//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomanage

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ServicePrincipalsClient contains the methods for the ServicePrincipals group.
// Don't use this type directly, use NewServicePrincipalsClient() instead.
type ServicePrincipalsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewServicePrincipalsClient creates a new instance of ServicePrincipalsClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewServicePrincipalsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ServicePrincipalsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ServicePrincipalsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Get - Get the Automanage AAD first party Application Service Principal details for the subscription id.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-05-04
// options - ServicePrincipalsClientGetOptions contains the optional parameters for the ServicePrincipalsClient.Get method.
func (client *ServicePrincipalsClient) Get(ctx context.Context, options *ServicePrincipalsClientGetOptions) (ServicePrincipalsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, options)
	if err != nil {
		return ServicePrincipalsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServicePrincipalsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServicePrincipalsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ServicePrincipalsClient) getCreateRequest(ctx context.Context, options *ServicePrincipalsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Automanage/servicePrincipals/default"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-05-04")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ServicePrincipalsClient) getHandleResponse(resp *http.Response) (ServicePrincipalsClientGetResponse, error) {
	result := ServicePrincipalsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServicePrincipal); err != nil {
		return ServicePrincipalsClientGetResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Get the Automanage AAD first party Application Service Principal details for the subscription
// id.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-05-04
// options - ServicePrincipalsClientListBySubscriptionOptions contains the optional parameters for the ServicePrincipalsClient.ListBySubscription
// method.
func (client *ServicePrincipalsClient) NewListBySubscriptionPager(options *ServicePrincipalsClientListBySubscriptionOptions) *runtime.Pager[ServicePrincipalsClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[ServicePrincipalsClientListBySubscriptionResponse]{
		More: func(page ServicePrincipalsClientListBySubscriptionResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ServicePrincipalsClientListBySubscriptionResponse) (ServicePrincipalsClientListBySubscriptionResponse, error) {
			req, err := client.listBySubscriptionCreateRequest(ctx, options)
			if err != nil {
				return ServicePrincipalsClientListBySubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ServicePrincipalsClientListBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ServicePrincipalsClientListBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *ServicePrincipalsClient) listBySubscriptionCreateRequest(ctx context.Context, options *ServicePrincipalsClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Automanage/servicePrincipals"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-05-04")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *ServicePrincipalsClient) listBySubscriptionHandleResponse(resp *http.Response) (ServicePrincipalsClientListBySubscriptionResponse, error) {
	result := ServicePrincipalsClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServicePrincipalListResult); err != nil {
		return ServicePrincipalsClientListBySubscriptionResponse{}, err
	}
	return result, nil
}
