//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armavs

import "encoding/json"

func unmarshalAddonPropertiesClassification(rawMsg json.RawMessage) (AddonPropertiesClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AddonPropertiesClassification
	switch m["addonType"] {
	case string(AddonTypeArc):
		b = &AddonArcProperties{}
	case string(AddonTypeHCX):
		b = &AddonHcxProperties{}
	case string(AddonTypeSRM):
		b = &AddonSrmProperties{}
	case string(AddonTypeVR):
		b = &AddonVrProperties{}
	default:
		b = &AddonProperties{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalPlacementPolicyPropertiesClassification(rawMsg json.RawMessage) (PlacementPolicyPropertiesClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b PlacementPolicyPropertiesClassification
	switch m["type"] {
	case string(PlacementPolicyTypeVMHost):
		b = &VMHostPlacementPolicyProperties{}
	case string(PlacementPolicyTypeVMVM):
		b = &VMPlacementPolicyProperties{}
	default:
		b = &PlacementPolicyProperties{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalScriptExecutionParameterClassification(rawMsg json.RawMessage) (ScriptExecutionParameterClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ScriptExecutionParameterClassification
	switch m["type"] {
	case string(ScriptExecutionParameterTypeCredential):
		b = &PSCredentialExecutionParameter{}
	case string(ScriptExecutionParameterTypeSecureValue):
		b = &ScriptSecureStringExecutionParameter{}
	case string(ScriptExecutionParameterTypeValue):
		b = &ScriptStringExecutionParameter{}
	default:
		b = &ScriptExecutionParameter{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalScriptExecutionParameterClassificationArray(rawMsg json.RawMessage) ([]ScriptExecutionParameterClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]ScriptExecutionParameterClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalScriptExecutionParameterClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalWorkloadNetworkDhcpEntityClassification(rawMsg json.RawMessage) (WorkloadNetworkDhcpEntityClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b WorkloadNetworkDhcpEntityClassification
	switch m["dhcpType"] {
	case string(DhcpTypeEnumRELAY):
		b = &WorkloadNetworkDhcpRelay{}
	case string(DhcpTypeEnumSERVER):
		b = &WorkloadNetworkDhcpServer{}
	default:
		b = &WorkloadNetworkDhcpEntity{}
	}
	return b, json.Unmarshal(rawMsg, b)
}
