//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcosmos

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// CassandraClustersClient contains the methods for the CassandraClusters group.
// Don't use this type directly, use NewCassandraClustersClient() instead.
type CassandraClustersClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewCassandraClustersClient creates a new instance of CassandraClustersClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewCassandraClustersClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*CassandraClustersClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &CassandraClustersClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateUpdate - Create or update a managed Cassandra cluster. When updating, you must specify all writable properties.
// To update only some properties, use PATCH.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// clusterName - Managed Cassandra cluster name.
// body - The properties specifying the desired state of the managed Cassandra cluster.
// options - CassandraClustersClientBeginCreateUpdateOptions contains the optional parameters for the CassandraClustersClient.BeginCreateUpdate
// method.
func (client *CassandraClustersClient) BeginCreateUpdate(ctx context.Context, resourceGroupName string, clusterName string, body ClusterResource, options *CassandraClustersClientBeginCreateUpdateOptions) (*runtime.Poller[CassandraClustersClientCreateUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createUpdate(ctx, resourceGroupName, clusterName, body, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[CassandraClustersClientCreateUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[CassandraClustersClientCreateUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateUpdate - Create or update a managed Cassandra cluster. When updating, you must specify all writable properties. To
// update only some properties, use PATCH.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
func (client *CassandraClustersClient) createUpdate(ctx context.Context, resourceGroupName string, clusterName string, body ClusterResource, options *CassandraClustersClientBeginCreateUpdateOptions) (*http.Response, error) {
	req, err := client.createUpdateCreateRequest(ctx, resourceGroupName, clusterName, body, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createUpdateCreateRequest creates the CreateUpdate request.
func (client *CassandraClustersClient) createUpdateCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, body ClusterResource, options *CassandraClustersClientBeginCreateUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, body)
}

// BeginDeallocate - Deallocate the Managed Cassandra Cluster and Associated Data Centers. Deallocation will deallocate the
// host virtual machine of this cluster, and reserved the data disk. This won't do anything on an
// already deallocated cluster. Use Start to restart the cluster.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// clusterName - Managed Cassandra cluster name.
// options - CassandraClustersClientBeginDeallocateOptions contains the optional parameters for the CassandraClustersClient.BeginDeallocate
// method.
func (client *CassandraClustersClient) BeginDeallocate(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientBeginDeallocateOptions) (*runtime.Poller[CassandraClustersClientDeallocateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deallocate(ctx, resourceGroupName, clusterName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[CassandraClustersClientDeallocateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[CassandraClustersClientDeallocateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Deallocate - Deallocate the Managed Cassandra Cluster and Associated Data Centers. Deallocation will deallocate the host
// virtual machine of this cluster, and reserved the data disk. This won't do anything on an
// already deallocated cluster. Use Start to restart the cluster.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
func (client *CassandraClustersClient) deallocate(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientBeginDeallocateOptions) (*http.Response, error) {
	req, err := client.deallocateCreateRequest(ctx, resourceGroupName, clusterName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deallocateCreateRequest creates the Deallocate request.
func (client *CassandraClustersClient) deallocateCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientBeginDeallocateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/deallocate"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDelete - Deletes a managed Cassandra cluster.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// clusterName - Managed Cassandra cluster name.
// options - CassandraClustersClientBeginDeleteOptions contains the optional parameters for the CassandraClustersClient.BeginDelete
// method.
func (client *CassandraClustersClient) BeginDelete(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientBeginDeleteOptions) (*runtime.Poller[CassandraClustersClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, clusterName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[CassandraClustersClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[CassandraClustersClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes a managed Cassandra cluster.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
func (client *CassandraClustersClient) deleteOperation(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, clusterName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *CassandraClustersClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get the properties of a managed Cassandra cluster.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// clusterName - Managed Cassandra cluster name.
// options - CassandraClustersClientGetOptions contains the optional parameters for the CassandraClustersClient.Get method.
func (client *CassandraClustersClient) Get(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientGetOptions) (CassandraClustersClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, clusterName, options)
	if err != nil {
		return CassandraClustersClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CassandraClustersClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CassandraClustersClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *CassandraClustersClient) getCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *CassandraClustersClient) getHandleResponse(resp *http.Response) (CassandraClustersClientGetResponse, error) {
	result := CassandraClustersClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ClusterResource); err != nil {
		return CassandraClustersClientGetResponse{}, err
	}
	return result, nil
}

// GetBackup - Get the properties of an individual backup of this cluster that is available to restore.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// clusterName - Managed Cassandra cluster name.
// backupID - Id of a restorable backup of a Cassandra cluster.
// options - CassandraClustersClientGetBackupOptions contains the optional parameters for the CassandraClustersClient.GetBackup
// method.
func (client *CassandraClustersClient) GetBackup(ctx context.Context, resourceGroupName string, clusterName string, backupID string, options *CassandraClustersClientGetBackupOptions) (CassandraClustersClientGetBackupResponse, error) {
	req, err := client.getBackupCreateRequest(ctx, resourceGroupName, clusterName, backupID, options)
	if err != nil {
		return CassandraClustersClientGetBackupResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CassandraClustersClientGetBackupResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CassandraClustersClientGetBackupResponse{}, runtime.NewResponseError(resp)
	}
	return client.getBackupHandleResponse(resp)
}

// getBackupCreateRequest creates the GetBackup request.
func (client *CassandraClustersClient) getBackupCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, backupID string, options *CassandraClustersClientGetBackupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/backups/{backupId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	if backupID == "" {
		return nil, errors.New("parameter backupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{backupId}", url.PathEscape(backupID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBackupHandleResponse handles the GetBackup response.
func (client *CassandraClustersClient) getBackupHandleResponse(resp *http.Response) (CassandraClustersClientGetBackupResponse, error) {
	result := CassandraClustersClientGetBackupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupResource); err != nil {
		return CassandraClustersClientGetBackupResponse{}, err
	}
	return result, nil
}

// BeginInvokeCommand - Invoke a command like nodetool for cassandra maintenance
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// clusterName - Managed Cassandra cluster name.
// body - Specification which command to run where
// options - CassandraClustersClientBeginInvokeCommandOptions contains the optional parameters for the CassandraClustersClient.BeginInvokeCommand
// method.
func (client *CassandraClustersClient) BeginInvokeCommand(ctx context.Context, resourceGroupName string, clusterName string, body CommandPostBody, options *CassandraClustersClientBeginInvokeCommandOptions) (*runtime.Poller[CassandraClustersClientInvokeCommandResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.invokeCommand(ctx, resourceGroupName, clusterName, body, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[CassandraClustersClientInvokeCommandResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[CassandraClustersClientInvokeCommandResponse](options.ResumeToken, client.pl, nil)
	}
}

// InvokeCommand - Invoke a command like nodetool for cassandra maintenance
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
func (client *CassandraClustersClient) invokeCommand(ctx context.Context, resourceGroupName string, clusterName string, body CommandPostBody, options *CassandraClustersClientBeginInvokeCommandOptions) (*http.Response, error) {
	req, err := client.invokeCommandCreateRequest(ctx, resourceGroupName, clusterName, body, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// invokeCommandCreateRequest creates the InvokeCommand request.
func (client *CassandraClustersClient) invokeCommandCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, body CommandPostBody, options *CassandraClustersClientBeginInvokeCommandOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/invokeCommand"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, body)
}

// NewListBackupsPager - List the backups of this cluster that are available to restore.
// Generated from API version 2022-08-15-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// clusterName - Managed Cassandra cluster name.
// options - CassandraClustersClientListBackupsOptions contains the optional parameters for the CassandraClustersClient.ListBackups
// method.
func (client *CassandraClustersClient) NewListBackupsPager(resourceGroupName string, clusterName string, options *CassandraClustersClientListBackupsOptions) *runtime.Pager[CassandraClustersClientListBackupsResponse] {
	return runtime.NewPager(runtime.PagingHandler[CassandraClustersClientListBackupsResponse]{
		More: func(page CassandraClustersClientListBackupsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *CassandraClustersClientListBackupsResponse) (CassandraClustersClientListBackupsResponse, error) {
			req, err := client.listBackupsCreateRequest(ctx, resourceGroupName, clusterName, options)
			if err != nil {
				return CassandraClustersClientListBackupsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return CassandraClustersClientListBackupsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return CassandraClustersClientListBackupsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBackupsHandleResponse(resp)
		},
	})
}

// listBackupsCreateRequest creates the ListBackups request.
func (client *CassandraClustersClient) listBackupsCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientListBackupsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/backups"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBackupsHandleResponse handles the ListBackups response.
func (client *CassandraClustersClient) listBackupsHandleResponse(resp *http.Response) (CassandraClustersClientListBackupsResponse, error) {
	result := CassandraClustersClientListBackupsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ListBackups); err != nil {
		return CassandraClustersClientListBackupsResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - List all managed Cassandra clusters in this resource group.
// Generated from API version 2022-08-15-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - CassandraClustersClientListByResourceGroupOptions contains the optional parameters for the CassandraClustersClient.ListByResourceGroup
// method.
func (client *CassandraClustersClient) NewListByResourceGroupPager(resourceGroupName string, options *CassandraClustersClientListByResourceGroupOptions) *runtime.Pager[CassandraClustersClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[CassandraClustersClientListByResourceGroupResponse]{
		More: func(page CassandraClustersClientListByResourceGroupResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *CassandraClustersClientListByResourceGroupResponse) (CassandraClustersClientListByResourceGroupResponse, error) {
			req, err := client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			if err != nil {
				return CassandraClustersClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return CassandraClustersClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return CassandraClustersClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *CassandraClustersClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *CassandraClustersClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *CassandraClustersClient) listByResourceGroupHandleResponse(resp *http.Response) (CassandraClustersClientListByResourceGroupResponse, error) {
	result := CassandraClustersClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ListClusters); err != nil {
		return CassandraClustersClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - List all managed Cassandra clusters in this subscription.
// Generated from API version 2022-08-15-preview
// options - CassandraClustersClientListBySubscriptionOptions contains the optional parameters for the CassandraClustersClient.ListBySubscription
// method.
func (client *CassandraClustersClient) NewListBySubscriptionPager(options *CassandraClustersClientListBySubscriptionOptions) *runtime.Pager[CassandraClustersClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[CassandraClustersClientListBySubscriptionResponse]{
		More: func(page CassandraClustersClientListBySubscriptionResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *CassandraClustersClientListBySubscriptionResponse) (CassandraClustersClientListBySubscriptionResponse, error) {
			req, err := client.listBySubscriptionCreateRequest(ctx, options)
			if err != nil {
				return CassandraClustersClientListBySubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return CassandraClustersClientListBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return CassandraClustersClientListBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *CassandraClustersClient) listBySubscriptionCreateRequest(ctx context.Context, options *CassandraClustersClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/cassandraClusters"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *CassandraClustersClient) listBySubscriptionHandleResponse(resp *http.Response) (CassandraClustersClientListBySubscriptionResponse, error) {
	result := CassandraClustersClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ListClusters); err != nil {
		return CassandraClustersClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// BeginStart - Start the Managed Cassandra Cluster and Associated Data Centers. Start will start the host virtual machine
// of this cluster with reserved data disk. This won't do anything on an already running
// cluster. Use Deallocate to deallocate the cluster.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// clusterName - Managed Cassandra cluster name.
// options - CassandraClustersClientBeginStartOptions contains the optional parameters for the CassandraClustersClient.BeginStart
// method.
func (client *CassandraClustersClient) BeginStart(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientBeginStartOptions) (*runtime.Poller[CassandraClustersClientStartResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.start(ctx, resourceGroupName, clusterName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[CassandraClustersClientStartResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[CassandraClustersClientStartResponse](options.ResumeToken, client.pl, nil)
	}
}

// Start - Start the Managed Cassandra Cluster and Associated Data Centers. Start will start the host virtual machine of this
// cluster with reserved data disk. This won't do anything on an already running
// cluster. Use Deallocate to deallocate the cluster.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
func (client *CassandraClustersClient) start(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientBeginStartOptions) (*http.Response, error) {
	req, err := client.startCreateRequest(ctx, resourceGroupName, clusterName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// startCreateRequest creates the Start request.
func (client *CassandraClustersClient) startCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientBeginStartOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/start"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Status - Gets the CPU, memory, and disk usage statistics for each Cassandra node in a cluster.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// clusterName - Managed Cassandra cluster name.
// options - CassandraClustersClientStatusOptions contains the optional parameters for the CassandraClustersClient.Status
// method.
func (client *CassandraClustersClient) Status(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientStatusOptions) (CassandraClustersClientStatusResponse, error) {
	req, err := client.statusCreateRequest(ctx, resourceGroupName, clusterName, options)
	if err != nil {
		return CassandraClustersClientStatusResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CassandraClustersClientStatusResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CassandraClustersClientStatusResponse{}, runtime.NewResponseError(resp)
	}
	return client.statusHandleResponse(resp)
}

// statusCreateRequest creates the Status request.
func (client *CassandraClustersClient) statusCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, options *CassandraClustersClientStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/status"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// statusHandleResponse handles the Status response.
func (client *CassandraClustersClient) statusHandleResponse(resp *http.Response) (CassandraClustersClientStatusResponse, error) {
	result := CassandraClustersClientStatusResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CassandraClusterPublicStatus); err != nil {
		return CassandraClustersClientStatusResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Updates some of the properties of a managed Cassandra cluster.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// clusterName - Managed Cassandra cluster name.
// body - Parameters to provide for specifying the managed Cassandra cluster.
// options - CassandraClustersClientBeginUpdateOptions contains the optional parameters for the CassandraClustersClient.BeginUpdate
// method.
func (client *CassandraClustersClient) BeginUpdate(ctx context.Context, resourceGroupName string, clusterName string, body ClusterResource, options *CassandraClustersClientBeginUpdateOptions) (*runtime.Poller[CassandraClustersClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, clusterName, body, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[CassandraClustersClientUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[CassandraClustersClientUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Update - Updates some of the properties of a managed Cassandra cluster.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-08-15-preview
func (client *CassandraClustersClient) update(ctx context.Context, resourceGroupName string, clusterName string, body ClusterResource, options *CassandraClustersClientBeginUpdateOptions) (*http.Response, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, clusterName, body, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateCreateRequest creates the Update request.
func (client *CassandraClustersClient) updateCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, body ClusterResource, options *CassandraClustersClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, body)
}
