//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeploymentmanager

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ServiceUnitsClient contains the methods for the ServiceUnits group.
// Don't use this type directly, use NewServiceUnitsClient() instead.
type ServiceUnitsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewServiceUnitsClient creates a new instance of ServiceUnitsClient with the specified values.
// subscriptionID - Subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID forms
// part of the URI for every service call.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewServiceUnitsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ServiceUnitsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ServiceUnitsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdate - This is an asynchronous operation and can be polled to completion using the operation resource returned
// by this operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// serviceTopologyName - The name of the service topology .
// serviceName - The name of the service resource.
// serviceUnitName - The name of the service unit resource.
// serviceUnitInfo - The service unit resource object.
// options - ServiceUnitsClientBeginCreateOrUpdateOptions contains the optional parameters for the ServiceUnitsClient.BeginCreateOrUpdate
// method.
func (client *ServiceUnitsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, serviceTopologyName string, serviceName string, serviceUnitName string, serviceUnitInfo ServiceUnitResource, options *ServiceUnitsClientBeginCreateOrUpdateOptions) (*runtime.Poller[ServiceUnitsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, serviceTopologyName, serviceName, serviceUnitName, serviceUnitInfo, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ServiceUnitsClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ServiceUnitsClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - This is an asynchronous operation and can be polled to completion using the operation resource returned
// by this operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-11-01-preview
func (client *ServiceUnitsClient) createOrUpdate(ctx context.Context, resourceGroupName string, serviceTopologyName string, serviceName string, serviceUnitName string, serviceUnitInfo ServiceUnitResource, options *ServiceUnitsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, serviceTopologyName, serviceName, serviceUnitName, serviceUnitInfo, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ServiceUnitsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, serviceTopologyName string, serviceName string, serviceUnitName string, serviceUnitInfo ServiceUnitResource, options *ServiceUnitsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/serviceTopologies/{serviceTopologyName}/services/{serviceName}/serviceUnits/{serviceUnitName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceTopologyName == "" {
		return nil, errors.New("parameter serviceTopologyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceTopologyName}", url.PathEscape(serviceTopologyName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if serviceUnitName == "" {
		return nil, errors.New("parameter serviceUnitName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceUnitName}", url.PathEscape(serviceUnitName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, serviceUnitInfo)
}

// Delete - Deletes the service unit.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// serviceTopologyName - The name of the service topology .
// serviceName - The name of the service resource.
// serviceUnitName - The name of the service unit resource.
// options - ServiceUnitsClientDeleteOptions contains the optional parameters for the ServiceUnitsClient.Delete method.
func (client *ServiceUnitsClient) Delete(ctx context.Context, resourceGroupName string, serviceTopologyName string, serviceName string, serviceUnitName string, options *ServiceUnitsClientDeleteOptions) (ServiceUnitsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, serviceTopologyName, serviceName, serviceUnitName, options)
	if err != nil {
		return ServiceUnitsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServiceUnitsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return ServiceUnitsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return ServiceUnitsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ServiceUnitsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, serviceTopologyName string, serviceName string, serviceUnitName string, options *ServiceUnitsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/serviceTopologies/{serviceTopologyName}/services/{serviceName}/serviceUnits/{serviceUnitName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceTopologyName == "" {
		return nil, errors.New("parameter serviceTopologyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceTopologyName}", url.PathEscape(serviceTopologyName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if serviceUnitName == "" {
		return nil, errors.New("parameter serviceUnitName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceUnitName}", url.PathEscape(serviceUnitName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets the service unit.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// serviceTopologyName - The name of the service topology .
// serviceName - The name of the service resource.
// serviceUnitName - The name of the service unit resource.
// options - ServiceUnitsClientGetOptions contains the optional parameters for the ServiceUnitsClient.Get method.
func (client *ServiceUnitsClient) Get(ctx context.Context, resourceGroupName string, serviceTopologyName string, serviceName string, serviceUnitName string, options *ServiceUnitsClientGetOptions) (ServiceUnitsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, serviceTopologyName, serviceName, serviceUnitName, options)
	if err != nil {
		return ServiceUnitsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServiceUnitsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServiceUnitsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ServiceUnitsClient) getCreateRequest(ctx context.Context, resourceGroupName string, serviceTopologyName string, serviceName string, serviceUnitName string, options *ServiceUnitsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/serviceTopologies/{serviceTopologyName}/services/{serviceName}/serviceUnits/{serviceUnitName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceTopologyName == "" {
		return nil, errors.New("parameter serviceTopologyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceTopologyName}", url.PathEscape(serviceTopologyName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if serviceUnitName == "" {
		return nil, errors.New("parameter serviceUnitName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceUnitName}", url.PathEscape(serviceUnitName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ServiceUnitsClient) getHandleResponse(resp *http.Response) (ServiceUnitsClientGetResponse, error) {
	result := ServiceUnitsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServiceUnitResource); err != nil {
		return ServiceUnitsClientGetResponse{}, err
	}
	return result, nil
}

// List - Lists the service units under a service in the service topology.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// serviceTopologyName - The name of the service topology .
// serviceName - The name of the service resource.
// options - ServiceUnitsClientListOptions contains the optional parameters for the ServiceUnitsClient.List method.
func (client *ServiceUnitsClient) List(ctx context.Context, resourceGroupName string, serviceTopologyName string, serviceName string, options *ServiceUnitsClientListOptions) (ServiceUnitsClientListResponse, error) {
	req, err := client.listCreateRequest(ctx, resourceGroupName, serviceTopologyName, serviceName, options)
	if err != nil {
		return ServiceUnitsClientListResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServiceUnitsClientListResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServiceUnitsClientListResponse{}, runtime.NewResponseError(resp)
	}
	return client.listHandleResponse(resp)
}

// listCreateRequest creates the List request.
func (client *ServiceUnitsClient) listCreateRequest(ctx context.Context, resourceGroupName string, serviceTopologyName string, serviceName string, options *ServiceUnitsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/serviceTopologies/{serviceTopologyName}/services/{serviceName}/serviceUnits"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceTopologyName == "" {
		return nil, errors.New("parameter serviceTopologyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceTopologyName}", url.PathEscape(serviceTopologyName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ServiceUnitsClient) listHandleResponse(resp *http.Response) (ServiceUnitsClientListResponse, error) {
	result := ServiceUnitsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServiceUnitResourceArray); err != nil {
		return ServiceUnitsClientListResponse{}, err
	}
	return result, nil
}
