//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdevcenter

import "time"

// AllowedEnvironmentType - Represents an allowed environment type.
type AllowedEnvironmentType struct {
	// Properties of an allowed environment type.
	Properties *AllowedEnvironmentTypeProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AllowedEnvironmentTypeListResult - Result of the allowed environment type list operation.
type AllowedEnvironmentTypeListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*AllowedEnvironmentType `json:"value,omitempty" azure:"ro"`
}

// AllowedEnvironmentTypeProperties - Properties of an allowed environment type.
type AllowedEnvironmentTypeProperties struct {
	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// AttachedNetworkConnection - Represents an attached NetworkConnection.
type AttachedNetworkConnection struct {
	// Attached NetworkConnection properties.
	Properties *AttachedNetworkConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AttachedNetworkConnectionProperties - Properties of an attached NetworkConnection.
type AttachedNetworkConnectionProperties struct {
	// REQUIRED; The resource ID of the NetworkConnection you want to attach.
	NetworkConnectionID *string `json:"networkConnectionId,omitempty"`

	// READ-ONLY; AAD Join type of the network. This is populated based on the referenced Network Connection.
	DomainJoinType *DomainJoinType `json:"domainJoinType,omitempty" azure:"ro"`

	// READ-ONLY; Health check status values
	HealthCheckStatus *HealthCheckStatus `json:"healthCheckStatus,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the NetworkConnection resource specified in 'networkConnectionResourceId' property lives.
	NetworkConnectionLocation *string `json:"networkConnectionLocation,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// AttachedNetworkListResult - Results of the Attached Networks list operation.
type AttachedNetworkListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*AttachedNetworkConnection `json:"value,omitempty" azure:"ro"`
}

// AttachedNetworksClientBeginCreateOrUpdateOptions contains the optional parameters for the AttachedNetworksClient.BeginCreateOrUpdate
// method.
type AttachedNetworksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AttachedNetworksClientBeginDeleteOptions contains the optional parameters for the AttachedNetworksClient.BeginDelete method.
type AttachedNetworksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AttachedNetworksClientGetByDevCenterOptions contains the optional parameters for the AttachedNetworksClient.GetByDevCenter
// method.
type AttachedNetworksClientGetByDevCenterOptions struct {
	// placeholder for future optional parameters
}

// AttachedNetworksClientGetByProjectOptions contains the optional parameters for the AttachedNetworksClient.GetByProject
// method.
type AttachedNetworksClientGetByProjectOptions struct {
	// placeholder for future optional parameters
}

// AttachedNetworksClientListByDevCenterOptions contains the optional parameters for the AttachedNetworksClient.ListByDevCenter
// method.
type AttachedNetworksClientListByDevCenterOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// AttachedNetworksClientListByProjectOptions contains the optional parameters for the AttachedNetworksClient.ListByProject
// method.
type AttachedNetworksClientListByProjectOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// Capability - A name/value pair to describe a capability.
type Capability struct {
	// READ-ONLY; Name of the capability.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Value of the capability.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// Catalog - Represents a catalog.
type Catalog struct {
	// Catalog properties.
	Properties *CatalogProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CatalogListResult - Results of the catalog list operation.
type CatalogListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*Catalog `json:"value,omitempty" azure:"ro"`
}

// CatalogProperties - Properties of a catalog.
type CatalogProperties struct {
	// Properties for an Azure DevOps catalog type.
	AdoGit *GitCatalog `json:"adoGit,omitempty"`

	// Properties for a GitHub catalog type.
	GitHub *GitCatalog `json:"gitHub,omitempty"`

	// READ-ONLY; When the catalog was last synced.
	LastSyncTime *time.Time `json:"lastSyncTime,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The synchronization state of the catalog.
	SyncState *CatalogSyncState `json:"syncState,omitempty" azure:"ro"`
}

// CatalogUpdate - The catalog's properties for partial update. Properties not provided in the update request will not be
// changed.
type CatalogUpdate struct {
	// Catalog properties for update.
	Properties *CatalogUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// CatalogUpdateProperties - Properties of a catalog. These properties can be updated after the resource has been created.
type CatalogUpdateProperties struct {
	// Properties for an Azure DevOps catalog type.
	AdoGit *GitCatalog `json:"adoGit,omitempty"`

	// Properties for a GitHub catalog type.
	GitHub *GitCatalog `json:"gitHub,omitempty"`
}

// CatalogsClientBeginCreateOrUpdateOptions contains the optional parameters for the CatalogsClient.BeginCreateOrUpdate method.
type CatalogsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CatalogsClientBeginDeleteOptions contains the optional parameters for the CatalogsClient.BeginDelete method.
type CatalogsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CatalogsClientBeginSyncOptions contains the optional parameters for the CatalogsClient.BeginSync method.
type CatalogsClientBeginSyncOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CatalogsClientBeginUpdateOptions contains the optional parameters for the CatalogsClient.BeginUpdate method.
type CatalogsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CatalogsClientGetOptions contains the optional parameters for the CatalogsClient.Get method.
type CatalogsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CatalogsClientListByDevCenterOptions contains the optional parameters for the CatalogsClient.ListByDevCenter method.
type CatalogsClientListByDevCenterOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// DevBoxDefinition - Represents a definition for a Developer Machine.
type DevBoxDefinition struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Dev Box definition properties
	Properties *DevBoxDefinitionProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DevBoxDefinitionListResult - Results of the Dev Box definition list operation.
type DevBoxDefinitionListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*DevBoxDefinition `json:"value,omitempty" azure:"ro"`
}

// DevBoxDefinitionProperties - Properties of a Dev Box definition.
type DevBoxDefinitionProperties struct {
	// Image reference information.
	ImageReference *ImageReference `json:"imageReference,omitempty"`

	// The storage type used for the Operating System disk of Dev Boxes created using this definition.
	OSStorageType *string `json:"osStorageType,omitempty"`

	// The SKU for Dev Boxes created using this definition.
	SKU *SKU `json:"sku,omitempty"`

	// READ-ONLY; Image reference information for the currently active image (only populated during updates).
	ActiveImageReference *ImageReference `json:"activeImageReference,omitempty" azure:"ro"`

	// READ-ONLY; Details for image validator error. Populated when the image validation is not successful.
	ImageValidationErrorDetails *ImageValidationErrorDetails `json:"imageValidationErrorDetails,omitempty" azure:"ro"`

	// READ-ONLY; Validation status of the configured image.
	ImageValidationStatus *ImageValidationStatus `json:"imageValidationStatus,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// DevBoxDefinitionUpdate - Partial update of a Dev Box definition resource.
type DevBoxDefinitionUpdate struct {
	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of a Dev Box definition to be updated.
	Properties *DevBoxDefinitionUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DevBoxDefinitionUpdateProperties - Properties of a Dev Box definition. These properties can be updated after the resource
// has been created.
type DevBoxDefinitionUpdateProperties struct {
	// Image reference information.
	ImageReference *ImageReference `json:"imageReference,omitempty"`

	// The storage type used for the Operating System disk of Dev Boxes created using this definition.
	OSStorageType *string `json:"osStorageType,omitempty"`

	// The SKU for Dev Boxes created using this definition.
	SKU *SKU `json:"sku,omitempty"`
}

// DevBoxDefinitionsClientBeginCreateOrUpdateOptions contains the optional parameters for the DevBoxDefinitionsClient.BeginCreateOrUpdate
// method.
type DevBoxDefinitionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevBoxDefinitionsClientBeginDeleteOptions contains the optional parameters for the DevBoxDefinitionsClient.BeginDelete
// method.
type DevBoxDefinitionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevBoxDefinitionsClientBeginUpdateOptions contains the optional parameters for the DevBoxDefinitionsClient.BeginUpdate
// method.
type DevBoxDefinitionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevBoxDefinitionsClientGetByProjectOptions contains the optional parameters for the DevBoxDefinitionsClient.GetByProject
// method.
type DevBoxDefinitionsClientGetByProjectOptions struct {
	// placeholder for future optional parameters
}

// DevBoxDefinitionsClientGetOptions contains the optional parameters for the DevBoxDefinitionsClient.Get method.
type DevBoxDefinitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DevBoxDefinitionsClientListByDevCenterOptions contains the optional parameters for the DevBoxDefinitionsClient.ListByDevCenter
// method.
type DevBoxDefinitionsClientListByDevCenterOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// DevBoxDefinitionsClientListByProjectOptions contains the optional parameters for the DevBoxDefinitionsClient.ListByProject
// method.
type DevBoxDefinitionsClientListByProjectOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// DevCenter - Represents a devcenter resource.
type DevCenter struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Managed identity properties
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// DevCenter properties
	Properties *Properties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DevCentersClientBeginCreateOrUpdateOptions contains the optional parameters for the DevCentersClient.BeginCreateOrUpdate
// method.
type DevCentersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevCentersClientBeginDeleteOptions contains the optional parameters for the DevCentersClient.BeginDelete method.
type DevCentersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevCentersClientBeginUpdateOptions contains the optional parameters for the DevCentersClient.BeginUpdate method.
type DevCentersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevCentersClientGetOptions contains the optional parameters for the DevCentersClient.Get method.
type DevCentersClientGetOptions struct {
	// placeholder for future optional parameters
}

// DevCentersClientListByResourceGroupOptions contains the optional parameters for the DevCentersClient.ListByResourceGroup
// method.
type DevCentersClientListByResourceGroupOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// DevCentersClientListBySubscriptionOptions contains the optional parameters for the DevCentersClient.ListBySubscription
// method.
type DevCentersClientListBySubscriptionOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// EnvironmentRole - A role that can be assigned to a user.
type EnvironmentRole struct {
	// READ-ONLY; This is a description of the Role Assignment.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The common name of the Role Assignment. This is a descriptive name such as 'AcrPush'.
	RoleName *string `json:"roleName,omitempty" azure:"ro"`
}

// EnvironmentType - Represents an environment type.
type EnvironmentType struct {
	// Properties of an environment type.
	Properties *EnvironmentTypeProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EnvironmentTypeListResult - Result of the environment type list operation.
type EnvironmentTypeListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*EnvironmentType `json:"value,omitempty" azure:"ro"`
}

// EnvironmentTypeProperties - Properties of an environment type.
type EnvironmentTypeProperties struct {
	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// EnvironmentTypeUpdate - The environment type for partial update. Properties not provided in the update request will not
// be changed.
type EnvironmentTypeUpdate struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// EnvironmentTypesClientCreateOrUpdateOptions contains the optional parameters for the EnvironmentTypesClient.CreateOrUpdate
// method.
type EnvironmentTypesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentTypesClientDeleteOptions contains the optional parameters for the EnvironmentTypesClient.Delete method.
type EnvironmentTypesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentTypesClientGetOptions contains the optional parameters for the EnvironmentTypesClient.Get method.
type EnvironmentTypesClientGetOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentTypesClientListByDevCenterOptions contains the optional parameters for the EnvironmentTypesClient.ListByDevCenter
// method.
type EnvironmentTypesClientListByDevCenterOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// EnvironmentTypesClientUpdateOptions contains the optional parameters for the EnvironmentTypesClient.Update method.
type EnvironmentTypesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// GalleriesClientBeginCreateOrUpdateOptions contains the optional parameters for the GalleriesClient.BeginCreateOrUpdate
// method.
type GalleriesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleriesClientBeginDeleteOptions contains the optional parameters for the GalleriesClient.BeginDelete method.
type GalleriesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleriesClientGetOptions contains the optional parameters for the GalleriesClient.Get method.
type GalleriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// GalleriesClientListByDevCenterOptions contains the optional parameters for the GalleriesClient.ListByDevCenter method.
type GalleriesClientListByDevCenterOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// Gallery - Represents a gallery.
type Gallery struct {
	// Gallery properties.
	Properties *GalleryProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GalleryListResult - Results of the gallery list operation.
type GalleryListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*Gallery `json:"value,omitempty" azure:"ro"`
}

// GalleryProperties - Properties of a gallery.
type GalleryProperties struct {
	// REQUIRED; The resource ID of the backing Azure Compute Gallery.
	GalleryResourceID *string `json:"galleryResourceId,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GitCatalog - Properties for a Git repository catalog.
type GitCatalog struct {
	// Git branch.
	Branch *string `json:"branch,omitempty"`

	// The folder where the catalog items can be found inside the repository.
	Path *string `json:"path,omitempty"`

	// A reference to the Key Vault secret containing a security token to authenticate to a Git repository.
	SecretIdentifier *string `json:"secretIdentifier,omitempty"`

	// Git URI.
	URI *string `json:"uri,omitempty"`
}

// HealthCheck - An individual health check item
type HealthCheck struct {
	// READ-ONLY; Additional details about the health check or the recommended action.
	AdditionalDetails *string `json:"additionalDetails,omitempty" azure:"ro"`

	// READ-ONLY; The display name of this health check item.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; End time of the health check item.
	EndDateTime *time.Time `json:"endDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The type of error that occurred during this health check.
	ErrorType *string `json:"errorType,omitempty" azure:"ro"`

	// READ-ONLY; The recommended action to fix the corresponding error.
	RecommendedAction *string `json:"recommendedAction,omitempty" azure:"ro"`

	// READ-ONLY; Start time of health check item.
	StartDateTime *time.Time `json:"startDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The status of the health check item.
	Status *HealthCheckStatus `json:"status,omitempty" azure:"ro"`
}

// HealthCheckStatusDetails - Health Check details.
type HealthCheckStatusDetails struct {
	// Health check status details properties.
	Properties *HealthCheckStatusDetailsProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HealthCheckStatusDetailsListResult - Result of the network health check list operation.
type HealthCheckStatusDetailsListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*HealthCheckStatusDetails `json:"value,omitempty" azure:"ro"`
}

// HealthCheckStatusDetailsProperties - Health Check properties.
type HealthCheckStatusDetailsProperties struct {
	// READ-ONLY; End time of last execution of the health checks.
	EndDateTime *time.Time `json:"endDateTime,omitempty" azure:"ro"`

	// READ-ONLY; Details for each health check item.
	HealthChecks []*HealthCheck `json:"healthChecks,omitempty" azure:"ro"`

	// READ-ONLY; Start time of last execution of the health checks.
	StartDateTime *time.Time `json:"startDateTime,omitempty" azure:"ro"`
}

// Image - Represents an image.
type Image struct {
	// Image properties.
	Properties *ImageProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ImageListResult - Results of the image list operation.
type ImageListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*Image `json:"value,omitempty" azure:"ro"`
}

// ImageProperties - Properties of an image.
type ImageProperties struct {
	// READ-ONLY; The description of the image.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The name of the image offer.
	Offer *string `json:"offer,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The publisher of the image.
	Publisher *string `json:"publisher,omitempty" azure:"ro"`

	// READ-ONLY; The recommended machine configuration to use with the image.
	RecommendedMachineConfiguration *RecommendedMachineConfiguration `json:"recommendedMachineConfiguration,omitempty" azure:"ro"`

	// READ-ONLY; The SKU name for the image.
	SKU *string `json:"sku,omitempty" azure:"ro"`
}

// ImageReference - Image reference information
type ImageReference struct {
	// Image ID, or Image version ID. When Image ID is provided, its latest version will be used.
	ID *string `json:"id,omitempty"`

	// The image offer.
	Offer *string `json:"offer,omitempty"`

	// The image publisher.
	Publisher *string `json:"publisher,omitempty"`

	// The image sku.
	SKU *string `json:"sku,omitempty"`

	// READ-ONLY; The actual version of the image after use. When id references a gallery image latest version, this will indicate
	// the actual version in use.
	ExactVersion *string `json:"exactVersion,omitempty" azure:"ro"`
}

// ImageValidationErrorDetails - Image validation error details
type ImageValidationErrorDetails struct {
	// An identifier for the error.
	Code *string `json:"code,omitempty"`

	// A message describing the error.
	Message *string `json:"message,omitempty"`
}

// ImageVersion - Represents an image version.
type ImageVersion struct {
	// Image version properties.
	Properties *ImageVersionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ImageVersionListResult - Results of the image version list operation.
type ImageVersionListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*ImageVersion `json:"value,omitempty" azure:"ro"`
}

// ImageVersionProperties - Properties of an image version.
type ImageVersionProperties struct {
	// READ-ONLY; If the version should be excluded from being treated as the latest version.
	ExcludeFromLatest *bool `json:"excludeFromLatest,omitempty" azure:"ro"`

	// READ-ONLY; The semantic version string.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The size of the OS disk image, in GB.
	OSDiskImageSizeInGb *int32 `json:"osDiskImageSizeInGb,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The datetime that the backing image version was published.
	PublishedDate *time.Time `json:"publishedDate,omitempty" azure:"ro"`
}

// ImageVersionsClientGetOptions contains the optional parameters for the ImageVersionsClient.Get method.
type ImageVersionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ImageVersionsClientListByImageOptions contains the optional parameters for the ImageVersionsClient.ListByImage method.
type ImageVersionsClientListByImageOptions struct {
	// placeholder for future optional parameters
}

// ImagesClientGetOptions contains the optional parameters for the ImagesClient.Get method.
type ImagesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ImagesClientListByDevCenterOptions contains the optional parameters for the ImagesClient.ListByDevCenter method.
type ImagesClientListByDevCenterOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// ImagesClientListByGalleryOptions contains the optional parameters for the ImagesClient.ListByGallery method.
type ImagesClientListByGalleryOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// ListResult - Result of the list devcenters operation
type ListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*DevCenter `json:"value,omitempty" azure:"ro"`
}

// ListUsagesResult - List of Core Usages.
type ListUsagesResult struct {
	// READ-ONLY; The link to get the next page of Usage result.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The array page of Usages.
	Value []*Usage `json:"value,omitempty" azure:"ro"`
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// NetworkConnection - Network related settings
type NetworkConnection struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of a Network Connection
	Properties *NetworkProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkConnectionListResult - Result of the network connection list operation.
type NetworkConnectionListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*NetworkConnection `json:"value,omitempty" azure:"ro"`
}

// NetworkConnectionUpdate - The network connection properties for partial update. Properties not provided in the update request
// will not be changed.
type NetworkConnectionUpdate struct {
	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of a network connection resource to be updated.
	Properties *NetworkConnectionUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// NetworkConnectionUpdateProperties - Properties of network connection. These properties can be updated after the resource
// has been created.
type NetworkConnectionUpdateProperties struct {
	// Active Directory domain name
	DomainName *string `json:"domainName,omitempty"`

	// The password for the account used to join domain
	DomainPassword *string `json:"domainPassword,omitempty"`

	// The username of an Active Directory account (user or service account) that has permissions to create computer objects in
	// Active Directory. Required format: admin@contoso.com.
	DomainUsername *string `json:"domainUsername,omitempty"`

	// Active Directory domain Organization Unit (OU)
	OrganizationUnit *string `json:"organizationUnit,omitempty"`

	// The subnet to attach Virtual Machines to
	SubnetID *string `json:"subnetId,omitempty"`
}

// NetworkConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the NetworkConnectionsClient.BeginCreateOrUpdate
// method.
type NetworkConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NetworkConnectionsClientBeginDeleteOptions contains the optional parameters for the NetworkConnectionsClient.BeginDelete
// method.
type NetworkConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NetworkConnectionsClientBeginUpdateOptions contains the optional parameters for the NetworkConnectionsClient.BeginUpdate
// method.
type NetworkConnectionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NetworkConnectionsClientGetHealthDetailsOptions contains the optional parameters for the NetworkConnectionsClient.GetHealthDetails
// method.
type NetworkConnectionsClientGetHealthDetailsOptions struct {
	// placeholder for future optional parameters
}

// NetworkConnectionsClientGetOptions contains the optional parameters for the NetworkConnectionsClient.Get method.
type NetworkConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// NetworkConnectionsClientListByResourceGroupOptions contains the optional parameters for the NetworkConnectionsClient.ListByResourceGroup
// method.
type NetworkConnectionsClientListByResourceGroupOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// NetworkConnectionsClientListBySubscriptionOptions contains the optional parameters for the NetworkConnectionsClient.ListBySubscription
// method.
type NetworkConnectionsClientListBySubscriptionOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// NetworkConnectionsClientListHealthDetailsOptions contains the optional parameters for the NetworkConnectionsClient.ListHealthDetails
// method.
type NetworkConnectionsClientListHealthDetailsOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// NetworkConnectionsClientRunHealthChecksOptions contains the optional parameters for the NetworkConnectionsClient.RunHealthChecks
// method.
type NetworkConnectionsClientRunHealthChecksOptions struct {
	// placeholder for future optional parameters
}

// NetworkProperties - Network properties
type NetworkProperties struct {
	// REQUIRED; AAD Join type.
	DomainJoinType *DomainJoinType `json:"domainJoinType,omitempty"`

	// Active Directory domain name
	DomainName *string `json:"domainName,omitempty"`

	// The password for the account used to join domain
	DomainPassword *string `json:"domainPassword,omitempty"`

	// The username of an Active Directory account (user or service account) that has permissions to create computer objects in
	// Active Directory. Required format: admin@contoso.com.
	DomainUsername *string `json:"domainUsername,omitempty"`

	// The name for resource group where NICs will be placed.
	NetworkingResourceGroupName *string `json:"networkingResourceGroupName,omitempty"`

	// Active Directory domain Organization Unit (OU)
	OrganizationUnit *string `json:"organizationUnit,omitempty"`

	// The subnet to attach Virtual Machines to
	SubnetID *string `json:"subnetId,omitempty"`

	// READ-ONLY; Overall health status of the network connection. Health checks are run on creation, update, and periodically
	// to validate the network connection.
	HealthCheckStatus *HealthCheckStatus `json:"healthCheckStatus,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationStatus - The current status of an async operation
type OperationStatus struct {
	// REQUIRED; Operation status.
	Status *string `json:"status,omitempty"`

	// The end time of the operation.
	EndTime *time.Time `json:"endTime,omitempty"`

	// If present, details of the operation error.
	Error *ErrorDetail `json:"error,omitempty"`

	// Fully qualified ID for the async operation.
	ID *string `json:"id,omitempty"`

	// Name of the async operation.
	Name *string `json:"name,omitempty"`

	// The operations list.
	Operations []*OperationStatusResult `json:"operations,omitempty"`

	// Percent of the operation that is complete.
	PercentComplete *float32 `json:"percentComplete,omitempty"`

	// The start time of the operation.
	StartTime *time.Time `json:"startTime,omitempty"`

	// READ-ONLY; Custom operation properties, populated only for a successful operation.
	Properties interface{} `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The id of the resource.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`
}

// OperationStatusResult - The current status of an async operation.
type OperationStatusResult struct {
	// REQUIRED; Operation status.
	Status *string `json:"status,omitempty"`

	// The end time of the operation.
	EndTime *time.Time `json:"endTime,omitempty"`

	// If present, details of the operation error.
	Error *ErrorDetail `json:"error,omitempty"`

	// Fully qualified ID for the async operation.
	ID *string `json:"id,omitempty"`

	// Name of the async operation.
	Name *string `json:"name,omitempty"`

	// The operations list.
	Operations []*OperationStatusResult `json:"operations,omitempty"`

	// Percent of the operation that is complete.
	PercentComplete *float32 `json:"percentComplete,omitempty"`

	// The start time of the operation.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// OperationStatusesClientGetOptions contains the optional parameters for the OperationStatusesClient.Get method.
type OperationStatusesClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Pool - A pool of Virtual Machines.
type Pool struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Pool properties
	Properties *PoolProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PoolListResult - Results of the machine pool list operation.
type PoolListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*Pool `json:"value,omitempty" azure:"ro"`
}

// PoolProperties - Properties of a Pool
type PoolProperties struct {
	// Name of a Dev Box definition in parent Project of this Pool
	DevBoxDefinitionName *string `json:"devBoxDefinitionName,omitempty"`

	// Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created.
	LicenseType *LicenseType `json:"licenseType,omitempty"`

	// Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box.
	LocalAdministrator *LocalAdminStatus `json:"localAdministrator,omitempty"`

	// Name of a Network Connection in parent Project of this Pool
	NetworkConnectionName *string `json:"networkConnectionName,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// PoolUpdate - The pool properties for partial update. Properties not provided in the update request will not be changed.
type PoolUpdate struct {
	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of a pool to be updated.
	Properties *PoolUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// PoolUpdateProperties - Properties of a Pool. These properties can be updated after the resource has been created.
type PoolUpdateProperties struct {
	// Name of a Dev Box definition in parent Project of this Pool
	DevBoxDefinitionName *string `json:"devBoxDefinitionName,omitempty"`

	// Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created.
	LicenseType *LicenseType `json:"licenseType,omitempty"`

	// Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box.
	LocalAdministrator *LocalAdminStatus `json:"localAdministrator,omitempty"`

	// Name of a Network Connection in parent Project of this Pool
	NetworkConnectionName *string `json:"networkConnectionName,omitempty"`
}

// PoolsClientBeginCreateOrUpdateOptions contains the optional parameters for the PoolsClient.BeginCreateOrUpdate method.
type PoolsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PoolsClientBeginDeleteOptions contains the optional parameters for the PoolsClient.BeginDelete method.
type PoolsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PoolsClientBeginUpdateOptions contains the optional parameters for the PoolsClient.BeginUpdate method.
type PoolsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PoolsClientGetOptions contains the optional parameters for the PoolsClient.Get method.
type PoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PoolsClientListByProjectOptions contains the optional parameters for the PoolsClient.ListByProject method.
type PoolsClientListByProjectOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// Project - Represents a project resource.
type Project struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of a project.
	Properties *ProjectProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProjectAllowedEnvironmentTypesClientGetOptions contains the optional parameters for the ProjectAllowedEnvironmentTypesClient.Get
// method.
type ProjectAllowedEnvironmentTypesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProjectAllowedEnvironmentTypesClientListOptions contains the optional parameters for the ProjectAllowedEnvironmentTypesClient.List
// method.
type ProjectAllowedEnvironmentTypesClientListOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// ProjectEnvironmentType - Represents an environment type.
type ProjectEnvironmentType struct {
	// Managed identity properties
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The geo-location for the environment type
	Location *string `json:"location,omitempty"`

	// Properties of an environment type.
	Properties *ProjectEnvironmentTypeProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProjectEnvironmentTypeListResult - Result of the project environment type list operation.
type ProjectEnvironmentTypeListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*ProjectEnvironmentType `json:"value,omitempty" azure:"ro"`
}

// ProjectEnvironmentTypeProperties - Properties of a project environment type.
type ProjectEnvironmentTypeProperties struct {
	// The role definition assigned to the environment creator on backing resources.
	CreatorRoleAssignment *ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment `json:"creatorRoleAssignment,omitempty"`

	// Id of a subscription that the environment type will be mapped to. The environment's resources will be deployed into this
	// subscription.
	DeploymentTargetID *string `json:"deploymentTargetId,omitempty"`

	// Defines whether this Environment Type can be used in this Project.
	Status *EnableStatus `json:"status,omitempty"`

	// Role Assignments created on environment backing resources. This is a mapping from a user object ID to an object of role
	// definition IDs.
	UserRoleAssignments map[string]*UserRoleAssignmentValue `json:"userRoleAssignments,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ProjectEnvironmentTypeUpdate - The project environment type for partial update. Properties not provided in the update request
// will not be changed.
type ProjectEnvironmentTypeUpdate struct {
	// Managed identity properties
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Properties to configure an environment type.
	Properties *ProjectEnvironmentTypeUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ProjectEnvironmentTypeUpdateProperties - Properties of a project environment type. These properties can be updated after
// the resource has been created.
type ProjectEnvironmentTypeUpdateProperties struct {
	// The role definition assigned to the environment creator on backing resources.
	CreatorRoleAssignment *ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment `json:"creatorRoleAssignment,omitempty"`

	// Id of a subscription that the environment type will be mapped to. The environment's resources will be deployed into this
	// subscription.
	DeploymentTargetID *string `json:"deploymentTargetId,omitempty"`

	// Defines whether this Environment Type can be used in this Project.
	Status *EnableStatus `json:"status,omitempty"`

	// Role Assignments created on environment backing resources. This is a mapping from a user object ID to an object of role
	// definition IDs.
	UserRoleAssignments map[string]*UserRoleAssignmentValue `json:"userRoleAssignments,omitempty"`
}

// ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment - The role definition assigned to the environment creator on
// backing resources.
type ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment struct {
	// A map of roles to assign to the environment creator.
	Roles map[string]*EnvironmentRole `json:"roles,omitempty"`
}

// ProjectEnvironmentTypesClientCreateOrUpdateOptions contains the optional parameters for the ProjectEnvironmentTypesClient.CreateOrUpdate
// method.
type ProjectEnvironmentTypesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProjectEnvironmentTypesClientDeleteOptions contains the optional parameters for the ProjectEnvironmentTypesClient.Delete
// method.
type ProjectEnvironmentTypesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProjectEnvironmentTypesClientGetOptions contains the optional parameters for the ProjectEnvironmentTypesClient.Get method.
type ProjectEnvironmentTypesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProjectEnvironmentTypesClientListOptions contains the optional parameters for the ProjectEnvironmentTypesClient.List method.
type ProjectEnvironmentTypesClientListOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// ProjectEnvironmentTypesClientUpdateOptions contains the optional parameters for the ProjectEnvironmentTypesClient.Update
// method.
type ProjectEnvironmentTypesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProjectListResult - Results of the project list operation.
type ProjectListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*Project `json:"value,omitempty" azure:"ro"`
}

// ProjectProperties - Properties of a project.
type ProjectProperties struct {
	// Description of the project.
	Description *string `json:"description,omitempty"`

	// Resource Id of an associated DevCenter
	DevCenterID *string `json:"devCenterId,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ProjectUpdate - The project properties for partial update. Properties not provided in the update request will not be changed.
type ProjectUpdate struct {
	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of a project to be updated.
	Properties *ProjectUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ProjectUpdateProperties - Properties of a project. These properties can be updated after the resource has been created.
type ProjectUpdateProperties struct {
	// Description of the project.
	Description *string `json:"description,omitempty"`

	// Resource Id of an associated DevCenter
	DevCenterID *string `json:"devCenterId,omitempty"`
}

// ProjectsClientBeginCreateOrUpdateOptions contains the optional parameters for the ProjectsClient.BeginCreateOrUpdate method.
type ProjectsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProjectsClientBeginDeleteOptions contains the optional parameters for the ProjectsClient.BeginDelete method.
type ProjectsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProjectsClientBeginUpdateOptions contains the optional parameters for the ProjectsClient.BeginUpdate method.
type ProjectsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProjectsClientGetOptions contains the optional parameters for the ProjectsClient.Get method.
type ProjectsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProjectsClientListByResourceGroupOptions contains the optional parameters for the ProjectsClient.ListByResourceGroup method.
type ProjectsClientListByResourceGroupOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// ProjectsClientListBySubscriptionOptions contains the optional parameters for the ProjectsClient.ListBySubscription method.
type ProjectsClientListBySubscriptionOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// Properties of the devcenter.
type Properties struct {
	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecommendedMachineConfiguration - Properties for a recommended machine configuration.
type RecommendedMachineConfiguration struct {
	// READ-ONLY; Recommended memory range.
	Memory *ResourceRange `json:"memory,omitempty" azure:"ro"`

	// READ-ONLY; Recommended vCPU range.
	VCPUs *ResourceRange `json:"vCPUs,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceRange - Properties for a range of values.
type ResourceRange struct {
	// READ-ONLY; Maximum value.
	Max *int32 `json:"max,omitempty" azure:"ro"`

	// READ-ONLY; Minimum value.
	Min *int32 `json:"min,omitempty" azure:"ro"`
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier `json:"tier,omitempty"`
}

// SKUInfo - The resource model definition representing SKU for DevCenter resources
type SKUInfo struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier `json:"tier,omitempty"`

	// READ-ONLY; Collection of name/value pairs to describe the SKU capabilities.
	Capabilities []*Capability `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; SKU supported locations.
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource type
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`
}

// SKUListResult - Results of the Microsoft.DevCenter SKU list operation.
type SKUListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*SKUInfo `json:"value,omitempty" azure:"ro"`
}

// SKUsClientListBySubscriptionOptions contains the optional parameters for the SKUsClient.ListBySubscription method.
type SKUsClientListBySubscriptionOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// Schedule - Represents a Schedule to execute a task.
type Schedule struct {
	// Properties of a Schedule resource
	Properties *ScheduleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScheduleListResult - Result of the schedule list operation.
type ScheduleListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Current page of results.
	Value []*Schedule `json:"value,omitempty" azure:"ro"`
}

// ScheduleProperties - The Schedule properties defining when and what to execute.
type ScheduleProperties struct {
	// The frequency of this scheduled task.
	Frequency *ScheduledFrequency `json:"frequency,omitempty"`

	// Indicates whether or not this scheduled task is enabled.
	State *EnableStatus `json:"state,omitempty"`

	// The target time to trigger the action. The format is HH:MM.
	Time *string `json:"time,omitempty"`

	// The IANA timezone id at which the schedule should execute.
	TimeZone *string `json:"timeZone,omitempty"`

	// Supported type this scheduled task represents.
	Type *ScheduledType `json:"type,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ScheduleUpdate - The schedule properties for partial update. Properties not provided in the update request will not be
// changed.
type ScheduleUpdate struct {
	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of a schedule resource to be updated.
	Properties *ScheduleUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ScheduleUpdateProperties - Updatable properties of a Schedule.
type ScheduleUpdateProperties struct {
	// The frequency of this scheduled task.
	Frequency *ScheduledFrequency `json:"frequency,omitempty"`

	// Indicates whether or not this scheduled task is enabled.
	State *EnableStatus `json:"state,omitempty"`

	// The target time to trigger the action. The format is HH:MM.
	Time *string `json:"time,omitempty"`

	// The IANA timezone id at which the schedule should execute.
	TimeZone *string `json:"timeZone,omitempty"`

	// Supported type this scheduled task represents.
	Type *ScheduledType `json:"type,omitempty"`
}

// SchedulesClientBeginCreateOrUpdateOptions contains the optional parameters for the SchedulesClient.BeginCreateOrUpdate
// method.
type SchedulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// SchedulesClientBeginDeleteOptions contains the optional parameters for the SchedulesClient.BeginDelete method.
type SchedulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// SchedulesClientBeginUpdateOptions contains the optional parameters for the SchedulesClient.BeginUpdate method.
type SchedulesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// SchedulesClientGetOptions contains the optional parameters for the SchedulesClient.Get method.
type SchedulesClientGetOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// SchedulesClientListByPoolOptions contains the optional parameters for the SchedulesClient.ListByPool method.
type SchedulesClientListByPoolOptions struct {
	// The maximum number of resources to return from the operation. Example: '$top=10'.
	Top *int32
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TrackedResourceUpdate - Base tracked resource type for PATCH updates
type TrackedResourceUpdate struct {
	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// Update - The devcenter resource for partial updates. Properties not provided in the update request will not be changed.
type Update struct {
	// Managed identity properties
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// Usage - The core usage details.
type Usage struct {
	// The current usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`

	// The limit integer.
	Limit *int64 `json:"limit,omitempty"`

	// The name.
	Name *UsageName `json:"name,omitempty"`

	// The unit details.
	Unit *UsageUnit `json:"unit,omitempty"`
}

// UsageName - The Usage Names.
type UsageName struct {
	// The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// The name of the resource.
	Value *string `json:"value,omitempty"`
}

// UsagesClientListByLocationOptions contains the optional parameters for the UsagesClient.ListByLocation method.
type UsagesClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// UserRoleAssignmentValue - Mapping of user object ID to role assignments.
type UserRoleAssignmentValue struct {
	// A map of roles to assign to the parent user.
	Roles map[string]*EnvironmentRole `json:"roles,omitempty"`
}
