//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeviceprovisioningservices

import "time"

// AsyncOperationResult - Result of a long running operation.
type AsyncOperationResult struct {
	// Error message containing code, description and details
	Error *ErrorMessage `json:"error,omitempty"`

	// current status of a long running operation.
	Status *string `json:"status,omitempty"`
}

// CertificateBodyDescription - The JSON-serialized X509 Certificate.
type CertificateBodyDescription struct {
	// Base-64 representation of the X509 leaf certificate .cer file or just .pem file content.
	Certificate *string `json:"certificate,omitempty"`

	// True indicates that the certificate will be created in verified state and proof of possession will not be required.
	IsVerified *bool `json:"isVerified,omitempty"`
}

// CertificateListDescription - The JSON-serialized array of Certificate objects.
type CertificateListDescription struct {
	// The array of Certificate objects.
	Value []*CertificateResponse `json:"value,omitempty"`
}

// CertificateProperties - The description of an X509 CA Certificate.
type CertificateProperties struct {
	// base-64 representation of X509 certificate .cer file or just .pem file content.
	Certificate []byte `json:"certificate,omitempty"`

	// Determines whether certificate has been verified.
	IsVerified *bool `json:"isVerified,omitempty"`

	// READ-ONLY; The certificate's creation date and time.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The certificate's expiration date and time.
	Expiry *time.Time `json:"expiry,omitempty" azure:"ro"`

	// READ-ONLY; The certificate's subject name.
	Subject *string `json:"subject,omitempty" azure:"ro"`

	// READ-ONLY; The certificate's thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`

	// READ-ONLY; The certificate's last update date and time.
	Updated *time.Time `json:"updated,omitempty" azure:"ro"`
}

// CertificateResponse - The X509 Certificate.
type CertificateResponse struct {
	// properties of a certificate
	Properties *CertificateProperties `json:"properties,omitempty"`

	// READ-ONLY; The entity tag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the certificate.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DpsCertificateClientCreateOrUpdateOptions contains the optional parameters for the DpsCertificateClient.CreateOrUpdate
// method.
type DpsCertificateClientCreateOrUpdateOptions struct {
	// ETag of the certificate. This is required to update an existing certificate, and ignored while creating a brand new certificate.
	IfMatch *string
}

// DpsCertificateClientDeleteOptions contains the optional parameters for the DpsCertificateClient.Delete method.
type DpsCertificateClientDeleteOptions struct {
	// Time the certificate is created.
	CertificateCreated *time.Time
	// Indicates if the certificate contains a private key.
	CertificateHasPrivateKey *bool
	// Indicates if certificate has been verified by owner of the private key.
	CertificateIsVerified *bool
	// Time the certificate is last updated.
	CertificateLastUpdated *time.Time
	// This is optional, and it is the Common Name of the certificate.
	CertificateName1 *string
	// Random number generated to indicate Proof of Possession.
	CertificateNonce *string
	// A description that mentions the purpose of the certificate.
	CertificatePurpose *CertificatePurpose
	// Raw data within the certificate.
	CertificateRawBytes []byte
}

// DpsCertificateClientGenerateVerificationCodeOptions contains the optional parameters for the DpsCertificateClient.GenerateVerificationCode
// method.
type DpsCertificateClientGenerateVerificationCodeOptions struct {
	// Certificate creation time.
	CertificateCreated *time.Time
	// Indicates if the certificate contains private key.
	CertificateHasPrivateKey *bool
	// Indicates if the certificate has been verified by owner of the private key.
	CertificateIsVerified *bool
	// Certificate last updated time.
	CertificateLastUpdated *time.Time
	// Common Name for the certificate.
	CertificateName1 *string
	// Random number generated to indicate Proof of Possession.
	CertificateNonce *string
	// Description mentioning the purpose of the certificate.
	CertificatePurpose *CertificatePurpose
	// Raw data of certificate.
	CertificateRawBytes []byte
}

// DpsCertificateClientGetOptions contains the optional parameters for the DpsCertificateClient.Get method.
type DpsCertificateClientGetOptions struct {
	// ETag of the certificate.
	IfMatch *string
}

// DpsCertificateClientListOptions contains the optional parameters for the DpsCertificateClient.List method.
type DpsCertificateClientListOptions struct {
	// placeholder for future optional parameters
}

// DpsCertificateClientVerifyCertificateOptions contains the optional parameters for the DpsCertificateClient.VerifyCertificate
// method.
type DpsCertificateClientVerifyCertificateOptions struct {
	// Certificate creation time.
	CertificateCreated *time.Time
	// Indicates if the certificate contains private key.
	CertificateHasPrivateKey *bool
	// Indicates if the certificate has been verified by owner of the private key.
	CertificateIsVerified *bool
	// Certificate last updated time.
	CertificateLastUpdated *time.Time
	// Common Name for the certificate.
	CertificateName1 *string
	// Random number generated to indicate Proof of Possession.
	CertificateNonce *string
	// Describe the purpose of the certificate.
	CertificatePurpose *CertificatePurpose
	// Raw data of certificate.
	CertificateRawBytes []byte
}

// ErrorDetails - Error details.
type ErrorDetails struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details *string `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The HTTP status code.
	HTTPStatusCode *string `json:"httpStatusCode,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ErrorMessage - Error response containing message and code.
type ErrorMessage struct {
	// standard error code
	Code *string `json:"code,omitempty"`

	// detailed summary of error
	Details *string `json:"details,omitempty"`

	// standard error description
	Message *string `json:"message,omitempty"`
}

// GroupIDInformation - The group information for creating a private endpoint on a provisioning service
type GroupIDInformation struct {
	// REQUIRED; The properties for a group information object
	Properties *GroupIDInformationProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GroupIDInformationProperties - The properties for a group information object
type GroupIDInformationProperties struct {
	// The group id
	GroupID *string `json:"groupId,omitempty"`

	// The required members for a specific group id
	RequiredMembers []*string `json:"requiredMembers,omitempty"`

	// The required DNS zones for a specific group id
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`
}

// IPFilterRule - The IP filter rules for a provisioning Service.
type IPFilterRule struct {
	// REQUIRED; The desired action for requests captured by this rule.
	Action *IPFilterActionType `json:"action,omitempty"`

	// REQUIRED; The name of the IP filter rule.
	FilterName *string `json:"filterName,omitempty"`

	// REQUIRED; A string that contains the IP address range in CIDR notation for the rule.
	IPMask *string `json:"ipMask,omitempty"`

	// Target for requests captured by this rule.
	Target *IPFilterTargetType `json:"target,omitempty"`
}

// IotDpsPropertiesDescription - the service specific properties of a provisioning service, including keys, linked iot hubs,
// current state, and system generated properties such as hostname and idScope
type IotDpsPropertiesDescription struct {
	// Allocation policy to be used by this provisioning service.
	AllocationPolicy *AllocationPolicy `json:"allocationPolicy,omitempty"`

	// List of authorization keys for a provisioning service.
	AuthorizationPolicies []*SharedAccessSignatureAuthorizationRuleAccessRightsDescription `json:"authorizationPolicies,omitempty"`

	// Optional. Indicates if the DPS instance has Data Residency enabled, removing the cross geo-pair disaster recovery.
	EnableDataResidency *bool `json:"enableDataResidency,omitempty"`

	// The IP filter rules.
	IPFilterRules []*IPFilterRule `json:"ipFilterRules,omitempty"`

	// List of IoT hubs associated with this provisioning service.
	IotHubs []*IotHubDefinitionDescription `json:"iotHubs,omitempty"`

	// Private endpoint connections created on this IotHub
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`

	// The ARM provisioning state of the provisioning service.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Whether requests from Public Network are allowed
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Current state of the provisioning service.
	State *State `json:"state,omitempty"`

	// READ-ONLY; Device endpoint for this provisioning service.
	DeviceProvisioningHostName *string `json:"deviceProvisioningHostName,omitempty" azure:"ro"`

	// READ-ONLY; Unique identifier of this provisioning service.
	IDScope *string `json:"idScope,omitempty" azure:"ro"`

	// READ-ONLY; Service endpoint for provisioning service.
	ServiceOperationsHostName *string `json:"serviceOperationsHostName,omitempty" azure:"ro"`
}

// IotDpsResourceClientBeginCreateOrUpdateOptions contains the optional parameters for the IotDpsResourceClient.BeginCreateOrUpdate
// method.
type IotDpsResourceClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IotDpsResourceClientBeginCreateOrUpdatePrivateEndpointConnectionOptions contains the optional parameters for the IotDpsResourceClient.BeginCreateOrUpdatePrivateEndpointConnection
// method.
type IotDpsResourceClientBeginCreateOrUpdatePrivateEndpointConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IotDpsResourceClientBeginDeleteOptions contains the optional parameters for the IotDpsResourceClient.BeginDelete method.
type IotDpsResourceClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IotDpsResourceClientBeginDeletePrivateEndpointConnectionOptions contains the optional parameters for the IotDpsResourceClient.BeginDeletePrivateEndpointConnection
// method.
type IotDpsResourceClientBeginDeletePrivateEndpointConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IotDpsResourceClientBeginUpdateOptions contains the optional parameters for the IotDpsResourceClient.BeginUpdate method.
type IotDpsResourceClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IotDpsResourceClientCheckProvisioningServiceNameAvailabilityOptions contains the optional parameters for the IotDpsResourceClient.CheckProvisioningServiceNameAvailability
// method.
type IotDpsResourceClientCheckProvisioningServiceNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// IotDpsResourceClientGetOperationResultOptions contains the optional parameters for the IotDpsResourceClient.GetOperationResult
// method.
type IotDpsResourceClientGetOperationResultOptions struct {
	// placeholder for future optional parameters
}

// IotDpsResourceClientGetOptions contains the optional parameters for the IotDpsResourceClient.Get method.
type IotDpsResourceClientGetOptions struct {
	// placeholder for future optional parameters
}

// IotDpsResourceClientGetPrivateEndpointConnectionOptions contains the optional parameters for the IotDpsResourceClient.GetPrivateEndpointConnection
// method.
type IotDpsResourceClientGetPrivateEndpointConnectionOptions struct {
	// placeholder for future optional parameters
}

// IotDpsResourceClientGetPrivateLinkResourcesOptions contains the optional parameters for the IotDpsResourceClient.GetPrivateLinkResources
// method.
type IotDpsResourceClientGetPrivateLinkResourcesOptions struct {
	// placeholder for future optional parameters
}

// IotDpsResourceClientListByResourceGroupOptions contains the optional parameters for the IotDpsResourceClient.ListByResourceGroup
// method.
type IotDpsResourceClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// IotDpsResourceClientListBySubscriptionOptions contains the optional parameters for the IotDpsResourceClient.ListBySubscription
// method.
type IotDpsResourceClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// IotDpsResourceClientListKeysForKeyNameOptions contains the optional parameters for the IotDpsResourceClient.ListKeysForKeyName
// method.
type IotDpsResourceClientListKeysForKeyNameOptions struct {
	// placeholder for future optional parameters
}

// IotDpsResourceClientListKeysOptions contains the optional parameters for the IotDpsResourceClient.ListKeys method.
type IotDpsResourceClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// IotDpsResourceClientListPrivateEndpointConnectionsOptions contains the optional parameters for the IotDpsResourceClient.ListPrivateEndpointConnections
// method.
type IotDpsResourceClientListPrivateEndpointConnectionsOptions struct {
	// placeholder for future optional parameters
}

// IotDpsResourceClientListPrivateLinkResourcesOptions contains the optional parameters for the IotDpsResourceClient.ListPrivateLinkResources
// method.
type IotDpsResourceClientListPrivateLinkResourcesOptions struct {
	// placeholder for future optional parameters
}

// IotDpsResourceClientListValidSKUsOptions contains the optional parameters for the IotDpsResourceClient.ListValidSKUs method.
type IotDpsResourceClientListValidSKUsOptions struct {
	// placeholder for future optional parameters
}

// IotDpsSKUDefinition - Available SKUs of tier and units.
type IotDpsSKUDefinition struct {
	// Sku name.
	Name *IotDpsSKU `json:"name,omitempty"`
}

// IotDpsSKUDefinitionListResult - List of available SKUs.
type IotDpsSKUDefinitionListResult struct {
	// The list of SKUs
	Value []*IotDpsSKUDefinition `json:"value,omitempty"`

	// READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// IotDpsSKUInfo - List of possible provisioning service SKUs.
type IotDpsSKUInfo struct {
	// The number of units to provision
	Capacity *int64 `json:"capacity,omitempty"`

	// Sku name.
	Name *IotDpsSKU `json:"name,omitempty"`

	// READ-ONLY; Pricing tier name of the provisioning service.
	Tier *string `json:"tier,omitempty" azure:"ro"`
}

// IotHubDefinitionDescription - Description of the IoT hub.
type IotHubDefinitionDescription struct {
	// REQUIRED; Connection string of the IoT hub.
	ConnectionString *string `json:"connectionString,omitempty"`

	// REQUIRED; ARM region of the IoT hub.
	Location *string `json:"location,omitempty"`

	// weight to apply for a given iot h.
	AllocationWeight *int32 `json:"allocationWeight,omitempty"`

	// flag for applying allocationPolicy or not for a given iot hub.
	ApplyAllocationPolicy *bool `json:"applyAllocationPolicy,omitempty"`

	// READ-ONLY; Host name of the IoT hub.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// NameAvailabilityInfo - Description of name availability.
type NameAvailabilityInfo struct {
	// message containing a detailed reason name is unavailable
	Message *string `json:"message,omitempty"`

	// specifies if a name is available or not
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// specifies the reason a name is unavailable
	Reason *NameUnavailabilityReason `json:"reason,omitempty"`
}

// Operation - Provisioning Service REST API operation.
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Operation name: {provider}/{resource}/{read | write | action | delete}
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Name of the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Service provider: Microsoft Devices.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type: ProvisioningServices.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationInputs - Input values for operation results call.
type OperationInputs struct {
	// REQUIRED; The name of the Provisioning Service to check.
	Name *string `json:"name,omitempty"`
}

// OperationListResult - Result of the request to list provisioning service operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning service operations supported by the Microsoft.Devices resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint - The private endpoint property of a private endpoint connection
type PrivateEndpoint struct {
	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The private endpoint connection of a provisioning service
type PrivateEndpointConnection struct {
	// REQUIRED; The properties of a private endpoint connection
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProperties - The properties of a private endpoint connection
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; The current state of a private endpoint connection
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The private endpoint property of a private endpoint connection
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
}

// PrivateLinkResources - The available private link resources for a provisioning service
type PrivateLinkResources struct {
	// The list of available private link resources for a provisioning service
	Value []*GroupIDInformation `json:"value,omitempty"`
}

// PrivateLinkServiceConnectionState - The current state of a private endpoint connection
type PrivateLinkServiceConnectionState struct {
	// REQUIRED; The description for the current state of a private endpoint connection
	Description *string `json:"description,omitempty"`

	// REQUIRED; The status of a private endpoint connection
	Status *PrivateLinkServiceConnectionStatus `json:"status,omitempty"`

	// Actions required for a private endpoint connection
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// ProvisioningServiceDescription - The description of the provisioning service.
type ProvisioningServiceDescription struct {
	// REQUIRED; The resource location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Service specific properties for a provisioning service
	Properties *IotDpsPropertiesDescription `json:"properties,omitempty"`

	// REQUIRED; Sku info for a provisioning Service.
	SKU *IotDpsSKUInfo `json:"sku,omitempty"`

	// The Etag field is not required. If it is provided in the response body, it must also be provided as a header per the normal
	// ETag convention.
	Etag *string `json:"etag,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProvisioningServiceDescriptionListResult - List of provisioning service descriptions.
type ProvisioningServiceDescriptionListResult struct {
	// List of provisioning service descriptions.
	Value []*ProvisioningServiceDescription `json:"value,omitempty"`

	// READ-ONLY; the next link
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// Resource - The common properties of an Azure resource.
type Resource struct {
	// REQUIRED; The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SharedAccessSignatureAuthorizationRuleAccessRightsDescription - Description of the shared access key.
type SharedAccessSignatureAuthorizationRuleAccessRightsDescription struct {
	// REQUIRED; Name of the key.
	KeyName *string `json:"keyName,omitempty"`

	// REQUIRED; Rights that this key has.
	Rights *AccessRightsDescription `json:"rights,omitempty"`

	// Primary SAS key value.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// Secondary SAS key value.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// SharedAccessSignatureAuthorizationRuleListResult - List of shared access keys.
type SharedAccessSignatureAuthorizationRuleListResult struct {
	// The list of shared access policies.
	Value []*SharedAccessSignatureAuthorizationRuleAccessRightsDescription `json:"value,omitempty"`

	// READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagsResource - A container holding only the Tags for a resource, allowing the user to update the tags on a Provisioning
// Service instance.
type TagsResource struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// VerificationCodeRequest - The JSON-serialized leaf certificate
type VerificationCodeRequest struct {
	// base-64 representation of X509 certificate .cer file or just .pem file content.
	Certificate *string `json:"certificate,omitempty"`
}

// VerificationCodeResponse - Description of the response of the verification code.
type VerificationCodeResponse struct {
	Properties *VerificationCodeResponseProperties `json:"properties,omitempty"`

	// READ-ONLY; Request etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of certificate.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

type VerificationCodeResponseProperties struct {
	// base-64 representation of X509 certificate .cer file or just .pem file content.
	Certificate []byte `json:"certificate,omitempty"`

	// Certificate created time.
	Created *string `json:"created,omitempty"`

	// Code expiry.
	Expiry *string `json:"expiry,omitempty"`

	// Indicate if the certificate is verified by owner of private key.
	IsVerified *bool `json:"isVerified,omitempty"`

	// Certificate subject.
	Subject *string `json:"subject,omitempty"`

	// Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`

	// Certificate updated time.
	Updated *string `json:"updated,omitempty"`

	// Verification code.
	VerificationCode *string `json:"verificationCode,omitempty"`
}
