//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagednetwork

import (
	"encoding/json"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type ConnectivityCollection.
func (c ConnectivityCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groups", c.Groups)
	populate(objectMap, "peerings", c.Peerings)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GroupProperties.
func (g GroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", g.Etag)
	populate(objectMap, "managementGroups", g.ManagementGroups)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "subnets", g.Subnets)
	populate(objectMap, "subscriptions", g.Subscriptions)
	populate(objectMap, "virtualNetworks", g.VirtualNetworks)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type HubAndSpokePeeringPolicyProperties.
func (h HubAndSpokePeeringPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", h.Etag)
	populate(objectMap, "hub", h.Hub)
	populate(objectMap, "mesh", h.Mesh)
	populate(objectMap, "provisioningState", h.ProvisioningState)
	populate(objectMap, "spokes", h.Spokes)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedNetwork.
func (m ManagedNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MeshPeeringPolicyProperties.
func (m MeshPeeringPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "hub", m.Hub)
	populate(objectMap, "mesh", m.Mesh)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "spokes", m.Spokes)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PeeringPolicyProperties.
func (p PeeringPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "hub", p.Hub)
	populate(objectMap, "mesh", p.Mesh)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "spokes", p.Spokes)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Scope.
func (s Scope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "managementGroups", s.ManagementGroups)
	populate(objectMap, "subnets", s.Subnets)
	populate(objectMap, "subscriptions", s.Subscriptions)
	populate(objectMap, "virtualNetworks", s.VirtualNetworks)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Update.
func (u Update) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}
