//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeploymentscripts

import "time"

// AzureCliScript - Object model for the Azure CLI script.
type AzureCliScript struct {
	// REQUIRED; Type of the script.
	Kind *ScriptType `json:"kind,omitempty"`

	// REQUIRED; The location of the ACI and the storage account for the deployment script.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of the Azure CLI script object.
	Properties *AzureCliScriptProperties `json:"properties,omitempty"`

	// Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDeploymentScript implements the DeploymentScriptClassification interface for type AzureCliScript.
func (a *AzureCliScript) GetDeploymentScript() *DeploymentScript {
	return &DeploymentScript{
		Identity:   a.Identity,
		Location:   a.Location,
		Tags:       a.Tags,
		Kind:       a.Kind,
		SystemData: a.SystemData,
		ID:         a.ID,
		Name:       a.Name,
		Type:       a.Type,
	}
}

// AzureCliScriptProperties - Properties of the Azure CLI script object.
type AzureCliScriptProperties struct {
	// REQUIRED; Azure CLI module version to be used.
	AzCliVersion *string `json:"azCliVersion,omitempty"`

	// REQUIRED; Interval for which the service retains the script resource after it reaches a terminal state. Resource will be
	// deleted when this duration expires. Duration is based on ISO 8601 pattern (for example
	// P1D means one day).
	RetentionInterval *string `json:"retentionInterval,omitempty"`

	// Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
	Arguments *string `json:"arguments,omitempty"`

	// The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
	CleanupPreference *CleanupOptions `json:"cleanupPreference,omitempty"`

	// Container settings.
	ContainerSettings *ContainerConfiguration `json:"containerSettings,omitempty"`

	// The environment variables to pass over to the script.
	EnvironmentVariables []*EnvironmentVariable `json:"environmentVariables,omitempty"`

	// Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be
	// current time stamp or a GUID.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// Uri for the script. This is the entry point for the external script.
	PrimaryScriptURI *string `json:"primaryScriptUri,omitempty"`

	// Script body.
	ScriptContent *string `json:"scriptContent,omitempty"`

	// Storage Account settings.
	StorageAccountSettings *StorageAccountConfiguration `json:"storageAccountSettings,omitempty"`

	// Supporting files for the external script.
	SupportingScriptUris []*string `json:"supportingScriptUris,omitempty"`

	// Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
	Timeout *string `json:"timeout,omitempty"`

	// READ-ONLY; List of script outputs.
	Outputs map[string]interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; State of the script execution. This only appears in the response.
	ProvisioningState *ScriptProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Contains the results of script execution.
	Status *ScriptStatus `json:"status,omitempty" azure:"ro"`
}

// AzurePowerShellScript - Object model for the Azure PowerShell script.
type AzurePowerShellScript struct {
	// REQUIRED; Type of the script.
	Kind *ScriptType `json:"kind,omitempty"`

	// REQUIRED; The location of the ACI and the storage account for the deployment script.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of the Azure PowerShell script object.
	Properties *AzurePowerShellScriptProperties `json:"properties,omitempty"`

	// Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDeploymentScript implements the DeploymentScriptClassification interface for type AzurePowerShellScript.
func (a *AzurePowerShellScript) GetDeploymentScript() *DeploymentScript {
	return &DeploymentScript{
		Identity:   a.Identity,
		Location:   a.Location,
		Tags:       a.Tags,
		Kind:       a.Kind,
		SystemData: a.SystemData,
		ID:         a.ID,
		Name:       a.Name,
		Type:       a.Type,
	}
}

// AzurePowerShellScriptProperties - Properties of the Azure PowerShell script object.
type AzurePowerShellScriptProperties struct {
	// REQUIRED; Azure PowerShell module version to be used.
	AzPowerShellVersion *string `json:"azPowerShellVersion,omitempty"`

	// REQUIRED; Interval for which the service retains the script resource after it reaches a terminal state. Resource will be
	// deleted when this duration expires. Duration is based on ISO 8601 pattern (for example
	// P1D means one day).
	RetentionInterval *string `json:"retentionInterval,omitempty"`

	// Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
	Arguments *string `json:"arguments,omitempty"`

	// The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
	CleanupPreference *CleanupOptions `json:"cleanupPreference,omitempty"`

	// Container settings.
	ContainerSettings *ContainerConfiguration `json:"containerSettings,omitempty"`

	// The environment variables to pass over to the script.
	EnvironmentVariables []*EnvironmentVariable `json:"environmentVariables,omitempty"`

	// Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be
	// current time stamp or a GUID.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// Uri for the script. This is the entry point for the external script.
	PrimaryScriptURI *string `json:"primaryScriptUri,omitempty"`

	// Script body.
	ScriptContent *string `json:"scriptContent,omitempty"`

	// Storage Account settings.
	StorageAccountSettings *StorageAccountConfiguration `json:"storageAccountSettings,omitempty"`

	// Supporting files for the external script.
	SupportingScriptUris []*string `json:"supportingScriptUris,omitempty"`

	// Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
	Timeout *string `json:"timeout,omitempty"`

	// READ-ONLY; List of script outputs.
	Outputs map[string]interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; State of the script execution. This only appears in the response.
	ProvisioningState *ScriptProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Contains the results of script execution.
	Status *ScriptStatus `json:"status,omitempty" azure:"ro"`
}

// AzureResourceBase - Common properties for all Azure resources.
type AzureResourceBase struct {
	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClientBeginCreateOptions contains the optional parameters for the Client.BeginCreate method.
type ClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientDeleteOptions contains the optional parameters for the Client.Delete method.
type ClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ClientGetLogsDefaultOptions contains the optional parameters for the Client.GetLogsDefault method.
type ClientGetLogsDefaultOptions struct {
	// The number of lines to show from the tail of the deployment script log. Valid value is a positive number up to 1000. If
	// 'tail' is not provided, all available logs are shown up to container instance
	// log capacity of 4mb.
	Tail *int32
}

// ClientGetLogsOptions contains the optional parameters for the Client.GetLogs method.
type ClientGetLogsOptions struct {
	// placeholder for future optional parameters
}

// ClientGetOptions contains the optional parameters for the Client.Get method.
type ClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClientListByResourceGroupOptions contains the optional parameters for the Client.ListByResourceGroup method.
type ClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ClientListBySubscriptionOptions contains the optional parameters for the Client.ListBySubscription method.
type ClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ClientUpdateOptions contains the optional parameters for the Client.Update method.
type ClientUpdateOptions struct {
	// Deployment script resource with the tags to be updated.
	DeploymentScript *DeploymentScriptUpdateParameter
}

// ContainerConfiguration - Settings to customize ACI container instance.
type ContainerConfiguration struct {
	// Container group name, if not specified then the name will get auto-generated. Not specifying a 'containerGroupName' indicates
	// the system to generate a unique name which might end up flagging an Azure
	// Policy as non-compliant. Use 'containerGroupName' when you have an Azure Policy that expects a specific naming convention
	// or when you want to fully control the name. 'containerGroupName' property must
	// be between 1 and 63 characters long, must contain only lowercase letters, numbers, and dashes and it cannot start or end
	// with a dash and consecutive dashes are not allowed. To specify a
	// 'containerGroupName', add the following object to properties: { "containerSettings": { "containerGroupName": "contoso-container"
	// } }. If you do not want to specify a 'containerGroupName' then do not
	// add 'containerSettings' property.
	ContainerGroupName *string `json:"containerGroupName,omitempty"`
}

// DeploymentScriptClassification provides polymorphic access to related types.
// Call the interface's GetDeploymentScript() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureCliScript, *AzurePowerShellScript, *DeploymentScript
type DeploymentScriptClassification interface {
	// GetDeploymentScript returns the DeploymentScript content of the underlying type.
	GetDeploymentScript() *DeploymentScript
}

// DeploymentScript - Deployment script object.
type DeploymentScript struct {
	// REQUIRED; Type of the script.
	Kind *ScriptType `json:"kind,omitempty"`

	// REQUIRED; The location of the ACI and the storage account for the deployment script.
	Location *string `json:"location,omitempty"`

	// Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDeploymentScript implements the DeploymentScriptClassification interface for type DeploymentScript.
func (d *DeploymentScript) GetDeploymentScript() *DeploymentScript { return d }

// DeploymentScriptListResult - List of deployment scripts.
type DeploymentScriptListResult struct {
	// An array of deployment scripts.
	Value []DeploymentScriptClassification `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DeploymentScriptPropertiesBase - Common properties for the deployment script.
type DeploymentScriptPropertiesBase struct {
	// The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
	CleanupPreference *CleanupOptions `json:"cleanupPreference,omitempty"`

	// Container settings.
	ContainerSettings *ContainerConfiguration `json:"containerSettings,omitempty"`

	// Storage Account settings.
	StorageAccountSettings *StorageAccountConfiguration `json:"storageAccountSettings,omitempty"`

	// READ-ONLY; List of script outputs.
	Outputs map[string]interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; State of the script execution. This only appears in the response.
	ProvisioningState *ScriptProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Contains the results of script execution.
	Status *ScriptStatus `json:"status,omitempty" azure:"ro"`
}

// DeploymentScriptUpdateParameter - Deployment script parameters to be updated.
type DeploymentScriptUpdateParameter struct {
	// Resource tags to be updated.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EnvironmentVariable - The environment variable to pass to the script in the container instance.
type EnvironmentVariable struct {
	// REQUIRED; The name of the environment variable.
	Name *string `json:"name,omitempty"`

	// The value of the secure environment variable.
	SecureValue *string `json:"secureValue,omitempty"`

	// The value of the environment variable.
	Value *string `json:"value,omitempty"`
}

// Error - Deployment scripts error response.
type Error struct {
	// Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows
	// the OData error response format.)
	Error *ErrorResponse `json:"error,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.)
type ErrorResponse struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorResponse `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// LogProperties - Script log properties.
type LogProperties struct {
	// READ-ONLY; Script execution logs in text format.
	Log *string `json:"log,omitempty" azure:"ro"`
}

// ManagedServiceIdentity - Managed identity generic object.
type ManagedServiceIdentity struct {
	// Type of the managed identity.
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed
	// identity.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; ID of the Azure Active Directory.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ScriptConfigurationBase - Common configuration settings for both Azure PowerShell and Azure CLI scripts.
type ScriptConfigurationBase struct {
	// REQUIRED; Interval for which the service retains the script resource after it reaches a terminal state. Resource will be
	// deleted when this duration expires. Duration is based on ISO 8601 pattern (for example
	// P1D means one day).
	RetentionInterval *string `json:"retentionInterval,omitempty"`

	// Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
	Arguments *string `json:"arguments,omitempty"`

	// The environment variables to pass over to the script.
	EnvironmentVariables []*EnvironmentVariable `json:"environmentVariables,omitempty"`

	// Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be
	// current time stamp or a GUID.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// Uri for the script. This is the entry point for the external script.
	PrimaryScriptURI *string `json:"primaryScriptUri,omitempty"`

	// Script body.
	ScriptContent *string `json:"scriptContent,omitempty"`

	// Supporting files for the external script.
	SupportingScriptUris []*string `json:"supportingScriptUris,omitempty"`

	// Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
	Timeout *string `json:"timeout,omitempty"`
}

// ScriptLog - Script execution log object.
type ScriptLog struct {
	// Script log properties.
	Properties *LogProperties `json:"properties,omitempty"`

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScriptLogsList - Deployment script execution logs.
type ScriptLogsList struct {
	// Deployment scripts logs.
	Value []*ScriptLog `json:"value,omitempty"`
}

// ScriptStatus - Generic object modeling results of script execution.
type ScriptStatus struct {
	// Error that is relayed from the script execution.
	Error *ErrorResponse `json:"error,omitempty"`

	// READ-ONLY; ACI resource Id.
	ContainerInstanceID *string `json:"containerInstanceId,omitempty" azure:"ro"`

	// READ-ONLY; End time of the script execution.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Time the deployment script resource will expire.
	ExpirationTime *time.Time `json:"expirationTime,omitempty" azure:"ro"`

	// READ-ONLY; Start time of the script execution.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Storage account resource Id.
	StorageAccountID *string `json:"storageAccountId,omitempty" azure:"ro"`
}

// StorageAccountConfiguration - Settings to use an existing storage account. Valid storage account kinds are: Storage, StorageV2
// and FileStorage
type StorageAccountConfiguration struct {
	// The storage account access key.
	StorageAccountKey *string `json:"storageAccountKey,omitempty"`

	// The storage account name.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// UserAssignedIdentity - User-assigned managed identity.
type UserAssignedIdentity struct {
	// READ-ONLY; Client App Id associated with this identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; Azure Active Directory principal ID associated with this identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}
