//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity

import "time"

// AADConnectivityStateAutoGenerated - Describes an Azure resource with kind
type AADConnectivityStateAutoGenerated struct {
	// The connectivity state of the external AAD solution
	ConnectivityState *AADConnectivityState `json:"connectivityState,omitempty"`
}

// AADExternalSecuritySolution - Represents an AAD identity protection solution which sends logs to an OMS workspace.
type AADExternalSecuritySolution struct {
	// The kind of the external solution
	Kind *ExternalSecuritySolutionKind `json:"kind,omitempty"`

	// The external security solution properties for AAD solutions
	Properties *AADSolutionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AADSolutionProperties - The external security solution properties for AAD solutions
type AADSolutionProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The connectivity state of the external AAD solution
	ConnectivityState *AADConnectivityState `json:"connectivityState,omitempty"`
	DeviceType        *string               `json:"deviceType,omitempty"`
	DeviceVendor      *string               `json:"deviceVendor,omitempty"`

	// Represents an OMS workspace to which the solution is connected
	Workspace *ConnectedWorkspace `json:"workspace,omitempty"`
}

// AccountConnectorsClientCreateOrUpdateOptions contains the optional parameters for the AccountConnectorsClient.CreateOrUpdate
// method.
type AccountConnectorsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AccountConnectorsClientDeleteOptions contains the optional parameters for the AccountConnectorsClient.Delete method.
type AccountConnectorsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AccountConnectorsClientGetOptions contains the optional parameters for the AccountConnectorsClient.Get method.
type AccountConnectorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccountConnectorsClientListOptions contains the optional parameters for the AccountConnectorsClient.List method.
type AccountConnectorsClientListOptions struct {
	// placeholder for future optional parameters
}

// ActiveConnectionsNotInAllowedRange - Number of active connections is not in allowed range.
type ActiveConnectionsNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type ActiveConnectionsNotInAllowedRange.
func (a *ActiveConnectionsNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: a.DisplayName,
		Description: a.Description,
		IsEnabled:   a.IsEnabled,
		RuleType:    a.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type ActiveConnectionsNotInAllowedRange.
func (a *ActiveConnectionsNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: a.MinThreshold,
		MaxThreshold: a.MaxThreshold,
		DisplayName:  a.DisplayName,
		Description:  a.Description,
		IsEnabled:    a.IsEnabled,
		RuleType:     a.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type ActiveConnectionsNotInAllowedRange.
func (a *ActiveConnectionsNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: a.TimeWindowSize,
		MinThreshold:   a.MinThreshold,
		MaxThreshold:   a.MaxThreshold,
		DisplayName:    a.DisplayName,
		Description:    a.Description,
		IsEnabled:      a.IsEnabled,
		RuleType:       a.RuleType,
	}
}

type AdaptiveApplicationControlGroup struct {
	// REQUIRED; Represents a machines group and set of rules to be allowed running on a machine
	Properties *AdaptiveApplicationControlGroupData `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AdaptiveApplicationControlGroupData - Represents a machines group and set of rules to be allowed running on a machine
type AdaptiveApplicationControlGroupData struct {
	// The application control policy enforcement/protection mode of the machine group
	EnforcementMode     *EnforcementMode      `json:"enforcementMode,omitempty"`
	PathRecommendations []*PathRecommendation `json:"pathRecommendations,omitempty"`

	// The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
	ProtectionMode    *ProtectionMode     `json:"protectionMode,omitempty"`
	VMRecommendations []*VMRecommendation `json:"vmRecommendations,omitempty"`

	// READ-ONLY; The configuration status of the machines group or machine or rule
	ConfigurationStatus *ConfigurationStatus `json:"configurationStatus,omitempty" azure:"ro"`

	// READ-ONLY
	Issues []*AdaptiveApplicationControlIssueSummary `json:"issues,omitempty" azure:"ro"`

	// READ-ONLY; The initial recommendation status of the machine group or machine
	RecommendationStatus *RecommendationStatus `json:"recommendationStatus,omitempty" azure:"ro"`

	// READ-ONLY; The source type of the machine group
	SourceSystem *SourceSystem `json:"sourceSystem,omitempty" azure:"ro"`
}

// AdaptiveApplicationControlGroups - Represents a list of VM/server groups and set of rules that are Recommended by Microsoft
// Defender for Cloud to be allowed
type AdaptiveApplicationControlGroups struct {
	Value []*AdaptiveApplicationControlGroup `json:"value,omitempty"`
}

// AdaptiveApplicationControlIssueSummary - Represents a summary of the alerts of the machine group
type AdaptiveApplicationControlIssueSummary struct {
	// An alert that machines within a group can have
	Issue *AdaptiveApplicationControlIssue `json:"issue,omitempty"`

	// The number of machines in the group that have this alert
	NumberOfVMs *float32 `json:"numberOfVms,omitempty"`
}

// AdaptiveApplicationControlsClientDeleteOptions contains the optional parameters for the AdaptiveApplicationControlsClient.Delete
// method.
type AdaptiveApplicationControlsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AdaptiveApplicationControlsClientGetOptions contains the optional parameters for the AdaptiveApplicationControlsClient.Get
// method.
type AdaptiveApplicationControlsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AdaptiveApplicationControlsClientListOptions contains the optional parameters for the AdaptiveApplicationControlsClient.List
// method.
type AdaptiveApplicationControlsClientListOptions struct {
	// Include the policy rules
	IncludePathRecommendations *bool
	// Return output in a summarized form
	Summary *bool
}

// AdaptiveApplicationControlsClientPutOptions contains the optional parameters for the AdaptiveApplicationControlsClient.Put
// method.
type AdaptiveApplicationControlsClientPutOptions struct {
	// placeholder for future optional parameters
}

// AdaptiveNetworkHardening - The resource whose properties describes the Adaptive Network Hardening settings for some Azure
// resource
type AdaptiveNetworkHardening struct {
	// Properties of the Adaptive Network Hardening resource
	Properties *AdaptiveNetworkHardeningProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

type AdaptiveNetworkHardeningEnforceRequest struct {
	// REQUIRED; The Azure resource IDs of the effective network security groups that will be updated with the created security
	// rules from the Adaptive Network Hardening rules
	NetworkSecurityGroups []*string `json:"networkSecurityGroups,omitempty"`

	// REQUIRED; The rules to enforce
	Rules []*Rule `json:"rules,omitempty"`
}

// AdaptiveNetworkHardeningProperties - Adaptive Network Hardening resource properties
type AdaptiveNetworkHardeningProperties struct {
	// The Network Security Groups effective on the network interfaces of the protected resource
	EffectiveNetworkSecurityGroups []*EffectiveNetworkSecurityGroups `json:"effectiveNetworkSecurityGroups,omitempty"`

	// The security rules which are recommended to be effective on the VM
	Rules []*Rule `json:"rules,omitempty"`

	// The UTC time on which the rules were calculated
	RulesCalculationTime *time.Time `json:"rulesCalculationTime,omitempty"`
}

// AdaptiveNetworkHardeningsClientBeginEnforceOptions contains the optional parameters for the AdaptiveNetworkHardeningsClient.BeginEnforce
// method.
type AdaptiveNetworkHardeningsClientBeginEnforceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AdaptiveNetworkHardeningsClientGetOptions contains the optional parameters for the AdaptiveNetworkHardeningsClient.Get
// method.
type AdaptiveNetworkHardeningsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AdaptiveNetworkHardeningsClientListByExtendedResourceOptions contains the optional parameters for the AdaptiveNetworkHardeningsClient.ListByExtendedResource
// method.
type AdaptiveNetworkHardeningsClientListByExtendedResourceOptions struct {
	// placeholder for future optional parameters
}

// AdaptiveNetworkHardeningsList - Response for ListAdaptiveNetworkHardenings API service call
type AdaptiveNetworkHardeningsList struct {
	// The URL to get the next set of results
	NextLink *string `json:"nextLink,omitempty"`

	// A list of Adaptive Network Hardenings resources
	Value []*AdaptiveNetworkHardening `json:"value,omitempty"`
}

// AdditionalDataClassification provides polymorphic access to related types.
// Call the interface's GetAdditionalData() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AdditionalData, *ContainerRegistryVulnerabilityProperties, *SQLServerVulnerabilityProperties, *ServerVulnerabilityProperties
type AdditionalDataClassification interface {
	// GetAdditionalData returns the AdditionalData content of the underlying type.
	GetAdditionalData() *AdditionalData
}

// AdditionalData - Details of the sub-assessment
type AdditionalData struct {
	// REQUIRED; Sub-assessment resource type
	AssessedResourceType *AssessedResourceType `json:"assessedResourceType,omitempty"`
}

// GetAdditionalData implements the AdditionalDataClassification interface for type AdditionalData.
func (a *AdditionalData) GetAdditionalData() *AdditionalData { return a }

// AdditionalWorkspacesProperties - Properties of the additional workspaces.
type AdditionalWorkspacesProperties struct {
	// List of data types sent to workspace
	DataTypes []*AdditionalWorkspaceDataType `json:"dataTypes,omitempty"`

	// Workspace type.
	Type *AdditionalWorkspaceType `json:"type,omitempty"`

	// Workspace resource id
	Workspace *string `json:"workspace,omitempty"`
}

// AdvancedThreatProtectionClientCreateOptions contains the optional parameters for the AdvancedThreatProtectionClient.Create
// method.
type AdvancedThreatProtectionClientCreateOptions struct {
	// placeholder for future optional parameters
}

// AdvancedThreatProtectionClientGetOptions contains the optional parameters for the AdvancedThreatProtectionClient.Get method.
type AdvancedThreatProtectionClientGetOptions struct {
	// placeholder for future optional parameters
}

// AdvancedThreatProtectionProperties - The Advanced Threat Protection settings.
type AdvancedThreatProtectionProperties struct {
	// Indicates whether Advanced Threat Protection is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// AdvancedThreatProtectionSetting - The Advanced Threat Protection resource.
type AdvancedThreatProtectionSetting struct {
	// The Advanced Threat Protection settings.
	Properties *AdvancedThreatProtectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Alert - Security alert
type Alert struct {
	// describes security alert properties.
	Properties *AlertProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertEntity - Changing set of properties depending on the entity type.
type AlertEntity struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; Type of entity
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertList - List of security alerts
type AlertList struct {
	// describes security alert properties.
	Value []*Alert `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AlertProperties - describes security alert properties.
type AlertProperties struct {
	// Custom properties for the alert.
	ExtendedProperties map[string]*string `json:"extendedProperties,omitempty"`

	// Changing set of properties depending on the supportingEvidence type.
	SupportingEvidence *AlertPropertiesSupportingEvidence `json:"supportingEvidence,omitempty"`

	// READ-ONLY; The display name of the alert.
	AlertDisplayName *string `json:"alertDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Unique identifier for the detection logic (all alert instances from the same detection logic will have the same
	// alertType).
	AlertType *string `json:"alertType,omitempty" azure:"ro"`

	// READ-ONLY; A direct link to the alert page in Azure Portal.
	AlertURI *string `json:"alertUri,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the resource most related to this alert.
	CompromisedEntity *string `json:"compromisedEntity,omitempty" azure:"ro"`

	// READ-ONLY; Key for corelating related alerts. Alerts with the same correlation key considered to be related.
	CorrelationKey *string `json:"correlationKey,omitempty" azure:"ro"`

	// READ-ONLY; Description of the suspicious activity that was detected.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The UTC time of the last event or activity included in the alert in ISO8601 format.
	EndTimeUTC *time.Time `json:"endTimeUtc,omitempty" azure:"ro"`

	// READ-ONLY; A list of entities related to the alert.
	Entities []*AlertEntity `json:"entities,omitempty" azure:"ro"`

	// READ-ONLY; Links related to the alert
	ExtendedLinks []map[string]*string `json:"extendedLinks,omitempty" azure:"ro"`

	// READ-ONLY; The kill chain related intent behind the alert. For list of supported values, and explanations of Azure Security
	// Center's supported kill chain intents.
	Intent *Intent `json:"intent,omitempty" azure:"ro"`

	// READ-ONLY; This field determines whether the alert is an incident (a compound grouping of several alerts) or a single alert.
	IsIncident *bool `json:"isIncident,omitempty" azure:"ro"`

	// READ-ONLY; The UTC processing end time of the alert in ISO8601 format.
	ProcessingEndTimeUTC *time.Time `json:"processingEndTimeUtc,omitempty" azure:"ro"`

	// READ-ONLY; The name of Azure Security Center pricing tier which powering this alert. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-pricing
	ProductComponentName *string `json:"productComponentName,omitempty" azure:"ro"`

	// READ-ONLY; The name of the product which published this alert (Azure Security Center, Azure ATP, Microsoft Defender ATP,
	// O365 ATP, MCAS, and so on).
	ProductName *string `json:"productName,omitempty" azure:"ro"`

	// READ-ONLY; Manual action items to take to remediate the alert.
	RemediationSteps []*string `json:"remediationSteps,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifiers that can be used to direct the alert to the right product exposure group (tenant, workspace,
	// subscription etc.). There can be multiple identifiers of different type per alert.
	ResourceIdentifiers []ResourceIdentifierClassification `json:"resourceIdentifiers,omitempty" azure:"ro"`

	// READ-ONLY; The risk level of the threat that was detected. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-alerts-overview#how-are-alerts-classified.
	Severity *AlertSeverity `json:"severity,omitempty" azure:"ro"`

	// READ-ONLY; The UTC time of the first event or activity included in the alert in ISO8601 format.
	StartTimeUTC *time.Time `json:"startTimeUtc,omitempty" azure:"ro"`

	// READ-ONLY; The life cycle status of the alert.
	Status *AlertStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Kill chain related sub-techniques behind the alert.
	SubTechniques []*string `json:"subTechniques,omitempty" azure:"ro"`

	// READ-ONLY; Unique identifier for the alert.
	SystemAlertID *string `json:"systemAlertId,omitempty" azure:"ro"`

	// READ-ONLY; kill chain related techniques behind the alert.
	Techniques []*string `json:"techniques,omitempty" azure:"ro"`

	// READ-ONLY; The UTC time the alert was generated in ISO8601 format.
	TimeGeneratedUTC *time.Time `json:"timeGeneratedUtc,omitempty" azure:"ro"`

	// READ-ONLY; The name of the vendor that raises the alert.
	VendorName *string `json:"vendorName,omitempty" azure:"ro"`

	// READ-ONLY; Schema version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// AlertPropertiesSupportingEvidence - Changing set of properties depending on the supportingEvidence type.
type AlertPropertiesSupportingEvidence struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; Type of the supportingEvidence
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertSimulatorBundlesRequestProperties - Simulate alerts according to this bundles.
type AlertSimulatorBundlesRequestProperties struct {
	// REQUIRED; The kind of alert simulation.
	Kind *Kind `json:"kind,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Bundles list.
	Bundles []*BundleType `json:"bundles,omitempty"`
}

// GetAlertSimulatorRequestProperties implements the AlertSimulatorRequestPropertiesClassification interface for type AlertSimulatorBundlesRequestProperties.
func (a *AlertSimulatorBundlesRequestProperties) GetAlertSimulatorRequestProperties() *AlertSimulatorRequestProperties {
	return &AlertSimulatorRequestProperties{
		Kind:                 a.Kind,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AlertSimulatorRequestBody - Alert Simulator request body.
type AlertSimulatorRequestBody struct {
	// Alert Simulator request body data.
	Properties AlertSimulatorRequestPropertiesClassification `json:"properties,omitempty"`
}

// AlertSimulatorRequestPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetAlertSimulatorRequestProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AlertSimulatorBundlesRequestProperties, *AlertSimulatorRequestProperties
type AlertSimulatorRequestPropertiesClassification interface {
	// GetAlertSimulatorRequestProperties returns the AlertSimulatorRequestProperties content of the underlying type.
	GetAlertSimulatorRequestProperties() *AlertSimulatorRequestProperties
}

// AlertSimulatorRequestProperties - Describes properties of an alert simulation request
type AlertSimulatorRequestProperties struct {
	// REQUIRED; The kind of alert simulation.
	Kind *Kind `json:"kind,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
}

// GetAlertSimulatorRequestProperties implements the AlertSimulatorRequestPropertiesClassification interface for type AlertSimulatorRequestProperties.
func (a *AlertSimulatorRequestProperties) GetAlertSimulatorRequestProperties() *AlertSimulatorRequestProperties {
	return a
}

// AlertSyncSettingProperties - The alert sync setting properties
type AlertSyncSettingProperties struct {
	// REQUIRED; Is the alert sync setting enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// AlertSyncSettings - Represents an alert sync setting
type AlertSyncSettings struct {
	// REQUIRED; the kind of the settings string
	Kind *SettingKind `json:"kind,omitempty"`

	// Alert sync setting data
	Properties *AlertSyncSettingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetSetting implements the SettingClassification interface for type AlertSyncSettings.
func (a *AlertSyncSettings) GetSetting() *Setting {
	return &Setting{
		Kind: a.Kind,
		ID:   a.ID,
		Name: a.Name,
		Type: a.Type,
	}
}

// AlertsClientBeginSimulateOptions contains the optional parameters for the AlertsClient.BeginSimulate method.
type AlertsClientBeginSimulateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AlertsClientGetResourceGroupLevelOptions contains the optional parameters for the AlertsClient.GetResourceGroupLevel method.
type AlertsClientGetResourceGroupLevelOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientGetSubscriptionLevelOptions contains the optional parameters for the AlertsClient.GetSubscriptionLevel method.
type AlertsClientGetSubscriptionLevelOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientListByResourceGroupOptions contains the optional parameters for the AlertsClient.ListByResourceGroup method.
type AlertsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientListOptions contains the optional parameters for the AlertsClient.List method.
type AlertsClientListOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientListResourceGroupLevelByRegionOptions contains the optional parameters for the AlertsClient.ListResourceGroupLevelByRegion
// method.
type AlertsClientListResourceGroupLevelByRegionOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientListSubscriptionLevelByRegionOptions contains the optional parameters for the AlertsClient.ListSubscriptionLevelByRegion
// method.
type AlertsClientListSubscriptionLevelByRegionOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientUpdateResourceGroupLevelStateToActivateOptions contains the optional parameters for the AlertsClient.UpdateResourceGroupLevelStateToActivate
// method.
type AlertsClientUpdateResourceGroupLevelStateToActivateOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientUpdateResourceGroupLevelStateToDismissOptions contains the optional parameters for the AlertsClient.UpdateResourceGroupLevelStateToDismiss
// method.
type AlertsClientUpdateResourceGroupLevelStateToDismissOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientUpdateResourceGroupLevelStateToInProgressOptions contains the optional parameters for the AlertsClient.UpdateResourceGroupLevelStateToInProgress
// method.
type AlertsClientUpdateResourceGroupLevelStateToInProgressOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientUpdateResourceGroupLevelStateToResolveOptions contains the optional parameters for the AlertsClient.UpdateResourceGroupLevelStateToResolve
// method.
type AlertsClientUpdateResourceGroupLevelStateToResolveOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientUpdateSubscriptionLevelStateToActivateOptions contains the optional parameters for the AlertsClient.UpdateSubscriptionLevelStateToActivate
// method.
type AlertsClientUpdateSubscriptionLevelStateToActivateOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientUpdateSubscriptionLevelStateToDismissOptions contains the optional parameters for the AlertsClient.UpdateSubscriptionLevelStateToDismiss
// method.
type AlertsClientUpdateSubscriptionLevelStateToDismissOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientUpdateSubscriptionLevelStateToInProgressOptions contains the optional parameters for the AlertsClient.UpdateSubscriptionLevelStateToInProgress
// method.
type AlertsClientUpdateSubscriptionLevelStateToInProgressOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientUpdateSubscriptionLevelStateToResolveOptions contains the optional parameters for the AlertsClient.UpdateSubscriptionLevelStateToResolve
// method.
type AlertsClientUpdateSubscriptionLevelStateToResolveOptions struct {
	// placeholder for future optional parameters
}

// AlertsSuppressionRule - Describes the suppression rule
type AlertsSuppressionRule struct {
	// describes AlertsSuppressionRule properties
	Properties *AlertsSuppressionRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertsSuppressionRuleProperties - describes AlertsSuppressionRule properties
type AlertsSuppressionRuleProperties struct {
	// REQUIRED; Type of the alert to automatically suppress. For all alert types, use '*'
	AlertType *string `json:"alertType,omitempty"`

	// REQUIRED; The reason for dismissing the alert
	Reason *string `json:"reason,omitempty"`

	// REQUIRED; Possible states of the rule
	State *RuleState `json:"state,omitempty"`

	// Any comment regarding the rule
	Comment *string `json:"comment,omitempty"`

	// Expiration date of the rule, if value is not provided or provided as null this field will default to the maximum allowed
	// expiration date.
	ExpirationDateUTC *time.Time `json:"expirationDateUtc,omitempty"`

	// The suppression conditions
	SuppressionAlertsScope *SuppressionAlertsScope `json:"suppressionAlertsScope,omitempty"`

	// READ-ONLY; The last time this rule was modified
	LastModifiedUTC *time.Time `json:"lastModifiedUtc,omitempty" azure:"ro"`
}

// AlertsSuppressionRulesClientDeleteOptions contains the optional parameters for the AlertsSuppressionRulesClient.Delete
// method.
type AlertsSuppressionRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AlertsSuppressionRulesClientGetOptions contains the optional parameters for the AlertsSuppressionRulesClient.Get method.
type AlertsSuppressionRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// AlertsSuppressionRulesClientListOptions contains the optional parameters for the AlertsSuppressionRulesClient.List method.
type AlertsSuppressionRulesClientListOptions struct {
	// Type of the alert to get rules for
	AlertType *string
}

// AlertsSuppressionRulesClientUpdateOptions contains the optional parameters for the AlertsSuppressionRulesClient.Update
// method.
type AlertsSuppressionRulesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// AlertsSuppressionRulesList - Suppression rules list for subscription.
type AlertsSuppressionRulesList struct {
	// REQUIRED
	Value []*AlertsSuppressionRule `json:"value,omitempty"`

	// READ-ONLY; URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AllowedConnectionsClientGetOptions contains the optional parameters for the AllowedConnectionsClient.Get method.
type AllowedConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AllowedConnectionsClientListByHomeRegionOptions contains the optional parameters for the AllowedConnectionsClient.ListByHomeRegion
// method.
type AllowedConnectionsClientListByHomeRegionOptions struct {
	// placeholder for future optional parameters
}

// AllowedConnectionsClientListOptions contains the optional parameters for the AllowedConnectionsClient.List method.
type AllowedConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// AllowedConnectionsList - List of all possible traffic between Azure resources
type AllowedConnectionsList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY
	Value []*AllowedConnectionsResource `json:"value,omitempty" azure:"ro"`
}

// AllowedConnectionsResource - The resource whose properties describes the allowed traffic between Azure resources
type AllowedConnectionsResource struct {
	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Describes the allowed traffic between Azure resources
	Properties *AllowedConnectionsResourceProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AllowedConnectionsResourceProperties - Describes the allowed traffic between Azure resources
type AllowedConnectionsResourceProperties struct {
	// READ-ONLY; The UTC time on which the allowed connections resource was calculated
	CalculatedDateTime *time.Time `json:"calculatedDateTime,omitempty" azure:"ro"`

	// READ-ONLY; List of connectable resources
	ConnectableResources []*ConnectableResource `json:"connectableResources,omitempty" azure:"ro"`
}

// AllowlistCustomAlertRuleClassification provides polymorphic access to related types.
// Call the interface's GetAllowlistCustomAlertRule() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AllowlistCustomAlertRule, *ConnectionFromIPNotAllowed, *ConnectionToIPNotAllowed, *LocalUserNotAllowed, *ProcessNotAllowed
type AllowlistCustomAlertRuleClassification interface {
	ListCustomAlertRuleClassification
	// GetAllowlistCustomAlertRule returns the AllowlistCustomAlertRule content of the underlying type.
	GetAllowlistCustomAlertRule() *AllowlistCustomAlertRule
}

// AllowlistCustomAlertRule - A custom alert rule that checks if a value (depends on the custom alert type) is allowed.
type AllowlistCustomAlertRule struct {
	// REQUIRED; The values to allow. The format of the values depends on the rule type.
	AllowlistValues []*string `json:"allowlistValues,omitempty"`

	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType `json:"valueType,omitempty" azure:"ro"`
}

// GetAllowlistCustomAlertRule implements the AllowlistCustomAlertRuleClassification interface for type AllowlistCustomAlertRule.
func (a *AllowlistCustomAlertRule) GetAllowlistCustomAlertRule() *AllowlistCustomAlertRule { return a }

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type AllowlistCustomAlertRule.
func (a *AllowlistCustomAlertRule) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: a.DisplayName,
		Description: a.Description,
		IsEnabled:   a.IsEnabled,
		RuleType:    a.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type AllowlistCustomAlertRule.
func (a *AllowlistCustomAlertRule) GetListCustomAlertRule() *ListCustomAlertRule {
	return &ListCustomAlertRule{
		ValueType:   a.ValueType,
		DisplayName: a.DisplayName,
		Description: a.Description,
		IsEnabled:   a.IsEnabled,
		RuleType:    a.RuleType,
	}
}

// AmqpC2DMessagesNotInAllowedRange - Number of cloud to device messages (AMQP protocol) is not in allowed range.
type AmqpC2DMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type AmqpC2DMessagesNotInAllowedRange.
func (a *AmqpC2DMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: a.DisplayName,
		Description: a.Description,
		IsEnabled:   a.IsEnabled,
		RuleType:    a.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type AmqpC2DMessagesNotInAllowedRange.
func (a *AmqpC2DMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: a.MinThreshold,
		MaxThreshold: a.MaxThreshold,
		DisplayName:  a.DisplayName,
		Description:  a.Description,
		IsEnabled:    a.IsEnabled,
		RuleType:     a.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type AmqpC2DMessagesNotInAllowedRange.
func (a *AmqpC2DMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: a.TimeWindowSize,
		MinThreshold:   a.MinThreshold,
		MaxThreshold:   a.MaxThreshold,
		DisplayName:    a.DisplayName,
		Description:    a.Description,
		IsEnabled:      a.IsEnabled,
		RuleType:       a.RuleType,
	}
}

// AmqpC2DRejectedMessagesNotInAllowedRange - Number of rejected cloud to device messages (AMQP protocol) is not in allowed
// range.
type AmqpC2DRejectedMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type AmqpC2DRejectedMessagesNotInAllowedRange.
func (a *AmqpC2DRejectedMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: a.DisplayName,
		Description: a.Description,
		IsEnabled:   a.IsEnabled,
		RuleType:    a.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type AmqpC2DRejectedMessagesNotInAllowedRange.
func (a *AmqpC2DRejectedMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: a.MinThreshold,
		MaxThreshold: a.MaxThreshold,
		DisplayName:  a.DisplayName,
		Description:  a.Description,
		IsEnabled:    a.IsEnabled,
		RuleType:     a.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type AmqpC2DRejectedMessagesNotInAllowedRange.
func (a *AmqpC2DRejectedMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: a.TimeWindowSize,
		MinThreshold:   a.MinThreshold,
		MaxThreshold:   a.MaxThreshold,
		DisplayName:    a.DisplayName,
		Description:    a.Description,
		IsEnabled:      a.IsEnabled,
		RuleType:       a.RuleType,
	}
}

// AmqpD2CMessagesNotInAllowedRange - Number of device to cloud messages (AMQP protocol) is not in allowed range.
type AmqpD2CMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type AmqpD2CMessagesNotInAllowedRange.
func (a *AmqpD2CMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: a.DisplayName,
		Description: a.Description,
		IsEnabled:   a.IsEnabled,
		RuleType:    a.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type AmqpD2CMessagesNotInAllowedRange.
func (a *AmqpD2CMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: a.MinThreshold,
		MaxThreshold: a.MaxThreshold,
		DisplayName:  a.DisplayName,
		Description:  a.Description,
		IsEnabled:    a.IsEnabled,
		RuleType:     a.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type AmqpD2CMessagesNotInAllowedRange.
func (a *AmqpD2CMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: a.TimeWindowSize,
		MinThreshold:   a.MinThreshold,
		MaxThreshold:   a.MaxThreshold,
		DisplayName:    a.DisplayName,
		Description:    a.Description,
		IsEnabled:      a.IsEnabled,
		RuleType:       a.RuleType,
	}
}

// Application - Security Application over a given scope
type Application struct {
	// Properties of a security application
	Properties *ApplicationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationClientCreateOrUpdateOptions contains the optional parameters for the ApplicationClient.CreateOrUpdate method.
type ApplicationClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ApplicationClientDeleteOptions contains the optional parameters for the ApplicationClient.Delete method.
type ApplicationClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ApplicationClientGetOptions contains the optional parameters for the ApplicationClient.Get method.
type ApplicationClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationCondition - Application's condition
type ApplicationCondition struct {
	// The application Condition's Operator, for example Contains for id or In for list of possible IDs, see examples
	Operator *ApplicationConditionOperator `json:"operator,omitempty"`

	// The application Condition's Property, e.g. ID, see examples
	Property *string `json:"property,omitempty"`

	// The application Condition's Value like IDs that contain some string, see examples
	Value *string `json:"value,omitempty"`
}

// ApplicationProperties - Describes properties of an application
type ApplicationProperties struct {
	// REQUIRED; The application conditionSets - see examples
	ConditionSets []interface{} `json:"conditionSets,omitempty"`

	// REQUIRED; The application source, what it affects, e.g. Assessments
	SourceResourceType *ApplicationSourceResourceType `json:"sourceResourceType,omitempty"`

	// description of the application
	Description *string `json:"description,omitempty"`

	// display name of the application
	DisplayName *string `json:"displayName,omitempty"`
}

// ApplicationsClientListOptions contains the optional parameters for the ApplicationsClient.List method.
type ApplicationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsList - Page of a security applications list
type ApplicationsList struct {
	// READ-ONLY; The URI to fetch the next page
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Collection of applications in this page
	Value []*Application `json:"value,omitempty" azure:"ro"`
}

// AscLocation - The ASC location of the subscription is in the "name" field
type AscLocation struct {
	// An empty set of properties
	Properties interface{} `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AscLocationList - List of locations where ASC saves your data
type AscLocationList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY
	Value []*AscLocation `json:"value,omitempty" azure:"ro"`
}

// Assessment - Security assessment on a resource
type Assessment struct {
	// Describes properties of an assessment.
	Properties *AssessmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssessmentLinks - Links relevant to the assessment
type AssessmentLinks struct {
	// READ-ONLY; Link to assessment in Azure Portal
	AzurePortalURI *string `json:"azurePortalUri,omitempty" azure:"ro"`
}

// AssessmentList - Page of a security assessments list
type AssessmentList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Collection of security assessments in this page
	Value []*AssessmentResponse `json:"value,omitempty" azure:"ro"`
}

// AssessmentMetadata - Security assessment metadata
type AssessmentMetadata struct {
	// Describes properties of an assessment metadata.
	Properties *AssessmentMetadataProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssessmentMetadataPartnerData - Describes the partner that created the assessment
type AssessmentMetadataPartnerData struct {
	// REQUIRED; Name of the company of the partner
	PartnerName *string `json:"partnerName,omitempty"`

	// REQUIRED; Secret to authenticate the partner and verify it created the assessment - write only
	Secret *string `json:"secret,omitempty"`

	// Name of the product of the partner that created the assessment
	ProductName *string `json:"productName,omitempty"`
}

// AssessmentMetadataProperties - Describes properties of an assessment metadata.
type AssessmentMetadataProperties struct {
	// REQUIRED; BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom
	// Azure Policy definition
	AssessmentType *AssessmentType `json:"assessmentType,omitempty"`

	// REQUIRED; User friendly display name of the assessment
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; The severity level of the assessment
	Severity   *Severity     `json:"severity,omitempty"`
	Categories []*Categories `json:"categories,omitempty"`

	// Human readable description of the assessment
	Description *string `json:"description,omitempty"`

	// The implementation effort required to remediate this assessment
	ImplementationEffort *ImplementationEffort `json:"implementationEffort,omitempty"`

	// Describes the partner that created the assessment
	PartnerData *AssessmentMetadataPartnerData `json:"partnerData,omitempty"`

	// True if this assessment is in preview release status
	Preview *bool `json:"preview,omitempty"`

	// Human readable description of what you should do to mitigate this security issue
	RemediationDescription *string    `json:"remediationDescription,omitempty"`
	Threats                []*Threats `json:"threats,omitempty"`

	// The user impact of the assessment
	UserImpact *UserImpact `json:"userImpact,omitempty"`

	// READ-ONLY; Azure resource ID of the policy definition that turns this assessment calculation on
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty" azure:"ro"`
}

// AssessmentMetadataPropertiesResponse - Describes properties of an assessment metadata response.
type AssessmentMetadataPropertiesResponse struct {
	// REQUIRED; BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom
	// Azure Policy definition
	AssessmentType *AssessmentType `json:"assessmentType,omitempty"`

	// REQUIRED; User friendly display name of the assessment
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; The severity level of the assessment
	Severity   *Severity     `json:"severity,omitempty"`
	Categories []*Categories `json:"categories,omitempty"`

	// Human readable description of the assessment
	Description *string `json:"description,omitempty"`

	// The implementation effort required to remediate this assessment
	ImplementationEffort *ImplementationEffort `json:"implementationEffort,omitempty"`

	// Describes the partner that created the assessment
	PartnerData            *AssessmentMetadataPartnerData `json:"partnerData,omitempty"`
	PlannedDeprecationDate *string                        `json:"plannedDeprecationDate,omitempty"`

	// True if this assessment is in preview release status
	Preview      *bool                                             `json:"preview,omitempty"`
	PublishDates *AssessmentMetadataPropertiesResponsePublishDates `json:"publishDates,omitempty"`

	// Human readable description of what you should do to mitigate this security issue
	RemediationDescription *string       `json:"remediationDescription,omitempty"`
	Tactics                []*Tactics    `json:"tactics,omitempty"`
	Techniques             []*Techniques `json:"techniques,omitempty"`
	Threats                []*Threats    `json:"threats,omitempty"`

	// The user impact of the assessment
	UserImpact *UserImpact `json:"userImpact,omitempty"`

	// READ-ONLY; Azure resource ID of the policy definition that turns this assessment calculation on
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty" azure:"ro"`
}

type AssessmentMetadataPropertiesResponsePublishDates struct {
	// REQUIRED
	Public *string `json:"public,omitempty"`
	GA     *string `json:"GA,omitempty"`
}

// AssessmentMetadataResponse - Security assessment metadata response
type AssessmentMetadataResponse struct {
	// Describes properties of an assessment metadata response.
	Properties *AssessmentMetadataPropertiesResponse `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssessmentMetadataResponseList - List of security assessment metadata
type AssessmentMetadataResponseList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY
	Value []*AssessmentMetadataResponse `json:"value,omitempty" azure:"ro"`
}

// AssessmentPartnerData - Data regarding 3rd party partner integration
type AssessmentPartnerData struct {
	// REQUIRED; Name of the company of the partner
	PartnerName *string `json:"partnerName,omitempty"`

	// REQUIRED; secret to authenticate the partner - write only
	Secret *string `json:"secret,omitempty"`
}

// AssessmentProperties - Describes properties of an assessment.
type AssessmentProperties struct {
	// REQUIRED; Details of the resource that was assessed
	ResourceDetails ResourceDetailsClassification `json:"resourceDetails,omitempty"`

	// REQUIRED; The result of the assessment
	Status *AssessmentStatus `json:"status,omitempty"`

	// Additional data regarding the assessment
	AdditionalData map[string]*string `json:"additionalData,omitempty"`

	// Describes properties of an assessment metadata.
	Metadata *AssessmentMetadataProperties `json:"metadata,omitempty"`

	// Data regarding 3rd party partner integration
	PartnersData *AssessmentPartnerData `json:"partnersData,omitempty"`

	// READ-ONLY; User friendly display name of the assessment
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Links relevant to the assessment
	Links *AssessmentLinks `json:"links,omitempty" azure:"ro"`
}

// AssessmentPropertiesBase - Describes properties of an assessment.
type AssessmentPropertiesBase struct {
	// REQUIRED; Details of the resource that was assessed
	ResourceDetails ResourceDetailsClassification `json:"resourceDetails,omitempty"`

	// Additional data regarding the assessment
	AdditionalData map[string]*string `json:"additionalData,omitempty"`

	// Describes properties of an assessment metadata.
	Metadata *AssessmentMetadataProperties `json:"metadata,omitempty"`

	// Data regarding 3rd party partner integration
	PartnersData *AssessmentPartnerData `json:"partnersData,omitempty"`

	// READ-ONLY; User friendly display name of the assessment
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Links relevant to the assessment
	Links *AssessmentLinks `json:"links,omitempty" azure:"ro"`
}

// AssessmentPropertiesResponse - Describes properties of an assessment.
type AssessmentPropertiesResponse struct {
	// REQUIRED; Details of the resource that was assessed
	ResourceDetails ResourceDetailsClassification `json:"resourceDetails,omitempty"`

	// REQUIRED; The result of the assessment
	Status *AssessmentStatusResponse `json:"status,omitempty"`

	// Additional data regarding the assessment
	AdditionalData map[string]*string `json:"additionalData,omitempty"`

	// Describes properties of an assessment metadata.
	Metadata *AssessmentMetadataProperties `json:"metadata,omitempty"`

	// Data regarding 3rd party partner integration
	PartnersData *AssessmentPartnerData `json:"partnersData,omitempty"`

	// READ-ONLY; User friendly display name of the assessment
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Links relevant to the assessment
	Links *AssessmentLinks `json:"links,omitempty" azure:"ro"`
}

// AssessmentResponse - Security assessment on a resource - response format
type AssessmentResponse struct {
	// Describes properties of an assessment.
	Properties *AssessmentPropertiesResponse `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssessmentStatus - The result of the assessment
type AssessmentStatus struct {
	// REQUIRED; Programmatic code for the status of the assessment
	Code *AssessmentStatusCode `json:"code,omitempty"`

	// Programmatic code for the cause of the assessment status
	Cause *string `json:"cause,omitempty"`

	// Human readable description of the assessment status
	Description *string `json:"description,omitempty"`
}

// AssessmentStatusResponse - The result of the assessment
type AssessmentStatusResponse struct {
	// REQUIRED; Programmatic code for the status of the assessment
	Code *AssessmentStatusCode `json:"code,omitempty"`

	// Programmatic code for the cause of the assessment status
	Cause *string `json:"cause,omitempty"`

	// Human readable description of the assessment status
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The time that the assessment was created and first evaluated. Returned as UTC time in ISO 8601 format
	FirstEvaluationDate *time.Time `json:"firstEvaluationDate,omitempty" azure:"ro"`

	// READ-ONLY; The time that the status of the assessment last changed. Returned as UTC time in ISO 8601 format
	StatusChangeDate *time.Time `json:"statusChangeDate,omitempty" azure:"ro"`
}

// AssessmentsClientCreateOrUpdateOptions contains the optional parameters for the AssessmentsClient.CreateOrUpdate method.
type AssessmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AssessmentsClientDeleteOptions contains the optional parameters for the AssessmentsClient.Delete method.
type AssessmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AssessmentsClientGetOptions contains the optional parameters for the AssessmentsClient.Get method.
type AssessmentsClientGetOptions struct {
	// OData expand. Optional.
	Expand *ExpandEnum
}

// AssessmentsClientListOptions contains the optional parameters for the AssessmentsClient.List method.
type AssessmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// AssessmentsMetadataClientCreateInSubscriptionOptions contains the optional parameters for the AssessmentsMetadataClient.CreateInSubscription
// method.
type AssessmentsMetadataClientCreateInSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AssessmentsMetadataClientDeleteInSubscriptionOptions contains the optional parameters for the AssessmentsMetadataClient.DeleteInSubscription
// method.
type AssessmentsMetadataClientDeleteInSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AssessmentsMetadataClientGetInSubscriptionOptions contains the optional parameters for the AssessmentsMetadataClient.GetInSubscription
// method.
type AssessmentsMetadataClientGetInSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AssessmentsMetadataClientGetOptions contains the optional parameters for the AssessmentsMetadataClient.Get method.
type AssessmentsMetadataClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssessmentsMetadataClientListBySubscriptionOptions contains the optional parameters for the AssessmentsMetadataClient.ListBySubscription
// method.
type AssessmentsMetadataClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AssessmentsMetadataClientListOptions contains the optional parameters for the AssessmentsMetadataClient.List method.
type AssessmentsMetadataClientListOptions struct {
	// placeholder for future optional parameters
}

// AtaExternalSecuritySolution - Represents an ATA security solution which sends logs to an OMS workspace
type AtaExternalSecuritySolution struct {
	// The kind of the external solution
	Kind *ExternalSecuritySolutionKind `json:"kind,omitempty"`

	// The external security solution properties for ATA solutions
	Properties *AtaSolutionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AtaSolutionProperties - The external security solution properties for ATA solutions
type AtaSolutionProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
	DeviceType           *string `json:"deviceType,omitempty"`
	DeviceVendor         *string `json:"deviceVendor,omitempty"`
	LastEventReceived    *string `json:"lastEventReceived,omitempty"`

	// Represents an OMS workspace to which the solution is connected
	Workspace *ConnectedWorkspace `json:"workspace,omitempty"`
}

// AuthenticationDetailsPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetAuthenticationDetailsProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AuthenticationDetailsProperties, *AwAssumeRoleAuthenticationDetailsProperties, *AwsCredsAuthenticationDetailsProperties,
// - *GcpCredentialsDetailsProperties
type AuthenticationDetailsPropertiesClassification interface {
	// GetAuthenticationDetailsProperties returns the AuthenticationDetailsProperties content of the underlying type.
	GetAuthenticationDetailsProperties() *AuthenticationDetailsProperties
}

// AuthenticationDetailsProperties - Settings for cloud authentication management
type AuthenticationDetailsProperties struct {
	// REQUIRED; Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use
	// account organization credentials.
	AuthenticationType *AuthenticationType `json:"authenticationType,omitempty"`

	// READ-ONLY; State of the multi-cloud connector
	AuthenticationProvisioningState *AuthenticationProvisioningState `json:"authenticationProvisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions []*PermissionProperty `json:"grantedPermissions,omitempty" azure:"ro"`
}

// GetAuthenticationDetailsProperties implements the AuthenticationDetailsPropertiesClassification interface for type AuthenticationDetailsProperties.
func (a *AuthenticationDetailsProperties) GetAuthenticationDetailsProperties() *AuthenticationDetailsProperties {
	return a
}

// AutoProvisioningSetting - Auto provisioning setting
type AutoProvisioningSetting struct {
	// Auto provisioning setting data
	Properties *AutoProvisioningSettingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AutoProvisioningSettingList - List of all the auto provisioning settings response
type AutoProvisioningSettingList struct {
	// List of all the auto provisioning settings
	Value []*AutoProvisioningSetting `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AutoProvisioningSettingProperties - describes properties of an auto provisioning setting
type AutoProvisioningSettingProperties struct {
	// REQUIRED; Describes what kind of security agent provisioning action to take
	AutoProvision *AutoProvision `json:"autoProvision,omitempty"`
}

// AutoProvisioningSettingsClientCreateOptions contains the optional parameters for the AutoProvisioningSettingsClient.Create
// method.
type AutoProvisioningSettingsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// AutoProvisioningSettingsClientGetOptions contains the optional parameters for the AutoProvisioningSettingsClient.Get method.
type AutoProvisioningSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AutoProvisioningSettingsClientListOptions contains the optional parameters for the AutoProvisioningSettingsClient.List
// method.
type AutoProvisioningSettingsClientListOptions struct {
	// placeholder for future optional parameters
}

// Automation - The security automation resource.
type Automation struct {
	// Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`

	// Kind of the resource
	Kind *string `json:"kind,omitempty"`

	// Location where the resource is stored
	Location *string `json:"location,omitempty"`

	// Security automation data
	Properties *AutomationProperties `json:"properties,omitempty"`

	// A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AutomationActionClassification provides polymorphic access to related types.
// Call the interface's GetAutomationAction() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AutomationAction, *AutomationActionEventHub, *AutomationActionLogicApp, *AutomationActionWorkspace
type AutomationActionClassification interface {
	// GetAutomationAction returns the AutomationAction content of the underlying type.
	GetAutomationAction() *AutomationAction
}

// AutomationAction - The action that should be triggered.
type AutomationAction struct {
	// REQUIRED; The type of the action that will be triggered by the Automation
	ActionType *ActionType `json:"actionType,omitempty"`
}

// GetAutomationAction implements the AutomationActionClassification interface for type AutomationAction.
func (a *AutomationAction) GetAutomationAction() *AutomationAction { return a }

// AutomationActionEventHub - The target Event Hub to which event data will be exported. To learn more about Microsoft Defender
// for Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
type AutomationActionEventHub struct {
	// REQUIRED; The type of the action that will be triggered by the Automation
	ActionType *ActionType `json:"actionType,omitempty"`

	// The target Event Hub connection string (it will not be included in any response).
	ConnectionString *string `json:"connectionString,omitempty"`

	// The target Event Hub Azure Resource ID.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`

	// READ-ONLY; The target Event Hub SAS policy name.
	SasPolicyName *string `json:"sasPolicyName,omitempty" azure:"ro"`
}

// GetAutomationAction implements the AutomationActionClassification interface for type AutomationActionEventHub.
func (a *AutomationActionEventHub) GetAutomationAction() *AutomationAction {
	return &AutomationAction{
		ActionType: a.ActionType,
	}
}

// AutomationActionLogicApp - The logic app action that should be triggered. To learn more about Microsoft Defender for Cloud's
// Workflow Automation capabilities, visit https://aka.ms/ASCWorkflowAutomationLearnMore
type AutomationActionLogicApp struct {
	// REQUIRED; The type of the action that will be triggered by the Automation
	ActionType *ActionType `json:"actionType,omitempty"`

	// The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions
	// to trigger the Logic App
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`

	// The Logic App trigger URI endpoint (it will not be included in any response).
	URI *string `json:"uri,omitempty"`
}

// GetAutomationAction implements the AutomationActionClassification interface for type AutomationActionLogicApp.
func (a *AutomationActionLogicApp) GetAutomationAction() *AutomationAction {
	return &AutomationAction{
		ActionType: a.ActionType,
	}
}

// AutomationActionWorkspace - The Log Analytics Workspace to which event data will be exported. Security alerts data will
// reside in the 'SecurityAlert' table and the assessments data will reside in the 'SecurityRecommendation'
// table (under the 'Security'/'SecurityCenterFree' solutions). Note that in order to view the data in the workspace, the
// Security Center Log Analytics free/standard solution needs to be enabled on that
// workspace. To learn more about Microsoft Defender for Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
type AutomationActionWorkspace struct {
	// REQUIRED; The type of the action that will be triggered by the Automation
	ActionType *ActionType `json:"actionType,omitempty"`

	// The fully qualified Log Analytics Workspace Azure Resource ID.
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`
}

// GetAutomationAction implements the AutomationActionClassification interface for type AutomationActionWorkspace.
func (a *AutomationActionWorkspace) GetAutomationAction() *AutomationAction {
	return &AutomationAction{
		ActionType: a.ActionType,
	}
}

// AutomationList - List of security automations response.
type AutomationList struct {
	// REQUIRED; The list of security automations under the given scope.
	Value []*Automation `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AutomationProperties - A set of properties that defines the behavior of the automation configuration. To learn more about
// the supported security events data models schemas - please visit https://aka.ms/ASCAutomationSchemas.
type AutomationProperties struct {
	// A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set,
	// are true.
	Actions []AutomationActionClassification `json:"actions,omitempty"`

	// The security automation description.
	Description *string `json:"description,omitempty"`

	// Indicates whether the security automation is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself
	// or a resource group under that subscription. The automation will only apply on
	// defined scopes.
	Scopes []*AutomationScope `json:"scopes,omitempty"`

	// A collection of the source event types which evaluate the security automation set of rules.
	Sources []*AutomationSource `json:"sources,omitempty"`
}

// AutomationRuleSet - A rule set which evaluates all its rules upon an event interception. Only when all the included rules
// in the rule set will be evaluated as 'true', will the event trigger the defined actions.
type AutomationRuleSet struct {
	Rules []*AutomationTriggeringRule `json:"rules,omitempty"`
}

// AutomationScope - A single automation scope.
type AutomationScope struct {
	// The resources scope description.
	Description *string `json:"description,omitempty"`

	// The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that
	// subscription (fully qualified Azure resource IDs).
	ScopePath *string `json:"scopePath,omitempty"`
}

// AutomationSource - The source event types which evaluate the security automation set of rules. For example - security alerts
// and security assessments. To learn more about the supported security events data models
// schemas - please visit https://aka.ms/ASCAutomationSchemas.
type AutomationSource struct {
	// A valid event source type.
	EventSource *EventSource `json:"eventSource,omitempty"`

	// A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical
	// 'or').
	RuleSets []*AutomationRuleSet `json:"ruleSets,omitempty"`
}

// AutomationTriggeringRule - A rule which is evaluated upon event interception. The rule is configured by comparing a specific
// value from the event model to an expected value. This comparison is done by using one of the supported
// operators set.
type AutomationTriggeringRule struct {
	// The expected value.
	ExpectedValue *string `json:"expectedValue,omitempty"`

	// A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
	Operator *Operator `json:"operator,omitempty"`

	// The JPath of the entity model property that should be checked.
	PropertyJPath *string `json:"propertyJPath,omitempty"`

	// The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
	PropertyType *PropertyType `json:"propertyType,omitempty"`
}

// AutomationValidationStatus - The security automation model state property bag.
type AutomationValidationStatus struct {
	// Indicates whether the model is valid or not.
	IsValid *bool `json:"isValid,omitempty"`

	// The validation message.
	Message *string `json:"message,omitempty"`
}

// AutomationsClientCreateOrUpdateOptions contains the optional parameters for the AutomationsClient.CreateOrUpdate method.
type AutomationsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AutomationsClientDeleteOptions contains the optional parameters for the AutomationsClient.Delete method.
type AutomationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AutomationsClientGetOptions contains the optional parameters for the AutomationsClient.Get method.
type AutomationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AutomationsClientListByResourceGroupOptions contains the optional parameters for the AutomationsClient.ListByResourceGroup
// method.
type AutomationsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AutomationsClientListOptions contains the optional parameters for the AutomationsClient.List method.
type AutomationsClientListOptions struct {
	// placeholder for future optional parameters
}

// AutomationsClientValidateOptions contains the optional parameters for the AutomationsClient.Validate method.
type AutomationsClientValidateOptions struct {
	// placeholder for future optional parameters
}

// AwAssumeRoleAuthenticationDetailsProperties - AWS cloud account connector based assume role, the role enables delegating
// access to your AWS resources. The role is composed of role Amazon Resource Name (ARN) and external ID. For more details,
// refer to Creating a Role to Delegate Permissions to an IAM User (write only) [https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user.html]
type AwAssumeRoleAuthenticationDetailsProperties struct {
	// REQUIRED; Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use
	// account organization credentials.
	AuthenticationType *AuthenticationType `json:"authenticationType,omitempty"`

	// REQUIRED; Assumed role ID is an identifier that you can use to create temporary security credentials.
	AwsAssumeRoleArn *string `json:"awsAssumeRoleArn,omitempty"`

	// REQUIRED; A unique identifier that is required when you assume a role in another account.
	AwsExternalID *string `json:"awsExternalId,omitempty"`

	// READ-ONLY; The ID of the cloud account
	AccountID *string `json:"accountId,omitempty" azure:"ro"`

	// READ-ONLY; State of the multi-cloud connector
	AuthenticationProvisioningState *AuthenticationProvisioningState `json:"authenticationProvisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions []*PermissionProperty `json:"grantedPermissions,omitempty" azure:"ro"`
}

// GetAuthenticationDetailsProperties implements the AuthenticationDetailsPropertiesClassification interface for type AwAssumeRoleAuthenticationDetailsProperties.
func (a *AwAssumeRoleAuthenticationDetailsProperties) GetAuthenticationDetailsProperties() *AuthenticationDetailsProperties {
	return &AuthenticationDetailsProperties{
		AuthenticationProvisioningState: a.AuthenticationProvisioningState,
		GrantedPermissions:              a.GrantedPermissions,
		AuthenticationType:              a.AuthenticationType,
	}
}

// AwsCredsAuthenticationDetailsProperties - AWS cloud account connector based credentials, the credentials is composed of
// access key ID and secret key, for more details, refer to Creating an IAM User in Your AWS Account (write only)
// [https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html]
type AwsCredsAuthenticationDetailsProperties struct {
	// REQUIRED; Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use
	// account organization credentials.
	AuthenticationType *AuthenticationType `json:"authenticationType,omitempty"`

	// REQUIRED; Public key element of the AWS credential object (write only)
	AwsAccessKeyID *string `json:"awsAccessKeyId,omitempty"`

	// REQUIRED; Secret key element of the AWS credential object (write only)
	AwsSecretAccessKey *string `json:"awsSecretAccessKey,omitempty"`

	// READ-ONLY; The ID of the cloud account
	AccountID *string `json:"accountId,omitempty" azure:"ro"`

	// READ-ONLY; State of the multi-cloud connector
	AuthenticationProvisioningState *AuthenticationProvisioningState `json:"authenticationProvisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions []*PermissionProperty `json:"grantedPermissions,omitempty" azure:"ro"`
}

// GetAuthenticationDetailsProperties implements the AuthenticationDetailsPropertiesClassification interface for type AwsCredsAuthenticationDetailsProperties.
func (a *AwsCredsAuthenticationDetailsProperties) GetAuthenticationDetailsProperties() *AuthenticationDetailsProperties {
	return &AuthenticationDetailsProperties{
		AuthenticationProvisioningState: a.AuthenticationProvisioningState,
		GrantedPermissions:              a.GrantedPermissions,
		AuthenticationType:              a.AuthenticationType,
	}
}

// AwsEnvironmentData - The aws connector environment data
type AwsEnvironmentData struct {
	// REQUIRED; The type of the environment data.
	EnvironmentType *EnvironmentType `json:"environmentType,omitempty"`

	// The AWS account's organizational data
	OrganizationalData AwsOrganizationalDataClassification `json:"organizationalData,omitempty"`
}

// GetEnvironmentData implements the EnvironmentDataClassification interface for type AwsEnvironmentData.
func (a *AwsEnvironmentData) GetEnvironmentData() *EnvironmentData {
	return &EnvironmentData{
		EnvironmentType: a.EnvironmentType,
	}
}

// AwsOrganizationalDataClassification provides polymorphic access to related types.
// Call the interface's GetAwsOrganizationalData() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AwsOrganizationalData, *AwsOrganizationalDataMaster, *AwsOrganizationalDataMember
type AwsOrganizationalDataClassification interface {
	// GetAwsOrganizationalData returns the AwsOrganizationalData content of the underlying type.
	GetAwsOrganizationalData() *AwsOrganizationalData
}

// AwsOrganizationalData - The awsOrganization data
type AwsOrganizationalData struct {
	// REQUIRED; The multi cloud account's membership type in the organization
	OrganizationMembershipType *OrganizationMembershipType `json:"organizationMembershipType,omitempty"`
}

// GetAwsOrganizationalData implements the AwsOrganizationalDataClassification interface for type AwsOrganizationalData.
func (a *AwsOrganizationalData) GetAwsOrganizationalData() *AwsOrganizationalData { return a }

// AwsOrganizationalDataMaster - The awsOrganization data for the master account
type AwsOrganizationalDataMaster struct {
	// REQUIRED; The multi cloud account's membership type in the organization
	OrganizationMembershipType *OrganizationMembershipType `json:"organizationMembershipType,omitempty"`

	// If the multi cloud account is of membership type organization, list of accounts excluded from offering
	ExcludedAccountIDs []*string `json:"excludedAccountIds,omitempty"`

	// If the multi cloud account is of membership type organization, this will be the name of the onboarding stackset
	StacksetName *string `json:"stacksetName,omitempty"`
}

// GetAwsOrganizationalData implements the AwsOrganizationalDataClassification interface for type AwsOrganizationalDataMaster.
func (a *AwsOrganizationalDataMaster) GetAwsOrganizationalData() *AwsOrganizationalData {
	return &AwsOrganizationalData{
		OrganizationMembershipType: a.OrganizationMembershipType,
	}
}

// AwsOrganizationalDataMember - The awsOrganization data for the member account
type AwsOrganizationalDataMember struct {
	// REQUIRED; The multi cloud account's membership type in the organization
	OrganizationMembershipType *OrganizationMembershipType `json:"organizationMembershipType,omitempty"`

	// If the multi cloud account is not of membership type organization, this will be the ID of the account's parent
	ParentHierarchyID *string `json:"parentHierarchyId,omitempty"`
}

// GetAwsOrganizationalData implements the AwsOrganizationalDataClassification interface for type AwsOrganizationalDataMember.
func (a *AwsOrganizationalDataMember) GetAwsOrganizationalData() *AwsOrganizationalData {
	return &AwsOrganizationalData{
		OrganizationMembershipType: a.OrganizationMembershipType,
	}
}

// AzureDevOpsScopeEnvironmentData - The AzureDevOps scope connector's environment data
type AzureDevOpsScopeEnvironmentData struct {
	// REQUIRED; The type of the environment data.
	EnvironmentType *EnvironmentType `json:"environmentType,omitempty"`
}

// GetEnvironmentData implements the EnvironmentDataClassification interface for type AzureDevOpsScopeEnvironmentData.
func (a *AzureDevOpsScopeEnvironmentData) GetEnvironmentData() *EnvironmentData {
	return &EnvironmentData{
		EnvironmentType: a.EnvironmentType,
	}
}

// AzureResourceDetails - Details of the Azure resource that was assessed
type AzureResourceDetails struct {
	// REQUIRED; The platform where the assessed resource resides
	Source *Source `json:"source,omitempty"`

	// READ-ONLY; Azure resource Id of the assessed resource
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GetResourceDetails implements the ResourceDetailsClassification interface for type AzureResourceDetails.
func (a *AzureResourceDetails) GetResourceDetails() *ResourceDetails {
	return &ResourceDetails{
		Source: a.Source,
	}
}

// AzureResourceIdentifier - Azure resource identifier.
type AzureResourceIdentifier struct {
	// REQUIRED; There can be multiple identifiers of different type per alert, this field specify the identifier type.
	Type *ResourceIdentifierType `json:"type,omitempty"`

	// READ-ONLY; ARM resource identifier for the cloud resource being alerted on
	AzureResourceID *string `json:"azureResourceId,omitempty" azure:"ro"`
}

// GetResourceIdentifier implements the ResourceIdentifierClassification interface for type AzureResourceIdentifier.
func (a *AzureResourceIdentifier) GetResourceIdentifier() *ResourceIdentifier {
	return &ResourceIdentifier{
		Type: a.Type,
	}
}

// AzureResourceLink - Describes an Azure resource with kind
type AzureResourceLink struct {
	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`
}

// AzureTrackedResourceLocation - Describes an Azure resource with location
type AzureTrackedResourceLocation struct {
	// Location where the resource is stored
	Location *string `json:"location,omitempty"`
}

// Baseline details.
type Baseline struct {
	// Expected results.
	ExpectedResults [][]*string `json:"expectedResults,omitempty"`

	// Baseline update time (UTC).
	UpdatedTime *time.Time `json:"updatedTime,omitempty"`
}

// BaselineAdjustedResult - The rule result adjusted with baseline.
type BaselineAdjustedResult struct {
	// Baseline details.
	Baseline *Baseline `json:"baseline,omitempty"`

	// Results the are not in baseline.
	ResultsNotInBaseline [][]*string `json:"resultsNotInBaseline,omitempty"`

	// Results the are in baseline.
	ResultsOnlyInBaseline [][]*string `json:"resultsOnlyInBaseline,omitempty"`

	// The rule result status.
	Status *RuleStatus `json:"status,omitempty"`
}

// BenchmarkReference - The benchmark references.
type BenchmarkReference struct {
	// The benchmark name.
	Benchmark *string `json:"benchmark,omitempty"`

	// The benchmark reference.
	Reference *string `json:"reference,omitempty"`
}

// CVE details
type CVE struct {
	// READ-ONLY; Link url
	Link *string `json:"link,omitempty" azure:"ro"`

	// READ-ONLY; CVE title
	Title *string `json:"title,omitempty" azure:"ro"`
}

// CVSS details
type CVSS struct {
	// READ-ONLY; CVSS base
	Base *float32 `json:"base,omitempty" azure:"ro"`
}

// CefExternalSecuritySolution - Represents a security solution which sends CEF logs to an OMS workspace
type CefExternalSecuritySolution struct {
	// The kind of the external solution
	Kind *ExternalSecuritySolutionKind `json:"kind,omitempty"`

	// The external security solution properties for CEF solutions
	Properties *CefSolutionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CefSolutionProperties - The external security solution properties for CEF solutions
type CefSolutionProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
	Agent                *string `json:"agent,omitempty"`
	DeviceType           *string `json:"deviceType,omitempty"`
	DeviceVendor         *string `json:"deviceVendor,omitempty"`
	Hostname             *string `json:"hostname,omitempty"`
	LastEventReceived    *string `json:"lastEventReceived,omitempty"`

	// Represents an OMS workspace to which the solution is connected
	Workspace *ConnectedWorkspace `json:"workspace,omitempty"`
}

// CloudOfferingClassification provides polymorphic access to related types.
// Call the interface's GetCloudOffering() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CloudOffering, *CspmMonitorAwsOffering, *CspmMonitorAzureDevOpsOffering, *CspmMonitorGcpOffering, *CspmMonitorGithubOffering,
// - *DefenderCspmAwsOffering, *DefenderCspmGcpOffering, *DefenderFoDatabasesAwsOffering, *DefenderForContainersAwsOffering,
// - *DefenderForContainersGcpOffering, *DefenderForDatabasesGcpOffering, *DefenderForDevOpsAzureDevOpsOffering, *DefenderForDevOpsGithubOffering,
// - *DefenderForServersAwsOffering, *DefenderForServersGcpOffering, *InformationProtectionAwsOffering
type CloudOfferingClassification interface {
	// GetCloudOffering returns the CloudOffering content of the underlying type.
	GetCloudOffering() *CloudOffering
}

// CloudOffering - The security offering details
type CloudOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type CloudOffering.
func (c *CloudOffering) GetCloudOffering() *CloudOffering { return c }

// Compliance of a scope
type Compliance struct {
	// Compliance data
	Properties *ComplianceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ComplianceList - List of Compliance objects response
type ComplianceList struct {
	// List of Compliance objects
	Value []*Compliance `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ComplianceProperties - The Compliance score (percentage) of a Subscription is a sum of all Resources' Compliances under
// the given Subscription. A Resource Compliance is defined as the compliant ('healthy') Policy
// Definitions out of all Policy Definitions applicable to a given resource.
type ComplianceProperties struct {
	// READ-ONLY; An array of segment, which is the actually the compliance assessment.
	AssessmentResult []*ComplianceSegment `json:"assessmentResult,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp when the Compliance calculation was conducted.
	AssessmentTimestampUTCDate *time.Time `json:"assessmentTimestampUtcDate,omitempty" azure:"ro"`

	// READ-ONLY; The resource count of the given subscription for which the Compliance calculation was conducted (needed for
	// Management Group Compliance calculation).
	ResourceCount *int32 `json:"resourceCount,omitempty" azure:"ro"`
}

// ComplianceResult - a compliance result
type ComplianceResult struct {
	// Compliance result data
	Properties *ComplianceResultProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ComplianceResultList - List of compliance results response
type ComplianceResultList struct {
	// REQUIRED; List of compliance results
	Value []*ComplianceResult `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ComplianceResultProperties - Compliance result data
type ComplianceResultProperties struct {
	// READ-ONLY; The status of the resource regarding a single assessment
	ResourceStatus *ResourceStatus `json:"resourceStatus,omitempty" azure:"ro"`
}

// ComplianceResultsClientGetOptions contains the optional parameters for the ComplianceResultsClient.Get method.
type ComplianceResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ComplianceResultsClientListOptions contains the optional parameters for the ComplianceResultsClient.List method.
type ComplianceResultsClientListOptions struct {
	// placeholder for future optional parameters
}

// ComplianceSegment - A segment of a compliance assessment.
type ComplianceSegment struct {
	// READ-ONLY; The size (%) of the segment.
	Percentage *float64 `json:"percentage,omitempty" azure:"ro"`

	// READ-ONLY; The segment type, e.g. compliant, non-compliance, insufficient coverage, N/A, etc.
	SegmentType *string `json:"segmentType,omitempty" azure:"ro"`
}

// CompliancesClientGetOptions contains the optional parameters for the CompliancesClient.Get method.
type CompliancesClientGetOptions struct {
	// placeholder for future optional parameters
}

// CompliancesClientListOptions contains the optional parameters for the CompliancesClient.List method.
type CompliancesClientListOptions struct {
	// placeholder for future optional parameters
}

// Condition - Governance rule's condition
type Condition struct {
	// The governance rule Condition's Operator, for example Equals for severity or In for list of assessments, see examples
	Operator *GovernanceRuleConditionOperator `json:"operator,omitempty"`

	// The governance rule Condition's Property, e.g. Severity or AssessmentKey, see examples
	Property *string `json:"property,omitempty"`

	// The governance rule Condition's Value like severity Low, High or assessments keys, see examples
	Value *string `json:"value,omitempty"`
}

// ConnectableResource - Describes the allowed inbound and outbound traffic of an Azure resource
type ConnectableResource struct {
	// READ-ONLY; The Azure resource id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The list of Azure resources that the resource has inbound allowed connection from
	InboundConnectedResources []*ConnectedResource `json:"inboundConnectedResources,omitempty" azure:"ro"`

	// READ-ONLY; The list of Azure resources that the resource has outbound allowed connection to
	OutboundConnectedResources []*ConnectedResource `json:"outboundConnectedResources,omitempty" azure:"ro"`
}

// ConnectedResource - Describes properties of a connected resource
type ConnectedResource struct {
	// READ-ONLY; The Azure resource id of the connected resource
	ConnectedResourceID *string `json:"connectedResourceId,omitempty" azure:"ro"`

	// READ-ONLY; The allowed tcp ports
	TCPPorts *string `json:"tcpPorts,omitempty" azure:"ro"`

	// READ-ONLY; The allowed udp ports
	UDPPorts *string `json:"udpPorts,omitempty" azure:"ro"`
}

// ConnectedWorkspace - Represents an OMS workspace to which the solution is connected
type ConnectedWorkspace struct {
	// Azure resource ID of the connected OMS workspace
	ID *string `json:"id,omitempty"`
}

// ConnectionFromIPNotAllowed - Inbound connection from an ip that isn't allowed. Allow list consists of ipv4 or ipv6 range
// in CIDR notation.
type ConnectionFromIPNotAllowed struct {
	// REQUIRED; The values to allow. The format of the values depends on the rule type.
	AllowlistValues []*string `json:"allowlistValues,omitempty"`

	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType `json:"valueType,omitempty" azure:"ro"`
}

// GetAllowlistCustomAlertRule implements the AllowlistCustomAlertRuleClassification interface for type ConnectionFromIPNotAllowed.
func (c *ConnectionFromIPNotAllowed) GetAllowlistCustomAlertRule() *AllowlistCustomAlertRule {
	return &AllowlistCustomAlertRule{
		AllowlistValues: c.AllowlistValues,
		ValueType:       c.ValueType,
		DisplayName:     c.DisplayName,
		Description:     c.Description,
		IsEnabled:       c.IsEnabled,
		RuleType:        c.RuleType,
	}
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type ConnectionFromIPNotAllowed.
func (c *ConnectionFromIPNotAllowed) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: c.DisplayName,
		Description: c.Description,
		IsEnabled:   c.IsEnabled,
		RuleType:    c.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type ConnectionFromIPNotAllowed.
func (c *ConnectionFromIPNotAllowed) GetListCustomAlertRule() *ListCustomAlertRule {
	return &ListCustomAlertRule{
		ValueType:   c.ValueType,
		DisplayName: c.DisplayName,
		Description: c.Description,
		IsEnabled:   c.IsEnabled,
		RuleType:    c.RuleType,
	}
}

// ConnectionStrings - Connection string for ingesting security data and logs
type ConnectionStrings struct {
	// REQUIRED; Connection strings
	Value []*IngestionConnectionString `json:"value,omitempty"`
}

// ConnectionToIPNotAllowed - Outbound connection to an ip that isn't allowed. Allow list consists of ipv4 or ipv6 range in
// CIDR notation.
type ConnectionToIPNotAllowed struct {
	// REQUIRED; The values to allow. The format of the values depends on the rule type.
	AllowlistValues []*string `json:"allowlistValues,omitempty"`

	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType `json:"valueType,omitempty" azure:"ro"`
}

// GetAllowlistCustomAlertRule implements the AllowlistCustomAlertRuleClassification interface for type ConnectionToIPNotAllowed.
func (c *ConnectionToIPNotAllowed) GetAllowlistCustomAlertRule() *AllowlistCustomAlertRule {
	return &AllowlistCustomAlertRule{
		AllowlistValues: c.AllowlistValues,
		ValueType:       c.ValueType,
		DisplayName:     c.DisplayName,
		Description:     c.Description,
		IsEnabled:       c.IsEnabled,
		RuleType:        c.RuleType,
	}
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type ConnectionToIPNotAllowed.
func (c *ConnectionToIPNotAllowed) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: c.DisplayName,
		Description: c.Description,
		IsEnabled:   c.IsEnabled,
		RuleType:    c.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type ConnectionToIPNotAllowed.
func (c *ConnectionToIPNotAllowed) GetListCustomAlertRule() *ListCustomAlertRule {
	return &ListCustomAlertRule{
		ValueType:   c.ValueType,
		DisplayName: c.DisplayName,
		Description: c.Description,
		IsEnabled:   c.IsEnabled,
		RuleType:    c.RuleType,
	}
}

// Connector - The security connector resource.
type Connector struct {
	// Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`

	// Kind of the resource
	Kind *string `json:"kind,omitempty"`

	// Location where the resource is stored
	Location *string `json:"location,omitempty"`

	// Security connector data
	Properties *ConnectorProperties `json:"properties,omitempty"`

	// A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectorApplicationClientCreateOrUpdateOptions contains the optional parameters for the ConnectorApplicationClient.CreateOrUpdate
// method.
type ConnectorApplicationClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectorApplicationClientDeleteOptions contains the optional parameters for the ConnectorApplicationClient.Delete method.
type ConnectorApplicationClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConnectorApplicationClientGetOptions contains the optional parameters for the ConnectorApplicationClient.Get method.
type ConnectorApplicationClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectorApplicationsClientListOptions contains the optional parameters for the ConnectorApplicationsClient.List method.
type ConnectorApplicationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ConnectorGovernanceRuleClientListOptions contains the optional parameters for the ConnectorGovernanceRuleClient.List method.
type ConnectorGovernanceRuleClientListOptions struct {
	// placeholder for future optional parameters
}

// ConnectorGovernanceRulesClientCreateOrUpdateOptions contains the optional parameters for the ConnectorGovernanceRulesClient.CreateOrUpdate
// method.
type ConnectorGovernanceRulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectorGovernanceRulesClientDeleteOptions contains the optional parameters for the ConnectorGovernanceRulesClient.Delete
// method.
type ConnectorGovernanceRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConnectorGovernanceRulesClientGetOptions contains the optional parameters for the ConnectorGovernanceRulesClient.Get method.
type ConnectorGovernanceRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectorGovernanceRulesExecuteStatusClientBeginGetOptions contains the optional parameters for the ConnectorGovernanceRulesExecuteStatusClient.BeginGet
// method.
type ConnectorGovernanceRulesExecuteStatusClientBeginGetOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectorProperties - A set of properties that defines the security connector configuration.
type ConnectorProperties struct {
	// The security connector environment data.
	EnvironmentData EnvironmentDataClassification `json:"environmentData,omitempty"`

	// The multi cloud resource's cloud name.
	EnvironmentName *CloudName `json:"environmentName,omitempty"`

	// The multi cloud resource identifier (account id in case of AWS connector, project number in case of GCP connector).
	HierarchyIdentifier *string `json:"hierarchyIdentifier,omitempty"`

	// A collection of offerings for the security connector.
	Offerings []CloudOfferingClassification `json:"offerings,omitempty"`

	// READ-ONLY; The date on which the trial period will end, if applicable. Trial period exists for 30 days after upgrading
	// to payed offerings.
	HierarchyIdentifierTrialEndDate *time.Time `json:"hierarchyIdentifierTrialEndDate,omitempty" azure:"ro"`
}

// ConnectorSetting - The connector setting
type ConnectorSetting struct {
	// Connector setting data
	Properties *ConnectorSettingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectorSettingList - For a subscription, list of all cloud account connectors and their settings
type ConnectorSettingList struct {
	// List of all the cloud account connector settings
	Value []*ConnectorSetting `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ConnectorSettingProperties - Describes properties of a connector setting
type ConnectorSettingProperties struct {
	// Settings for authentication management, these settings are relevant only for the cloud connector.
	AuthenticationDetails AuthenticationDetailsPropertiesClassification `json:"authenticationDetails,omitempty"`

	// Settings for hybrid compute management. These settings are relevant only for Arc autoProvision (Hybrid Compute).
	HybridComputeSettings *HybridComputeSettingsProperties `json:"hybridComputeSettings,omitempty"`
}

// ConnectorsClientCreateOrUpdateOptions contains the optional parameters for the ConnectorsClient.CreateOrUpdate method.
type ConnectorsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectorsClientDeleteOptions contains the optional parameters for the ConnectorsClient.Delete method.
type ConnectorsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConnectorsClientGetOptions contains the optional parameters for the ConnectorsClient.Get method.
type ConnectorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectorsClientListByResourceGroupOptions contains the optional parameters for the ConnectorsClient.ListByResourceGroup
// method.
type ConnectorsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ConnectorsClientListOptions contains the optional parameters for the ConnectorsClient.List method.
type ConnectorsClientListOptions struct {
	// placeholder for future optional parameters
}

// ConnectorsClientUpdateOptions contains the optional parameters for the ConnectorsClient.Update method.
type ConnectorsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectorsList - List of security connectors response.
type ConnectorsList struct {
	// REQUIRED; The list of security connectors under the given scope.
	Value []*Connector `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// Contact details and configurations for notifications coming from Microsoft Defender for Cloud.
type Contact struct {
	// Security contact data
	Properties *ContactProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContactList - List of security contacts response
type ContactList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of security contacts
	Value []*Contact `json:"value,omitempty" azure:"ro"`
}

// ContactProperties - Describes security contact properties
type ContactProperties struct {
	// Defines whether to send email notifications about new security alerts
	AlertNotifications *ContactPropertiesAlertNotifications `json:"alertNotifications,omitempty"`

	// List of email addresses which will get notifications from Microsoft Defender for Cloud by the configurations defined in
	// this security contact.
	Emails *string `json:"emails,omitempty"`

	// Defines whether to send email notifications from Microsoft Defender for Cloud to persons with specific RBAC roles on the
	// subscription.
	NotificationsByRole *ContactPropertiesNotificationsByRole `json:"notificationsByRole,omitempty"`

	// The security contact's phone number
	Phone *string `json:"phone,omitempty"`
}

// ContactPropertiesAlertNotifications - Defines whether to send email notifications about new security alerts
type ContactPropertiesAlertNotifications struct {
	// Defines the minimal alert severity which will be sent as email notifications
	MinimalSeverity *MinimalSeverity `json:"minimalSeverity,omitempty"`

	// Defines if email notifications will be sent about new security alerts
	State *State `json:"state,omitempty"`
}

// ContactPropertiesNotificationsByRole - Defines whether to send email notifications from Microsoft Defender for Cloud to
// persons with specific RBAC roles on the subscription.
type ContactPropertiesNotificationsByRole struct {
	// Defines which RBAC roles will get email notifications from Microsoft Defender for Cloud. List of allowed RBAC roles:
	Roles []*Roles `json:"roles,omitempty"`

	// Defines whether to send email notifications from AMicrosoft Defender for Cloud to persons with specific RBAC roles on the
	// subscription.
	State *State `json:"state,omitempty"`
}

// ContactsClientCreateOptions contains the optional parameters for the ContactsClient.Create method.
type ContactsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// ContactsClientDeleteOptions contains the optional parameters for the ContactsClient.Delete method.
type ContactsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ContactsClientGetOptions contains the optional parameters for the ContactsClient.Get method.
type ContactsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContactsClientListOptions contains the optional parameters for the ContactsClient.List method.
type ContactsClientListOptions struct {
	// placeholder for future optional parameters
}

// ContainerRegistryVulnerabilityProperties - Additional context fields for container registry Vulnerability assessment
type ContainerRegistryVulnerabilityProperties struct {
	// REQUIRED; Sub-assessment resource type
	AssessedResourceType *AssessedResourceType `json:"assessedResourceType,omitempty"`

	// READ-ONLY; List of CVEs
	Cve []*CVE `json:"cve,omitempty" azure:"ro"`

	// READ-ONLY; Dictionary from cvss version to cvss details object
	Cvss map[string]*CVSS `json:"cvss,omitempty" azure:"ro"`

	// READ-ONLY; Digest of the vulnerable image
	ImageDigest *string `json:"imageDigest,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether a patch is available or not
	Patchable *bool `json:"patchable,omitempty" azure:"ro"`

	// READ-ONLY; Published time
	PublishedTime *time.Time `json:"publishedTime,omitempty" azure:"ro"`

	// READ-ONLY; Name of the repository which the vulnerable image belongs to
	RepositoryName *string `json:"repositoryName,omitempty" azure:"ro"`

	// READ-ONLY; Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered, Vulnerability
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY
	VendorReferences []*VendorReference `json:"vendorReferences,omitempty" azure:"ro"`
}

// GetAdditionalData implements the AdditionalDataClassification interface for type ContainerRegistryVulnerabilityProperties.
func (c *ContainerRegistryVulnerabilityProperties) GetAdditionalData() *AdditionalData {
	return &AdditionalData{
		AssessedResourceType: c.AssessedResourceType,
	}
}

// CspmMonitorAwsOffering - The CSPM monitoring for AWS offering
type CspmMonitorAwsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// The native cloud connection configuration
	NativeCloudConnection *CspmMonitorAwsOfferingNativeCloudConnection `json:"nativeCloudConnection,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type CspmMonitorAwsOffering.
func (c *CspmMonitorAwsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: c.OfferingType,
		Description:  c.Description,
	}
}

// CspmMonitorAwsOfferingNativeCloudConnection - The native cloud connection configuration
type CspmMonitorAwsOfferingNativeCloudConnection struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// CspmMonitorAzureDevOpsOffering - The CSPM monitoring for AzureDevOps offering
type CspmMonitorAzureDevOpsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type CspmMonitorAzureDevOpsOffering.
func (c *CspmMonitorAzureDevOpsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: c.OfferingType,
		Description:  c.Description,
	}
}

// CspmMonitorGcpOffering - The CSPM monitoring for GCP offering
type CspmMonitorGcpOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// The native cloud connection configuration
	NativeCloudConnection *CspmMonitorGcpOfferingNativeCloudConnection `json:"nativeCloudConnection,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type CspmMonitorGcpOffering.
func (c *CspmMonitorGcpOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: c.OfferingType,
		Description:  c.Description,
	}
}

// CspmMonitorGcpOfferingNativeCloudConnection - The native cloud connection configuration
type CspmMonitorGcpOfferingNativeCloudConnection struct {
	// The service account email address in GCP for this offering
	ServiceAccountEmailAddress *string `json:"serviceAccountEmailAddress,omitempty"`

	// The GCP workload identity provider id for the offering
	WorkloadIdentityProviderID *string `json:"workloadIdentityProviderId,omitempty"`
}

// CspmMonitorGithubOffering - The CSPM monitoring for github offering
type CspmMonitorGithubOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type CspmMonitorGithubOffering.
func (c *CspmMonitorGithubOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: c.OfferingType,
		Description:  c.Description,
	}
}

// CustomAlertRuleClassification provides polymorphic access to related types.
// Call the interface's GetCustomAlertRule() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ActiveConnectionsNotInAllowedRange, *AllowlistCustomAlertRule, *AmqpC2DMessagesNotInAllowedRange, *AmqpC2DRejectedMessagesNotInAllowedRange,
// - *AmqpD2CMessagesNotInAllowedRange, *ConnectionFromIPNotAllowed, *ConnectionToIPNotAllowed, *CustomAlertRule, *DenylistCustomAlertRule,
// - *DirectMethodInvokesNotInAllowedRange, *FailedLocalLoginsNotInAllowedRange, *FileUploadsNotInAllowedRange, *HTTPC2DMessagesNotInAllowedRange,
// - *HTTPC2DRejectedMessagesNotInAllowedRange, *HTTPD2CMessagesNotInAllowedRange, *ListCustomAlertRule, *LocalUserNotAllowed,
// - *MqttC2DMessagesNotInAllowedRange, *MqttC2DRejectedMessagesNotInAllowedRange, *MqttD2CMessagesNotInAllowedRange, *ProcessNotAllowed,
// - *QueuePurgesNotInAllowedRange, *ThresholdCustomAlertRule, *TimeWindowCustomAlertRule, *TwinUpdatesNotInAllowedRange,
// - *UnauthorizedOperationsNotInAllowedRange
type CustomAlertRuleClassification interface {
	// GetCustomAlertRule returns the CustomAlertRule content of the underlying type.
	GetCustomAlertRule() *CustomAlertRule
}

// CustomAlertRule - A custom alert rule.
type CustomAlertRule struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type CustomAlertRule.
func (c *CustomAlertRule) GetCustomAlertRule() *CustomAlertRule { return c }

// CustomAssessmentAutomation - Custom Assessment Automation
type CustomAssessmentAutomation struct {
	// describes Custom Assessment Automation properties.
	Properties *CustomAssessmentAutomationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomAssessmentAutomationProperties - describes the Custom Assessment Automation properties
type CustomAssessmentAutomationProperties struct {
	// The assessment metadata key used when an assessment is generated for this assessment automation.
	AssessmentKey *string `json:"assessmentKey,omitempty"`

	// GZip encoded KQL query representing the assessment automation results required.
	CompressedQuery *string `json:"compressedQuery,omitempty"`

	// The description to relate to the assessments generated by this assessment automation.
	Description *string `json:"description,omitempty"`

	// The display name of the assessments generated by this assessment automation.
	DisplayName *string `json:"displayName,omitempty"`

	// The remediation description to relate to the assessments generated by this assessment automation.
	RemediationDescription *string `json:"remediationDescription,omitempty"`

	// The severity to relate to the assessments generated by this assessment automation.
	Severity *SeverityEnum `json:"severity,omitempty"`

	// Relevant cloud for the custom assessment automation.
	SupportedCloud *SupportedCloudEnum `json:"supportedCloud,omitempty"`
}

// CustomAssessmentAutomationRequest - Custom Assessment Automation request
type CustomAssessmentAutomationRequest struct {
	// describes Custom Assessment Automation request properties.
	Properties *CustomAssessmentAutomationRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomAssessmentAutomationRequestProperties - describes the Custom Assessment Automation properties
type CustomAssessmentAutomationRequestProperties struct {
	// Base 64 encoded KQL query representing the assessment automation results required.
	CompressedQuery *string `json:"compressedQuery,omitempty"`

	// The description to relate to the assessments generated by this assessment automation.
	Description *string `json:"description,omitempty"`

	// The display name of the assessments generated by this assessment automation.
	DisplayName *string `json:"displayName,omitempty"`

	// The remediation description to relate to the assessments generated by this assessment automation.
	RemediationDescription *string `json:"remediationDescription,omitempty"`

	// The severity to relate to the assessments generated by this assessment automation.
	Severity *SeverityEnum `json:"severity,omitempty"`

	// Relevant cloud for the custom assessment automation.
	SupportedCloud *SupportedCloudEnum `json:"supportedCloud,omitempty"`
}

// CustomAssessmentAutomationsClientCreateOptions contains the optional parameters for the CustomAssessmentAutomationsClient.Create
// method.
type CustomAssessmentAutomationsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// CustomAssessmentAutomationsClientDeleteOptions contains the optional parameters for the CustomAssessmentAutomationsClient.Delete
// method.
type CustomAssessmentAutomationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CustomAssessmentAutomationsClientGetOptions contains the optional parameters for the CustomAssessmentAutomationsClient.Get
// method.
type CustomAssessmentAutomationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CustomAssessmentAutomationsClientListByResourceGroupOptions contains the optional parameters for the CustomAssessmentAutomationsClient.ListByResourceGroup
// method.
type CustomAssessmentAutomationsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// CustomAssessmentAutomationsClientListBySubscriptionOptions contains the optional parameters for the CustomAssessmentAutomationsClient.ListBySubscription
// method.
type CustomAssessmentAutomationsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// CustomAssessmentAutomationsListResult - A list of Custom Assessment Automations
type CustomAssessmentAutomationsListResult struct {
	// The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Collection of Custom Assessment Automations
	Value []*CustomAssessmentAutomation `json:"value,omitempty" azure:"ro"`
}

// CustomEntityStoreAssignment - Custom entity store assignment
type CustomEntityStoreAssignment struct {
	// describes custom entity store assignment properties.
	Properties *CustomEntityStoreAssignmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomEntityStoreAssignmentProperties - describes the custom entity store assignment properties
type CustomEntityStoreAssignmentProperties struct {
	// The link to entity store database.
	EntityStoreDatabaseLink *string `json:"entityStoreDatabaseLink,omitempty"`

	// The principal assigned with entity store. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
	Principal *string `json:"principal,omitempty"`
}

// CustomEntityStoreAssignmentRequest - describes the custom entity store assignment request
type CustomEntityStoreAssignmentRequest struct {
	// describes properties of custom entity store assignment request
	Properties *CustomEntityStoreAssignmentRequestProperties `json:"properties,omitempty"`
}

// CustomEntityStoreAssignmentRequestProperties - describes properties of custom entity store assignment request
type CustomEntityStoreAssignmentRequestProperties struct {
	// The principal assigned with entity store. If not provided, will use caller principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
	Principal *string `json:"principal,omitempty"`
}

// CustomEntityStoreAssignmentsClientCreateOptions contains the optional parameters for the CustomEntityStoreAssignmentsClient.Create
// method.
type CustomEntityStoreAssignmentsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// CustomEntityStoreAssignmentsClientDeleteOptions contains the optional parameters for the CustomEntityStoreAssignmentsClient.Delete
// method.
type CustomEntityStoreAssignmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CustomEntityStoreAssignmentsClientGetOptions contains the optional parameters for the CustomEntityStoreAssignmentsClient.Get
// method.
type CustomEntityStoreAssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CustomEntityStoreAssignmentsClientListByResourceGroupOptions contains the optional parameters for the CustomEntityStoreAssignmentsClient.ListByResourceGroup
// method.
type CustomEntityStoreAssignmentsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// CustomEntityStoreAssignmentsClientListBySubscriptionOptions contains the optional parameters for the CustomEntityStoreAssignmentsClient.ListBySubscription
// method.
type CustomEntityStoreAssignmentsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// CustomEntityStoreAssignmentsListResult - A list of custom entity store assignments
type CustomEntityStoreAssignmentsListResult struct {
	// The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Collection of custom entity store assignments
	Value []*CustomEntityStoreAssignment `json:"value,omitempty" azure:"ro"`
}

// DataExportSettingProperties - The data export setting properties
type DataExportSettingProperties struct {
	// REQUIRED; Is the data export setting enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DataExportSettings - Represents a data export setting
type DataExportSettings struct {
	// REQUIRED; the kind of the settings string
	Kind *SettingKind `json:"kind,omitempty"`

	// Data export setting data
	Properties *DataExportSettingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetSetting implements the SettingClassification interface for type DataExportSettings.
func (d *DataExportSettings) GetSetting() *Setting {
	return &Setting{
		Kind: d.Kind,
		ID:   d.ID,
		Name: d.Name,
		Type: d.Type,
	}
}

// DefenderCspmAwsOffering - The CSPM P1 for Aws offering
type DefenderCspmAwsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// The Microsoft Defender for Server VM scanning configuration
	VMScanners *DefenderCspmAwsOfferingVMScanners `json:"vmScanners,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderCspmAwsOffering.
func (d *DefenderCspmAwsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: d.OfferingType,
		Description:  d.Description,
	}
}

// DefenderCspmAwsOfferingVMScanners - The Microsoft Defender for Server VM scanning configuration
type DefenderCspmAwsOfferingVMScanners struct {
	// configuration for Microsoft Defender for Server VM scanning
	Configuration *DefenderCspmAwsOfferingVMScannersConfiguration `json:"configuration,omitempty"`

	// Is Microsoft Defender for Server VM scanning enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderCspmAwsOfferingVMScannersConfiguration - configuration for Microsoft Defender for Server VM scanning
type DefenderCspmAwsOfferingVMScannersConfiguration struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`

	// VM tags that indicates that VM should not be scanned
	ExclusionTags map[string]*string `json:"exclusionTags,omitempty"`

	// The scanning mode for the vm scan.
	ScanningMode *ScanningMode `json:"scanningMode,omitempty"`
}

// DefenderCspmGcpOffering - The CSPM P1 for GCP offering
type DefenderCspmGcpOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderCspmGcpOffering.
func (d *DefenderCspmGcpOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: d.OfferingType,
		Description:  d.Description,
	}
}

// DefenderFoDatabasesAwsOffering - The Defender for Databases AWS offering
type DefenderFoDatabasesAwsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// The ARC autoprovisioning configuration
	ArcAutoProvisioning *DefenderFoDatabasesAwsOfferingArcAutoProvisioning `json:"arcAutoProvisioning,omitempty"`

	// The RDS configuration
	Rds *DefenderFoDatabasesAwsOfferingRds `json:"rds,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderFoDatabasesAwsOffering.
func (d *DefenderFoDatabasesAwsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: d.OfferingType,
		Description:  d.Description,
	}
}

// DefenderFoDatabasesAwsOfferingArcAutoProvisioning - The ARC autoprovisioning configuration
type DefenderFoDatabasesAwsOfferingArcAutoProvisioning struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`

	// Is arc auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderFoDatabasesAwsOfferingRds - The RDS configuration
type DefenderFoDatabasesAwsOfferingRds struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`

	// Is RDS protection enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderForContainersAwsOffering - The Defender for Containers AWS offering
type DefenderForContainersAwsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// Is audit logs pipeline auto provisioning enabled
	AutoProvisioning *bool `json:"autoProvisioning,omitempty"`

	// The cloudwatch to kinesis connection configuration
	CloudWatchToKinesis *DefenderForContainersAwsOfferingCloudWatchToKinesis `json:"cloudWatchToKinesis,omitempty"`

	// The container vulnerability assessment configuration
	ContainerVulnerabilityAssessment *DefenderForContainersAwsOfferingContainerVulnerabilityAssessment `json:"containerVulnerabilityAssessment,omitempty"`

	// The container vulnerability assessment task configuration
	ContainerVulnerabilityAssessmentTask *DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask `json:"containerVulnerabilityAssessmentTask,omitempty"`

	// Enable container vulnerability assessment feature
	EnableContainerVulnerabilityAssessment *bool `json:"enableContainerVulnerabilityAssessment,omitempty"`

	// The kinesis to s3 connection configuration
	KinesisToS3 *DefenderForContainersAwsOfferingKinesisToS3 `json:"kinesisToS3,omitempty"`

	// The retention time in days of kube audit logs set on the CloudWatch log group
	KubeAuditRetentionTime *int64 `json:"kubeAuditRetentionTime,omitempty"`

	// The kubernetes to scuba connection configuration
	KubernetesScubaReader *DefenderForContainersAwsOfferingKubernetesScubaReader `json:"kubernetesScubaReader,omitempty"`

	// The kubernetes service connection configuration
	KubernetesService *DefenderForContainersAwsOfferingKubernetesService `json:"kubernetesService,omitempty"`

	// The externalId used by the data reader to prevent the confused deputy attack
	ScubaExternalID *string `json:"scubaExternalId,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForContainersAwsOffering.
func (d *DefenderForContainersAwsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: d.OfferingType,
		Description:  d.Description,
	}
}

// DefenderForContainersAwsOfferingCloudWatchToKinesis - The cloudwatch to kinesis connection configuration
type DefenderForContainersAwsOfferingCloudWatchToKinesis struct {
	// The cloud role ARN in AWS used by CloudWatch to transfer data into Kinesis
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersAwsOfferingContainerVulnerabilityAssessment - The container vulnerability assessment configuration
type DefenderForContainersAwsOfferingContainerVulnerabilityAssessment struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask - The container vulnerability assessment task configuration
type DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersAwsOfferingKinesisToS3 - The kinesis to s3 connection configuration
type DefenderForContainersAwsOfferingKinesisToS3 struct {
	// The cloud role ARN in AWS used by Kinesis to transfer data into S3
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersAwsOfferingKubernetesScubaReader - The kubernetes to scuba connection configuration
type DefenderForContainersAwsOfferingKubernetesScubaReader struct {
	// The cloud role ARN in AWS for this feature used for reading data
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersAwsOfferingKubernetesService - The kubernetes service connection configuration
type DefenderForContainersAwsOfferingKubernetesService struct {
	// The cloud role ARN in AWS for this feature used for provisioning resources
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersGcpOffering - The containers GCP offering
type DefenderForContainersGcpOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// Is audit logs data collection enabled
	AuditLogsAutoProvisioningFlag *bool `json:"auditLogsAutoProvisioningFlag,omitempty"`

	// The native cloud connection configuration
	DataPipelineNativeCloudConnection *DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection `json:"dataPipelineNativeCloudConnection,omitempty"`

	// Is Microsoft Defender for Cloud Kubernetes agent auto provisioning enabled
	DefenderAgentAutoProvisioningFlag *bool `json:"defenderAgentAutoProvisioningFlag,omitempty"`

	// The native cloud connection configuration
	NativeCloudConnection *DefenderForContainersGcpOfferingNativeCloudConnection `json:"nativeCloudConnection,omitempty"`

	// Is Policy Kubernetes agent auto provisioning enabled
	PolicyAgentAutoProvisioningFlag *bool `json:"policyAgentAutoProvisioningFlag,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForContainersGcpOffering.
func (d *DefenderForContainersGcpOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: d.OfferingType,
		Description:  d.Description,
	}
}

// DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection - The native cloud connection configuration
type DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection struct {
	// The data collection service account email address in GCP for this offering
	ServiceAccountEmailAddress *string `json:"serviceAccountEmailAddress,omitempty"`

	// The data collection GCP workload identity provider id for this offering
	WorkloadIdentityProviderID *string `json:"workloadIdentityProviderId,omitempty"`
}

// DefenderForContainersGcpOfferingNativeCloudConnection - The native cloud connection configuration
type DefenderForContainersGcpOfferingNativeCloudConnection struct {
	// The service account email address in GCP for this offering
	ServiceAccountEmailAddress *string `json:"serviceAccountEmailAddress,omitempty"`

	// The GCP workload identity provider id for this offering
	WorkloadIdentityProviderID *string `json:"workloadIdentityProviderId,omitempty"`
}

// DefenderForDatabasesGcpOffering - The Defender for Databases GCP offering configurations
type DefenderForDatabasesGcpOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// The ARC autoprovisioning configuration
	ArcAutoProvisioning *DefenderForDatabasesGcpOfferingArcAutoProvisioning `json:"arcAutoProvisioning,omitempty"`

	// The native cloud connection configuration
	DefenderForDatabasesArcAutoProvisioning *DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning `json:"defenderForDatabasesArcAutoProvisioning,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForDatabasesGcpOffering.
func (d *DefenderForDatabasesGcpOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: d.OfferingType,
		Description:  d.Description,
	}
}

// DefenderForDatabasesGcpOfferingArcAutoProvisioning - The ARC autoprovisioning configuration
type DefenderForDatabasesGcpOfferingArcAutoProvisioning struct {
	// Is arc auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning - The native cloud connection configuration
type DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning struct {
	// The service account email address in GCP for this offering
	ServiceAccountEmailAddress *string `json:"serviceAccountEmailAddress,omitempty"`

	// The GCP workload identity provider id for this offering
	WorkloadIdentityProviderID *string `json:"workloadIdentityProviderId,omitempty"`
}

// DefenderForDevOpsAzureDevOpsOffering - The Defender for DevOps for Azure DevOps offering
type DefenderForDevOpsAzureDevOpsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForDevOpsAzureDevOpsOffering.
func (d *DefenderForDevOpsAzureDevOpsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: d.OfferingType,
		Description:  d.Description,
	}
}

// DefenderForDevOpsGithubOffering - The Defender for DevOps for Github offering
type DefenderForDevOpsGithubOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForDevOpsGithubOffering.
func (d *DefenderForDevOpsGithubOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: d.OfferingType,
		Description:  d.Description,
	}
}

// DefenderForServersAwsOffering - The Defender for Servers AWS offering
type DefenderForServersAwsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// The ARC autoprovisioning configuration
	ArcAutoProvisioning *DefenderForServersAwsOfferingArcAutoProvisioning `json:"arcAutoProvisioning,omitempty"`

	// The Defender for servers connection configuration
	DefenderForServers *DefenderForServersAwsOfferingDefenderForServers `json:"defenderForServers,omitempty"`

	// The Microsoft Defender for Endpoint autoprovisioning configuration
	MdeAutoProvisioning *DefenderForServersAwsOfferingMdeAutoProvisioning `json:"mdeAutoProvisioning,omitempty"`

	// configuration for the servers offering subPlan
	SubPlan *DefenderForServersAwsOfferingSubPlan `json:"subPlan,omitempty"`

	// The Microsoft Defender for Server VM scanning configuration
	VMScanners *DefenderForServersAwsOfferingVMScanners `json:"vmScanners,omitempty"`

	// The Vulnerability Assessment autoprovisioning configuration
	VaAutoProvisioning *DefenderForServersAwsOfferingVaAutoProvisioning `json:"vaAutoProvisioning,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForServersAwsOffering.
func (d *DefenderForServersAwsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: d.OfferingType,
		Description:  d.Description,
	}
}

// DefenderForServersAwsOfferingArcAutoProvisioning - The ARC autoprovisioning configuration
type DefenderForServersAwsOfferingArcAutoProvisioning struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`

	// Is arc auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderForServersAwsOfferingDefenderForServers - The Defender for servers connection configuration
type DefenderForServersAwsOfferingDefenderForServers struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForServersAwsOfferingMdeAutoProvisioning - The Microsoft Defender for Endpoint autoprovisioning configuration
type DefenderForServersAwsOfferingMdeAutoProvisioning struct {
	// configuration for Microsoft Defender for Endpoint autoprovisioning
	Configuration interface{} `json:"configuration,omitempty"`

	// Is Microsoft Defender for Endpoint auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderForServersAwsOfferingSubPlan - configuration for the servers offering subPlan
type DefenderForServersAwsOfferingSubPlan struct {
	// The available sub plans
	Type *SubPlan `json:"type,omitempty"`
}

// DefenderForServersAwsOfferingVMScanners - The Microsoft Defender for Server VM scanning configuration
type DefenderForServersAwsOfferingVMScanners struct {
	// configuration for Microsoft Defender for Server VM scanning
	Configuration *DefenderForServersAwsOfferingVMScannersConfiguration `json:"configuration,omitempty"`

	// Is Microsoft Defender for Server VM scanning enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderForServersAwsOfferingVMScannersConfiguration - configuration for Microsoft Defender for Server VM scanning
type DefenderForServersAwsOfferingVMScannersConfiguration struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`

	// VM tags that indicates that VM should not be scanned
	ExclusionTags map[string]*string `json:"exclusionTags,omitempty"`

	// The scanning mode for the vm scan.
	ScanningMode *ScanningMode `json:"scanningMode,omitempty"`
}

// DefenderForServersAwsOfferingVaAutoProvisioning - The Vulnerability Assessment autoprovisioning configuration
type DefenderForServersAwsOfferingVaAutoProvisioning struct {
	// configuration for Vulnerability Assessment autoprovisioning
	Configuration *DefenderForServersAwsOfferingVaAutoProvisioningConfiguration `json:"configuration,omitempty"`

	// Is Vulnerability Assessment auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderForServersAwsOfferingVaAutoProvisioningConfiguration - configuration for Vulnerability Assessment autoprovisioning
type DefenderForServersAwsOfferingVaAutoProvisioningConfiguration struct {
	// The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
	Type *Type `json:"type,omitempty"`
}

// DefenderForServersGcpOffering - The Defender for Servers GCP offering configurations
type DefenderForServersGcpOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// The ARC autoprovisioning configuration
	ArcAutoProvisioning *DefenderForServersGcpOfferingArcAutoProvisioning `json:"arcAutoProvisioning,omitempty"`

	// The Defender for servers connection configuration
	DefenderForServers *DefenderForServersGcpOfferingDefenderForServers `json:"defenderForServers,omitempty"`

	// The Microsoft Defender for Endpoint autoprovisioning configuration
	MdeAutoProvisioning *DefenderForServersGcpOfferingMdeAutoProvisioning `json:"mdeAutoProvisioning,omitempty"`

	// configuration for the servers offering subPlan
	SubPlan *DefenderForServersGcpOfferingSubPlan `json:"subPlan,omitempty"`

	// The Vulnerability Assessment autoprovisioning configuration
	VaAutoProvisioning *DefenderForServersGcpOfferingVaAutoProvisioning `json:"vaAutoProvisioning,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForServersGcpOffering.
func (d *DefenderForServersGcpOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: d.OfferingType,
		Description:  d.Description,
	}
}

// DefenderForServersGcpOfferingArcAutoProvisioning - The ARC autoprovisioning configuration
type DefenderForServersGcpOfferingArcAutoProvisioning struct {
	// Is arc auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderForServersGcpOfferingDefenderForServers - The Defender for servers connection configuration
type DefenderForServersGcpOfferingDefenderForServers struct {
	// The service account email address in GCP for this feature
	ServiceAccountEmailAddress *string `json:"serviceAccountEmailAddress,omitempty"`

	// The workload identity provider id in GCP for this feature
	WorkloadIdentityProviderID *string `json:"workloadIdentityProviderId,omitempty"`
}

// DefenderForServersGcpOfferingMdeAutoProvisioning - The Microsoft Defender for Endpoint autoprovisioning configuration
type DefenderForServersGcpOfferingMdeAutoProvisioning struct {
	// configuration for Microsoft Defender for Endpoint autoprovisioning
	Configuration interface{} `json:"configuration,omitempty"`

	// Is Microsoft Defender for Endpoint auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderForServersGcpOfferingSubPlan - configuration for the servers offering subPlan
type DefenderForServersGcpOfferingSubPlan struct {
	// The available sub plans
	Type *SubPlan `json:"type,omitempty"`
}

// DefenderForServersGcpOfferingVaAutoProvisioning - The Vulnerability Assessment autoprovisioning configuration
type DefenderForServersGcpOfferingVaAutoProvisioning struct {
	// configuration for Vulnerability Assessment autoprovisioning
	Configuration *DefenderForServersGcpOfferingVaAutoProvisioningConfiguration `json:"configuration,omitempty"`

	// Is Vulnerability Assessment auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderForServersGcpOfferingVaAutoProvisioningConfiguration - configuration for Vulnerability Assessment autoprovisioning
type DefenderForServersGcpOfferingVaAutoProvisioningConfiguration struct {
	// The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
	Type *Type `json:"type,omitempty"`
}

// DenylistCustomAlertRule - A custom alert rule that checks if a value (depends on the custom alert type) is denied.
type DenylistCustomAlertRule struct {
	// REQUIRED; The values to deny. The format of the values depends on the rule type.
	DenylistValues []*string `json:"denylistValues,omitempty"`

	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType `json:"valueType,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type DenylistCustomAlertRule.
func (d *DenylistCustomAlertRule) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: d.DisplayName,
		Description: d.Description,
		IsEnabled:   d.IsEnabled,
		RuleType:    d.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type DenylistCustomAlertRule.
func (d *DenylistCustomAlertRule) GetListCustomAlertRule() *ListCustomAlertRule {
	return &ListCustomAlertRule{
		ValueType:   d.ValueType,
		DisplayName: d.DisplayName,
		Description: d.Description,
		IsEnabled:   d.IsEnabled,
		RuleType:    d.RuleType,
	}
}

// DeviceSecurityGroup - The device security group resource
type DeviceSecurityGroup struct {
	// Device Security group data
	Properties *DeviceSecurityGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeviceSecurityGroupList - List of device security groups
type DeviceSecurityGroupList struct {
	// List of device security group objects
	Value []*DeviceSecurityGroup `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DeviceSecurityGroupProperties - describes properties of a security group.
type DeviceSecurityGroupProperties struct {
	// The allow-list custom alert rules.
	AllowlistRules []AllowlistCustomAlertRuleClassification `json:"allowlistRules,omitempty"`

	// The deny-list custom alert rules.
	DenylistRules []*DenylistCustomAlertRule `json:"denylistRules,omitempty"`

	// The list of custom alert threshold rules.
	ThresholdRules []ThresholdCustomAlertRuleClassification `json:"thresholdRules,omitempty"`

	// The list of custom alert time-window rules.
	TimeWindowRules []TimeWindowCustomAlertRuleClassification `json:"timeWindowRules,omitempty"`
}

// DeviceSecurityGroupsClientCreateOrUpdateOptions contains the optional parameters for the DeviceSecurityGroupsClient.CreateOrUpdate
// method.
type DeviceSecurityGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DeviceSecurityGroupsClientDeleteOptions contains the optional parameters for the DeviceSecurityGroupsClient.Delete method.
type DeviceSecurityGroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DeviceSecurityGroupsClientGetOptions contains the optional parameters for the DeviceSecurityGroupsClient.Get method.
type DeviceSecurityGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DeviceSecurityGroupsClientListOptions contains the optional parameters for the DeviceSecurityGroupsClient.List method.
type DeviceSecurityGroupsClientListOptions struct {
	// placeholder for future optional parameters
}

// DirectMethodInvokesNotInAllowedRange - Number of direct method invokes is not in allowed range.
type DirectMethodInvokesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type DirectMethodInvokesNotInAllowedRange.
func (d *DirectMethodInvokesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: d.DisplayName,
		Description: d.Description,
		IsEnabled:   d.IsEnabled,
		RuleType:    d.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type DirectMethodInvokesNotInAllowedRange.
func (d *DirectMethodInvokesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: d.MinThreshold,
		MaxThreshold: d.MaxThreshold,
		DisplayName:  d.DisplayName,
		Description:  d.Description,
		IsEnabled:    d.IsEnabled,
		RuleType:     d.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type DirectMethodInvokesNotInAllowedRange.
func (d *DirectMethodInvokesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: d.TimeWindowSize,
		MinThreshold:   d.MinThreshold,
		MaxThreshold:   d.MaxThreshold,
		DisplayName:    d.DisplayName,
		Description:    d.Description,
		IsEnabled:      d.IsEnabled,
		RuleType:       d.RuleType,
	}
}

type DiscoveredSecuritySolution struct {
	// REQUIRED
	Properties *DiscoveredSecuritySolutionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

type DiscoveredSecuritySolutionList struct {
	Value []*DiscoveredSecuritySolution `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

type DiscoveredSecuritySolutionProperties struct {
	// REQUIRED; The security solutions' image offer
	Offer *string `json:"offer,omitempty"`

	// REQUIRED; The security solutions' image publisher
	Publisher *string `json:"publisher,omitempty"`

	// REQUIRED; The security solutions' image sku
	SKU *string `json:"sku,omitempty"`

	// REQUIRED; The security family of the discovered solution
	SecurityFamily *SecurityFamily `json:"securityFamily,omitempty"`
}

// DiscoveredSecuritySolutionsClientGetOptions contains the optional parameters for the DiscoveredSecuritySolutionsClient.Get
// method.
type DiscoveredSecuritySolutionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DiscoveredSecuritySolutionsClientListByHomeRegionOptions contains the optional parameters for the DiscoveredSecuritySolutionsClient.ListByHomeRegion
// method.
type DiscoveredSecuritySolutionsClientListByHomeRegionOptions struct {
	// placeholder for future optional parameters
}

// DiscoveredSecuritySolutionsClientListOptions contains the optional parameters for the DiscoveredSecuritySolutionsClient.List
// method.
type DiscoveredSecuritySolutionsClientListOptions struct {
	// placeholder for future optional parameters
}

// ETag - Entity tag is used for comparing two or more entities from the same requested resource.
type ETag struct {
	// Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`
}

// EffectiveNetworkSecurityGroups - Describes the Network Security Groups effective on a network interface
type EffectiveNetworkSecurityGroups struct {
	// The Azure resource ID of the network interface
	NetworkInterface *string `json:"networkInterface,omitempty"`

	// The Network Security Groups effective on the network interface
	NetworkSecurityGroups []*string `json:"networkSecurityGroups,omitempty"`
}

// EnvironmentDataClassification provides polymorphic access to related types.
// Call the interface's GetEnvironmentData() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AwsEnvironmentData, *AzureDevOpsScopeEnvironmentData, *EnvironmentData, *GcpProjectEnvironmentData, *GithubScopeEnvironmentData
type EnvironmentDataClassification interface {
	// GetEnvironmentData returns the EnvironmentData content of the underlying type.
	GetEnvironmentData() *EnvironmentData
}

// EnvironmentData - The security connector environment data.
type EnvironmentData struct {
	// REQUIRED; The type of the environment data.
	EnvironmentType *EnvironmentType `json:"environmentType,omitempty"`
}

// GetEnvironmentData implements the EnvironmentDataClassification interface for type EnvironmentData.
func (e *EnvironmentData) GetEnvironmentData() *EnvironmentData { return e }

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExecuteGovernanceRuleParams - Governance rule execution parameters
type ExecuteGovernanceRuleParams struct {
	// Describe if governance rule should be override
	Override *bool `json:"override,omitempty"`
}

// ExecuteRuleStatus - Execute status of Security GovernanceRule over a given scope
type ExecuteRuleStatus struct {
	// READ-ONLY; Unique key for the execution of GovernanceRule
	OperationID *string `json:"operationId,omitempty" azure:"ro"`
}

// ExternalSecuritySolution - Represents a security solution external to Microsoft Defender for Cloud which sends information
// to an OMS workspace and whose data is displayed by Microsoft Defender for Cloud.
type ExternalSecuritySolution struct {
	// The kind of the external solution
	Kind *ExternalSecuritySolutionKind `json:"kind,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExternalSecuritySolutionKindAutoGenerated - Describes an Azure resource with kind
type ExternalSecuritySolutionKindAutoGenerated struct {
	// The kind of the external solution
	Kind *ExternalSecuritySolutionKind `json:"kind,omitempty"`
}

type ExternalSecuritySolutionList struct {
	Value []*ExternalSecuritySolution `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ExternalSecuritySolutionProperties - The solution properties (correspond to the solution kind)
type ExternalSecuritySolutionProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
	DeviceType           *string `json:"deviceType,omitempty"`
	DeviceVendor         *string `json:"deviceVendor,omitempty"`

	// Represents an OMS workspace to which the solution is connected
	Workspace *ConnectedWorkspace `json:"workspace,omitempty"`
}

// ExternalSecuritySolutionsClientGetOptions contains the optional parameters for the ExternalSecuritySolutionsClient.Get
// method.
type ExternalSecuritySolutionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExternalSecuritySolutionsClientListByHomeRegionOptions contains the optional parameters for the ExternalSecuritySolutionsClient.ListByHomeRegion
// method.
type ExternalSecuritySolutionsClientListByHomeRegionOptions struct {
	// placeholder for future optional parameters
}

// ExternalSecuritySolutionsClientListOptions contains the optional parameters for the ExternalSecuritySolutionsClient.List
// method.
type ExternalSecuritySolutionsClientListOptions struct {
	// placeholder for future optional parameters
}

// FailedLocalLoginsNotInAllowedRange - Number of failed local logins is not in allowed range.
type FailedLocalLoginsNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type FailedLocalLoginsNotInAllowedRange.
func (f *FailedLocalLoginsNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: f.DisplayName,
		Description: f.Description,
		IsEnabled:   f.IsEnabled,
		RuleType:    f.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type FailedLocalLoginsNotInAllowedRange.
func (f *FailedLocalLoginsNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: f.MinThreshold,
		MaxThreshold: f.MaxThreshold,
		DisplayName:  f.DisplayName,
		Description:  f.Description,
		IsEnabled:    f.IsEnabled,
		RuleType:     f.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type FailedLocalLoginsNotInAllowedRange.
func (f *FailedLocalLoginsNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: f.TimeWindowSize,
		MinThreshold:   f.MinThreshold,
		MaxThreshold:   f.MaxThreshold,
		DisplayName:    f.DisplayName,
		Description:    f.Description,
		IsEnabled:      f.IsEnabled,
		RuleType:       f.RuleType,
	}
}

// FileUploadsNotInAllowedRange - Number of file uploads is not in allowed range.
type FileUploadsNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type FileUploadsNotInAllowedRange.
func (f *FileUploadsNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: f.DisplayName,
		Description: f.Description,
		IsEnabled:   f.IsEnabled,
		RuleType:    f.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type FileUploadsNotInAllowedRange.
func (f *FileUploadsNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: f.MinThreshold,
		MaxThreshold: f.MaxThreshold,
		DisplayName:  f.DisplayName,
		Description:  f.Description,
		IsEnabled:    f.IsEnabled,
		RuleType:     f.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type FileUploadsNotInAllowedRange.
func (f *FileUploadsNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: f.TimeWindowSize,
		MinThreshold:   f.MinThreshold,
		MaxThreshold:   f.MaxThreshold,
		DisplayName:    f.DisplayName,
		Description:    f.Description,
		IsEnabled:      f.IsEnabled,
		RuleType:       f.RuleType,
	}
}

// GcpCredentialsDetailsProperties - GCP cloud account connector based service to service credentials, the credentials are
// composed of the organization ID and a JSON API key (write only)
type GcpCredentialsDetailsProperties struct {
	// REQUIRED; Auth provider x509 certificate URL field of the API key (write only)
	AuthProviderX509CertURL *string `json:"authProviderX509CertUrl,omitempty"`

	// REQUIRED; Auth URI field of the API key (write only)
	AuthURI *string `json:"authUri,omitempty"`

	// REQUIRED; Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use
	// account organization credentials.
	AuthenticationType *AuthenticationType `json:"authenticationType,omitempty"`

	// REQUIRED; Client email field of the API key (write only)
	ClientEmail *string `json:"clientEmail,omitempty"`

	// REQUIRED; Client ID field of the API key (write only)
	ClientID *string `json:"clientId,omitempty"`

	// REQUIRED; Client x509 certificate URL field of the API key (write only)
	ClientX509CertURL *string `json:"clientX509CertUrl,omitempty"`

	// REQUIRED; The organization ID of the GCP cloud account
	OrganizationID *string `json:"organizationId,omitempty"`

	// REQUIRED; Private key field of the API key (write only)
	PrivateKey *string `json:"privateKey,omitempty"`

	// REQUIRED; Private key ID field of the API key (write only)
	PrivateKeyID *string `json:"privateKeyId,omitempty"`

	// REQUIRED; Project ID field of the API key (write only)
	ProjectID *string `json:"projectId,omitempty"`

	// REQUIRED; Token URI field of the API key (write only)
	TokenURI *string `json:"tokenUri,omitempty"`

	// REQUIRED; Type field of the API key (write only)
	Type *string `json:"type,omitempty"`

	// READ-ONLY; State of the multi-cloud connector
	AuthenticationProvisioningState *AuthenticationProvisioningState `json:"authenticationProvisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions []*PermissionProperty `json:"grantedPermissions,omitempty" azure:"ro"`
}

// GetAuthenticationDetailsProperties implements the AuthenticationDetailsPropertiesClassification interface for type GcpCredentialsDetailsProperties.
func (g *GcpCredentialsDetailsProperties) GetAuthenticationDetailsProperties() *AuthenticationDetailsProperties {
	return &AuthenticationDetailsProperties{
		AuthenticationProvisioningState: g.AuthenticationProvisioningState,
		GrantedPermissions:              g.GrantedPermissions,
		AuthenticationType:              g.AuthenticationType,
	}
}

// GcpOrganizationalDataClassification provides polymorphic access to related types.
// Call the interface's GetGcpOrganizationalData() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *GcpOrganizationalData, *GcpOrganizationalDataMember, *GcpOrganizationalDataOrganization
type GcpOrganizationalDataClassification interface {
	// GetGcpOrganizationalData returns the GcpOrganizationalData content of the underlying type.
	GetGcpOrganizationalData() *GcpOrganizationalData
}

// GcpOrganizationalData - The gcpOrganization data
type GcpOrganizationalData struct {
	// REQUIRED; The multi cloud account's membership type in the organization
	OrganizationMembershipType *OrganizationMembershipType `json:"organizationMembershipType,omitempty"`
}

// GetGcpOrganizationalData implements the GcpOrganizationalDataClassification interface for type GcpOrganizationalData.
func (g *GcpOrganizationalData) GetGcpOrganizationalData() *GcpOrganizationalData { return g }

// GcpOrganizationalDataMember - The gcpOrganization data for the member account
type GcpOrganizationalDataMember struct {
	// REQUIRED; The multi cloud account's membership type in the organization
	OrganizationMembershipType *OrganizationMembershipType `json:"organizationMembershipType,omitempty"`

	// The GCP management project number from organizational onboarding
	ManagementProjectNumber *string `json:"managementProjectNumber,omitempty"`

	// If the multi cloud account is not of membership type organization, this will be the ID of the project's parent
	ParentHierarchyID *string `json:"parentHierarchyId,omitempty"`
}

// GetGcpOrganizationalData implements the GcpOrganizationalDataClassification interface for type GcpOrganizationalDataMember.
func (g *GcpOrganizationalDataMember) GetGcpOrganizationalData() *GcpOrganizationalData {
	return &GcpOrganizationalData{
		OrganizationMembershipType: g.OrganizationMembershipType,
	}
}

// GcpOrganizationalDataOrganization - The gcpOrganization data for the parent account
type GcpOrganizationalDataOrganization struct {
	// REQUIRED; The multi cloud account's membership type in the organization
	OrganizationMembershipType *OrganizationMembershipType `json:"organizationMembershipType,omitempty"`

	// If the multi cloud account is of membership type organization, list of accounts excluded from offering
	ExcludedProjectNumbers []*string `json:"excludedProjectNumbers,omitempty"`

	// The service account email address which represents the organization level permissions container.
	ServiceAccountEmailAddress *string `json:"serviceAccountEmailAddress,omitempty"`

	// The GCP workload identity provider id which represents the permissions required to auto provision security connectors
	WorkloadIdentityProviderID *string `json:"workloadIdentityProviderId,omitempty"`
}

// GetGcpOrganizationalData implements the GcpOrganizationalDataClassification interface for type GcpOrganizationalDataOrganization.
func (g *GcpOrganizationalDataOrganization) GetGcpOrganizationalData() *GcpOrganizationalData {
	return &GcpOrganizationalData{
		OrganizationMembershipType: g.OrganizationMembershipType,
	}
}

// GcpProjectDetails - The details about the project represented by the security connector
type GcpProjectDetails struct {
	// The GCP Project id
	ProjectID *string `json:"projectId,omitempty"`

	// The unique GCP Project number
	ProjectNumber *string `json:"projectNumber,omitempty"`

	// READ-ONLY; The GCP workload identity federation pool id
	WorkloadIdentityPoolID *string `json:"workloadIdentityPoolId,omitempty" azure:"ro"`
}

// GcpProjectEnvironmentData - The GCP project connector environment data
type GcpProjectEnvironmentData struct {
	// REQUIRED; The type of the environment data.
	EnvironmentType *EnvironmentType `json:"environmentType,omitempty"`

	// The Gcp project's organizational data
	OrganizationalData GcpOrganizationalDataClassification `json:"organizationalData,omitempty"`

	// The Gcp project's details
	ProjectDetails *GcpProjectDetails `json:"projectDetails,omitempty"`
}

// GetEnvironmentData implements the EnvironmentDataClassification interface for type GcpProjectEnvironmentData.
func (g *GcpProjectEnvironmentData) GetEnvironmentData() *EnvironmentData {
	return &EnvironmentData{
		EnvironmentType: g.EnvironmentType,
	}
}

// GithubScopeEnvironmentData - The github scope connector's environment data
type GithubScopeEnvironmentData struct {
	// REQUIRED; The type of the environment data.
	EnvironmentType *EnvironmentType `json:"environmentType,omitempty"`
}

// GetEnvironmentData implements the EnvironmentDataClassification interface for type GithubScopeEnvironmentData.
func (g *GithubScopeEnvironmentData) GetEnvironmentData() *EnvironmentData {
	return &EnvironmentData{
		EnvironmentType: g.EnvironmentType,
	}
}

// GovernanceAssignment - Security GovernanceAssignment over a given scope
type GovernanceAssignment struct {
	// Properties of a security governanceAssignment
	Properties *GovernanceAssignmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GovernanceAssignmentAdditionalData - Describe the additional data of GovernanceAssignment - optional
type GovernanceAssignmentAdditionalData struct {
	// Ticket link associated with this GovernanceAssignment - for example: https://snow.com
	TicketLink *string `json:"ticketLink,omitempty"`

	// Ticket number associated with this GovernanceAssignment
	TicketNumber *int32 `json:"ticketNumber,omitempty"`

	// The ticket status associated with this GovernanceAssignment - for example: Active
	TicketStatus *string `json:"ticketStatus,omitempty"`
}

// GovernanceAssignmentProperties - Describes properties of an governance assignment
type GovernanceAssignmentProperties struct {
	// REQUIRED; The remediation due-date - after this date Secure Score will be affected (in case of active grace-period)
	RemediationDueDate *time.Time `json:"remediationDueDate,omitempty"`

	// The additional data for the governance assignment - e.g. links to ticket (optional), see example
	AdditionalData *GovernanceAssignmentAdditionalData `json:"additionalData,omitempty"`

	// The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
	GovernanceEmailNotification *GovernanceEmailNotification `json:"governanceEmailNotification,omitempty"`

	// Defines whether there is a grace period on the governance assignment
	IsGracePeriod *bool `json:"isGracePeriod,omitempty"`

	// The Owner for the governance assignment - e.g. user@contoso.com - see example
	Owner *string `json:"owner,omitempty"`

	// The ETA (estimated time of arrival) for remediation (optional), see example
	RemediationEta *RemediationEta `json:"remediationEta,omitempty"`
}

// GovernanceAssignmentsClientCreateOrUpdateOptions contains the optional parameters for the GovernanceAssignmentsClient.CreateOrUpdate
// method.
type GovernanceAssignmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// GovernanceAssignmentsClientDeleteOptions contains the optional parameters for the GovernanceAssignmentsClient.Delete method.
type GovernanceAssignmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GovernanceAssignmentsClientGetOptions contains the optional parameters for the GovernanceAssignmentsClient.Get method.
type GovernanceAssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// GovernanceAssignmentsClientListOptions contains the optional parameters for the GovernanceAssignmentsClient.List method.
type GovernanceAssignmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// GovernanceAssignmentsList - Page of a security governance assignments list
type GovernanceAssignmentsList struct {
	// READ-ONLY; The URI to fetch the next page
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Collection of governance assignments in this page
	Value []*GovernanceAssignment `json:"value,omitempty" azure:"ro"`
}

// GovernanceEmailNotification - The governance email weekly notification configuration.
type GovernanceEmailNotification struct {
	// Exclude manager from weekly email notification.
	DisableManagerEmailNotification *bool `json:"disableManagerEmailNotification,omitempty"`

	// Exclude owner from weekly email notification.
	DisableOwnerEmailNotification *bool `json:"disableOwnerEmailNotification,omitempty"`
}

// GovernanceRule - Security GovernanceRule over a given scope
type GovernanceRule struct {
	// Properties of a security governanceRule
	Properties *GovernanceRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GovernanceRuleClientListOptions contains the optional parameters for the GovernanceRuleClient.List method.
type GovernanceRuleClientListOptions struct {
	// placeholder for future optional parameters
}

// GovernanceRuleEmailNotification - The governance email weekly notification configuration.
type GovernanceRuleEmailNotification struct {
	// Defines whether manager email notifications are disabled.
	DisableManagerEmailNotification *bool `json:"disableManagerEmailNotification,omitempty"`

	// Defines whether owner email notifications are disabled.
	DisableOwnerEmailNotification *bool `json:"disableOwnerEmailNotification,omitempty"`
}

// GovernanceRuleList - Page of a security governanceRules list
type GovernanceRuleList struct {
	// READ-ONLY; The URI to fetch the next page
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Collection of governanceRules in this page
	Value []*GovernanceRule `json:"value,omitempty" azure:"ro"`
}

// GovernanceRuleOwnerSource - Describe the owner source of governance rule
type GovernanceRuleOwnerSource struct {
	// The owner type for the governance rule owner source
	Type *GovernanceRuleOwnerSourceType `json:"type,omitempty"`

	// The source value e.g. tag key like owner name or email address
	Value *string `json:"value,omitempty"`
}

// GovernanceRuleProperties - Describes properties of an governanceRule
type GovernanceRuleProperties struct {
	// REQUIRED; The governance rule conditionSets - see examples
	ConditionSets []interface{} `json:"conditionSets,omitempty"`

	// REQUIRED; display name of the governanceRule
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; The Owner source for the governance rule - e.g. Manually by user@contoso.com - see example
	OwnerSource *GovernanceRuleOwnerSource `json:"ownerSource,omitempty"`

	// REQUIRED; The governance rule priority, priority to the lower number. Rules with the same priority on the same subscription
	// will not be allowed
	RulePriority *int32 `json:"rulePriority,omitempty"`

	// REQUIRED; The rule type of the governance rule, defines the source of the rule e.g. Integrated
	RuleType *GovernanceRuleType `json:"ruleType,omitempty"`

	// REQUIRED; The governance rule source, what the rule affects, e.g. Assessments
	SourceResourceType *GovernanceRuleSourceResourceType `json:"sourceResourceType,omitempty"`

	// description of the governanceRule
	Description *string `json:"description,omitempty"`

	// The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
	GovernanceEmailNotification *GovernanceRuleEmailNotification `json:"governanceEmailNotification,omitempty"`

	// Defines whether the rule is active/inactive
	IsDisabled *bool `json:"isDisabled,omitempty"`

	// Defines whether there is a grace period on the governance rule
	IsGracePeriod *bool `json:"isGracePeriod,omitempty"`

	// Governance rule remediation timeframe - this is the time that will affect on the grace-period duration e.g. 7.00:00:00
	// - means 7 days
	RemediationTimeframe *string `json:"remediationTimeframe,omitempty"`
}

// GovernanceRulesClientBeginRuleIDExecuteSingleSecurityConnectorOptions contains the optional parameters for the GovernanceRulesClient.BeginRuleIDExecuteSingleSecurityConnector
// method.
type GovernanceRulesClientBeginRuleIDExecuteSingleSecurityConnectorOptions struct {
	// GovernanceRule over a subscription scope
	ExecuteGovernanceRuleParams *ExecuteGovernanceRuleParams
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GovernanceRulesClientBeginRuleIDExecuteSingleSubscriptionOptions contains the optional parameters for the GovernanceRulesClient.BeginRuleIDExecuteSingleSubscription
// method.
type GovernanceRulesClientBeginRuleIDExecuteSingleSubscriptionOptions struct {
	// GovernanceRule over a subscription scope
	ExecuteGovernanceRuleParams *ExecuteGovernanceRuleParams
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GovernanceRulesClientCreateOrUpdateOptions contains the optional parameters for the GovernanceRulesClient.CreateOrUpdate
// method.
type GovernanceRulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// GovernanceRulesClientDeleteOptions contains the optional parameters for the GovernanceRulesClient.Delete method.
type GovernanceRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GovernanceRulesClientGetOptions contains the optional parameters for the GovernanceRulesClient.Get method.
type GovernanceRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// HTTPC2DMessagesNotInAllowedRange - Number of cloud to device messages (HTTP protocol) is not in allowed range.
type HTTPC2DMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type HTTPC2DMessagesNotInAllowedRange.
func (h *HTTPC2DMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: h.DisplayName,
		Description: h.Description,
		IsEnabled:   h.IsEnabled,
		RuleType:    h.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type HTTPC2DMessagesNotInAllowedRange.
func (h *HTTPC2DMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: h.MinThreshold,
		MaxThreshold: h.MaxThreshold,
		DisplayName:  h.DisplayName,
		Description:  h.Description,
		IsEnabled:    h.IsEnabled,
		RuleType:     h.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type HTTPC2DMessagesNotInAllowedRange.
func (h *HTTPC2DMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: h.TimeWindowSize,
		MinThreshold:   h.MinThreshold,
		MaxThreshold:   h.MaxThreshold,
		DisplayName:    h.DisplayName,
		Description:    h.Description,
		IsEnabled:      h.IsEnabled,
		RuleType:       h.RuleType,
	}
}

// HTTPC2DRejectedMessagesNotInAllowedRange - Number of rejected cloud to device messages (HTTP protocol) is not in allowed
// range.
type HTTPC2DRejectedMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type HTTPC2DRejectedMessagesNotInAllowedRange.
func (h *HTTPC2DRejectedMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: h.DisplayName,
		Description: h.Description,
		IsEnabled:   h.IsEnabled,
		RuleType:    h.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type HTTPC2DRejectedMessagesNotInAllowedRange.
func (h *HTTPC2DRejectedMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: h.MinThreshold,
		MaxThreshold: h.MaxThreshold,
		DisplayName:  h.DisplayName,
		Description:  h.Description,
		IsEnabled:    h.IsEnabled,
		RuleType:     h.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type HTTPC2DRejectedMessagesNotInAllowedRange.
func (h *HTTPC2DRejectedMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: h.TimeWindowSize,
		MinThreshold:   h.MinThreshold,
		MaxThreshold:   h.MaxThreshold,
		DisplayName:    h.DisplayName,
		Description:    h.Description,
		IsEnabled:      h.IsEnabled,
		RuleType:       h.RuleType,
	}
}

// HTTPD2CMessagesNotInAllowedRange - Number of device to cloud messages (HTTP protocol) is not in allowed range.
type HTTPD2CMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type HTTPD2CMessagesNotInAllowedRange.
func (h *HTTPD2CMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: h.DisplayName,
		Description: h.Description,
		IsEnabled:   h.IsEnabled,
		RuleType:    h.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type HTTPD2CMessagesNotInAllowedRange.
func (h *HTTPD2CMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: h.MinThreshold,
		MaxThreshold: h.MaxThreshold,
		DisplayName:  h.DisplayName,
		Description:  h.Description,
		IsEnabled:    h.IsEnabled,
		RuleType:     h.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type HTTPD2CMessagesNotInAllowedRange.
func (h *HTTPD2CMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: h.TimeWindowSize,
		MinThreshold:   h.MinThreshold,
		MaxThreshold:   h.MaxThreshold,
		DisplayName:    h.DisplayName,
		Description:    h.Description,
		IsEnabled:      h.IsEnabled,
		RuleType:       h.RuleType,
	}
}

// HybridComputeSettingsProperties - Settings for hybrid compute management
type HybridComputeSettingsProperties struct {
	// REQUIRED; Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
	AutoProvision *AutoProvision `json:"autoProvision,omitempty"`

	// For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine
	// can use.
	ProxyServer *ProxyServerProperties `json:"proxyServer,omitempty"`

	// The location where the metadata of machines will be stored
	Region *string `json:"region,omitempty"`

	// The name of the resource group where Arc (Hybrid Compute) connectors are connected.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`

	// An object to access resources that are secured by an Azure AD tenant.
	ServicePrincipal *ServicePrincipalProperties `json:"servicePrincipal,omitempty"`

	// READ-ONLY; State of the service principal and its secret
	HybridComputeProvisioningState *HybridComputeProvisioningState `json:"hybridComputeProvisioningState,omitempty" azure:"ro"`
}

// InformationProtectionAwsOffering - The information protection for AWS offering
type InformationProtectionAwsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType `json:"offeringType,omitempty"`

	// The native cloud connection configuration
	InformationProtection *InformationProtectionAwsOfferingInformationProtection `json:"informationProtection,omitempty"`

	// READ-ONLY; The offering description.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// GetCloudOffering implements the CloudOfferingClassification interface for type InformationProtectionAwsOffering.
func (i *InformationProtectionAwsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		OfferingType: i.OfferingType,
		Description:  i.Description,
	}
}

// InformationProtectionAwsOfferingInformationProtection - The native cloud connection configuration
type InformationProtectionAwsOfferingInformationProtection struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// InformationProtectionKeyword - The information type keyword.
type InformationProtectionKeyword struct {
	// Indicates whether the keyword can be applied on numeric types or not.
	CanBeNumeric *bool `json:"canBeNumeric,omitempty"`

	// Indicates whether the keyword is custom or not.
	Custom *bool `json:"custom,omitempty"`

	// Indicates whether the keyword is excluded or not.
	Excluded *bool `json:"excluded,omitempty"`

	// The keyword pattern.
	Pattern *string `json:"pattern,omitempty"`
}

// InformationProtectionPoliciesClientCreateOrUpdateOptions contains the optional parameters for the InformationProtectionPoliciesClient.CreateOrUpdate
// method.
type InformationProtectionPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// InformationProtectionPoliciesClientGetOptions contains the optional parameters for the InformationProtectionPoliciesClient.Get
// method.
type InformationProtectionPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// InformationProtectionPoliciesClientListOptions contains the optional parameters for the InformationProtectionPoliciesClient.List
// method.
type InformationProtectionPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// InformationProtectionPolicy - Information protection policy.
type InformationProtectionPolicy struct {
	// Information protection policy data
	Properties *InformationProtectionPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InformationProtectionPolicyList - Information protection policies response.
type InformationProtectionPolicyList struct {
	// List of information protection policies.
	Value []*InformationProtectionPolicy `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// InformationProtectionPolicyProperties - describes properties of an information protection policy.
type InformationProtectionPolicyProperties struct {
	// The sensitivity information types.
	InformationTypes map[string]*InformationType `json:"informationTypes,omitempty"`

	// Dictionary of sensitivity labels.
	Labels map[string]*SensitivityLabel `json:"labels,omitempty"`

	// READ-ONLY; Describes the last UTC time the policy was modified.
	LastModifiedUTC *time.Time `json:"lastModifiedUtc,omitempty" azure:"ro"`

	// READ-ONLY; Describes the version of the policy.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// InformationType - The information type.
type InformationType struct {
	// Indicates whether the information type is custom or not.
	Custom *bool `json:"custom,omitempty"`

	// The description of the information type.
	Description *string `json:"description,omitempty"`

	// The name of the information type.
	DisplayName *string `json:"displayName,omitempty"`

	// Indicates whether the information type is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`

	// The information type keywords.
	Keywords []*InformationProtectionKeyword `json:"keywords,omitempty"`

	// The order of the information type.
	Order *int32 `json:"order,omitempty"`

	// The recommended label id to be associated with this information type.
	RecommendedLabelID *string `json:"recommendedLabelId,omitempty"`
}

// IngestionConnectionString - Connection string for ingesting security data and logs
type IngestionConnectionString struct {
	// READ-ONLY; The region where ingested logs and data resides
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Connection string value
	Value *string `json:"value,omitempty" azure:"ro"`
}

// IngestionSetting - Configures how to correlate scan data and logs with resources associated with the subscription.
type IngestionSetting struct {
	// Ingestion setting data
	Properties interface{} `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IngestionSettingList - List of ingestion settings
type IngestionSettingList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of ingestion settings
	Value []*IngestionSetting `json:"value,omitempty" azure:"ro"`
}

// IngestionSettingToken - Configures how to correlate scan data and logs with resources associated with the subscription.
type IngestionSettingToken struct {
	// READ-ONLY; The token is used for correlating security data and logs with the resources in the subscription.
	Token *string `json:"token,omitempty" azure:"ro"`
}

// IngestionSettingsClientCreateOptions contains the optional parameters for the IngestionSettingsClient.Create method.
type IngestionSettingsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// IngestionSettingsClientDeleteOptions contains the optional parameters for the IngestionSettingsClient.Delete method.
type IngestionSettingsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IngestionSettingsClientGetOptions contains the optional parameters for the IngestionSettingsClient.Get method.
type IngestionSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// IngestionSettingsClientListConnectionStringsOptions contains the optional parameters for the IngestionSettingsClient.ListConnectionStrings
// method.
type IngestionSettingsClientListConnectionStringsOptions struct {
	// placeholder for future optional parameters
}

// IngestionSettingsClientListOptions contains the optional parameters for the IngestionSettingsClient.List method.
type IngestionSettingsClientListOptions struct {
	// placeholder for future optional parameters
}

// IngestionSettingsClientListTokensOptions contains the optional parameters for the IngestionSettingsClient.ListTokens method.
type IngestionSettingsClientListTokensOptions struct {
	// placeholder for future optional parameters
}

// IoTSecurityAggregatedAlert - Security Solution Aggregated Alert information
type IoTSecurityAggregatedAlert struct {
	// IoT Security solution aggregated alert details.
	Properties *IoTSecurityAggregatedAlertProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IoTSecurityAggregatedAlertList - List of IoT Security solution aggregated alert data.
type IoTSecurityAggregatedAlertList struct {
	// REQUIRED; List of aggregated alerts data.
	Value []*IoTSecurityAggregatedAlert `json:"value,omitempty"`

	// READ-ONLY; When there is too much alert data for one page, use this URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// IoTSecurityAggregatedAlertProperties - IoT Security solution aggregated alert details.
type IoTSecurityAggregatedAlertProperties struct {
	// READ-ONLY; IoT Security solution alert response.
	ActionTaken *string `json:"actionTaken,omitempty" azure:"ro"`

	// READ-ONLY; Date of detection.
	AggregatedDateUTC *time.Time `json:"aggregatedDateUtc,omitempty" azure:"ro"`

	// READ-ONLY; Display name of the alert type.
	AlertDisplayName *string `json:"alertDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Name of the alert type.
	AlertType *string `json:"alertType,omitempty" azure:"ro"`

	// READ-ONLY; Number of alerts occurrences within the aggregated time window.
	Count *int64 `json:"count,omitempty" azure:"ro"`

	// READ-ONLY; Description of the suspected vulnerability and meaning.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource ID of the resource that received the alerts.
	EffectedResourceType *string `json:"effectedResourceType,omitempty" azure:"ro"`

	// READ-ONLY; Log analytics query for getting the list of affected devices/alerts.
	LogAnalyticsQuery *string `json:"logAnalyticsQuery,omitempty" azure:"ro"`

	// READ-ONLY; Recommended steps for remediation.
	RemediationSteps *string `json:"remediationSteps,omitempty" azure:"ro"`

	// READ-ONLY; Assessed alert severity.
	ReportedSeverity *ReportedSeverity `json:"reportedSeverity,omitempty" azure:"ro"`

	// READ-ONLY; The type of the alerted resource (Azure, Non-Azure).
	SystemSource *string `json:"systemSource,omitempty" azure:"ro"`

	// READ-ONLY; 10 devices with the highest number of occurrences of this alert type, on this day.
	TopDevicesList []*IoTSecurityAggregatedAlertPropertiesTopDevicesListItem `json:"topDevicesList,omitempty" azure:"ro"`

	// READ-ONLY; Name of the organization that raised the alert.
	VendorName *string `json:"vendorName,omitempty" azure:"ro"`
}

type IoTSecurityAggregatedAlertPropertiesTopDevicesListItem struct {
	// READ-ONLY; Number of alerts raised for this device.
	AlertsCount *int64 `json:"alertsCount,omitempty" azure:"ro"`

	// READ-ONLY; Name of the device.
	DeviceID *string `json:"deviceId,omitempty" azure:"ro"`

	// READ-ONLY; Most recent time this alert was raised for this device, on this day.
	LastOccurrence *string `json:"lastOccurrence,omitempty" azure:"ro"`
}

// IoTSecurityAggregatedRecommendation - IoT Security solution recommendation information.
type IoTSecurityAggregatedRecommendation struct {
	// Security Solution data
	Properties *IoTSecurityAggregatedRecommendationProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IoTSecurityAggregatedRecommendationList - List of IoT Security solution aggregated recommendations.
type IoTSecurityAggregatedRecommendationList struct {
	// REQUIRED; List of aggregated recommendations data.
	Value []*IoTSecurityAggregatedRecommendation `json:"value,omitempty"`

	// READ-ONLY; When there is too much alert data for one page, use this URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// IoTSecurityAggregatedRecommendationProperties - IoT Security solution aggregated recommendation information
type IoTSecurityAggregatedRecommendationProperties struct {
	// Name of the recommendation.
	RecommendationName *string `json:"recommendationName,omitempty"`

	// READ-ONLY; Description of the suspected vulnerability and meaning.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Name of the organization that made the recommendation.
	DetectedBy *string `json:"detectedBy,omitempty" azure:"ro"`

	// READ-ONLY; Number of healthy devices within the IoT Security solution.
	HealthyDevices *int64 `json:"healthyDevices,omitempty" azure:"ro"`

	// READ-ONLY; Log analytics query for getting the list of affected devices/alerts.
	LogAnalyticsQuery *string `json:"logAnalyticsQuery,omitempty" azure:"ro"`

	// READ-ONLY; Display name of the recommendation type.
	RecommendationDisplayName *string `json:"recommendationDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Recommendation-type GUID.
	RecommendationTypeID *string `json:"recommendationTypeId,omitempty" azure:"ro"`

	// READ-ONLY; Recommended steps for remediation
	RemediationSteps *string `json:"remediationSteps,omitempty" azure:"ro"`

	// READ-ONLY; Assessed recommendation severity.
	ReportedSeverity *ReportedSeverity `json:"reportedSeverity,omitempty" azure:"ro"`

	// READ-ONLY; Number of unhealthy devices within the IoT Security solution.
	UnhealthyDeviceCount *int64 `json:"unhealthyDeviceCount,omitempty" azure:"ro"`
}

// IoTSecurityAlertedDevice - Statistical information about the number of alerts per device during last set number of days.
type IoTSecurityAlertedDevice struct {
	// READ-ONLY; Number of alerts raised for this device.
	AlertsCount *int64 `json:"alertsCount,omitempty" azure:"ro"`

	// READ-ONLY; Device identifier.
	DeviceID *string `json:"deviceId,omitempty" azure:"ro"`
}

// IoTSecurityDeviceAlert - Statistical information about the number of alerts per alert type during last set number of days
type IoTSecurityDeviceAlert struct {
	// READ-ONLY; Display name of the alert
	AlertDisplayName *string `json:"alertDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Number of alerts raised for this alert type.
	AlertsCount *int64 `json:"alertsCount,omitempty" azure:"ro"`

	// READ-ONLY; Assessed Alert severity.
	ReportedSeverity *ReportedSeverity `json:"reportedSeverity,omitempty" azure:"ro"`
}

// IoTSecurityDeviceRecommendation - Statistical information about the number of recommendations per device, per recommendation
// type.
type IoTSecurityDeviceRecommendation struct {
	// READ-ONLY; Number of devices with this recommendation.
	DevicesCount *int64 `json:"devicesCount,omitempty" azure:"ro"`

	// READ-ONLY; Display name of the recommendation.
	RecommendationDisplayName *string `json:"recommendationDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Assessed recommendation severity.
	ReportedSeverity *ReportedSeverity `json:"reportedSeverity,omitempty" azure:"ro"`
}

// IoTSecuritySolutionAnalyticsModel - Security analytics of your IoT Security solution
type IoTSecuritySolutionAnalyticsModel struct {
	// Security Solution Aggregated Alert data
	Properties *IoTSecuritySolutionAnalyticsModelProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IoTSecuritySolutionAnalyticsModelList - List of Security analytics of your IoT Security solution
type IoTSecuritySolutionAnalyticsModelList struct {
	// REQUIRED; List of Security analytics of your IoT Security solution
	Value []*IoTSecuritySolutionAnalyticsModel `json:"value,omitempty"`

	// READ-ONLY; When there is too much alert data for one page, use this URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// IoTSecuritySolutionAnalyticsModelProperties - Security analytics properties of your IoT Security solution
type IoTSecuritySolutionAnalyticsModelProperties struct {
	// List of the 3 most prevalent device alerts.
	MostPrevalentDeviceAlerts []*IoTSecurityDeviceAlert `json:"mostPrevalentDeviceAlerts,omitempty"`

	// List of the 3 most prevalent device recommendations.
	MostPrevalentDeviceRecommendations []*IoTSecurityDeviceRecommendation `json:"mostPrevalentDeviceRecommendations,omitempty"`

	// List of the 3 devices with the most alerts.
	TopAlertedDevices []*IoTSecurityAlertedDevice `json:"topAlertedDevices,omitempty"`

	// READ-ONLY; List of device metrics by the aggregation date.
	DevicesMetrics []*IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem `json:"devicesMetrics,omitempty" azure:"ro"`

	// READ-ONLY; Security analytics of your IoT Security solution.
	Metrics *IoTSeverityMetrics `json:"metrics,omitempty" azure:"ro"`

	// READ-ONLY; Number of unhealthy devices within your IoT Security solution.
	UnhealthyDeviceCount *int64 `json:"unhealthyDeviceCount,omitempty" azure:"ro"`
}

type IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem struct {
	// Aggregation of IoT Security solution device alert metrics by date.
	Date *time.Time `json:"date,omitempty"`

	// Device alert count by severity.
	DevicesMetrics *IoTSeverityMetrics `json:"devicesMetrics,omitempty"`
}

// IoTSecuritySolutionModel - IoT Security solution configuration and resource information.
type IoTSecuritySolutionModel struct {
	// The resource location.
	Location *string `json:"location,omitempty"`

	// Security Solution data
	Properties *IoTSecuritySolutionProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IoTSecuritySolutionProperties - Security Solution setting data
type IoTSecuritySolutionProperties struct {
	// REQUIRED; Resource display name.
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; IoT Hub resource IDs
	IotHubs []*string `json:"iotHubs,omitempty"`

	// List of additional workspaces
	AdditionalWorkspaces []*AdditionalWorkspacesProperties `json:"additionalWorkspaces,omitempty"`

	// Disabled data sources. Disabling these data sources compromises the system.
	DisabledDataSources []*DataSource `json:"disabledDataSources,omitempty"`

	// List of additional options for exporting to workspace data.
	Export []*ExportData `json:"export,omitempty"`

	// List of the configuration status for each recommendation type.
	RecommendationsConfiguration []*RecommendationConfigurationProperties `json:"recommendationsConfiguration,omitempty"`

	// Status of the IoT Security solution.
	Status *SecuritySolutionStatus `json:"status,omitempty"`

	// Unmasked IP address logging status
	UnmaskedIPLoggingStatus *UnmaskedIPLoggingStatus `json:"unmaskedIpLoggingStatus,omitempty"`

	// Properties of the IoT Security solution's user defined resources.
	UserDefinedResources *UserDefinedResourcesProperties `json:"userDefinedResources,omitempty"`

	// Workspace resource ID
	Workspace *string `json:"workspace,omitempty"`

	// READ-ONLY; List of resources that were automatically discovered as relevant to the security solution.
	AutoDiscoveredResources []*string `json:"autoDiscoveredResources,omitempty" azure:"ro"`
}

// IoTSecuritySolutionsList - List of IoT Security solutions.
type IoTSecuritySolutionsList struct {
	// REQUIRED; List of IoT Security solutions
	Value []*IoTSecuritySolutionModel `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// IoTSeverityMetrics - IoT Security solution analytics severity metrics.
type IoTSeverityMetrics struct {
	// Count of high severity alerts/recommendations.
	High *int64 `json:"high,omitempty"`

	// Count of low severity alerts/recommendations.
	Low *int64 `json:"low,omitempty"`

	// Count of medium severity alerts/recommendations.
	Medium *int64 `json:"medium,omitempty"`
}

// IotSecuritySolutionAnalyticsClientGetOptions contains the optional parameters for the IotSecuritySolutionAnalyticsClient.Get
// method.
type IotSecuritySolutionAnalyticsClientGetOptions struct {
	// placeholder for future optional parameters
}

// IotSecuritySolutionAnalyticsClientListOptions contains the optional parameters for the IotSecuritySolutionAnalyticsClient.List
// method.
type IotSecuritySolutionAnalyticsClientListOptions struct {
	// placeholder for future optional parameters
}

// IotSecuritySolutionClientCreateOrUpdateOptions contains the optional parameters for the IotSecuritySolutionClient.CreateOrUpdate
// method.
type IotSecuritySolutionClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// IotSecuritySolutionClientDeleteOptions contains the optional parameters for the IotSecuritySolutionClient.Delete method.
type IotSecuritySolutionClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IotSecuritySolutionClientGetOptions contains the optional parameters for the IotSecuritySolutionClient.Get method.
type IotSecuritySolutionClientGetOptions struct {
	// placeholder for future optional parameters
}

// IotSecuritySolutionClientListByResourceGroupOptions contains the optional parameters for the IotSecuritySolutionClient.ListByResourceGroup
// method.
type IotSecuritySolutionClientListByResourceGroupOptions struct {
	// Filter the IoT Security solution with OData syntax. Supports filtering by iotHubs.
	Filter *string
}

// IotSecuritySolutionClientListBySubscriptionOptions contains the optional parameters for the IotSecuritySolutionClient.ListBySubscription
// method.
type IotSecuritySolutionClientListBySubscriptionOptions struct {
	// Filter the IoT Security solution with OData syntax. Supports filtering by iotHubs.
	Filter *string
}

// IotSecuritySolutionClientUpdateOptions contains the optional parameters for the IotSecuritySolutionClient.Update method.
type IotSecuritySolutionClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// IotSecuritySolutionsAnalyticsAggregatedAlertClientDismissOptions contains the optional parameters for the IotSecuritySolutionsAnalyticsAggregatedAlertClient.Dismiss
// method.
type IotSecuritySolutionsAnalyticsAggregatedAlertClientDismissOptions struct {
	// placeholder for future optional parameters
}

// IotSecuritySolutionsAnalyticsAggregatedAlertClientGetOptions contains the optional parameters for the IotSecuritySolutionsAnalyticsAggregatedAlertClient.Get
// method.
type IotSecuritySolutionsAnalyticsAggregatedAlertClientGetOptions struct {
	// placeholder for future optional parameters
}

// IotSecuritySolutionsAnalyticsAggregatedAlertClientListOptions contains the optional parameters for the IotSecuritySolutionsAnalyticsAggregatedAlertClient.List
// method.
type IotSecuritySolutionsAnalyticsAggregatedAlertClientListOptions struct {
	// Number of results to retrieve.
	Top *int32
}

// IotSecuritySolutionsAnalyticsRecommendationClientGetOptions contains the optional parameters for the IotSecuritySolutionsAnalyticsRecommendationClient.Get
// method.
type IotSecuritySolutionsAnalyticsRecommendationClientGetOptions struct {
	// placeholder for future optional parameters
}

// IotSecuritySolutionsAnalyticsRecommendationClientListOptions contains the optional parameters for the IotSecuritySolutionsAnalyticsRecommendationClient.List
// method.
type IotSecuritySolutionsAnalyticsRecommendationClientListOptions struct {
	// Number of results to retrieve.
	Top *int32
}

// JitNetworkAccessPoliciesClientCreateOrUpdateOptions contains the optional parameters for the JitNetworkAccessPoliciesClient.CreateOrUpdate
// method.
type JitNetworkAccessPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// JitNetworkAccessPoliciesClientDeleteOptions contains the optional parameters for the JitNetworkAccessPoliciesClient.Delete
// method.
type JitNetworkAccessPoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// JitNetworkAccessPoliciesClientGetOptions contains the optional parameters for the JitNetworkAccessPoliciesClient.Get method.
type JitNetworkAccessPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// JitNetworkAccessPoliciesClientInitiateOptions contains the optional parameters for the JitNetworkAccessPoliciesClient.Initiate
// method.
type JitNetworkAccessPoliciesClientInitiateOptions struct {
	// placeholder for future optional parameters
}

// JitNetworkAccessPoliciesClientListByRegionOptions contains the optional parameters for the JitNetworkAccessPoliciesClient.ListByRegion
// method.
type JitNetworkAccessPoliciesClientListByRegionOptions struct {
	// placeholder for future optional parameters
}

// JitNetworkAccessPoliciesClientListByResourceGroupAndRegionOptions contains the optional parameters for the JitNetworkAccessPoliciesClient.ListByResourceGroupAndRegion
// method.
type JitNetworkAccessPoliciesClientListByResourceGroupAndRegionOptions struct {
	// placeholder for future optional parameters
}

// JitNetworkAccessPoliciesClientListByResourceGroupOptions contains the optional parameters for the JitNetworkAccessPoliciesClient.ListByResourceGroup
// method.
type JitNetworkAccessPoliciesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// JitNetworkAccessPoliciesClientListOptions contains the optional parameters for the JitNetworkAccessPoliciesClient.List
// method.
type JitNetworkAccessPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

type JitNetworkAccessPoliciesList struct {
	Value []*JitNetworkAccessPolicy `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

type JitNetworkAccessPolicy struct {
	// REQUIRED
	Properties *JitNetworkAccessPolicyProperties `json:"properties,omitempty"`

	// Kind of the resource
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

type JitNetworkAccessPolicyInitiatePort struct {
	// REQUIRED; The time to close the request in UTC
	EndTimeUTC *time.Time `json:"endTimeUtc,omitempty"`

	// REQUIRED
	Number *int32 `json:"number,omitempty"`

	// Source of the allowed traffic. If omitted, the request will be for the source IP address of the initiate request.
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
}

type JitNetworkAccessPolicyInitiateRequest struct {
	// REQUIRED; A list of virtual machines & ports to open access for
	VirtualMachines []*JitNetworkAccessPolicyInitiateVirtualMachine `json:"virtualMachines,omitempty"`

	// The justification for making the initiate request
	Justification *string `json:"justification,omitempty"`
}

type JitNetworkAccessPolicyInitiateVirtualMachine struct {
	// REQUIRED; Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`

	// REQUIRED; The ports to open for the resource with the id
	Ports []*JitNetworkAccessPolicyInitiatePort `json:"ports,omitempty"`
}

type JitNetworkAccessPolicyProperties struct {
	// REQUIRED; Configurations for Microsoft.Compute/virtualMachines resource type.
	VirtualMachines []*JitNetworkAccessPolicyVirtualMachine `json:"virtualMachines,omitempty"`
	Requests        []*JitNetworkAccessRequest              `json:"requests,omitempty"`

	// READ-ONLY; Gets the provisioning state of the Just-in-Time policy.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

type JitNetworkAccessPolicyVirtualMachine struct {
	// REQUIRED; Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`

	// REQUIRED; Port configurations for the virtual machine
	Ports []*JitNetworkAccessPortRule `json:"ports,omitempty"`

	// Public IP address of the Azure Firewall that is linked to this policy, if applicable
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
}

type JitNetworkAccessPortRule struct {
	// REQUIRED; Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
	MaxRequestAccessDuration *string `json:"maxRequestAccessDuration,omitempty"`

	// REQUIRED
	Number *int32 `json:"number,omitempty"`

	// REQUIRED
	Protocol *Protocol `json:"protocol,omitempty"`

	// Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3"
	// or "192.168.0.0/16".
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`

	// Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
	AllowedSourceAddressPrefixes []*string `json:"allowedSourceAddressPrefixes,omitempty"`
}

type JitNetworkAccessRequest struct {
	// REQUIRED; The identity of the person who made the request
	Requestor *string `json:"requestor,omitempty"`

	// REQUIRED; The start time of the request in UTC
	StartTimeUTC *time.Time `json:"startTimeUtc,omitempty"`

	// REQUIRED
	VirtualMachines []*JitNetworkAccessRequestVirtualMachine `json:"virtualMachines,omitempty"`

	// The justification for making the initiate request
	Justification *string `json:"justification,omitempty"`
}

type JitNetworkAccessRequestPort struct {
	// REQUIRED; The date & time at which the request ends in UTC
	EndTimeUTC *time.Time `json:"endTimeUtc,omitempty"`

	// REQUIRED
	Number *int32 `json:"number,omitempty"`

	// REQUIRED; The status of the port
	Status *Status `json:"status,omitempty"`

	// REQUIRED; A description of why the status has its value
	StatusReason *StatusReason `json:"statusReason,omitempty"`

	// Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3"
	// or "192.168.0.0/16".
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`

	// Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
	AllowedSourceAddressPrefixes []*string `json:"allowedSourceAddressPrefixes,omitempty"`

	// The port which is mapped to this port's number in the Azure Firewall, if applicable
	MappedPort *int32 `json:"mappedPort,omitempty"`
}

type JitNetworkAccessRequestVirtualMachine struct {
	// REQUIRED; Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`

	// REQUIRED; The ports that were opened for the virtual machine
	Ports []*JitNetworkAccessRequestPort `json:"ports,omitempty"`
}

// KindAutoGenerated - Describes an Azure resource with kind
type KindAutoGenerated struct {
	// Kind of the resource
	Kind *string `json:"kind,omitempty"`
}

// ListCustomAlertRuleClassification provides polymorphic access to related types.
// Call the interface's GetListCustomAlertRule() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AllowlistCustomAlertRule, *ConnectionFromIPNotAllowed, *ConnectionToIPNotAllowed, *DenylistCustomAlertRule, *ListCustomAlertRule,
// - *LocalUserNotAllowed, *ProcessNotAllowed
type ListCustomAlertRuleClassification interface {
	CustomAlertRuleClassification
	// GetListCustomAlertRule returns the ListCustomAlertRule content of the underlying type.
	GetListCustomAlertRule() *ListCustomAlertRule
}

// ListCustomAlertRule - A List custom alert rule.
type ListCustomAlertRule struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType `json:"valueType,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type ListCustomAlertRule.
func (l *ListCustomAlertRule) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: l.DisplayName,
		Description: l.Description,
		IsEnabled:   l.IsEnabled,
		RuleType:    l.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type ListCustomAlertRule.
func (l *ListCustomAlertRule) GetListCustomAlertRule() *ListCustomAlertRule { return l }

// LocalUserNotAllowed - Login by a local user that isn't allowed. Allow list consists of login names to allow.
type LocalUserNotAllowed struct {
	// REQUIRED; The values to allow. The format of the values depends on the rule type.
	AllowlistValues []*string `json:"allowlistValues,omitempty"`

	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType `json:"valueType,omitempty" azure:"ro"`
}

// GetAllowlistCustomAlertRule implements the AllowlistCustomAlertRuleClassification interface for type LocalUserNotAllowed.
func (l *LocalUserNotAllowed) GetAllowlistCustomAlertRule() *AllowlistCustomAlertRule {
	return &AllowlistCustomAlertRule{
		AllowlistValues: l.AllowlistValues,
		ValueType:       l.ValueType,
		DisplayName:     l.DisplayName,
		Description:     l.Description,
		IsEnabled:       l.IsEnabled,
		RuleType:        l.RuleType,
	}
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type LocalUserNotAllowed.
func (l *LocalUserNotAllowed) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: l.DisplayName,
		Description: l.Description,
		IsEnabled:   l.IsEnabled,
		RuleType:    l.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type LocalUserNotAllowed.
func (l *LocalUserNotAllowed) GetListCustomAlertRule() *ListCustomAlertRule {
	return &ListCustomAlertRule{
		ValueType:   l.ValueType,
		DisplayName: l.DisplayName,
		Description: l.Description,
		IsEnabled:   l.IsEnabled,
		RuleType:    l.RuleType,
	}
}

// Location - Describes an Azure resource with location
type Location struct {
	// READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty" azure:"ro"`
}

// LocationsClientGetOptions contains the optional parameters for the LocationsClient.Get method.
type LocationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LocationsClientListOptions contains the optional parameters for the LocationsClient.List method.
type LocationsClientListOptions struct {
	// placeholder for future optional parameters
}

// LogAnalyticsIdentifier - Represents a Log Analytics workspace scope identifier.
type LogAnalyticsIdentifier struct {
	// REQUIRED; There can be multiple identifiers of different type per alert, this field specify the identifier type.
	Type *ResourceIdentifierType `json:"type,omitempty"`

	// READ-ONLY; (optional) The LogAnalytics agent id reporting the event that this alert is based on.
	AgentID *string `json:"agentId,omitempty" azure:"ro"`

	// READ-ONLY; The LogAnalytics workspace id that stores this alert.
	WorkspaceID *string `json:"workspaceId,omitempty" azure:"ro"`

	// READ-ONLY; The azure resource group for the LogAnalytics workspace storing this alert
	WorkspaceResourceGroup *string `json:"workspaceResourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; The azure subscription id for the LogAnalytics workspace storing this alert.
	WorkspaceSubscriptionID *string `json:"workspaceSubscriptionId,omitempty" azure:"ro"`
}

// GetResourceIdentifier implements the ResourceIdentifierClassification interface for type LogAnalyticsIdentifier.
func (l *LogAnalyticsIdentifier) GetResourceIdentifier() *ResourceIdentifier {
	return &ResourceIdentifier{
		Type: l.Type,
	}
}

// MdeOnboardingData - The resource of the configuration or data needed to onboard the machine to MDE
type MdeOnboardingData struct {
	// Properties of the MDE configuration or data parameter needed to onboard the machine to MDE
	Properties *MdeOnboardingDataProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MdeOnboardingDataList - List of all MDE onboarding data resources
type MdeOnboardingDataList struct {
	// List of the resources of the configuration or data needed to onboard the machine to MDE
	Value []*MdeOnboardingData `json:"value,omitempty"`
}

// MdeOnboardingDataProperties - Properties of the MDE configuration or data parameter needed to onboard the machine to MDE
type MdeOnboardingDataProperties struct {
	// The onboarding package used to onboard Linux machines to MDE, coded in base64. This can also be used for onboarding using
	// the dedicated VM Extension
	OnboardingPackageLinux []byte `json:"onboardingPackageLinux,omitempty"`

	// The onboarding package used to onboard Windows machines to MDE, coded in base64. This can also be used for onboarding using
	// the dedicated VM Extension
	OnboardingPackageWindows []byte `json:"onboardingPackageWindows,omitempty"`
}

// MdeOnboardingsClientGetOptions contains the optional parameters for the MdeOnboardingsClient.Get method.
type MdeOnboardingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MdeOnboardingsClientListOptions contains the optional parameters for the MdeOnboardingsClient.List method.
type MdeOnboardingsClientListOptions struct {
	// placeholder for future optional parameters
}

// MqttC2DMessagesNotInAllowedRange - Number of cloud to device messages (MQTT protocol) is not in allowed range.
type MqttC2DMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type MqttC2DMessagesNotInAllowedRange.
func (m *MqttC2DMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: m.DisplayName,
		Description: m.Description,
		IsEnabled:   m.IsEnabled,
		RuleType:    m.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type MqttC2DMessagesNotInAllowedRange.
func (m *MqttC2DMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: m.MinThreshold,
		MaxThreshold: m.MaxThreshold,
		DisplayName:  m.DisplayName,
		Description:  m.Description,
		IsEnabled:    m.IsEnabled,
		RuleType:     m.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type MqttC2DMessagesNotInAllowedRange.
func (m *MqttC2DMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: m.TimeWindowSize,
		MinThreshold:   m.MinThreshold,
		MaxThreshold:   m.MaxThreshold,
		DisplayName:    m.DisplayName,
		Description:    m.Description,
		IsEnabled:      m.IsEnabled,
		RuleType:       m.RuleType,
	}
}

// MqttC2DRejectedMessagesNotInAllowedRange - Number of rejected cloud to device messages (MQTT protocol) is not in allowed
// range.
type MqttC2DRejectedMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type MqttC2DRejectedMessagesNotInAllowedRange.
func (m *MqttC2DRejectedMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: m.DisplayName,
		Description: m.Description,
		IsEnabled:   m.IsEnabled,
		RuleType:    m.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type MqttC2DRejectedMessagesNotInAllowedRange.
func (m *MqttC2DRejectedMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: m.MinThreshold,
		MaxThreshold: m.MaxThreshold,
		DisplayName:  m.DisplayName,
		Description:  m.Description,
		IsEnabled:    m.IsEnabled,
		RuleType:     m.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type MqttC2DRejectedMessagesNotInAllowedRange.
func (m *MqttC2DRejectedMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: m.TimeWindowSize,
		MinThreshold:   m.MinThreshold,
		MaxThreshold:   m.MaxThreshold,
		DisplayName:    m.DisplayName,
		Description:    m.Description,
		IsEnabled:      m.IsEnabled,
		RuleType:       m.RuleType,
	}
}

// MqttD2CMessagesNotInAllowedRange - Number of device to cloud messages (MQTT protocol) is not in allowed range.
type MqttD2CMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type MqttD2CMessagesNotInAllowedRange.
func (m *MqttD2CMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: m.DisplayName,
		Description: m.Description,
		IsEnabled:   m.IsEnabled,
		RuleType:    m.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type MqttD2CMessagesNotInAllowedRange.
func (m *MqttD2CMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: m.MinThreshold,
		MaxThreshold: m.MaxThreshold,
		DisplayName:  m.DisplayName,
		Description:  m.Description,
		IsEnabled:    m.IsEnabled,
		RuleType:     m.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type MqttD2CMessagesNotInAllowedRange.
func (m *MqttD2CMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: m.TimeWindowSize,
		MinThreshold:   m.MinThreshold,
		MaxThreshold:   m.MaxThreshold,
		DisplayName:    m.DisplayName,
		Description:    m.Description,
		IsEnabled:      m.IsEnabled,
		RuleType:       m.RuleType,
	}
}

// OnPremiseResourceDetailsClassification provides polymorphic access to related types.
// Call the interface's GetOnPremiseResourceDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *OnPremiseResourceDetails, *OnPremiseSQLResourceDetails
type OnPremiseResourceDetailsClassification interface {
	ResourceDetailsClassification
	// GetOnPremiseResourceDetails returns the OnPremiseResourceDetails content of the underlying type.
	GetOnPremiseResourceDetails() *OnPremiseResourceDetails
}

// OnPremiseResourceDetails - Details of the On Premise resource that was assessed
type OnPremiseResourceDetails struct {
	// REQUIRED; The name of the machine
	MachineName *string `json:"machineName,omitempty"`

	// REQUIRED; The platform where the assessed resource resides
	Source *Source `json:"source,omitempty"`

	// REQUIRED; The oms agent Id installed on the machine
	SourceComputerID *string `json:"sourceComputerId,omitempty"`

	// REQUIRED; The unique Id of the machine
	Vmuuid *string `json:"vmuuid,omitempty"`

	// REQUIRED; Azure resource Id of the workspace the machine is attached to
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// GetOnPremiseResourceDetails implements the OnPremiseResourceDetailsClassification interface for type OnPremiseResourceDetails.
func (o *OnPremiseResourceDetails) GetOnPremiseResourceDetails() *OnPremiseResourceDetails { return o }

// GetResourceDetails implements the ResourceDetailsClassification interface for type OnPremiseResourceDetails.
func (o *OnPremiseResourceDetails) GetResourceDetails() *ResourceDetails {
	return &ResourceDetails{
		Source: o.Source,
	}
}

// OnPremiseSQLResourceDetails - Details of the On Premise Sql resource that was assessed
type OnPremiseSQLResourceDetails struct {
	// REQUIRED; The Sql database name installed on the machine
	DatabaseName *string `json:"databaseName,omitempty"`

	// REQUIRED; The name of the machine
	MachineName *string `json:"machineName,omitempty"`

	// REQUIRED; The Sql server name installed on the machine
	ServerName *string `json:"serverName,omitempty"`

	// REQUIRED; The platform where the assessed resource resides
	Source *Source `json:"source,omitempty"`

	// REQUIRED; The oms agent Id installed on the machine
	SourceComputerID *string `json:"sourceComputerId,omitempty"`

	// REQUIRED; The unique Id of the machine
	Vmuuid *string `json:"vmuuid,omitempty"`

	// REQUIRED; Azure resource Id of the workspace the machine is attached to
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// GetOnPremiseResourceDetails implements the OnPremiseResourceDetailsClassification interface for type OnPremiseSQLResourceDetails.
func (o *OnPremiseSQLResourceDetails) GetOnPremiseResourceDetails() *OnPremiseResourceDetails {
	return &OnPremiseResourceDetails{
		WorkspaceID:      o.WorkspaceID,
		Vmuuid:           o.Vmuuid,
		SourceComputerID: o.SourceComputerID,
		MachineName:      o.MachineName,
		Source:           o.Source,
	}
}

// GetResourceDetails implements the ResourceDetailsClassification interface for type OnPremiseSQLResourceDetails.
func (o *OnPremiseSQLResourceDetails) GetResourceDetails() *ResourceDetails {
	return &ResourceDetails{
		Source: o.Source,
	}
}

// Operation - Possible operation in the REST API of Microsoft.Security
type Operation struct {
	// Security operation display
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Name of the operation
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Where the operation is originated
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Security operation display
type OperationDisplay struct {
	// READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the security operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationList - List of possible operations for Microsoft.Security resource provider
type OperationList struct {
	// List of Security operations
	Value []*Operation `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PathRecommendation - Represents a path that is recommended to be allowed and its properties
type PathRecommendation struct {
	// The recommendation action of the machine or rule
	Action *RecommendationAction `json:"action,omitempty"`

	// Whether the application is commonly run on the machine
	Common *bool `json:"common,omitempty"`

	// The configuration status of the machines group or machine or rule
	ConfigurationStatus *ConfigurationStatus `json:"configurationStatus,omitempty"`

	// The type of the file (for Linux files - Executable is used)
	FileType *FileType `json:"fileType,omitempty"`

	// The full path of the file, or an identifier of the application
	Path *string `json:"path,omitempty"`

	// Represents the publisher information of a process/rule
	PublisherInfo *PublisherInfo `json:"publisherInfo,omitempty"`

	// The type of IoT Security recommendation.
	Type      *RecommendationType   `json:"type,omitempty"`
	UserSids  []*string             `json:"userSids,omitempty"`
	Usernames []*UserRecommendation `json:"usernames,omitempty"`
}

// Pricing - Microsoft Defender for Cloud is provided in two pricing tiers: free and standard, with the standard tier available
// with a trial period. The standard tier offers advanced security capabilities, while
// the free tier offers basic security features.
type Pricing struct {
	// Pricing data
	Properties *PricingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PricingList - List of pricing configurations response.
type PricingList struct {
	// REQUIRED; List of pricing configurations
	Value []*Pricing `json:"value,omitempty"`
}

// PricingProperties - Pricing properties for the relevant scope
type PricingProperties struct {
	// REQUIRED; The pricing tier value. Microsoft Defender for Cloud is provided in two pricing tiers: free and standard, with
	// the standard tier available with a trial period. The standard tier offers advanced
	// security capabilities, while the free tier offers basic security features.
	PricingTier *PricingTier `json:"pricingTier,omitempty"`

	// The sub-plan selected for a Standard pricing configuration, when more than one sub-plan is available. Each sub-plan enables
	// a set of security features. When not specified, full plan is applied.
	SubPlan *string `json:"subPlan,omitempty"`

	// READ-ONLY; Optional. True if the plan is deprecated. If there are replacing plans they will appear in replacedBy property
	Deprecated *bool `json:"deprecated,omitempty" azure:"ro"`

	// READ-ONLY; The duration left for the subscriptions free trial period - in ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
	FreeTrialRemainingTime *string `json:"freeTrialRemainingTime,omitempty" azure:"ro"`

	// READ-ONLY; Optional. List of plans that replace this plan. This property exists only if this plan is deprecated.
	ReplacedBy []*string `json:"replacedBy,omitempty" azure:"ro"`
}

// PricingsClientGetOptions contains the optional parameters for the PricingsClient.Get method.
type PricingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PricingsClientListOptions contains the optional parameters for the PricingsClient.List method.
type PricingsClientListOptions struct {
	// placeholder for future optional parameters
}

// PricingsClientUpdateOptions contains the optional parameters for the PricingsClient.Update method.
type PricingsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProcessNotAllowed - Execution of a process that isn't allowed. Allow list consists of process names to allow.
type ProcessNotAllowed struct {
	// REQUIRED; The values to allow. The format of the values depends on the rule type.
	AllowlistValues []*string `json:"allowlistValues,omitempty"`

	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType `json:"valueType,omitempty" azure:"ro"`
}

// GetAllowlistCustomAlertRule implements the AllowlistCustomAlertRuleClassification interface for type ProcessNotAllowed.
func (p *ProcessNotAllowed) GetAllowlistCustomAlertRule() *AllowlistCustomAlertRule {
	return &AllowlistCustomAlertRule{
		AllowlistValues: p.AllowlistValues,
		ValueType:       p.ValueType,
		DisplayName:     p.DisplayName,
		Description:     p.Description,
		IsEnabled:       p.IsEnabled,
		RuleType:        p.RuleType,
	}
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type ProcessNotAllowed.
func (p *ProcessNotAllowed) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: p.DisplayName,
		Description: p.Description,
		IsEnabled:   p.IsEnabled,
		RuleType:    p.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type ProcessNotAllowed.
func (p *ProcessNotAllowed) GetListCustomAlertRule() *ListCustomAlertRule {
	return &ListCustomAlertRule{
		ValueType:   p.ValueType,
		DisplayName: p.DisplayName,
		Description: p.Description,
		IsEnabled:   p.IsEnabled,
		RuleType:    p.RuleType,
	}
}

// ProtectionMode - The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used
// for Linux.
type ProtectionMode struct {
	// The application control policy enforcement/protection mode of the machine group
	Exe *EnforcementMode `json:"exe,omitempty"`

	// The application control policy enforcement/protection mode of the machine group
	Executable *EnforcementMode `json:"executable,omitempty"`

	// The application control policy enforcement/protection mode of the machine group
	Msi *EnforcementMode `json:"msi,omitempty"`

	// The application control policy enforcement/protection mode of the machine group
	Script *EnforcementMode `json:"script,omitempty"`
}

// ProxyServerProperties - For a non-Azure machine that is not connected directly to the internet, specify a proxy server
// that the non-Azure machine can use.
type ProxyServerProperties struct {
	// Proxy server IP
	IP *string `json:"ip,omitempty"`

	// Proxy server port
	Port *string `json:"port,omitempty"`
}

// PublisherInfo - Represents the publisher information of a process/rule
type PublisherInfo struct {
	// The "OriginalName" field taken from the file's version resource
	BinaryName *string `json:"binaryName,omitempty"`

	// The product name taken from the file's version resource
	ProductName *string `json:"productName,omitempty"`

	// The Subject field of the x.509 certificate used to sign the code, using the following fields - O = Organization, L = Locality,
	// S = State or Province, and C = Country
	PublisherName *string `json:"publisherName,omitempty"`

	// The binary file version taken from the file's version resource
	Version *string `json:"version,omitempty"`
}

// QueryCheck - The rule query details.
type QueryCheck struct {
	// Column names of expected result.
	ColumnNames []*string `json:"columnNames,omitempty"`

	// Expected result.
	ExpectedResult [][]*string `json:"expectedResult,omitempty"`

	// The rule query.
	Query *string `json:"query,omitempty"`
}

// QueuePurgesNotInAllowedRange - Number of device queue purges is not in allowed range.
type QueuePurgesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type QueuePurgesNotInAllowedRange.
func (q *QueuePurgesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: q.DisplayName,
		Description: q.Description,
		IsEnabled:   q.IsEnabled,
		RuleType:    q.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type QueuePurgesNotInAllowedRange.
func (q *QueuePurgesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: q.MinThreshold,
		MaxThreshold: q.MaxThreshold,
		DisplayName:  q.DisplayName,
		Description:  q.Description,
		IsEnabled:    q.IsEnabled,
		RuleType:     q.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type QueuePurgesNotInAllowedRange.
func (q *QueuePurgesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: q.TimeWindowSize,
		MinThreshold:   q.MinThreshold,
		MaxThreshold:   q.MaxThreshold,
		DisplayName:    q.DisplayName,
		Description:    q.Description,
		IsEnabled:      q.IsEnabled,
		RuleType:       q.RuleType,
	}
}

// RecommendationConfigurationProperties - The type of IoT Security recommendation.
type RecommendationConfigurationProperties struct {
	// REQUIRED; The type of IoT Security recommendation.
	RecommendationType *RecommendationType `json:"recommendationType,omitempty"`

	// REQUIRED; Recommendation status. When the recommendation status is disabled recommendations are not generated.
	Status *RecommendationConfigStatus `json:"status,omitempty"`

	// READ-ONLY
	Name *string `json:"name,omitempty" azure:"ro"`
}

// RegulatoryComplianceAssessment - Regulatory compliance assessment details and state
type RegulatoryComplianceAssessment struct {
	// Regulatory compliance assessment data
	Properties *RegulatoryComplianceAssessmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegulatoryComplianceAssessmentList - List of regulatory compliance assessment response
type RegulatoryComplianceAssessmentList struct {
	// REQUIRED
	Value []*RegulatoryComplianceAssessment `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// RegulatoryComplianceAssessmentProperties - Regulatory compliance assessment data
type RegulatoryComplianceAssessmentProperties struct {
	// Aggregative state based on the assessment's scanned resources states
	State *State `json:"state,omitempty"`

	// READ-ONLY; Link to more detailed assessment results data. The response type will be according to the assessmentType field
	AssessmentDetailsLink *string `json:"assessmentDetailsLink,omitempty" azure:"ro"`

	// READ-ONLY; The expected type of assessment contained in the AssessmentDetailsLink
	AssessmentType *string `json:"assessmentType,omitempty" azure:"ro"`

	// READ-ONLY; The description of the regulatory compliance assessment
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The given assessment's related resources count with failed state.
	FailedResources *int32 `json:"failedResources,omitempty" azure:"ro"`

	// READ-ONLY; The given assessment's related resources count with passed state.
	PassedResources *int32 `json:"passedResources,omitempty" azure:"ro"`

	// READ-ONLY; The given assessment's related resources count with skipped state.
	SkippedResources *int32 `json:"skippedResources,omitempty" azure:"ro"`

	// READ-ONLY; The given assessment's related resources count with unsupported state.
	UnsupportedResources *int32 `json:"unsupportedResources,omitempty" azure:"ro"`
}

// RegulatoryComplianceAssessmentsClientGetOptions contains the optional parameters for the RegulatoryComplianceAssessmentsClient.Get
// method.
type RegulatoryComplianceAssessmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RegulatoryComplianceAssessmentsClientListOptions contains the optional parameters for the RegulatoryComplianceAssessmentsClient.List
// method.
type RegulatoryComplianceAssessmentsClientListOptions struct {
	// OData filter. Optional.
	Filter *string
}

// RegulatoryComplianceControl - Regulatory compliance control details and state
type RegulatoryComplianceControl struct {
	// Regulatory compliance control data
	Properties *RegulatoryComplianceControlProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegulatoryComplianceControlList - List of regulatory compliance controls response
type RegulatoryComplianceControlList struct {
	// REQUIRED; List of regulatory compliance controls
	Value []*RegulatoryComplianceControl `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// RegulatoryComplianceControlProperties - Regulatory compliance control data
type RegulatoryComplianceControlProperties struct {
	// Aggregative state based on the control's supported assessments states
	State *State `json:"state,omitempty"`

	// READ-ONLY; The description of the regulatory compliance control
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The number of supported regulatory compliance assessments of the given control with a failed state
	FailedAssessments *int32 `json:"failedAssessments,omitempty" azure:"ro"`

	// READ-ONLY; The number of supported regulatory compliance assessments of the given control with a passed state
	PassedAssessments *int32 `json:"passedAssessments,omitempty" azure:"ro"`

	// READ-ONLY; The number of supported regulatory compliance assessments of the given control with a skipped state
	SkippedAssessments *int32 `json:"skippedAssessments,omitempty" azure:"ro"`
}

// RegulatoryComplianceControlsClientGetOptions contains the optional parameters for the RegulatoryComplianceControlsClient.Get
// method.
type RegulatoryComplianceControlsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RegulatoryComplianceControlsClientListOptions contains the optional parameters for the RegulatoryComplianceControlsClient.List
// method.
type RegulatoryComplianceControlsClientListOptions struct {
	// OData filter. Optional.
	Filter *string
}

// RegulatoryComplianceStandard - Regulatory compliance standard details and state
type RegulatoryComplianceStandard struct {
	// Regulatory compliance standard data
	Properties *RegulatoryComplianceStandardProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegulatoryComplianceStandardList - List of regulatory compliance standards response
type RegulatoryComplianceStandardList struct {
	// REQUIRED
	Value []*RegulatoryComplianceStandard `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// RegulatoryComplianceStandardProperties - Regulatory compliance standard data
type RegulatoryComplianceStandardProperties struct {
	// Aggregative state based on the standard's supported controls states
	State *State `json:"state,omitempty"`

	// READ-ONLY; The number of supported regulatory compliance controls of the given standard with a failed state
	FailedControls *int32 `json:"failedControls,omitempty" azure:"ro"`

	// READ-ONLY; The number of supported regulatory compliance controls of the given standard with a passed state
	PassedControls *int32 `json:"passedControls,omitempty" azure:"ro"`

	// READ-ONLY; The number of supported regulatory compliance controls of the given standard with a skipped state
	SkippedControls *int32 `json:"skippedControls,omitempty" azure:"ro"`

	// READ-ONLY; The number of regulatory compliance controls of the given standard which are unsupported by automated assessments
	UnsupportedControls *int32 `json:"unsupportedControls,omitempty" azure:"ro"`
}

// RegulatoryComplianceStandardsClientGetOptions contains the optional parameters for the RegulatoryComplianceStandardsClient.Get
// method.
type RegulatoryComplianceStandardsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RegulatoryComplianceStandardsClientListOptions contains the optional parameters for the RegulatoryComplianceStandardsClient.List
// method.
type RegulatoryComplianceStandardsClientListOptions struct {
	// OData filter. Optional.
	Filter *string
}

// Remediation details.
type Remediation struct {
	// Is remediation automated.
	Automated *bool `json:"automated,omitempty"`

	// Remediation description.
	Description *string `json:"description,omitempty"`

	// Optional link to remediate in Azure Portal.
	PortalLink *string `json:"portalLink,omitempty"`

	// Remediation script.
	Scripts []*string `json:"scripts,omitempty"`
}

// RemediationEta - The ETA (estimated time of arrival) for remediation
type RemediationEta struct {
	// REQUIRED; ETA for remediation.
	Eta *time.Time `json:"eta,omitempty"`

	// REQUIRED; Justification for change of Eta.
	Justification *string `json:"justification,omitempty"`
}

// Resource - Describes an Azure resource.
type Resource struct {
	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceDetailsClassification provides polymorphic access to related types.
// Call the interface's GetResourceDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureResourceDetails, *OnPremiseResourceDetails, *OnPremiseSQLResourceDetails, *ResourceDetails
type ResourceDetailsClassification interface {
	// GetResourceDetails returns the ResourceDetails content of the underlying type.
	GetResourceDetails() *ResourceDetails
}

// ResourceDetails - Details of the resource that was assessed
type ResourceDetails struct {
	// REQUIRED; The platform where the assessed resource resides
	Source *Source `json:"source,omitempty"`
}

// GetResourceDetails implements the ResourceDetailsClassification interface for type ResourceDetails.
func (r *ResourceDetails) GetResourceDetails() *ResourceDetails { return r }

// ResourceIdentifierClassification provides polymorphic access to related types.
// Call the interface's GetResourceIdentifier() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureResourceIdentifier, *LogAnalyticsIdentifier, *ResourceIdentifier
type ResourceIdentifierClassification interface {
	// GetResourceIdentifier returns the ResourceIdentifier content of the underlying type.
	GetResourceIdentifier() *ResourceIdentifier
}

// ResourceIdentifier - A resource identifier for an alert which can be used to direct the alert to the right product exposure
// group (tenant, workspace, subscription etc.).
type ResourceIdentifier struct {
	// REQUIRED; There can be multiple identifiers of different type per alert, this field specify the identifier type.
	Type *ResourceIdentifierType `json:"type,omitempty"`
}

// GetResourceIdentifier implements the ResourceIdentifierClassification interface for type ResourceIdentifier.
func (r *ResourceIdentifier) GetResourceIdentifier() *ResourceIdentifier { return r }

// Rule - Describes remote addresses that is recommended to communicate with the Azure resource on some (Protocol, Port, Direction).
// All other remote addresses are recommended to be blocked
type Rule struct {
	// The rule's destination port
	DestinationPort *int32 `json:"destinationPort,omitempty"`

	// The rule's direction
	Direction *Direction `json:"direction,omitempty"`

	// The remote IP addresses that should be able to communicate with the Azure resource on the rule's destination port and protocol
	IPAddresses []*string `json:"ipAddresses,omitempty"`

	// The name of the rule
	Name *string `json:"name,omitempty"`

	// The rule's transport protocols
	Protocols []*TransportProtocol `json:"protocols,omitempty"`
}

// RuleResults - Rule results.
type RuleResults struct {
	// Rule results properties.
	Properties *RuleResultsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RuleResultsInput - Rule results input.
type RuleResultsInput struct {
	// Take results from latest scan.
	LatestScan *bool `json:"latestScan,omitempty"`

	// Expected results to be inserted into the baseline. Leave this field empty it LatestScan == true.
	Results [][]*string `json:"results,omitempty"`
}

// RuleResultsProperties - Rule results properties.
type RuleResultsProperties struct {
	// Expected results in the baseline.
	Results [][]*string `json:"results,omitempty"`
}

// RulesResults - A list of rules results.
type RulesResults struct {
	// List of rule results.
	Value []*RuleResults `json:"value,omitempty"`
}

// RulesResultsInput - Rules results input.
type RulesResultsInput struct {
	// Take results from latest scan.
	LatestScan *bool `json:"latestScan,omitempty"`

	// Expected results to be inserted into the baseline. Leave this field empty it LatestScan == true.
	Results map[string][][]*string `json:"results,omitempty"`
}

// SQLServerVulnerabilityProperties - Details of the resource that was assessed
type SQLServerVulnerabilityProperties struct {
	// REQUIRED; Sub-assessment resource type
	AssessedResourceType *AssessedResourceType `json:"assessedResourceType,omitempty"`

	// READ-ONLY; The T-SQL query that runs on your SQL database to perform the particular check
	Query *string `json:"query,omitempty" azure:"ro"`

	// READ-ONLY; The resource type the sub assessment refers to in its resource details
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetAdditionalData implements the AdditionalDataClassification interface for type SQLServerVulnerabilityProperties.
func (s *SQLServerVulnerabilityProperties) GetAdditionalData() *AdditionalData {
	return &AdditionalData{
		AssessedResourceType: s.AssessedResourceType,
	}
}

// SQLVulnerabilityAssessmentBaselineRulesClientAddOptions contains the optional parameters for the SQLVulnerabilityAssessmentBaselineRulesClient.Add
// method.
type SQLVulnerabilityAssessmentBaselineRulesClientAddOptions struct {
	// The baseline rules.
	Body *RulesResultsInput
}

// SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateOptions contains the optional parameters for the SQLVulnerabilityAssessmentBaselineRulesClient.CreateOrUpdate
// method.
type SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateOptions struct {
	// The baseline results for this rule.
	Body *RuleResultsInput
}

// SQLVulnerabilityAssessmentBaselineRulesClientDeleteOptions contains the optional parameters for the SQLVulnerabilityAssessmentBaselineRulesClient.Delete
// method.
type SQLVulnerabilityAssessmentBaselineRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SQLVulnerabilityAssessmentBaselineRulesClientGetOptions contains the optional parameters for the SQLVulnerabilityAssessmentBaselineRulesClient.Get
// method.
type SQLVulnerabilityAssessmentBaselineRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLVulnerabilityAssessmentBaselineRulesClientListOptions contains the optional parameters for the SQLVulnerabilityAssessmentBaselineRulesClient.List
// method.
type SQLVulnerabilityAssessmentBaselineRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLVulnerabilityAssessmentScanResultsClientGetOptions contains the optional parameters for the SQLVulnerabilityAssessmentScanResultsClient.Get
// method.
type SQLVulnerabilityAssessmentScanResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLVulnerabilityAssessmentScanResultsClientListOptions contains the optional parameters for the SQLVulnerabilityAssessmentScanResultsClient.List
// method.
type SQLVulnerabilityAssessmentScanResultsClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLVulnerabilityAssessmentScansClientGetOptions contains the optional parameters for the SQLVulnerabilityAssessmentScansClient.Get
// method.
type SQLVulnerabilityAssessmentScansClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLVulnerabilityAssessmentScansClientListOptions contains the optional parameters for the SQLVulnerabilityAssessmentScansClient.List
// method.
type SQLVulnerabilityAssessmentScansClientListOptions struct {
	// placeholder for future optional parameters
}

// Scan - A vulnerability assessment scan record.
type Scan struct {
	// A vulnerability assessment scan record properties.
	Properties *ScanProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScanProperties - A vulnerability assessment scan record properties.
type ScanProperties struct {
	// The database name.
	Database *string `json:"database,omitempty"`

	// Scan results are valid until end time (UTC).
	EndTime *time.Time `json:"endTime,omitempty"`

	// The number of failed rules with high severity.
	HighSeverityFailedRulesCount *int32 `json:"highSeverityFailedRulesCount,omitempty"`

	// Baseline created for this database, and has one or more rules.
	IsBaselineApplied *bool `json:"isBaselineApplied,omitempty"`

	// The number of failed rules with low severity.
	LowSeverityFailedRulesCount *int32 `json:"lowSeverityFailedRulesCount,omitempty"`

	// The number of failed rules with medium severity.
	MediumSeverityFailedRulesCount *int32 `json:"mediumSeverityFailedRulesCount,omitempty"`

	// The SQL version.
	SQLVersion *string `json:"sqlVersion,omitempty"`

	// The server name.
	Server *string `json:"server,omitempty"`

	// The scan start time (UTC).
	StartTime *time.Time `json:"startTime,omitempty"`

	// The scan status.
	State *ScanState `json:"state,omitempty"`

	// The number of total failed rules.
	TotalFailedRulesCount *int32 `json:"totalFailedRulesCount,omitempty"`

	// The number of total passed rules.
	TotalPassedRulesCount *int32 `json:"totalPassedRulesCount,omitempty"`

	// The number of total rules assessed.
	TotalRulesCount *int32 `json:"totalRulesCount,omitempty"`

	// The scan trigger type.
	TriggerType *ScanTriggerType `json:"triggerType,omitempty"`
}

// ScanResult - A vulnerability assessment scan result for a single rule.
type ScanResult struct {
	// A vulnerability assessment scan result properties for a single rule.
	Properties *ScanResultProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScanResultProperties - A vulnerability assessment scan result properties for a single rule.
type ScanResultProperties struct {
	// The rule result adjusted with baseline.
	BaselineAdjustedResult *BaselineAdjustedResult `json:"baselineAdjustedResult,omitempty"`

	// Indicated whether the results specified here are trimmed.
	IsTrimmed *bool `json:"isTrimmed,omitempty"`

	// The results of the query that was run.
	QueryResults [][]*string `json:"queryResults,omitempty"`

	// Remediation details.
	Remediation *Remediation `json:"remediation,omitempty"`

	// The rule Id.
	RuleID *string `json:"ruleId,omitempty"`

	// vulnerability assessment rule metadata details.
	RuleMetadata *VaRule `json:"ruleMetadata,omitempty"`

	// The rule result status.
	Status *RuleStatus `json:"status,omitempty"`
}

// ScanResults - A list of vulnerability assessment scan results.
type ScanResults struct {
	// List of vulnerability assessment scan results.
	Value []*ScanResult `json:"value,omitempty"`
}

// Scans - A list of vulnerability assessment scan records.
type Scans struct {
	// List of vulnerability assessment scan records.
	Value []*Scan `json:"value,omitempty"`
}

// ScopeElement - A more specific scope used to identify the alerts to suppress.
type ScopeElement struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The alert entity type to suppress by.
	Field *string `json:"field,omitempty"`
}

// ScoreDetails - Calculation result data
type ScoreDetails struct {
	// READ-ONLY; Current score
	Current *float64 `json:"current,omitempty" azure:"ro"`

	// READ-ONLY; Maximum score available
	Max *int32 `json:"max,omitempty" azure:"ro"`

	// READ-ONLY; Ratio of the current score divided by the maximum. Rounded to 4 digits after the decimal point
	Percentage *float64 `json:"percentage,omitempty" azure:"ro"`
}

// SecureScoreControlDefinitionItem - Information about the security control.
type SecureScoreControlDefinitionItem struct {
	// Security Control Definition Properties.
	Properties *SecureScoreControlDefinitionItemProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecureScoreControlDefinitionItemProperties - Security Control Definition Properties.
type SecureScoreControlDefinitionItemProperties struct {
	// READ-ONLY; Array of assessments metadata IDs that are included in this security control
	AssessmentDefinitions []*AzureResourceLink `json:"assessmentDefinitions,omitempty" azure:"ro"`

	// READ-ONLY; User friendly description of the control
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; User friendly display name of the control
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Maximum control score (0..10)
	MaxScore *int32 `json:"maxScore,omitempty" azure:"ro"`

	// READ-ONLY; Source object from which the control was created
	Source *SecureScoreControlDefinitionSource `json:"source,omitempty" azure:"ro"`
}

// SecureScoreControlDefinitionList - List of security controls definition
type SecureScoreControlDefinitionList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Collection of security controls definition in this page
	Value []*SecureScoreControlDefinitionItem `json:"value,omitempty" azure:"ro"`
}

// SecureScoreControlDefinitionSource - The type of the security control (For example, BuiltIn)
type SecureScoreControlDefinitionSource struct {
	// The type of security control (for example, BuiltIn)
	SourceType *ControlType `json:"sourceType,omitempty"`
}

// SecureScoreControlDefinitionsClientListBySubscriptionOptions contains the optional parameters for the SecureScoreControlDefinitionsClient.ListBySubscription
// method.
type SecureScoreControlDefinitionsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// SecureScoreControlDefinitionsClientListOptions contains the optional parameters for the SecureScoreControlDefinitionsClient.List
// method.
type SecureScoreControlDefinitionsClientListOptions struct {
	// placeholder for future optional parameters
}

// SecureScoreControlDetails - Details of the security control, its score, and the health status of the relevant resources.
type SecureScoreControlDetails struct {
	// Calculation result data in control level
	Properties *SecureScoreControlScoreDetails `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecureScoreControlList - List of security controls
type SecureScoreControlList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Collection of security controls in this page
	Value []*SecureScoreControlDetails `json:"value,omitempty" azure:"ro"`
}

// SecureScoreControlScore - Calculation result data
type SecureScoreControlScore struct {
	// READ-ONLY; Actual score for the control = (achieved points / total points) * max score. if total points is zeroed, the
	// return number is 0.00
	Current *float64 `json:"current,omitempty" azure:"ro"`

	// READ-ONLY; Maximum control score (0..10)
	Max *int32 `json:"max,omitempty" azure:"ro"`

	// READ-ONLY; Ratio of the current score divided by the maximum. Rounded to 4 digits after the decimal point
	Percentage *float64 `json:"percentage,omitempty" azure:"ro"`
}

// SecureScoreControlScoreDetails - Calculation result data in control level
type SecureScoreControlScoreDetails struct {
	// Information about the security control.
	Definition *SecureScoreControlDefinitionItem `json:"definition,omitempty"`

	// READ-ONLY; User friendly display name of the control
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Number of healthy resources in the control
	HealthyResourceCount *int32 `json:"healthyResourceCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of not applicable resources in the control
	NotApplicableResourceCount *int32 `json:"notApplicableResourceCount,omitempty" azure:"ro"`

	// READ-ONLY; Actual score object for the control
	Score *ScoreDetails `json:"score,omitempty" azure:"ro"`

	// READ-ONLY; Number of unhealthy resources in the control
	UnhealthyResourceCount *int32 `json:"unhealthyResourceCount,omitempty" azure:"ro"`

	// READ-ONLY; The relative weight for this specific control in each of your subscriptions. Used when calculating an aggregated
	// score for this control across all of your subscriptions.
	Weight *int64 `json:"weight,omitempty" azure:"ro"`
}

// SecureScoreControlsClientListBySecureScoreOptions contains the optional parameters for the SecureScoreControlsClient.ListBySecureScore
// method.
type SecureScoreControlsClientListBySecureScoreOptions struct {
	// OData expand. Optional.
	Expand *ExpandControlsEnum
}

// SecureScoreControlsClientListOptions contains the optional parameters for the SecureScoreControlsClient.List method.
type SecureScoreControlsClientListOptions struct {
	// OData expand. Optional.
	Expand *ExpandControlsEnum
}

// SecureScoreItem - Secure score item data model
type SecureScoreItem struct {
	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Secure score item
	Properties *SecureScoreItemProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecureScoreItemProperties - Describes properties of a calculated secure score.
type SecureScoreItemProperties struct {
	// READ-ONLY; The initiative’s name
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; score object
	Score *ScoreDetails `json:"score,omitempty" azure:"ro"`

	// READ-ONLY; The relative weight for each subscription. Used when calculating an aggregated secure score for multiple subscriptions.
	Weight *int64 `json:"weight,omitempty" azure:"ro"`
}

// SecureScoresClientGetOptions contains the optional parameters for the SecureScoresClient.Get method.
type SecureScoresClientGetOptions struct {
	// placeholder for future optional parameters
}

// SecureScoresClientListOptions contains the optional parameters for the SecureScoresClient.List method.
type SecureScoresClientListOptions struct {
	// placeholder for future optional parameters
}

// SecureScoresList - List of secure scores
type SecureScoresList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Collection of secure scores in this page
	Value []*SecureScoreItem `json:"value,omitempty" azure:"ro"`
}

// SensitivityLabel - The sensitivity label.
type SensitivityLabel struct {
	// The description of the sensitivity label.
	Description *string `json:"description,omitempty"`

	// The name of the sensitivity label.
	DisplayName *string `json:"displayName,omitempty"`

	// Indicates whether the label is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`

	// The order of the sensitivity label.
	Order *int32 `json:"order,omitempty"`

	// The rank of the sensitivity label.
	Rank *Rank `json:"rank,omitempty"`
}

// ServerVulnerabilityAssessment - Describes the server vulnerability assessment details on a resource
type ServerVulnerabilityAssessment struct {
	// describes ServerVulnerabilityAssessment properties.
	Properties *ServerVulnerabilityAssessmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerVulnerabilityAssessmentClientBeginDeleteOptions contains the optional parameters for the ServerVulnerabilityAssessmentClient.BeginDelete
// method.
type ServerVulnerabilityAssessmentClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerVulnerabilityAssessmentClientCreateOrUpdateOptions contains the optional parameters for the ServerVulnerabilityAssessmentClient.CreateOrUpdate
// method.
type ServerVulnerabilityAssessmentClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServerVulnerabilityAssessmentClientGetOptions contains the optional parameters for the ServerVulnerabilityAssessmentClient.Get
// method.
type ServerVulnerabilityAssessmentClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerVulnerabilityAssessmentClientListByExtendedResourceOptions contains the optional parameters for the ServerVulnerabilityAssessmentClient.ListByExtendedResource
// method.
type ServerVulnerabilityAssessmentClientListByExtendedResourceOptions struct {
	// placeholder for future optional parameters
}

// ServerVulnerabilityAssessmentProperties - describes ServerVulnerabilityAssessment properties.
type ServerVulnerabilityAssessmentProperties struct {
	// READ-ONLY; The provisioningState of the vulnerability assessment capability on the VM
	ProvisioningState *ServerVulnerabilityAssessmentPropertiesProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ServerVulnerabilityAssessmentsList - List of server vulnerability assessments
type ServerVulnerabilityAssessmentsList struct {
	Value []*ServerVulnerabilityAssessment `json:"value,omitempty"`
}

// ServerVulnerabilityProperties - Additional context fields for server vulnerability assessment
type ServerVulnerabilityProperties struct {
	// REQUIRED; Sub-assessment resource type
	AssessedResourceType *AssessedResourceType `json:"assessedResourceType,omitempty"`

	// READ-ONLY; List of CVEs
	Cve []*CVE `json:"cve,omitempty" azure:"ro"`

	// READ-ONLY; Dictionary from cvss version to cvss details object
	Cvss map[string]*CVSS `json:"cvss,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether a patch is available or not
	Patchable *bool `json:"patchable,omitempty" azure:"ro"`

	// READ-ONLY; Published time
	PublishedTime *time.Time `json:"publishedTime,omitempty" azure:"ro"`

	// READ-ONLY; Threat name
	Threat *string `json:"threat,omitempty" azure:"ro"`

	// READ-ONLY; Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY
	VendorReferences []*VendorReference `json:"vendorReferences,omitempty" azure:"ro"`
}

// GetAdditionalData implements the AdditionalDataClassification interface for type ServerVulnerabilityProperties.
func (s *ServerVulnerabilityProperties) GetAdditionalData() *AdditionalData {
	return &AdditionalData{
		AssessedResourceType: s.AssessedResourceType,
	}
}

// ServicePrincipalProperties - Details of the service principal.
type ServicePrincipalProperties struct {
	// Application ID of service principal.
	ApplicationID *string `json:"applicationId,omitempty"`

	// A secret string that the application uses to prove its identity, also can be referred to as application password (write
	// only).
	Secret *string `json:"secret,omitempty"`
}

// SettingClassification provides polymorphic access to related types.
// Call the interface's GetSetting() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AlertSyncSettings, *DataExportSettings, *Setting
type SettingClassification interface {
	// GetSetting returns the Setting content of the underlying type.
	GetSetting() *Setting
}

// Setting - The kind of the security setting
type Setting struct {
	// REQUIRED; the kind of the settings string
	Kind *SettingKind `json:"kind,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetSetting implements the SettingClassification interface for type Setting.
func (s *Setting) GetSetting() *Setting { return s }

// SettingsClientGetOptions contains the optional parameters for the SettingsClient.Get method.
type SettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SettingsClientListOptions contains the optional parameters for the SettingsClient.List method.
type SettingsClientListOptions struct {
	// placeholder for future optional parameters
}

// SettingsClientUpdateOptions contains the optional parameters for the SettingsClient.Update method.
type SettingsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SettingsList - Subscription settings list.
type SettingsList struct {
	// The settings list.
	Value []SettingClassification `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// Software - Represents a software data
type Software struct {
	// REQUIRED; Properties of the Software Inventory resource
	Properties *SoftwareProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SoftwareInventoriesClientGetOptions contains the optional parameters for the SoftwareInventoriesClient.Get method.
type SoftwareInventoriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SoftwareInventoriesClientListByExtendedResourceOptions contains the optional parameters for the SoftwareInventoriesClient.ListByExtendedResource
// method.
type SoftwareInventoriesClientListByExtendedResourceOptions struct {
	// placeholder for future optional parameters
}

// SoftwareInventoriesClientListBySubscriptionOptions contains the optional parameters for the SoftwareInventoriesClient.ListBySubscription
// method.
type SoftwareInventoriesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// SoftwareProperties - Software Inventory resource properties
type SoftwareProperties struct {
	// Unique identifier for the virtual machine in the service.
	DeviceID *string `json:"deviceId,omitempty"`

	// The end of support date in case the product is upcoming end of support.
	EndOfSupportDate *string `json:"endOfSupportDate,omitempty"`

	// End of support status.
	EndOfSupportStatus *EndOfSupportStatus `json:"endOfSupportStatus,omitempty"`

	// First time that the software was seen in the device.
	FirstSeenAt *string `json:"firstSeenAt,omitempty"`

	// Number of weaknesses.
	NumberOfKnownVulnerabilities *int32 `json:"numberOfKnownVulnerabilities,omitempty"`

	// Platform of the operating system running on the device.
	OSPlatform *string `json:"osPlatform,omitempty"`

	// Name of the software product.
	SoftwareName *string `json:"softwareName,omitempty"`

	// Name of the software vendor.
	Vendor *string `json:"vendor,omitempty"`

	// Version number of the software product.
	Version *string `json:"version,omitempty"`
}

// SoftwaresList - Represents the software inventory of the virtual machine.
type SoftwaresList struct {
	Value []*Software `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

type Solution struct {
	Properties *SolutionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

type SolutionList struct {
	Value []*Solution `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

type SolutionProperties struct {
	// REQUIRED; The security solutions' status
	ProtectionStatus *string `json:"protectionStatus,omitempty"`

	// REQUIRED; The security family provisioning State
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`

	// REQUIRED; The security family of the security solution
	SecurityFamily *SecurityFamily `json:"securityFamily,omitempty"`

	// REQUIRED; The security solutions' template
	Template *string `json:"template,omitempty"`
}

// SolutionsClientGetOptions contains the optional parameters for the SolutionsClient.Get method.
type SolutionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SolutionsClientListOptions contains the optional parameters for the SolutionsClient.List method.
type SolutionsClientListOptions struct {
	// placeholder for future optional parameters
}

type SolutionsReferenceData struct {
	// REQUIRED
	Properties *SolutionsReferenceDataProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SolutionsReferenceDataClientListByHomeRegionOptions contains the optional parameters for the SolutionsReferenceDataClient.ListByHomeRegion
// method.
type SolutionsReferenceDataClientListByHomeRegionOptions struct {
	// placeholder for future optional parameters
}

// SolutionsReferenceDataClientListOptions contains the optional parameters for the SolutionsReferenceDataClient.List method.
type SolutionsReferenceDataClientListOptions struct {
	// placeholder for future optional parameters
}

type SolutionsReferenceDataList struct {
	Value []*SolutionsReferenceData `json:"value,omitempty"`
}

type SolutionsReferenceDataProperties struct {
	// REQUIRED; The security solutions' vendor name
	AlertVendorName *string `json:"alertVendorName,omitempty"`

	// REQUIRED; The security solutions' package info url
	PackageInfoURL *string `json:"packageInfoUrl,omitempty"`

	// REQUIRED; The security solutions' product name
	ProductName *string `json:"productName,omitempty"`

	// REQUIRED; The security solutions' publisher
	Publisher *string `json:"publisher,omitempty"`

	// REQUIRED; The security solutions' publisher display name
	PublisherDisplayName *string `json:"publisherDisplayName,omitempty"`

	// REQUIRED; The security family of the security solution
	SecurityFamily *SecurityFamily `json:"securityFamily,omitempty"`

	// REQUIRED; The security solutions' template
	Template *string `json:"template,omitempty"`
}

// SubAssessment - Security sub-assessment on a resource
type SubAssessment struct {
	// Describes properties of an sub-assessment.
	Properties *SubAssessmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SubAssessmentList - List of security sub-assessments
type SubAssessmentList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY
	Value []*SubAssessment `json:"value,omitempty" azure:"ro"`
}

// SubAssessmentProperties - Describes properties of an sub-assessment.
type SubAssessmentProperties struct {
	// Details of the sub-assessment
	AdditionalData AdditionalDataClassification `json:"additionalData,omitempty"`

	// Details of the resource that was assessed
	ResourceDetails ResourceDetailsClassification `json:"resourceDetails,omitempty"`

	// Status of the sub-assessment
	Status *SubAssessmentStatus `json:"status,omitempty"`

	// READ-ONLY; Category of the sub-assessment
	Category *string `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; Human readable description of the assessment status
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; User friendly display name of the sub-assessment
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Vulnerability ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Description of the impact of this sub-assessment
	Impact *string `json:"impact,omitempty" azure:"ro"`

	// READ-ONLY; Information on how to remediate this sub-assessment
	Remediation *string `json:"remediation,omitempty" azure:"ro"`

	// READ-ONLY; The date and time the sub-assessment was generated
	TimeGenerated *time.Time `json:"timeGenerated,omitempty" azure:"ro"`
}

// SubAssessmentStatus - Status of the sub-assessment
type SubAssessmentStatus struct {
	// READ-ONLY; Programmatic code for the cause of the assessment status
	Cause *string `json:"cause,omitempty" azure:"ro"`

	// READ-ONLY; Programmatic code for the status of the assessment
	Code *SubAssessmentStatusCode `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Human readable description of the assessment status
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The sub-assessment severity level
	Severity *Severity `json:"severity,omitempty" azure:"ro"`
}

// SubAssessmentsClientGetOptions contains the optional parameters for the SubAssessmentsClient.Get method.
type SubAssessmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SubAssessmentsClientListAllOptions contains the optional parameters for the SubAssessmentsClient.ListAll method.
type SubAssessmentsClientListAllOptions struct {
	// placeholder for future optional parameters
}

// SubAssessmentsClientListOptions contains the optional parameters for the SubAssessmentsClient.List method.
type SubAssessmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionGovernanceRulesExecuteStatusClientBeginGetOptions contains the optional parameters for the SubscriptionGovernanceRulesExecuteStatusClient.BeginGet
// method.
type SubscriptionGovernanceRulesExecuteStatusClientBeginGetOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

type SuppressionAlertsScope struct {
	// REQUIRED; All the conditions inside need to be true in order to suppress the alert
	AllOf []*ScopeElement `json:"allOf,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// Tags - A list of key value pairs that describe the resource.
type Tags struct {
	// A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TagsResource - A container holding only the Tags for a resource, allowing the user to update the tags.
type TagsResource struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// Task - Security task that we recommend to do in order to strengthen security
type Task struct {
	// Describes properties of a task.
	Properties *TaskProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TaskList - List of security task recommendations
type TaskList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY
	Value []*Task `json:"value,omitempty" azure:"ro"`
}

// TaskParameters - Changing set of properties, depending on the task type that is derived from the name field
type TaskParameters struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; Name of the task type
	Name *string `json:"name,omitempty" azure:"ro"`
}

// TaskProperties - Describes properties of a task.
type TaskProperties struct {
	// Changing set of properties, depending on the task type that is derived from the name field
	SecurityTaskParameters *TaskParameters `json:"securityTaskParameters,omitempty"`

	// READ-ONLY; The time this task was discovered in UTC
	CreationTimeUTC *time.Time `json:"creationTimeUtc,omitempty" azure:"ro"`

	// READ-ONLY; The time this task's details were last changed in UTC
	LastStateChangeTimeUTC *time.Time `json:"lastStateChangeTimeUtc,omitempty" azure:"ro"`

	// READ-ONLY; State of the task (Active, Resolved etc.)
	State *string `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Additional data on the state of the task
	SubState *string `json:"subState,omitempty" azure:"ro"`
}

// TasksClientGetResourceGroupLevelTaskOptions contains the optional parameters for the TasksClient.GetResourceGroupLevelTask
// method.
type TasksClientGetResourceGroupLevelTaskOptions struct {
	// placeholder for future optional parameters
}

// TasksClientGetSubscriptionLevelTaskOptions contains the optional parameters for the TasksClient.GetSubscriptionLevelTask
// method.
type TasksClientGetSubscriptionLevelTaskOptions struct {
	// placeholder for future optional parameters
}

// TasksClientListByHomeRegionOptions contains the optional parameters for the TasksClient.ListByHomeRegion method.
type TasksClientListByHomeRegionOptions struct {
	// OData filter. Optional.
	Filter *string
}

// TasksClientListByResourceGroupOptions contains the optional parameters for the TasksClient.ListByResourceGroup method.
type TasksClientListByResourceGroupOptions struct {
	// OData filter. Optional.
	Filter *string
}

// TasksClientListOptions contains the optional parameters for the TasksClient.List method.
type TasksClientListOptions struct {
	// OData filter. Optional.
	Filter *string
}

// TasksClientUpdateResourceGroupLevelTaskStateOptions contains the optional parameters for the TasksClient.UpdateResourceGroupLevelTaskState
// method.
type TasksClientUpdateResourceGroupLevelTaskStateOptions struct {
	// placeholder for future optional parameters
}

// TasksClientUpdateSubscriptionLevelTaskStateOptions contains the optional parameters for the TasksClient.UpdateSubscriptionLevelTaskState
// method.
type TasksClientUpdateSubscriptionLevelTaskStateOptions struct {
	// placeholder for future optional parameters
}

// ThresholdCustomAlertRuleClassification provides polymorphic access to related types.
// Call the interface's GetThresholdCustomAlertRule() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ActiveConnectionsNotInAllowedRange, *AmqpC2DMessagesNotInAllowedRange, *AmqpC2DRejectedMessagesNotInAllowedRange, *AmqpD2CMessagesNotInAllowedRange,
// - *DirectMethodInvokesNotInAllowedRange, *FailedLocalLoginsNotInAllowedRange, *FileUploadsNotInAllowedRange, *HTTPC2DMessagesNotInAllowedRange,
// - *HTTPC2DRejectedMessagesNotInAllowedRange, *HTTPD2CMessagesNotInAllowedRange, *MqttC2DMessagesNotInAllowedRange, *MqttC2DRejectedMessagesNotInAllowedRange,
// - *MqttD2CMessagesNotInAllowedRange, *QueuePurgesNotInAllowedRange, *ThresholdCustomAlertRule, *TimeWindowCustomAlertRule,
// - *TwinUpdatesNotInAllowedRange, *UnauthorizedOperationsNotInAllowedRange
type ThresholdCustomAlertRuleClassification interface {
	CustomAlertRuleClassification
	// GetThresholdCustomAlertRule returns the ThresholdCustomAlertRule content of the underlying type.
	GetThresholdCustomAlertRule() *ThresholdCustomAlertRule
}

// ThresholdCustomAlertRule - A custom alert rule that checks if a value (depends on the custom alert type) is within the
// given range.
type ThresholdCustomAlertRule struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type ThresholdCustomAlertRule.
func (t *ThresholdCustomAlertRule) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: t.DisplayName,
		Description: t.Description,
		IsEnabled:   t.IsEnabled,
		RuleType:    t.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type ThresholdCustomAlertRule.
func (t *ThresholdCustomAlertRule) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule { return t }

// TimeWindowCustomAlertRuleClassification provides polymorphic access to related types.
// Call the interface's GetTimeWindowCustomAlertRule() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ActiveConnectionsNotInAllowedRange, *AmqpC2DMessagesNotInAllowedRange, *AmqpC2DRejectedMessagesNotInAllowedRange, *AmqpD2CMessagesNotInAllowedRange,
// - *DirectMethodInvokesNotInAllowedRange, *FailedLocalLoginsNotInAllowedRange, *FileUploadsNotInAllowedRange, *HTTPC2DMessagesNotInAllowedRange,
// - *HTTPC2DRejectedMessagesNotInAllowedRange, *HTTPD2CMessagesNotInAllowedRange, *MqttC2DMessagesNotInAllowedRange, *MqttC2DRejectedMessagesNotInAllowedRange,
// - *MqttD2CMessagesNotInAllowedRange, *QueuePurgesNotInAllowedRange, *TimeWindowCustomAlertRule, *TwinUpdatesNotInAllowedRange,
// - *UnauthorizedOperationsNotInAllowedRange
type TimeWindowCustomAlertRuleClassification interface {
	ThresholdCustomAlertRuleClassification
	// GetTimeWindowCustomAlertRule returns the TimeWindowCustomAlertRule content of the underlying type.
	GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule
}

// TimeWindowCustomAlertRule - A custom alert rule that checks if the number of activities (depends on the custom alert type)
// in a time window is within the given range.
type TimeWindowCustomAlertRule struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type TimeWindowCustomAlertRule.
func (t *TimeWindowCustomAlertRule) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: t.DisplayName,
		Description: t.Description,
		IsEnabled:   t.IsEnabled,
		RuleType:    t.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type TimeWindowCustomAlertRule.
func (t *TimeWindowCustomAlertRule) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: t.MinThreshold,
		MaxThreshold: t.MaxThreshold,
		DisplayName:  t.DisplayName,
		Description:  t.Description,
		IsEnabled:    t.IsEnabled,
		RuleType:     t.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type TimeWindowCustomAlertRule.
func (t *TimeWindowCustomAlertRule) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return t
}

// TopologyClientGetOptions contains the optional parameters for the TopologyClient.Get method.
type TopologyClientGetOptions struct {
	// placeholder for future optional parameters
}

// TopologyClientListByHomeRegionOptions contains the optional parameters for the TopologyClient.ListByHomeRegion method.
type TopologyClientListByHomeRegionOptions struct {
	// placeholder for future optional parameters
}

// TopologyClientListOptions contains the optional parameters for the TopologyClient.List method.
type TopologyClientListOptions struct {
	// placeholder for future optional parameters
}

type TopologyList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY
	Value []*TopologyResource `json:"value,omitempty" azure:"ro"`
}

type TopologyResource struct {
	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY
	Properties *TopologyResourceProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

type TopologyResourceProperties struct {
	// READ-ONLY; The UTC time on which the topology was calculated
	CalculatedDateTime *time.Time `json:"calculatedDateTime,omitempty" azure:"ro"`

	// READ-ONLY; Azure resources which are part of this topology resource
	TopologyResources []*TopologySingleResource `json:"topologyResources,omitempty" azure:"ro"`
}

type TopologySingleResource struct {
	// READ-ONLY; Azure resources connected to this resource which are in lower level in the topology view
	Children []*TopologySingleResourceChild `json:"children,omitempty" azure:"ro"`

	// READ-ONLY; The location of this resource
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Indicates the resource connectivity level to the Internet (InternetFacing, Internal ,etc.)
	NetworkZones *string `json:"networkZones,omitempty" azure:"ro"`

	// READ-ONLY; Azure resources connected to this resource which are in higher level in the topology view
	Parents []*TopologySingleResourceParent `json:"parents,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if the resource has security recommendations
	RecommendationsExist *bool `json:"recommendationsExist,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource id
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`

	// READ-ONLY; The security severity of the resource
	Severity *string `json:"severity,omitempty" azure:"ro"`

	// READ-ONLY; Score of the resource based on its security severity
	TopologyScore *int32 `json:"topologyScore,omitempty" azure:"ro"`
}

type TopologySingleResourceChild struct {
	// READ-ONLY; Azure resource id which serves as child resource in topology view
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`
}

type TopologySingleResourceParent struct {
	// READ-ONLY; Azure resource id which serves as parent resource in topology view
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`
}

// TrackedResource - Describes an Azure tracked resource.
type TrackedResource struct {
	// Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`

	// Kind of the resource
	Kind *string `json:"kind,omitempty"`

	// Location where the resource is stored
	Location *string `json:"location,omitempty"`

	// A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TwinUpdatesNotInAllowedRange - Number of twin updates is not in allowed range.
type TwinUpdatesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type TwinUpdatesNotInAllowedRange.
func (t *TwinUpdatesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: t.DisplayName,
		Description: t.Description,
		IsEnabled:   t.IsEnabled,
		RuleType:    t.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type TwinUpdatesNotInAllowedRange.
func (t *TwinUpdatesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: t.MinThreshold,
		MaxThreshold: t.MaxThreshold,
		DisplayName:  t.DisplayName,
		Description:  t.Description,
		IsEnabled:    t.IsEnabled,
		RuleType:     t.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type TwinUpdatesNotInAllowedRange.
func (t *TwinUpdatesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: t.TimeWindowSize,
		MinThreshold:   t.MinThreshold,
		MaxThreshold:   t.MaxThreshold,
		DisplayName:    t.DisplayName,
		Description:    t.Description,
		IsEnabled:      t.IsEnabled,
		RuleType:       t.RuleType,
	}
}

// UnauthorizedOperationsNotInAllowedRange - Number of unauthorized operations is not in allowed range.
type UnauthorizedOperationsNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`

	// REQUIRED; The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`

	// REQUIRED; The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`

	// READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type UnauthorizedOperationsNotInAllowedRange.
func (u *UnauthorizedOperationsNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		DisplayName: u.DisplayName,
		Description: u.Description,
		IsEnabled:   u.IsEnabled,
		RuleType:    u.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type UnauthorizedOperationsNotInAllowedRange.
func (u *UnauthorizedOperationsNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		MinThreshold: u.MinThreshold,
		MaxThreshold: u.MaxThreshold,
		DisplayName:  u.DisplayName,
		Description:  u.Description,
		IsEnabled:    u.IsEnabled,
		RuleType:     u.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type UnauthorizedOperationsNotInAllowedRange.
func (u *UnauthorizedOperationsNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		TimeWindowSize: u.TimeWindowSize,
		MinThreshold:   u.MinThreshold,
		MaxThreshold:   u.MaxThreshold,
		DisplayName:    u.DisplayName,
		Description:    u.Description,
		IsEnabled:      u.IsEnabled,
		RuleType:       u.RuleType,
	}
}

// UpdateIoTSecuritySolutionProperties - Update Security Solution setting data
type UpdateIoTSecuritySolutionProperties struct {
	// List of the configuration status for each recommendation type.
	RecommendationsConfiguration []*RecommendationConfigurationProperties `json:"recommendationsConfiguration,omitempty"`

	// Properties of the IoT Security solution's user defined resources.
	UserDefinedResources *UserDefinedResourcesProperties `json:"userDefinedResources,omitempty"`
}

type UpdateIotSecuritySolutionData struct {
	// Security Solution data
	Properties *UpdateIoTSecuritySolutionProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// UserDefinedResourcesProperties - Properties of the IoT Security solution's user defined resources.
type UserDefinedResourcesProperties struct {
	// REQUIRED; Azure Resource Graph query which represents the security solution's user defined resources. Required to start
	// with "where type != "Microsoft.Devices/IotHubs""
	Query *string `json:"query,omitempty"`

	// REQUIRED; List of Azure subscription ids on which the user defined resources query should be executed.
	QuerySubscriptions []*string `json:"querySubscriptions,omitempty"`
}

// UserRecommendation - Represents a user that is recommended to be allowed for a certain rule
type UserRecommendation struct {
	// The recommendation action of the machine or rule
	RecommendationAction *RecommendationAction `json:"recommendationAction,omitempty"`

	// Represents a user that is recommended to be allowed for a certain rule
	Username *string `json:"username,omitempty"`
}

// VMRecommendation - Represents a machine that is part of a machine group
type VMRecommendation struct {
	// The configuration status of the machines group or machine or rule
	ConfigurationStatus *ConfigurationStatus `json:"configurationStatus,omitempty"`

	// The machine supportability of Enforce feature
	EnforcementSupport *EnforcementSupport `json:"enforcementSupport,omitempty"`

	// The recommendation action of the machine or rule
	RecommendationAction *RecommendationAction `json:"recommendationAction,omitempty"`

	// The full resource id of the machine
	ResourceID *string `json:"resourceId,omitempty"`
}

// VaRule - vulnerability assessment rule metadata details.
type VaRule struct {
	// The benchmark references.
	BenchmarkReferences []*BenchmarkReference `json:"benchmarkReferences,omitempty"`

	// The rule category.
	Category *string `json:"category,omitempty"`

	// The rule description.
	Description *string `json:"description,omitempty"`

	// The rule query details.
	QueryCheck *QueryCheck `json:"queryCheck,omitempty"`

	// The rule rationale.
	Rationale *string `json:"rationale,omitempty"`

	// The rule Id.
	RuleID *string `json:"ruleId,omitempty"`

	// The rule type.
	RuleType *RuleType `json:"ruleType,omitempty"`

	// The rule severity.
	Severity *RuleSeverity `json:"severity,omitempty"`

	// The rule title.
	Title *string `json:"title,omitempty"`
}

// VendorReference - Vendor reference
type VendorReference struct {
	// READ-ONLY; Link url
	Link *string `json:"link,omitempty" azure:"ro"`

	// READ-ONLY; Link title
	Title *string `json:"title,omitempty" azure:"ro"`
}

// WorkspaceSetting - Configures where to store the OMS agent data for workspaces under a scope
type WorkspaceSetting struct {
	// Workspace setting data
	Properties *WorkspaceSettingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkspaceSettingList - List of workspace settings response
type WorkspaceSettingList struct {
	// REQUIRED; List of workspace settings
	Value []*WorkspaceSetting `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// WorkspaceSettingProperties - Workspace setting data
type WorkspaceSettingProperties struct {
	// REQUIRED; All the VMs in this scope will send their security data to the mentioned workspace unless overridden by a setting
	// with more specific scope
	Scope *string `json:"scope,omitempty"`

	// REQUIRED; The full Azure ID of the workspace to save the data in
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// WorkspaceSettingsClientCreateOptions contains the optional parameters for the WorkspaceSettingsClient.Create method.
type WorkspaceSettingsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceSettingsClientDeleteOptions contains the optional parameters for the WorkspaceSettingsClient.Delete method.
type WorkspaceSettingsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceSettingsClientGetOptions contains the optional parameters for the WorkspaceSettingsClient.Get method.
type WorkspaceSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceSettingsClientListOptions contains the optional parameters for the WorkspaceSettingsClient.List method.
type WorkspaceSettingsClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceSettingsClientUpdateOptions contains the optional parameters for the WorkspaceSettingsClient.Update method.
type WorkspaceSettingsClientUpdateOptions struct {
	// placeholder for future optional parameters
}
