//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple1200series_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple1200series/armstorsimple1200series"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/BackupsListByManager.json
func ExampleBackupsClient_NewListByManagerPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armstorsimple1200series.NewBackupsClient("9eb689cd-7243-43b4-b6f6-5c65cb296641", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListByManagerPager("ResourceGroupForSDKTest",
		"hAzureSDKOperations",
		&armstorsimple1200series.BackupsClientListByManagerOptions{Filter: to.Ptr("createdTime%20ge%20'2018-08-10T17:30:03Z'%20and%20createdTime%20le%20'2018-08-14T17:30:03Z'%20and%20initiatedBy%20eq%20'Manual'")})
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/BackupsListByDevice.json
func ExampleBackupsClient_NewListByDevicePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armstorsimple1200series.NewBackupsClient("9eb689cd-7243-43b4-b6f6-5c65cb296641", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListByDevicePager("HSDK-4XY4FI2IVG",
		"ResourceGroupForSDKTest",
		"hAzureSDKOperations",
		&armstorsimple1200series.BackupsClientListByDeviceOptions{ForFailover: nil,
			Filter: to.Ptr("initiatedBy%20eq%20'Manual'"),
		})
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/BackupsDelete.json
func ExampleBackupsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armstorsimple1200series.NewBackupsClient("9eb689cd-7243-43b4-b6f6-5c65cb296641", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginDelete(ctx,
		"HSDK-UGU4PITWNI",
		"315c3461-96ad-41bf-af0b-3a8be5113203",
		"ResourceGroupForSDKTest",
		"hAzureSDKOperations",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/BackupsClone.json
func ExampleBackupsClient_BeginClone() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armstorsimple1200series.NewBackupsClient("9eb689cd-7243-43b4-b6f6-5c65cb296641", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginClone(ctx,
		"HSDK-4XY4FI2IVG",
		"58d33025-e837-41cc-b15f-7c85ced64aab",
		"2304968f-91af-4f59-8b79-31e321eee40e",
		"ResourceGroupForSDKTest",
		"hAzureSDKOperations",
		armstorsimple1200series.CloneRequest{
			Properties: &armstorsimple1200series.CloneRequestProperties{
				NewEndpointName: to.Ptr("ClonedTieredFileShareForSDKTest"),
				Share: &armstorsimple1200series.FileShare{
					Name: to.Ptr("TieredFileShareForSDKTest"),
					Properties: &armstorsimple1200series.FileShareProperties{
						Description:                to.Ptr("Restore file Share"),
						AdminUser:                  to.Ptr("HSDK-4XY4FI2IVG\\StorSimpleAdmin"),
						DataPolicy:                 to.Ptr(armstorsimple1200series.DataPolicyTiered),
						MonitoringStatus:           to.Ptr(armstorsimple1200series.MonitoringStatusEnabled),
						ProvisionedCapacityInBytes: to.Ptr[int64](536870912000),
						ShareStatus:                to.Ptr(armstorsimple1200series.ShareStatusOnline),
					},
				},
				TargetAccessPointID: to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/hAzureSDKOperations/devices/hsdk-4xy4fi2ivg/fileServers/HSDK-4XY4FI2IVG"),
				TargetDeviceID:      to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/hAzureSDKOperations/devices/hsdk-4xy4fi2ivg"),
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
