//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple8000series

import "time"

// AccessControlRecord - The access control record.
type AccessControlRecord struct {
	// REQUIRED; The properties of access control record.
	Properties *AccessControlRecordProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccessControlRecordList - The collection of access control records.
type AccessControlRecordList struct {
	// REQUIRED; The value.
	Value []*AccessControlRecord `json:"value,omitempty"`
}

// AccessControlRecordProperties - The properties of access control record.
type AccessControlRecordProperties struct {
	// REQUIRED; The iSCSI initiator name (IQN).
	InitiatorName *string `json:"initiatorName,omitempty"`

	// READ-ONLY; The number of volumes using the access control record.
	VolumeCount *int32 `json:"volumeCount,omitempty" azure:"ro"`
}

// AccessControlRecordsClientBeginCreateOrUpdateOptions contains the optional parameters for the AccessControlRecordsClient.BeginCreateOrUpdate
// method.
type AccessControlRecordsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccessControlRecordsClientBeginDeleteOptions contains the optional parameters for the AccessControlRecordsClient.BeginDelete
// method.
type AccessControlRecordsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccessControlRecordsClientGetOptions contains the optional parameters for the AccessControlRecordsClient.Get method.
type AccessControlRecordsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccessControlRecordsClientListByManagerOptions contains the optional parameters for the AccessControlRecordsClient.ListByManager
// method.
type AccessControlRecordsClientListByManagerOptions struct {
	// placeholder for future optional parameters
}

// AcsConfiguration - The ACS configuration.
type AcsConfiguration struct {
	// REQUIRED; The namespace.
	Namespace *string `json:"namespace,omitempty"`

	// REQUIRED; The realm.
	Realm *string `json:"realm,omitempty"`

	// REQUIRED; The service URL.
	ServiceURL *string `json:"serviceUrl,omitempty"`
}

// Alert - The alert.
type Alert struct {
	// REQUIRED; The properties of the alert.
	Properties *AlertProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertErrorDetails - The details of the error for which the alert was raised
type AlertErrorDetails struct {
	// The error code
	ErrorCode *string `json:"errorCode,omitempty"`

	// The error message
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// The number of occurrences
	Occurences *int32 `json:"occurences,omitempty"`
}

// AlertFilter - The OData filters to be used for Alert
type AlertFilter struct {
	// Specifies the appeared time (in UTC) of the alerts to be filtered. Only 'Greater-Than' and 'Lesser-Than' operators are
	// supported for this property.
	AppearedOnTime *time.Time `json:"appearedOnTime,omitempty"`

	// Specifies the severity of the alerts to be filtered. Only 'Equality' operator is supported for this property.
	Severity *AlertSeverity `json:"severity,omitempty"`

	// Specifies the source name of the alerts to be filtered. Only 'Equality' operator is supported for this property.
	SourceName *string `json:"sourceName,omitempty"`

	// Specifies the source type of the alerts to be filtered. Only 'Equality' operator is supported for this property.
	SourceType *AlertSourceType `json:"sourceType,omitempty"`

	// Specifies the status of the alerts to be filtered. Only 'Equality' operator is supported for this property.
	Status *AlertStatus `json:"status,omitempty"`
}

// AlertList - The collection of alerts.
type AlertList struct {
	// REQUIRED; The value.
	Value []*Alert `json:"value,omitempty"`

	// The URI of the next page of alerts.
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertNotificationProperties - The properties of the alert notification settings.
type AlertNotificationProperties struct {
	// REQUIRED; Indicates whether email notification enabled or not.
	EmailNotification *AlertEmailNotificationStatus `json:"emailNotification,omitempty"`

	// The alert notification email list.
	AdditionalRecipientEmailList []*string `json:"additionalRecipientEmailList,omitempty"`

	// The alert notification culture.
	AlertNotificationCulture *string `json:"alertNotificationCulture,omitempty"`

	// The value indicating whether alert notification enabled for admin or not.
	NotificationToServiceOwners *AlertEmailNotificationStatus `json:"notificationToServiceOwners,omitempty"`
}

// AlertProperties - The properties of alert
type AlertProperties struct {
	// REQUIRED; The type of the alert
	AlertType *string `json:"alertType,omitempty"`

	// REQUIRED; The source time at which the alert was raised
	AppearedAtSourceTime *time.Time `json:"appearedAtSourceTime,omitempty"`

	// REQUIRED; The UTC time at which the alert was raised
	AppearedAtTime *time.Time `json:"appearedAtTime,omitempty"`

	// REQUIRED; The scope of the alert
	Scope *AlertScope `json:"scope,omitempty"`

	// REQUIRED; The severity of the alert
	Severity *AlertSeverity `json:"severity,omitempty"`

	// REQUIRED; The source at which the alert was raised
	Source *AlertSource `json:"source,omitempty"`

	// REQUIRED; The current status of the alert
	Status *AlertStatus `json:"status,omitempty"`

	// REQUIRED; The title of the alert
	Title *string `json:"title,omitempty"`

	// The source time at which the alert was cleared
	ClearedAtSourceTime *time.Time `json:"clearedAtSourceTime,omitempty"`

	// The UTC time at which the alert was cleared
	ClearedAtTime *time.Time `json:"clearedAtTime,omitempty"`

	// More details about the alert
	DetailedInformation map[string]*string `json:"detailedInformation,omitempty"`

	// The details of the error for which the alert was raised
	ErrorDetails *AlertErrorDetails `json:"errorDetails,omitempty"`

	// The recommended action for the issue raised in the alert
	Recommendation *string `json:"recommendation,omitempty"`

	// The reason for resolving the alert
	ResolutionReason *string `json:"resolutionReason,omitempty"`
}

// AlertSettings - The alert settings.
type AlertSettings struct {
	// REQUIRED; The properties of the alert notification settings.
	Properties *AlertNotificationProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertSource - The source details at which the alert was raised
type AlertSource struct {
	// The source type of the alert
	AlertSourceType *AlertSourceType `json:"alertSourceType,omitempty"`

	// The name of the source
	Name *string `json:"name,omitempty"`

	// The time zone of the source
	TimeZone *string `json:"timeZone,omitempty"`
}

// AlertsClientClearOptions contains the optional parameters for the AlertsClient.Clear method.
type AlertsClientClearOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientListByManagerOptions contains the optional parameters for the AlertsClient.ListByManager method.
type AlertsClientListByManagerOptions struct {
	// OData Filter options
	Filter *string
}

// AlertsClientSendTestEmailOptions contains the optional parameters for the AlertsClient.SendTestEmail method.
type AlertsClientSendTestEmailOptions struct {
	// placeholder for future optional parameters
}

// AsymmetricEncryptedSecret - Represent the secrets intended for encryption with asymmetric key pair.
type AsymmetricEncryptedSecret struct {
	// REQUIRED; The algorithm used to encrypt "Value".
	EncryptionAlgorithm *EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`

	// REQUIRED; The value of the secret.
	Value *string `json:"value,omitempty"`

	// Thumbprint certificate that was used to encrypt "Value". If the value in unencrypted, it will be null.
	EncryptionCertThumbprint *string `json:"encryptionCertThumbprint,omitempty"`
}

// AvailableProviderOperation - Represents available provider operation.
type AvailableProviderOperation struct {
	// Contains the localized display information for this particular operation/action.
	Display *AvailableProviderOperationDisplay `json:"display,omitempty"`

	// The name of the operation being performed on a particular object. Name format: "{resourceProviderNamespace}/{resourceType}/{read|write|delete|action}".
	// Eg.
	// Microsoft.StorSimple/managers/devices/volumeContainers/read, Microsoft.StorSimple/managers/devices/alerts/clearAlerts/action
	Name *string `json:"name,omitempty"`

	// The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX. Default
	// value is "user,system"
	Origin *string `json:"origin,omitempty"`

	// Reserved for future use.
	Properties interface{} `json:"properties,omitempty"`
}

// AvailableProviderOperationDisplay - Contains the localized display information for this particular operation/action. These
// value will be used by several clients for (a) custom role definitions for RBAC, (b) complex query filters for the
// event service and (c) audit history/records for management operations.
type AvailableProviderOperationDisplay struct {
	// The localized friendly description for the operation, as it should be shown to the user. It should be thorough, yet concise
	// - it will be used in tool tips and detailed views.
	Description *string `json:"description,omitempty"`

	// The localized friendly name for the operation, as it should be shown to the user. It should be concise (to fit in drop
	// downs) but clear (i.e. self-documenting). It should use Title Casing and include
	// the entity/resource to which it applies.
	Operation *string `json:"operation,omitempty"`

	// The localized friendly form of the resource provider name - it is expected to also include the publisher/company responsible.
	// It should use Title Casing and begin with 'Microsoft' for 1st party
	// services.
	Provider *string `json:"provider,omitempty"`

	// The localized friendly form of the resource type related to this action/operation - it should match the public documentation
	// for the resource provider. It should use Title Casing - for examples,
	// please refer to the 'name' section.
	Resource *string `json:"resource,omitempty"`
}

// AvailableProviderOperationList - List of available provider operations.
type AvailableProviderOperationList struct {
	// REQUIRED; The value.
	Value []*AvailableProviderOperation `json:"value,omitempty"`

	// The NextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// Backup - The backup.
type Backup struct {
	// REQUIRED; The properties of the backup.
	Properties *BackupProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupElement - The backup element.
type BackupElement struct {
	// REQUIRED; The path ID that uniquely identifies the backup element.
	ElementID *string `json:"elementId,omitempty"`

	// REQUIRED; The name of the backup element.
	ElementName *string `json:"elementName,omitempty"`

	// REQUIRED; The hierarchical type of the backup element.
	ElementType *string `json:"elementType,omitempty"`

	// REQUIRED; The size in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`

	// REQUIRED; The path ID of the volume container.
	VolumeContainerID *string `json:"volumeContainerId,omitempty"`

	// REQUIRED; The name of the volume.
	VolumeName *string `json:"volumeName,omitempty"`

	// The volume type.
	VolumeType *VolumeType `json:"volumeType,omitempty"`
}

// BackupFilter - The OData filters to be used for backups.
type BackupFilter struct {
	// Specifies the backupPolicyId of the backups to be filtered. Only 'Equality' operator is supported for this property.
	BackupPolicyID *string `json:"backupPolicyId,omitempty"`

	// Specifies the creation time of the backups to be filtered. Only 'Greater Than or Equal To' and 'Lesser Than or Equal To'
	// operators are supported for this property.
	CreatedTime *time.Time `json:"createdTime,omitempty"`

	// Specifies the volumeId of the backups to be filtered. Only 'Equality' operator is supported for this property.
	VolumeID *string `json:"volumeId,omitempty"`
}

// BackupList - The collection of backups.
type BackupList struct {
	// REQUIRED; The value.
	Value []*Backup `json:"value,omitempty"`

	// The NextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackupPoliciesClientBeginBackupNowOptions contains the optional parameters for the BackupPoliciesClient.BeginBackupNow
// method.
type BackupPoliciesClientBeginBackupNowOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the BackupPoliciesClient.BeginCreateOrUpdate
// method.
type BackupPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupPoliciesClientBeginDeleteOptions contains the optional parameters for the BackupPoliciesClient.BeginDelete method.
type BackupPoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupPoliciesClientGetOptions contains the optional parameters for the BackupPoliciesClient.Get method.
type BackupPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupPoliciesClientListByDeviceOptions contains the optional parameters for the BackupPoliciesClient.ListByDevice method.
type BackupPoliciesClientListByDeviceOptions struct {
	// placeholder for future optional parameters
}

// BackupPolicy - The backup policy.
type BackupPolicy struct {
	// REQUIRED; The properties of the backup policy.
	Properties *BackupPolicyProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupPolicyList - The collection of backup policies.
type BackupPolicyList struct {
	// REQUIRED; The value.
	Value []*BackupPolicy `json:"value,omitempty"`
}

// BackupPolicyProperties - The properties of the backup policy.
type BackupPolicyProperties struct {
	// REQUIRED; The path IDs of the volumes which are part of the backup policy.
	VolumeIDs []*string `json:"volumeIds,omitempty"`

	// READ-ONLY; The backup policy creation type. Indicates whether this was created through SaaS or through StorSimple Snapshot
	// Manager.
	BackupPolicyCreationType *BackupPolicyCreationType `json:"backupPolicyCreationType,omitempty" azure:"ro"`

	// READ-ONLY; The time of the last backup for the backup policy.
	LastBackupTime *time.Time `json:"lastBackupTime,omitempty" azure:"ro"`

	// READ-ONLY; The time of the next backup for the backup policy.
	NextBackupTime *time.Time `json:"nextBackupTime,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether at least one of the schedules in the backup policy is active or not.
	ScheduledBackupStatus *ScheduledBackupStatus `json:"scheduledBackupStatus,omitempty" azure:"ro"`

	// READ-ONLY; The count of schedules the backup policy contains.
	SchedulesCount *int64 `json:"schedulesCount,omitempty" azure:"ro"`

	// READ-ONLY; If the backup policy was created by StorSimple Snapshot Manager, then this field indicates the hostname of the
	// StorSimple Snapshot Manager.
	SsmHostName *string `json:"ssmHostName,omitempty" azure:"ro"`
}

// BackupProperties - The properties of the backup.
type BackupProperties struct {
	// REQUIRED; The time when the backup was created.
	CreatedOn *time.Time `json:"createdOn,omitempty"`

	// REQUIRED; The backup elements.
	Elements []*BackupElement `json:"elements,omitempty"`

	// REQUIRED; The backup size in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`

	// The backup job creation type.
	BackupJobCreationType *BackupJobCreationType `json:"backupJobCreationType,omitempty"`

	// The path ID of the backup policy.
	BackupPolicyID *string `json:"backupPolicyId,omitempty"`

	// The type of the backup.
	BackupType *BackupType `json:"backupType,omitempty"`

	// The StorSimple Snapshot Manager host name.
	SsmHostName *string `json:"ssmHostName,omitempty"`
}

// BackupSchedule - The backup schedule.
type BackupSchedule struct {
	// REQUIRED; The properties of the backup schedule.
	Properties *BackupScheduleProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupScheduleList - The backup schedule list.
type BackupScheduleList struct {
	// REQUIRED; The value.
	Value []*BackupSchedule `json:"value,omitempty"`
}

// BackupScheduleProperties - The properties of the backup schedule.
type BackupScheduleProperties struct {
	// REQUIRED; The type of backup which needs to be taken.
	BackupType *BackupType `json:"backupType,omitempty"`

	// REQUIRED; The number of backups to be retained.
	RetentionCount *int64 `json:"retentionCount,omitempty"`

	// REQUIRED; The schedule recurrence.
	ScheduleRecurrence *ScheduleRecurrence `json:"scheduleRecurrence,omitempty"`

	// REQUIRED; The schedule status.
	ScheduleStatus *ScheduleStatus `json:"scheduleStatus,omitempty"`

	// REQUIRED; The start time of the schedule.
	StartTime *time.Time `json:"startTime,omitempty"`

	// READ-ONLY; The last successful backup run which was triggered for the schedule.
	LastSuccessfulRun *time.Time `json:"lastSuccessfulRun,omitempty" azure:"ro"`
}

// BackupSchedulesClientBeginCreateOrUpdateOptions contains the optional parameters for the BackupSchedulesClient.BeginCreateOrUpdate
// method.
type BackupSchedulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupSchedulesClientBeginDeleteOptions contains the optional parameters for the BackupSchedulesClient.BeginDelete method.
type BackupSchedulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupSchedulesClientGetOptions contains the optional parameters for the BackupSchedulesClient.Get method.
type BackupSchedulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupSchedulesClientListByBackupPolicyOptions contains the optional parameters for the BackupSchedulesClient.ListByBackupPolicy
// method.
type BackupSchedulesClientListByBackupPolicyOptions struct {
	// placeholder for future optional parameters
}

// BackupsClientBeginCloneOptions contains the optional parameters for the BackupsClient.BeginClone method.
type BackupsClientBeginCloneOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupsClientBeginDeleteOptions contains the optional parameters for the BackupsClient.BeginDelete method.
type BackupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupsClientBeginRestoreOptions contains the optional parameters for the BackupsClient.BeginRestore method.
type BackupsClientBeginRestoreOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupsClientListByDeviceOptions contains the optional parameters for the BackupsClient.ListByDevice method.
type BackupsClientListByDeviceOptions struct {
	// OData Filter options
	Filter *string
}

// BandwidthRateSettingProperties - The properties of the bandwidth setting.
type BandwidthRateSettingProperties struct {
	// REQUIRED; The schedules.
	Schedules []*BandwidthSchedule `json:"schedules,omitempty"`

	// READ-ONLY; The number of volumes that uses the bandwidth setting.
	VolumeCount *int32 `json:"volumeCount,omitempty" azure:"ro"`
}

// BandwidthSchedule - The schedule for bandwidth setting.
type BandwidthSchedule struct {
	// REQUIRED; The days of the week when this schedule is applicable.
	Days []*DayOfWeek `json:"days,omitempty"`

	// REQUIRED; The rate in Mbps.
	RateInMbps *int32 `json:"rateInMbps,omitempty"`

	// REQUIRED; The start time of the schedule.
	Start *Time `json:"start,omitempty"`

	// REQUIRED; The stop time of the schedule.
	Stop *Time `json:"stop,omitempty"`
}

// BandwidthSetting - The bandwidth setting.
type BandwidthSetting struct {
	// REQUIRED; The properties of the bandwidth setting.
	Properties *BandwidthRateSettingProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BandwidthSettingList - The collection of bandwidth setting entities.
type BandwidthSettingList struct {
	// REQUIRED; The value.
	Value []*BandwidthSetting `json:"value,omitempty"`
}

// BandwidthSettingsClientBeginCreateOrUpdateOptions contains the optional parameters for the BandwidthSettingsClient.BeginCreateOrUpdate
// method.
type BandwidthSettingsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BandwidthSettingsClientBeginDeleteOptions contains the optional parameters for the BandwidthSettingsClient.BeginDelete
// method.
type BandwidthSettingsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BandwidthSettingsClientGetOptions contains the optional parameters for the BandwidthSettingsClient.Get method.
type BandwidthSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BandwidthSettingsClientListByManagerOptions contains the optional parameters for the BandwidthSettingsClient.ListByManager
// method.
type BandwidthSettingsClientListByManagerOptions struct {
	// placeholder for future optional parameters
}

// BaseModel - Represents the base class for all other ARM object models
type BaseModel struct {
	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ChapSettings - The Challenge-Handshake Authentication Protocol (CHAP) settings.
type ChapSettings struct {
	// The CHAP initiator secret.
	InitiatorSecret *AsymmetricEncryptedSecret `json:"initiatorSecret,omitempty"`

	// The CHAP initiator user.
	InitiatorUser *string `json:"initiatorUser,omitempty"`

	// The target secret.
	TargetSecret *AsymmetricEncryptedSecret `json:"targetSecret,omitempty"`

	// The CHAP target user.
	TargetUser *string `json:"targetUser,omitempty"`
}

// ClearAlertRequest - The request for clearing the alert
type ClearAlertRequest struct {
	// REQUIRED; The list of alert IDs to be cleared
	Alerts []*string `json:"alerts,omitempty"`

	// The resolution message while clearing the alert
	ResolutionMessage *string `json:"resolutionMessage,omitempty"`
}

// CloneRequest - The clone job request.
type CloneRequest struct {
	// REQUIRED; The backup element that is cloned.
	BackupElement *BackupElement `json:"backupElement,omitempty"`

	// REQUIRED; The list of path IDs of the access control records to be associated to the new cloned volume.
	TargetAccessControlRecordIDs []*string `json:"targetAccessControlRecordIds,omitempty"`

	// REQUIRED; The path ID of the device which will act as the clone target.
	TargetDeviceID *string `json:"targetDeviceId,omitempty"`

	// REQUIRED; The name of the new volume which will be created and the backup will be cloned into.
	TargetVolumeName *string `json:"targetVolumeName,omitempty"`
}

// CloudAppliance - The cloud appliance.
type CloudAppliance struct {
	// REQUIRED; The name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The virtual network region.
	VnetRegion *string `json:"vnetRegion,omitempty"`

	// Indicates whether virtual network used is configured with DNS or not.
	IsVnetDNSConfigured *bool `json:"isVnetDnsConfigured,omitempty"`

	// Indicates whether virtual network used is configured with express route or not.
	IsVnetExpressConfigured *bool `json:"isVnetExpressConfigured,omitempty"`

	// The model number.
	ModelNumber *string `json:"modelNumber,omitempty"`

	// The name of the storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// The type of the storage account.
	StorageAccountType *string `json:"storageAccountType,omitempty"`

	// The name of the subnet.
	SubnetName *string `json:"subnetName,omitempty"`

	// The name of the virtual machine image.
	VMImageName *string `json:"vmImageName,omitempty"`

	// The type of the virtual machine.
	VMType *string `json:"vmType,omitempty"`

	// The name of the virtual network.
	VnetName *string `json:"vnetName,omitempty"`
}

// CloudApplianceConfiguration - The cloud appliance configuration
type CloudApplianceConfiguration struct {
	// REQUIRED; The properties.
	Properties *CloudApplianceConfigurationProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CloudApplianceConfigurationList - The cloud appliance configuration list
type CloudApplianceConfigurationList struct {
	// REQUIRED; The value.
	Value []*CloudApplianceConfiguration `json:"value,omitempty"`
}

// CloudApplianceConfigurationProperties - The properties of cloud appliance configuration.
type CloudApplianceConfigurationProperties struct {
	// REQUIRED; The ACS configuration.
	AcsConfiguration *AcsConfiguration `json:"acsConfiguration,omitempty"`

	// REQUIRED; The cloud platform.
	CloudPlatform *string `json:"cloudPlatform,omitempty"`

	// REQUIRED; The model number.
	ModelNumber *string `json:"modelNumber,omitempty"`

	// REQUIRED; The supported regions.
	SupportedRegions []*string `json:"supportedRegions,omitempty"`

	// REQUIRED; The supported storage account types.
	SupportedStorageAccountTypes []*string `json:"supportedStorageAccountTypes,omitempty"`

	// REQUIRED; The supported virtual machine images.
	SupportedVMImages []*VMImage `json:"supportedVmImages,omitempty"`

	// REQUIRED; The supported virtual machine types.
	SupportedVMTypes []*string `json:"supportedVmTypes,omitempty"`
}

// CloudApplianceSettings - The cloud appliance settings.
type CloudApplianceSettings struct {
	// The channel integrity key (encrypted with DAK).
	ChannelIntegrityKey *AsymmetricEncryptedSecret `json:"channelIntegrityKey,omitempty"`

	// The service data encryption key (encrypted with DAK).
	ServiceDataEncryptionKey *AsymmetricEncryptedSecret `json:"serviceDataEncryptionKey,omitempty"`
}

// CloudAppliancesClientBeginProvisionOptions contains the optional parameters for the CloudAppliancesClient.BeginProvision
// method.
type CloudAppliancesClientBeginProvisionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudAppliancesClientListSupportedConfigurationsOptions contains the optional parameters for the CloudAppliancesClient.ListSupportedConfigurations
// method.
type CloudAppliancesClientListSupportedConfigurationsOptions struct {
	// placeholder for future optional parameters
}

// ConfigureDeviceRequest - The mandatory device configuration request.
type ConfigureDeviceRequest struct {
	// REQUIRED; The properties of the configure device request.
	Properties *ConfigureDeviceRequestProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConfigureDeviceRequestProperties - The properties of the configure device request.
type ConfigureDeviceRequestProperties struct {
	// REQUIRED; The current name of the device.
	CurrentDeviceName *string `json:"currentDeviceName,omitempty"`

	// REQUIRED; The friendly name for the device.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// REQUIRED; The device time zone. For eg: "Pacific Standard Time"
	TimeZone *string `json:"timeZone,omitempty"`

	// The secondary DNS Settings of the device.
	DNSSettings *SecondaryDNSSettings `json:"dnsSettings,omitempty"`

	// The 'Data 0' network interface card settings.
	NetworkInterfaceData0Settings *NetworkInterfaceData0Settings `json:"networkInterfaceData0Settings,omitempty"`
}

// ControllerPowerStateChangeRequest - The controller power state change request.
type ControllerPowerStateChangeRequest struct {
	// REQUIRED; The properties of the controller power state change request.
	Properties *ControllerPowerStateChangeRequestProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ControllerPowerStateChangeRequestProperties - The properties of the controller power state change request.
type ControllerPowerStateChangeRequestProperties struct {
	// REQUIRED; The power state that the request is expecting for the controller of the device.
	Action *ControllerPowerStateAction `json:"action,omitempty"`

	// REQUIRED; The active controller that the request is expecting on the device.
	ActiveController *ControllerID `json:"activeController,omitempty"`

	// REQUIRED; The controller 0's status that the request is expecting on the device.
	Controller0State *ControllerStatus `json:"controller0State,omitempty"`

	// REQUIRED; The controller 1's status that the request is expecting on the device.
	Controller1State *ControllerStatus `json:"controller1State,omitempty"`
}

// DNSSettings - The DNS(Domain Name Server) settings of a device.
type DNSSettings struct {
	// The primary IPv4 DNS server for the device
	PrimaryDNSServer *string `json:"primaryDnsServer,omitempty"`

	// The primary IPv6 DNS server for the device
	PrimaryIPv6DNSServer *string `json:"primaryIpv6DnsServer,omitempty"`

	// The secondary IPv4 DNS server for the device
	SecondaryDNSServers []*string `json:"secondaryDnsServers,omitempty"`

	// The secondary IPv6 DNS server for the device
	SecondaryIPv6DNSServers []*string `json:"secondaryIpv6DnsServers,omitempty"`
}

// DataStatistics - The additional details related to the data related statistics of a job. Currently applicable only for
// Backup, Clone and Restore jobs.
type DataStatistics struct {
	// The number of bytes of data written to cloud, as part of the job.
	CloudData *int64 `json:"cloudData,omitempty"`

	// The number of bytes of data processed till now, as part of the job.
	ProcessedData *int64 `json:"processedData,omitempty"`

	// The average throughput of data processed(bytes/sec), as part of the job.
	Throughput *int64 `json:"throughput,omitempty"`

	// The total bytes of data to be processed, as part of the job.
	TotalData *int64 `json:"totalData,omitempty"`
}

// Device - The StorSimple device.
type Device struct {
	// REQUIRED; The properties of the StorSimple device.
	Properties *DeviceProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeviceDetails - The additional device details regarding the end point count and volume container count.
type DeviceDetails struct {
	// The total number of endpoints that are currently on the device ( i.e. number of volumes).
	EndpointCount *int32 `json:"endpointCount,omitempty"`

	// The total number of volume containers on the device.
	VolumeContainerCount *int32 `json:"volumeContainerCount,omitempty"`
}

// DeviceList - The collection of devices.
type DeviceList struct {
	// REQUIRED; The value.
	Value []*Device `json:"value,omitempty"`
}

// DevicePatch - The device patch.
type DevicePatch struct {
	// REQUIRED; The properties of the device patch.
	Properties *DevicePatchProperties `json:"properties,omitempty"`
}

// DevicePatchProperties - The properties of the device patch.
type DevicePatchProperties struct {
	// Short description given for the device
	DeviceDescription *string `json:"deviceDescription,omitempty"`
}

// DeviceProperties - The properties of the StorSimple device.
type DeviceProperties struct {
	// REQUIRED; The UTC time at which the device was activated
	ActivationTime *time.Time `json:"activationTime,omitempty"`

	// REQUIRED; The identifier of the active controller of the device.
	ActiveController *ControllerID `json:"activeController,omitempty"`

	// REQUIRED; The language culture setting on the device. For eg: "en-US"
	Culture *string `json:"culture,omitempty"`

	// REQUIRED; The current configuration status of the device.
	DeviceConfigurationStatus *DeviceConfigurationStatus `json:"deviceConfigurationStatus,omitempty"`

	// REQUIRED; The device description.
	DeviceDescription *string `json:"deviceDescription,omitempty"`

	// REQUIRED; The version number of the software running on the device.
	DeviceSoftwareVersion *string `json:"deviceSoftwareVersion,omitempty"`

	// REQUIRED; The type of the device.
	DeviceType *DeviceType `json:"deviceType,omitempty"`

	// REQUIRED; The friendly name of the device.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// REQUIRED; The device friendly software version.
	FriendlySoftwareVersion *string `json:"friendlySoftwareVersion,omitempty"`

	// REQUIRED; The device model.
	ModelDescription *string `json:"modelDescription,omitempty"`

	// REQUIRED; The serial number.
	SerialNumber *string `json:"serialNumber,omitempty"`

	// REQUIRED; The current status of the device.
	Status *DeviceStatus `json:"status,omitempty"`

	// REQUIRED; The target IQN.
	TargetIqn *string `json:"targetIqn,omitempty"`

	// The device agent group version.
	AgentGroupVersion *int32 `json:"agentGroupVersion,omitempty"`

	// The storage in bytes that is available locally on the device.
	AvailableLocalStorageInBytes *int64 `json:"availableLocalStorageInBytes,omitempty"`

	// The storage in bytes that is available on the device for tiered volumes.
	AvailableTieredStorageInBytes *int64 `json:"availableTieredStorageInBytes,omitempty"`

	// The additional device details regarding the end point count and volume container count.
	Details *DeviceDetails `json:"details,omitempty"`

	// The location of the virtual appliance.
	DeviceLocation *string `json:"deviceLocation,omitempty"`

	// The friendly name of the software running on the device.
	FriendlySoftwareName *string `json:"friendlySoftwareName,omitempty"`

	// The number of network interface cards
	NetworkInterfaceCardCount *int32 `json:"networkInterfaceCardCount,omitempty"`

	// The storage in bytes used for locally pinned volumes on the device (including additional local reservation).
	ProvisionedLocalStorageInBytes *int64 `json:"provisionedLocalStorageInBytes,omitempty"`

	// The storage in bytes that has been provisioned on the device for tiered volumes.
	ProvisionedTieredStorageInBytes *int64 `json:"provisionedTieredStorageInBytes,omitempty"`

	// Total capacity in bytes of tiered and locally pinned volumes on the device
	ProvisionedVolumeSizeInBytes *int64 `json:"provisionedVolumeSizeInBytes,omitempty"`

	// The additional device details for the service data encryption key rollover.
	RolloverDetails *DeviceRolloverDetails `json:"rolloverDetails,omitempty"`

	// The total tiered storage available on the device in bytes.
	TotalTieredStorageInBytes *int64 `json:"totalTieredStorageInBytes,omitempty"`

	// The storage in bytes that is currently being used on the device, including both local and cloud.
	UsingStorageInBytes *int64 `json:"usingStorageInBytes,omitempty"`

	// READ-ONLY; The virtual machine API type.
	VirtualMachineAPIType *VirtualMachineAPIType `json:"virtualMachineApiType,omitempty" azure:"ro"`
}

// DeviceRolloverDetails - The additional device details for the service data encryption key rollover.
type DeviceRolloverDetails struct {
	// The eligibility status of device for service data encryption key rollover.
	AuthorizationEligibility *AuthorizationEligibility `json:"authorizationEligibility,omitempty"`

	// The authorization status of the device for service data encryption key rollover.
	AuthorizationStatus *AuthorizationStatus `json:"authorizationStatus,omitempty"`

	// The reason for inEligibility of device, in case it's not eligible for service data encryption key rollover.
	InEligibilityReason *InEligibilityCategory `json:"inEligibilityReason,omitempty"`
}

// DeviceSettingsClientBeginCreateOrUpdateAlertSettingsOptions contains the optional parameters for the DeviceSettingsClient.BeginCreateOrUpdateAlertSettings
// method.
type DeviceSettingsClientBeginCreateOrUpdateAlertSettingsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeviceSettingsClientBeginCreateOrUpdateTimeSettingsOptions contains the optional parameters for the DeviceSettingsClient.BeginCreateOrUpdateTimeSettings
// method.
type DeviceSettingsClientBeginCreateOrUpdateTimeSettingsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeviceSettingsClientBeginSyncRemotemanagementCertificateOptions contains the optional parameters for the DeviceSettingsClient.BeginSyncRemotemanagementCertificate
// method.
type DeviceSettingsClientBeginSyncRemotemanagementCertificateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeviceSettingsClientBeginUpdateNetworkSettingsOptions contains the optional parameters for the DeviceSettingsClient.BeginUpdateNetworkSettings
// method.
type DeviceSettingsClientBeginUpdateNetworkSettingsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeviceSettingsClientBeginUpdateSecuritySettingsOptions contains the optional parameters for the DeviceSettingsClient.BeginUpdateSecuritySettings
// method.
type DeviceSettingsClientBeginUpdateSecuritySettingsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeviceSettingsClientGetAlertSettingsOptions contains the optional parameters for the DeviceSettingsClient.GetAlertSettings
// method.
type DeviceSettingsClientGetAlertSettingsOptions struct {
	// placeholder for future optional parameters
}

// DeviceSettingsClientGetNetworkSettingsOptions contains the optional parameters for the DeviceSettingsClient.GetNetworkSettings
// method.
type DeviceSettingsClientGetNetworkSettingsOptions struct {
	// placeholder for future optional parameters
}

// DeviceSettingsClientGetSecuritySettingsOptions contains the optional parameters for the DeviceSettingsClient.GetSecuritySettings
// method.
type DeviceSettingsClientGetSecuritySettingsOptions struct {
	// placeholder for future optional parameters
}

// DeviceSettingsClientGetTimeSettingsOptions contains the optional parameters for the DeviceSettingsClient.GetTimeSettings
// method.
type DeviceSettingsClientGetTimeSettingsOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientAuthorizeForServiceEncryptionKeyRolloverOptions contains the optional parameters for the DevicesClient.AuthorizeForServiceEncryptionKeyRollover
// method.
type DevicesClientAuthorizeForServiceEncryptionKeyRolloverOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientBeginConfigureOptions contains the optional parameters for the DevicesClient.BeginConfigure method.
type DevicesClientBeginConfigureOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginDeactivateOptions contains the optional parameters for the DevicesClient.BeginDeactivate method.
type DevicesClientBeginDeactivateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginDeleteOptions contains the optional parameters for the DevicesClient.BeginDelete method.
type DevicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginFailoverOptions contains the optional parameters for the DevicesClient.BeginFailover method.
type DevicesClientBeginFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginInstallUpdatesOptions contains the optional parameters for the DevicesClient.BeginInstallUpdates method.
type DevicesClientBeginInstallUpdatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginScanForUpdatesOptions contains the optional parameters for the DevicesClient.BeginScanForUpdates method.
type DevicesClientBeginScanForUpdatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientGetOptions contains the optional parameters for the DevicesClient.Get method.
type DevicesClientGetOptions struct {
	// Specify $expand=details to populate additional fields related to the device or $expand=rolloverdetails to populate additional
	// fields related to the service data encryption key rollover on device
	Expand *string
}

// DevicesClientGetUpdateSummaryOptions contains the optional parameters for the DevicesClient.GetUpdateSummary method.
type DevicesClientGetUpdateSummaryOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientListByManagerOptions contains the optional parameters for the DevicesClient.ListByManager method.
type DevicesClientListByManagerOptions struct {
	// Specify $expand=details to populate additional fields related to the device or $expand=rolloverdetails to populate additional
	// fields related to the service data encryption key rollover on device
	Expand *string
}

// DevicesClientListFailoverSetsOptions contains the optional parameters for the DevicesClient.ListFailoverSets method.
type DevicesClientListFailoverSetsOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientListFailoverTargetsOptions contains the optional parameters for the DevicesClient.ListFailoverTargets method.
type DevicesClientListFailoverTargetsOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientListMetricDefinitionOptions contains the optional parameters for the DevicesClient.ListMetricDefinition method.
type DevicesClientListMetricDefinitionOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientListMetricsOptions contains the optional parameters for the DevicesClient.ListMetrics method.
type DevicesClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientUpdateOptions contains the optional parameters for the DevicesClient.Update method.
type DevicesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DimensionFilter - The dimension filter.
type DimensionFilter struct {
	// Specifies the dimension name. E.g., NetworkInterface. Valid values are the ones specified in the field "dimensions" in
	// the ListMetricDefinitions call. Only 'Equality' operator is supported for this
	// property.
	Name *string `json:"name,omitempty"`

	// Specifies the dimension value. E.g., Data0. Valid values are the ones returned in the field "dimensions" in the ListMetricDefinitions
	// call. Only 'Equality' operator is supported for this property.
	Values *string `json:"values,omitempty"`
}

// EncryptionSettings - The encryption settings.
type EncryptionSettings struct {
	// REQUIRED; The properties of the encryption settings.
	Properties *EncryptionSettingsProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EncryptionSettingsProperties - The properties of encryption settings.
type EncryptionSettingsProperties struct {
	// REQUIRED; The encryption status to indicates if encryption is enabled or not.
	EncryptionStatus *EncryptionStatus `json:"encryptionStatus,omitempty"`

	// REQUIRED; The key rollover status to indicates if key rollover is required or not. If secret's encryption has been upgraded,
	// then it requires key rollover.
	KeyRolloverStatus *KeyRolloverStatus `json:"keyRolloverStatus,omitempty"`
}

// FailoverRequest - The request object for triggering a failover of volume containers, from a source device to a target device.
type FailoverRequest struct {
	// The ARM path ID of the device which will act as the failover target.
	TargetDeviceID *string `json:"targetDeviceId,omitempty"`

	// The list of path IDs of the volume containers which needs to be failed-over to the target device.
	VolumeContainers []*string `json:"volumeContainers,omitempty"`
}

// FailoverSet - The failover set on a device.
type FailoverSet struct {
	// The eligibility result of the failover set, for failover.
	EligibilityResult *FailoverSetEligibilityResult `json:"eligibilityResult,omitempty"`

	// The list of meta data of volume containers, which are part of the failover set.
	VolumeContainers []*VolumeContainerFailoverMetadata `json:"volumeContainers,omitempty"`
}

// FailoverSetEligibilityResult - The eligibility result of failover set, for failover.
type FailoverSetEligibilityResult struct {
	// The error message, if the failover set is not eligible for failover.
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Represents if this failover set is eligible for failover or not.
	IsEligibleForFailover *bool `json:"isEligibleForFailover,omitempty"`
}

// FailoverSetsList - The list of failover sets.
type FailoverSetsList struct {
	// The list of failover sets.
	Value []*FailoverSet `json:"value,omitempty"`
}

// FailoverTarget - Represents the eligibility of a device as a failover target device.
type FailoverTarget struct {
	// The amount of free local storage available on the device in bytes.
	AvailableLocalStorageInBytes *int64 `json:"availableLocalStorageInBytes,omitempty"`

	// The amount of free tiered storage available for the device in bytes.
	AvailableTieredStorageInBytes *int64 `json:"availableTieredStorageInBytes,omitempty"`

	// The count of data containers on the device.
	DataContainersCount *int32 `json:"dataContainersCount,omitempty"`

	// The path ID of the device.
	DeviceID *string `json:"deviceId,omitempty"`

	// The geo location (applicable only for cloud appliances) of the device.
	DeviceLocation *string `json:"deviceLocation,omitempty"`

	// The software version of the device.
	DeviceSoftwareVersion *string `json:"deviceSoftwareVersion,omitempty"`

	// The status of the device.
	DeviceStatus *DeviceStatus `json:"deviceStatus,omitempty"`

	// The eligibility result of the device, as a failover target device.
	EligibilityResult *TargetEligibilityResult `json:"eligibilityResult,omitempty"`

	// The friendly name for the current version of software on the device.
	FriendlyDeviceSoftwareVersion *string `json:"friendlyDeviceSoftwareVersion,omitempty"`

	// The model number of the device.
	ModelDescription *string `json:"modelDescription,omitempty"`

	// The count of volumes on the device.
	VolumesCount *int32 `json:"volumesCount,omitempty"`
}

// FailoverTargetsList - The list of all devices in a resource and their eligibility status as a failover target device.
type FailoverTargetsList struct {
	// The list of all the failover targets.
	Value []*FailoverTarget `json:"value,omitempty"`
}

// Feature - The feature.
type Feature struct {
	// REQUIRED; The name of the feature.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The feature support status.
	Status *FeatureSupportStatus `json:"status,omitempty"`
}

// FeatureFilter - The OData filter to be used for features.
type FeatureFilter struct {
	// Specifies the device ID for which the features are required. Only 'Equality' operator is supported for this property.
	DeviceID *string `json:"deviceId,omitempty"`
}

// FeatureList - The collections of features.
type FeatureList struct {
	// REQUIRED; The value.
	Value []*Feature `json:"value,omitempty"`
}

// HardwareComponent - The hardware component.
type HardwareComponent struct {
	// REQUIRED; The component ID.
	ComponentID *string `json:"componentId,omitempty"`

	// REQUIRED; The display name of the hardware component.
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; The status of the hardware component.
	Status *HardwareComponentStatus `json:"status,omitempty"`

	// REQUIRED; The display name of the status of hardware component.
	StatusDisplayName *string `json:"statusDisplayName,omitempty"`
}

// HardwareComponentGroup - The hardware component group.
type HardwareComponentGroup struct {
	// REQUIRED; The properties of the hardware component group.
	Properties *HardwareComponentGroupProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HardwareComponentGroupList - The collection of hardware component groups.
type HardwareComponentGroupList struct {
	// REQUIRED; The value.
	Value []*HardwareComponentGroup `json:"value,omitempty"`
}

// HardwareComponentGroupProperties - The properties of hardware component group.
type HardwareComponentGroupProperties struct {
	// REQUIRED; The list of hardware components.
	Components []*HardwareComponent `json:"components,omitempty"`

	// REQUIRED; The display name the hardware component group.
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; The last updated time.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty"`
}

// HardwareComponentGroupsClientBeginChangeControllerPowerStateOptions contains the optional parameters for the HardwareComponentGroupsClient.BeginChangeControllerPowerState
// method.
type HardwareComponentGroupsClientBeginChangeControllerPowerStateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// HardwareComponentGroupsClientListByDeviceOptions contains the optional parameters for the HardwareComponentGroupsClient.ListByDevice
// method.
type HardwareComponentGroupsClientListByDeviceOptions struct {
	// placeholder for future optional parameters
}

// Job - The job.
type Job struct {
	// REQUIRED; The percentage of the job that is already complete.
	PercentComplete *int32 `json:"percentComplete,omitempty"`

	// REQUIRED; The current status of the job.
	Status *JobStatus `json:"status,omitempty"`

	// The UTC time at which the job completed.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The error details, if any, for the job.
	Error *JobErrorDetails `json:"error,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// The properties of the job.
	Properties *JobProperties `json:"properties,omitempty"`

	// The UTC time at which the job was started.
	StartTime *time.Time `json:"startTime,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobErrorDetails - The job error details. Contains list of job error items.
type JobErrorDetails struct {
	// REQUIRED; The error code intended for programmatic access.
	Code *string `json:"code,omitempty"`

	// REQUIRED; The error message intended to describe the error in detail.
	Message *string `json:"message,omitempty"`

	// The error details.
	ErrorDetails []*JobErrorItem `json:"errorDetails,omitempty"`
}

// JobErrorItem - The job error items.
type JobErrorItem struct {
	// REQUIRED; The error code intended for programmatic access.
	Code *string `json:"code,omitempty"`

	// REQUIRED; The error message intended to describe the error in detail.
	Message *string `json:"message,omitempty"`

	// The recommended actions.
	Recommendations []*string `json:"recommendations,omitempty"`
}

// JobFilter - The OData filter to be used for jobs.
type JobFilter struct {
	// Specifies the type of the jobs to be filtered. For e.g., "ScheduledBackup", "ManualBackup", "RestoreBackup", "CloneVolume",
	// "FailoverVolumeContainers", "CreateLocallyPinnedVolume", "ModifyVolume",
	// "InstallUpdates", "SupportPackageLogs", or "CreateCloudAppliance". Only 'Equality' operator can be used for this property.
	JobType *string `json:"jobType,omitempty"`

	// Specifies the start time of the jobs to be filtered. Only 'Greater Than or Equal To' and 'Lesser Than or Equal To' operators
	// are supported for this property.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Specifies the status of the jobs to be filtered. For e.g., "Running", "Succeeded", "Failed" or "Canceled". Only 'Equality'
	// operator is supported for this property.
	Status *string `json:"status,omitempty"`
}

// JobList - The collection of jobs.
type JobList struct {
	// REQUIRED; The value.
	Value []*Job `json:"value,omitempty"`

	// The NextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobProperties - The properties of the job.
type JobProperties struct {
	// REQUIRED; The type of the job.
	JobType *JobType `json:"jobType,omitempty"`

	// The time of the backup used for the failover.
	BackupPointInTime *time.Time `json:"backupPointInTime,omitempty"`

	// The backup type (CloudSnapshot | LocalSnapshot). Applicable only for backup jobs.
	BackupType *BackupType `json:"backupType,omitempty"`

	// The data statistics properties of the job.
	DataStats *DataStatistics `json:"dataStats,omitempty"`

	// The device ID in which the job ran.
	DeviceID *string `json:"deviceId,omitempty"`

	// The entity identifier for which the job ran.
	EntityLabel *string `json:"entityLabel,omitempty"`

	// The entity type for which the job ran.
	EntityType *string `json:"entityType,omitempty"`

	// Represents whether the job is cancellable or not.
	IsCancellable *bool `json:"isCancellable,omitempty"`

	// The job stages.
	JobStages []*JobStage `json:"jobStages,omitempty"`

	// The source device ID of the failover job.
	SourceDeviceID *string `json:"sourceDeviceId,omitempty"`
}

// JobStage - The details about the specific stage of a job.
type JobStage struct {
	// REQUIRED; The stage status.
	StageStatus *JobStatus `json:"stageStatus,omitempty"`

	// The details of the stage.
	Detail *string `json:"detail,omitempty"`

	// The error code of the stage if any.
	ErrorCode *string `json:"errorCode,omitempty"`

	// The message of the job stage.
	Message *string `json:"message,omitempty"`
}

// JobsClientBeginCancelOptions contains the optional parameters for the JobsClient.BeginCancel method.
type JobsClientBeginCancelOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JobsClientGetOptions contains the optional parameters for the JobsClient.Get method.
type JobsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobsClientListByDeviceOptions contains the optional parameters for the JobsClient.ListByDevice method.
type JobsClientListByDeviceOptions struct {
	// OData Filter options
	Filter *string
}

// JobsClientListByManagerOptions contains the optional parameters for the JobsClient.ListByManager method.
type JobsClientListByManagerOptions struct {
	// OData Filter options
	Filter *string
}

// Key - The key.
type Key struct {
	// REQUIRED; The activation key for the device.
	ActivationKey *string `json:"activationKey,omitempty"`
}

// ListFailoverTargetsRequest - The request object for fetching the list of failover targets (eligible devices for failover).
type ListFailoverTargetsRequest struct {
	// The list of path IDs of the volume containers that needs to be failed-over, for which we want to fetch the eligible targets.
	VolumeContainers []*string `json:"volumeContainers,omitempty"`
}

// Manager - The StorSimple Manager.
type Manager struct {
	// REQUIRED; The geo location of the resource.
	Location *string `json:"location,omitempty"`

	// The etag of the manager.
	Etag *string `json:"etag,omitempty"`

	// The properties of the StorSimple Manager.
	Properties *ManagerProperties `json:"properties,omitempty"`

	// The tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagerExtendedInfo - The extended info of the manager.
type ManagerExtendedInfo struct {
	// The etag of the resource.
	Etag *string `json:"etag,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// The extended info properties.
	Properties *ManagerExtendedInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagerExtendedInfoProperties - The properties of the manager extended info.
type ManagerExtendedInfoProperties struct {
	// REQUIRED; Represents the encryption algorithm used to encrypt the keys. None - if Key is saved in plain text format. Algorithm
	// name - if key is encrypted
	Algorithm *string `json:"algorithm,omitempty"`

	// REQUIRED; Represents the CIK of the resource.
	IntegrityKey *string `json:"integrityKey,omitempty"`

	// Represents the CEK of the resource.
	EncryptionKey *string `json:"encryptionKey,omitempty"`

	// Represents the Cert thumbprint that was used to encrypt the CEK.
	EncryptionKeyThumbprint *string `json:"encryptionKeyThumbprint,omitempty"`

	// Represents the portal thumbprint which can be used optionally to encrypt the entire data before storing it.
	PortalCertificateThumbprint *string `json:"portalCertificateThumbprint,omitempty"`

	// The version of the extended info being persisted.
	Version *string `json:"version,omitempty"`
}

// ManagerIntrinsicSettings - Intrinsic settings which refers to the type of the StorSimple Manager.
type ManagerIntrinsicSettings struct {
	// REQUIRED; The type of StorSimple Manager.
	Type *ManagerType `json:"type,omitempty"`
}

// ManagerList - The list of StorSimple Managers.
type ManagerList struct {
	// REQUIRED; The list of StorSimple managers.
	Value []*Manager `json:"value,omitempty"`
}

// ManagerPatch - The StorSimple Manager patch.
type ManagerPatch struct {
	// The tags attached to the Manager.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ManagerProperties - The properties of the StorSimple Manager.
type ManagerProperties struct {
	// Represents the type of StorSimple Manager.
	CisIntrinsicSettings *ManagerIntrinsicSettings `json:"cisIntrinsicSettings,omitempty"`

	// Specifies the state of the resource as it is getting provisioned. Value of "Succeeded" means the Manager was successfully
	// created.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Specifies the Sku.
	SKU *ManagerSKU `json:"sku,omitempty"`
}

// ManagerSKU - The Sku.
type ManagerSKU struct {
	// REQUIRED; Refers to the sku name which should be "Standard"
	Name *string `json:"name,omitempty"`
}

// ManagersClientCreateExtendedInfoOptions contains the optional parameters for the ManagersClient.CreateExtendedInfo method.
type ManagersClientCreateExtendedInfoOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientCreateOrUpdateOptions contains the optional parameters for the ManagersClient.CreateOrUpdate method.
type ManagersClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientDeleteExtendedInfoOptions contains the optional parameters for the ManagersClient.DeleteExtendedInfo method.
type ManagersClientDeleteExtendedInfoOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientDeleteOptions contains the optional parameters for the ManagersClient.Delete method.
type ManagersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientGetActivationKeyOptions contains the optional parameters for the ManagersClient.GetActivationKey method.
type ManagersClientGetActivationKeyOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientGetDevicePublicEncryptionKeyOptions contains the optional parameters for the ManagersClient.GetDevicePublicEncryptionKey
// method.
type ManagersClientGetDevicePublicEncryptionKeyOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientGetEncryptionSettingsOptions contains the optional parameters for the ManagersClient.GetEncryptionSettings
// method.
type ManagersClientGetEncryptionSettingsOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientGetExtendedInfoOptions contains the optional parameters for the ManagersClient.GetExtendedInfo method.
type ManagersClientGetExtendedInfoOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientGetOptions contains the optional parameters for the ManagersClient.Get method.
type ManagersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientGetPublicEncryptionKeyOptions contains the optional parameters for the ManagersClient.GetPublicEncryptionKey
// method.
type ManagersClientGetPublicEncryptionKeyOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientListByResourceGroupOptions contains the optional parameters for the ManagersClient.ListByResourceGroup method.
type ManagersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientListFeatureSupportStatusOptions contains the optional parameters for the ManagersClient.ListFeatureSupportStatus
// method.
type ManagersClientListFeatureSupportStatusOptions struct {
	// OData Filter options
	Filter *string
}

// ManagersClientListMetricDefinitionOptions contains the optional parameters for the ManagersClient.ListMetricDefinition
// method.
type ManagersClientListMetricDefinitionOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientListMetricsOptions contains the optional parameters for the ManagersClient.ListMetrics method.
type ManagersClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientListOptions contains the optional parameters for the ManagersClient.List method.
type ManagersClientListOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientRegenerateActivationKeyOptions contains the optional parameters for the ManagersClient.RegenerateActivationKey
// method.
type ManagersClientRegenerateActivationKeyOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientUpdateExtendedInfoOptions contains the optional parameters for the ManagersClient.UpdateExtendedInfo method.
type ManagersClientUpdateExtendedInfoOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientUpdateOptions contains the optional parameters for the ManagersClient.Update method.
type ManagersClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// MetricAvailablity - The metric availability.
type MetricAvailablity struct {
	// The retention period for the metric at the specified timegrain.
	Retention *string `json:"retention,omitempty"`

	// The aggregation interval for the metric.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricData - The metric data.
type MetricData struct {
	// The average of all samples at the time stamp.
	Average *float64 `json:"average,omitempty"`

	// The count of all samples at the time stamp.
	Count *int32 `json:"count,omitempty"`

	// The maximum of all samples at the time stamp.
	Maximum *float64 `json:"maximum,omitempty"`

	// The minimum of all samples at the time stamp.
	Minimum *float64 `json:"minimum,omitempty"`

	// The sum of all samples at the time stamp.
	Sum *float64 `json:"sum,omitempty"`

	// The time stamp of the metric data.
	TimeStamp *time.Time `json:"timeStamp,omitempty"`
}

// MetricDefinition - The monitoring metric definition.
type MetricDefinition struct {
	// The category of the metric.
	Category *string `json:"category,omitempty"`

	// The available metric dimensions.
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// The available metric granularities.
	MetricAvailabilities []*MetricAvailablity `json:"metricAvailabilities,omitempty"`

	// The metric name.
	Name *MetricName `json:"name,omitempty"`

	// The metric aggregation type.
	PrimaryAggregationType *MetricAggregationType `json:"primaryAggregationType,omitempty"`

	// The metric source ID.
	ResourceID *string `json:"resourceId,omitempty"`

	// The metric definition type.
	Type *string `json:"type,omitempty"`

	// The metric unit.
	Unit *MetricUnit `json:"unit,omitempty"`
}

// MetricDefinitionList - The list of metric definitions.
type MetricDefinitionList struct {
	// The list of metric definitions.
	Value []*MetricDefinition `json:"value,omitempty"`
}

// MetricDimension - The metric dimension. It indicates the source of the metric.
type MetricDimension struct {
	// The metric dimension name.
	Name *string `json:"name,omitempty"`

	// The metric dimension values.
	Value *string `json:"value,omitempty"`
}

// MetricFilter - The OData filters to be used for metrics.
type MetricFilter struct {
	// REQUIRED; Specifies the category of the metrics to be filtered. E.g., "CapacityUtilization". Valid values are the ones
	// returned as the field "category" in the ListMetricDefinitions call. Only 'Equality'
	// operator is supported for this property.
	Category *string `json:"category,omitempty"`

	// Specifies the source(the dimension) of the metrics to be filtered. Only 'Equality' operator is supported for this property.
	Dimensions *DimensionFilter `json:"dimensions,omitempty"`

	// Specifies the end time of the time range to be queried. Only 'Less Than Or Equal To' operator is supported for this property.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Specifies the metric name filter specifying the name of the metric to be filtered on. Only 'Equality' operator is supported
	// for this property.
	Name *MetricNameFilter `json:"name,omitempty"`

	// Specifies the start time of the time range to be queried. Only 'Greater Than Or Equal To' operator is supported for this
	// property.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Specifies the time granularity of the metrics to be returned. E.g., "P1D". Valid values are the ones returned as the field
	// "timeGrain" in the ListMetricDefinitions call. Only 'Equality' operator is
	// supported for this property.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricList - The metric list.
type MetricList struct {
	// The value.
	Value []*Metrics `json:"value,omitempty"`
}

// MetricName - The metric name.
type MetricName struct {
	// The localized metric name.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// The metric name.
	Value *string `json:"value,omitempty"`
}

// MetricNameFilter - The metric name filter, specifying the name of the metric to be filtered on.
type MetricNameFilter struct {
	// Specifies the metric name to be filtered on. E.g., CloudStorageUsed. Valid values are the ones returned in the field "name"
	// in the ListMetricDefinitions call. Only 'Equality' operator is supported for
	// this property.
	Value *string `json:"value,omitempty"`
}

// Metrics - The monitoring metric.
type Metrics struct {
	// The metric dimensions.
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// The end time of the metric data.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The name of the metric.
	Name *MetricName `json:"name,omitempty"`

	// The metric aggregation type.
	PrimaryAggregation *MetricAggregationType `json:"primaryAggregation,omitempty"`

	// The ID of metric source.
	ResourceID *string `json:"resourceId,omitempty"`

	// The start time of the metric data.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The time granularity of the metric data.
	TimeGrain *string `json:"timeGrain,omitempty"`

	// The type of the metric data.
	Type *string `json:"type,omitempty"`

	// The unit of the metric data.
	Unit *MetricUnit `json:"unit,omitempty"`

	// The list of the metric data.
	Values []*MetricData `json:"values,omitempty"`
}

// NetworkAdapterList - The collection of network adapters on the device.
type NetworkAdapterList struct {
	// REQUIRED; The value.
	Value []*NetworkAdapters `json:"value,omitempty"`
}

// NetworkAdapters - Represents the network adapter on device.
type NetworkAdapters struct {
	// REQUIRED; The ID of the network adapter.
	InterfaceID *NetInterfaceID `json:"interfaceId,omitempty"`

	// REQUIRED; Value indicating cloud and ISCSI status of network adapter.
	IscsiAndCloudStatus *ISCSIAndCloudStatus `json:"iscsiAndCloudStatus,omitempty"`

	// REQUIRED; The mode of network adapter, either IPv4, IPv6 or both.
	Mode *NetworkMode `json:"mode,omitempty"`

	// REQUIRED; Value indicating status of network adapter.
	NetInterfaceStatus *NetInterfaceStatus `json:"netInterfaceStatus,omitempty"`

	// Value indicating whether this instance is default.
	IsDefault *bool `json:"isDefault,omitempty"`

	// The IPv4 configuration of the network adapter.
	NicIPv4Settings *NicIPv4 `json:"nicIpv4Settings,omitempty"`

	// The IPv6 configuration of the network adapter.
	NicIPv6Settings *NicIPv6 `json:"nicIpv6Settings,omitempty"`

	// The speed of the network adapter.
	Speed *int64 `json:"speed,omitempty"`
}

// NetworkInterfaceData0Settings - The 'Data 0' network interface card settings.
type NetworkInterfaceData0Settings struct {
	// The controller 1's IPv4 address.
	ControllerOneIP *string `json:"controllerOneIp,omitempty"`

	// The controller 0's IPv4 address.
	ControllerZeroIP *string `json:"controllerZeroIp,omitempty"`
}

// NetworkSettings - Represents the network settings of a device.
type NetworkSettings struct {
	// REQUIRED; The properties of network settings of a device.
	Properties *NetworkSettingsProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkSettingsPatch - Represents the patch request for the network settings of a device.
type NetworkSettingsPatch struct {
	// REQUIRED; The properties of the network settings patch.
	Properties *NetworkSettingsPatchProperties `json:"properties,omitempty"`
}

// NetworkSettingsPatchProperties - The properties of the network settings patch.
type NetworkSettingsPatchProperties struct {
	// The DNS (Domain Name System) settings of device.
	DNSSettings *DNSSettings `json:"dnsSettings,omitempty"`

	// The network adapter list of device.
	NetworkAdapters *NetworkAdapterList `json:"networkAdapters,omitempty"`
}

// NetworkSettingsProperties - The properties of the network settings of device.
type NetworkSettingsProperties struct {
	// REQUIRED; The DNS (Domain Name System) settings of device.
	DNSSettings *DNSSettings `json:"dnsSettings,omitempty"`

	// REQUIRED; The network adapter list of device.
	NetworkAdapters *NetworkAdapterList `json:"networkAdapters,omitempty"`

	// REQUIRED; The webproxy settings of device.
	WebproxySettings *WebproxySettings `json:"webproxySettings,omitempty"`
}

// NicIPv4 - Details related to the IPv4 address configuration.
type NicIPv4 struct {
	// The IPv4 address of Controller0.
	Controller0IPv4Address *string `json:"controller0Ipv4Address,omitempty"`

	// The IPv4 address of Controller1.
	Controller1IPv4Address *string `json:"controller1Ipv4Address,omitempty"`

	// The IPv4 address of the network adapter.
	IPv4Address *string `json:"ipv4Address,omitempty"`

	// The IPv4 gateway of the network adapter.
	IPv4Gateway *string `json:"ipv4Gateway,omitempty"`

	// The IPv4 netmask of the network adapter.
	IPv4Netmask *string `json:"ipv4Netmask,omitempty"`
}

// NicIPv6 - Details related to the IPv6 address configuration.
type NicIPv6 struct {
	// The IPv6 address of Controller0.
	Controller0IPv6Address *string `json:"controller0Ipv6Address,omitempty"`

	// The IPv6 address of Controller1.
	Controller1IPv6Address *string `json:"controller1Ipv6Address,omitempty"`

	// The IPv6 address of the network adapter.
	IPv6Address *string `json:"ipv6Address,omitempty"`

	// The IPv6 gateway of the network adapter.
	IPv6Gateway *string `json:"ipv6Gateway,omitempty"`

	// The IPv6 prefix of the network adapter.
	IPv6Prefix *string `json:"ipv6Prefix,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PublicKey - The public key.
type PublicKey struct {
	// REQUIRED; The key.
	Key *string `json:"key,omitempty"`
}

// RemoteManagementSettings - The settings for remote management of a device.
type RemoteManagementSettings struct {
	// REQUIRED; The remote management mode.
	RemoteManagementMode *RemoteManagementModeConfiguration `json:"remoteManagementMode,omitempty"`

	// The remote management certificates.
	RemoteManagementCertificate *string `json:"remoteManagementCertificate,omitempty"`
}

// RemoteManagementSettingsPatch - The settings for updating remote management mode of the device.
type RemoteManagementSettingsPatch struct {
	// REQUIRED; The remote management mode.
	RemoteManagementMode *RemoteManagementModeConfiguration `json:"remoteManagementMode,omitempty"`
}

// Resource - The Azure Resource.
type Resource struct {
	// REQUIRED; The geo location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScheduleRecurrence - The schedule recurrence.
type ScheduleRecurrence struct {
	// REQUIRED; The recurrence type.
	RecurrenceType *RecurrenceType `json:"recurrenceType,omitempty"`

	// REQUIRED; The recurrence value.
	RecurrenceValue *int32 `json:"recurrenceValue,omitempty"`

	// The week days list. Applicable only for schedules of recurrence type 'weekly'.
	WeeklyDaysList []*DayOfWeek `json:"weeklyDaysList,omitempty"`
}

// SecondaryDNSSettings - The secondary DNS settings.
type SecondaryDNSSettings struct {
	// The list of secondary DNS Server IP addresses.
	SecondaryDNSServers []*string `json:"secondaryDnsServers,omitempty"`
}

// SecuritySettings - The security settings of a device.
type SecuritySettings struct {
	// REQUIRED; The properties of the security settings of a device.
	Properties *SecuritySettingsProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecuritySettingsPatch - Represents the patch request for the security settings of a device.
type SecuritySettingsPatch struct {
	// REQUIRED; The properties of the security settings patch.
	Properties *SecuritySettingsPatchProperties `json:"properties,omitempty"`
}

// SecuritySettingsPatchProperties - The properties of the security settings patch.
type SecuritySettingsPatchProperties struct {
	// The device CHAP and reverse-CHAP settings.
	ChapSettings *ChapSettings `json:"chapSettings,omitempty"`

	// The cloud appliance settings.
	CloudApplianceSettings *CloudApplianceSettings `json:"cloudApplianceSettings,omitempty"`

	// The device administrator password.
	DeviceAdminPassword *AsymmetricEncryptedSecret `json:"deviceAdminPassword,omitempty"`

	// The remote management settings.
	RemoteManagementSettings *RemoteManagementSettingsPatch `json:"remoteManagementSettings,omitempty"`

	// The snapshot manager password.
	SnapshotPassword *AsymmetricEncryptedSecret `json:"snapshotPassword,omitempty"`
}

// SecuritySettingsProperties - The properties of security settings of a device.
type SecuritySettingsProperties struct {
	// REQUIRED; The Challenge-Handshake Authentication Protocol (CHAP) settings.
	ChapSettings *ChapSettings `json:"chapSettings,omitempty"`

	// REQUIRED; The settings for remote management of a device.
	RemoteManagementSettings *RemoteManagementSettings `json:"remoteManagementSettings,omitempty"`
}

// SendTestAlertEmailRequest - The request for sending test alert email
type SendTestAlertEmailRequest struct {
	// REQUIRED; The list of email IDs to send the test alert email
	EmailList []*string `json:"emailList,omitempty"`
}

// StorageAccountCredential - The storage account credential.
type StorageAccountCredential struct {
	// REQUIRED; The storage account credential properties.
	Properties *StorageAccountCredentialProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageAccountCredentialList - The collection of storage account credential entities.
type StorageAccountCredentialList struct {
	// REQUIRED; The value.
	Value []*StorageAccountCredential `json:"value,omitempty"`
}

// StorageAccountCredentialProperties - The storage account credential properties.
type StorageAccountCredentialProperties struct {
	// REQUIRED; The storage endpoint
	EndPoint *string `json:"endPoint,omitempty"`

	// REQUIRED; Signifies whether SSL needs to be enabled or not.
	SSLStatus *SSLStatus `json:"sslStatus,omitempty"`

	// The details of the storage account password.
	AccessKey *AsymmetricEncryptedSecret `json:"accessKey,omitempty"`

	// READ-ONLY; The count of volumes using this storage account credential.
	VolumesCount *int32 `json:"volumesCount,omitempty" azure:"ro"`
}

// StorageAccountCredentialsClientBeginCreateOrUpdateOptions contains the optional parameters for the StorageAccountCredentialsClient.BeginCreateOrUpdate
// method.
type StorageAccountCredentialsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageAccountCredentialsClientBeginDeleteOptions contains the optional parameters for the StorageAccountCredentialsClient.BeginDelete
// method.
type StorageAccountCredentialsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageAccountCredentialsClientGetOptions contains the optional parameters for the StorageAccountCredentialsClient.Get
// method.
type StorageAccountCredentialsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountCredentialsClientListByManagerOptions contains the optional parameters for the StorageAccountCredentialsClient.ListByManager
// method.
type StorageAccountCredentialsClientListByManagerOptions struct {
	// placeholder for future optional parameters
}

// SymmetricEncryptedSecret - Represents the secrets encrypted using Symmetric Encryption Key.
type SymmetricEncryptedSecret struct {
	// REQUIRED; The algorithm used to encrypt the "Value".
	EncryptionAlgorithm *EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`

	// REQUIRED; The value of the secret itself. If the secret is in plaintext or null then EncryptionAlgorithm will be none.
	Value *string `json:"value,omitempty"`

	// The thumbprint of the cert that was used to encrypt "Value".
	ValueCertificateThumbprint *string `json:"valueCertificateThumbprint,omitempty"`
}

// TargetEligibilityErrorMessage - The error/warning message due to which the device is ineligible as a failover target device.
type TargetEligibilityErrorMessage struct {
	// The localized error message stating the reason why the device is not eligible as a target device.
	Message *string `json:"message,omitempty"`

	// The localized resolution message for the error.
	Resolution *string `json:"resolution,omitempty"`

	// The result code for the error, due to which the device does not qualify as a failover target device.
	ResultCode *TargetEligibilityResultCode `json:"resultCode,omitempty"`
}

// TargetEligibilityResult - The eligibility result of device, as a failover target device.
type TargetEligibilityResult struct {
	// The eligibility status of device, as a failover target device.
	EligibilityStatus *TargetEligibilityStatus `json:"eligibilityStatus,omitempty"`

	// The list of error messages, if a device does not qualify as a failover target device.
	Messages []*TargetEligibilityErrorMessage `json:"messages,omitempty"`
}

// Time - The time.
type Time struct {
	// REQUIRED; The hour.
	Hours *int32 `json:"hours,omitempty"`

	// REQUIRED; The minute.
	Minutes *int32 `json:"minutes,omitempty"`

	// REQUIRED; The second.
	Seconds *int32 `json:"seconds,omitempty"`
}

// TimeSettings - The time settings of a device.
type TimeSettings struct {
	// REQUIRED; The properties of the time settings of a device.
	Properties *TimeSettingsProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TimeSettingsProperties - The properties of time settings of a device.
type TimeSettingsProperties struct {
	// REQUIRED; The timezone of device, like '(UTC -06:00) Central America'
	TimeZone *string `json:"timeZone,omitempty"`

	// The primary Network Time Protocol (NTP) server name, like 'time.windows.com'.
	PrimaryTimeServer *string `json:"primaryTimeServer,omitempty"`

	// The secondary Network Time Protocol (NTP) server name, like 'time.contoso.com'. It's optional.
	SecondaryTimeServer []*string `json:"secondaryTimeServer,omitempty"`
}

// Updates - The updates profile of a device.
type Updates struct {
	// REQUIRED; The properties of the updates profile.
	Properties *UpdatesProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpdatesProperties - The properties of the updates profile.
type UpdatesProperties struct {
	// Indicates whether an update is in progress or not.
	IsUpdateInProgress *bool `json:"isUpdateInProgress,omitempty"`

	// The time when the last update was completed.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty"`

	// Set to 'true' if maintenance mode update available.
	MaintenanceModeUpdatesAvailable *bool `json:"maintenanceModeUpdatesAvailable,omitempty"`

	// Set to 'true' if regular updates are available for the device.
	RegularUpdatesAvailable *bool `json:"regularUpdatesAvailable,omitempty"`
}

// VMImage - The virtual machine image.
type VMImage struct {
	// REQUIRED; The name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The offer.
	Offer *string `json:"offer,omitempty"`

	// REQUIRED; The publisher.
	Publisher *string `json:"publisher,omitempty"`

	// REQUIRED; The SKU.
	SKU *string `json:"sku,omitempty"`

	// REQUIRED; The version.
	Version *string `json:"version,omitempty"`
}

// Volume - The volume.
type Volume struct {
	// REQUIRED; The properties of the volume.
	Properties *VolumeProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VolumeContainer - The volume container.
type VolumeContainer struct {
	// REQUIRED; The volume container properties.
	Properties *VolumeContainerProperties `json:"properties,omitempty"`

	// The Kind of the object. Currently only Series8000 is supported
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VolumeContainerFailoverMetadata - The metadata of the volume container, that is being considered as part of a failover
// set.
type VolumeContainerFailoverMetadata struct {
	// The path ID of the volume container.
	VolumeContainerID *string `json:"volumeContainerId,omitempty"`

	// The list of metadata of volumes inside the volume container, which contains valid cloud snapshots.
	Volumes []*VolumeFailoverMetadata `json:"volumes,omitempty"`
}

// VolumeContainerList - The collection of volume container entities.
type VolumeContainerList struct {
	// REQUIRED; The value.
	Value []*VolumeContainer `json:"value,omitempty"`
}

// VolumeContainerProperties - The properties of volume container.
type VolumeContainerProperties struct {
	// REQUIRED; The path ID of storage account associated with the volume container.
	StorageAccountCredentialID *string `json:"storageAccountCredentialId,omitempty"`

	// The bandwidth-rate set on the volume container.
	BandWidthRateInMbps *int32 `json:"bandWidthRateInMbps,omitempty"`

	// The ID of the bandwidth setting associated with the volume container.
	BandwidthSettingID *string `json:"bandwidthSettingId,omitempty"`

	// The key used to encrypt data in the volume container. It is required when property 'EncryptionStatus' is "Enabled".
	EncryptionKey *AsymmetricEncryptedSecret `json:"encryptionKey,omitempty"`

	// READ-ONLY; The flag to denote whether encryption is enabled or not.
	EncryptionStatus *EncryptionStatus `json:"encryptionStatus,omitempty" azure:"ro"`

	// READ-ONLY; The owner ship status of the volume container. Only when the status is "NotOwned", the delete operation on the
	// volume container is permitted.
	OwnerShipStatus *OwnerShipStatus `json:"ownerShipStatus,omitempty" azure:"ro"`

	// READ-ONLY; The total cloud storage for the volume container.
	TotalCloudStorageUsageInBytes *int64 `json:"totalCloudStorageUsageInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The number of volumes in the volume Container.
	VolumeCount *int32 `json:"volumeCount,omitempty" azure:"ro"`
}

// VolumeContainersClientBeginCreateOrUpdateOptions contains the optional parameters for the VolumeContainersClient.BeginCreateOrUpdate
// method.
type VolumeContainersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumeContainersClientBeginDeleteOptions contains the optional parameters for the VolumeContainersClient.BeginDelete method.
type VolumeContainersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumeContainersClientGetOptions contains the optional parameters for the VolumeContainersClient.Get method.
type VolumeContainersClientGetOptions struct {
	// placeholder for future optional parameters
}

// VolumeContainersClientListByDeviceOptions contains the optional parameters for the VolumeContainersClient.ListByDevice
// method.
type VolumeContainersClientListByDeviceOptions struct {
	// placeholder for future optional parameters
}

// VolumeContainersClientListMetricDefinitionOptions contains the optional parameters for the VolumeContainersClient.ListMetricDefinition
// method.
type VolumeContainersClientListMetricDefinitionOptions struct {
	// placeholder for future optional parameters
}

// VolumeContainersClientListMetricsOptions contains the optional parameters for the VolumeContainersClient.ListMetrics method.
type VolumeContainersClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// VolumeFailoverMetadata - The metadata of a volume that has valid cloud snapshot.
type VolumeFailoverMetadata struct {
	// The date at which the snapshot was taken.
	BackupCreatedDate *time.Time `json:"backupCreatedDate,omitempty"`

	// The path ID of the backup-element for this volume, inside the backup set.
	BackupElementID *string `json:"backupElementId,omitempty"`

	// The path ID of the backup set.
	BackupID *string `json:"backupId,omitempty"`

	// The path ID of the backup policy using which the snapshot was taken.
	BackupPolicyID *string `json:"backupPolicyId,omitempty"`

	// The size of the volume in bytes at the time the snapshot was taken.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`

	// The path ID of the volume.
	VolumeID *string `json:"volumeId,omitempty"`

	// The type of the volume.
	VolumeType *VolumeType `json:"volumeType,omitempty"`
}

// VolumeList - The collection of volumes.
type VolumeList struct {
	// REQUIRED; The value.
	Value []*Volume `json:"value,omitempty"`
}

// VolumeProperties - The properties of volume.
type VolumeProperties struct {
	// REQUIRED; The IDs of the access control records, associated with the volume.
	AccessControlRecordIDs []*string `json:"accessControlRecordIds,omitempty"`

	// REQUIRED; The monitoring status of the volume.
	MonitoringStatus *MonitoringStatus `json:"monitoringStatus,omitempty"`

	// REQUIRED; The size of the volume in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`

	// REQUIRED; The volume status.
	VolumeStatus *VolumeStatus `json:"volumeStatus,omitempty"`

	// REQUIRED; The type of the volume.
	VolumeType *VolumeType `json:"volumeType,omitempty"`

	// READ-ONLY; The IDs of the backup policies, in which this volume is part of.
	BackupPolicyIDs []*string `json:"backupPolicyIds,omitempty" azure:"ro"`

	// READ-ONLY; The backup status of the volume.
	BackupStatus *BackupStatus `json:"backupStatus,omitempty" azure:"ro"`

	// READ-ONLY; The operation status on the volume.
	OperationStatus *OperationStatus `json:"operationStatus,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the volume container, in which this volume is created.
	VolumeContainerID *string `json:"volumeContainerId,omitempty" azure:"ro"`
}

// VolumesClientBeginCreateOrUpdateOptions contains the optional parameters for the VolumesClient.BeginCreateOrUpdate method.
type VolumesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginDeleteOptions contains the optional parameters for the VolumesClient.BeginDelete method.
type VolumesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientGetOptions contains the optional parameters for the VolumesClient.Get method.
type VolumesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VolumesClientListByDeviceOptions contains the optional parameters for the VolumesClient.ListByDevice method.
type VolumesClientListByDeviceOptions struct {
	// placeholder for future optional parameters
}

// VolumesClientListByVolumeContainerOptions contains the optional parameters for the VolumesClient.ListByVolumeContainer
// method.
type VolumesClientListByVolumeContainerOptions struct {
	// placeholder for future optional parameters
}

// VolumesClientListMetricDefinitionOptions contains the optional parameters for the VolumesClient.ListMetricDefinition method.
type VolumesClientListMetricDefinitionOptions struct {
	// placeholder for future optional parameters
}

// VolumesClientListMetricsOptions contains the optional parameters for the VolumesClient.ListMetrics method.
type VolumesClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// WebproxySettings - The web proxy settings on the device.
type WebproxySettings struct {
	// REQUIRED; The authentication type.
	Authentication *AuthenticationType `json:"authentication,omitempty"`

	// REQUIRED; The webproxy username.
	Username *string `json:"username,omitempty"`

	// The connection URI.
	ConnectionURI *string `json:"connectionUri,omitempty"`
}
