//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvisualstudio

// AccountResource - The response to an account resource GET request.
type AccountResource struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties map[string]*string `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Unique identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountResourceListResult - The response to an account resource list GET request.
type AccountResourceListResult struct {
	// Array of resource details.
	Value []*AccountResource `json:"value,omitempty"`
}

// AccountResourceRequest - The body of a PUT request to modify a Visual Studio account resource.
type AccountResourceRequest struct {
	// The account name.
	AccountName *string `json:"accountName,omitempty"`

	// The Azure instance location.
	Location *string `json:"location,omitempty"`

	// The type of the operation.
	OperationType *AccountResourceRequestOperationType `json:"operationType,omitempty"`

	// The custom properties of the resource.
	Properties map[string]*string `json:"properties,omitempty"`

	// The custom tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AccountTagRequest - The body of a Patch request to add tags to a Visual Studio account resource.
type AccountTagRequest struct {
	// The custom tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AccountsClientCheckNameAvailabilityOptions contains the optional parameters for the AccountsClient.CheckNameAvailability
// method.
type AccountsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientCreateOrUpdateOptions contains the optional parameters for the AccountsClient.CreateOrUpdate method.
type AccountsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientDeleteOptions contains the optional parameters for the AccountsClient.Delete method.
type AccountsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientGetOptions contains the optional parameters for the AccountsClient.Get method.
type AccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListByResourceGroupOptions contains the optional parameters for the AccountsClient.ListByResourceGroup method.
type AccountsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientUpdateOptions contains the optional parameters for the AccountsClient.Update method.
type AccountsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CheckNameAvailabilityParameter - The body of a POST request to check name availability.
type CheckNameAvailabilityParameter struct {
	// The name of the resource to check availability for.
	ResourceName *string `json:"resourceName,omitempty"`

	// The type of resource to check availability for.
	ResourceType *string `json:"resourceType,omitempty"`
}

// CheckNameAvailabilityResult - The response to a name availability request.
type CheckNameAvailabilityResult struct {
	// The message describing the detailed reason.
	Message *string `json:"message,omitempty"`

	// The value which indicates whether the provided name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
}

// ExtensionResource - The response to an extension resource GET request.
type ExtensionResource struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// The extension plan that was purchased.
	Plan *ExtensionResourcePlan `json:"plan,omitempty"`

	// Resource properties.
	Properties map[string]*string `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Unique identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExtensionResourceListResult - The response to an extension resource list GET request.
type ExtensionResourceListResult struct {
	// Array of extension resource details.
	Value []*ExtensionResource `json:"value,omitempty"`
}

// ExtensionResourcePlan - Plan data for an extension resource.
type ExtensionResourcePlan struct {
	// Name of the plan.
	Name *string `json:"name,omitempty"`

	// Product name.
	Product *string `json:"product,omitempty"`

	// Optional: the promotion code associated with the plan.
	PromotionCode *string `json:"promotionCode,omitempty"`

	// Name of the extension publisher.
	Publisher *string `json:"publisher,omitempty"`

	// A string that uniquely identifies the plan version.
	Version *string `json:"version,omitempty"`
}

// ExtensionResourceRequest - The body of an extension resource PUT request.
type ExtensionResourceRequest struct {
	// The Azure region of the Visual Studio account associated with this request (i.e 'southcentralus'.)
	Location *string `json:"location,omitempty"`

	// Extended information about the plan being purchased for this extension resource.
	Plan *ExtensionResourcePlan `json:"plan,omitempty"`

	// A dictionary of extended properties. This property is currently unused.
	Properties map[string]*string `json:"properties,omitempty"`

	// A dictionary of user-defined tags to be stored with the extension resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ExtensionsClientCreateOptions contains the optional parameters for the ExtensionsClient.Create method.
type ExtensionsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// ExtensionsClientDeleteOptions contains the optional parameters for the ExtensionsClient.Delete method.
type ExtensionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ExtensionsClientGetOptions contains the optional parameters for the ExtensionsClient.Get method.
type ExtensionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExtensionsClientListByAccountOptions contains the optional parameters for the ExtensionsClient.ListByAccount method.
type ExtensionsClientListByAccountOptions struct {
	// placeholder for future optional parameters
}

// ExtensionsClientUpdateOptions contains the optional parameters for the ExtensionsClient.Update method.
type ExtensionsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// Operation - Properties of an operation supported by the resource provider.
type Operation struct {
	// The properties of the resource operation.
	Display *OperationProperties `json:"display,omitempty"`

	// The name of the resource operation.
	Name *string `json:"name,omitempty"`
}

// OperationListResult - Container for a list of operations supported by a resource provider.
type OperationListResult struct {
	// A list of operations supported by a resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationProperties - Properties of an operation supported by the resource provider.
type OperationProperties struct {
	// The description of the resource operation.
	Description *string `json:"description,omitempty"`

	// The operation name.
	Operation *string `json:"operation,omitempty"`

	// The provider name.
	Provider *string `json:"provider,omitempty"`

	// The resource name.
	Resource *string `json:"resource,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProjectResource - A Visual Studio Team Services project resource.
type ProjectResource struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Key/value pair of resource properties.
	Properties map[string]*string `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Unique identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProjectResourceListResult - The response to a request to list Team Services project resources in a resource group/account.
type ProjectResourceListResult struct {
	// List of project resource details.
	Value []*ProjectResource `json:"value,omitempty"`
}

// ProjectsClientBeginCreateOptions contains the optional parameters for the ProjectsClient.BeginCreate method.
type ProjectsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// This parameter is ignored and should be set to an empty string.
	Validating *string
}

// ProjectsClientGetJobStatusOptions contains the optional parameters for the ProjectsClient.GetJobStatus method.
type ProjectsClientGetJobStatusOptions struct {
	// The job identifier.
	JobID *string
}

// ProjectsClientGetOptions contains the optional parameters for the ProjectsClient.Get method.
type ProjectsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProjectsClientListByResourceGroupOptions contains the optional parameters for the ProjectsClient.ListByResourceGroup method.
type ProjectsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ProjectsClientUpdateOptions contains the optional parameters for the ProjectsClient.Update method.
type ProjectsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// Resource - A generic Azure Resource Manager resource.
type Resource struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Unique identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}
