// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets a metadata generation run in Amazon DataZone.
func (c *Client) GetMetadataGenerationRun(ctx context.Context, params *GetMetadataGenerationRunInput, optFns ...func(*Options)) (*GetMetadataGenerationRunOutput, error) {
	if params == nil {
		params = &GetMetadataGenerationRunInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetMetadataGenerationRun", params, optFns, c.addOperationGetMetadataGenerationRunMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetMetadataGenerationRunOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetMetadataGenerationRunInput struct {

	// The ID of the Amazon DataZone domain the metadata generation run of which you
	// want to get.
	//
	// This member is required.
	DomainIdentifier *string

	// The identifier of the metadata generation run.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetMetadataGenerationRunOutput struct {

	// The ID of the Amazon DataZone domain the metadata generation run of which you
	// want to get.
	//
	// This member is required.
	DomainId *string

	// The ID of the metadata generation run.
	//
	// This member is required.
	Id *string

	// The ID of the project that owns the assets for which you're running metadata
	// generation.
	//
	// This member is required.
	OwningProjectId *string

	// The timestamp of when the metadata generation run was start.
	CreatedAt *time.Time

	// The Amazon DataZone user who started the metadata generation run.
	CreatedBy *string

	// The status of the metadata generation run.
	Status types.MetadataGenerationRunStatus

	// The asset for which you're generating metadata.
	Target *types.MetadataGenerationRunTarget

	// The type of metadata generation run.
	Type types.MetadataGenerationRunType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetMetadataGenerationRunMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetMetadataGenerationRun{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetMetadataGenerationRun{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetMetadataGenerationRun"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetMetadataGenerationRunValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetMetadataGenerationRun(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetMetadataGenerationRun(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetMetadataGenerationRun",
	}
}
