// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package securitycenter provides access to the Security Command Center API.
//
// For product documentation, see: https://cloud.google.com/security-command-center
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/securitycenter/v1"
//	...
//	ctx := context.Background()
//	securitycenterService, err := securitycenter.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	securitycenterService, err := securitycenter.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	securitycenterService, err := securitycenter.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package securitycenter // import "google.golang.org/api/securitycenter/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "securitycenter:v1"
const apiName = "securitycenter"
const apiVersion = "v1"
const basePath = "https://securitycenter.googleapis.com/"
const basePathTemplate = "https://securitycenter.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://securitycenter.mtls.googleapis.com/"
const defaultUniverseDomain = "googleapis.com"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.WithDefaultUniverseDomain(defaultUniverseDomain))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Folders = NewFoldersService(s)
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Folders *FoldersService

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewFoldersService(s *Service) *FoldersService {
	rs := &FoldersService{s: s}
	rs.Assets = NewFoldersAssetsService(s)
	rs.BigQueryExports = NewFoldersBigQueryExportsService(s)
	rs.EventThreatDetectionSettings = NewFoldersEventThreatDetectionSettingsService(s)
	rs.Findings = NewFoldersFindingsService(s)
	rs.Locations = NewFoldersLocationsService(s)
	rs.MuteConfigs = NewFoldersMuteConfigsService(s)
	rs.NotificationConfigs = NewFoldersNotificationConfigsService(s)
	rs.SecurityHealthAnalyticsSettings = NewFoldersSecurityHealthAnalyticsSettingsService(s)
	rs.Sources = NewFoldersSourcesService(s)
	return rs
}

type FoldersService struct {
	s *Service

	Assets *FoldersAssetsService

	BigQueryExports *FoldersBigQueryExportsService

	EventThreatDetectionSettings *FoldersEventThreatDetectionSettingsService

	Findings *FoldersFindingsService

	Locations *FoldersLocationsService

	MuteConfigs *FoldersMuteConfigsService

	NotificationConfigs *FoldersNotificationConfigsService

	SecurityHealthAnalyticsSettings *FoldersSecurityHealthAnalyticsSettingsService

	Sources *FoldersSourcesService
}

func NewFoldersAssetsService(s *Service) *FoldersAssetsService {
	rs := &FoldersAssetsService{s: s}
	return rs
}

type FoldersAssetsService struct {
	s *Service
}

func NewFoldersBigQueryExportsService(s *Service) *FoldersBigQueryExportsService {
	rs := &FoldersBigQueryExportsService{s: s}
	return rs
}

type FoldersBigQueryExportsService struct {
	s *Service
}

func NewFoldersEventThreatDetectionSettingsService(s *Service) *FoldersEventThreatDetectionSettingsService {
	rs := &FoldersEventThreatDetectionSettingsService{s: s}
	rs.CustomModules = NewFoldersEventThreatDetectionSettingsCustomModulesService(s)
	rs.EffectiveCustomModules = NewFoldersEventThreatDetectionSettingsEffectiveCustomModulesService(s)
	return rs
}

type FoldersEventThreatDetectionSettingsService struct {
	s *Service

	CustomModules *FoldersEventThreatDetectionSettingsCustomModulesService

	EffectiveCustomModules *FoldersEventThreatDetectionSettingsEffectiveCustomModulesService
}

func NewFoldersEventThreatDetectionSettingsCustomModulesService(s *Service) *FoldersEventThreatDetectionSettingsCustomModulesService {
	rs := &FoldersEventThreatDetectionSettingsCustomModulesService{s: s}
	return rs
}

type FoldersEventThreatDetectionSettingsCustomModulesService struct {
	s *Service
}

func NewFoldersEventThreatDetectionSettingsEffectiveCustomModulesService(s *Service) *FoldersEventThreatDetectionSettingsEffectiveCustomModulesService {
	rs := &FoldersEventThreatDetectionSettingsEffectiveCustomModulesService{s: s}
	return rs
}

type FoldersEventThreatDetectionSettingsEffectiveCustomModulesService struct {
	s *Service
}

func NewFoldersFindingsService(s *Service) *FoldersFindingsService {
	rs := &FoldersFindingsService{s: s}
	return rs
}

type FoldersFindingsService struct {
	s *Service
}

func NewFoldersLocationsService(s *Service) *FoldersLocationsService {
	rs := &FoldersLocationsService{s: s}
	rs.MuteConfigs = NewFoldersLocationsMuteConfigsService(s)
	return rs
}

type FoldersLocationsService struct {
	s *Service

	MuteConfigs *FoldersLocationsMuteConfigsService
}

func NewFoldersLocationsMuteConfigsService(s *Service) *FoldersLocationsMuteConfigsService {
	rs := &FoldersLocationsMuteConfigsService{s: s}
	return rs
}

type FoldersLocationsMuteConfigsService struct {
	s *Service
}

func NewFoldersMuteConfigsService(s *Service) *FoldersMuteConfigsService {
	rs := &FoldersMuteConfigsService{s: s}
	return rs
}

type FoldersMuteConfigsService struct {
	s *Service
}

func NewFoldersNotificationConfigsService(s *Service) *FoldersNotificationConfigsService {
	rs := &FoldersNotificationConfigsService{s: s}
	return rs
}

type FoldersNotificationConfigsService struct {
	s *Service
}

func NewFoldersSecurityHealthAnalyticsSettingsService(s *Service) *FoldersSecurityHealthAnalyticsSettingsService {
	rs := &FoldersSecurityHealthAnalyticsSettingsService{s: s}
	rs.CustomModules = NewFoldersSecurityHealthAnalyticsSettingsCustomModulesService(s)
	rs.EffectiveCustomModules = NewFoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesService(s)
	return rs
}

type FoldersSecurityHealthAnalyticsSettingsService struct {
	s *Service

	CustomModules *FoldersSecurityHealthAnalyticsSettingsCustomModulesService

	EffectiveCustomModules *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesService
}

func NewFoldersSecurityHealthAnalyticsSettingsCustomModulesService(s *Service) *FoldersSecurityHealthAnalyticsSettingsCustomModulesService {
	rs := &FoldersSecurityHealthAnalyticsSettingsCustomModulesService{s: s}
	return rs
}

type FoldersSecurityHealthAnalyticsSettingsCustomModulesService struct {
	s *Service
}

func NewFoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesService(s *Service) *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesService {
	rs := &FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesService{s: s}
	return rs
}

type FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesService struct {
	s *Service
}

func NewFoldersSourcesService(s *Service) *FoldersSourcesService {
	rs := &FoldersSourcesService{s: s}
	rs.Findings = NewFoldersSourcesFindingsService(s)
	return rs
}

type FoldersSourcesService struct {
	s *Service

	Findings *FoldersSourcesFindingsService
}

func NewFoldersSourcesFindingsService(s *Service) *FoldersSourcesFindingsService {
	rs := &FoldersSourcesFindingsService{s: s}
	rs.ExternalSystems = NewFoldersSourcesFindingsExternalSystemsService(s)
	return rs
}

type FoldersSourcesFindingsService struct {
	s *Service

	ExternalSystems *FoldersSourcesFindingsExternalSystemsService
}

func NewFoldersSourcesFindingsExternalSystemsService(s *Service) *FoldersSourcesFindingsExternalSystemsService {
	rs := &FoldersSourcesFindingsExternalSystemsService{s: s}
	return rs
}

type FoldersSourcesFindingsExternalSystemsService struct {
	s *Service
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Assets = NewOrganizationsAssetsService(s)
	rs.BigQueryExports = NewOrganizationsBigQueryExportsService(s)
	rs.EventThreatDetectionSettings = NewOrganizationsEventThreatDetectionSettingsService(s)
	rs.Findings = NewOrganizationsFindingsService(s)
	rs.Locations = NewOrganizationsLocationsService(s)
	rs.MuteConfigs = NewOrganizationsMuteConfigsService(s)
	rs.NotificationConfigs = NewOrganizationsNotificationConfigsService(s)
	rs.Operations = NewOrganizationsOperationsService(s)
	rs.ResourceValueConfigs = NewOrganizationsResourceValueConfigsService(s)
	rs.SecurityHealthAnalyticsSettings = NewOrganizationsSecurityHealthAnalyticsSettingsService(s)
	rs.Simulations = NewOrganizationsSimulationsService(s)
	rs.Sources = NewOrganizationsSourcesService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Assets *OrganizationsAssetsService

	BigQueryExports *OrganizationsBigQueryExportsService

	EventThreatDetectionSettings *OrganizationsEventThreatDetectionSettingsService

	Findings *OrganizationsFindingsService

	Locations *OrganizationsLocationsService

	MuteConfigs *OrganizationsMuteConfigsService

	NotificationConfigs *OrganizationsNotificationConfigsService

	Operations *OrganizationsOperationsService

	ResourceValueConfigs *OrganizationsResourceValueConfigsService

	SecurityHealthAnalyticsSettings *OrganizationsSecurityHealthAnalyticsSettingsService

	Simulations *OrganizationsSimulationsService

	Sources *OrganizationsSourcesService
}

func NewOrganizationsAssetsService(s *Service) *OrganizationsAssetsService {
	rs := &OrganizationsAssetsService{s: s}
	return rs
}

type OrganizationsAssetsService struct {
	s *Service
}

func NewOrganizationsBigQueryExportsService(s *Service) *OrganizationsBigQueryExportsService {
	rs := &OrganizationsBigQueryExportsService{s: s}
	return rs
}

type OrganizationsBigQueryExportsService struct {
	s *Service
}

func NewOrganizationsEventThreatDetectionSettingsService(s *Service) *OrganizationsEventThreatDetectionSettingsService {
	rs := &OrganizationsEventThreatDetectionSettingsService{s: s}
	rs.CustomModules = NewOrganizationsEventThreatDetectionSettingsCustomModulesService(s)
	rs.EffectiveCustomModules = NewOrganizationsEventThreatDetectionSettingsEffectiveCustomModulesService(s)
	return rs
}

type OrganizationsEventThreatDetectionSettingsService struct {
	s *Service

	CustomModules *OrganizationsEventThreatDetectionSettingsCustomModulesService

	EffectiveCustomModules *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesService
}

func NewOrganizationsEventThreatDetectionSettingsCustomModulesService(s *Service) *OrganizationsEventThreatDetectionSettingsCustomModulesService {
	rs := &OrganizationsEventThreatDetectionSettingsCustomModulesService{s: s}
	return rs
}

type OrganizationsEventThreatDetectionSettingsCustomModulesService struct {
	s *Service
}

func NewOrganizationsEventThreatDetectionSettingsEffectiveCustomModulesService(s *Service) *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesService {
	rs := &OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesService{s: s}
	return rs
}

type OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesService struct {
	s *Service
}

func NewOrganizationsFindingsService(s *Service) *OrganizationsFindingsService {
	rs := &OrganizationsFindingsService{s: s}
	return rs
}

type OrganizationsFindingsService struct {
	s *Service
}

func NewOrganizationsLocationsService(s *Service) *OrganizationsLocationsService {
	rs := &OrganizationsLocationsService{s: s}
	rs.MuteConfigs = NewOrganizationsLocationsMuteConfigsService(s)
	return rs
}

type OrganizationsLocationsService struct {
	s *Service

	MuteConfigs *OrganizationsLocationsMuteConfigsService
}

func NewOrganizationsLocationsMuteConfigsService(s *Service) *OrganizationsLocationsMuteConfigsService {
	rs := &OrganizationsLocationsMuteConfigsService{s: s}
	return rs
}

type OrganizationsLocationsMuteConfigsService struct {
	s *Service
}

func NewOrganizationsMuteConfigsService(s *Service) *OrganizationsMuteConfigsService {
	rs := &OrganizationsMuteConfigsService{s: s}
	return rs
}

type OrganizationsMuteConfigsService struct {
	s *Service
}

func NewOrganizationsNotificationConfigsService(s *Service) *OrganizationsNotificationConfigsService {
	rs := &OrganizationsNotificationConfigsService{s: s}
	return rs
}

type OrganizationsNotificationConfigsService struct {
	s *Service
}

func NewOrganizationsOperationsService(s *Service) *OrganizationsOperationsService {
	rs := &OrganizationsOperationsService{s: s}
	return rs
}

type OrganizationsOperationsService struct {
	s *Service
}

func NewOrganizationsResourceValueConfigsService(s *Service) *OrganizationsResourceValueConfigsService {
	rs := &OrganizationsResourceValueConfigsService{s: s}
	return rs
}

type OrganizationsResourceValueConfigsService struct {
	s *Service
}

func NewOrganizationsSecurityHealthAnalyticsSettingsService(s *Service) *OrganizationsSecurityHealthAnalyticsSettingsService {
	rs := &OrganizationsSecurityHealthAnalyticsSettingsService{s: s}
	rs.CustomModules = NewOrganizationsSecurityHealthAnalyticsSettingsCustomModulesService(s)
	rs.EffectiveCustomModules = NewOrganizationsSecurityHealthAnalyticsSettingsEffectiveCustomModulesService(s)
	return rs
}

type OrganizationsSecurityHealthAnalyticsSettingsService struct {
	s *Service

	CustomModules *OrganizationsSecurityHealthAnalyticsSettingsCustomModulesService

	EffectiveCustomModules *OrganizationsSecurityHealthAnalyticsSettingsEffectiveCustomModulesService
}

func NewOrganizationsSecurityHealthAnalyticsSettingsCustomModulesService(s *Service) *OrganizationsSecurityHealthAnalyticsSettingsCustomModulesService {
	rs := &OrganizationsSecurityHealthAnalyticsSettingsCustomModulesService{s: s}
	return rs
}

type OrganizationsSecurityHealthAnalyticsSettingsCustomModulesService struct {
	s *Service
}

func NewOrganizationsSecurityHealthAnalyticsSettingsEffectiveCustomModulesService(s *Service) *OrganizationsSecurityHealthAnalyticsSettingsEffectiveCustomModulesService {
	rs := &OrganizationsSecurityHealthAnalyticsSettingsEffectiveCustomModulesService{s: s}
	return rs
}

type OrganizationsSecurityHealthAnalyticsSettingsEffectiveCustomModulesService struct {
	s *Service
}

func NewOrganizationsSimulationsService(s *Service) *OrganizationsSimulationsService {
	rs := &OrganizationsSimulationsService{s: s}
	rs.AttackExposureResults = NewOrganizationsSimulationsAttackExposureResultsService(s)
	rs.AttackPaths = NewOrganizationsSimulationsAttackPathsService(s)
	rs.ValuedResources = NewOrganizationsSimulationsValuedResourcesService(s)
	return rs
}

type OrganizationsSimulationsService struct {
	s *Service

	AttackExposureResults *OrganizationsSimulationsAttackExposureResultsService

	AttackPaths *OrganizationsSimulationsAttackPathsService

	ValuedResources *OrganizationsSimulationsValuedResourcesService
}

func NewOrganizationsSimulationsAttackExposureResultsService(s *Service) *OrganizationsSimulationsAttackExposureResultsService {
	rs := &OrganizationsSimulationsAttackExposureResultsService{s: s}
	rs.AttackPaths = NewOrganizationsSimulationsAttackExposureResultsAttackPathsService(s)
	rs.ValuedResources = NewOrganizationsSimulationsAttackExposureResultsValuedResourcesService(s)
	return rs
}

type OrganizationsSimulationsAttackExposureResultsService struct {
	s *Service

	AttackPaths *OrganizationsSimulationsAttackExposureResultsAttackPathsService

	ValuedResources *OrganizationsSimulationsAttackExposureResultsValuedResourcesService
}

func NewOrganizationsSimulationsAttackExposureResultsAttackPathsService(s *Service) *OrganizationsSimulationsAttackExposureResultsAttackPathsService {
	rs := &OrganizationsSimulationsAttackExposureResultsAttackPathsService{s: s}
	return rs
}

type OrganizationsSimulationsAttackExposureResultsAttackPathsService struct {
	s *Service
}

func NewOrganizationsSimulationsAttackExposureResultsValuedResourcesService(s *Service) *OrganizationsSimulationsAttackExposureResultsValuedResourcesService {
	rs := &OrganizationsSimulationsAttackExposureResultsValuedResourcesService{s: s}
	return rs
}

type OrganizationsSimulationsAttackExposureResultsValuedResourcesService struct {
	s *Service
}

func NewOrganizationsSimulationsAttackPathsService(s *Service) *OrganizationsSimulationsAttackPathsService {
	rs := &OrganizationsSimulationsAttackPathsService{s: s}
	return rs
}

type OrganizationsSimulationsAttackPathsService struct {
	s *Service
}

func NewOrganizationsSimulationsValuedResourcesService(s *Service) *OrganizationsSimulationsValuedResourcesService {
	rs := &OrganizationsSimulationsValuedResourcesService{s: s}
	rs.AttackPaths = NewOrganizationsSimulationsValuedResourcesAttackPathsService(s)
	return rs
}

type OrganizationsSimulationsValuedResourcesService struct {
	s *Service

	AttackPaths *OrganizationsSimulationsValuedResourcesAttackPathsService
}

func NewOrganizationsSimulationsValuedResourcesAttackPathsService(s *Service) *OrganizationsSimulationsValuedResourcesAttackPathsService {
	rs := &OrganizationsSimulationsValuedResourcesAttackPathsService{s: s}
	return rs
}

type OrganizationsSimulationsValuedResourcesAttackPathsService struct {
	s *Service
}

func NewOrganizationsSourcesService(s *Service) *OrganizationsSourcesService {
	rs := &OrganizationsSourcesService{s: s}
	rs.Findings = NewOrganizationsSourcesFindingsService(s)
	return rs
}

type OrganizationsSourcesService struct {
	s *Service

	Findings *OrganizationsSourcesFindingsService
}

func NewOrganizationsSourcesFindingsService(s *Service) *OrganizationsSourcesFindingsService {
	rs := &OrganizationsSourcesFindingsService{s: s}
	rs.ExternalSystems = NewOrganizationsSourcesFindingsExternalSystemsService(s)
	return rs
}

type OrganizationsSourcesFindingsService struct {
	s *Service

	ExternalSystems *OrganizationsSourcesFindingsExternalSystemsService
}

func NewOrganizationsSourcesFindingsExternalSystemsService(s *Service) *OrganizationsSourcesFindingsExternalSystemsService {
	rs := &OrganizationsSourcesFindingsExternalSystemsService{s: s}
	return rs
}

type OrganizationsSourcesFindingsExternalSystemsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Assets = NewProjectsAssetsService(s)
	rs.BigQueryExports = NewProjectsBigQueryExportsService(s)
	rs.EventThreatDetectionSettings = NewProjectsEventThreatDetectionSettingsService(s)
	rs.Findings = NewProjectsFindingsService(s)
	rs.Locations = NewProjectsLocationsService(s)
	rs.MuteConfigs = NewProjectsMuteConfigsService(s)
	rs.NotificationConfigs = NewProjectsNotificationConfigsService(s)
	rs.SecurityHealthAnalyticsSettings = NewProjectsSecurityHealthAnalyticsSettingsService(s)
	rs.Sources = NewProjectsSourcesService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Assets *ProjectsAssetsService

	BigQueryExports *ProjectsBigQueryExportsService

	EventThreatDetectionSettings *ProjectsEventThreatDetectionSettingsService

	Findings *ProjectsFindingsService

	Locations *ProjectsLocationsService

	MuteConfigs *ProjectsMuteConfigsService

	NotificationConfigs *ProjectsNotificationConfigsService

	SecurityHealthAnalyticsSettings *ProjectsSecurityHealthAnalyticsSettingsService

	Sources *ProjectsSourcesService
}

func NewProjectsAssetsService(s *Service) *ProjectsAssetsService {
	rs := &ProjectsAssetsService{s: s}
	return rs
}

type ProjectsAssetsService struct {
	s *Service
}

func NewProjectsBigQueryExportsService(s *Service) *ProjectsBigQueryExportsService {
	rs := &ProjectsBigQueryExportsService{s: s}
	return rs
}

type ProjectsBigQueryExportsService struct {
	s *Service
}

func NewProjectsEventThreatDetectionSettingsService(s *Service) *ProjectsEventThreatDetectionSettingsService {
	rs := &ProjectsEventThreatDetectionSettingsService{s: s}
	rs.CustomModules = NewProjectsEventThreatDetectionSettingsCustomModulesService(s)
	rs.EffectiveCustomModules = NewProjectsEventThreatDetectionSettingsEffectiveCustomModulesService(s)
	return rs
}

type ProjectsEventThreatDetectionSettingsService struct {
	s *Service

	CustomModules *ProjectsEventThreatDetectionSettingsCustomModulesService

	EffectiveCustomModules *ProjectsEventThreatDetectionSettingsEffectiveCustomModulesService
}

func NewProjectsEventThreatDetectionSettingsCustomModulesService(s *Service) *ProjectsEventThreatDetectionSettingsCustomModulesService {
	rs := &ProjectsEventThreatDetectionSettingsCustomModulesService{s: s}
	return rs
}

type ProjectsEventThreatDetectionSettingsCustomModulesService struct {
	s *Service
}

func NewProjectsEventThreatDetectionSettingsEffectiveCustomModulesService(s *Service) *ProjectsEventThreatDetectionSettingsEffectiveCustomModulesService {
	rs := &ProjectsEventThreatDetectionSettingsEffectiveCustomModulesService{s: s}
	return rs
}

type ProjectsEventThreatDetectionSettingsEffectiveCustomModulesService struct {
	s *Service
}

func NewProjectsFindingsService(s *Service) *ProjectsFindingsService {
	rs := &ProjectsFindingsService{s: s}
	return rs
}

type ProjectsFindingsService struct {
	s *Service
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.MuteConfigs = NewProjectsLocationsMuteConfigsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	MuteConfigs *ProjectsLocationsMuteConfigsService
}

func NewProjectsLocationsMuteConfigsService(s *Service) *ProjectsLocationsMuteConfigsService {
	rs := &ProjectsLocationsMuteConfigsService{s: s}
	return rs
}

type ProjectsLocationsMuteConfigsService struct {
	s *Service
}

func NewProjectsMuteConfigsService(s *Service) *ProjectsMuteConfigsService {
	rs := &ProjectsMuteConfigsService{s: s}
	return rs
}

type ProjectsMuteConfigsService struct {
	s *Service
}

func NewProjectsNotificationConfigsService(s *Service) *ProjectsNotificationConfigsService {
	rs := &ProjectsNotificationConfigsService{s: s}
	return rs
}

type ProjectsNotificationConfigsService struct {
	s *Service
}

func NewProjectsSecurityHealthAnalyticsSettingsService(s *Service) *ProjectsSecurityHealthAnalyticsSettingsService {
	rs := &ProjectsSecurityHealthAnalyticsSettingsService{s: s}
	rs.CustomModules = NewProjectsSecurityHealthAnalyticsSettingsCustomModulesService(s)
	rs.EffectiveCustomModules = NewProjectsSecurityHealthAnalyticsSettingsEffectiveCustomModulesService(s)
	return rs
}

type ProjectsSecurityHealthAnalyticsSettingsService struct {
	s *Service

	CustomModules *ProjectsSecurityHealthAnalyticsSettingsCustomModulesService

	EffectiveCustomModules *ProjectsSecurityHealthAnalyticsSettingsEffectiveCustomModulesService
}

func NewProjectsSecurityHealthAnalyticsSettingsCustomModulesService(s *Service) *ProjectsSecurityHealthAnalyticsSettingsCustomModulesService {
	rs := &ProjectsSecurityHealthAnalyticsSettingsCustomModulesService{s: s}
	return rs
}

type ProjectsSecurityHealthAnalyticsSettingsCustomModulesService struct {
	s *Service
}

func NewProjectsSecurityHealthAnalyticsSettingsEffectiveCustomModulesService(s *Service) *ProjectsSecurityHealthAnalyticsSettingsEffectiveCustomModulesService {
	rs := &ProjectsSecurityHealthAnalyticsSettingsEffectiveCustomModulesService{s: s}
	return rs
}

type ProjectsSecurityHealthAnalyticsSettingsEffectiveCustomModulesService struct {
	s *Service
}

func NewProjectsSourcesService(s *Service) *ProjectsSourcesService {
	rs := &ProjectsSourcesService{s: s}
	rs.Findings = NewProjectsSourcesFindingsService(s)
	return rs
}

type ProjectsSourcesService struct {
	s *Service

	Findings *ProjectsSourcesFindingsService
}

func NewProjectsSourcesFindingsService(s *Service) *ProjectsSourcesFindingsService {
	rs := &ProjectsSourcesFindingsService{s: s}
	rs.ExternalSystems = NewProjectsSourcesFindingsExternalSystemsService(s)
	return rs
}

type ProjectsSourcesFindingsService struct {
	s *Service

	ExternalSystems *ProjectsSourcesFindingsExternalSystemsService
}

func NewProjectsSourcesFindingsExternalSystemsService(s *Service) *ProjectsSourcesFindingsExternalSystemsService {
	rs := &ProjectsSourcesFindingsExternalSystemsService{s: s}
	return rs
}

type ProjectsSourcesFindingsExternalSystemsService struct {
	s *Service
}

// Access: Represents an access event.
type Access struct {
	// CallerIp: Caller's IP address, such as "1.1.1.1".
	CallerIp string `json:"callerIp,omitempty"`

	// CallerIpGeo: The caller IP's geolocation, which identifies where the
	// call came from.
	CallerIpGeo *Geolocation `json:"callerIpGeo,omitempty"`

	// MethodName: The method that the service account called, e.g.
	// "SetIamPolicy".
	MethodName string `json:"methodName,omitempty"`

	// PrincipalEmail: Associated email, such as "foo@google.com". The email
	// address of the authenticated user or a service account acting on
	// behalf of a third party principal making the request. For third party
	// identity callers, the `principal_subject` field is populated instead
	// of this field. For privacy reasons, the principal email address is
	// sometimes redacted. For more information, see Caller identities in
	// audit logs (https://cloud.google.com/logging/docs/audit#user-id).
	PrincipalEmail string `json:"principalEmail,omitempty"`

	// PrincipalSubject: A string that represents the principal_subject that
	// is associated with the identity. Unlike `principal_email`,
	// `principal_subject` supports principals that aren't associated with
	// email addresses, such as third party principals. For most identities,
	// the format is `principal://iam.googleapis.com/{identity pool
	// name}/subject/{subject}`. Some GKE identities, such as GKE_WORKLOAD,
	// FREEFORM, and GKE_HUB_WORKLOAD, still use the legacy format
	// `serviceAccount:{identity pool name}[{subject}]`.
	PrincipalSubject string `json:"principalSubject,omitempty"`

	// ServiceAccountDelegationInfo: The identity delegation history of an
	// authenticated service account that made the request. The
	// `serviceAccountDelegationInfo[]` object contains information about
	// the real authorities that try to access Google Cloud resources by
	// delegating on a service account. When multiple authorities are
	// present, they are guaranteed to be sorted based on the original
	// ordering of the identity delegation events.
	ServiceAccountDelegationInfo []*ServiceAccountDelegationInfo `json:"serviceAccountDelegationInfo,omitempty"`

	// ServiceAccountKeyName: The name of the service account key that was
	// used to create or exchange credentials when authenticating the
	// service account that made the request. This is a scheme-less URI full
	// resource name. For example:
	// "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/
	// keys/{key}".
	ServiceAccountKeyName string `json:"serviceAccountKeyName,omitempty"`

	// ServiceName: This is the API service that the service account made a
	// call to, e.g. "iam.googleapis.com"
	ServiceName string `json:"serviceName,omitempty"`

	// UserAgent: The caller's user agent string associated with the
	// finding.
	UserAgent string `json:"userAgent,omitempty"`

	// UserAgentFamily: Type of user agent associated with the finding. For
	// example, an operating system shell or an embedded or standalone
	// application.
	UserAgentFamily string `json:"userAgentFamily,omitempty"`

	// UserName: A string that represents a username. The username provided
	// depends on the type of the finding and is likely not an IAM
	// principal. For example, this can be a system username if the finding
	// is related to a virtual machine, or it can be an application login
	// username.
	UserName string `json:"userName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CallerIp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallerIp") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Access) MarshalJSON() ([]byte, error) {
	type NoMethod Access
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccessReview: Conveys information about a Kubernetes access review
// (such as one returned by a `kubectl auth can-i`
// (https://kubernetes.io/docs/reference/access-authn-authz/authorization/#checking-api-access)
// command) that was involved in a finding.
type AccessReview struct {
	// Group: The API group of the resource. "*" means all.
	Group string `json:"group,omitempty"`

	// Name: The name of the resource being requested. Empty means all.
	Name string `json:"name,omitempty"`

	// Ns: Namespace of the action being requested. Currently, there is no
	// distinction between no namespace and all namespaces. Both are
	// represented by "" (empty).
	Ns string `json:"ns,omitempty"`

	// Resource: The optional resource type requested. "*" means all.
	Resource string `json:"resource,omitempty"`

	// Subresource: The optional subresource type.
	Subresource string `json:"subresource,omitempty"`

	// Verb: A Kubernetes resource API verb, like get, list, watch, create,
	// update, delete, proxy. "*" means all.
	Verb string `json:"verb,omitempty"`

	// Version: The API version of the resource. "*" means all.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Group") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Group") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccessReview) MarshalJSON() ([]byte, error) {
	type NoMethod AccessReview
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Application: Represents an application associated with a finding.
type Application struct {
	// BaseUri: The base URI that identifies the network location of the
	// application in which the vulnerability was detected. For example,
	// `http://example.com`.
	BaseUri string `json:"baseUri,omitempty"`

	// FullUri: The full URI with payload that can be used to reproduce the
	// vulnerability. For example, `http://example.com?p=aMmYgI6H`.
	FullUri string `json:"fullUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BaseUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BaseUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Application) MarshalJSON() ([]byte, error) {
	type NoMethod Application
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Asset: Security Command Center representation of a Google Cloud
// resource. The Asset is a Security Command Center resource that
// captures information about a single Google Cloud resource. All
// modifications to an Asset are only within the context of Security
// Command Center and don't affect the referenced Google Cloud resource.
type Asset struct {
	// CanonicalName: The canonical name of the resource. It's either
	// "organizations/{organization_id}/assets/{asset_id}",
	// "folders/{folder_id}/assets/{asset_id}" or
	// "projects/{project_number}/assets/{asset_id}", depending on the
	// closest CRM ancestor of the resource.
	CanonicalName string `json:"canonicalName,omitempty"`

	// CreateTime: The time at which the asset was created in Security
	// Command Center.
	CreateTime string `json:"createTime,omitempty"`

	// IamPolicy: Cloud IAM Policy information associated with the Google
	// Cloud resource described by the Security Command Center asset. This
	// information is managed and defined by the Google Cloud resource and
	// cannot be modified by the user.
	IamPolicy *IamPolicy `json:"iamPolicy,omitempty"`

	// Name: The relative resource name of this asset. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example: "organizations/{organization_id}/assets/{asset_id}".
	Name string `json:"name,omitempty"`

	// ResourceProperties: Resource managed properties. These properties are
	// managed and defined by the Google Cloud resource and cannot be
	// modified by the user.
	ResourceProperties googleapi.RawMessage `json:"resourceProperties,omitempty"`

	// SecurityCenterProperties: Security Command Center managed properties.
	// These properties are managed by Security Command Center and cannot be
	// modified by the user.
	SecurityCenterProperties *SecurityCenterProperties `json:"securityCenterProperties,omitempty"`

	// SecurityMarks: User specified security marks. These marks are
	// entirely managed by the user and come from the SecurityMarks resource
	// that belongs to the asset.
	SecurityMarks *SecurityMarks `json:"securityMarks,omitempty"`

	// UpdateTime: The time at which the asset was last updated or added in
	// Cloud SCC.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Asset) MarshalJSON() ([]byte, error) {
	type NoMethod Asset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssetDiscoveryConfig: The configuration used for Asset Discovery
// runs.
type AssetDiscoveryConfig struct {
	// FolderIds: The folder ids to use for filtering asset discovery. It
	// consists of only digits, e.g., 756619654966.
	FolderIds []string `json:"folderIds,omitempty"`

	// InclusionMode: The mode to use for filtering asset discovery.
	//
	// Possible values:
	//   "INCLUSION_MODE_UNSPECIFIED" - Unspecified. Setting the mode with
	// this value will disable inclusion/exclusion filtering for Asset
	// Discovery.
	//   "INCLUDE_ONLY" - Asset Discovery will capture only the resources
	// within the projects specified. All other resources will be ignored.
	//   "EXCLUDE" - Asset Discovery will ignore all resources under the
	// projects specified. All other resources will be retrieved.
	InclusionMode string `json:"inclusionMode,omitempty"`

	// ProjectIds: The project ids to use for filtering asset discovery.
	ProjectIds []string `json:"projectIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FolderIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FolderIds") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssetDiscoveryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AssetDiscoveryConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AttackExposure: An attack exposure contains the results of an attack
// path simulation run.
type AttackExposure struct {
	// AttackExposureResult: The resource name of the attack path simulation
	// result that contains the details regarding this attack exposure
	// score. Example:
	// organizations/123/simulations/456/attackExposureResults/789
	AttackExposureResult string `json:"attackExposureResult,omitempty"`

	// ExposedHighValueResourcesCount: The number of high value resources
	// that are exposed as a result of this finding.
	ExposedHighValueResourcesCount int64 `json:"exposedHighValueResourcesCount,omitempty"`

	// ExposedLowValueResourcesCount: The number of high value resources
	// that are exposed as a result of this finding.
	ExposedLowValueResourcesCount int64 `json:"exposedLowValueResourcesCount,omitempty"`

	// ExposedMediumValueResourcesCount: The number of medium value
	// resources that are exposed as a result of this finding.
	ExposedMediumValueResourcesCount int64 `json:"exposedMediumValueResourcesCount,omitempty"`

	// LatestCalculationTime: The most recent time the attack exposure was
	// updated on this finding.
	LatestCalculationTime string `json:"latestCalculationTime,omitempty"`

	// Score: A number between 0 (inclusive) and infinity that represents
	// how important this finding is to remediate. The higher the score, the
	// more important it is to remediate.
	Score float64 `json:"score,omitempty"`

	// State: What state this AttackExposure is in. This captures whether or
	// not an attack exposure has been calculated or not.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The state is not specified.
	//   "CALCULATED" - The attack exposure has been calculated.
	//   "NOT_CALCULATED" - The attack exposure has not been calculated.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AttackExposureResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttackExposureResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AttackExposure) MarshalJSON() ([]byte, error) {
	type NoMethod AttackExposure
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AttackExposure) UnmarshalJSON(data []byte) error {
	type NoMethod AttackExposure
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// AttackPath: A path that an attacker could take to reach an exposed
// resource.
type AttackPath struct {
	// Edges: A list of the edges between nodes in this attack path.
	Edges []*AttackPathEdge `json:"edges,omitempty"`

	// Name: The attack path name, for example,
	// `organizations/12/simulation/34/valuedResources/56/attackPaths/78`
	Name string `json:"name,omitempty"`

	// PathNodes: A list of nodes that exist in this attack path.
	PathNodes []*AttackPathNode `json:"pathNodes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Edges") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Edges") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AttackPath) MarshalJSON() ([]byte, error) {
	type NoMethod AttackPath
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AttackPathEdge: Represents a connection between a source node and a
// destination node in this attack path.
type AttackPathEdge struct {
	// Destination: The attack node uuid of the destination node.
	Destination string `json:"destination,omitempty"`

	// Source: The attack node uuid of the source node.
	Source string `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Destination") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AttackPathEdge) MarshalJSON() ([]byte, error) {
	type NoMethod AttackPathEdge
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AttackPathNode: Represents one point that an attacker passes through
// in this attack path.
type AttackPathNode struct {
	// AssociatedFindings: The findings associated with this node in the
	// attack path.
	AssociatedFindings []*PathNodeAssociatedFinding `json:"associatedFindings,omitempty"`

	// AttackSteps: A list of attack step nodes that exist in this attack
	// path node.
	AttackSteps []*AttackStepNode `json:"attackSteps,omitempty"`

	// DisplayName: Human-readable name of this resource.
	DisplayName string `json:"displayName,omitempty"`

	// Resource: The name of the resource at this point in the attack path.
	// The format of the name follows the Cloud Asset Inventory resource
	// name format
	// ("https://cloud.google.com/asset-inventory/docs/resource-name-format")
	Resource string `json:"resource,omitempty"`

	// ResourceType: The supported resource type
	// (https://cloud.google.com/asset-inventory/docs/supported-asset-types")
	ResourceType string `json:"resourceType,omitempty"`

	// Uuid: Unique id of the attack path node.
	Uuid string `json:"uuid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AssociatedFindings")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssociatedFindings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AttackPathNode) MarshalJSON() ([]byte, error) {
	type NoMethod AttackPathNode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AttackStepNode: Detailed steps the attack can take between path
// nodes.
type AttackStepNode struct {
	// Description: Attack step description
	Description string `json:"description,omitempty"`

	// DisplayName: User friendly name of the attack step
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Attack step labels for metadata
	Labels map[string]string `json:"labels,omitempty"`

	// Type: Attack step type. Can be either AND, OR or DEFENSE
	//
	// Possible values:
	//   "NODE_TYPE_UNSPECIFIED" - Type not specified
	//   "NODE_TYPE_AND" - Incoming edge joined with AND
	//   "NODE_TYPE_OR" - Incoming edge joined with OR
	//   "NODE_TYPE_DEFENSE" - Incoming edge is defense
	//   "NODE_TYPE_ATTACKER" - Incoming edge is attacker
	Type string `json:"type,omitempty"`

	// Uuid: Unique ID for one Node
	Uuid string `json:"uuid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AttackStepNode) MarshalJSON() ([]byte, error) {
	type NoMethod AttackStepNode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must
// have one or more AuditLogConfigs. If there are AuditConfigs for both
// `allServices` and a specific service, the union of the two
// AuditConfigs is used for that service: the log_types specified in
// each AuditConfig are enabled, and the exempted_members in each
// AuditLogConfig are exempted. Example Policy with multiple
// AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members":
// [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, {
// "log_type": "ADMIN_READ" } ] }, { "service":
// "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type":
// "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [
// "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy
// enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts
// `jose@example.com` from DATA_READ logging, and `aliya@example.com`
// from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of
	// permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`

	// Service: Specifies a service that will be enabled for audit logging.
	// For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
	// `allServices` is a special value that covers all services.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditLogConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type":
// "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, {
// "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and
// 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ
// logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging
	// for this type of permission. Follows the same format of
	// Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`

	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExemptedMembers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackupDisasterRecovery: Information related to Google Cloud Backup
// and DR Service findings.
type BackupDisasterRecovery struct {
	// Appliance: The name of the Backup and DR appliance that captures,
	// moves, and manages the lifecycle of backup data. For example,
	// `backup-server-57137`.
	Appliance string `json:"appliance,omitempty"`

	// Applications: The names of Backup and DR applications. An application
	// is a VM, database, or file system on a managed host monitored by a
	// backup and recovery appliance. For example, `centos7-01-vol00`,
	// `centos7-01-vol01`, `centos7-01-vol02`.
	Applications []string `json:"applications,omitempty"`

	// BackupCreateTime: The timestamp at which the Backup and DR backup was
	// created.
	BackupCreateTime string `json:"backupCreateTime,omitempty"`

	// BackupTemplate: The name of a Backup and DR template which comprises
	// one or more backup policies. See the Backup and DR documentation
	// (https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
	// for more information. For example, `snap-ov`.
	BackupTemplate string `json:"backupTemplate,omitempty"`

	// BackupType: The backup type of the Backup and DR image. For example,
	// `Snapshot`, `Remote Snapshot`, `OnVault`.
	BackupType string `json:"backupType,omitempty"`

	// Host: The name of a Backup and DR host, which is managed by the
	// backup and recovery appliance and known to the management console.
	// The host can be of type Generic (for example, Compute Engine, SQL
	// Server, Oracle DB, SMB file system, etc.), vCenter, or an ESX server.
	// See the Backup and DR documentation on hosts
	// (https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
	// for more information. For example, `centos7-01`.
	Host string `json:"host,omitempty"`

	// Policies: The names of Backup and DR policies that are associated
	// with a template and that define when to run a backup, how frequently
	// to run a backup, and how long to retain the backup image. For
	// example, `onvaults`.
	Policies []string `json:"policies,omitempty"`

	// PolicyOptions: The names of Backup and DR advanced policy options of
	// a policy applying to an application. See the Backup and DR
	// documentation on policy options
	// (https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
	// For example, `skipofflineappsincongrp, nounmap`.
	PolicyOptions []string `json:"policyOptions,omitempty"`

	// Profile: The name of the Backup and DR resource profile that
	// specifies the storage media for backups of application and VM data.
	// See the Backup and DR documentation on profiles
	// (https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
	// For example, `GCP`.
	Profile string `json:"profile,omitempty"`

	// StoragePool: The name of the Backup and DR storage pool that the
	// backup and recovery appliance is storing data in. The storage pool
	// could be of type Cloud, Primary, Snapshot, or OnVault. See the Backup
	// and DR documentation on storage pools
	// (https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
	// For example, `DiskPoolOne`.
	StoragePool string `json:"storagePool,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Appliance") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Appliance") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackupDisasterRecovery) MarshalJSON() ([]byte, error) {
	type NoMethod BackupDisasterRecovery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchCreateResourceValueConfigsRequest: Request message to create
// multiple resource value configs
type BatchCreateResourceValueConfigsRequest struct {
	// Requests: Required. The resource value configs to be created.
	Requests []*CreateResourceValueConfigRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchCreateResourceValueConfigsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchCreateResourceValueConfigsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchCreateResourceValueConfigsResponse: Response message for
// BatchCreateResourceValueConfigs
type BatchCreateResourceValueConfigsResponse struct {
	// ResourceValueConfigs: The resource value configs created
	ResourceValueConfigs []*GoogleCloudSecuritycenterV1ResourceValueConfig `json:"resourceValueConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "ResourceValueConfigs") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceValueConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BatchCreateResourceValueConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchCreateResourceValueConfigsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the
	// current request. If the condition evaluates to `false`, then this
	// binding does not apply to the current request. However, a different
	// role binding might grant the same role to one or more of the
	// principals in this binding. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`

	// Members: Specifies the principals requesting access for a Google
	// Cloud resource. `members` can have the following values: *
	// `allUsers`: A special identifier that represents anyone who is on the
	// internet; with or without a Google account. *
	// `allAuthenticatedUsers`: A special identifier that represents anyone
	// who is authenticated with a Google account or a service account. Does
	// not include identities that come from external identity providers
	// (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address
	// that represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
	//  An identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`.
	// * `group:{emailid}`: An email address that represents a Google group.
	// For example, `admins@example.com`. * `domain:{domain}`: The G Suite
	// domain (primary) that represents all the users of that domain. For
	// example, `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_
	// id}/subject/{subject_attribute_value}`: A single identity in a
	// workforce identity pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{po
	// ol_id}/group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{po
	// ol_id}/attribute.{attribute_name}/{attribute_value}`: All workforce
	// identities with a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{po
	// ol_id}/*`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/gl
	// obal/workloadIdentityPools/{pool_id}/subject/{subject_attribute_value}
	// `: A single identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations
	// /global/workloadIdentityPools/{pool_id}/group/{group_id}`: A workload
	// identity pool group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations
	// /global/workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{at
	// tribute_value}`: All identities in a workload identity pool with a
	// certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations
	// /global/workloadIdentityPools/{pool_id}/*`: All identities in a
	// workload identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An
	// email address (plus unique identifier) representing a user that has
	// been recently deleted. For example,
	// `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered
	// user retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
	// (plus unique identifier) representing a service account that has been
	// recently deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`.
	// If the service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains
	// the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`:
	// An email address (plus unique identifier) representing a Google group
	// that has been recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is
	// recovered, this value reverts to `group:{emailid}` and the recovered
	// group retains the role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePool
	// s/{pool_id}/subject/{subject_attribute_value}`: Deleted single
	// identity in a workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePool
	// s/my-pool-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`

	// Role: Role that is assigned to the list of `members`, or principals.
	// For example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
	// overview of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BulkMuteFindingsRequest: Request message for bulk findings update.
// Note: 1. If multiple bulk update requests match the same resource,
// the order in which they get executed is not defined. 2. Once a bulk
// operation is started, there is no way to stop it.
type BulkMuteFindingsRequest struct {
	// Filter: Expression that identifies findings that should be updated.
	// The expression is a list of zero or more restrictions combined via
	// logical operators `AND` and `OR`. Parentheses are supported, and `OR`
	// has higher precedence than `AND`. Restrictions have the form ` ` and
	// may have a `-` character in front of them to indicate negation. The
	// fields map to those defined in the corresponding resource. The
	// supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
	// `<=` for integer values. * `:`, meaning substring matching, for
	// strings. The supported value types are: * string literals in quotes.
	// * integer literals without quotes. * boolean literals `true` and
	// `false` without quotes.
	Filter string `json:"filter,omitempty"`

	// MuteAnnotation: This can be a mute configuration name or any
	// identifier for mute/unmute of findings based on the filter.
	MuteAnnotation string `json:"muteAnnotation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BulkMuteFindingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BulkMuteFindingsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudDlpDataProfile: The data profile
// (https://cloud.google.com/dlp/docs/data-profiles) associated with the
// finding.
type CloudDlpDataProfile struct {
	// DataProfile: Name of the data profile, for example,
	// `projects/123/locations/europe/tableProfiles/8383929`.
	DataProfile string `json:"dataProfile,omitempty"`

	// ParentType: The resource hierarchy level at which the data profile
	// was generated.
	//
	// Possible values:
	//   "PARENT_TYPE_UNSPECIFIED" - Unspecified parent type.
	//   "ORGANIZATION" - Organization-level configurations.
	//   "PROJECT" - Project-level configurations.
	ParentType string `json:"parentType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataProfile") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataProfile") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudDlpDataProfile) MarshalJSON() ([]byte, error) {
	type NoMethod CloudDlpDataProfile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudDlpInspection: Details about the Cloud Data Loss Prevention
// (Cloud DLP) inspection job
// (https://cloud.google.com/dlp/docs/concepts-job-triggers) that
// produced the finding.
type CloudDlpInspection struct {
	// FullScan: Whether Cloud DLP scanned the complete resource or a
	// sampled subset.
	FullScan bool `json:"fullScan,omitempty"`

	// InfoType: The type of information (or *infoType
	// (https://cloud.google.com/dlp/docs/infotypes-reference)*) found, for
	// example, `EMAIL_ADDRESS` or `STREET_ADDRESS`.
	InfoType string `json:"infoType,omitempty"`

	// InfoTypeCount: The number of times Cloud DLP found this infoType
	// within this job and resource.
	InfoTypeCount int64 `json:"infoTypeCount,omitempty,string"`

	// InspectJob: Name of the inspection job, for example,
	// `projects/123/locations/europe/dlpJobs/i-8383929`.
	InspectJob string `json:"inspectJob,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FullScan") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FullScan") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudDlpInspection) MarshalJSON() ([]byte, error) {
	type NoMethod CloudDlpInspection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudLoggingEntry: Metadata taken from a Cloud Logging LogEntry
// (https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
type CloudLoggingEntry struct {
	// InsertId: A unique identifier for the log entry.
	InsertId string `json:"insertId,omitempty"`

	// LogId: The type of the log (part of `log_name`. `log_name` is the
	// resource name of the log to which this log entry belongs). For
	// example: `cloudresourcemanager.googleapis.com/activity`. Note that
	// this field is not URL-encoded, unlike the `LOG_ID` field in
	// `LogEntry`.
	LogId string `json:"logId,omitempty"`

	// ResourceContainer: The organization, folder, or project of the
	// monitored resource that produced this log entry.
	ResourceContainer string `json:"resourceContainer,omitempty"`

	// Timestamp: The time the event described by the log entry occurred.
	Timestamp string `json:"timestamp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InsertId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InsertId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudLoggingEntry) MarshalJSON() ([]byte, error) {
	type NoMethod CloudLoggingEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Compliance: Contains compliance information about a security standard
// indicating unmet recommendations.
type Compliance struct {
	// Ids: Policies within the standard or benchmark, for example, A.12.4.1
	Ids []string `json:"ids,omitempty"`

	// Standard: Industry-wide compliance standards or benchmarks, such as
	// CIS, PCI, and OWASP.
	Standard string `json:"standard,omitempty"`

	// Version: Version of the standard or benchmark, for example, 1.1
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Ids") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Ids") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Compliance) MarshalJSON() ([]byte, error) {
	type NoMethod Compliance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ComplianceSnapshot: Result containing the properties and count of a
// ComplianceSnapshot request.
type ComplianceSnapshot struct {
	// Category: The category of Findings matching.
	Category string `json:"category,omitempty"`

	// ComplianceStandard: The compliance standard (ie CIS).
	ComplianceStandard string `json:"complianceStandard,omitempty"`

	// ComplianceVersion: The compliance version (ie 1.3) in CIS 1.3.
	ComplianceVersion string `json:"complianceVersion,omitempty"`

	// Count: Total count of findings for the given properties.
	Count int64 `json:"count,omitempty,string"`

	// LeafContainerResource: The leaf container resource name that is
	// closest to the snapshot.
	LeafContainerResource string `json:"leafContainerResource,omitempty"`

	// Name: The compliance snapshot name. Format:
	// //sources//complianceSnapshots/
	Name string `json:"name,omitempty"`

	// ProjectDisplayName: The CRM resource display name that is closest to
	// the snapshot the Findings belong to.
	ProjectDisplayName string `json:"projectDisplayName,omitempty"`

	// SnapshotTime: The snapshot time of the snapshot.
	SnapshotTime string `json:"snapshotTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Category") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ComplianceSnapshot) MarshalJSON() ([]byte, error) {
	type NoMethod ComplianceSnapshot
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Connection: Contains information about the IP connection associated
// with the finding.
type Connection struct {
	// DestinationIp: Destination IP address. Not present for sockets that
	// are listening and not connected.
	DestinationIp string `json:"destinationIp,omitempty"`

	// DestinationPort: Destination port. Not present for sockets that are
	// listening and not connected.
	DestinationPort int64 `json:"destinationPort,omitempty"`

	// Protocol: IANA Internet Protocol Number such as TCP(6) and UDP(17).
	//
	// Possible values:
	//   "PROTOCOL_UNSPECIFIED" - Unspecified protocol (not HOPOPT).
	//   "ICMP" - Internet Control Message Protocol.
	//   "TCP" - Transmission Control Protocol.
	//   "UDP" - User Datagram Protocol.
	//   "GRE" - Generic Routing Encapsulation.
	//   "ESP" - Encap Security Payload.
	Protocol string `json:"protocol,omitempty"`

	// SourceIp: Source IP address.
	SourceIp string `json:"sourceIp,omitempty"`

	// SourcePort: Source port.
	SourcePort int64 `json:"sourcePort,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestinationIp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestinationIp") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Connection) MarshalJSON() ([]byte, error) {
	type NoMethod Connection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Contact: The email address of a contact.
type Contact struct {
	// Email: An email address. For example, "person123@company.com".
	Email string `json:"email,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Contact) MarshalJSON() ([]byte, error) {
	type NoMethod Contact
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ContactDetails: Details about specific contacts
type ContactDetails struct {
	// Contacts: A list of contacts
	Contacts []*Contact `json:"contacts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Contacts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contacts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ContactDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ContactDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Container: Container associated with the finding.
type Container struct {
	// CreateTime: The time that the container was created.
	CreateTime string `json:"createTime,omitempty"`

	// ImageId: Optional container image ID, if provided by the container
	// runtime. Uniquely identifies the container image launched using a
	// container image digest.
	ImageId string `json:"imageId,omitempty"`

	// Labels: Container labels, as provided by the container runtime.
	Labels []*Label `json:"labels,omitempty"`

	// Name: Name of the container.
	Name string `json:"name,omitempty"`

	// Uri: Container image URI provided when configuring a pod or
	// container. This string can identify a container image version using
	// mutable tags.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Container) MarshalJSON() ([]byte, error) {
	type NoMethod Container
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateResourceValueConfigRequest: Request message to create single
// resource value config
type CreateResourceValueConfigRequest struct {
	// Parent: Required. Resource name of the new ResourceValueConfig's
	// parent.
	Parent string `json:"parent,omitempty"`

	// ResourceValueConfig: Required. The resource value config being
	// created.
	ResourceValueConfig *GoogleCloudSecuritycenterV1ResourceValueConfig `json:"resourceValueConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateResourceValueConfigRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateResourceValueConfigRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomModuleValidationError: An error encountered while validating
// the uploaded configuration of an Event Threat Detection Custom
// Module.
type CustomModuleValidationError struct {
	// Description: A description of the error, suitable for human
	// consumption. Required.
	Description string `json:"description,omitempty"`

	// End: The end position of the error in the uploaded text version of
	// the module. This field may be omitted if no specific position
	// applies, or if one could not be computed..
	End *Position `json:"end,omitempty"`

	// FieldPath: The path, in RFC 8901 JSON Pointer format, to the field
	// that failed validation. This may be left empty if no specific field
	// is affected.
	FieldPath string `json:"fieldPath,omitempty"`

	// Start: The initial position of the error in the uploaded text version
	// of the module. This field may be omitted if no specific position
	// applies, or if one could not be computed.
	Start *Position `json:"start,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomModuleValidationError) MarshalJSON() ([]byte, error) {
	type NoMethod CustomModuleValidationError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomModuleValidationErrors: A list of zero or more errors
// encountered while validating the uploaded configuration of an Event
// Threat Detection Custom Module.
type CustomModuleValidationErrors struct {
	Errors []*CustomModuleValidationError `json:"errors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Errors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomModuleValidationErrors) MarshalJSON() ([]byte, error) {
	type NoMethod CustomModuleValidationErrors
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Cve: CVE stands for Common Vulnerabilities and Exposures. Information
// from the CVE record (https://www.cve.org/ResourcesSupport/Glossary)
// that describes this vulnerability.
type Cve struct {
	// Cvssv3: Describe Common Vulnerability Scoring System specified at
	// https://www.first.org/cvss/v3.1/specification-document
	Cvssv3 *Cvssv3 `json:"cvssv3,omitempty"`

	// ExploitationActivity: The exploitation activity of the vulnerability
	// in the wild.
	//
	// Possible values:
	//   "EXPLOITATION_ACTIVITY_UNSPECIFIED" - Invalid or empty value.
	//   "WIDE" - Exploitation has been reported or confirmed to widely
	// occur.
	//   "CONFIRMED" - Limited reported or confirmed exploitation
	// activities.
	//   "AVAILABLE" - Exploit is publicly available.
	//   "ANTICIPATED" - No known exploitation activity, but has a high
	// potential for exploitation.
	//   "NO_KNOWN" - No known exploitation activity.
	ExploitationActivity string `json:"exploitationActivity,omitempty"`

	// Id: The unique identifier for the vulnerability. e.g. CVE-2021-34527
	Id string `json:"id,omitempty"`

	// Impact: The potential impact of the vulnerability if it was to be
	// exploited.
	//
	// Possible values:
	//   "RISK_RATING_UNSPECIFIED" - Invalid or empty value.
	//   "LOW" - Exploitation would have little to no security impact.
	//   "MEDIUM" - Exploitation would enable attackers to perform
	// activities, or could allow attackers to have a direct impact, but
	// would require additional steps.
	//   "HIGH" - Exploitation would enable attackers to have a notable
	// direct impact without needing to overcome any major mitigating
	// factors.
	//   "CRITICAL" - Exploitation would fundamentally undermine the
	// security of affected systems, enable actors to perform significant
	// attacks with minimal effort, with little to no mitigating factors to
	// overcome.
	Impact string `json:"impact,omitempty"`

	// ObservedInTheWild: Whether or not the vulnerability has been observed
	// in the wild.
	ObservedInTheWild bool `json:"observedInTheWild,omitempty"`

	// References: Additional information about the CVE. e.g.
	// https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
	References []*Reference `json:"references,omitempty"`

	// UpstreamFixAvailable: Whether upstream fix is available for the CVE.
	UpstreamFixAvailable bool `json:"upstreamFixAvailable,omitempty"`

	// ZeroDay: Whether or not the vulnerability was zero day when the
	// finding was published.
	ZeroDay bool `json:"zeroDay,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cvssv3") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cvssv3") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Cve) MarshalJSON() ([]byte, error) {
	type NoMethod Cve
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Cvssv3: Common Vulnerability Scoring System version 3.
type Cvssv3 struct {
	// AttackComplexity: This metric describes the conditions beyond the
	// attacker's control that must exist in order to exploit the
	// vulnerability.
	//
	// Possible values:
	//   "ATTACK_COMPLEXITY_UNSPECIFIED" - Invalid value.
	//   "ATTACK_COMPLEXITY_LOW" - Specialized access conditions or
	// extenuating circumstances do not exist. An attacker can expect
	// repeatable success when attacking the vulnerable component.
	//   "ATTACK_COMPLEXITY_HIGH" - A successful attack depends on
	// conditions beyond the attacker's control. That is, a successful
	// attack cannot be accomplished at will, but requires the attacker to
	// invest in some measurable amount of effort in preparation or
	// execution against the vulnerable component before a successful attack
	// can be expected.
	AttackComplexity string `json:"attackComplexity,omitempty"`

	// AttackVector: Base Metrics Represents the intrinsic characteristics
	// of a vulnerability that are constant over time and across user
	// environments. This metric reflects the context by which vulnerability
	// exploitation is possible.
	//
	// Possible values:
	//   "ATTACK_VECTOR_UNSPECIFIED" - Invalid value.
	//   "ATTACK_VECTOR_NETWORK" - The vulnerable component is bound to the
	// network stack and the set of possible attackers extends beyond the
	// other options listed below, up to and including the entire Internet.
	//   "ATTACK_VECTOR_ADJACENT" - The vulnerable component is bound to the
	// network stack, but the attack is limited at the protocol level to a
	// logically adjacent topology.
	//   "ATTACK_VECTOR_LOCAL" - The vulnerable component is not bound to
	// the network stack and the attacker's path is via read/write/execute
	// capabilities.
	//   "ATTACK_VECTOR_PHYSICAL" - The attack requires the attacker to
	// physically touch or manipulate the vulnerable component.
	AttackVector string `json:"attackVector,omitempty"`

	// AvailabilityImpact: This metric measures the impact to the
	// availability of the impacted component resulting from a successfully
	// exploited vulnerability.
	//
	// Possible values:
	//   "IMPACT_UNSPECIFIED" - Invalid value.
	//   "IMPACT_HIGH" - High impact.
	//   "IMPACT_LOW" - Low impact.
	//   "IMPACT_NONE" - No impact.
	AvailabilityImpact string `json:"availabilityImpact,omitempty"`

	// BaseScore: The base score is a function of the base metric scores.
	BaseScore float64 `json:"baseScore,omitempty"`

	// ConfidentialityImpact: This metric measures the impact to the
	// confidentiality of the information resources managed by a software
	// component due to a successfully exploited vulnerability.
	//
	// Possible values:
	//   "IMPACT_UNSPECIFIED" - Invalid value.
	//   "IMPACT_HIGH" - High impact.
	//   "IMPACT_LOW" - Low impact.
	//   "IMPACT_NONE" - No impact.
	ConfidentialityImpact string `json:"confidentialityImpact,omitempty"`

	// IntegrityImpact: This metric measures the impact to integrity of a
	// successfully exploited vulnerability.
	//
	// Possible values:
	//   "IMPACT_UNSPECIFIED" - Invalid value.
	//   "IMPACT_HIGH" - High impact.
	//   "IMPACT_LOW" - Low impact.
	//   "IMPACT_NONE" - No impact.
	IntegrityImpact string `json:"integrityImpact,omitempty"`

	// PrivilegesRequired: This metric describes the level of privileges an
	// attacker must possess before successfully exploiting the
	// vulnerability.
	//
	// Possible values:
	//   "PRIVILEGES_REQUIRED_UNSPECIFIED" - Invalid value.
	//   "PRIVILEGES_REQUIRED_NONE" - The attacker is unauthorized prior to
	// attack, and therefore does not require any access to settings or
	// files of the vulnerable system to carry out an attack.
	//   "PRIVILEGES_REQUIRED_LOW" - The attacker requires privileges that
	// provide basic user capabilities that could normally affect only
	// settings and files owned by a user. Alternatively, an attacker with
	// Low privileges has the ability to access only non-sensitive
	// resources.
	//   "PRIVILEGES_REQUIRED_HIGH" - The attacker requires privileges that
	// provide significant (e.g., administrative) control over the
	// vulnerable component allowing access to component-wide settings and
	// files.
	PrivilegesRequired string `json:"privilegesRequired,omitempty"`

	// Scope: The Scope metric captures whether a vulnerability in one
	// vulnerable component impacts resources in components beyond its
	// security scope.
	//
	// Possible values:
	//   "SCOPE_UNSPECIFIED" - Invalid value.
	//   "SCOPE_UNCHANGED" - An exploited vulnerability can only affect
	// resources managed by the same security authority.
	//   "SCOPE_CHANGED" - An exploited vulnerability can affect resources
	// beyond the security scope managed by the security authority of the
	// vulnerable component.
	Scope string `json:"scope,omitempty"`

	// UserInteraction: This metric captures the requirement for a human
	// user, other than the attacker, to participate in the successful
	// compromise of the vulnerable component.
	//
	// Possible values:
	//   "USER_INTERACTION_UNSPECIFIED" - Invalid value.
	//   "USER_INTERACTION_NONE" - The vulnerable system can be exploited
	// without interaction from any user.
	//   "USER_INTERACTION_REQUIRED" - Successful exploitation of this
	// vulnerability requires a user to take some action before the
	// vulnerability can be exploited.
	UserInteraction string `json:"userInteraction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttackComplexity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttackComplexity") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Cvssv3) MarshalJSON() ([]byte, error) {
	type NoMethod Cvssv3
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Cvssv3) UnmarshalJSON(data []byte) error {
	type NoMethod Cvssv3
	var s1 struct {
		BaseScore gensupport.JSONFloat64 `json:"baseScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BaseScore = float64(s1.BaseScore)
	return nil
}

// Database: Represents database access information, such as queries. A
// database may be a sub-resource of an instance (as in the case of
// Cloud SQL instances or Cloud Spanner instances), or the database
// instance itself. Some database resources might not have the full
// resource name (https://google.aip.dev/122#full-resource-names)
// populated because these resource types, such as Cloud SQL databases,
// are not yet supported by Cloud Asset Inventory. In these cases only
// the display name is provided.
type Database struct {
	// DisplayName: The human-readable name of the database that the user
	// connected to.
	DisplayName string `json:"displayName,omitempty"`

	// Grantees: The target usernames, roles, or groups of an SQL privilege
	// grant, which is not an IAM policy change.
	Grantees []string `json:"grantees,omitempty"`

	// Name: Some database resources may not have the full resource name
	// (https://google.aip.dev/122#full-resource-names) populated because
	// these resource types are not yet supported by Cloud Asset Inventory
	// (e.g. Cloud SQL databases). In these cases only the display name will
	// be provided. The full resource name
	// (https://google.aip.dev/122#full-resource-names) of the database that
	// the user connected to, if it is supported by Cloud Asset Inventory.
	Name string `json:"name,omitempty"`

	// Query: The SQL statement that is associated with the database access.
	Query string `json:"query,omitempty"`

	// UserName: The username used to connect to the database. The username
	// might not be an IAM principal and does not have a set format.
	UserName string `json:"userName,omitempty"`

	// Version: The version of the database, for example, POSTGRES_14. See
	// the complete list
	// (https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/SqlDatabaseVersion).
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Database) MarshalJSON() ([]byte, error) {
	type NoMethod Database
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Detection: Memory hash detection contributing to the binary family
// match.
type Detection struct {
	// Binary: The name of the binary associated with the memory hash
	// signature detection.
	Binary string `json:"binary,omitempty"`

	// PercentPagesMatched: The percentage of memory page hashes in the
	// signature that were matched.
	PercentPagesMatched float64 `json:"percentPagesMatched,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Binary") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Binary") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Detection) MarshalJSON() ([]byte, error) {
	type NoMethod Detection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Detection) UnmarshalJSON(data []byte) error {
	type NoMethod Detection
	var s1 struct {
		PercentPagesMatched gensupport.JSONFloat64 `json:"percentPagesMatched"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.PercentPagesMatched = float64(s1.PercentPagesMatched)
	return nil
}

// DiskPath: Path of the file in terms of underlying disk/partition
// identifiers.
type DiskPath struct {
	// PartitionUuid: UUID of the partition (format
	// https://wiki.archlinux.org/title/persistent_block_device_naming#by-uuid)
	PartitionUuid string `json:"partitionUuid,omitempty"`

	// RelativePath: Relative path of the file in the partition as a JSON
	// encoded string. Example: /home/user1/executable_file.sh
	RelativePath string `json:"relativePath,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PartitionUuid") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PartitionUuid") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskPath) MarshalJSON() ([]byte, error) {
	type NoMethod DiskPath
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EffectiveEventThreatDetectionCustomModule: An
// EffectiveEventThreatDetectionCustomModule is the representation of an
// Event Threat Detection custom module at a specified level of the
// resource hierarchy: organization, folder, or project. If a custom
// module is inherited from a parent organization or folder, the value
// of the `enablement_state` property in
// EffectiveEventThreatDetectionCustomModule is set to the value that is
// effective in the parent, instead of `INHERITED`. For example, if the
// module is enabled in a parent organization or folder, the effective
// `enablement_state` for the module in all child folders or projects is
// also `enabled`. EffectiveEventThreatDetectionCustomModule is
// read-only.
type EffectiveEventThreatDetectionCustomModule struct {
	// Config: Output only. Config for the effective module.
	Config googleapi.RawMessage `json:"config,omitempty"`

	// Description: Output only. The description for the module.
	Description string `json:"description,omitempty"`

	// DisplayName: Output only. The human readable name to be displayed for
	// the module.
	DisplayName string `json:"displayName,omitempty"`

	// EnablementState: Output only. The effective state of enablement for
	// the module at the given level of the hierarchy.
	//
	// Possible values:
	//   "ENABLEMENT_STATE_UNSPECIFIED" - Unspecified enablement state.
	//   "ENABLED" - The module is enabled at the given level.
	//   "DISABLED" - The module is disabled at the given level.
	EnablementState string `json:"enablementState,omitempty"`

	// Name: Output only. The resource name of the effective ETD custom
	// module. Its format is: *
	// "organizations/{organization}/eventThreatDetectionSettings/effectiveCu
	// stomModules/{module}". *
	// "folders/{folder}/eventThreatDetectionSettings/effectiveCustomModules/
	// {module}". *
	// "projects/{project}/eventThreatDetectionSettings/effectiveCustomModule
	// s/{module}".
	Name string `json:"name,omitempty"`

	// Type: Output only. Type for the module. e.g. CONFIGURABLE_BAD_IP.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Config") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EffectiveEventThreatDetectionCustomModule) MarshalJSON() ([]byte, error) {
	type NoMethod EffectiveEventThreatDetectionCustomModule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// EnvironmentVariable: A name-value pair representing an environment
// variable used in an operating system process.
type EnvironmentVariable struct {
	// Name: Environment variable name as a JSON encoded string.
	Name string `json:"name,omitempty"`

	// Val: Environment variable value as a JSON encoded string.
	Val string `json:"val,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EnvironmentVariable) MarshalJSON() ([]byte, error) {
	type NoMethod EnvironmentVariable
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EventThreatDetectionCustomModule: Represents an instance of an Event
// Threat Detection custom module, including its full module name,
// display name, enablement state, and last updated time. You can create
// a custom module at the organization, folder, or project level. Custom
// modules that you create at the organization or folder level are
// inherited by child folders and projects.
type EventThreatDetectionCustomModule struct {
	// AncestorModule: Output only. The closest ancestor module that this
	// module inherits the enablement state from. The format is the same as
	// the EventThreatDetectionCustomModule resource name.
	AncestorModule string `json:"ancestorModule,omitempty"`

	// Config: Config for the module. For the resident module, its config
	// value is defined at this level. For the inherited module, its config
	// value is inherited from the ancestor module.
	Config googleapi.RawMessage `json:"config,omitempty"`

	// Description: The description for the module.
	Description string `json:"description,omitempty"`

	// DisplayName: The human readable name to be displayed for the module.
	DisplayName string `json:"displayName,omitempty"`

	// EnablementState: The state of enablement for the module at the given
	// level of the hierarchy.
	//
	// Possible values:
	//   "ENABLEMENT_STATE_UNSPECIFIED" - Unspecified enablement state.
	//   "ENABLED" - The module is enabled at the given level.
	//   "DISABLED" - The module is disabled at the given level.
	//   "INHERITED" - When the enablement state is inherited.
	EnablementState string `json:"enablementState,omitempty"`

	// LastEditor: Output only. The editor the module was last updated by.
	LastEditor string `json:"lastEditor,omitempty"`

	// Name: Immutable. The resource name of the Event Threat Detection
	// custom module. Its format is: *
	// "organizations/{organization}/eventThreatDetectionSettings/customModul
	// es/{module}". *
	// "folders/{folder}/eventThreatDetectionSettings/customModules/{module}"
	// . *
	// "projects/{project}/eventThreatDetectionSettings/customModules/{module
	// }".
	Name string `json:"name,omitempty"`

	// Type: Type for the module. e.g. CONFIGURABLE_BAD_IP.
	Type string `json:"type,omitempty"`

	// UpdateTime: Output only. The time the module was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AncestorModule") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AncestorModule") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EventThreatDetectionCustomModule) MarshalJSON() ([]byte, error) {
	type NoMethod EventThreatDetectionCustomModule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExfilResource: Resource where data was exfiltrated from or
// exfiltrated to.
type ExfilResource struct {
	// Components: Subcomponents of the asset that was exfiltrated, like
	// URIs used during exfiltration, table names, databases, and filenames.
	// For example, multiple tables might have been exfiltrated from the
	// same Cloud SQL instance, or multiple files might have been
	// exfiltrated from the same Cloud Storage bucket.
	Components []string `json:"components,omitempty"`

	// Name: The resource's full resource name
	// (https://cloud.google.com/apis/design/resource_names#full_resource_name).
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Components") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Components") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExfilResource) MarshalJSON() ([]byte, error) {
	type NoMethod ExfilResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Exfiltration: Exfiltration represents a data exfiltration attempt
// from one or more sources to one or more targets. The `sources`
// attribute lists the sources of the exfiltrated data. The `targets`
// attribute lists the destinations the data was copied to.
type Exfiltration struct {
	// Sources: If there are multiple sources, then the data is considered
	// "joined" between them. For instance, BigQuery can join multiple
	// tables, and each table would be considered a source.
	Sources []*ExfilResource `json:"sources,omitempty"`

	// Targets: If there are multiple targets, each target would get a
	// complete copy of the "joined" source data.
	Targets []*ExfilResource `json:"targets,omitempty"`

	// TotalExfiltratedBytes: Total exfiltrated bytes processed for the
	// entire job.
	TotalExfiltratedBytes int64 `json:"totalExfiltratedBytes,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Sources") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Sources") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Exfiltration) MarshalJSON() ([]byte, error) {
	type NoMethod Exfiltration
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression
// Language (CEL) syntax. CEL is a C-like expression language. The
// syntax and semantics of CEL are documented at
// https://github.com/google/cel-spec. Example (Comparison): title:
// "Summary size limit" description: "Determines if a summary is less
// than 100 chars" expression: "document.summary.size() < 100" Example
// (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly
// visible" expression: "document.type != 'private' && document.type !=
// 'internal'" Example (Data Manipulation): title: "Notification string"
// description: "Create a notification string with a timestamp."
// expression: "'New message received at ' +
// string(document.create_time)" The exact variables and functions that
// may be referenced within an expression are determined by the service
// that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a
	// longer text which describes the expression, e.g. when hovered over it
	// in a UI.
	Description string `json:"description,omitempty"`

	// Expression: Textual representation of an expression in Common
	// Expression Language syntax.
	Expression string `json:"expression,omitempty"`

	// Location: Optional. String indicating the location of the expression
	// for error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`

	// Title: Optional. Title for the expression, i.e. a short string
	// describing its purpose. This can be used e.g. in UIs which allow to
	// enter the expression.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// File: File information about the related binary/library used by an
// executable, or the script used by a script interpreter
type File struct {
	// Contents: Prefix of the file contents as a JSON-encoded string.
	Contents string `json:"contents,omitempty"`

	// DiskPath: Path of the file in terms of underlying disk/partition
	// identifiers.
	DiskPath *DiskPath `json:"diskPath,omitempty"`

	// HashedSize: The length in bytes of the file prefix that was hashed.
	// If hashed_size == size, any hashes reported represent the entire
	// file.
	HashedSize int64 `json:"hashedSize,omitempty,string"`

	// PartiallyHashed: True when the hash covers only a prefix of the file.
	PartiallyHashed bool `json:"partiallyHashed,omitempty"`

	// Path: Absolute path of the file as a JSON encoded string.
	Path string `json:"path,omitempty"`

	// Sha256: SHA256 hash of the first hashed_size bytes of the file
	// encoded as a hex string. If hashed_size == size, sha256 represents
	// the SHA256 hash of the entire file.
	Sha256 string `json:"sha256,omitempty"`

	// Size: Size of the file in bytes.
	Size int64 `json:"size,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *File) MarshalJSON() ([]byte, error) {
	type NoMethod File
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Finding: Security Command Center finding. A finding is a record of
// assessment data like security, risk, health, or privacy, that is
// ingested into Security Command Center for presentation, notification,
// analysis, policy testing, and enforcement. For example, a cross-site
// scripting (XSS) vulnerability in an App Engine application is a
// finding.
type Finding struct {
	// Access: Access details associated with the finding, such as more
	// information on the caller, which method was accessed, and from where.
	Access *Access `json:"access,omitempty"`

	// Application: Represents an application associated with the finding.
	Application *Application `json:"application,omitempty"`

	// AttackExposure: The results of an attack path simulation relevant to
	// this finding.
	AttackExposure *AttackExposure `json:"attackExposure,omitempty"`

	// BackupDisasterRecovery: Fields related to Backup and DR findings.
	BackupDisasterRecovery *BackupDisasterRecovery `json:"backupDisasterRecovery,omitempty"`

	// CanonicalName: The canonical name of the finding. It's either
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}",
	// "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
	// "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
	//  depending on the closest CRM ancestor of the resource associated
	// with the finding.
	CanonicalName string `json:"canonicalName,omitempty"`

	// Category: The additional taxonomy group within findings from a given
	// source. This field is immutable after creation time. Example:
	// "XSS_FLASH_INJECTION"
	Category string `json:"category,omitempty"`

	// CloudDlpDataProfile: Cloud DLP data profile that is associated with
	// the finding.
	CloudDlpDataProfile *CloudDlpDataProfile `json:"cloudDlpDataProfile,omitempty"`

	// CloudDlpInspection: Cloud Data Loss Prevention (Cloud DLP) inspection
	// results that are associated with the finding.
	CloudDlpInspection *CloudDlpInspection `json:"cloudDlpInspection,omitempty"`

	// Compliances: Contains compliance information for security standards
	// associated to the finding.
	Compliances []*Compliance `json:"compliances,omitempty"`

	// Connections: Contains information about the IP connection associated
	// with the finding.
	Connections []*Connection `json:"connections,omitempty"`

	// Contacts: Output only. Map containing the points of contact for the
	// given finding. The key represents the type of contact, while the
	// value contains a list of all the contacts that pertain. Please refer
	// to:
	// https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
	// { "security": { "contacts": [ { "email": "person1@company.com" }, {
	// "email": "person2@company.com" } ] } }
	Contacts map[string]ContactDetails `json:"contacts,omitempty"`

	// Containers: Containers associated with the finding. This field
	// provides information for both Kubernetes and non-Kubernetes
	// containers.
	Containers []*Container `json:"containers,omitempty"`

	// CreateTime: The time at which the finding was created in Security
	// Command Center.
	CreateTime string `json:"createTime,omitempty"`

	// Database: Database associated with the finding.
	Database *Database `json:"database,omitempty"`

	// Description: Contains more details about the finding.
	Description string `json:"description,omitempty"`

	// EventTime: The time the finding was first detected. If an existing
	// finding is updated, then this is the time the update occurred. For
	// example, if the finding represents an open firewall, this property
	// captures the time the detector believes the firewall became open. The
	// accuracy is determined by the detector. If the finding is later
	// resolved, then this time reflects when the finding was resolved. This
	// must not be set to a value greater than the current timestamp.
	EventTime string `json:"eventTime,omitempty"`

	// Exfiltration: Represents exfiltrations associated with the finding.
	Exfiltration *Exfiltration `json:"exfiltration,omitempty"`

	// ExternalSystems: Output only. Third party SIEM/SOAR fields within
	// SCC, contains external system information and external system finding
	// fields.
	ExternalSystems map[string]GoogleCloudSecuritycenterV1ExternalSystem `json:"externalSystems,omitempty"`

	// ExternalUri: The URI that, if available, points to a web page outside
	// of Security Command Center where additional information about the
	// finding can be found. This field is guaranteed to be either empty or
	// a well formed URL.
	ExternalUri string `json:"externalUri,omitempty"`

	// Files: File associated with the finding.
	Files []*File `json:"files,omitempty"`

	// FindingClass: The class of the finding.
	//
	// Possible values:
	//   "FINDING_CLASS_UNSPECIFIED" - Unspecified finding class.
	//   "THREAT" - Describes unwanted or malicious activity.
	//   "VULNERABILITY" - Describes a potential weakness in software that
	// increases risk to Confidentiality & Integrity & Availability.
	//   "MISCONFIGURATION" - Describes a potential weakness in cloud
	// resource/asset configuration that increases risk.
	//   "OBSERVATION" - Describes a security observation that is for
	// informational purposes.
	//   "SCC_ERROR" - Describes an error that prevents some SCC
	// functionality.
	//   "POSTURE_VIOLATION" - Describes a potential security risk due to a
	// change in the security posture.
	FindingClass string `json:"findingClass,omitempty"`

	// IamBindings: Represents IAM bindings associated with the finding.
	IamBindings []*IamBinding `json:"iamBindings,omitempty"`

	// Indicator: Represents what's commonly known as an *indicator of
	// compromise* (IoC) in computer forensics. This is an artifact observed
	// on a network or in an operating system that, with high confidence,
	// indicates a computer intrusion. For more information, see Indicator
	// of compromise
	// (https://en.wikipedia.org/wiki/Indicator_of_compromise).
	Indicator *Indicator `json:"indicator,omitempty"`

	// KernelRootkit: Signature of the kernel rootkit.
	KernelRootkit *KernelRootkit `json:"kernelRootkit,omitempty"`

	// Kubernetes: Kubernetes resources associated with the finding.
	Kubernetes *Kubernetes `json:"kubernetes,omitempty"`

	// LoadBalancers: The load balancers associated with the finding.
	LoadBalancers []*LoadBalancer `json:"loadBalancers,omitempty"`

	// LogEntries: Log entries that are relevant to the finding.
	LogEntries []*LogEntry `json:"logEntries,omitempty"`

	// MitreAttack: MITRE ATT&CK tactics and techniques related to this
	// finding. See: https://attack.mitre.org
	MitreAttack *MitreAttack `json:"mitreAttack,omitempty"`

	// ModuleName: Unique identifier of the module which generated the
	// finding. Example:
	// folders/598186756061/securityHealthAnalyticsSettings/customModules/567
	// 99441161885
	ModuleName string `json:"moduleName,omitempty"`

	// Mute: Indicates the mute state of a finding (either muted, unmuted or
	// undefined). Unlike other attributes of a finding, a finding provider
	// shouldn't set the value of mute.
	//
	// Possible values:
	//   "MUTE_UNSPECIFIED" - Unspecified.
	//   "MUTED" - Finding has been muted.
	//   "UNMUTED" - Finding has been unmuted.
	//   "UNDEFINED" - Finding has never been muted/unmuted.
	Mute string `json:"mute,omitempty"`

	// MuteInitiator: Records additional information about the mute
	// operation, for example, the mute configuration
	// (/security-command-center/docs/how-to-mute-findings) that muted the
	// finding and the user who muted the finding.
	MuteInitiator string `json:"muteInitiator,omitempty"`

	// MuteUpdateTime: Output only. The most recent time this finding was
	// muted or unmuted.
	MuteUpdateTime string `json:"muteUpdateTime,omitempty"`

	// Name: The relative resource name
	// (https://cloud.google.com/apis/design/resource_names#relative_resource_name)
	// of the finding. Example:
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}",
	// "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
	// "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
	Name string `json:"name,omitempty"`

	// NextSteps: Steps to address the finding.
	NextSteps string `json:"nextSteps,omitempty"`

	// OrgPolicies: Contains information about the org policies associated
	// with the finding.
	OrgPolicies []*OrgPolicy `json:"orgPolicies,omitempty"`

	// Parent: The relative resource name of the source the finding belongs
	// to. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// This field is immutable after creation time. For example:
	// "organizations/{organization_id}/sources/{source_id}"
	Parent string `json:"parent,omitempty"`

	// ParentDisplayName: Output only. The human readable display name of
	// the finding source such as "Event Threat Detection" or "Security
	// Health Analytics".
	ParentDisplayName string `json:"parentDisplayName,omitempty"`

	// Processes: Represents operating system processes associated with the
	// Finding.
	Processes []*Process `json:"processes,omitempty"`

	// ResourceName: For findings on Google Cloud resources, the full
	// resource name of the Google Cloud resource this finding is for. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	// When the finding is for a non-Google Cloud resource, the resourceName
	// can be a customer or partner defined string. This field is immutable
	// after creation time.
	ResourceName string `json:"resourceName,omitempty"`

	// SecurityMarks: Output only. User specified security marks. These
	// marks are entirely managed by the user and come from the
	// SecurityMarks resource that belongs to the finding.
	SecurityMarks *SecurityMarks `json:"securityMarks,omitempty"`

	// SecurityPosture: The security posture associated with the finding.
	SecurityPosture *SecurityPosture `json:"securityPosture,omitempty"`

	// Severity: The severity of the finding. This field is managed by the
	// source that writes the finding.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - This value is used for findings when a
	// source doesn't write a severity value.
	//   "CRITICAL" - Vulnerability: A critical vulnerability is easily
	// discoverable by an external actor, exploitable, and results in the
	// direct ability to execute arbitrary code, exfiltrate data, and
	// otherwise gain additional access and privileges to cloud resources
	// and workloads. Examples include publicly accessible unprotected user
	// data and public SSH access with weak or no passwords. Threat:
	// Indicates a threat that is able to access, modify, or delete data or
	// execute unauthorized code within existing resources.
	//   "HIGH" - Vulnerability: A high risk vulnerability can be easily
	// discovered and exploited in combination with other vulnerabilities in
	// order to gain direct access and the ability to execute arbitrary
	// code, exfiltrate data, and otherwise gain additional access and
	// privileges to cloud resources and workloads. An example is a database
	// with weak or no passwords that is only accessible internally. This
	// database could easily be compromised by an actor that had access to
	// the internal network. Threat: Indicates a threat that is able to
	// create new computational resources in an environment but not able to
	// access data or execute code in existing resources.
	//   "MEDIUM" - Vulnerability: A medium risk vulnerability could be used
	// by an actor to gain access to resources or privileges that enable
	// them to eventually (through multiple steps or a complex exploit) gain
	// access and the ability to execute arbitrary code or exfiltrate data.
	// An example is a service account with access to more projects than it
	// should have. If an actor gains access to the service account, they
	// could potentially use that access to manipulate a project the service
	// account was not intended to. Threat: Indicates a threat that is able
	// to cause operational impact but may not access data or execute
	// unauthorized code.
	//   "LOW" - Vulnerability: A low risk vulnerability hampers a security
	// organization's ability to detect vulnerabilities or active threats in
	// their deployment, or prevents the root cause investigation of
	// security issues. An example is monitoring and logs being disabled for
	// resource configurations and access. Threat: Indicates a threat that
	// has obtained minimal access to an environment but is not able to
	// access data, execute code, or create resources.
	Severity string `json:"severity,omitempty"`

	// SourceProperties: Source specific properties. These properties are
	// managed by the source that writes the finding. The key names in the
	// source_properties map must be between 1 and 255 characters, and must
	// start with a letter and contain alphanumeric characters or
	// underscores only.
	SourceProperties googleapi.RawMessage `json:"sourceProperties,omitempty"`

	// State: The state of the finding.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - The finding requires attention and has not been
	// addressed yet.
	//   "INACTIVE" - The finding has been fixed, triaged as a non-issue or
	// otherwise addressed and is no longer active.
	State string `json:"state,omitempty"`

	// Vulnerability: Represents vulnerability-specific fields like CVE and
	// CVSS scores. CVE stands for Common Vulnerabilities and Exposures
	// (https://cve.mitre.org/about/)
	Vulnerability *Vulnerability `json:"vulnerability,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Access") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Finding) MarshalJSON() ([]byte, error) {
	type NoMethod Finding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Folder: Message that contains the resource name and display name of a
// folder resource.
type Folder struct {
	// ResourceFolder: Full resource name of this folder. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceFolder string `json:"resourceFolder,omitempty"`

	// ResourceFolderDisplayName: The user defined display name for this
	// folder.
	ResourceFolderDisplayName string `json:"resourceFolderDisplayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceFolder") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceFolder") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Folder) MarshalJSON() ([]byte, error) {
	type NoMethod Folder
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Geolocation: Represents a geographical location for a given access.
type Geolocation struct {
	// RegionCode: A CLDR.
	RegionCode string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RegionCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RegionCode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Geolocation) MarshalJSON() ([]byte, error) {
	type NoMethod Geolocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GetIamPolicyRequest: Request message for `GetIamPolicy` method.
type GetIamPolicyRequest struct {
	// Options: OPTIONAL: A `GetPolicyOptions` object for specifying options
	// to `GetIamPolicy`.
	Options *GetPolicyOptions `json:"options,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Options") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Options") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GetIamPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GetPolicyOptions: Encapsulates settings provided to GetIamPolicy.
type GetPolicyOptions struct {
	// RequestedPolicyVersion: Optional. The maximum policy version that
	// will be used to format the policy. Valid values are 0, 1, and 3.
	// Requests specifying an invalid value will be rejected. Requests for
	// policies with any conditional role bindings must specify version 3.
	// Policies with no conditional role bindings may specify any valid
	// value or leave the field unset. The policy in the response might use
	// the policy version that you specified, or it might use a lower policy
	// version. For example, if you specify version 3, but the policy has no
	// conditional role bindings, the response uses version 1. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	RequestedPolicyVersion int64 `json:"requestedPolicyVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "RequestedPolicyVersion") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequestedPolicyVersion")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GetPolicyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GetPolicyOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1BigQueryExport: Configures how to deliver
// Findings to BigQuery Instance.
type GoogleCloudSecuritycenterV1BigQueryExport struct {
	// CreateTime: Output only. The time at which the BigQuery export was
	// created. This field is set by the server and will be ignored if
	// provided on export on creation.
	CreateTime string `json:"createTime,omitempty"`

	// Dataset: The dataset to write findings' updates to. Its format is
	// "projects/[project_id]/datasets/[bigquery_dataset_id]". BigQuery
	// Dataset unique ID must contain only letters (a-z, A-Z), numbers
	// (0-9), or underscores (_).
	Dataset string `json:"dataset,omitempty"`

	// Description: The description of the export (max of 1024 characters).
	Description string `json:"description,omitempty"`

	// Filter: Expression that defines the filter to apply across
	// create/update events of findings. The expression is a list of zero or
	// more restrictions combined via logical operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	// Restrictions have the form ` ` and may have a `-` character in front
	// of them to indicate negation. The fields map to those defined in the
	// corresponding resource. The supported operators are: * `=` for all
	// value types. * `>`, `<`, `>=`, `<=` for integer values. * `:`,
	// meaning substring matching, for strings. The supported value types
	// are: * string literals in quotes. * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	Filter string `json:"filter,omitempty"`

	// MostRecentEditor: Output only. Email address of the user who last
	// edited the BigQuery export. This field is set by the server and will
	// be ignored if provided on export creation or update.
	MostRecentEditor string `json:"mostRecentEditor,omitempty"`

	// Name: The relative resource name of this export. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name.
	// Example format:
	// "organizations/{organization_id}/bigQueryExports/{export_id}" Example
	// format: "folders/{folder_id}/bigQueryExports/{export_id}" Example
	// format: "projects/{project_id}/bigQueryExports/{export_id}" This
	// field is provided in responses, and is ignored when provided in
	// create requests.
	Name string `json:"name,omitempty"`

	// Principal: Output only. The service account that needs permission to
	// create table and upload data to the BigQuery dataset.
	Principal string `json:"principal,omitempty"`

	// UpdateTime: Output only. The most recent time at which the BigQuery
	// export was updated. This field is set by the server and will be
	// ignored if provided on export creation or update.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1BigQueryExport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1BigQueryExport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1Binding: Represents a Kubernetes
// RoleBinding or ClusterRoleBinding.
type GoogleCloudSecuritycenterV1Binding struct {
	// Name: Name for the binding.
	Name string `json:"name,omitempty"`

	// Ns: Namespace for the binding.
	Ns string `json:"ns,omitempty"`

	// Role: The Role or ClusterRole referenced by the binding.
	Role *Role `json:"role,omitempty"`

	// Subjects: Represents one or more subjects that are bound to the role.
	// Not always available for PATCH requests.
	Subjects []*Subject `json:"subjects,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1BulkMuteFindingsResponse: The response to
// a BulkMute request. Contains the LRO information.
type GoogleCloudSecuritycenterV1BulkMuteFindingsResponse struct {
}

// GoogleCloudSecuritycenterV1CustomConfig: Defines the properties in a
// custom module configuration for Security Health Analytics. Use the
// custom module configuration to create custom detectors that generate
// custom findings for resources that you specify.
type GoogleCloudSecuritycenterV1CustomConfig struct {
	// CustomOutput: Custom output properties.
	CustomOutput *GoogleCloudSecuritycenterV1CustomOutputSpec `json:"customOutput,omitempty"`

	// Description: Text that describes the vulnerability or
	// misconfiguration that the custom module detects. This explanation is
	// returned with each finding instance to help investigators understand
	// the detected issue. The text must be enclosed in quotation marks.
	Description string `json:"description,omitempty"`

	// Predicate: The CEL expression to evaluate to produce findings. When
	// the expression evaluates to true against a resource, a finding is
	// generated.
	Predicate *Expr `json:"predicate,omitempty"`

	// Recommendation: An explanation of the recommended steps that security
	// teams can take to resolve the detected issue. This explanation is
	// returned with each finding generated by this module in the
	// `nextSteps` property of the finding JSON.
	Recommendation string `json:"recommendation,omitempty"`

	// ResourceSelector: The resource types that the custom module operates
	// on. Each custom module can specify up to 5 resource types.
	ResourceSelector *GoogleCloudSecuritycenterV1ResourceSelector `json:"resourceSelector,omitempty"`

	// Severity: The severity to assign to findings generated by the module.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Unspecified severity.
	//   "CRITICAL" - Critical severity.
	//   "HIGH" - High severity.
	//   "MEDIUM" - Medium severity.
	//   "LOW" - Low severity.
	Severity string `json:"severity,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomOutput") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomOutput") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1CustomConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1CustomConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1CustomOutputSpec: A set of optional
// name-value pairs that define custom source properties to return with
// each finding that is generated by the custom module. The custom
// source properties that are defined here are included in the finding
// JSON under `sourceProperties`.
type GoogleCloudSecuritycenterV1CustomOutputSpec struct {
	// Properties: A list of custom output properties to add to the finding.
	Properties []*GoogleCloudSecuritycenterV1Property `json:"properties,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Properties") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Properties") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1CustomOutputSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1CustomOutputSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1EffectiveSecurityHealthAnalyticsCustomModul
// e: An EffectiveSecurityHealthAnalyticsCustomModule is the
// representation of a Security Health Analytics custom module at a
// specified level of the resource hierarchy: organization, folder, or
// project. If a custom module is inherited from a parent organization
// or folder, the value of the `enablementState` property in
// EffectiveSecurityHealthAnalyticsCustomModule is set to the value that
// is effective in the parent, instead of `INHERITED`. For example, if
// the module is enabled in a parent organization or folder, the
// effective enablement_state for the module in all child folders or
// projects is also `enabled`.
// EffectiveSecurityHealthAnalyticsCustomModule is read-only.
type GoogleCloudSecuritycenterV1EffectiveSecurityHealthAnalyticsCustomModule struct {
	// CustomConfig: Output only. The user-specified configuration for the
	// module.
	CustomConfig *GoogleCloudSecuritycenterV1CustomConfig `json:"customConfig,omitempty"`

	// DisplayName: Output only. The display name for the custom module. The
	// name must be between 1 and 128 characters, start with a lowercase
	// letter, and contain alphanumeric characters or underscores only.
	DisplayName string `json:"displayName,omitempty"`

	// EnablementState: Output only. The effective state of enablement for
	// the module at the given level of the hierarchy.
	//
	// Possible values:
	//   "ENABLEMENT_STATE_UNSPECIFIED" - Unspecified enablement state.
	//   "ENABLED" - The module is enabled at the given level.
	//   "DISABLED" - The module is disabled at the given level.
	EnablementState string `json:"enablementState,omitempty"`

	// Name: Output only. The resource name of the custom module. Its format
	// is
	// "organizations/{organization}/securityHealthAnalyticsSettings/effectiv
	// eCustomModules/{customModule}", or
	// "folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModul
	// es/{customModule}", or
	// "projects/{project}/securityHealthAnalyticsSettings/effectiveCustomMod
	// ules/{customModule}"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CustomConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1EffectiveSecurityHealthAnalyticsCustomModule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1EffectiveSecurityHealthAnalyticsCustomModule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1ExternalSystem: Representation of third
// party SIEM/SOAR fields within SCC.
type GoogleCloudSecuritycenterV1ExternalSystem struct {
	// Assignees: References primary/secondary etc assignees in the external
	// system.
	Assignees []string `json:"assignees,omitempty"`

	// CaseCloseTime: The time when the case was closed, as reported by the
	// external system.
	CaseCloseTime string `json:"caseCloseTime,omitempty"`

	// CaseCreateTime: The time when the case was created, as reported by
	// the external system.
	CaseCreateTime string `json:"caseCreateTime,omitempty"`

	// CasePriority: The priority of the finding's corresponding case in the
	// external system.
	CasePriority string `json:"casePriority,omitempty"`

	// CaseSla: The SLA of the finding's corresponding case in the external
	// system.
	CaseSla string `json:"caseSla,omitempty"`

	// CaseUri: The link to the finding's corresponding case in the external
	// system.
	CaseUri string `json:"caseUri,omitempty"`

	// ExternalSystemUpdateTime: The time when the case was last updated, as
	// reported by the external system.
	ExternalSystemUpdateTime string `json:"externalSystemUpdateTime,omitempty"`

	// ExternalUid: The identifier that's used to track the finding's
	// corresponding case in the external system.
	ExternalUid string `json:"externalUid,omitempty"`

	// Name: Full resource name of the external system, for example:
	// "organizations/1234/sources/5678/findings/123456/externalSystems/jira"
	// , "folders/1234/sources/5678/findings/123456/externalSystems/jira",
	// "projects/1234/sources/5678/findings/123456/externalSystems/jira"
	Name string `json:"name,omitempty"`

	// Status: The most recent status of the finding's corresponding case,
	// as reported by the external system.
	Status string `json:"status,omitempty"`

	// TicketInfo: Information about the ticket, if any, that is being used
	// to track the resolution of the issue that is identified by this
	// finding.
	TicketInfo *TicketInfo `json:"ticketInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Assignees") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Assignees") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1ExternalSystem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1ExternalSystem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1MuteConfig: A mute config is a Cloud SCC
// resource that contains the configuration to mute create/update events
// of findings.
type GoogleCloudSecuritycenterV1MuteConfig struct {
	// CreateTime: Output only. The time at which the mute config was
	// created. This field is set by the server and will be ignored if
	// provided on config creation.
	CreateTime string `json:"createTime,omitempty"`

	// Description: A description of the mute config.
	Description string `json:"description,omitempty"`

	// DisplayName: The human readable name to be displayed for the mute
	// config.
	DisplayName string `json:"displayName,omitempty"`

	// Filter: Required. An expression that defines the filter to apply
	// across create/update events of findings. While creating a filter
	// string, be mindful of the scope in which the mute configuration is
	// being created. E.g., If a filter contains project = X but is created
	// under the project = Y scope, it might not match any findings. The
	// following field and operator combinations are supported: * severity:
	// `=`, `:` * category: `=`, `:` * resource.name: `=`, `:` *
	// resource.project_name: `=`, `:` * resource.project_display_name: `=`,
	// `:` * resource.folders.resource_folder: `=`, `:` *
	// resource.parent_name: `=`, `:` * resource.parent_display_name: `=`,
	// `:` * resource.type: `=`, `:` * finding_class: `=`, `:` *
	// indicator.ip_addresses: `=`, `:` * indicator.domains: `=`, `:`
	Filter string `json:"filter,omitempty"`

	// MostRecentEditor: Output only. Email address of the user who last
	// edited the mute config. This field is set by the server and will be
	// ignored if provided on config creation or update.
	MostRecentEditor string `json:"mostRecentEditor,omitempty"`

	// Name: This field will be ignored if provided on config creation.
	// Format "organizations/{organization}/muteConfigs/{mute_config}"
	// "folders/{folder}/muteConfigs/{mute_config}"
	// "projects/{project}/muteConfigs/{mute_config}"
	// "organizations/{organization}/locations/global/muteConfigs/{mute_confi
	// g}" "folders/{folder}/locations/global/muteConfigs/{mute_config}"
	// "projects/{project}/locations/global/muteConfigs/{mute_config}"
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. The most recent time at which the mute
	// config was updated. This field is set by the server and will be
	// ignored if provided on config creation or update.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1MuteConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1MuteConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1NotificationMessage: Cloud SCC's
// Notification
type GoogleCloudSecuritycenterV1NotificationMessage struct {
	// Finding: If it's a Finding based notification config, this field will
	// be populated.
	Finding *Finding `json:"finding,omitempty"`

	// NotificationConfigName: Name of the notification config that
	// generated current notification.
	NotificationConfigName string `json:"notificationConfigName,omitempty"`

	// Resource: The Cloud resource tied to this notification's Finding.
	Resource *GoogleCloudSecuritycenterV1Resource `json:"resource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Finding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Finding") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1NotificationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1NotificationMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1Property: An individual name-value pair
// that defines a custom source property.
type GoogleCloudSecuritycenterV1Property struct {
	// Name: Name of the property for the custom output.
	Name string `json:"name,omitempty"`

	// ValueExpression: The CEL expression for the custom output. A resource
	// property can be specified to return the value of the property or a
	// text string enclosed in quotation marks.
	ValueExpression *Expr `json:"valueExpression,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1Property) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1Property
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1Resource: Information related to the
// Google Cloud resource.
type GoogleCloudSecuritycenterV1Resource struct {
	// DisplayName: The human readable name of the resource.
	DisplayName string `json:"displayName,omitempty"`

	// Folders: Output only. Contains a Folder message for each folder in
	// the assets ancestry. The first folder is the deepest nested folder,
	// and the last folder is the folder directly under the Organization.
	Folders []*Folder `json:"folders,omitempty"`

	// Name: The full resource name of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	Name string `json:"name,omitempty"`

	// Parent: The full resource name of resource's parent.
	Parent string `json:"parent,omitempty"`

	// ParentDisplayName: The human readable name of resource's parent.
	ParentDisplayName string `json:"parentDisplayName,omitempty"`

	// Project: The full resource name of project that the resource belongs
	// to.
	Project string `json:"project,omitempty"`

	// ProjectDisplayName: The project ID that the resource belongs to.
	ProjectDisplayName string `json:"projectDisplayName,omitempty"`

	// Type: The full resource type of the resource.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1Resource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1Resource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1ResourceSelector: Resource for selecting
// resource type.
type GoogleCloudSecuritycenterV1ResourceSelector struct {
	// ResourceTypes: The resource types to run the detector on.
	ResourceTypes []string `json:"resourceTypes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceTypes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1ResourceSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1ResourceSelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1ResourceValueConfig: A resource value
// config (RVC) is a mapping configuration of user's resources to
// resource values. Used in Attack path simulations.
type GoogleCloudSecuritycenterV1ResourceValueConfig struct {
	// CreateTime: Output only. Timestamp this resource value config was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Description of the resource value config.
	Description string `json:"description,omitempty"`

	// Name: Name for the resource value config
	Name string `json:"name,omitempty"`

	// ResourceLabelsSelector: List of resource labels to search for,
	// evaluated with AND. E.g. "resource_labels_selector": {"key": "value",
	// "env": "prod"} will match resources with labels "key": "value" AND
	// "env": "prod"
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels
	ResourceLabelsSelector map[string]string `json:"resourceLabelsSelector,omitempty"`

	// ResourceType: Apply resource_value only to resources that match
	// resource_type. resource_type will be checked with "AND" of other
	// resources. E.g. "storage.googleapis.com/Bucket" with resource_value
	// "HIGH" will apply "HIGH" value only to
	// "storage.googleapis.com/Bucket" resources.
	ResourceType string `json:"resourceType,omitempty"`

	// ResourceValue: Required. Resource value level this expression
	// represents
	//
	// Possible values:
	//   "RESOURCE_VALUE_UNSPECIFIED" - Unspecific value
	//   "HIGH" - High resource value
	//   "MEDIUM" - Medium resource value
	//   "LOW" - Low resource value
	//   "NONE" - No resource value, e.g. ignore these resources
	ResourceValue string `json:"resourceValue,omitempty"`

	// Scope: Project or folder to scope this config to. For example,
	// "project/456" would apply this config only to resources in
	// "project/456" scope will be checked with "AND" of other resources.
	Scope string `json:"scope,omitempty"`

	// SensitiveDataProtectionMapping: A mapping of the sensitivity on
	// Sensitive Data Protection finding to resource values. This mapping
	// can only be used in combination with a resource_type that is related
	// to BigQuery, e.g. "bigquery.googleapis.com/Dataset".
	SensitiveDataProtectionMapping *GoogleCloudSecuritycenterV1SensitiveDataProtectionMapping `json:"sensitiveDataProtectionMapping,omitempty"`

	// TagValues: Required. Tag values combined with AND to check against.
	// Values in the form "tagValues/123" E.g. [ "tagValues/123",
	// "tagValues/456", "tagValues/789" ]
	// https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing
	TagValues []string `json:"tagValues,omitempty"`

	// UpdateTime: Output only. Timestamp this resource value config was
	// last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1ResourceValueConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1ResourceValueConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1RunAssetDiscoveryResponse: Response of
// asset discovery run
type GoogleCloudSecuritycenterV1RunAssetDiscoveryResponse struct {
	// Duration: The duration between asset discovery run start and end
	Duration string `json:"duration,omitempty"`

	// State: The state of an asset discovery run.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Asset discovery run state was unspecified.
	//   "COMPLETED" - Asset discovery run completed successfully.
	//   "SUPERSEDED" - Asset discovery run was cancelled with tasks still
	// pending, as another run for the same organization was started with a
	// higher priority.
	//   "TERMINATED" - Asset discovery run was killed and terminated.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Duration") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1RunAssetDiscoveryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1RunAssetDiscoveryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule:
// Represents an instance of a Security Health Analytics custom module,
// including its full module name, display name, enablement state, and
// last updated time. You can create a custom module at the
// organization, folder, or project level. Custom modules that you
// create at the organization or folder level are inherited by the child
// folders and projects.
type GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule struct {
	// AncestorModule: Output only. If empty, indicates that the custom
	// module was created in the organization, folder, or project in which
	// you are viewing the custom module. Otherwise, `ancestor_module`
	// specifies the organization or folder from which the custom module is
	// inherited.
	AncestorModule string `json:"ancestorModule,omitempty"`

	// CustomConfig: The user specified custom configuration for the module.
	CustomConfig *GoogleCloudSecuritycenterV1CustomConfig `json:"customConfig,omitempty"`

	// DisplayName: The display name of the Security Health Analytics custom
	// module. This display name becomes the finding category for all
	// findings that are returned by this custom module. The display name
	// must be between 1 and 128 characters, start with a lowercase letter,
	// and contain alphanumeric characters or underscores only.
	DisplayName string `json:"displayName,omitempty"`

	// EnablementState: The enablement state of the custom module.
	//
	// Possible values:
	//   "ENABLEMENT_STATE_UNSPECIFIED" - Unspecified enablement state.
	//   "ENABLED" - The module is enabled at the given CRM resource.
	//   "DISABLED" - The module is disabled at the given CRM resource.
	//   "INHERITED" - State is inherited from an ancestor module. The
	// module will either be effectively ENABLED or DISABLED based on its
	// closest non-inherited ancestor module in the CRM hierarchy.
	EnablementState string `json:"enablementState,omitempty"`

	// LastEditor: Output only. The editor that last updated the custom
	// module.
	LastEditor string `json:"lastEditor,omitempty"`

	// Name: Immutable. The resource name of the custom module. Its format
	// is
	// "organizations/{organization}/securityHealthAnalyticsSettings/customMo
	// dules/{customModule}", or
	// "folders/{folder}/securityHealthAnalyticsSettings/customModules/{custo
	// mModule}", or
	// "projects/{project}/securityHealthAnalyticsSettings/customModules/{cus
	// tomModule}" The id {customModule} is server-generated and is not user
	// settable. It will be a numeric id containing 1-20 digits.
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. The time at which the custom module was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AncestorModule") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AncestorModule") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1SensitiveDataProtectionMapping: Resource
// value mapping for Sensitive Data Protection findings. If any of these
// mappings have a resource value that is not unspecified, the
// resource_value field will be ignored when reading this configuration.
type GoogleCloudSecuritycenterV1SensitiveDataProtectionMapping struct {
	// HighSensitivityMapping: Resource value mapping for high-sensitivity
	// Sensitive Data Protection findings
	//
	// Possible values:
	//   "RESOURCE_VALUE_UNSPECIFIED" - Unspecific value
	//   "HIGH" - High resource value
	//   "MEDIUM" - Medium resource value
	//   "LOW" - Low resource value
	//   "NONE" - No resource value, e.g. ignore these resources
	HighSensitivityMapping string `json:"highSensitivityMapping,omitempty"`

	// MediumSensitivityMapping: Resource value mapping for
	// medium-sensitivity Sensitive Data Protection findings
	//
	// Possible values:
	//   "RESOURCE_VALUE_UNSPECIFIED" - Unspecific value
	//   "HIGH" - High resource value
	//   "MEDIUM" - Medium resource value
	//   "LOW" - Low resource value
	//   "NONE" - No resource value, e.g. ignore these resources
	MediumSensitivityMapping string `json:"mediumSensitivityMapping,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "HighSensitivityMapping") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HighSensitivityMapping")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1SensitiveDataProtectionMapping) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1SensitiveDataProtectionMapping
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1beta1RunAssetDiscoveryResponse: Response
// of asset discovery run
type GoogleCloudSecuritycenterV1beta1RunAssetDiscoveryResponse struct {
	// Duration: The duration between asset discovery run start and end
	Duration string `json:"duration,omitempty"`

	// State: The state of an asset discovery run.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Asset discovery run state was unspecified.
	//   "COMPLETED" - Asset discovery run completed successfully.
	//   "SUPERSEDED" - Asset discovery run was cancelled with tasks still
	// pending, as another run for the same organization was started with a
	// higher priority.
	//   "TERMINATED" - Asset discovery run was killed and terminated.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Duration") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1beta1RunAssetDiscoveryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1beta1RunAssetDiscoveryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1p1beta1Finding: Security Command Center
// finding. A finding is a record of assessment data (security, risk,
// health or privacy) ingested into Security Command Center for
// presentation, notification, analysis, policy testing, and
// enforcement. For example, an XSS vulnerability in an App Engine
// application is a finding.
type GoogleCloudSecuritycenterV1p1beta1Finding struct {
	// CanonicalName: The canonical name of the finding. It's either
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}",
	// "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
	// "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
	//  depending on the closest CRM ancestor of the resource associated
	// with the finding.
	CanonicalName string `json:"canonicalName,omitempty"`

	// Category: The additional taxonomy group within findings from a given
	// source. This field is immutable after creation time. Example:
	// "XSS_FLASH_INJECTION"
	Category string `json:"category,omitempty"`

	// CreateTime: The time at which the finding was created in Security
	// Command Center.
	CreateTime string `json:"createTime,omitempty"`

	// EventTime: The time at which the event took place, or when an update
	// to the finding occurred. For example, if the finding represents an
	// open firewall it would capture the time the detector believes the
	// firewall became open. The accuracy is determined by the detector. If
	// the finding were to be resolved afterward, this time would reflect
	// when the finding was resolved. Must not be set to a value greater
	// than the current timestamp.
	EventTime string `json:"eventTime,omitempty"`

	// ExternalUri: The URI that, if available, points to a web page outside
	// of Security Command Center where additional information about the
	// finding can be found. This field is guaranteed to be either empty or
	// a well formed URL.
	ExternalUri string `json:"externalUri,omitempty"`

	// Name: The relative resource name of this finding. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example:
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}"
	Name string `json:"name,omitempty"`

	// Parent: The relative resource name of the source the finding belongs
	// to. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// This field is immutable after creation time. For example:
	// "organizations/{organization_id}/sources/{source_id}"
	Parent string `json:"parent,omitempty"`

	// ResourceName: For findings on Google Cloud resources, the full
	// resource name of the Google Cloud resource this finding is for. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	// When the finding is for a non-Google Cloud resource, the resourceName
	// can be a customer or partner defined string. This field is immutable
	// after creation time.
	ResourceName string `json:"resourceName,omitempty"`

	// SecurityMarks: Output only. User specified security marks. These
	// marks are entirely managed by the user and come from the
	// SecurityMarks resource that belongs to the finding.
	SecurityMarks *GoogleCloudSecuritycenterV1p1beta1SecurityMarks `json:"securityMarks,omitempty"`

	// Severity: The severity of the finding. This field is managed by the
	// source that writes the finding.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - No severity specified. The default value.
	//   "CRITICAL" - Critical severity.
	//   "HIGH" - High severity.
	//   "MEDIUM" - Medium severity.
	//   "LOW" - Low severity.
	Severity string `json:"severity,omitempty"`

	// SourceProperties: Source specific properties. These properties are
	// managed by the source that writes the finding. The key names in the
	// source_properties map must be between 1 and 255 characters, and must
	// start with a letter and contain alphanumeric characters or
	// underscores only.
	SourceProperties googleapi.RawMessage `json:"sourceProperties,omitempty"`

	// State: The state of the finding.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - The finding requires attention and has not been
	// addressed yet.
	//   "INACTIVE" - The finding has been fixed, triaged as a non-issue or
	// otherwise addressed and is no longer active.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1p1beta1Finding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1p1beta1Finding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1p1beta1Folder: Message that contains the
// resource name and display name of a folder resource.
type GoogleCloudSecuritycenterV1p1beta1Folder struct {
	// ResourceFolder: Full resource name of this folder. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceFolder string `json:"resourceFolder,omitempty"`

	// ResourceFolderDisplayName: The user defined display name for this
	// folder.
	ResourceFolderDisplayName string `json:"resourceFolderDisplayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceFolder") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceFolder") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1p1beta1Folder) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1p1beta1Folder
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1p1beta1NotificationMessage: Security
// Command Center's Notification
type GoogleCloudSecuritycenterV1p1beta1NotificationMessage struct {
	// Finding: If it's a Finding based notification config, this field will
	// be populated.
	Finding *GoogleCloudSecuritycenterV1p1beta1Finding `json:"finding,omitempty"`

	// NotificationConfigName: Name of the notification config that
	// generated current notification.
	NotificationConfigName string `json:"notificationConfigName,omitempty"`

	// Resource: The Cloud resource tied to the notification.
	Resource *GoogleCloudSecuritycenterV1p1beta1Resource `json:"resource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Finding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Finding") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1p1beta1NotificationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1p1beta1NotificationMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1p1beta1Resource: Information related to
// the Google Cloud resource.
type GoogleCloudSecuritycenterV1p1beta1Resource struct {
	// Folders: Output only. Contains a Folder message for each folder in
	// the assets ancestry. The first folder is the deepest nested folder,
	// and the last folder is the folder directly under the Organization.
	Folders []*GoogleCloudSecuritycenterV1p1beta1Folder `json:"folders,omitempty"`

	// Name: The full resource name of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	Name string `json:"name,omitempty"`

	// Parent: The full resource name of resource's parent.
	Parent string `json:"parent,omitempty"`

	// ParentDisplayName: The human readable name of resource's parent.
	ParentDisplayName string `json:"parentDisplayName,omitempty"`

	// Project: The full resource name of project that the resource belongs
	// to.
	Project string `json:"project,omitempty"`

	// ProjectDisplayName: The project id that the resource belongs to.
	ProjectDisplayName string `json:"projectDisplayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Folders") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Folders") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1p1beta1Resource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1p1beta1Resource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1p1beta1RunAssetDiscoveryResponse: Response
// of asset discovery run
type GoogleCloudSecuritycenterV1p1beta1RunAssetDiscoveryResponse struct {
	// Duration: The duration between asset discovery run start and end
	Duration string `json:"duration,omitempty"`

	// State: The state of an asset discovery run.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Asset discovery run state was unspecified.
	//   "COMPLETED" - Asset discovery run completed successfully.
	//   "SUPERSEDED" - Asset discovery run was cancelled with tasks still
	// pending, as another run for the same organization was started with a
	// higher priority.
	//   "TERMINATED" - Asset discovery run was killed and terminated.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Duration") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1p1beta1RunAssetDiscoveryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1p1beta1RunAssetDiscoveryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1p1beta1SecurityMarks: User specified
// security marks that are attached to the parent Security Command
// Center resource. Security marks are scoped within a Security Command
// Center organization -- they can be modified and viewed by all users
// who have proper permissions on the organization.
type GoogleCloudSecuritycenterV1p1beta1SecurityMarks struct {
	// CanonicalName: The canonical name of the marks. Examples:
	// "organizations/{organization_id}/assets/{asset_id}/securityMarks"
	// "folders/{folder_id}/assets/{asset_id}/securityMarks"
	// "projects/{project_number}/assets/{asset_id}/securityMarks"
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}/securityMarks"
	// "folders/{folder_id}/sources/{source_id}/findings/{finding_id}/securit
	// yMarks"
	// "projects/{project_number}/sources/{source_id}/findings/{finding_id}/s
	// ecurityMarks"
	CanonicalName string `json:"canonicalName,omitempty"`

	// Marks: Mutable user specified security marks belonging to the parent
	// resource. Constraints are as follows: * Keys and values are treated
	// as case insensitive * Keys must be between 1 - 256 characters
	// (inclusive) * Keys must be letters, numbers, underscores, or dashes *
	// Values have leading and trailing whitespace trimmed, remaining
	// characters must be between 1 - 4096 characters (inclusive)
	Marks map[string]string `json:"marks,omitempty"`

	// Name: The relative resource name of the SecurityMarks. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Examples:
	// "organizations/{organization_id}/assets/{asset_id}/securityMarks"
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}/securityMarks".
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1p1beta1SecurityMarks) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1p1beta1SecurityMarks
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Access: Represents an access event.
type GoogleCloudSecuritycenterV2Access struct {
	// CallerIp: Caller's IP address, such as "1.1.1.1".
	CallerIp string `json:"callerIp,omitempty"`

	// CallerIpGeo: The caller IP's geolocation, which identifies where the
	// call came from.
	CallerIpGeo *GoogleCloudSecuritycenterV2Geolocation `json:"callerIpGeo,omitempty"`

	// MethodName: The method that the service account called, e.g.
	// "SetIamPolicy".
	MethodName string `json:"methodName,omitempty"`

	// PrincipalEmail: Associated email, such as "foo@google.com". The email
	// address of the authenticated user or a service account acting on
	// behalf of a third party principal making the request. For third party
	// identity callers, the `principal_subject` field is populated instead
	// of this field. For privacy reasons, the principal email address is
	// sometimes redacted. For more information, see Caller identities in
	// audit logs (https://cloud.google.com/logging/docs/audit#user-id).
	PrincipalEmail string `json:"principalEmail,omitempty"`

	// PrincipalSubject: A string that represents the principal_subject that
	// is associated with the identity. Unlike `principal_email`,
	// `principal_subject` supports principals that aren't associated with
	// email addresses, such as third party principals. For most identities,
	// the format is `principal://iam.googleapis.com/{identity pool
	// name}/subject/{subject}`. Some GKE identities, such as GKE_WORKLOAD,
	// FREEFORM, and GKE_HUB_WORKLOAD, still use the legacy format
	// `serviceAccount:{identity pool name}[{subject}]`.
	PrincipalSubject string `json:"principalSubject,omitempty"`

	// ServiceAccountDelegationInfo: The identity delegation history of an
	// authenticated service account that made the request. The
	// `serviceAccountDelegationInfo[]` object contains information about
	// the real authorities that try to access Google Cloud resources by
	// delegating on a service account. When multiple authorities are
	// present, they are guaranteed to be sorted based on the original
	// ordering of the identity delegation events.
	ServiceAccountDelegationInfo []*GoogleCloudSecuritycenterV2ServiceAccountDelegationInfo `json:"serviceAccountDelegationInfo,omitempty"`

	// ServiceAccountKeyName: The name of the service account key that was
	// used to create or exchange credentials when authenticating the
	// service account that made the request. This is a scheme-less URI full
	// resource name. For example:
	// "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/
	// keys/{key}".
	ServiceAccountKeyName string `json:"serviceAccountKeyName,omitempty"`

	// ServiceName: This is the API service that the service account made a
	// call to, e.g. "iam.googleapis.com"
	ServiceName string `json:"serviceName,omitempty"`

	// UserAgent: The caller's user agent string associated with the
	// finding.
	UserAgent string `json:"userAgent,omitempty"`

	// UserAgentFamily: Type of user agent associated with the finding. For
	// example, an operating system shell or an embedded or standalone
	// application.
	UserAgentFamily string `json:"userAgentFamily,omitempty"`

	// UserName: A string that represents a username. The username provided
	// depends on the type of the finding and is likely not an IAM
	// principal. For example, this can be a system username if the finding
	// is related to a virtual machine, or it can be an application login
	// username.
	UserName string `json:"userName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CallerIp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallerIp") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Access) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Access
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2AccessReview: Conveys information about a
// Kubernetes access review (such as one returned by a `kubectl auth
// can-i`
// (https://kubernetes.io/docs/reference/access-authn-authz/authorization/#checking-api-access)
// command) that was involved in a finding.
type GoogleCloudSecuritycenterV2AccessReview struct {
	// Group: The API group of the resource. "*" means all.
	Group string `json:"group,omitempty"`

	// Name: The name of the resource being requested. Empty means all.
	Name string `json:"name,omitempty"`

	// Ns: Namespace of the action being requested. Currently, there is no
	// distinction between no namespace and all namespaces. Both are
	// represented by "" (empty).
	Ns string `json:"ns,omitempty"`

	// Resource: The optional resource type requested. "*" means all.
	Resource string `json:"resource,omitempty"`

	// Subresource: The optional subresource type.
	Subresource string `json:"subresource,omitempty"`

	// Verb: A Kubernetes resource API verb, like get, list, watch, create,
	// update, delete, proxy. "*" means all.
	Verb string `json:"verb,omitempty"`

	// Version: The API version of the resource. "*" means all.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Group") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Group") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2AccessReview) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2AccessReview
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Application: Represents an application
// associated with a finding.
type GoogleCloudSecuritycenterV2Application struct {
	// BaseUri: The base URI that identifies the network location of the
	// application in which the vulnerability was detected. For example,
	// `http://example.com`.
	BaseUri string `json:"baseUri,omitempty"`

	// FullUri: The full URI with payload that could be used to reproduce
	// the vulnerability. For example, `http://example.com?p=aMmYgI6H`.
	FullUri string `json:"fullUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BaseUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BaseUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Application) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Application
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2AttackExposure: An attack exposure
// contains the results of an attack path simulation run.
type GoogleCloudSecuritycenterV2AttackExposure struct {
	// AttackExposureResult: The resource name of the attack path simulation
	// result that contains the details regarding this attack exposure
	// score. Example:
	// organizations/123/simulations/456/attackExposureResults/789
	AttackExposureResult string `json:"attackExposureResult,omitempty"`

	// ExposedHighValueResourcesCount: The number of high value resources
	// that are exposed as a result of this finding.
	ExposedHighValueResourcesCount int64 `json:"exposedHighValueResourcesCount,omitempty"`

	// ExposedLowValueResourcesCount: The number of high value resources
	// that are exposed as a result of this finding.
	ExposedLowValueResourcesCount int64 `json:"exposedLowValueResourcesCount,omitempty"`

	// ExposedMediumValueResourcesCount: The number of medium value
	// resources that are exposed as a result of this finding.
	ExposedMediumValueResourcesCount int64 `json:"exposedMediumValueResourcesCount,omitempty"`

	// LatestCalculationTime: The most recent time the attack exposure was
	// updated on this finding.
	LatestCalculationTime string `json:"latestCalculationTime,omitempty"`

	// Score: A number between 0 (inclusive) and infinity that represents
	// how important this finding is to remediate. The higher the score, the
	// more important it is to remediate.
	Score float64 `json:"score,omitempty"`

	// State: Output only. What state this AttackExposure is in. This
	// captures whether or not an attack exposure has been calculated or
	// not.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The state is not specified.
	//   "CALCULATED" - The attack exposure has been calculated.
	//   "NOT_CALCULATED" - The attack exposure has not been calculated.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AttackExposureResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttackExposureResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2AttackExposure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2AttackExposure
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudSecuritycenterV2AttackExposure) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudSecuritycenterV2AttackExposure
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudSecuritycenterV2BackupDisasterRecovery: Information
// related to Google Cloud Backup and DR Service findings.
type GoogleCloudSecuritycenterV2BackupDisasterRecovery struct {
	// Appliance: The name of the Backup and DR appliance that captures,
	// moves, and manages the lifecycle of backup data. For example,
	// `backup-server-57137`.
	Appliance string `json:"appliance,omitempty"`

	// Applications: The names of Backup and DR applications. An application
	// is a VM, database, or file system on a managed host monitored by a
	// backup and recovery appliance. For example, `centos7-01-vol00`,
	// `centos7-01-vol01`, `centos7-01-vol02`.
	Applications []string `json:"applications,omitempty"`

	// BackupCreateTime: The timestamp at which the Backup and DR backup was
	// created.
	BackupCreateTime string `json:"backupCreateTime,omitempty"`

	// BackupTemplate: The name of a Backup and DR template which comprises
	// one or more backup policies. See the Backup and DR documentation
	// (https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
	// for more information. For example, `snap-ov`.
	BackupTemplate string `json:"backupTemplate,omitempty"`

	// BackupType: The backup type of the Backup and DR image. For example,
	// `Snapshot`, `Remote Snapshot`, `OnVault`.
	BackupType string `json:"backupType,omitempty"`

	// Host: The name of a Backup and DR host, which is managed by the
	// backup and recovery appliance and known to the management console.
	// The host can be of type Generic (for example, Compute Engine, SQL
	// Server, Oracle DB, SMB file system, etc.), vCenter, or an ESX server.
	// See the Backup and DR documentation on hosts
	// (https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
	// for more information. For example, `centos7-01`.
	Host string `json:"host,omitempty"`

	// Policies: The names of Backup and DR policies that are associated
	// with a template and that define when to run a backup, how frequently
	// to run a backup, and how long to retain the backup image. For
	// example, `onvaults`.
	Policies []string `json:"policies,omitempty"`

	// PolicyOptions: The names of Backup and DR advanced policy options of
	// a policy applying to an application. See the Backup and DR
	// documentation on policy options
	// (https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
	// For example, `skipofflineappsincongrp, nounmap`.
	PolicyOptions []string `json:"policyOptions,omitempty"`

	// Profile: The name of the Backup and DR resource profile that
	// specifies the storage media for backups of application and VM data.
	// See the Backup and DR documentation on profiles
	// (https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
	// For example, `GCP`.
	Profile string `json:"profile,omitempty"`

	// StoragePool: The name of the Backup and DR storage pool that the
	// backup and recovery appliance is storing data in. The storage pool
	// could be of type Cloud, Primary, Snapshot, or OnVault. See the Backup
	// and DR documentation on storage pools
	// (https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
	// For example, `DiskPoolOne`.
	StoragePool string `json:"storagePool,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Appliance") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Appliance") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2BackupDisasterRecovery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2BackupDisasterRecovery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2BigQueryExport: Configures how to deliver
// Findings to BigQuery Instance.
type GoogleCloudSecuritycenterV2BigQueryExport struct {
	// CreateTime: Output only. The time at which the BigQuery export was
	// created. This field is set by the server and will be ignored if
	// provided on export on creation.
	CreateTime string `json:"createTime,omitempty"`

	// Dataset: The dataset to write findings' updates to. Its format is
	// "projects/[project_id]/datasets/[bigquery_dataset_id]". BigQuery
	// Dataset unique ID must contain only letters (a-z, A-Z), numbers
	// (0-9), or underscores (_).
	Dataset string `json:"dataset,omitempty"`

	// Description: The description of the export (max of 1024 characters).
	Description string `json:"description,omitempty"`

	// Filter: Expression that defines the filter to apply across
	// create/update events of findings. The expression is a list of zero or
	// more restrictions combined via logical operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	// Restrictions have the form ` ` and may have a `-` character in front
	// of them to indicate negation. The fields map to those defined in the
	// corresponding resource. The supported operators are: * `=` for all
	// value types. * `>`, `<`, `>=`, `<=` for integer values. * `:`,
	// meaning substring matching, for strings. The supported value types
	// are: * string literals in quotes. * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	Filter string `json:"filter,omitempty"`

	// MostRecentEditor: Output only. Email address of the user who last
	// edited the BigQuery export. This field is set by the server and will
	// be ignored if provided on export creation or update.
	MostRecentEditor string `json:"mostRecentEditor,omitempty"`

	// Name: The relative resource name of this export. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name.
	// The following list shows some examples: +
	// `organizations/{organization_id}/locations/{location_id}/bigQueryExpor
	// ts/{export_id}` +
	// `folders/{folder_id}/locations/{location_id}/bigQueryExports/{export_i
	// d}` +
	// `projects/{project_id}/locations/{location_id}/bigQueryExports/{export
	// _id}` This field is provided in responses, and is ignored when
	// provided in create requests.
	Name string `json:"name,omitempty"`

	// Principal: Output only. The service account that needs permission to
	// create table and upload data to the BigQuery dataset.
	Principal string `json:"principal,omitempty"`

	// UpdateTime: Output only. The most recent time at which the BigQuery
	// export was updated. This field is set by the server and will be
	// ignored if provided on export creation or update.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2BigQueryExport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2BigQueryExport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Binding: Represents a Kubernetes
// RoleBinding or ClusterRoleBinding.
type GoogleCloudSecuritycenterV2Binding struct {
	// Name: Name for the binding.
	Name string `json:"name,omitempty"`

	// Ns: Namespace for the binding.
	Ns string `json:"ns,omitempty"`

	// Role: The Role or ClusterRole referenced by the binding.
	Role *GoogleCloudSecuritycenterV2Role `json:"role,omitempty"`

	// Subjects: Represents one or more subjects that are bound to the role.
	// Not always available for PATCH requests.
	Subjects []*GoogleCloudSecuritycenterV2Subject `json:"subjects,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2BulkMuteFindingsResponse: The response to
// a BulkMute request. Contains the LRO information.
type GoogleCloudSecuritycenterV2BulkMuteFindingsResponse struct {
}

// GoogleCloudSecuritycenterV2CloudDlpDataProfile: The data profile
// (https://cloud.google.com/dlp/docs/data-profiles) associated with the
// finding.
type GoogleCloudSecuritycenterV2CloudDlpDataProfile struct {
	// DataProfile: Name of the data profile, for example,
	// `projects/123/locations/europe/tableProfiles/8383929`.
	DataProfile string `json:"dataProfile,omitempty"`

	// ParentType: The resource hierarchy level at which the data profile
	// was generated.
	//
	// Possible values:
	//   "PARENT_TYPE_UNSPECIFIED" - Unspecified parent type.
	//   "ORGANIZATION" - Organization-level configurations.
	//   "PROJECT" - Project-level configurations.
	ParentType string `json:"parentType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataProfile") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataProfile") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2CloudDlpDataProfile) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2CloudDlpDataProfile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2CloudDlpInspection: Details about the
// Cloud Data Loss Prevention (Cloud DLP) inspection job
// (https://cloud.google.com/dlp/docs/concepts-job-triggers) that
// produced the finding.
type GoogleCloudSecuritycenterV2CloudDlpInspection struct {
	// FullScan: Whether Cloud DLP scanned the complete resource or a
	// sampled subset.
	FullScan bool `json:"fullScan,omitempty"`

	// InfoType: The type of information (or *infoType
	// (https://cloud.google.com/dlp/docs/infotypes-reference)*) found, for
	// example, `EMAIL_ADDRESS` or `STREET_ADDRESS`.
	InfoType string `json:"infoType,omitempty"`

	// InfoTypeCount: The number of times Cloud DLP found this infoType
	// within this job and resource.
	InfoTypeCount int64 `json:"infoTypeCount,omitempty,string"`

	// InspectJob: Name of the inspection job, for example,
	// `projects/123/locations/europe/dlpJobs/i-8383929`.
	InspectJob string `json:"inspectJob,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FullScan") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FullScan") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2CloudDlpInspection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2CloudDlpInspection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2CloudLoggingEntry: Metadata taken from a
// Cloud Logging LogEntry
// (https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
type GoogleCloudSecuritycenterV2CloudLoggingEntry struct {
	// InsertId: A unique identifier for the log entry.
	InsertId string `json:"insertId,omitempty"`

	// LogId: The type of the log (part of `log_name`. `log_name` is the
	// resource name of the log to which this log entry belongs). For
	// example: `cloudresourcemanager.googleapis.com/activity` Note that
	// this field is not URL-encoded, unlike in `LogEntry`.
	LogId string `json:"logId,omitempty"`

	// ResourceContainer: The organization, folder, or project of the
	// monitored resource that produced this log entry.
	ResourceContainer string `json:"resourceContainer,omitempty"`

	// Timestamp: The time the event described by the log entry occurred.
	Timestamp string `json:"timestamp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InsertId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InsertId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2CloudLoggingEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2CloudLoggingEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Compliance: Contains compliance
// information about a security standard indicating unmet
// recommendations.
type GoogleCloudSecuritycenterV2Compliance struct {
	// Ids: Policies within the standard or benchmark, for example, A.12.4.1
	Ids []string `json:"ids,omitempty"`

	// Standard: Industry-wide compliance standards or benchmarks, such as
	// CIS, PCI, and OWASP.
	Standard string `json:"standard,omitempty"`

	// Version: Version of the standard or benchmark, for example, 1.1
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Ids") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Ids") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Compliance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Compliance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Connection: Contains information about the
// IP connection associated with the finding.
type GoogleCloudSecuritycenterV2Connection struct {
	// DestinationIp: Destination IP address. Not present for sockets that
	// are listening and not connected.
	DestinationIp string `json:"destinationIp,omitempty"`

	// DestinationPort: Destination port. Not present for sockets that are
	// listening and not connected.
	DestinationPort int64 `json:"destinationPort,omitempty"`

	// Protocol: IANA Internet Protocol Number such as TCP(6) and UDP(17).
	//
	// Possible values:
	//   "PROTOCOL_UNSPECIFIED" - Unspecified protocol (not HOPOPT).
	//   "ICMP" - Internet Control Message Protocol.
	//   "TCP" - Transmission Control Protocol.
	//   "UDP" - User Datagram Protocol.
	//   "GRE" - Generic Routing Encapsulation.
	//   "ESP" - Encap Security Payload.
	Protocol string `json:"protocol,omitempty"`

	// SourceIp: Source IP address.
	SourceIp string `json:"sourceIp,omitempty"`

	// SourcePort: Source port.
	SourcePort int64 `json:"sourcePort,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestinationIp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestinationIp") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Connection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Connection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Contact: The email address of a contact.
type GoogleCloudSecuritycenterV2Contact struct {
	// Email: An email address. For example, "person123@company.com".
	Email string `json:"email,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Contact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Contact
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2ContactDetails: Details about specific
// contacts
type GoogleCloudSecuritycenterV2ContactDetails struct {
	// Contacts: A list of contacts
	Contacts []*GoogleCloudSecuritycenterV2Contact `json:"contacts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Contacts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contacts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2ContactDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2ContactDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Container: Container associated with the
// finding.
type GoogleCloudSecuritycenterV2Container struct {
	// CreateTime: The time that the container was created.
	CreateTime string `json:"createTime,omitempty"`

	// ImageId: Optional container image ID, if provided by the container
	// runtime. Uniquely identifies the container image launched using a
	// container image digest.
	ImageId string `json:"imageId,omitempty"`

	// Labels: Container labels, as provided by the container runtime.
	Labels []*GoogleCloudSecuritycenterV2Label `json:"labels,omitempty"`

	// Name: Name of the container.
	Name string `json:"name,omitempty"`

	// Uri: Container image URI provided when configuring a pod or
	// container. This string can identify a container image version using
	// mutable tags.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Container) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Container
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Cve: CVE stands for Common Vulnerabilities
// and Exposures. Information from the CVE record
// (https://www.cve.org/ResourcesSupport/Glossary) that describes this
// vulnerability.
type GoogleCloudSecuritycenterV2Cve struct {
	// Cvssv3: Describe Common Vulnerability Scoring System specified at
	// https://www.first.org/cvss/v3.1/specification-document
	Cvssv3 *GoogleCloudSecuritycenterV2Cvssv3 `json:"cvssv3,omitempty"`

	// ExploitationActivity: The exploitation activity of the vulnerability
	// in the wild.
	//
	// Possible values:
	//   "EXPLOITATION_ACTIVITY_UNSPECIFIED" - Invalid or empty value.
	//   "WIDE" - Exploitation has been reported or confirmed to widely
	// occur.
	//   "CONFIRMED" - Limited reported or confirmed exploitation
	// activities.
	//   "AVAILABLE" - Exploit is publicly available.
	//   "ANTICIPATED" - No known exploitation activity, but has a high
	// potential for exploitation.
	//   "NO_KNOWN" - No known exploitation activity.
	ExploitationActivity string `json:"exploitationActivity,omitempty"`

	// Id: The unique identifier for the vulnerability. e.g. CVE-2021-34527
	Id string `json:"id,omitempty"`

	// Impact: The potential impact of the vulnerability if it was to be
	// exploited.
	//
	// Possible values:
	//   "RISK_RATING_UNSPECIFIED" - Invalid or empty value.
	//   "LOW" - Exploitation would have little to no security impact.
	//   "MEDIUM" - Exploitation would enable attackers to perform
	// activities, or could allow attackers to have a direct impact, but
	// would require additional steps.
	//   "HIGH" - Exploitation would enable attackers to have a notable
	// direct impact without needing to overcome any major mitigating
	// factors.
	//   "CRITICAL" - Exploitation would fundamentally undermine the
	// security of affected systems, enable actors to perform significant
	// attacks with minimal effort, with little to no mitigating factors to
	// overcome.
	Impact string `json:"impact,omitempty"`

	// ObservedInTheWild: Whether or not the vulnerability has been observed
	// in the wild.
	ObservedInTheWild bool `json:"observedInTheWild,omitempty"`

	// References: Additional information about the CVE. e.g.
	// https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
	References []*GoogleCloudSecuritycenterV2Reference `json:"references,omitempty"`

	// UpstreamFixAvailable: Whether upstream fix is available for the CVE.
	UpstreamFixAvailable bool `json:"upstreamFixAvailable,omitempty"`

	// ZeroDay: Whether or not the vulnerability was zero day when the
	// finding was published.
	ZeroDay bool `json:"zeroDay,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cvssv3") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cvssv3") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Cve) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Cve
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Cvssv3: Common Vulnerability Scoring
// System version 3.
type GoogleCloudSecuritycenterV2Cvssv3 struct {
	// AttackComplexity: This metric describes the conditions beyond the
	// attacker's control that must exist in order to exploit the
	// vulnerability.
	//
	// Possible values:
	//   "ATTACK_COMPLEXITY_UNSPECIFIED" - Invalid value.
	//   "ATTACK_COMPLEXITY_LOW" - Specialized access conditions or
	// extenuating circumstances do not exist. An attacker can expect
	// repeatable success when attacking the vulnerable component.
	//   "ATTACK_COMPLEXITY_HIGH" - A successful attack depends on
	// conditions beyond the attacker's control. That is, a successful
	// attack cannot be accomplished at will, but requires the attacker to
	// invest in some measurable amount of effort in preparation or
	// execution against the vulnerable component before a successful attack
	// can be expected.
	AttackComplexity string `json:"attackComplexity,omitempty"`

	// AttackVector: Base Metrics Represents the intrinsic characteristics
	// of a vulnerability that are constant over time and across user
	// environments. This metric reflects the context by which vulnerability
	// exploitation is possible.
	//
	// Possible values:
	//   "ATTACK_VECTOR_UNSPECIFIED" - Invalid value.
	//   "ATTACK_VECTOR_NETWORK" - The vulnerable component is bound to the
	// network stack and the set of possible attackers extends beyond the
	// other options listed below, up to and including the entire Internet.
	//   "ATTACK_VECTOR_ADJACENT" - The vulnerable component is bound to the
	// network stack, but the attack is limited at the protocol level to a
	// logically adjacent topology.
	//   "ATTACK_VECTOR_LOCAL" - The vulnerable component is not bound to
	// the network stack and the attacker's path is via read/write/execute
	// capabilities.
	//   "ATTACK_VECTOR_PHYSICAL" - The attack requires the attacker to
	// physically touch or manipulate the vulnerable component.
	AttackVector string `json:"attackVector,omitempty"`

	// AvailabilityImpact: This metric measures the impact to the
	// availability of the impacted component resulting from a successfully
	// exploited vulnerability.
	//
	// Possible values:
	//   "IMPACT_UNSPECIFIED" - Invalid value.
	//   "IMPACT_HIGH" - High impact.
	//   "IMPACT_LOW" - Low impact.
	//   "IMPACT_NONE" - No impact.
	AvailabilityImpact string `json:"availabilityImpact,omitempty"`

	// BaseScore: The base score is a function of the base metric scores.
	BaseScore float64 `json:"baseScore,omitempty"`

	// ConfidentialityImpact: This metric measures the impact to the
	// confidentiality of the information resources managed by a software
	// component due to a successfully exploited vulnerability.
	//
	// Possible values:
	//   "IMPACT_UNSPECIFIED" - Invalid value.
	//   "IMPACT_HIGH" - High impact.
	//   "IMPACT_LOW" - Low impact.
	//   "IMPACT_NONE" - No impact.
	ConfidentialityImpact string `json:"confidentialityImpact,omitempty"`

	// IntegrityImpact: This metric measures the impact to integrity of a
	// successfully exploited vulnerability.
	//
	// Possible values:
	//   "IMPACT_UNSPECIFIED" - Invalid value.
	//   "IMPACT_HIGH" - High impact.
	//   "IMPACT_LOW" - Low impact.
	//   "IMPACT_NONE" - No impact.
	IntegrityImpact string `json:"integrityImpact,omitempty"`

	// PrivilegesRequired: This metric describes the level of privileges an
	// attacker must possess before successfully exploiting the
	// vulnerability.
	//
	// Possible values:
	//   "PRIVILEGES_REQUIRED_UNSPECIFIED" - Invalid value.
	//   "PRIVILEGES_REQUIRED_NONE" - The attacker is unauthorized prior to
	// attack, and therefore does not require any access to settings or
	// files of the vulnerable system to carry out an attack.
	//   "PRIVILEGES_REQUIRED_LOW" - The attacker requires privileges that
	// provide basic user capabilities that could normally affect only
	// settings and files owned by a user. Alternatively, an attacker with
	// Low privileges has the ability to access only non-sensitive
	// resources.
	//   "PRIVILEGES_REQUIRED_HIGH" - The attacker requires privileges that
	// provide significant (e.g., administrative) control over the
	// vulnerable component allowing access to component-wide settings and
	// files.
	PrivilegesRequired string `json:"privilegesRequired,omitempty"`

	// Scope: The Scope metric captures whether a vulnerability in one
	// vulnerable component impacts resources in components beyond its
	// security scope.
	//
	// Possible values:
	//   "SCOPE_UNSPECIFIED" - Invalid value.
	//   "SCOPE_UNCHANGED" - An exploited vulnerability can only affect
	// resources managed by the same security authority.
	//   "SCOPE_CHANGED" - An exploited vulnerability can affect resources
	// beyond the security scope managed by the security authority of the
	// vulnerable component.
	Scope string `json:"scope,omitempty"`

	// UserInteraction: This metric captures the requirement for a human
	// user, other than the attacker, to participate in the successful
	// compromise of the vulnerable component.
	//
	// Possible values:
	//   "USER_INTERACTION_UNSPECIFIED" - Invalid value.
	//   "USER_INTERACTION_NONE" - The vulnerable system can be exploited
	// without interaction from any user.
	//   "USER_INTERACTION_REQUIRED" - Successful exploitation of this
	// vulnerability requires a user to take some action before the
	// vulnerability can be exploited.
	UserInteraction string `json:"userInteraction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttackComplexity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttackComplexity") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Cvssv3) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Cvssv3
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudSecuritycenterV2Cvssv3) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudSecuritycenterV2Cvssv3
	var s1 struct {
		BaseScore gensupport.JSONFloat64 `json:"baseScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BaseScore = float64(s1.BaseScore)
	return nil
}

// GoogleCloudSecuritycenterV2Database: Represents database access
// information, such as queries. A database may be a sub-resource of an
// instance (as in the case of Cloud SQL instances or Cloud Spanner
// instances), or the database instance itself. Some database resources
// might not have the full resource name
// (https://google.aip.dev/122#full-resource-names) populated because
// these resource types, such as Cloud SQL databases, are not yet
// supported by Cloud Asset Inventory. In these cases only the display
// name is provided.
type GoogleCloudSecuritycenterV2Database struct {
	// DisplayName: The human-readable name of the database that the user
	// connected to.
	DisplayName string `json:"displayName,omitempty"`

	// Grantees: The target usernames, roles, or groups of an SQL privilege
	// grant, which is not an IAM policy change.
	Grantees []string `json:"grantees,omitempty"`

	// Name: Some database resources may not have the full resource name
	// (https://google.aip.dev/122#full-resource-names) populated because
	// these resource types are not yet supported by Cloud Asset Inventory
	// (e.g. Cloud SQL databases). In these cases only the display name will
	// be provided. The full resource name
	// (https://google.aip.dev/122#full-resource-names) of the database that
	// the user connected to, if it is supported by Cloud Asset Inventory.
	Name string `json:"name,omitempty"`

	// Query: The SQL statement that is associated with the database access.
	Query string `json:"query,omitempty"`

	// UserName: The username used to connect to the database. The username
	// might not be an IAM principal and does not have a set format.
	UserName string `json:"userName,omitempty"`

	// Version: The version of the database, for example, POSTGRES_14. See
	// the complete list
	// (https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/SqlDatabaseVersion).
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Database) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Database
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Detection: Memory hash detection
// contributing to the binary family match.
type GoogleCloudSecuritycenterV2Detection struct {
	// Binary: The name of the binary associated with the memory hash
	// signature detection.
	Binary string `json:"binary,omitempty"`

	// PercentPagesMatched: The percentage of memory page hashes in the
	// signature that were matched.
	PercentPagesMatched float64 `json:"percentPagesMatched,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Binary") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Binary") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Detection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Detection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudSecuritycenterV2Detection) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudSecuritycenterV2Detection
	var s1 struct {
		PercentPagesMatched gensupport.JSONFloat64 `json:"percentPagesMatched"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.PercentPagesMatched = float64(s1.PercentPagesMatched)
	return nil
}

// GoogleCloudSecuritycenterV2DiskPath: Path of the file in terms of
// underlying disk/partition identifiers.
type GoogleCloudSecuritycenterV2DiskPath struct {
	// PartitionUuid: UUID of the partition (format
	// https://wiki.archlinux.org/title/persistent_block_device_naming#by-uuid)
	PartitionUuid string `json:"partitionUuid,omitempty"`

	// RelativePath: Relative path of the file in the partition as a JSON
	// encoded string. Example: /home/user1/executable_file.sh
	RelativePath string `json:"relativePath,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PartitionUuid") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PartitionUuid") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2DiskPath) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2DiskPath
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2EnvironmentVariable: A name-value pair
// representing an environment variable used in an operating system
// process.
type GoogleCloudSecuritycenterV2EnvironmentVariable struct {
	// Name: Environment variable name as a JSON encoded string.
	Name string `json:"name,omitempty"`

	// Val: Environment variable value as a JSON encoded string.
	Val string `json:"val,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2EnvironmentVariable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2EnvironmentVariable
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2ExfilResource: Resource where data was
// exfiltrated from or exfiltrated to.
type GoogleCloudSecuritycenterV2ExfilResource struct {
	// Components: Subcomponents of the asset that was exfiltrated, like
	// URIs used during exfiltration, table names, databases, and filenames.
	// For example, multiple tables might have been exfiltrated from the
	// same Cloud SQL instance, or multiple files might have been
	// exfiltrated from the same Cloud Storage bucket.
	Components []string `json:"components,omitempty"`

	// Name: The resource's full resource name
	// (https://cloud.google.com/apis/design/resource_names#full_resource_name).
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Components") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Components") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2ExfilResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2ExfilResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Exfiltration: Exfiltration represents a
// data exfiltration attempt from one or more sources to one or more
// targets. The `sources` attribute lists the sources of the exfiltrated
// data. The `targets` attribute lists the destinations the data was
// copied to.
type GoogleCloudSecuritycenterV2Exfiltration struct {
	// Sources: If there are multiple sources, then the data is considered
	// "joined" between them. For instance, BigQuery can join multiple
	// tables, and each table would be considered a source.
	Sources []*GoogleCloudSecuritycenterV2ExfilResource `json:"sources,omitempty"`

	// Targets: If there are multiple targets, each target would get a
	// complete copy of the "joined" source data.
	Targets []*GoogleCloudSecuritycenterV2ExfilResource `json:"targets,omitempty"`

	// TotalExfiltratedBytes: Total exfiltrated bytes processed for the
	// entire job.
	TotalExfiltratedBytes int64 `json:"totalExfiltratedBytes,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Sources") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Sources") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Exfiltration) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Exfiltration
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2ExternalSystem: Representation of third
// party SIEM/SOAR fields within SCC.
type GoogleCloudSecuritycenterV2ExternalSystem struct {
	// Assignees: References primary/secondary etc assignees in the external
	// system.
	Assignees []string `json:"assignees,omitempty"`

	// CaseCloseTime: The time when the case was closed, as reported by the
	// external system.
	CaseCloseTime string `json:"caseCloseTime,omitempty"`

	// CaseCreateTime: The time when the case was created, as reported by
	// the external system.
	CaseCreateTime string `json:"caseCreateTime,omitempty"`

	// CasePriority: The priority of the finding's corresponding case in the
	// external system.
	CasePriority string `json:"casePriority,omitempty"`

	// CaseSla: The SLA of the finding's corresponding case in the external
	// system.
	CaseSla string `json:"caseSla,omitempty"`

	// CaseUri: The link to the finding's corresponding case in the external
	// system.
	CaseUri string `json:"caseUri,omitempty"`

	// ExternalSystemUpdateTime: The time when the case was last updated, as
	// reported by the external system.
	ExternalSystemUpdateTime string `json:"externalSystemUpdateTime,omitempty"`

	// ExternalUid: The identifier that's used to track the finding's
	// corresponding case in the external system.
	ExternalUid string `json:"externalUid,omitempty"`

	// Name: Full resource name of the external system. The following list
	// shows some examples: +
	// `organizations/1234/sources/5678/findings/123456/externalSystems/jira`
	//  +
	// `organizations/1234/sources/5678/locations/us/findings/123456/external
	// Systems/jira` +
	// `folders/1234/sources/5678/findings/123456/externalSystems/jira` +
	// `folders/1234/sources/5678/locations/us/findings/123456/externalSystem
	// s/jira` +
	// `projects/1234/sources/5678/findings/123456/externalSystems/jira` +
	// `projects/1234/sources/5678/locations/us/findings/123456/externalSyste
	// ms/jira`
	Name string `json:"name,omitempty"`

	// Status: The most recent status of the finding's corresponding case,
	// as reported by the external system.
	Status string `json:"status,omitempty"`

	// TicketInfo: Information about the ticket, if any, that is being used
	// to track the resolution of the issue that is identified by this
	// finding.
	TicketInfo *GoogleCloudSecuritycenterV2TicketInfo `json:"ticketInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Assignees") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Assignees") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2ExternalSystem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2ExternalSystem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2File: File information about the related
// binary/library used by an executable, or the script used by a script
// interpreter
type GoogleCloudSecuritycenterV2File struct {
	// Contents: Prefix of the file contents as a JSON-encoded string.
	Contents string `json:"contents,omitempty"`

	// DiskPath: Path of the file in terms of underlying disk/partition
	// identifiers.
	DiskPath *GoogleCloudSecuritycenterV2DiskPath `json:"diskPath,omitempty"`

	// HashedSize: The length in bytes of the file prefix that was hashed.
	// If hashed_size == size, any hashes reported represent the entire
	// file.
	HashedSize int64 `json:"hashedSize,omitempty,string"`

	// PartiallyHashed: True when the hash covers only a prefix of the file.
	PartiallyHashed bool `json:"partiallyHashed,omitempty"`

	// Path: Absolute path of the file as a JSON encoded string.
	Path string `json:"path,omitempty"`

	// Sha256: SHA256 hash of the first hashed_size bytes of the file
	// encoded as a hex string. If hashed_size == size, sha256 represents
	// the SHA256 hash of the entire file.
	Sha256 string `json:"sha256,omitempty"`

	// Size: Size of the file in bytes.
	Size int64 `json:"size,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2File) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2File
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Finding: Security Command Center finding.
// A finding is a record of assessment data like security, risk, health,
// or privacy, that is ingested into Security Command Center for
// presentation, notification, analysis, policy testing, and
// enforcement. For example, a cross-site scripting (XSS) vulnerability
// in an App Engine application is a finding.
type GoogleCloudSecuritycenterV2Finding struct {
	// Access: Access details associated with the finding, such as more
	// information on the caller, which method was accessed, and from where.
	Access *GoogleCloudSecuritycenterV2Access `json:"access,omitempty"`

	// Application: Represents an application associated with the finding.
	Application *GoogleCloudSecuritycenterV2Application `json:"application,omitempty"`

	// AttackExposure: The results of an attack path simulation relevant to
	// this finding.
	AttackExposure *GoogleCloudSecuritycenterV2AttackExposure `json:"attackExposure,omitempty"`

	// BackupDisasterRecovery: Fields related to Backup and DR findings.
	BackupDisasterRecovery *GoogleCloudSecuritycenterV2BackupDisasterRecovery `json:"backupDisasterRecovery,omitempty"`

	// CanonicalName: Output only. The canonical name of the finding. The
	// following list shows some examples: +
	// `organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}` +
	// `organizations/{organization_id}/sources/{source_id}/locations/{locati
	// on_id}/findings/{finding_id}` +
	// `folders/{folder_id}/sources/{source_id}/findings/{finding_id}` +
	// `folders/{folder_id}/sources/{source_id}/locations/{location_id}/findi
	// ngs/{finding_id}` +
	// `projects/{project_id}/sources/{source_id}/findings/{finding_id}` +
	// `projects/{project_id}/sources/{source_id}/locations/{location_id}/fin
	// dings/{finding_id}` The prefix is the closest CRM ancestor of the
	// resource associated with the finding.
	CanonicalName string `json:"canonicalName,omitempty"`

	// Category: Immutable. The additional taxonomy group within findings
	// from a given source. Example: "XSS_FLASH_INJECTION"
	Category string `json:"category,omitempty"`

	// CloudDlpDataProfile: Cloud DLP data profile that is associated with
	// the finding.
	CloudDlpDataProfile *GoogleCloudSecuritycenterV2CloudDlpDataProfile `json:"cloudDlpDataProfile,omitempty"`

	// CloudDlpInspection: Cloud Data Loss Prevention (Cloud DLP) inspection
	// results that are associated with the finding.
	CloudDlpInspection *GoogleCloudSecuritycenterV2CloudDlpInspection `json:"cloudDlpInspection,omitempty"`

	// Compliances: Contains compliance information for security standards
	// associated to the finding.
	Compliances []*GoogleCloudSecuritycenterV2Compliance `json:"compliances,omitempty"`

	// Connections: Contains information about the IP connection associated
	// with the finding.
	Connections []*GoogleCloudSecuritycenterV2Connection `json:"connections,omitempty"`

	// Contacts: Output only. Map containing the points of contact for the
	// given finding. The key represents the type of contact, while the
	// value contains a list of all the contacts that pertain. Please refer
	// to:
	// https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
	// { "security": { "contacts": [ { "email": "person1@company.com" }, {
	// "email": "person2@company.com" } ] } }
	Contacts map[string]GoogleCloudSecuritycenterV2ContactDetails `json:"contacts,omitempty"`

	// Containers: Containers associated with the finding. This field
	// provides information for both Kubernetes and non-Kubernetes
	// containers.
	Containers []*GoogleCloudSecuritycenterV2Container `json:"containers,omitempty"`

	// CreateTime: Output only. The time at which the finding was created in
	// Security Command Center.
	CreateTime string `json:"createTime,omitempty"`

	// Database: Database associated with the finding.
	Database *GoogleCloudSecuritycenterV2Database `json:"database,omitempty"`

	// Description: Contains more details about the finding.
	Description string `json:"description,omitempty"`

	// EventTime: The time the finding was first detected. If an existing
	// finding is updated, then this is the time the update occurred. For
	// example, if the finding represents an open firewall, this property
	// captures the time the detector believes the firewall became open. The
	// accuracy is determined by the detector. If the finding is later
	// resolved, then this time reflects when the finding was resolved. This
	// must not be set to a value greater than the current timestamp.
	EventTime string `json:"eventTime,omitempty"`

	// Exfiltration: Represents exfiltrations associated with the finding.
	Exfiltration *GoogleCloudSecuritycenterV2Exfiltration `json:"exfiltration,omitempty"`

	// ExternalSystems: Output only. Third party SIEM/SOAR fields within
	// SCC, contains external system information and external system finding
	// fields.
	ExternalSystems map[string]GoogleCloudSecuritycenterV2ExternalSystem `json:"externalSystems,omitempty"`

	// ExternalUri: The URI that, if available, points to a web page outside
	// of Security Command Center where additional information about the
	// finding can be found. This field is guaranteed to be either empty or
	// a well formed URL.
	ExternalUri string `json:"externalUri,omitempty"`

	// Files: File associated with the finding.
	Files []*GoogleCloudSecuritycenterV2File `json:"files,omitempty"`

	// FindingClass: The class of the finding.
	//
	// Possible values:
	//   "FINDING_CLASS_UNSPECIFIED" - Unspecified finding class.
	//   "THREAT" - Describes unwanted or malicious activity.
	//   "VULNERABILITY" - Describes a potential weakness in software that
	// increases risk to Confidentiality & Integrity & Availability.
	//   "MISCONFIGURATION" - Describes a potential weakness in cloud
	// resource/asset configuration that increases risk.
	//   "OBSERVATION" - Describes a security observation that is for
	// informational purposes.
	//   "SCC_ERROR" - Describes an error that prevents some SCC
	// functionality.
	//   "POSTURE_VIOLATION" - Describes a potential security risk due to a
	// change in the security posture.
	FindingClass string `json:"findingClass,omitempty"`

	// IamBindings: Represents IAM bindings associated with the finding.
	IamBindings []*GoogleCloudSecuritycenterV2IamBinding `json:"iamBindings,omitempty"`

	// Indicator: Represents what's commonly known as an *indicator of
	// compromise* (IoC) in computer forensics. This is an artifact observed
	// on a network or in an operating system that, with high confidence,
	// indicates a computer intrusion. For more information, see Indicator
	// of compromise
	// (https://en.wikipedia.org/wiki/Indicator_of_compromise).
	Indicator *GoogleCloudSecuritycenterV2Indicator `json:"indicator,omitempty"`

	// KernelRootkit: Signature of the kernel rootkit.
	KernelRootkit *GoogleCloudSecuritycenterV2KernelRootkit `json:"kernelRootkit,omitempty"`

	// Kubernetes: Kubernetes resources associated with the finding.
	Kubernetes *GoogleCloudSecuritycenterV2Kubernetes `json:"kubernetes,omitempty"`

	// LoadBalancers: The load balancers associated with the finding.
	LoadBalancers []*GoogleCloudSecuritycenterV2LoadBalancer `json:"loadBalancers,omitempty"`

	// LogEntries: Log entries that are relevant to the finding.
	LogEntries []*GoogleCloudSecuritycenterV2LogEntry `json:"logEntries,omitempty"`

	// MitreAttack: MITRE ATT&CK tactics and techniques related to this
	// finding. See: https://attack.mitre.org
	MitreAttack *GoogleCloudSecuritycenterV2MitreAttack `json:"mitreAttack,omitempty"`

	// ModuleName: Unique identifier of the module which generated the
	// finding. Example:
	// folders/598186756061/securityHealthAnalyticsSettings/customModules/567
	// 99441161885
	ModuleName string `json:"moduleName,omitempty"`

	// Mute: Indicates the mute state of a finding (either muted, unmuted or
	// undefined). Unlike other attributes of a finding, a finding provider
	// shouldn't set the value of mute.
	//
	// Possible values:
	//   "MUTE_UNSPECIFIED" - Unspecified.
	//   "MUTED" - Finding has been muted.
	//   "UNMUTED" - Finding has been unmuted.
	//   "UNDEFINED" - Finding has never been muted/unmuted.
	Mute string `json:"mute,omitempty"`

	// MuteInitiator: Records additional information about the mute
	// operation, for example, the mute configuration
	// (https://cloud.google.com/security-command-center/docs/how-to-mute-findings)
	// that muted the finding and the user who muted the finding.
	MuteInitiator string `json:"muteInitiator,omitempty"`

	// MuteUpdateTime: Output only. The most recent time this finding was
	// muted or unmuted.
	MuteUpdateTime string `json:"muteUpdateTime,omitempty"`

	// Name: The relative resource name
	// (https://cloud.google.com/apis/design/resource_names#relative_resource_name)
	// of the finding. The following list shows some examples: +
	// `organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}` +
	// `organizations/{organization_id}/sources/{source_id}/locations/{locati
	// on_id}/findings/{finding_id}` +
	// `folders/{folder_id}/sources/{source_id}/findings/{finding_id}` +
	// `folders/{folder_id}/sources/{source_id}/locations/{location_id}/findi
	// ngs/{finding_id}` +
	// `projects/{project_id}/sources/{source_id}/findings/{finding_id}` +
	// `projects/{project_id}/sources/{source_id}/locations/{location_id}/fin
	// dings/{finding_id}`
	Name string `json:"name,omitempty"`

	// NextSteps: Steps to address the finding.
	NextSteps string `json:"nextSteps,omitempty"`

	// OrgPolicies: Contains information about the org policies associated
	// with the finding.
	OrgPolicies []*GoogleCloudSecuritycenterV2OrgPolicy `json:"orgPolicies,omitempty"`

	// Parent: The relative resource name of the source and location the
	// finding belongs to. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// This field is immutable after creation time. The following list shows
	// some examples: +
	// `organizations/{organization_id}/sources/{source_id}` +
	// `folders/{folders_id}/sources/{source_id}` +
	// `projects/{projects_id}/sources/{source_id}` +
	// `organizations/{organization_id}/sources/{source_id}/locations/{locati
	// on_id}` +
	// `folders/{folders_id}/sources/{source_id}/locations/{location_id}` +
	// `projects/{projects_id}/sources/{source_id}/locations/{location_id}`
	Parent string `json:"parent,omitempty"`

	// ParentDisplayName: Output only. The human readable display name of
	// the finding source such as "Event Threat Detection" or "Security
	// Health Analytics".
	ParentDisplayName string `json:"parentDisplayName,omitempty"`

	// Processes: Represents operating system processes associated with the
	// Finding.
	Processes []*GoogleCloudSecuritycenterV2Process `json:"processes,omitempty"`

	// ResourceName: Immutable. For findings on Google Cloud resources, the
	// full resource name of the Google Cloud resource this finding is for.
	// See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	// When the finding is for a non-Google Cloud resource, the resourceName
	// can be a customer or partner defined string.
	ResourceName string `json:"resourceName,omitempty"`

	// SecurityMarks: Output only. User specified security marks. These
	// marks are entirely managed by the user and come from the
	// SecurityMarks resource that belongs to the finding.
	SecurityMarks *GoogleCloudSecuritycenterV2SecurityMarks `json:"securityMarks,omitempty"`

	// SecurityPosture: The security posture associated with the finding.
	SecurityPosture *GoogleCloudSecuritycenterV2SecurityPosture `json:"securityPosture,omitempty"`

	// Severity: The severity of the finding. This field is managed by the
	// source that writes the finding.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - This value is used for findings when a
	// source doesn't write a severity value.
	//   "CRITICAL" - Vulnerability: A critical vulnerability is easily
	// discoverable by an external actor, exploitable, and results in the
	// direct ability to execute arbitrary code, exfiltrate data, and
	// otherwise gain additional access and privileges to cloud resources
	// and workloads. Examples include publicly accessible unprotected user
	// data and public SSH access with weak or no passwords. Threat:
	// Indicates a threat that is able to access, modify, or delete data or
	// execute unauthorized code within existing resources.
	//   "HIGH" - Vulnerability: A high risk vulnerability can be easily
	// discovered and exploited in combination with other vulnerabilities in
	// order to gain direct access and the ability to execute arbitrary
	// code, exfiltrate data, and otherwise gain additional access and
	// privileges to cloud resources and workloads. An example is a database
	// with weak or no passwords that is only accessible internally. This
	// database could easily be compromised by an actor that had access to
	// the internal network. Threat: Indicates a threat that is able to
	// create new computational resources in an environment but not able to
	// access data or execute code in existing resources.
	//   "MEDIUM" - Vulnerability: A medium risk vulnerability could be used
	// by an actor to gain access to resources or privileges that enable
	// them to eventually (through multiple steps or a complex exploit) gain
	// access and the ability to execute arbitrary code or exfiltrate data.
	// An example is a service account with access to more projects than it
	// should have. If an actor gains access to the service account, they
	// could potentially use that access to manipulate a project the service
	// account was not intended to. Threat: Indicates a threat that is able
	// to cause operational impact but may not access data or execute
	// unauthorized code.
	//   "LOW" - Vulnerability: A low risk vulnerability hampers a security
	// organization's ability to detect vulnerabilities or active threats in
	// their deployment, or prevents the root cause investigation of
	// security issues. An example is monitoring and logs being disabled for
	// resource configurations and access. Threat: Indicates a threat that
	// has obtained minimal access to an environment but is not able to
	// access data, execute code, or create resources.
	Severity string `json:"severity,omitempty"`

	// SourceProperties: Source specific properties. These properties are
	// managed by the source that writes the finding. The key names in the
	// source_properties map must be between 1 and 255 characters, and must
	// start with a letter and contain alphanumeric characters or
	// underscores only.
	SourceProperties googleapi.RawMessage `json:"sourceProperties,omitempty"`

	// State: Output only. The state of the finding.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - The finding requires attention and has not been
	// addressed yet.
	//   "INACTIVE" - The finding has been fixed, triaged as a non-issue or
	// otherwise addressed and is no longer active.
	State string `json:"state,omitempty"`

	// Vulnerability: Represents vulnerability-specific fields like CVE and
	// CVSS scores. CVE stands for Common Vulnerabilities and Exposures
	// (https://cve.mitre.org/about/)
	Vulnerability *GoogleCloudSecuritycenterV2Vulnerability `json:"vulnerability,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Access") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Finding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Finding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Geolocation: Represents a geographical
// location for a given access.
type GoogleCloudSecuritycenterV2Geolocation struct {
	// RegionCode: A CLDR.
	RegionCode string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RegionCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RegionCode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Geolocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Geolocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2IamBinding: Represents a particular IAM
// binding, which captures a member's role addition, removal, or state.
type GoogleCloudSecuritycenterV2IamBinding struct {
	// Action: The action that was performed on a Binding.
	//
	// Possible values:
	//   "ACTION_UNSPECIFIED" - Unspecified.
	//   "ADD" - Addition of a Binding.
	//   "REMOVE" - Removal of a Binding.
	Action string `json:"action,omitempty"`

	// Member: A single identity requesting access for a Cloud Platform
	// resource, for example, "foo@google.com".
	Member string `json:"member,omitempty"`

	// Role: Role that is assigned to "members". For example,
	// "roles/viewer", "roles/editor", or "roles/owner".
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2IamBinding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2IamBinding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Indicator: Represents what's commonly
// known as an _indicator of compromise_ (IoC) in computer forensics.
// This is an artifact observed on a network or in an operating system
// that, with high confidence, indicates a computer intrusion. For more
// information, see Indicator of compromise
// (https://en.wikipedia.org/wiki/Indicator_of_compromise).
type GoogleCloudSecuritycenterV2Indicator struct {
	// Domains: List of domains associated to the Finding.
	Domains []string `json:"domains,omitempty"`

	// IpAddresses: The list of IP addresses that are associated with the
	// finding.
	IpAddresses []string `json:"ipAddresses,omitempty"`

	// Signatures: The list of matched signatures indicating that the given
	// process is present in the environment.
	Signatures []*GoogleCloudSecuritycenterV2ProcessSignature `json:"signatures,omitempty"`

	// Uris: The list of URIs associated to the Findings.
	Uris []string `json:"uris,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Domains") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Domains") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Indicator) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Indicator
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2KernelRootkit: Kernel mode rootkit
// signatures.
type GoogleCloudSecuritycenterV2KernelRootkit struct {
	// Name: Rootkit name, when available.
	Name string `json:"name,omitempty"`

	// UnexpectedCodeModification: True if unexpected modifications of
	// kernel code memory are present.
	UnexpectedCodeModification bool `json:"unexpectedCodeModification,omitempty"`

	// UnexpectedFtraceHandler: True if `ftrace` points are present with
	// callbacks pointing to regions that are not in the expected kernel or
	// module code range.
	UnexpectedFtraceHandler bool `json:"unexpectedFtraceHandler,omitempty"`

	// UnexpectedInterruptHandler: True if interrupt handlers that are are
	// not in the expected kernel or module code regions are present.
	UnexpectedInterruptHandler bool `json:"unexpectedInterruptHandler,omitempty"`

	// UnexpectedKernelCodePages: True if kernel code pages that are not in
	// the expected kernel or module code regions are present.
	UnexpectedKernelCodePages bool `json:"unexpectedKernelCodePages,omitempty"`

	// UnexpectedKprobeHandler: True if `kprobe` points are present with
	// callbacks pointing to regions that are not in the expected kernel or
	// module code range.
	UnexpectedKprobeHandler bool `json:"unexpectedKprobeHandler,omitempty"`

	// UnexpectedProcessesInRunqueue: True if unexpected processes in the
	// scheduler run queue are present. Such processes are in the run queue,
	// but not in the process task list.
	UnexpectedProcessesInRunqueue bool `json:"unexpectedProcessesInRunqueue,omitempty"`

	// UnexpectedReadOnlyDataModification: True if unexpected modifications
	// of kernel read-only data memory are present.
	UnexpectedReadOnlyDataModification bool `json:"unexpectedReadOnlyDataModification,omitempty"`

	// UnexpectedSystemCallHandler: True if system call handlers that are
	// are not in the expected kernel or module code regions are present.
	UnexpectedSystemCallHandler bool `json:"unexpectedSystemCallHandler,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2KernelRootkit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2KernelRootkit
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Kubernetes: Kubernetes-related attributes.
type GoogleCloudSecuritycenterV2Kubernetes struct {
	// AccessReviews: Provides information on any Kubernetes access reviews
	// (privilege checks) relevant to the finding.
	AccessReviews []*GoogleCloudSecuritycenterV2AccessReview `json:"accessReviews,omitempty"`

	// Bindings: Provides Kubernetes role binding information for findings
	// that involve RoleBindings or ClusterRoleBindings
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
	Bindings []*GoogleCloudSecuritycenterV2Binding `json:"bindings,omitempty"`

	// NodePools: GKE node pools
	// (https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
	// associated with the finding. This field contains node pool
	// information for each node, when it is available.
	NodePools []*GoogleCloudSecuritycenterV2NodePool `json:"nodePools,omitempty"`

	// Nodes: Provides Kubernetes node
	// (https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
	// information.
	Nodes []*GoogleCloudSecuritycenterV2Node `json:"nodes,omitempty"`

	// Objects: Kubernetes objects related to the finding.
	Objects []*GoogleCloudSecuritycenterV2Object `json:"objects,omitempty"`

	// Pods: Kubernetes Pods
	// (https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
	// associated with the finding. This field contains Pod records for each
	// container that is owned by a Pod.
	Pods []*GoogleCloudSecuritycenterV2Pod `json:"pods,omitempty"`

	// Roles: Provides Kubernetes role information for findings that involve
	// Roles or ClusterRoles
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
	Roles []*GoogleCloudSecuritycenterV2Role `json:"roles,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessReviews") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessReviews") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Kubernetes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Kubernetes
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Label: Represents a generic name-value
// label. A label has separate name and value fields to support
// filtering with the `contains()` function. For more information, see
// Filtering on array-type fields
// (https://cloud.google.com/security-command-center/docs/how-to-api-list-findings#array-contains-filtering).
type GoogleCloudSecuritycenterV2Label struct {
	// Name: Name of the label.
	Name string `json:"name,omitempty"`

	// Value: Value that corresponds to the label's name.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Label) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Label
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2LoadBalancer: Contains information related
// to the load balancer associated with the finding.
type GoogleCloudSecuritycenterV2LoadBalancer struct {
	// Name: The name of the load balancer associated with the finding.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2LoadBalancer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2LoadBalancer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2LogEntry: An individual entry in a log.
type GoogleCloudSecuritycenterV2LogEntry struct {
	// CloudLoggingEntry: An individual entry in a log stored in Cloud
	// Logging.
	CloudLoggingEntry *GoogleCloudSecuritycenterV2CloudLoggingEntry `json:"cloudLoggingEntry,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CloudLoggingEntry")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CloudLoggingEntry") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2LogEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2LogEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2MemoryHashSignature: A signature
// corresponding to memory page hashes.
type GoogleCloudSecuritycenterV2MemoryHashSignature struct {
	// BinaryFamily: The binary family.
	BinaryFamily string `json:"binaryFamily,omitempty"`

	// Detections: The list of memory hash detections contributing to the
	// binary family match.
	Detections []*GoogleCloudSecuritycenterV2Detection `json:"detections,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BinaryFamily") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BinaryFamily") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2MemoryHashSignature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2MemoryHashSignature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2MitreAttack: MITRE ATT&CK tactics and
// techniques related to this finding. See: https://attack.mitre.org
type GoogleCloudSecuritycenterV2MitreAttack struct {
	// AdditionalTactics: Additional MITRE ATT&CK tactics related to this
	// finding, if any.
	//
	// Possible values:
	//   "TACTIC_UNSPECIFIED" - Unspecified value.
	//   "RECONNAISSANCE" - TA0043
	//   "RESOURCE_DEVELOPMENT" - TA0042
	//   "INITIAL_ACCESS" - TA0001
	//   "EXECUTION" - TA0002
	//   "PERSISTENCE" - TA0003
	//   "PRIVILEGE_ESCALATION" - TA0004
	//   "DEFENSE_EVASION" - TA0005
	//   "CREDENTIAL_ACCESS" - TA0006
	//   "DISCOVERY" - TA0007
	//   "LATERAL_MOVEMENT" - TA0008
	//   "COLLECTION" - TA0009
	//   "COMMAND_AND_CONTROL" - TA0011
	//   "EXFILTRATION" - TA0010
	//   "IMPACT" - TA0040
	AdditionalTactics []string `json:"additionalTactics,omitempty"`

	// AdditionalTechniques: Additional MITRE ATT&CK techniques related to
	// this finding, if any, along with any of their respective parent
	// techniques.
	//
	// Possible values:
	//   "TECHNIQUE_UNSPECIFIED" - Unspecified value.
	//   "MASQUERADING" - T1036
	//   "MATCH_LEGITIMATE_NAME_OR_LOCATION" - T1036.005
	//   "BOOT_OR_LOGON_INITIALIZATION_SCRIPTS" - T1037
	//   "STARTUP_ITEMS" - T1037.005
	//   "NETWORK_SERVICE_DISCOVERY" - T1046
	//   "PROCESS_DISCOVERY" - T1057
	//   "COMMAND_AND_SCRIPTING_INTERPRETER" - T1059
	//   "UNIX_SHELL" - T1059.004
	//   "PERMISSION_GROUPS_DISCOVERY" - T1069
	//   "CLOUD_GROUPS" - T1069.003
	//   "APPLICATION_LAYER_PROTOCOL" - T1071
	//   "DNS" - T1071.004
	//   "SOFTWARE_DEPLOYMENT_TOOLS" - T1072
	//   "VALID_ACCOUNTS" - T1078
	//   "DEFAULT_ACCOUNTS" - T1078.001
	//   "LOCAL_ACCOUNTS" - T1078.003
	//   "CLOUD_ACCOUNTS" - T1078.004
	//   "PROXY" - T1090
	//   "EXTERNAL_PROXY" - T1090.002
	//   "MULTI_HOP_PROXY" - T1090.003
	//   "ACCOUNT_MANIPULATION" - T1098
	//   "ADDITIONAL_CLOUD_CREDENTIALS" - T1098.001
	//   "SSH_AUTHORIZED_KEYS" - T1098.004
	//   "ADDITIONAL_CONTAINER_CLUSTER_ROLES" - T1098.006
	//   "INGRESS_TOOL_TRANSFER" - T1105
	//   "NATIVE_API" - T1106
	//   "BRUTE_FORCE" - T1110
	//   "SHARED_MODULES" - T1129
	//   "ACCESS_TOKEN_MANIPULATION" - T1134
	//   "TOKEN_IMPERSONATION_OR_THEFT" - T1134.001
	//   "EXPLOIT_PUBLIC_FACING_APPLICATION" - T1190
	//   "DOMAIN_POLICY_MODIFICATION" - T1484
	//   "DATA_DESTRUCTION" - T1485
	//   "SERVICE_STOP" - T1489
	//   "INHIBIT_SYSTEM_RECOVERY" - T1490
	//   "RESOURCE_HIJACKING" - T1496
	//   "NETWORK_DENIAL_OF_SERVICE" - T1498
	//   "CLOUD_SERVICE_DISCOVERY" - T1526
	//   "STEAL_APPLICATION_ACCESS_TOKEN" - T1528
	//   "ACCOUNT_ACCESS_REMOVAL" - T1531
	//   "STEAL_WEB_SESSION_COOKIE" - T1539
	//   "CREATE_OR_MODIFY_SYSTEM_PROCESS" - T1543
	//   "ABUSE_ELEVATION_CONTROL_MECHANISM" - T1548
	//   "UNSECURED_CREDENTIALS" - T1552
	//   "MODIFY_AUTHENTICATION_PROCESS" - T1556
	//   "IMPAIR_DEFENSES" - T1562
	//   "DISABLE_OR_MODIFY_TOOLS" - T1562.001
	//   "EXFILTRATION_OVER_WEB_SERVICE" - T1567
	//   "EXFILTRATION_TO_CLOUD_STORAGE" - T1567.002
	//   "DYNAMIC_RESOLUTION" - T1568
	//   "LATERAL_TOOL_TRANSFER" - T1570
	//   "MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE" - T1578
	//   "CREATE_SNAPSHOT" - T1578.001
	//   "CLOUD_INFRASTRUCTURE_DISCOVERY" - T1580
	//   "OBTAIN_CAPABILITIES" - T1588
	//   "ACTIVE_SCANNING" - T1595
	//   "SCANNING_IP_BLOCKS" - T1595.001
	//   "CONTAINER_AND_RESOURCE_DISCOVERY" - T1613
	AdditionalTechniques []string `json:"additionalTechniques,omitempty"`

	// PrimaryTactic: The MITRE ATT&CK tactic most closely represented by
	// this finding, if any.
	//
	// Possible values:
	//   "TACTIC_UNSPECIFIED" - Unspecified value.
	//   "RECONNAISSANCE" - TA0043
	//   "RESOURCE_DEVELOPMENT" - TA0042
	//   "INITIAL_ACCESS" - TA0001
	//   "EXECUTION" - TA0002
	//   "PERSISTENCE" - TA0003
	//   "PRIVILEGE_ESCALATION" - TA0004
	//   "DEFENSE_EVASION" - TA0005
	//   "CREDENTIAL_ACCESS" - TA0006
	//   "DISCOVERY" - TA0007
	//   "LATERAL_MOVEMENT" - TA0008
	//   "COLLECTION" - TA0009
	//   "COMMAND_AND_CONTROL" - TA0011
	//   "EXFILTRATION" - TA0010
	//   "IMPACT" - TA0040
	PrimaryTactic string `json:"primaryTactic,omitempty"`

	// PrimaryTechniques: The MITRE ATT&CK technique most closely
	// represented by this finding, if any. primary_techniques is a repeated
	// field because there are multiple levels of MITRE ATT&CK techniques.
	// If the technique most closely represented by this finding is a
	// sub-technique (e.g. `SCANNING_IP_BLOCKS`), both the sub-technique and
	// its parent technique(s) will be listed (e.g. `SCANNING_IP_BLOCKS`,
	// `ACTIVE_SCANNING`).
	//
	// Possible values:
	//   "TECHNIQUE_UNSPECIFIED" - Unspecified value.
	//   "MASQUERADING" - T1036
	//   "MATCH_LEGITIMATE_NAME_OR_LOCATION" - T1036.005
	//   "BOOT_OR_LOGON_INITIALIZATION_SCRIPTS" - T1037
	//   "STARTUP_ITEMS" - T1037.005
	//   "NETWORK_SERVICE_DISCOVERY" - T1046
	//   "PROCESS_DISCOVERY" - T1057
	//   "COMMAND_AND_SCRIPTING_INTERPRETER" - T1059
	//   "UNIX_SHELL" - T1059.004
	//   "PERMISSION_GROUPS_DISCOVERY" - T1069
	//   "CLOUD_GROUPS" - T1069.003
	//   "APPLICATION_LAYER_PROTOCOL" - T1071
	//   "DNS" - T1071.004
	//   "SOFTWARE_DEPLOYMENT_TOOLS" - T1072
	//   "VALID_ACCOUNTS" - T1078
	//   "DEFAULT_ACCOUNTS" - T1078.001
	//   "LOCAL_ACCOUNTS" - T1078.003
	//   "CLOUD_ACCOUNTS" - T1078.004
	//   "PROXY" - T1090
	//   "EXTERNAL_PROXY" - T1090.002
	//   "MULTI_HOP_PROXY" - T1090.003
	//   "ACCOUNT_MANIPULATION" - T1098
	//   "ADDITIONAL_CLOUD_CREDENTIALS" - T1098.001
	//   "SSH_AUTHORIZED_KEYS" - T1098.004
	//   "ADDITIONAL_CONTAINER_CLUSTER_ROLES" - T1098.006
	//   "INGRESS_TOOL_TRANSFER" - T1105
	//   "NATIVE_API" - T1106
	//   "BRUTE_FORCE" - T1110
	//   "SHARED_MODULES" - T1129
	//   "ACCESS_TOKEN_MANIPULATION" - T1134
	//   "TOKEN_IMPERSONATION_OR_THEFT" - T1134.001
	//   "EXPLOIT_PUBLIC_FACING_APPLICATION" - T1190
	//   "DOMAIN_POLICY_MODIFICATION" - T1484
	//   "DATA_DESTRUCTION" - T1485
	//   "SERVICE_STOP" - T1489
	//   "INHIBIT_SYSTEM_RECOVERY" - T1490
	//   "RESOURCE_HIJACKING" - T1496
	//   "NETWORK_DENIAL_OF_SERVICE" - T1498
	//   "CLOUD_SERVICE_DISCOVERY" - T1526
	//   "STEAL_APPLICATION_ACCESS_TOKEN" - T1528
	//   "ACCOUNT_ACCESS_REMOVAL" - T1531
	//   "STEAL_WEB_SESSION_COOKIE" - T1539
	//   "CREATE_OR_MODIFY_SYSTEM_PROCESS" - T1543
	//   "ABUSE_ELEVATION_CONTROL_MECHANISM" - T1548
	//   "UNSECURED_CREDENTIALS" - T1552
	//   "MODIFY_AUTHENTICATION_PROCESS" - T1556
	//   "IMPAIR_DEFENSES" - T1562
	//   "DISABLE_OR_MODIFY_TOOLS" - T1562.001
	//   "EXFILTRATION_OVER_WEB_SERVICE" - T1567
	//   "EXFILTRATION_TO_CLOUD_STORAGE" - T1567.002
	//   "DYNAMIC_RESOLUTION" - T1568
	//   "LATERAL_TOOL_TRANSFER" - T1570
	//   "MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE" - T1578
	//   "CREATE_SNAPSHOT" - T1578.001
	//   "CLOUD_INFRASTRUCTURE_DISCOVERY" - T1580
	//   "OBTAIN_CAPABILITIES" - T1588
	//   "ACTIVE_SCANNING" - T1595
	//   "SCANNING_IP_BLOCKS" - T1595.001
	//   "CONTAINER_AND_RESOURCE_DISCOVERY" - T1613
	PrimaryTechniques []string `json:"primaryTechniques,omitempty"`

	// Version: The MITRE ATT&CK version referenced by the above fields.
	// E.g. "8".
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalTactics")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalTactics") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2MitreAttack) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2MitreAttack
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2MuteConfig: A mute config is a Cloud SCC
// resource that contains the configuration to mute create/update events
// of findings.
type GoogleCloudSecuritycenterV2MuteConfig struct {
	// CreateTime: Output only. The time at which the mute config was
	// created. This field is set by the server and will be ignored if
	// provided on config creation.
	CreateTime string `json:"createTime,omitempty"`

	// Description: A description of the mute config.
	Description string `json:"description,omitempty"`

	// Filter: Required. An expression that defines the filter to apply
	// across create/update events of findings. While creating a filter
	// string, be mindful of the scope in which the mute configuration is
	// being created. E.g., If a filter contains project = X but is created
	// under the project = Y scope, it might not match any findings. The
	// following field and operator combinations are supported: * severity:
	// `=`, `:` * category: `=`, `:` * resource.name: `=`, `:` *
	// resource.project_name: `=`, `:` * resource.project_display_name: `=`,
	// `:` * resource.folders.resource_folder: `=`, `:` *
	// resource.parent_name: `=`, `:` * resource.parent_display_name: `=`,
	// `:` * resource.type: `=`, `:` * finding_class: `=`, `:` *
	// indicator.ip_addresses: `=`, `:` * indicator.domains: `=`, `:`
	Filter string `json:"filter,omitempty"`

	// MostRecentEditor: Output only. Email address of the user who last
	// edited the mute config. This field is set by the server and will be
	// ignored if provided on config creation or update.
	MostRecentEditor string `json:"mostRecentEditor,omitempty"`

	// Name: This field will be ignored if provided on config creation. The
	// following list shows some examples of the format: +
	// `organizations/{organization}/muteConfigs/{mute_config}` +
	// `organizations/{organization}locations/{location}//muteConfigs/{mute_c
	// onfig}` + `folders/{folder}/muteConfigs/{mute_config}` +
	// `folders/{folder}/locations/{location}/muteConfigs/{mute_config}` +
	// `projects/{project}/muteConfigs/{mute_config}` +
	// `projects/{project}/locations/{location}/muteConfigs/{mute_config}`
	Name string `json:"name,omitempty"`

	// Type: Required. The type of the mute config, which determines what
	// type of mute state the config affects. Immutable after creation.
	//
	// Possible values:
	//   "MUTE_CONFIG_TYPE_UNSPECIFIED" - Unused.
	//   "STATIC" - A static mute config, which sets the static mute state
	// of future matching findings to muted. Once the static mute state has
	// been set, finding or config modifications will not affect the state.
	Type string `json:"type,omitempty"`

	// UpdateTime: Output only. The most recent time at which the mute
	// config was updated. This field is set by the server and will be
	// ignored if provided on config creation or update.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2MuteConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2MuteConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Node: Kubernetes nodes associated with the
// finding.
type GoogleCloudSecuritycenterV2Node struct {
	// Name: Full resource name
	// (https://google.aip.dev/122#full-resource-names) of the Compute
	// Engine VM running the cluster node.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Node) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Node
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2NodePool: Provides GKE node pool
// information.
type GoogleCloudSecuritycenterV2NodePool struct {
	// Name: Kubernetes node pool name.
	Name string `json:"name,omitempty"`

	// Nodes: Nodes associated with the finding.
	Nodes []*GoogleCloudSecuritycenterV2Node `json:"nodes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2NodePool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2NodePool
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2NotificationMessage: Cloud SCC's
// Notification
type GoogleCloudSecuritycenterV2NotificationMessage struct {
	// Finding: If it's a Finding based notification config, this field will
	// be populated.
	Finding *GoogleCloudSecuritycenterV2Finding `json:"finding,omitempty"`

	// NotificationConfigName: Name of the notification config that
	// generated current notification.
	NotificationConfigName string `json:"notificationConfigName,omitempty"`

	// Resource: The Cloud resource tied to this notification's Finding.
	Resource *GoogleCloudSecuritycenterV2Resource `json:"resource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Finding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Finding") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2NotificationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2NotificationMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Object: Kubernetes object related to the
// finding, uniquely identified by GKNN. Used if the object Kind is not
// one of Pod, Node, NodePool, Binding, or AccessReview.
type GoogleCloudSecuritycenterV2Object struct {
	// Containers: Pod containers associated with this finding, if any.
	Containers []*GoogleCloudSecuritycenterV2Container `json:"containers,omitempty"`

	// Group: Kubernetes object group, such as "policy.k8s.io/v1".
	Group string `json:"group,omitempty"`

	// Kind: Kubernetes object kind, such as "Namespace".
	Kind string `json:"kind,omitempty"`

	// Name: Kubernetes object name. For details see
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/names/.
	Name string `json:"name,omitempty"`

	// Ns: Kubernetes object namespace. Must be a valid DNS label. Named
	// "ns" to avoid collision with C++ namespace keyword. For details see
	// https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
	Ns string `json:"ns,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Containers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Containers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Object) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Object
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2OrgPolicy: Contains information about the
// org policies associated with the finding.
type GoogleCloudSecuritycenterV2OrgPolicy struct {
	// Name: The resource name of the org policy. Example:
	// "organizations/{organization_id}/policies/{constraint_name}"
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2OrgPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2OrgPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Package: Package is a generic definition
// of a package.
type GoogleCloudSecuritycenterV2Package struct {
	// CpeUri: The CPE URI where the vulnerability was detected.
	CpeUri string `json:"cpeUri,omitempty"`

	// PackageName: The name of the package where the vulnerability was
	// detected.
	PackageName string `json:"packageName,omitempty"`

	// PackageType: Type of package, for example, os, maven, or go.
	PackageType string `json:"packageType,omitempty"`

	// PackageVersion: The version of the package.
	PackageVersion string `json:"packageVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CpeUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpeUri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Package) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Package
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Pod: A Kubernetes Pod.
type GoogleCloudSecuritycenterV2Pod struct {
	// Containers: Pod containers associated with this finding, if any.
	Containers []*GoogleCloudSecuritycenterV2Container `json:"containers,omitempty"`

	// Labels: Pod labels. For Kubernetes containers, these are applied to
	// the container.
	Labels []*GoogleCloudSecuritycenterV2Label `json:"labels,omitempty"`

	// Name: Kubernetes Pod name.
	Name string `json:"name,omitempty"`

	// Ns: Kubernetes Pod namespace.
	Ns string `json:"ns,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Containers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Containers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Pod) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Pod
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2PolicyDriftDetails: The policy field that
// violates the deployed posture and its expected and detected values.
type GoogleCloudSecuritycenterV2PolicyDriftDetails struct {
	// DetectedValue: The detected value that violates the deployed posture,
	// for example, `false` or `allowed_values={"projects/22831892"}`.
	DetectedValue string `json:"detectedValue,omitempty"`

	// ExpectedValue: The value of this field that was configured in a
	// posture, for example, `true` or
	// `allowed_values={"projects/29831892"}`.
	ExpectedValue string `json:"expectedValue,omitempty"`

	// Field: The name of the updated field, for example
	// constraint.implementation.policy_rules[0].enforce
	Field string `json:"field,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2PolicyDriftDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2PolicyDriftDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Process: Represents an operating system
// process.
type GoogleCloudSecuritycenterV2Process struct {
	// Args: Process arguments as JSON encoded strings.
	Args []string `json:"args,omitempty"`

	// ArgumentsTruncated: True if `args` is incomplete.
	ArgumentsTruncated bool `json:"argumentsTruncated,omitempty"`

	// Binary: File information for the process executable.
	Binary *GoogleCloudSecuritycenterV2File `json:"binary,omitempty"`

	// EnvVariables: Process environment variables.
	EnvVariables []*GoogleCloudSecuritycenterV2EnvironmentVariable `json:"envVariables,omitempty"`

	// EnvVariablesTruncated: True if `env_variables` is incomplete.
	EnvVariablesTruncated bool `json:"envVariablesTruncated,omitempty"`

	// Libraries: File information for libraries loaded by the process.
	Libraries []*GoogleCloudSecuritycenterV2File `json:"libraries,omitempty"`

	// Name: The process name, as displayed in utilities like `top` and
	// `ps`. This name can be accessed through `/proc/[pid]/comm` and
	// changed with `prctl(PR_SET_NAME)`.
	Name string `json:"name,omitempty"`

	// ParentPid: The parent process ID.
	ParentPid int64 `json:"parentPid,omitempty,string"`

	// Pid: The process ID.
	Pid int64 `json:"pid,omitempty,string"`

	// Script: When the process represents the invocation of a script,
	// `binary` provides information about the interpreter, while `script`
	// provides information about the script file provided to the
	// interpreter.
	Script *GoogleCloudSecuritycenterV2File `json:"script,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Args") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Args") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Process) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Process
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2ProcessSignature: Indicates what signature
// matched this process.
type GoogleCloudSecuritycenterV2ProcessSignature struct {
	// MemoryHashSignature: Signature indicating that a binary family was
	// matched.
	MemoryHashSignature *GoogleCloudSecuritycenterV2MemoryHashSignature `json:"memoryHashSignature,omitempty"`

	// SignatureType: Describes the type of resource associated with the
	// signature.
	//
	// Possible values:
	//   "SIGNATURE_TYPE_UNSPECIFIED" - The default signature type.
	//   "SIGNATURE_TYPE_PROCESS" - Used for signatures concerning
	// processes.
	//   "SIGNATURE_TYPE_FILE" - Used for signatures concerning disks.
	SignatureType string `json:"signatureType,omitempty"`

	// YaraRuleSignature: Signature indicating that a YARA rule was matched.
	YaraRuleSignature *GoogleCloudSecuritycenterV2YaraRuleSignature `json:"yaraRuleSignature,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MemoryHashSignature")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MemoryHashSignature") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2ProcessSignature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2ProcessSignature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Reference: Additional Links
type GoogleCloudSecuritycenterV2Reference struct {
	// Source: Source of the reference e.g. NVD
	Source string `json:"source,omitempty"`

	// Uri: Uri for the mentioned source e.g.
	// https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Source") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Source") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Reference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Reference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Resource: Information related to the
// Google Cloud resource.
type GoogleCloudSecuritycenterV2Resource struct {
	// DisplayName: The human readable name of the resource.
	DisplayName string `json:"displayName,omitempty"`

	// Name: The full resource name of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	Name string `json:"name,omitempty"`

	// Type: The full resource type of the resource.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Resource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Resource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2ResourceValueConfig: A resource value
// config (RVC) is a mapping configuration of user's resources to
// resource values. Used in Attack path simulations.
type GoogleCloudSecuritycenterV2ResourceValueConfig struct {
	// CreateTime: Output only. Timestamp this resource value config was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Description of the resource value config.
	Description string `json:"description,omitempty"`

	// Name: Name for the resource value config
	Name string `json:"name,omitempty"`

	// ResourceLabelsSelector: List of resource labels to search for,
	// evaluated with AND. E.g. "resource_labels_selector": {"key": "value",
	// "env": "prod"} will match resources with labels "key": "value" AND
	// "env": "prod"
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels
	ResourceLabelsSelector map[string]string `json:"resourceLabelsSelector,omitempty"`

	// ResourceType: Apply resource_value only to resources that match
	// resource_type. resource_type will be checked with "AND" of other
	// resources. E.g. "storage.googleapis.com/Bucket" with resource_value
	// "HIGH" will apply "HIGH" value only to
	// "storage.googleapis.com/Bucket" resources.
	ResourceType string `json:"resourceType,omitempty"`

	// ResourceValue: Resource value level this expression represents Only
	// required when there is no SDP mapping in the request
	//
	// Possible values:
	//   "RESOURCE_VALUE_UNSPECIFIED" - Unspecific value
	//   "HIGH" - High resource value
	//   "MEDIUM" - Medium resource value
	//   "LOW" - Low resource value
	//   "NONE" - No resource value, e.g. ignore these resources
	ResourceValue string `json:"resourceValue,omitempty"`

	// Scope: Project or folder to scope this config to. For example,
	// "project/456" would apply this config only to resources in
	// "project/456" scope will be checked with "AND" of other resources.
	Scope string `json:"scope,omitempty"`

	// SensitiveDataProtectionMapping: A mapping of the sensitivity on
	// Sensitive Data Protection finding to resource values. This mapping
	// can only be used in combination with a resource_type that is related
	// to BigQuery, e.g. "bigquery.googleapis.com/Dataset".
	SensitiveDataProtectionMapping *GoogleCloudSecuritycenterV2SensitiveDataProtectionMapping `json:"sensitiveDataProtectionMapping,omitempty"`

	// TagValues: Required. Tag values combined with AND to check against.
	// Values in the form "tagValues/123" E.g. [ "tagValues/123",
	// "tagValues/456", "tagValues/789" ]
	// https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing
	TagValues []string `json:"tagValues,omitempty"`

	// UpdateTime: Output only. Timestamp this resource value config was
	// last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2ResourceValueConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2ResourceValueConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Role: Kubernetes Role or ClusterRole.
type GoogleCloudSecuritycenterV2Role struct {
	// Kind: Role type.
	//
	// Possible values:
	//   "KIND_UNSPECIFIED" - Role type is not specified.
	//   "ROLE" - Kubernetes Role.
	//   "CLUSTER_ROLE" - Kubernetes ClusterRole.
	Kind string `json:"kind,omitempty"`

	// Name: Role name.
	Name string `json:"name,omitempty"`

	// Ns: Role namespace.
	Ns string `json:"ns,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Role) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Role
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2SecurityBulletin: SecurityBulletin are
// notifications of vulnerabilities of Google products.
type GoogleCloudSecuritycenterV2SecurityBulletin struct {
	// BulletinId: ID of the bulletin corresponding to the vulnerability.
	BulletinId string `json:"bulletinId,omitempty"`

	// SubmissionTime: Submission time of this Security Bulletin.
	SubmissionTime string `json:"submissionTime,omitempty"`

	// SuggestedUpgradeVersion: This represents a version that the cluster
	// receiving this notification should be upgraded to, based on its
	// current version. For example, 1.15.0
	SuggestedUpgradeVersion string `json:"suggestedUpgradeVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BulletinId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BulletinId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2SecurityBulletin) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2SecurityBulletin
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2SecurityMarks: User specified security
// marks that are attached to the parent Security Command Center
// resource. Security marks are scoped within a Security Command Center
// organization -- they can be modified and viewed by all users who have
// proper permissions on the organization.
type GoogleCloudSecuritycenterV2SecurityMarks struct {
	// CanonicalName: The canonical name of the marks. The following list
	// shows some examples: +
	// `organizations/{organization_id}/assets/{asset_id}/securityMarks" +
	// `organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}/securityMarks" +
	// `organizations/{organization_id}/sources/{source_id}/locations/{locati
	// on}/findings/{finding_id}/securityMarks" +
	// `folders/{folder_id}/assets/{asset_id}/securityMarks" +
	// `folders/{folder_id}/sources/{source_id}/findings/{finding_id}/securit
	// yMarks" +
	// `folders/{folder_id}/sources/{source_id}/locations/{location}/findings
	// /{finding_id}/securityMarks" +
	// `projects/{project_number}/assets/{asset_id}/securityMarks" +
	// `projects/{project_number}/sources/{source_id}/findings/{finding_id}/s
	// ecurityMarks" +
	// `projects/{project_number}/sources/{source_id}/locations/{location}/fi
	// ndings/{finding_id}/securityMarks"
	CanonicalName string `json:"canonicalName,omitempty"`

	// Marks: Mutable user specified security marks belonging to the parent
	// resource. Constraints are as follows: * Keys and values are treated
	// as case insensitive * Keys must be between 1 - 256 characters
	// (inclusive) * Keys must be letters, numbers, underscores, or dashes *
	// Values have leading and trailing whitespace trimmed, remaining
	// characters must be between 1 - 4096 characters (inclusive)
	Marks map[string]string `json:"marks,omitempty"`

	// Name: The relative resource name of the SecurityMarks. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// The following list shows some examples: +
	// `organizations/{organization_id}/assets/{asset_id}/securityMarks` +
	// `organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}/securityMarks` +
	// `organizations/{organization_id}/sources/{source_id}/locations/{locati
	// on}/findings/{finding_id}/securityMarks`
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2SecurityMarks) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2SecurityMarks
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2SecurityPosture: Represents a posture that
// is deployed on Google Cloud by the Security Command Center Posture
// Management service. A posture contains one or more policy sets. A
// policy set is a group of policies that enforce a set of security
// rules on Google Cloud.
type GoogleCloudSecuritycenterV2SecurityPosture struct {
	// ChangedPolicy: The name of the updated policy, for example,
	// `projects/{project_id}/policies/{constraint_name}`.
	ChangedPolicy string `json:"changedPolicy,omitempty"`

	// Name: Name of the posture, for example, `CIS-Posture`.
	Name string `json:"name,omitempty"`

	// Policy: The ID of the updated policy, for example,
	// `compute-policy-1`.
	Policy string `json:"policy,omitempty"`

	// PolicyDriftDetails: The details about a change in an updated policy
	// that violates the deployed posture.
	PolicyDriftDetails []*GoogleCloudSecuritycenterV2PolicyDriftDetails `json:"policyDriftDetails,omitempty"`

	// PolicySet: The name of the updated policy set, for example,
	// `cis-policyset`.
	PolicySet string `json:"policySet,omitempty"`

	// PostureDeployment: The name of the posture deployment, for example,
	// `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
	PostureDeployment string `json:"postureDeployment,omitempty"`

	// PostureDeploymentResource: The project, folder, or organization on
	// which the posture is deployed, for example,
	// `projects/{project_number}`.
	PostureDeploymentResource string `json:"postureDeploymentResource,omitempty"`

	// RevisionId: The version of the posture, for example, `c7cfa2a8`.
	RevisionId string `json:"revisionId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChangedPolicy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChangedPolicy") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2SecurityPosture) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2SecurityPosture
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2SensitiveDataProtectionMapping: Resource
// value mapping for Sensitive Data Protection findings If any of these
// mappings have a resource value that is not unspecified, the
// resource_value field will be ignored when reading this configuration.
type GoogleCloudSecuritycenterV2SensitiveDataProtectionMapping struct {
	// HighSensitivityMapping: Resource value mapping for high-sensitivity
	// Sensitive Data Protection findings
	//
	// Possible values:
	//   "RESOURCE_VALUE_UNSPECIFIED" - Unspecific value
	//   "HIGH" - High resource value
	//   "MEDIUM" - Medium resource value
	//   "LOW" - Low resource value
	//   "NONE" - No resource value, e.g. ignore these resources
	HighSensitivityMapping string `json:"highSensitivityMapping,omitempty"`

	// MediumSensitivityMapping: Resource value mapping for
	// medium-sensitivity Sensitive Data Protection findings
	//
	// Possible values:
	//   "RESOURCE_VALUE_UNSPECIFIED" - Unspecific value
	//   "HIGH" - High resource value
	//   "MEDIUM" - Medium resource value
	//   "LOW" - Low resource value
	//   "NONE" - No resource value, e.g. ignore these resources
	MediumSensitivityMapping string `json:"mediumSensitivityMapping,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "HighSensitivityMapping") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HighSensitivityMapping")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2SensitiveDataProtectionMapping) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2SensitiveDataProtectionMapping
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2ServiceAccountDelegationInfo: Identity
// delegation history of an authenticated service account.
type GoogleCloudSecuritycenterV2ServiceAccountDelegationInfo struct {
	// PrincipalEmail: The email address of a Google account.
	PrincipalEmail string `json:"principalEmail,omitempty"`

	// PrincipalSubject: A string representing the principal_subject
	// associated with the identity. As compared to `principal_email`,
	// supports principals that aren't associated with email addresses, such
	// as third party principals. For most identities, the format will be
	// `principal://iam.googleapis.com/{identity pool
	// name}/subjects/{subject}` except for some GKE identities
	// (GKE_WORKLOAD, FREEFORM, GKE_HUB_WORKLOAD) that are still in the
	// legacy format `serviceAccount:{identity pool name}[{subject}]`
	PrincipalSubject string `json:"principalSubject,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PrincipalEmail") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PrincipalEmail") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2ServiceAccountDelegationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2ServiceAccountDelegationInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Subject: Represents a Kubernetes subject.
type GoogleCloudSecuritycenterV2Subject struct {
	// Kind: Authentication type for the subject.
	//
	// Possible values:
	//   "AUTH_TYPE_UNSPECIFIED" - Authentication is not specified.
	//   "USER" - User with valid certificate.
	//   "SERVICEACCOUNT" - Users managed by Kubernetes API with credentials
	// stored as secrets.
	//   "GROUP" - Collection of users.
	Kind string `json:"kind,omitempty"`

	// Name: Name for the subject.
	Name string `json:"name,omitempty"`

	// Ns: Namespace for the subject.
	Ns string `json:"ns,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Subject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Subject
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2TicketInfo: Information about the ticket,
// if any, that is being used to track the resolution of the issue that
// is identified by this finding.
type GoogleCloudSecuritycenterV2TicketInfo struct {
	// Assignee: The assignee of the ticket in the ticket system.
	Assignee string `json:"assignee,omitempty"`

	// Description: The description of the ticket in the ticket system.
	Description string `json:"description,omitempty"`

	// Id: The identifier of the ticket in the ticket system.
	Id string `json:"id,omitempty"`

	// Status: The latest status of the ticket, as reported by the ticket
	// system.
	Status string `json:"status,omitempty"`

	// UpdateTime: The time when the ticket was last updated, as reported by
	// the ticket system.
	UpdateTime string `json:"updateTime,omitempty"`

	// Uri: The link to the ticket in the ticket system.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Assignee") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Assignee") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2TicketInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2TicketInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2Vulnerability: Refers to common
// vulnerability fields e.g. cve, cvss, cwe etc.
type GoogleCloudSecuritycenterV2Vulnerability struct {
	// Cve: CVE stands for Common Vulnerabilities and Exposures
	// (https://cve.mitre.org/about/)
	Cve *GoogleCloudSecuritycenterV2Cve `json:"cve,omitempty"`

	// FixedPackage: The fixed package is relevant to the finding.
	FixedPackage *GoogleCloudSecuritycenterV2Package `json:"fixedPackage,omitempty"`

	// OffendingPackage: The offending package is relevant to the finding.
	OffendingPackage *GoogleCloudSecuritycenterV2Package `json:"offendingPackage,omitempty"`

	// SecurityBulletin: The security bulletin is relevant to this finding.
	SecurityBulletin *GoogleCloudSecuritycenterV2SecurityBulletin `json:"securityBulletin,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cve") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cve") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2Vulnerability) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2Vulnerability
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV2YaraRuleSignature: A signature
// corresponding to a YARA rule.
type GoogleCloudSecuritycenterV2YaraRuleSignature struct {
	// YaraRule: The name of the YARA rule.
	YaraRule string `json:"yaraRule,omitempty"`

	// ForceSendFields is a list of field names (e.g. "YaraRule") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "YaraRule") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV2YaraRuleSignature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV2YaraRuleSignature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GroupAssetsRequest: Request message for grouping by assets.
type GroupAssetsRequest struct {
	// CompareDuration: When compare_duration is set, the GroupResult's
	// "state_change" property is updated to indicate whether the asset was
	// added, removed, or remained present during the compare_duration
	// period of time that precedes the read_time. This is the time between
	// (read_time - compare_duration) and read_time. The state change value
	// is derived based on the presence of the asset at the two points in
	// time. Intermediate state changes between the two times don't affect
	// the result. For example, the results aren't affected if the asset is
	// removed and re-created again. Possible "state_change" values when
	// compare_duration is specified: * "ADDED": indicates that the asset
	// was not present at the start of compare_duration, but present at
	// reference_time. * "REMOVED": indicates that the asset was present at
	// the start of compare_duration, but not present at reference_time. *
	// "ACTIVE": indicates that the asset was present at both the start and
	// the end of the time period defined by compare_duration and
	// reference_time. If compare_duration is not specified, then the only
	// possible state_change is "UNUSED", which will be the state_change set
	// for all assets present at read_time. If this field is set then
	// `state_change` must be a specified field in `group_by`.
	CompareDuration string `json:"compareDuration,omitempty"`

	// Filter: Expression that defines the filter to apply across assets.
	// The expression is a list of zero or more restrictions combined via
	// logical operators `AND` and `OR`. Parentheses are supported, and `OR`
	// has higher precedence than `AND`. Restrictions have the form ` ` and
	// may have a `-` character in front of them to indicate negation. The
	// fields map to those defined in the Asset resource. Examples include:
	// * name * security_center_properties.resource_name *
	// resource_properties.a_property * security_marks.marks.marka The
	// supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
	// `<=` for integer values. * `:`, meaning substring matching, for
	// strings. The supported value types are: * string literals in quotes.
	// * integer literals without quotes. * boolean literals `true` and
	// `false` without quotes. The following field and operator combinations
	// are supported: * name: `=` * update_time: `=`, `>`, `<`, `>=`, `<=`
	// Usage: This should be milliseconds since epoch or an RFC3339 string.
	// Examples: `update_time = "2019-06-10T16:07:18-07:00" `update_time =
	// 1560208038000` * create_time: `=`, `>`, `<`, `>=`, `<=` Usage: This
	// should be milliseconds since epoch or an RFC3339 string. Examples:
	// `create_time = "2019-06-10T16:07:18-07:00" `create_time =
	// 1560208038000` * iam_policy.policy_blob: `=`, `:` *
	// resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=` *
	// security_marks.marks: `=`, `:` *
	// security_center_properties.resource_name: `=`, `:` *
	// security_center_properties.resource_display_name: `=`, `:` *
	// security_center_properties.resource_type: `=`, `:` *
	// security_center_properties.resource_parent: `=`, `:` *
	// security_center_properties.resource_parent_display_name: `=`, `:` *
	// security_center_properties.resource_project: `=`, `:` *
	// security_center_properties.resource_project_display_name: `=`, `:` *
	// security_center_properties.resource_owners: `=`, `:` For example,
	// `resource_properties.size = 100` is a valid filter string. Use a
	// partial match on the empty string to filter based on a property
	// existing: `resource_properties.my_property : "" Use a negated
	// partial match on the empty string to filter based on a property not
	// existing: `-resource_properties.my_property : ""
	Filter string `json:"filter,omitempty"`

	// GroupBy: Required. Expression that defines what assets fields to use
	// for grouping. The string value should follow SQL syntax: comma
	// separated list of fields. For example:
	// "security_center_properties.resource_project,security_center_propertie
	// s.project". The following fields are supported when compare_duration
	// is not set: * security_center_properties.resource_project *
	// security_center_properties.resource_project_display_name *
	// security_center_properties.resource_type *
	// security_center_properties.resource_parent *
	// security_center_properties.resource_parent_display_name The following
	// fields are supported when compare_duration is set: *
	// security_center_properties.resource_type *
	// security_center_properties.resource_project_display_name *
	// security_center_properties.resource_parent_display_name
	GroupBy string `json:"groupBy,omitempty"`

	// PageSize: The maximum number of results to return in a single
	// response. Default is 10, minimum is 1, maximum is 1000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: The value returned by the last `GroupAssetsResponse`;
	// indicates that this is a continuation of a prior `GroupAssets` call,
	// and that the system should return the next page of data.
	PageToken string `json:"pageToken,omitempty"`

	// ReadTime: Time used as a reference point when filtering assets. The
	// filter is limited to assets existing at the supplied time and their
	// values are those at that specific time. Absence of this field will
	// default to the API's version of NOW.
	ReadTime string `json:"readTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CompareDuration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompareDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GroupAssetsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GroupAssetsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GroupAssetsResponse: Response message for grouping by assets.
type GroupAssetsResponse struct {
	// GroupByResults: Group results. There exists an element for each
	// existing unique combination of property/values. The element contains
	// a count for the number of times those specific property/values
	// appear.
	GroupByResults []*GroupResult `json:"groupByResults,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ReadTime: Time used for executing the groupBy request.
	ReadTime string `json:"readTime,omitempty"`

	// TotalSize: The total number of results matching the query.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "GroupByResults") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroupByResults") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GroupAssetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GroupAssetsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GroupFindingsRequest: Request message for grouping by findings.
type GroupFindingsRequest struct {
	// CompareDuration: When compare_duration is set, the GroupResult's
	// "state_change" attribute is updated to indicate whether the finding
	// had its state changed, the finding's state remained unchanged, or if
	// the finding was added during the compare_duration period of time that
	// precedes the read_time. This is the time between (read_time -
	// compare_duration) and read_time. The state_change value is derived
	// based on the presence and state of the finding at the two points in
	// time. Intermediate state changes between the two times don't affect
	// the result. For example, the results aren't affected if the finding
	// is made inactive and then active again. Possible "state_change"
	// values when compare_duration is specified: * "CHANGED": indicates
	// that the finding was present and matched the given filter at the
	// start of compare_duration, but changed its state at read_time. *
	// "UNCHANGED": indicates that the finding was present and matched the
	// given filter at the start of compare_duration and did not change
	// state at read_time. * "ADDED": indicates that the finding did not
	// match the given filter or was not present at the start of
	// compare_duration, but was present at read_time. * "REMOVED":
	// indicates that the finding was present and matched the filter at the
	// start of compare_duration, but did not match the filter at read_time.
	// If compare_duration is not specified, then the only possible
	// state_change is "UNUSED", which will be the state_change set for all
	// findings present at read_time. If this field is set then
	// `state_change` must be a specified field in `group_by`.
	CompareDuration string `json:"compareDuration,omitempty"`

	// Filter: Expression that defines the filter to apply across findings.
	// The expression is a list of one or more restrictions combined via
	// logical operators `AND` and `OR`. Parentheses are supported, and `OR`
	// has higher precedence than `AND`. Restrictions have the form ` ` and
	// may have a `-` character in front of them to indicate negation.
	// Examples include: * name * source_properties.a_property *
	// security_marks.marks.marka The supported operators are: * `=` for all
	// value types. * `>`, `<`, `>=`, `<=` for integer values. * `:`,
	// meaning substring matching, for strings. The supported value types
	// are: * string literals in quotes. * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes. The following
	// field and operator combinations are supported: * name: `=` * parent:
	// `=`, `:` * resource_name: `=`, `:` * state: `=`, `:` * category: `=`,
	// `:` * external_uri: `=`, `:` * event_time: `=`, `>`, `<`, `>=`, `<=`
	// Usage: This should be milliseconds since epoch or an RFC3339 string.
	// Examples: `event_time = "2019-06-10T16:07:18-07:00" `event_time =
	// 1560208038000` * severity: `=`, `:` * workflow_state: `=`, `:` *
	// security_marks.marks: `=`, `:` * source_properties: `=`, `:`, `>`,
	// `<`, `>=`, `<=` For example, `source_properties.size = 100` is a
	// valid filter string. Use a partial match on the empty string to
	// filter based on a property existing: `source_properties.my_property :
	// "" Use a negated partial match on the empty string to filter based
	// on a property not existing: `-source_properties.my_property : "" *
	// resource: * resource.name: `=`, `:` * resource.parent_name: `=`, `:`
	// * resource.parent_display_name: `=`, `:` * resource.project_name:
	// `=`, `:` * resource.project_display_name: `=`, `:` * resource.type:
	// `=`, `:`
	Filter string `json:"filter,omitempty"`

	// GroupBy: Required. Expression that defines what assets fields to use
	// for grouping (including `state_change`). The string value should
	// follow SQL syntax: comma separated list of fields. For example:
	// "parent,resource_name". The following fields are supported: *
	// resource_name * category * state * parent * severity The following
	// fields are supported when compare_duration is set: * state_change
	GroupBy string `json:"groupBy,omitempty"`

	// PageSize: The maximum number of results to return in a single
	// response. Default is 10, minimum is 1, maximum is 1000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: The value returned by the last `GroupFindingsResponse`;
	// indicates that this is a continuation of a prior `GroupFindings`
	// call, and that the system should return the next page of data.
	PageToken string `json:"pageToken,omitempty"`

	// ReadTime: Time used as a reference point when filtering findings. The
	// filter is limited to findings existing at the supplied time and their
	// values are those at that specific time. Absence of this field will
	// default to the API's version of NOW.
	ReadTime string `json:"readTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CompareDuration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompareDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GroupFindingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GroupFindingsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GroupFindingsResponse: Response message for group by findings.
type GroupFindingsResponse struct {
	// GroupByResults: Group results. There exists an element for each
	// existing unique combination of property/values. The element contains
	// a count for the number of times those specific property/values
	// appear.
	GroupByResults []*GroupResult `json:"groupByResults,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ReadTime: Time used for executing the groupBy request.
	ReadTime string `json:"readTime,omitempty"`

	// TotalSize: The total number of results matching the query.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "GroupByResults") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroupByResults") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GroupFindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GroupFindingsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GroupResult: Result containing the properties and count of a groupBy
// request.
type GroupResult struct {
	// Count: Total count of resources for the given properties.
	Count int64 `json:"count,omitempty,string"`

	// Properties: Properties matching the groupBy fields in the request.
	Properties googleapi.RawMessage `json:"properties,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GroupResult) MarshalJSON() ([]byte, error) {
	type NoMethod GroupResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IamBinding: Represents a particular IAM binding, which captures a
// member's role addition, removal, or state.
type IamBinding struct {
	// Action: The action that was performed on a Binding.
	//
	// Possible values:
	//   "ACTION_UNSPECIFIED" - Unspecified.
	//   "ADD" - Addition of a Binding.
	//   "REMOVE" - Removal of a Binding.
	Action string `json:"action,omitempty"`

	// Member: A single identity requesting access for a Cloud Platform
	// resource, for example, "foo@google.com".
	Member string `json:"member,omitempty"`

	// Role: Role that is assigned to "members". For example,
	// "roles/viewer", "roles/editor", or "roles/owner".
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IamBinding) MarshalJSON() ([]byte, error) {
	type NoMethod IamBinding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IamPolicy: Cloud IAM Policy information associated with the Google
// Cloud resource described by the Security Command Center asset. This
// information is managed and defined by the Google Cloud resource and
// cannot be modified by the user.
type IamPolicy struct {
	// PolicyBlob: The JSON representation of the Policy associated with the
	// asset. See https://cloud.google.com/iam/reference/rest/v1/Policy for
	// format details.
	PolicyBlob string `json:"policyBlob,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PolicyBlob") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PolicyBlob") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IamPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod IamPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Indicator: Represents what's commonly known as an _indicator of
// compromise_ (IoC) in computer forensics. This is an artifact observed
// on a network or in an operating system that, with high confidence,
// indicates a computer intrusion. For more information, see Indicator
// of compromise
// (https://en.wikipedia.org/wiki/Indicator_of_compromise).
type Indicator struct {
	// Domains: List of domains associated to the Finding.
	Domains []string `json:"domains,omitempty"`

	// IpAddresses: The list of IP addresses that are associated with the
	// finding.
	IpAddresses []string `json:"ipAddresses,omitempty"`

	// Signatures: The list of matched signatures indicating that the given
	// process is present in the environment.
	Signatures []*ProcessSignature `json:"signatures,omitempty"`

	// Uris: The list of URIs associated to the Findings.
	Uris []string `json:"uris,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Domains") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Domains") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Indicator) MarshalJSON() ([]byte, error) {
	type NoMethod Indicator
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// KernelRootkit: Kernel mode rootkit signatures.
type KernelRootkit struct {
	// Name: Rootkit name, when available.
	Name string `json:"name,omitempty"`

	// UnexpectedCodeModification: True if unexpected modifications of
	// kernel code memory are present.
	UnexpectedCodeModification bool `json:"unexpectedCodeModification,omitempty"`

	// UnexpectedFtraceHandler: True if `ftrace` points are present with
	// callbacks pointing to regions that are not in the expected kernel or
	// module code range.
	UnexpectedFtraceHandler bool `json:"unexpectedFtraceHandler,omitempty"`

	// UnexpectedInterruptHandler: True if interrupt handlers that are are
	// not in the expected kernel or module code regions are present.
	UnexpectedInterruptHandler bool `json:"unexpectedInterruptHandler,omitempty"`

	// UnexpectedKernelCodePages: True if kernel code pages that are not in
	// the expected kernel or module code regions are present.
	UnexpectedKernelCodePages bool `json:"unexpectedKernelCodePages,omitempty"`

	// UnexpectedKprobeHandler: True if `kprobe` points are present with
	// callbacks pointing to regions that are not in the expected kernel or
	// module code range.
	UnexpectedKprobeHandler bool `json:"unexpectedKprobeHandler,omitempty"`

	// UnexpectedProcessesInRunqueue: True if unexpected processes in the
	// scheduler run queue are present. Such processes are in the run queue,
	// but not in the process task list.
	UnexpectedProcessesInRunqueue bool `json:"unexpectedProcessesInRunqueue,omitempty"`

	// UnexpectedReadOnlyDataModification: True if unexpected modifications
	// of kernel read-only data memory are present.
	UnexpectedReadOnlyDataModification bool `json:"unexpectedReadOnlyDataModification,omitempty"`

	// UnexpectedSystemCallHandler: True if system call handlers that are
	// are not in the expected kernel or module code regions are present.
	UnexpectedSystemCallHandler bool `json:"unexpectedSystemCallHandler,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *KernelRootkit) MarshalJSON() ([]byte, error) {
	type NoMethod KernelRootkit
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Kubernetes: Kubernetes-related attributes.
type Kubernetes struct {
	// AccessReviews: Provides information on any Kubernetes access reviews
	// (privilege checks) relevant to the finding.
	AccessReviews []*AccessReview `json:"accessReviews,omitempty"`

	// Bindings: Provides Kubernetes role binding information for findings
	// that involve RoleBindings or ClusterRoleBindings
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
	Bindings []*GoogleCloudSecuritycenterV1Binding `json:"bindings,omitempty"`

	// NodePools: GKE node pools
	// (https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
	// associated with the finding. This field contains node pool
	// information for each node, when it is available.
	NodePools []*NodePool `json:"nodePools,omitempty"`

	// Nodes: Provides Kubernetes node
	// (https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
	// information.
	Nodes []*Node `json:"nodes,omitempty"`

	// Objects: Kubernetes objects related to the finding.
	Objects []*Object `json:"objects,omitempty"`

	// Pods: Kubernetes Pods
	// (https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
	// associated with the finding. This field contains Pod records for each
	// container that is owned by a Pod.
	Pods []*Pod `json:"pods,omitempty"`

	// Roles: Provides Kubernetes role information for findings that involve
	// Roles or ClusterRoles
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
	Roles []*Role `json:"roles,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessReviews") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessReviews") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Kubernetes) MarshalJSON() ([]byte, error) {
	type NoMethod Kubernetes
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Label: Represents a generic name-value label. A label has separate
// name and value fields to support filtering with the `contains()`
// function. For more information, see Filtering on array-type fields
// (https://cloud.google.com/security-command-center/docs/how-to-api-list-findings#array-contains-filtering).
type Label struct {
	// Name: Name of the label.
	Name string `json:"name,omitempty"`

	// Value: Value that corresponds to the label's name.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Label) MarshalJSON() ([]byte, error) {
	type NoMethod Label
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAssetsResponse: Response message for listing assets.
type ListAssetsResponse struct {
	// ListAssetsResults: Assets matching the list request.
	ListAssetsResults []*ListAssetsResult `json:"listAssetsResults,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ReadTime: Time used for executing the list request.
	ReadTime string `json:"readTime,omitempty"`

	// TotalSize: The total number of assets matching the query.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ListAssetsResults")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ListAssetsResults") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListAssetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAssetsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAssetsResult: Result containing the Asset and its State.
type ListAssetsResult struct {
	// Asset: Asset matching the search request.
	Asset *Asset `json:"asset,omitempty"`

	// StateChange: State change of the asset between the points in time.
	//
	// Possible values:
	//   "UNUSED" - State change is unused, this is the canonical default
	// for this enum.
	//   "ADDED" - Asset was added between the points in time.
	//   "REMOVED" - Asset was removed between the points in time.
	//   "ACTIVE" - Asset was present at both point(s) in time.
	StateChange string `json:"stateChange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Asset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Asset") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAssetsResult) MarshalJSON() ([]byte, error) {
	type NoMethod ListAssetsResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAttackPathsResponse: Response message for listing the attack
// paths for a given simulation or valued resource.
type ListAttackPathsResponse struct {
	// AttackPaths: The attack paths that the attack path simulation
	// identified.
	AttackPaths []*AttackPath `json:"attackPaths,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttackPaths") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttackPaths") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAttackPathsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAttackPathsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListBigQueryExportsResponse: Response message for listing BigQuery
// exports.
type ListBigQueryExportsResponse struct {
	// BigQueryExports: The BigQuery exports from the specified parent.
	BigQueryExports []*GoogleCloudSecuritycenterV1BigQueryExport `json:"bigQueryExports,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BigQueryExports") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigQueryExports") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListBigQueryExportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBigQueryExportsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListDescendantEventThreatDetectionCustomModulesResponse: Response for
// listing current and descendant resident Event Threat Detection custom
// modules.
type ListDescendantEventThreatDetectionCustomModulesResponse struct {
	// EventThreatDetectionCustomModules: Custom modules belonging to the
	// requested parent.
	EventThreatDetectionCustomModules []*EventThreatDetectionCustomModule `json:"eventThreatDetectionCustomModules,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "EventThreatDetectionCustomModules") to unconditionally include in
	// API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "EventThreatDetectionCustomModules") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListDescendantEventThreatDetectionCustomModulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDescendantEventThreatDetectionCustomModulesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListDescendantSecurityHealthAnalyticsCustomModulesResponse: Response
// message for listing descendant Security Health Analytics custom
// modules.
type ListDescendantSecurityHealthAnalyticsCustomModulesResponse struct {
	// NextPageToken: If not empty, indicates that there may be more custom
	// modules to be returned.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SecurityHealthAnalyticsCustomModules: Custom modules belonging to the
	// requested parent and its descendants.
	SecurityHealthAnalyticsCustomModules []*GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule `json:"securityHealthAnalyticsCustomModules,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListDescendantSecurityHealthAnalyticsCustomModulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDescendantSecurityHealthAnalyticsCustomModulesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListEffectiveEventThreatDetectionCustomModulesResponse: Response for
// listing EffectiveEventThreatDetectionCustomModules.
type ListEffectiveEventThreatDetectionCustomModulesResponse struct {
	// EffectiveEventThreatDetectionCustomModules: Effective custom modules
	// belonging to the requested parent.
	EffectiveEventThreatDetectionCustomModules []*EffectiveEventThreatDetectionCustomModule `json:"effectiveEventThreatDetectionCustomModules,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "EffectiveEventThreatDetectionCustomModules") to unconditionally
	// include in API requests. By default, fields with empty or default
	// values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "EffectiveEventThreatDetectionCustomModules") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListEffectiveEventThreatDetectionCustomModulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEffectiveEventThreatDetectionCustomModulesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListEffectiveSecurityHealthAnalyticsCustomModulesResponse: Response
// message for listing effective Security Health Analytics custom
// modules.
type ListEffectiveSecurityHealthAnalyticsCustomModulesResponse struct {
	// EffectiveSecurityHealthAnalyticsCustomModules: Effective custom
	// modules belonging to the requested parent.
	EffectiveSecurityHealthAnalyticsCustomModules []*GoogleCloudSecuritycenterV1EffectiveSecurityHealthAnalyticsCustomModule `json:"effectiveSecurityHealthAnalyticsCustomModules,omitempty"`

	// NextPageToken: If not empty, indicates that there may be more
	// effective custom modules to be returned.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "EffectiveSecurityHealthAnalyticsCustomModules") to unconditionally
	// include in API requests. By default, fields with empty or default
	// values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "EffectiveSecurityHealthAnalyticsCustomModules") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEffectiveSecurityHealthAnalyticsCustomModulesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListEventThreatDetectionCustomModulesResponse: Response for listing
// Event Threat Detection custom modules.
type ListEventThreatDetectionCustomModulesResponse struct {
	// EventThreatDetectionCustomModules: Custom modules belonging to the
	// requested parent.
	EventThreatDetectionCustomModules []*EventThreatDetectionCustomModule `json:"eventThreatDetectionCustomModules,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "EventThreatDetectionCustomModules") to unconditionally include in
	// API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "EventThreatDetectionCustomModules") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListEventThreatDetectionCustomModulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEventThreatDetectionCustomModulesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListFindingsResponse: Response message for listing findings.
type ListFindingsResponse struct {
	// ListFindingsResults: Findings matching the list request.
	ListFindingsResults []*ListFindingsResult `json:"listFindingsResults,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ReadTime: Time used for executing the list request.
	ReadTime string `json:"readTime,omitempty"`

	// TotalSize: The total number of findings matching the query.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ListFindingsResults")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ListFindingsResults") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListFindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFindingsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListFindingsResult: Result containing the Finding and its
// StateChange.
type ListFindingsResult struct {
	// Finding: Finding matching the search request.
	Finding *Finding `json:"finding,omitempty"`

	// Resource: Output only. Resource that is associated with this finding.
	Resource *Resource `json:"resource,omitempty"`

	// StateChange: State change of the finding between the points in time.
	//
	// Possible values:
	//   "UNUSED" - State change is unused, this is the canonical default
	// for this enum.
	//   "CHANGED" - The finding has changed state in some way between the
	// points in time and existed at both points.
	//   "UNCHANGED" - The finding has not changed state between the points
	// in time and existed at both points.
	//   "ADDED" - The finding was created between the points in time.
	//   "REMOVED" - The finding at timestamp does not match the filter
	// specified, but it did at timestamp - compare_duration.
	StateChange string `json:"stateChange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Finding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Finding") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListFindingsResult) MarshalJSON() ([]byte, error) {
	type NoMethod ListFindingsResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListMuteConfigsResponse: Response message for listing mute configs.
type ListMuteConfigsResponse struct {
	// MuteConfigs: The mute configs from the specified parent.
	MuteConfigs []*GoogleCloudSecuritycenterV1MuteConfig `json:"muteConfigs,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "MuteConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MuteConfigs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListMuteConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMuteConfigsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListNotificationConfigsResponse: Response message for listing
// notification configs.
type ListNotificationConfigsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// NotificationConfigs: Notification configs belonging to the requested
	// parent.
	NotificationConfigs []*NotificationConfig `json:"notificationConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListNotificationConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListNotificationConfigsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for
// Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListResourceValueConfigsResponse: Response message to list resource
// value configs
type ListResourceValueConfigsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is empty, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ResourceValueConfigs: The resource value configs from the specified
	// parent.
	ResourceValueConfigs []*GoogleCloudSecuritycenterV1ResourceValueConfig `json:"resourceValueConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListResourceValueConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListResourceValueConfigsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListSecurityHealthAnalyticsCustomModulesResponse: Response message
// for listing Security Health Analytics custom modules.
type ListSecurityHealthAnalyticsCustomModulesResponse struct {
	// NextPageToken: If not empty, indicates that there may be more custom
	// modules to be returned.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SecurityHealthAnalyticsCustomModules: Custom modules belonging to the
	// requested parent.
	SecurityHealthAnalyticsCustomModules []*GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule `json:"securityHealthAnalyticsCustomModules,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListSecurityHealthAnalyticsCustomModulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSecurityHealthAnalyticsCustomModulesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListSourcesResponse: Response message for listing sources.
type ListSourcesResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Sources: Sources belonging to the requested parent.
	Sources []*Source `json:"sources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListSourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSourcesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListValuedResourcesResponse: Response message for listing the valued
// resources for a given simulation.
type ListValuedResourcesResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TotalSize: The estimated total number of results matching the query.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ValuedResources: The valued resources that the attack path simulation
	// identified.
	ValuedResources []*ValuedResource `json:"valuedResources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListValuedResourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListValuedResourcesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LoadBalancer: Contains information related to the load balancer
// associated with the finding.
type LoadBalancer struct {
	// Name: The name of the load balancer associated with the finding.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LoadBalancer) MarshalJSON() ([]byte, error) {
	type NoMethod LoadBalancer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LogEntry: An individual entry in a log.
type LogEntry struct {
	// CloudLoggingEntry: An individual entry in a log stored in Cloud
	// Logging.
	CloudLoggingEntry *CloudLoggingEntry `json:"cloudLoggingEntry,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CloudLoggingEntry")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CloudLoggingEntry") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *LogEntry) MarshalJSON() ([]byte, error) {
	type NoMethod LogEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MemoryHashSignature: A signature corresponding to memory page hashes.
type MemoryHashSignature struct {
	// BinaryFamily: The binary family.
	BinaryFamily string `json:"binaryFamily,omitempty"`

	// Detections: The list of memory hash detections contributing to the
	// binary family match.
	Detections []*Detection `json:"detections,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BinaryFamily") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BinaryFamily") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MemoryHashSignature) MarshalJSON() ([]byte, error) {
	type NoMethod MemoryHashSignature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MitreAttack: MITRE ATT&CK tactics and techniques related to this
// finding. See: https://attack.mitre.org
type MitreAttack struct {
	// AdditionalTactics: Additional MITRE ATT&CK tactics related to this
	// finding, if any.
	//
	// Possible values:
	//   "TACTIC_UNSPECIFIED" - Unspecified value.
	//   "RECONNAISSANCE" - TA0043
	//   "RESOURCE_DEVELOPMENT" - TA0042
	//   "INITIAL_ACCESS" - TA0001
	//   "EXECUTION" - TA0002
	//   "PERSISTENCE" - TA0003
	//   "PRIVILEGE_ESCALATION" - TA0004
	//   "DEFENSE_EVASION" - TA0005
	//   "CREDENTIAL_ACCESS" - TA0006
	//   "DISCOVERY" - TA0007
	//   "LATERAL_MOVEMENT" - TA0008
	//   "COLLECTION" - TA0009
	//   "COMMAND_AND_CONTROL" - TA0011
	//   "EXFILTRATION" - TA0010
	//   "IMPACT" - TA0040
	AdditionalTactics []string `json:"additionalTactics,omitempty"`

	// AdditionalTechniques: Additional MITRE ATT&CK techniques related to
	// this finding, if any, along with any of their respective parent
	// techniques.
	//
	// Possible values:
	//   "TECHNIQUE_UNSPECIFIED" - Unspecified value.
	//   "MASQUERADING" - T1036
	//   "MATCH_LEGITIMATE_NAME_OR_LOCATION" - T1036.005
	//   "BOOT_OR_LOGON_INITIALIZATION_SCRIPTS" - T1037
	//   "STARTUP_ITEMS" - T1037.005
	//   "NETWORK_SERVICE_DISCOVERY" - T1046
	//   "PROCESS_DISCOVERY" - T1057
	//   "COMMAND_AND_SCRIPTING_INTERPRETER" - T1059
	//   "UNIX_SHELL" - T1059.004
	//   "PERMISSION_GROUPS_DISCOVERY" - T1069
	//   "CLOUD_GROUPS" - T1069.003
	//   "APPLICATION_LAYER_PROTOCOL" - T1071
	//   "DNS" - T1071.004
	//   "SOFTWARE_DEPLOYMENT_TOOLS" - T1072
	//   "VALID_ACCOUNTS" - T1078
	//   "DEFAULT_ACCOUNTS" - T1078.001
	//   "LOCAL_ACCOUNTS" - T1078.003
	//   "CLOUD_ACCOUNTS" - T1078.004
	//   "PROXY" - T1090
	//   "EXTERNAL_PROXY" - T1090.002
	//   "MULTI_HOP_PROXY" - T1090.003
	//   "ACCOUNT_MANIPULATION" - T1098
	//   "ADDITIONAL_CLOUD_CREDENTIALS" - T1098.001
	//   "SSH_AUTHORIZED_KEYS" - T1098.004
	//   "ADDITIONAL_CONTAINER_CLUSTER_ROLES" - T1098.006
	//   "INGRESS_TOOL_TRANSFER" - T1105
	//   "NATIVE_API" - T1106
	//   "BRUTE_FORCE" - T1110
	//   "SHARED_MODULES" - T1129
	//   "ACCESS_TOKEN_MANIPULATION" - T1134
	//   "TOKEN_IMPERSONATION_OR_THEFT" - T1134.001
	//   "EXPLOIT_PUBLIC_FACING_APPLICATION" - T1190
	//   "DOMAIN_POLICY_MODIFICATION" - T1484
	//   "DATA_DESTRUCTION" - T1485
	//   "SERVICE_STOP" - T1489
	//   "INHIBIT_SYSTEM_RECOVERY" - T1490
	//   "RESOURCE_HIJACKING" - T1496
	//   "NETWORK_DENIAL_OF_SERVICE" - T1498
	//   "CLOUD_SERVICE_DISCOVERY" - T1526
	//   "STEAL_APPLICATION_ACCESS_TOKEN" - T1528
	//   "ACCOUNT_ACCESS_REMOVAL" - T1531
	//   "STEAL_WEB_SESSION_COOKIE" - T1539
	//   "CREATE_OR_MODIFY_SYSTEM_PROCESS" - T1543
	//   "ABUSE_ELEVATION_CONTROL_MECHANISM" - T1548
	//   "UNSECURED_CREDENTIALS" - T1552
	//   "MODIFY_AUTHENTICATION_PROCESS" - T1556
	//   "IMPAIR_DEFENSES" - T1562
	//   "DISABLE_OR_MODIFY_TOOLS" - T1562.001
	//   "EXFILTRATION_OVER_WEB_SERVICE" - T1567
	//   "EXFILTRATION_TO_CLOUD_STORAGE" - T1567.002
	//   "DYNAMIC_RESOLUTION" - T1568
	//   "LATERAL_TOOL_TRANSFER" - T1570
	//   "MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE" - T1578
	//   "CREATE_SNAPSHOT" - T1578.001
	//   "CLOUD_INFRASTRUCTURE_DISCOVERY" - T1580
	//   "OBTAIN_CAPABILITIES" - T1588
	//   "ACTIVE_SCANNING" - T1595
	//   "SCANNING_IP_BLOCKS" - T1595.001
	//   "CONTAINER_AND_RESOURCE_DISCOVERY" - T1613
	AdditionalTechniques []string `json:"additionalTechniques,omitempty"`

	// PrimaryTactic: The MITRE ATT&CK tactic most closely represented by
	// this finding, if any.
	//
	// Possible values:
	//   "TACTIC_UNSPECIFIED" - Unspecified value.
	//   "RECONNAISSANCE" - TA0043
	//   "RESOURCE_DEVELOPMENT" - TA0042
	//   "INITIAL_ACCESS" - TA0001
	//   "EXECUTION" - TA0002
	//   "PERSISTENCE" - TA0003
	//   "PRIVILEGE_ESCALATION" - TA0004
	//   "DEFENSE_EVASION" - TA0005
	//   "CREDENTIAL_ACCESS" - TA0006
	//   "DISCOVERY" - TA0007
	//   "LATERAL_MOVEMENT" - TA0008
	//   "COLLECTION" - TA0009
	//   "COMMAND_AND_CONTROL" - TA0011
	//   "EXFILTRATION" - TA0010
	//   "IMPACT" - TA0040
	PrimaryTactic string `json:"primaryTactic,omitempty"`

	// PrimaryTechniques: The MITRE ATT&CK technique most closely
	// represented by this finding, if any. primary_techniques is a repeated
	// field because there are multiple levels of MITRE ATT&CK techniques.
	// If the technique most closely represented by this finding is a
	// sub-technique (e.g. `SCANNING_IP_BLOCKS`), both the sub-technique and
	// its parent technique(s) will be listed (e.g. `SCANNING_IP_BLOCKS`,
	// `ACTIVE_SCANNING`).
	//
	// Possible values:
	//   "TECHNIQUE_UNSPECIFIED" - Unspecified value.
	//   "MASQUERADING" - T1036
	//   "MATCH_LEGITIMATE_NAME_OR_LOCATION" - T1036.005
	//   "BOOT_OR_LOGON_INITIALIZATION_SCRIPTS" - T1037
	//   "STARTUP_ITEMS" - T1037.005
	//   "NETWORK_SERVICE_DISCOVERY" - T1046
	//   "PROCESS_DISCOVERY" - T1057
	//   "COMMAND_AND_SCRIPTING_INTERPRETER" - T1059
	//   "UNIX_SHELL" - T1059.004
	//   "PERMISSION_GROUPS_DISCOVERY" - T1069
	//   "CLOUD_GROUPS" - T1069.003
	//   "APPLICATION_LAYER_PROTOCOL" - T1071
	//   "DNS" - T1071.004
	//   "SOFTWARE_DEPLOYMENT_TOOLS" - T1072
	//   "VALID_ACCOUNTS" - T1078
	//   "DEFAULT_ACCOUNTS" - T1078.001
	//   "LOCAL_ACCOUNTS" - T1078.003
	//   "CLOUD_ACCOUNTS" - T1078.004
	//   "PROXY" - T1090
	//   "EXTERNAL_PROXY" - T1090.002
	//   "MULTI_HOP_PROXY" - T1090.003
	//   "ACCOUNT_MANIPULATION" - T1098
	//   "ADDITIONAL_CLOUD_CREDENTIALS" - T1098.001
	//   "SSH_AUTHORIZED_KEYS" - T1098.004
	//   "ADDITIONAL_CONTAINER_CLUSTER_ROLES" - T1098.006
	//   "INGRESS_TOOL_TRANSFER" - T1105
	//   "NATIVE_API" - T1106
	//   "BRUTE_FORCE" - T1110
	//   "SHARED_MODULES" - T1129
	//   "ACCESS_TOKEN_MANIPULATION" - T1134
	//   "TOKEN_IMPERSONATION_OR_THEFT" - T1134.001
	//   "EXPLOIT_PUBLIC_FACING_APPLICATION" - T1190
	//   "DOMAIN_POLICY_MODIFICATION" - T1484
	//   "DATA_DESTRUCTION" - T1485
	//   "SERVICE_STOP" - T1489
	//   "INHIBIT_SYSTEM_RECOVERY" - T1490
	//   "RESOURCE_HIJACKING" - T1496
	//   "NETWORK_DENIAL_OF_SERVICE" - T1498
	//   "CLOUD_SERVICE_DISCOVERY" - T1526
	//   "STEAL_APPLICATION_ACCESS_TOKEN" - T1528
	//   "ACCOUNT_ACCESS_REMOVAL" - T1531
	//   "STEAL_WEB_SESSION_COOKIE" - T1539
	//   "CREATE_OR_MODIFY_SYSTEM_PROCESS" - T1543
	//   "ABUSE_ELEVATION_CONTROL_MECHANISM" - T1548
	//   "UNSECURED_CREDENTIALS" - T1552
	//   "MODIFY_AUTHENTICATION_PROCESS" - T1556
	//   "IMPAIR_DEFENSES" - T1562
	//   "DISABLE_OR_MODIFY_TOOLS" - T1562.001
	//   "EXFILTRATION_OVER_WEB_SERVICE" - T1567
	//   "EXFILTRATION_TO_CLOUD_STORAGE" - T1567.002
	//   "DYNAMIC_RESOLUTION" - T1568
	//   "LATERAL_TOOL_TRANSFER" - T1570
	//   "MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE" - T1578
	//   "CREATE_SNAPSHOT" - T1578.001
	//   "CLOUD_INFRASTRUCTURE_DISCOVERY" - T1580
	//   "OBTAIN_CAPABILITIES" - T1588
	//   "ACTIVE_SCANNING" - T1595
	//   "SCANNING_IP_BLOCKS" - T1595.001
	//   "CONTAINER_AND_RESOURCE_DISCOVERY" - T1613
	PrimaryTechniques []string `json:"primaryTechniques,omitempty"`

	// Version: The MITRE ATT&CK version referenced by the above fields.
	// E.g. "8".
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalTactics")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalTactics") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *MitreAttack) MarshalJSON() ([]byte, error) {
	type NoMethod MitreAttack
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Node: Kubernetes nodes associated with the finding.
type Node struct {
	// Name: Full resource name
	// (https://google.aip.dev/122#full-resource-names) of the Compute
	// Engine VM running the cluster node.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Node) MarshalJSON() ([]byte, error) {
	type NoMethod Node
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NodePool: Provides GKE node pool information.
type NodePool struct {
	// Name: Kubernetes node pool name.
	Name string `json:"name,omitempty"`

	// Nodes: Nodes associated with the finding.
	Nodes []*Node `json:"nodes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *NodePool) MarshalJSON() ([]byte, error) {
	type NoMethod NodePool
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NotificationConfig: Cloud Security Command Center (Cloud SCC)
// notification configs. A notification config is a Cloud SCC resource
// that contains the configuration to send notifications for
// create/update events of findings, assets and etc.
type NotificationConfig struct {
	// Description: The description of the notification config (max of 1024
	// characters).
	Description string `json:"description,omitempty"`

	// Name: The relative resource name of this notification config. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example:
	// "organizations/{organization_id}/notificationConfigs/notify_public_buc
	// ket", "folders/{folder_id}/notificationConfigs/notify_public_bucket",
	// or "projects/{project_id}/notificationConfigs/notify_public_bucket".
	Name string `json:"name,omitempty"`

	// PubsubTopic: The Pub/Sub topic to send notifications to. Its format
	// is "projects/[project_id]/topics/[topic]".
	PubsubTopic string `json:"pubsubTopic,omitempty"`

	// ServiceAccount: Output only. The service account that needs
	// "pubsub.topics.publish" permission to publish to the Pub/Sub topic.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// StreamingConfig: The config for triggering streaming-based
	// notifications.
	StreamingConfig *StreamingConfig `json:"streamingConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *NotificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NotificationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Object: Kubernetes object related to the finding, uniquely identified
// by GKNN. Used if the object Kind is not one of Pod, Node, NodePool,
// Binding, or AccessReview.
type Object struct {
	// Containers: Pod containers associated with this finding, if any.
	Containers []*Container `json:"containers,omitempty"`

	// Group: Kubernetes object group, such as "policy.k8s.io/v1".
	Group string `json:"group,omitempty"`

	// Kind: Kubernetes object kind, such as "Namespace".
	Kind string `json:"kind,omitempty"`

	// Name: Kubernetes object name. For details see
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/names/.
	Name string `json:"name,omitempty"`

	// Ns: Kubernetes object namespace. Must be a valid DNS label. Named
	// "ns" to avoid collision with C++ namespace keyword. For details see
	// https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
	Ns string `json:"ns,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Containers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Containers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Object) MarshalJSON() ([]byte, error) {
	type NoMethod Object
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is
// the result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *Status `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal, successful response of the operation. If the
	// original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OrgPolicy: Contains information about the org policies associated
// with the finding.
type OrgPolicy struct {
	// Name: The resource name of the org policy. Example:
	// "organizations/{organization_id}/policies/{constraint_name}"
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrgPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod OrgPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OrganizationSettings: User specified settings that are attached to
// the Security Command Center organization.
type OrganizationSettings struct {
	// AssetDiscoveryConfig: The configuration used for Asset Discovery
	// runs.
	AssetDiscoveryConfig *AssetDiscoveryConfig `json:"assetDiscoveryConfig,omitempty"`

	// EnableAssetDiscovery: A flag that indicates if Asset Discovery should
	// be enabled. If the flag is set to `true`, then discovery of assets
	// will occur. If it is set to `false`, all historical assets will
	// remain, but discovery of future assets will not occur.
	EnableAssetDiscovery bool `json:"enableAssetDiscovery,omitempty"`

	// Name: The relative resource name of the settings. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example: "organizations/{organization_id}/organizationSettings".
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AssetDiscoveryConfig") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetDiscoveryConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrganizationSettings) MarshalJSON() ([]byte, error) {
	type NoMethod OrganizationSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Package: Package is a generic definition of a package.
type Package struct {
	// CpeUri: The CPE URI where the vulnerability was detected.
	CpeUri string `json:"cpeUri,omitempty"`

	// PackageName: The name of the package where the vulnerability was
	// detected.
	PackageName string `json:"packageName,omitempty"`

	// PackageType: Type of package, for example, os, maven, or go.
	PackageType string `json:"packageType,omitempty"`

	// PackageVersion: The version of the package.
	PackageVersion string `json:"packageVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CpeUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpeUri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Package) MarshalJSON() ([]byte, error) {
	type NoMethod Package
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PathNodeAssociatedFinding: A finding that is associated with this
// node in the attack path.
type PathNodeAssociatedFinding struct {
	// CanonicalFinding: Canonical name of the associated findings. Example:
	// organizations/123/sources/456/findings/789
	CanonicalFinding string `json:"canonicalFinding,omitempty"`

	// FindingCategory: The additional taxonomy group within findings from a
	// given source.
	FindingCategory string `json:"findingCategory,omitempty"`

	// Name: Full resource name of the finding.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalFinding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalFinding") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PathNodeAssociatedFinding) MarshalJSON() ([]byte, error) {
	type NoMethod PathNodeAssociatedFinding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Pod: A Kubernetes Pod.
type Pod struct {
	// Containers: Pod containers associated with this finding, if any.
	Containers []*Container `json:"containers,omitempty"`

	// Labels: Pod labels. For Kubernetes containers, these are applied to
	// the container.
	Labels []*Label `json:"labels,omitempty"`

	// Name: Kubernetes Pod name.
	Name string `json:"name,omitempty"`

	// Ns: Kubernetes Pod namespace.
	Ns string `json:"ns,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Containers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Containers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Pod) MarshalJSON() ([]byte, error) {
	type NoMethod Pod
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which
// specifies access controls for Google Cloud resources. A `Policy` is a
// collection of `bindings`. A `binding` binds one or more `members`, or
// principals, to a single `role`. Principals can be user accounts,
// service accounts, Google groups, and domains (such as G Suite). A
// `role` is a named list of permissions; each `role` can be an IAM
// predefined role or a user-created custom role. For some types of
// Google Cloud resources, a `binding` can also specify a `condition`,
// which is a logical expression that allows access to a resource only
// if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or
// both. To learn which resources support conditions in their IAM
// policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
// **JSON example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com",
// "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, {
// "role": "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ],
// "etag": "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ```
// bindings: - members: - user:mike@example.com -
// group:admins@example.com - domain:google.com -
// serviceAccount:my-project-id@appspot.gserviceaccount.com role:
// roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access
// after Sep 2020 expression: request.time <
// timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3
// ``` For a description of IAM and its features, see the IAM
// documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this
	// policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`

	// Bindings: Associates a list of `members`, or principals, with a
	// `role`. Optionally, may specify a `condition` that determines how and
	// when the `bindings` are applied. Each of the `bindings` must contain
	// at least one principal. The `bindings` in a `Policy` can refer to up
	// to 1,500 principals; up to 250 of these principals can be Google
	// groups. Each occurrence of a principal counts towards these limits.
	// For example, if the `bindings` grant 50 different roles to
	// `user:alice@example.com`, and not to any other principal, then you
	// can add another 1,450 principals to the `bindings` in the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`

	// Etag: `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a policy from overwriting each
	// other. It is strongly suggested that systems make use of the `etag`
	// in the read-modify-write cycle to perform policy updates in order to
	// avoid race conditions: An `etag` is returned in the response to
	// `getIamPolicy`, and systems are expected to put that etag in the
	// request to `setIamPolicy` to ensure that their change will be applied
	// to the same version of the policy. **Important:** If you use IAM
	// Conditions, you must include the `etag` field whenever you call
	// `setIamPolicy`. If you omit this field, then IAM allows you to
	// overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`

	// Version: Specifies the format of the policy. Valid values are `0`,
	// `1`, and `3`. Requests that specify an invalid value are rejected.
	// Any operation that affects conditional role bindings must specify
	// version `3`. This requirement applies to the following operations: *
	// Getting a policy that includes a conditional role binding * Adding a
	// conditional role binding to a policy * Changing a conditional role
	// binding in a policy * Removing any role binding, with or without a
	// condition, from a policy that includes conditions **Important:** If
	// you use IAM Conditions, you must include the `etag` field whenever
	// you call `setIamPolicy`. If you omit this field, then IAM allows you
	// to overwrite a version `3` policy with a version `1` policy, and all
	// of the conditions in the version `3` policy are lost. If a policy
	// does not include any conditions, operations on that policy may
	// specify any valid version or leave the field unset. To learn which
	// resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditConfigs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PolicyDriftDetails: The policy field that violates the deployed
// posture and its expected and detected values.
type PolicyDriftDetails struct {
	// DetectedValue: The detected value that violates the deployed posture,
	// for example, `false` or `allowed_values={"projects/22831892"}`.
	DetectedValue string `json:"detectedValue,omitempty"`

	// ExpectedValue: The value of this field that was configured in a
	// posture, for example, `true` or
	// `allowed_values={"projects/29831892"}`.
	ExpectedValue string `json:"expectedValue,omitempty"`

	// Field: The name of the updated field, for example
	// constraint.implementation.policy_rules[0].enforce
	Field string `json:"field,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PolicyDriftDetails) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyDriftDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Position: A position in the uploaded text version of a module.
type Position struct {
	ColumnNumber int64 `json:"columnNumber,omitempty"`

	LineNumber int64 `json:"lineNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ColumnNumber") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ColumnNumber") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Position) MarshalJSON() ([]byte, error) {
	type NoMethod Position
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Process: Represents an operating system process.
type Process struct {
	// Args: Process arguments as JSON encoded strings.
	Args []string `json:"args,omitempty"`

	// ArgumentsTruncated: True if `args` is incomplete.
	ArgumentsTruncated bool `json:"argumentsTruncated,omitempty"`

	// Binary: File information for the process executable.
	Binary *File `json:"binary,omitempty"`

	// EnvVariables: Process environment variables.
	EnvVariables []*EnvironmentVariable `json:"envVariables,omitempty"`

	// EnvVariablesTruncated: True if `env_variables` is incomplete.
	EnvVariablesTruncated bool `json:"envVariablesTruncated,omitempty"`

	// Libraries: File information for libraries loaded by the process.
	Libraries []*File `json:"libraries,omitempty"`

	// Name: The process name, as displayed in utilities like `top` and
	// `ps`. This name can be accessed through `/proc/[pid]/comm` and
	// changed with `prctl(PR_SET_NAME)`.
	Name string `json:"name,omitempty"`

	// ParentPid: The parent process ID.
	ParentPid int64 `json:"parentPid,omitempty,string"`

	// Pid: The process ID.
	Pid int64 `json:"pid,omitempty,string"`

	// Script: When the process represents the invocation of a script,
	// `binary` provides information about the interpreter, while `script`
	// provides information about the script file provided to the
	// interpreter.
	Script *File `json:"script,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Args") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Args") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Process) MarshalJSON() ([]byte, error) {
	type NoMethod Process
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ProcessSignature: Indicates what signature matched this process.
type ProcessSignature struct {
	// MemoryHashSignature: Signature indicating that a binary family was
	// matched.
	MemoryHashSignature *MemoryHashSignature `json:"memoryHashSignature,omitempty"`

	// SignatureType: Describes the type of resource associated with the
	// signature.
	//
	// Possible values:
	//   "SIGNATURE_TYPE_UNSPECIFIED" - The default signature type.
	//   "SIGNATURE_TYPE_PROCESS" - Used for signatures concerning
	// processes.
	//   "SIGNATURE_TYPE_FILE" - Used for signatures concerning disks.
	SignatureType string `json:"signatureType,omitempty"`

	// YaraRuleSignature: Signature indicating that a YARA rule was matched.
	YaraRuleSignature *YaraRuleSignature `json:"yaraRuleSignature,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MemoryHashSignature")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MemoryHashSignature") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ProcessSignature) MarshalJSON() ([]byte, error) {
	type NoMethod ProcessSignature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Reference: Additional Links
type Reference struct {
	// Source: Source of the reference e.g. NVD
	Source string `json:"source,omitempty"`

	// Uri: Uri for the mentioned source e.g.
	// https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Source") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Source") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Reference) MarshalJSON() ([]byte, error) {
	type NoMethod Reference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Resource: Information related to the Google Cloud resource that is
// associated with this finding.
type Resource struct {
	// DisplayName: The human readable name of the resource.
	DisplayName string `json:"displayName,omitempty"`

	// Folders: Contains a Folder message for each folder in the assets
	// ancestry. The first folder is the deepest nested folder, and the last
	// folder is the folder directly under the Organization.
	Folders []*Folder `json:"folders,omitempty"`

	// Name: The full resource name of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	Name string `json:"name,omitempty"`

	// ParentDisplayName: The human readable name of resource's parent.
	ParentDisplayName string `json:"parentDisplayName,omitempty"`

	// ParentName: The full resource name of resource's parent.
	ParentName string `json:"parentName,omitempty"`

	// ProjectDisplayName: The project ID that the resource belongs to.
	ProjectDisplayName string `json:"projectDisplayName,omitempty"`

	// ProjectName: The full resource name of project that the resource
	// belongs to.
	ProjectName string `json:"projectName,omitempty"`

	// Type: The full resource type of the resource.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Resource) MarshalJSON() ([]byte, error) {
	type NoMethod Resource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResourceValueConfigMetadata: Metadata about a ResourceValueConfig.
// For example, id and name.
type ResourceValueConfigMetadata struct {
	// Name: Resource value config name
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResourceValueConfigMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceValueConfigMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Role: Kubernetes Role or ClusterRole.
type Role struct {
	// Kind: Role type.
	//
	// Possible values:
	//   "KIND_UNSPECIFIED" - Role type is not specified.
	//   "ROLE" - Kubernetes Role.
	//   "CLUSTER_ROLE" - Kubernetes ClusterRole.
	Kind string `json:"kind,omitempty"`

	// Name: Role name.
	Name string `json:"name,omitempty"`

	// Ns: Role namespace.
	Ns string `json:"ns,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Role) MarshalJSON() ([]byte, error) {
	type NoMethod Role
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RunAssetDiscoveryRequest: Request message for running asset discovery
// for an organization.
type RunAssetDiscoveryRequest struct {
}

// SecurityBulletin: SecurityBulletin are notifications of
// vulnerabilities of Google products.
type SecurityBulletin struct {
	// BulletinId: ID of the bulletin corresponding to the vulnerability.
	BulletinId string `json:"bulletinId,omitempty"`

	// SubmissionTime: Submission time of this Security Bulletin.
	SubmissionTime string `json:"submissionTime,omitempty"`

	// SuggestedUpgradeVersion: This represents a version that the cluster
	// receiving this notification should be upgraded to, based on its
	// current version. For example, 1.15.0
	SuggestedUpgradeVersion string `json:"suggestedUpgradeVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BulletinId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BulletinId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SecurityBulletin) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityBulletin
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecurityCenterProperties: Security Command Center managed properties.
// These properties are managed by Security Command Center and cannot be
// modified by the user.
type SecurityCenterProperties struct {
	// Folders: Contains a Folder message for each folder in the assets
	// ancestry. The first folder is the deepest nested folder, and the last
	// folder is the folder directly under the Organization.
	Folders []*Folder `json:"folders,omitempty"`

	// ResourceDisplayName: The user defined display name for this resource.
	ResourceDisplayName string `json:"resourceDisplayName,omitempty"`

	// ResourceName: The full resource name of the Google Cloud resource
	// this asset represents. This field is immutable after create time.
	// See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceName string `json:"resourceName,omitempty"`

	// ResourceOwners: Owners of the Google Cloud resource.
	ResourceOwners []string `json:"resourceOwners,omitempty"`

	// ResourceParent: The full resource name of the immediate parent of the
	// resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceParent string `json:"resourceParent,omitempty"`

	// ResourceParentDisplayName: The user defined display name for the
	// parent of this resource.
	ResourceParentDisplayName string `json:"resourceParentDisplayName,omitempty"`

	// ResourceProject: The full resource name of the project the resource
	// belongs to. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceProject string `json:"resourceProject,omitempty"`

	// ResourceProjectDisplayName: The user defined display name for the
	// project of this resource.
	ResourceProjectDisplayName string `json:"resourceProjectDisplayName,omitempty"`

	// ResourceType: The type of the Google Cloud resource. Examples
	// include: APPLICATION, PROJECT, and ORGANIZATION. This is a case
	// insensitive field defined by Security Command Center and/or the
	// producer of the resource and is immutable after create time.
	ResourceType string `json:"resourceType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Folders") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Folders") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SecurityCenterProperties) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityCenterProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecurityMarks: User specified security marks that are attached to the
// parent Security Command Center resource. Security marks are scoped
// within a Security Command Center organization -- they can be modified
// and viewed by all users who have proper permissions on the
// organization.
type SecurityMarks struct {
	// CanonicalName: The canonical name of the marks. Examples:
	// "organizations/{organization_id}/assets/{asset_id}/securityMarks"
	// "folders/{folder_id}/assets/{asset_id}/securityMarks"
	// "projects/{project_number}/assets/{asset_id}/securityMarks"
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}/securityMarks"
	// "folders/{folder_id}/sources/{source_id}/findings/{finding_id}/securit
	// yMarks"
	// "projects/{project_number}/sources/{source_id}/findings/{finding_id}/s
	// ecurityMarks"
	CanonicalName string `json:"canonicalName,omitempty"`

	// Marks: Mutable user specified security marks belonging to the parent
	// resource. Constraints are as follows: * Keys and values are treated
	// as case insensitive * Keys must be between 1 - 256 characters
	// (inclusive) * Keys must be letters, numbers, underscores, or dashes *
	// Values have leading and trailing whitespace trimmed, remaining
	// characters must be between 1 - 4096 characters (inclusive)
	Marks map[string]string `json:"marks,omitempty"`

	// Name: The relative resource name of the SecurityMarks. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Examples:
	// "organizations/{organization_id}/assets/{asset_id}/securityMarks"
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}/securityMarks".
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CanonicalName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SecurityMarks) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityMarks
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecurityPosture: Represents a posture that is deployed on Google
// Cloud by the Security Command Center Posture Management service. A
// posture contains one or more policy sets. A policy set is a group of
// policies that enforce a set of security rules on Google Cloud.
type SecurityPosture struct {
	// ChangedPolicy: The name of the updated policy, for example,
	// `projects/{project_id}/policies/{constraint_name}`.
	ChangedPolicy string `json:"changedPolicy,omitempty"`

	// Name: Name of the posture, for example, `CIS-Posture`.
	Name string `json:"name,omitempty"`

	// Policy: The ID of the updated policy, for example,
	// `compute-policy-1`.
	Policy string `json:"policy,omitempty"`

	// PolicyDriftDetails: The details about a change in an updated policy
	// that violates the deployed posture.
	PolicyDriftDetails []*PolicyDriftDetails `json:"policyDriftDetails,omitempty"`

	// PolicySet: The name of the updated policyset, for example,
	// `cis-policyset`.
	PolicySet string `json:"policySet,omitempty"`

	// PostureDeployment: The name of the posture deployment, for example,
	// `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
	PostureDeployment string `json:"postureDeployment,omitempty"`

	// PostureDeploymentResource: The project, folder, or organization on
	// which the posture is deployed, for example,
	// `projects/{project_number}`.
	PostureDeploymentResource string `json:"postureDeploymentResource,omitempty"`

	// RevisionId: The version of the posture, for example, `c7cfa2a8`.
	RevisionId string `json:"revisionId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChangedPolicy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChangedPolicy") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SecurityPosture) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityPosture
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ServiceAccountDelegationInfo: Identity delegation history of an
// authenticated service account.
type ServiceAccountDelegationInfo struct {
	// PrincipalEmail: The email address of a Google account.
	PrincipalEmail string `json:"principalEmail,omitempty"`

	// PrincipalSubject: A string representing the principal_subject
	// associated with the identity. As compared to `principal_email`,
	// supports principals that aren't associated with email addresses, such
	// as third party principals. For most identities, the format will be
	// `principal://iam.googleapis.com/{identity pool
	// name}/subjects/{subject}` except for some GKE identities
	// (GKE_WORKLOAD, FREEFORM, GKE_HUB_WORKLOAD) that are still in the
	// legacy format `serviceAccount:{identity pool name}[{subject}]`
	PrincipalSubject string `json:"principalSubject,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PrincipalEmail") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PrincipalEmail") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ServiceAccountDelegationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceAccountDelegationInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SetFindingStateRequest: Request message for updating a finding's
// state.
type SetFindingStateRequest struct {
	// StartTime: Required. The time at which the updated state takes
	// effect.
	StartTime string `json:"startTime,omitempty"`

	// State: Required. The desired State of the finding.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - The finding requires attention and has not been
	// addressed yet.
	//   "INACTIVE" - The finding has been fixed, triaged as a non-issue or
	// otherwise addressed and is no longer active.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "StartTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "StartTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SetFindingStateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetFindingStateRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the
	// `resource`. The size of the policy is limited to a few 10s of KB. An
	// empty policy is a valid policy but certain Google Cloud services
	// (such as Projects) might reject them.
	Policy *Policy `json:"policy,omitempty"`

	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the
	// policy to modify. Only the fields in the mask will be modified. If no
	// mask is provided, the following default mask is used: `paths:
	// "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Policy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SetMuteRequest: Request message for updating a finding's mute status.
type SetMuteRequest struct {
	// Mute: Required. The desired state of the Mute.
	//
	// Possible values:
	//   "MUTE_UNSPECIFIED" - Unspecified.
	//   "MUTED" - Finding has been muted.
	//   "UNMUTED" - Finding has been unmuted.
	//   "UNDEFINED" - Finding has never been muted/unmuted.
	Mute string `json:"mute,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Mute") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Mute") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SetMuteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetMuteRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SimulateSecurityHealthAnalyticsCustomModuleRequest: Request message
// to simulate a CustomConfig against a given test resource. Maximum
// size of the request is 4 MB by default.
type SimulateSecurityHealthAnalyticsCustomModuleRequest struct {
	// CustomConfig: Required. The custom configuration that you need to
	// test.
	CustomConfig *GoogleCloudSecuritycenterV1CustomConfig `json:"customConfig,omitempty"`

	// Resource: Required. Resource data to simulate custom module against.
	Resource *SimulatedResource `json:"resource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SimulateSecurityHealthAnalyticsCustomModuleRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SimulateSecurityHealthAnalyticsCustomModuleRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SimulateSecurityHealthAnalyticsCustomModuleResponse: Response message
// for simulating a `SecurityHealthAnalyticsCustomModule` against a
// given resource.
type SimulateSecurityHealthAnalyticsCustomModuleResponse struct {
	// Result: Result for test case in the corresponding request.
	Result *SimulatedResult `json:"result,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Result") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SimulateSecurityHealthAnalyticsCustomModuleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SimulateSecurityHealthAnalyticsCustomModuleResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SimulatedResource: Manually constructed resource name. If the custom
// module evaluates against only the resource data, you can omit the
// `iam_policy_data` field. If it evaluates only the `iam_policy_data`
// field, you can omit the resource data.
type SimulatedResource struct {
	// IamPolicyData: Optional. A representation of the IAM policy.
	IamPolicyData *Policy `json:"iamPolicyData,omitempty"`

	// ResourceData: Optional. A representation of the Google Cloud
	// resource. Should match the Google Cloud resource JSON format.
	ResourceData googleapi.RawMessage `json:"resourceData,omitempty"`

	// ResourceType: Required. The type of the resource, for example,
	// `compute.googleapis.com/Disk`.
	ResourceType string `json:"resourceType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IamPolicyData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IamPolicyData") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SimulatedResource) MarshalJSON() ([]byte, error) {
	type NoMethod SimulatedResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SimulatedResult: Possible test result.
type SimulatedResult struct {
	// Error: Error encountered during the test.
	Error *Status `json:"error,omitempty"`

	// Finding: Finding that would be published for the test case, if a
	// violation is detected.
	Finding *Finding `json:"finding,omitempty"`

	// NoViolation: Indicates that the test case does not trigger any
	// violation.
	NoViolation *Empty `json:"noViolation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Error") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SimulatedResult) MarshalJSON() ([]byte, error) {
	type NoMethod SimulatedResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Simulation: Attack path simulation
type Simulation struct {
	// CreateTime: Output only. Time simulation was created
	CreateTime string `json:"createTime,omitempty"`

	// Name: Full resource name of the Simulation:
	// organizations/123/simulations/456
	Name string `json:"name,omitempty"`

	// ResourceValueConfigsMetadata: Resource value configurations' metadata
	// used in this simulation. Maximum of 100.
	ResourceValueConfigsMetadata []*ResourceValueConfigMetadata `json:"resourceValueConfigsMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Simulation) MarshalJSON() ([]byte, error) {
	type NoMethod Simulation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Source: Security Command Center finding source. A finding source is
// an entity or a mechanism that can produce a finding. A source is like
// a container of findings that come from the same scanner, logger,
// monitor, and other tools.
type Source struct {
	// CanonicalName: The canonical name of the finding source. It's either
	// "organizations/{organization_id}/sources/{source_id}",
	// "folders/{folder_id}/sources/{source_id}", or
	// "projects/{project_number}/sources/{source_id}", depending on the
	// closest CRM ancestor of the resource associated with the finding.
	CanonicalName string `json:"canonicalName,omitempty"`

	// Description: The description of the source (max of 1024 characters).
	// Example: "Web Security Scanner is a web security scanner for common
	// vulnerabilities in App Engine applications. It can automatically scan
	// and detect four common vulnerabilities, including
	// cross-site-scripting (XSS), Flash injection, mixed content (HTTP in
	// HTTPS), and outdated or insecure libraries."
	Description string `json:"description,omitempty"`

	// DisplayName: The source's display name. A source's display name must
	// be unique amongst its siblings, for example, two sources with the
	// same parent can't share the same display name. The display name must
	// have a length between 1 and 64 characters (inclusive).
	DisplayName string `json:"displayName,omitempty"`

	// Name: The relative resource name of this source. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example: "organizations/{organization_id}/sources/{source_id}"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CanonicalName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Source) MarshalJSON() ([]byte, error) {
	type NoMethod Source
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StreamingConfig: The config for streaming-based notifications, which
// send each event as soon as it is detected.
type StreamingConfig struct {
	// Filter: Expression that defines the filter to apply across
	// create/update events of assets or findings as specified by the event
	// type. The expression is a list of zero or more restrictions combined
	// via logical operators `AND` and `OR`. Parentheses are supported, and
	// `OR` has higher precedence than `AND`. Restrictions have the form ` `
	// and may have a `-` character in front of them to indicate negation.
	// The fields map to those defined in the corresponding resource. The
	// supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
	// `<=` for integer values. * `:`, meaning substring matching, for
	// strings. The supported value types are: * string literals in quotes.
	// * integer literals without quotes. * boolean literals `true` and
	// `false` without quotes.
	Filter string `json:"filter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *StreamingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod StreamingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Subject: Represents a Kubernetes subject.
type Subject struct {
	// Kind: Authentication type for the subject.
	//
	// Possible values:
	//   "AUTH_TYPE_UNSPECIFIED" - Authentication is not specified.
	//   "USER" - User with valid certificate.
	//   "SERVICEACCOUNT" - Users managed by Kubernetes API with credentials
	// stored as secrets.
	//   "GROUP" - Collection of users.
	Kind string `json:"kind,omitempty"`

	// Name: Name for the subject.
	Name string `json:"name,omitempty"`

	// Ns: Namespace for the subject.
	Ns string `json:"ns,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Subject) MarshalJSON() ([]byte, error) {
	type NoMethod Subject
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions`
// method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`.
	// Permissions with wildcards (such as `*` or `storage.*`) are not
	// allowed. For more information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that
	// the caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TicketInfo: Information about the ticket, if any, that is being used
// to track the resolution of the issue that is identified by this
// finding.
type TicketInfo struct {
	// Assignee: The assignee of the ticket in the ticket system.
	Assignee string `json:"assignee,omitempty"`

	// Description: The description of the ticket in the ticket system.
	Description string `json:"description,omitempty"`

	// Id: The identifier of the ticket in the ticket system.
	Id string `json:"id,omitempty"`

	// Status: The latest status of the ticket, as reported by the ticket
	// system.
	Status string `json:"status,omitempty"`

	// UpdateTime: The time when the ticket was last updated, as reported by
	// the ticket system.
	UpdateTime string `json:"updateTime,omitempty"`

	// Uri: The link to the ticket in the ticket system.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Assignee") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Assignee") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TicketInfo) MarshalJSON() ([]byte, error) {
	type NoMethod TicketInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ValidateEventThreatDetectionCustomModuleRequest: Request to validate
// an Event Threat Detection custom module.
type ValidateEventThreatDetectionCustomModuleRequest struct {
	// RawText: Required. The raw text of the module's contents. Used to
	// generate error messages.
	RawText string `json:"rawText,omitempty"`

	// Type: Required. The type of the module (e.g. CONFIGURABLE_BAD_IP).
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RawText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RawText") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ValidateEventThreatDetectionCustomModuleRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ValidateEventThreatDetectionCustomModuleRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ValidateEventThreatDetectionCustomModuleResponse: Response to
// validating an Event Threat Detection custom module.
type ValidateEventThreatDetectionCustomModuleResponse struct {
	// Errors: A list of errors returned by the validator. If the list is
	// empty, there were no errors.
	Errors *CustomModuleValidationErrors `json:"errors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Errors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ValidateEventThreatDetectionCustomModuleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ValidateEventThreatDetectionCustomModuleResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ValuedResource: A resource that is determined to have value to a
// user's system
type ValuedResource struct {
	// DisplayName: Human-readable name of the valued resource.
	DisplayName string `json:"displayName,omitempty"`

	// ExposedScore: Exposed score for this valued resource. A value of 0
	// means no exposure was detected exposure.
	ExposedScore float64 `json:"exposedScore,omitempty"`

	// Name: Valued resource name, for example, e.g.:
	// `organizations/123/simulations/456/valuedResources/789`
	Name string `json:"name,omitempty"`

	// Resource: The full resource name
	// (https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// of the valued resource.
	Resource string `json:"resource,omitempty"`

	// ResourceType: The resource type
	// (https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// of the valued resource.
	ResourceType string `json:"resourceType,omitempty"`

	// ResourceValue: How valuable this resource is.
	//
	// Possible values:
	//   "RESOURCE_VALUE_UNSPECIFIED" - The resource value isn't specified.
	//   "RESOURCE_VALUE_LOW" - This is a low-value resource.
	//   "RESOURCE_VALUE_MEDIUM" - This is a medium-value resource.
	//   "RESOURCE_VALUE_HIGH" - This is a high-value resource.
	ResourceValue string `json:"resourceValue,omitempty"`

	// ResourceValueConfigsUsed: List of resource value configurations'
	// metadata used to determine the value of this resource. Maximum of
	// 100.
	ResourceValueConfigsUsed []*ResourceValueConfigMetadata `json:"resourceValueConfigsUsed,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ValuedResource) MarshalJSON() ([]byte, error) {
	type NoMethod ValuedResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *ValuedResource) UnmarshalJSON(data []byte) error {
	type NoMethod ValuedResource
	var s1 struct {
		ExposedScore gensupport.JSONFloat64 `json:"exposedScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ExposedScore = float64(s1.ExposedScore)
	return nil
}

// Vulnerability: Refers to common vulnerability fields e.g. cve, cvss,
// cwe etc.
type Vulnerability struct {
	// Cve: CVE stands for Common Vulnerabilities and Exposures
	// (https://cve.mitre.org/about/)
	Cve *Cve `json:"cve,omitempty"`

	// FixedPackage: The fixed package is relevant to the finding.
	FixedPackage *Package `json:"fixedPackage,omitempty"`

	// OffendingPackage: The offending package is relevant to the finding.
	OffendingPackage *Package `json:"offendingPackage,omitempty"`

	// SecurityBulletin: The security bulletin is relevant to this finding.
	SecurityBulletin *SecurityBulletin `json:"securityBulletin,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cve") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cve") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Vulnerability) MarshalJSON() ([]byte, error) {
	type NoMethod Vulnerability
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// YaraRuleSignature: A signature corresponding to a YARA rule.
type YaraRuleSignature struct {
	// YaraRule: The name of the YARA rule.
	YaraRule string `json:"yaraRule,omitempty"`

	// ForceSendFields is a list of field names (e.g. "YaraRule") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "YaraRule") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *YaraRuleSignature) MarshalJSON() ([]byte, error) {
	type NoMethod YaraRuleSignature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "securitycenter.folders.assets.group":

type FoldersAssetsGroupCall struct {
	s                  *Service
	parent             string
	groupassetsrequest *GroupAssetsRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Group: Filters an organization's assets and groups them by their
// specified properties.
//
//   - parent: The name of the parent to group the assets by. Its format
//     is "organizations/[organization_id]", "folders/[folder_id]", or
//     "projects/[project_id]".
func (r *FoldersAssetsService) Group(parent string, groupassetsrequest *GroupAssetsRequest) *FoldersAssetsGroupCall {
	c := &FoldersAssetsGroupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.groupassetsrequest = groupassetsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersAssetsGroupCall) Fields(s ...googleapi.Field) *FoldersAssetsGroupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersAssetsGroupCall) Context(ctx context.Context) *FoldersAssetsGroupCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersAssetsGroupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersAssetsGroupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.groupassetsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assets:group")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.assets.group" call.
// Exactly one of *GroupAssetsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GroupAssetsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersAssetsGroupCall) Do(opts ...googleapi.CallOption) (*GroupAssetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GroupAssetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "deprecated": true,
	//   "description": "Filters an organization's assets and groups them by their specified properties.",
	//   "flatPath": "v1/folders/{foldersId}/assets:group",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.folders.assets.group",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The name of the parent to group the assets by. Its format is \"organizations/[organization_id]\", \"folders/[folder_id]\", or \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/assets:group",
	//   "request": {
	//     "$ref": "GroupAssetsRequest"
	//   },
	//   "response": {
	//     "$ref": "GroupAssetsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersAssetsGroupCall) Pages(ctx context.Context, f func(*GroupAssetsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.groupassetsrequest.PageToken = pt }(c.groupassetsrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.groupassetsrequest.PageToken = x.NextPageToken
	}
}

// method id "securitycenter.folders.assets.list":

type FoldersAssetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists an organization's assets.
//
//   - parent: The name of the parent resource that contains the assets.
//     The value that you can specify on parent depends on the method in
//     which you specify parent. You can specify one of the following
//     values: "organizations/[organization_id]", "folders/[folder_id]",
//     or "projects/[project_id]".
func (r *FoldersAssetsService) List(parent string) *FoldersAssetsListCall {
	c := &FoldersAssetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// CompareDuration sets the optional parameter "compareDuration": When
// compare_duration is set, the ListAssetsResult's "state_change"
// attribute is updated to indicate whether the asset was added,
// removed, or remained present during the compare_duration period of
// time that precedes the read_time. This is the time between (read_time
// - compare_duration) and read_time. The state_change value is derived
// based on the presence of the asset at the two points in time.
// Intermediate state changes between the two times don't affect the
// result. For example, the results aren't affected if the asset is
// removed and re-created again. Possible "state_change" values when
// compare_duration is specified: * "ADDED": indicates that the asset
// was not present at the start of compare_duration, but present at
// read_time. * "REMOVED": indicates that the asset was present at the
// start of compare_duration, but not present at read_time. * "ACTIVE":
// indicates that the asset was present at both the start and the end of
// the time period defined by compare_duration and read_time. If
// compare_duration is not specified, then the only possible
// state_change is "UNUSED", which will be the state_change set for all
// assets present at read_time.
func (c *FoldersAssetsListCall) CompareDuration(compareDuration string) *FoldersAssetsListCall {
	c.urlParams_.Set("compareDuration", compareDuration)
	return c
}

// FieldMask sets the optional parameter "fieldMask": A field mask to
// specify the ListAssetsResult fields to be listed in the response. An
// empty field mask will list all fields.
func (c *FoldersAssetsListCall) FieldMask(fieldMask string) *FoldersAssetsListCall {
	c.urlParams_.Set("fieldMask", fieldMask)
	return c
}

// Filter sets the optional parameter "filter": Expression that defines
// the filter to apply across assets. The expression is a list of zero
// or more restrictions combined via logical operators `AND` and `OR`.
// Parentheses are supported, and `OR` has higher precedence than `AND`.
// Restrictions have the form ` ` and may have a `-` character in front
// of them to indicate negation. The fields map to those defined in the
// Asset resource. Examples include: * name *
// security_center_properties.resource_name *
// resource_properties.a_property * security_marks.marks.marka The
// supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
// `<=` for integer values. * `:`, meaning substring matching, for
// strings. The supported value types are: * string literals in quotes.
// * integer literals without quotes. * boolean literals `true` and
// `false` without quotes. The following are the allowed field and
// operator combinations: * name: `=` * update_time: `=`, `>`, `<`,
// `>=`, `<=` Usage: This should be milliseconds since epoch or an
// RFC3339 string. Examples: `update_time = "2019-06-10T16:07:18-07:00"
// `update_time = 1560208038000` * create_time: `=`, `>`, `<`, `>=`,
// `<=` Usage: This should be milliseconds since epoch or an RFC3339
// string. Examples: `create_time = "2019-06-10T16:07:18-07:00"
// `create_time = 1560208038000` * iam_policy.policy_blob: `=`, `:` *
// resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=` *
// security_marks.marks: `=`, `:` *
// security_center_properties.resource_name: `=`, `:` *
// security_center_properties.resource_display_name: `=`, `:` *
// security_center_properties.resource_type: `=`, `:` *
// security_center_properties.resource_parent: `=`, `:` *
// security_center_properties.resource_parent_display_name: `=`, `:` *
// security_center_properties.resource_project: `=`, `:` *
// security_center_properties.resource_project_display_name: `=`, `:` *
// security_center_properties.resource_owners: `=`, `:` For example,
// `resource_properties.size = 100` is a valid filter string. Use a
// partial match on the empty string to filter based on a property
// existing: `resource_properties.my_property : "" Use a negated
// partial match on the empty string to filter based on a property not
// existing: `-resource_properties.my_property : ""
func (c *FoldersAssetsListCall) Filter(filter string) *FoldersAssetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Expression that
// defines what fields and order to use for sorting. The string value
// should follow SQL syntax: comma separated list of fields. For
// example: "name,resource_properties.a_property". The default sorting
// order is ascending. To specify descending order for a field, a suffix
// " desc" should be appended to the field name. For example: "name
// desc,resource_properties.a_property". Redundant space characters in
// the syntax are insignificant. "name
// desc,resource_properties.a_property" and " name desc ,
// resource_properties.a_property " are equivalent. The following fields
// are supported: name update_time resource_properties
// security_marks.marks security_center_properties.resource_name
// security_center_properties.resource_display_name
// security_center_properties.resource_parent
// security_center_properties.resource_parent_display_name
// security_center_properties.resource_project
// security_center_properties.resource_project_display_name
// security_center_properties.resource_type
func (c *FoldersAssetsListCall) OrderBy(orderBy string) *FoldersAssetsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return in a single response. Default is 10, minimum is
// 1, maximum is 1000.
func (c *FoldersAssetsListCall) PageSize(pageSize int64) *FoldersAssetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned
// by the last `ListAssetsResponse`; indicates that this is a
// continuation of a prior `ListAssets` call, and that the system should
// return the next page of data.
func (c *FoldersAssetsListCall) PageToken(pageToken string) *FoldersAssetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReadTime sets the optional parameter "readTime": Time used as a
// reference point when filtering assets. The filter is limited to
// assets existing at the supplied time and their values are those at
// that specific time. Absence of this field will default to the API's
// version of NOW.
func (c *FoldersAssetsListCall) ReadTime(readTime string) *FoldersAssetsListCall {
	c.urlParams_.Set("readTime", readTime)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersAssetsListCall) Fields(s ...googleapi.Field) *FoldersAssetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersAssetsListCall) IfNoneMatch(entityTag string) *FoldersAssetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersAssetsListCall) Context(ctx context.Context) *FoldersAssetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersAssetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersAssetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.assets.list" call.
// Exactly one of *ListAssetsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListAssetsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersAssetsListCall) Do(opts ...googleapi.CallOption) (*ListAssetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAssetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "deprecated": true,
	//   "description": "Lists an organization's assets.",
	//   "flatPath": "v1/folders/{foldersId}/assets",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.assets.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "compareDuration": {
	//       "description": "When compare_duration is set, the ListAssetsResult's \"state_change\" attribute is updated to indicate whether the asset was added, removed, or remained present during the compare_duration period of time that precedes the read_time. This is the time between (read_time - compare_duration) and read_time. The state_change value is derived based on the presence of the asset at the two points in time. Intermediate state changes between the two times don't affect the result. For example, the results aren't affected if the asset is removed and re-created again. Possible \"state_change\" values when compare_duration is specified: * \"ADDED\": indicates that the asset was not present at the start of compare_duration, but present at read_time. * \"REMOVED\": indicates that the asset was present at the start of compare_duration, but not present at read_time. * \"ACTIVE\": indicates that the asset was present at both the start and the end of the time period defined by compare_duration and read_time. If compare_duration is not specified, then the only possible state_change is \"UNUSED\", which will be the state_change set for all assets present at read_time.",
	//       "format": "google-duration",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "fieldMask": {
	//       "description": "A field mask to specify the ListAssetsResult fields to be listed in the response. An empty field mask will list all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "filter": {
	//       "description": "Expression that defines the filter to apply across assets. The expression is a list of zero or more restrictions combined via logical operators `AND` and `OR`. Parentheses are supported, and `OR` has higher precedence than `AND`. Restrictions have the form ` ` and may have a `-` character in front of them to indicate negation. The fields map to those defined in the Asset resource. Examples include: * name * security_center_properties.resource_name * resource_properties.a_property * security_marks.marks.marka The supported operators are: * `=` for all value types. * `\u003e`, `\u003c`, `\u003e=`, `\u003c=` for integer values. * `:`, meaning substring matching, for strings. The supported value types are: * string literals in quotes. * integer literals without quotes. * boolean literals `true` and `false` without quotes. The following are the allowed field and operator combinations: * name: `=` * update_time: `=`, `\u003e`, `\u003c`, `\u003e=`, `\u003c=` Usage: This should be milliseconds since epoch or an RFC3339 string. Examples: `update_time = \"2019-06-10T16:07:18-07:00\"` `update_time = 1560208038000` * create_time: `=`, `\u003e`, `\u003c`, `\u003e=`, `\u003c=` Usage: This should be milliseconds since epoch or an RFC3339 string. Examples: `create_time = \"2019-06-10T16:07:18-07:00\"` `create_time = 1560208038000` * iam_policy.policy_blob: `=`, `:` * resource_properties: `=`, `:`, `\u003e`, `\u003c`, `\u003e=`, `\u003c=` * security_marks.marks: `=`, `:` * security_center_properties.resource_name: `=`, `:` * security_center_properties.resource_display_name: `=`, `:` * security_center_properties.resource_type: `=`, `:` * security_center_properties.resource_parent: `=`, `:` * security_center_properties.resource_parent_display_name: `=`, `:` * security_center_properties.resource_project: `=`, `:` * security_center_properties.resource_project_display_name: `=`, `:` * security_center_properties.resource_owners: `=`, `:` For example, `resource_properties.size = 100` is a valid filter string. Use a partial match on the empty string to filter based on a property existing: `resource_properties.my_property : \"\"` Use a negated partial match on the empty string to filter based on a property not existing: `-resource_properties.my_property : \"\"`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Expression that defines what fields and order to use for sorting. The string value should follow SQL syntax: comma separated list of fields. For example: \"name,resource_properties.a_property\". The default sorting order is ascending. To specify descending order for a field, a suffix \" desc\" should be appended to the field name. For example: \"name desc,resource_properties.a_property\". Redundant space characters in the syntax are insignificant. \"name desc,resource_properties.a_property\" and \" name desc , resource_properties.a_property \" are equivalent. The following fields are supported: name update_time resource_properties security_marks.marks security_center_properties.resource_name security_center_properties.resource_display_name security_center_properties.resource_parent security_center_properties.resource_parent_display_name security_center_properties.resource_project security_center_properties.resource_project_display_name security_center_properties.resource_type",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of results to return in a single response. Default is 10, minimum is 1, maximum is 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The value returned by the last `ListAssetsResponse`; indicates that this is a continuation of a prior `ListAssets` call, and that the system should return the next page of data.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the parent resource that contains the assets. The value that you can specify on parent depends on the method in which you specify parent. You can specify one of the following values: \"organizations/[organization_id]\", \"folders/[folder_id]\", or \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "readTime": {
	//       "description": "Time used as a reference point when filtering assets. The filter is limited to assets existing at the supplied time and their values are those at that specific time. Absence of this field will default to the API's version of NOW.",
	//       "format": "google-datetime",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/assets",
	//   "response": {
	//     "$ref": "ListAssetsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersAssetsListCall) Pages(ctx context.Context, f func(*ListAssetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.folders.assets.updateSecurityMarks":

type FoldersAssetsUpdateSecurityMarksCall struct {
	s             *Service
	name          string
	securitymarks *SecurityMarks
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// UpdateSecurityMarks: Updates security marks.
//
//   - name: The relative resource name of the SecurityMarks. See:
//     https://cloud.google.com/apis/design/resource_names#relative_resource_name
//     Examples:
//     "organizations/{organization_id}/assets/{asset_id}/securityMarks"
//     "organizations/{organization_id}/sources/{source_id}/findings/{findi
//     ng_id}/securityMarks".
func (r *FoldersAssetsService) UpdateSecurityMarks(name string, securitymarks *SecurityMarks) *FoldersAssetsUpdateSecurityMarksCall {
	c := &FoldersAssetsUpdateSecurityMarksCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.securitymarks = securitymarks
	return c
}

// StartTime sets the optional parameter "startTime": The time at which
// the updated SecurityMarks take effect. If not set uses current server
// time. Updates will be applied to the SecurityMarks that are active
// immediately preceding this time. Must be earlier or equal to the
// server time.
func (c *FoldersAssetsUpdateSecurityMarksCall) StartTime(startTime string) *FoldersAssetsUpdateSecurityMarksCall {
	c.urlParams_.Set("startTime", startTime)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The FieldMask to
// use when updating the security marks resource. The field mask must
// not contain duplicate fields. If empty or set to "marks", all marks
// will be replaced. Individual marks can be updated using "marks.".
func (c *FoldersAssetsUpdateSecurityMarksCall) UpdateMask(updateMask string) *FoldersAssetsUpdateSecurityMarksCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersAssetsUpdateSecurityMarksCall) Fields(s ...googleapi.Field) *FoldersAssetsUpdateSecurityMarksCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersAssetsUpdateSecurityMarksCall) Context(ctx context.Context) *FoldersAssetsUpdateSecurityMarksCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersAssetsUpdateSecurityMarksCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersAssetsUpdateSecurityMarksCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.securitymarks)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.assets.updateSecurityMarks" call.
// Exactly one of *SecurityMarks or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *SecurityMarks.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersAssetsUpdateSecurityMarksCall) Do(opts ...googleapi.CallOption) (*SecurityMarks, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SecurityMarks{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates security marks.",
	//   "flatPath": "v1/folders/{foldersId}/assets/{assetsId}/securityMarks",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.assets.updateSecurityMarks",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The relative resource name of the SecurityMarks. See: https://cloud.google.com/apis/design/resource_names#relative_resource_name Examples: \"organizations/{organization_id}/assets/{asset_id}/securityMarks\" \"organizations/{organization_id}/sources/{source_id}/findings/{finding_id}/securityMarks\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/assets/[^/]+/securityMarks$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "startTime": {
	//       "description": "The time at which the updated SecurityMarks take effect. If not set uses current server time. Updates will be applied to the SecurityMarks that are active immediately preceding this time. Must be earlier or equal to the server time.",
	//       "format": "google-datetime",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The FieldMask to use when updating the security marks resource. The field mask must not contain duplicate fields. If empty or set to \"marks\", all marks will be replaced. Individual marks can be updated using \"marks.\".",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "SecurityMarks"
	//   },
	//   "response": {
	//     "$ref": "SecurityMarks"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.bigQueryExports.create":

type FoldersBigQueryExportsCreateCall struct {
	s                                         *Service
	parent                                    string
	googlecloudsecuritycenterv1bigqueryexport *GoogleCloudSecuritycenterV1BigQueryExport
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Create: Creates a BigQuery export.
//
//   - parent: The name of the parent resource of the new BigQuery export.
//     Its format is "organizations/[organization_id]",
//     "folders/[folder_id]", or "projects/[project_id]".
func (r *FoldersBigQueryExportsService) Create(parent string, googlecloudsecuritycenterv1bigqueryexport *GoogleCloudSecuritycenterV1BigQueryExport) *FoldersBigQueryExportsCreateCall {
	c := &FoldersBigQueryExportsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudsecuritycenterv1bigqueryexport = googlecloudsecuritycenterv1bigqueryexport
	return c
}

// BigQueryExportId sets the optional parameter "bigQueryExportId":
// Required. Unique identifier provided by the client within the parent
// scope. It must consist of only lowercase letters, numbers, and
// hyphens, must start with a letter, must end with either a letter or a
// number, and must be 63 characters or less.
func (c *FoldersBigQueryExportsCreateCall) BigQueryExportId(bigQueryExportId string) *FoldersBigQueryExportsCreateCall {
	c.urlParams_.Set("bigQueryExportId", bigQueryExportId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersBigQueryExportsCreateCall) Fields(s ...googleapi.Field) *FoldersBigQueryExportsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersBigQueryExportsCreateCall) Context(ctx context.Context) *FoldersBigQueryExportsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersBigQueryExportsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersBigQueryExportsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudsecuritycenterv1bigqueryexport)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bigQueryExports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.bigQueryExports.create" call.
// Exactly one of *GoogleCloudSecuritycenterV1BigQueryExport or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudSecuritycenterV1BigQueryExport.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersBigQueryExportsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1BigQueryExport, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1BigQueryExport{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a BigQuery export.",
	//   "flatPath": "v1/folders/{foldersId}/bigQueryExports",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.folders.bigQueryExports.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "bigQueryExportId": {
	//       "description": "Required. Unique identifier provided by the client within the parent scope. It must consist of only lowercase letters, numbers, and hyphens, must start with a letter, must end with either a letter or a number, and must be 63 characters or less.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the parent resource of the new BigQuery export. Its format is \"organizations/[organization_id]\", \"folders/[folder_id]\", or \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/bigQueryExports",
	//   "request": {
	//     "$ref": "GoogleCloudSecuritycenterV1BigQueryExport"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1BigQueryExport"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.bigQueryExports.delete":

type FoldersBigQueryExportsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing BigQuery export.
//
//   - name: The name of the BigQuery export to delete. Its format is
//     organizations/{organization}/bigQueryExports/{export_id},
//     folders/{folder}/bigQueryExports/{export_id}, or
//     projects/{project}/bigQueryExports/{export_id}.
func (r *FoldersBigQueryExportsService) Delete(name string) *FoldersBigQueryExportsDeleteCall {
	c := &FoldersBigQueryExportsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersBigQueryExportsDeleteCall) Fields(s ...googleapi.Field) *FoldersBigQueryExportsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersBigQueryExportsDeleteCall) Context(ctx context.Context) *FoldersBigQueryExportsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersBigQueryExportsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersBigQueryExportsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.bigQueryExports.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *FoldersBigQueryExportsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an existing BigQuery export.",
	//   "flatPath": "v1/folders/{foldersId}/bigQueryExports/{bigQueryExportsId}",
	//   "httpMethod": "DELETE",
	//   "id": "securitycenter.folders.bigQueryExports.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the BigQuery export to delete. Its format is organizations/{organization}/bigQueryExports/{export_id}, folders/{folder}/bigQueryExports/{export_id}, or projects/{project}/bigQueryExports/{export_id}",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/bigQueryExports/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.bigQueryExports.get":

type FoldersBigQueryExportsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a BigQuery export.
//
//   - name: Name of the BigQuery export to retrieve. Its format is
//     organizations/{organization}/bigQueryExports/{export_id},
//     folders/{folder}/bigQueryExports/{export_id}, or
//     projects/{project}/bigQueryExports/{export_id}.
func (r *FoldersBigQueryExportsService) Get(name string) *FoldersBigQueryExportsGetCall {
	c := &FoldersBigQueryExportsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersBigQueryExportsGetCall) Fields(s ...googleapi.Field) *FoldersBigQueryExportsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersBigQueryExportsGetCall) IfNoneMatch(entityTag string) *FoldersBigQueryExportsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersBigQueryExportsGetCall) Context(ctx context.Context) *FoldersBigQueryExportsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersBigQueryExportsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersBigQueryExportsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.bigQueryExports.get" call.
// Exactly one of *GoogleCloudSecuritycenterV1BigQueryExport or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudSecuritycenterV1BigQueryExport.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersBigQueryExportsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1BigQueryExport, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1BigQueryExport{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a BigQuery export.",
	//   "flatPath": "v1/folders/{foldersId}/bigQueryExports/{bigQueryExportsId}",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.bigQueryExports.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the BigQuery export to retrieve. Its format is organizations/{organization}/bigQueryExports/{export_id}, folders/{folder}/bigQueryExports/{export_id}, or projects/{project}/bigQueryExports/{export_id}",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/bigQueryExports/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1BigQueryExport"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.bigQueryExports.list":

type FoldersBigQueryExportsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists BigQuery exports. Note that when requesting BigQuery
// exports at a given level all exports under that level are also
// returned e.g. if requesting BigQuery exports under a folder, then all
// BigQuery exports immediately under the folder plus the ones created
// under the projects within the folder are returned.
//
//   - parent: The parent, which owns the collection of BigQuery exports.
//     Its format is "organizations/[organization_id]",
//     "folders/[folder_id]", "projects/[project_id]".
func (r *FoldersBigQueryExportsService) List(parent string) *FoldersBigQueryExportsListCall {
	c := &FoldersBigQueryExportsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of configs to return. The service may return fewer than this value.
// If unspecified, at most 10 configs will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *FoldersBigQueryExportsListCall) PageSize(pageSize int64) *FoldersBigQueryExportsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListBigQueryExports` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListBigQueryExports` must match the call that provided
// the page token.
func (c *FoldersBigQueryExportsListCall) PageToken(pageToken string) *FoldersBigQueryExportsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersBigQueryExportsListCall) Fields(s ...googleapi.Field) *FoldersBigQueryExportsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersBigQueryExportsListCall) IfNoneMatch(entityTag string) *FoldersBigQueryExportsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersBigQueryExportsListCall) Context(ctx context.Context) *FoldersBigQueryExportsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersBigQueryExportsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersBigQueryExportsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bigQueryExports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.bigQueryExports.list" call.
// Exactly one of *ListBigQueryExportsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListBigQueryExportsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersBigQueryExportsListCall) Do(opts ...googleapi.CallOption) (*ListBigQueryExportsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBigQueryExportsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists BigQuery exports. Note that when requesting BigQuery exports at a given level all exports under that level are also returned e.g. if requesting BigQuery exports under a folder, then all BigQuery exports immediately under the folder plus the ones created under the projects within the folder are returned.",
	//   "flatPath": "v1/folders/{foldersId}/bigQueryExports",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.bigQueryExports.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of configs to return. The service may return fewer than this value. If unspecified, at most 10 configs will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListBigQueryExports` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListBigQueryExports` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent, which owns the collection of BigQuery exports. Its format is \"organizations/[organization_id]\", \"folders/[folder_id]\", \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/bigQueryExports",
	//   "response": {
	//     "$ref": "ListBigQueryExportsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersBigQueryExportsListCall) Pages(ctx context.Context, f func(*ListBigQueryExportsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.folders.bigQueryExports.patch":

type FoldersBigQueryExportsPatchCall struct {
	s                                         *Service
	name                                      string
	googlecloudsecuritycenterv1bigqueryexport *GoogleCloudSecuritycenterV1BigQueryExport
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Patch: Updates a BigQuery export.
//
//   - name: The relative resource name of this export. See:
//     https://cloud.google.com/apis/design/resource_names#relative_resource_name.
//     Example format:
//     "organizations/{organization_id}/bigQueryExports/{export_id}"
//     Example format: "folders/{folder_id}/bigQueryExports/{export_id}"
//     Example format: "projects/{project_id}/bigQueryExports/{export_id}"
//     This field is provided in responses, and is ignored when provided
//     in create requests.
func (r *FoldersBigQueryExportsService) Patch(name string, googlecloudsecuritycenterv1bigqueryexport *GoogleCloudSecuritycenterV1BigQueryExport) *FoldersBigQueryExportsPatchCall {
	c := &FoldersBigQueryExportsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudsecuritycenterv1bigqueryexport = googlecloudsecuritycenterv1bigqueryexport
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated. If empty all mutable fields will be updated.
func (c *FoldersBigQueryExportsPatchCall) UpdateMask(updateMask string) *FoldersBigQueryExportsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersBigQueryExportsPatchCall) Fields(s ...googleapi.Field) *FoldersBigQueryExportsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersBigQueryExportsPatchCall) Context(ctx context.Context) *FoldersBigQueryExportsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersBigQueryExportsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersBigQueryExportsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudsecuritycenterv1bigqueryexport)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.bigQueryExports.patch" call.
// Exactly one of *GoogleCloudSecuritycenterV1BigQueryExport or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudSecuritycenterV1BigQueryExport.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersBigQueryExportsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1BigQueryExport, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1BigQueryExport{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a BigQuery export.",
	//   "flatPath": "v1/folders/{foldersId}/bigQueryExports/{bigQueryExportsId}",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.bigQueryExports.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The relative resource name of this export. See: https://cloud.google.com/apis/design/resource_names#relative_resource_name. Example format: \"organizations/{organization_id}/bigQueryExports/{export_id}\" Example format: \"folders/{folder_id}/bigQueryExports/{export_id}\" Example format: \"projects/{project_id}/bigQueryExports/{export_id}\" This field is provided in responses, and is ignored when provided in create requests.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/bigQueryExports/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated. If empty all mutable fields will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudSecuritycenterV1BigQueryExport"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1BigQueryExport"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.eventThreatDetectionSettings.validateCustomModule":

type FoldersEventThreatDetectionSettingsValidateCustomModuleCall struct {
	s                                               *Service
	parent                                          string
	validateeventthreatdetectioncustommodulerequest *ValidateEventThreatDetectionCustomModuleRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// ValidateCustomModule: Validates the given Event Threat Detection
// custom module.
//
//   - parent: Resource name of the parent to validate the Custom Module
//     under. Its format is: *
//     "organizations/{organization}/eventThreatDetectionSettings". *
//     "folders/{folder}/eventThreatDetectionSettings". *
//     "projects/{project}/eventThreatDetectionSettings".
func (r *FoldersEventThreatDetectionSettingsService) ValidateCustomModule(parent string, validateeventthreatdetectioncustommodulerequest *ValidateEventThreatDetectionCustomModuleRequest) *FoldersEventThreatDetectionSettingsValidateCustomModuleCall {
	c := &FoldersEventThreatDetectionSettingsValidateCustomModuleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.validateeventthreatdetectioncustommodulerequest = validateeventthreatdetectioncustommodulerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersEventThreatDetectionSettingsValidateCustomModuleCall) Fields(s ...googleapi.Field) *FoldersEventThreatDetectionSettingsValidateCustomModuleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersEventThreatDetectionSettingsValidateCustomModuleCall) Context(ctx context.Context) *FoldersEventThreatDetectionSettingsValidateCustomModuleCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersEventThreatDetectionSettingsValidateCustomModuleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersEventThreatDetectionSettingsValidateCustomModuleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.validateeventthreatdetectioncustommodulerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:validateCustomModule")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.eventThreatDetectionSettings.validateCustomModule" call.
// Exactly one of *ValidateEventThreatDetectionCustomModuleResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *ValidateEventThreatDetectionCustomModuleResponse.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersEventThreatDetectionSettingsValidateCustomModuleCall) Do(opts ...googleapi.CallOption) (*ValidateEventThreatDetectionCustomModuleResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ValidateEventThreatDetectionCustomModuleResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Validates the given Event Threat Detection custom module.",
	//   "flatPath": "v1/folders/{foldersId}/eventThreatDetectionSettings:validateCustomModule",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.folders.eventThreatDetectionSettings.validateCustomModule",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Resource name of the parent to validate the Custom Module under. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings\". * \"folders/{folder}/eventThreatDetectionSettings\". * \"projects/{project}/eventThreatDetectionSettings\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}:validateCustomModule",
	//   "request": {
	//     "$ref": "ValidateEventThreatDetectionCustomModuleRequest"
	//   },
	//   "response": {
	//     "$ref": "ValidateEventThreatDetectionCustomModuleResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.eventThreatDetectionSettings.customModules.create":

type FoldersEventThreatDetectionSettingsCustomModulesCreateCall struct {
	s                                *Service
	parent                           string
	eventthreatdetectioncustommodule *EventThreatDetectionCustomModule
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Create: Creates a resident Event Threat Detection custom module at
// the scope of the given Resource Manager parent, and also creates
// inherited custom modules for all descendants of the given parent.
// These modules are enabled by default.
//
//   - parent: The new custom module's parent. Its format is: *
//     "organizations/{organization}/eventThreatDetectionSettings". *
//     "folders/{folder}/eventThreatDetectionSettings". *
//     "projects/{project}/eventThreatDetectionSettings".
func (r *FoldersEventThreatDetectionSettingsCustomModulesService) Create(parent string, eventthreatdetectioncustommodule *EventThreatDetectionCustomModule) *FoldersEventThreatDetectionSettingsCustomModulesCreateCall {
	c := &FoldersEventThreatDetectionSettingsCustomModulesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.eventthreatdetectioncustommodule = eventthreatdetectioncustommodule
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersEventThreatDetectionSettingsCustomModulesCreateCall) Fields(s ...googleapi.Field) *FoldersEventThreatDetectionSettingsCustomModulesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersEventThreatDetectionSettingsCustomModulesCreateCall) Context(ctx context.Context) *FoldersEventThreatDetectionSettingsCustomModulesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersEventThreatDetectionSettingsCustomModulesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersEventThreatDetectionSettingsCustomModulesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventthreatdetectioncustommodule)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/customModules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.eventThreatDetectionSettings.customModules.create" call.
// Exactly one of *EventThreatDetectionCustomModule or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionCustomModule.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersEventThreatDetectionSettingsCustomModulesCreateCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionCustomModule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventThreatDetectionCustomModule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a resident Event Threat Detection custom module at the scope of the given Resource Manager parent, and also creates inherited custom modules for all descendants of the given parent. These modules are enabled by default.",
	//   "flatPath": "v1/folders/{foldersId}/eventThreatDetectionSettings/customModules",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.folders.eventThreatDetectionSettings.customModules.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The new custom module's parent. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings\". * \"folders/{folder}/eventThreatDetectionSettings\". * \"projects/{project}/eventThreatDetectionSettings\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/customModules",
	//   "request": {
	//     "$ref": "EventThreatDetectionCustomModule"
	//   },
	//   "response": {
	//     "$ref": "EventThreatDetectionCustomModule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.eventThreatDetectionSettings.customModules.delete":

type FoldersEventThreatDetectionSettingsCustomModulesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified Event Threat Detection custom module
// and all of its descendants in the Resource Manager hierarchy. This
// method is only supported for resident custom modules.
//
//   - name: Name of the custom module to delete. Its format is: *
//     "organizations/{organization}/eventThreatDetectionSettings/customMod
//     ules/{module}". *
//     "folders/{folder}/eventThreatDetectionSettings/customModules/{module
//     }". *
//     "projects/{project}/eventThreatDetectionSettings/customModules/{modu
//     le}".
func (r *FoldersEventThreatDetectionSettingsCustomModulesService) Delete(name string) *FoldersEventThreatDetectionSettingsCustomModulesDeleteCall {
	c := &FoldersEventThreatDetectionSettingsCustomModulesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersEventThreatDetectionSettingsCustomModulesDeleteCall) Fields(s ...googleapi.Field) *FoldersEventThreatDetectionSettingsCustomModulesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersEventThreatDetectionSettingsCustomModulesDeleteCall) Context(ctx context.Context) *FoldersEventThreatDetectionSettingsCustomModulesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersEventThreatDetectionSettingsCustomModulesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersEventThreatDetectionSettingsCustomModulesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.eventThreatDetectionSettings.customModules.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *FoldersEventThreatDetectionSettingsCustomModulesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the specified Event Threat Detection custom module and all of its descendants in the Resource Manager hierarchy. This method is only supported for resident custom modules.",
	//   "flatPath": "v1/folders/{foldersId}/eventThreatDetectionSettings/customModules/{customModulesId}",
	//   "httpMethod": "DELETE",
	//   "id": "securitycenter.folders.eventThreatDetectionSettings.customModules.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the custom module to delete. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings/customModules/{module}\". * \"folders/{folder}/eventThreatDetectionSettings/customModules/{module}\". * \"projects/{project}/eventThreatDetectionSettings/customModules/{module}\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/eventThreatDetectionSettings/customModules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.eventThreatDetectionSettings.customModules.get":

type FoldersEventThreatDetectionSettingsCustomModulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an Event Threat Detection custom module.
//
//   - name: Name of the custom module to get. Its format is: *
//     "organizations/{organization}/eventThreatDetectionSettings/customMod
//     ules/{module}". *
//     "folders/{folder}/eventThreatDetectionSettings/customModules/{module
//     }". *
//     "projects/{project}/eventThreatDetectionSettings/customModules/{modu
//     le}".
func (r *FoldersEventThreatDetectionSettingsCustomModulesService) Get(name string) *FoldersEventThreatDetectionSettingsCustomModulesGetCall {
	c := &FoldersEventThreatDetectionSettingsCustomModulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersEventThreatDetectionSettingsCustomModulesGetCall) Fields(s ...googleapi.Field) *FoldersEventThreatDetectionSettingsCustomModulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersEventThreatDetectionSettingsCustomModulesGetCall) IfNoneMatch(entityTag string) *FoldersEventThreatDetectionSettingsCustomModulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersEventThreatDetectionSettingsCustomModulesGetCall) Context(ctx context.Context) *FoldersEventThreatDetectionSettingsCustomModulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersEventThreatDetectionSettingsCustomModulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersEventThreatDetectionSettingsCustomModulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.eventThreatDetectionSettings.customModules.get" call.
// Exactly one of *EventThreatDetectionCustomModule or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionCustomModule.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersEventThreatDetectionSettingsCustomModulesGetCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionCustomModule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventThreatDetectionCustomModule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an Event Threat Detection custom module.",
	//   "flatPath": "v1/folders/{foldersId}/eventThreatDetectionSettings/customModules/{customModulesId}",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.eventThreatDetectionSettings.customModules.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the custom module to get. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings/customModules/{module}\". * \"folders/{folder}/eventThreatDetectionSettings/customModules/{module}\". * \"projects/{project}/eventThreatDetectionSettings/customModules/{module}\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/eventThreatDetectionSettings/customModules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "EventThreatDetectionCustomModule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.eventThreatDetectionSettings.customModules.list":

type FoldersEventThreatDetectionSettingsCustomModulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Event Threat Detection custom modules for the given
// Resource Manager parent. This includes resident modules defined at
// the scope of the parent along with modules inherited from ancestors.
//
//   - parent: Name of the parent to list custom modules under. Its format
//     is: * "organizations/{organization}/eventThreatDetectionSettings".
//   - "folders/{folder}/eventThreatDetectionSettings". *
//     "projects/{project}/eventThreatDetectionSettings".
func (r *FoldersEventThreatDetectionSettingsCustomModulesService) List(parent string) *FoldersEventThreatDetectionSettingsCustomModulesListCall {
	c := &FoldersEventThreatDetectionSettingsCustomModulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of modules to return. The service may return fewer than this value.
// If unspecified, at most 10 configs will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListCall) PageSize(pageSize int64) *FoldersEventThreatDetectionSettingsCustomModulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListEventThreatDetectionCustomModules`
// call. Provide this to retrieve the subsequent page. When paginating,
// all other parameters provided to
// `ListEventThreatDetectionCustomModules` must match the call that
// provided the page token.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListCall) PageToken(pageToken string) *FoldersEventThreatDetectionSettingsCustomModulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListCall) Fields(s ...googleapi.Field) *FoldersEventThreatDetectionSettingsCustomModulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListCall) IfNoneMatch(entityTag string) *FoldersEventThreatDetectionSettingsCustomModulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListCall) Context(ctx context.Context) *FoldersEventThreatDetectionSettingsCustomModulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersEventThreatDetectionSettingsCustomModulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/customModules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.eventThreatDetectionSettings.customModules.list" call.
// Exactly one of *ListEventThreatDetectionCustomModulesResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *ListEventThreatDetectionCustomModulesResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListCall) Do(opts ...googleapi.CallOption) (*ListEventThreatDetectionCustomModulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEventThreatDetectionCustomModulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all Event Threat Detection custom modules for the given Resource Manager parent. This includes resident modules defined at the scope of the parent along with modules inherited from ancestors.",
	//   "flatPath": "v1/folders/{foldersId}/eventThreatDetectionSettings/customModules",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.eventThreatDetectionSettings.customModules.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of modules to return. The service may return fewer than this value. If unspecified, at most 10 configs will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListEventThreatDetectionCustomModules` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListEventThreatDetectionCustomModules` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the parent to list custom modules under. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings\". * \"folders/{folder}/eventThreatDetectionSettings\". * \"projects/{project}/eventThreatDetectionSettings\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/customModules",
	//   "response": {
	//     "$ref": "ListEventThreatDetectionCustomModulesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListCall) Pages(ctx context.Context, f func(*ListEventThreatDetectionCustomModulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.folders.eventThreatDetectionSettings.customModules.listDescendant":

type FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListDescendant: Lists all resident Event Threat Detection custom
// modules under the given Resource Manager parent and its descendants.
//
//   - parent: Name of the parent to list custom modules under. Its format
//     is: * "organizations/{organization}/eventThreatDetectionSettings".
//   - "folders/{folder}/eventThreatDetectionSettings". *
//     "projects/{project}/eventThreatDetectionSettings".
func (r *FoldersEventThreatDetectionSettingsCustomModulesService) ListDescendant(parent string) *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall {
	c := &FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of modules to return. The service may return fewer than this value.
// If unspecified, at most 10 configs will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall) PageSize(pageSize int64) *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous
// `ListDescendantEventThreatDetectionCustomModules` call. Provide this
// to retrieve the subsequent page. When paginating, all other
// parameters provided to
// `ListDescendantEventThreatDetectionCustomModules` must match the call
// that provided the page token.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall) PageToken(pageToken string) *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall) Fields(s ...googleapi.Field) *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall) IfNoneMatch(entityTag string) *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall) Context(ctx context.Context) *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/customModules:listDescendant")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.eventThreatDetectionSettings.customModules.listDescendant" call.
// Exactly one of
// *ListDescendantEventThreatDetectionCustomModulesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *ListDescendantEventThreatDetectionCustomModulesResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall) Do(opts ...googleapi.CallOption) (*ListDescendantEventThreatDetectionCustomModulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDescendantEventThreatDetectionCustomModulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all resident Event Threat Detection custom modules under the given Resource Manager parent and its descendants.",
	//   "flatPath": "v1/folders/{foldersId}/eventThreatDetectionSettings/customModules:listDescendant",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.eventThreatDetectionSettings.customModules.listDescendant",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of modules to return. The service may return fewer than this value. If unspecified, at most 10 configs will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListDescendantEventThreatDetectionCustomModules` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListDescendantEventThreatDetectionCustomModules` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the parent to list custom modules under. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings\". * \"folders/{folder}/eventThreatDetectionSettings\". * \"projects/{project}/eventThreatDetectionSettings\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/customModules:listDescendant",
	//   "response": {
	//     "$ref": "ListDescendantEventThreatDetectionCustomModulesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersEventThreatDetectionSettingsCustomModulesListDescendantCall) Pages(ctx context.Context, f func(*ListDescendantEventThreatDetectionCustomModulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.folders.eventThreatDetectionSettings.customModules.patch":

type FoldersEventThreatDetectionSettingsCustomModulesPatchCall struct {
	s                                *Service
	name                             string
	eventthreatdetectioncustommodule *EventThreatDetectionCustomModule
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Patch: Updates the Event Threat Detection custom module with the
// given name based on the given update mask. Updating the enablement
// state is supported for both resident and inherited modules (though
// resident modules cannot have an enablement state of "inherited").
// Updating the display name or configuration of a module is supported
// for resident modules only. The type of a module cannot be changed.
//
//   - name: Immutable. The resource name of the Event Threat Detection
//     custom module. Its format is: *
//     "organizations/{organization}/eventThreatDetectionSettings/customMod
//     ules/{module}". *
//     "folders/{folder}/eventThreatDetectionSettings/customModules/{module
//     }". *
//     "projects/{project}/eventThreatDetectionSettings/customModules/{modu
//     le}".
func (r *FoldersEventThreatDetectionSettingsCustomModulesService) Patch(name string, eventthreatdetectioncustommodule *EventThreatDetectionCustomModule) *FoldersEventThreatDetectionSettingsCustomModulesPatchCall {
	c := &FoldersEventThreatDetectionSettingsCustomModulesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.eventthreatdetectioncustommodule = eventthreatdetectioncustommodule
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated. If empty all mutable fields will be updated.
func (c *FoldersEventThreatDetectionSettingsCustomModulesPatchCall) UpdateMask(updateMask string) *FoldersEventThreatDetectionSettingsCustomModulesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersEventThreatDetectionSettingsCustomModulesPatchCall) Fields(s ...googleapi.Field) *FoldersEventThreatDetectionSettingsCustomModulesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersEventThreatDetectionSettingsCustomModulesPatchCall) Context(ctx context.Context) *FoldersEventThreatDetectionSettingsCustomModulesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersEventThreatDetectionSettingsCustomModulesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersEventThreatDetectionSettingsCustomModulesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventthreatdetectioncustommodule)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.eventThreatDetectionSettings.customModules.patch" call.
// Exactly one of *EventThreatDetectionCustomModule or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionCustomModule.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersEventThreatDetectionSettingsCustomModulesPatchCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionCustomModule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventThreatDetectionCustomModule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the Event Threat Detection custom module with the given name based on the given update mask. Updating the enablement state is supported for both resident and inherited modules (though resident modules cannot have an enablement state of \"inherited\"). Updating the display name or configuration of a module is supported for resident modules only. The type of a module cannot be changed.",
	//   "flatPath": "v1/folders/{foldersId}/eventThreatDetectionSettings/customModules/{customModulesId}",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.eventThreatDetectionSettings.customModules.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The resource name of the Event Threat Detection custom module. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings/customModules/{module}\". * \"folders/{folder}/eventThreatDetectionSettings/customModules/{module}\". * \"projects/{project}/eventThreatDetectionSettings/customModules/{module}\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/eventThreatDetectionSettings/customModules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated. If empty all mutable fields will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "EventThreatDetectionCustomModule"
	//   },
	//   "response": {
	//     "$ref": "EventThreatDetectionCustomModule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.eventThreatDetectionSettings.effectiveCustomModules.get":

type FoldersEventThreatDetectionSettingsEffectiveCustomModulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an effective Event Threat Detection custom module at the
// given level.
//
//   - name: The resource name of the effective Event Threat Detection
//     custom module. Its format is: *
//     "organizations/{organization}/eventThreatDetectionSettings/effective
//     CustomModules/{module}". *
//     "folders/{folder}/eventThreatDetectionSettings/effectiveCustomModule
//     s/{module}". *
//     "projects/{project}/eventThreatDetectionSettings/effectiveCustomModu
//     les/{module}".
func (r *FoldersEventThreatDetectionSettingsEffectiveCustomModulesService) Get(name string) *FoldersEventThreatDetectionSettingsEffectiveCustomModulesGetCall {
	c := &FoldersEventThreatDetectionSettingsEffectiveCustomModulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesGetCall) Fields(s ...googleapi.Field) *FoldersEventThreatDetectionSettingsEffectiveCustomModulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesGetCall) IfNoneMatch(entityTag string) *FoldersEventThreatDetectionSettingsEffectiveCustomModulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesGetCall) Context(ctx context.Context) *FoldersEventThreatDetectionSettingsEffectiveCustomModulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.eventThreatDetectionSettings.effectiveCustomModules.get" call.
// Exactly one of *EffectiveEventThreatDetectionCustomModule or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *EffectiveEventThreatDetectionCustomModule.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesGetCall) Do(opts ...googleapi.CallOption) (*EffectiveEventThreatDetectionCustomModule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EffectiveEventThreatDetectionCustomModule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an effective Event Threat Detection custom module at the given level.",
	//   "flatPath": "v1/folders/{foldersId}/eventThreatDetectionSettings/effectiveCustomModules/{effectiveCustomModulesId}",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.eventThreatDetectionSettings.effectiveCustomModules.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the effective Event Threat Detection custom module. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings/effectiveCustomModules/{module}\". * \"folders/{folder}/eventThreatDetectionSettings/effectiveCustomModules/{module}\". * \"projects/{project}/eventThreatDetectionSettings/effectiveCustomModules/{module}\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/eventThreatDetectionSettings/effectiveCustomModules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "EffectiveEventThreatDetectionCustomModule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.eventThreatDetectionSettings.effectiveCustomModules.list":

type FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all effective Event Threat Detection custom modules for
// the given parent. This includes resident modules defined at the scope
// of the parent along with modules inherited from its ancestors.
//
//   - parent: Name of the parent to list custom modules for. Its format
//     is: * "organizations/{organization}/eventThreatDetectionSettings".
//   - "folders/{folder}/eventThreatDetectionSettings". *
//     "projects/{project}/eventThreatDetectionSettings".
func (r *FoldersEventThreatDetectionSettingsEffectiveCustomModulesService) List(parent string) *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall {
	c := &FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of modules to return. The service may return fewer than this value.
// If unspecified, at most 10 configs will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall) PageSize(pageSize int64) *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous
// `ListEffectiveEventThreatDetectionCustomModules` call. Provide this
// to retrieve the subsequent page. When paginating, all other
// parameters provided to
// `ListEffectiveEventThreatDetectionCustomModules` must match the call
// that provided the page token.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall) PageToken(pageToken string) *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall) Fields(s ...googleapi.Field) *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall) IfNoneMatch(entityTag string) *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall) Context(ctx context.Context) *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/effectiveCustomModules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.eventThreatDetectionSettings.effectiveCustomModules.list" call.
// Exactly one of
// *ListEffectiveEventThreatDetectionCustomModulesResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *ListEffectiveEventThreatDetectionCustomModulesResponse.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall) Do(opts ...googleapi.CallOption) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEffectiveEventThreatDetectionCustomModulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all effective Event Threat Detection custom modules for the given parent. This includes resident modules defined at the scope of the parent along with modules inherited from its ancestors.",
	//   "flatPath": "v1/folders/{foldersId}/eventThreatDetectionSettings/effectiveCustomModules",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.eventThreatDetectionSettings.effectiveCustomModules.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of modules to return. The service may return fewer than this value. If unspecified, at most 10 configs will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListEffectiveEventThreatDetectionCustomModules` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListEffectiveEventThreatDetectionCustomModules` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the parent to list custom modules for. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings\". * \"folders/{folder}/eventThreatDetectionSettings\". * \"projects/{project}/eventThreatDetectionSettings\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/effectiveCustomModules",
	//   "response": {
	//     "$ref": "ListEffectiveEventThreatDetectionCustomModulesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersEventThreatDetectionSettingsEffectiveCustomModulesListCall) Pages(ctx context.Context, f func(*ListEffectiveEventThreatDetectionCustomModulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.folders.findings.bulkMute":

type FoldersFindingsBulkMuteCall struct {
	s                       *Service
	parent                  string
	bulkmutefindingsrequest *BulkMuteFindingsRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// BulkMute: Kicks off an LRO to bulk mute findings for a parent based
// on a filter. The parent can be either an organization, folder or
// project. The findings matched by the filter will be muted after the
// LRO is done.
//
//   - parent: The parent, at which bulk action needs to be applied. Its
//     format is "organizations/[organization_id]", "folders/[folder_id]",
//     "projects/[project_id]".
func (r *FoldersFindingsService) BulkMute(parent string, bulkmutefindingsrequest *BulkMuteFindingsRequest) *FoldersFindingsBulkMuteCall {
	c := &FoldersFindingsBulkMuteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.bulkmutefindingsrequest = bulkmutefindingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersFindingsBulkMuteCall) Fields(s ...googleapi.Field) *FoldersFindingsBulkMuteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersFindingsBulkMuteCall) Context(ctx context.Context) *FoldersFindingsBulkMuteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersFindingsBulkMuteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersFindingsBulkMuteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.bulkmutefindingsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/findings:bulkMute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.findings.bulkMute" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersFindingsBulkMuteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Kicks off an LRO to bulk mute findings for a parent based on a filter. The parent can be either an organization, folder or project. The findings matched by the filter will be muted after the LRO is done.",
	//   "flatPath": "v1/folders/{foldersId}/findings:bulkMute",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.folders.findings.bulkMute",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent, at which bulk action needs to be applied. Its format is \"organizations/[organization_id]\", \"folders/[folder_id]\", \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/findings:bulkMute",
	//   "request": {
	//     "$ref": "BulkMuteFindingsRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.locations.muteConfigs.delete":

type FoldersLocationsMuteConfigsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing mute config.
//
//   - name: Name of the mute config to delete. Its format is
//     organizations/{organization}/muteConfigs/{config_id},
//     folders/{folder}/muteConfigs/{config_id},
//     projects/{project}/muteConfigs/{config_id},
//     organizations/{organization}/locations/global/muteConfigs/{config_id
//     }, folders/{folder}/locations/global/muteConfigs/{config_id}, or
//     projects/{project}/locations/global/muteConfigs/{config_id}.
func (r *FoldersLocationsMuteConfigsService) Delete(name string) *FoldersLocationsMuteConfigsDeleteCall {
	c := &FoldersLocationsMuteConfigsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersLocationsMuteConfigsDeleteCall) Fields(s ...googleapi.Field) *FoldersLocationsMuteConfigsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersLocationsMuteConfigsDeleteCall) Context(ctx context.Context) *FoldersLocationsMuteConfigsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersLocationsMuteConfigsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsMuteConfigsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.locations.muteConfigs.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *FoldersLocationsMuteConfigsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an existing mute config.",
	//   "flatPath": "v1/folders/{foldersId}/locations/{locationsId}/muteConfigs/{muteConfigsId}",
	//   "httpMethod": "DELETE",
	//   "id": "securitycenter.folders.locations.muteConfigs.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the mute config to delete. Its format is organizations/{organization}/muteConfigs/{config_id}, folders/{folder}/muteConfigs/{config_id}, projects/{project}/muteConfigs/{config_id}, organizations/{organization}/locations/global/muteConfigs/{config_id}, folders/{folder}/locations/global/muteConfigs/{config_id}, or projects/{project}/locations/global/muteConfigs/{config_id}.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/locations/[^/]+/muteConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.locations.muteConfigs.get":

type FoldersLocationsMuteConfigsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a mute config.
//
//   - name: Name of the mute config to retrieve. Its format is
//     organizations/{organization}/muteConfigs/{config_id},
//     folders/{folder}/muteConfigs/{config_id},
//     projects/{project}/muteConfigs/{config_id},
//     organizations/{organization}/locations/global/muteConfigs/{config_id
//     }, folders/{folder}/locations/global/muteConfigs/{config_id}, or
//     projects/{project}/locations/global/muteConfigs/{config_id}.
func (r *FoldersLocationsMuteConfigsService) Get(name string) *FoldersLocationsMuteConfigsGetCall {
	c := &FoldersLocationsMuteConfigsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersLocationsMuteConfigsGetCall) Fields(s ...googleapi.Field) *FoldersLocationsMuteConfigsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersLocationsMuteConfigsGetCall) IfNoneMatch(entityTag string) *FoldersLocationsMuteConfigsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersLocationsMuteConfigsGetCall) Context(ctx context.Context) *FoldersLocationsMuteConfigsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersLocationsMuteConfigsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsMuteConfigsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.locations.muteConfigs.get" call.
// Exactly one of *GoogleCloudSecuritycenterV1MuteConfig or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudSecuritycenterV1MuteConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersLocationsMuteConfigsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1MuteConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1MuteConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a mute config.",
	//   "flatPath": "v1/folders/{foldersId}/locations/{locationsId}/muteConfigs/{muteConfigsId}",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.locations.muteConfigs.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the mute config to retrieve. Its format is organizations/{organization}/muteConfigs/{config_id}, folders/{folder}/muteConfigs/{config_id}, projects/{project}/muteConfigs/{config_id}, organizations/{organization}/locations/global/muteConfigs/{config_id}, folders/{folder}/locations/global/muteConfigs/{config_id}, or projects/{project}/locations/global/muteConfigs/{config_id}.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/locations/[^/]+/muteConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1MuteConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.locations.muteConfigs.patch":

type FoldersLocationsMuteConfigsPatchCall struct {
	s                                     *Service
	name                                  string
	googlecloudsecuritycenterv1muteconfig *GoogleCloudSecuritycenterV1MuteConfig
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Patch: Updates a mute config.
//
//   - name: This field will be ignored if provided on config creation.
//     Format "organizations/{organization}/muteConfigs/{mute_config}"
//     "folders/{folder}/muteConfigs/{mute_config}"
//     "projects/{project}/muteConfigs/{mute_config}"
//     "organizations/{organization}/locations/global/muteConfigs/{mute_con
//     fig}" "folders/{folder}/locations/global/muteConfigs/{mute_config}"
//     "projects/{project}/locations/global/muteConfigs/{mute_config}".
func (r *FoldersLocationsMuteConfigsService) Patch(name string, googlecloudsecuritycenterv1muteconfig *GoogleCloudSecuritycenterV1MuteConfig) *FoldersLocationsMuteConfigsPatchCall {
	c := &FoldersLocationsMuteConfigsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudsecuritycenterv1muteconfig = googlecloudsecuritycenterv1muteconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated. If empty all mutable fields will be updated.
func (c *FoldersLocationsMuteConfigsPatchCall) UpdateMask(updateMask string) *FoldersLocationsMuteConfigsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersLocationsMuteConfigsPatchCall) Fields(s ...googleapi.Field) *FoldersLocationsMuteConfigsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersLocationsMuteConfigsPatchCall) Context(ctx context.Context) *FoldersLocationsMuteConfigsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersLocationsMuteConfigsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsMuteConfigsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudsecuritycenterv1muteconfig)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.locations.muteConfigs.patch" call.
// Exactly one of *GoogleCloudSecuritycenterV1MuteConfig or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudSecuritycenterV1MuteConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersLocationsMuteConfigsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1MuteConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1MuteConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a mute config.",
	//   "flatPath": "v1/folders/{foldersId}/locations/{locationsId}/muteConfigs/{muteConfigsId}",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.locations.muteConfigs.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "This field will be ignored if provided on config creation. Format \"organizations/{organization}/muteConfigs/{mute_config}\" \"folders/{folder}/muteConfigs/{mute_config}\" \"projects/{project}/muteConfigs/{mute_config}\" \"organizations/{organization}/locations/global/muteConfigs/{mute_config}\" \"folders/{folder}/locations/global/muteConfigs/{mute_config}\" \"projects/{project}/locations/global/muteConfigs/{mute_config}\"",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/locations/[^/]+/muteConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated. If empty all mutable fields will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudSecuritycenterV1MuteConfig"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1MuteConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.muteConfigs.create":

type FoldersMuteConfigsCreateCall struct {
	s                                     *Service
	parent                                string
	googlecloudsecuritycenterv1muteconfig *GoogleCloudSecuritycenterV1MuteConfig
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Create: Creates a mute config.
//
//   - parent: Resource name of the new mute configs's parent. Its format
//     is "organizations/[organization_id]", "folders/[folder_id]", or
//     "projects/[project_id]".
func (r *FoldersMuteConfigsService) Create(parent string, googlecloudsecuritycenterv1muteconfig *GoogleCloudSecuritycenterV1MuteConfig) *FoldersMuteConfigsCreateCall {
	c := &FoldersMuteConfigsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudsecuritycenterv1muteconfig = googlecloudsecuritycenterv1muteconfig
	return c
}

// MuteConfigId sets the optional parameter "muteConfigId": Required.
// Unique identifier provided by the client within the parent scope. It
// must consist of only lowercase letters, numbers, and hyphens, must
// start with a letter, must end with either a letter or a number, and
// must be 63 characters or less.
func (c *FoldersMuteConfigsCreateCall) MuteConfigId(muteConfigId string) *FoldersMuteConfigsCreateCall {
	c.urlParams_.Set("muteConfigId", muteConfigId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersMuteConfigsCreateCall) Fields(s ...googleapi.Field) *FoldersMuteConfigsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersMuteConfigsCreateCall) Context(ctx context.Context) *FoldersMuteConfigsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersMuteConfigsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersMuteConfigsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudsecuritycenterv1muteconfig)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/muteConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.muteConfigs.create" call.
// Exactly one of *GoogleCloudSecuritycenterV1MuteConfig or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudSecuritycenterV1MuteConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersMuteConfigsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1MuteConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1MuteConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a mute config.",
	//   "flatPath": "v1/folders/{foldersId}/muteConfigs",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.folders.muteConfigs.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "muteConfigId": {
	//       "description": "Required. Unique identifier provided by the client within the parent scope. It must consist of only lowercase letters, numbers, and hyphens, must start with a letter, must end with either a letter or a number, and must be 63 characters or less.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Resource name of the new mute configs's parent. Its format is \"organizations/[organization_id]\", \"folders/[folder_id]\", or \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/muteConfigs",
	//   "request": {
	//     "$ref": "GoogleCloudSecuritycenterV1MuteConfig"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1MuteConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.muteConfigs.delete":

type FoldersMuteConfigsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing mute config.
//
//   - name: Name of the mute config to delete. Its format is
//     organizations/{organization}/muteConfigs/{config_id},
//     folders/{folder}/muteConfigs/{config_id},
//     projects/{project}/muteConfigs/{config_id},
//     organizations/{organization}/locations/global/muteConfigs/{config_id
//     }, folders/{folder}/locations/global/muteConfigs/{config_id}, or
//     projects/{project}/locations/global/muteConfigs/{config_id}.
func (r *FoldersMuteConfigsService) Delete(name string) *FoldersMuteConfigsDeleteCall {
	c := &FoldersMuteConfigsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersMuteConfigsDeleteCall) Fields(s ...googleapi.Field) *FoldersMuteConfigsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersMuteConfigsDeleteCall) Context(ctx context.Context) *FoldersMuteConfigsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersMuteConfigsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersMuteConfigsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.muteConfigs.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *FoldersMuteConfigsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an existing mute config.",
	//   "flatPath": "v1/folders/{foldersId}/muteConfigs/{muteConfigsId}",
	//   "httpMethod": "DELETE",
	//   "id": "securitycenter.folders.muteConfigs.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the mute config to delete. Its format is organizations/{organization}/muteConfigs/{config_id}, folders/{folder}/muteConfigs/{config_id}, projects/{project}/muteConfigs/{config_id}, organizations/{organization}/locations/global/muteConfigs/{config_id}, folders/{folder}/locations/global/muteConfigs/{config_id}, or projects/{project}/locations/global/muteConfigs/{config_id}.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/muteConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.muteConfigs.get":

type FoldersMuteConfigsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a mute config.
//
//   - name: Name of the mute config to retrieve. Its format is
//     organizations/{organization}/muteConfigs/{config_id},
//     folders/{folder}/muteConfigs/{config_id},
//     projects/{project}/muteConfigs/{config_id},
//     organizations/{organization}/locations/global/muteConfigs/{config_id
//     }, folders/{folder}/locations/global/muteConfigs/{config_id}, or
//     projects/{project}/locations/global/muteConfigs/{config_id}.
func (r *FoldersMuteConfigsService) Get(name string) *FoldersMuteConfigsGetCall {
	c := &FoldersMuteConfigsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersMuteConfigsGetCall) Fields(s ...googleapi.Field) *FoldersMuteConfigsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersMuteConfigsGetCall) IfNoneMatch(entityTag string) *FoldersMuteConfigsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersMuteConfigsGetCall) Context(ctx context.Context) *FoldersMuteConfigsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersMuteConfigsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersMuteConfigsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.muteConfigs.get" call.
// Exactly one of *GoogleCloudSecuritycenterV1MuteConfig or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudSecuritycenterV1MuteConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersMuteConfigsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1MuteConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1MuteConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a mute config.",
	//   "flatPath": "v1/folders/{foldersId}/muteConfigs/{muteConfigsId}",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.muteConfigs.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the mute config to retrieve. Its format is organizations/{organization}/muteConfigs/{config_id}, folders/{folder}/muteConfigs/{config_id}, projects/{project}/muteConfigs/{config_id}, organizations/{organization}/locations/global/muteConfigs/{config_id}, folders/{folder}/locations/global/muteConfigs/{config_id}, or projects/{project}/locations/global/muteConfigs/{config_id}.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/muteConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1MuteConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.muteConfigs.list":

type FoldersMuteConfigsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists mute configs.
//
//   - parent: The parent, which owns the collection of mute configs. Its
//     format is "organizations/[organization_id]", "folders/[folder_id]",
//     "projects/[project_id]".
func (r *FoldersMuteConfigsService) List(parent string) *FoldersMuteConfigsListCall {
	c := &FoldersMuteConfigsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of configs to return. The service may return fewer than this value.
// If unspecified, at most 10 configs will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *FoldersMuteConfigsListCall) PageSize(pageSize int64) *FoldersMuteConfigsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListMuteConfigs` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListMuteConfigs` must match the call that provided the
// page token.
func (c *FoldersMuteConfigsListCall) PageToken(pageToken string) *FoldersMuteConfigsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersMuteConfigsListCall) Fields(s ...googleapi.Field) *FoldersMuteConfigsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersMuteConfigsListCall) IfNoneMatch(entityTag string) *FoldersMuteConfigsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersMuteConfigsListCall) Context(ctx context.Context) *FoldersMuteConfigsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersMuteConfigsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersMuteConfigsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/muteConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.muteConfigs.list" call.
// Exactly one of *ListMuteConfigsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListMuteConfigsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersMuteConfigsListCall) Do(opts ...googleapi.CallOption) (*ListMuteConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMuteConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists mute configs.",
	//   "flatPath": "v1/folders/{foldersId}/muteConfigs",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.muteConfigs.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of configs to return. The service may return fewer than this value. If unspecified, at most 10 configs will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListMuteConfigs` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListMuteConfigs` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent, which owns the collection of mute configs. Its format is \"organizations/[organization_id]\", \"folders/[folder_id]\", \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/muteConfigs",
	//   "response": {
	//     "$ref": "ListMuteConfigsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersMuteConfigsListCall) Pages(ctx context.Context, f func(*ListMuteConfigsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.folders.muteConfigs.patch":

type FoldersMuteConfigsPatchCall struct {
	s                                     *Service
	name                                  string
	googlecloudsecuritycenterv1muteconfig *GoogleCloudSecuritycenterV1MuteConfig
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Patch: Updates a mute config.
//
//   - name: This field will be ignored if provided on config creation.
//     Format "organizations/{organization}/muteConfigs/{mute_config}"
//     "folders/{folder}/muteConfigs/{mute_config}"
//     "projects/{project}/muteConfigs/{mute_config}"
//     "organizations/{organization}/locations/global/muteConfigs/{mute_con
//     fig}" "folders/{folder}/locations/global/muteConfigs/{mute_config}"
//     "projects/{project}/locations/global/muteConfigs/{mute_config}".
func (r *FoldersMuteConfigsService) Patch(name string, googlecloudsecuritycenterv1muteconfig *GoogleCloudSecuritycenterV1MuteConfig) *FoldersMuteConfigsPatchCall {
	c := &FoldersMuteConfigsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudsecuritycenterv1muteconfig = googlecloudsecuritycenterv1muteconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated. If empty all mutable fields will be updated.
func (c *FoldersMuteConfigsPatchCall) UpdateMask(updateMask string) *FoldersMuteConfigsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersMuteConfigsPatchCall) Fields(s ...googleapi.Field) *FoldersMuteConfigsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersMuteConfigsPatchCall) Context(ctx context.Context) *FoldersMuteConfigsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersMuteConfigsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersMuteConfigsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudsecuritycenterv1muteconfig)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.muteConfigs.patch" call.
// Exactly one of *GoogleCloudSecuritycenterV1MuteConfig or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudSecuritycenterV1MuteConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersMuteConfigsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1MuteConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1MuteConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a mute config.",
	//   "flatPath": "v1/folders/{foldersId}/muteConfigs/{muteConfigsId}",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.muteConfigs.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "This field will be ignored if provided on config creation. Format \"organizations/{organization}/muteConfigs/{mute_config}\" \"folders/{folder}/muteConfigs/{mute_config}\" \"projects/{project}/muteConfigs/{mute_config}\" \"organizations/{organization}/locations/global/muteConfigs/{mute_config}\" \"folders/{folder}/locations/global/muteConfigs/{mute_config}\" \"projects/{project}/locations/global/muteConfigs/{mute_config}\"",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/muteConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated. If empty all mutable fields will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudSecuritycenterV1MuteConfig"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1MuteConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.notificationConfigs.create":

type FoldersNotificationConfigsCreateCall struct {
	s                  *Service
	parent             string
	notificationconfig *NotificationConfig
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Create: Creates a notification config.
//
//   - parent: Resource name of the new notification config's parent. Its
//     format is "organizations/[organization_id]", "folders/[folder_id]",
//     or "projects/[project_id]".
func (r *FoldersNotificationConfigsService) Create(parent string, notificationconfig *NotificationConfig) *FoldersNotificationConfigsCreateCall {
	c := &FoldersNotificationConfigsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.notificationconfig = notificationconfig
	return c
}

// ConfigId sets the optional parameter "configId": Required. Unique
// identifier provided by the client within the parent scope. It must be
// between 1 and 128 characters and contain alphanumeric characters,
// underscores, or hyphens only.
func (c *FoldersNotificationConfigsCreateCall) ConfigId(configId string) *FoldersNotificationConfigsCreateCall {
	c.urlParams_.Set("configId", configId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersNotificationConfigsCreateCall) Fields(s ...googleapi.Field) *FoldersNotificationConfigsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersNotificationConfigsCreateCall) Context(ctx context.Context) *FoldersNotificationConfigsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersNotificationConfigsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersNotificationConfigsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.notificationconfig)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/notificationConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.notificationConfigs.create" call.
// Exactly one of *NotificationConfig or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *NotificationConfig.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersNotificationConfigsCreateCall) Do(opts ...googleapi.CallOption) (*NotificationConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NotificationConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a notification config.",
	//   "flatPath": "v1/folders/{foldersId}/notificationConfigs",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.folders.notificationConfigs.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "configId": {
	//       "description": "Required. Unique identifier provided by the client within the parent scope. It must be between 1 and 128 characters and contain alphanumeric characters, underscores, or hyphens only.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Resource name of the new notification config's parent. Its format is \"organizations/[organization_id]\", \"folders/[folder_id]\", or \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/notificationConfigs",
	//   "request": {
	//     "$ref": "NotificationConfig"
	//   },
	//   "response": {
	//     "$ref": "NotificationConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.notificationConfigs.delete":

type FoldersNotificationConfigsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a notification config.
//
//   - name: Name of the notification config to delete. Its format is
//     "organizations/[organization_id]/notificationConfigs/[config_id]",
//     "folders/[folder_id]/notificationConfigs/[config_id]", or
//     "projects/[project_id]/notificationConfigs/[config_id]".
func (r *FoldersNotificationConfigsService) Delete(name string) *FoldersNotificationConfigsDeleteCall {
	c := &FoldersNotificationConfigsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersNotificationConfigsDeleteCall) Fields(s ...googleapi.Field) *FoldersNotificationConfigsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersNotificationConfigsDeleteCall) Context(ctx context.Context) *FoldersNotificationConfigsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersNotificationConfigsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersNotificationConfigsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.notificationConfigs.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *FoldersNotificationConfigsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a notification config.",
	//   "flatPath": "v1/folders/{foldersId}/notificationConfigs/{notificationConfigsId}",
	//   "httpMethod": "DELETE",
	//   "id": "securitycenter.folders.notificationConfigs.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the notification config to delete. Its format is \"organizations/[organization_id]/notificationConfigs/[config_id]\", \"folders/[folder_id]/notificationConfigs/[config_id]\", or \"projects/[project_id]/notificationConfigs/[config_id]\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/notificationConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.notificationConfigs.get":

type FoldersNotificationConfigsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a notification config.
//
//   - name: Name of the notification config to get. Its format is
//     "organizations/[organization_id]/notificationConfigs/[config_id]",
//     "folders/[folder_id]/notificationConfigs/[config_id]", or
//     "projects/[project_id]/notificationConfigs/[config_id]".
func (r *FoldersNotificationConfigsService) Get(name string) *FoldersNotificationConfigsGetCall {
	c := &FoldersNotificationConfigsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersNotificationConfigsGetCall) Fields(s ...googleapi.Field) *FoldersNotificationConfigsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersNotificationConfigsGetCall) IfNoneMatch(entityTag string) *FoldersNotificationConfigsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersNotificationConfigsGetCall) Context(ctx context.Context) *FoldersNotificationConfigsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersNotificationConfigsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersNotificationConfigsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.notificationConfigs.get" call.
// Exactly one of *NotificationConfig or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *NotificationConfig.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersNotificationConfigsGetCall) Do(opts ...googleapi.CallOption) (*NotificationConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NotificationConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a notification config.",
	//   "flatPath": "v1/folders/{foldersId}/notificationConfigs/{notificationConfigsId}",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.notificationConfigs.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the notification config to get. Its format is \"organizations/[organization_id]/notificationConfigs/[config_id]\", \"folders/[folder_id]/notificationConfigs/[config_id]\", or \"projects/[project_id]/notificationConfigs/[config_id]\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/notificationConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "NotificationConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.notificationConfigs.list":

type FoldersNotificationConfigsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists notification configs.
//
//   - parent: The name of the parent in which to list the notification
//     configurations. Its format is "organizations/[organization_id]",
//     "folders/[folder_id]", or "projects/[project_id]".
func (r *FoldersNotificationConfigsService) List(parent string) *FoldersNotificationConfigsListCall {
	c := &FoldersNotificationConfigsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return in a single response. Default is 10, minimum is
// 1, maximum is 1000.
func (c *FoldersNotificationConfigsListCall) PageSize(pageSize int64) *FoldersNotificationConfigsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned
// by the last `ListNotificationConfigsResponse`; indicates that this is
// a continuation of a prior `ListNotificationConfigs` call, and that
// the system should return the next page of data.
func (c *FoldersNotificationConfigsListCall) PageToken(pageToken string) *FoldersNotificationConfigsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersNotificationConfigsListCall) Fields(s ...googleapi.Field) *FoldersNotificationConfigsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersNotificationConfigsListCall) IfNoneMatch(entityTag string) *FoldersNotificationConfigsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersNotificationConfigsListCall) Context(ctx context.Context) *FoldersNotificationConfigsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersNotificationConfigsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersNotificationConfigsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/notificationConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.notificationConfigs.list" call.
// Exactly one of *ListNotificationConfigsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListNotificationConfigsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersNotificationConfigsListCall) Do(opts ...googleapi.CallOption) (*ListNotificationConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListNotificationConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists notification configs.",
	//   "flatPath": "v1/folders/{foldersId}/notificationConfigs",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.notificationConfigs.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of results to return in a single response. Default is 10, minimum is 1, maximum is 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The value returned by the last `ListNotificationConfigsResponse`; indicates that this is a continuation of a prior `ListNotificationConfigs` call, and that the system should return the next page of data.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the parent in which to list the notification configurations. Its format is \"organizations/[organization_id]\", \"folders/[folder_id]\", or \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/notificationConfigs",
	//   "response": {
	//     "$ref": "ListNotificationConfigsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersNotificationConfigsListCall) Pages(ctx context.Context, f func(*ListNotificationConfigsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.folders.notificationConfigs.patch":

type FoldersNotificationConfigsPatchCall struct {
	s                  *Service
	name               string
	notificationconfig *NotificationConfig
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch:  Updates a notification config. The following update fields
// are allowed: description, pubsub_topic, streaming_config.filter
//
//   - name: The relative resource name of this notification config. See:
//     https://cloud.google.com/apis/design/resource_names#relative_resource_name
//     Example:
//     "organizations/{organization_id}/notificationConfigs/notify_public_b
//     ucket",
//     "folders/{folder_id}/notificationConfigs/notify_public_bucket", or
//     "projects/{project_id}/notificationConfigs/notify_public_bucket".
func (r *FoldersNotificationConfigsService) Patch(name string, notificationconfig *NotificationConfig) *FoldersNotificationConfigsPatchCall {
	c := &FoldersNotificationConfigsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.notificationconfig = notificationconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": The FieldMask to
// use when updating the notification config. If empty all mutable
// fields will be updated.
func (c *FoldersNotificationConfigsPatchCall) UpdateMask(updateMask string) *FoldersNotificationConfigsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersNotificationConfigsPatchCall) Fields(s ...googleapi.Field) *FoldersNotificationConfigsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersNotificationConfigsPatchCall) Context(ctx context.Context) *FoldersNotificationConfigsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersNotificationConfigsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersNotificationConfigsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.notificationconfig)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.notificationConfigs.patch" call.
// Exactly one of *NotificationConfig or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *NotificationConfig.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersNotificationConfigsPatchCall) Do(opts ...googleapi.CallOption) (*NotificationConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NotificationConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": " Updates a notification config. The following update fields are allowed: description, pubsub_topic, streaming_config.filter",
	//   "flatPath": "v1/folders/{foldersId}/notificationConfigs/{notificationConfigsId}",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.notificationConfigs.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The relative resource name of this notification config. See: https://cloud.google.com/apis/design/resource_names#relative_resource_name Example: \"organizations/{organization_id}/notificationConfigs/notify_public_bucket\", \"folders/{folder_id}/notificationConfigs/notify_public_bucket\", or \"projects/{project_id}/notificationConfigs/notify_public_bucket\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/notificationConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The FieldMask to use when updating the notification config. If empty all mutable fields will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "NotificationConfig"
	//   },
	//   "response": {
	//     "$ref": "NotificationConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.securityHealthAnalyticsSettings.customModules.create":

type FoldersSecurityHealthAnalyticsSettingsCustomModulesCreateCall struct {
	s                                                              *Service
	parent                                                         string
	googlecloudsecuritycenterv1securityhealthanalyticscustommodule *GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule
	urlParams_                                                     gensupport.URLParams
	ctx_                                                           context.Context
	header_                                                        http.Header
}

// Create: Creates a resident SecurityHealthAnalyticsCustomModule at the
// scope of the given CRM parent, and also creates inherited
// SecurityHealthAnalyticsCustomModules for all CRM descendants of the
// given parent. These modules are enabled by default.
//
//   - parent: Resource name of the new custom module's parent. Its format
//     is "organizations/{organization}/securityHealthAnalyticsSettings",
//     "folders/{folder}/securityHealthAnalyticsSettings", or
//     "projects/{project}/securityHealthAnalyticsSettings".
func (r *FoldersSecurityHealthAnalyticsSettingsCustomModulesService) Create(parent string, googlecloudsecuritycenterv1securityhealthanalyticscustommodule *GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule) *FoldersSecurityHealthAnalyticsSettingsCustomModulesCreateCall {
	c := &FoldersSecurityHealthAnalyticsSettingsCustomModulesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudsecuritycenterv1securityhealthanalyticscustommodule = googlecloudsecuritycenterv1securityhealthanalyticscustommodule
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesCreateCall) Fields(s ...googleapi.Field) *FoldersSecurityHealthAnalyticsSettingsCustomModulesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesCreateCall) Context(ctx context.Context) *FoldersSecurityHealthAnalyticsSettingsCustomModulesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudsecuritycenterv1securityhealthanalyticscustommodule)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/customModules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.securityHealthAnalyticsSettings.customModules.create" call.
// Exactly one of
// *GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule.Server
// Response.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the given CRM parent, and also creates inherited SecurityHealthAnalyticsCustomModules for all CRM descendants of the given parent. These modules are enabled by default.",
	//   "flatPath": "v1/folders/{foldersId}/securityHealthAnalyticsSettings/customModules",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.folders.securityHealthAnalyticsSettings.customModules.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Resource name of the new custom module's parent. Its format is \"organizations/{organization}/securityHealthAnalyticsSettings\", \"folders/{folder}/securityHealthAnalyticsSettings\", or \"projects/{project}/securityHealthAnalyticsSettings\"",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/customModules",
	//   "request": {
	//     "$ref": "GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.securityHealthAnalyticsSettings.customModules.delete":

type FoldersSecurityHealthAnalyticsSettingsCustomModulesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified SecurityHealthAnalyticsCustomModule and
// all of its descendants in the CRM hierarchy. This method is only
// supported for resident custom modules.
//
//   - name: Name of the custom module to delete. Its format is
//     "organizations/{organization}/securityHealthAnalyticsSettings/custom
//     Modules/{customModule}",
//     "folders/{folder}/securityHealthAnalyticsSettings/customModules/{cus
//     tomModule}", or
//     "projects/{project}/securityHealthAnalyticsSettings/customModules/{c
//     ustomModule}".
func (r *FoldersSecurityHealthAnalyticsSettingsCustomModulesService) Delete(name string) *FoldersSecurityHealthAnalyticsSettingsCustomModulesDeleteCall {
	c := &FoldersSecurityHealthAnalyticsSettingsCustomModulesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesDeleteCall) Fields(s ...googleapi.Field) *FoldersSecurityHealthAnalyticsSettingsCustomModulesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesDeleteCall) Context(ctx context.Context) *FoldersSecurityHealthAnalyticsSettingsCustomModulesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.securityHealthAnalyticsSettings.customModules.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the specified SecurityHealthAnalyticsCustomModule and all of its descendants in the CRM hierarchy. This method is only supported for resident custom modules.",
	//   "flatPath": "v1/folders/{foldersId}/securityHealthAnalyticsSettings/customModules/{customModulesId}",
	//   "httpMethod": "DELETE",
	//   "id": "securitycenter.folders.securityHealthAnalyticsSettings.customModules.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the custom module to delete. Its format is \"organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}\", \"folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}\", or \"projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}\"",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/securityHealthAnalyticsSettings/customModules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.securityHealthAnalyticsSettings.customModules.get":

type FoldersSecurityHealthAnalyticsSettingsCustomModulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a SecurityHealthAnalyticsCustomModule.
//
//   - name: Name of the custom module to get. Its format is
//     "organizations/{organization}/securityHealthAnalyticsSettings/custom
//     Modules/{customModule}",
//     "folders/{folder}/securityHealthAnalyticsSettings/customModules/{cus
//     tomModule}", or
//     "projects/{project}/securityHealthAnalyticsSettings/customModules/{c
//     ustomModule}".
func (r *FoldersSecurityHealthAnalyticsSettingsCustomModulesService) Get(name string) *FoldersSecurityHealthAnalyticsSettingsCustomModulesGetCall {
	c := &FoldersSecurityHealthAnalyticsSettingsCustomModulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesGetCall) Fields(s ...googleapi.Field) *FoldersSecurityHealthAnalyticsSettingsCustomModulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesGetCall) IfNoneMatch(entityTag string) *FoldersSecurityHealthAnalyticsSettingsCustomModulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesGetCall) Context(ctx context.Context) *FoldersSecurityHealthAnalyticsSettingsCustomModulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.securityHealthAnalyticsSettings.customModules.get" call.
// Exactly one of
// *GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule.Server
// Response.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a SecurityHealthAnalyticsCustomModule.",
	//   "flatPath": "v1/folders/{foldersId}/securityHealthAnalyticsSettings/customModules/{customModulesId}",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.securityHealthAnalyticsSettings.customModules.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the custom module to get. Its format is \"organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}\", \"folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}\", or \"projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}\"",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/securityHealthAnalyticsSettings/customModules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.securityHealthAnalyticsSettings.customModules.list":

type FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all SecurityHealthAnalyticsCustomModules for
// the given parent. This includes resident modules defined at the scope
// of the parent, and inherited modules, inherited from CRM ancestors.
//
//   - parent: Name of parent to list custom modules. Its format is
//     "organizations/{organization}/securityHealthAnalyticsSettings",
//     "folders/{folder}/securityHealthAnalyticsSettings", or
//     "projects/{project}/securityHealthAnalyticsSettings".
func (r *FoldersSecurityHealthAnalyticsSettingsCustomModulesService) List(parent string) *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall {
	c := &FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return in a single response. Default is 10, minimum is
// 1, maximum is 1000.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall) PageSize(pageSize int64) *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned
// by the last call indicating a continuation
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall) PageToken(pageToken string) *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall) Fields(s ...googleapi.Field) *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall) IfNoneMatch(entityTag string) *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall) Context(ctx context.Context) *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/customModules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.securityHealthAnalyticsSettings.customModules.list" call.
// Exactly one of *ListSecurityHealthAnalyticsCustomModulesResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *ListSecurityHealthAnalyticsCustomModulesResponse.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall) Do(opts ...googleapi.CallOption) (*ListSecurityHealthAnalyticsCustomModulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSecurityHealthAnalyticsCustomModulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a list of all SecurityHealthAnalyticsCustomModules for the given parent. This includes resident modules defined at the scope of the parent, and inherited modules, inherited from CRM ancestors.",
	//   "flatPath": "v1/folders/{foldersId}/securityHealthAnalyticsSettings/customModules",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.securityHealthAnalyticsSettings.customModules.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of results to return in a single response. Default is 10, minimum is 1, maximum is 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The value returned by the last call indicating a continuation",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of parent to list custom modules. Its format is \"organizations/{organization}/securityHealthAnalyticsSettings\", \"folders/{folder}/securityHealthAnalyticsSettings\", or \"projects/{project}/securityHealthAnalyticsSettings\"",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/customModules",
	//   "response": {
	//     "$ref": "ListSecurityHealthAnalyticsCustomModulesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListCall) Pages(ctx context.Context, f func(*ListSecurityHealthAnalyticsCustomModulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.folders.securityHealthAnalyticsSettings.customModules.listDescendant":

type FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListDescendant: Returns a list of all resident
// SecurityHealthAnalyticsCustomModules under the given CRM parent and
// all of the parent’s CRM descendants.
//
//   - parent: Name of parent to list descendant custom modules. Its
//     format is
//     "organizations/{organization}/securityHealthAnalyticsSettings",
//     "folders/{folder}/securityHealthAnalyticsSettings", or
//     "projects/{project}/securityHealthAnalyticsSettings".
func (r *FoldersSecurityHealthAnalyticsSettingsCustomModulesService) ListDescendant(parent string) *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall {
	c := &FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return in a single response. Default is 10, minimum is
// 1, maximum is 1000.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall) PageSize(pageSize int64) *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned
// by the last call indicating a continuation
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall) PageToken(pageToken string) *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall) Fields(s ...googleapi.Field) *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall) IfNoneMatch(entityTag string) *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall) Context(ctx context.Context) *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/customModules:listDescendant")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.securityHealthAnalyticsSettings.customModules.listDescendant" call.
// Exactly one of
// *ListDescendantSecurityHealthAnalyticsCustomModulesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *ListDescendantSecurityHealthAnalyticsCustomModulesResponse.ServerResp
// onse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall) Do(opts ...googleapi.CallOption) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDescendantSecurityHealthAnalyticsCustomModulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a list of all resident SecurityHealthAnalyticsCustomModules under the given CRM parent and all of the parent’s CRM descendants.",
	//   "flatPath": "v1/folders/{foldersId}/securityHealthAnalyticsSettings/customModules:listDescendant",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.securityHealthAnalyticsSettings.customModules.listDescendant",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of results to return in a single response. Default is 10, minimum is 1, maximum is 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The value returned by the last call indicating a continuation",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of parent to list descendant custom modules. Its format is \"organizations/{organization}/securityHealthAnalyticsSettings\", \"folders/{folder}/securityHealthAnalyticsSettings\", or \"projects/{project}/securityHealthAnalyticsSettings\"",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/customModules:listDescendant",
	//   "response": {
	//     "$ref": "ListDescendantSecurityHealthAnalyticsCustomModulesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesListDescendantCall) Pages(ctx context.Context, f func(*ListDescendantSecurityHealthAnalyticsCustomModulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.folders.securityHealthAnalyticsSettings.customModules.patch":

type FoldersSecurityHealthAnalyticsSettingsCustomModulesPatchCall struct {
	s                                                              *Service
	name                                                           string
	googlecloudsecuritycenterv1securityhealthanalyticscustommodule *GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule
	urlParams_                                                     gensupport.URLParams
	ctx_                                                           context.Context
	header_                                                        http.Header
}

// Patch: Updates the SecurityHealthAnalyticsCustomModule under the
// given name based on the given update mask. Updating the enablement
// state is supported on both resident and inherited modules (though
// resident modules cannot have an enablement state of "inherited").
// Updating the display name and custom config of a module is supported
// on resident modules only.
//
//   - name: Immutable. The resource name of the custom module. Its format
//     is
//     "organizations/{organization}/securityHealthAnalyticsSettings/custom
//     Modules/{customModule}", or
//     "folders/{folder}/securityHealthAnalyticsSettings/customModules/{cus
//     tomModule}", or
//     "projects/{project}/securityHealthAnalyticsSettings/customModules/{c
//     ustomModule}" The id {customModule} is server-generated and is not
//     user settable. It will be a numeric id containing 1-20 digits.
func (r *FoldersSecurityHealthAnalyticsSettingsCustomModulesService) Patch(name string, googlecloudsecuritycenterv1securityhealthanalyticscustommodule *GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule) *FoldersSecurityHealthAnalyticsSettingsCustomModulesPatchCall {
	c := &FoldersSecurityHealthAnalyticsSettingsCustomModulesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudsecuritycenterv1securityhealthanalyticscustommodule = googlecloudsecuritycenterv1securityhealthanalyticscustommodule
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated. The only fields that can be updated are
// `enablement_state` and `custom_config`. If empty or set to the
// wildcard value `*`, both `enablement_state` and `custom_config` are
// updated.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesPatchCall) UpdateMask(updateMask string) *FoldersSecurityHealthAnalyticsSettingsCustomModulesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesPatchCall) Fields(s ...googleapi.Field) *FoldersSecurityHealthAnalyticsSettingsCustomModulesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesPatchCall) Context(ctx context.Context) *FoldersSecurityHealthAnalyticsSettingsCustomModulesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudsecuritycenterv1securityhealthanalyticscustommodule)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.securityHealthAnalyticsSettings.customModules.patch" call.
// Exactly one of
// *GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule.Server
// Response.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the SecurityHealthAnalyticsCustomModule under the given name based on the given update mask. Updating the enablement state is supported on both resident and inherited modules (though resident modules cannot have an enablement state of \"inherited\"). Updating the display name and custom config of a module is supported on resident modules only.",
	//   "flatPath": "v1/folders/{foldersId}/securityHealthAnalyticsSettings/customModules/{customModulesId}",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.securityHealthAnalyticsSettings.customModules.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The resource name of the custom module. Its format is \"organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}\", or \"folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}\", or \"projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}\" The id {customModule} is server-generated and is not user settable. It will be a numeric id containing 1-20 digits.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/securityHealthAnalyticsSettings/customModules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated. The only fields that can be updated are `enablement_state` and `custom_config`. If empty or set to the wildcard value `*`, both `enablement_state` and `custom_config` are updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1SecurityHealthAnalyticsCustomModule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.securityHealthAnalyticsSettings.customModules.simulate":

type FoldersSecurityHealthAnalyticsSettingsCustomModulesSimulateCall struct {
	s                                                  *Service
	parent                                             string
	simulatesecurityhealthanalyticscustommodulerequest *SimulateSecurityHealthAnalyticsCustomModuleRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Simulate: Simulates a given SecurityHealthAnalyticsCustomModule and
// Resource.
//
//   - parent: The relative resource name of the organization, project, or
//     folder. For more information about relative resource names, see
//     Relative Resource Name
//     (https://cloud.google.com/apis/design/resource_names#relative_resource_name)
//     Example: `organizations/{organization_id}`.
func (r *FoldersSecurityHealthAnalyticsSettingsCustomModulesService) Simulate(parent string, simulatesecurityhealthanalyticscustommodulerequest *SimulateSecurityHealthAnalyticsCustomModuleRequest) *FoldersSecurityHealthAnalyticsSettingsCustomModulesSimulateCall {
	c := &FoldersSecurityHealthAnalyticsSettingsCustomModulesSimulateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.simulatesecurityhealthanalyticscustommodulerequest = simulatesecurityhealthanalyticscustommodulerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesSimulateCall) Fields(s ...googleapi.Field) *FoldersSecurityHealthAnalyticsSettingsCustomModulesSimulateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesSimulateCall) Context(ctx context.Context) *FoldersSecurityHealthAnalyticsSettingsCustomModulesSimulateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesSimulateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesSimulateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.simulatesecurityhealthanalyticscustommodulerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/customModules:simulate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.securityHealthAnalyticsSettings.customModules.simulate" call.
// Exactly one of *SimulateSecurityHealthAnalyticsCustomModuleResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *SimulateSecurityHealthAnalyticsCustomModuleResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSecurityHealthAnalyticsSettingsCustomModulesSimulateCall) Do(opts ...googleapi.CallOption) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SimulateSecurityHealthAnalyticsCustomModuleResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Simulates a given SecurityHealthAnalyticsCustomModule and Resource.",
	//   "flatPath": "v1/folders/{foldersId}/securityHealthAnalyticsSettings/customModules:simulate",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.folders.securityHealthAnalyticsSettings.customModules.simulate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The relative resource name of the organization, project, or folder. For more information about relative resource names, see [Relative Resource Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name) Example: `organizations/{organization_id}`",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/customModules:simulate",
	//   "request": {
	//     "$ref": "SimulateSecurityHealthAnalyticsCustomModuleRequest"
	//   },
	//   "response": {
	//     "$ref": "SimulateSecurityHealthAnalyticsCustomModuleResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.securityHealthAnalyticsSettings.effectiveCustomModules.get":

type FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves an EffectiveSecurityHealthAnalyticsCustomModule.
//
//   - name: Name of the effective custom module to get. Its format is
//     "organizations/{organization}/securityHealthAnalyticsSettings/effect
//     iveCustomModules/{customModule}",
//     "folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomMod
//     ules/{customModule}", or
//     "projects/{project}/securityHealthAnalyticsSettings/effectiveCustomM
//     odules/{customModule}".
func (r *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesService) Get(name string) *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesGetCall {
	c := &FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesGetCall) Fields(s ...googleapi.Field) *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesGetCall) IfNoneMatch(entityTag string) *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesGetCall) Context(ctx context.Context) *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.securityHealthAnalyticsSettings.effectiveCustomModules.get" call.
// Exactly one of
// *GoogleCloudSecuritycenterV1EffectiveSecurityHealthAnalyticsCustomModu
// le or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudSecuritycenterV1EffectiveSecurityHealthAnalyticsCustomModu
// le.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1EffectiveSecurityHealthAnalyticsCustomModule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1EffectiveSecurityHealthAnalyticsCustomModule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves an EffectiveSecurityHealthAnalyticsCustomModule.",
	//   "flatPath": "v1/folders/{foldersId}/securityHealthAnalyticsSettings/effectiveCustomModules/{effectiveCustomModulesId}",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.securityHealthAnalyticsSettings.effectiveCustomModules.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the effective custom module to get. Its format is \"organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}\", \"folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}\", or \"projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}\"",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/securityHealthAnalyticsSettings/effectiveCustomModules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1EffectiveSecurityHealthAnalyticsCustomModule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.securityHealthAnalyticsSettings.effectiveCustomModules.list":

type FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all
// EffectiveSecurityHealthAnalyticsCustomModules for the given parent.
// This includes resident modules defined at the scope of the parent,
// and inherited modules, inherited from CRM ancestors.
//
//   - parent: Name of parent to list effective custom modules. Its format
//     is "organizations/{organization}/securityHealthAnalyticsSettings",
//     "folders/{folder}/securityHealthAnalyticsSettings", or
//     "projects/{project}/securityHealthAnalyticsSettings".
func (r *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesService) List(parent string) *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall {
	c := &FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return in a single response. Default is 10, minimum is
// 1, maximum is 1000.
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall) PageSize(pageSize int64) *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned
// by the last call indicating a continuation
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall) PageToken(pageToken string) *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall) Fields(s ...googleapi.Field) *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall) IfNoneMatch(entityTag string) *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall) Context(ctx context.Context) *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/effectiveCustomModules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.securityHealthAnalyticsSettings.effectiveCustomModules.list" call.
// Exactly one of
// *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall) Do(opts ...googleapi.CallOption) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEffectiveSecurityHealthAnalyticsCustomModulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the given parent. This includes resident modules defined at the scope of the parent, and inherited modules, inherited from CRM ancestors.",
	//   "flatPath": "v1/folders/{foldersId}/securityHealthAnalyticsSettings/effectiveCustomModules",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.securityHealthAnalyticsSettings.effectiveCustomModules.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of results to return in a single response. Default is 10, minimum is 1, maximum is 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The value returned by the last call indicating a continuation",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of parent to list effective custom modules. Its format is \"organizations/{organization}/securityHealthAnalyticsSettings\", \"folders/{folder}/securityHealthAnalyticsSettings\", or \"projects/{project}/securityHealthAnalyticsSettings\"",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/effectiveCustomModules",
	//   "response": {
	//     "$ref": "ListEffectiveSecurityHealthAnalyticsCustomModulesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersSecurityHealthAnalyticsSettingsEffectiveCustomModulesListCall) Pages(ctx context.Context, f func(*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.folders.sources.list":

type FoldersSourcesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all sources belonging to an organization.
//
//   - parent: Resource name of the parent of sources to list. Its format
//     should be "organizations/[organization_id]", "folders/[folder_id]",
//     or "projects/[project_id]".
func (r *FoldersSourcesService) List(parent string) *FoldersSourcesListCall {
	c := &FoldersSourcesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return in a single response. Default is 10, minimum is
// 1, maximum is 1000.
func (c *FoldersSourcesListCall) PageSize(pageSize int64) *FoldersSourcesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned
// by the last `ListSourcesResponse`; indicates that this is a
// continuation of a prior `ListSources` call, and that the system
// should return the next page of data.
func (c *FoldersSourcesListCall) PageToken(pageToken string) *FoldersSourcesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSourcesListCall) Fields(s ...googleapi.Field) *FoldersSourcesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersSourcesListCall) IfNoneMatch(entityTag string) *FoldersSourcesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSourcesListCall) Context(ctx context.Context) *FoldersSourcesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSourcesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSourcesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/sources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.sources.list" call.
// Exactly one of *ListSourcesResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListSourcesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersSourcesListCall) Do(opts ...googleapi.CallOption) (*ListSourcesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSourcesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all sources belonging to an organization.",
	//   "flatPath": "v1/folders/{foldersId}/sources",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.sources.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of results to return in a single response. Default is 10, minimum is 1, maximum is 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The value returned by the last `ListSourcesResponse`; indicates that this is a continuation of a prior `ListSources` call, and that the system should return the next page of data.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Resource name of the parent of sources to list. Its format should be \"organizations/[organization_id]\", \"folders/[folder_id]\", or \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/sources",
	//   "response": {
	//     "$ref": "ListSourcesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersSourcesListCall) Pages(ctx context.Context, f func(*ListSourcesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.folders.sources.findings.group":

type FoldersSourcesFindingsGroupCall struct {
	s                    *Service
	parent               string
	groupfindingsrequest *GroupFindingsRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Group: Filters an organization or source's findings and groups them
// by their specified properties. To group across all sources provide a
// `-` as the source id. Example:
// /v1/organizations/{organization_id}/sources/-/findings,
// /v1/folders/{folder_id}/sources/-/findings,
// /v1/projects/{project_id}/sources/-/findings
//
//   - parent: Name of the source to groupBy. Its format is
//     "organizations/[organization_id]/sources/[source_id]",
//     folders/[folder_id]/sources/[source_id], or
//     projects/[project_id]/sources/[source_id]. To groupBy across all
//     sources provide a source_id of `-`. For example:
//     organizations/{organization_id}/sources/-,
//     folders/{folder_id}/sources/-, or projects/{project_id}/sources/-.
func (r *FoldersSourcesFindingsService) Group(parent string, groupfindingsrequest *GroupFindingsRequest) *FoldersSourcesFindingsGroupCall {
	c := &FoldersSourcesFindingsGroupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.groupfindingsrequest = groupfindingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSourcesFindingsGroupCall) Fields(s ...googleapi.Field) *FoldersSourcesFindingsGroupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSourcesFindingsGroupCall) Context(ctx context.Context) *FoldersSourcesFindingsGroupCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSourcesFindingsGroupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSourcesFindingsGroupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.groupfindingsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/findings:group")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.sources.findings.group" call.
// Exactly one of *GroupFindingsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GroupFindingsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersSourcesFindingsGroupCall) Do(opts ...googleapi.CallOption) (*GroupFindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GroupFindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Filters an organization or source's findings and groups them by their specified properties. To group across all sources provide a `-` as the source id. Example: /v1/organizations/{organization_id}/sources/-/findings, /v1/folders/{folder_id}/sources/-/findings, /v1/projects/{project_id}/sources/-/findings",
	//   "flatPath": "v1/folders/{foldersId}/sources/{sourcesId}/findings:group",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.folders.sources.findings.group",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Name of the source to groupBy. Its format is \"organizations/[organization_id]/sources/[source_id]\", folders/[folder_id]/sources/[source_id], or projects/[project_id]/sources/[source_id]. To groupBy across all sources provide a source_id of `-`. For example: organizations/{organization_id}/sources/-, folders/{folder_id}/sources/-, or projects/{project_id}/sources/-",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/sources/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/findings:group",
	//   "request": {
	//     "$ref": "GroupFindingsRequest"
	//   },
	//   "response": {
	//     "$ref": "GroupFindingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersSourcesFindingsGroupCall) Pages(ctx context.Context, f func(*GroupFindingsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.groupfindingsrequest.PageToken = pt }(c.groupfindingsrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.groupfindingsrequest.PageToken = x.NextPageToken
	}
}

// method id "securitycenter.folders.sources.findings.list":

type FoldersSourcesFindingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists an organization or source's findings. To list across all
// sources provide a `-` as the source id. Example:
// /v1/organizations/{organization_id}/sources/-/findings
//
//   - parent: Name of the source the findings belong to. Its format is
//     "organizations/[organization_id]/sources/[source_id],
//     folders/[folder_id]/sources/[source_id], or
//     projects/[project_id]/sources/[source_id]". To list across all
//     sources provide a source_id of `-`. For example:
//     organizations/{organization_id}/sources/-,
//     folders/{folder_id}/sources/- or projects/{projects_id}/sources/-.
func (r *FoldersSourcesFindingsService) List(parent string) *FoldersSourcesFindingsListCall {
	c := &FoldersSourcesFindingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// CompareDuration sets the optional parameter "compareDuration": When
// compare_duration is set, the ListFindingsResult's "state_change"
// attribute is updated to indicate whether the finding had its state
// changed, the finding's state remained unchanged, or if the finding
// was added in any state during the compare_duration period of time
// that precedes the read_time. This is the time between (read_time -
// compare_duration) and read_time. The state_change value is derived
// based on the presence and state of the finding at the two points in
// time. Intermediate state changes between the two times don't affect
// the result. For example, the results aren't affected if the finding
// is made inactive and then active again. Possible "state_change"
// values when compare_duration is specified: * "CHANGED": indicates
// that the finding was present and matched the given filter at the
// start of compare_duration, but changed its state at read_time. *
// "UNCHANGED": indicates that the finding was present and matched the
// given filter at the start of compare_duration and did not change
// state at read_time. * "ADDED": indicates that the finding did not
// match the given filter or was not present at the start of
// compare_duration, but was present at read_time. * "REMOVED":
// indicates that the finding was present and matched the filter at the
// start of compare_duration, but did not match the filter at read_time.
// If compare_duration is not specified, then the only possible
// state_change is "UNUSED", which will be the state_change set for all
// findings present at read_time.
func (c *FoldersSourcesFindingsListCall) CompareDuration(compareDuration string) *FoldersSourcesFindingsListCall {
	c.urlParams_.Set("compareDuration", compareDuration)
	return c
}

// FieldMask sets the optional parameter "fieldMask": A field mask to
// specify the Finding fields to be listed in the response. An empty
// field mask will list all fields.
func (c *FoldersSourcesFindingsListCall) FieldMask(fieldMask string) *FoldersSourcesFindingsListCall {
	c.urlParams_.Set("fieldMask", fieldMask)
	return c
}

// Filter sets the optional parameter "filter": Expression that defines
// the filter to apply across findings. The expression is a list of one
// or more restrictions combined via logical operators `AND` and `OR`.
// Parentheses are supported, and `OR` has higher precedence than `AND`.
// Restrictions have the form ` ` and may have a `-` character in front
// of them to indicate negation. Examples include: * name *
// source_properties.a_property * security_marks.marks.marka The
// supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
// `<=` for integer values. * `:`, meaning substring matching, for
// strings. The supported value types are: * string literals in quotes.
// * integer literals without quotes. * boolean literals `true` and
// `false` without quotes. The following field and operator combinations
// are supported: * name: `=` * parent: `=`, `:` * resource_name: `=`,
// `:` * state: `=`, `:` * category: `=`, `:` * external_uri: `=`, `:` *
// event_time: `=`, `>`, `<`, `>=`, `<=` Usage: This should be
// milliseconds since epoch or an RFC3339 string. Examples: `event_time
// = "2019-06-10T16:07:18-07:00" `event_time = 1560208038000` *
// severity: `=`, `:` * workflow_state: `=`, `:` * security_marks.marks:
// `=`, `:` * source_properties: `=`, `:`, `>`, `<`, `>=`, `<=` For
// example, `source_properties.size = 100` is a valid filter string. Use
// a partial match on the empty string to filter based on a property
// existing: `source_properties.my_property : "" Use a negated partial
// match on the empty string to filter based on a property not existing:
// `-source_properties.my_property : "" * resource: * resource.name:
// `=`, `:` * resource.parent_name: `=`, `:` *
// resource.parent_display_name: `=`, `:` * resource.project_name: `=`,
// `:` * resource.project_display_name: `=`, `:` * resource.type: `=`,
// `:` * resource.folders.resource_folder: `=`, `:` *
// resource.display_name: `=`, `:`
func (c *FoldersSourcesFindingsListCall) Filter(filter string) *FoldersSourcesFindingsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Expression that
// defines what fields and order to use for sorting. The string value
// should follow SQL syntax: comma separated list of fields. For
// example: "name,resource_properties.a_property". The default sorting
// order is ascending. To specify descending order for a field, a suffix
// " desc" should be appended to the field name. For example: "name
// desc,source_properties.a_property". Redundant space characters in the
// syntax are insignificant. "name desc,source_properties.a_property"
// and " name desc , source_properties.a_property " are equivalent. The
// following fields are supported: name parent state category
// resource_name event_time source_properties security_marks.marks
func (c *FoldersSourcesFindingsListCall) OrderBy(orderBy string) *FoldersSourcesFindingsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return in a single response. Default is 10, minimum is
// 1, maximum is 1000.
func (c *FoldersSourcesFindingsListCall) PageSize(pageSize int64) *FoldersSourcesFindingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned
// by the last `ListFindingsResponse`; indicates that this is a
// continuation of a prior `ListFindings` call, and that the system
// should return the next page of data.
func (c *FoldersSourcesFindingsListCall) PageToken(pageToken string) *FoldersSourcesFindingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReadTime sets the optional parameter "readTime": Time used as a
// reference point when filtering findings. The filter is limited to
// findings existing at the supplied time and their values are those at
// that specific time. Absence of this field will default to the API's
// version of NOW.
func (c *FoldersSourcesFindingsListCall) ReadTime(readTime string) *FoldersSourcesFindingsListCall {
	c.urlParams_.Set("readTime", readTime)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSourcesFindingsListCall) Fields(s ...googleapi.Field) *FoldersSourcesFindingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersSourcesFindingsListCall) IfNoneMatch(entityTag string) *FoldersSourcesFindingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSourcesFindingsListCall) Context(ctx context.Context) *FoldersSourcesFindingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSourcesFindingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSourcesFindingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/findings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.sources.findings.list" call.
// Exactly one of *ListFindingsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListFindingsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersSourcesFindingsListCall) Do(opts ...googleapi.CallOption) (*ListFindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists an organization or source's findings. To list across all sources provide a `-` as the source id. Example: /v1/organizations/{organization_id}/sources/-/findings",
	//   "flatPath": "v1/folders/{foldersId}/sources/{sourcesId}/findings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.sources.findings.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "compareDuration": {
	//       "description": "When compare_duration is set, the ListFindingsResult's \"state_change\" attribute is updated to indicate whether the finding had its state changed, the finding's state remained unchanged, or if the finding was added in any state during the compare_duration period of time that precedes the read_time. This is the time between (read_time - compare_duration) and read_time. The state_change value is derived based on the presence and state of the finding at the two points in time. Intermediate state changes between the two times don't affect the result. For example, the results aren't affected if the finding is made inactive and then active again. Possible \"state_change\" values when compare_duration is specified: * \"CHANGED\": indicates that the finding was present and matched the given filter at the start of compare_duration, but changed its state at read_time. * \"UNCHANGED\": indicates that the finding was present and matched the given filter at the start of compare_duration and did not change state at read_time. * \"ADDED\": indicates that the finding did not match the given filter or was not present at the start of compare_duration, but was present at read_time. * \"REMOVED\": indicates that the finding was present and matched the filter at the start of compare_duration, but did not match the filter at read_time. If compare_duration is not specified, then the only possible state_change is \"UNUSED\", which will be the state_change set for all findings present at read_time.",
	//       "format": "google-duration",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "fieldMask": {
	//       "description": "A field mask to specify the Finding fields to be listed in the response. An empty field mask will list all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "filter": {
	//       "description": "Expression that defines the filter to apply across findings. The expression is a list of one or more restrictions combined via logical operators `AND` and `OR`. Parentheses are supported, and `OR` has higher precedence than `AND`. Restrictions have the form ` ` and may have a `-` character in front of them to indicate negation. Examples include: * name * source_properties.a_property * security_marks.marks.marka The supported operators are: * `=` for all value types. * `\u003e`, `\u003c`, `\u003e=`, `\u003c=` for integer values. * `:`, meaning substring matching, for strings. The supported value types are: * string literals in quotes. * integer literals without quotes. * boolean literals `true` and `false` without quotes. The following field and operator combinations are supported: * name: `=` * parent: `=`, `:` * resource_name: `=`, `:` * state: `=`, `:` * category: `=`, `:` * external_uri: `=`, `:` * event_time: `=`, `\u003e`, `\u003c`, `\u003e=`, `\u003c=` Usage: This should be milliseconds since epoch or an RFC3339 string. Examples: `event_time = \"2019-06-10T16:07:18-07:00\"` `event_time = 1560208038000` * severity: `=`, `:` * workflow_state: `=`, `:` * security_marks.marks: `=`, `:` * source_properties: `=`, `:`, `\u003e`, `\u003c`, `\u003e=`, `\u003c=` For example, `source_properties.size = 100` is a valid filter string. Use a partial match on the empty string to filter based on a property existing: `source_properties.my_property : \"\"` Use a negated partial match on the empty string to filter based on a property not existing: `-source_properties.my_property : \"\"` * resource: * resource.name: `=`, `:` * resource.parent_name: `=`, `:` * resource.parent_display_name: `=`, `:` * resource.project_name: `=`, `:` * resource.project_display_name: `=`, `:` * resource.type: `=`, `:` * resource.folders.resource_folder: `=`, `:` * resource.display_name: `=`, `:`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Expression that defines what fields and order to use for sorting. The string value should follow SQL syntax: comma separated list of fields. For example: \"name,resource_properties.a_property\". The default sorting order is ascending. To specify descending order for a field, a suffix \" desc\" should be appended to the field name. For example: \"name desc,source_properties.a_property\". Redundant space characters in the syntax are insignificant. \"name desc,source_properties.a_property\" and \" name desc , source_properties.a_property \" are equivalent. The following fields are supported: name parent state category resource_name event_time source_properties security_marks.marks",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of results to return in a single response. Default is 10, minimum is 1, maximum is 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The value returned by the last `ListFindingsResponse`; indicates that this is a continuation of a prior `ListFindings` call, and that the system should return the next page of data.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the source the findings belong to. Its format is \"organizations/[organization_id]/sources/[source_id], folders/[folder_id]/sources/[source_id], or projects/[project_id]/sources/[source_id]\". To list across all sources provide a source_id of `-`. For example: organizations/{organization_id}/sources/-, folders/{folder_id}/sources/- or projects/{projects_id}/sources/-",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/sources/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "readTime": {
	//       "description": "Time used as a reference point when filtering findings. The filter is limited to findings existing at the supplied time and their values are those at that specific time. Absence of this field will default to the API's version of NOW.",
	//       "format": "google-datetime",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/findings",
	//   "response": {
	//     "$ref": "ListFindingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersSourcesFindingsListCall) Pages(ctx context.Context, f func(*ListFindingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.folders.sources.findings.patch":

type FoldersSourcesFindingsPatchCall struct {
	s          *Service
	name       string
	finding    *Finding
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Creates or updates a finding. The corresponding source must
// exist for a finding creation to succeed.
//
//   - name: The relative resource name
//     (https://cloud.google.com/apis/design/resource_names#relative_resource_name)
//     of the finding. Example:
//     "organizations/{organization_id}/sources/{source_id}/findings/{findi
//     ng_id}",
//     "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
//     "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
func (r *FoldersSourcesFindingsService) Patch(name string, finding *Finding) *FoldersSourcesFindingsPatchCall {
	c := &FoldersSourcesFindingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.finding = finding
	return c
}

// UpdateMask sets the optional parameter "updateMask": The FieldMask to
// use when updating the finding resource. This field should not be
// specified when creating a finding. When updating a finding, an empty
// mask is treated as updating all mutable fields and replacing
// source_properties. Individual source_properties can be added/updated
// by using "source_properties." in the field mask.
func (c *FoldersSourcesFindingsPatchCall) UpdateMask(updateMask string) *FoldersSourcesFindingsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSourcesFindingsPatchCall) Fields(s ...googleapi.Field) *FoldersSourcesFindingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSourcesFindingsPatchCall) Context(ctx context.Context) *FoldersSourcesFindingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSourcesFindingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSourcesFindingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.finding)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.sources.findings.patch" call.
// Exactly one of *Finding or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Finding.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *FoldersSourcesFindingsPatchCall) Do(opts ...googleapi.CallOption) (*Finding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Finding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates or updates a finding. The corresponding source must exist for a finding creation to succeed.",
	//   "flatPath": "v1/folders/{foldersId}/sources/{sourcesId}/findings/{findingsId}",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.sources.findings.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The [relative resource name](https://cloud.google.com/apis/design/resource_names#relative_resource_name) of the finding. Example: \"organizations/{organization_id}/sources/{source_id}/findings/{finding_id}\", \"folders/{folder_id}/sources/{source_id}/findings/{finding_id}\", \"projects/{project_id}/sources/{source_id}/findings/{finding_id}\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/sources/[^/]+/findings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The FieldMask to use when updating the finding resource. This field should not be specified when creating a finding. When updating a finding, an empty mask is treated as updating all mutable fields and replacing source_properties. Individual source_properties can be added/updated by using \"source_properties.\" in the field mask.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "Finding"
	//   },
	//   "response": {
	//     "$ref": "Finding"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.sources.findings.setMute":

type FoldersSourcesFindingsSetMuteCall struct {
	s              *Service
	name           string
	setmuterequest *SetMuteRequest
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// SetMute: Updates the mute state of a finding.
//
//   - name: The relative resource name
//     (https://cloud.google.com/apis/design/resource_names#relative_resource_name)
//     of the finding. Example:
//     "organizations/{organization_id}/sources/{source_id}/findings/{findi
//     ng_id}",
//     "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
//     "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
func (r *FoldersSourcesFindingsService) SetMute(name string, setmuterequest *SetMuteRequest) *FoldersSourcesFindingsSetMuteCall {
	c := &FoldersSourcesFindingsSetMuteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setmuterequest = setmuterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSourcesFindingsSetMuteCall) Fields(s ...googleapi.Field) *FoldersSourcesFindingsSetMuteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSourcesFindingsSetMuteCall) Context(ctx context.Context) *FoldersSourcesFindingsSetMuteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSourcesFindingsSetMuteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSourcesFindingsSetMuteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setmuterequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:setMute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.sources.findings.setMute" call.
// Exactly one of *Finding or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Finding.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *FoldersSourcesFindingsSetMuteCall) Do(opts ...googleapi.CallOption) (*Finding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Finding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the mute state of a finding.",
	//   "flatPath": "v1/folders/{foldersId}/sources/{sourcesId}/findings/{findingsId}:setMute",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.folders.sources.findings.setMute",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The [relative resource name](https://cloud.google.com/apis/design/resource_names#relative_resource_name) of the finding. Example: \"organizations/{organization_id}/sources/{source_id}/findings/{finding_id}\", \"folders/{folder_id}/sources/{source_id}/findings/{finding_id}\", \"projects/{project_id}/sources/{source_id}/findings/{finding_id}\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/sources/[^/]+/findings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:setMute",
	//   "request": {
	//     "$ref": "SetMuteRequest"
	//   },
	//   "response": {
	//     "$ref": "Finding"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.sources.findings.setState":

type FoldersSourcesFindingsSetStateCall struct {
	s                      *Service
	name                   string
	setfindingstaterequest *SetFindingStateRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetState: Updates the state of a finding.
//
//   - name: The relative resource name
//     (https://cloud.google.com/apis/design/resource_names#relative_resource_name)
//     of the finding. Example:
//     "organizations/{organization_id}/sources/{source_id}/findings/{findi
//     ng_id}",
//     "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
//     "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
func (r *FoldersSourcesFindingsService) SetState(name string, setfindingstaterequest *SetFindingStateRequest) *FoldersSourcesFindingsSetStateCall {
	c := &FoldersSourcesFindingsSetStateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setfindingstaterequest = setfindingstaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSourcesFindingsSetStateCall) Fields(s ...googleapi.Field) *FoldersSourcesFindingsSetStateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSourcesFindingsSetStateCall) Context(ctx context.Context) *FoldersSourcesFindingsSetStateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSourcesFindingsSetStateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSourcesFindingsSetStateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setfindingstaterequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:setState")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.sources.findings.setState" call.
// Exactly one of *Finding or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Finding.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *FoldersSourcesFindingsSetStateCall) Do(opts ...googleapi.CallOption) (*Finding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Finding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the state of a finding.",
	//   "flatPath": "v1/folders/{foldersId}/sources/{sourcesId}/findings/{findingsId}:setState",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.folders.sources.findings.setState",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The [relative resource name](https://cloud.google.com/apis/design/resource_names#relative_resource_name) of the finding. Example: \"organizations/{organization_id}/sources/{source_id}/findings/{finding_id}\", \"folders/{folder_id}/sources/{source_id}/findings/{finding_id}\", \"projects/{project_id}/sources/{source_id}/findings/{finding_id}\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/sources/[^/]+/findings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:setState",
	//   "request": {
	//     "$ref": "SetFindingStateRequest"
	//   },
	//   "response": {
	//     "$ref": "Finding"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.sources.findings.updateSecurityMarks":

type FoldersSourcesFindingsUpdateSecurityMarksCall struct {
	s             *Service
	name          string
	securitymarks *SecurityMarks
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// UpdateSecurityMarks: Updates security marks.
//
//   - name: The relative resource name of the SecurityMarks. See:
//     https://cloud.google.com/apis/design/resource_names#relative_resource_name
//     Examples:
//     "organizations/{organization_id}/assets/{asset_id}/securityMarks"
//     "organizations/{organization_id}/sources/{source_id}/findings/{findi
//     ng_id}/securityMarks".
func (r *FoldersSourcesFindingsService) UpdateSecurityMarks(name string, securitymarks *SecurityMarks) *FoldersSourcesFindingsUpdateSecurityMarksCall {
	c := &FoldersSourcesFindingsUpdateSecurityMarksCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.securitymarks = securitymarks
	return c
}

// StartTime sets the optional parameter "startTime": The time at which
// the updated SecurityMarks take effect. If not set uses current server
// time. Updates will be applied to the SecurityMarks that are active
// immediately preceding this time. Must be earlier or equal to the
// server time.
func (c *FoldersSourcesFindingsUpdateSecurityMarksCall) StartTime(startTime string) *FoldersSourcesFindingsUpdateSecurityMarksCall {
	c.urlParams_.Set("startTime", startTime)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The FieldMask to
// use when updating the security marks resource. The field mask must
// not contain duplicate fields. If empty or set to "marks", all marks
// will be replaced. Individual marks can be updated using "marks.".
func (c *FoldersSourcesFindingsUpdateSecurityMarksCall) UpdateMask(updateMask string) *FoldersSourcesFindingsUpdateSecurityMarksCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSourcesFindingsUpdateSecurityMarksCall) Fields(s ...googleapi.Field) *FoldersSourcesFindingsUpdateSecurityMarksCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSourcesFindingsUpdateSecurityMarksCall) Context(ctx context.Context) *FoldersSourcesFindingsUpdateSecurityMarksCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSourcesFindingsUpdateSecurityMarksCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSourcesFindingsUpdateSecurityMarksCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.securitymarks)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.sources.findings.updateSecurityMarks" call.
// Exactly one of *SecurityMarks or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *SecurityMarks.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersSourcesFindingsUpdateSecurityMarksCall) Do(opts ...googleapi.CallOption) (*SecurityMarks, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SecurityMarks{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates security marks.",
	//   "flatPath": "v1/folders/{foldersId}/sources/{sourcesId}/findings/{findingsId}/securityMarks",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.sources.findings.updateSecurityMarks",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The relative resource name of the SecurityMarks. See: https://cloud.google.com/apis/design/resource_names#relative_resource_name Examples: \"organizations/{organization_id}/assets/{asset_id}/securityMarks\" \"organizations/{organization_id}/sources/{source_id}/findings/{finding_id}/securityMarks\".",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/sources/[^/]+/findings/[^/]+/securityMarks$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "startTime": {
	//       "description": "The time at which the updated SecurityMarks take effect. If not set uses current server time. Updates will be applied to the SecurityMarks that are active immediately preceding this time. Must be earlier or equal to the server time.",
	//       "format": "google-datetime",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The FieldMask to use when updating the security marks resource. The field mask must not contain duplicate fields. If empty or set to \"marks\", all marks will be replaced. Individual marks can be updated using \"marks.\".",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "SecurityMarks"
	//   },
	//   "response": {
	//     "$ref": "SecurityMarks"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.sources.findings.externalSystems.patch":

type FoldersSourcesFindingsExternalSystemsPatchCall struct {
	s                                         *Service
	name                                      string
	googlecloudsecuritycenterv1externalsystem *GoogleCloudSecuritycenterV1ExternalSystem
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Patch: Updates external system. This is for a given finding.
//
//   - name: Full resource name of the external system, for example:
//     "organizations/1234/sources/5678/findings/123456/externalSystems/jir
//     a",
//     "folders/1234/sources/5678/findings/123456/externalSystems/jira",
//     "projects/1234/sources/5678/findings/123456/externalSystems/jira".
func (r *FoldersSourcesFindingsExternalSystemsService) Patch(name string, googlecloudsecuritycenterv1externalsystem *GoogleCloudSecuritycenterV1ExternalSystem) *FoldersSourcesFindingsExternalSystemsPatchCall {
	c := &FoldersSourcesFindingsExternalSystemsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudsecuritycenterv1externalsystem = googlecloudsecuritycenterv1externalsystem
	return c
}

// UpdateMask sets the optional parameter "updateMask": The FieldMask to
// use when updating the external system resource. If empty all mutable
// fields will be updated.
func (c *FoldersSourcesFindingsExternalSystemsPatchCall) UpdateMask(updateMask string) *FoldersSourcesFindingsExternalSystemsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSourcesFindingsExternalSystemsPatchCall) Fields(s ...googleapi.Field) *FoldersSourcesFindingsExternalSystemsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSourcesFindingsExternalSystemsPatchCall) Context(ctx context.Context) *FoldersSourcesFindingsExternalSystemsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSourcesFindingsExternalSystemsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSourcesFindingsExternalSystemsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudsecuritycenterv1externalsystem)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.sources.findings.externalSystems.patch" call.
// Exactly one of *GoogleCloudSecuritycenterV1ExternalSystem or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudSecuritycenterV1ExternalSystem.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSourcesFindingsExternalSystemsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1ExternalSystem, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1ExternalSystem{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates external system. This is for a given finding.",
	//   "flatPath": "v1/folders/{foldersId}/sources/{sourcesId}/findings/{findingsId}/externalSystems/{externalSystemsId}",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.sources.findings.externalSystems.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Full resource name of the external system, for example: \"organizations/1234/sources/5678/findings/123456/externalSystems/jira\", \"folders/1234/sources/5678/findings/123456/externalSystems/jira\", \"projects/1234/sources/5678/findings/123456/externalSystems/jira\"",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/sources/[^/]+/findings/[^/]+/externalSystems/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The FieldMask to use when updating the external system resource. If empty all mutable fields will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudSecuritycenterV1ExternalSystem"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1ExternalSystem"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.getOrganizationSettings":

type OrganizationsGetOrganizationSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetOrganizationSettings: Gets the settings for an organization.
//
//   - name: Name of the organization to get organization settings for.
//     Its format is
//     "organizations/[organization_id]/organizationSettings".
func (r *OrganizationsService) GetOrganizationSettings(name string) *OrganizationsGetOrganizationSettingsCall {
	c := &OrganizationsGetOrganizationSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetOrganizationSettingsCall) Fields(s ...googleapi.Field) *OrganizationsGetOrganizationSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetOrganizationSettingsCall) IfNoneMatch(entityTag string) *OrganizationsGetOrganizationSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetOrganizationSettingsCall) Context(ctx context.Context) *OrganizationsGetOrganizationSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetOrganizationSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetOrganizationSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.getOrganizationSettings" call.
// Exactly one of *OrganizationSettings or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *OrganizationSettings.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsGetOrganizationSettingsCall) Do(opts ...googleapi.CallOption) (*OrganizationSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OrganizationSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the settings for an organization.",
	//   "flatPath": "v1/organizations/{organizationsId}/organizationSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.getOrganizationSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the organization to get organization settings for. Its format is \"organizations/[organization_id]/organizationSettings\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/organizationSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "OrganizationSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.updateOrganizationSettings":

type OrganizationsUpdateOrganizationSettingsCall struct {
	s                    *Service
	name                 string
	organizationsettings *OrganizationSettings
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// UpdateOrganizationSettings: Updates an organization's settings.
//
//   - name: The relative resource name of the settings. See:
//     https://cloud.google.com/apis/design/resource_names#relative_resource_name
//     Example: "organizations/{organization_id}/organizationSettings".
func (r *OrganizationsService) UpdateOrganizationSettings(name string, organizationsettings *OrganizationSettings) *OrganizationsUpdateOrganizationSettingsCall {
	c := &OrganizationsUpdateOrganizationSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.organizationsettings = organizationsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The FieldMask to
// use when updating the settings resource. If empty all mutable fields
// will be updated.
func (c *OrganizationsUpdateOrganizationSettingsCall) UpdateMask(updateMask string) *OrganizationsUpdateOrganizationSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsUpdateOrganizationSettingsCall) Fields(s ...googleapi.Field) *OrganizationsUpdateOrganizationSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsUpdateOrganizationSettingsCall) Context(ctx context.Context) *OrganizationsUpdateOrganizationSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsUpdateOrganizationSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsUpdateOrganizationSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.organizationsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.updateOrganizationSettings" call.
// Exactly one of *OrganizationSettings or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *OrganizationSettings.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsUpdateOrganizationSettingsCall) Do(opts ...googleapi.CallOption) (*OrganizationSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OrganizationSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an organization's settings.",
	//   "flatPath": "v1/organizations/{organizationsId}/organizationSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.organizations.updateOrganizationSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The relative resource name of the settings. See: https://cloud.google.com/apis/design/resource_names#relative_resource_name Example: \"organizations/{organization_id}/organizationSettings\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/organizationSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The FieldMask to use when updating the settings resource. If empty all mutable fields will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "OrganizationSettings"
	//   },
	//   "response": {
	//     "$ref": "OrganizationSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.assets.group":

type OrganizationsAssetsGroupCall struct {
	s                  *Service
	parent             string
	groupassetsrequest *GroupAssetsRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Group: Filters an organization's assets and groups them by their
// specified properties.
//
//   - parent: The name of the parent to group the assets by. Its format
//     is "organizations/[organization_id]", "folders/[folder_id]", or
//     "projects/[project_id]".
func (r *OrganizationsAssetsService) Group(parent string, groupassetsrequest *GroupAssetsRequest) *OrganizationsAssetsGroupCall {
	c := &OrganizationsAssetsGroupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.groupassetsrequest = groupassetsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAssetsGroupCall) Fields(s ...googleapi.Field) *OrganizationsAssetsGroupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAssetsGroupCall) Context(ctx context.Context) *OrganizationsAssetsGroupCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAssetsGroupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAssetsGroupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.groupassetsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assets:group")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.assets.group" call.
// Exactly one of *GroupAssetsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GroupAssetsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAssetsGroupCall) Do(opts ...googleapi.CallOption) (*GroupAssetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GroupAssetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "deprecated": true,
	//   "description": "Filters an organization's assets and groups them by their specified properties.",
	//   "flatPath": "v1/organizations/{organizationsId}/assets:group",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.organizations.assets.group",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The name of the parent to group the assets by. Its format is \"organizations/[organization_id]\", \"folders/[folder_id]\", or \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/assets:group",
	//   "request": {
	//     "$ref": "GroupAssetsRequest"
	//   },
	//   "response": {
	//     "$ref": "GroupAssetsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsAssetsGroupCall) Pages(ctx context.Context, f func(*GroupAssetsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.groupassetsrequest.PageToken = pt }(c.groupassetsrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.groupassetsrequest.PageToken = x.NextPageToken
	}
}

// method id "securitycenter.organizations.assets.list":

type OrganizationsAssetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists an organization's assets.
//
//   - parent: The name of the parent resource that contains the assets.
//     The value that you can specify on parent depends on the method in
//     which you specify parent. You can specify one of the following
//     values: "organizations/[organization_id]", "folders/[folder_id]",
//     or "projects/[project_id]".
func (r *OrganizationsAssetsService) List(parent string) *OrganizationsAssetsListCall {
	c := &OrganizationsAssetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// CompareDuration sets the optional parameter "compareDuration": When
// compare_duration is set, the ListAssetsResult's "state_change"
// attribute is updated to indicate whether the asset was added,
// removed, or remained present during the compare_duration period of
// time that precedes the read_time. This is the time between (read_time
// - compare_duration) and read_time. The state_change value is derived
// based on the presence of the asset at the two points in time.
// Intermediate state changes between the two times don't affect the
// result. For example, the results aren't affected if the asset is
// removed and re-created again. Possible "state_change" values when
// compare_duration is specified: * "ADDED": indicates that the asset
// was not present at the start of compare_duration, but present at
// read_time. * "REMOVED": indicates that the asset was present at the
// start of compare_duration, but not present at read_time. * "ACTIVE":
// indicates that the asset was present at both the start and the end of
// the time period defined by compare_duration and read_time. If
// compare_duration is not specified, then the only possible
// state_change is "UNUSED", which will be the state_change set for all
// assets present at read_time.
func (c *OrganizationsAssetsListCall) CompareDuration(compareDuration string) *OrganizationsAssetsListCall {
	c.urlParams_.Set("compareDuration", compareDuration)
	return c
}

// FieldMask sets the optional parameter "fieldMask": A field mask to
// specify the ListAssetsResult fields to be listed in the response. An
// empty field mask will list all fields.
func (c *OrganizationsAssetsListCall) FieldMask(fieldMask string) *OrganizationsAssetsListCall {
	c.urlParams_.Set("fieldMask", fieldMask)
	return c
}

// Filter sets the optional parameter "filter": Expression that defines
// the filter to apply across assets. The expression is a list of zero
// or more restrictions combined via logical operators `AND` and `OR`.
// Parentheses are supported, and `OR` has higher precedence than `AND`.
// Restrictions have the form ` ` and may have a `-` character in front
// of them to indicate negation. The fields map to those defined in the
// Asset resource. Examples include: * name *
// security_center_properties.resource_name *
// resource_properties.a_property * security_marks.marks.marka The
// supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
// `<=` for integer values. * `:`, meaning substring matching, for
// strings. The supported value types are: * string literals in quotes.
// * integer literals without quotes. * boolean literals `true` and
// `false` without quotes. The following are the allowed field and
// operator combinations: * name: `=` * update_time: `=`, `>`, `<`,
// `>=`, `<=` Usage: This should be milliseconds since epoch or an
// RFC3339 string. Examples: `update_time = "2019-06-10T16:07:18-07:00"
// `update_time = 1560208038000` * create_time: `=`, `>`, `<`, `>=`,
// `<=` Usage: This should be milliseconds since epoch or an RFC3339
// string. Examples: `create_time = "2019-06-10T16:07:18-07:00"
// `create_time = 1560208038000` * iam_policy.policy_blob: `=`, `:` *
// resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=` *
// security_marks.marks: `=`, `:` *
// security_center_properties.resource_name: `=`, `:` *
// security_center_properties.resource_display_name: `=`, `:` *
// security_center_properties.resource_type: `=`, `:` *
// security_center_properties.resource_parent: `=`, `:` *
// security_center_properties.resource_parent_display_name: `=`, `:` *
// security_center_properties.resource_project: `=`, `:` *
// security_center_properties.resource_project_display_name: `=`, `:` *
// security_center_properties.resource_owners: `=`, `:` For example,
// `resource_properties.size = 100` is a valid filter string. Use a
// partial match on the empty string to filter based on a property
// existing: `resource_properties.my_property : "" Use a negated
// partial match on the empty string to filter based on a property not
// existing: `-resource_properties.my_property : ""
func (c *OrganizationsAssetsListCall) Filter(filter string) *OrganizationsAssetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Expression that
// defines what fields and order to use for sorting. The string value
// should follow SQL syntax: comma separated list of fields. For
// example: "name,resource_properties.a_property". The default sorting
// order is ascending. To specify descending order for a field, a suffix
// " desc" should be appended to the field name. For example: "name
// desc,resource_properties.a_property". Redundant space characters in
// the syntax are insignificant. "name
// desc,resource_properties.a_property" and " name desc ,
// resource_properties.a_property " are equivalent. The following fields
// are supported: name update_time resource_properties
// security_marks.marks security_center_properties.resource_name
// security_center_properties.resource_display_name
// security_center_properties.resource_parent
// security_center_properties.resource_parent_display_name
// security_center_properties.resource_project
// security_center_properties.resource_project_display_name
// security_center_properties.resource_type
func (c *OrganizationsAssetsListCall) OrderBy(orderBy string) *OrganizationsAssetsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return in a single response. Default is 10, minimum is
// 1, maximum is 1000.
func (c *OrganizationsAssetsListCall) PageSize(pageSize int64) *OrganizationsAssetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned
// by the last `ListAssetsResponse`; indicates that this is a
// continuation of a prior `ListAssets` call, and that the system should
// return the next page of data.
func (c *OrganizationsAssetsListCall) PageToken(pageToken string) *OrganizationsAssetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReadTime sets the optional parameter "readTime": Time used as a
// reference point when filtering assets. The filter is limited to
// assets existing at the supplied time and their values are those at
// that specific time. Absence of this field will default to the API's
// version of NOW.
func (c *OrganizationsAssetsListCall) ReadTime(readTime string) *OrganizationsAssetsListCall {
	c.urlParams_.Set("readTime", readTime)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAssetsListCall) Fields(s ...googleapi.Field) *OrganizationsAssetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsAssetsListCall) IfNoneMatch(entityTag string) *OrganizationsAssetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAssetsListCall) Context(ctx context.Context) *OrganizationsAssetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAssetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAssetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.assets.list" call.
// Exactly one of *ListAssetsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListAssetsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAssetsListCall) Do(opts ...googleapi.CallOption) (*ListAssetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAssetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "deprecated": true,
	//   "description": "Lists an organization's assets.",
	//   "flatPath": "v1/organizations/{organizationsId}/assets",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.assets.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "compareDuration": {
	//       "description": "When compare_duration is set, the ListAssetsResult's \"state_change\" attribute is updated to indicate whether the asset was added, removed, or remained present during the compare_duration period of time that precedes the read_time. This is the time between (read_time - compare_duration) and read_time. The state_change value is derived based on the presence of the asset at the two points in time. Intermediate state changes between the two times don't affect the result. For example, the results aren't affected if the asset is removed and re-created again. Possible \"state_change\" values when compare_duration is specified: * \"ADDED\": indicates that the asset was not present at the start of compare_duration, but present at read_time. * \"REMOVED\": indicates that the asset was present at the start of compare_duration, but not present at read_time. * \"ACTIVE\": indicates that the asset was present at both the start and the end of the time period defined by compare_duration and read_time. If compare_duration is not specified, then the only possible state_change is \"UNUSED\", which will be the state_change set for all assets present at read_time.",
	//       "format": "google-duration",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "fieldMask": {
	//       "description": "A field mask to specify the ListAssetsResult fields to be listed in the response. An empty field mask will list all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "filter": {
	//       "description": "Expression that defines the filter to apply across assets. The expression is a list of zero or more restrictions combined via logical operators `AND` and `OR`. Parentheses are supported, and `OR` has higher precedence than `AND`. Restrictions have the form ` ` and may have a `-` character in front of them to indicate negation. The fields map to those defined in the Asset resource. Examples include: * name * security_center_properties.resource_name * resource_properties.a_property * security_marks.marks.marka The supported operators are: * `=` for all value types. * `\u003e`, `\u003c`, `\u003e=`, `\u003c=` for integer values. * `:`, meaning substring matching, for strings. The supported value types are: * string literals in quotes. * integer literals without quotes. * boolean literals `true` and `false` without quotes. The following are the allowed field and operator combinations: * name: `=` * update_time: `=`, `\u003e`, `\u003c`, `\u003e=`, `\u003c=` Usage: This should be milliseconds since epoch or an RFC3339 string. Examples: `update_time = \"2019-06-10T16:07:18-07:00\"` `update_time = 1560208038000` * create_time: `=`, `\u003e`, `\u003c`, `\u003e=`, `\u003c=` Usage: This should be milliseconds since epoch or an RFC3339 string. Examples: `create_time = \"2019-06-10T16:07:18-07:00\"` `create_time = 1560208038000` * iam_policy.policy_blob: `=`, `:` * resource_properties: `=`, `:`, `\u003e`, `\u003c`, `\u003e=`, `\u003c=` * security_marks.marks: `=`, `:` * security_center_properties.resource_name: `=`, `:` * security_center_properties.resource_display_name: `=`, `:` * security_center_properties.resource_type: `=`, `:` * security_center_properties.resource_parent: `=`, `:` * security_center_properties.resource_parent_display_name: `=`, `:` * security_center_properties.resource_project: `=`, `:` * security_center_properties.resource_project_display_name: `=`, `:` * security_center_properties.resource_owners: `=`, `:` For example, `resource_properties.size = 100` is a valid filter string. Use a partial match on the empty string to filter based on a property existing: `resource_properties.my_property : \"\"` Use a negated partial match on the empty string to filter based on a property not existing: `-resource_properties.my_property : \"\"`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Expression that defines what fields and order to use for sorting. The string value should follow SQL syntax: comma separated list of fields. For example: \"name,resource_properties.a_property\". The default sorting order is ascending. To specify descending order for a field, a suffix \" desc\" should be appended to the field name. For example: \"name desc,resource_properties.a_property\". Redundant space characters in the syntax are insignificant. \"name desc,resource_properties.a_property\" and \" name desc , resource_properties.a_property \" are equivalent. The following fields are supported: name update_time resource_properties security_marks.marks security_center_properties.resource_name security_center_properties.resource_display_name security_center_properties.resource_parent security_center_properties.resource_parent_display_name security_center_properties.resource_project security_center_properties.resource_project_display_name security_center_properties.resource_type",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of results to return in a single response. Default is 10, minimum is 1, maximum is 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The value returned by the last `ListAssetsResponse`; indicates that this is a continuation of a prior `ListAssets` call, and that the system should return the next page of data.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the parent resource that contains the assets. The value that you can specify on parent depends on the method in which you specify parent. You can specify one of the following values: \"organizations/[organization_id]\", \"folders/[folder_id]\", or \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "readTime": {
	//       "description": "Time used as a reference point when filtering assets. The filter is limited to assets existing at the supplied time and their values are those at that specific time. Absence of this field will default to the API's version of NOW.",
	//       "format": "google-datetime",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/assets",
	//   "response": {
	//     "$ref": "ListAssetsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsAssetsListCall) Pages(ctx context.Context, f func(*ListAssetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.organizations.assets.runDiscovery":

type OrganizationsAssetsRunDiscoveryCall struct {
	s                        *Service
	parent                   string
	runassetdiscoveryrequest *RunAssetDiscoveryRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// RunDiscovery: Runs asset discovery. The discovery is tracked with a
// long-running operation. This API can only be called with limited
// frequency for an organization. If it is called too frequently the
// caller will receive a TOO_MANY_REQUESTS error.
//
//   - parent: Name of the organization to run asset discovery for. Its
//     format is "organizations/[organization_id]".
func (r *OrganizationsAssetsService) RunDiscovery(parent string, runassetdiscoveryrequest *RunAssetDiscoveryRequest) *OrganizationsAssetsRunDiscoveryCall {
	c := &OrganizationsAssetsRunDiscoveryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.runassetdiscoveryrequest = runassetdiscoveryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAssetsRunDiscoveryCall) Fields(s ...googleapi.Field) *OrganizationsAssetsRunDiscoveryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAssetsRunDiscoveryCall) Context(ctx context.Context) *OrganizationsAssetsRunDiscoveryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAssetsRunDiscoveryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAssetsRunDiscoveryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.runassetdiscoveryrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assets:runDiscovery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.assets.runDiscovery" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsAssetsRunDiscoveryCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "deprecated": true,
	//   "description": "Runs asset discovery. The discovery is tracked with a long-running operation. This API can only be called with limited frequency for an organization. If it is called too frequently the caller will receive a TOO_MANY_REQUESTS error.",
	//   "flatPath": "v1/organizations/{organizationsId}/assets:runDiscovery",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.organizations.assets.runDiscovery",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Name of the organization to run asset discovery for. Its format is \"organizations/[organization_id]\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/assets:runDiscovery",
	//   "request": {
	//     "$ref": "RunAssetDiscoveryRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.assets.updateSecurityMarks":

type OrganizationsAssetsUpdateSecurityMarksCall struct {
	s             *Service
	name          string
	securitymarks *SecurityMarks
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// UpdateSecurityMarks: Updates security marks.
//
//   - name: The relative resource name of the SecurityMarks. See:
//     https://cloud.google.com/apis/design/resource_names#relative_resource_name
//     Examples:
//     "organizations/{organization_id}/assets/{asset_id}/securityMarks"
//     "organizations/{organization_id}/sources/{source_id}/findings/{findi
//     ng_id}/securityMarks".
func (r *OrganizationsAssetsService) UpdateSecurityMarks(name string, securitymarks *SecurityMarks) *OrganizationsAssetsUpdateSecurityMarksCall {
	c := &OrganizationsAssetsUpdateSecurityMarksCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.securitymarks = securitymarks
	return c
}

// StartTime sets the optional parameter "startTime": The time at which
// the updated SecurityMarks take effect. If not set uses current server
// time. Updates will be applied to the SecurityMarks that are active
// immediately preceding this time. Must be earlier or equal to the
// server time.
func (c *OrganizationsAssetsUpdateSecurityMarksCall) StartTime(startTime string) *OrganizationsAssetsUpdateSecurityMarksCall {
	c.urlParams_.Set("startTime", startTime)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The FieldMask to
// use when updating the security marks resource. The field mask must
// not contain duplicate fields. If empty or set to "marks", all marks
// will be replaced. Individual marks can be updated using "marks.".
func (c *OrganizationsAssetsUpdateSecurityMarksCall) UpdateMask(updateMask string) *OrganizationsAssetsUpdateSecurityMarksCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAssetsUpdateSecurityMarksCall) Fields(s ...googleapi.Field) *OrganizationsAssetsUpdateSecurityMarksCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAssetsUpdateSecurityMarksCall) Context(ctx context.Context) *OrganizationsAssetsUpdateSecurityMarksCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAssetsUpdateSecurityMarksCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAssetsUpdateSecurityMarksCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.securitymarks)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.assets.updateSecurityMarks" call.
// Exactly one of *SecurityMarks or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *SecurityMarks.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAssetsUpdateSecurityMarksCall) Do(opts ...googleapi.CallOption) (*SecurityMarks, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SecurityMarks{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates security marks.",
	//   "flatPath": "v1/organizations/{organizationsId}/assets/{assetsId}/securityMarks",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.organizations.assets.updateSecurityMarks",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The relative resource name of the SecurityMarks. See: https://cloud.google.com/apis/design/resource_names#relative_resource_name Examples: \"organizations/{organization_id}/assets/{asset_id}/securityMarks\" \"organizations/{organization_id}/sources/{source_id}/findings/{finding_id}/securityMarks\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/assets/[^/]+/securityMarks$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "startTime": {
	//       "description": "The time at which the updated SecurityMarks take effect. If not set uses current server time. Updates will be applied to the SecurityMarks that are active immediately preceding this time. Must be earlier or equal to the server time.",
	//       "format": "google-datetime",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The FieldMask to use when updating the security marks resource. The field mask must not contain duplicate fields. If empty or set to \"marks\", all marks will be replaced. Individual marks can be updated using \"marks.\".",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "SecurityMarks"
	//   },
	//   "response": {
	//     "$ref": "SecurityMarks"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.bigQueryExports.create":

type OrganizationsBigQueryExportsCreateCall struct {
	s                                         *Service
	parent                                    string
	googlecloudsecuritycenterv1bigqueryexport *GoogleCloudSecuritycenterV1BigQueryExport
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Create: Creates a BigQuery export.
//
//   - parent: The name of the parent resource of the new BigQuery export.
//     Its format is "organizations/[organization_id]",
//     "folders/[folder_id]", or "projects/[project_id]".
func (r *OrganizationsBigQueryExportsService) Create(parent string, googlecloudsecuritycenterv1bigqueryexport *GoogleCloudSecuritycenterV1BigQueryExport) *OrganizationsBigQueryExportsCreateCall {
	c := &OrganizationsBigQueryExportsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudsecuritycenterv1bigqueryexport = googlecloudsecuritycenterv1bigqueryexport
	return c
}

// BigQueryExportId sets the optional parameter "bigQueryExportId":
// Required. Unique identifier provided by the client within the parent
// scope. It must consist of only lowercase letters, numbers, and
// hyphens, must start with a letter, must end with either a letter or a
// number, and must be 63 characters or less.
func (c *OrganizationsBigQueryExportsCreateCall) BigQueryExportId(bigQueryExportId string) *OrganizationsBigQueryExportsCreateCall {
	c.urlParams_.Set("bigQueryExportId", bigQueryExportId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsBigQueryExportsCreateCall) Fields(s ...googleapi.Field) *OrganizationsBigQueryExportsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsBigQueryExportsCreateCall) Context(ctx context.Context) *OrganizationsBigQueryExportsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsBigQueryExportsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsBigQueryExportsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudsecuritycenterv1bigqueryexport)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bigQueryExports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.bigQueryExports.create" call.
// Exactly one of *GoogleCloudSecuritycenterV1BigQueryExport or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudSecuritycenterV1BigQueryExport.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsBigQueryExportsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1BigQueryExport, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1BigQueryExport{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a BigQuery export.",
	//   "flatPath": "v1/organizations/{organizationsId}/bigQueryExports",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.organizations.bigQueryExports.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "bigQueryExportId": {
	//       "description": "Required. Unique identifier provided by the client within the parent scope. It must consist of only lowercase letters, numbers, and hyphens, must start with a letter, must end with either a letter or a number, and must be 63 characters or less.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the parent resource of the new BigQuery export. Its format is \"organizations/[organization_id]\", \"folders/[folder_id]\", or \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/bigQueryExports",
	//   "request": {
	//     "$ref": "GoogleCloudSecuritycenterV1BigQueryExport"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1BigQueryExport"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.bigQueryExports.delete":

type OrganizationsBigQueryExportsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing BigQuery export.
//
//   - name: The name of the BigQuery export to delete. Its format is
//     organizations/{organization}/bigQueryExports/{export_id},
//     folders/{folder}/bigQueryExports/{export_id}, or
//     projects/{project}/bigQueryExports/{export_id}.
func (r *OrganizationsBigQueryExportsService) Delete(name string) *OrganizationsBigQueryExportsDeleteCall {
	c := &OrganizationsBigQueryExportsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsBigQueryExportsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsBigQueryExportsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsBigQueryExportsDeleteCall) Context(ctx context.Context) *OrganizationsBigQueryExportsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsBigQueryExportsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsBigQueryExportsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.bigQueryExports.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *OrganizationsBigQueryExportsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an existing BigQuery export.",
	//   "flatPath": "v1/organizations/{organizationsId}/bigQueryExports/{bigQueryExportsId}",
	//   "httpMethod": "DELETE",
	//   "id": "securitycenter.organizations.bigQueryExports.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the BigQuery export to delete. Its format is organizations/{organization}/bigQueryExports/{export_id}, folders/{folder}/bigQueryExports/{export_id}, or projects/{project}/bigQueryExports/{export_id}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/bigQueryExports/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.bigQueryExports.get":

type OrganizationsBigQueryExportsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a BigQuery export.
//
//   - name: Name of the BigQuery export to retrieve. Its format is
//     organizations/{organization}/bigQueryExports/{export_id},
//     folders/{folder}/bigQueryExports/{export_id}, or
//     projects/{project}/bigQueryExports/{export_id}.
func (r *OrganizationsBigQueryExportsService) Get(name string) *OrganizationsBigQueryExportsGetCall {
	c := &OrganizationsBigQueryExportsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsBigQueryExportsGetCall) Fields(s ...googleapi.Field) *OrganizationsBigQueryExportsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsBigQueryExportsGetCall) IfNoneMatch(entityTag string) *OrganizationsBigQueryExportsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsBigQueryExportsGetCall) Context(ctx context.Context) *OrganizationsBigQueryExportsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsBigQueryExportsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsBigQueryExportsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.bigQueryExports.get" call.
// Exactly one of *GoogleCloudSecuritycenterV1BigQueryExport or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudSecuritycenterV1BigQueryExport.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsBigQueryExportsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1BigQueryExport, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1BigQueryExport{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a BigQuery export.",
	//   "flatPath": "v1/organizations/{organizationsId}/bigQueryExports/{bigQueryExportsId}",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.bigQueryExports.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the BigQuery export to retrieve. Its format is organizations/{organization}/bigQueryExports/{export_id}, folders/{folder}/bigQueryExports/{export_id}, or projects/{project}/bigQueryExports/{export_id}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/bigQueryExports/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1BigQueryExport"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.bigQueryExports.list":

type OrganizationsBigQueryExportsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists BigQuery exports. Note that when requesting BigQuery
// exports at a given level all exports under that level are also
// returned e.g. if requesting BigQuery exports under a folder, then all
// BigQuery exports immediately under the folder plus the ones created
// under the projects within the folder are returned.
//
//   - parent: The parent, which owns the collection of BigQuery exports.
//     Its format is "organizations/[organization_id]",
//     "folders/[folder_id]", "projects/[project_id]".
func (r *OrganizationsBigQueryExportsService) List(parent string) *OrganizationsBigQueryExportsListCall {
	c := &OrganizationsBigQueryExportsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of configs to return. The service may return fewer than this value.
// If unspecified, at most 10 configs will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *OrganizationsBigQueryExportsListCall) PageSize(pageSize int64) *OrganizationsBigQueryExportsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListBigQueryExports` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListBigQueryExports` must match the call that provided
// the page token.
func (c *OrganizationsBigQueryExportsListCall) PageToken(pageToken string) *OrganizationsBigQueryExportsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsBigQueryExportsListCall) Fields(s ...googleapi.Field) *OrganizationsBigQueryExportsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsBigQueryExportsListCall) IfNoneMatch(entityTag string) *OrganizationsBigQueryExportsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsBigQueryExportsListCall) Context(ctx context.Context) *OrganizationsBigQueryExportsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsBigQueryExportsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsBigQueryExportsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bigQueryExports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.bigQueryExports.list" call.
// Exactly one of *ListBigQueryExportsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListBigQueryExportsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsBigQueryExportsListCall) Do(opts ...googleapi.CallOption) (*ListBigQueryExportsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBigQueryExportsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists BigQuery exports. Note that when requesting BigQuery exports at a given level all exports under that level are also returned e.g. if requesting BigQuery exports under a folder, then all BigQuery exports immediately under the folder plus the ones created under the projects within the folder are returned.",
	//   "flatPath": "v1/organizations/{organizationsId}/bigQueryExports",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.bigQueryExports.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of configs to return. The service may return fewer than this value. If unspecified, at most 10 configs will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListBigQueryExports` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListBigQueryExports` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent, which owns the collection of BigQuery exports. Its format is \"organizations/[organization_id]\", \"folders/[folder_id]\", \"projects/[project_id]\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/bigQueryExports",
	//   "response": {
	//     "$ref": "ListBigQueryExportsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsBigQueryExportsListCall) Pages(ctx context.Context, f func(*ListBigQueryExportsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.organizations.bigQueryExports.patch":

type OrganizationsBigQueryExportsPatchCall struct {
	s                                         *Service
	name                                      string
	googlecloudsecuritycenterv1bigqueryexport *GoogleCloudSecuritycenterV1BigQueryExport
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Patch: Updates a BigQuery export.
//
//   - name: The relative resource name of this export. See:
//     https://cloud.google.com/apis/design/resource_names#relative_resource_name.
//     Example format:
//     "organizations/{organization_id}/bigQueryExports/{export_id}"
//     Example format: "folders/{folder_id}/bigQueryExports/{export_id}"
//     Example format: "projects/{project_id}/bigQueryExports/{export_id}"
//     This field is provided in responses, and is ignored when provided
//     in create requests.
func (r *OrganizationsBigQueryExportsService) Patch(name string, googlecloudsecuritycenterv1bigqueryexport *GoogleCloudSecuritycenterV1BigQueryExport) *OrganizationsBigQueryExportsPatchCall {
	c := &OrganizationsBigQueryExportsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudsecuritycenterv1bigqueryexport = googlecloudsecuritycenterv1bigqueryexport
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated. If empty all mutable fields will be updated.
func (c *OrganizationsBigQueryExportsPatchCall) UpdateMask(updateMask string) *OrganizationsBigQueryExportsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsBigQueryExportsPatchCall) Fields(s ...googleapi.Field) *OrganizationsBigQueryExportsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsBigQueryExportsPatchCall) Context(ctx context.Context) *OrganizationsBigQueryExportsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsBigQueryExportsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsBigQueryExportsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudsecuritycenterv1bigqueryexport)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.bigQueryExports.patch" call.
// Exactly one of *GoogleCloudSecuritycenterV1BigQueryExport or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudSecuritycenterV1BigQueryExport.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsBigQueryExportsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudSecuritycenterV1BigQueryExport, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudSecuritycenterV1BigQueryExport{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a BigQuery export.",
	//   "flatPath": "v1/organizations/{organizationsId}/bigQueryExports/{bigQueryExportsId}",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.organizations.bigQueryExports.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The relative resource name of this export. See: https://cloud.google.com/apis/design/resource_names#relative_resource_name. Example format: \"organizations/{organization_id}/bigQueryExports/{export_id}\" Example format: \"folders/{folder_id}/bigQueryExports/{export_id}\" Example format: \"projects/{project_id}/bigQueryExports/{export_id}\" This field is provided in responses, and is ignored when provided in create requests.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/bigQueryExports/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated. If empty all mutable fields will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudSecuritycenterV1BigQueryExport"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudSecuritycenterV1BigQueryExport"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.eventThreatDetectionSettings.validateCustomModule":

type OrganizationsEventThreatDetectionSettingsValidateCustomModuleCall struct {
	s                                               *Service
	parent                                          string
	validateeventthreatdetectioncustommodulerequest *ValidateEventThreatDetectionCustomModuleRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// ValidateCustomModule: Validates the given Event Threat Detection
// custom module.
//
//   - parent: Resource name of the parent to validate the Custom Module
//     under. Its format is: *
//     "organizations/{organization}/eventThreatDetectionSettings". *
//     "folders/{folder}/eventThreatDetectionSettings". *
//     "projects/{project}/eventThreatDetectionSettings".
func (r *OrganizationsEventThreatDetectionSettingsService) ValidateCustomModule(parent string, validateeventthreatdetectioncustommodulerequest *ValidateEventThreatDetectionCustomModuleRequest) *OrganizationsEventThreatDetectionSettingsValidateCustomModuleCall {
	c := &OrganizationsEventThreatDetectionSettingsValidateCustomModuleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.validateeventthreatdetectioncustommodulerequest = validateeventthreatdetectioncustommodulerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsEventThreatDetectionSettingsValidateCustomModuleCall) Fields(s ...googleapi.Field) *OrganizationsEventThreatDetectionSettingsValidateCustomModuleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsEventThreatDetectionSettingsValidateCustomModuleCall) Context(ctx context.Context) *OrganizationsEventThreatDetectionSettingsValidateCustomModuleCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsEventThreatDetectionSettingsValidateCustomModuleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsEventThreatDetectionSettingsValidateCustomModuleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.validateeventthreatdetectioncustommodulerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:validateCustomModule")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.eventThreatDetectionSettings.validateCustomModule" call.
// Exactly one of *ValidateEventThreatDetectionCustomModuleResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *ValidateEventThreatDetectionCustomModuleResponse.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsEventThreatDetectionSettingsValidateCustomModuleCall) Do(opts ...googleapi.CallOption) (*ValidateEventThreatDetectionCustomModuleResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ValidateEventThreatDetectionCustomModuleResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Validates the given Event Threat Detection custom module.",
	//   "flatPath": "v1/organizations/{organizationsId}/eventThreatDetectionSettings:validateCustomModule",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.organizations.eventThreatDetectionSettings.validateCustomModule",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Resource name of the parent to validate the Custom Module under. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings\". * \"folders/{folder}/eventThreatDetectionSettings\". * \"projects/{project}/eventThreatDetectionSettings\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}:validateCustomModule",
	//   "request": {
	//     "$ref": "ValidateEventThreatDetectionCustomModuleRequest"
	//   },
	//   "response": {
	//     "$ref": "ValidateEventThreatDetectionCustomModuleResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.eventThreatDetectionSettings.customModules.create":

type OrganizationsEventThreatDetectionSettingsCustomModulesCreateCall struct {
	s                                *Service
	parent                           string
	eventthreatdetectioncustommodule *EventThreatDetectionCustomModule
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Create: Creates a resident Event Threat Detection custom module at
// the scope of the given Resource Manager parent, and also creates
// inherited custom modules for all descendants of the given parent.
// These modules are enabled by default.
//
//   - parent: The new custom module's parent. Its format is: *
//     "organizations/{organization}/eventThreatDetectionSettings". *
//     "folders/{folder}/eventThreatDetectionSettings". *
//     "projects/{project}/eventThreatDetectionSettings".
func (r *OrganizationsEventThreatDetectionSettingsCustomModulesService) Create(parent string, eventthreatdetectioncustommodule *EventThreatDetectionCustomModule) *OrganizationsEventThreatDetectionSettingsCustomModulesCreateCall {
	c := &OrganizationsEventThreatDetectionSettingsCustomModulesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.eventthreatdetectioncustommodule = eventthreatdetectioncustommodule
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesCreateCall) Fields(s ...googleapi.Field) *OrganizationsEventThreatDetectionSettingsCustomModulesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesCreateCall) Context(ctx context.Context) *OrganizationsEventThreatDetectionSettingsCustomModulesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsEventThreatDetectionSettingsCustomModulesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventthreatdetectioncustommodule)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/customModules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.eventThreatDetectionSettings.customModules.create" call.
// Exactly one of *EventThreatDetectionCustomModule or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionCustomModule.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesCreateCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionCustomModule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventThreatDetectionCustomModule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a resident Event Threat Detection custom module at the scope of the given Resource Manager parent, and also creates inherited custom modules for all descendants of the given parent. These modules are enabled by default.",
	//   "flatPath": "v1/organizations/{organizationsId}/eventThreatDetectionSettings/customModules",
	//   "httpMethod": "POST",
	//   "id": "securitycenter.organizations.eventThreatDetectionSettings.customModules.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The new custom module's parent. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings\". * \"folders/{folder}/eventThreatDetectionSettings\". * \"projects/{project}/eventThreatDetectionSettings\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/customModules",
	//   "request": {
	//     "$ref": "EventThreatDetectionCustomModule"
	//   },
	//   "response": {
	//     "$ref": "EventThreatDetectionCustomModule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.eventThreatDetectionSettings.customModules.delete":

type OrganizationsEventThreatDetectionSettingsCustomModulesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified Event Threat Detection custom module
// and all of its descendants in the Resource Manager hierarchy. This
// method is only supported for resident custom modules.
//
//   - name: Name of the custom module to delete. Its format is: *
//     "organizations/{organization}/eventThreatDetectionSettings/customMod
//     ules/{module}". *
//     "folders/{folder}/eventThreatDetectionSettings/customModules/{module
//     }". *
//     "projects/{project}/eventThreatDetectionSettings/customModules/{modu
//     le}".
func (r *OrganizationsEventThreatDetectionSettingsCustomModulesService) Delete(name string) *OrganizationsEventThreatDetectionSettingsCustomModulesDeleteCall {
	c := &OrganizationsEventThreatDetectionSettingsCustomModulesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsEventThreatDetectionSettingsCustomModulesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesDeleteCall) Context(ctx context.Context) *OrganizationsEventThreatDetectionSettingsCustomModulesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsEventThreatDetectionSettingsCustomModulesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.eventThreatDetectionSettings.customModules.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the specified Event Threat Detection custom module and all of its descendants in the Resource Manager hierarchy. This method is only supported for resident custom modules.",
	//   "flatPath": "v1/organizations/{organizationsId}/eventThreatDetectionSettings/customModules/{customModulesId}",
	//   "httpMethod": "DELETE",
	//   "id": "securitycenter.organizations.eventThreatDetectionSettings.customModules.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the custom module to delete. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings/customModules/{module}\". * \"folders/{folder}/eventThreatDetectionSettings/customModules/{module}\". * \"projects/{project}/eventThreatDetectionSettings/customModules/{module}\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/eventThreatDetectionSettings/customModules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.eventThreatDetectionSettings.customModules.get":

type OrganizationsEventThreatDetectionSettingsCustomModulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an Event Threat Detection custom module.
//
//   - name: Name of the custom module to get. Its format is: *
//     "organizations/{organization}/eventThreatDetectionSettings/customMod
//     ules/{module}". *
//     "folders/{folder}/eventThreatDetectionSettings/customModules/{module
//     }". *
//     "projects/{project}/eventThreatDetectionSettings/customModules/{modu
//     le}".
func (r *OrganizationsEventThreatDetectionSettingsCustomModulesService) Get(name string) *OrganizationsEventThreatDetectionSettingsCustomModulesGetCall {
	c := &OrganizationsEventThreatDetectionSettingsCustomModulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesGetCall) Fields(s ...googleapi.Field) *OrganizationsEventThreatDetectionSettingsCustomModulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesGetCall) IfNoneMatch(entityTag string) *OrganizationsEventThreatDetectionSettingsCustomModulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesGetCall) Context(ctx context.Context) *OrganizationsEventThreatDetectionSettingsCustomModulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsEventThreatDetectionSettingsCustomModulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.eventThreatDetectionSettings.customModules.get" call.
// Exactly one of *EventThreatDetectionCustomModule or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionCustomModule.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesGetCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionCustomModule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventThreatDetectionCustomModule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an Event Threat Detection custom module.",
	//   "flatPath": "v1/organizations/{organizationsId}/eventThreatDetectionSettings/customModules/{customModulesId}",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.eventThreatDetectionSettings.customModules.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the custom module to get. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings/customModules/{module}\". * \"folders/{folder}/eventThreatDetectionSettings/customModules/{module}\". * \"projects/{project}/eventThreatDetectionSettings/customModules/{module}\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/eventThreatDetectionSettings/customModules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "EventThreatDetectionCustomModule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.eventThreatDetectionSettings.customModules.list":

type OrganizationsEventThreatDetectionSettingsCustomModulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Event Threat Detection custom modules for the given
// Resource Manager parent. This includes resident modules defined at
// the scope of the parent along with modules inherited from ancestors.
//
//   - parent: Name of the parent to list custom modules under. Its format
//     is: * "organizations/{organization}/eventThreatDetectionSettings".
//   - "folders/{folder}/eventThreatDetectionSettings". *
//     "projects/{project}/eventThreatDetectionSettings".
func (r *OrganizationsEventThreatDetectionSettingsCustomModulesService) List(parent string) *OrganizationsEventThreatDetectionSettingsCustomModulesListCall {
	c := &OrganizationsEventThreatDetectionSettingsCustomModulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of modules to return. The service may return fewer than this value.
// If unspecified, at most 10 configs will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListCall) PageSize(pageSize int64) *OrganizationsEventThreatDetectionSettingsCustomModulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListEventThreatDetectionCustomModules`
// call. Provide this to retrieve the subsequent page. When paginating,
// all other parameters provided to
// `ListEventThreatDetectionCustomModules` must match the call that
// provided the page token.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListCall) PageToken(pageToken string) *OrganizationsEventThreatDetectionSettingsCustomModulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListCall) Fields(s ...googleapi.Field) *OrganizationsEventThreatDetectionSettingsCustomModulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListCall) IfNoneMatch(entityTag string) *OrganizationsEventThreatDetectionSettingsCustomModulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListCall) Context(ctx context.Context) *OrganizationsEventThreatDetectionSettingsCustomModulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/customModules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.eventThreatDetectionSettings.customModules.list" call.
// Exactly one of *ListEventThreatDetectionCustomModulesResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *ListEventThreatDetectionCustomModulesResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListCall) Do(opts ...googleapi.CallOption) (*ListEventThreatDetectionCustomModulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEventThreatDetectionCustomModulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all Event Threat Detection custom modules for the given Resource Manager parent. This includes resident modules defined at the scope of the parent along with modules inherited from ancestors.",
	//   "flatPath": "v1/organizations/{organizationsId}/eventThreatDetectionSettings/customModules",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.eventThreatDetectionSettings.customModules.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of modules to return. The service may return fewer than this value. If unspecified, at most 10 configs will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListEventThreatDetectionCustomModules` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListEventThreatDetectionCustomModules` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the parent to list custom modules under. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings\". * \"folders/{folder}/eventThreatDetectionSettings\". * \"projects/{project}/eventThreatDetectionSettings\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/customModules",
	//   "response": {
	//     "$ref": "ListEventThreatDetectionCustomModulesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListCall) Pages(ctx context.Context, f func(*ListEventThreatDetectionCustomModulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.organizations.eventThreatDetectionSettings.customModules.listDescendant":

type OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListDescendant: Lists all resident Event Threat Detection custom
// modules under the given Resource Manager parent and its descendants.
//
//   - parent: Name of the parent to list custom modules under. Its format
//     is: * "organizations/{organization}/eventThreatDetectionSettings".
//   - "folders/{folder}/eventThreatDetectionSettings". *
//     "projects/{project}/eventThreatDetectionSettings".
func (r *OrganizationsEventThreatDetectionSettingsCustomModulesService) ListDescendant(parent string) *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall {
	c := &OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of modules to return. The service may return fewer than this value.
// If unspecified, at most 10 configs will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall) PageSize(pageSize int64) *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous
// `ListDescendantEventThreatDetectionCustomModules` call. Provide this
// to retrieve the subsequent page. When paginating, all other
// parameters provided to
// `ListDescendantEventThreatDetectionCustomModules` must match the call
// that provided the page token.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall) PageToken(pageToken string) *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall) Fields(s ...googleapi.Field) *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall) IfNoneMatch(entityTag string) *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall) Context(ctx context.Context) *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/customModules:listDescendant")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.eventThreatDetectionSettings.customModules.listDescendant" call.
// Exactly one of
// *ListDescendantEventThreatDetectionCustomModulesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *ListDescendantEventThreatDetectionCustomModulesResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall) Do(opts ...googleapi.CallOption) (*ListDescendantEventThreatDetectionCustomModulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDescendantEventThreatDetectionCustomModulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all resident Event Threat Detection custom modules under the given Resource Manager parent and its descendants.",
	//   "flatPath": "v1/organizations/{organizationsId}/eventThreatDetectionSettings/customModules:listDescendant",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.eventThreatDetectionSettings.customModules.listDescendant",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of modules to return. The service may return fewer than this value. If unspecified, at most 10 configs will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListDescendantEventThreatDetectionCustomModules` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListDescendantEventThreatDetectionCustomModules` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the parent to list custom modules under. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings\". * \"folders/{folder}/eventThreatDetectionSettings\". * \"projects/{project}/eventThreatDetectionSettings\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/customModules:listDescendant",
	//   "response": {
	//     "$ref": "ListDescendantEventThreatDetectionCustomModulesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesListDescendantCall) Pages(ctx context.Context, f func(*ListDescendantEventThreatDetectionCustomModulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "securitycenter.organizations.eventThreatDetectionSettings.customModules.patch":

type OrganizationsEventThreatDetectionSettingsCustomModulesPatchCall struct {
	s                                *Service
	name                             string
	eventthreatdetectioncustommodule *EventThreatDetectionCustomModule
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Patch: Updates the Event Threat Detection custom module with the
// given name based on the given update mask. Updating the enablement
// state is supported for both resident and inherited modules (though
// resident modules cannot have an enablement state of "inherited").
// Updating the display name or configuration of a module is supported
// for resident modules only. The type of a module cannot be changed.
//
//   - name: Immutable. The resource name of the Event Threat Detection
//     custom module. Its format is: *
//     "organizations/{organization}/eventThreatDetectionSettings/customMod
//     ules/{module}". *
//     "folders/{folder}/eventThreatDetectionSettings/customModules/{module
//     }". *
//     "projects/{project}/eventThreatDetectionSettings/customModules/{modu
//     le}".
func (r *OrganizationsEventThreatDetectionSettingsCustomModulesService) Patch(name string, eventthreatdetectioncustommodule *EventThreatDetectionCustomModule) *OrganizationsEventThreatDetectionSettingsCustomModulesPatchCall {
	c := &OrganizationsEventThreatDetectionSettingsCustomModulesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.eventthreatdetectioncustommodule = eventthreatdetectioncustommodule
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated. If empty all mutable fields will be updated.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesPatchCall) UpdateMask(updateMask string) *OrganizationsEventThreatDetectionSettingsCustomModulesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesPatchCall) Fields(s ...googleapi.Field) *OrganizationsEventThreatDetectionSettingsCustomModulesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesPatchCall) Context(ctx context.Context) *OrganizationsEventThreatDetectionSettingsCustomModulesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsEventThreatDetectionSettingsCustomModulesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventthreatdetectioncustommodule)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.eventThreatDetectionSettings.customModules.patch" call.
// Exactly one of *EventThreatDetectionCustomModule or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionCustomModule.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsEventThreatDetectionSettingsCustomModulesPatchCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionCustomModule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventThreatDetectionCustomModule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the Event Threat Detection custom module with the given name based on the given update mask. Updating the enablement state is supported for both resident and inherited modules (though resident modules cannot have an enablement state of \"inherited\"). Updating the display name or configuration of a module is supported for resident modules only. The type of a module cannot be changed.",
	//   "flatPath": "v1/organizations/{organizationsId}/eventThreatDetectionSettings/customModules/{customModulesId}",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.organizations.eventThreatDetectionSettings.customModules.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The resource name of the Event Threat Detection custom module. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings/customModules/{module}\". * \"folders/{folder}/eventThreatDetectionSettings/customModules/{module}\". * \"projects/{project}/eventThreatDetectionSettings/customModules/{module}\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/eventThreatDetectionSettings/customModules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated. If empty all mutable fields will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "EventThreatDetectionCustomModule"
	//   },
	//   "response": {
	//     "$ref": "EventThreatDetectionCustomModule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.eventThreatDetectionSettings.effectiveCustomModules.get":

type OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an effective Event Threat Detection custom module at the
// given level.
//
//   - name: The resource name of the effective Event Threat Detection
//     custom module. Its format is: *
//     "organizations/{organization}/eventThreatDetectionSettings/effective
//     CustomModules/{module}". *
//     "folders/{folder}/eventThreatDetectionSettings/effectiveCustomModule
//     s/{module}". *
//     "projects/{project}/eventThreatDetectionSettings/effectiveCustomModu
//     les/{module}".
func (r *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesService) Get(name string) *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesGetCall {
	c := &OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesGetCall) Fields(s ...googleapi.Field) *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesGetCall) IfNoneMatch(entityTag string) *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesGetCall) Context(ctx context.Context) *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.eventThreatDetectionSettings.effectiveCustomModules.get" call.
// Exactly one of *EffectiveEventThreatDetectionCustomModule or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *EffectiveEventThreatDetectionCustomModule.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesGetCall) Do(opts ...googleapi.CallOption) (*EffectiveEventThreatDetectionCustomModule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EffectiveEventThreatDetectionCustomModule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an effective Event Threat Detection custom module at the given level.",
	//   "flatPath": "v1/organizations/{organizationsId}/eventThreatDetectionSettings/effectiveCustomModules/{effectiveCustomModulesId}",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.eventThreatDetectionSettings.effectiveCustomModules.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the effective Event Threat Detection custom module. Its format is: * \"organizations/{organization}/eventThreatDetectionSettings/effectiveCustomModules/{module}\". * \"folders/{folder}/eventThreatDetectionSettings/effectiveCustomModules/{module}\". * \"projects/{project}/eventThreatDetectionSettings/effectiveCustomModules/{module}\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/eventThreatDetectionSettings/effectiveCustomModules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "EffectiveEventThreatDetectionCustomModule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.eventThreatDetectionSettings.effectiveCustomModules.list":

type OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all effective Event Threat Detection custom modules for
// the given parent. This includes resident modules defined at the scope
// of the parent along with modules inherited from its ancestors.
//
//   - parent: Name of the parent to list custom modules for. Its format
//     is: * "organizations/{organization}/eventThreatDetectionSettings".
//   - "folders/{folder}/eventThreatDetectionSettings". *
//     "projects/{project}/eventThreatDetectionSettings".
func (r *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesService) List(parent string) *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall {
	c := &OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of modules to return. The service may return fewer than this value.
// If unspecified, at most 10 configs will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall) PageSize(pageSize int64) *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous
// `ListEffectiveEventThreatDetectionCustomModules` call. Provide this
// to retrieve the subsequent page. When paginating, all other
// parameters provided to
// `ListEffectiveEventThreatDetectionCustomModules` must match the call
// that provided the page token.
func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall) PageToken(pageToken string) *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall) Fields(s ...googleapi.Field) *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall) IfNoneMatch(entityTag string) *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall) Context(ctx context.Context) *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsEventThreatDetectionSettingsEffectiveCustomModulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}