# frozen_string_literal: true

class AddVulnerabilityUserMentionsProjectIdTrigger < Gitlab::Database::Migration[2.2]
  milestone '17.1'

  def up
    install_sharding_key_assignment_trigger(
      table: :vulnerability_user_mentions,
      sharding_key: :project_id,
      parent_table: :vulnerabilities,
      parent_sharding_key: :project_id,
      foreign_key: :vulnerability_id
    )
  end

  def down
    remove_sharding_key_assignment_trigger(
      table: :vulnerability_user_mentions,
      sharding_key: :project_id,
      parent_table: :vulnerabilities,
      parent_sharding_key: :project_id,
      foreign_key: :vulnerability_id
    )
  end
end
