# frozen_string_literal: true

class QueueBackfillHasVulnerabilityResolution < Gitlab::Database::Migration[2.2]
  milestone '17.5'

  restrict_gitlab_migration gitlab_schema: :gitlab_main

  MIGRATION = "BackfillHasVulnerabilityResolution"
  DELAY_INTERVAL = 2.minutes
  BATCH_SIZE = 5000
  SUB_BATCH_SIZE = 500

  def up
    Gitlab::Database::QueryAnalyzers::Base.suppress_schema_issues_for_decomposed_tables do
      queue_batched_background_migration(
        MIGRATION,
        :vulnerability_reads,
        :id,
        job_interval: DELAY_INTERVAL,
        batch_size: BATCH_SIZE,
        sub_batch_size: SUB_BATCH_SIZE
      )
    end
  end

  def down
    Gitlab::Database::QueryAnalyzers::Base.suppress_schema_issues_for_decomposed_tables do
      delete_batched_background_migration(MIGRATION, :vulnerability_reads, :id, [])
    end
  end
end
