---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Exposure of confidential secret or token npm access token

## Description

The response body contains content that matches the pattern of a npm access token.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

Review the response body content and remove any exposed values.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 798.84 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
