---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Two-factor authentication

DETAILS:
**Tier:** Free, Premium, Ultimate
**Offering:** GitLab.com, Self-managed

Two-factor authentication (2FA) provides an additional level of security to your GitLab account. For others to access
your account, they would need your username and password _and_ access to your second factor of authentication.

GitLab supports as a second factor of authentication:

- One-time password authenticators ([OTP](https://datatracker.ietf.org/doc/html/rfc6238)). When enabled, GitLab prompts
  you for a code when you sign in. Codes are generated by your OTP authenticator (for example, a password
  manager on one of your devices).
- WebAuthn devices. You're prompted to activate your WebAuthn device (usually by pressing a button on it) when
  you supply your username and password to sign in. This performs secure authentication on your behalf.

If you set up a device, also set up an OTP so you can still access your account if you lose the device.

## Use personal access tokens with two-factor authentication

When 2FA is enabled, you can't use your password to authenticate with Git over HTTPS or the [GitLab API](../../../api/rest/index.md).
You can use a [personal access token](../personal_access_tokens.md) instead.

## OAuth credential helpers

The following Git credential helpers authenticate to GitLab using OAuth. This is compatible with two-factor authentication. The first time you authenticate, the helper opens the web browser and GitLab asks you to authorize the app. Subsequent authentication requires no interaction.

### Git Credential Manager

[Git Credential Manager](https://github.com/GitCredentialManager/git-credential-manager) (GCM) authenticates by default using OAuth. GCM supports GitLab.com without any manual configuration. To use GCM with self-managed GitLab, see [GitLab support](https://github.com/GitCredentialManager/git-credential-manager/blob/main/docs/gitlab.md).

So you do not need to re-authenticate on every push, GCM supports caching as well as a variety of platform-specific credential stores that persist between sessions. This feature is useful whether you use personal access tokens or OAuth.

Git for Windows includes Git Credential Manager.

Git Credential Manager is developed primarily by GitHub, Inc. It is an open-source project and is supported by the community.

### git-credential-oauth

[git-credential-oauth](https://github.com/hickford/git-credential-oauth) supports GitLab.com and several popular public hosts without any manual configuration needed. To use with self-managed GitLab, see the [git-credential-oauth custom hosts documentation](https://github.com/hickford/git-credential-oauth#custom-hosts).

Many Linux distributions include git-credential-oauth as a package.

git-credential-oauth is an open-source project supported by the community.

## Enable two-factor authentication

You can enable 2FA using a:

- OTP authenticator. After you enable 2FA, back up your [recovery codes](#recovery-codes).
- WebAuthn device.

Your account email must be confirmed to enable 2FA.

### Enable a one-time password authenticator

To enable 2FA with an OTP authenticator:

1. **In GitLab:**
   1. Access your [**User settings**](../index.md#access-your-user-settings).
   1. Select **Account**.
   1. Select **Enable Two-factor Authentication**.
1. **On your device (usually your phone):**
   1. Install a compatible application. For example:
      - Cloud-based (recommended because you can restore access if you lose the hardware device):
        - [Authy](https://authy.com/).
        - [Cisco Duo](https://duo.com/).
      - Other (proprietary):
        - [Google Authenticator](https://support.google.com/accounts/answer/1066447?hl=en).
        - [Microsoft Authenticator](https://www.microsoft.com/en-us/security/mobile-authenticator-app).
      - Other (Free Software)
        - [Aegis Authenticator](https://getaegis.app/).
        - [FreeOTP](https://freeotp.github.io/).
   1. In the application, add a new entry in one of two ways:
      - Scan the code displayed by GitLab with your device's camera to add the entry automatically.
      - Enter the details provided to add the entry manually.
1. **In GitLab:**
   1. Enter the six-digit pin number from the entry on your device into **Pin code**.
   1. Enter your current password.
   1. Select **Submit**.

If you entered the correct pin, GitLab displays a list of [recovery codes](#recovery-codes). Download them and keep them
in a safe place.

### Enable a one-time password authenticator using FortiAuthenticator

On self-managed GitLab, by default this feature is not available. To make it available per user, an administrator can
[enable the feature flag](../../../administration/feature_flags.md) named `forti_authenticator`.
On GitLab.com and GitLab Dedicated, this feature is not available.

You can use FortiAuthenticator as an OTP provider in GitLab. Users must:

- Exist in both FortiAuthenticator and GitLab with the same username.
- Have FortiToken configured in FortiAuthenticator.

You need a username and access token for FortiAuthenticator. The `access_token` shown below is the FortAuthenticator
access key. To get the token, see the REST API Solution Guide at
[Fortinet Document Library](https://docs.fortinet.com/document/fortiauthenticator/6.2.0/rest-api-solution-guide/158294/the-fortiauthenticator-api).
Tested with FortAuthenticator version 6.2.0.

Configure FortiAuthenticator in GitLab. On your GitLab server:

1. Open the configuration file.

   For Linux package installations:

   ```shell
   sudo editor /etc/gitlab/gitlab.rb
   ```

   For self-compiled installations:

   ```shell
   cd /home/git/gitlab
   sudo -u git -H editor config/gitlab.yml
   ```

1. Add the provider configuration.

   For Linux package installations:

   ```ruby
   gitlab_rails['forti_authenticator_enabled'] = true
   gitlab_rails['forti_authenticator_host'] = 'forti_authenticator.example.com'
   gitlab_rails['forti_authenticator_port'] = 443
   gitlab_rails['forti_authenticator_username'] = '<some_username>'
   gitlab_rails['forti_authenticator_access_token'] = 's3cr3t'
   ```

   For self-compiled installations:

   ```yaml
   forti_authenticator:
     enabled: true
     host: forti_authenticator.example.com
     port: 443
     username: <some_username>
     access_token: s3cr3t
   ```

1. Save the configuration file.
1. [Reconfigure](../../../administration/restart_gitlab.md#reconfigure-a-linux-package-installation)
   (Linux package installations) or [restart](../../../administration/restart_gitlab.md#self-compiled-installations)
   (self-compiled installations).

### Enable a one-time password authenticator using Cisco Duo

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/15760) in GitLab 15.10.

FLAG:
On self-managed GitLab, by default this feature is available. On GitLab.com this feature is not available.

You can use Cisco Duo as an OTP provider in GitLab.

DUO® is a registered trademark of Cisco Systems, Inc., and/or its affiliates in the United States and certain other countries.

#### Prerequisites

To use Cisco Duo as an OTP provider:

- Your account must exist in both Cisco Duo and GitLab, with the same username in both applications.
- You must have [configured Cisco Duo](https://admin.duosecurity.com/) and have an integration key, secret key, and API hostname.

For more information, see the [Cisco Duo API documentation](https://duo.com/docs/authapi).

GitLab 15.10 has been tested with Cisco Duo version D261.14

#### Configure Cisco Duo in GitLab

On your GitLab server:

1. Open the configuration file.

   For Linux package installations:

   ```shell
   sudo editor /etc/gitlab/gitlab.rb
   ```

   For self-compiled installations:

   ```shell
   cd /home/git/gitlab
   sudo -u git -H editor config/gitlab.yml
   ```

1. Add the provider configuration.

   For Linux package installations:

   ```ruby
    gitlab_rails['duo_auth_enabled'] = false
    gitlab_rails['duo_auth_integration_key'] = '<duo_integration_key_value>'
    gitlab_rails['duo_auth_secret_key'] = '<duo_secret_key_value>'
    gitlab_rails['duo_auth_hostname'] = '<duo_api_hostname>'
   ```

   For self-compiled installations:

   ```yaml
   duo_auth:
     enabled: true
     hostname: <duo_api_hostname>
     integration_key: <duo_integration_key_value>
     secret_key: <duo_secret_key_value>
   ```

1. Save the configuration file.
1. For Linux package installations, [reconfigure GitLab](../../../administration/restart_gitlab.md#reconfigure-a-linux-package-installation).
   For self-compiled installations, [restart GitLab](../../../administration/restart_gitlab.md#self-compiled-installations).

### Enable a one-time password authenticator using FortiToken Cloud

DETAILS:
**Offering:** Self-managed

FLAG:
On self-managed GitLab, by default this feature is not available. To make it available per user, an administrator can
[enable the feature flag](../../../administration/feature_flags.md) named `forti_token_cloud`.
On GitLab.com and GitLab Dedicated, this feature is not available.
This feature is not ready for production use.

You can use FortiToken Cloud as an OTP provider in GitLab. Users must:

- Exist in both FortiToken Cloud and GitLab with the same username.
- Have FortiToken configured in FortiToken Cloud.

You need a `client_id` and `client_secret` to configure FortiToken Cloud. To get these, see the REST API Guide at
[Fortinet Document Library](https://docs.fortinet.com/document/fortitoken-cloud/latest/rest-api/456035/overview).

Configure FortiToken Cloud in GitLab. On your GitLab server:

1. Open the configuration file.

   For Linux package installations:

   ```shell
   sudo editor /etc/gitlab/gitlab.rb
   ```

   For self-compiled installations:

   ```shell
   cd /home/git/gitlab
   sudo -u git -H editor config/gitlab.yml
   ```

1. Add the provider configuration.

   For Linux package installations:

   ```ruby
   gitlab_rails['forti_token_cloud_enabled'] = true
   gitlab_rails['forti_token_cloud_client_id'] = '<your_fortinet_cloud_client_id>'
   gitlab_rails['forti_token_cloud_client_secret'] = '<your_fortinet_cloud_client_secret>'
   ```

   For self-compiled installations:

   ```yaml
   forti_token_cloud:
     enabled: true
     client_id: YOUR_FORTI_TOKEN_CLOUD_CLIENT_ID
     client_secret: YOUR_FORTI_TOKEN_CLOUD_CLIENT_SECRET
   ```

1. Save the configuration file.
1. [Reconfigure](../../../administration/restart_gitlab.md#reconfigure-a-linux-package-installation) (Linux package installations) or
   [restart](../../../administration/restart_gitlab.md#self-compiled-installations) (self-compiled installations).

### Set up a WebAuthn device

> - Optional one-time password authentication for WebAuthn devices [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/378844) in GitLab 15.10 [with a feature flag](../../../administration/feature_flags.md) named `webauthn_without_totp`.
> - [Generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/396931) in GitLab 17.6. Feature flag `webauthn_without_totp` removed.

WebAuthn is [supported by](https://caniuse.com/#search=webauthn) the following:

- Desktop browsers:
  - Chrome
  - Edge
  - Firefox
  - Opera
  - Safari
- Mobile browsers:
  - Chrome for Android
  - Firefox for Android
  - iOS Safari (since iOS 13.3)

To set up 2FA with a WebAuthn-compatible device:

1. Optional. [Set up an OTP authenticator](#enable-a-one-time-password-authenticator).
1. Access your [**User settings**](../index.md#access-your-user-settings).
1. Select **Account**.
1. Select **Enable Two-Factor Authentication**.
1. Plug in your WebAuthn device.
1. Enter a device name and in GitLab 15.10 and later, your GitLab account password.
   You might not need to enter this password if you have signed in through your
   identity provider.
1. Select **Set up New WebAuthn Device**.
1. Depending on your device, you might have to press a button or touch a sensor.

You should receive a message indicating that you successfully set up your device.

When you set up 2FA with a WebAuthn-compatible device, that device is linked to
a specific browser on a specific computer. Depending on the browser and WebAuthn
device, you might be able to configure settings to use the WebAuthn device on a
different browser or computer.

If this is the first time you have set up 2FA, you
must [download recovery codes](#recovery-codes) so you can recover access to your
account if you lose access.

WARNING:
You can lose access to your account if you clear your browser data.

## Recovery codes

Immediately after successfully enabling 2FA with an OTP authenticator, you're prompted to download
a set of generated recovery codes. If you ever lose access to your OTP authenticator, you can use one of
these recovery codes to sign in to your account.

WARNING:
Each code can be used only once to sign in to your account.

You should copy and print the codes, or use **Download codes** to download them for storage in a safe
place. If you choose to download them, the file is called `gitlab-recovery-codes.txt`.

> - Recovery codes are not generated for WebAuthn devices.
> - `gitlab-sshd` is not suitable for regenerating recovery codes.

If you lose the recovery codes, or want to generate new ones, you can use either:

- The [2FA account settings](#regenerate-two-factor-authentication-recovery-codes) page.
- [SSH](two_factor_authentication_troubleshooting.md#generate-new-recovery-codes-using-ssh).

### Regenerate two-factor authentication recovery codes

To regenerate 2FA recovery codes, you need access to a desktop browser:

1. Access your [**User settings**](../index.md#access-your-user-settings).
1. Select **Account > Two-Factor Authentication (2FA)**.
1. If you've already configured 2FA, select **Manage two-factor authentication**.
1. In the **Disable two-factor authentication** section, select **Regenerate recovery codes**.
1. On the dialog, enter your current password and select **Regenerate recovery codes**.

NOTE:
If you regenerate 2FA recovery codes, save them. You can't use any previously created 2FA codes.

## Sign in with two-factor authentication enabled

Signing in with 2FA enabled is only slightly different than the typical sign-in process. Enter your username and password
and you're presented with a second prompt, depending on which type of 2FA you've enabled.

### Sign in using a one-time password authenticator

When asked, enter the pin from your OTP authenticator or a recovery code to sign in.

### Sign in using a WebAuthn device

In supported browsers, you should be automatically prompted to activate your WebAuthn device (for example, by touching
or pressing its button) after entering your credentials.

A message displays indicating that your device responded to the authentication request and you're automatically signed
in.

## Disable two-factor authentication

> - Ability to disable OTP authenticator and WebAuthn devices individually or simultaneously [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/393419) in GitLab 17.6.

You can disable the OTP authenticator and WebAuthn devices individually or simultaneously. To disable them simultaneously:

1. Access your [**User settings**](../index.md#access-your-user-settings).
1. Select **Account**.
1. Select **Manage two-factor authentication**.
1. In the **Disable two-factor authentication** section, select **Disable two-factor authentication**.
1. On the dialog, enter your current password and select **Disable two-factor authentication**.

This clears all your 2FA registrations, including mobile applications and WebAuthn devices.

## Information for GitLab administrators

DETAILS:
**Tier:** Free, Premium, Ultimate
**Offering:** Self-managed

- Take care that 2FA keeps working after [restoring a GitLab backup](../../../administration/backup_restore/index.md).
- To ensure 2FA authorizes correctly with an OTP server, synchronize your GitLab
  server's time using a service like NTP. Otherwise, authorization can always fail because of time differences.
- The GitLab WebAuthn implementation does _not_ work when the GitLab instance is accessed from multiple hostnames
  or FQDNs. Each WebAuthn registration is linked to the _current hostname_ at the time of registration, and
  cannot be used for other hostnames or FQDNs.

  For example, if a user is trying to access a GitLab instance from `first.host.xyz` and `second.host.xyz`:

  - The user signs in by using `first.host.xyz` and registers their WebAuthn key.
  - The user signs out and attempts to sign in by using `first.host.xyz` - WebAuthn authentication succeeds.
  - The user signs out and attempts to sign in by using `second.host.xyz` - WebAuthn authentication fails, because
    the WebAuthn key has only been registered on `first.host.xyz`.

- To enforce 2FA at the system or group levels see, [Enforce two-factor authentication](../../../security/two_factor_authentication.md).
