// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

type Organization struct {
	Common
	FullName string `json:"full_name"`
	Name     string `json:"name"`
}

func (o Organization) Equal(other Organization) bool {
	return o.Common.Equal(other.Common) &&
		o.FullName == other.FullName &&
		o.Name == other.Name
}

func (o *Organization) GetName() string {
	return o.Name
}

func (o *Organization) Clone() Interface {
	clone := &Organization{}
	*clone = *o
	return clone
}
