// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package forgejo

import (
	"context"

	"code.forgejo.org/f3/gof3/v3/id"
	"code.forgejo.org/f3/gof3/v3/kind"
	options_http "code.forgejo.org/f3/gof3/v3/options/http"
	f3_tree "code.forgejo.org/f3/gof3/v3/tree/f3"
	"code.forgejo.org/f3/gof3/v3/tree/generic"

	forgejo_sdk "code.forgejo.org/f3/gof3/v3/forges/forgejo/sdk"
	"github.com/hashicorp/go-version"
)

func maybeMilestoneID(milestone *forgejo_sdk.Milestone) *int64 {
	if milestone != nil {
		id := milestone.ID
		return &id
	}
	return nil
}

func labelListToIDs(labels []*forgejo_sdk.Label) []int64 {
	ids := make([]int64, 0, len(labels))
	for _, label := range labels {
		ids = append(ids, label.ID)
	}
	return ids
}

type common struct {
	generic.NullDriver
}

func (o *common) GetHelper() any {
	panic("not implemented")
}

func (o *common) ListPage(ctx context.Context, page int) generic.ChildrenSlice {
	return generic.NewChildrenSlice(0)
}

func (o *common) getTree() generic.TreeInterface {
	return o.GetNode().GetTree()
}

func (o *common) getForge() *forge {
	return o.getTree().GetRoot().GetChild(id.NewNodeID(f3_tree.KindForge)).GetDriver().(*forge)
}

func (o *common) getPageSize() int {
	return o.getTreeDriver().GetPageSize()
}

func (o *common) getF3Tree() f3_tree.TreeInterface {
	return o.getTree().(f3_tree.TreeInterface)
}

func (o *common) getKind() kind.Kind {
	return o.GetNode().GetKind()
}

func (o *common) getChildDriver(kind kind.Kind) generic.NodeDriverInterface {
	return o.GetNode().GetChild(id.NewNodeID(kind)).GetDriver()
}

func (o *common) getProject() *project {
	return f3_tree.GetProject(o.GetNode()).GetDriver().(*project)
}

func (o *common) isContainer() bool {
	return o.getF3Tree().IsContainer(o.getKind())
}

func (o *common) getPushURL() string {
	return o.getTreeDriver().options.GetPushURL()
}

func (o *common) getNewMigrationHTTPClient() options_http.NewMigrationHTTPClientFun {
	return o.getTreeDriver().options.GetNewMigrationHTTPClient()
}

func (o *common) getTreeDriver() *treeDriver {
	return o.GetTreeDriver().(*treeDriver)
}

func (o *common) getIsAdmin() bool {
	return o.getTreeDriver().GetIsAdmin()
}

func (o *common) getClient() *forgejo_sdk.Client {
	return o.getTreeDriver().GetClient()
}

func (o *common) maybeSudoName(name string) {
	o.getTreeDriver().MaybeSudoName(name)
}

func (o *common) maybeSudoID(ctx context.Context, id int64) {
	o.getTreeDriver().maybeSudoID(ctx, id)
}

func (o *common) notSudo() {
	o.getTreeDriver().NotSudo()
}

func (o *common) getVersion() *version.Version {
	return o.getTreeDriver().GetVersion()
}

func (o *common) IsNull() bool { return false }
