// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package path

import (
	"code.forgejo.org/f3/gof3/v3/f3"
	"code.forgejo.org/f3/gof3/v3/id"
	"code.forgejo.org/f3/gof3/v3/kind"
)

type PathElementAllocator func() PathElement

type PathElement interface {
	SetID(id.NodeID)
	GetID() id.NodeID

	SetMappedID(id.NodeID)
	GetMappedID() id.NodeID

	SetKind(kind kind.Kind)
	GetKind() kind.Kind

	ToFormat() f3.Interface
}

type Path interface {
	Length() int
	PathString() PathString
	PathMappedString() PathString
	String() string
	ReadablePathString() PathString
	ReadableString() string
	Append(child PathElement) Path
	RemoveFirst() Path
	PopFirst() (PathElement, Path)
	Pop() (PathElement, Path)
	RemoveLast() Path
	Empty() bool
	First() PathElement
	Last() PathElement
	All() []PathElement
}

type PathString interface {
	Empty() bool
	Join() string
	Append(element string)
	Elements() []string
}
