// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package util

import (
	"errors"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestPanicToError(t *testing.T) {
	assert.NoError(t, PanicToError(func() {}))

	errorMessage := "ERROR"
	panicingFun := func() {
		panic(errors.New(errorMessage))
	}
	err := PanicToError(panicingFun)
	assert.EqualValues(t, errorMessage, err.Error())
	assert.Contains(t, err.Stack(), "PanicToError")
}
