// Code generated by ffjson <https://github.com/pquerna/ffjson>. DO NOT EDIT.
// source: pkg/archive/archive.go

package archive

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"github.com/containers/storage/pkg/idtools"
	fflib "github.com/pquerna/ffjson/fflib/v1"
	"os"
)

// MarshalJSON marshal bytes to json - template
func (j *Archiver) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *Archiver) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"Untar":`)
	/* Falling back. type=func(io.Reader, string, *archive.TarOptions) error kind=func */
	err = buf.Encode(j.Untar)
	if err != nil {
		return err
	}
	if j.TarIDMappings != nil {
		/* Struct fall back. type=idtools.IDMappings kind=struct */
		buf.WriteString(`,"TarIDMappings":`)
		err = buf.Encode(j.TarIDMappings)
		if err != nil {
			return err
		}
	} else {
		buf.WriteString(`,"TarIDMappings":null`)
	}
	if j.ChownOpts != nil {
		/* Struct fall back. type=idtools.IDPair kind=struct */
		buf.WriteString(`,"ChownOpts":`)
		err = buf.Encode(j.ChownOpts)
		if err != nil {
			return err
		}
	} else {
		buf.WriteString(`,"ChownOpts":null`)
	}
	if j.UntarIDMappings != nil {
		/* Struct fall back. type=idtools.IDMappings kind=struct */
		buf.WriteString(`,"UntarIDMappings":`)
		err = buf.Encode(j.UntarIDMappings)
		if err != nil {
			return err
		}
	} else {
		buf.WriteString(`,"UntarIDMappings":null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffjtArchiverbase = iota
	ffjtArchivernosuchkey

	ffjtArchiverUntar

	ffjtArchiverTarIDMappings

	ffjtArchiverChownOpts

	ffjtArchiverUntarIDMappings
)

var ffjKeyArchiverUntar = []byte("Untar")

var ffjKeyArchiverTarIDMappings = []byte("TarIDMappings")

var ffjKeyArchiverChownOpts = []byte("ChownOpts")

var ffjKeyArchiverUntarIDMappings = []byte("UntarIDMappings")

// UnmarshalJSON umarshall json - template of ffjson
func (j *Archiver) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *Archiver) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtArchiverbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtArchivernosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'C':

					if bytes.Equal(ffjKeyArchiverChownOpts, kn) {
						currentKey = ffjtArchiverChownOpts
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'T':

					if bytes.Equal(ffjKeyArchiverTarIDMappings, kn) {
						currentKey = ffjtArchiverTarIDMappings
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'U':

					if bytes.Equal(ffjKeyArchiverUntar, kn) {
						currentKey = ffjtArchiverUntar
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyArchiverUntarIDMappings, kn) {
						currentKey = ffjtArchiverUntarIDMappings
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffjKeyArchiverUntarIDMappings, kn) {
					currentKey = ffjtArchiverUntarIDMappings
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyArchiverChownOpts, kn) {
					currentKey = ffjtArchiverChownOpts
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyArchiverTarIDMappings, kn) {
					currentKey = ffjtArchiverTarIDMappings
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyArchiverUntar, kn) {
					currentKey = ffjtArchiverUntar
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtArchivernosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtArchiverUntar:
					goto handle_Untar

				case ffjtArchiverTarIDMappings:
					goto handle_TarIDMappings

				case ffjtArchiverChownOpts:
					goto handle_ChownOpts

				case ffjtArchiverUntarIDMappings:
					goto handle_UntarIDMappings

				case ffjtArchivernosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Untar:

	/* handler: j.Untar type=func(io.Reader, string, *archive.TarOptions) error kind=func quoted=false*/

	{
		/* Falling back. type=func(io.Reader, string, *archive.TarOptions) error kind=func */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.Untar)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TarIDMappings:

	/* handler: j.TarIDMappings type=idtools.IDMappings kind=struct quoted=false*/

	{
		/* Falling back. type=idtools.IDMappings kind=struct */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.TarIDMappings)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ChownOpts:

	/* handler: j.ChownOpts type=idtools.IDPair kind=struct quoted=false*/

	{
		/* Falling back. type=idtools.IDPair kind=struct */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.ChownOpts)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_UntarIDMappings:

	/* handler: j.UntarIDMappings type=idtools.IDMappings kind=struct quoted=false*/

	{
		/* Falling back. type=idtools.IDMappings kind=struct */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.UntarIDMappings)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *TarOptions) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *TarOptions) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"IncludeFiles":`)
	if j.IncludeFiles != nil {
		buf.WriteString(`[`)
		for i, v := range j.IncludeFiles {
			if i != 0 {
				buf.WriteString(`,`)
			}
			fflib.WriteJsonString(buf, string(v))
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"ExcludePatterns":`)
	if j.ExcludePatterns != nil {
		buf.WriteString(`[`)
		for i, v := range j.ExcludePatterns {
			if i != 0 {
				buf.WriteString(`,`)
			}
			fflib.WriteJsonString(buf, string(v))
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"Compression":`)
	fflib.FormatBits2(buf, uint64(j.Compression), 10, j.Compression < 0)
	if j.NoLchown {
		buf.WriteString(`,"NoLchown":true`)
	} else {
		buf.WriteString(`,"NoLchown":false`)
	}
	buf.WriteString(`,"UIDMaps":`)
	if j.UIDMaps != nil {
		buf.WriteString(`[`)
		for i, v := range j.UIDMaps {
			if i != 0 {
				buf.WriteString(`,`)
			}
			/* Struct fall back. type=idtools.IDMap kind=struct */
			err = buf.Encode(&v)
			if err != nil {
				return err
			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"GIDMaps":`)
	if j.GIDMaps != nil {
		buf.WriteString(`[`)
		for i, v := range j.GIDMaps {
			if i != 0 {
				buf.WriteString(`,`)
			}
			/* Struct fall back. type=idtools.IDMap kind=struct */
			err = buf.Encode(&v)
			if err != nil {
				return err
			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	if j.IgnoreChownErrors {
		buf.WriteString(`,"IgnoreChownErrors":true`)
	} else {
		buf.WriteString(`,"IgnoreChownErrors":false`)
	}
	if j.ChownOpts != nil {
		/* Struct fall back. type=idtools.IDPair kind=struct */
		buf.WriteString(`,"ChownOpts":`)
		err = buf.Encode(j.ChownOpts)
		if err != nil {
			return err
		}
	} else {
		buf.WriteString(`,"ChownOpts":null`)
	}
	if j.IncludeSourceDir {
		buf.WriteString(`,"IncludeSourceDir":true`)
	} else {
		buf.WriteString(`,"IncludeSourceDir":false`)
	}
	buf.WriteString(`,"WhiteoutFormat":`)
	fflib.FormatBits2(buf, uint64(j.WhiteoutFormat), 10, j.WhiteoutFormat < 0)
	buf.WriteString(`,"WhiteoutData":`)
	/* Interface types must use runtime reflection. type=interface {} kind=interface */
	err = buf.Encode(j.WhiteoutData)
	if err != nil {
		return err
	}
	if j.NoOverwriteDirNonDir {
		buf.WriteString(`,"NoOverwriteDirNonDir":true`)
	} else {
		buf.WriteString(`,"NoOverwriteDirNonDir":false`)
	}
	if j.RebaseNames == nil {
		buf.WriteString(`,"RebaseNames":null`)
	} else {
		buf.WriteString(`,"RebaseNames":{ `)
		for key, value := range j.RebaseNames {
			fflib.WriteJsonString(buf, key)
			buf.WriteString(`:`)
			fflib.WriteJsonString(buf, string(value))
			buf.WriteByte(',')
		}
		buf.Rewind(1)
		buf.WriteByte('}')
	}
	if j.InUserNS {
		buf.WriteString(`,"InUserNS":true`)
	} else {
		buf.WriteString(`,"InUserNS":false`)
	}
	if j.CopyPass {
		buf.WriteString(`,"CopyPass":true`)
	} else {
		buf.WriteString(`,"CopyPass":false`)
	}
	if j.ForceMask != nil {
		buf.WriteString(`,"ForceMask":`)
		fflib.FormatBits2(buf, uint64(*j.ForceMask), 10, false)
	} else {
		buf.WriteString(`,"ForceMask":null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffjtTarOptionsbase = iota
	ffjtTarOptionsnosuchkey

	ffjtTarOptionsIncludeFiles

	ffjtTarOptionsExcludePatterns

	ffjtTarOptionsCompression

	ffjtTarOptionsNoLchown

	ffjtTarOptionsUIDMaps

	ffjtTarOptionsGIDMaps

	ffjtTarOptionsIgnoreChownErrors

	ffjtTarOptionsChownOpts

	ffjtTarOptionsIncludeSourceDir

	ffjtTarOptionsWhiteoutFormat

	ffjtTarOptionsWhiteoutData

	ffjtTarOptionsNoOverwriteDirNonDir

	ffjtTarOptionsRebaseNames

	ffjtTarOptionsInUserNS

	ffjtTarOptionsCopyPass

	ffjtTarOptionsForceMask
)

var ffjKeyTarOptionsIncludeFiles = []byte("IncludeFiles")

var ffjKeyTarOptionsExcludePatterns = []byte("ExcludePatterns")

var ffjKeyTarOptionsCompression = []byte("Compression")

var ffjKeyTarOptionsNoLchown = []byte("NoLchown")

var ffjKeyTarOptionsUIDMaps = []byte("UIDMaps")

var ffjKeyTarOptionsGIDMaps = []byte("GIDMaps")

var ffjKeyTarOptionsIgnoreChownErrors = []byte("IgnoreChownErrors")

var ffjKeyTarOptionsChownOpts = []byte("ChownOpts")

var ffjKeyTarOptionsIncludeSourceDir = []byte("IncludeSourceDir")

var ffjKeyTarOptionsWhiteoutFormat = []byte("WhiteoutFormat")

var ffjKeyTarOptionsWhiteoutData = []byte("WhiteoutData")

var ffjKeyTarOptionsNoOverwriteDirNonDir = []byte("NoOverwriteDirNonDir")

var ffjKeyTarOptionsRebaseNames = []byte("RebaseNames")

var ffjKeyTarOptionsInUserNS = []byte("InUserNS")

var ffjKeyTarOptionsCopyPass = []byte("CopyPass")

var ffjKeyTarOptionsForceMask = []byte("ForceMask")

// UnmarshalJSON umarshall json - template of ffjson
func (j *TarOptions) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *TarOptions) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtTarOptionsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtTarOptionsnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'C':

					if bytes.Equal(ffjKeyTarOptionsCompression, kn) {
						currentKey = ffjtTarOptionsCompression
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyTarOptionsChownOpts, kn) {
						currentKey = ffjtTarOptionsChownOpts
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyTarOptionsCopyPass, kn) {
						currentKey = ffjtTarOptionsCopyPass
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'E':

					if bytes.Equal(ffjKeyTarOptionsExcludePatterns, kn) {
						currentKey = ffjtTarOptionsExcludePatterns
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'F':

					if bytes.Equal(ffjKeyTarOptionsForceMask, kn) {
						currentKey = ffjtTarOptionsForceMask
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'G':

					if bytes.Equal(ffjKeyTarOptionsGIDMaps, kn) {
						currentKey = ffjtTarOptionsGIDMaps
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'I':

					if bytes.Equal(ffjKeyTarOptionsIncludeFiles, kn) {
						currentKey = ffjtTarOptionsIncludeFiles
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyTarOptionsIgnoreChownErrors, kn) {
						currentKey = ffjtTarOptionsIgnoreChownErrors
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyTarOptionsIncludeSourceDir, kn) {
						currentKey = ffjtTarOptionsIncludeSourceDir
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyTarOptionsInUserNS, kn) {
						currentKey = ffjtTarOptionsInUserNS
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'N':

					if bytes.Equal(ffjKeyTarOptionsNoLchown, kn) {
						currentKey = ffjtTarOptionsNoLchown
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyTarOptionsNoOverwriteDirNonDir, kn) {
						currentKey = ffjtTarOptionsNoOverwriteDirNonDir
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'R':

					if bytes.Equal(ffjKeyTarOptionsRebaseNames, kn) {
						currentKey = ffjtTarOptionsRebaseNames
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'U':

					if bytes.Equal(ffjKeyTarOptionsUIDMaps, kn) {
						currentKey = ffjtTarOptionsUIDMaps
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'W':

					if bytes.Equal(ffjKeyTarOptionsWhiteoutFormat, kn) {
						currentKey = ffjtTarOptionsWhiteoutFormat
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyTarOptionsWhiteoutData, kn) {
						currentKey = ffjtTarOptionsWhiteoutData
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffjKeyTarOptionsForceMask, kn) {
					currentKey = ffjtTarOptionsForceMask
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyTarOptionsCopyPass, kn) {
					currentKey = ffjtTarOptionsCopyPass
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyTarOptionsInUserNS, kn) {
					currentKey = ffjtTarOptionsInUserNS
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyTarOptionsRebaseNames, kn) {
					currentKey = ffjtTarOptionsRebaseNames
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyTarOptionsNoOverwriteDirNonDir, kn) {
					currentKey = ffjtTarOptionsNoOverwriteDirNonDir
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyTarOptionsWhiteoutData, kn) {
					currentKey = ffjtTarOptionsWhiteoutData
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyTarOptionsWhiteoutFormat, kn) {
					currentKey = ffjtTarOptionsWhiteoutFormat
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyTarOptionsIncludeSourceDir, kn) {
					currentKey = ffjtTarOptionsIncludeSourceDir
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyTarOptionsChownOpts, kn) {
					currentKey = ffjtTarOptionsChownOpts
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyTarOptionsIgnoreChownErrors, kn) {
					currentKey = ffjtTarOptionsIgnoreChownErrors
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyTarOptionsGIDMaps, kn) {
					currentKey = ffjtTarOptionsGIDMaps
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyTarOptionsUIDMaps, kn) {
					currentKey = ffjtTarOptionsUIDMaps
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyTarOptionsNoLchown, kn) {
					currentKey = ffjtTarOptionsNoLchown
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyTarOptionsCompression, kn) {
					currentKey = ffjtTarOptionsCompression
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyTarOptionsExcludePatterns, kn) {
					currentKey = ffjtTarOptionsExcludePatterns
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyTarOptionsIncludeFiles, kn) {
					currentKey = ffjtTarOptionsIncludeFiles
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtTarOptionsnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtTarOptionsIncludeFiles:
					goto handle_IncludeFiles

				case ffjtTarOptionsExcludePatterns:
					goto handle_ExcludePatterns

				case ffjtTarOptionsCompression:
					goto handle_Compression

				case ffjtTarOptionsNoLchown:
					goto handle_NoLchown

				case ffjtTarOptionsUIDMaps:
					goto handle_UIDMaps

				case ffjtTarOptionsGIDMaps:
					goto handle_GIDMaps

				case ffjtTarOptionsIgnoreChownErrors:
					goto handle_IgnoreChownErrors

				case ffjtTarOptionsChownOpts:
					goto handle_ChownOpts

				case ffjtTarOptionsIncludeSourceDir:
					goto handle_IncludeSourceDir

				case ffjtTarOptionsWhiteoutFormat:
					goto handle_WhiteoutFormat

				case ffjtTarOptionsWhiteoutData:
					goto handle_WhiteoutData

				case ffjtTarOptionsNoOverwriteDirNonDir:
					goto handle_NoOverwriteDirNonDir

				case ffjtTarOptionsRebaseNames:
					goto handle_RebaseNames

				case ffjtTarOptionsInUserNS:
					goto handle_InUserNS

				case ffjtTarOptionsCopyPass:
					goto handle_CopyPass

				case ffjtTarOptionsForceMask:
					goto handle_ForceMask

				case ffjtTarOptionsnosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_IncludeFiles:

	/* handler: j.IncludeFiles type=[]string kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.IncludeFiles = nil
		} else {

			j.IncludeFiles = []string{}

			wantVal := true

			for {

				var tmpJIncludeFiles string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJIncludeFiles type=string kind=string quoted=false*/

				{

					{
						if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
							return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
						}
					}

					if tok == fflib.FFTok_null {

					} else {

						outBuf := fs.Output.Bytes()

						tmpJIncludeFiles = string(string(outBuf))

					}
				}

				j.IncludeFiles = append(j.IncludeFiles, tmpJIncludeFiles)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ExcludePatterns:

	/* handler: j.ExcludePatterns type=[]string kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.ExcludePatterns = nil
		} else {

			j.ExcludePatterns = []string{}

			wantVal := true

			for {

				var tmpJExcludePatterns string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJExcludePatterns type=string kind=string quoted=false*/

				{

					{
						if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
							return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
						}
					}

					if tok == fflib.FFTok_null {

					} else {

						outBuf := fs.Output.Bytes()

						tmpJExcludePatterns = string(string(outBuf))

					}
				}

				j.ExcludePatterns = append(j.ExcludePatterns, tmpJExcludePatterns)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Compression:

	/* handler: j.Compression type=archive.Compression kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for Compression", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.Compression = Compression(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_NoLchown:

	/* handler: j.NoLchown type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.NoLchown = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.NoLchown = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_UIDMaps:

	/* handler: j.UIDMaps type=[]idtools.IDMap kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.UIDMaps = nil
		} else {

			j.UIDMaps = []idtools.IDMap{}

			wantVal := true

			for {

				var tmpJUIDMaps idtools.IDMap

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJUIDMaps type=idtools.IDMap kind=struct quoted=false*/

				{
					/* Falling back. type=idtools.IDMap kind=struct */
					tbuf, err := fs.CaptureField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}

					err = json.Unmarshal(tbuf, &tmpJUIDMaps)
					if err != nil {
						return fs.WrapErr(err)
					}
				}

				j.UIDMaps = append(j.UIDMaps, tmpJUIDMaps)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_GIDMaps:

	/* handler: j.GIDMaps type=[]idtools.IDMap kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.GIDMaps = nil
		} else {

			j.GIDMaps = []idtools.IDMap{}

			wantVal := true

			for {

				var tmpJGIDMaps idtools.IDMap

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJGIDMaps type=idtools.IDMap kind=struct quoted=false*/

				{
					/* Falling back. type=idtools.IDMap kind=struct */
					tbuf, err := fs.CaptureField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}

					err = json.Unmarshal(tbuf, &tmpJGIDMaps)
					if err != nil {
						return fs.WrapErr(err)
					}
				}

				j.GIDMaps = append(j.GIDMaps, tmpJGIDMaps)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IgnoreChownErrors:

	/* handler: j.IgnoreChownErrors type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.IgnoreChownErrors = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.IgnoreChownErrors = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ChownOpts:

	/* handler: j.ChownOpts type=idtools.IDPair kind=struct quoted=false*/

	{
		/* Falling back. type=idtools.IDPair kind=struct */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.ChownOpts)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IncludeSourceDir:

	/* handler: j.IncludeSourceDir type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.IncludeSourceDir = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.IncludeSourceDir = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_WhiteoutFormat:

	/* handler: j.WhiteoutFormat type=archive.WhiteoutFormat kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for WhiteoutFormat", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.WhiteoutFormat = WhiteoutFormat(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_WhiteoutData:

	/* handler: j.WhiteoutData type=interface {} kind=interface quoted=false*/

	{
		/* Falling back. type=interface {} kind=interface */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.WhiteoutData)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_NoOverwriteDirNonDir:

	/* handler: j.NoOverwriteDirNonDir type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.NoOverwriteDirNonDir = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.NoOverwriteDirNonDir = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_RebaseNames:

	/* handler: j.RebaseNames type=map[string]string kind=map quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_bracket && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.RebaseNames = nil
		} else {

			j.RebaseNames = make(map[string]string, 0)

			wantVal := true

			for {

				var k string

				var tmpJRebaseNames string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_bracket {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: k type=string kind=string quoted=false*/

				{

					{
						if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
							return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
						}
					}

					if tok == fflib.FFTok_null {

					} else {

						outBuf := fs.Output.Bytes()

						k = string(string(outBuf))

					}
				}

				// Expect ':' after key
				tok = fs.Scan()
				if tok != fflib.FFTok_colon {
					return fs.WrapErr(fmt.Errorf("wanted colon token, but got token: %v", tok))
				}

				tok = fs.Scan()
				/* handler: tmpJRebaseNames type=string kind=string quoted=false*/

				{

					{
						if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
							return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
						}
					}

					if tok == fflib.FFTok_null {

					} else {

						outBuf := fs.Output.Bytes()

						tmpJRebaseNames = string(string(outBuf))

					}
				}

				j.RebaseNames[k] = tmpJRebaseNames

				wantVal = false
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InUserNS:

	/* handler: j.InUserNS type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.InUserNS = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.InUserNS = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CopyPass:

	/* handler: j.CopyPass type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.CopyPass = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.CopyPass = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ForceMask:

	/* handler: j.ForceMask type=os.FileMode kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for FileMode", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			j.ForceMask = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := os.FileMode(tval)
			j.ForceMask = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *TempArchive) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *TempArchive) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"Size":`)
	fflib.FormatBits2(buf, uint64(j.Size), 10, j.Size < 0)
	buf.WriteByte('}')
	return nil
}

const (
	ffjtTempArchivebase = iota
	ffjtTempArchivenosuchkey

	ffjtTempArchiveSize
)

var ffjKeyTempArchiveSize = []byte("Size")

// UnmarshalJSON umarshall json - template of ffjson
func (j *TempArchive) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *TempArchive) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtTempArchivebase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtTempArchivenosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'S':

					if bytes.Equal(ffjKeyTempArchiveSize, kn) {
						currentKey = ffjtTempArchiveSize
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffjKeyTempArchiveSize, kn) {
					currentKey = ffjtTempArchiveSize
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtTempArchivenosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtTempArchiveSize:
					goto handle_Size

				case ffjtTempArchivenosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Size:

	/* handler: j.Size type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.Size = int64(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *tarAppender) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *tarAppender) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	if j.TarWriter != nil {
		/* Struct fall back. type=tar.Writer kind=struct */
		buf.WriteString(`{"TarWriter":`)
		err = buf.Encode(j.TarWriter)
		if err != nil {
			return err
		}
	} else {
		buf.WriteString(`{"TarWriter":null`)
	}
	if j.Buffer != nil {
		/* Struct fall back. type=bufio.Writer kind=struct */
		buf.WriteString(`,"Buffer":`)
		err = buf.Encode(j.Buffer)
		if err != nil {
			return err
		}
	} else {
		buf.WriteString(`,"Buffer":null`)
	}
	/* Falling back. type=map[uint64]string kind=map */
	buf.WriteString(`,"SeenFiles":`)
	err = buf.Encode(j.SeenFiles)
	if err != nil {
		return err
	}
	if j.IDMappings != nil {
		/* Struct fall back. type=idtools.IDMappings kind=struct */
		buf.WriteString(`,"IDMappings":`)
		err = buf.Encode(j.IDMappings)
		if err != nil {
			return err
		}
	} else {
		buf.WriteString(`,"IDMappings":null`)
	}
	if j.ChownOpts != nil {
		/* Struct fall back. type=idtools.IDPair kind=struct */
		buf.WriteString(`,"ChownOpts":`)
		err = buf.Encode(j.ChownOpts)
		if err != nil {
			return err
		}
	} else {
		buf.WriteString(`,"ChownOpts":null`)
	}
	buf.WriteString(`,"WhiteoutConverter":`)
	/* Interface types must use runtime reflection. type=archive.tarWhiteoutConverter kind=interface */
	err = buf.Encode(j.WhiteoutConverter)
	if err != nil {
		return err
	}
	if j.CopyPass {
		buf.WriteString(`,"CopyPass":true`)
	} else {
		buf.WriteString(`,"CopyPass":false`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffjttarAppenderbase = iota
	ffjttarAppendernosuchkey

	ffjttarAppenderTarWriter

	ffjttarAppenderBuffer

	ffjttarAppenderSeenFiles

	ffjttarAppenderIDMappings

	ffjttarAppenderChownOpts

	ffjttarAppenderWhiteoutConverter

	ffjttarAppenderCopyPass
)

var ffjKeytarAppenderTarWriter = []byte("TarWriter")

var ffjKeytarAppenderBuffer = []byte("Buffer")

var ffjKeytarAppenderSeenFiles = []byte("SeenFiles")

var ffjKeytarAppenderIDMappings = []byte("IDMappings")

var ffjKeytarAppenderChownOpts = []byte("ChownOpts")

var ffjKeytarAppenderWhiteoutConverter = []byte("WhiteoutConverter")

var ffjKeytarAppenderCopyPass = []byte("CopyPass")

// UnmarshalJSON umarshall json - template of ffjson
func (j *tarAppender) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *tarAppender) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjttarAppenderbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjttarAppendernosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'B':

					if bytes.Equal(ffjKeytarAppenderBuffer, kn) {
						currentKey = ffjttarAppenderBuffer
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'C':

					if bytes.Equal(ffjKeytarAppenderChownOpts, kn) {
						currentKey = ffjttarAppenderChownOpts
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeytarAppenderCopyPass, kn) {
						currentKey = ffjttarAppenderCopyPass
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'I':

					if bytes.Equal(ffjKeytarAppenderIDMappings, kn) {
						currentKey = ffjttarAppenderIDMappings
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'S':

					if bytes.Equal(ffjKeytarAppenderSeenFiles, kn) {
						currentKey = ffjttarAppenderSeenFiles
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'T':

					if bytes.Equal(ffjKeytarAppenderTarWriter, kn) {
						currentKey = ffjttarAppenderTarWriter
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'W':

					if bytes.Equal(ffjKeytarAppenderWhiteoutConverter, kn) {
						currentKey = ffjttarAppenderWhiteoutConverter
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffjKeytarAppenderCopyPass, kn) {
					currentKey = ffjttarAppenderCopyPass
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeytarAppenderWhiteoutConverter, kn) {
					currentKey = ffjttarAppenderWhiteoutConverter
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeytarAppenderChownOpts, kn) {
					currentKey = ffjttarAppenderChownOpts
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeytarAppenderIDMappings, kn) {
					currentKey = ffjttarAppenderIDMappings
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeytarAppenderSeenFiles, kn) {
					currentKey = ffjttarAppenderSeenFiles
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeytarAppenderBuffer, kn) {
					currentKey = ffjttarAppenderBuffer
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeytarAppenderTarWriter, kn) {
					currentKey = ffjttarAppenderTarWriter
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjttarAppendernosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjttarAppenderTarWriter:
					goto handle_TarWriter

				case ffjttarAppenderBuffer:
					goto handle_Buffer

				case ffjttarAppenderSeenFiles:
					goto handle_SeenFiles

				case ffjttarAppenderIDMappings:
					goto handle_IDMappings

				case ffjttarAppenderChownOpts:
					goto handle_ChownOpts

				case ffjttarAppenderWhiteoutConverter:
					goto handle_WhiteoutConverter

				case ffjttarAppenderCopyPass:
					goto handle_CopyPass

				case ffjttarAppendernosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_TarWriter:

	/* handler: j.TarWriter type=tar.Writer kind=struct quoted=false*/

	{
		/* Falling back. type=tar.Writer kind=struct */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.TarWriter)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Buffer:

	/* handler: j.Buffer type=bufio.Writer kind=struct quoted=false*/

	{
		/* Falling back. type=bufio.Writer kind=struct */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.Buffer)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_SeenFiles:

	/* handler: j.SeenFiles type=map[uint64]string kind=map quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_bracket && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.SeenFiles = nil
		} else {

			j.SeenFiles = make(map[uint64]string, 0)

			wantVal := true

			for {

				var k uint64

				var tmpJSeenFiles string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_bracket {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: k type=uint64 kind=uint64 quoted=false*/

				{
					if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
						return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
					}
				}

				{

					if tok == fflib.FFTok_null {

					} else {

						tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

						if err != nil {
							return fs.WrapErr(err)
						}

						k = uint64(tval)

					}
				}

				// Expect ':' after key
				tok = fs.Scan()
				if tok != fflib.FFTok_colon {
					return fs.WrapErr(fmt.Errorf("wanted colon token, but got token: %v", tok))
				}

				tok = fs.Scan()
				/* handler: tmpJSeenFiles type=string kind=string quoted=false*/

				{

					{
						if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
							return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
						}
					}

					if tok == fflib.FFTok_null {

					} else {

						outBuf := fs.Output.Bytes()

						tmpJSeenFiles = string(string(outBuf))

					}
				}

				j.SeenFiles[k] = tmpJSeenFiles

				wantVal = false
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IDMappings:

	/* handler: j.IDMappings type=idtools.IDMappings kind=struct quoted=false*/

	{
		/* Falling back. type=idtools.IDMappings kind=struct */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.IDMappings)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ChownOpts:

	/* handler: j.ChownOpts type=idtools.IDPair kind=struct quoted=false*/

	{
		/* Falling back. type=idtools.IDPair kind=struct */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.ChownOpts)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_WhiteoutConverter:

	/* handler: j.WhiteoutConverter type=archive.tarWhiteoutConverter kind=interface quoted=false*/

	{
		/* Falling back. type=archive.tarWhiteoutConverter kind=interface */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.WhiteoutConverter)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CopyPass:

	/* handler: j.CopyPass type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.CopyPass = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.CopyPass = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}
