// Code generated by protoc-gen-go. DO NOT EDIT.
// source: github.com/lightstep/lightstep-tracer-common/tmpgen/metrics.proto

/*
Package metricspb is a generated protocol buffer package.

It is generated from these files:
	github.com/lightstep/lightstep-tracer-common/tmpgen/metrics.proto

It has these top-level messages:
	MetricPoint
	IngestRequest
	IngestResponse
*/
package metricspb // import "github.com/lightstep/lightstep-tracer-common/golang/protobuf/metricspb"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import lightstep_collector "github.com/lightstep/lightstep-tracer-common/golang/protobuf/collectorpb"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf2 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// MetricKind indicates the semantics of the points (i.e. how to interpret values
// relative to each other).
type MetricKind int32

const (
	// InvalidMetricKind is the default value for the MetricKind. Some languages' proto compilers
	// (e.g. Go) return the default if no value is set. The default is marked invalid here to
	// avoid a common mistake where a field is left unset and appears to be set to the default.
	MetricKind_INVALID_METRIC_KIND MetricKind = 0
	// Counter metrics measure change over an interval.
	// When aggregated, counter metrics are usually added.
	MetricKind_COUNTER MetricKind = 1
	// Gauge metrics measure the value at a point in time.
	// When aggregated, intermediate values are often dropped for the latest value.
	MetricKind_GAUGE MetricKind = 2
)

var MetricKind_name = map[int32]string{
	0: "INVALID_METRIC_KIND",
	1: "COUNTER",
	2: "GAUGE",
}
var MetricKind_value = map[string]int32{
	"INVALID_METRIC_KIND": 0,
	"COUNTER":             1,
	"GAUGE":               2,
}

func (x MetricKind) String() string {
	return proto.EnumName(MetricKind_name, int32(x))
}
func (MetricKind) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// MetricPoint is an update to a single measure.
type MetricPoint struct {
	// Kind indicates the semantics of this point. Kind should always be the same for a given metric
	// name (e.g. "cpu.usage" should always have the same kind)
	Kind MetricKind `protobuf:"varint,1,opt,name=kind,enum=lightstep.metrics.MetricKind" json:"kind,omitempty"`
	// MetricName indicates the metric being emitted.
	MetricName string `protobuf:"bytes,2,opt,name=metric_name,json=metricName" json:"metric_name,omitempty"`
	// Start of the interval for which the points represent.
	// - All Counter points will be assumed to represent the entire interval.
	// - All Gauge points will be assumed to be instantaneous at the start of the interval.
	Start *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=start" json:"start,omitempty"`
	// Duration of the interval for which the points represent. The end of the interval is start + duration.
	// We expect this value to be unset or zero for Gauge points.
	Duration *google_protobuf2.Duration `protobuf:"bytes,4,opt,name=duration" json:"duration,omitempty"`
	// Labels contain labels specific to this point.
	Labels []*lightstep_collector.KeyValue `protobuf:"bytes,5,rep,name=labels" json:"labels,omitempty"`
	// Value represents the update being emitted. Values can be one of two types: uint64 or double.
	// The type of the value should always be the same for a given metric name (e.g. "cpu.usage"
	// should always have value type double).
	//
	// Types that are valid to be assigned to Value:
	//	*MetricPoint_Uint64Value
	//	*MetricPoint_DoubleValue
	Value isMetricPoint_Value `protobuf_oneof:"value"`
}

func (m *MetricPoint) Reset()                    { *m = MetricPoint{} }
func (m *MetricPoint) String() string            { return proto.CompactTextString(m) }
func (*MetricPoint) ProtoMessage()               {}
func (*MetricPoint) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type isMetricPoint_Value interface {
	isMetricPoint_Value()
}

type MetricPoint_Uint64Value struct {
	Uint64Value uint64 `protobuf:"varint,6,opt,name=uint64_value,json=uint64Value,oneof"`
}
type MetricPoint_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,7,opt,name=double_value,json=doubleValue,oneof"`
}

func (*MetricPoint_Uint64Value) isMetricPoint_Value() {}
func (*MetricPoint_DoubleValue) isMetricPoint_Value() {}

func (m *MetricPoint) GetValue() isMetricPoint_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *MetricPoint) GetKind() MetricKind {
	if m != nil {
		return m.Kind
	}
	return MetricKind_INVALID_METRIC_KIND
}

func (m *MetricPoint) GetMetricName() string {
	if m != nil {
		return m.MetricName
	}
	return ""
}

func (m *MetricPoint) GetStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.Start
	}
	return nil
}

func (m *MetricPoint) GetDuration() *google_protobuf2.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *MetricPoint) GetLabels() []*lightstep_collector.KeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *MetricPoint) GetUint64Value() uint64 {
	if x, ok := m.GetValue().(*MetricPoint_Uint64Value); ok {
		return x.Uint64Value
	}
	return 0
}

func (m *MetricPoint) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*MetricPoint_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MetricPoint) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MetricPoint_OneofMarshaler, _MetricPoint_OneofUnmarshaler, _MetricPoint_OneofSizer, []interface{}{
		(*MetricPoint_Uint64Value)(nil),
		(*MetricPoint_DoubleValue)(nil),
	}
}

func _MetricPoint_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MetricPoint)
	// value
	switch x := m.Value.(type) {
	case *MetricPoint_Uint64Value:
		b.EncodeVarint(6<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Uint64Value))
	case *MetricPoint_DoubleValue:
		b.EncodeVarint(7<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case nil:
	default:
		return fmt.Errorf("MetricPoint.Value has unexpected type %T", x)
	}
	return nil
}

func _MetricPoint_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MetricPoint)
	switch tag {
	case 6: // value.uint64_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &MetricPoint_Uint64Value{x}
		return true, err
	case 7: // value.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &MetricPoint_DoubleValue{math.Float64frombits(x)}
		return true, err
	default:
		return false, nil
	}
}

func _MetricPoint_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MetricPoint)
	// value
	switch x := m.Value.(type) {
	case *MetricPoint_Uint64Value:
		n += proto.SizeVarint(6<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.Uint64Value))
	case *MetricPoint_DoubleValue:
		n += proto.SizeVarint(7<<3 | proto.WireFixed64)
		n += 8
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// IngestRequest is an update to one or more measures.
type IngestRequest struct {
	// IdempotencyKey is a random string that should uniquely identify this report.
	// It should be generated once and used for all retries. The server will use it
	// to de-duplicate requests.
	IdempotencyKey string `protobuf:"bytes,1,opt,name=idempotency_key,json=idempotencyKey" json:"idempotency_key,omitempty"`
	// Reporter contains information to identify the specific originator of this report.
	Reporter *lightstep_collector.Reporter `protobuf:"bytes,2,opt,name=reporter" json:"reporter,omitempty"`
	// Points contain the individual updates.
	Points []*MetricPoint `protobuf:"bytes,3,rep,name=points" json:"points,omitempty"`
}

func (m *IngestRequest) Reset()                    { *m = IngestRequest{} }
func (m *IngestRequest) String() string            { return proto.CompactTextString(m) }
func (*IngestRequest) ProtoMessage()               {}
func (*IngestRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *IngestRequest) GetIdempotencyKey() string {
	if m != nil {
		return m.IdempotencyKey
	}
	return ""
}

func (m *IngestRequest) GetReporter() *lightstep_collector.Reporter {
	if m != nil {
		return m.Reporter
	}
	return nil
}

func (m *IngestRequest) GetPoints() []*MetricPoint {
	if m != nil {
		return m.Points
	}
	return nil
}

// IngestResponse is reserved for future use.
type IngestResponse struct {
}

func (m *IngestResponse) Reset()                    { *m = IngestResponse{} }
func (m *IngestResponse) String() string            { return proto.CompactTextString(m) }
func (*IngestResponse) ProtoMessage()               {}
func (*IngestResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func init() {
	proto.RegisterType((*MetricPoint)(nil), "lightstep.metrics.MetricPoint")
	proto.RegisterType((*IngestRequest)(nil), "lightstep.metrics.IngestRequest")
	proto.RegisterType((*IngestResponse)(nil), "lightstep.metrics.IngestResponse")
	proto.RegisterEnum("lightstep.metrics.MetricKind", MetricKind_name, MetricKind_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for MetricsService service

type MetricsServiceClient interface {
	Report(ctx context.Context, in *IngestRequest, opts ...grpc.CallOption) (*IngestResponse, error)
}

type metricsServiceClient struct {
	cc *grpc.ClientConn
}

func NewMetricsServiceClient(cc *grpc.ClientConn) MetricsServiceClient {
	return &metricsServiceClient{cc}
}

func (c *metricsServiceClient) Report(ctx context.Context, in *IngestRequest, opts ...grpc.CallOption) (*IngestResponse, error) {
	out := new(IngestResponse)
	err := grpc.Invoke(ctx, "/lightstep.metrics.MetricsService/Report", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for MetricsService service

type MetricsServiceServer interface {
	Report(context.Context, *IngestRequest) (*IngestResponse, error)
}

func RegisterMetricsServiceServer(s *grpc.Server, srv MetricsServiceServer) {
	s.RegisterService(&_MetricsService_serviceDesc, srv)
}

func _MetricsService_Report_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IngestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceServer).Report(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lightstep.metrics.MetricsService/Report",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceServer).Report(ctx, req.(*IngestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MetricsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "lightstep.metrics.MetricsService",
	HandlerType: (*MetricsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Report",
			Handler:    _MetricsService_Report_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "github.com/lightstep/lightstep-tracer-common/tmpgen/metrics.proto",
}

func init() {
	proto.RegisterFile("github.com/lightstep/lightstep-tracer-common/tmpgen/metrics.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 579 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x93, 0xdf, 0x6e, 0xd3, 0x30,
	0x14, 0xc6, 0x97, 0xae, 0xed, 0x56, 0x97, 0x95, 0xe2, 0x5d, 0x90, 0x55, 0xb0, 0x85, 0x72, 0x41,
	0x34, 0x69, 0x09, 0x0c, 0x36, 0x09, 0x24, 0x2e, 0xf6, 0x4f, 0xa3, 0xea, 0x56, 0x26, 0xaf, 0x9b,
	0x10, 0x37, 0x55, 0x92, 0x1e, 0x32, 0x6b, 0x89, 0x6d, 0x1c, 0x67, 0x52, 0x6f, 0x79, 0x05, 0xde,
	0x80, 0x5b, 0x1e, 0x07, 0x1e, 0x81, 0x07, 0x41, 0xb5, 0xd3, 0x76, 0x63, 0x0c, 0x89, 0x3b, 0xeb,
	0x7c, 0xbf, 0xe3, 0x7c, 0xdf, 0x39, 0x31, 0xda, 0x89, 0xa9, 0xba, 0xc8, 0x43, 0x2f, 0xe2, 0xa9,
	0x9f, 0xd0, 0xf8, 0x42, 0x65, 0x0a, 0xc4, 0xec, 0xb4, 0xa1, 0x64, 0x10, 0x81, 0xdc, 0x88, 0x78,
	0x9a, 0x72, 0xe6, 0xab, 0x54, 0xc4, 0xc0, 0xfc, 0x14, 0x94, 0xa4, 0x51, 0xe6, 0x09, 0xc9, 0x15,
	0xc7, 0x0f, 0xa6, 0xb4, 0x57, 0x08, 0xad, 0x0f, 0xff, 0x75, 0x6b, 0xcc, 0x93, 0x80, 0xc5, 0xbe,
	0xbe, 0x2d, 0xcc, 0x3f, 0xf9, 0x11, 0x4f, 0x12, 0x88, 0x14, 0x97, 0x22, 0x9c, 0x9d, 0xcd, 0xc7,
	0x5a, 0x8f, 0x62, 0xce, 0xe3, 0x04, 0xfc, 0x40, 0x50, 0x3f, 0x60, 0x8c, 0xab, 0x40, 0x51, 0xce,
	0x0a, 0x2b, 0xad, 0xd5, 0x42, 0x9d, 0x5e, 0x35, 0xcc, 0xa5, 0x06, 0x0a, 0x7d, 0xed, 0x4f, 0x5d,
	0xd1, 0x14, 0x32, 0x15, 0xa4, 0xc2, 0x00, 0xed, 0x9f, 0x25, 0x54, 0x3f, 0xd6, 0x21, 0x4e, 0x38,
	0x65, 0x0a, 0xbf, 0x40, 0xe5, 0x4b, 0xca, 0x86, 0xb6, 0xe5, 0x58, 0x6e, 0x63, 0xf3, 0xb1, 0x77,
	0x2b, 0xaa, 0x67, 0xe8, 0x2e, 0x65, 0x43, 0xa2, 0x51, 0xbc, 0x86, 0xea, 0x46, 0x1b, 0xb0, 0x20,
	0x05, 0xbb, 0xe4, 0x58, 0x6e, 0x8d, 0x20, 0x53, 0xea, 0x05, 0x29, 0xe0, 0xe7, 0xa8, 0x92, 0xa9,
	0x40, 0x2a, 0x7b, 0xde, 0xb1, 0xdc, 0xfa, 0x66, 0xcb, 0x33, 0xa6, 0xbc, 0x89, 0x29, 0xaf, 0x3f,
	0x31, 0x45, 0x0c, 0x88, 0xb7, 0xd0, 0xe2, 0x24, 0x88, 0x5d, 0xd6, 0x4d, 0x2b, 0xb7, 0x9a, 0xf6,
	0x0b, 0x80, 0x4c, 0x51, 0xbc, 0x85, 0xaa, 0x49, 0x10, 0x42, 0x92, 0xd9, 0x15, 0x67, 0xde, 0xad,
	0xdf, 0xb0, 0x3f, 0x9b, 0x6b, 0x17, 0x46, 0xe7, 0x41, 0x92, 0x03, 0x29, 0x60, 0xfc, 0x14, 0xdd,
	0xcb, 0x29, 0x53, 0xdb, 0xaf, 0x06, 0x57, 0xe3, 0xba, 0x5d, 0x75, 0x2c, 0xb7, 0xfc, 0x6e, 0x8e,
	0xd4, 0x4d, 0x55, 0xc3, 0x63, 0x68, 0xc8, 0xf3, 0x30, 0x81, 0x02, 0x5a, 0x70, 0x2c, 0xd7, 0x1a,
	0x43, 0xa6, 0xaa, 0xa1, 0xdd, 0x05, 0x54, 0xd1, 0x6a, 0xfb, 0xbb, 0x85, 0x96, 0x3a, 0x2c, 0x86,
	0x4c, 0x11, 0xf8, 0x9c, 0x43, 0xa6, 0xf0, 0x33, 0x74, 0x9f, 0x0e, 0x21, 0x15, 0x5c, 0x01, 0x8b,
	0x46, 0x83, 0x4b, 0x18, 0xe9, 0x19, 0xd7, 0x48, 0xe3, 0x5a, 0xb9, 0x0b, 0x23, 0xfc, 0x1a, 0x2d,
	0x4a, 0x10, 0x5c, 0x2a, 0x90, 0x7a, 0x96, 0x77, 0xc5, 0x20, 0x05, 0x44, 0xa6, 0x38, 0xde, 0x46,
	0x55, 0x31, 0xde, 0x62, 0x66, 0xcf, 0xeb, 0xfc, 0xab, 0x77, 0xae, 0x4f, 0x2f, 0x9b, 0x14, 0x74,
	0xbb, 0x89, 0x1a, 0x13, 0xb3, 0x99, 0xe0, 0x2c, 0x83, 0xf5, 0xb7, 0x08, 0xcd, 0xf6, 0x8c, 0x1f,
	0xa2, 0xe5, 0x4e, 0xef, 0x7c, 0xe7, 0xa8, 0xb3, 0x3f, 0x38, 0x3e, 0xe8, 0x93, 0xce, 0xde, 0xa0,
	0xdb, 0xe9, 0xed, 0x37, 0xe7, 0x70, 0x1d, 0x2d, 0xec, 0xbd, 0x3f, 0xeb, 0xf5, 0x0f, 0x48, 0xd3,
	0xc2, 0x35, 0x54, 0x39, 0xdc, 0x39, 0x3b, 0x3c, 0x68, 0x96, 0x36, 0x15, 0x6a, 0x98, 0xf6, 0xec,
	0x14, 0xe4, 0x15, 0x8d, 0x00, 0x87, 0xa8, 0x6a, 0x0c, 0x63, 0xe7, 0x2f, 0xa6, 0x6e, 0x8c, 0xaa,
	0xf5, 0xe4, 0x1f, 0x84, 0xf1, 0xd7, 0x5e, 0xfe, 0xf2, 0xe3, 0xd7, 0xd7, 0xd2, 0x52, 0x7b, 0x71,
	0xf2, 0x34, 0xdf, 0x58, 0xeb, 0xbb, 0x3e, 0x5a, 0x89, 0x78, 0x7a, 0xad, 0xd9, 0xbc, 0x3a, 0x2f,
	0x96, 0x22, 0x3a, 0xb1, 0x3e, 0xd6, 0x0a, 0x54, 0x84, 0xdf, 0x4a, 0xe5, 0xa3, 0xd3, 0x93, 0xdd,
	0xb0, 0xaa, 0x7f, 0xa6, 0x97, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0x81, 0x01, 0xe0, 0xd6, 0x14,
	0x04, 0x00, 0x00,
}
