+++
title = "htmx lore"
description = """\
  Carson Gross explores the fascinating lore of htmx, from its playful community memes like &quot;It's So Over/We're \
  So Back&quot; and &quot;Laser Eye Horse&quot; to humorous controversies such as the &quot;Microsoft Purchase \
  Rumor&quot; and the htmx/intercooler.js feud. This essay dives into the vibrant culture, iconic moments, and \
  lighthearted chaos surrounding htmx."""
date = 2024-12-17
updated = 2024-12-17
authors = ["Carson Gross"]
[taxonomies]
tag = ["posts"]
+++

<center style="padding: 12px">
<img src="/img/i-lied.png" alt="I lied, I don't have a Twitter account. Take off your shoes, we're going to learn about hypermedia." style="border-radius: 32px; max-width: 100%">
</center>

For better or [for worse](https://x.com/IroncladDev/status/1866185587616596356), htmx has collected a lot of lore, mainly around [the twitter account](https://twitter.com/htmx_org).

Here are some explanations.

## It's So Over/We're So Back

A common set of phrases used by htmx enthusiasts when, for example, [@bunjavascript told me to delete my account](https://x.com/bunjavascript/status/1708557665268568412)

## htmx CEO

At one point there was a hostile takeover attempt of the htmx CEO position and, in a desperate poison pill, I declared
everyone CEO of htmx.  

[Turk](https://x.com/gitpush_gitpaid) created <https://htmx.ceo> if you want to register as a CEO.

If someone emails hr@bigsky.software asking if you are CEO of htmx, I will tell them yes.

You can put it on your LinkedIn, because it's true.

## Laser Eye Horse 

At some point I photoshopped lasers onto a horse mask, as kind of an homage to [@horse_js](https://x.com/horse_js).

For some reason it stuck and now it's the [official unofficial](https://swag.htmx.org/products/i-lied-sticker) mascot of htmx.

## Spieltrieb

Spieltrieb means "play instinct", and is a big part of the [htmx vibe](https://x.com/search?q=spieltrieb%20from%3Ahtmx_org&src=typed_query).

## Pickles

At some point someone (I think [@techsavvytravvy](https://x.com/techsavvytravvy)), generated [a grug AI image](https://x.com/htmx_org/status/1708697536587047142), and there
was a pickle smiling in a really bizarre way in it.  

So we started riffing on pickles and now [there's a shirt](https://swag.htmx.org/products/htmx-pickle-shirt).

Cry more, [drizzle](https://x.com/DrizzleORM/status/1757149983713665238).

## XSS

In July 2023, when htmx first got popular, there was a
[moral panic](https://x.com/htmx_org/status/1683607693246775297) around
[cross site scripting](https://x.com/htmx_org/status/1683529221195571200).  I
[may](https://x.com/htmx_org/status/1683607217499414531) have
[overcooked](https://x.com/htmx_org/status/1683649190071791617) my
[response](https://x.com/htmx_org/status/1683612179512057856) to
[it](https://x.com/htmx_org/status/1683818711763877892).

## Shut Up Warren

[@WarrenInTheBuff](https://x.com/WarrenInTheBuff) is the king of twitter and we regularly fight with him.  This often
ends in someone saying ["shut up warren"](https://x.com/ThePrimeagen/status/1792564215749779515).

You can see the htmx website do this by going to <https://htmx.org?suw=true>

## Microsoft Purchase Rumor

In mid-January of 2024 I got really serious with the htmx twitter account and started [quote](https://x.com/htmx_org/status/1745930477825868044) 
tweeting [things](https://x.com/htmx_org/status/1745915394626351315)
[about microsoft](https://x.com/htmx_org).  People started [worrying](https://x.com/SusSoftware/status/1746206195461878113).  I announced a [license change](https://x.com/htmx_org/status/1746736273728094323)
to get people freaked out about a rug pull.

[I then changed htmx to BSD0](https://x.com/htmx_org/status/1746880860723544211)

[This is the offer](https://x.com/htmx_org/status/1746895016256328079) I got from microsoft (real).

## (same thing)

I believe that [this tweet](https://x.com/htmx_org/status/1672264927136952322) is the origin of the (same thing) meme

## Stronger Together

In December 2023, I was trying to get some indonesian twitter users to take a look at htmx, so I created a 
["Montana & Indonesia, Stronger Together!"](https://x.com/htmx_org/status/1734371865156563428) tweet w/an AI image.

This turned into a [whole series of tweets](https://x.com/search?q=%22stronger%20together%22%20from%3A%40htmx_org&src=typed_query&f=live).

## Hinges

Sometimes I am accused of being "unhinged" but, in fact, [I own many hinges](https://x.com/search?q=from%3Ahtmx_org%20hinges&src=typed_query).

## \* library

People often [call htmx a framework](@/essays/is-htmx-another-javascript-framework.md), but it's [a library](https://x.com/htmx_org/status/1848751101035827210)

## "man"

A common [one word response](https://x.com/search?q=%22man%22%20from%3Ahtmx_org&src=typed_query&f=live) when I don't feel like
arguing with someone.

## The Le Marquee d'&lt;something>

In December 2024, I [added a marquee tag](https://github.com/bigskysoftware/htmx/commit/2b88d967c19619281228d1bf5398751615bdf462) to 
the htmx website and started using the honorific (sic) in my twitter title.

## htmx sucks

I wrote an essay called [htmx sucks](@/essays/htmx-sucks.md) in which I criticize htmx (some valid, some tongue in 
cheek, most both.)  I also released [a mug](https://swag.htmx.org/products/htmx-sucks-mug) that I will often link to when people are criticizing htmx.

## Jason Knight

Jason Knight [hates htmx](https://x.com/JasonKn99664124/status/1731555036864381251) and wrote a
[great post](https://archive.is/rQrl7) about it.

Please don't harass him, [I draw energy](https://x.com/htmx_org/status/1756476449693872635) from his posts.

## Drop Downs

In July 2023, sparked by the accusation that htmx users could not create dropdowns, I did a deep-dive into web
drop down technology and [uncovered a bombshell](https://x.com/htmx_org/status/1684936514885869568)

## "htmx is a front end library of peace"

A phrase I will often [quote tweet](https://x.com/search?q=htmx%20is%20a%20front%20end%20library%20of%20peace%20from%3A%40htmx_org&src=typed_query&f=live)
violent htmx-related imagery with.

## The Process &trade;

[The Process&trade;](https://x.com/htmx_org/status/1697651918858764375) is the mechanism by which people initially hostile
to htmx come to be enlightened.

## "that's ridiculous"

In [June 2023](https://x.com/htmx_org/status/1807183339222405317), [@srasash](https://twitter.com/srasash) accused
htmx of being a government op, the first in many such increasingly ridiculous claims.  I typically quote-tweet these
claims and point out that ["that's ridiculous"](https://x.com/search?q=%22that%27s%20ridiculous%22%20from%3A%40htmx_org&src=typed_query&f=live)

## Grug

I created <http://grugbrain.dev>.

## The htmx/intercooler.js feud

The htmx & [intercooler.js](https://x.com/intercoolerjs) twitter accounts often fight with one another.  Sometimes its
just me [switching back and forth](https://x.com/intercoolerjs/status/1859652045399355559), but two other people have 
access to the intercooler account, so sometimes I have no idea who I am fighting with.

## If Nothing Magically Works

Nothing [magically breaks](https://x.com/htmx_org/status/1729870461864226829).

## /r/webdev

I was very unfairly given [a lifetime ban](https://x.com/htmx_org/status/1719687461385691283) from 
[/r/webdev/](https://www.reddit.com/r/webdev/) for an
[obviously satirical post](https://old.reddit.com/r/webdev/comments/17i0loi/anyone_heard_of_htmx/).  Even the term "htmx" is banned (or semi-banned) on that sub, so people now use
the [htmeggs](https://swag.htmx.org/products/htmeggs-shirt) instead.

## "looking into this"

[idk](https://x.com/search?q=%22idk%22%20from%3Ahtmx_org&src=typed_query&f=live), I just think [it's funny](https://x.com/search?q=%22looking%20into%20this%22%20from%3Ahtmx_org&src=typed_query)

## "Look at this nerd ragin'"

A common phrase used to [mock people (including ourselves)](https://x.com/search?q=%22Look%20at%20this%20nerd%20ragin%27%22%20from%3Ahtmx_org&src=typed_query) with.

## Joker/Bane/Skeletor/Thanos, etc.

htmx is a [villain](https://x.com/htmx_org/status/1651698199478796292) in the front-end world, I'm good w/that
