/* Default version of diskfs_get_source

   Copyright (C) 2013 Free Software Foundation, Inc.

   Written by Justus Winter <4winter@informatik.uni-hamburg.de>

   This file is part of the GNU Hurd.

   The GNU Hurd is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   The GNU Hurd is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the GNU Hurd.  If not, see <http://www.gnu.org/licenses/>.  */

#include "priv.h"

error_t __attribute__ ((weak))
diskfs_get_source (char *source, size_t source_len)
{
  if (diskfs_disk_name == NULL)
    return EOPNOTSUPP;

  strncpy (source, diskfs_disk_name, source_len - 1);
  source[source_len - 1] = '\0';
  return 0;
}
