#!/usr/bin/env python

"""
Test qualifiers for recurring events.

Copyright (C) 2014, 2015 Paul Boddie <paul@boddie.org.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from vRecurrence import *

def show(l):
    for x in l:
        print x
    print

qualifiers = [
    ("YEARLY", {"interval" : 1})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 11, 2)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (2003, 12, 24))
print len(l) == 7, 7, len(l)
print l[0] == (1997, 11, 2), (1997, 11, 2), l[0]
print l[-1] == (2003, 11, 2), (2003, 11, 2), l[-1]
print

qualifiers = [
    ("YEARLY", {"interval" : 2}),
    ("BYMONTH", {"values" : [1]}),
    ("BYDAY", {"values" : [(6, None)]}),
    ("BYHOUR", {"values" : [8, 9]}),
    ("BYMINUTE", {"values" : [30]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 1, 5, 8, 30, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (2003, 12, 24, 0, 0, 0))
print len(l) == 32, 32, len(l)
print l[0] == (1997, 1, 11, 8, 30, 0), (1997, 1, 11, 8, 30, 0), l[0]
print l[-1] == (2003, 1, 25, 9, 30, 0), (2003, 1, 25, 9, 30, 0), l[-1]
print

qualifiers = [
    ("DAILY", {"interval" : 1})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 12, 24), 10)
print len(l) == 10, 10, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1997, 9, 11, 9, 0, 0), (1997, 9, 11, 9, 0, 0), l[-1]
print

qualifiers = [
    ("DAILY", {"interval" : 1})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 12, 24, 0, 0, 0))
print len(l) == 113, 113, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1997, 12, 23, 9, 0, 0), (1997, 12, 23, 9, 0, 0), l[-1]
print

qualifiers = [
    ("DAILY", {"interval" : 2})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 12, 24, 0, 0, 0))
print len(l) == 57, 57, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1997, 12, 23, 9, 0, 0), (1997, 12, 23, 9, 0, 0), l[-1]
print

qualifiers = [
    ("WEEKLY", {"interval" : 1})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 12, 24, 0, 0, 0))
print len(l) == 17, 17, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1997, 12, 23, 9, 0, 0), (1997, 12, 23, 9, 0, 0), l[-1]
print

qualifiers = [
    ("DAILY", {"interval" : 10})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 12, 24, 0, 0, 0), 5)
print len(l) == 5, 5, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1997, 10, 12, 9, 0, 0), (1997, 10, 12, 9, 0, 0), l[-1]
print

qualifiers = [
    ("YEARLY", {"interval" : 1}),
    ("BYMONTH", {"values" : [1]}),
    ("BYDAY", {"values" : [(1, None), (2, None), (3, None), (4, None), (5, None), (6, None), (7, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1998, 1, 1, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (2000, 1, 31, 14, 0, 0))
print len(l) == 93, 93, len(l)
print l[0] == (1998, 1, 1, 9, 0, 0), (1998, 1, 1, 9, 0, 0), l[0]
print l[-1] == (2000, 1, 31, 9, 0, 0), (2000, 1, 31, 9, 0, 0), l[-1]
print

qualifiers = [
    ("DAILY", {"interval" : 1}),
    ("BYMONTH", {"values" : [1]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1998, 1, 1, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (2000, 1, 31, 14, 0, 0))
print len(l) == 93, 93, len(l)
print l[0] == (1998, 1, 1, 9, 0, 0), (1998, 1, 1, 9, 0, 0), l[0]
print l[-1] == (2000, 1, 31, 9, 0, 0), (2000, 1, 31, 9, 0, 0), l[-1]
print

qualifiers = [
    ("WEEKLY", {"interval" : 1})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 12, 24, 0, 0, 0), 10)
print len(l) == 10, 10, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1997, 11, 4, 9, 0, 0), (1997, 11, 4, 9, 0, 0), l[-1]
print

qualifiers = [
    ("WEEKLY", {"interval" : 1})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 12, 24, 0, 0, 0))
print len(l) == 17, 17, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1997, 12, 23, 9, 0, 0), (1997, 12, 23, 9, 0, 0), l[-1]
print

qualifiers = [
    ("WEEKLY", {"interval" : 2})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1998, 2, 20, 0, 0, 0))
print len(l) == 13, 13, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1998, 2, 17, 9, 0, 0), (1998, 2, 17, 9, 0, 0), l[-1]
print

qualifiers = [
    ("WEEKLY", {"interval" : 1}),
    ("BYDAY", {"values" : [(2, None), (4, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 10, 7, 9, 0, 0))
print len(l) == 10, 10, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1997, 10, 2, 9, 0, 0), (1997, 10, 2, 9, 0, 0), l[-1]
print

qualifiers = [
    ("WEEKLY", {"interval" : 1}),
    ("BYDAY", {"values" : [(2, None), (4, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 12, 24, 0, 0, 0), 10)
print len(l) == 10, 10, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1997, 10, 2, 9, 0, 0), (1997, 10, 2, 9, 0, 0), l[-1]
print

qualifiers = [
    ("WEEKLY", {"interval" : 2}),
    ("BYDAY", {"values" : [(1, None), (3, None), (5, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 1, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 12, 24, 0, 0, 0))
print len(l) == 25, 25, len(l)
print l[0] == (1997, 9, 1, 9, 0, 0), (1997, 9, 1, 9, 0, 0), l[0]
print l[-1] == (1997, 12, 22, 9, 0, 0), (1997, 12, 22, 9, 0, 0), l[-1]
print

qualifiers = [
    ("WEEKLY", {"interval" : 2}),
    ("BYDAY", {"values" : [(2, None), (4, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 12, 24, 0, 0, 0), 8)
print len(l) == 8, 8, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1997, 10, 16, 9, 0, 0), (1997, 10, 16, 9, 0, 0), l[-1]
print

qualifiers = [
    ("MONTHLY", {"interval" : 1}),
    ("BYDAY", {"values" : [(5, 1)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 5, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1998, 12, 24, 0, 0, 0), 10)
print len(l) == 10, 10, len(l)
print l[0] == (1997, 9, 5, 9, 0, 0), (1997, 9, 5, 9, 0, 0), l[0]
print l[-1] == (1998, 6, 5, 9, 0, 0), (1998, 6, 5, 9, 0, 0), l[-1]
print

qualifiers = [
    ("MONTHLY", {"interval" : 1}),
    ("BYDAY", {"values" : [(5, 1)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 5, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 12, 24, 0, 0, 0))
print len(l) == 4, 4, len(l)
print l[0] == (1997, 9, 5, 9, 0, 0), (1997, 9, 5, 9, 0, 0), l[0]
print l[-1] == (1997, 12, 5, 9, 0, 0), (1997, 12, 5, 9, 0, 0), l[-1]
print

qualifiers = [
    ("MONTHLY", {"interval" : 2}),
    ("BYDAY", {"values" : [(7, 1), (7, -1)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 7, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1998, 12, 24, 0, 0, 0), 10)
print len(l) == 10, 10, len(l)
print l[0] == (1997, 9, 7, 9, 0, 0), (1997, 9, 7, 9, 0, 0), l[0]
print l[-1] == (1998, 5, 31, 9, 0, 0), (1998, 5, 31, 9, 0, 0), l[-1]
print

qualifiers = [
    ("MONTHLY", {"interval" : 1}),
    ("BYDAY", {"values" : [(1, -2)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 22, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1998, 12, 24, 0, 0, 0), 6)
print len(l) == 6, 6, len(l)
print l[0] == (1997, 9, 22, 9, 0, 0), (1997, 9, 22, 9, 0, 0), l[0]
print l[-1] == (1998, 2, 16, 9, 0, 0), (1998, 2, 16, 9, 0, 0), l[-1]
print

qualifiers = [
    ("MONTHLY", {"interval" : 1}),
    ("BYMONTHDAY", {"values" : [-3]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 28, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1998, 12, 24, 0, 0, 0), 6)
print len(l) == 6, 6, len(l)
print l[0] == (1997, 9, 28, 9, 0, 0), (1997, 9, 28, 9, 0, 0), l[0]
print l[-1] == (1998, 2, 26, 9, 0, 0), (1998, 2, 26, 9, 0, 0), l[-1]
print

qualifiers = [
    ("MONTHLY", {"interval" : 1}),
    ("BYMONTHDAY", {"values" : [2, 15]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1998, 12, 24, 0, 0, 0), 10)
print len(l) == 10, 10, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1998, 1, 15, 9, 0, 0), (1998, 1, 15, 9, 0, 0), l[-1]
print

qualifiers = [
    ("MONTHLY", {"interval" : 1}),
    ("BYMONTHDAY", {"values" : [1, -1]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 30, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1998, 12, 24, 0, 0, 0), 10)
print len(l) == 10, 10, len(l)
print l[0] == (1997, 9, 30, 9, 0, 0), (1997, 9, 30, 9, 0, 0), l[0]
print l[-1] == (1998, 2, 1, 9, 0, 0), (1998, 2, 1, 9, 0, 0), l[-1]
print

qualifiers = [
    ("MONTHLY", {"interval" : 18}),
    ("BYMONTHDAY", {"values" : [10, 11, 12, 13, 14, 15]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 10, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1999, 12, 24, 0, 0, 0), 10)
print len(l) == 10, 10, len(l)
print l[0] == (1997, 9, 10, 9, 0, 0), (1997, 9, 10, 9, 0, 0), l[0]
print l[-1] == (1999, 3, 13, 9, 0, 0), (1999, 3, 13, 9, 0, 0), l[-1]
print

qualifiers = [
    ("MONTHLY", {"interval" : 2}),
    ("BYDAY", {"values" : [(2, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1998, 4, 1, 0, 0, 0))
print len(l) == 18, 18, len(l)
print l[0] == (1997, 9, 2, 9, 0, 0), (1997, 9, 2, 9, 0, 0), l[0]
print l[-1] == (1998, 3, 31, 9, 0, 0), (1998, 3, 31, 9, 0, 0), l[-1]
print

qualifiers = [
    ("YEARLY", {"interval" : 1}),
    ("BYMONTH", {"values" : [6, 7]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 6, 10, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (2001, 12, 24, 0, 0, 0), 10)
print len(l) == 10, 10, len(l)
print l[0] == (1997, 6, 10, 9, 0, 0), (1997, 6, 10, 9, 0, 0), l[0]
print l[-1] == (2001, 7, 10, 9, 0, 0), (2001, 7, 10, 9, 0, 0), l[-1]
print

qualifiers = [
    ("YEARLY", {"interval" : 2}),
    ("BYMONTH", {"values" : [1, 2, 3]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 3, 10, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (2003, 12, 24, 0, 0, 0), 10)
print len(l) == 10, 10, len(l)
print l[0] == (1997, 3, 10, 9, 0, 0), (1997, 3, 10, 9, 0, 0), l[0]
print l[-1] == (2003, 3, 10, 9, 0, 0), (2003, 3, 10, 9, 0, 0), l[-1]
print

qualifiers = [
    ("YEARLY", {"interval" : 3}),
    ("BYYEARDAY", {"values" : [1, 100, 200]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 1, 1, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (2006, 2, 1, 0, 0, 0), 10)
print len(l) == 10, 10, len(l)
print l[0] == (1997, 1, 1, 9, 0, 0), (1997, 1, 1, 9, 0, 0), l[0]
print l[-1] == (2006, 1, 1, 9, 0, 0), (2006, 1, 1, 9, 0, 0), l[-1]
print

qualifiers = [
    ("YEARLY", {"interval" : 1}),
    ("BYDAY", {"values" : [(1, 20)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 5, 19, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1999, 12, 24, 0, 0, 0))
print len(l) == 3, 3, len(l)
print l[0] == (1997, 5, 19, 9, 0, 0), (1997, 5, 19, 9, 0, 0), l[0]
print l[-1] == (1999, 5, 17, 9, 0, 0), (1999, 5, 17, 9, 0, 0), l[-1]
print

"""
qualifiers = [
    ("YEARLY", {"interval" : 1}),
    ("BYWEEKNO", {"values" : [20]}),
    ("BYDAY", {"values" : [(1, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 5, 12, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1999, 12, 24, 0, 0, 0))
print len(l) == 3, 3, len(l)
print l[0] == (1997, 5, 12, 9, 0, 0), (1997, 5, 12, 9, 0, 0), l[0]
print l[-1] == (1999, 5, 17, 9, 0, 0), (1999, 5, 17, 9, 0, 0), l[-1]
print
"""

qualifiers = [
    ("YEARLY", {"interval" : 1}),
    ("BYMONTH", {"values" : [3]}),
    ("BYDAY", {"values" : [(4, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 3, 13, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1999, 12, 24, 0, 0, 0))
print len(l) == 11, 11, len(l)
print l[0] == (1997, 3, 13, 9, 0, 0), (1997, 3, 13, 9, 0, 0), l[0]
print l[-1] == (1999, 3, 25, 9, 0, 0), (1999, 3, 25, 9, 0, 0), l[-1]
print

qualifiers = [
    ("YEARLY", {"interval" : 1}),
    ("BYMONTH", {"values" : [6, 7, 8]}),
    ("BYDAY", {"values" : [(4, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 6, 5, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1999, 12, 24, 0, 0, 0))
print len(l) == 39, 39, len(l)
print l[0] == (1997, 6, 5, 9, 0, 0), (1997, 6, 5, 9, 0, 0), l[0]
print l[-1] == (1999, 8, 26, 9, 0, 0), (1999, 8, 26, 9, 0, 0), l[-1]
print

qualifiers = [
    ("MONTHLY", {"interval" : 1}),
    ("BYMONTHDAY", {"values" : [13]}),
    ("BYDAY", {"values" : [(5, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 2, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (2000, 12, 24, 0, 0, 0))
print len(l) == 5, 5, len(l)
print l[0] == (1998, 2, 13, 9, 0, 0), (1998, 2, 13, 9, 0, 0), l[0]
print l[-1] == (2000, 10, 13, 9, 0, 0), (2000, 10, 13, 9, 0, 0), l[-1]
print

qualifiers = [
    ("MONTHLY", {"interval" : 1}),
    ("BYMONTHDAY", {"values" : [7, 8, 9, 10, 11, 12, 13]}),
    ("BYDAY", {"values" : [(6, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 13, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1998, 6, 30, 0, 0, 0))
print len(l) == 10, 10, len(l)
print l[0] == (1997, 9, 13, 9, 0, 0), (1997, 9, 13, 9, 0, 0), l[0]
print l[-1] == (1998, 6, 13, 9, 0, 0), (1998, 6, 13, 9, 0, 0), l[-1]
print

qualifiers = [
    ("YEARLY", {"interval" : 4}),
    ("BYMONTH", {"values" : [11]}),
    ("BYMONTHDAY", {"values" : [2, 3, 4, 5, 6, 7, 8]}),
    ("BYDAY", {"values" : [(2, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1996, 11, 5, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (2004, 12, 24, 0, 0, 0))
print len(l) == 3, 3, len(l)
print l[0] == (1996, 11, 5, 9, 0, 0), (1996, 11, 5, 9, 0, 0), l[0]
print l[-1] == (2004, 11, 2, 9, 0, 0), (2004, 11, 2, 9, 0, 0), l[-1]
print

qualifiers = [
    ("MONTHLY", {"interval" : 1}),
    ("BYDAY", {"values" : [(2, None), (3, None), (4, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 4, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1997, 12, 24, 0, 0, 0), 3, [3])
print len(l) == 3, 3, len(l)
print l[0] == (1997, 9, 4, 9, 0, 0), (1997, 9, 4, 9, 0, 0), l[0]
print l[-1] == (1997, 11, 6, 9, 0, 0), (1997, 11, 6, 9, 0, 0), l[-1]
print

l2 = l

qualifiers = [
    ("MONTHLY", {"interval" : 1}),
    ("BYDAY", {"values" : [(1, None), (2, None), (3, None), (4, None), (5, None)]})
    ]

l = order_qualifiers(qualifiers)
show(l)
dt = (1997, 9, 29, 9, 0, 0)
l = get_datetime_structure(dt)
show(l)
l = combine_datetime_with_qualifiers(dt, qualifiers)
show(l)

s = get_selector(dt, qualifiers)
l = s.materialise(dt, (1998, 4, 1, 0, 0, 0), None, [-2])
print len(l) == 7, 7, len(l)
print l[0] == (1997, 9, 29, 9, 0, 0), (1997, 9, 29, 9, 0, 0), l[0]
print l[-1] == (1998, 3, 30, 9, 0, 0), (1998, 3, 30, 9, 0, 0), l[-1]
print

# vim: tabstop=4 expandtab shiftwidth=4
