#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:vincent.vole@example.com"
SENDER="mailto:paul.boddie@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"
echo 'PT60S' > "$PREFS/$USER/freebusy_offers"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/fb-request-person-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule an event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-person.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out0f.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out0f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the recipient.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-request-person.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out1.tmp

   ! grep -q 'METHOD:REPLY' out1.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out1f.tmp

   ! grep -q "event6@example.com" "out1f.tmp" \
&& echo "Success" \
|| echo "Failed"

   ! [ -e "$FBOTHERFILE" ] \
|| ! grep -q "event6@example.com" "$FBOTHERFILE" \
&& echo "Success" \
|| echo "Failed"

# Counter the invitation.

  "$COUNTER_SCRIPT" $COUNTER_ARGS "$USER" 20141126T170000 20141126T180000 "event6@example.com" 2>> $ERROR \
| tee out2r.tmp \
| "$SHOWMAIL" \
> out2.tmp

# Note that the invitation has only been prepared, not processed.

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out2f.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f.tmp" \
&& ! grep -q "^20141126T160000Z${TAB}20141126T170000Z" "out2f.tmp" \
&& echo "Success" \
|| echo "Failed"

   grep -q 'METHOD:COUNTER' out2.tmp \
&& grep -q 'DTSTART;TZID=Europe/Oslo.*:20141126T170000' out2.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_offers" \
>  out2o.tmp

   ! grep -q "^20141126T160000Z${TAB}20141126T170000Z" "out2o.tmp" \
&& echo "Success" \
|| echo "Failed"

# Send the counter-proposal.

"$OUTGOING_SCRIPT" $ARGS < out2r.tmp 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out2f2.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f2.tmp" \
&& ! grep -q "^20141126T160000Z${TAB}20141126T170000Z" "out2f2.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_offers" \
>  out2o2.tmp

   grep -q "^20141126T160000Z${TAB}20141126T170000Z" "out2o2.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the response to the organiser.

  "$PERSON_SCRIPT" $ARGS < out2r.tmp 2>> $ERROR \
| tee out3r.tmp \
| "$SHOWMAIL" \
> out3.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy_other" "$USER" \
>  out3f.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out3f.tmp" \
&& ! grep -q "^20141126T160000Z${TAB}20141126T170000Z" "out3f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "object" "event6@example.com" \
>  out3O.tmp

   grep -q 'DTSTART;TZID=Europe/Oslo.*:20141126T160000' "out3O.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "countered_object" "event6@example.com" "$USER" \
>  out3C.tmp

   grep -q 'DTSTART;TZID=Europe/Oslo.*:20141126T170000' "out3C.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "requests" \
>  out3R.tmp

   grep -q 'event6@example.com' "out3R.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the free/busy state of the recipient so far.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/fb-request-person-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out4.tmp

   grep -q 'METHOD:REPLY' out4.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T150000Z/20141126T160000Z' out4.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T160000Z/20141126T170000Z' out4.tmp \
&& echo "Success" \
|| echo "Failed"

# Decline the counter-proposal.

  sed 's/COUNTER/DECLINECOUNTER/' < out2.tmp \
| sed 's/^From: calendar/To: vincent.vole/' \
| sed 's/^To: paul.boddie/From: paul.boddie/' \
> out5.tmp

"$OUTGOING_SCRIPT" $ARGS < out5.tmp 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "countered_object" "event6@example.com" "$USER" \
>  out5C.tmp

   ! grep -q 'event6@example.com' "out5C.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "requests" \
>  out5R.tmp

   ! grep -q 'event6@example.com' "out5R.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < out5.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out6.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out6f.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out6f.tmp" \
&& ! grep -q "^20141126T160000Z${TAB}20141126T170000Z" "out6f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_offers" \
>  out6o.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out6o.tmp" \
&& ! grep -q "^20141126T160000Z${TAB}20141126T170000Z" "out6o.tmp" \
&& echo "Success" \
|| echo "Failed"
