/*
 * Copyright 2000-2010 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.lang;

import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

/**
 * Top-level node in AST, corresponds to PsiFile.
 *
 * @see com.intellij.psi.PsiFile
 */
public interface FileASTNode extends ASTNode {
  @NotNull
  CharTable getCharTable();

  boolean isParsed();

  /**
   * @return a lighter AST object for this tree. The result is not guaranteed to be thread-safe, and not cached inside.
   */
  @NotNull
  LighterAST getLighterAST();
}
