package Juman::Grammar;
require 5.004_04; # For base pragma.
use strict;
use base qw/ Exporter /;
use vars qw/ @EXPORT_OK $HINSI $BUNRUI $TYPE $FORM /;
@EXPORT_OK = qw/ $HINSI $BUNRUI $TYPE $FORM /;

=head1 NAME

Juman::Grammar - 品詞分類辞書および活用分類辞書

=head1 DESCRIPTION

Juman 品詞分類辞書および活用分類辞書の Perl スクリプト版．

=head1 VARIABLES

=over 4

=item C<$HINSI>

品詞と品詞番号の対応表(ハッシュ)に対するリファレンスが格納されている．

    $HINSI->[0]->{品詞} => 品詞番号
    $HINSI->[品詞番号]  => 品詞

=item C<$BUNRUI>

細分類と細分類番号の対応表(ハッシュ)に対するリファレンスが格納されてい
る．

    $BUNRUI->{品詞}->[0]->{細分類} => 細分類番号
    $BUNRUI->{品詞}->[細分類番号]  => 細分類

=item C<$TYPE>

活用型と活用型番号の対応表(ハッシュ)に対するリファレンスが格納されてい
る．

    $TYPE->[0]->{活用型} => 活用型番号
    $TYPE->[活用型番号]  => [ 活用型, 活用形, 活用形, ... ]

=item C<$FORM>

活用形と活用形番号の対応表(ハッシュ)に対するリファレンスが格納されてい
る．

    $FORM->{活用型}->[0]->{活用形} => 活用形番号
    $FORM->{活用型}->[活用形番号]  => [ 活用形, 語尾, [読み語尾] ]

=back

=cut
$HINSI = [
           {
             '接尾辞' => 14,
             '感動詞' => 12,
             '副詞' => 8,
             '指示詞' => 7,
             '形容詞' => 3,
             '未定義語' => 15,
             '接頭辞' => 13,
             '特殊' => 1,
             '名詞' => 6,
             '判定詞' => 4,
             '接続詞' => 10,
             '動詞' => 2,
             '助動詞' => 5,
             '連体詞' => 11,
             '助詞' => 9
           },
           '特殊',
           '動詞',
           '形容詞',
           '判定詞',
           '助動詞',
           '名詞',
           '指示詞',
           '副詞',
           '助詞',
           '接続詞',
           '連体詞',
           '感動詞',
           '接頭辞',
           '接尾辞',
           '未定義語'
         ];
$BUNRUI = {
            '接尾辞' => [
                             {
                               '動詞性接尾辞' => 7,
                               '形容詞性述語接尾辞' => 5,
                               '名詞性名詞接尾辞' => 2,
                               '名詞性述語接尾辞' => 1,
                               '形容詞性名詞接尾辞' => 6,
                               '名詞性特殊接尾辞' => 4,
                               '名詞性名詞助数辞' => 3
                             },
                             '名詞性述語接尾辞',
                             '名詞性名詞接尾辞',
                             '名詞性名詞助数辞',
                             '名詞性特殊接尾辞',
                             '形容詞性述語接尾辞',
                             '形容詞性名詞接尾辞',
                             '動詞性接尾辞'
                           ],
            '副詞' => [
                          {
                            '時制相副詞' => 5,
                            '評価副詞' => 7,
                            '陳述副詞' => 6,
                            '様態副詞' => 1,
                            '頻度副詞' => 4,
                            '程度副詞' => 2,
                            '量副詞' => 3,
                            '発言副詞' => 8
                          },
                          '様態副詞',
                          '程度副詞',
                          '量副詞',
                          '頻度副詞',
                          '時制相副詞',
                          '陳述副詞',
                          '評価副詞',
                          '発言副詞'
                        ],
            '指示詞' => [
                             {
                               '連体詞形態指示詞' => 2,
                               '名詞形態指示詞' => 1,
                               '副詞形態指示詞' => 3
                             },
                             '名詞形態指示詞',
                             '連体詞形態指示詞',
                             '副詞形態指示詞'
                           ],
            '未定義語' => [
                                {
                                  'アルファベット' => 3,
                                  'カタカナ' => 2,
                                  'その他' => 1
                                },
                                'その他',
                                'カタカナ',
                                'アルファベット'
                              ],
            '接頭辞' => [
                             {
                               'イ形容詞接頭辞' => 3,
                               'ナ形容詞接頭辞' => 4,
                               '動詞接頭辞' => 2,
                               '名詞接頭辞' => 1
                             },
                             '名詞接頭辞',
                             '動詞接頭辞',
                             'イ形容詞接頭辞',
                             'ナ形容詞接頭辞'
                           ],
            '特殊' => [
                          {
                            '空白' => 6,
                            '括弧終' => 4,
                            '括弧始' => 3,
                            '読点' => 2,
                            '記号' => 5,
                            '句点' => 1
                          },
                          '句点',
                          '読点',
                          '括弧始',
                          '括弧終',
                          '記号',
                          '空白'
                        ],
            '名詞' => [
                          {
                            '組織名' => 6,
                            '数詞' => 7,
                            '人名' => 5,
                            '固有名詞' => 3,
                            '普通名詞' => 1,
                            'サ変名詞' => 2,
                            '地名' => 4,
                            '時相名詞' => 10,
                            '副詞的名詞' => 9,
                            '形式名詞' => 8
                          },
                          '普通名詞',
                          'サ変名詞',
                          '固有名詞',
                          '地名',
                          '人名',
                          '組織名',
                          '数詞',
                          '形式名詞',
                          '副詞的名詞',
                          '時相名詞'
                        ],
            '助詞' => [
                          {
                            '副助詞' => 2,
                            '終助詞' => 4,
                            '接続助詞' => 3,
                            '格助詞' => 1
                          },
                          '格助詞',
                          '副助詞',
                          '接続助詞',
                          '終助詞'
                        ]
          };
$TYPE = [
          {
            '子音動詞カ行' => 2,
            'イ形容詞イ段特殊' => 20,
            '子音動詞ナ行' => 7,
            '無活用型' => 26,
            '動詞性接尾辞うる型' => 32,
            'ナノ形容詞' => 22,
            'カ変動詞' => 14,
            '子音動詞ガ行' => 4,
            '判定詞' => 25,
            '子音動詞タ行' => 6,
            '助動詞ぬ型' => 27,
            '助動詞そうだ型' => 29,
            '助動詞だろう型' => 28,
            '子音動詞サ行' => 5,
            'ナ形容詞' => 21,
            '子音動詞カ行促音便形' => 3,
            'イ形容詞アウオ段' => 18,
            'ザ変動詞' => 17,
            '子音動詞ラ行イ形' => 11,
            '助動詞く型' => 30,
            'タル形容詞' => 24,
            '子音動詞バ行' => 8,
            '子音動詞ワ行文語音便形' => 13,
            'イ形容詞イ段' => 19,
            '子音動詞ワ行' => 12,
            'カ変動詞来' => 15,
            'ナ形容詞特殊' => 23,
            '動詞性接尾辞ます型' => 31,
            'サ変動詞' => 16,
            '子音動詞ラ行' => 10,
            '子音動詞マ行' => 9,
            '母音動詞' => 1
          },
          [
            '母音動詞',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形',
            '文語命令形'
          ],
          [
            '子音動詞カ行',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形'
          ],
          [
            '子音動詞カ行促音便形',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形'
          ],
          [
            '子音動詞ガ行',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形'
          ],
          [
            '子音動詞サ行',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形'
          ],
          [
            '子音動詞タ行',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形'
          ],
          [
            '子音動詞ナ行',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形'
          ],
          [
            '子音動詞バ行',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形'
          ],
          [
            '子音動詞マ行',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形'
          ],
          [
            '子音動詞ラ行',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形'
          ],
          [
            '子音動詞ラ行イ形',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形'
          ],
          [
            '子音動詞ワ行',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形'
          ],
          [
            '子音動詞ワ行文語音便形',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形'
          ],
          [
            'カ変動詞',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形'
          ],
          [
            'カ変動詞来',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形'
          ],
          [
            'サ変動詞',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形',
            '文語基本形',
            '文語未然形',
            '文語命令形'
          ],
          [
            'ザ変動詞',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            '基本条件形',
            '基本連用形',
            'タ接連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            '音便条件形',
            '文語基本形',
            '文語未然形',
            '文語命令形'
          ],
          [
            'イ形容詞アウオ段',
            '語幹',
            '基本形',
            '命令形',
            '基本推量形',
            '基本省略推量形',
            '基本条件形',
            '基本連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            'タ系連用チャ形２',
            '音便条件形',
            '音便条件形２',
            '文語基本形',
            '文語未然形',
            '文語連用形',
            '文語連体形',
            '文語命令形'
          ],
          [
            'イ形容詞イ段',
            '語幹',
            '基本形',
            '命令形',
            '基本推量形',
            '基本省略推量形',
            '基本条件形',
            '基本連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            'タ系連用チャ形２',
            '音便条件形',
            '音便条件形２',
            '文語基本形',
            '文語未然形',
            '文語連用形',
            '文語連体形',
            '文語命令形'
          ],
          [
            'イ形容詞イ段特殊',
            '語幹',
            '基本形',
            '命令形',
            '基本推量形',
            '基本省略推量形',
            '基本条件形',
            '基本連用形',
            'タ形',
            'タ系推量形',
            'タ系省略推量形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形',
            'タ系連用チャ形',
            'タ系連用チャ形２',
            '音便条件形',
            '音便条件形２',
            '文語基本形',
            '文語未然形',
            '文語連用形',
            '文語連体形',
            '文語命令形'
          ],
          [
            'ナ形容詞',
            '語幹',
            '基本形',
            'ダ列命令形',
            'ダ列基本連体形',
            'ダ列基本推量形',
            'ダ列基本省略推量形',
            'ダ列基本条件形',
            'ダ列基本連用形',
            'ダ列タ形',
            'ダ列タ系推量形',
            'ダ列タ系省略推量形',
            'ダ列タ系条件形',
            'ダ列タ系連用テ形',
            'ダ列タ系連用タリ形',
            'ダ列タ系連用ジャ形',
            'ダ列文語連体形',
            'ダ列文語条件形',
            'デアル列基本形',
            'デアル列命令形',
            'デアル列基本推量形',
            'デアル列基本省略推量形',
            'デアル列基本条件形',
            'デアル列基本連用形',
            'デアル列タ形',
            'デアル列タ系推量形',
            'デアル列タ系省略推量形',
            'デアル列タ系条件形',
            'デアル列タ系連用テ形',
            'デアル列タ系連用タリ形',
            'デス列基本形',
            'デス列基本推量形',
            'デス列基本省略推量形',
            'デス列タ形',
            'デス列タ系推量形',
            'デス列タ系省略推量形',
            'デス列タ系条件形',
            'デス列タ系連用テ形',
            'デス列タ系連用タリ形'
          ],
          [
            'ナノ形容詞',
            '語幹',
            '基本形',
            'ダ列命令形',
            'ダ列基本連体形',
            'ダ列特殊連体形',
            'ダ列基本推量形',
            'ダ列基本省略推量形',
            'ダ列基本条件形',
            'ダ列基本連用形',
            'ダ列タ形',
            'ダ列タ系推量形',
            'ダ列タ系省略推量形',
            'ダ列タ系条件形',
            'ダ列タ系連用テ形',
            'ダ列タ系連用タリ形',
            'ダ列タ系連用ジャ形',
            'ダ列文語連体形',
            'ダ列文語条件形',
            'デアル列基本形',
            'デアル列命令形',
            'デアル列基本推量形',
            'デアル列基本省略推量形',
            'デアル列基本条件形',
            'デアル列基本連用形',
            'デアル列タ形',
            'デアル列タ系推量形',
            'デアル列タ系省略推量形',
            'デアル列タ系条件形',
            'デアル列タ系連用テ形',
            'デアル列タ系連用タリ形',
            'デス列基本形',
            'デス列基本推量形',
            'デス列基本省略推量形',
            'デス列タ形',
            'デス列タ系推量形',
            'デス列タ系省略推量形',
            'デス列タ系条件形',
            'デス列タ系連用テ形',
            'デス列タ系連用タリ形'
          ],
          [
            'ナ形容詞特殊',
            '語幹',
            '基本形',
            'ダ列命令形',
            'ダ列基本連体形',
            'ダ列特殊連体形',
            'ダ列基本推量形',
            'ダ列基本省略推量形',
            'ダ列基本条件形',
            'ダ列基本連用形',
            'ダ列特殊連用形',
            'ダ列タ形',
            'ダ列タ系推量形',
            'ダ列タ系省略推量形',
            'ダ列タ系条件形',
            'ダ列タ系連用テ形',
            'ダ列タ系連用タリ形',
            'ダ列タ系連用ジャ形',
            'ダ列文語連体形',
            'ダ列文語条件形',
            'デアル列基本形',
            'デアル列命令形',
            'デアル列基本推量形',
            'デアル列基本省略推量形',
            'デアル列基本条件形',
            'デアル列基本連用形',
            'デアル列タ形',
            'デアル列タ系推量形',
            'デアル列タ系省略推量形',
            'デアル列タ系条件形',
            'デアル列タ系連用テ形',
            'デアル列タ系連用タリ形',
            'デス列基本形',
            'デス列基本推量形',
            'デス列基本省略推量形',
            'デス列タ形',
            'デス列タ系推量形',
            'デス列タ系省略推量形',
            'デス列タ系条件形',
            'デス列タ系連用テ形',
            'デス列タ系連用タリ形'
          ],
          [
            'タル形容詞',
            '語幹',
            '基本形',
            '基本連用形'
          ],
          [
            '判定詞',
            '語幹',
            '基本形',
            'ダ列命令形',
            'ダ列基本連体形',
            'ダ列特殊連体形',
            'ダ列基本推量形',
            'ダ列基本省略推量形',
            'ダ列基本条件形',
            'ダ列タ形',
            'ダ列タ系推量形',
            'ダ列タ系省略推量形',
            'ダ列タ系条件形',
            'ダ列タ系連用テ形',
            'ダ列タ系連用タリ形',
            'ダ列タ系連用ジャ形',
            'デアル列基本形',
            'デアル列命令形',
            'デアル列基本推量形',
            'デアル列基本省略推量形',
            'デアル列基本条件形',
            'デアル列基本連用形',
            'デアル列タ形',
            'デアル列タ系推量形',
            'デアル列タ系省略推量形',
            'デアル列タ系条件形',
            'デアル列タ系連用テ形',
            'デアル列タ系連用タリ形',
            'デス列基本形',
            'デス列基本推量形',
            'デス列基本省略推量形',
            'デス列タ形',
            'デス列タ系推量形',
            'デス列タ系省略推量形',
            'デス列タ系条件形',
            'デス列タ系連用テ形',
            'デス列タ系連用タリ形'
          ],
          [
            '無活用型',
            '語幹',
            '基本形'
          ],
          [
            '助動詞ぬ型',
            '語幹',
            '基本形',
            '基本条件形',
            '基本連用形',
            '基本推量形',
            '基本省略推量形',
            'タ形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系推量形',
            'タ系省略推量形',
            '音便基本形',
            '音便推量形',
            '音便省略推量形',
            '文語連体形',
            '文語条件形',
            '文語音便条件形'
          ],
          [
            '助動詞だろう型',
            '語幹',
            '基本形',
            'ダ列基本省略推量形',
            'ダ列基本条件形',
            'デアル列基本推量形',
            'デアル列基本省略推量形',
            'デス列基本推量形',
            'デス列基本省略推量形'
          ],
          [
            '助動詞そうだ型',
            '語幹',
            '基本形',
            'ダ列タ系連用テ形',
            'デアル列基本形',
            'デス列基本形'
          ],
          [
            '助動詞く型',
            '語幹',
            '基本形',
            '基本連用形',
            '文語連体形'
          ],
          [
            '動詞性接尾辞ます型',
            '語幹',
            '基本形',
            '未然形',
            '意志形',
            '省略意志形',
            '命令形',
            'タ形',
            'タ系条件形',
            'タ系連用テ形',
            'タ系連用タリ形'
          ],
          [
            '動詞性接尾辞うる型',
            '語幹',
            '基本形',
            '基本条件形'
          ]
        ];
$FORM = {
          '子音動詞カ行' => [
                                    {
                                      '音便条件形' => 17,
                                      'タ系連用チャ形' => 16,
                                      '未然形' => 3,
                                      '語幹' => 1,
                                      '省略意志形' => 5,
                                      'タ系条件形' => 13,
                                      'タ系省略推量形' => 12,
                                      '基本形' => 2,
                                      '基本条件形' => 7,
                                      'タ系連用タリ形' => 15,
                                      '基本連用形' => 8,
                                      'タ接連用形' => 9,
                                      '意志形' => 4,
                                      'タ形' => 10,
                                      'タ系連用テ形' => 14,
                                      'タ系推量形' => 11,
                                      '命令形' => 6
                                    },
                                    [
                                      '語幹',
                                      '*'
                                    ],
                                    [
                                      '基本形',
                                      'く'
                                    ],
                                    [
                                      '未然形',
                                      'か'
                                    ],
                                    [
                                      '意志形',
                                      'こう'
                                    ],
                                    [
                                      '省略意志形',
                                      'こ'
                                    ],
                                    [
                                      '命令形',
                                      'け'
                                    ],
                                    [
                                      '基本条件形',
                                      'けば'
                                    ],
                                    [
                                      '基本連用形',
                                      'き'
                                    ],
                                    [
                                      'タ接連用形',
                                      'い'
                                    ],
                                    [
                                      'タ形',
                                      'いた'
                                    ],
                                    [
                                      'タ系推量形',
                                      'いたろう'
                                    ],
                                    [
                                      'タ系省略推量形',
                                      'いたろ'
                                    ],
                                    [
                                      'タ系条件形',
                                      'いたら'
                                    ],
                                    [
                                      'タ系連用テ形',
                                      'いて'
                                    ],
                                    [
                                      'タ系連用タリ形',
                                      'いたり'
                                    ],
                                    [
                                      'タ系連用チャ形',
                                      'いちゃ'
                                    ],
                                    [
                                      '音便条件形',
                                      'きゃ'
                                    ]
                                  ],
          'イ形容詞イ段特殊' => [
                                          {
                                            '音便条件形２' => 17,
                                            '文語未然形' => 19,
                                            '音便条件形' => 16,
                                            'タ系連用チャ形' => 14,
                                            '語幹' => 1,
                                            '文語連体形' => 21,
                                            '基本推量形' => 4,
                                            'タ系条件形' => 11,
                                            'タ系省略推量形' => 10,
                                            '基本形' => 2,
                                            '基本条件形' => 6,
                                            '基本省略推量形' => 5,
                                            'タ系連用タリ形' => 13,
                                            '基本連用形' => 7,
                                            '文語連用形' => 20,
                                            '文語基本形' => 18,
                                            'タ系連用チャ形２' => 15,
                                            'タ形' => 8,
                                            'タ系連用テ形' => 12,
                                            'タ系推量形' => 9,
                                            '命令形' => 3,
                                            '文語命令形' => 22
                                          },
                                          [
                                            '語幹',
                                            '*'
                                          ],
                                          [
                                            '基本形',
                                            'い'
                                          ],
                                          [
                                            '命令形',
                                            'かれ'
                                          ],
                                          [
                                            '基本推量形',
                                            'かろう'
                                          ],
                                          [
                                            '基本省略推量形',
                                            'かろ'
                                          ],
                                          [
                                            '基本条件形',
                                            'ければ'
                                          ],
                                          [
                                            '基本連用形',
                                            'く'
                                          ],
                                          [
                                            'タ形',
                                            'かった'
                                          ],
                                          [
                                            'タ系推量形',
                                            'かったろう'
                                          ],
                                          [
                                            'タ系省略推量形',
                                            'かったろ'
                                          ],
                                          [
                                            'タ系条件形',
                                            'かったら'
                                          ],
                                          [
                                            'タ系連用テ形',
                                            'くて'
                                          ],
                                          [
                                            'タ系連用タリ形',
                                            'かったり'
                                          ],
                                          [
                                            'タ系連用チャ形',
                                            'くちゃ'
                                          ],
                                          [
                                            'タ系連用チャ形２',
                                            'くっちゃ'
                                          ],
                                          [
                                            '音便条件形',
                                            'けりゃ'
                                          ],
                                          [
                                            '音便条件形２',
                                            'きゃ'
                                          ],
                                          [
                                            '文語基本形',
                                            'し'
                                          ],
                                          [
                                            '文語未然形',
                                            'から'
                                          ],
                                          [
                                            '文語連用形',
                                            'ゅう'
                                          ],
                                          [
                                            '文語連体形',
                                            'き'
                                          ],
                                          [
                                            '文語命令形',
                                            'かれ'
                                          ]
                                        ],
          '子音動詞ナ行' => [
                                    {
                                      '音便条件形' => 17,
                                      'タ系連用チャ形' => 16,
                                      '未然形' => 3,
                                      '語幹' => 1,
                                      '省略意志形' => 5,
                                      'タ系条件形' => 13,
                                      'タ系省略推量形' => 12,
                                      '基本形' => 2,
                                      '基本条件形' => 7,
                                      'タ系連用タリ形' => 15,
                                      '基本連用形' => 8,
                                      'タ接連用形' => 9,
                                      '意志形' => 4,
                                      'タ形' => 10,
                                      'タ系連用テ形' => 14,
                                      'タ系推量形' => 11,
                                      '命令形' => 6
                                    },
                                    [
                                      '語幹',
                                      '*'
                                    ],
                                    [
                                      '基本形',
                                      'ぬ'
                                    ],
                                    [
                                      '未然形',
                                      'な'
                                    ],
                                    [
                                      '意志形',
                                      'のう'
                                    ],
                                    [
                                      '省略意志形',
                                      'の'
                                    ],
                                    [
                                      '命令形',
                                      'ね'
                                    ],
                                    [
                                      '基本条件形',
                                      'ねば'
                                    ],
                                    [
                                      '基本連用形',
                                      'に'
                                    ],
                                    [
                                      'タ接連用形',
                                      'ん'
                                    ],
                                    [
                                      'タ形',
                                      'んだ'
                                    ],
                                    [
                                      'タ系推量形',
                                      'んだろう'
                                    ],
                                    [
                                      'タ系省略推量形',
                                      'んたろ'
                                    ],
                                    [
                                      'タ系条件形',
                                      'んだら'
                                    ],
                                    [
                                      'タ系連用テ形',
                                      'んで'
                                    ],
                                    [
                                      'タ系連用タリ形',
                                      'んだり'
                                    ],
                                    [
                                      'タ系連用チャ形',
                                      'んじゃ'
                                    ],
                                    [
                                      '音便条件形',
                                      'にゃ'
                                    ]
                                  ],
          '無活用型' => [
                              {
                                '語幹' => 1,
                                '基本形' => 2
                              },
                              [
                                '語幹',
                                '*'
                              ],
                              [
                                '基本形',
                                '*'
                              ]
                            ],
          '動詞性接尾辞うる型' => [
                                             {
                                               '語幹' => 1,
                                               '基本条件形' => 3,
                                               '基本形' => 2
                                             },
                                             [
                                               '語幹',
                                               '*'
                                             ],
                                             [
                                               '基本形',
                                               'うる'
                                             ],
                                             [
                                               '基本条件形',
                                               'うれば'
                                             ]
                                           ],
          'ナノ形容詞' => [
                                 {
                                   'デス列基本形' => 31,
                                   'デアル列タ形' => 25,
                                   'ダ列文語連体形' => 17,
                                   'ダ列基本連用形' => 9,
                                   'デス列タ系条件形' => 37,
                                   'ダ列基本推量形' => 6,
                                   'ダ列基本省略推量形' => 7,
                                   'デアル列命令形' => 20,
                                   'ダ列特殊連体形' => 5,
                                   'ダ列タ系推量形' => 11,
                                   'デス列タ系連用テ形' => 38,
                                   'ダ列タ系連用タリ形' => 15,
                                   'デス列タ形' => 34,
                                   'デアル列タ系省略推量形' => 27,
                                   'デス列基本省略推量形' => 33,
                                   'デス列タ系省略推量形' => 36,
                                   'デアル列基本推量形' => 21,
                                   'ダ列タ系連用ジャ形' => 16,
                                   'デアル列基本形' => 19,
                                   'デアル列基本条件形' => 23,
                                   'デアル列タ系連用タリ形' => 30,
                                   'ダ列タ系連用テ形' => 14,
                                   'ダ列タ系条件形' => 13,
                                   'デアル列基本連用形' => 24,
                                   '語幹' => 1,
                                   'デス列タ系推量形' => 35,
                                   'デアル列タ系連用テ形' => 29,
                                   'ダ列命令形' => 3,
                                   'デアル列基本省略推量形' => 22,
                                   '基本形' => 2,
                                   'ダ列基本連体形' => 4,
                                   'ダ列タ系省略推量形' => 12,
                                   'ダ列基本条件形' => 8,
                                   'デス列タ系連用タリ形' => 39,
                                   'ダ列タ形' => 10,
                                   'デアル列タ系条件形' => 28,
                                   'ダ列文語条件形' => 18,
                                   'デス列基本推量形' => 32,
                                   'デアル列タ系推量形' => 26
                                 },
                                 [
                                   '語幹',
                                   '*'
                                 ],
                                 [
                                   '基本形',
                                   'だ'
                                 ],
                                 [
                                   'ダ列命令形',
                                   'なれ'
                                 ],
                                 [
                                   'ダ列基本連体形',
                                   'な'
                                 ],
                                 [
                                   'ダ列特殊連体形',
                                   'の'
                                 ],
                                 [
                                   'ダ列基本推量形',
                                   'だろう'
                                 ],
                                 [
                                   'ダ列基本省略推量形',
                                   'だろ'
                                 ],
                                 [
                                   'ダ列基本条件形',
                                   'ならば'
                                 ],
                                 [
                                   'ダ列基本連用形',
                                   'に'
                                 ],
                                 [
                                   'ダ列タ形',
                                   'だった'
                                 ],
                                 [
                                   'ダ列タ系推量形',
                                   'だったろう'
                                 ],
                                 [
                                   'ダ列タ系省略推量形',
                                   'だったろ'
                                 ],
                                 [
                                   'ダ列タ系条件形',
                                   'だったら'
                                 ],
                                 [
                                   'ダ列タ系連用テ形',
                                   'で'
                                 ],
                                 [
                                   'ダ列タ系連用タリ形',
                                   'だったり'
                                 ],
                                 [
                                   'ダ列タ系連用ジャ形',
                                   'じゃ'
                                 ],
                                 [
                                   'ダ列文語連体形',
                                   'なる'
                                 ],
                                 [
                                   'ダ列文語条件形',
                                   'なれば'
                                 ],
                                 [
                                   'デアル列基本形',
                                   'である'
                                 ],
                                 [
                                   'デアル列命令形',
                                   'であれ'
                                 ],
                                 [
                                   'デアル列基本推量形',
                                   'であろう'
                                 ],
                                 [
                                   'デアル列基本省略推量形',
                                   'であろ'
                                 ],
                                 [
                                   'デアル列基本条件形',
                                   'であれば'
                                 ],
                                 [
                                   'デアル列基本連用形',
                                   'であり'
                                 ],
                                 [
                                   'デアル列タ形',
                                   'であった'
                                 ],
                                 [
                                   'デアル列タ系推量形',
                                   'であったろう'
                                 ],
                                 [
                                   'デアル列タ系省略推量形',
                                   'であったろ'
                                 ],
                                 [
                                   'デアル列タ系条件形',
                                   'であったら'
                                 ],
                                 [
                                   'デアル列タ系連用テ形',
                                   'であって'
                                 ],
                                 [
                                   'デアル列タ系連用タリ形',
                                   'であったり'
                                 ],
                                 [
                                   'デス列基本形',
                                   'です'
                                 ],
                                 [
                                   'デス列基本推量形',
                                   'でしょう'
                                 ],
                                 [
                                   'デス列基本省略推量形',
                                   'でしょ'
                                 ],
                                 [
                                   'デス列タ形',
                                   'でした'
                                 ],
                                 [
                                   'デス列タ系推量形',
                                   'でしたろう'
                                 ],
                                 [
                                   'デス列タ系省略推量形',
                                   'でしたろ'
                                 ],
                                 [
                                   'デス列タ系条件形',
                                   'でしたら'
                                 ],
                                 [
                                   'デス列タ系連用テ形',
                                   'でして'
                                 ],
                                 [
                                   'デス列タ系連用タリ形',
                                   'でしたり'
                                 ]
                               ],
          'カ変動詞' => [
                              {
                                '音便条件形' => 17,
                                'タ系連用チャ形' => 16,
                                '未然形' => 3,
                                '語幹' => 1,
                                '省略意志形' => 5,
                                'タ系条件形' => 13,
                                'タ系省略推量形' => 12,
                                '基本形' => 2,
                                '基本条件形' => 7,
                                'タ系連用タリ形' => 15,
                                '基本連用形' => 8,
                                'タ接連用形' => 9,
                                '意志形' => 4,
                                'タ形' => 10,
                                'タ系連用テ形' => 14,
                                'タ系推量形' => 11,
                                '命令形' => 6
                              },
                              [
                                '語幹',
                                '*'
                              ],
                              [
                                '基本形',
                                'くる'
                              ],
                              [
                                '未然形',
                                'こ'
                              ],
                              [
                                '意志形',
                                'こよう'
                              ],
                              [
                                '省略意志形',
                                'こよ'
                              ],
                              [
                                '命令形',
                                'こい'
                              ],
                              [
                                '基本条件形',
                                'くれば'
                              ],
                              [
                                '基本連用形',
                                'き'
                              ],
                              [
                                'タ接連用形',
                                'き'
                              ],
                              [
                                'タ形',
                                'きた'
                              ],
                              [
                                'タ系推量形',
                                'きたろう'
                              ],
                              [
                                'タ系省略推量形',
                                'きたろ'
                              ],
                              [
                                'タ系条件形',
                                'きたら'
                              ],
                              [
                                'タ系連用テ形',
                                'きて'
                              ],
                              [
                                'タ系連用タリ形',
                                'きたり'
                              ],
                              [
                                'タ系連用チャ形',
                                'きちゃ'
                              ],
                              [
                                '音便条件形',
                                'くりゃ'
                              ]
                            ],
          '子音動詞ガ行' => [
                                    {
                                      '音便条件形' => 17,
                                      'タ系連用チャ形' => 16,
                                      '未然形' => 3,
                                      '語幹' => 1,
                                      '省略意志形' => 5,
                                      'タ系条件形' => 13,
                                      'タ系省略推量形' => 12,
                                      '基本形' => 2,
                                      '基本条件形' => 7,
                                      'タ系連用タリ形' => 15,
                                      '基本連用形' => 8,
                                      'タ接連用形' => 9,
                                      '意志形' => 4,
                                      'タ形' => 10,
                                      'タ系連用テ形' => 14,
                                      'タ系推量形' => 11,
                                      '命令形' => 6
                                    },
                                    [
                                      '語幹',
                                      '*'
                                    ],
                                    [
                                      '基本形',
                                      'ぐ'
                                    ],
                                    [
                                      '未然形',
                                      'が'
                                    ],
                                    [
                                      '意志形',
                                      'ごう'
                                    ],
                                    [
                                      '省略意志形',
                                      'ご'
                                    ],
                                    [
                                      '命令形',
                                      'げ'
                                    ],
                                    [
                                      '基本条件形',
                                      'げば'
                                    ],
                                    [
                                      '基本連用形',
                                      'ぎ'
                                    ],
                                    [
                                      'タ接連用形',
                                      'い'
                                    ],
                                    [
                                      'タ形',
                                      'いだ'
                                    ],
                                    [
                                      'タ系推量形',
                                      'いだろう'
                                    ],
                                    [
                                      'タ系省略推量形',
                                      'いだろ'
                                    ],
                                    [
                                      'タ系条件形',
                                      'いだら'
                                    ],
                                    [
                                      'タ系連用テ形',
                                      'いで'
                                    ],
                                    [
                                      'タ系連用タリ形',
                                      'いだり'
                                    ],
                                    [
                                      'タ系連用チャ形',
                                      'いじゃ'
                                    ],
                                    [
                                      '音便条件形',
                                      'ぎゃ'
                                    ]
                                  ],
          '判定詞' => [
                           {
                             'デス列基本形' => 28,
                             'デアル列タ形' => 22,
                             'デス列タ系条件形' => 34,
                             'ダ列基本推量形' => 6,
                             'ダ列基本省略推量形' => 7,
                             'デアル列命令形' => 17,
                             'ダ列特殊連体形' => 5,
                             'ダ列タ系推量形' => 10,
                             'デス列タ系連用テ形' => 35,
                             'ダ列タ系連用タリ形' => 14,
                             'デス列タ形' => 31,
                             'デアル列タ系省略推量形' => 24,
                             'デス列基本省略推量形' => 30,
                             'デス列タ系省略推量形' => 33,
                             'デアル列基本推量形' => 18,
                             'ダ列タ系連用ジャ形' => 15,
                             'デアル列基本形' => 16,
                             'デアル列基本条件形' => 20,
                             'デアル列タ系連用タリ形' => 27,
                             'ダ列タ系連用テ形' => 13,
                             'ダ列タ系条件形' => 12,
                             'デアル列基本連用形' => 21,
                             '語幹' => 1,
                             'デアル列タ系連用テ形' => 26,
                             'デス列タ系推量形' => 32,
                             'ダ列命令形' => 3,
                             'デアル列基本省略推量形' => 19,
                             '基本形' => 2,
                             'ダ列基本連体形' => 4,
                             'ダ列タ系省略推量形' => 11,
                             'ダ列基本条件形' => 8,
                             'デス列タ系連用タリ形' => 36,
                             'ダ列タ形' => 9,
                             'デアル列タ系条件形' => 25,
                             'デス列基本推量形' => 29,
                             'デアル列タ系推量形' => 23
                           },
                           [
                             '語幹',
                             '*'
                           ],
                           [
                             '基本形',
                             'だ'
                           ],
                           [
                             'ダ列命令形',
                             'なれ'
                           ],
                           [
                             'ダ列基本連体形',
                             'な'
                           ],
                           [
                             'ダ列特殊連体形',
                             'の'
                           ],
                           [
                             'ダ列基本推量形',
                             'だろう'
                           ],
                           [
                             'ダ列基本省略推量形',
                             'だろ'
                           ],
                           [
                             'ダ列基本条件形',
                             'ならば'
                           ],
                           [
                             'ダ列タ形',
                             'だった'
                           ],
                           [
                             'ダ列タ系推量形',
                             'だったろう'
                           ],
                           [
                             'ダ列タ系省略推量形',
                             'だったろ'
                           ],
                           [
                             'ダ列タ系条件形',
                             'だったら'
                           ],
                           [
                             'ダ列タ系連用テ形',
                             'で'
                           ],
                           [
                             'ダ列タ系連用タリ形',
                             'だったり'
                           ],
                           [
                             'ダ列タ系連用ジャ形',
                             'じゃ'
                           ],
                           [
                             'デアル列基本形',
                             'である'
                           ],
                           [
                             'デアル列命令形',
                             'であれ'
                           ],
                           [
                             'デアル列基本推量形',
                             'であろう'
                           ],
                           [
                             'デアル列基本省略推量形',
                             'であろ'
                           ],
                           [
                             'デアル列基本条件形',
                             'であれば'
                           ],
                           [
                             'デアル列基本連用形',
                             'であり'
                           ],
                           [
                             'デアル列タ形',
                             'であった'
                           ],
                           [
                             'デアル列タ系推量形',
                             'であったろう'
                           ],
                           [
                             'デアル列タ系省略推量形',
                             'であったろ'
                           ],
                           [
                             'デアル列タ系条件形',
                             'であったら'
                           ],
                           [
                             'デアル列タ系連用テ形',
                             'であって'
                           ],
                           [
                             'デアル列タ系連用タリ形',
                             'であったり'
                           ],
                           [
                             'デス列基本形',
                             'です'
                           ],
                           [
                             'デス列基本推量形',
                             'でしょう'
                           ],
                           [
                             'デス列基本省略推量形',
                             'でしょ'
                           ],
                           [
                             'デス列タ形',
                             'でした'
                           ],
                           [
                             'デス列タ系推量形',
                             'でしたろう'
                           ],
                           [
                             'デス列タ系省略推量形',
                             'でしたろ'
                           ],
                           [
                             'デス列タ系条件形',
                             'でしたら'
                           ],
                           [
                             'デス列タ系連用テ形',
                             'でして'
                           ],
                           [
                             'デス列タ系連用タリ形',
                             'でしたり'
                           ]
                         ],
          '子音動詞タ行' => [
                                    {
                                      '音便条件形' => 17,
                                      'タ系連用チャ形' => 16,
                                      '未然形' => 3,
                                      '語幹' => 1,
                                      '省略意志形' => 5,
                                      'タ系条件形' => 13,
                                      'タ系省略推量形' => 12,
                                      '基本形' => 2,
                                      '基本条件形' => 7,
                                      'タ系連用タリ形' => 15,
                                      '基本連用形' => 8,
                                      'タ接連用形' => 9,
                                      '意志形' => 4,
                                      'タ形' => 10,
                                      'タ系連用テ形' => 14,
                                      'タ系推量形' => 11,
                                      '命令形' => 6
                                    },
                                    [
                                      '語幹',
                                      '*'
                                    ],
                                    [
                                      '基本形',
                                      'つ'
                                    ],
                                    [
                                      '未然形',
                                      'た'
                                    ],
                                    [
                                      '意志形',
                                      'とう'
                                    ],
                                    [
                                      '省略意志形',
                                      'と'
                                    ],
                                    [
                                      '命令形',
                                      'て'
                                    ],
                                    [
                                      '基本条件形',
                                      'てば'
                                    ],
                                    [
                                      '基本連用形',
                                      'ち'
                                    ],
                                    [
                                      'タ接連用形',
                                      'っ'
                                    ],
                                    [
                                      'タ形',
                                      'った'
                                    ],
                                    [
                                      'タ系推量形',
                                      'ったろう'
                                    ],
                                    [
                                      'タ系省略推量形',
                                      'ったろ'
                                    ],
                                    [
                                      'タ系条件形',
                                      'ったら'
                                    ],
                                    [
                                      'タ系連用テ形',
                                      'って'
                                    ],
                                    [
                                      'タ系連用タリ形',
                                      'ったり'
                                    ],
                                    [
                                      'タ系連用チャ形',
                                      'っちゃ'
                                    ],
                                    [
                                      '音便条件形',
                                      'ちゃ'
                                    ]
                                  ],
          '助動詞ぬ型' => [
                                 {
                                   '音便推量形' => 13,
                                   '基本省略推量形' => 6,
                                   '音便基本形' => 12,
                                   '文語音便条件形' => 17,
                                   '基本連用形' => 4,
                                   '文語条件形' => 16,
                                   'タ系連用テ形' => 9,
                                   '語幹' => 1,
                                   'タ形' => 7,
                                   '文語連体形' => 15,
                                   'タ系推量形' => 10,
                                   '基本推量形' => 5,
                                   '音便省略推量形' => 14,
                                   'タ系省略推量形' => 11,
                                   'タ系条件形' => 8,
                                   '基本形' => 2,
                                   '基本条件形' => 3
                                 },
                                 [
                                   '語幹',
                                   '*'
                                 ],
                                 [
                                   '基本形',
                                   'ぬ'
                                 ],
                                 [
                                   '基本条件形',
                                   'ねば'
                                 ],
                                 [
                                   '基本連用形',
                                   'ず'
                                 ],
                                 [
                                   '基本推量形',
                                   'ぬだろう'
                                 ],
                                 [
                                   '基本省略推量形',
                                   'ぬだろ'
                                 ],
                                 [
                                   'タ形',
                                   'なんだ'
                                 ],
                                 [
                                   'タ系条件形',
                                   'なんだら'
                                 ],
                                 [
                                   'タ系連用テ形',
                                   'ないで'
                                 ],
                                 [
                                   'タ系推量形',
                                   'なんだろう'
                                 ],
                                 [
                                   'タ系省略推量形',
                                   'なんだろ'
                                 ],
                                 [
                                   '音便基本形',
                                   'ん'
                                 ],
                                 [
                                   '音便推量形',
                                   'んだろう'
                                 ],
                                 [
                                   '音便省略推量形',
                                   'んだろ'
                                 ],
                                 [
                                   '文語連体形',
                                   'ざる'
                                 ],
                                 [
                                   '文語条件形',
                                   'ざれば'
                                 ],
                                 [
                                   '文語音便条件形',
                                   'ずんば'
                                 ]
                               ],
          '助動詞そうだ型' => [
                                       {
                                         'デアル列基本形' => 4,
                                         '語幹' => 1,
                                         'デス列基本形' => 5,
                                         'ダ列タ系連用テ形' => 3,
                                         '基本形' => 2
                                       },
                                       [
                                         '語幹',
                                         '*'
                                       ],
                                       [
                                         '基本形',
                                         'だ'
                                       ],
                                       [
                                         'ダ列タ系連用テ形',
                                         'で'
                                       ],
                                       [
                                         'デアル列基本形',
                                         'である'
                                       ],
                                       [
                                         'デス列基本形',
                                         'です'
                                       ]
                                     ],
          '助動詞だろう型' => [
                                       {
                                         'デアル列基本推量形' => 5,
                                         'ダ列基本条件形' => 4,
                                         '語幹' => 1,
                                         'ダ列基本省略推量形' => 3,
                                         'デアル列基本省略推量形' => 6,
                                         'デス列基本推量形' => 7,
                                         'デス列基本省略推量形' => 8,
                                         '基本形' => 2
                                       },
                                       [
                                         '語幹',
                                         '*'
                                       ],
                                       [
                                         '基本形',
                                         'だろう'
                                       ],
                                       [
                                         'ダ列基本省略推量形',
                                         'だろ'
                                       ],
                                       [
                                         'ダ列基本条件形',
                                         'ならば'
                                       ],
                                       [
                                         'デアル列基本推量形',
                                         'であろう'
                                       ],
                                       [
                                         'デアル列基本省略推量形',
                                         'であろ'
                                       ],
                                       [
                                         'デス列基本推量形',
                                         'でしょう'
                                       ],
                                       [
                                         'デス列基本省略推量形',
                                         'でしょ'
                                       ]
                                     ],
          '子音動詞サ行' => [
                                    {
                                      '音便条件形' => 17,
                                      'タ系連用チャ形' => 16,
                                      '未然形' => 3,
                                      '語幹' => 1,
                                      '省略意志形' => 5,
                                      'タ系条件形' => 13,
                                      'タ系省略推量形' => 12,
                                      '基本形' => 2,
                                      '基本条件形' => 7,
                                      'タ系連用タリ形' => 15,
                                      '基本連用形' => 8,
                                      'タ接連用形' => 9,
                                      '意志形' => 4,
                                      'タ形' => 10,
                                      'タ系連用テ形' => 14,
                                      'タ系推量形' => 11,
                                      '命令形' => 6
                                    },
                                    [
                                      '語幹',
                                      '*'
                                    ],
                                    [
                                      '基本形',
                                      'す'
                                    ],
                                    [
                                      '未然形',
                                      'さ'
                                    ],
                                    [
                                      '意志形',
                                      'そう'
                                    ],
                                    [
                                      '省略意志形',
                                      'そ'
                                    ],
                                    [
                                      '命令形',
                                      'せ'
                                    ],
                                    [
                                      '基本条件形',
                                      'せば'
                                    ],
                                    [
                                      '基本連用形',
                                      'し'
                                    ],
                                    [
                                      'タ接連用形',
                                      'し'
                                    ],
                                    [
                                      'タ形',
                                      'した'
                                    ],
                                    [
                                      'タ系推量形',
                                      'したろう'
                                    ],
                                    [
                                      'タ系省略推量形',
                                      'したろ'
                                    ],
                                    [
                                      'タ系条件形',
                                      'したら'
                                    ],
                                    [
                                      'タ系連用テ形',
                                      'して'
                                    ],
                                    [
                                      'タ系連用タリ形',
                                      'したり'
                                    ],
                                    [
                                      'タ系連用チャ形',
                                      'しちゃ'
                                    ],
                                    [
                                      '音便条件形',
                                      'しゃ'
                                    ]
                                  ],
          'ナ形容詞' => [
                              {
                                'デス列基本形' => 30,
                                'デアル列タ形' => 24,
                                'ダ列文語連体形' => 16,
                                'ダ列基本連用形' => 8,
                                'デス列タ系条件形' => 36,
                                'ダ列基本推量形' => 5,
                                'ダ列基本省略推量形' => 6,
                                'デアル列命令形' => 19,
                                'ダ列タ系推量形' => 10,
                                'デス列タ系連用テ形' => 37,
                                'ダ列タ系連用タリ形' => 14,
                                'デス列タ形' => 33,
                                'デアル列タ系省略推量形' => 26,
                                'デス列基本省略推量形' => 32,
                                'デス列タ系省略推量形' => 35,
                                'デアル列基本推量形' => 20,
                                'ダ列タ系連用ジャ形' => 15,
                                'デアル列基本形' => 18,
                                'デアル列基本条件形' => 22,
                                'デアル列タ系連用タリ形' => 29,
                                'ダ列タ系連用テ形' => 13,
                                'ダ列タ系条件形' => 12,
                                'デアル列基本連用形' => 23,
                                '語幹' => 1,
                                'デス列タ系推量形' => 34,
                                'デアル列タ系連用テ形' => 28,
                                'ダ列命令形' => 3,
                                'デアル列基本省略推量形' => 21,
                                '基本形' => 2,
                                'ダ列基本連体形' => 4,
                                'ダ列タ系省略推量形' => 11,
                                'ダ列基本条件形' => 7,
                                'デス列タ系連用タリ形' => 38,
                                'ダ列タ形' => 9,
                                'デアル列タ系条件形' => 27,
                                'ダ列文語条件形' => 17,
                                'デス列基本推量形' => 31,
                                'デアル列タ系推量形' => 25
                              },
                              [
                                '語幹',
                                '*'
                              ],
                              [
                                '基本形',
                                'だ'
                              ],
                              [
                                'ダ列命令形',
                                'なれ'
                              ],
                              [
                                'ダ列基本連体形',
                                'な'
                              ],
                              [
                                'ダ列基本推量形',
                                'だろう'
                              ],
                              [
                                'ダ列基本省略推量形',
                                'だろ'
                              ],
                              [
                                'ダ列基本条件形',
                                'ならば'
                              ],
                              [
                                'ダ列基本連用形',
                                'に'
                              ],
                              [
                                'ダ列タ形',
                                'だった'
                              ],
                              [
                                'ダ列タ系推量形',
                                'だったろう'
                              ],
                              [
                                'ダ列タ系省略推量形',
                                'だったろ'
                              ],
                              [
                                'ダ列タ系条件形',
                                'だったら'
                              ],
                              [
                                'ダ列タ系連用テ形',
                                'で'
                              ],
                              [
                                'ダ列タ系連用タリ形',
                                'だったり'
                              ],
                              [
                                'ダ列タ系連用ジャ形',
                                'じゃ'
                              ],
                              [
                                'ダ列文語連体形',
                                'なる'
                              ],
                              [
                                'ダ列文語条件形',
                                'なれば'
                              ],
                              [
                                'デアル列基本形',
                                'である'
                              ],
                              [
                                'デアル列命令形',
                                'であれ'
                              ],
                              [
                                'デアル列基本推量形',
                                'であろう'
                              ],
                              [
                                'デアル列基本省略推量形',
                                'であろ'
                              ],
                              [
                                'デアル列基本条件形',
                                'であれば'
                              ],
                              [
                                'デアル列基本連用形',
                                'であり'
                              ],
                              [
                                'デアル列タ形',
                                'であった'
                              ],
                              [
                                'デアル列タ系推量形',
                                'であったろう'
                              ],
                              [
                                'デアル列タ系省略推量形',
                                'であったろ'
                              ],
                              [
                                'デアル列タ系条件形',
                                'であったら'
                              ],
                              [
                                'デアル列タ系連用テ形',
                                'であって'
                              ],
                              [
                                'デアル列タ系連用タリ形',
                                'であったり'
                              ],
                              [
                                'デス列基本形',
                                'です'
                              ],
                              [
                                'デス列基本推量形',
                                'でしょう'
                              ],
                              [
                                'デス列基本省略推量形',
                                'でしょ'
                              ],
                              [
                                'デス列タ形',
                                'でした'
                              ],
                              [
                                'デス列タ系推量形',
                                'でしたろう'
                              ],
                              [
                                'デス列タ系省略推量形',
                                'でしたろ'
                              ],
                              [
                                'デス列タ系条件形',
                                'でしたら'
                              ],
                              [
                                'デス列タ系連用テ形',
                                'でして'
                              ],
                              [
                                'デス列タ系連用タリ形',
                                'でしたり'
                              ]
                            ],
          '子音動詞カ行促音便形' => [
                                                {
                                                  '音便条件形' => 17,
                                                  'タ系連用チャ形' => 16,
                                                  '未然形' => 3,
                                                  '語幹' => 1,
                                                  '省略意志形' => 5,
                                                  'タ系条件形' => 13,
                                                  'タ系省略推量形' => 12,
                                                  '基本形' => 2,
                                                  '基本条件形' => 7,
                                                  'タ系連用タリ形' => 15,
                                                  '基本連用形' => 8,
                                                  'タ接連用形' => 9,
                                                  '意志形' => 4,
                                                  'タ形' => 10,
                                                  'タ系連用テ形' => 14,
                                                  'タ系推量形' => 11,
                                                  '命令形' => 6
                                                },
                                                [
                                                  '語幹',
                                                  '*'
                                                ],
                                                [
                                                  '基本形',
                                                  'く'
                                                ],
                                                [
                                                  '未然形',
                                                  'か'
                                                ],
                                                [
                                                  '意志形',
                                                  'こう'
                                                ],
                                                [
                                                  '省略意志形',
                                                  'こ'
                                                ],
                                                [
                                                  '命令形',
                                                  'け'
                                                ],
                                                [
                                                  '基本条件形',
                                                  'けば'
                                                ],
                                                [
                                                  '基本連用形',
                                                  'き'
                                                ],
                                                [
                                                  'タ接連用形',
                                                  'っ'
                                                ],
                                                [
                                                  'タ形',
                                                  'った'
                                                ],
                                                [
                                                  'タ系推量形',
                                                  'ったろう'
                                                ],
                                                [
                                                  'タ系省略推量形',
                                                  'ったろ'
                                                ],
                                                [
                                                  'タ系条件形',
                                                  'ったら'
                                                ],
                                                [
                                                  'タ系連用テ形',
                                                  'って'
                                                ],
                                                [
                                                  'タ系連用タリ形',
                                                  'ったり'
                                                ],
                                                [
                                                  'タ系連用チャ形',
                                                  'っちゃ'
                                                ],
                                                [
                                                  '音便条件形',
                                                  'きゃ'
                                                ]
                                              ],
          'イ形容詞アウオ段' => [
                                          {
                                            '音便条件形２' => 17,
                                            '文語未然形' => 19,
                                            '音便条件形' => 16,
                                            'タ系連用チャ形' => 14,
                                            '語幹' => 1,
                                            '文語連体形' => 21,
                                            '基本推量形' => 4,
                                            'タ系条件形' => 11,
                                            'タ系省略推量形' => 10,
                                            '基本形' => 2,
                                            '基本条件形' => 6,
                                            '基本省略推量形' => 5,
                                            'タ系連用タリ形' => 13,
                                            '基本連用形' => 7,
                                            '文語連用形' => 20,
                                            '文語基本形' => 18,
                                            'タ系連用チャ形２' => 15,
                                            'タ形' => 8,
                                            'タ系連用テ形' => 12,
                                            'タ系推量形' => 9,
                                            '命令形' => 3,
                                            '文語命令形' => 22
                                          },
                                          [
                                            '語幹',
                                            '*'
                                          ],
                                          [
                                            '基本形',
                                            'い'
                                          ],
                                          [
                                            '命令形',
                                            'かれ'
                                          ],
                                          [
                                            '基本推量形',
                                            'かろう'
                                          ],
                                          [
                                            '基本省略推量形',
                                            'かろ'
                                          ],
                                          [
                                            '基本条件形',
                                            'ければ'
                                          ],
                                          [
                                            '基本連用形',
                                            'く'
                                          ],
                                          [
                                            'タ形',
                                            'かった'
                                          ],
                                          [
                                            'タ系推量形',
                                            'かったろう'
                                          ],
                                          [
                                            'タ系省略推量形',
                                            'かったろ'
                                          ],
                                          [
                                            'タ系条件形',
                                            'かったら'
                                          ],
                                          [
                                            'タ系連用テ形',
                                            'くて'
                                          ],
                                          [
                                            'タ系連用タリ形',
                                            'かったり'
                                          ],
                                          [
                                            'タ系連用チャ形',
                                            'くちゃ'
                                          ],
                                          [
                                            'タ系連用チャ形２',
                                            'くっちゃ'
                                          ],
                                          [
                                            '音便条件形',
                                            'けりゃ'
                                          ],
                                          [
                                            '音便条件形２',
                                            'きゃ'
                                          ],
                                          [
                                            '文語基本形',
                                            'し'
                                          ],
                                          [
                                            '文語未然形',
                                            'から'
                                          ],
                                          [
                                            '文語連用形',
                                            'う'
                                          ],
                                          [
                                            '文語連体形',
                                            'き'
                                          ],
                                          [
                                            '文語命令形',
                                            'かれ'
                                          ]
                                        ],
          'ザ変動詞' => [
                              {
                                '文語未然形' => 19,
                                '音便条件形' => 17,
                                'タ系連用チャ形' => 16,
                                '未然形' => 3,
                                '語幹' => 1,
                                '省略意志形' => 5,
                                'タ系条件形' => 13,
                                'タ系省略推量形' => 12,
                                '基本形' => 2,
                                '基本条件形' => 7,
                                'タ系連用タリ形' => 15,
                                '基本連用形' => 8,
                                'タ接連用形' => 9,
                                '文語基本形' => 18,
                                '意志形' => 4,
                                'タ形' => 10,
                                'タ系連用テ形' => 14,
                                'タ系推量形' => 11,
                                '命令形' => 6,
                                '文語命令形' => 20
                              },
                              [
                                '語幹',
                                '*'
                              ],
                              [
                                '基本形',
                                'ずる'
                              ],
                              [
                                '未然形',
                                'ざ'
                              ],
                              [
                                '意志形',
                                'じよう'
                              ],
                              [
                                '省略意志形',
                                'じよ'
                              ],
                              [
                                '命令形',
                                'ぜよ'
                              ],
                              [
                                '基本条件形',
                                'ずれば'
                              ],
                              [
                                '基本連用形',
                                'じ'
                              ],
                              [
                                'タ接連用形',
                                'じ'
                              ],
                              [
                                'タ形',
                                'じた'
                              ],
                              [
                                'タ系推量形',
                                'じたろう'
                              ],
                              [
                                'タ系省略推量形',
                                'じたろ'
                              ],
                              [
                                'タ系条件形',
                                'じたら'
                              ],
                              [
                                'タ系連用テ形',
                                'じて'
                              ],
                              [
                                'タ系連用タリ形',
                                'じたり'
                              ],
                              [
                                'タ系連用チャ形',
                                'じちゃ'
                              ],
                              [
                                '音便条件形',
                                'ずりゃ'
                              ],
                              [
                                '文語基本形',
                                'ず'
                              ],
                              [
                                '文語未然形',
                                'ぜ'
                              ],
                              [
                                '文語命令形',
                                'じろ'
                              ]
                            ],
          '子音動詞ラ行イ形' => [
                                          {
                                            '音便条件形' => 17,
                                            'タ系連用チャ形' => 16,
                                            '未然形' => 3,
                                            '語幹' => 1,
                                            '省略意志形' => 5,
                                            'タ系条件形' => 13,
                                            'タ系省略推量形' => 12,
                                            '基本形' => 2,
                                            '基本条件形' => 7,
                                            'タ系連用タリ形' => 15,
                                            '基本連用形' => 8,
                                            'タ接連用形' => 9,
                                            '意志形' => 4,
                                            'タ形' => 10,
                                            'タ系連用テ形' => 14,
                                            'タ系推量形' => 11,
                                            '命令形' => 6
                                          },
                                          [
                                            '語幹',
                                            '*'
                                          ],
                                          [
                                            '基本形',
                                            'る'
                                          ],
                                          [
                                            '未然形',
                                            'ら'
                                          ],
                                          [
                                            '意志形',
                                            'ろう'
                                          ],
                                          [
                                            '省略意志形',
                                            'ろ'
                                          ],
                                          [
                                            '命令形',
                                            'い'
                                          ],
                                          [
                                            '基本条件形',
                                            'れば'
                                          ],
                                          [
                                            '基本連用形',
                                            'り'
                                          ],
                                          [
                                            'タ接連用形',
                                            'っ'
                                          ],
                                          [
                                            'タ形',
                                            'った'
                                          ],
                                          [
                                            'タ系推量形',
                                            'ったろう'
                                          ],
                                          [
                                            'タ系省略推量形',
                                            'ったろ'
                                          ],
                                          [
                                            'タ系条件形',
                                            'ったら'
                                          ],
                                          [
                                            'タ系連用テ形',
                                            'って'
                                          ],
                                          [
                                            'タ系連用タリ形',
                                            'ったり'
                                          ],
                                          [
                                            'タ系連用チャ形',
                                            'っちゃ'
                                          ],
                                          [
                                            '音便条件形',
                                            'りゃ'
                                          ]
                                        ],
          '助動詞く型' => [
                                 {
                                   '語幹' => 1,
                                   '文語連体形' => 4,
                                   '基本連用形' => 3,
                                   '基本形' => 2
                                 },
                                 [
                                   '語幹',
                                   '*'
                                 ],
                                 [
                                   '基本形',
                                   'し'
                                 ],
                                 [
                                   '基本連用形',
                                   'く'
                                 ],
                                 [
                                   '文語連体形',
                                   'き'
                                 ]
                               ],
          'タル形容詞' => [
                                 {
                                   '語幹' => 1,
                                   '基本連用形' => 3,
                                   '基本形' => 2
                                 },
                                 [
                                   '語幹',
                                   '*'
                                 ],
                                 [
                                   '基本形',
                                   'たる'
                                 ],
                                 [
                                   '基本連用形',
                                   'と'
                                 ]
                               ],
          '子音動詞バ行' => [
                                    {
                                      '音便条件形' => 17,
                                      'タ系連用チャ形' => 16,
                                      '未然形' => 3,
                                      '語幹' => 1,
                                      '省略意志形' => 5,
                                      'タ系条件形' => 13,
                                      'タ系省略推量形' => 12,
                                      '基本形' => 2,
                                      '基本条件形' => 7,
                                      'タ系連用タリ形' => 15,
                                      '基本連用形' => 8,
                                      'タ接連用形' => 9,
                                      '意志形' => 4,
                                      'タ形' => 10,
                                      'タ系連用テ形' => 14,
                                      'タ系推量形' => 11,
                                      '命令形' => 6
                                    },
                                    [
                                      '語幹',
                                      '*'
                                    ],
                                    [
                                      '基本形',
                                      'ぶ'
                                    ],
                                    [
                                      '未然形',
                                      'ば'
                                    ],
                                    [
                                      '意志形',
                                      'ぼう'
                                    ],
                                    [
                                      '省略意志形',
                                      'ぼ'
                                    ],
                                    [
                                      '命令形',
                                      'べ'
                                    ],
                                    [
                                      '基本条件形',
                                      'べば'
                                    ],
                                    [
                                      '基本連用形',
                                      'び'
                                    ],
                                    [
                                      'タ接連用形',
                                      'ん'
                                    ],
                                    [
                                      'タ形',
                                      'んだ'
                                    ],
                                    [
                                      'タ系推量形',
                                      'んだろう'
                                    ],
                                    [
                                      'タ系省略推量形',
                                      'んたろ'
                                    ],
                                    [
                                      'タ系条件形',
                                      'んだら'
                                    ],
                                    [
                                      'タ系連用テ形',
                                      'んで'
                                    ],
                                    [
                                      'タ系連用タリ形',
                                      'んだり'
                                    ],
                                    [
                                      'タ系連用チャ形',
                                      'んじゃ'
                                    ],
                                    [
                                      '音便条件形',
                                      'びゃ'
                                    ]
                                  ],
          '子音動詞ワ行文語音便形' => [
                                                   {
                                                     'タ系連用チャ形' => 16,
                                                     '未然形' => 3,
                                                     '語幹' => 1,
                                                     '省略意志形' => 5,
                                                     'タ系条件形' => 13,
                                                     'タ系省略推量形' => 12,
                                                     '基本形' => 2,
                                                     '基本条件形' => 7,
                                                     'タ系連用タリ形' => 15,
                                                     '基本連用形' => 8,
                                                     'タ接連用形' => 9,
                                                     '意志形' => 4,
                                                     'タ形' => 10,
                                                     'タ系連用テ形' => 14,
                                                     'タ系推量形' => 11,
                                                     '命令形' => 6
                                                   },
                                                   [
                                                     '語幹',
                                                     '*'
                                                   ],
                                                   [
                                                     '基本形',
                                                     'う'
                                                   ],
                                                   [
                                                     '未然形',
                                                     'わ'
                                                   ],
                                                   [
                                                     '意志形',
                                                     'おう'
                                                   ],
                                                   [
                                                     '省略意志形',
                                                     'お'
                                                   ],
                                                   [
                                                     '命令形',
                                                     'え'
                                                   ],
                                                   [
                                                     '基本条件形',
                                                     'えば'
                                                   ],
                                                   [
                                                     '基本連用形',
                                                     'い'
                                                   ],
                                                   [
                                                     'タ接連用形',
                                                     'う'
                                                   ],
                                                   [
                                                     'タ形',
                                                     'うた'
                                                   ],
                                                   [
                                                     'タ系推量形',
                                                     'うたろう'
                                                   ],
                                                   [
                                                     'タ系省略推量形',
                                                     'うたろ'
                                                   ],
                                                   [
                                                     'タ系条件形',
                                                     'うたら'
                                                   ],
                                                   [
                                                     'タ系連用テ形',
                                                     'うて'
                                                   ],
                                                   [
                                                     'タ系連用タリ形',
                                                     'うたり'
                                                   ],
                                                   [
                                                     'タ系連用チャ形',
                                                     'うちゃ'
                                                   ]
                                                 ],
          'イ形容詞イ段' => [
                                    {
                                      '音便条件形２' => 17,
                                      '文語未然形' => 19,
                                      '音便条件形' => 16,
                                      'タ系連用チャ形' => 14,
                                      '語幹' => 1,
                                      '文語連体形' => 21,
                                      '基本推量形' => 4,
                                      'タ系条件形' => 11,
                                      'タ系省略推量形' => 10,
                                      '基本形' => 2,
                                      '基本条件形' => 6,
                                      '基本省略推量形' => 5,
                                      'タ系連用タリ形' => 13,
                                      '基本連用形' => 7,
                                      '文語連用形' => 20,
                                      '文語基本形' => 18,
                                      'タ系連用チャ形２' => 15,
                                      'タ形' => 8,
                                      'タ系連用テ形' => 12,
                                      'タ系推量形' => 9,
                                      '命令形' => 3,
                                      '文語命令形' => 22
                                    },
                                    [
                                      '語幹',
                                      '*'
                                    ],
                                    [
                                      '基本形',
                                      'い'
                                    ],
                                    [
                                      '命令形',
                                      'かれ'
                                    ],
                                    [
                                      '基本推量形',
                                      'かろう'
                                    ],
                                    [
                                      '基本省略推量形',
                                      'かろ'
                                    ],
                                    [
                                      '基本条件形',
                                      'ければ'
                                    ],
                                    [
                                      '基本連用形',
                                      'く'
                                    ],
                                    [
                                      'タ形',
                                      'かった'
                                    ],
                                    [
                                      'タ系推量形',
                                      'かったろう'
                                    ],
                                    [
                                      'タ系省略推量形',
                                      'かったろ'
                                    ],
                                    [
                                      'タ系条件形',
                                      'かったら'
                                    ],
                                    [
                                      'タ系連用テ形',
                                      'くて'
                                    ],
                                    [
                                      'タ系連用タリ形',
                                      'かったり'
                                    ],
                                    [
                                      'タ系連用チャ形',
                                      'くちゃ'
                                    ],
                                    [
                                      'タ系連用チャ形２',
                                      'くっちゃ'
                                    ],
                                    [
                                      '音便条件形',
                                      'けりゃ'
                                    ],
                                    [
                                      '音便条件形２',
                                      'きゃ'
                                    ],
                                    [
                                      '文語基本形',
                                      '*'
                                    ],
                                    [
                                      '文語未然形',
                                      'から'
                                    ],
                                    [
                                      '文語連用形',
                                      'ゅう'
                                    ],
                                    [
                                      '文語連体形',
                                      'き'
                                    ],
                                    [
                                      '文語命令形',
                                      'かれ'
                                    ]
                                  ],
          '子音動詞ワ行' => [
                                    {
                                      'タ系連用チャ形' => 16,
                                      '未然形' => 3,
                                      '語幹' => 1,
                                      '省略意志形' => 5,
                                      'タ系条件形' => 13,
                                      'タ系省略推量形' => 12,
                                      '基本形' => 2,
                                      '基本条件形' => 7,
                                      'タ系連用タリ形' => 15,
                                      '基本連用形' => 8,
                                      'タ接連用形' => 9,
                                      '意志形' => 4,
                                      'タ形' => 10,
                                      'タ系連用テ形' => 14,
                                      'タ系推量形' => 11,
                                      '命令形' => 6
                                    },
                                    [
                                      '語幹',
                                      '*'
                                    ],
                                    [
                                      '基本形',
                                      'う'
                                    ],
                                    [
                                      '未然形',
                                      'わ'
                                    ],
                                    [
                                      '意志形',
                                      'おう'
                                    ],
                                    [
                                      '省略意志形',
                                      'お'
                                    ],
                                    [
                                      '命令形',
                                      'え'
                                    ],
                                    [
                                      '基本条件形',
                                      'えば'
                                    ],
                                    [
                                      '基本連用形',
                                      'い'
                                    ],
                                    [
                                      'タ接連用形',
                                      'っ'
                                    ],
                                    [
                                      'タ形',
                                      'った'
                                    ],
                                    [
                                      'タ系推量形',
                                      'ったろう'
                                    ],
                                    [
                                      'タ系省略推量形',
                                      'ったろ'
                                    ],
                                    [
                                      'タ系条件形',
                                      'ったら'
                                    ],
                                    [
                                      'タ系連用テ形',
                                      'って'
                                    ],
                                    [
                                      'タ系連用タリ形',
                                      'ったり'
                                    ],
                                    [
                                      'タ系連用チャ形',
                                      'っちゃ'
                                    ]
                                  ],
          'カ変動詞来' => [
                                 {
                                   '音便条件形' => 17,
                                   'タ系連用チャ形' => 16,
                                   '未然形' => 3,
                                   '語幹' => 1,
                                   '省略意志形' => 5,
                                   'タ系条件形' => 13,
                                   'タ系省略推量形' => 12,
                                   '基本形' => 2,
                                   '基本条件形' => 7,
                                   'タ系連用タリ形' => 15,
                                   '基本連用形' => 8,
                                   'タ接連用形' => 9,
                                   '意志形' => 4,
                                   'タ形' => 10,
                                   'タ系連用テ形' => 14,
                                   'タ系推量形' => 11,
                                   '命令形' => 6
                                 },
                                 [
                                   '語幹',
                                   '*',
                                   '*'
                                 ],
                                 [
                                   '基本形',
                                   '来る',
                                   'くる'
                                 ],
                                 [
                                   '未然形',
                                   '来',
                                   'こ'
                                 ],
                                 [
                                   '意志形',
                                   '来よう',
                                   'こよう'
                                 ],
                                 [
                                   '省略意志形',
                                   '来よ',
                                   'こよ'
                                 ],
                                 [
                                   '命令形',
                                   '来い',
                                   'こい'
                                 ],
                                 [
                                   '基本条件形',
                                   '来れば',
                                   'くれば'
                                 ],
                                 [
                                   '基本連用形',
                                   '来',
                                   'き'
                                 ],
                                 [
                                   'タ接連用形',
                                   '来',
                                   'き'
                                 ],
                                 [
                                   'タ形',
                                   '来た',
                                   'きた'
                                 ],
                                 [
                                   'タ系推量形',
                                   '来たろう',
                                   'きたろう'
                                 ],
                                 [
                                   'タ系省略推量形',
                                   '来たろ',
                                   'きたろ'
                                 ],
                                 [
                                   'タ系条件形',
                                   '来たら',
                                   'きたら'
                                 ],
                                 [
                                   'タ系連用テ形',
                                   '来て',
                                   'きて'
                                 ],
                                 [
                                   'タ系連用タリ形',
                                   '来たり',
                                   'きたり'
                                 ],
                                 [
                                   'タ系連用チャ形',
                                   '来ちゃ',
                                   'きちゃ'
                                 ],
                                 [
                                   '音便条件形',
                                   '来りゃ',
                                   'くりゃ'
                                 ]
                               ],
          'ナ形容詞特殊' => [
                                    {
                                      'デス列基本形' => 32,
                                      'デアル列タ形' => 26,
                                      'ダ列文語連体形' => 18,
                                      'ダ列基本連用形' => 9,
                                      'デス列タ系条件形' => 38,
                                      'ダ列基本推量形' => 6,
                                      'ダ列基本省略推量形' => 7,
                                      'デアル列命令形' => 21,
                                      'ダ列特殊連体形' => 5,
                                      'ダ列タ系推量形' => 12,
                                      'デス列タ系連用テ形' => 39,
                                      'ダ列タ系連用タリ形' => 16,
                                      'デス列タ形' => 35,
                                      'デアル列タ系省略推量形' => 28,
                                      'ダ列特殊連用形' => 10,
                                      'デス列基本省略推量形' => 34,
                                      'デス列タ系省略推量形' => 37,
                                      'デアル列基本推量形' => 22,
                                      'ダ列タ系連用ジャ形' => 17,
                                      'デアル列基本形' => 20,
                                      'デアル列基本条件形' => 24,
                                      'デアル列タ系連用タリ形' => 31,
                                      'ダ列タ系連用テ形' => 15,
                                      'ダ列タ系条件形' => 14,
                                      'デアル列基本連用形' => 25,
                                      '語幹' => 1,
                                      'デス列タ系推量形' => 36,
                                      'デアル列タ系連用テ形' => 30,
                                      'ダ列命令形' => 3,
                                      'デアル列基本省略推量形' => 23,
                                      '基本形' => 2,
                                      'ダ列基本連体形' => 4,
                                      'ダ列タ系省略推量形' => 13,
                                      'ダ列基本条件形' => 8,
                                      'デス列タ系連用タリ形' => 40,
                                      'ダ列タ形' => 11,
                                      'デアル列タ系条件形' => 29,
                                      'ダ列文語条件形' => 19,
                                      'デス列基本推量形' => 33,
                                      'デアル列タ系推量形' => 27
                                    },
                                    [
                                      '語幹',
                                      '*'
                                    ],
                                    [
                                      '基本形',
                                      'だ'
                                    ],
                                    [
                                      'ダ列命令形',
                                      'なれ'
                                    ],
                                    [
                                      'ダ列基本連体形',
                                      'な'
                                    ],
                                    [
                                      'ダ列特殊連体形',
                                      '*'
                                    ],
                                    [
                                      'ダ列基本推量形',
                                      'だろう'
                                    ],
                                    [
                                      'ダ列基本省略推量形',
                                      'だろ'
                                    ],
                                    [
                                      'ダ列基本条件形',
                                      'ならば'
                                    ],
                                    [
                                      'ダ列基本連用形',
                                      'に'
                                    ],
                                    [
                                      'ダ列特殊連用形',
                                      'く'
                                    ],
                                    [
                                      'ダ列タ形',
                                      'だった'
                                    ],
                                    [
                                      'ダ列タ系推量形',
                                      'だったろう'
                                    ],
                                    [
                                      'ダ列タ系省略推量形',
                                      'だったろ'
                                    ],
                                    [
                                      'ダ列タ系条件形',
                                      'だったら'
                                    ],
                                    [
                                      'ダ列タ系連用テ形',
                                      'で'
                                    ],
                                    [
                                      'ダ列タ系連用タリ形',
                                      'だったり'
                                    ],
                                    [
                                      'ダ列タ系連用ジャ形',
                                      'じゃ'
                                    ],
                                    [
                                      'ダ列文語連体形',
                                      'なる'
                                    ],
                                    [
                                      'ダ列文語条件形',
                                      'なれば'
                                    ],
                                    [
                                      'デアル列基本形',
                                      'である'
                                    ],
                                    [
                                      'デアル列命令形',
                                      'であれ'
                                    ],
                                    [
                                      'デアル列基本推量形',
                                      'であろう'
                                    ],
                                    [
                                      'デアル列基本省略推量形',
                                      'であろ'
                                    ],
                                    [
                                      'デアル列基本条件形',
                                      'であれば'
                                    ],
                                    [
                                      'デアル列基本連用形',
                                      'であり'
                                    ],
                                    [
                                      'デアル列タ形',
                                      'であった'
                                    ],
                                    [
                                      'デアル列タ系推量形',
                                      'であったろう'
                                    ],
                                    [
                                      'デアル列タ系省略推量形',
                                      'であったろ'
                                    ],
                                    [
                                      'デアル列タ系条件形',
                                      'であったら'
                                    ],
                                    [
                                      'デアル列タ系連用テ形',
                                      'であって'
                                    ],
                                    [
                                      'デアル列タ系連用タリ形',
                                      'であったり'
                                    ],
                                    [
                                      'デス列基本形',
                                      'です'
                                    ],
                                    [
                                      'デス列基本推量形',
                                      'でしょう'
                                    ],
                                    [
                                      'デス列基本省略推量形',
                                      'でしょ'
                                    ],
                                    [
                                      'デス列タ形',
                                      'でした'
                                    ],
                                    [
                                      'デス列タ系推量形',
                                      'でしたろう'
                                    ],
                                    [
                                      'デス列タ系省略推量形',
                                      'でしたろ'
                                    ],
                                    [
                                      'デス列タ系条件形',
                                      'でしたら'
                                    ],
                                    [
                                      'デス列タ系連用テ形',
                                      'でして'
                                    ],
                                    [
                                      'デス列タ系連用タリ形',
                                      'でしたり'
                                    ]
                                  ],
          '動詞性接尾辞ます型' => [
                                             {
                                               'タ系連用タリ形' => 10,
                                               '未然形' => 3,
                                               '意志形' => 4,
                                               '語幹' => 1,
                                               'タ形' => 7,
                                               'タ系連用テ形' => 9,
                                               '省略意志形' => 5,
                                               '命令形' => 6,
                                               'タ系条件形' => 8,
                                               '基本形' => 2
                                             },
                                             [
                                               '語幹',
                                               '*'
                                             ],
                                             [
                                               '基本形',
                                               'ます'
                                             ],
                                             [
                                               '未然形',
                                               'ませ'
                                             ],
                                             [
                                               '意志形',
                                               'ましょう'
                                             ],
                                             [
                                               '省略意志形',
                                               'ましょ'
                                             ],
                                             [
                                               '命令形',
                                               'ませ'
                                             ],
                                             [
                                               'タ形',
                                               'ました'
                                             ],
                                             [
                                               'タ系条件形',
                                               'ましたら'
                                             ],
                                             [
                                               'タ系連用テ形',
                                               'まして'
                                             ],
                                             [
                                               'タ系連用タリ形',
                                               'ましたり'
                                             ]
                                           ],
          'サ変動詞' => [
                              {
                                '文語未然形' => 19,
                                '音便条件形' => 17,
                                'タ系連用チャ形' => 16,
                                '未然形' => 3,
                                '語幹' => 1,
                                '省略意志形' => 5,
                                'タ系条件形' => 13,
                                'タ系省略推量形' => 12,
                                '基本形' => 2,
                                '基本条件形' => 7,
                                'タ系連用タリ形' => 15,
                                '基本連用形' => 8,
                                'タ接連用形' => 9,
                                '文語基本形' => 18,
                                '意志形' => 4,
                                'タ形' => 10,
                                'タ系連用テ形' => 14,
                                'タ系推量形' => 11,
                                '命令形' => 6,
                                '文語命令形' => 20
                              },
                              [
                                '語幹',
                                '*'
                              ],
                              [
                                '基本形',
                                'する'
                              ],
                              [
                                '未然形',
                                'さ'
                              ],
                              [
                                '意志形',
                                'しよう'
                              ],
                              [
                                '省略意志形',
                                'しよ'
                              ],
                              [
                                '命令形',
                                'しろ'
                              ],
                              [
                                '基本条件形',
                                'すれば'
                              ],
                              [
                                '基本連用形',
                                'し'
                              ],
                              [
                                'タ接連用形',
                                'し'
                              ],
                              [
                                'タ形',
                                'した'
                              ],
                              [
                                'タ系推量形',
                                'したろう'
                              ],
                              [
                                'タ系省略推量形',
                                'したろ'
                              ],
                              [
                                'タ系条件形',
                                'したら'
                              ],
                              [
                                'タ系連用テ形',
                                'して'
                              ],
                              [
                                'タ系連用タリ形',
                                'したり'
                              ],
                              [
                                'タ系連用チャ形',
                                'しちゃ'
                              ],
                              [
                                '音便条件形',
                                'すりゃ'
                              ],
                              [
                                '文語基本形',
                                'す'
                              ],
                              [
                                '文語未然形',
                                'せ'
                              ],
                              [
                                '文語命令形',
                                'せよ'
                              ]
                            ],
          '子音動詞ラ行' => [
                                    {
                                      '音便条件形' => 17,
                                      'タ系連用チャ形' => 16,
                                      '未然形' => 3,
                                      '語幹' => 1,
                                      '省略意志形' => 5,
                                      'タ系条件形' => 13,
                                      'タ系省略推量形' => 12,
                                      '基本形' => 2,
                                      '基本条件形' => 7,
                                      'タ系連用タリ形' => 15,
                                      '基本連用形' => 8,
                                      'タ接連用形' => 9,
                                      '意志形' => 4,
                                      'タ形' => 10,
                                      'タ系連用テ形' => 14,
                                      'タ系推量形' => 11,
                                      '命令形' => 6
                                    },
                                    [
                                      '語幹',
                                      '*'
                                    ],
                                    [
                                      '基本形',
                                      'る'
                                    ],
                                    [
                                      '未然形',
                                      'ら'
                                    ],
                                    [
                                      '意志形',
                                      'ろう'
                                    ],
                                    [
                                      '省略意志形',
                                      'ろ'
                                    ],
                                    [
                                      '命令形',
                                      'れ'
                                    ],
                                    [
                                      '基本条件形',
                                      'れば'
                                    ],
                                    [
                                      '基本連用形',
                                      'り'
                                    ],
                                    [
                                      'タ接連用形',
                                      'っ'
                                    ],
                                    [
                                      'タ形',
                                      'った'
                                    ],
                                    [
                                      'タ系推量形',
                                      'ったろう'
                                    ],
                                    [
                                      'タ系省略推量形',
                                      'ったろ'
                                    ],
                                    [
                                      'タ系条件形',
                                      'ったら'
                                    ],
                                    [
                                      'タ系連用テ形',
                                      'って'
                                    ],
                                    [
                                      'タ系連用タリ形',
                                      'ったり'
                                    ],
                                    [
                                      'タ系連用チャ形',
                                      'っちゃ'
                                    ],
                                    [
                                      '音便条件形',
                                      'りゃ'
                                    ]
                                  ],
          '子音動詞マ行' => [
                                    {
                                      '音便条件形' => 17,
                                      'タ系連用チャ形' => 16,
                                      '未然形' => 3,
                                      '語幹' => 1,
                                      '省略意志形' => 5,
                                      'タ系条件形' => 13,
                                      'タ系省略推量形' => 12,
                                      '基本形' => 2,
                                      '基本条件形' => 7,
                                      'タ系連用タリ形' => 15,
                                      '基本連用形' => 8,
                                      'タ接連用形' => 9,
                                      '意志形' => 4,
                                      'タ形' => 10,
                                      'タ系連用テ形' => 14,
                                      'タ系推量形' => 11,
                                      '命令形' => 6
                                    },
                                    [
                                      '語幹',
                                      '*'
                                    ],
                                    [
                                      '基本形',
                                      'む'
                                    ],
                                    [
                                      '未然形',
                                      'ま'
                                    ],
                                    [
                                      '意志形',
                                      'もう'
                                    ],
                                    [
                                      '省略意志形',
                                      'も'
                                    ],
                                    [
                                      '命令形',
                                      'め'
                                    ],
                                    [
                                      '基本条件形',
                                      'めば'
                                    ],
                                    [
                                      '基本連用形',
                                      'み'
                                    ],
                                    [
                                      'タ接連用形',
                                      'ん'
                                    ],
                                    [
                                      'タ形',
                                      'んだ'
                                    ],
                                    [
                                      'タ系推量形',
                                      'んだろう'
                                    ],
                                    [
                                      'タ系省略推量形',
                                      'んたろ'
                                    ],
                                    [
                                      'タ系条件形',
                                      'んだら'
                                    ],
                                    [
                                      'タ系連用テ形',
                                      'んで'
                                    ],
                                    [
                                      'タ系連用タリ形',
                                      'んだり'
                                    ],
                                    [
                                      'タ系連用チャ形',
                                      'んじゃ'
                                    ],
                                    [
                                      '音便条件形',
                                      'みゃ'
                                    ]
                                  ],
          '母音動詞' => [
                              {
                                '音便条件形' => 17,
                                'タ系連用チャ形' => 16,
                                '未然形' => 3,
                                '語幹' => 1,
                                '省略意志形' => 5,
                                'タ系条件形' => 13,
                                'タ系省略推量形' => 12,
                                '基本形' => 2,
                                '基本条件形' => 7,
                                'タ系連用タリ形' => 15,
                                '基本連用形' => 8,
                                'タ接連用形' => 9,
                                '意志形' => 4,
                                'タ形' => 10,
                                'タ系連用テ形' => 14,
                                'タ系推量形' => 11,
                                '命令形' => 6,
                                '文語命令形' => 18
                              },
                              [
                                '語幹',
                                '*'
                              ],
                              [
                                '基本形',
                                'る'
                              ],
                              [
                                '未然形',
                                '*'
                              ],
                              [
                                '意志形',
                                'よう'
                              ],
                              [
                                '省略意志形',
                                'よ'
                              ],
                              [
                                '命令形',
                                'ろ'
                              ],
                              [
                                '基本条件形',
                                'れば'
                              ],
                              [
                                '基本連用形',
                                '*'
                              ],
                              [
                                'タ接連用形',
                                '*'
                              ],
                              [
                                'タ形',
                                'た'
                              ],
                              [
                                'タ系推量形',
                                'たろう'
                              ],
                              [
                                'タ系省略推量形',
                                'たろ'
                              ],
                              [
                                'タ系条件形',
                                'たら'
                              ],
                              [
                                'タ系連用テ形',
                                'て'
                              ],
                              [
                                'タ系連用タリ形',
                                'たり'
                              ],
                              [
                                'タ系連用チャ形',
                                'ちゃ'
                              ],
                              [
                                '音便条件形',
                                'りゃ'
                              ],
                              [
                                '文語命令形',
                                'よ'
                              ]
                            ]
        };

1;

=head1 MEMO

This module is generated
from F</usr/local/share/juman/dic/JUMAN.grammar>
and F</usr/local/share/juman/dic/JUMAN.katuyou>
with F<mkgrammarpm>
at Sat Sep 24 01:55:36 2011.

=cut
