% KEYRINGER(1) Keyringer User Manual
% Silvio Rhatto <rhatto@riseup.net>
% Oct 25, 2013

# NAME

keyringer - encrypted and distributed secret sharing software

# SYNOPSIS

keyringer <*keyring*> <*action*> [*options*]...

# DESCRIPTION

Keyringer lets you manage and share secrets using GnuPG and Git in a
distributed fashion.

It has custom commands to create key-pairs and to encrypt, decrypt and
re-encrypt secrets. It also supports encryption to multiple recipients
and groups of recipients, to allow a workgroup to share access to a single
repository while restricting some secrets to subsets of the group.

Secrets are encrypted using OpenPGP and added to a Git tree so that they
can be synced with remote branches later.

# ACTIONS

Keyringer has three types of actions:

1. Repository lookup and manipulation actions, which handle repository initialization,
   content tracking and navigation.

2. Secret manipulation actions, which take care of encrypting, decrypting and other
   read/write operations on secrets.

3. Configuration actions, handling repository metadata.

# REPOSITORY LOOKUP AND MANIPULATION ACTIONS

find <*expression*>
:   Find secrets in the repository.

init <*path*> [*remote*]
:   Initialize a new keyringer repository. If a *remote* URL is specified, keyringer will
    clone an existing repository.

    After initialization, *path* will contain a folder structure for storing secrets
    and metadata (user aka recipients, groups of recipients, etc).

    Also, an entry will be added to `$HOME/.keyringer/config` allowing keyringer to
    find the keyring by its alias.

destroy
:   Alias for *teardown* action.

git <*action*> <*options*>
:   Git wrapper that operates from the toplevel keyring repository. You can issue any
    *GIT(1)* subcommand with this action to have it applied in the keyring repository.

commit [*arguments*]
:   Alias to "git commit".

ls <*path*>
:   List contents from the toplevel repository *keys* folder or from relative paths
    if *path* is specified. Like the git wrapper, this is a wrapper around the *LS(1)*
    command.

mkdir <*path*>
:   Create a directory inside the repository *keys* folder.

rmdir <*path*>
:   Remove an empty folder inside the repository *keys* folder.

tree <*path*>
:   List contents from the toplevel repository *keys* folder or from relative paths
    if *path* is specified using a tree-like format. Like the ls wrapper, this is a
    wrapper around the *TREE(1)* command.

shell
:   Run keyringer on interactive mode from a built-in command-line prompt where
    all other actions can be called and are operated from the current selected
    keyring.

    An additional "cd" internal command is available for directory navigation.

    All <*secret*> parameters from actions invoked from the shell are called
    relatively from the current selected directory.

teardown
:   Remove permanently a local copy of a repository, very dangerous if you
    have just a single copy.

check
:   Run maintenance checks in a keyring.

# SECRET MANIPULATION ACTIONS

All secret manipulation actions operate upon a *secret* which is the pathname
of an encrypted file relative to the keyring with optional `.asc` extension.

If the `.asc` extension is omitted, keyringer will add it at the end of the
pathname.

No spaces are allowed in the secret name.

Secret manipulation actions do not commit changes into the secret repository.
Instead, the user has to manually commit the changes using the git wrapper
action.

append <*secret*>
:   Append contents into a secret by decrypting the secret, appending lines read
    from the standard input and encrypting again.

append-batch <*secret*>
:   Append contents into a secret, batch mode.

decrypt <*secret*>
:   Decrypts a secret into standard output.

del <*secret*>
:   Removes a secret using Git. After deleting a secret a git commit and push is still
    needed to update remote repositories.

    Please note that this command **does not remove the secret from the Git history.**
    To completely remove a file from a keyring, you should also rewrite the Git
    history yourself.

delete <*secret*>
:   Alias for *del* action.

rm <*secret*>
:   Alias for *del* action.

cp <*secret*> <*dest*>
:   Copy a secret.

mv <*secret*> <*dest*>
:   Rename a secret.

edit <*secret*>
:   Edit a secret by temporarily decrypting it, opening the decrypted copy into the
    text editor defined by the *$EDITOR* environment variable and then re-encrypting it.

    Please make sure to use an *$EDITOR* which does not leak data like history buffers.
    Keyringer tries to detect if *$EDITOR* is set to VIM and disables the *.viminfo* file.

encrypt <*secret*> [*file*]
:   Encrypts content from standard input or *file* into *secret* pathname. No spaces
    are supported in the *secret* name. If *file* is actually a folder, keyringer
    will recursivelly encrypt all it's contents.

encrypt-batch <*secret*> [*file*]
:   Encrypt content, batch mode. Behavior is identical to *encrypt* action, but less
    verbose. Useful inside scripts.

genkeys <*ssh*|*gpg*|*x509*|*x509-self*|*ssl*|*ssl-self*> [*options*]
:   Wrapper to generate encryption key-pairs, useful for automated key deployment.

genpair <*ssh*|*gpg*|*x509*|*x509-self*|*ssl*|*ssl-self*> [*options*]
:   Alias for *genkeys* action.

open <*secret*>
:   Decrypt a secret into a temporary folder and open it using xdg-open, which
    tries to figure out the file type and then calls the associated application.

    After the application exits, keyringer encrypts the temporary decrypted file
    again into the secret file and deletes the temporary file.

pwgen <*secret*> [*size*]
:    Generates a random passphrase and stores into *secret* pathname with optional
     entropy size in bytes. Default size is 20.

     Passphrases will be slightly bigger than size due to base64 conversion.

     With this action you can generate and store a passphrase without need to see
     it. Combined with clip or sclip action provides an hygienic way to handle
     secrets.

recrypt <*secret*>
:   Re-encrypts a secret by decrypting it and encrypting it again. Useful when users are added
    into the recipient configuration. If no *secret* is given, all secrets in the repository
    are re-encrypted.

clip <*secret*>
:   Copy the first line of a secret to the clipboard, following password-store convention.

xclip <*secret*>
:   Alias to clip action.

sclip <*secret*>
:   Same as clip action, but sleeps five seconds, overwrite clipboard and exit. If xdotool
    is available, it also switches to the next window using the alt+Tab shortcut. This action
    is useful to be invoked by a custom key combo in a window manager so it becomes easy to
    provide keyringer managed passphrases to other applications such as a web browser.

# CONFIGURATION ACTIONS

commands
:   List available actions, useful for shell completion and syntax check.

options <*ls*|*edit*|*add*>
:   List, edit or add miscellaneous *repository* options.

    Repository options are settings which are saved in the repository as a *global*
    configuration stanza for a given keyring, shared by all users with access to
    the repository.

    Options are written using the *KEY=VALUE* syntax. All lines starting with the
    hash (#) character are interpreted as comments.

preferences <*ls*|*edit*|*add*>
:   List, edit or add *user* preferences for a given repository.

    User preferences are settings which are saved in the user's keyringer folder
    (`$HOME/.keyringer/`), and not shared with the other users.

    Preferences are written using the *KEY=VALUE* syntax. All lines starting with the
    hash (#) character are interpreted as comments.

usage
:   Show keyringer usage information.

help
:   Alias for usage action.

recipients <*ls*|*edit*> <*recipients-file*>
:   List, create or edit recipients configuration.

    Recipients files are lists of OpenPGP public key fingerprints which are used
    by keyringer when encrypting secrets and associated with email aliases.

    Keyringer uses a default recipients file, but specifying a custom *recipients-file*
    pathname will override this default.

    For instance, if a user encrypts a secret to a file in the keyring repository's
    *accounting* folder, a *recipients-file* under *accounting* will be used.
    Encrypting a secret into *accounting/bank-accounts* will result in a file
    `$KEYRING_FOLDER/keys/accounting/bank-accounts.asc` encrypted using the public
    keys listed in the config file`$KEYRING_FOLDER/config/recipients/accounting`.

    Each line in a recipients file has entries in the format
    'john@doe.com XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX', where *john@doe.com*
    is an alias for the OpenPGP public key whose fingerprint is
    *XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX.*

    All lines starting with the hash (#) character are interpreted as comments.

    Parameters to the *recipients* action are:

      *ls*
      :   List all existing recipients files.

      *edit*
      :   Create or edit a recipients file.

          Editing happens using the editor specified by the `$EDITOR`
          environment variable.

          The required parameter *recipients-file* is interpreted relative
          to the `$KEYRING_FOLDER/config/recipients/` folder.

# FILES

$HOME/.keyringer/config
:  User's main configuration file used to map alias names to keyrings.

$HOME/.keyringer/*keyring*
:  User preferences for the keyringer aliased *keyring* keyring.

$KEYRING_FOLDER/config/options
:  Custom keyring options which will be applied for all users that use
   the keyringer repository.

# LIMITATIONS

Keyringer currently has the following limitations:

1. Metadata is not encrypted, meaning that an attacker with access to a keyringer
   repository can discover all public key IDs used for encryption, and which secrets
   are encrypted to which keys. This can be improved in the future by encrypting
   the repository configuration with support for the *--hidden-recipient* GnuPG
   option and encrypted repository options.

   To mitigate that, it's possible to keep the repo just atop of an encrypted and
   non-public place.

2. History is not rewritten by default when secrets are removed from a keyringer
   repository. After a secret is removed with the *del* action, it will still be
   available in the repository history even after a commit. This is by design
   for the following reasons:

  - It's the default behavior of the Git content tracker. Forcing the
    deletion by default could break the expected behavior and hence limit
    the repository's backup features, which can be helpful if someone
    mistakenly overwrites a secret.

  - History rewriting cannot be considered a security measure against the
    unauthorized access to a secret as it doesn't automatically update all
    working copies of the repository.

    In the case that the secret is a passphrase, the recommended measure
    against such attacks is to change the passphrase, making useless the
    knowledge of the previous secret.

    Users wishing to edit their repository history should proceed manually
    using the *git* action.

3. Keyringer does not protect data which were not encrypted to a keyring,
   so be careful when decrypting secrets and writing them to the disk or
   other storage media.

   Pay special attention that keyringer outputs data to stdout, which could
   be easily spotted by any agent looking directly at you computer screen.

   The xclip action even copies secret data to the X11 clipboard, which can
   be accessed by any application running in the user's X11 session, so use
   this feature carefully.

# SEE ALSO

The *README* file distributed with Keyringer contains full documentation.

The Keyringer source code and all documentation may be downloaded from
<https://keyringer.pw>.
