; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=memcpyopt -S < %s -verify-memoryssa | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64"
target triple = "x86_64-apple-macosx10.7.0"

@x = global i32 0

declare void @otherf(ptr)

declare void @llvm.memset.p0.i64(ptr nocapture, i8, i64, i1) nounwind

; memcpyopt should not touch atomic ops
define void @test1() nounwind uwtable ssp {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[X:%.*]] = alloca [101 x i32], align 16
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 16 [[X]], i8 0, i64 400, i1 false)
; CHECK-NEXT:    [[GEP1:%.*]] = getelementptr inbounds [101 x i32], ptr [[X]], i32 0, i32 100
; CHECK-NEXT:    store atomic i32 0, ptr [[GEP1]] unordered, align 4
; CHECK-NEXT:    call void @otherf(ptr [[X]])
; CHECK-NEXT:    ret void
;
  %x = alloca [101 x i32], align 16
  call void @llvm.memset.p0.i64(ptr align 16 %x, i8 0, i64 400, i1 false)
  %gep1 = getelementptr inbounds [101 x i32], ptr %x, i32 0, i32 100
  store atomic i32 0, ptr %gep1 unordered, align 4
  call void @otherf(ptr %x)
  ret void
}

; memcpyopt across unordered store
define void @test2() nounwind uwtable ssp {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[OLD:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[NEW:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @otherf(ptr nocapture [[NEW]])
; CHECK-NEXT:    store atomic i32 0, ptr @x unordered, align 4
; CHECK-NEXT:    call void @otherf(ptr nocapture [[NEW]])
; CHECK-NEXT:    ret void
;
  %old = alloca i32
  %new = alloca i32
  call void @otherf(ptr nocapture %old)
  store atomic i32 0, ptr @x unordered, align 4
  %v = load i32, ptr %old
  store i32 %v, ptr %new
  call void @otherf(ptr nocapture %new)
  ret void
}

