// RUN: llvm-mc -triple x86_64-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: vaddpd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x58,0x5c,0x82,0x40]      
vaddpd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vaddpd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x58,0x5c,0x82,0xc0]      
vaddpd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vaddpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x58,0x5c,0x82,0x40]     
vaddpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x58,0x5c,0x82,0xc0]     
vaddpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x58,0x5c,0x82,0x40]    
vaddpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x58,0x5c,0x82,0xc0]    
vaddpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x58,0x5c,0x02,0x40]      
vaddpd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vaddpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x58,0x5c,0x02,0x40]     
vaddpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x58,0x5c,0x02,0x40]    
vaddpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x58,0x5a,0x40]      
vaddpd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vaddpd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x58,0x5a,0x40]     
vaddpd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x58,0x5a,0x40]    
vaddpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vaddpd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vaddpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vaddpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vaddpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vaddpd 485498096, %zmm19, %zmm19 

// CHECK: vaddpd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vaddpd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vaddpd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x58,0x5a,0x40]      
vaddpd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vaddpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x58,0x5a,0x40]     
vaddpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x58,0x5a,0x40]    
vaddpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x58,0x5c,0x02,0x40]      
vaddpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vaddpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x58,0x5c,0x02,0x40]     
vaddpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x58,0x5c,0x02,0x40]    
vaddpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x58,0x5c,0x82,0x40]      
vaddpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vaddpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x58,0x5c,0x82,0xc0]      
vaddpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vaddpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x58,0x5c,0x82,0x40]     
vaddpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x58,0x5c,0x82,0xc0]     
vaddpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x58,0x5c,0x82,0x40]    
vaddpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x58,0x5c,0x82,0xc0]    
vaddpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x30,0x58,0xdb]     
vaddpd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vaddpd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x32,0x58,0xdb]    
vaddpd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xb2,0x58,0xdb]   
vaddpd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x58,0x1a]      
vaddpd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vaddpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x58,0x1a]     
vaddpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x58,0x1a]    
vaddpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x58,0x1a]      
vaddpd (%rdx), %zmm19, %zmm19 

// CHECK: vaddpd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x58,0x1a]     
vaddpd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x58,0x1a]    
vaddpd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x10,0x58,0xdb]     
vaddpd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vaddpd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x12,0x58,0xdb]    
vaddpd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x92,0x58,0xdb]   
vaddpd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x50,0x58,0xdb]     
vaddpd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vaddpd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x52,0x58,0xdb]    
vaddpd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xd2,0x58,0xdb]   
vaddpd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x70,0x58,0xdb]     
vaddpd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vaddpd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x72,0x58,0xdb]    
vaddpd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xf2,0x58,0xdb]   
vaddpd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddpd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x40,0x58,0xdb]      
vaddpd %zmm19, %zmm19, %zmm19 

// CHECK: vaddpd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x42,0x58,0xdb]     
vaddpd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vaddpd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xc2,0x58,0xdb]    
vaddpd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x58,0x5a,0x40]      
vaddps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vaddps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x58,0x5a,0x40]     
vaddps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vaddps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x58,0x5a,0x40]    
vaddps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x58,0x5c,0x02,0x40]      
vaddps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vaddps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x58,0x5c,0x02,0x40]     
vaddps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vaddps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x58,0x5c,0x02,0x40]    
vaddps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x58,0x5c,0x82,0x40]      
vaddps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vaddps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x58,0x5c,0x82,0xc0]      
vaddps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vaddps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x58,0x5c,0x82,0x40]     
vaddps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vaddps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x58,0x5c,0x82,0xc0]     
vaddps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vaddps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x58,0x5c,0x82,0x40]    
vaddps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x58,0x5c,0x82,0xc0]    
vaddps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x58,0x5c,0x82,0x40]      
vaddps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vaddps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x58,0x5c,0x82,0xc0]      
vaddps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vaddps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x58,0x5c,0x82,0x40]     
vaddps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vaddps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x58,0x5c,0x82,0xc0]     
vaddps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vaddps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x58,0x5c,0x82,0x40]    
vaddps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x58,0x5c,0x82,0xc0]    
vaddps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x58,0x5c,0x02,0x40]      
vaddps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vaddps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x58,0x5c,0x02,0x40]     
vaddps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vaddps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x58,0x5c,0x02,0x40]    
vaddps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x58,0x5a,0x40]      
vaddps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vaddps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x58,0x5a,0x40]     
vaddps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vaddps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x58,0x5a,0x40]    
vaddps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vaddps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vaddps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vaddps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vaddps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vaddps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vaddps 485498096, %zmm19, %zmm19 

// CHECK: vaddps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vaddps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vaddps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vaddps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x30,0x58,0xdb]     
vaddps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vaddps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x32,0x58,0xdb]    
vaddps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vaddps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xb2,0x58,0xdb]   
vaddps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x58,0x1a]      
vaddps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vaddps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x58,0x1a]     
vaddps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vaddps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x58,0x1a]    
vaddps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x58,0x1a]      
vaddps (%rdx), %zmm19, %zmm19 

// CHECK: vaddps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x58,0x1a]     
vaddps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vaddps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x58,0x1a]    
vaddps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x10,0x58,0xdb]     
vaddps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vaddps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x12,0x58,0xdb]    
vaddps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vaddps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0x92,0x58,0xdb]   
vaddps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x50,0x58,0xdb]     
vaddps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vaddps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x52,0x58,0xdb]    
vaddps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vaddps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xd2,0x58,0xdb]   
vaddps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x70,0x58,0xdb]     
vaddps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vaddps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x72,0x58,0xdb]    
vaddps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vaddps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xf2,0x58,0xdb]   
vaddps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vaddps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x40,0x58,0xdb]      
vaddps %zmm19, %zmm19, %zmm19 

// CHECK: vaddps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x42,0x58,0xdb]     
vaddps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vaddps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xc2,0x58,0xdb]    
vaddps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x50,0x03,0x5a,0x40,0x00]     
valignd $0, 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: valignd $0, 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x52,0x03,0x5a,0x40,0x00]    
valignd $0, 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xd2,0x03,0x5a,0x40,0x00]   
valignd $0, 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x50,0x03,0x5c,0x02,0x40,0x00]     
valignd $0, 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: valignd $0, 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x52,0x03,0x5c,0x02,0x40,0x00]    
valignd $0, 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xd2,0x03,0x5c,0x02,0x40,0x00]   
valignd $0, 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x50,0x03,0x5c,0x82,0x40,0x00]     
valignd $0, 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: valignd $0, -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x50,0x03,0x5c,0x82,0xc0,0x00]     
valignd $0, -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: valignd $0, 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x52,0x03,0x5c,0x82,0x40,0x00]    
valignd $0, 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x52,0x03,0x5c,0x82,0xc0,0x00]    
valignd $0, -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xd2,0x03,0x5c,0x82,0x40,0x00]   
valignd $0, 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xd2,0x03,0x5c,0x82,0xc0,0x00]   
valignd $0, -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x03,0x5c,0x82,0x40,0x00]     
valignd $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: valignd $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x03,0x5c,0x82,0xc0,0x00]     
valignd $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: valignd $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x03,0x5c,0x82,0x40,0x00]    
valignd $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x03,0x5c,0x82,0xc0,0x00]    
valignd $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x03,0x5c,0x82,0x40,0x00]   
valignd $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x03,0x5c,0x82,0xc0,0x00]   
valignd $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x03,0x5c,0x02,0x40,0x00]     
valignd $0, 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: valignd $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x03,0x5c,0x02,0x40,0x00]    
valignd $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x03,0x5c,0x02,0x40,0x00]   
valignd $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x03,0x5a,0x40,0x00]     
valignd $0, 4096(%rdx), %zmm19, %zmm19 

// CHECK: valignd $0, 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x03,0x5a,0x40,0x00]    
valignd $0, 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x03,0x5a,0x40,0x00]   
valignd $0, 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x50,0x03,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
valignd $0, 485498096{1to16}, %zmm19, %zmm19 

// CHECK: valignd $0, 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x52,0x03,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
valignd $0, 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xd2,0x03,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]   
valignd $0, 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x03,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
valignd $0, 485498096, %zmm19, %zmm19 

// CHECK: valignd $0, 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x03,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
valignd $0, 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x03,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]   
valignd $0, 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x50,0x03,0x1a,0x00]     
valignd $0, (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: valignd $0, (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x52,0x03,0x1a,0x00]    
valignd $0, (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xd2,0x03,0x1a,0x00]   
valignd $0, (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x03,0x1a,0x00]     
valignd $0, (%rdx), %zmm19, %zmm19 

// CHECK: valignd $0, (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x03,0x1a,0x00]    
valignd $0, (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x03,0x1a,0x00]   
valignd $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignd $0, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0x65,0x40,0x03,0xdb,0x00]     
valignd $0, %zmm19, %zmm19, %zmm19 

// CHECK: valignd $0, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0x65,0x42,0x03,0xdb,0x00]    
valignd $0, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: valignd $0, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0x65,0xc2,0x03,0xdb,0x00]   
valignd $0, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x03,0x5c,0x82,0x40,0x00]     
valignq $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: valignq $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x03,0x5c,0x82,0xc0,0x00]     
valignq $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: valignq $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x03,0x5c,0x82,0x40,0x00]    
valignq $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x03,0x5c,0x82,0xc0,0x00]    
valignq $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x03,0x5c,0x82,0x40,0x00]   
valignq $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x03,0x5c,0x82,0xc0,0x00]   
valignq $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x03,0x5c,0x02,0x40,0x00]     
valignq $0, 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: valignq $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x03,0x5c,0x02,0x40,0x00]    
valignq $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x03,0x5c,0x02,0x40,0x00]   
valignq $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x03,0x5a,0x40,0x00]     
valignq $0, 4096(%rdx), %zmm19, %zmm19 

// CHECK: valignq $0, 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x03,0x5a,0x40,0x00]    
valignq $0, 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x03,0x5a,0x40,0x00]   
valignq $0, 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x50,0x03,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
valignq $0, 485498096{1to8}, %zmm19, %zmm19 

// CHECK: valignq $0, 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x52,0x03,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
valignq $0, 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xd2,0x03,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]   
valignq $0, 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x03,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
valignq $0, 485498096, %zmm19, %zmm19 

// CHECK: valignq $0, 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x03,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
valignq $0, 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x03,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]   
valignq $0, 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x50,0x03,0x5a,0x40,0x00]     
valignq $0, 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: valignq $0, 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x52,0x03,0x5a,0x40,0x00]    
valignq $0, 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xd2,0x03,0x5a,0x40,0x00]   
valignq $0, 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x50,0x03,0x5c,0x02,0x40,0x00]     
valignq $0, 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: valignq $0, 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x52,0x03,0x5c,0x02,0x40,0x00]    
valignq $0, 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xd2,0x03,0x5c,0x02,0x40,0x00]   
valignq $0, 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x50,0x03,0x5c,0x82,0x40,0x00]     
valignq $0, 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: valignq $0, -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x50,0x03,0x5c,0x82,0xc0,0x00]     
valignq $0, -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: valignq $0, 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x52,0x03,0x5c,0x82,0x40,0x00]    
valignq $0, 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x52,0x03,0x5c,0x82,0xc0,0x00]    
valignq $0, -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xd2,0x03,0x5c,0x82,0x40,0x00]   
valignq $0, 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xd2,0x03,0x5c,0x82,0xc0,0x00]   
valignq $0, -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x50,0x03,0x1a,0x00]     
valignq $0, (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: valignq $0, (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x52,0x03,0x1a,0x00]    
valignq $0, (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xd2,0x03,0x1a,0x00]   
valignq $0, (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x03,0x1a,0x00]     
valignq $0, (%rdx), %zmm19, %zmm19 

// CHECK: valignq $0, (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x03,0x1a,0x00]    
valignq $0, (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x03,0x1a,0x00]   
valignq $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: valignq $0, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0xe5,0x40,0x03,0xdb,0x00]     
valignq $0, %zmm19, %zmm19, %zmm19 

// CHECK: valignq $0, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0xe5,0x42,0x03,0xdb,0x00]    
valignq $0, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: valignq $0, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0xe5,0xc2,0x03,0xdb,0x00]   
valignq $0, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmpd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x65,0x5c,0x82,0x40]      
vblendmpd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vblendmpd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x65,0x5c,0x82,0xc0]      
vblendmpd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vblendmpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x65,0x5c,0x82,0x40]     
vblendmpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x65,0x5c,0x82,0xc0]     
vblendmpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x65,0x5c,0x82,0x40]    
vblendmpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x65,0x5c,0x82,0xc0]    
vblendmpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmpd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x65,0x5c,0x02,0x40]      
vblendmpd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vblendmpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x65,0x5c,0x02,0x40]     
vblendmpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x65,0x5c,0x02,0x40]    
vblendmpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmpd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x65,0x5a,0x40]      
vblendmpd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vblendmpd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x65,0x5a,0x40]     
vblendmpd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x65,0x5a,0x40]    
vblendmpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmpd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x65,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vblendmpd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vblendmpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x65,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vblendmpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x65,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vblendmpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vblendmpd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x65,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vblendmpd 485498096, %zmm19, %zmm19 

// CHECK: vblendmpd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x65,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vblendmpd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x65,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vblendmpd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmpd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x65,0x5a,0x40]      
vblendmpd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vblendmpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x65,0x5a,0x40]     
vblendmpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x65,0x5a,0x40]     
vblendmpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vblendmpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x65,0x5c,0x02,0x40]      
vblendmpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vblendmpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x65,0x5c,0x02,0x40]     
vblendmpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x65,0x5c,0x02,0x40]     
vblendmpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vblendmpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x65,0x5c,0x82,0x40]      
vblendmpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vblendmpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x65,0x5c,0x82,0xc0]      
vblendmpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vblendmpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x65,0x5c,0x82,0x40]     
vblendmpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x65,0x5c,0x82,0x40]     
vblendmpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vblendmpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x65,0x5c,0x82,0xc0]     
vblendmpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x65,0x5c,0x82,0xc0]     
vblendmpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vblendmpd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x65,0x1a]      
vblendmpd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vblendmpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x65,0x1a]     
vblendmpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x65,0x1a]     
vblendmpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vblendmpd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x65,0x1a]      
vblendmpd (%rdx), %zmm19, %zmm19 

// CHECK: vblendmpd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x65,0x1a]     
vblendmpd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x65,0x1a]    
vblendmpd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmpd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x65,0xdb]      
vblendmpd %zmm19, %zmm19, %zmm19 

// CHECK: vblendmpd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x65,0xdb]     
vblendmpd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmpd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x65,0xdb]    
vblendmpd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x65,0x5a,0x40]      
vblendmps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vblendmps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x65,0x5a,0x40]     
vblendmps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x65,0x5a,0x40]     
vblendmps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vblendmps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x65,0x5c,0x02,0x40]      
vblendmps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vblendmps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x65,0x5c,0x02,0x40]     
vblendmps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x65,0x5c,0x02,0x40]     
vblendmps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vblendmps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x65,0x5c,0x82,0x40]      
vblendmps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vblendmps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x65,0x5c,0x82,0xc0]      
vblendmps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vblendmps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x65,0x5c,0x82,0x40]     
vblendmps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x65,0x5c,0x82,0x40]     
vblendmps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vblendmps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x65,0x5c,0x82,0xc0]     
vblendmps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x65,0x5c,0x82,0xc0]     
vblendmps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vblendmps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x65,0x5c,0x82,0x40]      
vblendmps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vblendmps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x65,0x5c,0x82,0xc0]      
vblendmps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vblendmps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x65,0x5c,0x82,0x40]     
vblendmps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x65,0x5c,0x82,0xc0]     
vblendmps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x65,0x5c,0x82,0x40]    
vblendmps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x65,0x5c,0x82,0xc0]    
vblendmps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x65,0x5c,0x02,0x40]      
vblendmps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vblendmps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x65,0x5c,0x02,0x40]     
vblendmps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x65,0x5c,0x02,0x40]    
vblendmps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x65,0x5a,0x40]      
vblendmps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vblendmps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x65,0x5a,0x40]     
vblendmps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x65,0x5a,0x40]    
vblendmps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x65,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vblendmps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vblendmps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x65,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vblendmps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x65,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vblendmps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vblendmps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x65,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vblendmps 485498096, %zmm19, %zmm19 

// CHECK: vblendmps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x65,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vblendmps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x65,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vblendmps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x65,0x1a]      
vblendmps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vblendmps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x65,0x1a]     
vblendmps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x65,0x1a]     
vblendmps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vblendmps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x65,0x1a]      
vblendmps (%rdx), %zmm19, %zmm19 

// CHECK: vblendmps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x65,0x1a]     
vblendmps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x65,0x1a]    
vblendmps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vblendmps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x65,0xdb]      
vblendmps %zmm19, %zmm19, %zmm19 

// CHECK: vblendmps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x65,0xdb]     
vblendmps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vblendmps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x65,0xdb]    
vblendmps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vbroadcastf32x4 1024(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x1a,0x5c,0x82,0x40]       
vbroadcastf32x4 1024(%rdx,%rax,4), %zmm19 

// CHECK: vbroadcastf32x4 -1024(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x1a,0x5c,0x82,0xc0]       
vbroadcastf32x4 -1024(%rdx,%rax,4), %zmm19 

// CHECK: vbroadcastf32x4 1024(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x1a,0x5c,0x82,0x40]      
vbroadcastf32x4 1024(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vbroadcastf32x4 -1024(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x1a,0x5c,0x82,0xc0]      
vbroadcastf32x4 -1024(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vbroadcastf32x4 1024(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x1a,0x5c,0x82,0x40]     
vbroadcastf32x4 1024(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vbroadcastf32x4 -1024(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x1a,0x5c,0x82,0xc0]     
vbroadcastf32x4 -1024(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vbroadcastf32x4 1024(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x1a,0x5c,0x02,0x40]       
vbroadcastf32x4 1024(%rdx,%rax), %zmm19 

// CHECK: vbroadcastf32x4 1024(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x1a,0x5c,0x02,0x40]      
vbroadcastf32x4 1024(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vbroadcastf32x4 1024(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x1a,0x5c,0x02,0x40]     
vbroadcastf32x4 1024(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vbroadcastf32x4 1024(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x1a,0x5a,0x40]       
vbroadcastf32x4 1024(%rdx), %zmm19 

// CHECK: vbroadcastf32x4 1024(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x1a,0x5a,0x40]      
vbroadcastf32x4 1024(%rdx), %zmm19 {%k2} 

// CHECK: vbroadcastf32x4 1024(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x1a,0x5a,0x40]     
vbroadcastf32x4 1024(%rdx), %zmm19 {%k2} {z} 

// CHECK: vbroadcastf32x4 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x1a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vbroadcastf32x4 485498096, %zmm19 

// CHECK: vbroadcastf32x4 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x1a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vbroadcastf32x4 485498096, %zmm19 {%k2} 

// CHECK: vbroadcastf32x4 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x1a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vbroadcastf32x4 485498096, %zmm19 {%k2} {z} 

// CHECK: vbroadcastf32x4 (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x1a,0x1a]       
vbroadcastf32x4 (%rdx), %zmm19 

// CHECK: vbroadcastf32x4 (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x1a,0x1a]      
vbroadcastf32x4 (%rdx), %zmm19 {%k2} 

// CHECK: vbroadcastf32x4 (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x1a,0x1a]     
vbroadcastf32x4 (%rdx), %zmm19 {%k2} {z} 

// CHECK: vbroadcastf64x4 2048(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x1b,0x5c,0x82,0x40]       
vbroadcastf64x4 2048(%rdx,%rax,4), %zmm19 

// CHECK: vbroadcastf64x4 -2048(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x1b,0x5c,0x82,0xc0]       
vbroadcastf64x4 -2048(%rdx,%rax,4), %zmm19 

// CHECK: vbroadcastf64x4 2048(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x1b,0x5c,0x82,0x40]      
vbroadcastf64x4 2048(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vbroadcastf64x4 -2048(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x1b,0x5c,0x82,0xc0]      
vbroadcastf64x4 -2048(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vbroadcastf64x4 2048(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x1b,0x5c,0x82,0x40]     
vbroadcastf64x4 2048(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vbroadcastf64x4 -2048(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x1b,0x5c,0x82,0xc0]     
vbroadcastf64x4 -2048(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vbroadcastf64x4 2048(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x1b,0x5c,0x02,0x40]       
vbroadcastf64x4 2048(%rdx,%rax), %zmm19 

// CHECK: vbroadcastf64x4 2048(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x1b,0x5c,0x02,0x40]      
vbroadcastf64x4 2048(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vbroadcastf64x4 2048(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x1b,0x5c,0x02,0x40]     
vbroadcastf64x4 2048(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vbroadcastf64x4 2048(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x1b,0x5a,0x40]       
vbroadcastf64x4 2048(%rdx), %zmm19 

// CHECK: vbroadcastf64x4 2048(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x1b,0x5a,0x40]      
vbroadcastf64x4 2048(%rdx), %zmm19 {%k2} 

// CHECK: vbroadcastf64x4 2048(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x1b,0x5a,0x40]     
vbroadcastf64x4 2048(%rdx), %zmm19 {%k2} {z} 

// CHECK: vbroadcastf64x4 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x1b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vbroadcastf64x4 485498096, %zmm19 

// CHECK: vbroadcastf64x4 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x1b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vbroadcastf64x4 485498096, %zmm19 {%k2} 

// CHECK: vbroadcastf64x4 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x1b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vbroadcastf64x4 485498096, %zmm19 {%k2} {z} 

// CHECK: vbroadcastf64x4 (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x1b,0x1a]       
vbroadcastf64x4 (%rdx), %zmm19 

// CHECK: vbroadcastf64x4 (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x1b,0x1a]      
vbroadcastf64x4 (%rdx), %zmm19 {%k2} 

// CHECK: vbroadcastf64x4 (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x1b,0x1a]     
vbroadcastf64x4 (%rdx), %zmm19 {%k2} {z} 

// CHECK: vbroadcasti32x4 1024(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x5a,0x5c,0x82,0x40]       
vbroadcasti32x4 1024(%rdx,%rax,4), %zmm19 

// CHECK: vbroadcasti32x4 -1024(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x5a,0x5c,0x82,0xc0]       
vbroadcasti32x4 -1024(%rdx,%rax,4), %zmm19 

// CHECK: vbroadcasti32x4 1024(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x5a,0x5c,0x82,0x40]      
vbroadcasti32x4 1024(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vbroadcasti32x4 -1024(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x5a,0x5c,0x82,0xc0]      
vbroadcasti32x4 -1024(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vbroadcasti32x4 1024(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x5a,0x5c,0x82,0x40]     
vbroadcasti32x4 1024(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vbroadcasti32x4 -1024(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x5a,0x5c,0x82,0xc0]     
vbroadcasti32x4 -1024(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vbroadcasti32x4 1024(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x5a,0x5c,0x02,0x40]       
vbroadcasti32x4 1024(%rdx,%rax), %zmm19 

// CHECK: vbroadcasti32x4 1024(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x5a,0x5c,0x02,0x40]      
vbroadcasti32x4 1024(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vbroadcasti32x4 1024(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x5a,0x5c,0x02,0x40]     
vbroadcasti32x4 1024(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vbroadcasti32x4 1024(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x5a,0x5a,0x40]       
vbroadcasti32x4 1024(%rdx), %zmm19 

// CHECK: vbroadcasti32x4 1024(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x5a,0x5a,0x40]      
vbroadcasti32x4 1024(%rdx), %zmm19 {%k2} 

// CHECK: vbroadcasti32x4 1024(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x5a,0x5a,0x40]     
vbroadcasti32x4 1024(%rdx), %zmm19 {%k2} {z} 

// CHECK: vbroadcasti32x4 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x5a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vbroadcasti32x4 485498096, %zmm19 

// CHECK: vbroadcasti32x4 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x5a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vbroadcasti32x4 485498096, %zmm19 {%k2} 

// CHECK: vbroadcasti32x4 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x5a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vbroadcasti32x4 485498096, %zmm19 {%k2} {z} 

// CHECK: vbroadcasti32x4 (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x5a,0x1a]       
vbroadcasti32x4 (%rdx), %zmm19 

// CHECK: vbroadcasti32x4 (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x5a,0x1a]      
vbroadcasti32x4 (%rdx), %zmm19 {%k2} 

// CHECK: vbroadcasti32x4 (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x5a,0x1a]     
vbroadcasti32x4 (%rdx), %zmm19 {%k2} {z} 

// CHECK: vbroadcasti64x4 2048(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x5b,0x5c,0x82,0x40]       
vbroadcasti64x4 2048(%rdx,%rax,4), %zmm19 

// CHECK: vbroadcasti64x4 -2048(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x5b,0x5c,0x82,0xc0]       
vbroadcasti64x4 -2048(%rdx,%rax,4), %zmm19 

// CHECK: vbroadcasti64x4 2048(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x5b,0x5c,0x82,0x40]      
vbroadcasti64x4 2048(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vbroadcasti64x4 -2048(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x5b,0x5c,0x82,0xc0]      
vbroadcasti64x4 -2048(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vbroadcasti64x4 2048(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x5b,0x5c,0x82,0x40]     
vbroadcasti64x4 2048(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vbroadcasti64x4 -2048(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x5b,0x5c,0x82,0xc0]     
vbroadcasti64x4 -2048(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vbroadcasti64x4 2048(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x5b,0x5c,0x02,0x40]       
vbroadcasti64x4 2048(%rdx,%rax), %zmm19 

// CHECK: vbroadcasti64x4 2048(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x5b,0x5c,0x02,0x40]      
vbroadcasti64x4 2048(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vbroadcasti64x4 2048(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x5b,0x5c,0x02,0x40]     
vbroadcasti64x4 2048(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vbroadcasti64x4 2048(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x5b,0x5a,0x40]       
vbroadcasti64x4 2048(%rdx), %zmm19 

// CHECK: vbroadcasti64x4 2048(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x5b,0x5a,0x40]      
vbroadcasti64x4 2048(%rdx), %zmm19 {%k2} 

// CHECK: vbroadcasti64x4 2048(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x5b,0x5a,0x40]     
vbroadcasti64x4 2048(%rdx), %zmm19 {%k2} {z} 

// CHECK: vbroadcasti64x4 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vbroadcasti64x4 485498096, %zmm19 

// CHECK: vbroadcasti64x4 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vbroadcasti64x4 485498096, %zmm19 {%k2} 

// CHECK: vbroadcasti64x4 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vbroadcasti64x4 485498096, %zmm19 {%k2} {z} 

// CHECK: vbroadcasti64x4 (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x5b,0x1a]       
vbroadcasti64x4 (%rdx), %zmm19 

// CHECK: vbroadcasti64x4 (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x5b,0x1a]      
vbroadcasti64x4 (%rdx), %zmm19 {%k2} 

// CHECK: vbroadcasti64x4 (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x5b,0x1a]     
vbroadcasti64x4 (%rdx), %zmm19 {%k2} {z} 

// CHECK: vbroadcastsd 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x19,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vbroadcastsd 485498096, %zmm19 

// CHECK: vbroadcastsd 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x19,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vbroadcastsd 485498096, %zmm19 {%k2} 

// CHECK: vbroadcastsd 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x19,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vbroadcastsd 485498096, %zmm19 {%k2} {z} 

// CHECK: vbroadcastsd 512(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x19,0x5c,0x82,0x40]       
vbroadcastsd 512(%rdx,%rax,4), %zmm19 

// CHECK: vbroadcastsd -512(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x19,0x5c,0x82,0xc0]       
vbroadcastsd -512(%rdx,%rax,4), %zmm19 

// CHECK: vbroadcastsd 512(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x19,0x5c,0x82,0x40]      
vbroadcastsd 512(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vbroadcastsd -512(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x19,0x5c,0x82,0xc0]      
vbroadcastsd -512(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vbroadcastsd 512(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x19,0x5c,0x82,0x40]     
vbroadcastsd 512(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vbroadcastsd -512(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x19,0x5c,0x82,0xc0]     
vbroadcastsd -512(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vbroadcastsd 512(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x19,0x5c,0x02,0x40]       
vbroadcastsd 512(%rdx,%rax), %zmm19 

// CHECK: vbroadcastsd 512(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x19,0x5c,0x02,0x40]      
vbroadcastsd 512(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vbroadcastsd 512(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x19,0x5c,0x02,0x40]     
vbroadcastsd 512(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vbroadcastsd 512(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x19,0x5a,0x40]       
vbroadcastsd 512(%rdx), %zmm19 

// CHECK: vbroadcastsd 512(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x19,0x5a,0x40]      
vbroadcastsd 512(%rdx), %zmm19 {%k2} 

// CHECK: vbroadcastsd 512(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x19,0x5a,0x40]     
vbroadcastsd 512(%rdx), %zmm19 {%k2} {z} 

// CHECK: vbroadcastsd (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x19,0x1a]       
vbroadcastsd (%rdx), %zmm19 

// CHECK: vbroadcastsd (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x19,0x1a]      
vbroadcastsd (%rdx), %zmm19 {%k2} 

// CHECK: vbroadcastsd (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x19,0x1a]     
vbroadcastsd (%rdx), %zmm19 {%k2} {z} 

// CHECK: vbroadcastsd %xmm15, %zmm19 
// CHECK: encoding: [0x62,0xc2,0xfd,0x48,0x19,0xdf]       
vbroadcastsd %xmm15, %zmm19 

// CHECK: vbroadcastsd %xmm15, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xc2,0xfd,0x4a,0x19,0xdf]      
vbroadcastsd %xmm15, %zmm19 {%k2} 

// CHECK: vbroadcastsd %xmm15, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xc2,0xfd,0xca,0x19,0xdf]     
vbroadcastsd %xmm15, %zmm19 {%k2} {z} 

// CHECK: vbroadcastsd %xmm1, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x19,0xd9]       
vbroadcastsd %xmm1, %zmm19 

// CHECK: vbroadcastsd %xmm1, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x19,0xd9]      
vbroadcastsd %xmm1, %zmm19 {%k2} 

// CHECK: vbroadcastsd %xmm1, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x19,0xd9]     
vbroadcastsd %xmm1, %zmm19 {%k2} {z} 

// CHECK: vbroadcastss 256(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x18,0x5c,0x82,0x40]       
vbroadcastss 256(%rdx,%rax,4), %zmm19 

// CHECK: vbroadcastss -256(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x18,0x5c,0x82,0xc0]       
vbroadcastss -256(%rdx,%rax,4), %zmm19 

// CHECK: vbroadcastss 256(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x18,0x5c,0x82,0x40]      
vbroadcastss 256(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vbroadcastss -256(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x18,0x5c,0x82,0xc0]      
vbroadcastss -256(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vbroadcastss 256(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x18,0x5c,0x82,0x40]     
vbroadcastss 256(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vbroadcastss -256(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x18,0x5c,0x82,0xc0]     
vbroadcastss -256(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vbroadcastss 256(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x18,0x5c,0x02,0x40]       
vbroadcastss 256(%rdx,%rax), %zmm19 

// CHECK: vbroadcastss 256(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x18,0x5c,0x02,0x40]      
vbroadcastss 256(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vbroadcastss 256(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x18,0x5c,0x02,0x40]     
vbroadcastss 256(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vbroadcastss 256(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x18,0x5a,0x40]       
vbroadcastss 256(%rdx), %zmm19 

// CHECK: vbroadcastss 256(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x18,0x5a,0x40]      
vbroadcastss 256(%rdx), %zmm19 {%k2} 

// CHECK: vbroadcastss 256(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x18,0x5a,0x40]     
vbroadcastss 256(%rdx), %zmm19 {%k2} {z} 

// CHECK: vbroadcastss 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x18,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vbroadcastss 485498096, %zmm19 

// CHECK: vbroadcastss 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x18,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vbroadcastss 485498096, %zmm19 {%k2} 

// CHECK: vbroadcastss 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x18,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vbroadcastss 485498096, %zmm19 {%k2} {z} 

// CHECK: vbroadcastss (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x18,0x1a]       
vbroadcastss (%rdx), %zmm19 

// CHECK: vbroadcastss (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x18,0x1a]      
vbroadcastss (%rdx), %zmm19 {%k2} 

// CHECK: vbroadcastss (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x18,0x1a]     
vbroadcastss (%rdx), %zmm19 {%k2} {z} 

// CHECK: vbroadcastss %xmm15, %zmm19 
// CHECK: encoding: [0x62,0xc2,0x7d,0x48,0x18,0xdf]       
vbroadcastss %xmm15, %zmm19 

// CHECK: vbroadcastss %xmm15, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xc2,0x7d,0x4a,0x18,0xdf]      
vbroadcastss %xmm15, %zmm19 {%k2} 

// CHECK: vbroadcastss %xmm15, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xc2,0x7d,0xca,0x18,0xdf]     
vbroadcastss %xmm15, %zmm19 {%k2} {z} 

// CHECK: vbroadcastss %xmm1, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x18,0xd9]       
vbroadcastss %xmm1, %zmm19 

// CHECK: vbroadcastss %xmm1, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x18,0xd9]      
vbroadcastss %xmm1, %zmm19 {%k2} 

// CHECK: vbroadcastss %xmm1, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x18,0xd9]     
vbroadcastss %xmm1, %zmm19 {%k2} {z} 

// CHECK: vcmpeqpd 4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0xe5,0x40,0xc2,0x54,0x82,0x40,0x00]      
vcmpeqpd 4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vcmpeqpd -4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0xe5,0x40,0xc2,0x54,0x82,0xc0,0x00]      
vcmpeqpd -4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vcmpeqpd 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xe5,0x42,0xc2,0x54,0x82,0x40,0x00]     
vcmpeqpd 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xe5,0x42,0xc2,0x54,0x82,0xc0,0x00]     
vcmpeqpd -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd 4096(%rdx,%rax), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0xe5,0x40,0xc2,0x54,0x02,0x40,0x00]      
vcmpeqpd 4096(%rdx,%rax), %zmm19, %k2 

// CHECK: vcmpeqpd 4096(%rdx,%rax), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xe5,0x42,0xc2,0x54,0x02,0x40,0x00]     
vcmpeqpd 4096(%rdx,%rax), %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd 4096(%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0xe5,0x40,0xc2,0x52,0x40,0x00]      
vcmpeqpd 4096(%rdx), %zmm19, %k2 

// CHECK: vcmpeqpd 4096(%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xe5,0x42,0xc2,0x52,0x40,0x00]     
vcmpeqpd 4096(%rdx), %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd 485498096{1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0xe5,0x50,0xc2,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqpd 485498096{1to8}, %zmm19, %k2 

// CHECK: vcmpeqpd 485498096{1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xe5,0x52,0xc2,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqpd 485498096{1to8}, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd 485498096, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0xe5,0x40,0xc2,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqpd 485498096, %zmm19, %k2 

// CHECK: vcmpeqpd 485498096, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xe5,0x42,0xc2,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqpd 485498096, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd 512(%rdx){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0xe5,0x50,0xc2,0x52,0x40,0x00]      
vcmpeqpd 512(%rdx){1to8}, %zmm19, %k2 

// CHECK: vcmpeqpd 512(%rdx){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xe5,0x52,0xc2,0x52,0x40,0x00]     
vcmpeqpd 512(%rdx){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd 512(%rdx,%rax){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0xe5,0x50,0xc2,0x54,0x02,0x40,0x00]      
vcmpeqpd 512(%rdx,%rax){1to8}, %zmm19, %k2 

// CHECK: vcmpeqpd 512(%rdx,%rax){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xe5,0x52,0xc2,0x54,0x02,0x40,0x00]     
vcmpeqpd 512(%rdx,%rax){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd 512(%rdx,%rax,4){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0xe5,0x50,0xc2,0x54,0x82,0x40,0x00]      
vcmpeqpd 512(%rdx,%rax,4){1to8}, %zmm19, %k2 

// CHECK: vcmpeqpd -512(%rdx,%rax,4){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0xe5,0x50,0xc2,0x54,0x82,0xc0,0x00]      
vcmpeqpd -512(%rdx,%rax,4){1to8}, %zmm19, %k2 

// CHECK: vcmpeqpd 512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xe5,0x52,0xc2,0x54,0x82,0x40,0x00]     
vcmpeqpd 512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd -512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xe5,0x52,0xc2,0x54,0x82,0xc0,0x00]     
vcmpeqpd -512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd (%rdx){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0xe5,0x50,0xc2,0x12,0x00]      
vcmpeqpd (%rdx){1to8}, %zmm19, %k2 

// CHECK: vcmpeqpd (%rdx){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xe5,0x52,0xc2,0x12,0x00]     
vcmpeqpd (%rdx){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd (%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0xe5,0x40,0xc2,0x12,0x00]      
vcmpeqpd (%rdx), %zmm19, %k2 

// CHECK: vcmpeqpd (%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xe5,0x42,0xc2,0x12,0x00]     
vcmpeqpd (%rdx), %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd {sae}, %zmm19, %zmm19, %k2 
// CHECK: encoding: [0x62,0xb1,0xe5,0x10,0xc2,0xd3,0x00]     
vcmpeqpd {sae}, %zmm19, %zmm19, %k2 

// CHECK: vcmpeqpd {sae}, %zmm19, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xb1,0xe5,0x12,0xc2,0xd3,0x00]    
vcmpeqpd {sae}, %zmm19, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqpd %zmm19, %zmm19, %k2 
// CHECK: encoding: [0x62,0xb1,0xe5,0x40,0xc2,0xd3,0x00]      
vcmpeqpd %zmm19, %zmm19, %k2 

// CHECK: vcmpeqpd %zmm19, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xb1,0xe5,0x42,0xc2,0xd3,0x00]     
vcmpeqpd %zmm19, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps 256(%rdx){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x64,0x50,0xc2,0x52,0x40,0x00]      
vcmpeqps 256(%rdx){1to16}, %zmm19, %k2 

// CHECK: vcmpeqps 256(%rdx){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x64,0x52,0xc2,0x52,0x40,0x00]     
vcmpeqps 256(%rdx){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps 256(%rdx,%rax){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x64,0x50,0xc2,0x54,0x02,0x40,0x00]      
vcmpeqps 256(%rdx,%rax){1to16}, %zmm19, %k2 

// CHECK: vcmpeqps 256(%rdx,%rax){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x64,0x52,0xc2,0x54,0x02,0x40,0x00]     
vcmpeqps 256(%rdx,%rax){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps 256(%rdx,%rax,4){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x64,0x50,0xc2,0x54,0x82,0x40,0x00]      
vcmpeqps 256(%rdx,%rax,4){1to16}, %zmm19, %k2 

// CHECK: vcmpeqps -256(%rdx,%rax,4){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x64,0x50,0xc2,0x54,0x82,0xc0,0x00]      
vcmpeqps -256(%rdx,%rax,4){1to16}, %zmm19, %k2 

// CHECK: vcmpeqps 256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x64,0x52,0xc2,0x54,0x82,0x40,0x00]     
vcmpeqps 256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps -256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x64,0x52,0xc2,0x54,0x82,0xc0,0x00]     
vcmpeqps -256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps 4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x64,0x40,0xc2,0x54,0x82,0x40,0x00]      
vcmpeqps 4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vcmpeqps -4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x64,0x40,0xc2,0x54,0x82,0xc0,0x00]      
vcmpeqps -4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vcmpeqps 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x64,0x42,0xc2,0x54,0x82,0x40,0x00]     
vcmpeqps 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x64,0x42,0xc2,0x54,0x82,0xc0,0x00]     
vcmpeqps -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps 4096(%rdx,%rax), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x64,0x40,0xc2,0x54,0x02,0x40,0x00]      
vcmpeqps 4096(%rdx,%rax), %zmm19, %k2 

// CHECK: vcmpeqps 4096(%rdx,%rax), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x64,0x42,0xc2,0x54,0x02,0x40,0x00]     
vcmpeqps 4096(%rdx,%rax), %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps 4096(%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x64,0x40,0xc2,0x52,0x40,0x00]      
vcmpeqps 4096(%rdx), %zmm19, %k2 

// CHECK: vcmpeqps 4096(%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x64,0x42,0xc2,0x52,0x40,0x00]     
vcmpeqps 4096(%rdx), %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps 485498096{1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x64,0x50,0xc2,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqps 485498096{1to16}, %zmm19, %k2 

// CHECK: vcmpeqps 485498096{1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x64,0x52,0xc2,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqps 485498096{1to16}, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps 485498096, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x64,0x40,0xc2,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqps 485498096, %zmm19, %k2 

// CHECK: vcmpeqps 485498096, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x64,0x42,0xc2,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqps 485498096, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps (%rdx){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x64,0x50,0xc2,0x12,0x00]      
vcmpeqps (%rdx){1to16}, %zmm19, %k2 

// CHECK: vcmpeqps (%rdx){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x64,0x52,0xc2,0x12,0x00]     
vcmpeqps (%rdx){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps (%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x64,0x40,0xc2,0x12,0x00]      
vcmpeqps (%rdx), %zmm19, %k2 

// CHECK: vcmpeqps (%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x64,0x42,0xc2,0x12,0x00]     
vcmpeqps (%rdx), %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps {sae}, %zmm19, %zmm19, %k2 
// CHECK: encoding: [0x62,0xb1,0x64,0x10,0xc2,0xd3,0x00]     
vcmpeqps {sae}, %zmm19, %zmm19, %k2 

// CHECK: vcmpeqps {sae}, %zmm19, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xb1,0x64,0x12,0xc2,0xd3,0x00]    
vcmpeqps {sae}, %zmm19, %zmm19, %k2 {%k2} 

// CHECK: vcmpeqps %zmm19, %zmm19, %k2 
// CHECK: encoding: [0x62,0xb1,0x64,0x40,0xc2,0xd3,0x00]      
vcmpeqps %zmm19, %zmm19, %k2 

// CHECK: vcmpeqps %zmm19, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xb1,0x64,0x42,0xc2,0xd3,0x00]     
vcmpeqps %zmm19, %zmm19, %k2 {%k2} 

// CHECK: vcompresspd %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x8a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcompresspd %zmm19, 485498096 

// CHECK: vcompresspd %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x8a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcompresspd %zmm19, 485498096 {%k2} 

// CHECK: vcompresspd %zmm19, 512(%rdx) 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x8a,0x5a,0x40]       
vcompresspd %zmm19, 512(%rdx) 

// CHECK: vcompresspd %zmm19, 512(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x8a,0x5a,0x40]      
vcompresspd %zmm19, 512(%rdx) {%k2} 

// CHECK: vcompresspd %zmm19, 512(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x8a,0x5c,0x82,0x40]       
vcompresspd %zmm19, 512(%rdx,%rax,4) 

// CHECK: vcompresspd %zmm19, -512(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x8a,0x5c,0x82,0xc0]       
vcompresspd %zmm19, -512(%rdx,%rax,4) 

// CHECK: vcompresspd %zmm19, 512(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x8a,0x5c,0x82,0x40]      
vcompresspd %zmm19, 512(%rdx,%rax,4) {%k2} 

// CHECK: vcompresspd %zmm19, -512(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x8a,0x5c,0x82,0xc0]      
vcompresspd %zmm19, -512(%rdx,%rax,4) {%k2} 

// CHECK: vcompresspd %zmm19, 512(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x8a,0x5c,0x02,0x40]       
vcompresspd %zmm19, 512(%rdx,%rax) 

// CHECK: vcompresspd %zmm19, 512(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x8a,0x5c,0x02,0x40]      
vcompresspd %zmm19, 512(%rdx,%rax) {%k2} 

// CHECK: vcompresspd %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x8a,0x1a]       
vcompresspd %zmm19, (%rdx) 

// CHECK: vcompresspd %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x8a,0x1a]      
vcompresspd %zmm19, (%rdx) {%k2} 

// CHECK: vcompresspd %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xfd,0x48,0x8a,0xdb]       
vcompresspd %zmm19, %zmm19 

// CHECK: vcompresspd %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x8a,0xdb]      
vcompresspd %zmm19, %zmm19 {%k2} 

// CHECK: vcompresspd %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xfd,0xca,0x8a,0xdb]     
vcompresspd %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcompressps %zmm19, 256(%rdx) 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x8a,0x5a,0x40]       
vcompressps %zmm19, 256(%rdx) 

// CHECK: vcompressps %zmm19, 256(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x8a,0x5a,0x40]      
vcompressps %zmm19, 256(%rdx) {%k2} 

// CHECK: vcompressps %zmm19, 256(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x8a,0x5c,0x82,0x40]       
vcompressps %zmm19, 256(%rdx,%rax,4) 

// CHECK: vcompressps %zmm19, -256(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x8a,0x5c,0x82,0xc0]       
vcompressps %zmm19, -256(%rdx,%rax,4) 

// CHECK: vcompressps %zmm19, 256(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x8a,0x5c,0x82,0x40]      
vcompressps %zmm19, 256(%rdx,%rax,4) {%k2} 

// CHECK: vcompressps %zmm19, -256(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x8a,0x5c,0x82,0xc0]      
vcompressps %zmm19, -256(%rdx,%rax,4) {%k2} 

// CHECK: vcompressps %zmm19, 256(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x8a,0x5c,0x02,0x40]       
vcompressps %zmm19, 256(%rdx,%rax) 

// CHECK: vcompressps %zmm19, 256(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x8a,0x5c,0x02,0x40]      
vcompressps %zmm19, 256(%rdx,%rax) {%k2} 

// CHECK: vcompressps %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x8a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcompressps %zmm19, 485498096 

// CHECK: vcompressps %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x8a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcompressps %zmm19, 485498096 {%k2} 

// CHECK: vcompressps %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x8a,0x1a]       
vcompressps %zmm19, (%rdx) 

// CHECK: vcompressps %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x8a,0x1a]      
vcompressps %zmm19, (%rdx) {%k2} 

// CHECK: vcompressps %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x7d,0x48,0x8a,0xdb]       
vcompressps %zmm19, %zmm19 

// CHECK: vcompressps %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x8a,0xdb]      
vcompressps %zmm19, %zmm19 {%k2} 

// CHECK: vcompressps %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x7d,0xca,0x8a,0xdb]     
vcompressps %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd 2048(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0xe6,0x5c,0x82,0x40]       
vcvtdq2pd 2048(%rdx,%rax,4), %zmm19 

// CHECK: vcvtdq2pd -2048(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0xe6,0x5c,0x82,0xc0]       
vcvtdq2pd -2048(%rdx,%rax,4), %zmm19 

// CHECK: vcvtdq2pd 2048(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0xe6,0x5c,0x82,0x40]      
vcvtdq2pd 2048(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtdq2pd -2048(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0xe6,0x5c,0x82,0xc0]      
vcvtdq2pd -2048(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtdq2pd 2048(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0xe6,0x5c,0x82,0x40]     
vcvtdq2pd 2048(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd -2048(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0xe6,0x5c,0x82,0xc0]     
vcvtdq2pd -2048(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd 2048(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0xe6,0x5c,0x02,0x40]       
vcvtdq2pd 2048(%rdx,%rax), %zmm19 

// CHECK: vcvtdq2pd 2048(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0xe6,0x5c,0x02,0x40]      
vcvtdq2pd 2048(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vcvtdq2pd 2048(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0xe6,0x5c,0x02,0x40]     
vcvtdq2pd 2048(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd 2048(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0xe6,0x5a,0x40]       
vcvtdq2pd 2048(%rdx), %zmm19 

// CHECK: vcvtdq2pd 2048(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0xe6,0x5a,0x40]      
vcvtdq2pd 2048(%rdx), %zmm19 {%k2} 

// CHECK: vcvtdq2pd 2048(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0xe6,0x5a,0x40]     
vcvtdq2pd 2048(%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd 256(%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0xe6,0x5a,0x40]       
vcvtdq2pd 256(%rdx){1to8}, %zmm19 

// CHECK: vcvtdq2pd 256(%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0xe6,0x5a,0x40]      
vcvtdq2pd 256(%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vcvtdq2pd 256(%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0xe6,0x5a,0x40]     
vcvtdq2pd 256(%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd 256(%rdx,%rax){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0xe6,0x5c,0x02,0x40]       
vcvtdq2pd 256(%rdx,%rax){1to8}, %zmm19 

// CHECK: vcvtdq2pd 256(%rdx,%rax){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0xe6,0x5c,0x02,0x40]      
vcvtdq2pd 256(%rdx,%rax){1to8}, %zmm19 {%k2} 

// CHECK: vcvtdq2pd 256(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0xe6,0x5c,0x02,0x40]     
vcvtdq2pd 256(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd 256(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0xe6,0x5c,0x82,0x40]       
vcvtdq2pd 256(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vcvtdq2pd -256(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0xe6,0x5c,0x82,0xc0]       
vcvtdq2pd -256(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vcvtdq2pd 256(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0xe6,0x5c,0x82,0x40]      
vcvtdq2pd 256(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vcvtdq2pd -256(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0xe6,0x5c,0x82,0xc0]      
vcvtdq2pd -256(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vcvtdq2pd 256(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0xe6,0x5c,0x82,0x40]     
vcvtdq2pd 256(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd -256(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0xe6,0x5c,0x82,0xc0]     
vcvtdq2pd -256(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd 485498096{1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0xe6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2pd 485498096{1to8}, %zmm19 

// CHECK: vcvtdq2pd 485498096{1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0xe6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2pd 485498096{1to8}, %zmm19 {%k2} 

// CHECK: vcvtdq2pd 485498096{1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0xe6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2pd 485498096{1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0xe6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2pd 485498096, %zmm19 

// CHECK: vcvtdq2pd 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0xe6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2pd 485498096, %zmm19 {%k2} 

// CHECK: vcvtdq2pd 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0xe6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2pd 485498096, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd (%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0xe6,0x1a]       
vcvtdq2pd (%rdx){1to8}, %zmm19 

// CHECK: vcvtdq2pd (%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0xe6,0x1a]      
vcvtdq2pd (%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vcvtdq2pd (%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0xe6,0x1a]     
vcvtdq2pd (%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0xe6,0x1a]       
vcvtdq2pd (%rdx), %zmm19 

// CHECK: vcvtdq2pd (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0xe6,0x1a]      
vcvtdq2pd (%rdx), %zmm19 {%k2} 

// CHECK: vcvtdq2pd (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0xe6,0x1a]     
vcvtdq2pd (%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtdq2pd %ymm23, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7e,0x48,0xe6,0xdf]       
vcvtdq2pd %ymm23, %zmm19 

// CHECK: vcvtdq2pd %ymm23, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7e,0x4a,0xe6,0xdf]      
vcvtdq2pd %ymm23, %zmm19 {%k2} 

// CHECK: vcvtdq2pd %ymm23, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7e,0xca,0xe6,0xdf]     
vcvtdq2pd %ymm23, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps 256(%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x5b,0x5a,0x40]       
vcvtdq2ps 256(%rdx){1to16}, %zmm19 

// CHECK: vcvtdq2ps 256(%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x5b,0x5a,0x40]      
vcvtdq2ps 256(%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vcvtdq2ps 256(%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x5b,0x5a,0x40]     
vcvtdq2ps 256(%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps 256(%rdx,%rax){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x5b,0x5c,0x02,0x40]       
vcvtdq2ps 256(%rdx,%rax){1to16}, %zmm19 

// CHECK: vcvtdq2ps 256(%rdx,%rax){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x5b,0x5c,0x02,0x40]      
vcvtdq2ps 256(%rdx,%rax){1to16}, %zmm19 {%k2} 

// CHECK: vcvtdq2ps 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x5b,0x5c,0x02,0x40]     
vcvtdq2ps 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps 256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x5b,0x5c,0x82,0x40]       
vcvtdq2ps 256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vcvtdq2ps -256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x5b,0x5c,0x82,0xc0]       
vcvtdq2ps -256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vcvtdq2ps 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x5b,0x5c,0x82,0x40]      
vcvtdq2ps 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vcvtdq2ps -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x5b,0x5c,0x82,0xc0]      
vcvtdq2ps -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vcvtdq2ps 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x5b,0x5c,0x82,0x40]     
vcvtdq2ps 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x5b,0x5c,0x82,0xc0]     
vcvtdq2ps -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x5b,0x5c,0x82,0x40]       
vcvtdq2ps 4096(%rdx,%rax,4), %zmm19 

// CHECK: vcvtdq2ps -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x5b,0x5c,0x82,0xc0]       
vcvtdq2ps -4096(%rdx,%rax,4), %zmm19 

// CHECK: vcvtdq2ps 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x5b,0x5c,0x82,0x40]      
vcvtdq2ps 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtdq2ps -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x5b,0x5c,0x82,0xc0]      
vcvtdq2ps -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtdq2ps 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x5b,0x5c,0x82,0x40]     
vcvtdq2ps 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x5b,0x5c,0x82,0xc0]     
vcvtdq2ps -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x5b,0x5c,0x02,0x40]       
vcvtdq2ps 4096(%rdx,%rax), %zmm19 

// CHECK: vcvtdq2ps 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x5b,0x5c,0x02,0x40]      
vcvtdq2ps 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vcvtdq2ps 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x5b,0x5c,0x02,0x40]     
vcvtdq2ps 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x5b,0x5a,0x40]       
vcvtdq2ps 4096(%rdx), %zmm19 

// CHECK: vcvtdq2ps 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x5b,0x5a,0x40]      
vcvtdq2ps 4096(%rdx), %zmm19 {%k2} 

// CHECK: vcvtdq2ps 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x5b,0x5a,0x40]     
vcvtdq2ps 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps 485498096{1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2ps 485498096{1to16}, %zmm19 

// CHECK: vcvtdq2ps 485498096{1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2ps 485498096{1to16}, %zmm19 {%k2} 

// CHECK: vcvtdq2ps 485498096{1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2ps 485498096{1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2ps 485498096, %zmm19 

// CHECK: vcvtdq2ps 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2ps 485498096, %zmm19 {%k2} 

// CHECK: vcvtdq2ps 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2ps 485498096, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps {rd-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x38,0x5b,0xdb]      
vcvtdq2ps {rd-sae}, %zmm19, %zmm19 

// CHECK: vcvtdq2ps {rd-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x3a,0x5b,0xdb]     
vcvtdq2ps {rd-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtdq2ps {rd-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xba,0x5b,0xdb]    
vcvtdq2ps {rd-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps (%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x5b,0x1a]       
vcvtdq2ps (%rdx){1to16}, %zmm19 

// CHECK: vcvtdq2ps (%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x5b,0x1a]      
vcvtdq2ps (%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vcvtdq2ps (%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x5b,0x1a]     
vcvtdq2ps (%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x5b,0x1a]       
vcvtdq2ps (%rdx), %zmm19 

// CHECK: vcvtdq2ps (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x5b,0x1a]      
vcvtdq2ps (%rdx), %zmm19 {%k2} 

// CHECK: vcvtdq2ps (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x5b,0x1a]     
vcvtdq2ps (%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps {rn-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x18,0x5b,0xdb]      
vcvtdq2ps {rn-sae}, %zmm19, %zmm19 

// CHECK: vcvtdq2ps {rn-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x1a,0x5b,0xdb]     
vcvtdq2ps {rn-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtdq2ps {rn-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x9a,0x5b,0xdb]    
vcvtdq2ps {rn-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps {ru-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x58,0x5b,0xdb]      
vcvtdq2ps {ru-sae}, %zmm19, %zmm19 

// CHECK: vcvtdq2ps {ru-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x5a,0x5b,0xdb]     
vcvtdq2ps {ru-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtdq2ps {ru-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xda,0x5b,0xdb]    
vcvtdq2ps {ru-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps {rz-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x78,0x5b,0xdb]      
vcvtdq2ps {rz-sae}, %zmm19, %zmm19 

// CHECK: vcvtdq2ps {rz-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x7a,0x5b,0xdb]     
vcvtdq2ps {rz-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtdq2ps {rz-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xfa,0x5b,0xdb]    
vcvtdq2ps {rz-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtdq2ps %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x48,0x5b,0xdb]       
vcvtdq2ps %zmm19, %zmm19 

// CHECK: vcvtdq2ps %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x4a,0x5b,0xdb]      
vcvtdq2ps %zmm19, %zmm19 {%k2} 

// CHECK: vcvtdq2ps %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xca,0x5b,0xdb]     
vcvtdq2ps %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtpd2dq 4096(%rdx,%rax,4), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xff,0x48,0xe6,0x7c,0x82,0x40]       
vcvtpd2dq 4096(%rdx,%rax,4), %ymm23 

// CHECK: vcvtpd2dq -4096(%rdx,%rax,4), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xff,0x48,0xe6,0x7c,0x82,0xc0]       
vcvtpd2dq -4096(%rdx,%rax,4), %ymm23 

// CHECK: vcvtpd2dq 4096(%rdx,%rax,4), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x4a,0xe6,0x7c,0x82,0x40]      
vcvtpd2dq 4096(%rdx,%rax,4), %ymm23 {%k2} 

// CHECK: vcvtpd2dq -4096(%rdx,%rax,4), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x4a,0xe6,0x7c,0x82,0xc0]      
vcvtpd2dq -4096(%rdx,%rax,4), %ymm23 {%k2} 

// CHECK: vcvtpd2dq 4096(%rdx,%rax,4), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xca,0xe6,0x7c,0x82,0x40]     
vcvtpd2dq 4096(%rdx,%rax,4), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq -4096(%rdx,%rax,4), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xca,0xe6,0x7c,0x82,0xc0]     
vcvtpd2dq -4096(%rdx,%rax,4), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq 4096(%rdx,%rax), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xff,0x48,0xe6,0x7c,0x02,0x40]       
vcvtpd2dq 4096(%rdx,%rax), %ymm23 

// CHECK: vcvtpd2dq 4096(%rdx,%rax), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x4a,0xe6,0x7c,0x02,0x40]      
vcvtpd2dq 4096(%rdx,%rax), %ymm23 {%k2} 

// CHECK: vcvtpd2dq 4096(%rdx,%rax), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xca,0xe6,0x7c,0x02,0x40]     
vcvtpd2dq 4096(%rdx,%rax), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq 4096(%rdx), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xff,0x48,0xe6,0x7a,0x40]       
vcvtpd2dq 4096(%rdx), %ymm23 

// CHECK: vcvtpd2dq 4096(%rdx), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x4a,0xe6,0x7a,0x40]      
vcvtpd2dq 4096(%rdx), %ymm23 {%k2} 

// CHECK: vcvtpd2dq 4096(%rdx), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xca,0xe6,0x7a,0x40]     
vcvtpd2dq 4096(%rdx), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq 485498096{1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xff,0x58,0xe6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2dq 485498096{1to8}, %ymm23 

// CHECK: vcvtpd2dq 485498096{1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x5a,0xe6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2dq 485498096{1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2dq 485498096{1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xda,0xe6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2dq 485498096{1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq 485498096, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xff,0x48,0xe6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2dq 485498096, %ymm23 

// CHECK: vcvtpd2dq 485498096, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x4a,0xe6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2dq 485498096, %ymm23 {%k2} 

// CHECK: vcvtpd2dq 485498096, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xca,0xe6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2dq 485498096, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq 512(%rdx){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xff,0x58,0xe6,0x7a,0x40]       
vcvtpd2dq 512(%rdx){1to8}, %ymm23 

// CHECK: vcvtpd2dq 512(%rdx){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x5a,0xe6,0x7a,0x40]      
vcvtpd2dq 512(%rdx){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2dq 512(%rdx){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xda,0xe6,0x7a,0x40]     
vcvtpd2dq 512(%rdx){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq 512(%rdx,%rax){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xff,0x58,0xe6,0x7c,0x02,0x40]       
vcvtpd2dq 512(%rdx,%rax){1to8}, %ymm23 

// CHECK: vcvtpd2dq 512(%rdx,%rax){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x5a,0xe6,0x7c,0x02,0x40]      
vcvtpd2dq 512(%rdx,%rax){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2dq 512(%rdx,%rax){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xda,0xe6,0x7c,0x02,0x40]     
vcvtpd2dq 512(%rdx,%rax){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq 512(%rdx,%rax,4){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xff,0x58,0xe6,0x7c,0x82,0x40]       
vcvtpd2dq 512(%rdx,%rax,4){1to8}, %ymm23 

// CHECK: vcvtpd2dq -512(%rdx,%rax,4){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xff,0x58,0xe6,0x7c,0x82,0xc0]       
vcvtpd2dq -512(%rdx,%rax,4){1to8}, %ymm23 

// CHECK: vcvtpd2dq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x5a,0xe6,0x7c,0x82,0x40]      
vcvtpd2dq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2dq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x5a,0xe6,0x7c,0x82,0xc0]      
vcvtpd2dq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2dq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xda,0xe6,0x7c,0x82,0x40]     
vcvtpd2dq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xda,0xe6,0x7c,0x82,0xc0]     
vcvtpd2dq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq {rd-sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xff,0x38,0xe6,0xfb]      
vcvtpd2dq {rd-sae}, %zmm19, %ymm23 

// CHECK: vcvtpd2dq {rd-sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xff,0x3a,0xe6,0xfb]     
vcvtpd2dq {rd-sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2dq {rd-sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xff,0xba,0xe6,0xfb]    
vcvtpd2dq {rd-sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq (%rdx){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xff,0x58,0xe6,0x3a]       
vcvtpd2dq (%rdx){1to8}, %ymm23 

// CHECK: vcvtpd2dq (%rdx){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x5a,0xe6,0x3a]      
vcvtpd2dq (%rdx){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2dq (%rdx){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xda,0xe6,0x3a]     
vcvtpd2dq (%rdx){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq (%rdx), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xff,0x48,0xe6,0x3a]       
vcvtpd2dq (%rdx), %ymm23 

// CHECK: vcvtpd2dq (%rdx), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x4a,0xe6,0x3a]      
vcvtpd2dq (%rdx), %ymm23 {%k2} 

// CHECK: vcvtpd2dq (%rdx), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xca,0xe6,0x3a]     
vcvtpd2dq (%rdx), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq {rn-sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xff,0x18,0xe6,0xfb]      
vcvtpd2dq {rn-sae}, %zmm19, %ymm23 

// CHECK: vcvtpd2dq {rn-sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xff,0x1a,0xe6,0xfb]     
vcvtpd2dq {rn-sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2dq {rn-sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xff,0x9a,0xe6,0xfb]    
vcvtpd2dq {rn-sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq {ru-sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xff,0x58,0xe6,0xfb]      
vcvtpd2dq {ru-sae}, %zmm19, %ymm23 

// CHECK: vcvtpd2dq {ru-sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xff,0x5a,0xe6,0xfb]     
vcvtpd2dq {ru-sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2dq {ru-sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xff,0xda,0xe6,0xfb]    
vcvtpd2dq {ru-sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq {rz-sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xff,0x78,0xe6,0xfb]      
vcvtpd2dq {rz-sae}, %zmm19, %ymm23 

// CHECK: vcvtpd2dq {rz-sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xff,0x7a,0xe6,0xfb]     
vcvtpd2dq {rz-sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2dq {rz-sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xff,0xfa,0xe6,0xfb]    
vcvtpd2dq {rz-sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2dq %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xff,0x48,0xe6,0xfb]       
vcvtpd2dq %zmm19, %ymm23 

// CHECK: vcvtpd2dq %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xff,0x4a,0xe6,0xfb]      
vcvtpd2dq %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2dq %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xff,0xca,0xe6,0xfb]     
vcvtpd2dq %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps 4096(%rdx,%rax,4), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x5a,0x7c,0x82,0x40]       
vcvtpd2ps 4096(%rdx,%rax,4), %ymm23 

// CHECK: vcvtpd2ps -4096(%rdx,%rax,4), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x5a,0x7c,0x82,0xc0]       
vcvtpd2ps -4096(%rdx,%rax,4), %ymm23 

// CHECK: vcvtpd2ps 4096(%rdx,%rax,4), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x5a,0x7c,0x82,0x40]      
vcvtpd2ps 4096(%rdx,%rax,4), %ymm23 {%k2} 

// CHECK: vcvtpd2ps -4096(%rdx,%rax,4), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x5a,0x7c,0x82,0xc0]      
vcvtpd2ps -4096(%rdx,%rax,4), %ymm23 {%k2} 

// CHECK: vcvtpd2ps 4096(%rdx,%rax,4), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x5a,0x7c,0x82,0x40]     
vcvtpd2ps 4096(%rdx,%rax,4), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps -4096(%rdx,%rax,4), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x5a,0x7c,0x82,0xc0]     
vcvtpd2ps -4096(%rdx,%rax,4), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps 4096(%rdx,%rax), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x5a,0x7c,0x02,0x40]       
vcvtpd2ps 4096(%rdx,%rax), %ymm23 

// CHECK: vcvtpd2ps 4096(%rdx,%rax), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x5a,0x7c,0x02,0x40]      
vcvtpd2ps 4096(%rdx,%rax), %ymm23 {%k2} 

// CHECK: vcvtpd2ps 4096(%rdx,%rax), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x5a,0x7c,0x02,0x40]     
vcvtpd2ps 4096(%rdx,%rax), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps 4096(%rdx), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x5a,0x7a,0x40]       
vcvtpd2ps 4096(%rdx), %ymm23 

// CHECK: vcvtpd2ps 4096(%rdx), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x5a,0x7a,0x40]      
vcvtpd2ps 4096(%rdx), %ymm23 {%k2} 

// CHECK: vcvtpd2ps 4096(%rdx), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x5a,0x7a,0x40]     
vcvtpd2ps 4096(%rdx), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps 485498096{1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x58,0x5a,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2ps 485498096{1to8}, %ymm23 

// CHECK: vcvtpd2ps 485498096{1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x5a,0x5a,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2ps 485498096{1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2ps 485498096{1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xda,0x5a,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2ps 485498096{1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps 485498096, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x5a,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2ps 485498096, %ymm23 

// CHECK: vcvtpd2ps 485498096, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x5a,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2ps 485498096, %ymm23 {%k2} 

// CHECK: vcvtpd2ps 485498096, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x5a,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2ps 485498096, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps 512(%rdx){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x58,0x5a,0x7a,0x40]       
vcvtpd2ps 512(%rdx){1to8}, %ymm23 

// CHECK: vcvtpd2ps 512(%rdx){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x5a,0x5a,0x7a,0x40]      
vcvtpd2ps 512(%rdx){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2ps 512(%rdx){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xda,0x5a,0x7a,0x40]     
vcvtpd2ps 512(%rdx){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps 512(%rdx,%rax){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x58,0x5a,0x7c,0x02,0x40]       
vcvtpd2ps 512(%rdx,%rax){1to8}, %ymm23 

// CHECK: vcvtpd2ps 512(%rdx,%rax){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x5a,0x5a,0x7c,0x02,0x40]      
vcvtpd2ps 512(%rdx,%rax){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2ps 512(%rdx,%rax){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xda,0x5a,0x7c,0x02,0x40]     
vcvtpd2ps 512(%rdx,%rax){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps 512(%rdx,%rax,4){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x58,0x5a,0x7c,0x82,0x40]       
vcvtpd2ps 512(%rdx,%rax,4){1to8}, %ymm23 

// CHECK: vcvtpd2ps -512(%rdx,%rax,4){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x58,0x5a,0x7c,0x82,0xc0]       
vcvtpd2ps -512(%rdx,%rax,4){1to8}, %ymm23 

// CHECK: vcvtpd2ps 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x5a,0x5a,0x7c,0x82,0x40]      
vcvtpd2ps 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2ps -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x5a,0x5a,0x7c,0x82,0xc0]      
vcvtpd2ps -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2ps 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xda,0x5a,0x7c,0x82,0x40]     
vcvtpd2ps 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xda,0x5a,0x7c,0x82,0xc0]     
vcvtpd2ps -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps {rd-sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfd,0x38,0x5a,0xfb]      
vcvtpd2ps {rd-sae}, %zmm19, %ymm23 

// CHECK: vcvtpd2ps {rd-sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x3a,0x5a,0xfb]     
vcvtpd2ps {rd-sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2ps {rd-sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0xba,0x5a,0xfb]    
vcvtpd2ps {rd-sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps (%rdx){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x58,0x5a,0x3a]       
vcvtpd2ps (%rdx){1to8}, %ymm23 

// CHECK: vcvtpd2ps (%rdx){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x5a,0x5a,0x3a]      
vcvtpd2ps (%rdx){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2ps (%rdx){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xda,0x5a,0x3a]     
vcvtpd2ps (%rdx){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps (%rdx), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x5a,0x3a]       
vcvtpd2ps (%rdx), %ymm23 

// CHECK: vcvtpd2ps (%rdx), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x5a,0x3a]      
vcvtpd2ps (%rdx), %ymm23 {%k2} 

// CHECK: vcvtpd2ps (%rdx), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x5a,0x3a]     
vcvtpd2ps (%rdx), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps {rn-sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfd,0x18,0x5a,0xfb]      
vcvtpd2ps {rn-sae}, %zmm19, %ymm23 

// CHECK: vcvtpd2ps {rn-sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x1a,0x5a,0xfb]     
vcvtpd2ps {rn-sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2ps {rn-sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x9a,0x5a,0xfb]    
vcvtpd2ps {rn-sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps {ru-sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfd,0x58,0x5a,0xfb]      
vcvtpd2ps {ru-sae}, %zmm19, %ymm23 

// CHECK: vcvtpd2ps {ru-sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x5a,0x5a,0xfb]     
vcvtpd2ps {ru-sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2ps {ru-sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0xda,0x5a,0xfb]    
vcvtpd2ps {ru-sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps {rz-sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfd,0x78,0x5a,0xfb]      
vcvtpd2ps {rz-sae}, %zmm19, %ymm23 

// CHECK: vcvtpd2ps {rz-sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x7a,0x5a,0xfb]     
vcvtpd2ps {rz-sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2ps {rz-sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0xfa,0x5a,0xfb]    
vcvtpd2ps {rz-sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2ps %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfd,0x48,0x5a,0xfb]       
vcvtpd2ps %zmm19, %ymm23 

// CHECK: vcvtpd2ps %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x4a,0x5a,0xfb]      
vcvtpd2ps %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2ps %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0xca,0x5a,0xfb]     
vcvtpd2ps %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq 4096(%rdx,%rax,4), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x48,0x79,0x7c,0x82,0x40]       
vcvtpd2udq 4096(%rdx,%rax,4), %ymm23 

// CHECK: vcvtpd2udq -4096(%rdx,%rax,4), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x48,0x79,0x7c,0x82,0xc0]       
vcvtpd2udq -4096(%rdx,%rax,4), %ymm23 

// CHECK: vcvtpd2udq 4096(%rdx,%rax,4), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x4a,0x79,0x7c,0x82,0x40]      
vcvtpd2udq 4096(%rdx,%rax,4), %ymm23 {%k2} 

// CHECK: vcvtpd2udq -4096(%rdx,%rax,4), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x4a,0x79,0x7c,0x82,0xc0]      
vcvtpd2udq -4096(%rdx,%rax,4), %ymm23 {%k2} 

// CHECK: vcvtpd2udq 4096(%rdx,%rax,4), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xca,0x79,0x7c,0x82,0x40]     
vcvtpd2udq 4096(%rdx,%rax,4), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq -4096(%rdx,%rax,4), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xca,0x79,0x7c,0x82,0xc0]     
vcvtpd2udq -4096(%rdx,%rax,4), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq 4096(%rdx,%rax), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x48,0x79,0x7c,0x02,0x40]       
vcvtpd2udq 4096(%rdx,%rax), %ymm23 

// CHECK: vcvtpd2udq 4096(%rdx,%rax), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x4a,0x79,0x7c,0x02,0x40]      
vcvtpd2udq 4096(%rdx,%rax), %ymm23 {%k2} 

// CHECK: vcvtpd2udq 4096(%rdx,%rax), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xca,0x79,0x7c,0x02,0x40]     
vcvtpd2udq 4096(%rdx,%rax), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq 4096(%rdx), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x48,0x79,0x7a,0x40]       
vcvtpd2udq 4096(%rdx), %ymm23 

// CHECK: vcvtpd2udq 4096(%rdx), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x4a,0x79,0x7a,0x40]      
vcvtpd2udq 4096(%rdx), %ymm23 {%k2} 

// CHECK: vcvtpd2udq 4096(%rdx), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xca,0x79,0x7a,0x40]     
vcvtpd2udq 4096(%rdx), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq 485498096{1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x58,0x79,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2udq 485498096{1to8}, %ymm23 

// CHECK: vcvtpd2udq 485498096{1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x5a,0x79,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2udq 485498096{1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2udq 485498096{1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xda,0x79,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2udq 485498096{1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq 485498096, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x48,0x79,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2udq 485498096, %ymm23 

// CHECK: vcvtpd2udq 485498096, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x4a,0x79,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2udq 485498096, %ymm23 {%k2} 

// CHECK: vcvtpd2udq 485498096, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xca,0x79,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2udq 485498096, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq 512(%rdx){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x58,0x79,0x7a,0x40]       
vcvtpd2udq 512(%rdx){1to8}, %ymm23 

// CHECK: vcvtpd2udq 512(%rdx){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x5a,0x79,0x7a,0x40]      
vcvtpd2udq 512(%rdx){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2udq 512(%rdx){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xda,0x79,0x7a,0x40]     
vcvtpd2udq 512(%rdx){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq 512(%rdx,%rax){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x58,0x79,0x7c,0x02,0x40]       
vcvtpd2udq 512(%rdx,%rax){1to8}, %ymm23 

// CHECK: vcvtpd2udq 512(%rdx,%rax){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x5a,0x79,0x7c,0x02,0x40]      
vcvtpd2udq 512(%rdx,%rax){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2udq 512(%rdx,%rax){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xda,0x79,0x7c,0x02,0x40]     
vcvtpd2udq 512(%rdx,%rax){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq 512(%rdx,%rax,4){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x58,0x79,0x7c,0x82,0x40]       
vcvtpd2udq 512(%rdx,%rax,4){1to8}, %ymm23 

// CHECK: vcvtpd2udq -512(%rdx,%rax,4){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x58,0x79,0x7c,0x82,0xc0]       
vcvtpd2udq -512(%rdx,%rax,4){1to8}, %ymm23 

// CHECK: vcvtpd2udq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x5a,0x79,0x7c,0x82,0x40]      
vcvtpd2udq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2udq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x5a,0x79,0x7c,0x82,0xc0]      
vcvtpd2udq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2udq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xda,0x79,0x7c,0x82,0x40]     
vcvtpd2udq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xda,0x79,0x7c,0x82,0xc0]     
vcvtpd2udq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq {rd-sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfc,0x38,0x79,0xfb]      
vcvtpd2udq {rd-sae}, %zmm19, %ymm23 

// CHECK: vcvtpd2udq {rd-sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfc,0x3a,0x79,0xfb]     
vcvtpd2udq {rd-sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2udq {rd-sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfc,0xba,0x79,0xfb]    
vcvtpd2udq {rd-sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq (%rdx){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x58,0x79,0x3a]       
vcvtpd2udq (%rdx){1to8}, %ymm23 

// CHECK: vcvtpd2udq (%rdx){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x5a,0x79,0x3a]      
vcvtpd2udq (%rdx){1to8}, %ymm23 {%k2} 

// CHECK: vcvtpd2udq (%rdx){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xda,0x79,0x3a]     
vcvtpd2udq (%rdx){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq (%rdx), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x48,0x79,0x3a]       
vcvtpd2udq (%rdx), %ymm23 

// CHECK: vcvtpd2udq (%rdx), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x4a,0x79,0x3a]      
vcvtpd2udq (%rdx), %ymm23 {%k2} 

// CHECK: vcvtpd2udq (%rdx), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xca,0x79,0x3a]     
vcvtpd2udq (%rdx), %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq {rn-sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfc,0x18,0x79,0xfb]      
vcvtpd2udq {rn-sae}, %zmm19, %ymm23 

// CHECK: vcvtpd2udq {rn-sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfc,0x1a,0x79,0xfb]     
vcvtpd2udq {rn-sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2udq {rn-sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfc,0x9a,0x79,0xfb]    
vcvtpd2udq {rn-sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq {ru-sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfc,0x58,0x79,0xfb]      
vcvtpd2udq {ru-sae}, %zmm19, %ymm23 

// CHECK: vcvtpd2udq {ru-sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfc,0x5a,0x79,0xfb]     
vcvtpd2udq {ru-sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2udq {ru-sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfc,0xda,0x79,0xfb]    
vcvtpd2udq {ru-sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq {rz-sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfc,0x78,0x79,0xfb]      
vcvtpd2udq {rz-sae}, %zmm19, %ymm23 

// CHECK: vcvtpd2udq {rz-sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfc,0x7a,0x79,0xfb]     
vcvtpd2udq {rz-sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2udq {rz-sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfc,0xfa,0x79,0xfb]    
vcvtpd2udq {rz-sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtpd2udq %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfc,0x48,0x79,0xfb]       
vcvtpd2udq %zmm19, %ymm23 

// CHECK: vcvtpd2udq %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfc,0x4a,0x79,0xfb]      
vcvtpd2udq %zmm19, %ymm23 {%k2} 

// CHECK: vcvtpd2udq %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfc,0xca,0x79,0xfb]     
vcvtpd2udq %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtph2ps 2048(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x13,0x5c,0x82,0x40]       
vcvtph2ps 2048(%rdx,%rax,4), %zmm19 

// CHECK: vcvtph2ps -2048(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x13,0x5c,0x82,0xc0]       
vcvtph2ps -2048(%rdx,%rax,4), %zmm19 

// CHECK: vcvtph2ps 2048(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x13,0x5c,0x82,0x40]      
vcvtph2ps 2048(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtph2ps -2048(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x13,0x5c,0x82,0xc0]      
vcvtph2ps -2048(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtph2ps 2048(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x13,0x5c,0x82,0x40]     
vcvtph2ps 2048(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtph2ps -2048(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x13,0x5c,0x82,0xc0]     
vcvtph2ps -2048(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtph2ps 2048(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x13,0x5c,0x02,0x40]       
vcvtph2ps 2048(%rdx,%rax), %zmm19 

// CHECK: vcvtph2ps 2048(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x13,0x5c,0x02,0x40]      
vcvtph2ps 2048(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vcvtph2ps 2048(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x13,0x5c,0x02,0x40]     
vcvtph2ps 2048(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vcvtph2ps 2048(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x13,0x5a,0x40]       
vcvtph2ps 2048(%rdx), %zmm19 

// CHECK: vcvtph2ps 2048(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x13,0x5a,0x40]      
vcvtph2ps 2048(%rdx), %zmm19 {%k2} 

// CHECK: vcvtph2ps 2048(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x13,0x5a,0x40]     
vcvtph2ps 2048(%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtph2ps 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x13,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtph2ps 485498096, %zmm19 

// CHECK: vcvtph2ps 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x13,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtph2ps 485498096, %zmm19 {%k2} 

// CHECK: vcvtph2ps 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x13,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtph2ps 485498096, %zmm19 {%k2} {z} 

// CHECK: vcvtph2ps (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x13,0x1a]       
vcvtph2ps (%rdx), %zmm19 

// CHECK: vcvtph2ps (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x13,0x1a]      
vcvtph2ps (%rdx), %zmm19 {%k2} 

// CHECK: vcvtph2ps (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x13,0x1a]     
vcvtph2ps (%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtph2ps {sae}, %ymm23, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x7d,0x18,0x13,0xdf]      
vcvtph2ps {sae}, %ymm23, %zmm19 

// CHECK: vcvtph2ps {sae}, %ymm23, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x7d,0x1a,0x13,0xdf]     
vcvtph2ps {sae}, %ymm23, %zmm19 {%k2} 

// CHECK: vcvtph2ps {sae}, %ymm23, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x7d,0x9a,0x13,0xdf]    
vcvtph2ps {sae}, %ymm23, %zmm19 {%k2} {z} 

// CHECK: vcvtph2ps %ymm23, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x7d,0x48,0x13,0xdf]       
vcvtph2ps %ymm23, %zmm19 

// CHECK: vcvtph2ps %ymm23, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x13,0xdf]      
vcvtph2ps %ymm23, %zmm19 {%k2} 

// CHECK: vcvtph2ps %ymm23, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x7d,0xca,0x13,0xdf]     
vcvtph2ps %ymm23, %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq 256(%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x58,0x5b,0x5a,0x40]       
vcvtps2dq 256(%rdx){1to16}, %zmm19 

// CHECK: vcvtps2dq 256(%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x5a,0x5b,0x5a,0x40]      
vcvtps2dq 256(%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vcvtps2dq 256(%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xda,0x5b,0x5a,0x40]     
vcvtps2dq 256(%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq 256(%rdx,%rax){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x58,0x5b,0x5c,0x02,0x40]       
vcvtps2dq 256(%rdx,%rax){1to16}, %zmm19 

// CHECK: vcvtps2dq 256(%rdx,%rax){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x5a,0x5b,0x5c,0x02,0x40]      
vcvtps2dq 256(%rdx,%rax){1to16}, %zmm19 {%k2} 

// CHECK: vcvtps2dq 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xda,0x5b,0x5c,0x02,0x40]     
vcvtps2dq 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq 256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x58,0x5b,0x5c,0x82,0x40]       
vcvtps2dq 256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vcvtps2dq -256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x58,0x5b,0x5c,0x82,0xc0]       
vcvtps2dq -256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vcvtps2dq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x5a,0x5b,0x5c,0x82,0x40]      
vcvtps2dq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vcvtps2dq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x5a,0x5b,0x5c,0x82,0xc0]      
vcvtps2dq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vcvtps2dq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xda,0x5b,0x5c,0x82,0x40]     
vcvtps2dq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xda,0x5b,0x5c,0x82,0xc0]     
vcvtps2dq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x5b,0x5c,0x82,0x40]       
vcvtps2dq 4096(%rdx,%rax,4), %zmm19 

// CHECK: vcvtps2dq -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x5b,0x5c,0x82,0xc0]       
vcvtps2dq -4096(%rdx,%rax,4), %zmm19 

// CHECK: vcvtps2dq 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x5b,0x5c,0x82,0x40]      
vcvtps2dq 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtps2dq -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x5b,0x5c,0x82,0xc0]      
vcvtps2dq -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtps2dq 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xca,0x5b,0x5c,0x82,0x40]     
vcvtps2dq 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xca,0x5b,0x5c,0x82,0xc0]     
vcvtps2dq -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x5b,0x5c,0x02,0x40]       
vcvtps2dq 4096(%rdx,%rax), %zmm19 

// CHECK: vcvtps2dq 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x5b,0x5c,0x02,0x40]      
vcvtps2dq 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vcvtps2dq 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xca,0x5b,0x5c,0x02,0x40]     
vcvtps2dq 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x5b,0x5a,0x40]       
vcvtps2dq 4096(%rdx), %zmm19 

// CHECK: vcvtps2dq 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x5b,0x5a,0x40]      
vcvtps2dq 4096(%rdx), %zmm19 {%k2} 

// CHECK: vcvtps2dq 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xca,0x5b,0x5a,0x40]     
vcvtps2dq 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq 485498096{1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x58,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtps2dq 485498096{1to16}, %zmm19 

// CHECK: vcvtps2dq 485498096{1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x5a,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtps2dq 485498096{1to16}, %zmm19 {%k2} 

// CHECK: vcvtps2dq 485498096{1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xda,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtps2dq 485498096{1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtps2dq 485498096, %zmm19 

// CHECK: vcvtps2dq 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtps2dq 485498096, %zmm19 {%k2} 

// CHECK: vcvtps2dq 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xca,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtps2dq 485498096, %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq {rd-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7d,0x38,0x5b,0xdb]      
vcvtps2dq {rd-sae}, %zmm19, %zmm19 

// CHECK: vcvtps2dq {rd-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7d,0x3a,0x5b,0xdb]     
vcvtps2dq {rd-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtps2dq {rd-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7d,0xba,0x5b,0xdb]    
vcvtps2dq {rd-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq (%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x58,0x5b,0x1a]       
vcvtps2dq (%rdx){1to16}, %zmm19 

// CHECK: vcvtps2dq (%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x5a,0x5b,0x1a]      
vcvtps2dq (%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vcvtps2dq (%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xda,0x5b,0x1a]     
vcvtps2dq (%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x5b,0x1a]       
vcvtps2dq (%rdx), %zmm19 

// CHECK: vcvtps2dq (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x5b,0x1a]      
vcvtps2dq (%rdx), %zmm19 {%k2} 

// CHECK: vcvtps2dq (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xca,0x5b,0x1a]     
vcvtps2dq (%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq {rn-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7d,0x18,0x5b,0xdb]      
vcvtps2dq {rn-sae}, %zmm19, %zmm19 

// CHECK: vcvtps2dq {rn-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7d,0x1a,0x5b,0xdb]     
vcvtps2dq {rn-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtps2dq {rn-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7d,0x9a,0x5b,0xdb]    
vcvtps2dq {rn-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq {ru-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7d,0x58,0x5b,0xdb]      
vcvtps2dq {ru-sae}, %zmm19, %zmm19 

// CHECK: vcvtps2dq {ru-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7d,0x5a,0x5b,0xdb]     
vcvtps2dq {ru-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtps2dq {ru-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7d,0xda,0x5b,0xdb]    
vcvtps2dq {ru-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq {rz-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7d,0x78,0x5b,0xdb]      
vcvtps2dq {rz-sae}, %zmm19, %zmm19 

// CHECK: vcvtps2dq {rz-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7d,0x7a,0x5b,0xdb]     
vcvtps2dq {rz-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtps2dq {rz-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7d,0xfa,0x5b,0xdb]    
vcvtps2dq {rz-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtps2dq %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7d,0x48,0x5b,0xdb]       
vcvtps2dq %zmm19, %zmm19 

// CHECK: vcvtps2dq %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7d,0x4a,0x5b,0xdb]      
vcvtps2dq %zmm19, %zmm19 {%k2} 

// CHECK: vcvtps2dq %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7d,0xca,0x5b,0xdb]     
vcvtps2dq %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd 2048(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x5a,0x5c,0x82,0x40]       
vcvtps2pd 2048(%rdx,%rax,4), %zmm19 

// CHECK: vcvtps2pd -2048(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x5a,0x5c,0x82,0xc0]       
vcvtps2pd -2048(%rdx,%rax,4), %zmm19 

// CHECK: vcvtps2pd 2048(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x5a,0x5c,0x82,0x40]      
vcvtps2pd 2048(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtps2pd -2048(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x5a,0x5c,0x82,0xc0]      
vcvtps2pd -2048(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtps2pd 2048(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x5a,0x5c,0x82,0x40]     
vcvtps2pd 2048(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd -2048(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x5a,0x5c,0x82,0xc0]     
vcvtps2pd -2048(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd 2048(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x5a,0x5c,0x02,0x40]       
vcvtps2pd 2048(%rdx,%rax), %zmm19 

// CHECK: vcvtps2pd 2048(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x5a,0x5c,0x02,0x40]      
vcvtps2pd 2048(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vcvtps2pd 2048(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x5a,0x5c,0x02,0x40]     
vcvtps2pd 2048(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd 2048(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x5a,0x5a,0x40]       
vcvtps2pd 2048(%rdx), %zmm19 

// CHECK: vcvtps2pd 2048(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x5a,0x5a,0x40]      
vcvtps2pd 2048(%rdx), %zmm19 {%k2} 

// CHECK: vcvtps2pd 2048(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x5a,0x5a,0x40]     
vcvtps2pd 2048(%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd 256(%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x5a,0x5a,0x40]       
vcvtps2pd 256(%rdx){1to8}, %zmm19 

// CHECK: vcvtps2pd 256(%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x5a,0x5a,0x40]      
vcvtps2pd 256(%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vcvtps2pd 256(%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x5a,0x5a,0x40]     
vcvtps2pd 256(%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd 256(%rdx,%rax){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x5a,0x5c,0x02,0x40]       
vcvtps2pd 256(%rdx,%rax){1to8}, %zmm19 

// CHECK: vcvtps2pd 256(%rdx,%rax){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x5a,0x5c,0x02,0x40]      
vcvtps2pd 256(%rdx,%rax){1to8}, %zmm19 {%k2} 

// CHECK: vcvtps2pd 256(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x5a,0x5c,0x02,0x40]     
vcvtps2pd 256(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd 256(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x5a,0x5c,0x82,0x40]       
vcvtps2pd 256(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vcvtps2pd -256(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x5a,0x5c,0x82,0xc0]       
vcvtps2pd -256(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vcvtps2pd 256(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x5a,0x5c,0x82,0x40]      
vcvtps2pd 256(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vcvtps2pd -256(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x5a,0x5c,0x82,0xc0]      
vcvtps2pd -256(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vcvtps2pd 256(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x5a,0x5c,0x82,0x40]     
vcvtps2pd 256(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd -256(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x5a,0x5c,0x82,0xc0]     
vcvtps2pd -256(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd 485498096{1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x5a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtps2pd 485498096{1to8}, %zmm19 

// CHECK: vcvtps2pd 485498096{1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x5a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtps2pd 485498096{1to8}, %zmm19 {%k2} 

// CHECK: vcvtps2pd 485498096{1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x5a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtps2pd 485498096{1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x5a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtps2pd 485498096, %zmm19 

// CHECK: vcvtps2pd 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x5a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtps2pd 485498096, %zmm19 {%k2} 

// CHECK: vcvtps2pd 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x5a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtps2pd 485498096, %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd (%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x5a,0x1a]       
vcvtps2pd (%rdx){1to8}, %zmm19 

// CHECK: vcvtps2pd (%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x5a,0x1a]      
vcvtps2pd (%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vcvtps2pd (%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x5a,0x1a]     
vcvtps2pd (%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x5a,0x1a]       
vcvtps2pd (%rdx), %zmm19 

// CHECK: vcvtps2pd (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x5a,0x1a]      
vcvtps2pd (%rdx), %zmm19 {%k2} 

// CHECK: vcvtps2pd (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x5a,0x1a]     
vcvtps2pd (%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd {sae}, %ymm23, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x18,0x5a,0xdf]      
vcvtps2pd {sae}, %ymm23, %zmm19 

// CHECK: vcvtps2pd {sae}, %ymm23, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x1a,0x5a,0xdf]     
vcvtps2pd {sae}, %ymm23, %zmm19 {%k2} 

// CHECK: vcvtps2pd {sae}, %ymm23, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x9a,0x5a,0xdf]    
vcvtps2pd {sae}, %ymm23, %zmm19 {%k2} {z} 

// CHECK: vcvtps2pd %ymm23, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x48,0x5a,0xdf]       
vcvtps2pd %ymm23, %zmm19 

// CHECK: vcvtps2pd %ymm23, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x4a,0x5a,0xdf]      
vcvtps2pd %ymm23, %zmm19 {%k2} 

// CHECK: vcvtps2pd %ymm23, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xca,0x5a,0xdf]     
vcvtps2pd %ymm23, %zmm19 {%k2} {z} 

// CHECK: vcvtps2ph $0, {sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa3,0x7d,0x18,0x1d,0xdf,0x00]     
vcvtps2ph $0, {sae}, %zmm19, %ymm23 

// CHECK: vcvtps2ph $0, {sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa3,0x7d,0x1a,0x1d,0xdf,0x00]    
vcvtps2ph $0, {sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtps2ph $0, {sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0x7d,0x9a,0x1d,0xdf,0x00]   
vcvtps2ph $0, {sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtps2ph $0, %zmm19, 2048(%rdx) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x1d,0x5a,0x40,0x00]      
vcvtps2ph $0, %zmm19, 2048(%rdx) 

// CHECK: vcvtps2ph $0, %zmm19, 2048(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x1d,0x5a,0x40,0x00]     
vcvtps2ph $0, %zmm19, 2048(%rdx) {%k2} 

// CHECK: vcvtps2ph $0, %zmm19, 2048(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x1d,0x5c,0x82,0x40,0x00]      
vcvtps2ph $0, %zmm19, 2048(%rdx,%rax,4) 

// CHECK: vcvtps2ph $0, %zmm19, -2048(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x1d,0x5c,0x82,0xc0,0x00]      
vcvtps2ph $0, %zmm19, -2048(%rdx,%rax,4) 

// CHECK: vcvtps2ph $0, %zmm19, 2048(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x1d,0x5c,0x82,0x40,0x00]     
vcvtps2ph $0, %zmm19, 2048(%rdx,%rax,4) {%k2} 

// CHECK: vcvtps2ph $0, %zmm19, -2048(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x1d,0x5c,0x82,0xc0,0x00]     
vcvtps2ph $0, %zmm19, -2048(%rdx,%rax,4) {%k2} 

// CHECK: vcvtps2ph $0, %zmm19, 2048(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x1d,0x5c,0x02,0x40,0x00]      
vcvtps2ph $0, %zmm19, 2048(%rdx,%rax) 

// CHECK: vcvtps2ph $0, %zmm19, 2048(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x1d,0x5c,0x02,0x40,0x00]     
vcvtps2ph $0, %zmm19, 2048(%rdx,%rax) {%k2} 

// CHECK: vcvtps2ph $0, %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x1d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vcvtps2ph $0, %zmm19, 485498096 

// CHECK: vcvtps2ph $0, %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x1d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vcvtps2ph $0, %zmm19, 485498096 {%k2} 

// CHECK: vcvtps2ph $0, %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x1d,0x1a,0x00]      
vcvtps2ph $0, %zmm19, (%rdx) 

// CHECK: vcvtps2ph $0, %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x1d,0x1a,0x00]     
vcvtps2ph $0, %zmm19, (%rdx) {%k2} 

// CHECK: vcvtps2ph $0, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa3,0x7d,0x48,0x1d,0xdf,0x00]      
vcvtps2ph $0, %zmm19, %ymm23 

// CHECK: vcvtps2ph $0, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa3,0x7d,0x4a,0x1d,0xdf,0x00]     
vcvtps2ph $0, %zmm19, %ymm23 {%k2} 

// CHECK: vcvtps2ph $0, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0x7d,0xca,0x1d,0xdf,0x00]    
vcvtps2ph $0, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvtps2udq 256(%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x79,0x5a,0x40]       
vcvtps2udq 256(%rdx){1to16}, %zmm19 

// CHECK: vcvtps2udq 256(%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x79,0x5a,0x40]      
vcvtps2udq 256(%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vcvtps2udq 256(%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x79,0x5a,0x40]     
vcvtps2udq 256(%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq 256(%rdx,%rax){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x79,0x5c,0x02,0x40]       
vcvtps2udq 256(%rdx,%rax){1to16}, %zmm19 

// CHECK: vcvtps2udq 256(%rdx,%rax){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x79,0x5c,0x02,0x40]      
vcvtps2udq 256(%rdx,%rax){1to16}, %zmm19 {%k2} 

// CHECK: vcvtps2udq 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x79,0x5c,0x02,0x40]     
vcvtps2udq 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq 256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x79,0x5c,0x82,0x40]       
vcvtps2udq 256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vcvtps2udq -256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x79,0x5c,0x82,0xc0]       
vcvtps2udq -256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vcvtps2udq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x79,0x5c,0x82,0x40]      
vcvtps2udq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vcvtps2udq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x79,0x5c,0x82,0xc0]      
vcvtps2udq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vcvtps2udq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x79,0x5c,0x82,0x40]     
vcvtps2udq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x79,0x5c,0x82,0xc0]     
vcvtps2udq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x79,0x5c,0x82,0x40]       
vcvtps2udq 4096(%rdx,%rax,4), %zmm19 

// CHECK: vcvtps2udq -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x79,0x5c,0x82,0xc0]       
vcvtps2udq -4096(%rdx,%rax,4), %zmm19 

// CHECK: vcvtps2udq 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x79,0x5c,0x82,0x40]      
vcvtps2udq 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtps2udq -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x79,0x5c,0x82,0xc0]      
vcvtps2udq -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtps2udq 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x79,0x5c,0x82,0x40]     
vcvtps2udq 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x79,0x5c,0x82,0xc0]     
vcvtps2udq -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x79,0x5c,0x02,0x40]       
vcvtps2udq 4096(%rdx,%rax), %zmm19 

// CHECK: vcvtps2udq 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x79,0x5c,0x02,0x40]      
vcvtps2udq 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vcvtps2udq 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x79,0x5c,0x02,0x40]     
vcvtps2udq 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x79,0x5a,0x40]       
vcvtps2udq 4096(%rdx), %zmm19 

// CHECK: vcvtps2udq 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x79,0x5a,0x40]      
vcvtps2udq 4096(%rdx), %zmm19 {%k2} 

// CHECK: vcvtps2udq 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x79,0x5a,0x40]     
vcvtps2udq 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq 485498096{1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x79,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtps2udq 485498096{1to16}, %zmm19 

// CHECK: vcvtps2udq 485498096{1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x79,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtps2udq 485498096{1to16}, %zmm19 {%k2} 

// CHECK: vcvtps2udq 485498096{1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x79,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtps2udq 485498096{1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x79,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtps2udq 485498096, %zmm19 

// CHECK: vcvtps2udq 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x79,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtps2udq 485498096, %zmm19 {%k2} 

// CHECK: vcvtps2udq 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x79,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtps2udq 485498096, %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq {rd-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x38,0x79,0xdb]      
vcvtps2udq {rd-sae}, %zmm19, %zmm19 

// CHECK: vcvtps2udq {rd-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x3a,0x79,0xdb]     
vcvtps2udq {rd-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtps2udq {rd-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xba,0x79,0xdb]    
vcvtps2udq {rd-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq (%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x79,0x1a]       
vcvtps2udq (%rdx){1to16}, %zmm19 

// CHECK: vcvtps2udq (%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x79,0x1a]      
vcvtps2udq (%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vcvtps2udq (%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x79,0x1a]     
vcvtps2udq (%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x79,0x1a]       
vcvtps2udq (%rdx), %zmm19 

// CHECK: vcvtps2udq (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x79,0x1a]      
vcvtps2udq (%rdx), %zmm19 {%k2} 

// CHECK: vcvtps2udq (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x79,0x1a]     
vcvtps2udq (%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq {rn-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x18,0x79,0xdb]      
vcvtps2udq {rn-sae}, %zmm19, %zmm19 

// CHECK: vcvtps2udq {rn-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x1a,0x79,0xdb]     
vcvtps2udq {rn-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtps2udq {rn-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x9a,0x79,0xdb]    
vcvtps2udq {rn-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq {ru-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x58,0x79,0xdb]      
vcvtps2udq {ru-sae}, %zmm19, %zmm19 

// CHECK: vcvtps2udq {ru-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x5a,0x79,0xdb]     
vcvtps2udq {ru-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtps2udq {ru-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xda,0x79,0xdb]    
vcvtps2udq {ru-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq {rz-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x78,0x79,0xdb]      
vcvtps2udq {rz-sae}, %zmm19, %zmm19 

// CHECK: vcvtps2udq {rz-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x7a,0x79,0xdb]     
vcvtps2udq {rz-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtps2udq {rz-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xfa,0x79,0xdb]    
vcvtps2udq {rz-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtps2udq %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x48,0x79,0xdb]       
vcvtps2udq %zmm19, %zmm19 

// CHECK: vcvtps2udq %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x4a,0x79,0xdb]      
vcvtps2udq %zmm19, %zmm19 {%k2} 

// CHECK: vcvtps2udq %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xca,0x79,0xdb]     
vcvtps2udq %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvttpd2dq 4096(%rdx,%rax,4), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0xe6,0x7c,0x82,0x40]       
vcvttpd2dq 4096(%rdx,%rax,4), %ymm23 

// CHECK: vcvttpd2dq -4096(%rdx,%rax,4), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0xe6,0x7c,0x82,0xc0]       
vcvttpd2dq -4096(%rdx,%rax,4), %ymm23 

// CHECK: vcvttpd2dq 4096(%rdx,%rax,4), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0xe6,0x7c,0x82,0x40]      
vcvttpd2dq 4096(%rdx,%rax,4), %ymm23 {%k2} 

// CHECK: vcvttpd2dq -4096(%rdx,%rax,4), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0xe6,0x7c,0x82,0xc0]      
vcvttpd2dq -4096(%rdx,%rax,4), %ymm23 {%k2} 

// CHECK: vcvttpd2dq 4096(%rdx,%rax,4), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0xe6,0x7c,0x82,0x40]     
vcvttpd2dq 4096(%rdx,%rax,4), %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq -4096(%rdx,%rax,4), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0xe6,0x7c,0x82,0xc0]     
vcvttpd2dq -4096(%rdx,%rax,4), %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq 4096(%rdx,%rax), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0xe6,0x7c,0x02,0x40]       
vcvttpd2dq 4096(%rdx,%rax), %ymm23 

// CHECK: vcvttpd2dq 4096(%rdx,%rax), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0xe6,0x7c,0x02,0x40]      
vcvttpd2dq 4096(%rdx,%rax), %ymm23 {%k2} 

// CHECK: vcvttpd2dq 4096(%rdx,%rax), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0xe6,0x7c,0x02,0x40]     
vcvttpd2dq 4096(%rdx,%rax), %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq 4096(%rdx), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0xe6,0x7a,0x40]       
vcvttpd2dq 4096(%rdx), %ymm23 

// CHECK: vcvttpd2dq 4096(%rdx), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0xe6,0x7a,0x40]      
vcvttpd2dq 4096(%rdx), %ymm23 {%k2} 

// CHECK: vcvttpd2dq 4096(%rdx), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0xe6,0x7a,0x40]     
vcvttpd2dq 4096(%rdx), %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq 485498096{1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x58,0xe6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2dq 485498096{1to8}, %ymm23 

// CHECK: vcvttpd2dq 485498096{1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x5a,0xe6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2dq 485498096{1to8}, %ymm23 {%k2} 

// CHECK: vcvttpd2dq 485498096{1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xda,0xe6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2dq 485498096{1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq 485498096, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0xe6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2dq 485498096, %ymm23 

// CHECK: vcvttpd2dq 485498096, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0xe6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2dq 485498096, %ymm23 {%k2} 

// CHECK: vcvttpd2dq 485498096, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0xe6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2dq 485498096, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq 512(%rdx){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x58,0xe6,0x7a,0x40]       
vcvttpd2dq 512(%rdx){1to8}, %ymm23 

// CHECK: vcvttpd2dq 512(%rdx){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x5a,0xe6,0x7a,0x40]      
vcvttpd2dq 512(%rdx){1to8}, %ymm23 {%k2} 

// CHECK: vcvttpd2dq 512(%rdx){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xda,0xe6,0x7a,0x40]     
vcvttpd2dq 512(%rdx){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq 512(%rdx,%rax){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x58,0xe6,0x7c,0x02,0x40]       
vcvttpd2dq 512(%rdx,%rax){1to8}, %ymm23 

// CHECK: vcvttpd2dq 512(%rdx,%rax){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x5a,0xe6,0x7c,0x02,0x40]      
vcvttpd2dq 512(%rdx,%rax){1to8}, %ymm23 {%k2} 

// CHECK: vcvttpd2dq 512(%rdx,%rax){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xda,0xe6,0x7c,0x02,0x40]     
vcvttpd2dq 512(%rdx,%rax){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq 512(%rdx,%rax,4){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x58,0xe6,0x7c,0x82,0x40]       
vcvttpd2dq 512(%rdx,%rax,4){1to8}, %ymm23 

// CHECK: vcvttpd2dq -512(%rdx,%rax,4){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x58,0xe6,0x7c,0x82,0xc0]       
vcvttpd2dq -512(%rdx,%rax,4){1to8}, %ymm23 

// CHECK: vcvttpd2dq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x5a,0xe6,0x7c,0x82,0x40]      
vcvttpd2dq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 

// CHECK: vcvttpd2dq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x5a,0xe6,0x7c,0x82,0xc0]      
vcvttpd2dq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 

// CHECK: vcvttpd2dq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xda,0xe6,0x7c,0x82,0x40]     
vcvttpd2dq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xda,0xe6,0x7c,0x82,0xc0]     
vcvttpd2dq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq (%rdx){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x58,0xe6,0x3a]       
vcvttpd2dq (%rdx){1to8}, %ymm23 

// CHECK: vcvttpd2dq (%rdx){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x5a,0xe6,0x3a]      
vcvttpd2dq (%rdx){1to8}, %ymm23 {%k2} 

// CHECK: vcvttpd2dq (%rdx){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xda,0xe6,0x3a]     
vcvttpd2dq (%rdx){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq (%rdx), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0xe6,0x3a]       
vcvttpd2dq (%rdx), %ymm23 

// CHECK: vcvttpd2dq (%rdx), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0xe6,0x3a]      
vcvttpd2dq (%rdx), %ymm23 {%k2} 

// CHECK: vcvttpd2dq (%rdx), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0xe6,0x3a]     
vcvttpd2dq (%rdx), %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq {sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfd,0x18,0xe6,0xfb]      
vcvttpd2dq {sae}, %zmm19, %ymm23 

// CHECK: vcvttpd2dq {sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x1a,0xe6,0xfb]     
vcvttpd2dq {sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvttpd2dq {sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x9a,0xe6,0xfb]    
vcvttpd2dq {sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2dq %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfd,0x48,0xe6,0xfb]       
vcvttpd2dq %zmm19, %ymm23 

// CHECK: vcvttpd2dq %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x4a,0xe6,0xfb]      
vcvttpd2dq %zmm19, %ymm23 {%k2} 

// CHECK: vcvttpd2dq %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0xca,0xe6,0xfb]     
vcvttpd2dq %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq 4096(%rdx,%rax,4), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x48,0x78,0x7c,0x82,0x40]       
vcvttpd2udq 4096(%rdx,%rax,4), %ymm23 

// CHECK: vcvttpd2udq -4096(%rdx,%rax,4), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x48,0x78,0x7c,0x82,0xc0]       
vcvttpd2udq -4096(%rdx,%rax,4), %ymm23 

// CHECK: vcvttpd2udq 4096(%rdx,%rax,4), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x4a,0x78,0x7c,0x82,0x40]      
vcvttpd2udq 4096(%rdx,%rax,4), %ymm23 {%k2} 

// CHECK: vcvttpd2udq -4096(%rdx,%rax,4), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x4a,0x78,0x7c,0x82,0xc0]      
vcvttpd2udq -4096(%rdx,%rax,4), %ymm23 {%k2} 

// CHECK: vcvttpd2udq 4096(%rdx,%rax,4), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xca,0x78,0x7c,0x82,0x40]     
vcvttpd2udq 4096(%rdx,%rax,4), %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq -4096(%rdx,%rax,4), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xca,0x78,0x7c,0x82,0xc0]     
vcvttpd2udq -4096(%rdx,%rax,4), %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq 4096(%rdx,%rax), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x48,0x78,0x7c,0x02,0x40]       
vcvttpd2udq 4096(%rdx,%rax), %ymm23 

// CHECK: vcvttpd2udq 4096(%rdx,%rax), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x4a,0x78,0x7c,0x02,0x40]      
vcvttpd2udq 4096(%rdx,%rax), %ymm23 {%k2} 

// CHECK: vcvttpd2udq 4096(%rdx,%rax), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xca,0x78,0x7c,0x02,0x40]     
vcvttpd2udq 4096(%rdx,%rax), %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq 4096(%rdx), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x48,0x78,0x7a,0x40]       
vcvttpd2udq 4096(%rdx), %ymm23 

// CHECK: vcvttpd2udq 4096(%rdx), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x4a,0x78,0x7a,0x40]      
vcvttpd2udq 4096(%rdx), %ymm23 {%k2} 

// CHECK: vcvttpd2udq 4096(%rdx), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xca,0x78,0x7a,0x40]     
vcvttpd2udq 4096(%rdx), %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq 485498096{1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x58,0x78,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2udq 485498096{1to8}, %ymm23 

// CHECK: vcvttpd2udq 485498096{1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x5a,0x78,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2udq 485498096{1to8}, %ymm23 {%k2} 

// CHECK: vcvttpd2udq 485498096{1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xda,0x78,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2udq 485498096{1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq 485498096, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x48,0x78,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2udq 485498096, %ymm23 

// CHECK: vcvttpd2udq 485498096, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x4a,0x78,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2udq 485498096, %ymm23 {%k2} 

// CHECK: vcvttpd2udq 485498096, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xca,0x78,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2udq 485498096, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq 512(%rdx){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x58,0x78,0x7a,0x40]       
vcvttpd2udq 512(%rdx){1to8}, %ymm23 

// CHECK: vcvttpd2udq 512(%rdx){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x5a,0x78,0x7a,0x40]      
vcvttpd2udq 512(%rdx){1to8}, %ymm23 {%k2} 

// CHECK: vcvttpd2udq 512(%rdx){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xda,0x78,0x7a,0x40]     
vcvttpd2udq 512(%rdx){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq 512(%rdx,%rax){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x58,0x78,0x7c,0x02,0x40]       
vcvttpd2udq 512(%rdx,%rax){1to8}, %ymm23 

// CHECK: vcvttpd2udq 512(%rdx,%rax){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x5a,0x78,0x7c,0x02,0x40]      
vcvttpd2udq 512(%rdx,%rax){1to8}, %ymm23 {%k2} 

// CHECK: vcvttpd2udq 512(%rdx,%rax){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xda,0x78,0x7c,0x02,0x40]     
vcvttpd2udq 512(%rdx,%rax){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq 512(%rdx,%rax,4){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x58,0x78,0x7c,0x82,0x40]       
vcvttpd2udq 512(%rdx,%rax,4){1to8}, %ymm23 

// CHECK: vcvttpd2udq -512(%rdx,%rax,4){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x58,0x78,0x7c,0x82,0xc0]       
vcvttpd2udq -512(%rdx,%rax,4){1to8}, %ymm23 

// CHECK: vcvttpd2udq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x5a,0x78,0x7c,0x82,0x40]      
vcvttpd2udq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 

// CHECK: vcvttpd2udq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x5a,0x78,0x7c,0x82,0xc0]      
vcvttpd2udq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} 

// CHECK: vcvttpd2udq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xda,0x78,0x7c,0x82,0x40]     
vcvttpd2udq 512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xda,0x78,0x7c,0x82,0xc0]     
vcvttpd2udq -512(%rdx,%rax,4){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq (%rdx){1to8}, %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x58,0x78,0x3a]       
vcvttpd2udq (%rdx){1to8}, %ymm23 

// CHECK: vcvttpd2udq (%rdx){1to8}, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x5a,0x78,0x3a]      
vcvttpd2udq (%rdx){1to8}, %ymm23 {%k2} 

// CHECK: vcvttpd2udq (%rdx){1to8}, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xda,0x78,0x3a]     
vcvttpd2udq (%rdx){1to8}, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq (%rdx), %ymm23 
// CHECK: encoding: [0x62,0xe1,0xfc,0x48,0x78,0x3a]       
vcvttpd2udq (%rdx), %ymm23 

// CHECK: vcvttpd2udq (%rdx), %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfc,0x4a,0x78,0x3a]      
vcvttpd2udq (%rdx), %ymm23 {%k2} 

// CHECK: vcvttpd2udq (%rdx), %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfc,0xca,0x78,0x3a]     
vcvttpd2udq (%rdx), %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq {sae}, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfc,0x18,0x78,0xfb]      
vcvttpd2udq {sae}, %zmm19, %ymm23 

// CHECK: vcvttpd2udq {sae}, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfc,0x1a,0x78,0xfb]     
vcvttpd2udq {sae}, %zmm19, %ymm23 {%k2} 

// CHECK: vcvttpd2udq {sae}, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfc,0x9a,0x78,0xfb]    
vcvttpd2udq {sae}, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvttpd2udq %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa1,0xfc,0x48,0x78,0xfb]       
vcvttpd2udq %zmm19, %ymm23 

// CHECK: vcvttpd2udq %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfc,0x4a,0x78,0xfb]      
vcvttpd2udq %zmm19, %ymm23 {%k2} 

// CHECK: vcvttpd2udq %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfc,0xca,0x78,0xfb]     
vcvttpd2udq %zmm19, %ymm23 {%k2} {z} 

// CHECK: vcvttps2dq 256(%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0x5b,0x5a,0x40]       
vcvttps2dq 256(%rdx){1to16}, %zmm19 

// CHECK: vcvttps2dq 256(%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0x5b,0x5a,0x40]      
vcvttps2dq 256(%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vcvttps2dq 256(%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0x5b,0x5a,0x40]     
vcvttps2dq 256(%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq 256(%rdx,%rax){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0x5b,0x5c,0x02,0x40]       
vcvttps2dq 256(%rdx,%rax){1to16}, %zmm19 

// CHECK: vcvttps2dq 256(%rdx,%rax){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0x5b,0x5c,0x02,0x40]      
vcvttps2dq 256(%rdx,%rax){1to16}, %zmm19 {%k2} 

// CHECK: vcvttps2dq 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0x5b,0x5c,0x02,0x40]     
vcvttps2dq 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq 256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0x5b,0x5c,0x82,0x40]       
vcvttps2dq 256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vcvttps2dq -256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0x5b,0x5c,0x82,0xc0]       
vcvttps2dq -256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vcvttps2dq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0x5b,0x5c,0x82,0x40]      
vcvttps2dq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vcvttps2dq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0x5b,0x5c,0x82,0xc0]      
vcvttps2dq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vcvttps2dq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0x5b,0x5c,0x82,0x40]     
vcvttps2dq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0x5b,0x5c,0x82,0xc0]     
vcvttps2dq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x5b,0x5c,0x82,0x40]       
vcvttps2dq 4096(%rdx,%rax,4), %zmm19 

// CHECK: vcvttps2dq -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x5b,0x5c,0x82,0xc0]       
vcvttps2dq -4096(%rdx,%rax,4), %zmm19 

// CHECK: vcvttps2dq 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x5b,0x5c,0x82,0x40]      
vcvttps2dq 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvttps2dq -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x5b,0x5c,0x82,0xc0]      
vcvttps2dq -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvttps2dq 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x5b,0x5c,0x82,0x40]     
vcvttps2dq 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x5b,0x5c,0x82,0xc0]     
vcvttps2dq -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x5b,0x5c,0x02,0x40]       
vcvttps2dq 4096(%rdx,%rax), %zmm19 

// CHECK: vcvttps2dq 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x5b,0x5c,0x02,0x40]      
vcvttps2dq 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vcvttps2dq 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x5b,0x5c,0x02,0x40]     
vcvttps2dq 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x5b,0x5a,0x40]       
vcvttps2dq 4096(%rdx), %zmm19 

// CHECK: vcvttps2dq 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x5b,0x5a,0x40]      
vcvttps2dq 4096(%rdx), %zmm19 {%k2} 

// CHECK: vcvttps2dq 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x5b,0x5a,0x40]     
vcvttps2dq 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq 485498096{1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvttps2dq 485498096{1to16}, %zmm19 

// CHECK: vcvttps2dq 485498096{1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvttps2dq 485498096{1to16}, %zmm19 {%k2} 

// CHECK: vcvttps2dq 485498096{1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvttps2dq 485498096{1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvttps2dq 485498096, %zmm19 

// CHECK: vcvttps2dq 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvttps2dq 485498096, %zmm19 {%k2} 

// CHECK: vcvttps2dq 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x5b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvttps2dq 485498096, %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq (%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0x5b,0x1a]       
vcvttps2dq (%rdx){1to16}, %zmm19 

// CHECK: vcvttps2dq (%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0x5b,0x1a]      
vcvttps2dq (%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vcvttps2dq (%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0x5b,0x1a]     
vcvttps2dq (%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x5b,0x1a]       
vcvttps2dq (%rdx), %zmm19 

// CHECK: vcvttps2dq (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x5b,0x1a]      
vcvttps2dq (%rdx), %zmm19 {%k2} 

// CHECK: vcvttps2dq (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x5b,0x1a]     
vcvttps2dq (%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq {sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7e,0x18,0x5b,0xdb]      
vcvttps2dq {sae}, %zmm19, %zmm19 

// CHECK: vcvttps2dq {sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7e,0x1a,0x5b,0xdb]     
vcvttps2dq {sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvttps2dq {sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7e,0x9a,0x5b,0xdb]    
vcvttps2dq {sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvttps2dq %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7e,0x48,0x5b,0xdb]       
vcvttps2dq %zmm19, %zmm19 

// CHECK: vcvttps2dq %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7e,0x4a,0x5b,0xdb]      
vcvttps2dq %zmm19, %zmm19 {%k2} 

// CHECK: vcvttps2dq %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7e,0xca,0x5b,0xdb]     
vcvttps2dq %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq 256(%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x78,0x5a,0x40]       
vcvttps2udq 256(%rdx){1to16}, %zmm19 

// CHECK: vcvttps2udq 256(%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x78,0x5a,0x40]      
vcvttps2udq 256(%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vcvttps2udq 256(%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x78,0x5a,0x40]     
vcvttps2udq 256(%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq 256(%rdx,%rax){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x78,0x5c,0x02,0x40]       
vcvttps2udq 256(%rdx,%rax){1to16}, %zmm19 

// CHECK: vcvttps2udq 256(%rdx,%rax){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x78,0x5c,0x02,0x40]      
vcvttps2udq 256(%rdx,%rax){1to16}, %zmm19 {%k2} 

// CHECK: vcvttps2udq 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x78,0x5c,0x02,0x40]     
vcvttps2udq 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq 256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x78,0x5c,0x82,0x40]       
vcvttps2udq 256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vcvttps2udq -256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x78,0x5c,0x82,0xc0]       
vcvttps2udq -256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vcvttps2udq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x78,0x5c,0x82,0x40]      
vcvttps2udq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vcvttps2udq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x78,0x5c,0x82,0xc0]      
vcvttps2udq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vcvttps2udq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x78,0x5c,0x82,0x40]     
vcvttps2udq 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x78,0x5c,0x82,0xc0]     
vcvttps2udq -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x78,0x5c,0x82,0x40]       
vcvttps2udq 4096(%rdx,%rax,4), %zmm19 

// CHECK: vcvttps2udq -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x78,0x5c,0x82,0xc0]       
vcvttps2udq -4096(%rdx,%rax,4), %zmm19 

// CHECK: vcvttps2udq 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x78,0x5c,0x82,0x40]      
vcvttps2udq 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvttps2udq -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x78,0x5c,0x82,0xc0]      
vcvttps2udq -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvttps2udq 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x78,0x5c,0x82,0x40]     
vcvttps2udq 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x78,0x5c,0x82,0xc0]     
vcvttps2udq -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x78,0x5c,0x02,0x40]       
vcvttps2udq 4096(%rdx,%rax), %zmm19 

// CHECK: vcvttps2udq 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x78,0x5c,0x02,0x40]      
vcvttps2udq 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vcvttps2udq 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x78,0x5c,0x02,0x40]     
vcvttps2udq 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x78,0x5a,0x40]       
vcvttps2udq 4096(%rdx), %zmm19 

// CHECK: vcvttps2udq 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x78,0x5a,0x40]      
vcvttps2udq 4096(%rdx), %zmm19 {%k2} 

// CHECK: vcvttps2udq 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x78,0x5a,0x40]     
vcvttps2udq 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq 485498096{1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x78,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvttps2udq 485498096{1to16}, %zmm19 

// CHECK: vcvttps2udq 485498096{1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x78,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvttps2udq 485498096{1to16}, %zmm19 {%k2} 

// CHECK: vcvttps2udq 485498096{1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x78,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvttps2udq 485498096{1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x78,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvttps2udq 485498096, %zmm19 

// CHECK: vcvttps2udq 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x78,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvttps2udq 485498096, %zmm19 {%k2} 

// CHECK: vcvttps2udq 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x78,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvttps2udq 485498096, %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq (%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x58,0x78,0x1a]       
vcvttps2udq (%rdx){1to16}, %zmm19 

// CHECK: vcvttps2udq (%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x5a,0x78,0x1a]      
vcvttps2udq (%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vcvttps2udq (%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xda,0x78,0x1a]     
vcvttps2udq (%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x78,0x1a]       
vcvttps2udq (%rdx), %zmm19 

// CHECK: vcvttps2udq (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x78,0x1a]      
vcvttps2udq (%rdx), %zmm19 {%k2} 

// CHECK: vcvttps2udq (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x78,0x1a]     
vcvttps2udq (%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq {sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x18,0x78,0xdb]      
vcvttps2udq {sae}, %zmm19, %zmm19 

// CHECK: vcvttps2udq {sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x1a,0x78,0xdb]     
vcvttps2udq {sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvttps2udq {sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x9a,0x78,0xdb]    
vcvttps2udq {sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvttps2udq %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x48,0x78,0xdb]       
vcvttps2udq %zmm19, %zmm19 

// CHECK: vcvttps2udq %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x4a,0x78,0xdb]      
vcvttps2udq %zmm19, %zmm19 {%k2} 

// CHECK: vcvttps2udq %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xca,0x78,0xdb]     
vcvttps2udq %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd 2048(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x5c,0x82,0x40]       
vcvtudq2pd 2048(%rdx,%rax,4), %zmm19 

// CHECK: vcvtudq2pd -2048(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x5c,0x82,0xc0]       
vcvtudq2pd -2048(%rdx,%rax,4), %zmm19 

// CHECK: vcvtudq2pd 2048(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x7a,0x5c,0x82,0x40]      
vcvtudq2pd 2048(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtudq2pd -2048(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x7a,0x5c,0x82,0xc0]      
vcvtudq2pd -2048(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtudq2pd 2048(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x7a,0x5c,0x82,0x40]     
vcvtudq2pd 2048(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd -2048(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x7a,0x5c,0x82,0xc0]     
vcvtudq2pd -2048(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd 2048(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x5c,0x02,0x40]       
vcvtudq2pd 2048(%rdx,%rax), %zmm19 

// CHECK: vcvtudq2pd 2048(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x7a,0x5c,0x02,0x40]      
vcvtudq2pd 2048(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vcvtudq2pd 2048(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x7a,0x5c,0x02,0x40]     
vcvtudq2pd 2048(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd 2048(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x5a,0x40]       
vcvtudq2pd 2048(%rdx), %zmm19 

// CHECK: vcvtudq2pd 2048(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x7a,0x5a,0x40]      
vcvtudq2pd 2048(%rdx), %zmm19 {%k2} 

// CHECK: vcvtudq2pd 2048(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x7a,0x5a,0x40]     
vcvtudq2pd 2048(%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd 256(%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x5a,0x40]       
vcvtudq2pd 256(%rdx){1to8}, %zmm19 

// CHECK: vcvtudq2pd 256(%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0x7a,0x5a,0x40]      
vcvtudq2pd 256(%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vcvtudq2pd 256(%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0x7a,0x5a,0x40]     
vcvtudq2pd 256(%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd 256(%rdx,%rax){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x5c,0x02,0x40]       
vcvtudq2pd 256(%rdx,%rax){1to8}, %zmm19 

// CHECK: vcvtudq2pd 256(%rdx,%rax){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0x7a,0x5c,0x02,0x40]      
vcvtudq2pd 256(%rdx,%rax){1to8}, %zmm19 {%k2} 

// CHECK: vcvtudq2pd 256(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0x7a,0x5c,0x02,0x40]     
vcvtudq2pd 256(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd 256(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x5c,0x82,0x40]       
vcvtudq2pd 256(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vcvtudq2pd -256(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x5c,0x82,0xc0]       
vcvtudq2pd -256(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vcvtudq2pd 256(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0x7a,0x5c,0x82,0x40]      
vcvtudq2pd 256(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vcvtudq2pd -256(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0x7a,0x5c,0x82,0xc0]      
vcvtudq2pd -256(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vcvtudq2pd 256(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0x7a,0x5c,0x82,0x40]     
vcvtudq2pd 256(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd -256(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0x7a,0x5c,0x82,0xc0]     
vcvtudq2pd -256(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd 485498096{1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2pd 485498096{1to8}, %zmm19 

// CHECK: vcvtudq2pd 485498096{1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0x7a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2pd 485498096{1to8}, %zmm19 {%k2} 

// CHECK: vcvtudq2pd 485498096{1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0x7a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2pd 485498096{1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2pd 485498096, %zmm19 

// CHECK: vcvtudq2pd 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x7a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2pd 485498096, %zmm19 {%k2} 

// CHECK: vcvtudq2pd 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x7a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2pd 485498096, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd (%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x1a]       
vcvtudq2pd (%rdx){1to8}, %zmm19 

// CHECK: vcvtudq2pd (%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x5a,0x7a,0x1a]      
vcvtudq2pd (%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vcvtudq2pd (%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xda,0x7a,0x1a]     
vcvtudq2pd (%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x1a]       
vcvtudq2pd (%rdx), %zmm19 

// CHECK: vcvtudq2pd (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x7a,0x1a]      
vcvtudq2pd (%rdx), %zmm19 {%k2} 

// CHECK: vcvtudq2pd (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x7a,0x1a]     
vcvtudq2pd (%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtudq2pd %ymm23, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7e,0x48,0x7a,0xdf]       
vcvtudq2pd %ymm23, %zmm19 

// CHECK: vcvtudq2pd %ymm23, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7e,0x4a,0x7a,0xdf]      
vcvtudq2pd %ymm23, %zmm19 {%k2} 

// CHECK: vcvtudq2pd %ymm23, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7e,0xca,0x7a,0xdf]     
vcvtudq2pd %ymm23, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps 256(%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7f,0x58,0x7a,0x5a,0x40]       
vcvtudq2ps 256(%rdx){1to16}, %zmm19 

// CHECK: vcvtudq2ps 256(%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7f,0x5a,0x7a,0x5a,0x40]      
vcvtudq2ps 256(%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vcvtudq2ps 256(%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7f,0xda,0x7a,0x5a,0x40]     
vcvtudq2ps 256(%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps 256(%rdx,%rax){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7f,0x58,0x7a,0x5c,0x02,0x40]       
vcvtudq2ps 256(%rdx,%rax){1to16}, %zmm19 

// CHECK: vcvtudq2ps 256(%rdx,%rax){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7f,0x5a,0x7a,0x5c,0x02,0x40]      
vcvtudq2ps 256(%rdx,%rax){1to16}, %zmm19 {%k2} 

// CHECK: vcvtudq2ps 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7f,0xda,0x7a,0x5c,0x02,0x40]     
vcvtudq2ps 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps 256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7f,0x58,0x7a,0x5c,0x82,0x40]       
vcvtudq2ps 256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vcvtudq2ps -256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7f,0x58,0x7a,0x5c,0x82,0xc0]       
vcvtudq2ps -256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vcvtudq2ps 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7f,0x5a,0x7a,0x5c,0x82,0x40]      
vcvtudq2ps 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vcvtudq2ps -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7f,0x5a,0x7a,0x5c,0x82,0xc0]      
vcvtudq2ps -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vcvtudq2ps 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7f,0xda,0x7a,0x5c,0x82,0x40]     
vcvtudq2ps 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7f,0xda,0x7a,0x5c,0x82,0xc0]     
vcvtudq2ps -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7f,0x48,0x7a,0x5c,0x82,0x40]       
vcvtudq2ps 4096(%rdx,%rax,4), %zmm19 

// CHECK: vcvtudq2ps -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7f,0x48,0x7a,0x5c,0x82,0xc0]       
vcvtudq2ps -4096(%rdx,%rax,4), %zmm19 

// CHECK: vcvtudq2ps 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7f,0x4a,0x7a,0x5c,0x82,0x40]      
vcvtudq2ps 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtudq2ps -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7f,0x4a,0x7a,0x5c,0x82,0xc0]      
vcvtudq2ps -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vcvtudq2ps 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7f,0xca,0x7a,0x5c,0x82,0x40]     
vcvtudq2ps 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7f,0xca,0x7a,0x5c,0x82,0xc0]     
vcvtudq2ps -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7f,0x48,0x7a,0x5c,0x02,0x40]       
vcvtudq2ps 4096(%rdx,%rax), %zmm19 

// CHECK: vcvtudq2ps 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7f,0x4a,0x7a,0x5c,0x02,0x40]      
vcvtudq2ps 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vcvtudq2ps 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7f,0xca,0x7a,0x5c,0x02,0x40]     
vcvtudq2ps 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7f,0x48,0x7a,0x5a,0x40]       
vcvtudq2ps 4096(%rdx), %zmm19 

// CHECK: vcvtudq2ps 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7f,0x4a,0x7a,0x5a,0x40]      
vcvtudq2ps 4096(%rdx), %zmm19 {%k2} 

// CHECK: vcvtudq2ps 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7f,0xca,0x7a,0x5a,0x40]     
vcvtudq2ps 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps 485498096{1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7f,0x58,0x7a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2ps 485498096{1to16}, %zmm19 

// CHECK: vcvtudq2ps 485498096{1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7f,0x5a,0x7a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2ps 485498096{1to16}, %zmm19 {%k2} 

// CHECK: vcvtudq2ps 485498096{1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7f,0xda,0x7a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2ps 485498096{1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7f,0x48,0x7a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2ps 485498096, %zmm19 

// CHECK: vcvtudq2ps 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7f,0x4a,0x7a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2ps 485498096, %zmm19 {%k2} 

// CHECK: vcvtudq2ps 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7f,0xca,0x7a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2ps 485498096, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps {rd-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7f,0x38,0x7a,0xdb]      
vcvtudq2ps {rd-sae}, %zmm19, %zmm19 

// CHECK: vcvtudq2ps {rd-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7f,0x3a,0x7a,0xdb]     
vcvtudq2ps {rd-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtudq2ps {rd-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7f,0xba,0x7a,0xdb]    
vcvtudq2ps {rd-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps (%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7f,0x58,0x7a,0x1a]       
vcvtudq2ps (%rdx){1to16}, %zmm19 

// CHECK: vcvtudq2ps (%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7f,0x5a,0x7a,0x1a]      
vcvtudq2ps (%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vcvtudq2ps (%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7f,0xda,0x7a,0x1a]     
vcvtudq2ps (%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7f,0x48,0x7a,0x1a]       
vcvtudq2ps (%rdx), %zmm19 

// CHECK: vcvtudq2ps (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7f,0x4a,0x7a,0x1a]      
vcvtudq2ps (%rdx), %zmm19 {%k2} 

// CHECK: vcvtudq2ps (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7f,0xca,0x7a,0x1a]     
vcvtudq2ps (%rdx), %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps {rn-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7f,0x18,0x7a,0xdb]      
vcvtudq2ps {rn-sae}, %zmm19, %zmm19 

// CHECK: vcvtudq2ps {rn-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7f,0x1a,0x7a,0xdb]     
vcvtudq2ps {rn-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtudq2ps {rn-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7f,0x9a,0x7a,0xdb]    
vcvtudq2ps {rn-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps {ru-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7f,0x58,0x7a,0xdb]      
vcvtudq2ps {ru-sae}, %zmm19, %zmm19 

// CHECK: vcvtudq2ps {ru-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7f,0x5a,0x7a,0xdb]     
vcvtudq2ps {ru-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtudq2ps {ru-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7f,0xda,0x7a,0xdb]    
vcvtudq2ps {ru-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps {rz-sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7f,0x78,0x7a,0xdb]      
vcvtudq2ps {rz-sae}, %zmm19, %zmm19 

// CHECK: vcvtudq2ps {rz-sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7f,0x7a,0x7a,0xdb]     
vcvtudq2ps {rz-sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vcvtudq2ps {rz-sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7f,0xfa,0x7a,0xdb]    
vcvtudq2ps {rz-sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vcvtudq2ps %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7f,0x48,0x7a,0xdb]       
vcvtudq2ps %zmm19, %zmm19 

// CHECK: vcvtudq2ps %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7f,0x4a,0x7a,0xdb]      
vcvtudq2ps %zmm19, %zmm19 {%k2} 

// CHECK: vcvtudq2ps %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7f,0xca,0x7a,0xdb]     
vcvtudq2ps %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5e,0x5c,0x82,0x40]      
vdivpd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vdivpd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5e,0x5c,0x82,0xc0]      
vdivpd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vdivpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5e,0x5c,0x82,0x40]     
vdivpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5e,0x5c,0x82,0xc0]     
vdivpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5e,0x5c,0x82,0x40]    
vdivpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5e,0x5c,0x82,0xc0]    
vdivpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5e,0x5c,0x02,0x40]      
vdivpd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vdivpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5e,0x5c,0x02,0x40]     
vdivpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5e,0x5c,0x02,0x40]    
vdivpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5e,0x5a,0x40]      
vdivpd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vdivpd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5e,0x5a,0x40]     
vdivpd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5e,0x5a,0x40]    
vdivpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vdivpd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vdivpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vdivpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vdivpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vdivpd 485498096, %zmm19, %zmm19 

// CHECK: vdivpd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vdivpd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vdivpd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5e,0x5a,0x40]      
vdivpd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vdivpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5e,0x5a,0x40]     
vdivpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5e,0x5a,0x40]    
vdivpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5e,0x5c,0x02,0x40]      
vdivpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vdivpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5e,0x5c,0x02,0x40]     
vdivpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5e,0x5c,0x02,0x40]    
vdivpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5e,0x5c,0x82,0x40]      
vdivpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vdivpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5e,0x5c,0x82,0xc0]      
vdivpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vdivpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5e,0x5c,0x82,0x40]     
vdivpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5e,0x5c,0x82,0xc0]     
vdivpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5e,0x5c,0x82,0x40]    
vdivpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5e,0x5c,0x82,0xc0]    
vdivpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x30,0x5e,0xdb]     
vdivpd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vdivpd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x32,0x5e,0xdb]    
vdivpd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xb2,0x5e,0xdb]   
vdivpd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5e,0x1a]      
vdivpd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vdivpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5e,0x1a]     
vdivpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5e,0x1a]    
vdivpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5e,0x1a]      
vdivpd (%rdx), %zmm19, %zmm19 

// CHECK: vdivpd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5e,0x1a]     
vdivpd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5e,0x1a]    
vdivpd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x10,0x5e,0xdb]     
vdivpd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vdivpd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x12,0x5e,0xdb]    
vdivpd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x92,0x5e,0xdb]   
vdivpd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x50,0x5e,0xdb]     
vdivpd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vdivpd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x52,0x5e,0xdb]    
vdivpd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xd2,0x5e,0xdb]   
vdivpd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x70,0x5e,0xdb]     
vdivpd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vdivpd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x72,0x5e,0xdb]    
vdivpd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xf2,0x5e,0xdb]   
vdivpd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivpd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x40,0x5e,0xdb]      
vdivpd %zmm19, %zmm19, %zmm19 

// CHECK: vdivpd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x42,0x5e,0xdb]     
vdivpd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vdivpd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xc2,0x5e,0xdb]    
vdivpd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5e,0x5a,0x40]      
vdivps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vdivps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5e,0x5a,0x40]     
vdivps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vdivps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5e,0x5a,0x40]    
vdivps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5e,0x5c,0x02,0x40]      
vdivps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vdivps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5e,0x5c,0x02,0x40]     
vdivps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vdivps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5e,0x5c,0x02,0x40]    
vdivps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5e,0x5c,0x82,0x40]      
vdivps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vdivps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5e,0x5c,0x82,0xc0]      
vdivps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vdivps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5e,0x5c,0x82,0x40]     
vdivps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vdivps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5e,0x5c,0x82,0xc0]     
vdivps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vdivps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5e,0x5c,0x82,0x40]    
vdivps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5e,0x5c,0x82,0xc0]    
vdivps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5e,0x5c,0x82,0x40]      
vdivps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vdivps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5e,0x5c,0x82,0xc0]      
vdivps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vdivps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5e,0x5c,0x82,0x40]     
vdivps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vdivps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5e,0x5c,0x82,0xc0]     
vdivps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vdivps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5e,0x5c,0x82,0x40]    
vdivps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5e,0x5c,0x82,0xc0]    
vdivps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5e,0x5c,0x02,0x40]      
vdivps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vdivps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5e,0x5c,0x02,0x40]     
vdivps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vdivps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5e,0x5c,0x02,0x40]    
vdivps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5e,0x5a,0x40]      
vdivps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vdivps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5e,0x5a,0x40]     
vdivps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vdivps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5e,0x5a,0x40]    
vdivps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vdivps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vdivps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vdivps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vdivps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vdivps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vdivps 485498096, %zmm19, %zmm19 

// CHECK: vdivps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vdivps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vdivps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vdivps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x30,0x5e,0xdb]     
vdivps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vdivps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x32,0x5e,0xdb]    
vdivps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vdivps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xb2,0x5e,0xdb]   
vdivps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5e,0x1a]      
vdivps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vdivps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5e,0x1a]     
vdivps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vdivps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5e,0x1a]    
vdivps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5e,0x1a]      
vdivps (%rdx), %zmm19, %zmm19 

// CHECK: vdivps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5e,0x1a]     
vdivps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vdivps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5e,0x1a]    
vdivps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x10,0x5e,0xdb]     
vdivps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vdivps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x12,0x5e,0xdb]    
vdivps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vdivps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0x92,0x5e,0xdb]   
vdivps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x50,0x5e,0xdb]     
vdivps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vdivps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x52,0x5e,0xdb]    
vdivps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vdivps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xd2,0x5e,0xdb]   
vdivps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x70,0x5e,0xdb]     
vdivps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vdivps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x72,0x5e,0xdb]    
vdivps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vdivps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xf2,0x5e,0xdb]   
vdivps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vdivps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x40,0x5e,0xdb]      
vdivps %zmm19, %zmm19, %zmm19 

// CHECK: vdivps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x42,0x5e,0xdb]     
vdivps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vdivps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xc2,0x5e,0xdb]    
vdivps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vexpandpd 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x88,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vexpandpd 485498096, %zmm19 

// CHECK: vexpandpd 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x88,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vexpandpd 485498096, %zmm19 {%k2} 

// CHECK: vexpandpd 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x88,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vexpandpd 485498096, %zmm19 {%k2} {z} 

// CHECK: vexpandpd 512(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x88,0x5c,0x82,0x40]       
vexpandpd 512(%rdx,%rax,4), %zmm19 

// CHECK: vexpandpd -512(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x88,0x5c,0x82,0xc0]       
vexpandpd -512(%rdx,%rax,4), %zmm19 

// CHECK: vexpandpd 512(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x88,0x5c,0x82,0x40]      
vexpandpd 512(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vexpandpd -512(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x88,0x5c,0x82,0xc0]      
vexpandpd -512(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vexpandpd 512(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x88,0x5c,0x82,0x40]     
vexpandpd 512(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vexpandpd -512(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x88,0x5c,0x82,0xc0]     
vexpandpd -512(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vexpandpd 512(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x88,0x5c,0x02,0x40]       
vexpandpd 512(%rdx,%rax), %zmm19 

// CHECK: vexpandpd 512(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x88,0x5c,0x02,0x40]      
vexpandpd 512(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vexpandpd 512(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x88,0x5c,0x02,0x40]     
vexpandpd 512(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vexpandpd 512(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x88,0x5a,0x40]       
vexpandpd 512(%rdx), %zmm19 

// CHECK: vexpandpd 512(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x88,0x5a,0x40]      
vexpandpd 512(%rdx), %zmm19 {%k2} 

// CHECK: vexpandpd 512(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x88,0x5a,0x40]     
vexpandpd 512(%rdx), %zmm19 {%k2} {z} 

// CHECK: vexpandpd (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x88,0x1a]       
vexpandpd (%rdx), %zmm19 

// CHECK: vexpandpd (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x88,0x1a]      
vexpandpd (%rdx), %zmm19 {%k2} 

// CHECK: vexpandpd (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x88,0x1a]     
vexpandpd (%rdx), %zmm19 {%k2} {z} 

// CHECK: vexpandpd %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xfd,0x48,0x88,0xdb]       
vexpandpd %zmm19, %zmm19 

// CHECK: vexpandpd %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x88,0xdb]      
vexpandpd %zmm19, %zmm19 {%k2} 

// CHECK: vexpandpd %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xfd,0xca,0x88,0xdb]     
vexpandpd %zmm19, %zmm19 {%k2} {z} 

// CHECK: vexpandps 256(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x88,0x5c,0x82,0x40]       
vexpandps 256(%rdx,%rax,4), %zmm19 

// CHECK: vexpandps -256(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x88,0x5c,0x82,0xc0]       
vexpandps -256(%rdx,%rax,4), %zmm19 

// CHECK: vexpandps 256(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x88,0x5c,0x82,0x40]      
vexpandps 256(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vexpandps -256(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x88,0x5c,0x82,0xc0]      
vexpandps -256(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vexpandps 256(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x88,0x5c,0x82,0x40]     
vexpandps 256(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vexpandps -256(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x88,0x5c,0x82,0xc0]     
vexpandps -256(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vexpandps 256(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x88,0x5c,0x02,0x40]       
vexpandps 256(%rdx,%rax), %zmm19 

// CHECK: vexpandps 256(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x88,0x5c,0x02,0x40]      
vexpandps 256(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vexpandps 256(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x88,0x5c,0x02,0x40]     
vexpandps 256(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vexpandps 256(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x88,0x5a,0x40]       
vexpandps 256(%rdx), %zmm19 

// CHECK: vexpandps 256(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x88,0x5a,0x40]      
vexpandps 256(%rdx), %zmm19 {%k2} 

// CHECK: vexpandps 256(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x88,0x5a,0x40]     
vexpandps 256(%rdx), %zmm19 {%k2} {z} 

// CHECK: vexpandps 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x88,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vexpandps 485498096, %zmm19 

// CHECK: vexpandps 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x88,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vexpandps 485498096, %zmm19 {%k2} 

// CHECK: vexpandps 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x88,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vexpandps 485498096, %zmm19 {%k2} {z} 

// CHECK: vexpandps (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x88,0x1a]       
vexpandps (%rdx), %zmm19 

// CHECK: vexpandps (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x88,0x1a]      
vexpandps (%rdx), %zmm19 {%k2} 

// CHECK: vexpandps (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x88,0x1a]     
vexpandps (%rdx), %zmm19 {%k2} {z} 

// CHECK: vexpandps %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x7d,0x48,0x88,0xdb]       
vexpandps %zmm19, %zmm19 

// CHECK: vexpandps %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x88,0xdb]      
vexpandps %zmm19, %zmm19 {%k2} 

// CHECK: vexpandps %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x7d,0xca,0x88,0xdb]     
vexpandps %zmm19, %zmm19 {%k2} {z} 

// CHECK: vextractf32x4 $0, %zmm19, 1024(%rdx) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x19,0x5a,0x40,0x00]      
vextractf32x4 $0, %zmm19, 1024(%rdx) 

// CHECK: vextractf32x4 $0, %zmm19, 1024(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x19,0x5a,0x40,0x00]     
vextractf32x4 $0, %zmm19, 1024(%rdx) {%k2} 

// CHECK: vextractf32x4 $0, %zmm19, 1024(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x19,0x5c,0x82,0x40,0x00]      
vextractf32x4 $0, %zmm19, 1024(%rdx,%rax,4) 

// CHECK: vextractf32x4 $0, %zmm19, -1024(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x19,0x5c,0x82,0xc0,0x00]      
vextractf32x4 $0, %zmm19, -1024(%rdx,%rax,4) 

// CHECK: vextractf32x4 $0, %zmm19, 1024(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x19,0x5c,0x82,0x40,0x00]     
vextractf32x4 $0, %zmm19, 1024(%rdx,%rax,4) {%k2} 

// CHECK: vextractf32x4 $0, %zmm19, -1024(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x19,0x5c,0x82,0xc0,0x00]     
vextractf32x4 $0, %zmm19, -1024(%rdx,%rax,4) {%k2} 

// CHECK: vextractf32x4 $0, %zmm19, 1024(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x19,0x5c,0x02,0x40,0x00]      
vextractf32x4 $0, %zmm19, 1024(%rdx,%rax) 

// CHECK: vextractf32x4 $0, %zmm19, 1024(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x19,0x5c,0x02,0x40,0x00]     
vextractf32x4 $0, %zmm19, 1024(%rdx,%rax) {%k2} 

// CHECK: vextractf32x4 $0, %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x19,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vextractf32x4 $0, %zmm19, 485498096 

// CHECK: vextractf32x4 $0, %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x19,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vextractf32x4 $0, %zmm19, 485498096 {%k2} 

// CHECK: vextractf32x4 $0, %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x19,0x1a,0x00]      
vextractf32x4 $0, %zmm19, (%rdx) 

// CHECK: vextractf32x4 $0, %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x19,0x1a,0x00]     
vextractf32x4 $0, %zmm19, (%rdx) {%k2} 

// CHECK: vextractf32x4 $0, %zmm19, %xmm15 
// CHECK: encoding: [0x62,0xc3,0x7d,0x48,0x19,0xdf,0x00]      
vextractf32x4 $0, %zmm19, %xmm15 

// CHECK: vextractf32x4 $0, %zmm19, %xmm15 {%k2} 
// CHECK: encoding: [0x62,0xc3,0x7d,0x4a,0x19,0xdf,0x00]     
vextractf32x4 $0, %zmm19, %xmm15 {%k2} 

// CHECK: vextractf32x4 $0, %zmm19, %xmm15 {%k2} {z} 
// CHECK: encoding: [0x62,0xc3,0x7d,0xca,0x19,0xdf,0x00]    
vextractf32x4 $0, %zmm19, %xmm15 {%k2} {z} 

// CHECK: vextractf32x4 $0, %zmm19, %xmm1 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x19,0xd9,0x00]      
vextractf32x4 $0, %zmm19, %xmm1 

// CHECK: vextractf32x4 $0, %zmm19, %xmm1 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x19,0xd9,0x00]     
vextractf32x4 $0, %zmm19, %xmm1 {%k2} 

// CHECK: vextractf32x4 $0, %zmm19, %xmm1 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x19,0xd9,0x00]    
vextractf32x4 $0, %zmm19, %xmm1 {%k2} {z} 

// CHECK: vextractf64x4 $0, %zmm19, 2048(%rdx) 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x1b,0x5a,0x40,0x00]      
vextractf64x4 $0, %zmm19, 2048(%rdx) 

// CHECK: vextractf64x4 $0, %zmm19, 2048(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x1b,0x5a,0x40,0x00]     
vextractf64x4 $0, %zmm19, 2048(%rdx) {%k2} 

// CHECK: vextractf64x4 $0, %zmm19, 2048(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x1b,0x5c,0x82,0x40,0x00]      
vextractf64x4 $0, %zmm19, 2048(%rdx,%rax,4) 

// CHECK: vextractf64x4 $0, %zmm19, -2048(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x1b,0x5c,0x82,0xc0,0x00]      
vextractf64x4 $0, %zmm19, -2048(%rdx,%rax,4) 

// CHECK: vextractf64x4 $0, %zmm19, 2048(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x1b,0x5c,0x82,0x40,0x00]     
vextractf64x4 $0, %zmm19, 2048(%rdx,%rax,4) {%k2} 

// CHECK: vextractf64x4 $0, %zmm19, -2048(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x1b,0x5c,0x82,0xc0,0x00]     
vextractf64x4 $0, %zmm19, -2048(%rdx,%rax,4) {%k2} 

// CHECK: vextractf64x4 $0, %zmm19, 2048(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x1b,0x5c,0x02,0x40,0x00]      
vextractf64x4 $0, %zmm19, 2048(%rdx,%rax) 

// CHECK: vextractf64x4 $0, %zmm19, 2048(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x1b,0x5c,0x02,0x40,0x00]     
vextractf64x4 $0, %zmm19, 2048(%rdx,%rax) {%k2} 

// CHECK: vextractf64x4 $0, %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x1b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vextractf64x4 $0, %zmm19, 485498096 

// CHECK: vextractf64x4 $0, %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x1b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vextractf64x4 $0, %zmm19, 485498096 {%k2} 

// CHECK: vextractf64x4 $0, %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x1b,0x1a,0x00]      
vextractf64x4 $0, %zmm19, (%rdx) 

// CHECK: vextractf64x4 $0, %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x1b,0x1a,0x00]     
vextractf64x4 $0, %zmm19, (%rdx) {%k2} 

// CHECK: vextractf64x4 $0, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa3,0xfd,0x48,0x1b,0xdf,0x00]      
vextractf64x4 $0, %zmm19, %ymm23 

// CHECK: vextractf64x4 $0, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa3,0xfd,0x4a,0x1b,0xdf,0x00]     
vextractf64x4 $0, %zmm19, %ymm23 {%k2} 

// CHECK: vextractf64x4 $0, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0xfd,0xca,0x1b,0xdf,0x00]    
vextractf64x4 $0, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vextracti32x4 $0, %zmm19, 1024(%rdx) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x39,0x5a,0x40,0x00]      
vextracti32x4 $0, %zmm19, 1024(%rdx) 

// CHECK: vextracti32x4 $0, %zmm19, 1024(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x39,0x5a,0x40,0x00]     
vextracti32x4 $0, %zmm19, 1024(%rdx) {%k2} 

// CHECK: vextracti32x4 $0, %zmm19, 1024(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x39,0x5c,0x82,0x40,0x00]      
vextracti32x4 $0, %zmm19, 1024(%rdx,%rax,4) 

// CHECK: vextracti32x4 $0, %zmm19, -1024(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x39,0x5c,0x82,0xc0,0x00]      
vextracti32x4 $0, %zmm19, -1024(%rdx,%rax,4) 

// CHECK: vextracti32x4 $0, %zmm19, 1024(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x39,0x5c,0x82,0x40,0x00]     
vextracti32x4 $0, %zmm19, 1024(%rdx,%rax,4) {%k2} 

// CHECK: vextracti32x4 $0, %zmm19, -1024(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x39,0x5c,0x82,0xc0,0x00]     
vextracti32x4 $0, %zmm19, -1024(%rdx,%rax,4) {%k2} 

// CHECK: vextracti32x4 $0, %zmm19, 1024(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x39,0x5c,0x02,0x40,0x00]      
vextracti32x4 $0, %zmm19, 1024(%rdx,%rax) 

// CHECK: vextracti32x4 $0, %zmm19, 1024(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x39,0x5c,0x02,0x40,0x00]     
vextracti32x4 $0, %zmm19, 1024(%rdx,%rax) {%k2} 

// CHECK: vextracti32x4 $0, %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vextracti32x4 $0, %zmm19, 485498096 

// CHECK: vextracti32x4 $0, %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vextracti32x4 $0, %zmm19, 485498096 {%k2} 

// CHECK: vextracti32x4 $0, %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x39,0x1a,0x00]      
vextracti32x4 $0, %zmm19, (%rdx) 

// CHECK: vextracti32x4 $0, %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x39,0x1a,0x00]     
vextracti32x4 $0, %zmm19, (%rdx) {%k2} 

// CHECK: vextracti32x4 $0, %zmm19, %xmm15 
// CHECK: encoding: [0x62,0xc3,0x7d,0x48,0x39,0xdf,0x00]      
vextracti32x4 $0, %zmm19, %xmm15 

// CHECK: vextracti32x4 $0, %zmm19, %xmm15 {%k2} 
// CHECK: encoding: [0x62,0xc3,0x7d,0x4a,0x39,0xdf,0x00]     
vextracti32x4 $0, %zmm19, %xmm15 {%k2} 

// CHECK: vextracti32x4 $0, %zmm19, %xmm15 {%k2} {z} 
// CHECK: encoding: [0x62,0xc3,0x7d,0xca,0x39,0xdf,0x00]    
vextracti32x4 $0, %zmm19, %xmm15 {%k2} {z} 

// CHECK: vextracti32x4 $0, %zmm19, %xmm1 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x39,0xd9,0x00]      
vextracti32x4 $0, %zmm19, %xmm1 

// CHECK: vextracti32x4 $0, %zmm19, %xmm1 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x39,0xd9,0x00]     
vextracti32x4 $0, %zmm19, %xmm1 {%k2} 

// CHECK: vextracti32x4 $0, %zmm19, %xmm1 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x39,0xd9,0x00]    
vextracti32x4 $0, %zmm19, %xmm1 {%k2} {z} 

// CHECK: vextracti64x4 $0, %zmm19, 2048(%rdx) 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x3b,0x5a,0x40,0x00]      
vextracti64x4 $0, %zmm19, 2048(%rdx) 

// CHECK: vextracti64x4 $0, %zmm19, 2048(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x3b,0x5a,0x40,0x00]     
vextracti64x4 $0, %zmm19, 2048(%rdx) {%k2} 

// CHECK: vextracti64x4 $0, %zmm19, 2048(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x3b,0x5c,0x82,0x40,0x00]      
vextracti64x4 $0, %zmm19, 2048(%rdx,%rax,4) 

// CHECK: vextracti64x4 $0, %zmm19, -2048(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x3b,0x5c,0x82,0xc0,0x00]      
vextracti64x4 $0, %zmm19, -2048(%rdx,%rax,4) 

// CHECK: vextracti64x4 $0, %zmm19, 2048(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x3b,0x5c,0x82,0x40,0x00]     
vextracti64x4 $0, %zmm19, 2048(%rdx,%rax,4) {%k2} 

// CHECK: vextracti64x4 $0, %zmm19, -2048(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x3b,0x5c,0x82,0xc0,0x00]     
vextracti64x4 $0, %zmm19, -2048(%rdx,%rax,4) {%k2} 

// CHECK: vextracti64x4 $0, %zmm19, 2048(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x3b,0x5c,0x02,0x40,0x00]      
vextracti64x4 $0, %zmm19, 2048(%rdx,%rax) 

// CHECK: vextracti64x4 $0, %zmm19, 2048(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x3b,0x5c,0x02,0x40,0x00]     
vextracti64x4 $0, %zmm19, 2048(%rdx,%rax) {%k2} 

// CHECK: vextracti64x4 $0, %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vextracti64x4 $0, %zmm19, 485498096 

// CHECK: vextracti64x4 $0, %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vextracti64x4 $0, %zmm19, 485498096 {%k2} 

// CHECK: vextracti64x4 $0, %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x3b,0x1a,0x00]      
vextracti64x4 $0, %zmm19, (%rdx) 

// CHECK: vextracti64x4 $0, %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x3b,0x1a,0x00]     
vextracti64x4 $0, %zmm19, (%rdx) {%k2} 

// CHECK: vextracti64x4 $0, %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa3,0xfd,0x48,0x3b,0xdf,0x00]      
vextracti64x4 $0, %zmm19, %ymm23 

// CHECK: vextracti64x4 $0, %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa3,0xfd,0x4a,0x3b,0xdf,0x00]     
vextracti64x4 $0, %zmm19, %ymm23 {%k2} 

// CHECK: vextracti64x4 $0, %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0xfd,0xca,0x3b,0xdf,0x00]    
vextracti64x4 $0, %zmm19, %ymm23 {%k2} {z} 

// CHECK: vfixupimmpd $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x54,0x5c,0x82,0x40,0x00]     
vfixupimmpd $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x54,0x5c,0x82,0xc0,0x00]     
vfixupimmpd $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x54,0x5c,0x82,0x40,0x00]    
vfixupimmpd $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x54,0x5c,0x82,0xc0,0x00]    
vfixupimmpd $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x54,0x5c,0x82,0x40,0x00]   
vfixupimmpd $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x54,0x5c,0x82,0xc0,0x00]   
vfixupimmpd $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x54,0x5c,0x02,0x40,0x00]     
vfixupimmpd $0, 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x54,0x5c,0x02,0x40,0x00]    
vfixupimmpd $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x54,0x5c,0x02,0x40,0x00]   
vfixupimmpd $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x54,0x5a,0x40,0x00]     
vfixupimmpd $0, 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x54,0x5a,0x40,0x00]    
vfixupimmpd $0, 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x54,0x5a,0x40,0x00]   
vfixupimmpd $0, 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x50,0x54,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmpd $0, 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x52,0x54,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmpd $0, 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xd2,0x54,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmpd $0, 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x54,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmpd $0, 485498096, %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x54,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmpd $0, 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x54,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmpd $0, 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x50,0x54,0x5a,0x40,0x00]     
vfixupimmpd $0, 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x52,0x54,0x5a,0x40,0x00]    
vfixupimmpd $0, 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xd2,0x54,0x5a,0x40,0x00]   
vfixupimmpd $0, 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x50,0x54,0x5c,0x02,0x40,0x00]     
vfixupimmpd $0, 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x52,0x54,0x5c,0x02,0x40,0x00]    
vfixupimmpd $0, 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xd2,0x54,0x5c,0x02,0x40,0x00]   
vfixupimmpd $0, 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x50,0x54,0x5c,0x82,0x40,0x00]     
vfixupimmpd $0, 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x50,0x54,0x5c,0x82,0xc0,0x00]     
vfixupimmpd $0, -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x52,0x54,0x5c,0x82,0x40,0x00]    
vfixupimmpd $0, 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x52,0x54,0x5c,0x82,0xc0,0x00]    
vfixupimmpd $0, -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xd2,0x54,0x5c,0x82,0x40,0x00]   
vfixupimmpd $0, 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xd2,0x54,0x5c,0x82,0xc0,0x00]   
vfixupimmpd $0, -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x50,0x54,0x1a,0x00]     
vfixupimmpd $0, (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x52,0x54,0x1a,0x00]    
vfixupimmpd $0, (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xd2,0x54,0x1a,0x00]   
vfixupimmpd $0, (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x54,0x1a,0x00]     
vfixupimmpd $0, (%rdx), %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x54,0x1a,0x00]    
vfixupimmpd $0, (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x54,0x1a,0x00]   
vfixupimmpd $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, {sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0xe5,0x10,0x54,0xdb,0x00]    
vfixupimmpd $0, {sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, {sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0xe5,0x12,0x54,0xdb,0x00]   
vfixupimmpd $0, {sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, {sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0xe5,0x92,0x54,0xdb,0x00]  
vfixupimmpd $0, {sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmpd $0, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0xe5,0x40,0x54,0xdb,0x00]     
vfixupimmpd $0, %zmm19, %zmm19, %zmm19 

// CHECK: vfixupimmpd $0, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0xe5,0x42,0x54,0xdb,0x00]    
vfixupimmpd $0, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmpd $0, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0xe5,0xc2,0x54,0xdb,0x00]   
vfixupimmpd $0, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x50,0x54,0x5a,0x40,0x00]     
vfixupimmps $0, 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfixupimmps $0, 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x52,0x54,0x5a,0x40,0x00]    
vfixupimmps $0, 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xd2,0x54,0x5a,0x40,0x00]   
vfixupimmps $0, 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x50,0x54,0x5c,0x02,0x40,0x00]     
vfixupimmps $0, 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfixupimmps $0, 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x52,0x54,0x5c,0x02,0x40,0x00]    
vfixupimmps $0, 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xd2,0x54,0x5c,0x02,0x40,0x00]   
vfixupimmps $0, 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x50,0x54,0x5c,0x82,0x40,0x00]     
vfixupimmps $0, 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfixupimmps $0, -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x50,0x54,0x5c,0x82,0xc0,0x00]     
vfixupimmps $0, -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfixupimmps $0, 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x52,0x54,0x5c,0x82,0x40,0x00]    
vfixupimmps $0, 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x52,0x54,0x5c,0x82,0xc0,0x00]    
vfixupimmps $0, -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xd2,0x54,0x5c,0x82,0x40,0x00]   
vfixupimmps $0, 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xd2,0x54,0x5c,0x82,0xc0,0x00]   
vfixupimmps $0, -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x54,0x5c,0x82,0x40,0x00]     
vfixupimmps $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfixupimmps $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x54,0x5c,0x82,0xc0,0x00]     
vfixupimmps $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfixupimmps $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x54,0x5c,0x82,0x40,0x00]    
vfixupimmps $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x54,0x5c,0x82,0xc0,0x00]    
vfixupimmps $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x54,0x5c,0x82,0x40,0x00]   
vfixupimmps $0, 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x54,0x5c,0x82,0xc0,0x00]   
vfixupimmps $0, -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x54,0x5c,0x02,0x40,0x00]     
vfixupimmps $0, 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfixupimmps $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x54,0x5c,0x02,0x40,0x00]    
vfixupimmps $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x54,0x5c,0x02,0x40,0x00]   
vfixupimmps $0, 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x54,0x5a,0x40,0x00]     
vfixupimmps $0, 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfixupimmps $0, 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x54,0x5a,0x40,0x00]    
vfixupimmps $0, 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x54,0x5a,0x40,0x00]   
vfixupimmps $0, 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x50,0x54,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmps $0, 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfixupimmps $0, 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x52,0x54,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmps $0, 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xd2,0x54,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmps $0, 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x54,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmps $0, 485498096, %zmm19, %zmm19 

// CHECK: vfixupimmps $0, 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x54,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmps $0, 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x54,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmps $0, 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x50,0x54,0x1a,0x00]     
vfixupimmps $0, (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfixupimmps $0, (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x52,0x54,0x1a,0x00]    
vfixupimmps $0, (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xd2,0x54,0x1a,0x00]   
vfixupimmps $0, (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x54,0x1a,0x00]     
vfixupimmps $0, (%rdx), %zmm19, %zmm19 

// CHECK: vfixupimmps $0, (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x54,0x1a,0x00]    
vfixupimmps $0, (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x54,0x1a,0x00]   
vfixupimmps $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, {sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0x65,0x10,0x54,0xdb,0x00]    
vfixupimmps $0, {sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfixupimmps $0, {sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0x65,0x12,0x54,0xdb,0x00]   
vfixupimmps $0, {sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, {sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0x65,0x92,0x54,0xdb,0x00]  
vfixupimmps $0, {sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfixupimmps $0, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0x65,0x40,0x54,0xdb,0x00]     
vfixupimmps $0, %zmm19, %zmm19, %zmm19 

// CHECK: vfixupimmps $0, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0x65,0x42,0x54,0xdb,0x00]    
vfixupimmps $0, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfixupimmps $0, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0x65,0xc2,0x54,0xdb,0x00]   
vfixupimmps $0, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x98,0x5c,0x82,0x40]      
vfmadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x98,0x5c,0x82,0xc0]      
vfmadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x98,0x5c,0x82,0x40]     
vfmadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x98,0x5c,0x82,0xc0]     
vfmadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x98,0x5c,0x82,0x40]    
vfmadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x98,0x5c,0x82,0xc0]    
vfmadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x98,0x5c,0x02,0x40]      
vfmadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x98,0x5c,0x02,0x40]     
vfmadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x98,0x5c,0x02,0x40]    
vfmadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x98,0x5a,0x40]      
vfmadd132pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmadd132pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x98,0x5a,0x40]     
vfmadd132pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x98,0x5a,0x40]    
vfmadd132pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x98,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmadd132pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfmadd132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x98,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmadd132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x98,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmadd132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x98,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmadd132pd 485498096, %zmm19, %zmm19 

// CHECK: vfmadd132pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x98,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmadd132pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x98,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmadd132pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x98,0x5a,0x40]      
vfmadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x98,0x5a,0x40]     
vfmadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x98,0x5a,0x40]    
vfmadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x98,0x5c,0x02,0x40]      
vfmadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x98,0x5c,0x02,0x40]     
vfmadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x98,0x5c,0x02,0x40]    
vfmadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x98,0x5c,0x82,0x40]      
vfmadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x98,0x5c,0x82,0xc0]      
vfmadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x98,0x5c,0x82,0x40]     
vfmadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x98,0x5c,0x82,0xc0]     
vfmadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x98,0x5c,0x82,0x40]    
vfmadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x98,0x5c,0x82,0xc0]    
vfmadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0x98,0xdb]     
vfmadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0x98,0xdb]    
vfmadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0x98,0xdb]   
vfmadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x98,0x1a]      
vfmadd132pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x98,0x1a]     
vfmadd132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x98,0x1a]    
vfmadd132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x98,0x1a]      
vfmadd132pd (%rdx), %zmm19, %zmm19 

// CHECK: vfmadd132pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x98,0x1a]     
vfmadd132pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x98,0x1a]    
vfmadd132pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0x98,0xdb]     
vfmadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0x98,0xdb]    
vfmadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0x98,0xdb]   
vfmadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0x98,0xdb]     
vfmadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0x98,0xdb]    
vfmadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0x98,0xdb]   
vfmadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0x98,0xdb]     
vfmadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0x98,0xdb]    
vfmadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0x98,0xdb]   
vfmadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x98,0xdb]      
vfmadd132pd %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd132pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x98,0xdb]     
vfmadd132pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x98,0xdb]    
vfmadd132pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x98,0x5a,0x40]      
vfmadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x98,0x5a,0x40]     
vfmadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x98,0x5a,0x40]    
vfmadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x98,0x5c,0x02,0x40]      
vfmadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x98,0x5c,0x02,0x40]     
vfmadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x98,0x5c,0x02,0x40]    
vfmadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x98,0x5c,0x82,0x40]      
vfmadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x98,0x5c,0x82,0xc0]      
vfmadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x98,0x5c,0x82,0x40]     
vfmadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x98,0x5c,0x82,0xc0]     
vfmadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x98,0x5c,0x82,0x40]    
vfmadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x98,0x5c,0x82,0xc0]    
vfmadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x98,0x5c,0x82,0x40]      
vfmadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x98,0x5c,0x82,0xc0]      
vfmadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x98,0x5c,0x82,0x40]     
vfmadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x98,0x5c,0x82,0xc0]     
vfmadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x98,0x5c,0x82,0x40]    
vfmadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x98,0x5c,0x82,0xc0]    
vfmadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x98,0x5c,0x02,0x40]      
vfmadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x98,0x5c,0x02,0x40]     
vfmadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x98,0x5c,0x02,0x40]    
vfmadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x98,0x5a,0x40]      
vfmadd132ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmadd132ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x98,0x5a,0x40]     
vfmadd132ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x98,0x5a,0x40]    
vfmadd132ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x98,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmadd132ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfmadd132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x98,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmadd132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x98,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmadd132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x98,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmadd132ps 485498096, %zmm19, %zmm19 

// CHECK: vfmadd132ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x98,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmadd132ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x98,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmadd132ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0x98,0xdb]     
vfmadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0x98,0xdb]    
vfmadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0x98,0xdb]   
vfmadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x98,0x1a]      
vfmadd132ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x98,0x1a]     
vfmadd132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x98,0x1a]    
vfmadd132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x98,0x1a]      
vfmadd132ps (%rdx), %zmm19, %zmm19 

// CHECK: vfmadd132ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x98,0x1a]     
vfmadd132ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x98,0x1a]    
vfmadd132ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0x98,0xdb]     
vfmadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0x98,0xdb]    
vfmadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0x98,0xdb]   
vfmadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0x98,0xdb]     
vfmadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0x98,0xdb]    
vfmadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0x98,0xdb]   
vfmadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0x98,0xdb]     
vfmadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0x98,0xdb]    
vfmadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0x98,0xdb]   
vfmadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd132ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x98,0xdb]      
vfmadd132ps %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd132ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x98,0xdb]     
vfmadd132ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd132ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x98,0xdb]    
vfmadd132ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa8,0x5c,0x82,0x40]      
vfmadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa8,0x5c,0x82,0xc0]      
vfmadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa8,0x5c,0x82,0x40]     
vfmadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa8,0x5c,0x82,0xc0]     
vfmadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa8,0x5c,0x82,0x40]    
vfmadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa8,0x5c,0x82,0xc0]    
vfmadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa8,0x5c,0x02,0x40]      
vfmadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa8,0x5c,0x02,0x40]     
vfmadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa8,0x5c,0x02,0x40]    
vfmadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa8,0x5a,0x40]      
vfmadd213pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmadd213pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa8,0x5a,0x40]     
vfmadd213pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa8,0x5a,0x40]    
vfmadd213pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmadd213pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfmadd213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmadd213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmadd213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmadd213pd 485498096, %zmm19, %zmm19 

// CHECK: vfmadd213pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmadd213pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmadd213pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa8,0x5a,0x40]      
vfmadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa8,0x5a,0x40]     
vfmadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa8,0x5a,0x40]    
vfmadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa8,0x5c,0x02,0x40]      
vfmadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa8,0x5c,0x02,0x40]     
vfmadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa8,0x5c,0x02,0x40]    
vfmadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa8,0x5c,0x82,0x40]      
vfmadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa8,0x5c,0x82,0xc0]      
vfmadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa8,0x5c,0x82,0x40]     
vfmadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa8,0x5c,0x82,0xc0]     
vfmadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa8,0x5c,0x82,0x40]    
vfmadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa8,0x5c,0x82,0xc0]    
vfmadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0xa8,0xdb]     
vfmadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0xa8,0xdb]    
vfmadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0xa8,0xdb]   
vfmadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa8,0x1a]      
vfmadd213pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa8,0x1a]     
vfmadd213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa8,0x1a]    
vfmadd213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa8,0x1a]      
vfmadd213pd (%rdx), %zmm19, %zmm19 

// CHECK: vfmadd213pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa8,0x1a]     
vfmadd213pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa8,0x1a]    
vfmadd213pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0xa8,0xdb]     
vfmadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0xa8,0xdb]    
vfmadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0xa8,0xdb]   
vfmadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0xa8,0xdb]     
vfmadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0xa8,0xdb]    
vfmadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0xa8,0xdb]   
vfmadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0xa8,0xdb]     
vfmadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0xa8,0xdb]    
vfmadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0xa8,0xdb]   
vfmadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0xa8,0xdb]      
vfmadd213pd %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd213pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0xa8,0xdb]     
vfmadd213pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0xa8,0xdb]    
vfmadd213pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa8,0x5a,0x40]      
vfmadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa8,0x5a,0x40]     
vfmadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa8,0x5a,0x40]    
vfmadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa8,0x5c,0x02,0x40]      
vfmadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa8,0x5c,0x02,0x40]     
vfmadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa8,0x5c,0x02,0x40]    
vfmadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa8,0x5c,0x82,0x40]      
vfmadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa8,0x5c,0x82,0xc0]      
vfmadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa8,0x5c,0x82,0x40]     
vfmadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa8,0x5c,0x82,0xc0]     
vfmadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa8,0x5c,0x82,0x40]    
vfmadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa8,0x5c,0x82,0xc0]    
vfmadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa8,0x5c,0x82,0x40]      
vfmadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa8,0x5c,0x82,0xc0]      
vfmadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa8,0x5c,0x82,0x40]     
vfmadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa8,0x5c,0x82,0xc0]     
vfmadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa8,0x5c,0x82,0x40]    
vfmadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa8,0x5c,0x82,0xc0]    
vfmadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa8,0x5c,0x02,0x40]      
vfmadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa8,0x5c,0x02,0x40]     
vfmadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa8,0x5c,0x02,0x40]    
vfmadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa8,0x5a,0x40]      
vfmadd213ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmadd213ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa8,0x5a,0x40]     
vfmadd213ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa8,0x5a,0x40]    
vfmadd213ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmadd213ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfmadd213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmadd213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmadd213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmadd213ps 485498096, %zmm19, %zmm19 

// CHECK: vfmadd213ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmadd213ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmadd213ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0xa8,0xdb]     
vfmadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0xa8,0xdb]    
vfmadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0xa8,0xdb]   
vfmadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa8,0x1a]      
vfmadd213ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa8,0x1a]     
vfmadd213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa8,0x1a]    
vfmadd213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa8,0x1a]      
vfmadd213ps (%rdx), %zmm19, %zmm19 

// CHECK: vfmadd213ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa8,0x1a]     
vfmadd213ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa8,0x1a]    
vfmadd213ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0xa8,0xdb]     
vfmadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0xa8,0xdb]    
vfmadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0xa8,0xdb]   
vfmadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0xa8,0xdb]     
vfmadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0xa8,0xdb]    
vfmadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0xa8,0xdb]   
vfmadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0xa8,0xdb]     
vfmadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0xa8,0xdb]    
vfmadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0xa8,0xdb]   
vfmadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd213ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0xa8,0xdb]      
vfmadd213ps %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd213ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0xa8,0xdb]     
vfmadd213ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd213ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0xa8,0xdb]    
vfmadd213ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb8,0x5c,0x82,0x40]      
vfmadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb8,0x5c,0x82,0xc0]      
vfmadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb8,0x5c,0x82,0x40]     
vfmadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb8,0x5c,0x82,0xc0]     
vfmadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb8,0x5c,0x82,0x40]    
vfmadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb8,0x5c,0x82,0xc0]    
vfmadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb8,0x5c,0x02,0x40]      
vfmadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb8,0x5c,0x02,0x40]     
vfmadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb8,0x5c,0x02,0x40]    
vfmadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb8,0x5a,0x40]      
vfmadd231pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmadd231pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb8,0x5a,0x40]     
vfmadd231pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb8,0x5a,0x40]    
vfmadd231pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmadd231pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfmadd231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmadd231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmadd231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmadd231pd 485498096, %zmm19, %zmm19 

// CHECK: vfmadd231pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmadd231pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmadd231pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb8,0x5a,0x40]      
vfmadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb8,0x5a,0x40]     
vfmadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb8,0x5a,0x40]    
vfmadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb8,0x5c,0x02,0x40]      
vfmadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb8,0x5c,0x02,0x40]     
vfmadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb8,0x5c,0x02,0x40]    
vfmadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb8,0x5c,0x82,0x40]      
vfmadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb8,0x5c,0x82,0xc0]      
vfmadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb8,0x5c,0x82,0x40]     
vfmadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb8,0x5c,0x82,0xc0]     
vfmadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb8,0x5c,0x82,0x40]    
vfmadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb8,0x5c,0x82,0xc0]    
vfmadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0xb8,0xdb]     
vfmadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0xb8,0xdb]    
vfmadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0xb8,0xdb]   
vfmadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb8,0x1a]      
vfmadd231pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmadd231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb8,0x1a]     
vfmadd231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb8,0x1a]    
vfmadd231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb8,0x1a]      
vfmadd231pd (%rdx), %zmm19, %zmm19 

// CHECK: vfmadd231pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb8,0x1a]     
vfmadd231pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb8,0x1a]    
vfmadd231pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0xb8,0xdb]     
vfmadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0xb8,0xdb]    
vfmadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0xb8,0xdb]   
vfmadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0xb8,0xdb]     
vfmadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0xb8,0xdb]    
vfmadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0xb8,0xdb]   
vfmadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0xb8,0xdb]     
vfmadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0xb8,0xdb]    
vfmadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0xb8,0xdb]   
vfmadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0xb8,0xdb]      
vfmadd231pd %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd231pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0xb8,0xdb]     
vfmadd231pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0xb8,0xdb]    
vfmadd231pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb8,0x5a,0x40]      
vfmadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb8,0x5a,0x40]     
vfmadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb8,0x5a,0x40]    
vfmadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb8,0x5c,0x02,0x40]      
vfmadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb8,0x5c,0x02,0x40]     
vfmadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb8,0x5c,0x02,0x40]    
vfmadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb8,0x5c,0x82,0x40]      
vfmadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb8,0x5c,0x82,0xc0]      
vfmadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb8,0x5c,0x82,0x40]     
vfmadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb8,0x5c,0x82,0xc0]     
vfmadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb8,0x5c,0x82,0x40]    
vfmadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb8,0x5c,0x82,0xc0]    
vfmadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb8,0x5c,0x82,0x40]      
vfmadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb8,0x5c,0x82,0xc0]      
vfmadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb8,0x5c,0x82,0x40]     
vfmadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb8,0x5c,0x82,0xc0]     
vfmadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb8,0x5c,0x82,0x40]    
vfmadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb8,0x5c,0x82,0xc0]    
vfmadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb8,0x5c,0x02,0x40]      
vfmadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb8,0x5c,0x02,0x40]     
vfmadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb8,0x5c,0x02,0x40]    
vfmadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb8,0x5a,0x40]      
vfmadd231ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmadd231ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb8,0x5a,0x40]     
vfmadd231ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb8,0x5a,0x40]    
vfmadd231ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmadd231ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfmadd231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmadd231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmadd231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmadd231ps 485498096, %zmm19, %zmm19 

// CHECK: vfmadd231ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmadd231ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb8,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmadd231ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0xb8,0xdb]     
vfmadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0xb8,0xdb]    
vfmadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0xb8,0xdb]   
vfmadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb8,0x1a]      
vfmadd231ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmadd231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb8,0x1a]     
vfmadd231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb8,0x1a]    
vfmadd231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb8,0x1a]      
vfmadd231ps (%rdx), %zmm19, %zmm19 

// CHECK: vfmadd231ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb8,0x1a]     
vfmadd231ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb8,0x1a]    
vfmadd231ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0xb8,0xdb]     
vfmadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0xb8,0xdb]    
vfmadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0xb8,0xdb]   
vfmadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0xb8,0xdb]     
vfmadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0xb8,0xdb]    
vfmadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0xb8,0xdb]   
vfmadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0xb8,0xdb]     
vfmadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0xb8,0xdb]    
vfmadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0xb8,0xdb]   
vfmadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmadd231ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0xb8,0xdb]      
vfmadd231ps %zmm19, %zmm19, %zmm19 

// CHECK: vfmadd231ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0xb8,0xdb]     
vfmadd231ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmadd231ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0xb8,0xdb]    
vfmadd231ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x96,0x5c,0x82,0x40]      
vfmaddsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmaddsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x96,0x5c,0x82,0xc0]      
vfmaddsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmaddsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x96,0x5c,0x82,0x40]     
vfmaddsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x96,0x5c,0x82,0xc0]     
vfmaddsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x96,0x5c,0x82,0x40]    
vfmaddsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x96,0x5c,0x82,0xc0]    
vfmaddsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x96,0x5c,0x02,0x40]      
vfmaddsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmaddsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x96,0x5c,0x02,0x40]     
vfmaddsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x96,0x5c,0x02,0x40]    
vfmaddsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x96,0x5a,0x40]      
vfmaddsub132pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmaddsub132pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x96,0x5a,0x40]     
vfmaddsub132pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x96,0x5a,0x40]    
vfmaddsub132pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x96,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x96,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x96,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x96,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132pd 485498096, %zmm19, %zmm19 

// CHECK: vfmaddsub132pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x96,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x96,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x96,0x5a,0x40]      
vfmaddsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x96,0x5a,0x40]     
vfmaddsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x96,0x5a,0x40]    
vfmaddsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x96,0x5c,0x02,0x40]      
vfmaddsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x96,0x5c,0x02,0x40]     
vfmaddsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x96,0x5c,0x02,0x40]    
vfmaddsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x96,0x5c,0x82,0x40]      
vfmaddsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x96,0x5c,0x82,0xc0]      
vfmaddsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x96,0x5c,0x82,0x40]     
vfmaddsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x96,0x5c,0x82,0xc0]     
vfmaddsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x96,0x5c,0x82,0x40]    
vfmaddsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x96,0x5c,0x82,0xc0]    
vfmaddsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0x96,0xdb]     
vfmaddsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0x96,0xdb]    
vfmaddsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0x96,0xdb]   
vfmaddsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x96,0x1a]      
vfmaddsub132pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x96,0x1a]     
vfmaddsub132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x96,0x1a]    
vfmaddsub132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x96,0x1a]      
vfmaddsub132pd (%rdx), %zmm19, %zmm19 

// CHECK: vfmaddsub132pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x96,0x1a]     
vfmaddsub132pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x96,0x1a]    
vfmaddsub132pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0x96,0xdb]     
vfmaddsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0x96,0xdb]    
vfmaddsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0x96,0xdb]   
vfmaddsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0x96,0xdb]     
vfmaddsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0x96,0xdb]    
vfmaddsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0x96,0xdb]   
vfmaddsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0x96,0xdb]     
vfmaddsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0x96,0xdb]    
vfmaddsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0x96,0xdb]   
vfmaddsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x96,0xdb]      
vfmaddsub132pd %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub132pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x96,0xdb]     
vfmaddsub132pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x96,0xdb]    
vfmaddsub132pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x96,0x5a,0x40]      
vfmaddsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x96,0x5a,0x40]     
vfmaddsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x96,0x5a,0x40]    
vfmaddsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x96,0x5c,0x02,0x40]      
vfmaddsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x96,0x5c,0x02,0x40]     
vfmaddsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x96,0x5c,0x02,0x40]    
vfmaddsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x96,0x5c,0x82,0x40]      
vfmaddsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x96,0x5c,0x82,0xc0]      
vfmaddsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x96,0x5c,0x82,0x40]     
vfmaddsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x96,0x5c,0x82,0xc0]     
vfmaddsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x96,0x5c,0x82,0x40]    
vfmaddsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x96,0x5c,0x82,0xc0]    
vfmaddsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x96,0x5c,0x82,0x40]      
vfmaddsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmaddsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x96,0x5c,0x82,0xc0]      
vfmaddsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmaddsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x96,0x5c,0x82,0x40]     
vfmaddsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x96,0x5c,0x82,0xc0]     
vfmaddsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x96,0x5c,0x82,0x40]    
vfmaddsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x96,0x5c,0x82,0xc0]    
vfmaddsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x96,0x5c,0x02,0x40]      
vfmaddsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmaddsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x96,0x5c,0x02,0x40]     
vfmaddsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x96,0x5c,0x02,0x40]    
vfmaddsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x96,0x5a,0x40]      
vfmaddsub132ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmaddsub132ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x96,0x5a,0x40]     
vfmaddsub132ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x96,0x5a,0x40]    
vfmaddsub132ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x96,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x96,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x96,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x96,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132ps 485498096, %zmm19, %zmm19 

// CHECK: vfmaddsub132ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x96,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x96,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0x96,0xdb]     
vfmaddsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0x96,0xdb]    
vfmaddsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0x96,0xdb]   
vfmaddsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x96,0x1a]      
vfmaddsub132ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x96,0x1a]     
vfmaddsub132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x96,0x1a]    
vfmaddsub132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x96,0x1a]      
vfmaddsub132ps (%rdx), %zmm19, %zmm19 

// CHECK: vfmaddsub132ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x96,0x1a]     
vfmaddsub132ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x96,0x1a]    
vfmaddsub132ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0x96,0xdb]     
vfmaddsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0x96,0xdb]    
vfmaddsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0x96,0xdb]   
vfmaddsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0x96,0xdb]     
vfmaddsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0x96,0xdb]    
vfmaddsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0x96,0xdb]   
vfmaddsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0x96,0xdb]     
vfmaddsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0x96,0xdb]    
vfmaddsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0x96,0xdb]   
vfmaddsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub132ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x96,0xdb]      
vfmaddsub132ps %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub132ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x96,0xdb]     
vfmaddsub132ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub132ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x96,0xdb]    
vfmaddsub132ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa6,0x5c,0x82,0x40]      
vfmaddsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmaddsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa6,0x5c,0x82,0xc0]      
vfmaddsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmaddsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa6,0x5c,0x82,0x40]     
vfmaddsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa6,0x5c,0x82,0xc0]     
vfmaddsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa6,0x5c,0x82,0x40]    
vfmaddsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa6,0x5c,0x82,0xc0]    
vfmaddsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa6,0x5c,0x02,0x40]      
vfmaddsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmaddsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa6,0x5c,0x02,0x40]     
vfmaddsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa6,0x5c,0x02,0x40]    
vfmaddsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa6,0x5a,0x40]      
vfmaddsub213pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmaddsub213pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa6,0x5a,0x40]     
vfmaddsub213pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa6,0x5a,0x40]    
vfmaddsub213pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213pd 485498096, %zmm19, %zmm19 

// CHECK: vfmaddsub213pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa6,0x5a,0x40]      
vfmaddsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa6,0x5a,0x40]     
vfmaddsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa6,0x5a,0x40]    
vfmaddsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa6,0x5c,0x02,0x40]      
vfmaddsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa6,0x5c,0x02,0x40]     
vfmaddsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa6,0x5c,0x02,0x40]    
vfmaddsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa6,0x5c,0x82,0x40]      
vfmaddsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa6,0x5c,0x82,0xc0]      
vfmaddsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa6,0x5c,0x82,0x40]     
vfmaddsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa6,0x5c,0x82,0xc0]     
vfmaddsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa6,0x5c,0x82,0x40]    
vfmaddsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa6,0x5c,0x82,0xc0]    
vfmaddsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0xa6,0xdb]     
vfmaddsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0xa6,0xdb]    
vfmaddsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0xa6,0xdb]   
vfmaddsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa6,0x1a]      
vfmaddsub213pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa6,0x1a]     
vfmaddsub213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa6,0x1a]    
vfmaddsub213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa6,0x1a]      
vfmaddsub213pd (%rdx), %zmm19, %zmm19 

// CHECK: vfmaddsub213pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa6,0x1a]     
vfmaddsub213pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa6,0x1a]    
vfmaddsub213pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0xa6,0xdb]     
vfmaddsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0xa6,0xdb]    
vfmaddsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0xa6,0xdb]   
vfmaddsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0xa6,0xdb]     
vfmaddsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0xa6,0xdb]    
vfmaddsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0xa6,0xdb]   
vfmaddsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0xa6,0xdb]     
vfmaddsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0xa6,0xdb]    
vfmaddsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0xa6,0xdb]   
vfmaddsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0xa6,0xdb]      
vfmaddsub213pd %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub213pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0xa6,0xdb]     
vfmaddsub213pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0xa6,0xdb]    
vfmaddsub213pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa6,0x5a,0x40]      
vfmaddsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa6,0x5a,0x40]     
vfmaddsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa6,0x5a,0x40]    
vfmaddsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa6,0x5c,0x02,0x40]      
vfmaddsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa6,0x5c,0x02,0x40]     
vfmaddsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa6,0x5c,0x02,0x40]    
vfmaddsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa6,0x5c,0x82,0x40]      
vfmaddsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa6,0x5c,0x82,0xc0]      
vfmaddsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa6,0x5c,0x82,0x40]     
vfmaddsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa6,0x5c,0x82,0xc0]     
vfmaddsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa6,0x5c,0x82,0x40]    
vfmaddsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa6,0x5c,0x82,0xc0]    
vfmaddsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa6,0x5c,0x82,0x40]      
vfmaddsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmaddsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa6,0x5c,0x82,0xc0]      
vfmaddsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmaddsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa6,0x5c,0x82,0x40]     
vfmaddsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa6,0x5c,0x82,0xc0]     
vfmaddsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa6,0x5c,0x82,0x40]    
vfmaddsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa6,0x5c,0x82,0xc0]    
vfmaddsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa6,0x5c,0x02,0x40]      
vfmaddsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmaddsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa6,0x5c,0x02,0x40]     
vfmaddsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa6,0x5c,0x02,0x40]    
vfmaddsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa6,0x5a,0x40]      
vfmaddsub213ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmaddsub213ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa6,0x5a,0x40]     
vfmaddsub213ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa6,0x5a,0x40]    
vfmaddsub213ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213ps 485498096, %zmm19, %zmm19 

// CHECK: vfmaddsub213ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0xa6,0xdb]     
vfmaddsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0xa6,0xdb]    
vfmaddsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0xa6,0xdb]   
vfmaddsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa6,0x1a]      
vfmaddsub213ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa6,0x1a]     
vfmaddsub213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa6,0x1a]    
vfmaddsub213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa6,0x1a]      
vfmaddsub213ps (%rdx), %zmm19, %zmm19 

// CHECK: vfmaddsub213ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa6,0x1a]     
vfmaddsub213ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa6,0x1a]    
vfmaddsub213ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0xa6,0xdb]     
vfmaddsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0xa6,0xdb]    
vfmaddsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0xa6,0xdb]   
vfmaddsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0xa6,0xdb]     
vfmaddsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0xa6,0xdb]    
vfmaddsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0xa6,0xdb]   
vfmaddsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0xa6,0xdb]     
vfmaddsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0xa6,0xdb]    
vfmaddsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0xa6,0xdb]   
vfmaddsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub213ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0xa6,0xdb]      
vfmaddsub213ps %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub213ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0xa6,0xdb]     
vfmaddsub213ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub213ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0xa6,0xdb]    
vfmaddsub213ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb6,0x5c,0x82,0x40]      
vfmaddsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmaddsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb6,0x5c,0x82,0xc0]      
vfmaddsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmaddsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb6,0x5c,0x82,0x40]     
vfmaddsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb6,0x5c,0x82,0xc0]     
vfmaddsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb6,0x5c,0x82,0x40]    
vfmaddsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb6,0x5c,0x82,0xc0]    
vfmaddsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb6,0x5c,0x02,0x40]      
vfmaddsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmaddsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb6,0x5c,0x02,0x40]     
vfmaddsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb6,0x5c,0x02,0x40]    
vfmaddsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb6,0x5a,0x40]      
vfmaddsub231pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmaddsub231pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb6,0x5a,0x40]     
vfmaddsub231pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb6,0x5a,0x40]    
vfmaddsub231pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231pd 485498096, %zmm19, %zmm19 

// CHECK: vfmaddsub231pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb6,0x5a,0x40]      
vfmaddsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb6,0x5a,0x40]     
vfmaddsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb6,0x5a,0x40]    
vfmaddsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb6,0x5c,0x02,0x40]      
vfmaddsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb6,0x5c,0x02,0x40]     
vfmaddsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb6,0x5c,0x02,0x40]    
vfmaddsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb6,0x5c,0x82,0x40]      
vfmaddsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb6,0x5c,0x82,0xc0]      
vfmaddsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb6,0x5c,0x82,0x40]     
vfmaddsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb6,0x5c,0x82,0xc0]     
vfmaddsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb6,0x5c,0x82,0x40]    
vfmaddsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb6,0x5c,0x82,0xc0]    
vfmaddsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0xb6,0xdb]     
vfmaddsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0xb6,0xdb]    
vfmaddsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0xb6,0xdb]   
vfmaddsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb6,0x1a]      
vfmaddsub231pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmaddsub231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb6,0x1a]     
vfmaddsub231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb6,0x1a]    
vfmaddsub231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb6,0x1a]      
vfmaddsub231pd (%rdx), %zmm19, %zmm19 

// CHECK: vfmaddsub231pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb6,0x1a]     
vfmaddsub231pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb6,0x1a]    
vfmaddsub231pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0xb6,0xdb]     
vfmaddsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0xb6,0xdb]    
vfmaddsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0xb6,0xdb]   
vfmaddsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0xb6,0xdb]     
vfmaddsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0xb6,0xdb]    
vfmaddsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0xb6,0xdb]   
vfmaddsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0xb6,0xdb]     
vfmaddsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0xb6,0xdb]    
vfmaddsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0xb6,0xdb]   
vfmaddsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0xb6,0xdb]      
vfmaddsub231pd %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub231pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0xb6,0xdb]     
vfmaddsub231pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0xb6,0xdb]    
vfmaddsub231pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb6,0x5a,0x40]      
vfmaddsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb6,0x5a,0x40]     
vfmaddsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb6,0x5a,0x40]    
vfmaddsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb6,0x5c,0x02,0x40]      
vfmaddsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb6,0x5c,0x02,0x40]     
vfmaddsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb6,0x5c,0x02,0x40]    
vfmaddsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb6,0x5c,0x82,0x40]      
vfmaddsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb6,0x5c,0x82,0xc0]      
vfmaddsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb6,0x5c,0x82,0x40]     
vfmaddsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb6,0x5c,0x82,0xc0]     
vfmaddsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb6,0x5c,0x82,0x40]    
vfmaddsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb6,0x5c,0x82,0xc0]    
vfmaddsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb6,0x5c,0x82,0x40]      
vfmaddsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmaddsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb6,0x5c,0x82,0xc0]      
vfmaddsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmaddsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb6,0x5c,0x82,0x40]     
vfmaddsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb6,0x5c,0x82,0xc0]     
vfmaddsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb6,0x5c,0x82,0x40]    
vfmaddsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb6,0x5c,0x82,0xc0]    
vfmaddsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb6,0x5c,0x02,0x40]      
vfmaddsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmaddsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb6,0x5c,0x02,0x40]     
vfmaddsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb6,0x5c,0x02,0x40]    
vfmaddsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb6,0x5a,0x40]      
vfmaddsub231ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmaddsub231ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb6,0x5a,0x40]     
vfmaddsub231ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb6,0x5a,0x40]    
vfmaddsub231ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231ps 485498096, %zmm19, %zmm19 

// CHECK: vfmaddsub231ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb6,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0xb6,0xdb]     
vfmaddsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0xb6,0xdb]    
vfmaddsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0xb6,0xdb]   
vfmaddsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb6,0x1a]      
vfmaddsub231ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmaddsub231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb6,0x1a]     
vfmaddsub231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb6,0x1a]    
vfmaddsub231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb6,0x1a]      
vfmaddsub231ps (%rdx), %zmm19, %zmm19 

// CHECK: vfmaddsub231ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb6,0x1a]     
vfmaddsub231ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb6,0x1a]    
vfmaddsub231ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0xb6,0xdb]     
vfmaddsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0xb6,0xdb]    
vfmaddsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0xb6,0xdb]   
vfmaddsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0xb6,0xdb]     
vfmaddsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0xb6,0xdb]    
vfmaddsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0xb6,0xdb]   
vfmaddsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0xb6,0xdb]     
vfmaddsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0xb6,0xdb]    
vfmaddsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0xb6,0xdb]   
vfmaddsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmaddsub231ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0xb6,0xdb]      
vfmaddsub231ps %zmm19, %zmm19, %zmm19 

// CHECK: vfmaddsub231ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0xb6,0xdb]     
vfmaddsub231ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmaddsub231ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0xb6,0xdb]    
vfmaddsub231ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9a,0x5c,0x82,0x40]      
vfmsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9a,0x5c,0x82,0xc0]      
vfmsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9a,0x5c,0x82,0x40]     
vfmsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9a,0x5c,0x82,0xc0]     
vfmsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9a,0x5c,0x82,0x40]    
vfmsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9a,0x5c,0x82,0xc0]    
vfmsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9a,0x5c,0x02,0x40]      
vfmsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9a,0x5c,0x02,0x40]     
vfmsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9a,0x5c,0x02,0x40]    
vfmsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9a,0x5a,0x40]      
vfmsub132pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmsub132pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9a,0x5a,0x40]     
vfmsub132pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9a,0x5a,0x40]    
vfmsub132pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsub132pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfmsub132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsub132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsub132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsub132pd 485498096, %zmm19, %zmm19 

// CHECK: vfmsub132pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsub132pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsub132pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9a,0x5a,0x40]      
vfmsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9a,0x5a,0x40]     
vfmsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9a,0x5a,0x40]    
vfmsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9a,0x5c,0x02,0x40]      
vfmsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9a,0x5c,0x02,0x40]     
vfmsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9a,0x5c,0x02,0x40]    
vfmsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9a,0x5c,0x82,0x40]      
vfmsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9a,0x5c,0x82,0xc0]      
vfmsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9a,0x5c,0x82,0x40]     
vfmsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9a,0x5c,0x82,0xc0]     
vfmsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9a,0x5c,0x82,0x40]    
vfmsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9a,0x5c,0x82,0xc0]    
vfmsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0x9a,0xdb]     
vfmsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0x9a,0xdb]    
vfmsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0x9a,0xdb]   
vfmsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9a,0x1a]      
vfmsub132pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9a,0x1a]     
vfmsub132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9a,0x1a]    
vfmsub132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9a,0x1a]      
vfmsub132pd (%rdx), %zmm19, %zmm19 

// CHECK: vfmsub132pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9a,0x1a]     
vfmsub132pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9a,0x1a]    
vfmsub132pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0x9a,0xdb]     
vfmsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0x9a,0xdb]    
vfmsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0x9a,0xdb]   
vfmsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0x9a,0xdb]     
vfmsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0x9a,0xdb]    
vfmsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0x9a,0xdb]   
vfmsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0x9a,0xdb]     
vfmsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0x9a,0xdb]    
vfmsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0x9a,0xdb]   
vfmsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x9a,0xdb]      
vfmsub132pd %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub132pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x9a,0xdb]     
vfmsub132pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x9a,0xdb]    
vfmsub132pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9a,0x5a,0x40]      
vfmsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9a,0x5a,0x40]     
vfmsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9a,0x5a,0x40]    
vfmsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9a,0x5c,0x02,0x40]      
vfmsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9a,0x5c,0x02,0x40]     
vfmsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9a,0x5c,0x02,0x40]    
vfmsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9a,0x5c,0x82,0x40]      
vfmsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9a,0x5c,0x82,0xc0]      
vfmsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9a,0x5c,0x82,0x40]     
vfmsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9a,0x5c,0x82,0xc0]     
vfmsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9a,0x5c,0x82,0x40]    
vfmsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9a,0x5c,0x82,0xc0]    
vfmsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9a,0x5c,0x82,0x40]      
vfmsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9a,0x5c,0x82,0xc0]      
vfmsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9a,0x5c,0x82,0x40]     
vfmsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9a,0x5c,0x82,0xc0]     
vfmsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9a,0x5c,0x82,0x40]    
vfmsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9a,0x5c,0x82,0xc0]    
vfmsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9a,0x5c,0x02,0x40]      
vfmsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9a,0x5c,0x02,0x40]     
vfmsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9a,0x5c,0x02,0x40]    
vfmsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9a,0x5a,0x40]      
vfmsub132ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmsub132ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9a,0x5a,0x40]     
vfmsub132ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9a,0x5a,0x40]    
vfmsub132ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsub132ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfmsub132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsub132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsub132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsub132ps 485498096, %zmm19, %zmm19 

// CHECK: vfmsub132ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsub132ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsub132ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0x9a,0xdb]     
vfmsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0x9a,0xdb]    
vfmsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0x9a,0xdb]   
vfmsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9a,0x1a]      
vfmsub132ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9a,0x1a]     
vfmsub132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9a,0x1a]    
vfmsub132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9a,0x1a]      
vfmsub132ps (%rdx), %zmm19, %zmm19 

// CHECK: vfmsub132ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9a,0x1a]     
vfmsub132ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9a,0x1a]    
vfmsub132ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0x9a,0xdb]     
vfmsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0x9a,0xdb]    
vfmsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0x9a,0xdb]   
vfmsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0x9a,0xdb]     
vfmsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0x9a,0xdb]    
vfmsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0x9a,0xdb]   
vfmsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0x9a,0xdb]     
vfmsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0x9a,0xdb]    
vfmsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0x9a,0xdb]   
vfmsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub132ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x9a,0xdb]      
vfmsub132ps %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub132ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x9a,0xdb]     
vfmsub132ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub132ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x9a,0xdb]    
vfmsub132ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xaa,0x5c,0x82,0x40]      
vfmsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xaa,0x5c,0x82,0xc0]      
vfmsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xaa,0x5c,0x82,0x40]     
vfmsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xaa,0x5c,0x82,0xc0]     
vfmsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xaa,0x5c,0x82,0x40]    
vfmsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xaa,0x5c,0x82,0xc0]    
vfmsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xaa,0x5c,0x02,0x40]      
vfmsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xaa,0x5c,0x02,0x40]     
vfmsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xaa,0x5c,0x02,0x40]    
vfmsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xaa,0x5a,0x40]      
vfmsub213pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmsub213pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xaa,0x5a,0x40]     
vfmsub213pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xaa,0x5a,0x40]    
vfmsub213pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xaa,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsub213pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfmsub213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xaa,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsub213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xaa,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsub213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xaa,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsub213pd 485498096, %zmm19, %zmm19 

// CHECK: vfmsub213pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xaa,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsub213pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xaa,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsub213pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xaa,0x5a,0x40]      
vfmsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xaa,0x5a,0x40]     
vfmsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xaa,0x5a,0x40]    
vfmsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xaa,0x5c,0x02,0x40]      
vfmsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xaa,0x5c,0x02,0x40]     
vfmsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xaa,0x5c,0x02,0x40]    
vfmsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xaa,0x5c,0x82,0x40]      
vfmsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xaa,0x5c,0x82,0xc0]      
vfmsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xaa,0x5c,0x82,0x40]     
vfmsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xaa,0x5c,0x82,0xc0]     
vfmsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xaa,0x5c,0x82,0x40]    
vfmsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xaa,0x5c,0x82,0xc0]    
vfmsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0xaa,0xdb]     
vfmsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0xaa,0xdb]    
vfmsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0xaa,0xdb]   
vfmsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xaa,0x1a]      
vfmsub213pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xaa,0x1a]     
vfmsub213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xaa,0x1a]    
vfmsub213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xaa,0x1a]      
vfmsub213pd (%rdx), %zmm19, %zmm19 

// CHECK: vfmsub213pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xaa,0x1a]     
vfmsub213pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xaa,0x1a]    
vfmsub213pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0xaa,0xdb]     
vfmsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0xaa,0xdb]    
vfmsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0xaa,0xdb]   
vfmsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0xaa,0xdb]     
vfmsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0xaa,0xdb]    
vfmsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0xaa,0xdb]   
vfmsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0xaa,0xdb]     
vfmsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0xaa,0xdb]    
vfmsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0xaa,0xdb]   
vfmsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0xaa,0xdb]      
vfmsub213pd %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub213pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0xaa,0xdb]     
vfmsub213pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0xaa,0xdb]    
vfmsub213pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xaa,0x5a,0x40]      
vfmsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xaa,0x5a,0x40]     
vfmsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xaa,0x5a,0x40]    
vfmsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xaa,0x5c,0x02,0x40]      
vfmsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xaa,0x5c,0x02,0x40]     
vfmsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xaa,0x5c,0x02,0x40]    
vfmsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xaa,0x5c,0x82,0x40]      
vfmsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xaa,0x5c,0x82,0xc0]      
vfmsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xaa,0x5c,0x82,0x40]     
vfmsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xaa,0x5c,0x82,0xc0]     
vfmsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xaa,0x5c,0x82,0x40]    
vfmsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xaa,0x5c,0x82,0xc0]    
vfmsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xaa,0x5c,0x82,0x40]      
vfmsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xaa,0x5c,0x82,0xc0]      
vfmsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xaa,0x5c,0x82,0x40]     
vfmsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xaa,0x5c,0x82,0xc0]     
vfmsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xaa,0x5c,0x82,0x40]    
vfmsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xaa,0x5c,0x82,0xc0]    
vfmsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xaa,0x5c,0x02,0x40]      
vfmsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xaa,0x5c,0x02,0x40]     
vfmsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xaa,0x5c,0x02,0x40]    
vfmsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xaa,0x5a,0x40]      
vfmsub213ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmsub213ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xaa,0x5a,0x40]     
vfmsub213ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xaa,0x5a,0x40]    
vfmsub213ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xaa,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsub213ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfmsub213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xaa,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsub213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xaa,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsub213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xaa,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsub213ps 485498096, %zmm19, %zmm19 

// CHECK: vfmsub213ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xaa,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsub213ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xaa,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsub213ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0xaa,0xdb]     
vfmsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0xaa,0xdb]    
vfmsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0xaa,0xdb]   
vfmsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xaa,0x1a]      
vfmsub213ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xaa,0x1a]     
vfmsub213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xaa,0x1a]    
vfmsub213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xaa,0x1a]      
vfmsub213ps (%rdx), %zmm19, %zmm19 

// CHECK: vfmsub213ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xaa,0x1a]     
vfmsub213ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xaa,0x1a]    
vfmsub213ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0xaa,0xdb]     
vfmsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0xaa,0xdb]    
vfmsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0xaa,0xdb]   
vfmsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0xaa,0xdb]     
vfmsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0xaa,0xdb]    
vfmsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0xaa,0xdb]   
vfmsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0xaa,0xdb]     
vfmsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0xaa,0xdb]    
vfmsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0xaa,0xdb]   
vfmsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub213ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0xaa,0xdb]      
vfmsub213ps %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub213ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0xaa,0xdb]     
vfmsub213ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub213ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0xaa,0xdb]    
vfmsub213ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xba,0x5c,0x82,0x40]      
vfmsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xba,0x5c,0x82,0xc0]      
vfmsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xba,0x5c,0x82,0x40]     
vfmsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xba,0x5c,0x82,0xc0]     
vfmsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xba,0x5c,0x82,0x40]    
vfmsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xba,0x5c,0x82,0xc0]    
vfmsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xba,0x5c,0x02,0x40]      
vfmsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xba,0x5c,0x02,0x40]     
vfmsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xba,0x5c,0x02,0x40]    
vfmsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xba,0x5a,0x40]      
vfmsub231pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmsub231pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xba,0x5a,0x40]     
vfmsub231pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xba,0x5a,0x40]    
vfmsub231pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xba,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsub231pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfmsub231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xba,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsub231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xba,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsub231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xba,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsub231pd 485498096, %zmm19, %zmm19 

// CHECK: vfmsub231pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xba,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsub231pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xba,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsub231pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xba,0x5a,0x40]      
vfmsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xba,0x5a,0x40]     
vfmsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xba,0x5a,0x40]    
vfmsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xba,0x5c,0x02,0x40]      
vfmsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xba,0x5c,0x02,0x40]     
vfmsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xba,0x5c,0x02,0x40]    
vfmsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xba,0x5c,0x82,0x40]      
vfmsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xba,0x5c,0x82,0xc0]      
vfmsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xba,0x5c,0x82,0x40]     
vfmsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xba,0x5c,0x82,0xc0]     
vfmsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xba,0x5c,0x82,0x40]    
vfmsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xba,0x5c,0x82,0xc0]    
vfmsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0xba,0xdb]     
vfmsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0xba,0xdb]    
vfmsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0xba,0xdb]   
vfmsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xba,0x1a]      
vfmsub231pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmsub231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xba,0x1a]     
vfmsub231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xba,0x1a]    
vfmsub231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xba,0x1a]      
vfmsub231pd (%rdx), %zmm19, %zmm19 

// CHECK: vfmsub231pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xba,0x1a]     
vfmsub231pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xba,0x1a]    
vfmsub231pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0xba,0xdb]     
vfmsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0xba,0xdb]    
vfmsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0xba,0xdb]   
vfmsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0xba,0xdb]     
vfmsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0xba,0xdb]    
vfmsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0xba,0xdb]   
vfmsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0xba,0xdb]     
vfmsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0xba,0xdb]    
vfmsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0xba,0xdb]   
vfmsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0xba,0xdb]      
vfmsub231pd %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub231pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0xba,0xdb]     
vfmsub231pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0xba,0xdb]    
vfmsub231pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xba,0x5a,0x40]      
vfmsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xba,0x5a,0x40]     
vfmsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xba,0x5a,0x40]    
vfmsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xba,0x5c,0x02,0x40]      
vfmsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xba,0x5c,0x02,0x40]     
vfmsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xba,0x5c,0x02,0x40]    
vfmsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xba,0x5c,0x82,0x40]      
vfmsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xba,0x5c,0x82,0xc0]      
vfmsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xba,0x5c,0x82,0x40]     
vfmsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xba,0x5c,0x82,0xc0]     
vfmsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xba,0x5c,0x82,0x40]    
vfmsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xba,0x5c,0x82,0xc0]    
vfmsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xba,0x5c,0x82,0x40]      
vfmsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xba,0x5c,0x82,0xc0]      
vfmsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xba,0x5c,0x82,0x40]     
vfmsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xba,0x5c,0x82,0xc0]     
vfmsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xba,0x5c,0x82,0x40]    
vfmsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xba,0x5c,0x82,0xc0]    
vfmsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xba,0x5c,0x02,0x40]      
vfmsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xba,0x5c,0x02,0x40]     
vfmsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xba,0x5c,0x02,0x40]    
vfmsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xba,0x5a,0x40]      
vfmsub231ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmsub231ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xba,0x5a,0x40]     
vfmsub231ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xba,0x5a,0x40]    
vfmsub231ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xba,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsub231ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfmsub231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xba,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsub231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xba,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsub231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xba,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsub231ps 485498096, %zmm19, %zmm19 

// CHECK: vfmsub231ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xba,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsub231ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xba,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsub231ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0xba,0xdb]     
vfmsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0xba,0xdb]    
vfmsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0xba,0xdb]   
vfmsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xba,0x1a]      
vfmsub231ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmsub231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xba,0x1a]     
vfmsub231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xba,0x1a]    
vfmsub231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xba,0x1a]      
vfmsub231ps (%rdx), %zmm19, %zmm19 

// CHECK: vfmsub231ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xba,0x1a]     
vfmsub231ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xba,0x1a]    
vfmsub231ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0xba,0xdb]     
vfmsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0xba,0xdb]    
vfmsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0xba,0xdb]   
vfmsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0xba,0xdb]     
vfmsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0xba,0xdb]    
vfmsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0xba,0xdb]   
vfmsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0xba,0xdb]     
vfmsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0xba,0xdb]    
vfmsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0xba,0xdb]   
vfmsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsub231ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0xba,0xdb]      
vfmsub231ps %zmm19, %zmm19, %zmm19 

// CHECK: vfmsub231ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0xba,0xdb]     
vfmsub231ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsub231ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0xba,0xdb]    
vfmsub231ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x97,0x5c,0x82,0x40]      
vfmsubadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsubadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x97,0x5c,0x82,0xc0]      
vfmsubadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsubadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x97,0x5c,0x82,0x40]     
vfmsubadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x97,0x5c,0x82,0xc0]     
vfmsubadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x97,0x5c,0x82,0x40]    
vfmsubadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x97,0x5c,0x82,0xc0]    
vfmsubadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x97,0x5c,0x02,0x40]      
vfmsubadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmsubadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x97,0x5c,0x02,0x40]     
vfmsubadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x97,0x5c,0x02,0x40]    
vfmsubadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x97,0x5a,0x40]      
vfmsubadd132pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmsubadd132pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x97,0x5a,0x40]     
vfmsubadd132pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x97,0x5a,0x40]    
vfmsubadd132pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x97,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x97,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x97,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x97,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132pd 485498096, %zmm19, %zmm19 

// CHECK: vfmsubadd132pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x97,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x97,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x97,0x5a,0x40]      
vfmsubadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x97,0x5a,0x40]     
vfmsubadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x97,0x5a,0x40]    
vfmsubadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x97,0x5c,0x02,0x40]      
vfmsubadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x97,0x5c,0x02,0x40]     
vfmsubadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x97,0x5c,0x02,0x40]    
vfmsubadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x97,0x5c,0x82,0x40]      
vfmsubadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x97,0x5c,0x82,0xc0]      
vfmsubadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x97,0x5c,0x82,0x40]     
vfmsubadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x97,0x5c,0x82,0xc0]     
vfmsubadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x97,0x5c,0x82,0x40]    
vfmsubadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x97,0x5c,0x82,0xc0]    
vfmsubadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0x97,0xdb]     
vfmsubadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0x97,0xdb]    
vfmsubadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0x97,0xdb]   
vfmsubadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x97,0x1a]      
vfmsubadd132pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x97,0x1a]     
vfmsubadd132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x97,0x1a]    
vfmsubadd132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x97,0x1a]      
vfmsubadd132pd (%rdx), %zmm19, %zmm19 

// CHECK: vfmsubadd132pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x97,0x1a]     
vfmsubadd132pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x97,0x1a]    
vfmsubadd132pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0x97,0xdb]     
vfmsubadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0x97,0xdb]    
vfmsubadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0x97,0xdb]   
vfmsubadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0x97,0xdb]     
vfmsubadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0x97,0xdb]    
vfmsubadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0x97,0xdb]   
vfmsubadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0x97,0xdb]     
vfmsubadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0x97,0xdb]    
vfmsubadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0x97,0xdb]   
vfmsubadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x97,0xdb]      
vfmsubadd132pd %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd132pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x97,0xdb]     
vfmsubadd132pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x97,0xdb]    
vfmsubadd132pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x97,0x5a,0x40]      
vfmsubadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x97,0x5a,0x40]     
vfmsubadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x97,0x5a,0x40]    
vfmsubadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x97,0x5c,0x02,0x40]      
vfmsubadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x97,0x5c,0x02,0x40]     
vfmsubadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x97,0x5c,0x02,0x40]    
vfmsubadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x97,0x5c,0x82,0x40]      
vfmsubadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x97,0x5c,0x82,0xc0]      
vfmsubadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x97,0x5c,0x82,0x40]     
vfmsubadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x97,0x5c,0x82,0xc0]     
vfmsubadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x97,0x5c,0x82,0x40]    
vfmsubadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x97,0x5c,0x82,0xc0]    
vfmsubadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x97,0x5c,0x82,0x40]      
vfmsubadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsubadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x97,0x5c,0x82,0xc0]      
vfmsubadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsubadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x97,0x5c,0x82,0x40]     
vfmsubadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x97,0x5c,0x82,0xc0]     
vfmsubadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x97,0x5c,0x82,0x40]    
vfmsubadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x97,0x5c,0x82,0xc0]    
vfmsubadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x97,0x5c,0x02,0x40]      
vfmsubadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmsubadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x97,0x5c,0x02,0x40]     
vfmsubadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x97,0x5c,0x02,0x40]    
vfmsubadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x97,0x5a,0x40]      
vfmsubadd132ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmsubadd132ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x97,0x5a,0x40]     
vfmsubadd132ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x97,0x5a,0x40]    
vfmsubadd132ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x97,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x97,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x97,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x97,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132ps 485498096, %zmm19, %zmm19 

// CHECK: vfmsubadd132ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x97,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x97,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0x97,0xdb]     
vfmsubadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0x97,0xdb]    
vfmsubadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0x97,0xdb]   
vfmsubadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x97,0x1a]      
vfmsubadd132ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x97,0x1a]     
vfmsubadd132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x97,0x1a]    
vfmsubadd132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x97,0x1a]      
vfmsubadd132ps (%rdx), %zmm19, %zmm19 

// CHECK: vfmsubadd132ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x97,0x1a]     
vfmsubadd132ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x97,0x1a]    
vfmsubadd132ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0x97,0xdb]     
vfmsubadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0x97,0xdb]    
vfmsubadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0x97,0xdb]   
vfmsubadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0x97,0xdb]     
vfmsubadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0x97,0xdb]    
vfmsubadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0x97,0xdb]   
vfmsubadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0x97,0xdb]     
vfmsubadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0x97,0xdb]    
vfmsubadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0x97,0xdb]   
vfmsubadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd132ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x97,0xdb]      
vfmsubadd132ps %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd132ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x97,0xdb]     
vfmsubadd132ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd132ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x97,0xdb]    
vfmsubadd132ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa7,0x5c,0x82,0x40]      
vfmsubadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsubadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa7,0x5c,0x82,0xc0]      
vfmsubadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsubadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa7,0x5c,0x82,0x40]     
vfmsubadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa7,0x5c,0x82,0xc0]     
vfmsubadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa7,0x5c,0x82,0x40]    
vfmsubadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa7,0x5c,0x82,0xc0]    
vfmsubadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa7,0x5c,0x02,0x40]      
vfmsubadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmsubadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa7,0x5c,0x02,0x40]     
vfmsubadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa7,0x5c,0x02,0x40]    
vfmsubadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa7,0x5a,0x40]      
vfmsubadd213pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmsubadd213pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa7,0x5a,0x40]     
vfmsubadd213pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa7,0x5a,0x40]    
vfmsubadd213pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213pd 485498096, %zmm19, %zmm19 

// CHECK: vfmsubadd213pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa7,0x5a,0x40]      
vfmsubadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa7,0x5a,0x40]     
vfmsubadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa7,0x5a,0x40]    
vfmsubadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa7,0x5c,0x02,0x40]      
vfmsubadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa7,0x5c,0x02,0x40]     
vfmsubadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa7,0x5c,0x02,0x40]    
vfmsubadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa7,0x5c,0x82,0x40]      
vfmsubadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa7,0x5c,0x82,0xc0]      
vfmsubadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa7,0x5c,0x82,0x40]     
vfmsubadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa7,0x5c,0x82,0xc0]     
vfmsubadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa7,0x5c,0x82,0x40]    
vfmsubadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa7,0x5c,0x82,0xc0]    
vfmsubadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0xa7,0xdb]     
vfmsubadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0xa7,0xdb]    
vfmsubadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0xa7,0xdb]   
vfmsubadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xa7,0x1a]      
vfmsubadd213pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xa7,0x1a]     
vfmsubadd213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xa7,0x1a]    
vfmsubadd213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xa7,0x1a]      
vfmsubadd213pd (%rdx), %zmm19, %zmm19 

// CHECK: vfmsubadd213pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xa7,0x1a]     
vfmsubadd213pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xa7,0x1a]    
vfmsubadd213pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0xa7,0xdb]     
vfmsubadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0xa7,0xdb]    
vfmsubadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0xa7,0xdb]   
vfmsubadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0xa7,0xdb]     
vfmsubadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0xa7,0xdb]    
vfmsubadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0xa7,0xdb]   
vfmsubadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0xa7,0xdb]     
vfmsubadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0xa7,0xdb]    
vfmsubadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0xa7,0xdb]   
vfmsubadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0xa7,0xdb]      
vfmsubadd213pd %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd213pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0xa7,0xdb]     
vfmsubadd213pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0xa7,0xdb]    
vfmsubadd213pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa7,0x5a,0x40]      
vfmsubadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa7,0x5a,0x40]     
vfmsubadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa7,0x5a,0x40]    
vfmsubadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa7,0x5c,0x02,0x40]      
vfmsubadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa7,0x5c,0x02,0x40]     
vfmsubadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa7,0x5c,0x02,0x40]    
vfmsubadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa7,0x5c,0x82,0x40]      
vfmsubadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa7,0x5c,0x82,0xc0]      
vfmsubadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa7,0x5c,0x82,0x40]     
vfmsubadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa7,0x5c,0x82,0xc0]     
vfmsubadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa7,0x5c,0x82,0x40]    
vfmsubadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa7,0x5c,0x82,0xc0]    
vfmsubadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa7,0x5c,0x82,0x40]      
vfmsubadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsubadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa7,0x5c,0x82,0xc0]      
vfmsubadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsubadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa7,0x5c,0x82,0x40]     
vfmsubadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa7,0x5c,0x82,0xc0]     
vfmsubadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa7,0x5c,0x82,0x40]    
vfmsubadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa7,0x5c,0x82,0xc0]    
vfmsubadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa7,0x5c,0x02,0x40]      
vfmsubadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmsubadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa7,0x5c,0x02,0x40]     
vfmsubadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa7,0x5c,0x02,0x40]    
vfmsubadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa7,0x5a,0x40]      
vfmsubadd213ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmsubadd213ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa7,0x5a,0x40]     
vfmsubadd213ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa7,0x5a,0x40]    
vfmsubadd213ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213ps 485498096, %zmm19, %zmm19 

// CHECK: vfmsubadd213ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0xa7,0xdb]     
vfmsubadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0xa7,0xdb]    
vfmsubadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0xa7,0xdb]   
vfmsubadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xa7,0x1a]      
vfmsubadd213ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xa7,0x1a]     
vfmsubadd213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xa7,0x1a]    
vfmsubadd213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xa7,0x1a]      
vfmsubadd213ps (%rdx), %zmm19, %zmm19 

// CHECK: vfmsubadd213ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xa7,0x1a]     
vfmsubadd213ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xa7,0x1a]    
vfmsubadd213ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0xa7,0xdb]     
vfmsubadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0xa7,0xdb]    
vfmsubadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0xa7,0xdb]   
vfmsubadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0xa7,0xdb]     
vfmsubadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0xa7,0xdb]    
vfmsubadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0xa7,0xdb]   
vfmsubadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0xa7,0xdb]     
vfmsubadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0xa7,0xdb]    
vfmsubadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0xa7,0xdb]   
vfmsubadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd213ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0xa7,0xdb]      
vfmsubadd213ps %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd213ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0xa7,0xdb]     
vfmsubadd213ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd213ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0xa7,0xdb]    
vfmsubadd213ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb7,0x5c,0x82,0x40]      
vfmsubadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsubadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb7,0x5c,0x82,0xc0]      
vfmsubadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsubadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb7,0x5c,0x82,0x40]     
vfmsubadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb7,0x5c,0x82,0xc0]     
vfmsubadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb7,0x5c,0x82,0x40]    
vfmsubadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb7,0x5c,0x82,0xc0]    
vfmsubadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb7,0x5c,0x02,0x40]      
vfmsubadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmsubadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb7,0x5c,0x02,0x40]     
vfmsubadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb7,0x5c,0x02,0x40]    
vfmsubadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb7,0x5a,0x40]      
vfmsubadd231pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmsubadd231pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb7,0x5a,0x40]     
vfmsubadd231pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb7,0x5a,0x40]    
vfmsubadd231pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231pd 485498096, %zmm19, %zmm19 

// CHECK: vfmsubadd231pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb7,0x5a,0x40]      
vfmsubadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb7,0x5a,0x40]     
vfmsubadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb7,0x5a,0x40]    
vfmsubadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb7,0x5c,0x02,0x40]      
vfmsubadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb7,0x5c,0x02,0x40]     
vfmsubadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb7,0x5c,0x02,0x40]    
vfmsubadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb7,0x5c,0x82,0x40]      
vfmsubadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb7,0x5c,0x82,0xc0]      
vfmsubadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb7,0x5c,0x82,0x40]     
vfmsubadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb7,0x5c,0x82,0xc0]     
vfmsubadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb7,0x5c,0x82,0x40]    
vfmsubadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb7,0x5c,0x82,0xc0]    
vfmsubadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0xb7,0xdb]     
vfmsubadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0xb7,0xdb]    
vfmsubadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0xb7,0xdb]   
vfmsubadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xb7,0x1a]      
vfmsubadd231pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfmsubadd231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xb7,0x1a]     
vfmsubadd231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xb7,0x1a]    
vfmsubadd231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xb7,0x1a]      
vfmsubadd231pd (%rdx), %zmm19, %zmm19 

// CHECK: vfmsubadd231pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xb7,0x1a]     
vfmsubadd231pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xb7,0x1a]    
vfmsubadd231pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0xb7,0xdb]     
vfmsubadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0xb7,0xdb]    
vfmsubadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0xb7,0xdb]   
vfmsubadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0xb7,0xdb]     
vfmsubadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0xb7,0xdb]    
vfmsubadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0xb7,0xdb]   
vfmsubadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0xb7,0xdb]     
vfmsubadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0xb7,0xdb]    
vfmsubadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0xb7,0xdb]   
vfmsubadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0xb7,0xdb]      
vfmsubadd231pd %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd231pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0xb7,0xdb]     
vfmsubadd231pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0xb7,0xdb]    
vfmsubadd231pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb7,0x5a,0x40]      
vfmsubadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb7,0x5a,0x40]     
vfmsubadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb7,0x5a,0x40]    
vfmsubadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb7,0x5c,0x02,0x40]      
vfmsubadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb7,0x5c,0x02,0x40]     
vfmsubadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb7,0x5c,0x02,0x40]    
vfmsubadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb7,0x5c,0x82,0x40]      
vfmsubadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb7,0x5c,0x82,0xc0]      
vfmsubadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb7,0x5c,0x82,0x40]     
vfmsubadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb7,0x5c,0x82,0xc0]     
vfmsubadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb7,0x5c,0x82,0x40]    
vfmsubadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb7,0x5c,0x82,0xc0]    
vfmsubadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb7,0x5c,0x82,0x40]      
vfmsubadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsubadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb7,0x5c,0x82,0xc0]      
vfmsubadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfmsubadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb7,0x5c,0x82,0x40]     
vfmsubadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb7,0x5c,0x82,0xc0]     
vfmsubadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb7,0x5c,0x82,0x40]    
vfmsubadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb7,0x5c,0x82,0xc0]    
vfmsubadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb7,0x5c,0x02,0x40]      
vfmsubadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfmsubadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb7,0x5c,0x02,0x40]     
vfmsubadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb7,0x5c,0x02,0x40]    
vfmsubadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb7,0x5a,0x40]      
vfmsubadd231ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfmsubadd231ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb7,0x5a,0x40]     
vfmsubadd231ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb7,0x5a,0x40]    
vfmsubadd231ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231ps 485498096, %zmm19, %zmm19 

// CHECK: vfmsubadd231ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0xb7,0xdb]     
vfmsubadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0xb7,0xdb]    
vfmsubadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0xb7,0xdb]   
vfmsubadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xb7,0x1a]      
vfmsubadd231ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfmsubadd231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xb7,0x1a]     
vfmsubadd231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xb7,0x1a]    
vfmsubadd231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xb7,0x1a]      
vfmsubadd231ps (%rdx), %zmm19, %zmm19 

// CHECK: vfmsubadd231ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xb7,0x1a]     
vfmsubadd231ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xb7,0x1a]    
vfmsubadd231ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0xb7,0xdb]     
vfmsubadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0xb7,0xdb]    
vfmsubadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0xb7,0xdb]   
vfmsubadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0xb7,0xdb]     
vfmsubadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0xb7,0xdb]    
vfmsubadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0xb7,0xdb]   
vfmsubadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0xb7,0xdb]     
vfmsubadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0xb7,0xdb]    
vfmsubadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0xb7,0xdb]   
vfmsubadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfmsubadd231ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0xb7,0xdb]      
vfmsubadd231ps %zmm19, %zmm19, %zmm19 

// CHECK: vfmsubadd231ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0xb7,0xdb]     
vfmsubadd231ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfmsubadd231ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0xb7,0xdb]    
vfmsubadd231ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9c,0x5c,0x82,0x40]      
vfnmadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9c,0x5c,0x82,0xc0]      
vfnmadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9c,0x5c,0x82,0x40]     
vfnmadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9c,0x5c,0x82,0xc0]     
vfnmadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9c,0x5c,0x82,0x40]    
vfnmadd132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9c,0x5c,0x82,0xc0]    
vfnmadd132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9c,0x5c,0x02,0x40]      
vfnmadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfnmadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9c,0x5c,0x02,0x40]     
vfnmadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9c,0x5c,0x02,0x40]    
vfnmadd132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9c,0x5a,0x40]      
vfnmadd132pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfnmadd132pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9c,0x5a,0x40]     
vfnmadd132pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9c,0x5a,0x40]    
vfnmadd132pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132pd 485498096, %zmm19, %zmm19 

// CHECK: vfnmadd132pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9c,0x5a,0x40]      
vfnmadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9c,0x5a,0x40]     
vfnmadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9c,0x5a,0x40]    
vfnmadd132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9c,0x5c,0x02,0x40]      
vfnmadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9c,0x5c,0x02,0x40]     
vfnmadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9c,0x5c,0x02,0x40]    
vfnmadd132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9c,0x5c,0x82,0x40]      
vfnmadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9c,0x5c,0x82,0xc0]      
vfnmadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9c,0x5c,0x82,0x40]     
vfnmadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9c,0x5c,0x82,0xc0]     
vfnmadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9c,0x5c,0x82,0x40]    
vfnmadd132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9c,0x5c,0x82,0xc0]    
vfnmadd132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0x9c,0xdb]     
vfnmadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0x9c,0xdb]    
vfnmadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0x9c,0xdb]   
vfnmadd132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9c,0x1a]      
vfnmadd132pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9c,0x1a]     
vfnmadd132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9c,0x1a]    
vfnmadd132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9c,0x1a]      
vfnmadd132pd (%rdx), %zmm19, %zmm19 

// CHECK: vfnmadd132pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9c,0x1a]     
vfnmadd132pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9c,0x1a]    
vfnmadd132pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0x9c,0xdb]     
vfnmadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0x9c,0xdb]    
vfnmadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0x9c,0xdb]   
vfnmadd132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0x9c,0xdb]     
vfnmadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0x9c,0xdb]    
vfnmadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0x9c,0xdb]   
vfnmadd132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0x9c,0xdb]     
vfnmadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0x9c,0xdb]    
vfnmadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0x9c,0xdb]   
vfnmadd132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x9c,0xdb]      
vfnmadd132pd %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd132pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x9c,0xdb]     
vfnmadd132pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x9c,0xdb]    
vfnmadd132pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9c,0x5a,0x40]      
vfnmadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9c,0x5a,0x40]     
vfnmadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9c,0x5a,0x40]    
vfnmadd132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9c,0x5c,0x02,0x40]      
vfnmadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9c,0x5c,0x02,0x40]     
vfnmadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9c,0x5c,0x02,0x40]    
vfnmadd132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9c,0x5c,0x82,0x40]      
vfnmadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9c,0x5c,0x82,0xc0]      
vfnmadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9c,0x5c,0x82,0x40]     
vfnmadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9c,0x5c,0x82,0xc0]     
vfnmadd132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9c,0x5c,0x82,0x40]    
vfnmadd132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9c,0x5c,0x82,0x40]      
vfnmadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9c,0x5c,0x82,0xc0]      
vfnmadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9c,0x5c,0x82,0x40]     
vfnmadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9c,0x5c,0x82,0xc0]     
vfnmadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9c,0x5c,0x82,0x40]    
vfnmadd132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9c,0x5c,0x82,0xc0]    
vfnmadd132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9c,0x5c,0x02,0x40]      
vfnmadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfnmadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9c,0x5c,0x02,0x40]     
vfnmadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9c,0x5c,0x02,0x40]    
vfnmadd132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9c,0x5a,0x40]      
vfnmadd132ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfnmadd132ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9c,0x5a,0x40]     
vfnmadd132ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9c,0x5a,0x40]    
vfnmadd132ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132ps 485498096, %zmm19, %zmm19 

// CHECK: vfnmadd132ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0x9c,0xdb]     
vfnmadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0x9c,0xdb]    
vfnmadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0x9c,0xdb]   
vfnmadd132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9c,0x1a]      
vfnmadd132ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9c,0x1a]     
vfnmadd132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9c,0x1a]    
vfnmadd132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9c,0x1a]      
vfnmadd132ps (%rdx), %zmm19, %zmm19 

// CHECK: vfnmadd132ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9c,0x1a]     
vfnmadd132ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9c,0x1a]    
vfnmadd132ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0x9c,0xdb]     
vfnmadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0x9c,0xdb]    
vfnmadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0x9c,0xdb]   
vfnmadd132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0x9c,0xdb]     
vfnmadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0x9c,0xdb]    
vfnmadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0x9c,0xdb]   
vfnmadd132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0x9c,0xdb]     
vfnmadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0x9c,0xdb]    
vfnmadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0x9c,0xdb]   
vfnmadd132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd132ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x9c,0xdb]      
vfnmadd132ps %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd132ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x9c,0xdb]     
vfnmadd132ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd132ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x9c,0xdb]    
vfnmadd132ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xac,0x5c,0x82,0x40]      
vfnmadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xac,0x5c,0x82,0xc0]      
vfnmadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xac,0x5c,0x82,0x40]     
vfnmadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xac,0x5c,0x82,0xc0]     
vfnmadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xac,0x5c,0x82,0x40]    
vfnmadd213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xac,0x5c,0x82,0xc0]    
vfnmadd213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xac,0x5c,0x02,0x40]      
vfnmadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfnmadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xac,0x5c,0x02,0x40]     
vfnmadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xac,0x5c,0x02,0x40]    
vfnmadd213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xac,0x5a,0x40]      
vfnmadd213pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfnmadd213pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xac,0x5a,0x40]     
vfnmadd213pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xac,0x5a,0x40]    
vfnmadd213pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xac,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xac,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xac,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xac,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213pd 485498096, %zmm19, %zmm19 

// CHECK: vfnmadd213pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xac,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xac,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xac,0x5a,0x40]      
vfnmadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xac,0x5a,0x40]     
vfnmadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xac,0x5a,0x40]    
vfnmadd213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xac,0x5c,0x02,0x40]      
vfnmadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xac,0x5c,0x02,0x40]     
vfnmadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xac,0x5c,0x02,0x40]    
vfnmadd213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xac,0x5c,0x82,0x40]      
vfnmadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xac,0x5c,0x82,0xc0]      
vfnmadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xac,0x5c,0x82,0x40]     
vfnmadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xac,0x5c,0x82,0xc0]     
vfnmadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xac,0x5c,0x82,0x40]    
vfnmadd213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xac,0x5c,0x82,0xc0]    
vfnmadd213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0xac,0xdb]     
vfnmadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0xac,0xdb]    
vfnmadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0xac,0xdb]   
vfnmadd213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xac,0x1a]      
vfnmadd213pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xac,0x1a]     
vfnmadd213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xac,0x1a]    
vfnmadd213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xac,0x1a]      
vfnmadd213pd (%rdx), %zmm19, %zmm19 

// CHECK: vfnmadd213pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xac,0x1a]     
vfnmadd213pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xac,0x1a]    
vfnmadd213pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0xac,0xdb]     
vfnmadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0xac,0xdb]    
vfnmadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0xac,0xdb]   
vfnmadd213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0xac,0xdb]     
vfnmadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0xac,0xdb]    
vfnmadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0xac,0xdb]   
vfnmadd213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0xac,0xdb]     
vfnmadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0xac,0xdb]    
vfnmadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0xac,0xdb]   
vfnmadd213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0xac,0xdb]      
vfnmadd213pd %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd213pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0xac,0xdb]     
vfnmadd213pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0xac,0xdb]    
vfnmadd213pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xac,0x5a,0x40]      
vfnmadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xac,0x5a,0x40]     
vfnmadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xac,0x5a,0x40]    
vfnmadd213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xac,0x5c,0x02,0x40]      
vfnmadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xac,0x5c,0x02,0x40]     
vfnmadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xac,0x5c,0x02,0x40]    
vfnmadd213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xac,0x5c,0x82,0x40]      
vfnmadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xac,0x5c,0x82,0xc0]      
vfnmadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xac,0x5c,0x82,0x40]     
vfnmadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xac,0x5c,0x82,0xc0]     
vfnmadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xac,0x5c,0x82,0x40]    
vfnmadd213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xac,0x5c,0x82,0xc0]    
vfnmadd213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xac,0x5c,0x82,0x40]      
vfnmadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xac,0x5c,0x82,0xc0]      
vfnmadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xac,0x5c,0x82,0x40]     
vfnmadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xac,0x5c,0x82,0xc0]     
vfnmadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xac,0x5c,0x82,0x40]    
vfnmadd213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xac,0x5c,0x82,0xc0]    
vfnmadd213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xac,0x5c,0x02,0x40]      
vfnmadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfnmadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xac,0x5c,0x02,0x40]     
vfnmadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xac,0x5c,0x02,0x40]    
vfnmadd213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xac,0x5a,0x40]      
vfnmadd213ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfnmadd213ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xac,0x5a,0x40]     
vfnmadd213ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xac,0x5a,0x40]    
vfnmadd213ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xac,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xac,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xac,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xac,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213ps 485498096, %zmm19, %zmm19 

// CHECK: vfnmadd213ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xac,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xac,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0xac,0xdb]     
vfnmadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0xac,0xdb]    
vfnmadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0xac,0xdb]   
vfnmadd213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xac,0x1a]      
vfnmadd213ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xac,0x1a]     
vfnmadd213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xac,0x1a]    
vfnmadd213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xac,0x1a]      
vfnmadd213ps (%rdx), %zmm19, %zmm19 

// CHECK: vfnmadd213ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xac,0x1a]     
vfnmadd213ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xac,0x1a]    
vfnmadd213ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0xac,0xdb]     
vfnmadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0xac,0xdb]    
vfnmadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0xac,0xdb]   
vfnmadd213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0xac,0xdb]     
vfnmadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0xac,0xdb]    
vfnmadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0xac,0xdb]   
vfnmadd213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0xac,0xdb]     
vfnmadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0xac,0xdb]    
vfnmadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0xac,0xdb]   
vfnmadd213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd213ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0xac,0xdb]      
vfnmadd213ps %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd213ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0xac,0xdb]     
vfnmadd213ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd213ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0xac,0xdb]    
vfnmadd213ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xbc,0x5c,0x82,0x40]      
vfnmadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xbc,0x5c,0x82,0xc0]      
vfnmadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xbc,0x5c,0x82,0x40]     
vfnmadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xbc,0x5c,0x82,0xc0]     
vfnmadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xbc,0x5c,0x82,0x40]    
vfnmadd231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xbc,0x5c,0x82,0xc0]    
vfnmadd231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xbc,0x5c,0x02,0x40]      
vfnmadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfnmadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xbc,0x5c,0x02,0x40]     
vfnmadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xbc,0x5c,0x02,0x40]    
vfnmadd231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xbc,0x5a,0x40]      
vfnmadd231pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfnmadd231pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xbc,0x5a,0x40]     
vfnmadd231pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xbc,0x5a,0x40]    
vfnmadd231pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xbc,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xbc,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xbc,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xbc,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231pd 485498096, %zmm19, %zmm19 

// CHECK: vfnmadd231pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xbc,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xbc,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xbc,0x5a,0x40]      
vfnmadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xbc,0x5a,0x40]     
vfnmadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xbc,0x5a,0x40]    
vfnmadd231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xbc,0x5c,0x02,0x40]      
vfnmadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xbc,0x5c,0x02,0x40]     
vfnmadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xbc,0x5c,0x02,0x40]    
vfnmadd231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xbc,0x5c,0x82,0x40]      
vfnmadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xbc,0x5c,0x82,0xc0]      
vfnmadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xbc,0x5c,0x82,0x40]     
vfnmadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xbc,0x5c,0x82,0xc0]     
vfnmadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xbc,0x5c,0x82,0x40]    
vfnmadd231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xbc,0x5c,0x82,0xc0]    
vfnmadd231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0xbc,0xdb]     
vfnmadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0xbc,0xdb]    
vfnmadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0xbc,0xdb]   
vfnmadd231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xbc,0x1a]      
vfnmadd231pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfnmadd231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xbc,0x1a]     
vfnmadd231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xbc,0x1a]    
vfnmadd231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xbc,0x1a]      
vfnmadd231pd (%rdx), %zmm19, %zmm19 

// CHECK: vfnmadd231pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xbc,0x1a]     
vfnmadd231pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xbc,0x1a]    
vfnmadd231pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0xbc,0xdb]     
vfnmadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0xbc,0xdb]    
vfnmadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0xbc,0xdb]   
vfnmadd231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0xbc,0xdb]     
vfnmadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0xbc,0xdb]    
vfnmadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0xbc,0xdb]   
vfnmadd231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0xbc,0xdb]     
vfnmadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0xbc,0xdb]    
vfnmadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0xbc,0xdb]   
vfnmadd231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0xbc,0xdb]      
vfnmadd231pd %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd231pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0xbc,0xdb]     
vfnmadd231pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0xbc,0xdb]    
vfnmadd231pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xbc,0x5a,0x40]      
vfnmadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xbc,0x5a,0x40]     
vfnmadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xbc,0x5a,0x40]    
vfnmadd231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xbc,0x5c,0x02,0x40]      
vfnmadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xbc,0x5c,0x02,0x40]     
vfnmadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xbc,0x5c,0x02,0x40]    
vfnmadd231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xbc,0x5c,0x82,0x40]      
vfnmadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xbc,0x5c,0x82,0xc0]      
vfnmadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xbc,0x5c,0x82,0x40]     
vfnmadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xbc,0x5c,0x82,0xc0]     
vfnmadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xbc,0x5c,0x82,0x40]    
vfnmadd231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xbc,0x5c,0x82,0xc0]    
vfnmadd231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xbc,0x5c,0x82,0x40]      
vfnmadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xbc,0x5c,0x82,0xc0]      
vfnmadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xbc,0x5c,0x82,0x40]     
vfnmadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xbc,0x5c,0x82,0xc0]     
vfnmadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xbc,0x5c,0x82,0x40]    
vfnmadd231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xbc,0x5c,0x82,0xc0]    
vfnmadd231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xbc,0x5c,0x02,0x40]      
vfnmadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfnmadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xbc,0x5c,0x02,0x40]     
vfnmadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xbc,0x5c,0x02,0x40]    
vfnmadd231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xbc,0x5a,0x40]      
vfnmadd231ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfnmadd231ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xbc,0x5a,0x40]     
vfnmadd231ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xbc,0x5a,0x40]    
vfnmadd231ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xbc,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xbc,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xbc,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xbc,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231ps 485498096, %zmm19, %zmm19 

// CHECK: vfnmadd231ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xbc,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xbc,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0xbc,0xdb]     
vfnmadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0xbc,0xdb]    
vfnmadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0xbc,0xdb]   
vfnmadd231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xbc,0x1a]      
vfnmadd231ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfnmadd231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xbc,0x1a]     
vfnmadd231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xbc,0x1a]    
vfnmadd231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xbc,0x1a]      
vfnmadd231ps (%rdx), %zmm19, %zmm19 

// CHECK: vfnmadd231ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xbc,0x1a]     
vfnmadd231ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xbc,0x1a]    
vfnmadd231ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0xbc,0xdb]     
vfnmadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0xbc,0xdb]    
vfnmadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0xbc,0xdb]   
vfnmadd231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0xbc,0xdb]     
vfnmadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0xbc,0xdb]    
vfnmadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0xbc,0xdb]   
vfnmadd231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0xbc,0xdb]     
vfnmadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0xbc,0xdb]    
vfnmadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0xbc,0xdb]   
vfnmadd231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmadd231ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0xbc,0xdb]      
vfnmadd231ps %zmm19, %zmm19, %zmm19 

// CHECK: vfnmadd231ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0xbc,0xdb]     
vfnmadd231ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmadd231ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0xbc,0xdb]    
vfnmadd231ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9e,0x5c,0x82,0x40]      
vfnmsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9e,0x5c,0x82,0xc0]      
vfnmsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9e,0x5c,0x82,0x40]     
vfnmsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9e,0x5c,0x82,0xc0]     
vfnmsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9e,0x5c,0x82,0x40]    
vfnmsub132pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9e,0x5c,0x82,0xc0]    
vfnmsub132pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9e,0x5c,0x02,0x40]      
vfnmsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfnmsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9e,0x5c,0x02,0x40]     
vfnmsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9e,0x5c,0x02,0x40]    
vfnmsub132pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9e,0x5a,0x40]      
vfnmsub132pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfnmsub132pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9e,0x5a,0x40]     
vfnmsub132pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9e,0x5a,0x40]    
vfnmsub132pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132pd 485498096, %zmm19, %zmm19 

// CHECK: vfnmsub132pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9e,0x5a,0x40]      
vfnmsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9e,0x5a,0x40]     
vfnmsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9e,0x5a,0x40]    
vfnmsub132pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9e,0x5c,0x02,0x40]      
vfnmsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9e,0x5c,0x02,0x40]     
vfnmsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9e,0x5c,0x02,0x40]    
vfnmsub132pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9e,0x5c,0x82,0x40]      
vfnmsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9e,0x5c,0x82,0xc0]      
vfnmsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9e,0x5c,0x82,0x40]     
vfnmsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9e,0x5c,0x82,0xc0]     
vfnmsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9e,0x5c,0x82,0x40]    
vfnmsub132pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9e,0x5c,0x82,0xc0]    
vfnmsub132pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0x9e,0xdb]     
vfnmsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0x9e,0xdb]    
vfnmsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0x9e,0xdb]   
vfnmsub132pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x9e,0x1a]      
vfnmsub132pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x9e,0x1a]     
vfnmsub132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x9e,0x1a]    
vfnmsub132pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x9e,0x1a]      
vfnmsub132pd (%rdx), %zmm19, %zmm19 

// CHECK: vfnmsub132pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x9e,0x1a]     
vfnmsub132pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x9e,0x1a]    
vfnmsub132pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0x9e,0xdb]     
vfnmsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0x9e,0xdb]    
vfnmsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0x9e,0xdb]   
vfnmsub132pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0x9e,0xdb]     
vfnmsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0x9e,0xdb]    
vfnmsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0x9e,0xdb]   
vfnmsub132pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0x9e,0xdb]     
vfnmsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0x9e,0xdb]    
vfnmsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0x9e,0xdb]   
vfnmsub132pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x9e,0xdb]      
vfnmsub132pd %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub132pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x9e,0xdb]     
vfnmsub132pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x9e,0xdb]    
vfnmsub132pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9e,0x5a,0x40]      
vfnmsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9e,0x5a,0x40]     
vfnmsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9e,0x5a,0x40]    
vfnmsub132ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9e,0x5c,0x02,0x40]      
vfnmsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9e,0x5c,0x02,0x40]     
vfnmsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9e,0x5c,0x02,0x40]    
vfnmsub132ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9e,0x5c,0x82,0x40]      
vfnmsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9e,0x5c,0x82,0xc0]      
vfnmsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9e,0x5c,0x82,0x40]     
vfnmsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9e,0x5c,0x82,0xc0]     
vfnmsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9e,0x5c,0x82,0x40]    
vfnmsub132ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9e,0x5c,0x82,0xc0]    
vfnmsub132ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9e,0x5c,0x82,0x40]      
vfnmsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9e,0x5c,0x82,0xc0]      
vfnmsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9e,0x5c,0x82,0x40]     
vfnmsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9e,0x5c,0x82,0xc0]     
vfnmsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9e,0x5c,0x82,0x40]    
vfnmsub132ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9e,0x5c,0x82,0xc0]    
vfnmsub132ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9e,0x5c,0x02,0x40]      
vfnmsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfnmsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9e,0x5c,0x02,0x40]     
vfnmsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9e,0x5c,0x02,0x40]    
vfnmsub132ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9e,0x5a,0x40]      
vfnmsub132ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfnmsub132ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9e,0x5a,0x40]     
vfnmsub132ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9e,0x5a,0x40]    
vfnmsub132ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132ps 485498096, %zmm19, %zmm19 

// CHECK: vfnmsub132ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0x9e,0xdb]     
vfnmsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0x9e,0xdb]    
vfnmsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0x9e,0xdb]   
vfnmsub132ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x9e,0x1a]      
vfnmsub132ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x9e,0x1a]     
vfnmsub132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x9e,0x1a]    
vfnmsub132ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x9e,0x1a]      
vfnmsub132ps (%rdx), %zmm19, %zmm19 

// CHECK: vfnmsub132ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x9e,0x1a]     
vfnmsub132ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x9e,0x1a]    
vfnmsub132ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0x9e,0xdb]     
vfnmsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0x9e,0xdb]    
vfnmsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0x9e,0xdb]   
vfnmsub132ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0x9e,0xdb]     
vfnmsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0x9e,0xdb]    
vfnmsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0x9e,0xdb]   
vfnmsub132ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0x9e,0xdb]     
vfnmsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0x9e,0xdb]    
vfnmsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0x9e,0xdb]   
vfnmsub132ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub132ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x9e,0xdb]      
vfnmsub132ps %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub132ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x9e,0xdb]     
vfnmsub132ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub132ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x9e,0xdb]    
vfnmsub132ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xae,0x5c,0x82,0x40]      
vfnmsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xae,0x5c,0x82,0xc0]      
vfnmsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xae,0x5c,0x82,0x40]     
vfnmsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xae,0x5c,0x82,0xc0]     
vfnmsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xae,0x5c,0x82,0x40]    
vfnmsub213pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xae,0x5c,0x82,0xc0]    
vfnmsub213pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xae,0x5c,0x02,0x40]      
vfnmsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfnmsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xae,0x5c,0x02,0x40]     
vfnmsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xae,0x5c,0x02,0x40]    
vfnmsub213pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xae,0x5a,0x40]      
vfnmsub213pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfnmsub213pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xae,0x5a,0x40]     
vfnmsub213pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xae,0x5a,0x40]    
vfnmsub213pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xae,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xae,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xae,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xae,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213pd 485498096, %zmm19, %zmm19 

// CHECK: vfnmsub213pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xae,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xae,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xae,0x5a,0x40]      
vfnmsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xae,0x5a,0x40]     
vfnmsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xae,0x5a,0x40]    
vfnmsub213pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xae,0x5c,0x02,0x40]      
vfnmsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xae,0x5c,0x02,0x40]     
vfnmsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xae,0x5c,0x02,0x40]    
vfnmsub213pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xae,0x5c,0x82,0x40]      
vfnmsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xae,0x5c,0x82,0xc0]      
vfnmsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xae,0x5c,0x82,0x40]     
vfnmsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xae,0x5c,0x82,0xc0]     
vfnmsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xae,0x5c,0x82,0x40]    
vfnmsub213pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xae,0x5c,0x82,0xc0]    
vfnmsub213pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0xae,0xdb]     
vfnmsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0xae,0xdb]    
vfnmsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0xae,0xdb]   
vfnmsub213pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xae,0x1a]      
vfnmsub213pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xae,0x1a]     
vfnmsub213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xae,0x1a]    
vfnmsub213pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xae,0x1a]      
vfnmsub213pd (%rdx), %zmm19, %zmm19 

// CHECK: vfnmsub213pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xae,0x1a]     
vfnmsub213pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xae,0x1a]    
vfnmsub213pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0xae,0xdb]     
vfnmsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0xae,0xdb]    
vfnmsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0xae,0xdb]   
vfnmsub213pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0xae,0xdb]     
vfnmsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0xae,0xdb]    
vfnmsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0xae,0xdb]   
vfnmsub213pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0xae,0xdb]     
vfnmsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0xae,0xdb]    
vfnmsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0xae,0xdb]   
vfnmsub213pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0xae,0xdb]      
vfnmsub213pd %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub213pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0xae,0xdb]     
vfnmsub213pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0xae,0xdb]    
vfnmsub213pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xae,0x5a,0x40]      
vfnmsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xae,0x5a,0x40]     
vfnmsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xae,0x5a,0x40]    
vfnmsub213ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xae,0x5c,0x02,0x40]      
vfnmsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xae,0x5c,0x02,0x40]     
vfnmsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xae,0x5c,0x02,0x40]    
vfnmsub213ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xae,0x5c,0x82,0x40]      
vfnmsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xae,0x5c,0x82,0xc0]      
vfnmsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xae,0x5c,0x82,0x40]     
vfnmsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xae,0x5c,0x82,0xc0]     
vfnmsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xae,0x5c,0x82,0x40]    
vfnmsub213ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xae,0x5c,0x82,0xc0]    
vfnmsub213ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xae,0x5c,0x82,0x40]      
vfnmsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xae,0x5c,0x82,0xc0]      
vfnmsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xae,0x5c,0x82,0x40]     
vfnmsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xae,0x5c,0x82,0xc0]     
vfnmsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xae,0x5c,0x82,0x40]    
vfnmsub213ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xae,0x5c,0x82,0xc0]    
vfnmsub213ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xae,0x5c,0x02,0x40]      
vfnmsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfnmsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xae,0x5c,0x02,0x40]     
vfnmsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xae,0x5c,0x02,0x40]    
vfnmsub213ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xae,0x5a,0x40]      
vfnmsub213ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfnmsub213ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xae,0x5a,0x40]     
vfnmsub213ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xae,0x5a,0x40]    
vfnmsub213ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xae,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xae,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xae,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xae,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213ps 485498096, %zmm19, %zmm19 

// CHECK: vfnmsub213ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xae,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xae,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0xae,0xdb]     
vfnmsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0xae,0xdb]    
vfnmsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0xae,0xdb]   
vfnmsub213ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xae,0x1a]      
vfnmsub213ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xae,0x1a]     
vfnmsub213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xae,0x1a]    
vfnmsub213ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xae,0x1a]      
vfnmsub213ps (%rdx), %zmm19, %zmm19 

// CHECK: vfnmsub213ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xae,0x1a]     
vfnmsub213ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xae,0x1a]    
vfnmsub213ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0xae,0xdb]     
vfnmsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0xae,0xdb]    
vfnmsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0xae,0xdb]   
vfnmsub213ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0xae,0xdb]     
vfnmsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0xae,0xdb]    
vfnmsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0xae,0xdb]   
vfnmsub213ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0xae,0xdb]     
vfnmsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0xae,0xdb]    
vfnmsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0xae,0xdb]   
vfnmsub213ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub213ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0xae,0xdb]      
vfnmsub213ps %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub213ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0xae,0xdb]     
vfnmsub213ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub213ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0xae,0xdb]    
vfnmsub213ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xbe,0x5c,0x82,0x40]      
vfnmsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xbe,0x5c,0x82,0xc0]      
vfnmsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xbe,0x5c,0x82,0x40]     
vfnmsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xbe,0x5c,0x82,0xc0]     
vfnmsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xbe,0x5c,0x82,0x40]    
vfnmsub231pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xbe,0x5c,0x82,0xc0]    
vfnmsub231pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xbe,0x5c,0x02,0x40]      
vfnmsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfnmsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xbe,0x5c,0x02,0x40]     
vfnmsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xbe,0x5c,0x02,0x40]    
vfnmsub231pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xbe,0x5a,0x40]      
vfnmsub231pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfnmsub231pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xbe,0x5a,0x40]     
vfnmsub231pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xbe,0x5a,0x40]    
vfnmsub231pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xbe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xbe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xbe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xbe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231pd 485498096, %zmm19, %zmm19 

// CHECK: vfnmsub231pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xbe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xbe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xbe,0x5a,0x40]      
vfnmsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xbe,0x5a,0x40]     
vfnmsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xbe,0x5a,0x40]    
vfnmsub231pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xbe,0x5c,0x02,0x40]      
vfnmsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xbe,0x5c,0x02,0x40]     
vfnmsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xbe,0x5c,0x02,0x40]    
vfnmsub231pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xbe,0x5c,0x82,0x40]      
vfnmsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xbe,0x5c,0x82,0xc0]      
vfnmsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xbe,0x5c,0x82,0x40]     
vfnmsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xbe,0x5c,0x82,0xc0]     
vfnmsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xbe,0x5c,0x82,0x40]    
vfnmsub231pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xbe,0x5c,0x82,0xc0]    
vfnmsub231pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x30,0xbe,0xdb]     
vfnmsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x32,0xbe,0xdb]    
vfnmsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xb2,0xbe,0xdb]   
vfnmsub231pd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0xbe,0x1a]      
vfnmsub231pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vfnmsub231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0xbe,0x1a]     
vfnmsub231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0xbe,0x1a]    
vfnmsub231pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0xbe,0x1a]      
vfnmsub231pd (%rdx), %zmm19, %zmm19 

// CHECK: vfnmsub231pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0xbe,0x1a]     
vfnmsub231pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0xbe,0x1a]    
vfnmsub231pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x10,0xbe,0xdb]     
vfnmsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x12,0xbe,0xdb]    
vfnmsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x92,0xbe,0xdb]   
vfnmsub231pd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x50,0xbe,0xdb]     
vfnmsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x52,0xbe,0xdb]    
vfnmsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xd2,0xbe,0xdb]   
vfnmsub231pd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x70,0xbe,0xdb]     
vfnmsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x72,0xbe,0xdb]    
vfnmsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xf2,0xbe,0xdb]   
vfnmsub231pd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0xbe,0xdb]      
vfnmsub231pd %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub231pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0xbe,0xdb]     
vfnmsub231pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0xbe,0xdb]    
vfnmsub231pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xbe,0x5a,0x40]      
vfnmsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xbe,0x5a,0x40]     
vfnmsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xbe,0x5a,0x40]    
vfnmsub231ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xbe,0x5c,0x02,0x40]      
vfnmsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xbe,0x5c,0x02,0x40]     
vfnmsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xbe,0x5c,0x02,0x40]    
vfnmsub231ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xbe,0x5c,0x82,0x40]      
vfnmsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xbe,0x5c,0x82,0xc0]      
vfnmsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xbe,0x5c,0x82,0x40]     
vfnmsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xbe,0x5c,0x82,0xc0]     
vfnmsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xbe,0x5c,0x82,0x40]    
vfnmsub231ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xbe,0x5c,0x82,0xc0]    
vfnmsub231ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xbe,0x5c,0x82,0x40]      
vfnmsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xbe,0x5c,0x82,0xc0]      
vfnmsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vfnmsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xbe,0x5c,0x82,0x40]     
vfnmsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xbe,0x5c,0x82,0xc0]     
vfnmsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xbe,0x5c,0x82,0x40]    
vfnmsub231ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xbe,0x5c,0x82,0xc0]    
vfnmsub231ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xbe,0x5c,0x02,0x40]      
vfnmsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vfnmsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xbe,0x5c,0x02,0x40]     
vfnmsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xbe,0x5c,0x02,0x40]    
vfnmsub231ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xbe,0x5a,0x40]      
vfnmsub231ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vfnmsub231ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xbe,0x5a,0x40]     
vfnmsub231ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xbe,0x5a,0x40]    
vfnmsub231ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xbe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xbe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xbe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xbe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231ps 485498096, %zmm19, %zmm19 

// CHECK: vfnmsub231ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xbe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xbe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x30,0xbe,0xdb]     
vfnmsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x32,0xbe,0xdb]    
vfnmsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xb2,0xbe,0xdb]   
vfnmsub231ps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0xbe,0x1a]      
vfnmsub231ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vfnmsub231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0xbe,0x1a]     
vfnmsub231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0xbe,0x1a]    
vfnmsub231ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0xbe,0x1a]      
vfnmsub231ps (%rdx), %zmm19, %zmm19 

// CHECK: vfnmsub231ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0xbe,0x1a]     
vfnmsub231ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0xbe,0x1a]    
vfnmsub231ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x10,0xbe,0xdb]     
vfnmsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x12,0xbe,0xdb]    
vfnmsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0x92,0xbe,0xdb]   
vfnmsub231ps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x50,0xbe,0xdb]     
vfnmsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x52,0xbe,0xdb]    
vfnmsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xd2,0xbe,0xdb]   
vfnmsub231ps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x70,0xbe,0xdb]     
vfnmsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x72,0xbe,0xdb]    
vfnmsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xf2,0xbe,0xdb]   
vfnmsub231ps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vfnmsub231ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0xbe,0xdb]      
vfnmsub231ps %zmm19, %zmm19, %zmm19 

// CHECK: vfnmsub231ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0xbe,0xdb]     
vfnmsub231ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vfnmsub231ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0xbe,0xdb]    
vfnmsub231ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vgatherdpd 512(%rdx,%ymm3,4), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4b,0x92,0x5c,0x9a,0x40]      
vgatherdpd 512(%rdx,%ymm3,4), %zmm19 {%k3} 

// CHECK: vgatherdpd -512(%rdx,%ymm3,4), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4b,0x92,0x5c,0x9a,0xc0]      
vgatherdpd -512(%rdx,%ymm3,4), %zmm19 {%k3} 

// CHECK: vgatherdpd 512(%rdx,%ymm3), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4b,0x92,0x5c,0x1a,0x40]      
vgatherdpd 512(%rdx,%ymm3), %zmm19 {%k3} 

// CHECK: vgatherdps 256(%rdx,%zmm3,4), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4b,0x92,0x5c,0x9a,0x40]      
vgatherdps 256(%rdx,%zmm3,4), %zmm19 {%k3} 

// CHECK: vgatherdps -256(%rdx,%zmm3,4), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4b,0x92,0x5c,0x9a,0xc0]      
vgatherdps -256(%rdx,%zmm3,4), %zmm19 {%k3} 

// CHECK: vgatherdps 256(%rdx,%zmm3), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4b,0x92,0x5c,0x1a,0x40]      
vgatherdps 256(%rdx,%zmm3), %zmm19 {%k3} 

// CHECK: vgatherqpd 512(%rdx,%zmm3,4), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4b,0x93,0x5c,0x9a,0x40]      
vgatherqpd 512(%rdx,%zmm3,4), %zmm19 {%k3} 

// CHECK: vgatherqpd -512(%rdx,%zmm3,4), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4b,0x93,0x5c,0x9a,0xc0]      
vgatherqpd -512(%rdx,%zmm3,4), %zmm19 {%k3} 

// CHECK: vgatherqpd 512(%rdx,%zmm3), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4b,0x93,0x5c,0x1a,0x40]      
vgatherqpd 512(%rdx,%zmm3), %zmm19 {%k3} 

// CHECK: vgatherqps 256(%rdx,%zmm3,4), %ymm23 {%k3} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4b,0x93,0x7c,0x9a,0x40]      
vgatherqps 256(%rdx,%zmm3,4), %ymm23 {%k3} 

// CHECK: vgatherqps -256(%rdx,%zmm3,4), %ymm23 {%k3} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4b,0x93,0x7c,0x9a,0xc0]      
vgatherqps -256(%rdx,%zmm3,4), %ymm23 {%k3} 

// CHECK: vgatherqps 256(%rdx,%zmm3), %ymm23 {%k3} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4b,0x93,0x7c,0x1a,0x40]      
vgatherqps 256(%rdx,%zmm3), %ymm23 {%k3} 

// CHECK: vgetexppd 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x42,0x5c,0x82,0x40]       
vgetexppd 4096(%rdx,%rax,4), %zmm19 

// CHECK: vgetexppd -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x42,0x5c,0x82,0xc0]       
vgetexppd -4096(%rdx,%rax,4), %zmm19 

// CHECK: vgetexppd 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x42,0x5c,0x82,0x40]      
vgetexppd 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vgetexppd -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x42,0x5c,0x82,0xc0]      
vgetexppd -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vgetexppd 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x42,0x5c,0x82,0x40]     
vgetexppd 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vgetexppd -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x42,0x5c,0x82,0xc0]     
vgetexppd -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vgetexppd 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x42,0x5c,0x02,0x40]       
vgetexppd 4096(%rdx,%rax), %zmm19 

// CHECK: vgetexppd 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x42,0x5c,0x02,0x40]      
vgetexppd 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vgetexppd 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x42,0x5c,0x02,0x40]     
vgetexppd 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vgetexppd 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x42,0x5a,0x40]       
vgetexppd 4096(%rdx), %zmm19 

// CHECK: vgetexppd 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x42,0x5a,0x40]      
vgetexppd 4096(%rdx), %zmm19 {%k2} 

// CHECK: vgetexppd 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x42,0x5a,0x40]     
vgetexppd 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vgetexppd 485498096{1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x58,0x42,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vgetexppd 485498096{1to8}, %zmm19 

// CHECK: vgetexppd 485498096{1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x5a,0x42,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vgetexppd 485498096{1to8}, %zmm19 {%k2} 

// CHECK: vgetexppd 485498096{1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xda,0x42,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vgetexppd 485498096{1to8}, %zmm19 {%k2} {z} 

// CHECK: vgetexppd 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x42,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vgetexppd 485498096, %zmm19 

// CHECK: vgetexppd 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x42,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vgetexppd 485498096, %zmm19 {%k2} 

// CHECK: vgetexppd 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x42,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vgetexppd 485498096, %zmm19 {%k2} {z} 

// CHECK: vgetexppd 512(%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x58,0x42,0x5a,0x40]       
vgetexppd 512(%rdx){1to8}, %zmm19 

// CHECK: vgetexppd 512(%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x5a,0x42,0x5a,0x40]      
vgetexppd 512(%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vgetexppd 512(%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xda,0x42,0x5a,0x40]     
vgetexppd 512(%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vgetexppd 512(%rdx,%rax){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x58,0x42,0x5c,0x02,0x40]       
vgetexppd 512(%rdx,%rax){1to8}, %zmm19 

// CHECK: vgetexppd 512(%rdx,%rax){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x5a,0x42,0x5c,0x02,0x40]      
vgetexppd 512(%rdx,%rax){1to8}, %zmm19 {%k2} 

// CHECK: vgetexppd 512(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xda,0x42,0x5c,0x02,0x40]     
vgetexppd 512(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 

// CHECK: vgetexppd 512(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x58,0x42,0x5c,0x82,0x40]       
vgetexppd 512(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vgetexppd -512(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x58,0x42,0x5c,0x82,0xc0]       
vgetexppd -512(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vgetexppd 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x5a,0x42,0x5c,0x82,0x40]      
vgetexppd 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vgetexppd -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x5a,0x42,0x5c,0x82,0xc0]      
vgetexppd -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vgetexppd 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xda,0x42,0x5c,0x82,0x40]     
vgetexppd 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vgetexppd -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xda,0x42,0x5c,0x82,0xc0]     
vgetexppd -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vgetexppd (%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x58,0x42,0x1a]       
vgetexppd (%rdx){1to8}, %zmm19 

// CHECK: vgetexppd (%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x5a,0x42,0x1a]      
vgetexppd (%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vgetexppd (%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xda,0x42,0x1a]     
vgetexppd (%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vgetexppd (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x42,0x1a]       
vgetexppd (%rdx), %zmm19 

// CHECK: vgetexppd (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x42,0x1a]      
vgetexppd (%rdx), %zmm19 {%k2} 

// CHECK: vgetexppd (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x42,0x1a]     
vgetexppd (%rdx), %zmm19 {%k2} {z} 

// CHECK: vgetexppd {sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xfd,0x18,0x42,0xdb]      
vgetexppd {sae}, %zmm19, %zmm19 

// CHECK: vgetexppd {sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xfd,0x1a,0x42,0xdb]     
vgetexppd {sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vgetexppd {sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xfd,0x9a,0x42,0xdb]    
vgetexppd {sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vgetexppd %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xfd,0x48,0x42,0xdb]       
vgetexppd %zmm19, %zmm19 

// CHECK: vgetexppd %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x42,0xdb]      
vgetexppd %zmm19, %zmm19 {%k2} 

// CHECK: vgetexppd %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xfd,0xca,0x42,0xdb]     
vgetexppd %zmm19, %zmm19 {%k2} {z} 

// CHECK: vgetexpps 256(%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x58,0x42,0x5a,0x40]       
vgetexpps 256(%rdx){1to16}, %zmm19 

// CHECK: vgetexpps 256(%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x5a,0x42,0x5a,0x40]      
vgetexpps 256(%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vgetexpps 256(%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xda,0x42,0x5a,0x40]     
vgetexpps 256(%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vgetexpps 256(%rdx,%rax){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x58,0x42,0x5c,0x02,0x40]       
vgetexpps 256(%rdx,%rax){1to16}, %zmm19 

// CHECK: vgetexpps 256(%rdx,%rax){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x5a,0x42,0x5c,0x02,0x40]      
vgetexpps 256(%rdx,%rax){1to16}, %zmm19 {%k2} 

// CHECK: vgetexpps 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xda,0x42,0x5c,0x02,0x40]     
vgetexpps 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 

// CHECK: vgetexpps 256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x58,0x42,0x5c,0x82,0x40]       
vgetexpps 256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vgetexpps -256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x58,0x42,0x5c,0x82,0xc0]       
vgetexpps -256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vgetexpps 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x5a,0x42,0x5c,0x82,0x40]      
vgetexpps 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vgetexpps -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x5a,0x42,0x5c,0x82,0xc0]      
vgetexpps -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vgetexpps 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xda,0x42,0x5c,0x82,0x40]     
vgetexpps 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vgetexpps -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xda,0x42,0x5c,0x82,0xc0]     
vgetexpps -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vgetexpps 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x42,0x5c,0x82,0x40]       
vgetexpps 4096(%rdx,%rax,4), %zmm19 

// CHECK: vgetexpps -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x42,0x5c,0x82,0xc0]       
vgetexpps -4096(%rdx,%rax,4), %zmm19 

// CHECK: vgetexpps 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x42,0x5c,0x82,0x40]      
vgetexpps 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vgetexpps -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x42,0x5c,0x82,0xc0]      
vgetexpps -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vgetexpps 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x42,0x5c,0x82,0x40]     
vgetexpps 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vgetexpps -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x42,0x5c,0x82,0xc0]     
vgetexpps -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vgetexpps 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x42,0x5c,0x02,0x40]       
vgetexpps 4096(%rdx,%rax), %zmm19 

// CHECK: vgetexpps 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x42,0x5c,0x02,0x40]      
vgetexpps 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vgetexpps 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x42,0x5c,0x02,0x40]     
vgetexpps 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vgetexpps 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x42,0x5a,0x40]       
vgetexpps 4096(%rdx), %zmm19 

// CHECK: vgetexpps 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x42,0x5a,0x40]      
vgetexpps 4096(%rdx), %zmm19 {%k2} 

// CHECK: vgetexpps 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x42,0x5a,0x40]     
vgetexpps 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vgetexpps 485498096{1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x58,0x42,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vgetexpps 485498096{1to16}, %zmm19 

// CHECK: vgetexpps 485498096{1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x5a,0x42,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vgetexpps 485498096{1to16}, %zmm19 {%k2} 

// CHECK: vgetexpps 485498096{1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xda,0x42,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vgetexpps 485498096{1to16}, %zmm19 {%k2} {z} 

// CHECK: vgetexpps 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x42,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vgetexpps 485498096, %zmm19 

// CHECK: vgetexpps 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x42,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vgetexpps 485498096, %zmm19 {%k2} 

// CHECK: vgetexpps 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x42,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vgetexpps 485498096, %zmm19 {%k2} {z} 

// CHECK: vgetexpps (%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x58,0x42,0x1a]       
vgetexpps (%rdx){1to16}, %zmm19 

// CHECK: vgetexpps (%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x5a,0x42,0x1a]      
vgetexpps (%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vgetexpps (%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xda,0x42,0x1a]     
vgetexpps (%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vgetexpps (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x42,0x1a]       
vgetexpps (%rdx), %zmm19 

// CHECK: vgetexpps (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x42,0x1a]      
vgetexpps (%rdx), %zmm19 {%k2} 

// CHECK: vgetexpps (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x42,0x1a]     
vgetexpps (%rdx), %zmm19 {%k2} {z} 

// CHECK: vgetexpps {sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x7d,0x18,0x42,0xdb]      
vgetexpps {sae}, %zmm19, %zmm19 

// CHECK: vgetexpps {sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x7d,0x1a,0x42,0xdb]     
vgetexpps {sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vgetexpps {sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x7d,0x9a,0x42,0xdb]    
vgetexpps {sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vgetexpps %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x7d,0x48,0x42,0xdb]       
vgetexpps %zmm19, %zmm19 

// CHECK: vgetexpps %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x42,0xdb]      
vgetexpps %zmm19, %zmm19 {%k2} 

// CHECK: vgetexpps %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x7d,0xca,0x42,0xdb]     
vgetexpps %zmm19, %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x26,0x5c,0x82,0x40,0x00]      
vgetmantpd $0, 4096(%rdx,%rax,4), %zmm19 

// CHECK: vgetmantpd $0, -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x26,0x5c,0x82,0xc0,0x00]      
vgetmantpd $0, -4096(%rdx,%rax,4), %zmm19 

// CHECK: vgetmantpd $0, 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x26,0x5c,0x82,0x40,0x00]     
vgetmantpd $0, 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vgetmantpd $0, -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x26,0x5c,0x82,0xc0,0x00]     
vgetmantpd $0, -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vgetmantpd $0, 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x26,0x5c,0x82,0x40,0x00]    
vgetmantpd $0, 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x26,0x5c,0x82,0xc0,0x00]    
vgetmantpd $0, -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x26,0x5c,0x02,0x40,0x00]      
vgetmantpd $0, 4096(%rdx,%rax), %zmm19 

// CHECK: vgetmantpd $0, 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x26,0x5c,0x02,0x40,0x00]     
vgetmantpd $0, 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vgetmantpd $0, 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x26,0x5c,0x02,0x40,0x00]    
vgetmantpd $0, 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x26,0x5a,0x40,0x00]      
vgetmantpd $0, 4096(%rdx), %zmm19 

// CHECK: vgetmantpd $0, 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x26,0x5a,0x40,0x00]     
vgetmantpd $0, 4096(%rdx), %zmm19 {%k2} 

// CHECK: vgetmantpd $0, 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x26,0x5a,0x40,0x00]    
vgetmantpd $0, 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, 485498096{1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x26,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantpd $0, 485498096{1to8}, %zmm19 

// CHECK: vgetmantpd $0, 485498096{1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x26,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantpd $0, 485498096{1to8}, %zmm19 {%k2} 

// CHECK: vgetmantpd $0, 485498096{1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x26,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantpd $0, 485498096{1to8}, %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x26,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantpd $0, 485498096, %zmm19 

// CHECK: vgetmantpd $0, 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x26,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantpd $0, 485498096, %zmm19 {%k2} 

// CHECK: vgetmantpd $0, 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x26,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantpd $0, 485498096, %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, 512(%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x26,0x5a,0x40,0x00]      
vgetmantpd $0, 512(%rdx){1to8}, %zmm19 

// CHECK: vgetmantpd $0, 512(%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x26,0x5a,0x40,0x00]     
vgetmantpd $0, 512(%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vgetmantpd $0, 512(%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x26,0x5a,0x40,0x00]    
vgetmantpd $0, 512(%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, 512(%rdx,%rax){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x26,0x5c,0x02,0x40,0x00]      
vgetmantpd $0, 512(%rdx,%rax){1to8}, %zmm19 

// CHECK: vgetmantpd $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x26,0x5c,0x02,0x40,0x00]     
vgetmantpd $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} 

// CHECK: vgetmantpd $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x26,0x5c,0x02,0x40,0x00]    
vgetmantpd $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x26,0x5c,0x82,0x40,0x00]      
vgetmantpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vgetmantpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x26,0x5c,0x82,0xc0,0x00]      
vgetmantpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vgetmantpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x26,0x5c,0x82,0x40,0x00]     
vgetmantpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vgetmantpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x26,0x5c,0x82,0xc0,0x00]     
vgetmantpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vgetmantpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x26,0x5c,0x82,0x40,0x00]    
vgetmantpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x26,0x5c,0x82,0xc0,0x00]    
vgetmantpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, (%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x26,0x1a,0x00]      
vgetmantpd $0, (%rdx){1to8}, %zmm19 

// CHECK: vgetmantpd $0, (%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x26,0x1a,0x00]     
vgetmantpd $0, (%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vgetmantpd $0, (%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x26,0x1a,0x00]    
vgetmantpd $0, (%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x26,0x1a,0x00]      
vgetmantpd $0, (%rdx), %zmm19 

// CHECK: vgetmantpd $0, (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x26,0x1a,0x00]     
vgetmantpd $0, (%rdx), %zmm19 {%k2} 

// CHECK: vgetmantpd $0, (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x26,0x1a,0x00]    
vgetmantpd $0, (%rdx), %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, {sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0xfd,0x18,0x26,0xdb,0x00]     
vgetmantpd $0, {sae}, %zmm19, %zmm19 

// CHECK: vgetmantpd $0, {sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0xfd,0x1a,0x26,0xdb,0x00]    
vgetmantpd $0, {sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vgetmantpd $0, {sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0xfd,0x9a,0x26,0xdb,0x00]   
vgetmantpd $0, {sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vgetmantpd $0, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0xfd,0x48,0x26,0xdb,0x00]      
vgetmantpd $0, %zmm19, %zmm19 

// CHECK: vgetmantpd $0, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0xfd,0x4a,0x26,0xdb,0x00]     
vgetmantpd $0, %zmm19, %zmm19 {%k2} 

// CHECK: vgetmantpd $0, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0xfd,0xca,0x26,0xdb,0x00]    
vgetmantpd $0, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, 256(%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x58,0x26,0x5a,0x40,0x00]      
vgetmantps $0, 256(%rdx){1to16}, %zmm19 

// CHECK: vgetmantps $0, 256(%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x5a,0x26,0x5a,0x40,0x00]     
vgetmantps $0, 256(%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vgetmantps $0, 256(%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xda,0x26,0x5a,0x40,0x00]    
vgetmantps $0, 256(%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, 256(%rdx,%rax){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x58,0x26,0x5c,0x02,0x40,0x00]      
vgetmantps $0, 256(%rdx,%rax){1to16}, %zmm19 

// CHECK: vgetmantps $0, 256(%rdx,%rax){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x5a,0x26,0x5c,0x02,0x40,0x00]     
vgetmantps $0, 256(%rdx,%rax){1to16}, %zmm19 {%k2} 

// CHECK: vgetmantps $0, 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xda,0x26,0x5c,0x02,0x40,0x00]    
vgetmantps $0, 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, 256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x58,0x26,0x5c,0x82,0x40,0x00]      
vgetmantps $0, 256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vgetmantps $0, -256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x58,0x26,0x5c,0x82,0xc0,0x00]      
vgetmantps $0, -256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vgetmantps $0, 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x5a,0x26,0x5c,0x82,0x40,0x00]     
vgetmantps $0, 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vgetmantps $0, -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x5a,0x26,0x5c,0x82,0xc0,0x00]     
vgetmantps $0, -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vgetmantps $0, 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xda,0x26,0x5c,0x82,0x40,0x00]    
vgetmantps $0, 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xda,0x26,0x5c,0x82,0xc0,0x00]    
vgetmantps $0, -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x26,0x5c,0x82,0x40,0x00]      
vgetmantps $0, 4096(%rdx,%rax,4), %zmm19 

// CHECK: vgetmantps $0, -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x26,0x5c,0x82,0xc0,0x00]      
vgetmantps $0, -4096(%rdx,%rax,4), %zmm19 

// CHECK: vgetmantps $0, 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x26,0x5c,0x82,0x40,0x00]     
vgetmantps $0, 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vgetmantps $0, -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x26,0x5c,0x82,0xc0,0x00]     
vgetmantps $0, -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vgetmantps $0, 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x26,0x5c,0x82,0x40,0x00]    
vgetmantps $0, 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x26,0x5c,0x82,0xc0,0x00]    
vgetmantps $0, -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x26,0x5c,0x02,0x40,0x00]      
vgetmantps $0, 4096(%rdx,%rax), %zmm19 

// CHECK: vgetmantps $0, 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x26,0x5c,0x02,0x40,0x00]     
vgetmantps $0, 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vgetmantps $0, 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x26,0x5c,0x02,0x40,0x00]    
vgetmantps $0, 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x26,0x5a,0x40,0x00]      
vgetmantps $0, 4096(%rdx), %zmm19 

// CHECK: vgetmantps $0, 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x26,0x5a,0x40,0x00]     
vgetmantps $0, 4096(%rdx), %zmm19 {%k2} 

// CHECK: vgetmantps $0, 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x26,0x5a,0x40,0x00]    
vgetmantps $0, 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, 485498096{1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x58,0x26,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantps $0, 485498096{1to16}, %zmm19 

// CHECK: vgetmantps $0, 485498096{1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x5a,0x26,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantps $0, 485498096{1to16}, %zmm19 {%k2} 

// CHECK: vgetmantps $0, 485498096{1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xda,0x26,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantps $0, 485498096{1to16}, %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x26,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantps $0, 485498096, %zmm19 

// CHECK: vgetmantps $0, 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x26,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantps $0, 485498096, %zmm19 {%k2} 

// CHECK: vgetmantps $0, 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x26,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantps $0, 485498096, %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, (%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x58,0x26,0x1a,0x00]      
vgetmantps $0, (%rdx){1to16}, %zmm19 

// CHECK: vgetmantps $0, (%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x5a,0x26,0x1a,0x00]     
vgetmantps $0, (%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vgetmantps $0, (%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xda,0x26,0x1a,0x00]    
vgetmantps $0, (%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x26,0x1a,0x00]      
vgetmantps $0, (%rdx), %zmm19 

// CHECK: vgetmantps $0, (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x26,0x1a,0x00]     
vgetmantps $0, (%rdx), %zmm19 {%k2} 

// CHECK: vgetmantps $0, (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x26,0x1a,0x00]    
vgetmantps $0, (%rdx), %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, {sae}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0x7d,0x18,0x26,0xdb,0x00]     
vgetmantps $0, {sae}, %zmm19, %zmm19 

// CHECK: vgetmantps $0, {sae}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0x7d,0x1a,0x26,0xdb,0x00]    
vgetmantps $0, {sae}, %zmm19, %zmm19 {%k2} 

// CHECK: vgetmantps $0, {sae}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0x7d,0x9a,0x26,0xdb,0x00]   
vgetmantps $0, {sae}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vgetmantps $0, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0x7d,0x48,0x26,0xdb,0x00]      
vgetmantps $0, %zmm19, %zmm19 

// CHECK: vgetmantps $0, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0x7d,0x4a,0x26,0xdb,0x00]     
vgetmantps $0, %zmm19, %zmm19 {%k2} 

// CHECK: vgetmantps $0, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0x7d,0xca,0x26,0xdb,0x00]    
vgetmantps $0, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf32x4 $0, 1024(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x18,0x5c,0x82,0x40,0x00]     
vinsertf32x4 $0, 1024(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vinsertf32x4 $0, -1024(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x18,0x5c,0x82,0xc0,0x00]     
vinsertf32x4 $0, -1024(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vinsertf32x4 $0, 1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x18,0x5c,0x82,0x40,0x00]    
vinsertf32x4 $0, 1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf32x4 $0, -1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x18,0x5c,0x82,0xc0,0x00]    
vinsertf32x4 $0, -1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf32x4 $0, 1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x18,0x5c,0x82,0x40,0x00]   
vinsertf32x4 $0, 1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf32x4 $0, -1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x18,0x5c,0x82,0xc0,0x00]   
vinsertf32x4 $0, -1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf32x4 $0, 1024(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x18,0x5c,0x02,0x40,0x00]     
vinsertf32x4 $0, 1024(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vinsertf32x4 $0, 1024(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x18,0x5c,0x02,0x40,0x00]    
vinsertf32x4 $0, 1024(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf32x4 $0, 1024(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x18,0x5c,0x02,0x40,0x00]   
vinsertf32x4 $0, 1024(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf32x4 $0, 1024(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x18,0x5a,0x40,0x00]     
vinsertf32x4 $0, 1024(%rdx), %zmm19, %zmm19 

// CHECK: vinsertf32x4 $0, 1024(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x18,0x5a,0x40,0x00]    
vinsertf32x4 $0, 1024(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf32x4 $0, 1024(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x18,0x5a,0x40,0x00]   
vinsertf32x4 $0, 1024(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf32x4 $0, 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x18,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vinsertf32x4 $0, 485498096, %zmm19, %zmm19 

// CHECK: vinsertf32x4 $0, 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x18,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vinsertf32x4 $0, 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf32x4 $0, 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x18,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]   
vinsertf32x4 $0, 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf32x4 $0, (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x18,0x1a,0x00]     
vinsertf32x4 $0, (%rdx), %zmm19, %zmm19 

// CHECK: vinsertf32x4 $0, (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x18,0x1a,0x00]    
vinsertf32x4 $0, (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf32x4 $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x18,0x1a,0x00]   
vinsertf32x4 $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf32x4 $0, %xmm15, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xc3,0x65,0x40,0x18,0xdf,0x00]     
vinsertf32x4 $0, %xmm15, %zmm19, %zmm19 

// CHECK: vinsertf32x4 $0, %xmm15, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xc3,0x65,0x42,0x18,0xdf,0x00]    
vinsertf32x4 $0, %xmm15, %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf32x4 $0, %xmm15, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xc3,0x65,0xc2,0x18,0xdf,0x00]   
vinsertf32x4 $0, %xmm15, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf32x4 $0, %xmm1, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x18,0xd9,0x00]     
vinsertf32x4 $0, %xmm1, %zmm19, %zmm19 

// CHECK: vinsertf32x4 $0, %xmm1, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x18,0xd9,0x00]    
vinsertf32x4 $0, %xmm1, %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf32x4 $0, %xmm1, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x18,0xd9,0x00]   
vinsertf32x4 $0, %xmm1, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf64x4 $0, 2048(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x1a,0x5c,0x82,0x40,0x00]     
vinsertf64x4 $0, 2048(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vinsertf64x4 $0, -2048(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x1a,0x5c,0x82,0xc0,0x00]     
vinsertf64x4 $0, -2048(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vinsertf64x4 $0, 2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x1a,0x5c,0x82,0x40,0x00]    
vinsertf64x4 $0, 2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf64x4 $0, -2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x1a,0x5c,0x82,0xc0,0x00]    
vinsertf64x4 $0, -2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf64x4 $0, 2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x1a,0x5c,0x82,0x40,0x00]   
vinsertf64x4 $0, 2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf64x4 $0, -2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x1a,0x5c,0x82,0xc0,0x00]   
vinsertf64x4 $0, -2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf64x4 $0, 2048(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x1a,0x5c,0x02,0x40,0x00]     
vinsertf64x4 $0, 2048(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vinsertf64x4 $0, 2048(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x1a,0x5c,0x02,0x40,0x00]    
vinsertf64x4 $0, 2048(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf64x4 $0, 2048(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x1a,0x5c,0x02,0x40,0x00]   
vinsertf64x4 $0, 2048(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf64x4 $0, 2048(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x1a,0x5a,0x40,0x00]     
vinsertf64x4 $0, 2048(%rdx), %zmm19, %zmm19 

// CHECK: vinsertf64x4 $0, 2048(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x1a,0x5a,0x40,0x00]    
vinsertf64x4 $0, 2048(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf64x4 $0, 2048(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x1a,0x5a,0x40,0x00]   
vinsertf64x4 $0, 2048(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf64x4 $0, 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x1a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vinsertf64x4 $0, 485498096, %zmm19, %zmm19 

// CHECK: vinsertf64x4 $0, 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x1a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vinsertf64x4 $0, 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf64x4 $0, 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x1a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]   
vinsertf64x4 $0, 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf64x4 $0, (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x1a,0x1a,0x00]     
vinsertf64x4 $0, (%rdx), %zmm19, %zmm19 

// CHECK: vinsertf64x4 $0, (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x1a,0x1a,0x00]    
vinsertf64x4 $0, (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf64x4 $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x1a,0x1a,0x00]   
vinsertf64x4 $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinsertf64x4 $0, %ymm23, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0xe5,0x40,0x1a,0xdf,0x00]     
vinsertf64x4 $0, %ymm23, %zmm19, %zmm19 

// CHECK: vinsertf64x4 $0, %ymm23, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0xe5,0x42,0x1a,0xdf,0x00]    
vinsertf64x4 $0, %ymm23, %zmm19, %zmm19 {%k2} 

// CHECK: vinsertf64x4 $0, %ymm23, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0xe5,0xc2,0x1a,0xdf,0x00]   
vinsertf64x4 $0, %ymm23, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti32x4 $0, 1024(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x38,0x5c,0x82,0x40,0x00]     
vinserti32x4 $0, 1024(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vinserti32x4 $0, -1024(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x38,0x5c,0x82,0xc0,0x00]     
vinserti32x4 $0, -1024(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vinserti32x4 $0, 1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x38,0x5c,0x82,0x40,0x00]    
vinserti32x4 $0, 1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vinserti32x4 $0, -1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x38,0x5c,0x82,0xc0,0x00]    
vinserti32x4 $0, -1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vinserti32x4 $0, 1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x38,0x5c,0x82,0x40,0x00]   
vinserti32x4 $0, 1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti32x4 $0, -1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x38,0x5c,0x82,0xc0,0x00]   
vinserti32x4 $0, -1024(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti32x4 $0, 1024(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x38,0x5c,0x02,0x40,0x00]     
vinserti32x4 $0, 1024(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vinserti32x4 $0, 1024(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x38,0x5c,0x02,0x40,0x00]    
vinserti32x4 $0, 1024(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vinserti32x4 $0, 1024(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x38,0x5c,0x02,0x40,0x00]   
vinserti32x4 $0, 1024(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti32x4 $0, 1024(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x38,0x5a,0x40,0x00]     
vinserti32x4 $0, 1024(%rdx), %zmm19, %zmm19 

// CHECK: vinserti32x4 $0, 1024(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x38,0x5a,0x40,0x00]    
vinserti32x4 $0, 1024(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vinserti32x4 $0, 1024(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x38,0x5a,0x40,0x00]   
vinserti32x4 $0, 1024(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti32x4 $0, 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x38,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vinserti32x4 $0, 485498096, %zmm19, %zmm19 

// CHECK: vinserti32x4 $0, 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x38,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vinserti32x4 $0, 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vinserti32x4 $0, 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x38,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]   
vinserti32x4 $0, 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti32x4 $0, (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x38,0x1a,0x00]     
vinserti32x4 $0, (%rdx), %zmm19, %zmm19 

// CHECK: vinserti32x4 $0, (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x38,0x1a,0x00]    
vinserti32x4 $0, (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vinserti32x4 $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x38,0x1a,0x00]   
vinserti32x4 $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti32x4 $0, %xmm15, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xc3,0x65,0x40,0x38,0xdf,0x00]     
vinserti32x4 $0, %xmm15, %zmm19, %zmm19 

// CHECK: vinserti32x4 $0, %xmm15, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xc3,0x65,0x42,0x38,0xdf,0x00]    
vinserti32x4 $0, %xmm15, %zmm19, %zmm19 {%k2} 

// CHECK: vinserti32x4 $0, %xmm15, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xc3,0x65,0xc2,0x38,0xdf,0x00]   
vinserti32x4 $0, %xmm15, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti32x4 $0, %xmm1, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x65,0x40,0x38,0xd9,0x00]     
vinserti32x4 $0, %xmm1, %zmm19, %zmm19 

// CHECK: vinserti32x4 $0, %xmm1, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x65,0x42,0x38,0xd9,0x00]    
vinserti32x4 $0, %xmm1, %zmm19, %zmm19 {%k2} 

// CHECK: vinserti32x4 $0, %xmm1, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x65,0xc2,0x38,0xd9,0x00]   
vinserti32x4 $0, %xmm1, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti64x4 $0, 2048(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x3a,0x5c,0x82,0x40,0x00]     
vinserti64x4 $0, 2048(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vinserti64x4 $0, -2048(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x3a,0x5c,0x82,0xc0,0x00]     
vinserti64x4 $0, -2048(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vinserti64x4 $0, 2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x3a,0x5c,0x82,0x40,0x00]    
vinserti64x4 $0, 2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vinserti64x4 $0, -2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x3a,0x5c,0x82,0xc0,0x00]    
vinserti64x4 $0, -2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vinserti64x4 $0, 2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x3a,0x5c,0x82,0x40,0x00]   
vinserti64x4 $0, 2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti64x4 $0, -2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x3a,0x5c,0x82,0xc0,0x00]   
vinserti64x4 $0, -2048(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti64x4 $0, 2048(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x3a,0x5c,0x02,0x40,0x00]     
vinserti64x4 $0, 2048(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vinserti64x4 $0, 2048(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x3a,0x5c,0x02,0x40,0x00]    
vinserti64x4 $0, 2048(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vinserti64x4 $0, 2048(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x3a,0x5c,0x02,0x40,0x00]   
vinserti64x4 $0, 2048(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti64x4 $0, 2048(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x3a,0x5a,0x40,0x00]     
vinserti64x4 $0, 2048(%rdx), %zmm19, %zmm19 

// CHECK: vinserti64x4 $0, 2048(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x3a,0x5a,0x40,0x00]    
vinserti64x4 $0, 2048(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vinserti64x4 $0, 2048(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x3a,0x5a,0x40,0x00]   
vinserti64x4 $0, 2048(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti64x4 $0, 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x3a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vinserti64x4 $0, 485498096, %zmm19, %zmm19 

// CHECK: vinserti64x4 $0, 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x3a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vinserti64x4 $0, 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vinserti64x4 $0, 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x3a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]   
vinserti64x4 $0, 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti64x4 $0, (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xe5,0x40,0x3a,0x1a,0x00]     
vinserti64x4 $0, (%rdx), %zmm19, %zmm19 

// CHECK: vinserti64x4 $0, (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xe5,0x42,0x3a,0x1a,0x00]    
vinserti64x4 $0, (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vinserti64x4 $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xe5,0xc2,0x3a,0x1a,0x00]   
vinserti64x4 $0, (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vinserti64x4 $0, %ymm23, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0xe5,0x40,0x3a,0xdf,0x00]     
vinserti64x4 $0, %ymm23, %zmm19, %zmm19 

// CHECK: vinserti64x4 $0, %ymm23, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0xe5,0x42,0x3a,0xdf,0x00]    
vinserti64x4 $0, %ymm23, %zmm19, %zmm19 {%k2} 

// CHECK: vinserti64x4 $0, %ymm23, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0xe5,0xc2,0x3a,0xdf,0x00]   
vinserti64x4 $0, %ymm23, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5f,0x5c,0x82,0x40]      
vmaxpd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vmaxpd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5f,0x5c,0x82,0xc0]      
vmaxpd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vmaxpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5f,0x5c,0x82,0x40]     
vmaxpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5f,0x5c,0x82,0xc0]     
vmaxpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5f,0x5c,0x82,0x40]    
vmaxpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5f,0x5c,0x82,0xc0]    
vmaxpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5f,0x5c,0x02,0x40]      
vmaxpd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vmaxpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5f,0x5c,0x02,0x40]     
vmaxpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5f,0x5c,0x02,0x40]    
vmaxpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5f,0x5a,0x40]      
vmaxpd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vmaxpd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5f,0x5a,0x40]     
vmaxpd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5f,0x5a,0x40]    
vmaxpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmaxpd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vmaxpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmaxpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vmaxpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmaxpd 485498096, %zmm19, %zmm19 

// CHECK: vmaxpd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmaxpd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vmaxpd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5f,0x5a,0x40]      
vmaxpd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vmaxpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5f,0x5a,0x40]     
vmaxpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5f,0x5a,0x40]    
vmaxpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5f,0x5c,0x02,0x40]      
vmaxpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vmaxpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5f,0x5c,0x02,0x40]     
vmaxpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5f,0x5c,0x02,0x40]    
vmaxpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5f,0x5c,0x82,0x40]      
vmaxpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vmaxpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5f,0x5c,0x82,0xc0]      
vmaxpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vmaxpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5f,0x5c,0x82,0x40]     
vmaxpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5f,0x5c,0x82,0xc0]     
vmaxpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5f,0x5c,0x82,0x40]    
vmaxpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5f,0x5c,0x82,0xc0]    
vmaxpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5f,0x1a]      
vmaxpd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vmaxpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5f,0x1a]     
vmaxpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5f,0x1a]    
vmaxpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5f,0x1a]      
vmaxpd (%rdx), %zmm19, %zmm19 

// CHECK: vmaxpd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5f,0x1a]     
vmaxpd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5f,0x1a]    
vmaxpd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd {sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x10,0x5f,0xdb]     
vmaxpd {sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vmaxpd {sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x12,0x5f,0xdb]    
vmaxpd {sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd {sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x92,0x5f,0xdb]   
vmaxpd {sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxpd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x40,0x5f,0xdb]      
vmaxpd %zmm19, %zmm19, %zmm19 

// CHECK: vmaxpd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x42,0x5f,0xdb]     
vmaxpd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxpd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xc2,0x5f,0xdb]    
vmaxpd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5f,0x5a,0x40]      
vmaxps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vmaxps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5f,0x5a,0x40]     
vmaxps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5f,0x5a,0x40]    
vmaxps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5f,0x5c,0x02,0x40]      
vmaxps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vmaxps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5f,0x5c,0x02,0x40]     
vmaxps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5f,0x5c,0x02,0x40]    
vmaxps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5f,0x5c,0x82,0x40]      
vmaxps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vmaxps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5f,0x5c,0x82,0xc0]      
vmaxps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vmaxps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5f,0x5c,0x82,0x40]     
vmaxps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5f,0x5c,0x82,0xc0]     
vmaxps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5f,0x5c,0x82,0x40]    
vmaxps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5f,0x5c,0x82,0xc0]    
vmaxps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5f,0x5c,0x82,0x40]      
vmaxps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vmaxps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5f,0x5c,0x82,0xc0]      
vmaxps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vmaxps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5f,0x5c,0x82,0x40]     
vmaxps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5f,0x5c,0x82,0xc0]     
vmaxps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5f,0x5c,0x82,0x40]    
vmaxps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5f,0x5c,0x82,0xc0]    
vmaxps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5f,0x5c,0x02,0x40]      
vmaxps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vmaxps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5f,0x5c,0x02,0x40]     
vmaxps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5f,0x5c,0x02,0x40]    
vmaxps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5f,0x5a,0x40]      
vmaxps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vmaxps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5f,0x5a,0x40]     
vmaxps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5f,0x5a,0x40]    
vmaxps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmaxps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vmaxps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmaxps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vmaxps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmaxps 485498096, %zmm19, %zmm19 

// CHECK: vmaxps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmaxps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vmaxps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5f,0x1a]      
vmaxps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vmaxps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5f,0x1a]     
vmaxps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5f,0x1a]    
vmaxps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5f,0x1a]      
vmaxps (%rdx), %zmm19, %zmm19 

// CHECK: vmaxps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5f,0x1a]     
vmaxps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5f,0x1a]    
vmaxps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps {sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x10,0x5f,0xdb]     
vmaxps {sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vmaxps {sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x12,0x5f,0xdb]    
vmaxps {sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps {sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0x92,0x5f,0xdb]   
vmaxps {sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmaxps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x40,0x5f,0xdb]      
vmaxps %zmm19, %zmm19, %zmm19 

// CHECK: vmaxps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x42,0x5f,0xdb]     
vmaxps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmaxps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xc2,0x5f,0xdb]    
vmaxps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5d,0x5c,0x82,0x40]      
vminpd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vminpd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5d,0x5c,0x82,0xc0]      
vminpd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vminpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5d,0x5c,0x82,0x40]     
vminpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vminpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5d,0x5c,0x82,0xc0]     
vminpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vminpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5d,0x5c,0x82,0x40]    
vminpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5d,0x5c,0x82,0xc0]    
vminpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5d,0x5c,0x02,0x40]      
vminpd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vminpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5d,0x5c,0x02,0x40]     
vminpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vminpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5d,0x5c,0x02,0x40]    
vminpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5d,0x5a,0x40]      
vminpd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vminpd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5d,0x5a,0x40]     
vminpd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vminpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5d,0x5a,0x40]    
vminpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vminpd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vminpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vminpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vminpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vminpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vminpd 485498096, %zmm19, %zmm19 

// CHECK: vminpd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vminpd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vminpd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vminpd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5d,0x5a,0x40]      
vminpd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vminpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5d,0x5a,0x40]     
vminpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vminpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5d,0x5a,0x40]    
vminpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5d,0x5c,0x02,0x40]      
vminpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vminpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5d,0x5c,0x02,0x40]     
vminpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vminpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5d,0x5c,0x02,0x40]    
vminpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5d,0x5c,0x82,0x40]      
vminpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vminpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5d,0x5c,0x82,0xc0]      
vminpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vminpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5d,0x5c,0x82,0x40]     
vminpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vminpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5d,0x5c,0x82,0xc0]     
vminpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vminpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5d,0x5c,0x82,0x40]    
vminpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5d,0x5c,0x82,0xc0]    
vminpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x5d,0x1a]      
vminpd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vminpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x5d,0x1a]     
vminpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vminpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x5d,0x1a]    
vminpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x5d,0x1a]      
vminpd (%rdx), %zmm19, %zmm19 

// CHECK: vminpd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x5d,0x1a]     
vminpd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vminpd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x5d,0x1a]    
vminpd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd {sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x10,0x5d,0xdb]     
vminpd {sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vminpd {sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x12,0x5d,0xdb]    
vminpd {sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vminpd {sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x92,0x5d,0xdb]   
vminpd {sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminpd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x40,0x5d,0xdb]      
vminpd %zmm19, %zmm19, %zmm19 

// CHECK: vminpd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x42,0x5d,0xdb]     
vminpd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vminpd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xc2,0x5d,0xdb]    
vminpd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5d,0x5a,0x40]      
vminps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vminps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5d,0x5a,0x40]     
vminps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vminps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5d,0x5a,0x40]    
vminps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5d,0x5c,0x02,0x40]      
vminps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vminps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5d,0x5c,0x02,0x40]     
vminps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vminps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5d,0x5c,0x02,0x40]    
vminps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5d,0x5c,0x82,0x40]      
vminps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vminps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5d,0x5c,0x82,0xc0]      
vminps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vminps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5d,0x5c,0x82,0x40]     
vminps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vminps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5d,0x5c,0x82,0xc0]     
vminps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vminps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5d,0x5c,0x82,0x40]    
vminps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5d,0x5c,0x82,0xc0]    
vminps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5d,0x5c,0x82,0x40]      
vminps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vminps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5d,0x5c,0x82,0xc0]      
vminps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vminps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5d,0x5c,0x82,0x40]     
vminps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vminps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5d,0x5c,0x82,0xc0]     
vminps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vminps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5d,0x5c,0x82,0x40]    
vminps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5d,0x5c,0x82,0xc0]    
vminps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5d,0x5c,0x02,0x40]      
vminps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vminps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5d,0x5c,0x02,0x40]     
vminps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vminps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5d,0x5c,0x02,0x40]    
vminps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5d,0x5a,0x40]      
vminps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vminps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5d,0x5a,0x40]     
vminps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vminps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5d,0x5a,0x40]    
vminps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vminps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vminps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vminps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vminps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vminps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vminps 485498096, %zmm19, %zmm19 

// CHECK: vminps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vminps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vminps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vminps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x5d,0x1a]      
vminps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vminps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x5d,0x1a]     
vminps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vminps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x5d,0x1a]    
vminps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x5d,0x1a]      
vminps (%rdx), %zmm19, %zmm19 

// CHECK: vminps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x5d,0x1a]     
vminps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vminps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x5d,0x1a]    
vminps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps {sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x10,0x5d,0xdb]     
vminps {sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vminps {sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x12,0x5d,0xdb]    
vminps {sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vminps {sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0x92,0x5d,0xdb]   
vminps {sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vminps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x40,0x5d,0xdb]      
vminps %zmm19, %zmm19, %zmm19 

// CHECK: vminps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x42,0x5d,0xdb]     
vminps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vminps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xc2,0x5d,0xdb]    
vminps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovapd 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x28,0x5c,0x82,0x40]       
vmovapd 4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovapd -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x28,0x5c,0x82,0xc0]       
vmovapd -4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovapd 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x28,0x5c,0x82,0x40]      
vmovapd 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovapd -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x28,0x5c,0x82,0xc0]      
vmovapd -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovapd 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x28,0x5c,0x82,0x40]     
vmovapd 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovapd -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x28,0x5c,0x82,0xc0]     
vmovapd -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovapd 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x28,0x5c,0x02,0x40]       
vmovapd 4096(%rdx,%rax), %zmm19 

// CHECK: vmovapd 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x28,0x5c,0x02,0x40]      
vmovapd 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vmovapd 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x28,0x5c,0x02,0x40]     
vmovapd 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vmovapd 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x28,0x5a,0x40]       
vmovapd 4096(%rdx), %zmm19 

// CHECK: vmovapd 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x28,0x5a,0x40]      
vmovapd 4096(%rdx), %zmm19 {%k2} 

// CHECK: vmovapd 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x28,0x5a,0x40]     
vmovapd 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovapd 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x28,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovapd 485498096, %zmm19 

// CHECK: vmovapd 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x28,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovapd 485498096, %zmm19 {%k2} 

// CHECK: vmovapd 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x28,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmovapd 485498096, %zmm19 {%k2} {z} 

// CHECK: vmovapd (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x28,0x1a]       
vmovapd (%rdx), %zmm19 

// CHECK: vmovapd (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x28,0x1a]      
vmovapd (%rdx), %zmm19 {%k2} 

// CHECK: vmovapd (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x28,0x1a]     
vmovapd (%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovapd %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xfd,0x48,0x29,0xdb]       
vmovapd.s %zmm19, %zmm19 

// CHECK: vmovapd %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x4a,0x29,0xdb]      
vmovapd.s %zmm19, %zmm19 {%k2} 

// CHECK: vmovapd %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0xca,0x29,0xdb]     
vmovapd.s %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovapd %zmm19, 4096(%rdx) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x29,0x5a,0x40]       
vmovapd %zmm19, 4096(%rdx) 

// CHECK: vmovapd %zmm19, 4096(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x29,0x5a,0x40]      
vmovapd %zmm19, 4096(%rdx) {%k2} 

// CHECK: vmovapd %zmm19, 4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x29,0x5c,0x82,0x40]       
vmovapd %zmm19, 4096(%rdx,%rax,4) 

// CHECK: vmovapd %zmm19, -4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x29,0x5c,0x82,0xc0]       
vmovapd %zmm19, -4096(%rdx,%rax,4) 

// CHECK: vmovapd %zmm19, 4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x29,0x5c,0x82,0x40]      
vmovapd %zmm19, 4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovapd %zmm19, -4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x29,0x5c,0x82,0xc0]      
vmovapd %zmm19, -4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovapd %zmm19, 4096(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x29,0x5c,0x02,0x40]       
vmovapd %zmm19, 4096(%rdx,%rax) 

// CHECK: vmovapd %zmm19, 4096(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x29,0x5c,0x02,0x40]      
vmovapd %zmm19, 4096(%rdx,%rax) {%k2} 

// CHECK: vmovapd %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x29,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovapd %zmm19, 485498096 

// CHECK: vmovapd %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x29,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovapd %zmm19, 485498096 {%k2} 

// CHECK: vmovapd %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x29,0x1a]       
vmovapd %zmm19, (%rdx) 

// CHECK: vmovapd %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x29,0x1a]      
vmovapd %zmm19, (%rdx) {%k2} 

// CHECK: vmovapd %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xfd,0x48,0x28,0xdb]       
vmovapd %zmm19, %zmm19 

// CHECK: vmovapd %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x4a,0x28,0xdb]      
vmovapd %zmm19, %zmm19 {%k2} 

// CHECK: vmovapd %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0xca,0x28,0xdb]     
vmovapd %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovaps 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x28,0x5c,0x82,0x40]       
vmovaps 4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovaps -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x28,0x5c,0x82,0xc0]       
vmovaps -4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovaps 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x28,0x5c,0x82,0x40]      
vmovaps 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovaps -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x28,0x5c,0x82,0xc0]      
vmovaps -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovaps 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x28,0x5c,0x82,0x40]     
vmovaps 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovaps -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x28,0x5c,0x82,0xc0]     
vmovaps -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovaps 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x28,0x5c,0x02,0x40]       
vmovaps 4096(%rdx,%rax), %zmm19 

// CHECK: vmovaps 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x28,0x5c,0x02,0x40]      
vmovaps 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vmovaps 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x28,0x5c,0x02,0x40]     
vmovaps 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vmovaps 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x28,0x5a,0x40]       
vmovaps 4096(%rdx), %zmm19 

// CHECK: vmovaps 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x28,0x5a,0x40]      
vmovaps 4096(%rdx), %zmm19 {%k2} 

// CHECK: vmovaps 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x28,0x5a,0x40]     
vmovaps 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovaps 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x28,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovaps 485498096, %zmm19 

// CHECK: vmovaps 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x28,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovaps 485498096, %zmm19 {%k2} 

// CHECK: vmovaps 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x28,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmovaps 485498096, %zmm19 {%k2} {z} 

// CHECK: vmovaps (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x28,0x1a]       
vmovaps (%rdx), %zmm19 

// CHECK: vmovaps (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x28,0x1a]      
vmovaps (%rdx), %zmm19 {%k2} 

// CHECK: vmovaps (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x28,0x1a]     
vmovaps (%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovaps %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x48,0x29,0xdb]       
vmovaps.s %zmm19, %zmm19 

// CHECK: vmovaps %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x4a,0x29,0xdb]      
vmovaps.s %zmm19, %zmm19 {%k2} 

// CHECK: vmovaps %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xca,0x29,0xdb]     
vmovaps.s %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovaps %zmm19, 4096(%rdx) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x29,0x5a,0x40]       
vmovaps %zmm19, 4096(%rdx) 

// CHECK: vmovaps %zmm19, 4096(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x29,0x5a,0x40]      
vmovaps %zmm19, 4096(%rdx) {%k2} 

// CHECK: vmovaps %zmm19, 4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x29,0x5c,0x82,0x40]       
vmovaps %zmm19, 4096(%rdx,%rax,4) 

// CHECK: vmovaps %zmm19, -4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x29,0x5c,0x82,0xc0]       
vmovaps %zmm19, -4096(%rdx,%rax,4) 

// CHECK: vmovaps %zmm19, 4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x29,0x5c,0x82,0x40]      
vmovaps %zmm19, 4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovaps %zmm19, -4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x29,0x5c,0x82,0xc0]      
vmovaps %zmm19, -4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovaps %zmm19, 4096(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x29,0x5c,0x02,0x40]       
vmovaps %zmm19, 4096(%rdx,%rax) 

// CHECK: vmovaps %zmm19, 4096(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x29,0x5c,0x02,0x40]      
vmovaps %zmm19, 4096(%rdx,%rax) {%k2} 

// CHECK: vmovaps %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x29,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovaps %zmm19, 485498096 

// CHECK: vmovaps %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x29,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovaps %zmm19, 485498096 {%k2} 

// CHECK: vmovaps %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x29,0x1a]       
vmovaps %zmm19, (%rdx) 

// CHECK: vmovaps %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x29,0x1a]      
vmovaps %zmm19, (%rdx) {%k2} 

// CHECK: vmovaps %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x48,0x28,0xdb]       
vmovaps %zmm19, %zmm19 

// CHECK: vmovaps %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x4a,0x28,0xdb]      
vmovaps %zmm19, %zmm19 {%k2} 

// CHECK: vmovaps %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xca,0x28,0xdb]     
vmovaps %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovddup 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xff,0x48,0x12,0x5c,0x82,0x40]       
vmovddup 4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovddup -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xff,0x48,0x12,0x5c,0x82,0xc0]       
vmovddup -4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovddup 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x4a,0x12,0x5c,0x82,0x40]      
vmovddup 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovddup -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x4a,0x12,0x5c,0x82,0xc0]      
vmovddup -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovddup 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xca,0x12,0x5c,0x82,0x40]     
vmovddup 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovddup -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xca,0x12,0x5c,0x82,0xc0]     
vmovddup -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovddup 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xff,0x48,0x12,0x5c,0x02,0x40]       
vmovddup 4096(%rdx,%rax), %zmm19 

// CHECK: vmovddup 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x4a,0x12,0x5c,0x02,0x40]      
vmovddup 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vmovddup 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xca,0x12,0x5c,0x02,0x40]     
vmovddup 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vmovddup 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xff,0x48,0x12,0x5a,0x40]       
vmovddup 4096(%rdx), %zmm19 

// CHECK: vmovddup 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x4a,0x12,0x5a,0x40]      
vmovddup 4096(%rdx), %zmm19 {%k2} 

// CHECK: vmovddup 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xca,0x12,0x5a,0x40]     
vmovddup 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovddup 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xff,0x48,0x12,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovddup 485498096, %zmm19 

// CHECK: vmovddup 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x4a,0x12,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovddup 485498096, %zmm19 {%k2} 

// CHECK: vmovddup 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xca,0x12,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmovddup 485498096, %zmm19 {%k2} {z} 

// CHECK: vmovddup (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xff,0x48,0x12,0x1a]       
vmovddup (%rdx), %zmm19 

// CHECK: vmovddup (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xff,0x4a,0x12,0x1a]      
vmovddup (%rdx), %zmm19 {%k2} 

// CHECK: vmovddup (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xff,0xca,0x12,0x1a]     
vmovddup (%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovddup %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xff,0x48,0x12,0xdb]       
vmovddup %zmm19, %zmm19 

// CHECK: vmovddup %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xff,0x4a,0x12,0xdb]      
vmovddup %zmm19, %zmm19 {%k2} 

// CHECK: vmovddup %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xff,0xca,0x12,0xdb]     
vmovddup %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovdqa32 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x6f,0x5c,0x82,0x40]       
vmovdqa32 4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovdqa32 -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x6f,0x5c,0x82,0xc0]       
vmovdqa32 -4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovdqa32 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x6f,0x5c,0x82,0x40]      
vmovdqa32 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovdqa32 -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x6f,0x5c,0x82,0xc0]      
vmovdqa32 -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovdqa32 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xca,0x6f,0x5c,0x82,0x40]     
vmovdqa32 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovdqa32 -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xca,0x6f,0x5c,0x82,0xc0]     
vmovdqa32 -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovdqa32 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x6f,0x5c,0x02,0x40]       
vmovdqa32 4096(%rdx,%rax), %zmm19 

// CHECK: vmovdqa32 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x6f,0x5c,0x02,0x40]      
vmovdqa32 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vmovdqa32 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xca,0x6f,0x5c,0x02,0x40]     
vmovdqa32 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vmovdqa32 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x6f,0x5a,0x40]       
vmovdqa32 4096(%rdx), %zmm19 

// CHECK: vmovdqa32 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x6f,0x5a,0x40]      
vmovdqa32 4096(%rdx), %zmm19 {%k2} 

// CHECK: vmovdqa32 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xca,0x6f,0x5a,0x40]     
vmovdqa32 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovdqa32 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x6f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovdqa32 485498096, %zmm19 

// CHECK: vmovdqa32 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x6f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovdqa32 485498096, %zmm19 {%k2} 

// CHECK: vmovdqa32 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xca,0x6f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmovdqa32 485498096, %zmm19 {%k2} {z} 

// CHECK: vmovdqa32 (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x6f,0x1a]       
vmovdqa32 (%rdx), %zmm19 

// CHECK: vmovdqa32 (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x6f,0x1a]      
vmovdqa32 (%rdx), %zmm19 {%k2} 

// CHECK: vmovdqa32 (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7d,0xca,0x6f,0x1a]     
vmovdqa32 (%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovdqa32 %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7d,0x48,0x7f,0xdb]       
vmovdqa32.s %zmm19, %zmm19 

// CHECK: vmovdqa32 %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7d,0x4a,0x7f,0xdb]      
vmovdqa32.s %zmm19, %zmm19 {%k2} 

// CHECK: vmovdqa32 %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7d,0xca,0x7f,0xdb]     
vmovdqa32.s %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovdqa32 %zmm19, 4096(%rdx) 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x5a,0x40]       
vmovdqa32 %zmm19, 4096(%rdx) 

// CHECK: vmovdqa32 %zmm19, 4096(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x7f,0x5a,0x40]      
vmovdqa32 %zmm19, 4096(%rdx) {%k2} 

// CHECK: vmovdqa32 %zmm19, 4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x5c,0x82,0x40]       
vmovdqa32 %zmm19, 4096(%rdx,%rax,4) 

// CHECK: vmovdqa32 %zmm19, -4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x5c,0x82,0xc0]       
vmovdqa32 %zmm19, -4096(%rdx,%rax,4) 

// CHECK: vmovdqa32 %zmm19, 4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x7f,0x5c,0x82,0x40]      
vmovdqa32 %zmm19, 4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovdqa32 %zmm19, -4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x7f,0x5c,0x82,0xc0]      
vmovdqa32 %zmm19, -4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovdqa32 %zmm19, 4096(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x5c,0x02,0x40]       
vmovdqa32 %zmm19, 4096(%rdx,%rax) 

// CHECK: vmovdqa32 %zmm19, 4096(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x7f,0x5c,0x02,0x40]      
vmovdqa32 %zmm19, 4096(%rdx,%rax) {%k2} 

// CHECK: vmovdqa32 %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovdqa32 %zmm19, 485498096 

// CHECK: vmovdqa32 %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovdqa32 %zmm19, 485498096 {%k2} 

// CHECK: vmovdqa32 %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x1a]       
vmovdqa32 %zmm19, (%rdx) 

// CHECK: vmovdqa32 %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7d,0x4a,0x7f,0x1a]      
vmovdqa32 %zmm19, (%rdx) {%k2} 

// CHECK: vmovdqa32 %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7d,0x48,0x6f,0xdb]       
vmovdqa32 %zmm19, %zmm19 

// CHECK: vmovdqa32 %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7d,0x4a,0x6f,0xdb]      
vmovdqa32 %zmm19, %zmm19 {%k2} 

// CHECK: vmovdqa32 %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7d,0xca,0x6f,0xdb]     
vmovdqa32 %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovdqa64 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x6f,0x5c,0x82,0x40]       
vmovdqa64 4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovdqa64 -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x6f,0x5c,0x82,0xc0]       
vmovdqa64 -4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovdqa64 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x6f,0x5c,0x82,0x40]      
vmovdqa64 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovdqa64 -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x6f,0x5c,0x82,0xc0]      
vmovdqa64 -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovdqa64 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x6f,0x5c,0x82,0x40]     
vmovdqa64 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovdqa64 -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x6f,0x5c,0x82,0xc0]     
vmovdqa64 -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovdqa64 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x6f,0x5c,0x02,0x40]       
vmovdqa64 4096(%rdx,%rax), %zmm19 

// CHECK: vmovdqa64 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x6f,0x5c,0x02,0x40]      
vmovdqa64 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vmovdqa64 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x6f,0x5c,0x02,0x40]     
vmovdqa64 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vmovdqa64 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x6f,0x5a,0x40]       
vmovdqa64 4096(%rdx), %zmm19 

// CHECK: vmovdqa64 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x6f,0x5a,0x40]      
vmovdqa64 4096(%rdx), %zmm19 {%k2} 

// CHECK: vmovdqa64 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x6f,0x5a,0x40]     
vmovdqa64 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovdqa64 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x6f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovdqa64 485498096, %zmm19 

// CHECK: vmovdqa64 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x6f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovdqa64 485498096, %zmm19 {%k2} 

// CHECK: vmovdqa64 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x6f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmovdqa64 485498096, %zmm19 {%k2} {z} 

// CHECK: vmovdqa64 (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x6f,0x1a]       
vmovdqa64 (%rdx), %zmm19 

// CHECK: vmovdqa64 (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x6f,0x1a]      
vmovdqa64 (%rdx), %zmm19 {%k2} 

// CHECK: vmovdqa64 (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x6f,0x1a]     
vmovdqa64 (%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovdqa64 %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xfd,0x48,0x7f,0xdb]       
vmovdqa64.s %zmm19, %zmm19 

// CHECK: vmovdqa64 %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x4a,0x7f,0xdb]      
vmovdqa64.s %zmm19, %zmm19 {%k2} 

// CHECK: vmovdqa64 %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0xca,0x7f,0xdb]     
vmovdqa64.s %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovdqa64 %zmm19, 4096(%rdx) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x5a,0x40]       
vmovdqa64 %zmm19, 4096(%rdx) 

// CHECK: vmovdqa64 %zmm19, 4096(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x7f,0x5a,0x40]      
vmovdqa64 %zmm19, 4096(%rdx) {%k2} 

// CHECK: vmovdqa64 %zmm19, 4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x5c,0x82,0x40]       
vmovdqa64 %zmm19, 4096(%rdx,%rax,4) 

// CHECK: vmovdqa64 %zmm19, -4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x5c,0x82,0xc0]       
vmovdqa64 %zmm19, -4096(%rdx,%rax,4) 

// CHECK: vmovdqa64 %zmm19, 4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x7f,0x5c,0x82,0x40]      
vmovdqa64 %zmm19, 4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovdqa64 %zmm19, -4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x7f,0x5c,0x82,0xc0]      
vmovdqa64 %zmm19, -4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovdqa64 %zmm19, 4096(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x5c,0x02,0x40]       
vmovdqa64 %zmm19, 4096(%rdx,%rax) 

// CHECK: vmovdqa64 %zmm19, 4096(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x7f,0x5c,0x02,0x40]      
vmovdqa64 %zmm19, 4096(%rdx,%rax) {%k2} 

// CHECK: vmovdqa64 %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovdqa64 %zmm19, 485498096 

// CHECK: vmovdqa64 %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovdqa64 %zmm19, 485498096 {%k2} 

// CHECK: vmovdqa64 %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x1a]       
vmovdqa64 %zmm19, (%rdx) 

// CHECK: vmovdqa64 %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x7f,0x1a]      
vmovdqa64 %zmm19, (%rdx) {%k2} 

// CHECK: vmovdqa64 %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xfd,0x48,0x6f,0xdb]       
vmovdqa64 %zmm19, %zmm19 

// CHECK: vmovdqa64 %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x4a,0x6f,0xdb]      
vmovdqa64 %zmm19, %zmm19 {%k2} 

// CHECK: vmovdqa64 %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0xca,0x6f,0xdb]     
vmovdqa64 %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovdqu32 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x6f,0x5c,0x82,0x40]       
vmovdqu32 4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovdqu32 -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x6f,0x5c,0x82,0xc0]       
vmovdqu32 -4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovdqu32 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x6f,0x5c,0x82,0x40]      
vmovdqu32 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovdqu32 -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x6f,0x5c,0x82,0xc0]      
vmovdqu32 -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovdqu32 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x6f,0x5c,0x82,0x40]     
vmovdqu32 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovdqu32 -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x6f,0x5c,0x82,0xc0]     
vmovdqu32 -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovdqu32 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x6f,0x5c,0x02,0x40]       
vmovdqu32 4096(%rdx,%rax), %zmm19 

// CHECK: vmovdqu32 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x6f,0x5c,0x02,0x40]      
vmovdqu32 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vmovdqu32 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x6f,0x5c,0x02,0x40]     
vmovdqu32 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vmovdqu32 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x6f,0x5a,0x40]       
vmovdqu32 4096(%rdx), %zmm19 

// CHECK: vmovdqu32 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x6f,0x5a,0x40]      
vmovdqu32 4096(%rdx), %zmm19 {%k2} 

// CHECK: vmovdqu32 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x6f,0x5a,0x40]     
vmovdqu32 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovdqu32 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x6f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovdqu32 485498096, %zmm19 

// CHECK: vmovdqu32 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x6f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovdqu32 485498096, %zmm19 {%k2} 

// CHECK: vmovdqu32 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x6f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmovdqu32 485498096, %zmm19 {%k2} {z} 

// CHECK: vmovdqu32 (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x6f,0x1a]       
vmovdqu32 (%rdx), %zmm19 

// CHECK: vmovdqu32 (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x6f,0x1a]      
vmovdqu32 (%rdx), %zmm19 {%k2} 

// CHECK: vmovdqu32 (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x6f,0x1a]     
vmovdqu32 (%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovdqu32 %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7e,0x48,0x7f,0xdb]       
vmovdqu32.s %zmm19, %zmm19 

// CHECK: vmovdqu32 %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7e,0x4a,0x7f,0xdb]      
vmovdqu32.s %zmm19, %zmm19 {%k2} 

// CHECK: vmovdqu32 %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7e,0xca,0x7f,0xdb]     
vmovdqu32.s %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovdqu32 %zmm19, 4096(%rdx) 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x7f,0x5a,0x40]       
vmovdqu32 %zmm19, 4096(%rdx) 

// CHECK: vmovdqu32 %zmm19, 4096(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x7f,0x5a,0x40]      
vmovdqu32 %zmm19, 4096(%rdx) {%k2} 

// CHECK: vmovdqu32 %zmm19, 4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x7f,0x5c,0x82,0x40]       
vmovdqu32 %zmm19, 4096(%rdx,%rax,4) 

// CHECK: vmovdqu32 %zmm19, -4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x7f,0x5c,0x82,0xc0]       
vmovdqu32 %zmm19, -4096(%rdx,%rax,4) 

// CHECK: vmovdqu32 %zmm19, 4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x7f,0x5c,0x82,0x40]      
vmovdqu32 %zmm19, 4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovdqu32 %zmm19, -4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x7f,0x5c,0x82,0xc0]      
vmovdqu32 %zmm19, -4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovdqu32 %zmm19, 4096(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x7f,0x5c,0x02,0x40]       
vmovdqu32 %zmm19, 4096(%rdx,%rax) 

// CHECK: vmovdqu32 %zmm19, 4096(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x7f,0x5c,0x02,0x40]      
vmovdqu32 %zmm19, 4096(%rdx,%rax) {%k2} 

// CHECK: vmovdqu32 %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovdqu32 %zmm19, 485498096 

// CHECK: vmovdqu32 %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovdqu32 %zmm19, 485498096 {%k2} 

// CHECK: vmovdqu32 %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x7f,0x1a]       
vmovdqu32 %zmm19, (%rdx) 

// CHECK: vmovdqu32 %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x7f,0x1a]      
vmovdqu32 %zmm19, (%rdx) {%k2} 

// CHECK: vmovdqu32 %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7e,0x48,0x6f,0xdb]       
vmovdqu32 %zmm19, %zmm19 

// CHECK: vmovdqu32 %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7e,0x4a,0x6f,0xdb]      
vmovdqu32 %zmm19, %zmm19 {%k2} 

// CHECK: vmovdqu32 %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7e,0xca,0x6f,0xdb]     
vmovdqu32 %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovdqu64 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfe,0x48,0x6f,0x5c,0x82,0x40]       
vmovdqu64 4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovdqu64 -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfe,0x48,0x6f,0x5c,0x82,0xc0]       
vmovdqu64 -4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovdqu64 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfe,0x4a,0x6f,0x5c,0x82,0x40]      
vmovdqu64 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovdqu64 -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfe,0x4a,0x6f,0x5c,0x82,0xc0]      
vmovdqu64 -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovdqu64 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfe,0xca,0x6f,0x5c,0x82,0x40]     
vmovdqu64 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovdqu64 -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfe,0xca,0x6f,0x5c,0x82,0xc0]     
vmovdqu64 -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovdqu64 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfe,0x48,0x6f,0x5c,0x02,0x40]       
vmovdqu64 4096(%rdx,%rax), %zmm19 

// CHECK: vmovdqu64 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfe,0x4a,0x6f,0x5c,0x02,0x40]      
vmovdqu64 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vmovdqu64 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfe,0xca,0x6f,0x5c,0x02,0x40]     
vmovdqu64 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vmovdqu64 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfe,0x48,0x6f,0x5a,0x40]       
vmovdqu64 4096(%rdx), %zmm19 

// CHECK: vmovdqu64 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfe,0x4a,0x6f,0x5a,0x40]      
vmovdqu64 4096(%rdx), %zmm19 {%k2} 

// CHECK: vmovdqu64 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfe,0xca,0x6f,0x5a,0x40]     
vmovdqu64 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovdqu64 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfe,0x48,0x6f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovdqu64 485498096, %zmm19 

// CHECK: vmovdqu64 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfe,0x4a,0x6f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovdqu64 485498096, %zmm19 {%k2} 

// CHECK: vmovdqu64 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfe,0xca,0x6f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmovdqu64 485498096, %zmm19 {%k2} {z} 

// CHECK: vmovdqu64 (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfe,0x48,0x6f,0x1a]       
vmovdqu64 (%rdx), %zmm19 

// CHECK: vmovdqu64 (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfe,0x4a,0x6f,0x1a]      
vmovdqu64 (%rdx), %zmm19 {%k2} 

// CHECK: vmovdqu64 (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfe,0xca,0x6f,0x1a]     
vmovdqu64 (%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovdqu64 %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xfe,0x48,0x7f,0xdb]       
vmovdqu64.s %zmm19, %zmm19 

// CHECK: vmovdqu64 %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfe,0x4a,0x7f,0xdb]      
vmovdqu64.s %zmm19, %zmm19 {%k2} 

// CHECK: vmovdqu64 %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfe,0xca,0x7f,0xdb]     
vmovdqu64.s %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovdqu64 %zmm19, 4096(%rdx) 
// CHECK: encoding: [0x62,0xe1,0xfe,0x48,0x7f,0x5a,0x40]       
vmovdqu64 %zmm19, 4096(%rdx) 

// CHECK: vmovdqu64 %zmm19, 4096(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfe,0x4a,0x7f,0x5a,0x40]      
vmovdqu64 %zmm19, 4096(%rdx) {%k2} 

// CHECK: vmovdqu64 %zmm19, 4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0xfe,0x48,0x7f,0x5c,0x82,0x40]       
vmovdqu64 %zmm19, 4096(%rdx,%rax,4) 

// CHECK: vmovdqu64 %zmm19, -4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0xfe,0x48,0x7f,0x5c,0x82,0xc0]       
vmovdqu64 %zmm19, -4096(%rdx,%rax,4) 

// CHECK: vmovdqu64 %zmm19, 4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfe,0x4a,0x7f,0x5c,0x82,0x40]      
vmovdqu64 %zmm19, 4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovdqu64 %zmm19, -4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfe,0x4a,0x7f,0x5c,0x82,0xc0]      
vmovdqu64 %zmm19, -4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovdqu64 %zmm19, 4096(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe1,0xfe,0x48,0x7f,0x5c,0x02,0x40]       
vmovdqu64 %zmm19, 4096(%rdx,%rax) 

// CHECK: vmovdqu64 %zmm19, 4096(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfe,0x4a,0x7f,0x5c,0x02,0x40]      
vmovdqu64 %zmm19, 4096(%rdx,%rax) {%k2} 

// CHECK: vmovdqu64 %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe1,0xfe,0x48,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovdqu64 %zmm19, 485498096 

// CHECK: vmovdqu64 %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfe,0x4a,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovdqu64 %zmm19, 485498096 {%k2} 

// CHECK: vmovdqu64 %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe1,0xfe,0x48,0x7f,0x1a]       
vmovdqu64 %zmm19, (%rdx) 

// CHECK: vmovdqu64 %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfe,0x4a,0x7f,0x1a]      
vmovdqu64 %zmm19, (%rdx) {%k2} 

// CHECK: vmovdqu64 %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xfe,0x48,0x6f,0xdb]       
vmovdqu64 %zmm19, %zmm19 

// CHECK: vmovdqu64 %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfe,0x4a,0x6f,0xdb]      
vmovdqu64 %zmm19, %zmm19 {%k2} 

// CHECK: vmovdqu64 %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfe,0xca,0x6f,0xdb]     
vmovdqu64 %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovntdqa 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x5c,0x82,0x40]       
vmovntdqa 4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovntdqa -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x5c,0x82,0xc0]       
vmovntdqa -4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovntdqa 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x5c,0x02,0x40]       
vmovntdqa 4096(%rdx,%rax), %zmm19 

// CHECK: vmovntdqa 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x5a,0x40]       
vmovntdqa 4096(%rdx), %zmm19 

// CHECK: vmovntdqa 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovntdqa 485498096, %zmm19 

// CHECK: vmovntdqa (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x1a]       
vmovntdqa (%rdx), %zmm19 

// CHECK: vmovntdq %zmm19, 4096(%rdx) 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0xe7,0x5a,0x40]       
vmovntdq %zmm19, 4096(%rdx) 

// CHECK: vmovntdq %zmm19, 4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0xe7,0x5c,0x82,0x40]       
vmovntdq %zmm19, 4096(%rdx,%rax,4) 

// CHECK: vmovntdq %zmm19, -4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0xe7,0x5c,0x82,0xc0]       
vmovntdq %zmm19, -4096(%rdx,%rax,4) 

// CHECK: vmovntdq %zmm19, 4096(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0xe7,0x5c,0x02,0x40]       
vmovntdq %zmm19, 4096(%rdx,%rax) 

// CHECK: vmovntdq %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0xe7,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovntdq %zmm19, 485498096 

// CHECK: vmovntdq %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe1,0x7d,0x48,0xe7,0x1a]       
vmovntdq %zmm19, (%rdx) 

// CHECK: vmovntpd %zmm19, 4096(%rdx) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x5a,0x40]       
vmovntpd %zmm19, 4096(%rdx) 

// CHECK: vmovntpd %zmm19, 4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x5c,0x82,0x40]       
vmovntpd %zmm19, 4096(%rdx,%rax,4) 

// CHECK: vmovntpd %zmm19, -4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x5c,0x82,0xc0]       
vmovntpd %zmm19, -4096(%rdx,%rax,4) 

// CHECK: vmovntpd %zmm19, 4096(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x5c,0x02,0x40]       
vmovntpd %zmm19, 4096(%rdx,%rax) 

// CHECK: vmovntpd %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovntpd %zmm19, 485498096 

// CHECK: vmovntpd %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x1a]       
vmovntpd %zmm19, (%rdx) 

// CHECK: vmovntps %zmm19, 4096(%rdx) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x2b,0x5a,0x40]       
vmovntps %zmm19, 4096(%rdx) 

// CHECK: vmovntps %zmm19, 4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x2b,0x5c,0x82,0x40]       
vmovntps %zmm19, 4096(%rdx,%rax,4) 

// CHECK: vmovntps %zmm19, -4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x2b,0x5c,0x82,0xc0]       
vmovntps %zmm19, -4096(%rdx,%rax,4) 

// CHECK: vmovntps %zmm19, 4096(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x2b,0x5c,0x02,0x40]       
vmovntps %zmm19, 4096(%rdx,%rax) 

// CHECK: vmovntps %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x2b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovntps %zmm19, 485498096 

// CHECK: vmovntps %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x2b,0x1a]       
vmovntps %zmm19, (%rdx) 

// CHECK: vmovshdup 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x16,0x5c,0x82,0x40]       
vmovshdup 4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovshdup -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x16,0x5c,0x82,0xc0]       
vmovshdup -4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovshdup 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x16,0x5c,0x82,0x40]      
vmovshdup 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovshdup -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x16,0x5c,0x82,0xc0]      
vmovshdup -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovshdup 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x16,0x5c,0x82,0x40]     
vmovshdup 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovshdup -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x16,0x5c,0x82,0xc0]     
vmovshdup -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovshdup 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x16,0x5c,0x02,0x40]       
vmovshdup 4096(%rdx,%rax), %zmm19 

// CHECK: vmovshdup 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x16,0x5c,0x02,0x40]      
vmovshdup 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vmovshdup 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x16,0x5c,0x02,0x40]     
vmovshdup 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vmovshdup 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x16,0x5a,0x40]       
vmovshdup 4096(%rdx), %zmm19 

// CHECK: vmovshdup 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x16,0x5a,0x40]      
vmovshdup 4096(%rdx), %zmm19 {%k2} 

// CHECK: vmovshdup 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x16,0x5a,0x40]     
vmovshdup 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovshdup 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovshdup 485498096, %zmm19 

// CHECK: vmovshdup 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovshdup 485498096, %zmm19 {%k2} 

// CHECK: vmovshdup 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmovshdup 485498096, %zmm19 {%k2} {z} 

// CHECK: vmovshdup (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x16,0x1a]       
vmovshdup (%rdx), %zmm19 

// CHECK: vmovshdup (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x16,0x1a]      
vmovshdup (%rdx), %zmm19 {%k2} 

// CHECK: vmovshdup (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x16,0x1a]     
vmovshdup (%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovshdup %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7e,0x48,0x16,0xdb]       
vmovshdup %zmm19, %zmm19 

// CHECK: vmovshdup %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7e,0x4a,0x16,0xdb]      
vmovshdup %zmm19, %zmm19 {%k2} 

// CHECK: vmovshdup %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7e,0xca,0x16,0xdb]     
vmovshdup %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovsldup 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x12,0x5c,0x82,0x40]       
vmovsldup 4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovsldup -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x12,0x5c,0x82,0xc0]       
vmovsldup -4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovsldup 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x12,0x5c,0x82,0x40]      
vmovsldup 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovsldup -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x12,0x5c,0x82,0xc0]      
vmovsldup -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovsldup 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x12,0x5c,0x82,0x40]     
vmovsldup 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovsldup -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x12,0x5c,0x82,0xc0]     
vmovsldup -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovsldup 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x12,0x5c,0x02,0x40]       
vmovsldup 4096(%rdx,%rax), %zmm19 

// CHECK: vmovsldup 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x12,0x5c,0x02,0x40]      
vmovsldup 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vmovsldup 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x12,0x5c,0x02,0x40]     
vmovsldup 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vmovsldup 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x12,0x5a,0x40]       
vmovsldup 4096(%rdx), %zmm19 

// CHECK: vmovsldup 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x12,0x5a,0x40]      
vmovsldup 4096(%rdx), %zmm19 {%k2} 

// CHECK: vmovsldup 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x12,0x5a,0x40]     
vmovsldup 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovsldup 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x12,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovsldup 485498096, %zmm19 

// CHECK: vmovsldup 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x12,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovsldup 485498096, %zmm19 {%k2} 

// CHECK: vmovsldup 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x12,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmovsldup 485498096, %zmm19 {%k2} {z} 

// CHECK: vmovsldup (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7e,0x48,0x12,0x1a]       
vmovsldup (%rdx), %zmm19 

// CHECK: vmovsldup (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7e,0x4a,0x12,0x1a]      
vmovsldup (%rdx), %zmm19 {%k2} 

// CHECK: vmovsldup (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7e,0xca,0x12,0x1a]     
vmovsldup (%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovsldup %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7e,0x48,0x12,0xdb]       
vmovsldup %zmm19, %zmm19 

// CHECK: vmovsldup %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7e,0x4a,0x12,0xdb]      
vmovsldup %zmm19, %zmm19 {%k2} 

// CHECK: vmovsldup %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7e,0xca,0x12,0xdb]     
vmovsldup %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovupd 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x10,0x5c,0x82,0x40]       
vmovupd 4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovupd -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x10,0x5c,0x82,0xc0]       
vmovupd -4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovupd 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x10,0x5c,0x82,0x40]      
vmovupd 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovupd -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x10,0x5c,0x82,0xc0]      
vmovupd -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovupd 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x10,0x5c,0x82,0x40]     
vmovupd 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovupd -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x10,0x5c,0x82,0xc0]     
vmovupd -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovupd 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x10,0x5c,0x02,0x40]       
vmovupd 4096(%rdx,%rax), %zmm19 

// CHECK: vmovupd 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x10,0x5c,0x02,0x40]      
vmovupd 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vmovupd 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x10,0x5c,0x02,0x40]     
vmovupd 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vmovupd 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x10,0x5a,0x40]       
vmovupd 4096(%rdx), %zmm19 

// CHECK: vmovupd 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x10,0x5a,0x40]      
vmovupd 4096(%rdx), %zmm19 {%k2} 

// CHECK: vmovupd 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x10,0x5a,0x40]     
vmovupd 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovupd 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x10,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovupd 485498096, %zmm19 

// CHECK: vmovupd 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x10,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovupd 485498096, %zmm19 {%k2} 

// CHECK: vmovupd 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x10,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmovupd 485498096, %zmm19 {%k2} {z} 

// CHECK: vmovupd (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x10,0x1a]       
vmovupd (%rdx), %zmm19 

// CHECK: vmovupd (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x10,0x1a]      
vmovupd (%rdx), %zmm19 {%k2} 

// CHECK: vmovupd (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xfd,0xca,0x10,0x1a]     
vmovupd (%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovupd %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xfd,0x48,0x11,0xdb]       
vmovupd.s %zmm19, %zmm19 

// CHECK: vmovupd %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x4a,0x11,0xdb]      
vmovupd.s %zmm19, %zmm19 {%k2} 

// CHECK: vmovupd %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0xca,0x11,0xdb]     
vmovupd.s %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovupd %zmm19, 4096(%rdx) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x11,0x5a,0x40]       
vmovupd %zmm19, 4096(%rdx) 

// CHECK: vmovupd %zmm19, 4096(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x11,0x5a,0x40]      
vmovupd %zmm19, 4096(%rdx) {%k2} 

// CHECK: vmovupd %zmm19, 4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x11,0x5c,0x82,0x40]       
vmovupd %zmm19, 4096(%rdx,%rax,4) 

// CHECK: vmovupd %zmm19, -4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x11,0x5c,0x82,0xc0]       
vmovupd %zmm19, -4096(%rdx,%rax,4) 

// CHECK: vmovupd %zmm19, 4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x11,0x5c,0x82,0x40]      
vmovupd %zmm19, 4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovupd %zmm19, -4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x11,0x5c,0x82,0xc0]      
vmovupd %zmm19, -4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovupd %zmm19, 4096(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x11,0x5c,0x02,0x40]       
vmovupd %zmm19, 4096(%rdx,%rax) 

// CHECK: vmovupd %zmm19, 4096(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x11,0x5c,0x02,0x40]      
vmovupd %zmm19, 4096(%rdx,%rax) {%k2} 

// CHECK: vmovupd %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x11,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovupd %zmm19, 485498096 

// CHECK: vmovupd %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x11,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovupd %zmm19, 485498096 {%k2} 

// CHECK: vmovupd %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe1,0xfd,0x48,0x11,0x1a]       
vmovupd %zmm19, (%rdx) 

// CHECK: vmovupd %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0xfd,0x4a,0x11,0x1a]      
vmovupd %zmm19, (%rdx) {%k2} 

// CHECK: vmovupd %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xfd,0x48,0x10,0xdb]       
vmovupd %zmm19, %zmm19 

// CHECK: vmovupd %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xfd,0x4a,0x10,0xdb]      
vmovupd %zmm19, %zmm19 {%k2} 

// CHECK: vmovupd %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xfd,0xca,0x10,0xdb]     
vmovupd %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovups 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x10,0x5c,0x82,0x40]       
vmovups 4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovups -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x10,0x5c,0x82,0xc0]       
vmovups -4096(%rdx,%rax,4), %zmm19 

// CHECK: vmovups 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x10,0x5c,0x82,0x40]      
vmovups 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovups -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x10,0x5c,0x82,0xc0]      
vmovups -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vmovups 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x10,0x5c,0x82,0x40]     
vmovups 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovups -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x10,0x5c,0x82,0xc0]     
vmovups -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vmovups 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x10,0x5c,0x02,0x40]       
vmovups 4096(%rdx,%rax), %zmm19 

// CHECK: vmovups 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x10,0x5c,0x02,0x40]      
vmovups 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vmovups 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x10,0x5c,0x02,0x40]     
vmovups 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vmovups 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x10,0x5a,0x40]       
vmovups 4096(%rdx), %zmm19 

// CHECK: vmovups 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x10,0x5a,0x40]      
vmovups 4096(%rdx), %zmm19 {%k2} 

// CHECK: vmovups 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x10,0x5a,0x40]     
vmovups 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovups 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x10,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovups 485498096, %zmm19 

// CHECK: vmovups 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x10,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovups 485498096, %zmm19 {%k2} 

// CHECK: vmovups 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x10,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmovups 485498096, %zmm19 {%k2} {z} 

// CHECK: vmovups (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x10,0x1a]       
vmovups (%rdx), %zmm19 

// CHECK: vmovups (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x10,0x1a]      
vmovups (%rdx), %zmm19 {%k2} 

// CHECK: vmovups (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x7c,0xca,0x10,0x1a]     
vmovups (%rdx), %zmm19 {%k2} {z} 

// CHECK: vmovups %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x48,0x11,0xdb]       
vmovups.s %zmm19, %zmm19 

// CHECK: vmovups %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x4a,0x11,0xdb]      
vmovups.s %zmm19, %zmm19 {%k2} 

// CHECK: vmovups %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xca,0x11,0xdb]     
vmovups.s %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmovups %zmm19, 4096(%rdx) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x11,0x5a,0x40]       
vmovups %zmm19, 4096(%rdx) 

// CHECK: vmovups %zmm19, 4096(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x11,0x5a,0x40]      
vmovups %zmm19, 4096(%rdx) {%k2} 

// CHECK: vmovups %zmm19, 4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x11,0x5c,0x82,0x40]       
vmovups %zmm19, 4096(%rdx,%rax,4) 

// CHECK: vmovups %zmm19, -4096(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x11,0x5c,0x82,0xc0]       
vmovups %zmm19, -4096(%rdx,%rax,4) 

// CHECK: vmovups %zmm19, 4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x11,0x5c,0x82,0x40]      
vmovups %zmm19, 4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovups %zmm19, -4096(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x11,0x5c,0x82,0xc0]      
vmovups %zmm19, -4096(%rdx,%rax,4) {%k2} 

// CHECK: vmovups %zmm19, 4096(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x11,0x5c,0x02,0x40]       
vmovups %zmm19, 4096(%rdx,%rax) 

// CHECK: vmovups %zmm19, 4096(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x11,0x5c,0x02,0x40]      
vmovups %zmm19, 4096(%rdx,%rax) {%k2} 

// CHECK: vmovups %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x11,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vmovups %zmm19, 485498096 

// CHECK: vmovups %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x11,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmovups %zmm19, 485498096 {%k2} 

// CHECK: vmovups %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe1,0x7c,0x48,0x11,0x1a]       
vmovups %zmm19, (%rdx) 

// CHECK: vmovups %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe1,0x7c,0x4a,0x11,0x1a]      
vmovups %zmm19, (%rdx) {%k2} 

// CHECK: vmovups %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x7c,0x48,0x10,0xdb]       
vmovups %zmm19, %zmm19 

// CHECK: vmovups %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x7c,0x4a,0x10,0xdb]      
vmovups %zmm19, %zmm19 {%k2} 

// CHECK: vmovups %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x7c,0xca,0x10,0xdb]     
vmovups %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x59,0x5c,0x82,0x40]      
vmulpd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vmulpd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x59,0x5c,0x82,0xc0]      
vmulpd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vmulpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x59,0x5c,0x82,0x40]     
vmulpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x59,0x5c,0x82,0xc0]     
vmulpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x59,0x5c,0x82,0x40]    
vmulpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x59,0x5c,0x82,0xc0]    
vmulpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x59,0x5c,0x02,0x40]      
vmulpd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vmulpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x59,0x5c,0x02,0x40]     
vmulpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x59,0x5c,0x02,0x40]    
vmulpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x59,0x5a,0x40]      
vmulpd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vmulpd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x59,0x5a,0x40]     
vmulpd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x59,0x5a,0x40]    
vmulpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmulpd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vmulpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmulpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vmulpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmulpd 485498096, %zmm19, %zmm19 

// CHECK: vmulpd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmulpd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vmulpd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x59,0x5a,0x40]      
vmulpd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vmulpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x59,0x5a,0x40]     
vmulpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x59,0x5a,0x40]    
vmulpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x59,0x5c,0x02,0x40]      
vmulpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vmulpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x59,0x5c,0x02,0x40]     
vmulpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x59,0x5c,0x02,0x40]    
vmulpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x59,0x5c,0x82,0x40]      
vmulpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vmulpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x59,0x5c,0x82,0xc0]      
vmulpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vmulpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x59,0x5c,0x82,0x40]     
vmulpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x59,0x5c,0x82,0xc0]     
vmulpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x59,0x5c,0x82,0x40]    
vmulpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x59,0x5c,0x82,0xc0]    
vmulpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x30,0x59,0xdb]     
vmulpd {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vmulpd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x32,0x59,0xdb]    
vmulpd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xb2,0x59,0xdb]   
vmulpd {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0x59,0x1a]      
vmulpd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vmulpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0x59,0x1a]     
vmulpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0x59,0x1a]    
vmulpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0x59,0x1a]      
vmulpd (%rdx), %zmm19, %zmm19 

// CHECK: vmulpd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0x59,0x1a]     
vmulpd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0x59,0x1a]    
vmulpd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x10,0x59,0xdb]     
vmulpd {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vmulpd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x12,0x59,0xdb]    
vmulpd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x92,0x59,0xdb]   
vmulpd {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x50,0x59,0xdb]     
vmulpd {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vmulpd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x52,0x59,0xdb]    
vmulpd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xd2,0x59,0xdb]   
vmulpd {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x70,0x59,0xdb]     
vmulpd {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vmulpd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x72,0x59,0xdb]    
vmulpd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xf2,0x59,0xdb]   
vmulpd {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulpd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x40,0x59,0xdb]      
vmulpd %zmm19, %zmm19, %zmm19 

// CHECK: vmulpd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x42,0x59,0xdb]     
vmulpd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmulpd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xc2,0x59,0xdb]    
vmulpd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x59,0x5a,0x40]      
vmulps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vmulps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x59,0x5a,0x40]     
vmulps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vmulps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x59,0x5a,0x40]    
vmulps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x59,0x5c,0x02,0x40]      
vmulps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vmulps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x59,0x5c,0x02,0x40]     
vmulps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vmulps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x59,0x5c,0x02,0x40]    
vmulps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x59,0x5c,0x82,0x40]      
vmulps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vmulps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x59,0x5c,0x82,0xc0]      
vmulps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vmulps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x59,0x5c,0x82,0x40]     
vmulps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vmulps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x59,0x5c,0x82,0xc0]     
vmulps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vmulps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x59,0x5c,0x82,0x40]    
vmulps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x59,0x5c,0x82,0xc0]    
vmulps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x59,0x5c,0x82,0x40]      
vmulps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vmulps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x59,0x5c,0x82,0xc0]      
vmulps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vmulps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x59,0x5c,0x82,0x40]     
vmulps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vmulps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x59,0x5c,0x82,0xc0]     
vmulps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vmulps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x59,0x5c,0x82,0x40]    
vmulps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x59,0x5c,0x82,0xc0]    
vmulps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x59,0x5c,0x02,0x40]      
vmulps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vmulps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x59,0x5c,0x02,0x40]     
vmulps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vmulps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x59,0x5c,0x02,0x40]    
vmulps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x59,0x5a,0x40]      
vmulps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vmulps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x59,0x5a,0x40]     
vmulps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vmulps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x59,0x5a,0x40]    
vmulps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmulps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vmulps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmulps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vmulps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vmulps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vmulps 485498096, %zmm19, %zmm19 

// CHECK: vmulps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vmulps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vmulps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vmulps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps {rd-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x30,0x59,0xdb]     
vmulps {rd-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vmulps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x32,0x59,0xdb]    
vmulps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmulps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xb2,0x59,0xdb]   
vmulps {rd-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x50,0x59,0x1a]      
vmulps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vmulps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x52,0x59,0x1a]     
vmulps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vmulps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xd2,0x59,0x1a]    
vmulps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x64,0x40,0x59,0x1a]      
vmulps (%rdx), %zmm19, %zmm19 

// CHECK: vmulps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x64,0x42,0x59,0x1a]     
vmulps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vmulps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x64,0xc2,0x59,0x1a]    
vmulps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps {rn-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x10,0x59,0xdb]     
vmulps {rn-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vmulps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x12,0x59,0xdb]    
vmulps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmulps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0x92,0x59,0xdb]   
vmulps {rn-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps {ru-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x50,0x59,0xdb]     
vmulps {ru-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vmulps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x52,0x59,0xdb]    
vmulps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmulps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xd2,0x59,0xdb]   
vmulps {ru-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps {rz-sae}, %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x70,0x59,0xdb]     
vmulps {rz-sae}, %zmm19, %zmm19, %zmm19 

// CHECK: vmulps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x72,0x59,0xdb]    
vmulps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmulps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xf2,0x59,0xdb]   
vmulps {rz-sae}, %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vmulps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x64,0x40,0x59,0xdb]      
vmulps %zmm19, %zmm19, %zmm19 

// CHECK: vmulps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x64,0x42,0x59,0xdb]     
vmulps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vmulps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x64,0xc2,0x59,0xdb]    
vmulps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpabsd 256(%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x58,0x1e,0x5a,0x40]       
vpabsd 256(%rdx){1to16}, %zmm19 

// CHECK: vpabsd 256(%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x5a,0x1e,0x5a,0x40]      
vpabsd 256(%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vpabsd 256(%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xda,0x1e,0x5a,0x40]     
vpabsd 256(%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vpabsd 256(%rdx,%rax){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x58,0x1e,0x5c,0x02,0x40]       
vpabsd 256(%rdx,%rax){1to16}, %zmm19 

// CHECK: vpabsd 256(%rdx,%rax){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x5a,0x1e,0x5c,0x02,0x40]      
vpabsd 256(%rdx,%rax){1to16}, %zmm19 {%k2} 

// CHECK: vpabsd 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xda,0x1e,0x5c,0x02,0x40]     
vpabsd 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 

// CHECK: vpabsd 256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x58,0x1e,0x5c,0x82,0x40]       
vpabsd 256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vpabsd -256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x58,0x1e,0x5c,0x82,0xc0]       
vpabsd -256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vpabsd 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x5a,0x1e,0x5c,0x82,0x40]      
vpabsd 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vpabsd -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x5a,0x1e,0x5c,0x82,0xc0]      
vpabsd -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vpabsd 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xda,0x1e,0x5c,0x82,0x40]     
vpabsd 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vpabsd -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xda,0x1e,0x5c,0x82,0xc0]     
vpabsd -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vpabsd 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x1e,0x5c,0x82,0x40]       
vpabsd 4096(%rdx,%rax,4), %zmm19 

// CHECK: vpabsd -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x1e,0x5c,0x82,0xc0]       
vpabsd -4096(%rdx,%rax,4), %zmm19 

// CHECK: vpabsd 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x1e,0x5c,0x82,0x40]      
vpabsd 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpabsd -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x1e,0x5c,0x82,0xc0]      
vpabsd -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpabsd 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x1e,0x5c,0x82,0x40]     
vpabsd 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpabsd -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x1e,0x5c,0x82,0xc0]     
vpabsd -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpabsd 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x1e,0x5c,0x02,0x40]       
vpabsd 4096(%rdx,%rax), %zmm19 

// CHECK: vpabsd 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x1e,0x5c,0x02,0x40]      
vpabsd 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vpabsd 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x1e,0x5c,0x02,0x40]     
vpabsd 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vpabsd 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x1e,0x5a,0x40]       
vpabsd 4096(%rdx), %zmm19 

// CHECK: vpabsd 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x1e,0x5a,0x40]      
vpabsd 4096(%rdx), %zmm19 {%k2} 

// CHECK: vpabsd 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x1e,0x5a,0x40]     
vpabsd 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vpabsd 485498096{1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x58,0x1e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpabsd 485498096{1to16}, %zmm19 

// CHECK: vpabsd 485498096{1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x5a,0x1e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpabsd 485498096{1to16}, %zmm19 {%k2} 

// CHECK: vpabsd 485498096{1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xda,0x1e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpabsd 485498096{1to16}, %zmm19 {%k2} {z} 

// CHECK: vpabsd 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x1e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpabsd 485498096, %zmm19 

// CHECK: vpabsd 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x1e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpabsd 485498096, %zmm19 {%k2} 

// CHECK: vpabsd 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x1e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpabsd 485498096, %zmm19 {%k2} {z} 

// CHECK: vpabsd (%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x58,0x1e,0x1a]       
vpabsd (%rdx){1to16}, %zmm19 

// CHECK: vpabsd (%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x5a,0x1e,0x1a]      
vpabsd (%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vpabsd (%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xda,0x1e,0x1a]     
vpabsd (%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vpabsd (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x1e,0x1a]       
vpabsd (%rdx), %zmm19 

// CHECK: vpabsd (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x1e,0x1a]      
vpabsd (%rdx), %zmm19 {%k2} 

// CHECK: vpabsd (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x1e,0x1a]     
vpabsd (%rdx), %zmm19 {%k2} {z} 

// CHECK: vpabsd %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x7d,0x48,0x1e,0xdb]       
vpabsd %zmm19, %zmm19 

// CHECK: vpabsd %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x1e,0xdb]      
vpabsd %zmm19, %zmm19 {%k2} 

// CHECK: vpabsd %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x7d,0xca,0x1e,0xdb]     
vpabsd %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpabsq 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x1f,0x5c,0x82,0x40]       
vpabsq 4096(%rdx,%rax,4), %zmm19 

// CHECK: vpabsq -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x1f,0x5c,0x82,0xc0]       
vpabsq -4096(%rdx,%rax,4), %zmm19 

// CHECK: vpabsq 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x1f,0x5c,0x82,0x40]      
vpabsq 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpabsq -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x1f,0x5c,0x82,0xc0]      
vpabsq -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpabsq 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x1f,0x5c,0x82,0x40]     
vpabsq 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpabsq -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x1f,0x5c,0x82,0xc0]     
vpabsq -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpabsq 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x1f,0x5c,0x02,0x40]       
vpabsq 4096(%rdx,%rax), %zmm19 

// CHECK: vpabsq 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x1f,0x5c,0x02,0x40]      
vpabsq 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vpabsq 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x1f,0x5c,0x02,0x40]     
vpabsq 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vpabsq 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x1f,0x5a,0x40]       
vpabsq 4096(%rdx), %zmm19 

// CHECK: vpabsq 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x1f,0x5a,0x40]      
vpabsq 4096(%rdx), %zmm19 {%k2} 

// CHECK: vpabsq 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x1f,0x5a,0x40]     
vpabsq 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vpabsq 485498096{1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x58,0x1f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpabsq 485498096{1to8}, %zmm19 

// CHECK: vpabsq 485498096{1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x5a,0x1f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpabsq 485498096{1to8}, %zmm19 {%k2} 

// CHECK: vpabsq 485498096{1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xda,0x1f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpabsq 485498096{1to8}, %zmm19 {%k2} {z} 

// CHECK: vpabsq 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x1f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpabsq 485498096, %zmm19 

// CHECK: vpabsq 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x1f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpabsq 485498096, %zmm19 {%k2} 

// CHECK: vpabsq 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x1f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpabsq 485498096, %zmm19 {%k2} {z} 

// CHECK: vpabsq 512(%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x58,0x1f,0x5a,0x40]       
vpabsq 512(%rdx){1to8}, %zmm19 

// CHECK: vpabsq 512(%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x5a,0x1f,0x5a,0x40]      
vpabsq 512(%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vpabsq 512(%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xda,0x1f,0x5a,0x40]     
vpabsq 512(%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpabsq 512(%rdx,%rax){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x58,0x1f,0x5c,0x02,0x40]       
vpabsq 512(%rdx,%rax){1to8}, %zmm19 

// CHECK: vpabsq 512(%rdx,%rax){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x5a,0x1f,0x5c,0x02,0x40]      
vpabsq 512(%rdx,%rax){1to8}, %zmm19 {%k2} 

// CHECK: vpabsq 512(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xda,0x1f,0x5c,0x02,0x40]     
vpabsq 512(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpabsq 512(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x58,0x1f,0x5c,0x82,0x40]       
vpabsq 512(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vpabsq -512(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x58,0x1f,0x5c,0x82,0xc0]       
vpabsq -512(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vpabsq 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x5a,0x1f,0x5c,0x82,0x40]      
vpabsq 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vpabsq -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x5a,0x1f,0x5c,0x82,0xc0]      
vpabsq -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vpabsq 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xda,0x1f,0x5c,0x82,0x40]     
vpabsq 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpabsq -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xda,0x1f,0x5c,0x82,0xc0]     
vpabsq -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpabsq (%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x58,0x1f,0x1a]       
vpabsq (%rdx){1to8}, %zmm19 

// CHECK: vpabsq (%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x5a,0x1f,0x1a]      
vpabsq (%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vpabsq (%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xda,0x1f,0x1a]     
vpabsq (%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpabsq (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x1f,0x1a]       
vpabsq (%rdx), %zmm19 

// CHECK: vpabsq (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x1f,0x1a]      
vpabsq (%rdx), %zmm19 {%k2} 

// CHECK: vpabsq (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x1f,0x1a]     
vpabsq (%rdx), %zmm19 {%k2} {z} 

// CHECK: vpabsq %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xfd,0x48,0x1f,0xdb]       
vpabsq %zmm19, %zmm19 

// CHECK: vpabsq %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x1f,0xdb]      
vpabsq %zmm19, %zmm19 {%k2} 

// CHECK: vpabsq %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xfd,0xca,0x1f,0xdb]     
vpabsq %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xfe,0x5a,0x40]      
vpaddd 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpaddd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xfe,0x5a,0x40]     
vpaddd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xfe,0x5a,0x40]    
vpaddd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xfe,0x5c,0x02,0x40]      
vpaddd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpaddd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xfe,0x5c,0x02,0x40]     
vpaddd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xfe,0x5c,0x02,0x40]    
vpaddd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xfe,0x5c,0x82,0x40]      
vpaddd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpaddd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xfe,0x5c,0x82,0xc0]      
vpaddd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpaddd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xfe,0x5c,0x82,0x40]     
vpaddd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xfe,0x5c,0x82,0xc0]     
vpaddd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xfe,0x5c,0x82,0x40]    
vpaddd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xfe,0x5c,0x82,0xc0]    
vpaddd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xfe,0x5c,0x82,0x40]      
vpaddd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpaddd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xfe,0x5c,0x82,0xc0]      
vpaddd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpaddd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xfe,0x5c,0x82,0x40]     
vpaddd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xfe,0x5c,0x82,0xc0]     
vpaddd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xfe,0x5c,0x82,0x40]    
vpaddd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xfe,0x5c,0x82,0xc0]    
vpaddd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xfe,0x5c,0x02,0x40]      
vpaddd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpaddd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xfe,0x5c,0x02,0x40]     
vpaddd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xfe,0x5c,0x02,0x40]    
vpaddd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xfe,0x5a,0x40]      
vpaddd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpaddd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xfe,0x5a,0x40]     
vpaddd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xfe,0x5a,0x40]    
vpaddd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xfe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpaddd 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpaddd 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xfe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpaddd 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xfe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpaddd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xfe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpaddd 485498096, %zmm19, %zmm19 

// CHECK: vpaddd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xfe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpaddd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xfe,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpaddd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xfe,0x1a]      
vpaddd (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpaddd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xfe,0x1a]     
vpaddd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xfe,0x1a]    
vpaddd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xfe,0x1a]      
vpaddd (%rdx), %zmm19, %zmm19 

// CHECK: vpaddd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xfe,0x1a]     
vpaddd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xfe,0x1a]    
vpaddd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x65,0x40,0xfe,0xdb]      
vpaddd %zmm19, %zmm19, %zmm19 

// CHECK: vpaddd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x65,0x42,0xfe,0xdb]     
vpaddd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x65,0xc2,0xfe,0xdb]    
vpaddd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xd4,0x5c,0x82,0x40]      
vpaddq 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpaddq -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xd4,0x5c,0x82,0xc0]      
vpaddq -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpaddq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xd4,0x5c,0x82,0x40]     
vpaddq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xd4,0x5c,0x82,0xc0]     
vpaddq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xd4,0x5c,0x82,0x40]    
vpaddq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xd4,0x5c,0x82,0xc0]    
vpaddq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xd4,0x5c,0x02,0x40]      
vpaddq 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpaddq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xd4,0x5c,0x02,0x40]     
vpaddq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xd4,0x5c,0x02,0x40]    
vpaddq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xd4,0x5a,0x40]      
vpaddq 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpaddq 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xd4,0x5a,0x40]     
vpaddq 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xd4,0x5a,0x40]    
vpaddq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xd4,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpaddq 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpaddq 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xd4,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpaddq 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xd4,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpaddq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xd4,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpaddq 485498096, %zmm19, %zmm19 

// CHECK: vpaddq 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xd4,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpaddq 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xd4,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpaddq 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xd4,0x5a,0x40]      
vpaddq 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpaddq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xd4,0x5a,0x40]     
vpaddq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xd4,0x5a,0x40]    
vpaddq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xd4,0x5c,0x02,0x40]      
vpaddq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpaddq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xd4,0x5c,0x02,0x40]     
vpaddq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xd4,0x5c,0x02,0x40]    
vpaddq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xd4,0x5c,0x82,0x40]      
vpaddq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpaddq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xd4,0x5c,0x82,0xc0]      
vpaddq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpaddq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xd4,0x5c,0x82,0x40]     
vpaddq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xd4,0x5c,0x82,0xc0]     
vpaddq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xd4,0x5c,0x82,0x40]    
vpaddq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xd4,0x5c,0x82,0xc0]    
vpaddq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xd4,0x1a]      
vpaddq (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpaddq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xd4,0x1a]     
vpaddq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xd4,0x1a]    
vpaddq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xd4,0x1a]      
vpaddq (%rdx), %zmm19, %zmm19 

// CHECK: vpaddq (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xd4,0x1a]     
vpaddq (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xd4,0x1a]    
vpaddq (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpaddq %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x40,0xd4,0xdb]      
vpaddq %zmm19, %zmm19, %zmm19 

// CHECK: vpaddq %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x42,0xd4,0xdb]     
vpaddq %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpaddq %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xc2,0xd4,0xdb]    
vpaddq %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xdb,0x5a,0x40]      
vpandd 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpandd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xdb,0x5a,0x40]     
vpandd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xdb,0x5a,0x40]    
vpandd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xdb,0x5c,0x02,0x40]      
vpandd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpandd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xdb,0x5c,0x02,0x40]     
vpandd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xdb,0x5c,0x02,0x40]    
vpandd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xdb,0x5c,0x82,0x40]      
vpandd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpandd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xdb,0x5c,0x82,0xc0]      
vpandd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpandd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xdb,0x5c,0x82,0x40]     
vpandd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xdb,0x5c,0x82,0xc0]     
vpandd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xdb,0x5c,0x82,0x40]    
vpandd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xdb,0x5c,0x82,0xc0]    
vpandd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xdb,0x5c,0x82,0x40]      
vpandd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpandd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xdb,0x5c,0x82,0xc0]      
vpandd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpandd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xdb,0x5c,0x82,0x40]     
vpandd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpandd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xdb,0x5c,0x82,0xc0]     
vpandd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpandd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xdb,0x5c,0x82,0x40]    
vpandd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xdb,0x5c,0x82,0xc0]    
vpandd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xdb,0x5c,0x02,0x40]      
vpandd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpandd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xdb,0x5c,0x02,0x40]     
vpandd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpandd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xdb,0x5c,0x02,0x40]    
vpandd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xdb,0x5a,0x40]      
vpandd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpandd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xdb,0x5a,0x40]     
vpandd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpandd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xdb,0x5a,0x40]    
vpandd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xdb,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpandd 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpandd 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xdb,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpandd 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xdb,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpandd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xdb,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpandd 485498096, %zmm19, %zmm19 

// CHECK: vpandd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xdb,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpandd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpandd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xdb,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpandd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xdb,0x1a]      
vpandd (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpandd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xdb,0x1a]     
vpandd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xdb,0x1a]    
vpandd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xdb,0x1a]      
vpandd (%rdx), %zmm19, %zmm19 

// CHECK: vpandd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xdb,0x1a]     
vpandd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpandd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xdb,0x1a]    
vpandd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x65,0x40,0xdb,0xdb]      
vpandd %zmm19, %zmm19, %zmm19 

// CHECK: vpandd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x65,0x42,0xdb,0xdb]     
vpandd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpandd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x65,0xc2,0xdb,0xdb]    
vpandd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xdf,0x5a,0x40]      
vpandnd 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpandnd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xdf,0x5a,0x40]     
vpandnd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xdf,0x5a,0x40]    
vpandnd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xdf,0x5c,0x02,0x40]      
vpandnd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpandnd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xdf,0x5c,0x02,0x40]     
vpandnd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xdf,0x5c,0x02,0x40]    
vpandnd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xdf,0x5c,0x82,0x40]      
vpandnd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpandnd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xdf,0x5c,0x82,0xc0]      
vpandnd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpandnd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xdf,0x5c,0x82,0x40]     
vpandnd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xdf,0x5c,0x82,0xc0]     
vpandnd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xdf,0x5c,0x82,0x40]    
vpandnd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xdf,0x5c,0x82,0xc0]    
vpandnd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xdf,0x5c,0x82,0x40]      
vpandnd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpandnd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xdf,0x5c,0x82,0xc0]      
vpandnd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpandnd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xdf,0x5c,0x82,0x40]     
vpandnd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xdf,0x5c,0x82,0xc0]     
vpandnd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xdf,0x5c,0x82,0x40]    
vpandnd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xdf,0x5c,0x82,0xc0]    
vpandnd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xdf,0x5c,0x02,0x40]      
vpandnd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpandnd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xdf,0x5c,0x02,0x40]     
vpandnd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xdf,0x5c,0x02,0x40]    
vpandnd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xdf,0x5a,0x40]      
vpandnd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpandnd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xdf,0x5a,0x40]     
vpandnd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xdf,0x5a,0x40]    
vpandnd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xdf,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpandnd 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpandnd 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xdf,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpandnd 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xdf,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpandnd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xdf,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpandnd 485498096, %zmm19, %zmm19 

// CHECK: vpandnd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xdf,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpandnd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xdf,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpandnd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x50,0xdf,0x1a]      
vpandnd (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpandnd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x52,0xdf,0x1a]     
vpandnd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xd2,0xdf,0x1a]    
vpandnd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0x65,0x40,0xdf,0x1a]      
vpandnd (%rdx), %zmm19, %zmm19 

// CHECK: vpandnd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0x65,0x42,0xdf,0x1a]     
vpandnd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0x65,0xc2,0xdf,0x1a]    
vpandnd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0x65,0x40,0xdf,0xdb]      
vpandnd %zmm19, %zmm19, %zmm19 

// CHECK: vpandnd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0x65,0x42,0xdf,0xdb]     
vpandnd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0x65,0xc2,0xdf,0xdb]    
vpandnd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xdf,0x5c,0x82,0x40]      
vpandnq 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpandnq -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xdf,0x5c,0x82,0xc0]      
vpandnq -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpandnq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xdf,0x5c,0x82,0x40]     
vpandnq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xdf,0x5c,0x82,0xc0]     
vpandnq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xdf,0x5c,0x82,0x40]    
vpandnq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xdf,0x5c,0x82,0xc0]    
vpandnq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xdf,0x5c,0x02,0x40]      
vpandnq 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpandnq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xdf,0x5c,0x02,0x40]     
vpandnq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xdf,0x5c,0x02,0x40]    
vpandnq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xdf,0x5a,0x40]      
vpandnq 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpandnq 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xdf,0x5a,0x40]     
vpandnq 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xdf,0x5a,0x40]    
vpandnq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xdf,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpandnq 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpandnq 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xdf,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpandnq 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xdf,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpandnq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xdf,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpandnq 485498096, %zmm19, %zmm19 

// CHECK: vpandnq 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xdf,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpandnq 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xdf,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpandnq 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xdf,0x5a,0x40]      
vpandnq 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpandnq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xdf,0x5a,0x40]     
vpandnq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xdf,0x5a,0x40]    
vpandnq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xdf,0x5c,0x02,0x40]      
vpandnq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpandnq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xdf,0x5c,0x02,0x40]     
vpandnq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xdf,0x5c,0x02,0x40]    
vpandnq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xdf,0x5c,0x82,0x40]      
vpandnq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpandnq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xdf,0x5c,0x82,0xc0]      
vpandnq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpandnq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xdf,0x5c,0x82,0x40]     
vpandnq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xdf,0x5c,0x82,0xc0]     
vpandnq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xdf,0x5c,0x82,0x40]    
vpandnq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xdf,0x5c,0x82,0xc0]    
vpandnq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xdf,0x1a]      
vpandnq (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpandnq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xdf,0x1a]     
vpandnq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xdf,0x1a]    
vpandnq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xdf,0x1a]      
vpandnq (%rdx), %zmm19, %zmm19 

// CHECK: vpandnq (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xdf,0x1a]     
vpandnq (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xdf,0x1a]    
vpandnq (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandnq %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x40,0xdf,0xdb]      
vpandnq %zmm19, %zmm19, %zmm19 

// CHECK: vpandnq %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x42,0xdf,0xdb]     
vpandnq %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpandnq %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xc2,0xdf,0xdb]    
vpandnq %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xdb,0x5c,0x82,0x40]      
vpandq 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpandq -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xdb,0x5c,0x82,0xc0]      
vpandq -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpandq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xdb,0x5c,0x82,0x40]     
vpandq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpandq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xdb,0x5c,0x82,0xc0]     
vpandq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpandq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xdb,0x5c,0x82,0x40]    
vpandq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xdb,0x5c,0x82,0xc0]    
vpandq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xdb,0x5c,0x02,0x40]      
vpandq 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpandq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xdb,0x5c,0x02,0x40]     
vpandq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpandq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xdb,0x5c,0x02,0x40]    
vpandq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xdb,0x5a,0x40]      
vpandq 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpandq 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xdb,0x5a,0x40]     
vpandq 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpandq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xdb,0x5a,0x40]    
vpandq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xdb,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpandq 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpandq 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xdb,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpandq 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xdb,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpandq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xdb,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpandq 485498096, %zmm19, %zmm19 

// CHECK: vpandq 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xdb,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpandq 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpandq 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xdb,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpandq 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xdb,0x5a,0x40]      
vpandq 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpandq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xdb,0x5a,0x40]     
vpandq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xdb,0x5a,0x40]    
vpandq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xdb,0x5c,0x02,0x40]      
vpandq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpandq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xdb,0x5c,0x02,0x40]     
vpandq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xdb,0x5c,0x02,0x40]    
vpandq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xdb,0x5c,0x82,0x40]      
vpandq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpandq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xdb,0x5c,0x82,0xc0]      
vpandq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpandq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xdb,0x5c,0x82,0x40]     
vpandq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xdb,0x5c,0x82,0xc0]     
vpandq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xdb,0x5c,0x82,0x40]    
vpandq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xdb,0x5c,0x82,0xc0]    
vpandq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x50,0xdb,0x1a]      
vpandq (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpandq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x52,0xdb,0x1a]     
vpandq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpandq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xd2,0xdb,0x1a]    
vpandq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe1,0xe5,0x40,0xdb,0x1a]      
vpandq (%rdx), %zmm19, %zmm19 

// CHECK: vpandq (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe1,0xe5,0x42,0xdb,0x1a]     
vpandq (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpandq (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe1,0xe5,0xc2,0xdb,0x1a]    
vpandq (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpandq %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa1,0xe5,0x40,0xdb,0xdb]      
vpandq %zmm19, %zmm19, %zmm19 

// CHECK: vpandq %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa1,0xe5,0x42,0xdb,0xdb]     
vpandq %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpandq %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa1,0xe5,0xc2,0xdb,0xdb]    
vpandq %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmd 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x64,0x5a,0x40]      
vpblendmd 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpblendmd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x64,0x5a,0x40]     
vpblendmd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x64,0x5a,0x40]     
vpblendmd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vpblendmd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x64,0x5c,0x02,0x40]      
vpblendmd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpblendmd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x64,0x5c,0x02,0x40]     
vpblendmd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x64,0x5c,0x02,0x40]     
vpblendmd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vpblendmd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x64,0x5c,0x82,0x40]      
vpblendmd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpblendmd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x64,0x5c,0x82,0xc0]      
vpblendmd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpblendmd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x64,0x5c,0x82,0x40]     
vpblendmd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x64,0x5c,0x82,0x40]     
vpblendmd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vpblendmd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x64,0x5c,0x82,0xc0]     
vpblendmd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x64,0x5c,0x82,0xc0]     
vpblendmd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vpblendmd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x64,0x5c,0x82,0x40]      
vpblendmd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpblendmd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x64,0x5c,0x82,0xc0]      
vpblendmd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpblendmd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x64,0x5c,0x82,0x40]     
vpblendmd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x64,0x5c,0x82,0xc0]     
vpblendmd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x64,0x5c,0x82,0x40]    
vpblendmd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x64,0x5c,0x82,0xc0]    
vpblendmd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x64,0x5c,0x02,0x40]      
vpblendmd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpblendmd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x64,0x5c,0x02,0x40]     
vpblendmd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x64,0x5c,0x02,0x40]    
vpblendmd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x64,0x5a,0x40]      
vpblendmd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpblendmd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x64,0x5a,0x40]     
vpblendmd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x64,0x5a,0x40]    
vpblendmd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmd 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x64,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpblendmd 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpblendmd 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x64,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpblendmd 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x64,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpblendmd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vpblendmd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x64,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpblendmd 485498096, %zmm19, %zmm19 

// CHECK: vpblendmd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x64,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpblendmd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x64,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpblendmd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmd (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x64,0x1a]      
vpblendmd (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpblendmd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x64,0x1a]     
vpblendmd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x64,0x1a]     
vpblendmd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vpblendmd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x64,0x1a]      
vpblendmd (%rdx), %zmm19, %zmm19 

// CHECK: vpblendmd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x64,0x1a]     
vpblendmd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x64,0x1a]    
vpblendmd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x64,0xdb]      
vpblendmd %zmm19, %zmm19, %zmm19 

// CHECK: vpblendmd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x64,0xdb]     
vpblendmd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x64,0xdb]    
vpblendmd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmq 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x64,0x5c,0x82,0x40]      
vpblendmq 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpblendmq -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x64,0x5c,0x82,0xc0]      
vpblendmq -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpblendmq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x64,0x5c,0x82,0x40]     
vpblendmq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x64,0x5c,0x82,0xc0]     
vpblendmq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x64,0x5c,0x82,0x40]    
vpblendmq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x64,0x5c,0x82,0xc0]    
vpblendmq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmq 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x64,0x5c,0x02,0x40]      
vpblendmq 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpblendmq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x64,0x5c,0x02,0x40]     
vpblendmq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x64,0x5c,0x02,0x40]    
vpblendmq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmq 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x64,0x5a,0x40]      
vpblendmq 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpblendmq 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x64,0x5a,0x40]     
vpblendmq 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x64,0x5a,0x40]    
vpblendmq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmq 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x64,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpblendmq 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpblendmq 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x64,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpblendmq 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x64,0x1a]     
vpblendmd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vpblendmq 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x64,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpblendmq 485498096, %zmm19, %zmm19 

// CHECK: vpblendmq 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x64,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpblendmq 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmq 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x64,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpblendmq 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmq 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x64,0x5a,0x40]      
vpblendmq 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpblendmq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x64,0x5a,0x40]     
vpblendmq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x64,0x5a,0x40]     
vpblendmq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vpblendmq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x64,0x5c,0x02,0x40]      
vpblendmq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpblendmq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x64,0x5c,0x02,0x40]     
vpblendmq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x64,0x5c,0x02,0x40]     
vpblendmq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vpblendmq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x64,0x5c,0x82,0x40]      
vpblendmq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpblendmq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x64,0x5c,0x82,0xc0]      
vpblendmq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpblendmq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x64,0x5c,0x82,0x40]     
vpblendmq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x64,0x5c,0x82,0x40]     
vpblendmq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vpblendmq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x64,0x5c,0x82,0xc0]     
vpblendmq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z}
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x64,0x5c,0x82,0xc0]     
vpblendmq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z}

// CHECK: vpblendmq (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x64,0x1a]      
vpblendmq (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpblendmq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x64,0x1a]     
vpblendmq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmq (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x64,0x1a]      
vpblendmq (%rdx), %zmm19, %zmm19 

// CHECK: vpblendmq (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x64,0x1a]     
vpblendmq (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmq (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x64,0x1a]    
vpblendmq (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpblendmq %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x64,0xdb]      
vpblendmq %zmm19, %zmm19, %zmm19 

// CHECK: vpblendmq %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x64,0xdb]     
vpblendmq %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpblendmq %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x64,0xdb]    
vpblendmq %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpbroadcastd 256(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x58,0x5c,0x82,0x40]       
vpbroadcastd 256(%rdx,%rax,4), %zmm19 

// CHECK: vpbroadcastd -256(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x58,0x5c,0x82,0xc0]       
vpbroadcastd -256(%rdx,%rax,4), %zmm19 

// CHECK: vpbroadcastd 256(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x58,0x5c,0x82,0x40]      
vpbroadcastd 256(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpbroadcastd -256(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x58,0x5c,0x82,0xc0]      
vpbroadcastd -256(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpbroadcastd 256(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x58,0x5c,0x82,0x40]     
vpbroadcastd 256(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpbroadcastd -256(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x58,0x5c,0x82,0xc0]     
vpbroadcastd -256(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpbroadcastd 256(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x58,0x5c,0x02,0x40]       
vpbroadcastd 256(%rdx,%rax), %zmm19 

// CHECK: vpbroadcastd 256(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x58,0x5c,0x02,0x40]      
vpbroadcastd 256(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vpbroadcastd 256(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x58,0x5c,0x02,0x40]     
vpbroadcastd 256(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vpbroadcastd 256(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x58,0x5a,0x40]       
vpbroadcastd 256(%rdx), %zmm19 

// CHECK: vpbroadcastd 256(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x58,0x5a,0x40]      
vpbroadcastd 256(%rdx), %zmm19 {%k2} 

// CHECK: vpbroadcastd 256(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x58,0x5a,0x40]     
vpbroadcastd 256(%rdx), %zmm19 {%k2} {z} 

// CHECK: vpbroadcastd 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpbroadcastd 485498096, %zmm19 

// CHECK: vpbroadcastd 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpbroadcastd 485498096, %zmm19 {%k2} 

// CHECK: vpbroadcastd 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x58,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpbroadcastd 485498096, %zmm19 {%k2} {z} 

// CHECK: vpbroadcastd %r13d, %zmm19 
// CHECK: encoding: [0x62,0xc2,0x7d,0x48,0x7c,0xdd]       
vpbroadcastd %r13d, %zmm19 

// CHECK: vpbroadcastd %r13d, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xc2,0x7d,0x4a,0x7c,0xdd]      
vpbroadcastd %r13d, %zmm19 {%k2} 

// CHECK: vpbroadcastd %r13d, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xc2,0x7d,0xca,0x7c,0xdd]     
vpbroadcastd %r13d, %zmm19 {%k2} {z} 

// CHECK: vpbroadcastd (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x58,0x1a]       
vpbroadcastd (%rdx), %zmm19 

// CHECK: vpbroadcastd (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x58,0x1a]      
vpbroadcastd (%rdx), %zmm19 {%k2} 

// CHECK: vpbroadcastd (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x58,0x1a]     
vpbroadcastd (%rdx), %zmm19 {%k2} {z} 

// CHECK: vpbroadcastd %xmm15, %zmm19 
// CHECK: encoding: [0x62,0xc2,0x7d,0x48,0x58,0xdf]       
vpbroadcastd %xmm15, %zmm19 

// CHECK: vpbroadcastd %xmm15, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xc2,0x7d,0x4a,0x58,0xdf]      
vpbroadcastd %xmm15, %zmm19 {%k2} 

// CHECK: vpbroadcastd %xmm15, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xc2,0x7d,0xca,0x58,0xdf]     
vpbroadcastd %xmm15, %zmm19 {%k2} {z} 

// CHECK: vpbroadcastd %xmm1, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x58,0xd9]       
vpbroadcastd %xmm1, %zmm19 

// CHECK: vpbroadcastd %xmm1, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x58,0xd9]      
vpbroadcastd %xmm1, %zmm19 {%k2} 

// CHECK: vpbroadcastd %xmm1, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x58,0xd9]     
vpbroadcastd %xmm1, %zmm19 {%k2} {z} 

// CHECK: vpbroadcastq 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpbroadcastq 485498096, %zmm19 

// CHECK: vpbroadcastq 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpbroadcastq 485498096, %zmm19 {%k2} 

// CHECK: vpbroadcastq 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x59,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpbroadcastq 485498096, %zmm19 {%k2} {z} 

// CHECK: vpbroadcastq 512(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x59,0x5c,0x82,0x40]       
vpbroadcastq 512(%rdx,%rax,4), %zmm19 

// CHECK: vpbroadcastq -512(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x59,0x5c,0x82,0xc0]       
vpbroadcastq -512(%rdx,%rax,4), %zmm19 

// CHECK: vpbroadcastq 512(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x59,0x5c,0x82,0x40]      
vpbroadcastq 512(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpbroadcastq -512(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x59,0x5c,0x82,0xc0]      
vpbroadcastq -512(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpbroadcastq 512(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x59,0x5c,0x82,0x40]     
vpbroadcastq 512(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpbroadcastq -512(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x59,0x5c,0x82,0xc0]     
vpbroadcastq -512(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpbroadcastq 512(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x59,0x5c,0x02,0x40]       
vpbroadcastq 512(%rdx,%rax), %zmm19 

// CHECK: vpbroadcastq 512(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x59,0x5c,0x02,0x40]      
vpbroadcastq 512(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vpbroadcastq 512(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x59,0x5c,0x02,0x40]     
vpbroadcastq 512(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vpbroadcastq 512(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x59,0x5a,0x40]       
vpbroadcastq 512(%rdx), %zmm19 

// CHECK: vpbroadcastq 512(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x59,0x5a,0x40]      
vpbroadcastq 512(%rdx), %zmm19 {%k2} 

// CHECK: vpbroadcastq 512(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x59,0x5a,0x40]     
vpbroadcastq 512(%rdx), %zmm19 {%k2} {z} 

// CHECK: vpbroadcastq %r15, %zmm19 
// CHECK: encoding: [0x62,0xc2,0xfd,0x48,0x7c,0xdf]       
vpbroadcastq %r15, %zmm19 

// CHECK: vpbroadcastq %r15, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xc2,0xfd,0x4a,0x7c,0xdf]      
vpbroadcastq %r15, %zmm19 {%k2} 

// CHECK: vpbroadcastq %r15, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xc2,0xfd,0xca,0x7c,0xdf]     
vpbroadcastq %r15, %zmm19 {%k2} {z} 

// CHECK: vpbroadcastq (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x59,0x1a]       
vpbroadcastq (%rdx), %zmm19 

// CHECK: vpbroadcastq (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x59,0x1a]      
vpbroadcastq (%rdx), %zmm19 {%k2} 

// CHECK: vpbroadcastq (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x59,0x1a]     
vpbroadcastq (%rdx), %zmm19 {%k2} {z} 

// CHECK: vpbroadcastq %xmm15, %zmm19 
// CHECK: encoding: [0x62,0xc2,0xfd,0x48,0x59,0xdf]       
vpbroadcastq %xmm15, %zmm19 

// CHECK: vpbroadcastq %xmm15, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xc2,0xfd,0x4a,0x59,0xdf]      
vpbroadcastq %xmm15, %zmm19 {%k2} 

// CHECK: vpbroadcastq %xmm15, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xc2,0xfd,0xca,0x59,0xdf]     
vpbroadcastq %xmm15, %zmm19 {%k2} {z} 

// CHECK: vpbroadcastq %xmm1, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x59,0xd9]       
vpbroadcastq %xmm1, %zmm19 

// CHECK: vpbroadcastq %xmm1, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x59,0xd9]      
vpbroadcastq %xmm1, %zmm19 {%k2} 

// CHECK: vpbroadcastq %xmm1, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x59,0xd9]     
vpbroadcastq %xmm1, %zmm19 {%k2} {z} 

// CHECK: vpcmpeqd 256(%rdx){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x50,0x76,0x52,0x40]      
vpcmpeqd 256(%rdx){1to16}, %zmm19, %k2 

// CHECK: vpcmpeqd 256(%rdx){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x52,0x76,0x52,0x40]     
vpcmpeqd 256(%rdx){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqd 256(%rdx,%rax){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x50,0x76,0x54,0x02,0x40]      
vpcmpeqd 256(%rdx,%rax){1to16}, %zmm19, %k2 

// CHECK: vpcmpeqd 256(%rdx,%rax){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x52,0x76,0x54,0x02,0x40]     
vpcmpeqd 256(%rdx,%rax){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqd 256(%rdx,%rax,4){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x50,0x76,0x54,0x82,0x40]      
vpcmpeqd 256(%rdx,%rax,4){1to16}, %zmm19, %k2 

// CHECK: vpcmpeqd -256(%rdx,%rax,4){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x50,0x76,0x54,0x82,0xc0]      
vpcmpeqd -256(%rdx,%rax,4){1to16}, %zmm19, %k2 

// CHECK: vpcmpeqd 256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x52,0x76,0x54,0x82,0x40]     
vpcmpeqd 256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqd -256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x52,0x76,0x54,0x82,0xc0]     
vpcmpeqd -256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqd 4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x40,0x76,0x54,0x82,0x40]      
vpcmpeqd 4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vpcmpeqd -4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x40,0x76,0x54,0x82,0xc0]      
vpcmpeqd -4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vpcmpeqd 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x42,0x76,0x54,0x82,0x40]     
vpcmpeqd 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqd -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x42,0x76,0x54,0x82,0xc0]     
vpcmpeqd -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqd 4096(%rdx,%rax), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x40,0x76,0x54,0x02,0x40]      
vpcmpeqd 4096(%rdx,%rax), %zmm19, %k2 

// CHECK: vpcmpeqd 4096(%rdx,%rax), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x42,0x76,0x54,0x02,0x40]     
vpcmpeqd 4096(%rdx,%rax), %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqd 4096(%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x40,0x76,0x52,0x40]      
vpcmpeqd 4096(%rdx), %zmm19, %k2 

// CHECK: vpcmpeqd 4096(%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x42,0x76,0x52,0x40]     
vpcmpeqd 4096(%rdx), %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqd 485498096{1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x50,0x76,0x14,0x25,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqd 485498096{1to16}, %zmm19, %k2 

// CHECK: vpcmpeqd 485498096{1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x52,0x76,0x14,0x25,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqd 485498096{1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqd 485498096, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x40,0x76,0x14,0x25,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqd 485498096, %zmm19, %k2 

// CHECK: vpcmpeqd 485498096, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x42,0x76,0x14,0x25,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqd 485498096, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqd (%rdx){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x50,0x76,0x12]      
vpcmpeqd (%rdx){1to16}, %zmm19, %k2 

// CHECK: vpcmpeqd (%rdx){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x52,0x76,0x12]     
vpcmpeqd (%rdx){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqd (%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x40,0x76,0x12]      
vpcmpeqd (%rdx), %zmm19, %k2 

// CHECK: vpcmpeqd (%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x42,0x76,0x12]     
vpcmpeqd (%rdx), %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqd %zmm19, %zmm19, %k2 
// CHECK: encoding: [0x62,0xb1,0x65,0x40,0x76,0xd3]      
vpcmpeqd %zmm19, %zmm19, %k2 

// CHECK: vpcmpeqd %zmm19, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xb1,0x65,0x42,0x76,0xd3]     
vpcmpeqd %zmm19, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq 4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x40,0x29,0x54,0x82,0x40]      
vpcmpeqq 4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vpcmpeqq -4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x40,0x29,0x54,0x82,0xc0]      
vpcmpeqq -4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vpcmpeqq 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x42,0x29,0x54,0x82,0x40]     
vpcmpeqq 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x42,0x29,0x54,0x82,0xc0]     
vpcmpeqq -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq 4096(%rdx,%rax), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x40,0x29,0x54,0x02,0x40]      
vpcmpeqq 4096(%rdx,%rax), %zmm19, %k2 

// CHECK: vpcmpeqq 4096(%rdx,%rax), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x42,0x29,0x54,0x02,0x40]     
vpcmpeqq 4096(%rdx,%rax), %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq 4096(%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x40,0x29,0x52,0x40]      
vpcmpeqq 4096(%rdx), %zmm19, %k2 

// CHECK: vpcmpeqq 4096(%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x42,0x29,0x52,0x40]     
vpcmpeqq 4096(%rdx), %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq 485498096{1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x50,0x29,0x14,0x25,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqq 485498096{1to8}, %zmm19, %k2 

// CHECK: vpcmpeqq 485498096{1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x52,0x29,0x14,0x25,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqq 485498096{1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq 485498096, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x40,0x29,0x14,0x25,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqq 485498096, %zmm19, %k2 

// CHECK: vpcmpeqq 485498096, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x42,0x29,0x14,0x25,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqq 485498096, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq 512(%rdx){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x50,0x29,0x52,0x40]      
vpcmpeqq 512(%rdx){1to8}, %zmm19, %k2 

// CHECK: vpcmpeqq 512(%rdx){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x52,0x29,0x52,0x40]     
vpcmpeqq 512(%rdx){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq 512(%rdx,%rax){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x50,0x29,0x54,0x02,0x40]      
vpcmpeqq 512(%rdx,%rax){1to8}, %zmm19, %k2 

// CHECK: vpcmpeqq 512(%rdx,%rax){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x52,0x29,0x54,0x02,0x40]     
vpcmpeqq 512(%rdx,%rax){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq 512(%rdx,%rax,4){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x50,0x29,0x54,0x82,0x40]      
vpcmpeqq 512(%rdx,%rax,4){1to8}, %zmm19, %k2 

// CHECK: vpcmpeqq -512(%rdx,%rax,4){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x50,0x29,0x54,0x82,0xc0]      
vpcmpeqq -512(%rdx,%rax,4){1to8}, %zmm19, %k2 

// CHECK: vpcmpeqq 512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x52,0x29,0x54,0x82,0x40]     
vpcmpeqq 512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq -512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x52,0x29,0x54,0x82,0xc0]     
vpcmpeqq -512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq (%rdx){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x50,0x29,0x12]      
vpcmpeqq (%rdx){1to8}, %zmm19, %k2 

// CHECK: vpcmpeqq (%rdx){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x52,0x29,0x12]     
vpcmpeqq (%rdx){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq (%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x40,0x29,0x12]      
vpcmpeqq (%rdx), %zmm19, %k2 

// CHECK: vpcmpeqq (%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x42,0x29,0x12]     
vpcmpeqq (%rdx), %zmm19, %k2 {%k2} 

// CHECK: vpcmpeqq %zmm19, %zmm19, %k2 
// CHECK: encoding: [0x62,0xb2,0xe5,0x40,0x29,0xd3]      
vpcmpeqq %zmm19, %zmm19, %k2 

// CHECK: vpcmpeqq %zmm19, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xb2,0xe5,0x42,0x29,0xd3]     
vpcmpeqq %zmm19, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd 256(%rdx){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0x65,0x50,0x1e,0x52,0x40,0x00]      
vpcmpequd 256(%rdx){1to16}, %zmm19, %k2 

// CHECK: vpcmpequd 256(%rdx){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x65,0x52,0x1e,0x52,0x40,0x00]     
vpcmpequd 256(%rdx){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd 256(%rdx,%rax){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0x65,0x50,0x1e,0x54,0x02,0x40,0x00]      
vpcmpequd 256(%rdx,%rax){1to16}, %zmm19, %k2 

// CHECK: vpcmpequd 256(%rdx,%rax){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x65,0x52,0x1e,0x54,0x02,0x40,0x00]     
vpcmpequd 256(%rdx,%rax){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd 256(%rdx,%rax,4){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0x65,0x50,0x1e,0x54,0x82,0x40,0x00]      
vpcmpequd 256(%rdx,%rax,4){1to16}, %zmm19, %k2 

// CHECK: vpcmpequd -256(%rdx,%rax,4){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0x65,0x50,0x1e,0x54,0x82,0xc0,0x00]      
vpcmpequd -256(%rdx,%rax,4){1to16}, %zmm19, %k2 

// CHECK: vpcmpequd 256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x65,0x52,0x1e,0x54,0x82,0x40,0x00]     
vpcmpequd 256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd -256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x65,0x52,0x1e,0x54,0x82,0xc0,0x00]     
vpcmpequd -256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd 4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0x65,0x40,0x1e,0x54,0x82,0x40,0x00]      
vpcmpequd 4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vpcmpequd -4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0x65,0x40,0x1e,0x54,0x82,0xc0,0x00]      
vpcmpequd -4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vpcmpequd 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x65,0x42,0x1e,0x54,0x82,0x40,0x00]     
vpcmpequd 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x65,0x42,0x1e,0x54,0x82,0xc0,0x00]     
vpcmpequd -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd 4096(%rdx,%rax), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0x65,0x40,0x1e,0x54,0x02,0x40,0x00]      
vpcmpequd 4096(%rdx,%rax), %zmm19, %k2 

// CHECK: vpcmpequd 4096(%rdx,%rax), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x65,0x42,0x1e,0x54,0x02,0x40,0x00]     
vpcmpequd 4096(%rdx,%rax), %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd 4096(%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0x65,0x40,0x1e,0x52,0x40,0x00]      
vpcmpequd 4096(%rdx), %zmm19, %k2 

// CHECK: vpcmpequd 4096(%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x65,0x42,0x1e,0x52,0x40,0x00]     
vpcmpequd 4096(%rdx), %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd 485498096{1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0x65,0x50,0x1e,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequd 485498096{1to16}, %zmm19, %k2 

// CHECK: vpcmpequd 485498096{1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x65,0x52,0x1e,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequd 485498096{1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd 485498096, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0x65,0x40,0x1e,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequd 485498096, %zmm19, %k2 

// CHECK: vpcmpequd 485498096, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x65,0x42,0x1e,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequd 485498096, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd (%rdx){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0x65,0x50,0x1e,0x12,0x00]      
vpcmpequd (%rdx){1to16}, %zmm19, %k2 

// CHECK: vpcmpequd (%rdx){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x65,0x52,0x1e,0x12,0x00]     
vpcmpequd (%rdx){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd (%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0x65,0x40,0x1e,0x12,0x00]      
vpcmpequd (%rdx), %zmm19, %k2 

// CHECK: vpcmpequd (%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x65,0x42,0x1e,0x12,0x00]     
vpcmpequd (%rdx), %zmm19, %k2 {%k2} 

// CHECK: vpcmpequd %zmm19, %zmm19, %k2 
// CHECK: encoding: [0x62,0xb3,0x65,0x40,0x1e,0xd3,0x00]      
vpcmpequd %zmm19, %zmm19, %k2 

// CHECK: vpcmpequd %zmm19, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xb3,0x65,0x42,0x1e,0xd3,0x00]     
vpcmpequd %zmm19, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq 4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0xe5,0x40,0x1e,0x54,0x82,0x40,0x00]      
vpcmpequq 4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vpcmpequq -4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0xe5,0x40,0x1e,0x54,0x82,0xc0,0x00]      
vpcmpequq -4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vpcmpequq 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xe5,0x42,0x1e,0x54,0x82,0x40,0x00]     
vpcmpequq 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xe5,0x42,0x1e,0x54,0x82,0xc0,0x00]     
vpcmpequq -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq 4096(%rdx,%rax), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0xe5,0x40,0x1e,0x54,0x02,0x40,0x00]      
vpcmpequq 4096(%rdx,%rax), %zmm19, %k2 

// CHECK: vpcmpequq 4096(%rdx,%rax), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xe5,0x42,0x1e,0x54,0x02,0x40,0x00]     
vpcmpequq 4096(%rdx,%rax), %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq 4096(%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0xe5,0x40,0x1e,0x52,0x40,0x00]      
vpcmpequq 4096(%rdx), %zmm19, %k2 

// CHECK: vpcmpequq 4096(%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xe5,0x42,0x1e,0x52,0x40,0x00]     
vpcmpequq 4096(%rdx), %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq 485498096{1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0xe5,0x50,0x1e,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequq 485498096{1to8}, %zmm19, %k2 

// CHECK: vpcmpequq 485498096{1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xe5,0x52,0x1e,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequq 485498096{1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq 485498096, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0xe5,0x40,0x1e,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequq 485498096, %zmm19, %k2 

// CHECK: vpcmpequq 485498096, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xe5,0x42,0x1e,0x14,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequq 485498096, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq 512(%rdx){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0xe5,0x50,0x1e,0x52,0x40,0x00]      
vpcmpequq 512(%rdx){1to8}, %zmm19, %k2 

// CHECK: vpcmpequq 512(%rdx){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xe5,0x52,0x1e,0x52,0x40,0x00]     
vpcmpequq 512(%rdx){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq 512(%rdx,%rax){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0xe5,0x50,0x1e,0x54,0x02,0x40,0x00]      
vpcmpequq 512(%rdx,%rax){1to8}, %zmm19, %k2 

// CHECK: vpcmpequq 512(%rdx,%rax){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xe5,0x52,0x1e,0x54,0x02,0x40,0x00]     
vpcmpequq 512(%rdx,%rax){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq 512(%rdx,%rax,4){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0xe5,0x50,0x1e,0x54,0x82,0x40,0x00]      
vpcmpequq 512(%rdx,%rax,4){1to8}, %zmm19, %k2 

// CHECK: vpcmpequq -512(%rdx,%rax,4){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0xe5,0x50,0x1e,0x54,0x82,0xc0,0x00]      
vpcmpequq -512(%rdx,%rax,4){1to8}, %zmm19, %k2 

// CHECK: vpcmpequq 512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xe5,0x52,0x1e,0x54,0x82,0x40,0x00]     
vpcmpequq 512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq -512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xe5,0x52,0x1e,0x54,0x82,0xc0,0x00]     
vpcmpequq -512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq (%rdx){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0xe5,0x50,0x1e,0x12,0x00]      
vpcmpequq (%rdx){1to8}, %zmm19, %k2 

// CHECK: vpcmpequq (%rdx){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xe5,0x52,0x1e,0x12,0x00]     
vpcmpequq (%rdx){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq (%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf3,0xe5,0x40,0x1e,0x12,0x00]      
vpcmpequq (%rdx), %zmm19, %k2 

// CHECK: vpcmpequq (%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xe5,0x42,0x1e,0x12,0x00]     
vpcmpequq (%rdx), %zmm19, %k2 {%k2} 

// CHECK: vpcmpequq %zmm19, %zmm19, %k2 
// CHECK: encoding: [0x62,0xb3,0xe5,0x40,0x1e,0xd3,0x00]      
vpcmpequq %zmm19, %zmm19, %k2 

// CHECK: vpcmpequq %zmm19, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xb3,0xe5,0x42,0x1e,0xd3,0x00]     
vpcmpequq %zmm19, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd 256(%rdx){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x50,0x66,0x52,0x40]      
vpcmpgtd 256(%rdx){1to16}, %zmm19, %k2 

// CHECK: vpcmpgtd 256(%rdx){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x52,0x66,0x52,0x40]     
vpcmpgtd 256(%rdx){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd 256(%rdx,%rax){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x50,0x66,0x54,0x02,0x40]      
vpcmpgtd 256(%rdx,%rax){1to16}, %zmm19, %k2 

// CHECK: vpcmpgtd 256(%rdx,%rax){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x52,0x66,0x54,0x02,0x40]     
vpcmpgtd 256(%rdx,%rax){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd 256(%rdx,%rax,4){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x50,0x66,0x54,0x82,0x40]      
vpcmpgtd 256(%rdx,%rax,4){1to16}, %zmm19, %k2 

// CHECK: vpcmpgtd -256(%rdx,%rax,4){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x50,0x66,0x54,0x82,0xc0]      
vpcmpgtd -256(%rdx,%rax,4){1to16}, %zmm19, %k2 

// CHECK: vpcmpgtd 256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x52,0x66,0x54,0x82,0x40]     
vpcmpgtd 256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd -256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x52,0x66,0x54,0x82,0xc0]     
vpcmpgtd -256(%rdx,%rax,4){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd 4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x40,0x66,0x54,0x82,0x40]      
vpcmpgtd 4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vpcmpgtd -4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x40,0x66,0x54,0x82,0xc0]      
vpcmpgtd -4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vpcmpgtd 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x42,0x66,0x54,0x82,0x40]     
vpcmpgtd 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x42,0x66,0x54,0x82,0xc0]     
vpcmpgtd -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd 4096(%rdx,%rax), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x40,0x66,0x54,0x02,0x40]      
vpcmpgtd 4096(%rdx,%rax), %zmm19, %k2 

// CHECK: vpcmpgtd 4096(%rdx,%rax), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x42,0x66,0x54,0x02,0x40]     
vpcmpgtd 4096(%rdx,%rax), %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd 4096(%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x40,0x66,0x52,0x40]      
vpcmpgtd 4096(%rdx), %zmm19, %k2 

// CHECK: vpcmpgtd 4096(%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x42,0x66,0x52,0x40]     
vpcmpgtd 4096(%rdx), %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd 485498096{1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x50,0x66,0x14,0x25,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtd 485498096{1to16}, %zmm19, %k2 

// CHECK: vpcmpgtd 485498096{1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x52,0x66,0x14,0x25,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtd 485498096{1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd 485498096, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x40,0x66,0x14,0x25,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtd 485498096, %zmm19, %k2 

// CHECK: vpcmpgtd 485498096, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x42,0x66,0x14,0x25,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtd 485498096, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd (%rdx){1to16}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x50,0x66,0x12]      
vpcmpgtd (%rdx){1to16}, %zmm19, %k2 

// CHECK: vpcmpgtd (%rdx){1to16}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x52,0x66,0x12]     
vpcmpgtd (%rdx){1to16}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd (%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf1,0x65,0x40,0x66,0x12]      
vpcmpgtd (%rdx), %zmm19, %k2 

// CHECK: vpcmpgtd (%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x65,0x42,0x66,0x12]     
vpcmpgtd (%rdx), %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtd %zmm19, %zmm19, %k2 
// CHECK: encoding: [0x62,0xb1,0x65,0x40,0x66,0xd3]      
vpcmpgtd %zmm19, %zmm19, %k2 

// CHECK: vpcmpgtd %zmm19, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xb1,0x65,0x42,0x66,0xd3]     
vpcmpgtd %zmm19, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq 4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x40,0x37,0x54,0x82,0x40]      
vpcmpgtq 4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vpcmpgtq -4096(%rdx,%rax,4), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x40,0x37,0x54,0x82,0xc0]      
vpcmpgtq -4096(%rdx,%rax,4), %zmm19, %k2 

// CHECK: vpcmpgtq 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x42,0x37,0x54,0x82,0x40]     
vpcmpgtq 4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x42,0x37,0x54,0x82,0xc0]     
vpcmpgtq -4096(%rdx,%rax,4), %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq 4096(%rdx,%rax), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x40,0x37,0x54,0x02,0x40]      
vpcmpgtq 4096(%rdx,%rax), %zmm19, %k2 

// CHECK: vpcmpgtq 4096(%rdx,%rax), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x42,0x37,0x54,0x02,0x40]     
vpcmpgtq 4096(%rdx,%rax), %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq 4096(%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x40,0x37,0x52,0x40]      
vpcmpgtq 4096(%rdx), %zmm19, %k2 

// CHECK: vpcmpgtq 4096(%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x42,0x37,0x52,0x40]     
vpcmpgtq 4096(%rdx), %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq 485498096{1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x50,0x37,0x14,0x25,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtq 485498096{1to8}, %zmm19, %k2 

// CHECK: vpcmpgtq 485498096{1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x52,0x37,0x14,0x25,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtq 485498096{1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq 485498096, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x40,0x37,0x14,0x25,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtq 485498096, %zmm19, %k2 

// CHECK: vpcmpgtq 485498096, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x42,0x37,0x14,0x25,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtq 485498096, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq 512(%rdx){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x50,0x37,0x52,0x40]      
vpcmpgtq 512(%rdx){1to8}, %zmm19, %k2 

// CHECK: vpcmpgtq 512(%rdx){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x52,0x37,0x52,0x40]     
vpcmpgtq 512(%rdx){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq 512(%rdx,%rax){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x50,0x37,0x54,0x02,0x40]      
vpcmpgtq 512(%rdx,%rax){1to8}, %zmm19, %k2 

// CHECK: vpcmpgtq 512(%rdx,%rax){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x52,0x37,0x54,0x02,0x40]     
vpcmpgtq 512(%rdx,%rax){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq 512(%rdx,%rax,4){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x50,0x37,0x54,0x82,0x40]      
vpcmpgtq 512(%rdx,%rax,4){1to8}, %zmm19, %k2 

// CHECK: vpcmpgtq -512(%rdx,%rax,4){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x50,0x37,0x54,0x82,0xc0]      
vpcmpgtq -512(%rdx,%rax,4){1to8}, %zmm19, %k2 

// CHECK: vpcmpgtq 512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x52,0x37,0x54,0x82,0x40]     
vpcmpgtq 512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq -512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x52,0x37,0x54,0x82,0xc0]     
vpcmpgtq -512(%rdx,%rax,4){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq (%rdx){1to8}, %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x50,0x37,0x12]      
vpcmpgtq (%rdx){1to8}, %zmm19, %k2 

// CHECK: vpcmpgtq (%rdx){1to8}, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x52,0x37,0x12]     
vpcmpgtq (%rdx){1to8}, %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq (%rdx), %zmm19, %k2 
// CHECK: encoding: [0x62,0xf2,0xe5,0x40,0x37,0x12]      
vpcmpgtq (%rdx), %zmm19, %k2 

// CHECK: vpcmpgtq (%rdx), %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xe5,0x42,0x37,0x12]     
vpcmpgtq (%rdx), %zmm19, %k2 {%k2} 

// CHECK: vpcmpgtq %zmm19, %zmm19, %k2 
// CHECK: encoding: [0x62,0xb2,0xe5,0x40,0x37,0xd3]      
vpcmpgtq %zmm19, %zmm19, %k2 

// CHECK: vpcmpgtq %zmm19, %zmm19, %k2 {%k2} 
// CHECK: encoding: [0x62,0xb2,0xe5,0x42,0x37,0xd3]     
vpcmpgtq %zmm19, %zmm19, %k2 {%k2} 

// CHECK: vpcompressd %zmm19, 256(%rdx) 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x8b,0x5a,0x40]       
vpcompressd %zmm19, 256(%rdx) 

// CHECK: vpcompressd %zmm19, 256(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x8b,0x5a,0x40]      
vpcompressd %zmm19, 256(%rdx) {%k2} 

// CHECK: vpcompressd %zmm19, 256(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x8b,0x5c,0x82,0x40]       
vpcompressd %zmm19, 256(%rdx,%rax,4) 

// CHECK: vpcompressd %zmm19, -256(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x8b,0x5c,0x82,0xc0]       
vpcompressd %zmm19, -256(%rdx,%rax,4) 

// CHECK: vpcompressd %zmm19, 256(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x8b,0x5c,0x82,0x40]      
vpcompressd %zmm19, 256(%rdx,%rax,4) {%k2} 

// CHECK: vpcompressd %zmm19, -256(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x8b,0x5c,0x82,0xc0]      
vpcompressd %zmm19, -256(%rdx,%rax,4) {%k2} 

// CHECK: vpcompressd %zmm19, 256(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x8b,0x5c,0x02,0x40]       
vpcompressd %zmm19, 256(%rdx,%rax) 

// CHECK: vpcompressd %zmm19, 256(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x8b,0x5c,0x02,0x40]      
vpcompressd %zmm19, 256(%rdx,%rax) {%k2} 

// CHECK: vpcompressd %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x8b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpcompressd %zmm19, 485498096 

// CHECK: vpcompressd %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x8b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpcompressd %zmm19, 485498096 {%k2} 

// CHECK: vpcompressd %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x8b,0x1a]       
vpcompressd %zmm19, (%rdx) 

// CHECK: vpcompressd %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x8b,0x1a]      
vpcompressd %zmm19, (%rdx) {%k2} 

// CHECK: vpcompressd %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x7d,0x48,0x8b,0xdb]       
vpcompressd %zmm19, %zmm19 

// CHECK: vpcompressd %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x8b,0xdb]      
vpcompressd %zmm19, %zmm19 {%k2} 

// CHECK: vpcompressd %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x7d,0xca,0x8b,0xdb]     
vpcompressd %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpcompressq %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x8b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpcompressq %zmm19, 485498096 

// CHECK: vpcompressq %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x8b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpcompressq %zmm19, 485498096 {%k2} 

// CHECK: vpcompressq %zmm19, 512(%rdx) 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x8b,0x5a,0x40]       
vpcompressq %zmm19, 512(%rdx) 

// CHECK: vpcompressq %zmm19, 512(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x8b,0x5a,0x40]      
vpcompressq %zmm19, 512(%rdx) {%k2} 

// CHECK: vpcompressq %zmm19, 512(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x8b,0x5c,0x82,0x40]       
vpcompressq %zmm19, 512(%rdx,%rax,4) 

// CHECK: vpcompressq %zmm19, -512(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x8b,0x5c,0x82,0xc0]       
vpcompressq %zmm19, -512(%rdx,%rax,4) 

// CHECK: vpcompressq %zmm19, 512(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x8b,0x5c,0x82,0x40]      
vpcompressq %zmm19, 512(%rdx,%rax,4) {%k2} 

// CHECK: vpcompressq %zmm19, -512(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x8b,0x5c,0x82,0xc0]      
vpcompressq %zmm19, -512(%rdx,%rax,4) {%k2} 

// CHECK: vpcompressq %zmm19, 512(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x8b,0x5c,0x02,0x40]       
vpcompressq %zmm19, 512(%rdx,%rax) 

// CHECK: vpcompressq %zmm19, 512(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x8b,0x5c,0x02,0x40]      
vpcompressq %zmm19, 512(%rdx,%rax) {%k2} 

// CHECK: vpcompressq %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x8b,0x1a]       
vpcompressq %zmm19, (%rdx) 

// CHECK: vpcompressq %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x8b,0x1a]      
vpcompressq %zmm19, (%rdx) {%k2} 

// CHECK: vpcompressq %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xfd,0x48,0x8b,0xdb]       
vpcompressq %zmm19, %zmm19 

// CHECK: vpcompressq %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x8b,0xdb]      
vpcompressq %zmm19, %zmm19 {%k2} 

// CHECK: vpcompressq %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xfd,0xca,0x8b,0xdb]     
vpcompressq %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x36,0x5a,0x40]      
vpermd 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x36,0x5a,0x40]     
vpermd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x36,0x5a,0x40]    
vpermd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x36,0x5c,0x02,0x40]      
vpermd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpermd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x36,0x5c,0x02,0x40]     
vpermd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x36,0x5c,0x02,0x40]    
vpermd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x36,0x5c,0x82,0x40]      
vpermd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x36,0x5c,0x82,0xc0]      
vpermd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x36,0x5c,0x82,0x40]     
vpermd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x36,0x5c,0x82,0xc0]     
vpermd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x36,0x5c,0x82,0x40]    
vpermd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x36,0x5c,0x82,0xc0]    
vpermd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x36,0x5c,0x82,0x40]      
vpermd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x36,0x5c,0x82,0xc0]      
vpermd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x36,0x5c,0x82,0x40]     
vpermd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x36,0x5c,0x82,0xc0]     
vpermd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x36,0x5c,0x82,0x40]    
vpermd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x36,0x5c,0x82,0xc0]    
vpermd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x36,0x5c,0x02,0x40]      
vpermd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x36,0x5c,0x02,0x40]     
vpermd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x36,0x5c,0x02,0x40]    
vpermd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x36,0x5a,0x40]      
vpermd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x36,0x5a,0x40]     
vpermd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x36,0x5a,0x40]    
vpermd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x36,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermd 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpermd 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x36,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermd 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x36,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x36,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermd 485498096, %zmm19, %zmm19 

// CHECK: vpermd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x36,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x36,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x36,0x1a]      
vpermd (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x36,0x1a]     
vpermd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x36,0x1a]    
vpermd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x36,0x1a]      
vpermd (%rdx), %zmm19, %zmm19 

// CHECK: vpermd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x36,0x1a]     
vpermd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x36,0x1a]    
vpermd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x36,0xdb]      
vpermd %zmm19, %zmm19, %zmm19 

// CHECK: vpermd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x36,0xdb]     
vpermd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x36,0xdb]    
vpermd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x76,0x5a,0x40]      
vpermi2d 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermi2d 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x76,0x5a,0x40]     
vpermi2d 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x76,0x5a,0x40]    
vpermi2d 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x76,0x5c,0x02,0x40]      
vpermi2d 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpermi2d 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x76,0x5c,0x02,0x40]     
vpermi2d 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x76,0x5c,0x02,0x40]    
vpermi2d 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x76,0x5c,0x82,0x40]      
vpermi2d 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermi2d -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x76,0x5c,0x82,0xc0]      
vpermi2d -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermi2d 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x76,0x5c,0x82,0x40]     
vpermi2d 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x76,0x5c,0x82,0xc0]     
vpermi2d -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x76,0x5c,0x82,0x40]    
vpermi2d 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x76,0x5c,0x82,0xc0]    
vpermi2d -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x76,0x5c,0x82,0x40]      
vpermi2d 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermi2d -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x76,0x5c,0x82,0xc0]      
vpermi2d -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermi2d 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x76,0x5c,0x82,0x40]     
vpermi2d 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x76,0x5c,0x82,0xc0]     
vpermi2d -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x76,0x5c,0x82,0x40]    
vpermi2d 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x76,0x5c,0x82,0xc0]    
vpermi2d -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x76,0x5c,0x02,0x40]      
vpermi2d 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermi2d 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x76,0x5c,0x02,0x40]     
vpermi2d 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x76,0x5c,0x02,0x40]    
vpermi2d 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x76,0x5a,0x40]      
vpermi2d 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermi2d 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x76,0x5a,0x40]     
vpermi2d 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x76,0x5a,0x40]    
vpermi2d 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x76,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermi2d 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpermi2d 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x76,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermi2d 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x76,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermi2d 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x76,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermi2d 485498096, %zmm19, %zmm19 

// CHECK: vpermi2d 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x76,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermi2d 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x76,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermi2d 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x76,0x1a]      
vpermi2d (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermi2d (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x76,0x1a]     
vpermi2d (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x76,0x1a]    
vpermi2d (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x76,0x1a]      
vpermi2d (%rdx), %zmm19, %zmm19 

// CHECK: vpermi2d (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x76,0x1a]     
vpermi2d (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x76,0x1a]    
vpermi2d (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2d %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x76,0xdb]      
vpermi2d %zmm19, %zmm19, %zmm19 

// CHECK: vpermi2d %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x76,0xdb]     
vpermi2d %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2d %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x76,0xdb]    
vpermi2d %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x77,0x5c,0x82,0x40]      
vpermi2pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermi2pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x77,0x5c,0x82,0xc0]      
vpermi2pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermi2pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x77,0x5c,0x82,0x40]     
vpermi2pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x77,0x5c,0x82,0xc0]     
vpermi2pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x77,0x5c,0x82,0x40]    
vpermi2pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x77,0x5c,0x82,0xc0]    
vpermi2pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x77,0x5c,0x02,0x40]      
vpermi2pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermi2pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x77,0x5c,0x02,0x40]     
vpermi2pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x77,0x5c,0x02,0x40]    
vpermi2pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x77,0x5a,0x40]      
vpermi2pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermi2pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x77,0x5a,0x40]     
vpermi2pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x77,0x5a,0x40]    
vpermi2pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x77,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermi2pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpermi2pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x77,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermi2pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x77,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermi2pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x77,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermi2pd 485498096, %zmm19, %zmm19 

// CHECK: vpermi2pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x77,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermi2pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x77,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermi2pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x77,0x5a,0x40]      
vpermi2pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermi2pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x77,0x5a,0x40]     
vpermi2pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x77,0x5a,0x40]    
vpermi2pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x77,0x5c,0x02,0x40]      
vpermi2pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpermi2pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x77,0x5c,0x02,0x40]     
vpermi2pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x77,0x5c,0x02,0x40]    
vpermi2pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x77,0x5c,0x82,0x40]      
vpermi2pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermi2pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x77,0x5c,0x82,0xc0]      
vpermi2pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermi2pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x77,0x5c,0x82,0x40]     
vpermi2pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x77,0x5c,0x82,0xc0]     
vpermi2pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x77,0x5c,0x82,0x40]    
vpermi2pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x77,0x5c,0x82,0xc0]    
vpermi2pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x77,0x1a]      
vpermi2pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermi2pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x77,0x1a]     
vpermi2pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x77,0x1a]    
vpermi2pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x77,0x1a]      
vpermi2pd (%rdx), %zmm19, %zmm19 

// CHECK: vpermi2pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x77,0x1a]     
vpermi2pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x77,0x1a]    
vpermi2pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x77,0xdb]      
vpermi2pd %zmm19, %zmm19, %zmm19 

// CHECK: vpermi2pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x77,0xdb]     
vpermi2pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x77,0xdb]    
vpermi2pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x77,0x5a,0x40]      
vpermi2ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermi2ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x77,0x5a,0x40]     
vpermi2ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x77,0x5a,0x40]    
vpermi2ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x77,0x5c,0x02,0x40]      
vpermi2ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpermi2ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x77,0x5c,0x02,0x40]     
vpermi2ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x77,0x5c,0x02,0x40]    
vpermi2ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x77,0x5c,0x82,0x40]      
vpermi2ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermi2ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x77,0x5c,0x82,0xc0]      
vpermi2ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermi2ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x77,0x5c,0x82,0x40]     
vpermi2ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x77,0x5c,0x82,0xc0]     
vpermi2ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x77,0x5c,0x82,0x40]    
vpermi2ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x77,0x5c,0x82,0xc0]    
vpermi2ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x77,0x5c,0x82,0x40]      
vpermi2ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermi2ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x77,0x5c,0x82,0xc0]      
vpermi2ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermi2ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x77,0x5c,0x82,0x40]     
vpermi2ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x77,0x5c,0x82,0xc0]     
vpermi2ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x77,0x5c,0x82,0x40]    
vpermi2ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x77,0x5c,0x82,0xc0]    
vpermi2ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x77,0x5c,0x02,0x40]      
vpermi2ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermi2ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x77,0x5c,0x02,0x40]     
vpermi2ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x77,0x5c,0x02,0x40]    
vpermi2ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x77,0x5a,0x40]      
vpermi2ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermi2ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x77,0x5a,0x40]     
vpermi2ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x77,0x5a,0x40]    
vpermi2ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x77,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermi2ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpermi2ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x77,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermi2ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x77,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermi2ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x77,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermi2ps 485498096, %zmm19, %zmm19 

// CHECK: vpermi2ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x77,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermi2ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x77,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermi2ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x77,0x1a]      
vpermi2ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermi2ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x77,0x1a]     
vpermi2ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x77,0x1a]    
vpermi2ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x77,0x1a]      
vpermi2ps (%rdx), %zmm19, %zmm19 

// CHECK: vpermi2ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x77,0x1a]     
vpermi2ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x77,0x1a]    
vpermi2ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x77,0xdb]      
vpermi2ps %zmm19, %zmm19, %zmm19 

// CHECK: vpermi2ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x77,0xdb]     
vpermi2ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x77,0xdb]    
vpermi2ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x76,0x5c,0x82,0x40]      
vpermi2q 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermi2q -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x76,0x5c,0x82,0xc0]      
vpermi2q -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermi2q 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x76,0x5c,0x82,0x40]     
vpermi2q 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x76,0x5c,0x82,0xc0]     
vpermi2q -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x76,0x5c,0x82,0x40]    
vpermi2q 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x76,0x5c,0x82,0xc0]    
vpermi2q -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x76,0x5c,0x02,0x40]      
vpermi2q 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermi2q 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x76,0x5c,0x02,0x40]     
vpermi2q 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x76,0x5c,0x02,0x40]    
vpermi2q 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x76,0x5a,0x40]      
vpermi2q 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermi2q 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x76,0x5a,0x40]     
vpermi2q 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x76,0x5a,0x40]    
vpermi2q 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x76,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermi2q 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpermi2q 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x76,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermi2q 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x76,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermi2q 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x76,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermi2q 485498096, %zmm19, %zmm19 

// CHECK: vpermi2q 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x76,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermi2q 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x76,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermi2q 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x76,0x5a,0x40]      
vpermi2q 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermi2q 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x76,0x5a,0x40]     
vpermi2q 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x76,0x5a,0x40]    
vpermi2q 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x76,0x5c,0x02,0x40]      
vpermi2q 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpermi2q 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x76,0x5c,0x02,0x40]     
vpermi2q 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x76,0x5c,0x02,0x40]    
vpermi2q 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x76,0x5c,0x82,0x40]      
vpermi2q 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermi2q -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x76,0x5c,0x82,0xc0]      
vpermi2q -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermi2q 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x76,0x5c,0x82,0x40]     
vpermi2q 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x76,0x5c,0x82,0xc0]     
vpermi2q -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x76,0x5c,0x82,0x40]    
vpermi2q 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x76,0x5c,0x82,0xc0]    
vpermi2q -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x76,0x1a]      
vpermi2q (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermi2q (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x76,0x1a]     
vpermi2q (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x76,0x1a]    
vpermi2q (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x76,0x1a]      
vpermi2q (%rdx), %zmm19, %zmm19 

// CHECK: vpermi2q (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x76,0x1a]     
vpermi2q (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x76,0x1a]    
vpermi2q (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermi2q %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x76,0xdb]      
vpermi2q %zmm19, %zmm19, %zmm19 

// CHECK: vpermi2q %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x76,0xdb]     
vpermi2q %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermi2q %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x76,0xdb]    
vpermi2q %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x05,0x5c,0x82,0x40,0x00]      
vpermilpd $0, 4096(%rdx,%rax,4), %zmm19 

// CHECK: vpermilpd $0, -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x05,0x5c,0x82,0xc0,0x00]      
vpermilpd $0, -4096(%rdx,%rax,4), %zmm19 

// CHECK: vpermilpd $0, 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x05,0x5c,0x82,0x40,0x00]     
vpermilpd $0, 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpermilpd $0, -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x05,0x5c,0x82,0xc0,0x00]     
vpermilpd $0, -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpermilpd $0, 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x05,0x5c,0x82,0x40,0x00]    
vpermilpd $0, 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x05,0x5c,0x82,0xc0,0x00]    
vpermilpd $0, -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x05,0x5c,0x02,0x40,0x00]      
vpermilpd $0, 4096(%rdx,%rax), %zmm19 

// CHECK: vpermilpd $0, 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x05,0x5c,0x02,0x40,0x00]     
vpermilpd $0, 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vpermilpd $0, 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x05,0x5c,0x02,0x40,0x00]    
vpermilpd $0, 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x05,0x5a,0x40,0x00]      
vpermilpd $0, 4096(%rdx), %zmm19 

// CHECK: vpermilpd $0, 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x05,0x5a,0x40,0x00]     
vpermilpd $0, 4096(%rdx), %zmm19 {%k2} 

// CHECK: vpermilpd $0, 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x05,0x5a,0x40,0x00]    
vpermilpd $0, 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, 485498096{1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x05,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilpd $0, 485498096{1to8}, %zmm19 

// CHECK: vpermilpd $0, 485498096{1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x05,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilpd $0, 485498096{1to8}, %zmm19 {%k2} 

// CHECK: vpermilpd $0, 485498096{1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x05,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilpd $0, 485498096{1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x05,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilpd $0, 485498096, %zmm19 

// CHECK: vpermilpd $0, 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x05,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilpd $0, 485498096, %zmm19 {%k2} 

// CHECK: vpermilpd $0, 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x05,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilpd $0, 485498096, %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, 512(%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x05,0x5a,0x40,0x00]      
vpermilpd $0, 512(%rdx){1to8}, %zmm19 

// CHECK: vpermilpd $0, 512(%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x05,0x5a,0x40,0x00]     
vpermilpd $0, 512(%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vpermilpd $0, 512(%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x05,0x5a,0x40,0x00]    
vpermilpd $0, 512(%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, 512(%rdx,%rax){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x05,0x5c,0x02,0x40,0x00]      
vpermilpd $0, 512(%rdx,%rax){1to8}, %zmm19 

// CHECK: vpermilpd $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x05,0x5c,0x02,0x40,0x00]     
vpermilpd $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} 

// CHECK: vpermilpd $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x05,0x5c,0x02,0x40,0x00]    
vpermilpd $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x05,0x5c,0x82,0x40,0x00]      
vpermilpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vpermilpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x05,0x5c,0x82,0xc0,0x00]      
vpermilpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vpermilpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x05,0x5c,0x82,0x40,0x00]     
vpermilpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vpermilpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x05,0x5c,0x82,0xc0,0x00]     
vpermilpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vpermilpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x05,0x5c,0x82,0x40,0x00]    
vpermilpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x05,0x5c,0x82,0xc0,0x00]    
vpermilpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, (%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x05,0x1a,0x00]      
vpermilpd $0, (%rdx){1to8}, %zmm19 

// CHECK: vpermilpd $0, (%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x05,0x1a,0x00]     
vpermilpd $0, (%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vpermilpd $0, (%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x05,0x1a,0x00]    
vpermilpd $0, (%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x05,0x1a,0x00]      
vpermilpd $0, (%rdx), %zmm19 

// CHECK: vpermilpd $0, (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x05,0x1a,0x00]     
vpermilpd $0, (%rdx), %zmm19 {%k2} 

// CHECK: vpermilpd $0, (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x05,0x1a,0x00]    
vpermilpd $0, (%rdx), %zmm19 {%k2} {z} 

// CHECK: vpermilpd $0, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0xfd,0x48,0x05,0xdb,0x00]      
vpermilpd $0, %zmm19, %zmm19 

// CHECK: vpermilpd $0, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0xfd,0x4a,0x05,0xdb,0x00]     
vpermilpd $0, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd $0, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0xfd,0xca,0x05,0xdb,0x00]    
vpermilpd $0, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x0d,0x5c,0x82,0x40]      
vpermilpd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermilpd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x0d,0x5c,0x82,0xc0]      
vpermilpd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermilpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x0d,0x5c,0x82,0x40]     
vpermilpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x0d,0x5c,0x82,0xc0]     
vpermilpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x0d,0x5c,0x82,0x40]    
vpermilpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x0d,0x5c,0x82,0xc0]    
vpermilpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x0d,0x5c,0x02,0x40]      
vpermilpd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermilpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x0d,0x5c,0x02,0x40]     
vpermilpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x0d,0x5c,0x02,0x40]    
vpermilpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x0d,0x5a,0x40]      
vpermilpd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermilpd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x0d,0x5a,0x40]     
vpermilpd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x0d,0x5a,0x40]    
vpermilpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x0d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermilpd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpermilpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x0d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermilpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x0d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermilpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x0d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermilpd 485498096, %zmm19, %zmm19 

// CHECK: vpermilpd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x0d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermilpd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x0d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermilpd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x0d,0x5a,0x40]      
vpermilpd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermilpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x0d,0x5a,0x40]     
vpermilpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x0d,0x5a,0x40]    
vpermilpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x0d,0x5c,0x02,0x40]      
vpermilpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpermilpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x0d,0x5c,0x02,0x40]     
vpermilpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x0d,0x5c,0x02,0x40]    
vpermilpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x0d,0x5c,0x82,0x40]      
vpermilpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermilpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x0d,0x5c,0x82,0xc0]      
vpermilpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermilpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x0d,0x5c,0x82,0x40]     
vpermilpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x0d,0x5c,0x82,0xc0]     
vpermilpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x0d,0x5c,0x82,0x40]    
vpermilpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x0d,0x5c,0x82,0xc0]    
vpermilpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x0d,0x1a]      
vpermilpd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermilpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x0d,0x1a]     
vpermilpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x0d,0x1a]    
vpermilpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x0d,0x1a]      
vpermilpd (%rdx), %zmm19, %zmm19 

// CHECK: vpermilpd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x0d,0x1a]     
vpermilpd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x0d,0x1a]    
vpermilpd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilpd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x0d,0xdb]      
vpermilpd %zmm19, %zmm19, %zmm19 

// CHECK: vpermilpd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x0d,0xdb]     
vpermilpd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilpd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x0d,0xdb]    
vpermilpd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, 256(%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x58,0x04,0x5a,0x40,0x00]      
vpermilps $0, 256(%rdx){1to16}, %zmm19 

// CHECK: vpermilps $0, 256(%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x5a,0x04,0x5a,0x40,0x00]     
vpermilps $0, 256(%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vpermilps $0, 256(%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xda,0x04,0x5a,0x40,0x00]    
vpermilps $0, 256(%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, 256(%rdx,%rax){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x58,0x04,0x5c,0x02,0x40,0x00]      
vpermilps $0, 256(%rdx,%rax){1to16}, %zmm19 

// CHECK: vpermilps $0, 256(%rdx,%rax){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x5a,0x04,0x5c,0x02,0x40,0x00]     
vpermilps $0, 256(%rdx,%rax){1to16}, %zmm19 {%k2} 

// CHECK: vpermilps $0, 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xda,0x04,0x5c,0x02,0x40,0x00]    
vpermilps $0, 256(%rdx,%rax){1to16}, %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, 256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x58,0x04,0x5c,0x82,0x40,0x00]      
vpermilps $0, 256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vpermilps $0, -256(%rdx,%rax,4){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x58,0x04,0x5c,0x82,0xc0,0x00]      
vpermilps $0, -256(%rdx,%rax,4){1to16}, %zmm19 

// CHECK: vpermilps $0, 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x5a,0x04,0x5c,0x82,0x40,0x00]     
vpermilps $0, 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vpermilps $0, -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x5a,0x04,0x5c,0x82,0xc0,0x00]     
vpermilps $0, -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} 

// CHECK: vpermilps $0, 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xda,0x04,0x5c,0x82,0x40,0x00]    
vpermilps $0, 256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xda,0x04,0x5c,0x82,0xc0,0x00]    
vpermilps $0, -256(%rdx,%rax,4){1to16}, %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x04,0x5c,0x82,0x40,0x00]      
vpermilps $0, 4096(%rdx,%rax,4), %zmm19 

// CHECK: vpermilps $0, -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x04,0x5c,0x82,0xc0,0x00]      
vpermilps $0, -4096(%rdx,%rax,4), %zmm19 

// CHECK: vpermilps $0, 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x04,0x5c,0x82,0x40,0x00]     
vpermilps $0, 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpermilps $0, -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x04,0x5c,0x82,0xc0,0x00]     
vpermilps $0, -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpermilps $0, 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x04,0x5c,0x82,0x40,0x00]    
vpermilps $0, 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x04,0x5c,0x82,0xc0,0x00]    
vpermilps $0, -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x04,0x5c,0x02,0x40,0x00]      
vpermilps $0, 4096(%rdx,%rax), %zmm19 

// CHECK: vpermilps $0, 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x04,0x5c,0x02,0x40,0x00]     
vpermilps $0, 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vpermilps $0, 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x04,0x5c,0x02,0x40,0x00]    
vpermilps $0, 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x04,0x5a,0x40,0x00]      
vpermilps $0, 4096(%rdx), %zmm19 

// CHECK: vpermilps $0, 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x04,0x5a,0x40,0x00]     
vpermilps $0, 4096(%rdx), %zmm19 {%k2} 

// CHECK: vpermilps $0, 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x04,0x5a,0x40,0x00]    
vpermilps $0, 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, 485498096{1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x58,0x04,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilps $0, 485498096{1to16}, %zmm19 

// CHECK: vpermilps $0, 485498096{1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x5a,0x04,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilps $0, 485498096{1to16}, %zmm19 {%k2} 

// CHECK: vpermilps $0, 485498096{1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xda,0x04,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilps $0, 485498096{1to16}, %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x04,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilps $0, 485498096, %zmm19 

// CHECK: vpermilps $0, 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x04,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilps $0, 485498096, %zmm19 {%k2} 

// CHECK: vpermilps $0, 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x04,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilps $0, 485498096, %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, (%rdx){1to16}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x58,0x04,0x1a,0x00]      
vpermilps $0, (%rdx){1to16}, %zmm19 

// CHECK: vpermilps $0, (%rdx){1to16}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x5a,0x04,0x1a,0x00]     
vpermilps $0, (%rdx){1to16}, %zmm19 {%k2} 

// CHECK: vpermilps $0, (%rdx){1to16}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xda,0x04,0x1a,0x00]    
vpermilps $0, (%rdx){1to16}, %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe3,0x7d,0x48,0x04,0x1a,0x00]      
vpermilps $0, (%rdx), %zmm19 

// CHECK: vpermilps $0, (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0x7d,0x4a,0x04,0x1a,0x00]     
vpermilps $0, (%rdx), %zmm19 {%k2} 

// CHECK: vpermilps $0, (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0x7d,0xca,0x04,0x1a,0x00]    
vpermilps $0, (%rdx), %zmm19 {%k2} {z} 

// CHECK: vpermilps $0, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0x7d,0x48,0x04,0xdb,0x00]      
vpermilps $0, %zmm19, %zmm19 

// CHECK: vpermilps $0, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0x7d,0x4a,0x04,0xdb,0x00]     
vpermilps $0, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps $0, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0x7d,0xca,0x04,0xdb,0x00]    
vpermilps $0, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x0c,0x5a,0x40]      
vpermilps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermilps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x0c,0x5a,0x40]     
vpermilps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x0c,0x5a,0x40]    
vpermilps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x0c,0x5c,0x02,0x40]      
vpermilps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpermilps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x0c,0x5c,0x02,0x40]     
vpermilps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x0c,0x5c,0x02,0x40]    
vpermilps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x0c,0x5c,0x82,0x40]      
vpermilps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermilps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x0c,0x5c,0x82,0xc0]      
vpermilps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermilps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x0c,0x5c,0x82,0x40]     
vpermilps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x0c,0x5c,0x82,0xc0]     
vpermilps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x0c,0x5c,0x82,0x40]    
vpermilps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x0c,0x5c,0x82,0xc0]    
vpermilps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x0c,0x5c,0x82,0x40]      
vpermilps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermilps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x0c,0x5c,0x82,0xc0]      
vpermilps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermilps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x0c,0x5c,0x82,0x40]     
vpermilps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x0c,0x5c,0x82,0xc0]     
vpermilps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x0c,0x5c,0x82,0x40]    
vpermilps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x0c,0x5c,0x82,0xc0]    
vpermilps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x0c,0x5c,0x02,0x40]      
vpermilps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermilps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x0c,0x5c,0x02,0x40]     
vpermilps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x0c,0x5c,0x02,0x40]    
vpermilps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x0c,0x5a,0x40]      
vpermilps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermilps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x0c,0x5a,0x40]     
vpermilps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x0c,0x5a,0x40]    
vpermilps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x0c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermilps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpermilps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x0c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermilps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x0c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermilps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x0c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermilps 485498096, %zmm19, %zmm19 

// CHECK: vpermilps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x0c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermilps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x0c,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermilps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x0c,0x1a]      
vpermilps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermilps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x0c,0x1a]     
vpermilps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x0c,0x1a]    
vpermilps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x0c,0x1a]      
vpermilps (%rdx), %zmm19, %zmm19 

// CHECK: vpermilps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x0c,0x1a]     
vpermilps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x0c,0x1a]    
vpermilps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermilps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x0c,0xdb]      
vpermilps %zmm19, %zmm19, %zmm19 

// CHECK: vpermilps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x0c,0xdb]     
vpermilps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermilps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x0c,0xdb]    
vpermilps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x01,0x5c,0x82,0x40,0x00]      
vpermpd $0, 4096(%rdx,%rax,4), %zmm19 

// CHECK: vpermpd $0, -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x01,0x5c,0x82,0xc0,0x00]      
vpermpd $0, -4096(%rdx,%rax,4), %zmm19 

// CHECK: vpermpd $0, 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x01,0x5c,0x82,0x40,0x00]     
vpermpd $0, 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpermpd $0, -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x01,0x5c,0x82,0xc0,0x00]     
vpermpd $0, -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpermpd $0, 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x01,0x5c,0x82,0x40,0x00]    
vpermpd $0, 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x01,0x5c,0x82,0xc0,0x00]    
vpermpd $0, -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x01,0x5c,0x02,0x40,0x00]      
vpermpd $0, 4096(%rdx,%rax), %zmm19 

// CHECK: vpermpd $0, 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x01,0x5c,0x02,0x40,0x00]     
vpermpd $0, 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vpermpd $0, 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x01,0x5c,0x02,0x40,0x00]    
vpermpd $0, 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x01,0x5a,0x40,0x00]      
vpermpd $0, 4096(%rdx), %zmm19 

// CHECK: vpermpd $0, 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x01,0x5a,0x40,0x00]     
vpermpd $0, 4096(%rdx), %zmm19 {%k2} 

// CHECK: vpermpd $0, 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x01,0x5a,0x40,0x00]    
vpermpd $0, 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, 485498096{1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x01,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermpd $0, 485498096{1to8}, %zmm19 

// CHECK: vpermpd $0, 485498096{1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x01,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermpd $0, 485498096{1to8}, %zmm19 {%k2} 

// CHECK: vpermpd $0, 485498096{1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x01,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermpd $0, 485498096{1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x01,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermpd $0, 485498096, %zmm19 

// CHECK: vpermpd $0, 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x01,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermpd $0, 485498096, %zmm19 {%k2} 

// CHECK: vpermpd $0, 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x01,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermpd $0, 485498096, %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, 512(%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x01,0x5a,0x40,0x00]      
vpermpd $0, 512(%rdx){1to8}, %zmm19 

// CHECK: vpermpd $0, 512(%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x01,0x5a,0x40,0x00]     
vpermpd $0, 512(%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vpermpd $0, 512(%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x01,0x5a,0x40,0x00]    
vpermpd $0, 512(%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, 512(%rdx,%rax){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x01,0x5c,0x02,0x40,0x00]      
vpermpd $0, 512(%rdx,%rax){1to8}, %zmm19 

// CHECK: vpermpd $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x01,0x5c,0x02,0x40,0x00]     
vpermpd $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} 

// CHECK: vpermpd $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x01,0x5c,0x02,0x40,0x00]    
vpermpd $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x01,0x5c,0x82,0x40,0x00]      
vpermpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vpermpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x01,0x5c,0x82,0xc0,0x00]      
vpermpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vpermpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x01,0x5c,0x82,0x40,0x00]     
vpermpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vpermpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x01,0x5c,0x82,0xc0,0x00]     
vpermpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vpermpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x01,0x5c,0x82,0x40,0x00]    
vpermpd $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x01,0x5c,0x82,0xc0,0x00]    
vpermpd $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, (%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x01,0x1a,0x00]      
vpermpd $0, (%rdx){1to8}, %zmm19 

// CHECK: vpermpd $0, (%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x01,0x1a,0x00]     
vpermpd $0, (%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vpermpd $0, (%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x01,0x1a,0x00]    
vpermpd $0, (%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x01,0x1a,0x00]      
vpermpd $0, (%rdx), %zmm19 

// CHECK: vpermpd $0, (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x01,0x1a,0x00]     
vpermpd $0, (%rdx), %zmm19 {%k2} 

// CHECK: vpermpd $0, (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x01,0x1a,0x00]    
vpermpd $0, (%rdx), %zmm19 {%k2} {z} 

// CHECK: vpermpd $0, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0xfd,0x48,0x01,0xdb,0x00]      
vpermpd $0, %zmm19, %zmm19 

// CHECK: vpermpd $0, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0xfd,0x4a,0x01,0xdb,0x00]     
vpermpd $0, %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd $0, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0xfd,0xca,0x01,0xdb,0x00]    
vpermpd $0, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x16,0x5c,0x82,0x40]      
vpermpd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermpd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x16,0x5c,0x82,0xc0]      
vpermpd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x16,0x5c,0x82,0x40]     
vpermpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x16,0x5c,0x82,0xc0]     
vpermpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x16,0x5c,0x82,0x40]    
vpermpd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x16,0x5c,0x82,0xc0]    
vpermpd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x16,0x5c,0x02,0x40]      
vpermpd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x16,0x5c,0x02,0x40]     
vpermpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x16,0x5c,0x02,0x40]    
vpermpd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x16,0x5a,0x40]      
vpermpd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermpd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x16,0x5a,0x40]     
vpermpd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x16,0x5a,0x40]    
vpermpd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermpd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpermpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermpd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermpd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermpd 485498096, %zmm19, %zmm19 

// CHECK: vpermpd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermpd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermpd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x16,0x5a,0x40]      
vpermpd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x16,0x5a,0x40]     
vpermpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x16,0x5a,0x40]    
vpermpd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x16,0x5c,0x02,0x40]      
vpermpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpermpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x16,0x5c,0x02,0x40]     
vpermpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x16,0x5c,0x02,0x40]    
vpermpd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x16,0x5c,0x82,0x40]      
vpermpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x16,0x5c,0x82,0xc0]      
vpermpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x16,0x5c,0x82,0x40]     
vpermpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x16,0x5c,0x82,0xc0]     
vpermpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x16,0x5c,0x82,0x40]    
vpermpd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x16,0x5c,0x82,0xc0]    
vpermpd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x16,0x1a]      
vpermpd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x16,0x1a]     
vpermpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x16,0x1a]    
vpermpd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x16,0x1a]      
vpermpd (%rdx), %zmm19, %zmm19 

// CHECK: vpermpd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x16,0x1a]     
vpermpd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x16,0x1a]    
vpermpd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermpd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x16,0xdb]      
vpermpd %zmm19, %zmm19, %zmm19 

// CHECK: vpermpd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x16,0xdb]     
vpermpd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermpd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x16,0xdb]    
vpermpd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x16,0x5a,0x40]      
vpermps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x16,0x5a,0x40]     
vpermps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x16,0x5a,0x40]    
vpermps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x16,0x5c,0x02,0x40]      
vpermps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpermps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x16,0x5c,0x02,0x40]     
vpermps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x16,0x5c,0x02,0x40]    
vpermps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x16,0x5c,0x82,0x40]      
vpermps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x16,0x5c,0x82,0xc0]      
vpermps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x16,0x5c,0x82,0x40]     
vpermps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x16,0x5c,0x82,0xc0]     
vpermps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x16,0x5c,0x82,0x40]    
vpermps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x16,0x5c,0x82,0xc0]    
vpermps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x16,0x5c,0x82,0x40]      
vpermps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x16,0x5c,0x82,0xc0]      
vpermps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x16,0x5c,0x82,0x40]     
vpermps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x16,0x5c,0x82,0xc0]     
vpermps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x16,0x5c,0x82,0x40]    
vpermps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x16,0x5c,0x82,0xc0]    
vpermps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x16,0x5c,0x02,0x40]      
vpermps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x16,0x5c,0x02,0x40]     
vpermps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x16,0x5c,0x02,0x40]    
vpermps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x16,0x5a,0x40]      
vpermps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x16,0x5a,0x40]     
vpermps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x16,0x5a,0x40]    
vpermps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpermps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermps 485498096, %zmm19, %zmm19 

// CHECK: vpermps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x16,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x16,0x1a]      
vpermps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x16,0x1a]     
vpermps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x16,0x1a]    
vpermps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x16,0x1a]      
vpermps (%rdx), %zmm19, %zmm19 

// CHECK: vpermps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x16,0x1a]     
vpermps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x16,0x1a]    
vpermps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x16,0xdb]      
vpermps %zmm19, %zmm19, %zmm19 

// CHECK: vpermps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x16,0xdb]     
vpermps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x16,0xdb]    
vpermps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq $0, 4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x00,0x5c,0x82,0x40,0x00]      
vpermq $0, 4096(%rdx,%rax,4), %zmm19 

// CHECK: vpermq $0, -4096(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x00,0x5c,0x82,0xc0,0x00]      
vpermq $0, -4096(%rdx,%rax,4), %zmm19 

// CHECK: vpermq $0, 4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x00,0x5c,0x82,0x40,0x00]     
vpermq $0, 4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpermq $0, -4096(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x00,0x5c,0x82,0xc0,0x00]     
vpermq $0, -4096(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpermq $0, 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x00,0x5c,0x82,0x40,0x00]    
vpermq $0, 4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpermq $0, -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x00,0x5c,0x82,0xc0,0x00]    
vpermq $0, -4096(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpermq $0, 4096(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x00,0x5c,0x02,0x40,0x00]      
vpermq $0, 4096(%rdx,%rax), %zmm19 

// CHECK: vpermq $0, 4096(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x00,0x5c,0x02,0x40,0x00]     
vpermq $0, 4096(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vpermq $0, 4096(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x00,0x5c,0x02,0x40,0x00]    
vpermq $0, 4096(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vpermq $0, 4096(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x00,0x5a,0x40,0x00]      
vpermq $0, 4096(%rdx), %zmm19 

// CHECK: vpermq $0, 4096(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x00,0x5a,0x40,0x00]     
vpermq $0, 4096(%rdx), %zmm19 {%k2} 

// CHECK: vpermq $0, 4096(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x00,0x5a,0x40,0x00]    
vpermq $0, 4096(%rdx), %zmm19 {%k2} {z} 

// CHECK: vpermq $0, 485498096{1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x00,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermq $0, 485498096{1to8}, %zmm19 

// CHECK: vpermq $0, 485498096{1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x00,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermq $0, 485498096{1to8}, %zmm19 {%k2} 

// CHECK: vpermq $0, 485498096{1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x00,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermq $0, 485498096{1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermq $0, 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x00,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermq $0, 485498096, %zmm19 

// CHECK: vpermq $0, 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x00,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermq $0, 485498096, %zmm19 {%k2} 

// CHECK: vpermq $0, 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x00,0x1c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermq $0, 485498096, %zmm19 {%k2} {z} 

// CHECK: vpermq $0, 512(%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x00,0x5a,0x40,0x00]      
vpermq $0, 512(%rdx){1to8}, %zmm19 

// CHECK: vpermq $0, 512(%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x00,0x5a,0x40,0x00]     
vpermq $0, 512(%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vpermq $0, 512(%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x00,0x5a,0x40,0x00]    
vpermq $0, 512(%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermq $0, 512(%rdx,%rax){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x00,0x5c,0x02,0x40,0x00]      
vpermq $0, 512(%rdx,%rax){1to8}, %zmm19 

// CHECK: vpermq $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x00,0x5c,0x02,0x40,0x00]     
vpermq $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} 

// CHECK: vpermq $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x00,0x5c,0x02,0x40,0x00]    
vpermq $0, 512(%rdx,%rax){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermq $0, 512(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x00,0x5c,0x82,0x40,0x00]      
vpermq $0, 512(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vpermq $0, -512(%rdx,%rax,4){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x00,0x5c,0x82,0xc0,0x00]      
vpermq $0, -512(%rdx,%rax,4){1to8}, %zmm19 

// CHECK: vpermq $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x00,0x5c,0x82,0x40,0x00]     
vpermq $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vpermq $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x00,0x5c,0x82,0xc0,0x00]     
vpermq $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} 

// CHECK: vpermq $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x00,0x5c,0x82,0x40,0x00]    
vpermq $0, 512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermq $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x00,0x5c,0x82,0xc0,0x00]    
vpermq $0, -512(%rdx,%rax,4){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermq $0, (%rdx){1to8}, %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x58,0x00,0x1a,0x00]      
vpermq $0, (%rdx){1to8}, %zmm19 

// CHECK: vpermq $0, (%rdx){1to8}, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x5a,0x00,0x1a,0x00]     
vpermq $0, (%rdx){1to8}, %zmm19 {%k2} 

// CHECK: vpermq $0, (%rdx){1to8}, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xda,0x00,0x1a,0x00]    
vpermq $0, (%rdx){1to8}, %zmm19 {%k2} {z} 

// CHECK: vpermq $0, (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe3,0xfd,0x48,0x00,0x1a,0x00]      
vpermq $0, (%rdx), %zmm19 

// CHECK: vpermq $0, (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe3,0xfd,0x4a,0x00,0x1a,0x00]     
vpermq $0, (%rdx), %zmm19 {%k2} 

// CHECK: vpermq $0, (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe3,0xfd,0xca,0x00,0x1a,0x00]    
vpermq $0, (%rdx), %zmm19 {%k2} {z} 

// CHECK: vpermq $0, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa3,0xfd,0x48,0x00,0xdb,0x00]      
vpermq $0, %zmm19, %zmm19 

// CHECK: vpermq $0, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa3,0xfd,0x4a,0x00,0xdb,0x00]     
vpermq $0, %zmm19, %zmm19 {%k2} 

// CHECK: vpermq $0, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa3,0xfd,0xca,0x00,0xdb,0x00]    
vpermq $0, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x36,0x5c,0x82,0x40]      
vpermq 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermq -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x36,0x5c,0x82,0xc0]      
vpermq -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x36,0x5c,0x82,0x40]     
vpermq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x36,0x5c,0x82,0xc0]     
vpermq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x36,0x5c,0x82,0x40]    
vpermq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x36,0x5c,0x82,0xc0]    
vpermq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x36,0x5c,0x02,0x40]      
vpermq 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x36,0x5c,0x02,0x40]     
vpermq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x36,0x5c,0x02,0x40]    
vpermq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x36,0x5a,0x40]      
vpermq 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermq 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x36,0x5a,0x40]     
vpermq 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x36,0x5a,0x40]    
vpermq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x36,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermq 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpermq 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x36,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermq 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x36,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x36,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermq 485498096, %zmm19, %zmm19 

// CHECK: vpermq 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x36,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermq 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermq 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x36,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermq 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x36,0x5a,0x40]      
vpermq 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x36,0x5a,0x40]     
vpermq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x36,0x5a,0x40]    
vpermq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x36,0x5c,0x02,0x40]      
vpermq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpermq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x36,0x5c,0x02,0x40]     
vpermq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x36,0x5c,0x02,0x40]    
vpermq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x36,0x5c,0x82,0x40]      
vpermq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x36,0x5c,0x82,0xc0]      
vpermq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x36,0x5c,0x82,0x40]     
vpermq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x36,0x5c,0x82,0xc0]     
vpermq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x36,0x5c,0x82,0x40]    
vpermq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x36,0x5c,0x82,0xc0]    
vpermq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x36,0x1a]      
vpermq (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x36,0x1a]     
vpermq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x36,0x1a]    
vpermq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x36,0x1a]      
vpermq (%rdx), %zmm19, %zmm19 

// CHECK: vpermq (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x36,0x1a]     
vpermq (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermq (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x36,0x1a]    
vpermq (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermq %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x36,0xdb]      
vpermq %zmm19, %zmm19, %zmm19 

// CHECK: vpermq %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x36,0xdb]     
vpermq %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermq %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x36,0xdb]    
vpermq %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x7e,0x5a,0x40]      
vpermt2d 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermt2d 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x7e,0x5a,0x40]     
vpermt2d 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x7e,0x5a,0x40]    
vpermt2d 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x7e,0x5c,0x02,0x40]      
vpermt2d 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpermt2d 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x7e,0x5c,0x02,0x40]     
vpermt2d 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x7e,0x5c,0x02,0x40]    
vpermt2d 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x7e,0x5c,0x82,0x40]      
vpermt2d 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermt2d -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x7e,0x5c,0x82,0xc0]      
vpermt2d -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermt2d 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x7e,0x5c,0x82,0x40]     
vpermt2d 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x7e,0x5c,0x82,0xc0]     
vpermt2d -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x7e,0x5c,0x82,0x40]    
vpermt2d 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x7e,0x5c,0x82,0xc0]    
vpermt2d -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x7e,0x5c,0x82,0x40]      
vpermt2d 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermt2d -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x7e,0x5c,0x82,0xc0]      
vpermt2d -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermt2d 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x7e,0x5c,0x82,0x40]     
vpermt2d 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x7e,0x5c,0x82,0xc0]     
vpermt2d -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x7e,0x5c,0x82,0x40]    
vpermt2d 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x7e,0x5c,0x82,0xc0]    
vpermt2d -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x7e,0x5c,0x02,0x40]      
vpermt2d 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermt2d 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x7e,0x5c,0x02,0x40]     
vpermt2d 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x7e,0x5c,0x02,0x40]    
vpermt2d 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x7e,0x5a,0x40]      
vpermt2d 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermt2d 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x7e,0x5a,0x40]     
vpermt2d 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x7e,0x5a,0x40]    
vpermt2d 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x7e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermt2d 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpermt2d 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x7e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermt2d 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x7e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermt2d 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x7e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermt2d 485498096, %zmm19, %zmm19 

// CHECK: vpermt2d 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x7e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermt2d 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x7e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermt2d 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x7e,0x1a]      
vpermt2d (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermt2d (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x7e,0x1a]     
vpermt2d (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x7e,0x1a]    
vpermt2d (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x7e,0x1a]      
vpermt2d (%rdx), %zmm19, %zmm19 

// CHECK: vpermt2d (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x7e,0x1a]     
vpermt2d (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x7e,0x1a]    
vpermt2d (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2d %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x7e,0xdb]      
vpermt2d %zmm19, %zmm19, %zmm19 

// CHECK: vpermt2d %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x7e,0xdb]     
vpermt2d %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2d %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x7e,0xdb]    
vpermt2d %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x7f,0x5c,0x82,0x40]      
vpermt2pd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermt2pd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x7f,0x5c,0x82,0xc0]      
vpermt2pd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermt2pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x7f,0x5c,0x82,0x40]     
vpermt2pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x7f,0x5c,0x82,0xc0]     
vpermt2pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x7f,0x5c,0x82,0x40]    
vpermt2pd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x7f,0x5c,0x82,0xc0]    
vpermt2pd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x7f,0x5c,0x02,0x40]      
vpermt2pd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermt2pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x7f,0x5c,0x02,0x40]     
vpermt2pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x7f,0x5c,0x02,0x40]    
vpermt2pd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x7f,0x5a,0x40]      
vpermt2pd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermt2pd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x7f,0x5a,0x40]     
vpermt2pd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x7f,0x5a,0x40]    
vpermt2pd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermt2pd 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpermt2pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermt2pd 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermt2pd 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermt2pd 485498096, %zmm19, %zmm19 

// CHECK: vpermt2pd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermt2pd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermt2pd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x7f,0x5a,0x40]      
vpermt2pd 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermt2pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x7f,0x5a,0x40]     
vpermt2pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x7f,0x5a,0x40]    
vpermt2pd 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x7f,0x5c,0x02,0x40]      
vpermt2pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpermt2pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x7f,0x5c,0x02,0x40]     
vpermt2pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x7f,0x5c,0x02,0x40]    
vpermt2pd 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x7f,0x5c,0x82,0x40]      
vpermt2pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermt2pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x7f,0x5c,0x82,0xc0]      
vpermt2pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermt2pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x7f,0x5c,0x82,0x40]     
vpermt2pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x7f,0x5c,0x82,0xc0]     
vpermt2pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x7f,0x5c,0x82,0x40]    
vpermt2pd 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x7f,0x5c,0x82,0xc0]    
vpermt2pd -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x7f,0x1a]      
vpermt2pd (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermt2pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x7f,0x1a]     
vpermt2pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x7f,0x1a]    
vpermt2pd (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x7f,0x1a]      
vpermt2pd (%rdx), %zmm19, %zmm19 

// CHECK: vpermt2pd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x7f,0x1a]     
vpermt2pd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x7f,0x1a]    
vpermt2pd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2pd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x7f,0xdb]      
vpermt2pd %zmm19, %zmm19, %zmm19 

// CHECK: vpermt2pd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x7f,0xdb]     
vpermt2pd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2pd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x7f,0xdb]    
vpermt2pd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x7f,0x5a,0x40]      
vpermt2ps 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermt2ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x7f,0x5a,0x40]     
vpermt2ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x7f,0x5a,0x40]    
vpermt2ps 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x7f,0x5c,0x02,0x40]      
vpermt2ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpermt2ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x7f,0x5c,0x02,0x40]     
vpermt2ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x7f,0x5c,0x02,0x40]    
vpermt2ps 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x7f,0x5c,0x82,0x40]      
vpermt2ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermt2ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x7f,0x5c,0x82,0xc0]      
vpermt2ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpermt2ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x7f,0x5c,0x82,0x40]     
vpermt2ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x7f,0x5c,0x82,0xc0]     
vpermt2ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x7f,0x5c,0x82,0x40]    
vpermt2ps 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x7f,0x5c,0x82,0xc0]    
vpermt2ps -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x7f,0x5c,0x82,0x40]      
vpermt2ps 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermt2ps -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x7f,0x5c,0x82,0xc0]      
vpermt2ps -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermt2ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x7f,0x5c,0x82,0x40]     
vpermt2ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x7f,0x5c,0x82,0xc0]     
vpermt2ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x7f,0x5c,0x82,0x40]    
vpermt2ps 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x7f,0x5c,0x82,0xc0]    
vpermt2ps -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x7f,0x5c,0x02,0x40]      
vpermt2ps 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermt2ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x7f,0x5c,0x02,0x40]     
vpermt2ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x7f,0x5c,0x02,0x40]    
vpermt2ps 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x7f,0x5a,0x40]      
vpermt2ps 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermt2ps 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x7f,0x5a,0x40]     
vpermt2ps 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x7f,0x5a,0x40]    
vpermt2ps 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermt2ps 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpermt2ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermt2ps 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermt2ps 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermt2ps 485498096, %zmm19, %zmm19 

// CHECK: vpermt2ps 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermt2ps 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x7f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermt2ps 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x7f,0x1a]      
vpermt2ps (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpermt2ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x7f,0x1a]     
vpermt2ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x7f,0x1a]    
vpermt2ps (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x7f,0x1a]      
vpermt2ps (%rdx), %zmm19, %zmm19 

// CHECK: vpermt2ps (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x7f,0x1a]     
vpermt2ps (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x7f,0x1a]    
vpermt2ps (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2ps %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x7f,0xdb]      
vpermt2ps %zmm19, %zmm19, %zmm19 

// CHECK: vpermt2ps %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x7f,0xdb]     
vpermt2ps %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2ps %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x7f,0xdb]    
vpermt2ps %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x7e,0x5c,0x82,0x40]      
vpermt2q 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermt2q -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x7e,0x5c,0x82,0xc0]      
vpermt2q -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpermt2q 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x7e,0x5c,0x82,0x40]     
vpermt2q 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x7e,0x5c,0x82,0xc0]     
vpermt2q -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x7e,0x5c,0x82,0x40]    
vpermt2q 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x7e,0x5c,0x82,0xc0]    
vpermt2q -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x7e,0x5c,0x02,0x40]      
vpermt2q 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpermt2q 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x7e,0x5c,0x02,0x40]     
vpermt2q 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x7e,0x5c,0x02,0x40]    
vpermt2q 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x7e,0x5a,0x40]      
vpermt2q 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpermt2q 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x7e,0x5a,0x40]     
vpermt2q 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x7e,0x5a,0x40]    
vpermt2q 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x7e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermt2q 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpermt2q 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x7e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermt2q 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x7e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermt2q 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x7e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpermt2q 485498096, %zmm19, %zmm19 

// CHECK: vpermt2q 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x7e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpermt2q 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x7e,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpermt2q 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x7e,0x5a,0x40]      
vpermt2q 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermt2q 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x7e,0x5a,0x40]     
vpermt2q 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x7e,0x5a,0x40]    
vpermt2q 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x7e,0x5c,0x02,0x40]      
vpermt2q 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpermt2q 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x7e,0x5c,0x02,0x40]     
vpermt2q 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x7e,0x5c,0x02,0x40]    
vpermt2q 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x7e,0x5c,0x82,0x40]      
vpermt2q 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermt2q -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x7e,0x5c,0x82,0xc0]      
vpermt2q -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpermt2q 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x7e,0x5c,0x82,0x40]     
vpermt2q 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x7e,0x5c,0x82,0xc0]     
vpermt2q -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x7e,0x5c,0x82,0x40]    
vpermt2q 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x7e,0x5c,0x82,0xc0]    
vpermt2q -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x7e,0x1a]      
vpermt2q (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpermt2q (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x7e,0x1a]     
vpermt2q (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x7e,0x1a]    
vpermt2q (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x7e,0x1a]      
vpermt2q (%rdx), %zmm19, %zmm19 

// CHECK: vpermt2q (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x7e,0x1a]     
vpermt2q (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x7e,0x1a]    
vpermt2q (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpermt2q %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x7e,0xdb]      
vpermt2q %zmm19, %zmm19, %zmm19 

// CHECK: vpermt2q %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x7e,0xdb]     
vpermt2q %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpermt2q %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x7e,0xdb]    
vpermt2q %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpexpandd 256(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x89,0x5c,0x82,0x40]       
vpexpandd 256(%rdx,%rax,4), %zmm19 

// CHECK: vpexpandd -256(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x89,0x5c,0x82,0xc0]       
vpexpandd -256(%rdx,%rax,4), %zmm19 

// CHECK: vpexpandd 256(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x89,0x5c,0x82,0x40]      
vpexpandd 256(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpexpandd -256(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x89,0x5c,0x82,0xc0]      
vpexpandd -256(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpexpandd 256(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x89,0x5c,0x82,0x40]     
vpexpandd 256(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpexpandd -256(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x89,0x5c,0x82,0xc0]     
vpexpandd -256(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpexpandd 256(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x89,0x5c,0x02,0x40]       
vpexpandd 256(%rdx,%rax), %zmm19 

// CHECK: vpexpandd 256(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x89,0x5c,0x02,0x40]      
vpexpandd 256(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vpexpandd 256(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x89,0x5c,0x02,0x40]     
vpexpandd 256(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vpexpandd 256(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x89,0x5a,0x40]       
vpexpandd 256(%rdx), %zmm19 

// CHECK: vpexpandd 256(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x89,0x5a,0x40]      
vpexpandd 256(%rdx), %zmm19 {%k2} 

// CHECK: vpexpandd 256(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x89,0x5a,0x40]     
vpexpandd 256(%rdx), %zmm19 {%k2} {z} 

// CHECK: vpexpandd 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x89,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpexpandd 485498096, %zmm19 

// CHECK: vpexpandd 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x89,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpexpandd 485498096, %zmm19 {%k2} 

// CHECK: vpexpandd 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x89,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpexpandd 485498096, %zmm19 {%k2} {z} 

// CHECK: vpexpandd (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x89,0x1a]       
vpexpandd (%rdx), %zmm19 

// CHECK: vpexpandd (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x89,0x1a]      
vpexpandd (%rdx), %zmm19 {%k2} 

// CHECK: vpexpandd (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7d,0xca,0x89,0x1a]     
vpexpandd (%rdx), %zmm19 {%k2} {z} 

// CHECK: vpexpandd %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x7d,0x48,0x89,0xdb]       
vpexpandd %zmm19, %zmm19 

// CHECK: vpexpandd %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x89,0xdb]      
vpexpandd %zmm19, %zmm19 {%k2} 

// CHECK: vpexpandd %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x7d,0xca,0x89,0xdb]     
vpexpandd %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpexpandq 485498096, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x89,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpexpandq 485498096, %zmm19 

// CHECK: vpexpandq 485498096, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x89,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpexpandq 485498096, %zmm19 {%k2} 

// CHECK: vpexpandq 485498096, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x89,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpexpandq 485498096, %zmm19 {%k2} {z} 

// CHECK: vpexpandq 512(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x89,0x5c,0x82,0x40]       
vpexpandq 512(%rdx,%rax,4), %zmm19 

// CHECK: vpexpandq -512(%rdx,%rax,4), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x89,0x5c,0x82,0xc0]       
vpexpandq -512(%rdx,%rax,4), %zmm19 

// CHECK: vpexpandq 512(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x89,0x5c,0x82,0x40]      
vpexpandq 512(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpexpandq -512(%rdx,%rax,4), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x89,0x5c,0x82,0xc0]      
vpexpandq -512(%rdx,%rax,4), %zmm19 {%k2} 

// CHECK: vpexpandq 512(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x89,0x5c,0x82,0x40]     
vpexpandq 512(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpexpandq -512(%rdx,%rax,4), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x89,0x5c,0x82,0xc0]     
vpexpandq -512(%rdx,%rax,4), %zmm19 {%k2} {z} 

// CHECK: vpexpandq 512(%rdx,%rax), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x89,0x5c,0x02,0x40]       
vpexpandq 512(%rdx,%rax), %zmm19 

// CHECK: vpexpandq 512(%rdx,%rax), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x89,0x5c,0x02,0x40]      
vpexpandq 512(%rdx,%rax), %zmm19 {%k2} 

// CHECK: vpexpandq 512(%rdx,%rax), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x89,0x5c,0x02,0x40]     
vpexpandq 512(%rdx,%rax), %zmm19 {%k2} {z} 

// CHECK: vpexpandq 512(%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x89,0x5a,0x40]       
vpexpandq 512(%rdx), %zmm19 

// CHECK: vpexpandq 512(%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x89,0x5a,0x40]      
vpexpandq 512(%rdx), %zmm19 {%k2} 

// CHECK: vpexpandq 512(%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x89,0x5a,0x40]     
vpexpandq 512(%rdx), %zmm19 {%k2} {z} 

// CHECK: vpexpandq (%rdx), %zmm19 
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x89,0x1a]       
vpexpandq (%rdx), %zmm19 

// CHECK: vpexpandq (%rdx), %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x89,0x1a]      
vpexpandq (%rdx), %zmm19 {%k2} 

// CHECK: vpexpandq (%rdx), %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xfd,0xca,0x89,0x1a]     
vpexpandq (%rdx), %zmm19 {%k2} {z} 

// CHECK: vpexpandq %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xfd,0x48,0x89,0xdb]       
vpexpandq %zmm19, %zmm19 

// CHECK: vpexpandq %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x89,0xdb]      
vpexpandq %zmm19, %zmm19 {%k2} 

// CHECK: vpexpandq %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xfd,0xca,0x89,0xdb]     
vpexpandq %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpgatherdd 256(%rdx,%zmm3,4), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4b,0x90,0x5c,0x9a,0x40]      
vpgatherdd 256(%rdx,%zmm3,4), %zmm19 {%k3} 

// CHECK: vpgatherdd -256(%rdx,%zmm3,4), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4b,0x90,0x5c,0x9a,0xc0]      
vpgatherdd -256(%rdx,%zmm3,4), %zmm19 {%k3} 

// CHECK: vpgatherdd 256(%rdx,%zmm3), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4b,0x90,0x5c,0x1a,0x40]      
vpgatherdd 256(%rdx,%zmm3), %zmm19 {%k3} 

// CHECK: vpgatherdq 512(%rdx,%ymm3,4), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4b,0x90,0x5c,0x9a,0x40]      
vpgatherdq 512(%rdx,%ymm3,4), %zmm19 {%k3} 

// CHECK: vpgatherdq -512(%rdx,%ymm3,4), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4b,0x90,0x5c,0x9a,0xc0]      
vpgatherdq -512(%rdx,%ymm3,4), %zmm19 {%k3} 

// CHECK: vpgatherdq 512(%rdx,%ymm3), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4b,0x90,0x5c,0x1a,0x40]      
vpgatherdq 512(%rdx,%ymm3), %zmm19 {%k3} 

// CHECK: vpgatherqd 256(%rdx,%zmm3,4), %ymm23 {%k3} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4b,0x91,0x7c,0x9a,0x40]      
vpgatherqd 256(%rdx,%zmm3,4), %ymm23 {%k3} 

// CHECK: vpgatherqd -256(%rdx,%zmm3,4), %ymm23 {%k3} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4b,0x91,0x7c,0x9a,0xc0]      
vpgatherqd -256(%rdx,%zmm3,4), %ymm23 {%k3} 

// CHECK: vpgatherqd 256(%rdx,%zmm3), %ymm23 {%k3} 
// CHECK: encoding: [0x62,0xe2,0x7d,0x4b,0x91,0x7c,0x1a,0x40]      
vpgatherqd 256(%rdx,%zmm3), %ymm23 {%k3} 

// CHECK: vpgatherqq 512(%rdx,%zmm3,4), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4b,0x91,0x5c,0x9a,0x40]      
vpgatherqq 512(%rdx,%zmm3,4), %zmm19 {%k3} 

// CHECK: vpgatherqq -512(%rdx,%zmm3,4), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4b,0x91,0x5c,0x9a,0xc0]      
vpgatherqq -512(%rdx,%zmm3,4), %zmm19 {%k3} 

// CHECK: vpgatherqq 512(%rdx,%zmm3), %zmm19 {%k3} 
// CHECK: encoding: [0x62,0xe2,0xfd,0x4b,0x91,0x5c,0x1a,0x40]      
vpgatherqq 512(%rdx,%zmm3), %zmm19 {%k3} 

// CHECK: vpmaxsd 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3d,0x5a,0x40]      
vpmaxsd 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpmaxsd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3d,0x5a,0x40]     
vpmaxsd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3d,0x5a,0x40]    
vpmaxsd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3d,0x5c,0x02,0x40]      
vpmaxsd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpmaxsd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3d,0x5c,0x02,0x40]     
vpmaxsd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3d,0x5c,0x02,0x40]    
vpmaxsd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3d,0x5c,0x82,0x40]      
vpmaxsd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpmaxsd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3d,0x5c,0x82,0xc0]      
vpmaxsd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpmaxsd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3d,0x5c,0x82,0x40]     
vpmaxsd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3d,0x5c,0x82,0xc0]     
vpmaxsd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3d,0x5c,0x82,0x40]    
vpmaxsd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3d,0x5c,0x82,0xc0]    
vpmaxsd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3d,0x5c,0x82,0x40]      
vpmaxsd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpmaxsd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3d,0x5c,0x82,0xc0]      
vpmaxsd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpmaxsd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3d,0x5c,0x82,0x40]     
vpmaxsd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3d,0x5c,0x82,0xc0]     
vpmaxsd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3d,0x5c,0x82,0x40]    
vpmaxsd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3d,0x5c,0x82,0xc0]    
vpmaxsd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3d,0x5c,0x02,0x40]      
vpmaxsd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpmaxsd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3d,0x5c,0x02,0x40]     
vpmaxsd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3d,0x5c,0x02,0x40]    
vpmaxsd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3d,0x5a,0x40]      
vpmaxsd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpmaxsd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3d,0x5a,0x40]     
vpmaxsd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3d,0x5a,0x40]    
vpmaxsd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsd 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpmaxsd 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpmaxsd 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpmaxsd 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpmaxsd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpmaxsd 485498096, %zmm19, %zmm19 

// CHECK: vpmaxsd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpmaxsd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpmaxsd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsd (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3d,0x1a]      
vpmaxsd (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpmaxsd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3d,0x1a]     
vpmaxsd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3d,0x1a]    
vpmaxsd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3d,0x1a]      
vpmaxsd (%rdx), %zmm19, %zmm19 

// CHECK: vpmaxsd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3d,0x1a]     
vpmaxsd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3d,0x1a]    
vpmaxsd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x3d,0xdb]      
vpmaxsd %zmm19, %zmm19, %zmm19 

// CHECK: vpmaxsd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x3d,0xdb]     
vpmaxsd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x3d,0xdb]    
vpmaxsd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3d,0x5c,0x82,0x40]      
vpmaxsq 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpmaxsq -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3d,0x5c,0x82,0xc0]      
vpmaxsq -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpmaxsq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3d,0x5c,0x82,0x40]     
vpmaxsq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3d,0x5c,0x82,0xc0]     
vpmaxsq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3d,0x5c,0x82,0x40]    
vpmaxsq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3d,0x5c,0x82,0xc0]    
vpmaxsq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3d,0x5c,0x02,0x40]      
vpmaxsq 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpmaxsq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3d,0x5c,0x02,0x40]     
vpmaxsq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3d,0x5c,0x02,0x40]    
vpmaxsq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3d,0x5a,0x40]      
vpmaxsq 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpmaxsq 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3d,0x5a,0x40]     
vpmaxsq 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3d,0x5a,0x40]    
vpmaxsq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpmaxsq 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpmaxsq 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpmaxsq 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpmaxsq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpmaxsq 485498096, %zmm19, %zmm19 

// CHECK: vpmaxsq 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpmaxsq 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3d,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpmaxsq 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3d,0x5a,0x40]      
vpmaxsq 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpmaxsq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3d,0x5a,0x40]     
vpmaxsq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3d,0x5a,0x40]    
vpmaxsq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3d,0x5c,0x02,0x40]      
vpmaxsq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpmaxsq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3d,0x5c,0x02,0x40]     
vpmaxsq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3d,0x5c,0x02,0x40]    
vpmaxsq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3d,0x5c,0x82,0x40]      
vpmaxsq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpmaxsq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3d,0x5c,0x82,0xc0]      
vpmaxsq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpmaxsq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3d,0x5c,0x82,0x40]     
vpmaxsq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3d,0x5c,0x82,0xc0]     
vpmaxsq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3d,0x5c,0x82,0x40]    
vpmaxsq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3d,0x5c,0x82,0xc0]    
vpmaxsq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3d,0x1a]      
vpmaxsq (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpmaxsq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3d,0x1a]     
vpmaxsq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3d,0x1a]    
vpmaxsq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3d,0x1a]      
vpmaxsq (%rdx), %zmm19, %zmm19 

// CHECK: vpmaxsq (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3d,0x1a]     
vpmaxsq (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3d,0x1a]    
vpmaxsq (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxsq %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x3d,0xdb]      
vpmaxsq %zmm19, %zmm19, %zmm19 

// CHECK: vpmaxsq %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x3d,0xdb]     
vpmaxsq %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxsq %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x3d,0xdb]    
vpmaxsq %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3f,0x5a,0x40]      
vpmaxud 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpmaxud 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3f,0x5a,0x40]     
vpmaxud 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3f,0x5a,0x40]    
vpmaxud 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3f,0x5c,0x02,0x40]      
vpmaxud 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpmaxud 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3f,0x5c,0x02,0x40]     
vpmaxud 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3f,0x5c,0x02,0x40]    
vpmaxud 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3f,0x5c,0x82,0x40]      
vpmaxud 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpmaxud -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3f,0x5c,0x82,0xc0]      
vpmaxud -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpmaxud 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3f,0x5c,0x82,0x40]     
vpmaxud 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3f,0x5c,0x82,0xc0]     
vpmaxud -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3f,0x5c,0x82,0x40]    
vpmaxud 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3f,0x5c,0x82,0xc0]    
vpmaxud -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3f,0x5c,0x82,0x40]      
vpmaxud 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpmaxud -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3f,0x5c,0x82,0xc0]      
vpmaxud -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpmaxud 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3f,0x5c,0x82,0x40]     
vpmaxud 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3f,0x5c,0x82,0xc0]     
vpmaxud -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3f,0x5c,0x82,0x40]    
vpmaxud 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3f,0x5c,0x82,0xc0]    
vpmaxud -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3f,0x5c,0x02,0x40]      
vpmaxud 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpmaxud 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3f,0x5c,0x02,0x40]     
vpmaxud 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3f,0x5c,0x02,0x40]    
vpmaxud 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3f,0x5a,0x40]      
vpmaxud 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpmaxud 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3f,0x5a,0x40]     
vpmaxud 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3f,0x5a,0x40]    
vpmaxud 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpmaxud 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpmaxud 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpmaxud 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpmaxud 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpmaxud 485498096, %zmm19, %zmm19 

// CHECK: vpmaxud 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpmaxud 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpmaxud 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3f,0x1a]      
vpmaxud (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpmaxud (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3f,0x1a]     
vpmaxud (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3f,0x1a]    
vpmaxud (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3f,0x1a]      
vpmaxud (%rdx), %zmm19, %zmm19 

// CHECK: vpmaxud (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3f,0x1a]     
vpmaxud (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3f,0x1a]    
vpmaxud (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxud %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x3f,0xdb]      
vpmaxud %zmm19, %zmm19, %zmm19 

// CHECK: vpmaxud %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x3f,0xdb]     
vpmaxud %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxud %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x3f,0xdb]    
vpmaxud %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3f,0x5c,0x82,0x40]      
vpmaxuq 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpmaxuq -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3f,0x5c,0x82,0xc0]      
vpmaxuq -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpmaxuq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3f,0x5c,0x82,0x40]     
vpmaxuq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3f,0x5c,0x82,0xc0]     
vpmaxuq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3f,0x5c,0x82,0x40]    
vpmaxuq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3f,0x5c,0x82,0xc0]    
vpmaxuq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3f,0x5c,0x02,0x40]      
vpmaxuq 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpmaxuq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3f,0x5c,0x02,0x40]     
vpmaxuq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3f,0x5c,0x02,0x40]    
vpmaxuq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3f,0x5a,0x40]      
vpmaxuq 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpmaxuq 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3f,0x5a,0x40]     
vpmaxuq 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3f,0x5a,0x40]    
vpmaxuq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpmaxuq 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpmaxuq 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpmaxuq 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpmaxuq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpmaxuq 485498096, %zmm19, %zmm19 

// CHECK: vpmaxuq 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpmaxuq 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3f,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpmaxuq 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3f,0x5a,0x40]      
vpmaxuq 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpmaxuq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3f,0x5a,0x40]     
vpmaxuq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3f,0x5a,0x40]    
vpmaxuq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3f,0x5c,0x02,0x40]      
vpmaxuq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpmaxuq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3f,0x5c,0x02,0x40]     
vpmaxuq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3f,0x5c,0x02,0x40]    
vpmaxuq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3f,0x5c,0x82,0x40]      
vpmaxuq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpmaxuq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3f,0x5c,0x82,0xc0]      
vpmaxuq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpmaxuq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3f,0x5c,0x82,0x40]     
vpmaxuq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3f,0x5c,0x82,0xc0]     
vpmaxuq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3f,0x5c,0x82,0x40]    
vpmaxuq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3f,0x5c,0x82,0xc0]    
vpmaxuq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3f,0x1a]      
vpmaxuq (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpmaxuq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3f,0x1a]     
vpmaxuq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3f,0x1a]    
vpmaxuq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3f,0x1a]      
vpmaxuq (%rdx), %zmm19, %zmm19 

// CHECK: vpmaxuq (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3f,0x1a]     
vpmaxuq (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3f,0x1a]    
vpmaxuq (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmaxuq %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x3f,0xdb]      
vpmaxuq %zmm19, %zmm19, %zmm19 

// CHECK: vpmaxuq %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x3f,0xdb]     
vpmaxuq %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpmaxuq %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x3f,0xdb]    
vpmaxuq %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x39,0x5a,0x40]      
vpminsd 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpminsd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x39,0x5a,0x40]     
vpminsd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x39,0x5a,0x40]    
vpminsd 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x39,0x5c,0x02,0x40]      
vpminsd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpminsd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x39,0x5c,0x02,0x40]     
vpminsd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x39,0x5c,0x02,0x40]    
vpminsd 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x39,0x5c,0x82,0x40]      
vpminsd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpminsd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x39,0x5c,0x82,0xc0]      
vpminsd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpminsd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x39,0x5c,0x82,0x40]     
vpminsd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x39,0x5c,0x82,0xc0]     
vpminsd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x39,0x5c,0x82,0x40]    
vpminsd 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x39,0x5c,0x82,0xc0]    
vpminsd -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x39,0x5c,0x82,0x40]      
vpminsd 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpminsd -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x39,0x5c,0x82,0xc0]      
vpminsd -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpminsd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x39,0x5c,0x82,0x40]     
vpminsd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x39,0x5c,0x82,0xc0]     
vpminsd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x39,0x5c,0x82,0x40]    
vpminsd 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x39,0x5c,0x82,0xc0]    
vpminsd -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x39,0x5c,0x02,0x40]      
vpminsd 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpminsd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x39,0x5c,0x02,0x40]     
vpminsd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x39,0x5c,0x02,0x40]    
vpminsd 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x39,0x5a,0x40]      
vpminsd 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpminsd 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x39,0x5a,0x40]     
vpminsd 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x39,0x5a,0x40]    
vpminsd 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpminsd 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpminsd 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpminsd 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpminsd 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpminsd 485498096, %zmm19, %zmm19 

// CHECK: vpminsd 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpminsd 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpminsd 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x39,0x1a]      
vpminsd (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpminsd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x39,0x1a]     
vpminsd (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x39,0x1a]    
vpminsd (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x39,0x1a]      
vpminsd (%rdx), %zmm19, %zmm19 

// CHECK: vpminsd (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x39,0x1a]     
vpminsd (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x39,0x1a]    
vpminsd (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsd %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x39,0xdb]      
vpminsd %zmm19, %zmm19, %zmm19 

// CHECK: vpminsd %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x39,0xdb]     
vpminsd %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsd %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x39,0xdb]    
vpminsd %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x39,0x5c,0x82,0x40]      
vpminsq 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpminsq -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x39,0x5c,0x82,0xc0]      
vpminsq -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpminsq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x39,0x5c,0x82,0x40]     
vpminsq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x39,0x5c,0x82,0xc0]     
vpminsq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x39,0x5c,0x82,0x40]    
vpminsq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x39,0x5c,0x82,0xc0]    
vpminsq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x39,0x5c,0x02,0x40]      
vpminsq 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpminsq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x39,0x5c,0x02,0x40]     
vpminsq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x39,0x5c,0x02,0x40]    
vpminsq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x39,0x5a,0x40]      
vpminsq 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpminsq 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x39,0x5a,0x40]     
vpminsq 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x39,0x5a,0x40]    
vpminsq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpminsq 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpminsq 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpminsq 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpminsq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpminsq 485498096, %zmm19, %zmm19 

// CHECK: vpminsq 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpminsq 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x39,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpminsq 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x39,0x5a,0x40]      
vpminsq 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpminsq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x39,0x5a,0x40]     
vpminsq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x39,0x5a,0x40]    
vpminsq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x39,0x5c,0x02,0x40]      
vpminsq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpminsq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x39,0x5c,0x02,0x40]     
vpminsq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x39,0x5c,0x02,0x40]    
vpminsq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x39,0x5c,0x82,0x40]      
vpminsq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpminsq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x39,0x5c,0x82,0xc0]      
vpminsq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpminsq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x39,0x5c,0x82,0x40]     
vpminsq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x39,0x5c,0x82,0xc0]     
vpminsq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x39,0x5c,0x82,0x40]    
vpminsq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x39,0x5c,0x82,0xc0]    
vpminsq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x39,0x1a]      
vpminsq (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpminsq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x39,0x1a]     
vpminsq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x39,0x1a]    
vpminsq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x39,0x1a]      
vpminsq (%rdx), %zmm19, %zmm19 

// CHECK: vpminsq (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x39,0x1a]     
vpminsq (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x39,0x1a]    
vpminsq (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminsq %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x39,0xdb]      
vpminsq %zmm19, %zmm19, %zmm19 

// CHECK: vpminsq %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x39,0xdb]     
vpminsq %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpminsq %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x39,0xdb]    
vpminsq %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud 256(%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3b,0x5a,0x40]      
vpminud 256(%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpminud 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3b,0x5a,0x40]     
vpminud 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminud 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3b,0x5a,0x40]    
vpminud 256(%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud 256(%rdx,%rax){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3b,0x5c,0x02,0x40]      
vpminud 256(%rdx,%rax){1to16}, %zmm19, %zmm19 

// CHECK: vpminud 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3b,0x5c,0x02,0x40]     
vpminud 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminud 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3b,0x5c,0x02,0x40]    
vpminud 256(%rdx,%rax){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3b,0x5c,0x82,0x40]      
vpminud 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpminud -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3b,0x5c,0x82,0xc0]      
vpminud -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 

// CHECK: vpminud 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3b,0x5c,0x82,0x40]     
vpminud 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminud -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3b,0x5c,0x82,0xc0]     
vpminud -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminud 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3b,0x5c,0x82,0x40]    
vpminud 256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3b,0x5c,0x82,0xc0]    
vpminud -256(%rdx,%rax,4){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3b,0x5c,0x82,0x40]      
vpminud 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpminud -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3b,0x5c,0x82,0xc0]      
vpminud -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpminud 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3b,0x5c,0x82,0x40]     
vpminud 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpminud -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3b,0x5c,0x82,0xc0]     
vpminud -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpminud 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3b,0x5c,0x82,0x40]    
vpminud 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3b,0x5c,0x82,0xc0]    
vpminud -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3b,0x5c,0x02,0x40]      
vpminud 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpminud 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3b,0x5c,0x02,0x40]     
vpminud 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpminud 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3b,0x5c,0x02,0x40]    
vpminud 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3b,0x5a,0x40]      
vpminud 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpminud 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3b,0x5a,0x40]     
vpminud 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpminud 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3b,0x5a,0x40]    
vpminud 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud 485498096{1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpminud 485498096{1to16}, %zmm19, %zmm19 

// CHECK: vpminud 485498096{1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpminud 485498096{1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminud 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpminud 485498096{1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpminud 485498096, %zmm19, %zmm19 

// CHECK: vpminud 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpminud 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpminud 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpminud 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud (%rdx){1to16}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x50,0x3b,0x1a]      
vpminud (%rdx){1to16}, %zmm19, %zmm19 

// CHECK: vpminud (%rdx){1to16}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x52,0x3b,0x1a]     
vpminud (%rdx){1to16}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminud (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xd2,0x3b,0x1a]    
vpminud (%rdx){1to16}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0x65,0x40,0x3b,0x1a]      
vpminud (%rdx), %zmm19, %zmm19 

// CHECK: vpminud (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x65,0x42,0x3b,0x1a]     
vpminud (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpminud (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x65,0xc2,0x3b,0x1a]    
vpminud (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminud %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0x65,0x40,0x3b,0xdb]      
vpminud %zmm19, %zmm19, %zmm19 

// CHECK: vpminud %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x65,0x42,0x3b,0xdb]     
vpminud %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpminud %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x65,0xc2,0x3b,0xdb]    
vpminud %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq 4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3b,0x5c,0x82,0x40]      
vpminuq 4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpminuq -4096(%rdx,%rax,4), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3b,0x5c,0x82,0xc0]      
vpminuq -4096(%rdx,%rax,4), %zmm19, %zmm19 

// CHECK: vpminuq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3b,0x5c,0x82,0x40]     
vpminuq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3b,0x5c,0x82,0xc0]     
vpminuq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3b,0x5c,0x82,0x40]    
vpminuq 4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3b,0x5c,0x82,0xc0]    
vpminuq -4096(%rdx,%rax,4), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq 4096(%rdx,%rax), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3b,0x5c,0x02,0x40]      
vpminuq 4096(%rdx,%rax), %zmm19, %zmm19 

// CHECK: vpminuq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3b,0x5c,0x02,0x40]     
vpminuq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3b,0x5c,0x02,0x40]    
vpminuq 4096(%rdx,%rax), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq 4096(%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3b,0x5a,0x40]      
vpminuq 4096(%rdx), %zmm19, %zmm19 

// CHECK: vpminuq 4096(%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3b,0x5a,0x40]     
vpminuq 4096(%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3b,0x5a,0x40]    
vpminuq 4096(%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq 485498096{1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpminuq 485498096{1to8}, %zmm19, %zmm19 

// CHECK: vpminuq 485498096{1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpminuq 485498096{1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpminuq 485498096{1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq 485498096, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpminuq 485498096, %zmm19, %zmm19 

// CHECK: vpminuq 485498096, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]     
vpminuq 485498096, %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq 485498096, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3b,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]    
vpminuq 485498096, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq 512(%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3b,0x5a,0x40]      
vpminuq 512(%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpminuq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3b,0x5a,0x40]     
vpminuq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3b,0x5a,0x40]    
vpminuq 512(%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3b,0x5c,0x02,0x40]      
vpminuq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 

// CHECK: vpminuq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3b,0x5c,0x02,0x40]     
vpminuq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3b,0x5c,0x02,0x40]    
vpminuq 512(%rdx,%rax){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3b,0x5c,0x82,0x40]      
vpminuq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpminuq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3b,0x5c,0x82,0xc0]      
vpminuq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 

// CHECK: vpminuq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3b,0x5c,0x82,0x40]     
vpminuq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3b,0x5c,0x82,0xc0]     
vpminuq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3b,0x5c,0x82,0x40]    
vpminuq 512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3b,0x5c,0x82,0xc0]    
vpminuq -512(%rdx,%rax,4){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq (%rdx){1to8}, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x50,0x3b,0x1a]      
vpminuq (%rdx){1to8}, %zmm19, %zmm19 

// CHECK: vpminuq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x52,0x3b,0x1a]     
vpminuq (%rdx){1to8}, %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xd2,0x3b,0x1a]    
vpminuq (%rdx){1to8}, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq (%rdx), %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xe2,0xe5,0x40,0x3b,0x1a]      
vpminuq (%rdx), %zmm19, %zmm19 

// CHECK: vpminuq (%rdx), %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xe2,0xe5,0x42,0x3b,0x1a]     
vpminuq (%rdx), %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq (%rdx), %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0xe5,0xc2,0x3b,0x1a]    
vpminuq (%rdx), %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpminuq %zmm19, %zmm19, %zmm19 
// CHECK: encoding: [0x62,0xa2,0xe5,0x40,0x3b,0xdb]      
vpminuq %zmm19, %zmm19, %zmm19 

// CHECK: vpminuq %zmm19, %zmm19, %zmm19 {%k2} 
// CHECK: encoding: [0x62,0xa2,0xe5,0x42,0x3b,0xdb]     
vpminuq %zmm19, %zmm19, %zmm19 {%k2} 

// CHECK: vpminuq %zmm19, %zmm19, %zmm19 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0xe5,0xc2,0x3b,0xdb]    
vpminuq %zmm19, %zmm19, %zmm19 {%k2} {z} 

// CHECK: vpmovdb %zmm19, 1024(%rdx) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x31,0x5a,0x40]       
vpmovdb %zmm19, 1024(%rdx) 

// CHECK: vpmovdb %zmm19, 1024(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x31,0x5a,0x40]      
vpmovdb %zmm19, 1024(%rdx) {%k2} 

// CHECK: vpmovdb %zmm19, 1024(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x31,0x5c,0x82,0x40]       
vpmovdb %zmm19, 1024(%rdx,%rax,4) 

// CHECK: vpmovdb %zmm19, -1024(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x31,0x5c,0x82,0xc0]       
vpmovdb %zmm19, -1024(%rdx,%rax,4) 

// CHECK: vpmovdb %zmm19, 1024(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x31,0x5c,0x82,0x40]      
vpmovdb %zmm19, 1024(%rdx,%rax,4) {%k2} 

// CHECK: vpmovdb %zmm19, -1024(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x31,0x5c,0x82,0xc0]      
vpmovdb %zmm19, -1024(%rdx,%rax,4) {%k2} 

// CHECK: vpmovdb %zmm19, 1024(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x31,0x5c,0x02,0x40]       
vpmovdb %zmm19, 1024(%rdx,%rax) 

// CHECK: vpmovdb %zmm19, 1024(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x31,0x5c,0x02,0x40]      
vpmovdb %zmm19, 1024(%rdx,%rax) {%k2} 

// CHECK: vpmovdb %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x31,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpmovdb %zmm19, 485498096 

// CHECK: vpmovdb %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x31,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpmovdb %zmm19, 485498096 {%k2} 

// CHECK: vpmovdb %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x31,0x1a]       
vpmovdb %zmm19, (%rdx) 

// CHECK: vpmovdb %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x31,0x1a]      
vpmovdb %zmm19, (%rdx) {%k2} 

// CHECK: vpmovdb %zmm19, %xmm15 
// CHECK: encoding: [0x62,0xc2,0x7e,0x48,0x31,0xdf]       
vpmovdb %zmm19, %xmm15 

// CHECK: vpmovdb %zmm19, %xmm15 {%k2} 
// CHECK: encoding: [0x62,0xc2,0x7e,0x4a,0x31,0xdf]      
vpmovdb %zmm19, %xmm15 {%k2} 

// CHECK: vpmovdb %zmm19, %xmm15 {%k2} {z} 
// CHECK: encoding: [0x62,0xc2,0x7e,0xca,0x31,0xdf]     
vpmovdb %zmm19, %xmm15 {%k2} {z} 

// CHECK: vpmovdb %zmm19, %xmm1 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x31,0xd9]       
vpmovdb %zmm19, %xmm1 

// CHECK: vpmovdb %zmm19, %xmm1 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x31,0xd9]      
vpmovdb %zmm19, %xmm1 {%k2} 

// CHECK: vpmovdb %zmm19, %xmm1 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7e,0xca,0x31,0xd9]     
vpmovdb %zmm19, %xmm1 {%k2} {z} 

// CHECK: vpmovdw %zmm19, 2048(%rdx) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x33,0x5a,0x40]       
vpmovdw %zmm19, 2048(%rdx) 

// CHECK: vpmovdw %zmm19, 2048(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x33,0x5a,0x40]      
vpmovdw %zmm19, 2048(%rdx) {%k2} 

// CHECK: vpmovdw %zmm19, 2048(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x33,0x5c,0x82,0x40]       
vpmovdw %zmm19, 2048(%rdx,%rax,4) 

// CHECK: vpmovdw %zmm19, -2048(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x33,0x5c,0x82,0xc0]       
vpmovdw %zmm19, -2048(%rdx,%rax,4) 

// CHECK: vpmovdw %zmm19, 2048(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x33,0x5c,0x82,0x40]      
vpmovdw %zmm19, 2048(%rdx,%rax,4) {%k2} 

// CHECK: vpmovdw %zmm19, -2048(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x33,0x5c,0x82,0xc0]      
vpmovdw %zmm19, -2048(%rdx,%rax,4) {%k2} 

// CHECK: vpmovdw %zmm19, 2048(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x33,0x5c,0x02,0x40]       
vpmovdw %zmm19, 2048(%rdx,%rax) 

// CHECK: vpmovdw %zmm19, 2048(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x33,0x5c,0x02,0x40]      
vpmovdw %zmm19, 2048(%rdx,%rax) {%k2} 

// CHECK: vpmovdw %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x33,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpmovdw %zmm19, 485498096 

// CHECK: vpmovdw %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x33,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpmovdw %zmm19, 485498096 {%k2} 

// CHECK: vpmovdw %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x33,0x1a]       
vpmovdw %zmm19, (%rdx) 

// CHECK: vpmovdw %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x33,0x1a]      
vpmovdw %zmm19, (%rdx) {%k2} 

// CHECK: vpmovdw %zmm19, %ymm23 
// CHECK: encoding: [0x62,0xa2,0x7e,0x48,0x33,0xdf]       
vpmovdw %zmm19, %ymm23 

// CHECK: vpmovdw %zmm19, %ymm23 {%k2} 
// CHECK: encoding: [0x62,0xa2,0x7e,0x4a,0x33,0xdf]      
vpmovdw %zmm19, %ymm23 {%k2} 

// CHECK: vpmovdw %zmm19, %ymm23 {%k2} {z} 
// CHECK: encoding: [0x62,0xa2,0x7e,0xca,0x33,0xdf]     
vpmovdw %zmm19, %ymm23 {%k2} {z} 

// CHECK: vpmovqw %zmm19, 1024(%rdx) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x34,0x5a,0x40]       
vpmovqw %zmm19, 1024(%rdx) 

// CHECK: vpmovqw %zmm19, 1024(%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x34,0x5a,0x40]      
vpmovqw %zmm19, 1024(%rdx) {%k2} 

// CHECK: vpmovqw %zmm19, 1024(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x34,0x5c,0x82,0x40]       
vpmovqw %zmm19, 1024(%rdx,%rax,4) 

// CHECK: vpmovqw %zmm19, -1024(%rdx,%rax,4) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x34,0x5c,0x82,0xc0]       
vpmovqw %zmm19, -1024(%rdx,%rax,4) 

// CHECK: vpmovqw %zmm19, 1024(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x34,0x5c,0x82,0x40]      
vpmovqw %zmm19, 1024(%rdx,%rax,4) {%k2} 

// CHECK: vpmovqw %zmm19, -1024(%rdx,%rax,4) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x34,0x5c,0x82,0xc0]      
vpmovqw %zmm19, -1024(%rdx,%rax,4) {%k2} 

// CHECK: vpmovqw %zmm19, 1024(%rdx,%rax) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x34,0x5c,0x02,0x40]       
vpmovqw %zmm19, 1024(%rdx,%rax) 

// CHECK: vpmovqw %zmm19, 1024(%rdx,%rax) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x34,0x5c,0x02,0x40]      
vpmovqw %zmm19, 1024(%rdx,%rax) {%k2} 

// CHECK: vpmovqw %zmm19, 485498096 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x34,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]       
vpmovqw %zmm19, 485498096 

// CHECK: vpmovqw %zmm19, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x34,0x1c,0x25,0xf0,0x1c,0xf0,0x1c]      
vpmovqw %zmm19, 485498096 {%k2} 

// CHECK: vpmovqw %zmm19, (%rdx) 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x34,0x1a]       
vpmovqw %zmm19, (%rdx) 

// CHECK: vpmovqw %zmm19, (%rdx) {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x34,0x1a]      
vpmovqw %zmm19, (%rdx) {%k2} 

// CHECK: vpmovqw %zmm19, %xmm15 
// CHECK: encoding: [0x62,0xc2,0x7e,0x48,0x34,0xdf]       
vpmovqw %zmm19, %xmm15 

// CHECK: vpmovqw %zmm19, %xmm15 {%k2} 
// CHECK: encoding: [0x62,0xc2,0x7e,0x4a,0x34,0xdf]      
vpmovqw %zmm19, %xmm15 {%k2} 

// CHECK: vpmovqw %zmm19, %xmm15 {%k2} {z} 
// CHECK: encoding: [0x62,0xc2,0x7e,0xca,0x34,0xdf]     
vpmovqw %zmm19, %xmm15 {%k2} {z} 

// CHECK: vpmovqw %zmm19, %xmm1 
// CHECK: encoding: [0x62,0xe2,0x7e,0x48,0x34,0xd9]       
vpmovqw %zmm19, %xmm1 

// CHECK: vpmovqw %zmm19, %xmm1 {%k2} 
// CHECK: encoding: [0x62,0xe2,0x7e,0x4a,0x34,0xd9]      
vpmovqw %zmm19, %xmm1 {%k2} 

// CHECK: vpmovqw %zmm19, %xmm1 {%k2} {z} 
// CHECK: encoding: [0x62,0xe2,0x7e,0xca,0x34,0xd9]     
