/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.wrapper.Downloader;
import org.apache.maven.wrapper.Logger;
import org.apache.maven.wrapper.PathAssembler;
import org.apache.maven.wrapper.WrapperConfiguration;

public class Installer {
    public static final String DEFAULT_DISTRIBUTION_PATH = "wrapper/dists";
    private final Downloader download;
    private final PathAssembler pathAssembler;

    public Installer(Downloader download, PathAssembler pathAssembler) {
        this.download = download;
        this.pathAssembler = pathAssembler;
    }

    public File createDist(WrapperConfiguration configuration) throws Exception {
        URI distributionUrl = configuration.getDistribution();
        String mvnwRepoUrl = System.getenv("MVNW_REPOURL");
        if (mvnwRepoUrl != null && !mvnwRepoUrl.isEmpty()) {
            Logger.info("Detected MVNW_REPOURL environment variable " + mvnwRepoUrl);
            String mvnPath = distributionUrl.toURL().toString();
            mvnPath = mvnPath.substring(mvnPath.indexOf("org/apache/maven"));
            distributionUrl = new URI(mvnwRepoUrl + "/" + mvnPath);
        }
        boolean alwaysDownload = configuration.isAlwaysDownload();
        boolean alwaysUnpack = configuration.isAlwaysUnpack();
        PathAssembler.LocalDistribution localDistribution = this.pathAssembler.getDistribution(configuration);
        Logger.info("Installing Maven distribution " + localDistribution.getDistributionDir().getAbsolutePath());
        File localZipFile = localDistribution.getZipFile();
        boolean downloaded = false;
        if (alwaysDownload || !localZipFile.exists()) {
            File tmpZipFile = new File(localZipFile.getParentFile(), localZipFile.getName() + ".part");
            tmpZipFile.delete();
            Logger.info("Downloading " + distributionUrl);
            this.download.download(distributionUrl, tmpZipFile);
            tmpZipFile.renameTo(localZipFile);
            downloaded = true;
        }
        File distDir = localDistribution.getDistributionDir();
        List<File> dirs = this.listDirs(distDir);
        if (downloaded || alwaysUnpack || dirs.isEmpty()) {
            for (File dir : dirs) {
                Logger.info("Deleting directory " + dir.getAbsolutePath());
                this.deleteDir(dir);
            }
            Logger.info("Unzipping " + localZipFile.getAbsolutePath() + " to " + distDir.getAbsolutePath());
            this.unzip(localZipFile, distDir);
            dirs = this.listDirs(distDir);
            if (dirs.isEmpty()) {
                throw new RuntimeException(String.format("Maven distribution '%s' does not contain any directory. Expected to find exactly 1 directory.", distDir));
            }
            this.setExecutablePermissions(dirs.get(0));
        }
        if (dirs.size() != 1) {
            throw new RuntimeException(String.format("Maven distribution '%s' contains too many directories. Expected to find exactly 1 directory.", distDir));
        }
        return dirs.get(0);
    }

    private List<File> listDirs(File distDir) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (distDir.exists()) {
            for (File file : distDir.listFiles()) {
                if (!file.isDirectory()) continue;
                dirs.add(file);
            }
        }
        return dirs;
    }

    private void setExecutablePermissions(File mavenHome) {
        String errorMessage;
        File mavenCommand;
        block30: {
            if (this.isWindows()) {
                return;
            }
            mavenCommand = new File(mavenHome, "bin/mvn");
            errorMessage = null;
            try {
                ProcessBuilder pb = new ProcessBuilder("chmod", "755", mavenCommand.getCanonicalPath());
                Process p = pb.start();
                if (p.waitFor() == 0) {
                    Logger.info("Set executable permissions for: " + mavenCommand.getAbsolutePath());
                    break block30;
                }
                try (BufferedReader is = new BufferedReader(new InputStreamReader(p.getInputStream()));
                     Formatter stdout = new Formatter();){
                    String line;
                    while ((line = is.readLine()) != null) {
                        stdout.format("%s%n", line);
                    }
                    errorMessage = stdout.toString();
                }
            }
            catch (IOException | InterruptedException e) {
                errorMessage = e.getMessage();
            }
        }
        if (errorMessage != null) {
            Logger.warn("Could not set executable permissions for: " + mavenCommand.getAbsolutePath());
            Logger.warn("Please do this manually if you want to use Maven.");
        }
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public void unzip(File zip, File dest) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                new File(dest, entry.getName()).mkdirs();
                continue;
            }
            new File(dest, entry.getName()).getParentFile().mkdirs();
            InputStream in = zipFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(dest, entry.getName())));
                Throwable throwable2 = null;
                try {
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = in.read(buffer)) >= 0) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (out == null) continue;
                    if (throwable2 != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ((OutputStream)out).close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                in.close();
            }
        }
        zipFile.close();
    }
}

