/*
 * Copyright 2013 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef COM_LOMIRI_CONTENTHUB_H_
#define COM_LOMIRI_CONTENTHUB_H_

#include <QHash>
#include <QList>
#include <QObject>
#include <QQmlListProperty>
#include "contentpeer.h"
#include "contenttransfer.h"

class ContentStore;
class QmlImportExportHandler;

namespace com {
namespace lomiri {
namespace content {
class Hub;
class Peer;
class Store;
class Type;
class Transfer;
}
}
}

class ContentHub : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QQmlListProperty<ContentTransfer> finishedImports READ finishedImports NOTIFY finishedImportsChanged)
    Q_PROPERTY(bool hasPending READ hasPending)

public:
    ContentHub(const ContentHub&) = delete;

    static ContentHub *instance();

    Q_INVOKABLE void restoreImports();

    QQmlListProperty<ContentTransfer> finishedImports();
    bool hasPending();

    Q_INVOKABLE ContentTransfer* importContent(com::lomiri::content::Peer peer, ContentType::Type type);
    Q_INVOKABLE ContentTransfer* exportContent(com::lomiri::content::Peer peer, ContentType::Type type);
    Q_INVOKABLE ContentTransfer* shareContent(com::lomiri::content::Peer peer, ContentType::Type type);

Q_SIGNALS:
    void importRequested(ContentTransfer *transfer);
    void exportRequested(ContentTransfer *transfer);
    void shareRequested(ContentTransfer *transfer);

    void finishedImportsChanged();

private Q_SLOTS:
    void handleImport(com::lomiri::content::Transfer* transfer);
    void handleExport(com::lomiri::content::Transfer* transfer);
    void handleShare(com::lomiri::content::Transfer* transfer);
    void updateState();

private:
    QList<ContentTransfer *> m_finishedImports;
    QHash<com::lomiri::content::Transfer *, ContentTransfer *> m_activeImports;
    com::lomiri::content::Hub *m_hub;
    QmlImportExportHandler *m_handler;
    bool m_hasPending = false;

protected:
    ContentHub(QObject* = nullptr);

};

#endif // COM_LOMIRI_CONTENTHUB_H_
