/*
 * Copyright 2014 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UCACTIONMANAGER_P_H
#define UCACTIONMANAGER_P_H

#include <QtCore/QObject>
#include <QtQml/QQmlListProperty>
#include <QtQml/QQmlParserStatus>

#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
#include <LomiriToolkit-Qt6/lomiritoolkitglobal.h>
#else
#include <LomiriToolkit/lomiritoolkitglobal.h>
#endif
#include "ucactioncontext_p.h"

UT_NAMESPACE_BEGIN

class UCAction;
class UCActionContext;
class LOMIRITOOLKIT_EXPORT UCActionManager : public QObject, public QQmlParserStatus
{
    Q_OBJECT
    Q_INTERFACES(QQmlParserStatus)
    Q_PROPERTY(QQmlListProperty<UT_PREPEND_NAMESPACE(UCAction)> actions READ actions)
    Q_PROPERTY(QQmlListProperty<UT_PREPEND_NAMESPACE(UCActionContext)> localContexts READ localContexts)
    Q_PROPERTY(UT_PREPEND_NAMESPACE(UCActionContext) *globalContext READ globalContext CONSTANT)
    Q_CLASSINFO("DefaultProperty", "actions")
public:
    explicit UCActionManager(QObject *parent = 0);

    void classBegin() override {}
    void componentComplete() override;

    QQmlListProperty<UCAction> actions();
    QQmlListProperty<UCActionContext> localContexts();
    UCActionContext *globalContext() const;

Q_SIGNALS:
    void quit();

public Q_SLOTS:
    void addAction(UT_PREPEND_NAMESPACE(UCAction) *action);
    void removeAction(UT_PREPEND_NAMESPACE(UCAction) *action);
    void addLocalContext(UT_PREPEND_NAMESPACE(UCActionContext) *context);
    void removeLocalContext(UT_PREPEND_NAMESPACE(UCActionContext) *context);

private:
    static void contextAppend(QQmlListProperty<UCActionContext> *list, UCActionContext *context);
    static void contextClear(QQmlListProperty<UCActionContext> *list);
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
    static qsizetype contextCount(QQmlListProperty<UCActionContext> *list);
#else
    static int contextCount(QQmlListProperty<UCActionContext> *list);
#endif

    static void actionAppend(QQmlListProperty<UCAction> *list, UCAction *action);
    static void actionClear(QQmlListProperty<UCAction> *list);
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
    static qsizetype actionCount(QQmlListProperty<UCAction> *list);
#else
    static int actionCount(QQmlListProperty<UCAction> *list);
#endif
};

UT_NAMESPACE_END

#endif // UCACTIONMANAGER_P_H
