/*
    libmaus2
    Copyright (C) 2009-2013 German Tischler
    Copyright (C) 2011-2013 Genome Research Limited

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#if ! defined(LIBMAUS2_GAMMA_SPARSEGAMMAGAPENCODER_HPP)
#define LIBMAUS2_GAMMA_SPARSEGAMMAGAPENCODER_HPP

#include <libmaus2/gamma/GammaEncoder.hpp>
#include <libmaus2/gamma/GammaDecoder.hpp>
#include <libmaus2/aio/OutputStreamInstance.hpp>
#include <libmaus2/aio/SynchronousGenericOutput.hpp>
#include <libmaus2/aio/SynchronousGenericInput.hpp>
#include <libmaus2/math/UnsignedInteger.hpp>

namespace libmaus2
{
	namespace gamma
	{
		template<typename _data_type>
		struct SparseGammaGapEncoderTemplate
		{
			typedef _data_type data_type;
			typedef SparseGammaGapEncoderTemplate<data_type> this_type;

			typedef std::unique_ptr<this_type> unique_ptr_type;
			typedef std::shared_ptr<this_type> shared_ptr_type;

			typedef libmaus2::aio::SynchronousGenericOutput<data_type> stream_type;

			stream_type SGO;
			int64_t prevkey;
			libmaus2::gamma::GammaEncoder<stream_type> genc;

			SparseGammaGapEncoderTemplate(std::ostream & out, int64_t const rprevkey = -1) : SGO(out,64*1024), prevkey(rprevkey), genc(SGO)
			{
			}

			void encode(uint64_t const key, uint64_t const val)
			{
				int64_t const dif = (static_cast<int64_t>(key)-prevkey)-1;
				genc.encode(dif);
				prevkey = key;
				assert ( val );
				genc.encode(val);
			}

			void term()
			{
				genc.encode(0);
				genc.encode(0);
				genc.flush();
				SGO.flush();
			}

			template<typename it>
			static void encodeArray(
				it const ita,
				it const ite,
				std::ostream & out
			)
			{
				std::sort(ita,ite);

				this_type enc(out);

				it itl = ita;

				while ( itl != ite )
				{
					it ith = itl;

					while ( ith != ite && *ith == *itl )
						++ith;

					enc.encode(*itl,ith-itl);

					itl = ith;
				}

				enc.term();
				out.flush();
			}

			template<typename it>
			static void encodeArray(
				it const ita,
				it const ite,
				std::string const & fn
			)
			{
				libmaus2::aio::OutputStreamInstance COS(fn);
				encodeArray(ita,ite,COS);
			}
		};

		typedef SparseGammaGapEncoderTemplate<uint64_t> SparseGammaGapEncoder;
		typedef SparseGammaGapEncoderTemplate< libmaus2::math::UnsignedInteger<4> > SparseGammaGapEncoder2;
	}
}
#endif
