/*
    libmaus2
    Copyright (C) 2016 German Tischler

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#if ! defined(LIBMAUS2_UTIL_DESTRUCTABLE_HPP)
#define LIBMAUS2_UTIL_DESTRUCTABLE_HPP

#include <memory>

namespace libmaus2
{
	namespace util
	{
		struct Destructable
		{
			typedef Destructable this_type;
			typedef std::unique_ptr<this_type> unique_ptr_type;
			typedef std::shared_ptr<this_type> shared_ptr_type;

			private:
			void * object;
			void (*destruct)(void *);

			Destructable(void * robject, void (*rdestruct)(void *)) : object(robject), destruct(rdestruct) {}

			public:
			static unique_ptr_type construct(void * robject, void (*rdestruct)(void *))
			{
				unique_ptr_type tptr(new Destructable(robject,rdestruct));
				return tptr;
			}

			static shared_ptr_type sconstruct(void * robject, void (*rdestruct)(void *))
			{
				shared_ptr_type tptr(new Destructable(robject,rdestruct));
				return tptr;
			}

			virtual ~Destructable()
			{
				if ( destruct )
				{
					destruct(object);
					object = 0;
				}
			}

			void * getObject()
			{
				return object;
			}
		};
	}
}
#endif
