/*
   Colour definitions from POVRay (http://www.povray.org)
*/
#ifndef __OBJCRYST_COULOURS_H
#define __OBJCRYST_COULOURS_H
struct POVRayColours
{
   const char *mName;
   REAL mRGB[3];
};

/** Colours from POVRay (first part) and Jmol
*(converted to floats from jmol_constants.java)
*/
const POVRayColours gPOVRayColours[]=
{
   {"Red",           { 1,  0, 0}},
   {"Green",         { 0,  1, 0}},
   {"Blue",          { 0,  0, 1}},
   {"Yellow",        { 1,  1, 0}},
   {"Cyan",          { 0,  1, 1}},
   {"Magenta",       { 1,  0, 1}},
   {"Clear",         { 1,  1, 1}},
   {"White",         { 1,  1, 1}},
   {"Black",         { 0,  0, 0}},
   {"Gray05",        { 0.05,  0.05, 0.05}},
   {"Gray10",        { .10,  .10, .10}},
   {"Gray15",        { 0.15,  0.15, 0.15}},
   {"Gray20",        { 0.20,  0.20, 0.20}},
   {"Gray25",        { 0.25,  0.25, 0.25}},
   {"Gray30",        { 0.30,  0.30, 0.30}},
   {"Gray35",        { 0.35,  0.35, 0.35}},
   {"Gray40",        { 0.40,  0.40, 0.40}},
   {"Gray45",        { 0.45,  0.45, 0.45}},
   {"Gray50",        { 0.50,  0.50, 0.50}},
   {"Gray55",        { 0.55,  0.55, 0.55}},
   {"Gray60",        { 0.60,  0.60, 0.60}},
   {"Gray65",        { 0.65,  0.65, 0.65}},
   {"Gray70",        { 0.70,  0.70, 0.70}},
   {"Gray75",        { 0.75,  0.75, 0.75}},
   {"Gray80",        { 0.80,  0.80, 0.80}},
   {"Gray85",        { 0.85,  0.85, 0.85}},
   {"Gray90",        { 0.90,  0.90, 0.90}},
   {"Gray95",        { 0.95,  0.95, 0.95}},
   {"DimGray",    { 0.329412 , 0.329412 , 0.329412}},
   {"DimGrey",    { 0.329412 , 0.329412 , 0.329412}},
   {"Gray",    { 0.752941 , 0.752941 , 0.752941}},
   {"Grey",    { 0.752941 , 0.752941 , 0.752941}},
   {"LightGray",    { 0.658824 , 0.658824 , 0.658824}},
   {"LightGrey",    { 0.658824 , 0.658824 , 0.658824}},
   {"VLightGray",    { 0.80 , 0.80 , 0.80}},
   {"VLightGrey",    { 0.80 , 0.80 , 0.80}},
   {"Aquamarine",    { 0.439216 , 0.858824 , 0.576471}},
   {"BlueViolet",    { 0.62352 , 0.372549 , 0.623529}},
   {"Brown",    { 0.647059 , 0.164706 , 0.164706}},
   {"CadetBlue",    { 0.372549 , 0.623529 , 0.623529}},
   {"Coral",    { 1.0 , 0.498039 , 0.0}},
   {"CornflowerBlue",    { 0.258824 , 0.258824 , 0.435294}},
   {"DarkGreen",    { 0.184314 , 0.309804 , 0.184314}},
   {"DarkOliveGreen",    { 0.309804 , 0.309804 , 0.184314}},
   {"DarkOrchid",    { 0.6 , 0.196078 , 0.8}},
   {"DarkSlateBlue",    { 0.119608 , 0.137255 , 0.556863}},
   {"DarkSlateGray",    { 0.184314 , 0.309804 , 0.309804}},
   {"DarkSlateGrey",    { 0.184314 , 0.309804 , 0.309804}},
   {"DarkTurquoise",    { 0.439216 , 0.576471 , 0.858824}},
   {"Firebrick",    { 0.556863 , 0.137255 , 0.137255}},
   {"ForestGreen",    { 0.137255 , 0.556863 , 0.137255}},
   {"Gold",    { 0.8 , 0.498039 , 0.196078}},
   {"Goldenrod",    { 0.858824 , 0.858824 , 0.439216}},
   {"GreenYellow",    { 0.576471 , 0.858824 , 0.439216}},
   {"IndianRed",    { 0.309804 , 0.184314 , 0.184314}},
   {"Khaki",    { 0.623529 , 0.623529 , 0.372549}},
   {"LightBlue",    { 0.74902 , 0.847059 , 0.847059}},
   {"LightSteelBlue",    { 0.560784 , 0.560784 , 0.737255}},
   {"LimeGreen",    { 0.196078 , 0.8 , 0.196078}},
   {"Maroon",    { 0.556863 , 0.137255 , 0.419608}},
   {"MediumAquamarine",    { 0.196078 , 0.8 , 0.6}},
   {"MediumBlue",    { 0.196078 , 0.196078 , 0.8}},
   {"MediumForestGreen",    { 0.419608 , 0.556863 , 0.137255}},
   {"MediumGoldenrod",    { 0.917647 , 0.917647 , 0.678431}},
   {"MediumOrchid",    { 0.576471 , 0.439216 , 0.858824}},
   {"MediumSeaGreen",    { 0.258824 , 0.435294 , 0.258824}},
   {"MediumSlateBlue",    { 0.498039 , 1.0}},
   {"MediumSpringGreen",    { 0.498039 , 1.0}},
   {"MediumTurquoise",    { 0.439216 , 0.858824 , 0.858824}},
   {"MediumVioletRed",    { 0.858824 , 0.439216 , 0.576471}},
   {"MidnightBlue",    { 0.184314 , 0.184314 , 0.309804}},
   {"Navy",    { 0.137255 , 0.137255 , 0.556863}},
   {"NavyBlue",    { 0.137255 , 0.137255 , 0.556863}},
   {"Orange",    { 1 , 0.5 , 0.0}},
   {"OrangeRed",    { 1.0 , 0.25}},
   {"Orchid",    { 0.858824 , 0.439216 , 0.858824}},
   {"PaleGreen",    { 0.560784 , 0.737255 , 0.560784}},
   {"Pink",    { 0.737255 , 0.560784 , 0.560784}},
   {"Plum",    { 0.917647 , 0.678431 , 0.917647}},
   {"Salmon",    { 0.435294 , 0.258824 , 0.258824}},
   {"SeaGreen",    { 0.137255 , 0.556863 , 0.419608}},
   {"Sienna",    { 0.556863 , 0.419608 , 0.137255}},
   {"SkyBlue",    { 0.196078 , 0.6 , 0.8}},
   {"SlateBlue",  { 0., 0.498039 , 1.0}},
   {"SpringGreen",  {0.  , 1.0 , 0.498039}},
   {"SteelBlue",    { 0.137255 , 0.419608 , 0.556863}},
   {"Tan",    { 0.858824 , 0.576471 , 0.439216}},
   {"Thistle",    { 0.847059 , 0.74902 , 0.847059}},
   {"Turquoise",    { 0.678431 , 0.917647 , 0.917647}},
   {"Violet",    { 0.309804 , 0.184314 , 0.309804}},
   {"VioletRed",    { 0.8 , 0.196078 , 0.6}},
   {"Wheat",    { 0.847059 , 0.847059 , 0.74902}},
   {"YellowGreen",    { 0.6 , 0.8 , 0.196078}},
   {"SummerSky",    { 0.22 , 0.69 , 0.87}},
   {"RichBlue",    { 0.35 , 0.35 , 0.67}},
   {"Brass", { 0.71 , 0.65 , 0.26}},
   {"Copper",    { 0.72 , 0.45 , 0.20}},
   {"Bronze",    { 0.55 , 0.47 , 0.14}},
   {"Bronze2",    { 0.65 , 0.49 , 0.24}},
   {"Silver",    { 0.90 , 0.91 , 0.98}},
   {"BrightGold",    { 0.85 , 0.85 , 0.10}},
   {"OldGold", { 0.81 , 0.71 , 0.23}},
   {"Feldspar",    { 0.82 , 0.57 , 0.46}},
   {"Quartz",    { 0.85 , 0.85 , 0.95}},
   {"Mica",         { 0,  0, 0}},
   {"NeonPink",    { 1.00 , 0.43 , 0.78}},
   {"DarkPurple",    { 0.53 , 0.12 , 0.47}},
   {"NeonBlue",    { 0.30 , 0.30 , 1.00}},
   {"CoolCopper",    { 0.85 , 0.53 , 0.10}},
   {"MandarinOrange",    { 0.89 , 0.47 , 0.20}},
   {"LightWood",    { 0.91 , 0.76 , 0.65}},
   {"MediumWood",    { 0.65 , 0.50 , 0.39}},
   {"DarkWood",    { 0.52 , 0.37 , 0.26}},
   {"SpicyPink",    { 1.00 , 0.11 , 0.68}},
   {"SemiSweetChoc",    { 0.42 , 0.26 , 0.15}},
   {"BakersChoc",    { 0.36 , 0.20 , 0.09}},
   {"Flesh",    { 0.96 , 0.80 , 0.69}},
   {"NewTan",    { 0.92 , 0.78 , 0.62}},
   {"NewMidnightBlue",    { 0.00 , 0.00 , 0.61}},
   {"VeryDarkBrown",    { 0.35 , 0.16 , 0.14}},
   {"DarkBrown",    { 0.36 , 0.25 , 0.20}},
   {"DarkTan",    { 0.59 , 0.41 , 0.31}},
   {"GreenCopper",    { 0.32 , 0.49 , 0.46}},
   {"DkGreenCopper",    { 0.29 , 0.46 , 0.43}},
   {"DustyRose",    { 0.52 , 0.39 , 0.39}},
   {"HuntersGreen",    { 0.13 , 0.37 , 0.31}},
   {"Scarlet",    { 0.55 , 0.09 , 0.09}},
   {"Med_Purple", { 0.73 , 0.16 , 0.96}},
   {"Light_Purple",    { 0.87 , 0.58 , 0.98}},
   {"Very_Light_Purple",    { 0.94 , 0.81 , 0.99}},
    {"H", {1.000, 1.000, 1.000}}, //Z=  1
    {"He", {0.851, 1.000, 1.000}}, //Z=  2
    {"Li", {0.800, 0.502, 1.000}}, //Z=  3
    {"Be", {0.761, 1.000, 0.000}}, //Z=  4
    {"B", {1.000, 0.710, 0.710}}, //Z=  5
    {"C", {0.565, 0.565, 0.565}}, //Z=  6
    {"N", {0.188, 0.314, 0.973}}, //Z=  7
    {"O", {1.000, 0.051, 0.051}}, //Z=  8
    {"F", {0.565, 0.878, 0.314}}, //Z=  9
    {"Ne", {0.702, 0.890, 0.961}}, //Z= 10
    {"Na", {0.671, 0.361, 0.949}}, //Z= 11
    {"Mg", {0.541, 1.000, 0.000}}, //Z= 12
    {"Al", {0.749, 0.651, 0.651}}, //Z= 13
    {"Si", {0.941, 0.784, 0.627}}, //Z= 14
    {"P", {1.000, 0.502, 0.000}}, //Z= 15
    {"S", {1.000, 1.000, 0.188}}, //Z= 16
    {"Cl", {0.122, 0.941, 0.122}}, //Z= 17
    {"Ar", {0.502, 0.820, 0.890}}, //Z= 18
    {"K", {0.561, 0.251, 0.831}}, //Z= 19
    {"Ca", {0.239, 1.000, 0.000}}, //Z= 20
    {"Sc", {0.902, 0.902, 0.902}}, //Z= 21
    {"Ti", {0.749, 0.761, 0.780}}, //Z= 22
    {"V", {0.651, 0.651, 0.671}}, //Z= 23
    {"Cr", {0.541, 0.600, 0.780}}, //Z= 24
    {"Mn", {0.612, 0.478, 0.780}}, //Z= 25
    {"Fe", {0.878, 0.400, 0.200}}, //Z= 26
    {"Co", {0.941, 0.565, 0.627}}, //Z= 27
    {"Ni", {0.314, 0.816, 0.314}}, //Z= 28
    {"Cu", {0.784, 0.502, 0.200}}, //Z= 29
    {"Zn", {0.490, 0.502, 0.690}}, //Z= 30
    {"Ga", {0.761, 0.561, 0.561}}, //Z= 31
    {"Ge", {0.400, 0.561, 0.561}}, //Z= 32
    {"As", {0.741, 0.502, 0.890}}, //Z= 33
    {"Se", {1.000, 0.631, 0.000}}, //Z= 34
    {"Br", {0.651, 0.161, 0.161}}, //Z= 35
    {"Kr", {0.361, 0.722, 0.820}}, //Z= 36
    {"Rb", {0.439, 0.180, 0.690}}, //Z= 37
    {"Sr", {0.000, 1.000, 0.000}}, //Z= 38
    {"Y", {0.580, 1.000, 1.000}}, //Z= 39
    {"Zr", {0.580, 0.878, 0.878}}, //Z= 40
    {"Nb", {0.451, 0.761, 0.788}}, //Z= 41
    {"Mo", {0.329, 0.710, 0.710}}, //Z= 42
    {"Tc", {0.231, 0.620, 0.620}}, //Z= 43
    {"Ru", {0.141, 0.561, 0.561}}, //Z= 44
    {"Rh", {0.039, 0.490, 0.549}}, //Z= 45
    {"Pd", {0.000, 0.412, 0.522}}, //Z= 46
    {"Ag", {0.753, 0.753, 0.753}}, //Z= 47
    {"Cd", {1.000, 0.851, 0.561}}, //Z= 48
    {"In", {0.651, 0.459, 0.451}}, //Z= 49
    {"Sn", {0.400, 0.502, 0.502}}, //Z= 50
    {"Sb", {0.620, 0.388, 0.710}}, //Z= 51
    {"Te", {0.831, 0.478, 0.000}}, //Z= 52
    {"I", {0.580, 0.000, 0.580}}, //Z= 53
    {"Xe", {0.259, 0.620, 0.690}}, //Z= 54
    {"Cs", {0.341, 0.090, 0.561}}, //Z= 55
    {"Ba", {0.000, 0.788, 0.000}}, //Z= 56
    {"La", {0.439, 0.831, 1.000}}, //Z= 57
    {"Ce", {1.000, 1.000, 0.780}}, //Z= 58
    {"Pr", {0.851, 1.000, 0.780}}, //Z= 59
    {"Nd", {0.780, 1.000, 0.780}}, //Z= 60
    {"Pm", {0.639, 1.000, 0.780}}, //Z= 61
    {"Sm", {0.561, 1.000, 0.780}}, //Z= 62
    {"Eu", {0.380, 1.000, 0.780}}, //Z= 63
    {"Gd", {0.271, 1.000, 0.780}}, //Z= 64
    {"Tb", {0.188, 1.000, 0.780}}, //Z= 65
    {"Dy", {0.122, 1.000, 0.780}}, //Z= 66
    {"Ho", {0.000, 1.000, 0.612}}, //Z= 67
    {"Er", {0.000, 0.902, 0.459}}, //Z= 68
    {"Tm", {0.000, 0.831, 0.322}}, //Z= 69
    {"Yb", {0.000, 0.749, 0.220}}, //Z= 70
    {"Lu", {0.000, 0.671, 0.141}}, //Z= 71
    {"Hf", {0.302, 0.761, 1.000}}, //Z= 72
    {"Ta", {0.302, 0.651, 1.000}}, //Z= 73
    {"W", {0.129, 0.580, 0.839}}, //Z= 74
    {"Re", {0.149, 0.490, 0.671}}, //Z= 75
    {"Os", {0.149, 0.400, 0.588}}, //Z= 76
    {"Ir", {0.090, 0.329, 0.529}}, //Z= 77
    {"Pt", {0.816, 0.816, 0.878}}, //Z= 78
    {"Au", {1.000, 0.820, 0.137}}, //Z= 79
    {"Hg", {0.722, 0.722, 0.816}}, //Z= 80
    {"Tl", {0.651, 0.329, 0.302}}, //Z= 81
    {"Pb", {0.341, 0.349, 0.380}}, //Z= 82
    {"Bi", {0.620, 0.310, 0.710}}, //Z= 83
    {"Po", {0.671, 0.361, 0.000}}, //Z= 84
    {"At", {0.459, 0.310, 0.271}}, //Z= 85
    {"Rn", {0.259, 0.510, 0.588}}, //Z= 86
    {"Fr", {0.259, 0.000, 0.400}}, //Z= 87
    {"Ra", {0.000, 0.490, 0.000}}, //Z= 88
    {"Ac", {0.439, 0.671, 0.980}}, //Z= 89
    {"Th", {0.000, 0.729, 1.000}}, //Z= 90
    {"Pa", {0.000, 0.631, 1.000}}, //Z= 91
    {"U", {0.000, 0.561, 1.000}}, //Z= 92
    {"Np", {0.000, 0.502, 1.000}}, //Z= 93
    {"Pu", {0.000, 0.420, 1.000}}, //Z= 94
    {"Am", {0.329, 0.361, 0.949}}, //Z= 95
    {"Cm", {0.471, 0.361, 0.890}}, //Z= 96
    {"Bk", {0.541, 0.310, 0.890}}, //Z= 97
    {"Cf", {0.631, 0.212, 0.831}}, //Z= 98
    {"Es", {0.702, 0.122, 0.831}}, //Z= 99
    {"Fm", {0.702, 0.122, 0.729}}, //Z=100
    {"Md", {0.702, 0.051, 0.651}}, //Z=101
    {"No", {0.741, 0.051, 0.529}}, //Z=102
    {"Lr", {0.780, 0.000, 0.400}}, //Z=103
    {"Rf", {0.800, 0.000, 0.349}}, //Z=104
    {"Db", {0.820, 0.000, 0.310}}, //Z=105
    {"Sg", {0.851, 0.000, 0.271}}, //Z=106
    {"Bh", {0.878, 0.000, 0.220}}, //Z=107
    {"Hs", {0.902, 0.000, 0.180}}, //Z=108
    {"Mt", {0.922, 0.000, 0.149}}, //Z=109
    {"",{0. , 0. , 0.}},
};
#endif
