/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_ktbm.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t34, t35, t39, t41, t43, t46, t47;
  double t49, t50, t51, t52, t53, t54, t56, t57;
  double t60, t62, t63, t67, t70, t71, t72, t74;
  double t76, t79, t80, t81, t82, t86, t90, t94;
  double t98, t101, t102, t106, tzk0;

  mgga_x_ktbm_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ktbm_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = t7 * t18;
  t20 = POW_1_3(rho[0]);
  t21 = M_CBRT6;
  t22 = params->at * t21;
  t23 = M_PI * M_PI;
  t24 = POW_1_3(t23);
  t25 = t24 * t24;
  t26 = 0.1e1 / t25;
  t27 = t22 * t26;
  t28 = M_CBRT2;
  t29 = t28 * t28;
  t30 = sigma[0] * t29;
  t31 = rho[0] * rho[0];
  t32 = t20 * t20;
  t34 = 0.1e1 / t32 / t31;
  t35 = t30 * t34;
  t39 = params->bt * tau[0] * t29;
  t41 = 0.1e1 / t32 / rho[0];
  t43 = t41 * t21 * t26;
  t46 = t21 * t21;
  t47 = params->a2t * t46;
  t49 = 0.1e1 / t24 / t23;
  t50 = t47 * t49;
  t51 = sigma[0] * sigma[0];
  t52 = t51 * t28;
  t53 = t31 * t31;
  t54 = t53 * rho[0];
  t56 = 0.1e1 / t20 / t54;
  t57 = t52 * t56;
  t60 = tau[0] * tau[0];
  t62 = params->b2t * t60 * t28;
  t63 = t31 * rho[0];
  t67 = 0.1e1 / t20 / t63 * t46 * t49;
  t70 = params->xt * t46;
  t71 = t70 * t49;
  t72 = sigma[0] * t28;
  t74 = 0.1e1 / t20 / t53;
  t76 = t72 * t74 * tau[0];
  t79 = params->ct + t27 * t35 / 0.24e2 + 0.5e1 / 0.9e1 * t39 * t43 + t50 * t57 / 0.288e3 + 0.5e2 / 0.81e2 * t62 * t67 + 0.5e1 / 0.108e3 * t71 * t76;
  t80 = t20 * t79;
  t81 = params->ab * t21;
  t82 = t81 * t26;
  t86 = params->bb * tau[0] * t29;
  t90 = params->a2b * t46 * t49;
  t94 = params->b2b * t60 * t28;
  t98 = params->xb * t46 * t49;
  t101 = params->cb + t82 * t35 / 0.24e2 + 0.5e1 / 0.9e1 * t86 * t43 + t90 * t57 / 0.288e3 + 0.5e2 / 0.81e2 * t94 * t67 + 0.5e1 / 0.108e3 * t98 * t76;
  t102 = 0.1e1 / t101;
  t106 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t80 * t102);
  tzk0 = 0.2e1 * t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t34, t35, t39, t41, t43, t46, t47;
  double t49, t50, t51, t52, t53, t54, t56, t57;
  double t60, t62, t63, t67, t70, t71, t72, t74;
  double t76, t79, t80, t81, t82, t86, t90, t94;
  double t98, t101, t102, t106, tzk0;

  double t107, t108, t113, t114, t118, t121, t123, t124;
  double t128, t132, t135, t136, t140, t141, t152, t153;
  double t158, tvrho0, t161, t162, t165, t169, t172, t173;
  double t182, t183, t188, tvsigma0, tvlapl0, t190, t194, t197;
  double t200, t201, t204, t208, t213, t214, t219, tvtau0;

  mgga_x_ktbm_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ktbm_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = t7 * t18;
  t20 = POW_1_3(rho[0]);
  t21 = M_CBRT6;
  t22 = params->at * t21;
  t23 = M_PI * M_PI;
  t24 = POW_1_3(t23);
  t25 = t24 * t24;
  t26 = 0.1e1 / t25;
  t27 = t22 * t26;
  t28 = M_CBRT2;
  t29 = t28 * t28;
  t30 = sigma[0] * t29;
  t31 = rho[0] * rho[0];
  t32 = t20 * t20;
  t34 = 0.1e1 / t32 / t31;
  t35 = t30 * t34;
  t39 = params->bt * tau[0] * t29;
  t41 = 0.1e1 / t32 / rho[0];
  t43 = t41 * t21 * t26;
  t46 = t21 * t21;
  t47 = params->a2t * t46;
  t49 = 0.1e1 / t24 / t23;
  t50 = t47 * t49;
  t51 = sigma[0] * sigma[0];
  t52 = t51 * t28;
  t53 = t31 * t31;
  t54 = t53 * rho[0];
  t56 = 0.1e1 / t20 / t54;
  t57 = t52 * t56;
  t60 = tau[0] * tau[0];
  t62 = params->b2t * t60 * t28;
  t63 = t31 * rho[0];
  t67 = 0.1e1 / t20 / t63 * t46 * t49;
  t70 = params->xt * t46;
  t71 = t70 * t49;
  t72 = sigma[0] * t28;
  t74 = 0.1e1 / t20 / t53;
  t76 = t72 * t74 * tau[0];
  t79 = params->ct + t27 * t35 / 0.24e2 + 0.5e1 / 0.9e1 * t39 * t43 + t50 * t57 / 0.288e3 + 0.5e2 / 0.81e2 * t62 * t67 + 0.5e1 / 0.108e3 * t71 * t76;
  t80 = t20 * t79;
  t81 = params->ab * t21;
  t82 = t81 * t26;
  t86 = params->bb * tau[0] * t29;
  t90 = params->a2b * t46 * t49;
  t94 = params->b2b * t60 * t28;
  t98 = params->xb * t46 * t49;
  t101 = params->cb + t82 * t35 / 0.24e2 + 0.5e1 / 0.9e1 * t86 * t43 + t90 * t57 / 0.288e3 + 0.5e2 / 0.81e2 * t94 * t67 + 0.5e1 / 0.108e3 * t98 * t76;
  t102 = 0.1e1 / t101;
  t106 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t80 * t102);
  tzk0 = 0.2e1 * t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t107 = 0.1e1 / t32;
  t108 = t107 * t79;
  t113 = 0.1e1 / t32 / t63;
  t114 = t30 * t113;
  t118 = t34 * t21 * t26;
  t121 = t53 * t31;
  t123 = 0.1e1 / t20 / t121;
  t124 = t52 * t123;
  t128 = t74 * t46 * t49;
  t132 = t72 * t56 * tau[0];
  t135 = -t27 * t114 / 0.9e1 - 0.25e2 / 0.27e2 * t39 * t118 - t50 * t124 / 0.54e2 - 0.5e3 / 0.243e3 * t62 * t128 - 0.65e2 / 0.324e3 * t71 * t132;
  t136 = t20 * t135;
  t140 = t101 * t101;
  t141 = 0.1e1 / t140;
  t152 = -t82 * t114 / 0.9e1 - 0.25e2 / 0.27e2 * t86 * t118 - t90 * t124 / 0.54e2 - 0.5e3 / 0.243e3 * t94 * t128 - 0.65e2 / 0.324e3 * t98 * t132;
  t153 = t141 * t152;
  t158 = my_piecewise3(t3, 0, -t19 * t108 * t102 / 0.8e1 - 0.3e1 / 0.8e1 * t19 * t136 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t153);
  tvrho0 = 0.2e1 * rho[0] * t158 + 0.2e1 * t106;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t161 = t26 * t29;
  t162 = t161 * t34;
  t165 = t72 * t56;
  t169 = t28 * t74 * tau[0];
  t172 = t22 * t162 / 0.24e2 + t50 * t165 / 0.144e3 + 0.5e1 / 0.108e3 * t71 * t169;
  t173 = t20 * t172;
  t182 = t81 * t162 / 0.24e2 + t90 * t165 / 0.144e3 + 0.5e1 / 0.108e3 * t98 * t169;
  t183 = t141 * t182;
  t188 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t173 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t183);
  tvsigma0 = 0.2e1 * rho[0] * t188;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t190 = params->bt * t29;
  t194 = params->b2t * tau[0] * t28;
  t197 = t72 * t74;
  t200 = 0.5e1 / 0.9e1 * t190 * t43 + 0.1e3 / 0.81e2 * t194 * t67 + 0.5e1 / 0.108e3 * t71 * t197;
  t201 = t20 * t200;
  t204 = params->bb * t29;
  t208 = params->b2b * tau[0] * t28;
  t213 = 0.5e1 / 0.9e1 * t204 * t43 + 0.1e3 / 0.81e2 * t208 * t67 + 0.5e1 / 0.108e3 * t98 * t197;
  t214 = t141 * t213;
  t219 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t201 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t214);
  tvtau0 = 0.2e1 * rho[0] * t219;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t34, t35, t39, t41, t43, t46, t47;
  double t49, t50, t51, t52, t53, t54, t56, t57;
  double t60, t62, t63, t67, t70, t71, t72, t74;
  double t76, t79, t80, t81, t82, t86, t90, t94;
  double t98, t101, t102, t106, tzk0;

  double t107, t108, t113, t114, t118, t121, t123, t124;
  double t128, t132, t135, t136, t140, t141, t152, t153;
  double t158, tvrho0, t161, t162, t165, t169, t172, t173;
  double t182, t183, t188, tvsigma0, tvlapl0, t190, t194, t197;
  double t200, t201, t204, t208, t213, t214, t219, tvtau0;

  double t222, t226, t234, t235, t239, t242, t244, t245;
  double t249, t253, t256, t257, t265, t266, t267, t281;
  double t282, t287, tv2rho20, t290, t294, t297, t301, t304;
  double t305, t319, t320, t321, t322, t331, t332, t337;
  double tv2rhosigma0, tv2rholapl0, t340, t350, t351, t364, t365, t374;
  double t375, t380, tv2rhotau0, t383, t384, t385, t386, t387;
  double t388, t394, t395, t400, t402, t403, t404, t408;
  double tv2sigma20, tv2sigmalapl0, t410, t411, t412, t413, t422, t423;
  double t427, t429, t433, tv2sigmatau0, tv2lapl20, tv2lapltau0, t435, t436;
  double t440, t446, t447, t452, t454, t458, tv2tau20;

  mgga_x_ktbm_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ktbm_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = t7 * t18;
  t20 = POW_1_3(rho[0]);
  t21 = M_CBRT6;
  t22 = params->at * t21;
  t23 = M_PI * M_PI;
  t24 = POW_1_3(t23);
  t25 = t24 * t24;
  t26 = 0.1e1 / t25;
  t27 = t22 * t26;
  t28 = M_CBRT2;
  t29 = t28 * t28;
  t30 = sigma[0] * t29;
  t31 = rho[0] * rho[0];
  t32 = t20 * t20;
  t34 = 0.1e1 / t32 / t31;
  t35 = t30 * t34;
  t39 = params->bt * tau[0] * t29;
  t41 = 0.1e1 / t32 / rho[0];
  t43 = t41 * t21 * t26;
  t46 = t21 * t21;
  t47 = params->a2t * t46;
  t49 = 0.1e1 / t24 / t23;
  t50 = t47 * t49;
  t51 = sigma[0] * sigma[0];
  t52 = t51 * t28;
  t53 = t31 * t31;
  t54 = t53 * rho[0];
  t56 = 0.1e1 / t20 / t54;
  t57 = t52 * t56;
  t60 = tau[0] * tau[0];
  t62 = params->b2t * t60 * t28;
  t63 = t31 * rho[0];
  t67 = 0.1e1 / t20 / t63 * t46 * t49;
  t70 = params->xt * t46;
  t71 = t70 * t49;
  t72 = sigma[0] * t28;
  t74 = 0.1e1 / t20 / t53;
  t76 = t72 * t74 * tau[0];
  t79 = params->ct + t27 * t35 / 0.24e2 + 0.5e1 / 0.9e1 * t39 * t43 + t50 * t57 / 0.288e3 + 0.5e2 / 0.81e2 * t62 * t67 + 0.5e1 / 0.108e3 * t71 * t76;
  t80 = t20 * t79;
  t81 = params->ab * t21;
  t82 = t81 * t26;
  t86 = params->bb * tau[0] * t29;
  t90 = params->a2b * t46 * t49;
  t94 = params->b2b * t60 * t28;
  t98 = params->xb * t46 * t49;
  t101 = params->cb + t82 * t35 / 0.24e2 + 0.5e1 / 0.9e1 * t86 * t43 + t90 * t57 / 0.288e3 + 0.5e2 / 0.81e2 * t94 * t67 + 0.5e1 / 0.108e3 * t98 * t76;
  t102 = 0.1e1 / t101;
  t106 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t80 * t102);
  tzk0 = 0.2e1 * t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t107 = 0.1e1 / t32;
  t108 = t107 * t79;
  t113 = 0.1e1 / t32 / t63;
  t114 = t30 * t113;
  t118 = t34 * t21 * t26;
  t121 = t53 * t31;
  t123 = 0.1e1 / t20 / t121;
  t124 = t52 * t123;
  t128 = t74 * t46 * t49;
  t132 = t72 * t56 * tau[0];
  t135 = -t27 * t114 / 0.9e1 - 0.25e2 / 0.27e2 * t39 * t118 - t50 * t124 / 0.54e2 - 0.5e3 / 0.243e3 * t62 * t128 - 0.65e2 / 0.324e3 * t71 * t132;
  t136 = t20 * t135;
  t140 = t101 * t101;
  t141 = 0.1e1 / t140;
  t152 = -t82 * t114 / 0.9e1 - 0.25e2 / 0.27e2 * t86 * t118 - t90 * t124 / 0.54e2 - 0.5e3 / 0.243e3 * t94 * t128 - 0.65e2 / 0.324e3 * t98 * t132;
  t153 = t141 * t152;
  t158 = my_piecewise3(t3, 0, -t19 * t108 * t102 / 0.8e1 - 0.3e1 / 0.8e1 * t19 * t136 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t153);
  tvrho0 = 0.2e1 * rho[0] * t158 + 0.2e1 * t106;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t161 = t26 * t29;
  t162 = t161 * t34;
  t165 = t72 * t56;
  t169 = t28 * t74 * tau[0];
  t172 = t22 * t162 / 0.24e2 + t50 * t165 / 0.144e3 + 0.5e1 / 0.108e3 * t71 * t169;
  t173 = t20 * t172;
  t182 = t81 * t162 / 0.24e2 + t90 * t165 / 0.144e3 + 0.5e1 / 0.108e3 * t98 * t169;
  t183 = t141 * t182;
  t188 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t173 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t183);
  tvsigma0 = 0.2e1 * rho[0] * t188;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t190 = params->bt * t29;
  t194 = params->b2t * tau[0] * t28;
  t197 = t72 * t74;
  t200 = 0.5e1 / 0.9e1 * t190 * t43 + 0.1e3 / 0.81e2 * t194 * t67 + 0.5e1 / 0.108e3 * t71 * t197;
  t201 = t20 * t200;
  t204 = params->bb * t29;
  t208 = params->b2b * tau[0] * t28;
  t213 = 0.5e1 / 0.9e1 * t204 * t43 + 0.1e3 / 0.81e2 * t208 * t67 + 0.5e1 / 0.108e3 * t98 * t197;
  t214 = t141 * t213;
  t219 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t201 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t214);
  tvtau0 = 0.2e1 * rho[0] * t219;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t222 = t41 * t79;
  t226 = t107 * t135;
  t234 = 0.1e1 / t32 / t53;
  t235 = t30 * t234;
  t239 = t113 * t21 * t26;
  t242 = t53 * t63;
  t244 = 0.1e1 / t20 / t242;
  t245 = t52 * t244;
  t249 = t56 * t46 * t49;
  t253 = t72 * t123 * tau[0];
  t256 = 0.11e2 / 0.27e2 * t27 * t235 + 0.2e3 / 0.81e2 * t39 * t239 + 0.19e2 / 0.162e3 * t50 * t245 + 0.65e4 / 0.729e3 * t62 * t249 + 0.26e3 / 0.243e3 * t71 * t253;
  t257 = t20 * t256;
  t265 = 0.1e1 / t140 / t101;
  t266 = t152 * t152;
  t267 = t265 * t266;
  t281 = 0.11e2 / 0.27e2 * t82 * t235 + 0.2e3 / 0.81e2 * t86 * t239 + 0.19e2 / 0.162e3 * t90 * t245 + 0.65e4 / 0.729e3 * t94 * t249 + 0.26e3 / 0.243e3 * t98 * t253;
  t282 = t141 * t281;
  t287 = my_piecewise3(t3, 0, t19 * t222 * t102 / 0.12e2 - t19 * t226 * t102 / 0.4e1 + t19 * t108 * t153 / 0.4e1 - 0.3e1 / 0.8e1 * t19 * t257 * t102 + 0.3e1 / 0.4e1 * t19 * t136 * t153 - 0.3e1 / 0.4e1 * t19 * t80 * t267 + 0.3e1 / 0.8e1 * t19 * t80 * t282);
  tv2rho20 = 0.2e1 * rho[0] * t287 + 0.4e1 * t158;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t290 = t107 * t172;
  t294 = t161 * t113;
  t297 = t72 * t123;
  t301 = t28 * t56 * tau[0];
  t304 = -t22 * t294 / 0.9e1 - t50 * t297 / 0.27e2 - 0.65e2 / 0.324e3 * t71 * t301;
  t305 = t20 * t304;
  t319 = t7 * t18 * t20;
  t320 = t79 * t265;
  t321 = t182 * t152;
  t322 = t320 * t321;
  t331 = -t81 * t294 / 0.9e1 - t90 * t297 / 0.27e2 - 0.65e2 / 0.324e3 * t98 * t301;
  t332 = t141 * t331;
  t337 = my_piecewise3(t3, 0, -t19 * t290 * t102 / 0.8e1 - 0.3e1 / 0.8e1 * t19 * t305 * t102 + 0.3e1 / 0.8e1 * t19 * t173 * t153 + t19 * t108 * t183 / 0.8e1 + 0.3e1 / 0.8e1 * t19 * t136 * t183 - 0.3e1 / 0.4e1 * t319 * t322 + 0.3e1 / 0.8e1 * t19 * t80 * t332);
  tv2rhosigma0 = 0.2e1 * rho[0] * t337 + 0.2e1 * t188;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t340 = t107 * t200;
  t350 = -0.25e2 / 0.27e2 * t190 * t118 - 0.1e4 / 0.243e3 * t194 * t128 - 0.65e2 / 0.324e3 * t71 * t165;
  t351 = t20 * t350;
  t364 = t213 * t152;
  t365 = t320 * t364;
  t374 = -0.25e2 / 0.27e2 * t204 * t118 - 0.1e4 / 0.243e3 * t208 * t128 - 0.65e2 / 0.324e3 * t98 * t165;
  t375 = t141 * t374;
  t380 = my_piecewise3(t3, 0, -t19 * t340 * t102 / 0.8e1 - 0.3e1 / 0.8e1 * t19 * t351 * t102 + 0.3e1 / 0.8e1 * t19 * t201 * t153 + t19 * t108 * t214 / 0.8e1 + 0.3e1 / 0.8e1 * t19 * t136 * t214 - 0.3e1 / 0.4e1 * t319 * t365 + 0.3e1 / 0.8e1 * t19 * t80 * t375);
  tv2rhotau0 = 0.2e1 * rho[0] * t380 + 0.2e1 * t219;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t383 = 0.1e1 / t54;
  t384 = t18 * t383;
  t385 = t7 * t384;
  t386 = t49 * t28;
  t387 = t386 * t102;
  t388 = t47 * t387;
  t394 = t182 * t182;
  t395 = t265 * t394;
  t400 = t7 * t384 * t79;
  t402 = t46 * t49;
  t403 = t402 * t28;
  t404 = t141 * params->a2b * t403;
  t408 = my_piecewise3(t3, 0, -t385 * t388 / 0.384e3 + 0.3e1 / 0.4e1 * t19 * t173 * t183 - 0.3e1 / 0.4e1 * t19 * t80 * t395 + t400 * t404 / 0.384e3);
  tv2sigma20 = 0.2e1 * rho[0] * t408;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t410 = 0.1e1 / t53;
  t411 = t18 * t410;
  t412 = t7 * t411;
  t413 = t70 * t387;
  t422 = t213 * t182;
  t423 = t320 * t422;
  t427 = t7 * t411 * t79;
  t429 = t141 * params->xb * t403;
  t433 = my_piecewise3(t3, 0, -0.5e1 / 0.288e3 * t412 * t413 + 0.3e1 / 0.8e1 * t19 * t201 * t183 + 0.3e1 / 0.8e1 * t19 * t173 * t214 - 0.3e1 / 0.4e1 * t319 * t423 + 0.5e1 / 0.288e3 * t427 * t429);
  tv2sigmatau0 = 0.2e1 * rho[0] * t433;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t435 = 0.1e1 / t63;
  t436 = t18 * t435;
  t440 = params->b2t * t28 * t402 * t102;
  t446 = t213 * t213;
  t447 = t265 * t446;
  t452 = t7 * t436 * t79;
  t454 = t141 * params->b2b * t403;
  t458 = my_piecewise3(t3, 0, -0.25e2 / 0.54e2 * t7 * t436 * t440 + 0.3e1 / 0.4e1 * t19 * t201 * t214 - 0.3e1 / 0.4e1 * t19 * t80 * t447 + 0.25e2 / 0.54e2 * t452 * t454);
  tv2tau20 = 0.2e1 * rho[0] * t458;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t34, t35, t39, t41, t43, t46, t47;
  double t49, t50, t51, t52, t53, t54, t56, t57;
  double t60, t62, t63, t67, t70, t71, t72, t74;
  double t76, t79, t80, t81, t82, t86, t90, t94;
  double t98, t101, t102, t106, tzk0;

  double t107, t108, t113, t114, t118, t121, t123, t124;
  double t128, t132, t135, t136, t140, t141, t152, t153;
  double t158, tvrho0, t161, t162, t165, t169, t172, t173;
  double t182, t183, t188, tvsigma0, tvlapl0, t190, t194, t197;
  double t200, t201, t204, t208, t213, t214, t219, tvtau0;

  double t222, t226, t234, t235, t239, t242, t244, t245;
  double t249, t253, t256, t257, t265, t266, t267, t281;
  double t282, t287, tv2rho20, t290, t294, t297, t301, t304;
  double t305, t319, t320, t321, t322, t331, t332, t337;
  double tv2rhosigma0, tv2rholapl0, t340, t350, t351, t364, t365, t374;
  double t375, t380, tv2rhotau0, t383, t384, t385, t386, t387;
  double t388, t394, t395, t400, t402, t403, t404, t408;
  double tv2sigma20, tv2sigmalapl0, t410, t411, t412, t413, t422, t423;
  double t427, t429, t433, tv2sigmatau0, tv2lapl20, tv2lapltau0, t435, t436;
  double t440, t446, t447, t452, t454, t458, tv2tau20;

  double t467, t468, t469, t470, t474, t475, t479, t480;
  double t484, t487, t489, t490, t494, t498, t501, t502;
  double t506, t510, t524, t525, t529, t548, t549, tv3rho30;
  double t553, t554, t555, t558, t562, t565, t569, t572;
  double t573, t581, t584, t585, t588, t589, t592, t593;
  double t620, t621, t625, t635, t636, tv3rho2sigma0, tv3rho2lapl0, t640;
  double t650, t651, t673, t674, t678, t691, t692, t695;
  double t698, t699, t702, t703, t714, t715, tv3rho2tau0, t719;
  double t720, t724, t725, t727, t736, t737, t749, t750;
  double t753, t754, t758, t762, t766, t767, t768, t771;
  double t772, tv3rhosigma20, tv3rhosigmalapl0, t778, t787, t788, t800, t808;
  double t811, t812, t815, t816, t819, t820, t826, t829;
  double t830, t831, t834, t835, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t841;
  double t850, t862, t863, t866, t867, t873, t876, t877;
  double t878, t879, t882, t883, tv3rhotau20, t887, t894, t897;
  double t898, t902, t904, t908, tv3sigma30, tv3sigma2lapl0, t916, t920;
  double t923, t927, t930, t931, t935, t938, t940, t944;
  double tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, t950, t954, t960, t961, t965;
  double t969, t972, t973, t977, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20;
  double t985, t988, t989, t994, t998, tv3tau30;

  mgga_x_ktbm_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ktbm_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = t7 * t18;
  t20 = POW_1_3(rho[0]);
  t21 = M_CBRT6;
  t22 = params->at * t21;
  t23 = M_PI * M_PI;
  t24 = POW_1_3(t23);
  t25 = t24 * t24;
  t26 = 0.1e1 / t25;
  t27 = t22 * t26;
  t28 = M_CBRT2;
  t29 = t28 * t28;
  t30 = sigma[0] * t29;
  t31 = rho[0] * rho[0];
  t32 = t20 * t20;
  t34 = 0.1e1 / t32 / t31;
  t35 = t30 * t34;
  t39 = params->bt * tau[0] * t29;
  t41 = 0.1e1 / t32 / rho[0];
  t43 = t41 * t21 * t26;
  t46 = t21 * t21;
  t47 = params->a2t * t46;
  t49 = 0.1e1 / t24 / t23;
  t50 = t47 * t49;
  t51 = sigma[0] * sigma[0];
  t52 = t51 * t28;
  t53 = t31 * t31;
  t54 = t53 * rho[0];
  t56 = 0.1e1 / t20 / t54;
  t57 = t52 * t56;
  t60 = tau[0] * tau[0];
  t62 = params->b2t * t60 * t28;
  t63 = t31 * rho[0];
  t67 = 0.1e1 / t20 / t63 * t46 * t49;
  t70 = params->xt * t46;
  t71 = t70 * t49;
  t72 = sigma[0] * t28;
  t74 = 0.1e1 / t20 / t53;
  t76 = t72 * t74 * tau[0];
  t79 = params->ct + t27 * t35 / 0.24e2 + 0.5e1 / 0.9e1 * t39 * t43 + t50 * t57 / 0.288e3 + 0.5e2 / 0.81e2 * t62 * t67 + 0.5e1 / 0.108e3 * t71 * t76;
  t80 = t20 * t79;
  t81 = params->ab * t21;
  t82 = t81 * t26;
  t86 = params->bb * tau[0] * t29;
  t90 = params->a2b * t46 * t49;
  t94 = params->b2b * t60 * t28;
  t98 = params->xb * t46 * t49;
  t101 = params->cb + t82 * t35 / 0.24e2 + 0.5e1 / 0.9e1 * t86 * t43 + t90 * t57 / 0.288e3 + 0.5e2 / 0.81e2 * t94 * t67 + 0.5e1 / 0.108e3 * t98 * t76;
  t102 = 0.1e1 / t101;
  t106 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t80 * t102);
  tzk0 = 0.2e1 * t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t107 = 0.1e1 / t32;
  t108 = t107 * t79;
  t113 = 0.1e1 / t32 / t63;
  t114 = t30 * t113;
  t118 = t34 * t21 * t26;
  t121 = t53 * t31;
  t123 = 0.1e1 / t20 / t121;
  t124 = t52 * t123;
  t128 = t74 * t46 * t49;
  t132 = t72 * t56 * tau[0];
  t135 = -t27 * t114 / 0.9e1 - 0.25e2 / 0.27e2 * t39 * t118 - t50 * t124 / 0.54e2 - 0.5e3 / 0.243e3 * t62 * t128 - 0.65e2 / 0.324e3 * t71 * t132;
  t136 = t20 * t135;
  t140 = t101 * t101;
  t141 = 0.1e1 / t140;
  t152 = -t82 * t114 / 0.9e1 - 0.25e2 / 0.27e2 * t86 * t118 - t90 * t124 / 0.54e2 - 0.5e3 / 0.243e3 * t94 * t128 - 0.65e2 / 0.324e3 * t98 * t132;
  t153 = t141 * t152;
  t158 = my_piecewise3(t3, 0, -t19 * t108 * t102 / 0.8e1 - 0.3e1 / 0.8e1 * t19 * t136 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t153);
  tvrho0 = 0.2e1 * rho[0] * t158 + 0.2e1 * t106;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t161 = t26 * t29;
  t162 = t161 * t34;
  t165 = t72 * t56;
  t169 = t28 * t74 * tau[0];
  t172 = t22 * t162 / 0.24e2 + t50 * t165 / 0.144e3 + 0.5e1 / 0.108e3 * t71 * t169;
  t173 = t20 * t172;
  t182 = t81 * t162 / 0.24e2 + t90 * t165 / 0.144e3 + 0.5e1 / 0.108e3 * t98 * t169;
  t183 = t141 * t182;
  t188 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t173 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t183);
  tvsigma0 = 0.2e1 * rho[0] * t188;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t190 = params->bt * t29;
  t194 = params->b2t * tau[0] * t28;
  t197 = t72 * t74;
  t200 = 0.5e1 / 0.9e1 * t190 * t43 + 0.1e3 / 0.81e2 * t194 * t67 + 0.5e1 / 0.108e3 * t71 * t197;
  t201 = t20 * t200;
  t204 = params->bb * t29;
  t208 = params->b2b * tau[0] * t28;
  t213 = 0.5e1 / 0.9e1 * t204 * t43 + 0.1e3 / 0.81e2 * t208 * t67 + 0.5e1 / 0.108e3 * t98 * t197;
  t214 = t141 * t213;
  t219 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t201 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t214);
  tvtau0 = 0.2e1 * rho[0] * t219;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t222 = t41 * t79;
  t226 = t107 * t135;
  t234 = 0.1e1 / t32 / t53;
  t235 = t30 * t234;
  t239 = t113 * t21 * t26;
  t242 = t53 * t63;
  t244 = 0.1e1 / t20 / t242;
  t245 = t52 * t244;
  t249 = t56 * t46 * t49;
  t253 = t72 * t123 * tau[0];
  t256 = 0.11e2 / 0.27e2 * t27 * t235 + 0.2e3 / 0.81e2 * t39 * t239 + 0.19e2 / 0.162e3 * t50 * t245 + 0.65e4 / 0.729e3 * t62 * t249 + 0.26e3 / 0.243e3 * t71 * t253;
  t257 = t20 * t256;
  t265 = 0.1e1 / t140 / t101;
  t266 = t152 * t152;
  t267 = t265 * t266;
  t281 = 0.11e2 / 0.27e2 * t82 * t235 + 0.2e3 / 0.81e2 * t86 * t239 + 0.19e2 / 0.162e3 * t90 * t245 + 0.65e4 / 0.729e3 * t94 * t249 + 0.26e3 / 0.243e3 * t98 * t253;
  t282 = t141 * t281;
  t287 = my_piecewise3(t3, 0, t19 * t222 * t102 / 0.12e2 - t19 * t226 * t102 / 0.4e1 + t19 * t108 * t153 / 0.4e1 - 0.3e1 / 0.8e1 * t19 * t257 * t102 + 0.3e1 / 0.4e1 * t19 * t136 * t153 - 0.3e1 / 0.4e1 * t19 * t80 * t267 + 0.3e1 / 0.8e1 * t19 * t80 * t282);
  tv2rho20 = 0.2e1 * rho[0] * t287 + 0.4e1 * t158;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t290 = t107 * t172;
  t294 = t161 * t113;
  t297 = t72 * t123;
  t301 = t28 * t56 * tau[0];
  t304 = -t22 * t294 / 0.9e1 - t50 * t297 / 0.27e2 - 0.65e2 / 0.324e3 * t71 * t301;
  t305 = t20 * t304;
  t319 = t7 * t18 * t20;
  t320 = t79 * t265;
  t321 = t182 * t152;
  t322 = t320 * t321;
  t331 = -t81 * t294 / 0.9e1 - t90 * t297 / 0.27e2 - 0.65e2 / 0.324e3 * t98 * t301;
  t332 = t141 * t331;
  t337 = my_piecewise3(t3, 0, -t19 * t290 * t102 / 0.8e1 - 0.3e1 / 0.8e1 * t19 * t305 * t102 + 0.3e1 / 0.8e1 * t19 * t173 * t153 + t19 * t108 * t183 / 0.8e1 + 0.3e1 / 0.8e1 * t19 * t136 * t183 - 0.3e1 / 0.4e1 * t319 * t322 + 0.3e1 / 0.8e1 * t19 * t80 * t332);
  tv2rhosigma0 = 0.2e1 * rho[0] * t337 + 0.2e1 * t188;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t340 = t107 * t200;
  t350 = -0.25e2 / 0.27e2 * t190 * t118 - 0.1e4 / 0.243e3 * t194 * t128 - 0.65e2 / 0.324e3 * t71 * t165;
  t351 = t20 * t350;
  t364 = t213 * t152;
  t365 = t320 * t364;
  t374 = -0.25e2 / 0.27e2 * t204 * t118 - 0.1e4 / 0.243e3 * t208 * t128 - 0.65e2 / 0.324e3 * t98 * t165;
  t375 = t141 * t374;
  t380 = my_piecewise3(t3, 0, -t19 * t340 * t102 / 0.8e1 - 0.3e1 / 0.8e1 * t19 * t351 * t102 + 0.3e1 / 0.8e1 * t19 * t201 * t153 + t19 * t108 * t214 / 0.8e1 + 0.3e1 / 0.8e1 * t19 * t136 * t214 - 0.3e1 / 0.4e1 * t319 * t365 + 0.3e1 / 0.8e1 * t19 * t80 * t375);
  tv2rhotau0 = 0.2e1 * rho[0] * t380 + 0.2e1 * t219;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t383 = 0.1e1 / t54;
  t384 = t18 * t383;
  t385 = t7 * t384;
  t386 = t49 * t28;
  t387 = t386 * t102;
  t388 = t47 * t387;
  t394 = t182 * t182;
  t395 = t265 * t394;
  t400 = t7 * t384 * t79;
  t402 = t46 * t49;
  t403 = t402 * t28;
  t404 = t141 * params->a2b * t403;
  t408 = my_piecewise3(t3, 0, -t385 * t388 / 0.384e3 + 0.3e1 / 0.4e1 * t19 * t173 * t183 - 0.3e1 / 0.4e1 * t19 * t80 * t395 + t400 * t404 / 0.384e3);
  tv2sigma20 = 0.2e1 * rho[0] * t408;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t410 = 0.1e1 / t53;
  t411 = t18 * t410;
  t412 = t7 * t411;
  t413 = t70 * t387;
  t422 = t213 * t182;
  t423 = t320 * t422;
  t427 = t7 * t411 * t79;
  t429 = t141 * params->xb * t403;
  t433 = my_piecewise3(t3, 0, -0.5e1 / 0.288e3 * t412 * t413 + 0.3e1 / 0.8e1 * t19 * t201 * t183 + 0.3e1 / 0.8e1 * t19 * t173 * t214 - 0.3e1 / 0.4e1 * t319 * t423 + 0.5e1 / 0.288e3 * t427 * t429);
  tv2sigmatau0 = 0.2e1 * rho[0] * t433;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t435 = 0.1e1 / t63;
  t436 = t18 * t435;
  t440 = params->b2t * t28 * t402 * t102;
  t446 = t213 * t213;
  t447 = t265 * t446;
  t452 = t7 * t436 * t79;
  t454 = t141 * params->b2b * t403;
  t458 = my_piecewise3(t3, 0, -0.25e2 / 0.54e2 * t7 * t436 * t440 + 0.3e1 / 0.4e1 * t19 * t201 * t214 - 0.3e1 / 0.4e1 * t19 * t80 * t447 + 0.25e2 / 0.54e2 * t452 * t454);
  tv2tau20 = 0.2e1 * rho[0] * t458;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t467 = t140 * t140;
  t468 = 0.1e1 / t467;
  t469 = t266 * t152;
  t470 = t468 * t469;
  t474 = t152 * t281;
  t475 = t320 * t474;
  t479 = 0.1e1 / t32 / t54;
  t480 = t30 * t479;
  t484 = t234 * t21 * t26;
  t487 = t53 * t53;
  t489 = 0.1e1 / t20 / t487;
  t490 = t52 * t489;
  t494 = t123 * t46 * t49;
  t498 = t72 * t244 * tau[0];
  t501 = -0.154e3 / 0.81e2 * t27 * t480 - 0.22e4 / 0.243e3 * t39 * t484 - 0.209e3 / 0.243e3 * t50 * t490 - 0.104e6 / 0.2187e4 * t62 * t494 - 0.494e4 / 0.729e3 * t71 * t498;
  t502 = t20 * t501;
  t506 = t41 * t135;
  t510 = t107 * t256;
  t524 = -0.154e3 / 0.81e2 * t82 * t480 - 0.22e4 / 0.243e3 * t86 * t484 - 0.209e3 / 0.243e3 * t90 * t490 - 0.104e6 / 0.2187e4 * t94 * t494 - 0.494e4 / 0.729e3 * t98 * t498;
  t525 = t141 * t524;
  t529 = t34 * t79;
  t548 = -0.3e1 / 0.4e1 * t19 * t108 * t267 - 0.9e1 / 0.4e1 * t19 * t136 * t267 + 0.9e1 / 0.4e1 * t19 * t80 * t470 - 0.9e1 / 0.4e1 * t319 * t475 - 0.3e1 / 0.8e1 * t19 * t502 * t102 + t19 * t506 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t19 * t510 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t525 - 0.5e1 / 0.36e2 * t19 * t529 * t102 - t19 * t222 * t153 / 0.4e1 + 0.3e1 / 0.4e1 * t19 * t226 * t153 + 0.3e1 / 0.8e1 * t19 * t108 * t282 + 0.9e1 / 0.8e1 * t19 * t257 * t153 + 0.9e1 / 0.8e1 * t19 * t136 * t282;
  t549 = my_piecewise3(t3, 0, t548);
  tv3rho30 = 0.2e1 * rho[0] * t549 + 0.6e1 * t287;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t553 = t79 * t468;
  t554 = t182 * t266;
  t555 = t553 * t554;
  t558 = t107 * t304;
  t562 = t161 * t234;
  t565 = t72 * t244;
  t569 = t28 * t123 * tau[0];
  t572 = 0.11e2 / 0.27e2 * t22 * t562 + 0.19e2 / 0.81e2 * t50 * t565 + 0.26e3 / 0.243e3 * t71 * t569;
  t573 = t20 * t572;
  t581 = t7 * t18 * t107;
  t584 = t135 * t265;
  t585 = t584 * t321;
  t588 = t331 * t152;
  t589 = t320 * t588;
  t592 = t182 * t281;
  t593 = t320 * t592;
  t620 = 0.11e2 / 0.27e2 * t81 * t562 + 0.19e2 / 0.81e2 * t90 * t565 + 0.26e3 / 0.243e3 * t98 * t569;
  t621 = t141 * t620;
  t625 = t41 * t172;
  t635 = 0.9e1 / 0.4e1 * t319 * t555 - t19 * t558 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t19 * t573 * t102 - t19 * t222 * t183 / 0.12e2 - t581 * t322 / 0.2e1 - 0.3e1 / 0.2e1 * t319 * t585 - 0.3e1 / 0.2e1 * t319 * t589 - 0.3e1 / 0.4e1 * t319 * t593 - 0.3e1 / 0.4e1 * t19 * t173 * t267 + 0.3e1 / 0.8e1 * t19 * t173 * t282 + t19 * t226 * t183 / 0.4e1 + t19 * t108 * t332 / 0.4e1 + 0.3e1 / 0.8e1 * t19 * t257 * t183 + 0.3e1 / 0.4e1 * t19 * t136 * t332 + 0.3e1 / 0.8e1 * t19 * t80 * t621 + t19 * t625 * t102 / 0.12e2 + t19 * t290 * t153 / 0.4e1 + 0.3e1 / 0.4e1 * t19 * t305 * t153;
  t636 = my_piecewise3(t3, 0, t635);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t636 + 0.4e1 * t337;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t640 = t107 * t350;
  t650 = 0.2e3 / 0.81e2 * t190 * t239 + 0.13e5 / 0.729e3 * t194 * t249 + 0.26e3 / 0.243e3 * t71 * t297;
  t651 = t20 * t650;
  t673 = 0.2e3 / 0.81e2 * t204 * t239 + 0.13e5 / 0.729e3 * t208 * t249 + 0.26e3 / 0.243e3 * t98 * t297;
  t674 = t141 * t673;
  t678 = t41 * t200;
  t691 = t213 * t266;
  t692 = t553 * t691;
  t695 = t584 * t364;
  t698 = t374 * t152;
  t699 = t320 * t698;
  t702 = t213 * t281;
  t703 = t320 * t702;
  t714 = -t19 * t640 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t19 * t651 * t102 + t19 * t226 * t214 / 0.4e1 + t19 * t108 * t375 / 0.4e1 + 0.3e1 / 0.8e1 * t19 * t257 * t214 + 0.3e1 / 0.4e1 * t19 * t136 * t375 + 0.3e1 / 0.8e1 * t19 * t80 * t674 + t19 * t678 * t102 / 0.12e2 + t19 * t340 * t153 / 0.4e1 + 0.3e1 / 0.4e1 * t19 * t351 * t153 + 0.3e1 / 0.8e1 * t19 * t201 * t282 + 0.9e1 / 0.4e1 * t319 * t692 - 0.3e1 / 0.2e1 * t319 * t695 - 0.3e1 / 0.2e1 * t319 * t699 - 0.3e1 / 0.4e1 * t319 * t703 - 0.3e1 / 0.4e1 * t19 * t201 * t267 - t19 * t222 * t214 / 0.12e2 - t581 * t365 / 0.2e1;
  t715 = my_piecewise3(t3, 0, t714);
  tv3rho2tau0 = 0.2e1 * rho[0] * t715 + 0.4e1 * t380;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t719 = t18 / t121;
  t720 = t7 * t719;
  t724 = t7 * t384 * params->a2t;
  t725 = t28 * t141;
  t727 = t402 * t725 * t152;
  t736 = t172 * t265;
  t737 = t736 * t321;
  t749 = t394 * t152;
  t750 = t553 * t749;
  t753 = t182 * t331;
  t754 = t320 * t753;
  t758 = t7 * t719 * t79;
  t762 = t7 * t384 * t135;
  t766 = t265 * params->a2b * t46;
  t767 = t386 * t152;
  t768 = t766 * t767;
  t771 = 0.5e1 / 0.384e3 * t720 * t388 + t724 * t727 / 0.384e3 + t19 * t290 * t183 / 0.4e1 + 0.3e1 / 0.4e1 * t19 * t305 * t183 - 0.3e1 / 0.2e1 * t319 * t737 + 0.3e1 / 0.4e1 * t19 * t173 * t332 - t19 * t108 * t395 / 0.4e1 - 0.3e1 / 0.4e1 * t19 * t136 * t395 + 0.9e1 / 0.4e1 * t319 * t750 - 0.3e1 / 0.2e1 * t319 * t754 - 0.5e1 / 0.384e3 * t758 * t404 + t762 * t404 / 0.384e3 - t400 * t768 / 0.192e3;
  t772 = my_piecewise3(t3, 0, t771);
  tv3rhosigma20 = 0.2e1 * rho[0] * t772 + 0.2e1 * t408;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t778 = t7 * t411 * params->xt;
  t787 = t200 * t265;
  t788 = t787 * t321;
  t800 = t736 * t364;
  t808 = t584 * t422;
  t811 = t422 * t152;
  t812 = t553 * t811;
  t815 = t374 * t182;
  t816 = t320 * t815;
  t819 = t213 * t331;
  t820 = t320 * t819;
  t826 = t7 * t411 * t135;
  t829 = t265 * params->xb;
  t830 = t829 * t46;
  t831 = t830 * t767;
  t834 = 0.5e1 / 0.72e2 * t385 * t413 + 0.5e1 / 0.288e3 * t778 * t727 + t19 * t340 * t183 / 0.8e1 + 0.3e1 / 0.8e1 * t19 * t351 * t183 - 0.3e1 / 0.4e1 * t319 * t788 + 0.3e1 / 0.8e1 * t19 * t201 * t332 + t19 * t290 * t214 / 0.8e1 + 0.3e1 / 0.8e1 * t19 * t305 * t214 - 0.3e1 / 0.4e1 * t319 * t800 + 0.3e1 / 0.8e1 * t19 * t173 * t375 - t581 * t423 / 0.4e1 - 0.3e1 / 0.4e1 * t319 * t808 + 0.9e1 / 0.4e1 * t319 * t812 - 0.3e1 / 0.4e1 * t319 * t816 - 0.3e1 / 0.4e1 * t319 * t820 - 0.5e1 / 0.72e2 * t400 * t429 + 0.5e1 / 0.288e3 * t826 * t429 - 0.5e1 / 0.144e3 * t427 * t831;
  t835 = my_piecewise3(t3, 0, t834);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t835 + 0.2e1 * t433;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t841 = t7 * t436 * params->b2t;
  t850 = t787 * t364;
  t862 = t446 * t152;
  t863 = t553 * t862;
  t866 = t213 * t374;
  t867 = t320 * t866;
  t873 = t7 * t436 * t135;
  t876 = t265 * params->b2b;
  t877 = t876 * t28;
  t878 = t402 * t152;
  t879 = t877 * t878;
  t882 = 0.25e2 / 0.18e2 * t412 * t440 + 0.25e2 / 0.54e2 * t841 * t727 + t19 * t340 * t214 / 0.4e1 + 0.3e1 / 0.4e1 * t19 * t351 * t214 - 0.3e1 / 0.2e1 * t319 * t850 + 0.3e1 / 0.4e1 * t19 * t201 * t375 - t19 * t108 * t447 / 0.4e1 - 0.3e1 / 0.4e1 * t19 * t136 * t447 + 0.9e1 / 0.4e1 * t319 * t863 - 0.3e1 / 0.2e1 * t319 * t867 - 0.25e2 / 0.18e2 * t427 * t454 + 0.25e2 / 0.54e2 * t873 * t454 - 0.25e2 / 0.27e2 * t452 * t879;
  t883 = my_piecewise3(t3, 0, t882);
  tv3rhotau20 = 0.2e1 * rho[0] * t883 + 0.2e1 * t458;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t887 = t402 * t725 * t182;
  t894 = t7 * t384 * t172;
  t897 = t394 * t182;
  t898 = t468 * t897;
  t902 = t265 * t182;
  t904 = t902 * params->a2b * t403;
  t908 = my_piecewise3(t3, 0, t724 * t887 / 0.128e3 - 0.9e1 / 0.4e1 * t19 * t173 * t395 + t894 * t404 / 0.128e3 + 0.9e1 / 0.4e1 * t19 * t80 * t898 - t400 * t904 / 0.64e2);
  tv3sigma30 = 0.2e1 * rho[0] * t908;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t916 = t7 * t384 * t200;
  t920 = t402 * t725 * t213;
  t923 = t736 * t422;
  t927 = t7 * t411 * t172;
  t930 = t213 * t394;
  t931 = t553 * t930;
  t935 = t830 * t386 * t182;
  t938 = t265 * t213;
  t940 = t938 * params->a2b * t403;
  t944 = my_piecewise3(t3, 0, 0.5e1 / 0.144e3 * t778 * t887 - 0.3e1 / 0.4e1 * t19 * t201 * t395 + t916 * t404 / 0.384e3 + t724 * t920 / 0.384e3 - 0.3e1 / 0.2e1 * t319 * t923 + 0.5e1 / 0.144e3 * t927 * t429 + 0.9e1 / 0.4e1 * t319 * t931 - 0.5e1 / 0.72e2 * t427 * t935 - t400 * t940 / 0.192e3);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t944;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t950 = t787 * t422;
  t954 = t7 * t411 * t200;
  t960 = t446 * t182;
  t961 = t553 * t960;
  t965 = t938 * params->xb * t403;
  t969 = t7 * t436 * t172;
  t972 = t402 * t182;
  t973 = t877 * t972;
  t977 = my_piecewise3(t3, 0, 0.25e2 / 0.54e2 * t841 * t887 + 0.5e1 / 0.144e3 * t778 * t920 - 0.3e1 / 0.2e1 * t319 * t950 + 0.5e1 / 0.144e3 * t954 * t429 - 0.3e1 / 0.4e1 * t19 * t173 * t447 + 0.9e1 / 0.4e1 * t319 * t961 - 0.5e1 / 0.72e2 * t427 * t965 + 0.25e2 / 0.54e2 * t969 * t454 - 0.25e2 / 0.27e2 * t452 * t973);
  tv3sigmatau20 = 0.2e1 * rho[0] * t977;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t985 = t7 * t436 * t200;
  t988 = t446 * t213;
  t989 = t468 * t988;
  t994 = t938 * params->b2b * t403;
  t998 = my_piecewise3(t3, 0, 0.25e2 / 0.18e2 * t841 * t920 - 0.9e1 / 0.4e1 * t19 * t201 * t447 + 0.25e2 / 0.18e2 * t985 * t454 + 0.9e1 / 0.4e1 * t19 * t80 * t989 - 0.25e2 / 0.9e1 * t452 * t994);
  tv3tau30 = 0.2e1 * rho[0] * t998;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t34, t35, t39, t41, t43, t46, t47;
  double t49, t50, t51, t52, t53, t54, t56, t57;
  double t60, t62, t63, t67, t70, t71, t72, t74;
  double t76, t79, t80, t81, t82, t86, t90, t94;
  double t98, t101, t102, t106, tzk0;

  double t107, t108, t113, t114, t118, t121, t123, t124;
  double t128, t132, t135, t136, t140, t141, t152, t153;
  double t158, tvrho0, t161, t162, t165, t169, t172, t173;
  double t182, t183, t188, tvsigma0, tvlapl0, t190, t194, t197;
  double t200, t201, t204, t208, t213, t214, t219, tvtau0;

  double t222, t226, t234, t235, t239, t242, t244, t245;
  double t249, t253, t256, t257, t265, t266, t267, t281;
  double t282, t287, tv2rho20, t290, t294, t297, t301, t304;
  double t305, t319, t320, t321, t322, t331, t332, t337;
  double tv2rhosigma0, tv2rholapl0, t340, t350, t351, t364, t365, t374;
  double t375, t380, tv2rhotau0, t383, t384, t385, t386, t387;
  double t388, t394, t395, t400, t402, t403, t404, t408;
  double tv2sigma20, tv2sigmalapl0, t410, t411, t412, t413, t422, t423;
  double t427, t429, t433, tv2sigmatau0, tv2lapl20, tv2lapltau0, t435, t436;
  double t440, t446, t447, t452, t454, t458, tv2tau20;

  double t467, t468, t469, t470, t474, t475, t479, t480;
  double t484, t487, t489, t490, t494, t498, t501, t502;
  double t506, t510, t524, t525, t529, t548, t549, tv3rho30;
  double t553, t554, t555, t558, t562, t565, t569, t572;
  double t573, t581, t584, t585, t588, t589, t592, t593;
  double t620, t621, t625, t635, t636, tv3rho2sigma0, tv3rho2lapl0, t640;
  double t650, t651, t673, t674, t678, t691, t692, t695;
  double t698, t699, t702, t703, t714, t715, tv3rho2tau0, t719;
  double t720, t724, t725, t727, t736, t737, t749, t750;
  double t753, t754, t758, t762, t766, t767, t768, t771;
  double t772, tv3rhosigma20, tv3rhosigmalapl0, t778, t787, t788, t800, t808;
  double t811, t812, t815, t816, t819, t820, t826, t829;
  double t830, t831, t834, t835, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t841;
  double t850, t862, t863, t866, t867, t873, t876, t877;
  double t878, t879, t882, t883, tv3rhotau20, t887, t894, t897;
  double t898, t902, t904, t908, tv3sigma30, tv3sigma2lapl0, t916, t920;
  double t923, t927, t930, t931, t935, t938, t940, t944;
  double tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, t950, t954, t960, t961, t965;
  double t969, t972, t973, t977, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20;
  double t985, t988, t989, t994, t998, tv3tau30;

  double t1030, t1031, t1045, t1048, t1064, t1068, t1073, t1074;
  double t1078, t1082, t1126, t1128, tv4rho40, t1148, t1170, t1179;
  double t1190, t1195, t1214, t1217, t1221, t1279, t1281, tv4rho3sigma0;
  double tv4rho3lapl0, t1351, t1423, t1425, tv4rho3tau0, t1429, t1431, t1435;
  double t1449, t1453, t1458, t1462, t1476, t1493, t1503, t1520;
  double t1546, t1548, tv4rho2sigma20, tv4rho2sigmalapl0, t1563, t1569, t1586, t1607;
  double t1622, t1637, t1661, t1702, t1705, tv4rho2sigmatau0, tv4rho2lapl20, tv4rho2lapltau0;
  double t1714, t1726, t1759, t1777, t1812, t1814, tv4rho2tau20, t1820;
  double t1824, t1869, t1880, t1881, tv4rhosigma30, tv4rhosigma2lapl0, t1891, t1911;
  double t1927, t1940, t1941, t1992, t1994, tv4rhosigma2tau0, tv4rhosigmalapl20, tv4rhosigmalapltau0;
  double t1999, t2054, t2100, t2102, tv4rhosigmatau20, tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20;
  double t2150, t2158, t2159, tv4rhotau30, t2163, t2169, t2172, t2174;
  double t2175, t2176, t2178, t2186, t2198, t2200, t2205, tv4sigma40;
  double tv4sigma3lapl0, t2221, t2229, t2233, t2246, t2247, t2256, t2257;
  double tv4sigma3tau0, tv4sigma2lapl20, tv4sigma2lapltau0, t2260, t2263, t2265, t2266, t2274;
  double t2294, t2325, t2326, tv4sigma2tau20, tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, t2330;
  double t2370, t2371, tv4sigmatau30, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20, tv4lapltau30, t2375;
  double t2385, t2396, t2402, tv4tau40;

  mgga_x_ktbm_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ktbm_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = t7 * t18;
  t20 = POW_1_3(rho[0]);
  t21 = M_CBRT6;
  t22 = params->at * t21;
  t23 = M_PI * M_PI;
  t24 = POW_1_3(t23);
  t25 = t24 * t24;
  t26 = 0.1e1 / t25;
  t27 = t22 * t26;
  t28 = M_CBRT2;
  t29 = t28 * t28;
  t30 = sigma[0] * t29;
  t31 = rho[0] * rho[0];
  t32 = t20 * t20;
  t34 = 0.1e1 / t32 / t31;
  t35 = t30 * t34;
  t39 = params->bt * tau[0] * t29;
  t41 = 0.1e1 / t32 / rho[0];
  t43 = t41 * t21 * t26;
  t46 = t21 * t21;
  t47 = params->a2t * t46;
  t49 = 0.1e1 / t24 / t23;
  t50 = t47 * t49;
  t51 = sigma[0] * sigma[0];
  t52 = t51 * t28;
  t53 = t31 * t31;
  t54 = t53 * rho[0];
  t56 = 0.1e1 / t20 / t54;
  t57 = t52 * t56;
  t60 = tau[0] * tau[0];
  t62 = params->b2t * t60 * t28;
  t63 = t31 * rho[0];
  t67 = 0.1e1 / t20 / t63 * t46 * t49;
  t70 = params->xt * t46;
  t71 = t70 * t49;
  t72 = sigma[0] * t28;
  t74 = 0.1e1 / t20 / t53;
  t76 = t72 * t74 * tau[0];
  t79 = params->ct + t27 * t35 / 0.24e2 + 0.5e1 / 0.9e1 * t39 * t43 + t50 * t57 / 0.288e3 + 0.5e2 / 0.81e2 * t62 * t67 + 0.5e1 / 0.108e3 * t71 * t76;
  t80 = t20 * t79;
  t81 = params->ab * t21;
  t82 = t81 * t26;
  t86 = params->bb * tau[0] * t29;
  t90 = params->a2b * t46 * t49;
  t94 = params->b2b * t60 * t28;
  t98 = params->xb * t46 * t49;
  t101 = params->cb + t82 * t35 / 0.24e2 + 0.5e1 / 0.9e1 * t86 * t43 + t90 * t57 / 0.288e3 + 0.5e2 / 0.81e2 * t94 * t67 + 0.5e1 / 0.108e3 * t98 * t76;
  t102 = 0.1e1 / t101;
  t106 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t80 * t102);
  tzk0 = 0.2e1 * t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t107 = 0.1e1 / t32;
  t108 = t107 * t79;
  t113 = 0.1e1 / t32 / t63;
  t114 = t30 * t113;
  t118 = t34 * t21 * t26;
  t121 = t53 * t31;
  t123 = 0.1e1 / t20 / t121;
  t124 = t52 * t123;
  t128 = t74 * t46 * t49;
  t132 = t72 * t56 * tau[0];
  t135 = -t27 * t114 / 0.9e1 - 0.25e2 / 0.27e2 * t39 * t118 - t50 * t124 / 0.54e2 - 0.5e3 / 0.243e3 * t62 * t128 - 0.65e2 / 0.324e3 * t71 * t132;
  t136 = t20 * t135;
  t140 = t101 * t101;
  t141 = 0.1e1 / t140;
  t152 = -t82 * t114 / 0.9e1 - 0.25e2 / 0.27e2 * t86 * t118 - t90 * t124 / 0.54e2 - 0.5e3 / 0.243e3 * t94 * t128 - 0.65e2 / 0.324e3 * t98 * t132;
  t153 = t141 * t152;
  t158 = my_piecewise3(t3, 0, -t19 * t108 * t102 / 0.8e1 - 0.3e1 / 0.8e1 * t19 * t136 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t153);
  tvrho0 = 0.2e1 * rho[0] * t158 + 0.2e1 * t106;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t161 = t26 * t29;
  t162 = t161 * t34;
  t165 = t72 * t56;
  t169 = t28 * t74 * tau[0];
  t172 = t22 * t162 / 0.24e2 + t50 * t165 / 0.144e3 + 0.5e1 / 0.108e3 * t71 * t169;
  t173 = t20 * t172;
  t182 = t81 * t162 / 0.24e2 + t90 * t165 / 0.144e3 + 0.5e1 / 0.108e3 * t98 * t169;
  t183 = t141 * t182;
  t188 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t173 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t183);
  tvsigma0 = 0.2e1 * rho[0] * t188;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t190 = params->bt * t29;
  t194 = params->b2t * tau[0] * t28;
  t197 = t72 * t74;
  t200 = 0.5e1 / 0.9e1 * t190 * t43 + 0.1e3 / 0.81e2 * t194 * t67 + 0.5e1 / 0.108e3 * t71 * t197;
  t201 = t20 * t200;
  t204 = params->bb * t29;
  t208 = params->b2b * tau[0] * t28;
  t213 = 0.5e1 / 0.9e1 * t204 * t43 + 0.1e3 / 0.81e2 * t208 * t67 + 0.5e1 / 0.108e3 * t98 * t197;
  t214 = t141 * t213;
  t219 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t19 * t201 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t214);
  tvtau0 = 0.2e1 * rho[0] * t219;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t222 = t41 * t79;
  t226 = t107 * t135;
  t234 = 0.1e1 / t32 / t53;
  t235 = t30 * t234;
  t239 = t113 * t21 * t26;
  t242 = t53 * t63;
  t244 = 0.1e1 / t20 / t242;
  t245 = t52 * t244;
  t249 = t56 * t46 * t49;
  t253 = t72 * t123 * tau[0];
  t256 = 0.11e2 / 0.27e2 * t27 * t235 + 0.2e3 / 0.81e2 * t39 * t239 + 0.19e2 / 0.162e3 * t50 * t245 + 0.65e4 / 0.729e3 * t62 * t249 + 0.26e3 / 0.243e3 * t71 * t253;
  t257 = t20 * t256;
  t265 = 0.1e1 / t140 / t101;
  t266 = t152 * t152;
  t267 = t265 * t266;
  t281 = 0.11e2 / 0.27e2 * t82 * t235 + 0.2e3 / 0.81e2 * t86 * t239 + 0.19e2 / 0.162e3 * t90 * t245 + 0.65e4 / 0.729e3 * t94 * t249 + 0.26e3 / 0.243e3 * t98 * t253;
  t282 = t141 * t281;
  t287 = my_piecewise3(t3, 0, t19 * t222 * t102 / 0.12e2 - t19 * t226 * t102 / 0.4e1 + t19 * t108 * t153 / 0.4e1 - 0.3e1 / 0.8e1 * t19 * t257 * t102 + 0.3e1 / 0.4e1 * t19 * t136 * t153 - 0.3e1 / 0.4e1 * t19 * t80 * t267 + 0.3e1 / 0.8e1 * t19 * t80 * t282);
  tv2rho20 = 0.2e1 * rho[0] * t287 + 0.4e1 * t158;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t290 = t107 * t172;
  t294 = t161 * t113;
  t297 = t72 * t123;
  t301 = t28 * t56 * tau[0];
  t304 = -t22 * t294 / 0.9e1 - t50 * t297 / 0.27e2 - 0.65e2 / 0.324e3 * t71 * t301;
  t305 = t20 * t304;
  t319 = t7 * t18 * t20;
  t320 = t79 * t265;
  t321 = t182 * t152;
  t322 = t320 * t321;
  t331 = -t81 * t294 / 0.9e1 - t90 * t297 / 0.27e2 - 0.65e2 / 0.324e3 * t98 * t301;
  t332 = t141 * t331;
  t337 = my_piecewise3(t3, 0, -t19 * t290 * t102 / 0.8e1 - 0.3e1 / 0.8e1 * t19 * t305 * t102 + 0.3e1 / 0.8e1 * t19 * t173 * t153 + t19 * t108 * t183 / 0.8e1 + 0.3e1 / 0.8e1 * t19 * t136 * t183 - 0.3e1 / 0.4e1 * t319 * t322 + 0.3e1 / 0.8e1 * t19 * t80 * t332);
  tv2rhosigma0 = 0.2e1 * rho[0] * t337 + 0.2e1 * t188;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t340 = t107 * t200;
  t350 = -0.25e2 / 0.27e2 * t190 * t118 - 0.1e4 / 0.243e3 * t194 * t128 - 0.65e2 / 0.324e3 * t71 * t165;
  t351 = t20 * t350;
  t364 = t213 * t152;
  t365 = t320 * t364;
  t374 = -0.25e2 / 0.27e2 * t204 * t118 - 0.1e4 / 0.243e3 * t208 * t128 - 0.65e2 / 0.324e3 * t98 * t165;
  t375 = t141 * t374;
  t380 = my_piecewise3(t3, 0, -t19 * t340 * t102 / 0.8e1 - 0.3e1 / 0.8e1 * t19 * t351 * t102 + 0.3e1 / 0.8e1 * t19 * t201 * t153 + t19 * t108 * t214 / 0.8e1 + 0.3e1 / 0.8e1 * t19 * t136 * t214 - 0.3e1 / 0.4e1 * t319 * t365 + 0.3e1 / 0.8e1 * t19 * t80 * t375);
  tv2rhotau0 = 0.2e1 * rho[0] * t380 + 0.2e1 * t219;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t383 = 0.1e1 / t54;
  t384 = t18 * t383;
  t385 = t7 * t384;
  t386 = t49 * t28;
  t387 = t386 * t102;
  t388 = t47 * t387;
  t394 = t182 * t182;
  t395 = t265 * t394;
  t400 = t7 * t384 * t79;
  t402 = t46 * t49;
  t403 = t402 * t28;
  t404 = t141 * params->a2b * t403;
  t408 = my_piecewise3(t3, 0, -t385 * t388 / 0.384e3 + 0.3e1 / 0.4e1 * t19 * t173 * t183 - 0.3e1 / 0.4e1 * t19 * t80 * t395 + t400 * t404 / 0.384e3);
  tv2sigma20 = 0.2e1 * rho[0] * t408;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t410 = 0.1e1 / t53;
  t411 = t18 * t410;
  t412 = t7 * t411;
  t413 = t70 * t387;
  t422 = t213 * t182;
  t423 = t320 * t422;
  t427 = t7 * t411 * t79;
  t429 = t141 * params->xb * t403;
  t433 = my_piecewise3(t3, 0, -0.5e1 / 0.288e3 * t412 * t413 + 0.3e1 / 0.8e1 * t19 * t201 * t183 + 0.3e1 / 0.8e1 * t19 * t173 * t214 - 0.3e1 / 0.4e1 * t319 * t423 + 0.5e1 / 0.288e3 * t427 * t429);
  tv2sigmatau0 = 0.2e1 * rho[0] * t433;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t435 = 0.1e1 / t63;
  t436 = t18 * t435;
  t440 = params->b2t * t28 * t402 * t102;
  t446 = t213 * t213;
  t447 = t265 * t446;
  t452 = t7 * t436 * t79;
  t454 = t141 * params->b2b * t403;
  t458 = my_piecewise3(t3, 0, -0.25e2 / 0.54e2 * t7 * t436 * t440 + 0.3e1 / 0.4e1 * t19 * t201 * t214 - 0.3e1 / 0.4e1 * t19 * t80 * t447 + 0.25e2 / 0.54e2 * t452 * t454);
  tv2tau20 = 0.2e1 * rho[0] * t458;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t467 = t140 * t140;
  t468 = 0.1e1 / t467;
  t469 = t266 * t152;
  t470 = t468 * t469;
  t474 = t152 * t281;
  t475 = t320 * t474;
  t479 = 0.1e1 / t32 / t54;
  t480 = t30 * t479;
  t484 = t234 * t21 * t26;
  t487 = t53 * t53;
  t489 = 0.1e1 / t20 / t487;
  t490 = t52 * t489;
  t494 = t123 * t46 * t49;
  t498 = t72 * t244 * tau[0];
  t501 = -0.154e3 / 0.81e2 * t27 * t480 - 0.22e4 / 0.243e3 * t39 * t484 - 0.209e3 / 0.243e3 * t50 * t490 - 0.104e6 / 0.2187e4 * t62 * t494 - 0.494e4 / 0.729e3 * t71 * t498;
  t502 = t20 * t501;
  t506 = t41 * t135;
  t510 = t107 * t256;
  t524 = -0.154e3 / 0.81e2 * t82 * t480 - 0.22e4 / 0.243e3 * t86 * t484 - 0.209e3 / 0.243e3 * t90 * t490 - 0.104e6 / 0.2187e4 * t94 * t494 - 0.494e4 / 0.729e3 * t98 * t498;
  t525 = t141 * t524;
  t529 = t34 * t79;
  t548 = -0.3e1 / 0.4e1 * t19 * t108 * t267 - 0.9e1 / 0.4e1 * t19 * t136 * t267 + 0.9e1 / 0.4e1 * t19 * t80 * t470 - 0.9e1 / 0.4e1 * t319 * t475 - 0.3e1 / 0.8e1 * t19 * t502 * t102 + t19 * t506 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t19 * t510 * t102 + 0.3e1 / 0.8e1 * t19 * t80 * t525 - 0.5e1 / 0.36e2 * t19 * t529 * t102 - t19 * t222 * t153 / 0.4e1 + 0.3e1 / 0.4e1 * t19 * t226 * t153 + 0.3e1 / 0.8e1 * t19 * t108 * t282 + 0.9e1 / 0.8e1 * t19 * t257 * t153 + 0.9e1 / 0.8e1 * t19 * t136 * t282;
  t549 = my_piecewise3(t3, 0, t548);
  tv3rho30 = 0.2e1 * rho[0] * t549 + 0.6e1 * t287;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t553 = t79 * t468;
  t554 = t182 * t266;
  t555 = t553 * t554;
  t558 = t107 * t304;
  t562 = t161 * t234;
  t565 = t72 * t244;
  t569 = t28 * t123 * tau[0];
  t572 = 0.11e2 / 0.27e2 * t22 * t562 + 0.19e2 / 0.81e2 * t50 * t565 + 0.26e3 / 0.243e3 * t71 * t569;
  t573 = t20 * t572;
  t581 = t7 * t18 * t107;
  t584 = t135 * t265;
  t585 = t584 * t321;
  t588 = t331 * t152;
  t589 = t320 * t588;
  t592 = t182 * t281;
  t593 = t320 * t592;
  t620 = 0.11e2 / 0.27e2 * t81 * t562 + 0.19e2 / 0.81e2 * t90 * t565 + 0.26e3 / 0.243e3 * t98 * t569;
  t621 = t141 * t620;
  t625 = t41 * t172;
  t635 = 0.9e1 / 0.4e1 * t319 * t555 - t19 * t558 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t19 * t573 * t102 - t19 * t222 * t183 / 0.12e2 - t581 * t322 / 0.2e1 - 0.3e1 / 0.2e1 * t319 * t585 - 0.3e1 / 0.2e1 * t319 * t589 - 0.3e1 / 0.4e1 * t319 * t593 - 0.3e1 / 0.4e1 * t19 * t173 * t267 + 0.3e1 / 0.8e1 * t19 * t173 * t282 + t19 * t226 * t183 / 0.4e1 + t19 * t108 * t332 / 0.4e1 + 0.3e1 / 0.8e1 * t19 * t257 * t183 + 0.3e1 / 0.4e1 * t19 * t136 * t332 + 0.3e1 / 0.8e1 * t19 * t80 * t621 + t19 * t625 * t102 / 0.12e2 + t19 * t290 * t153 / 0.4e1 + 0.3e1 / 0.4e1 * t19 * t305 * t153;
  t636 = my_piecewise3(t3, 0, t635);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t636 + 0.4e1 * t337;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t640 = t107 * t350;
  t650 = 0.2e3 / 0.81e2 * t190 * t239 + 0.13e5 / 0.729e3 * t194 * t249 + 0.26e3 / 0.243e3 * t71 * t297;
  t651 = t20 * t650;
  t673 = 0.2e3 / 0.81e2 * t204 * t239 + 0.13e5 / 0.729e3 * t208 * t249 + 0.26e3 / 0.243e3 * t98 * t297;
  t674 = t141 * t673;
  t678 = t41 * t200;
  t691 = t213 * t266;
  t692 = t553 * t691;
  t695 = t584 * t364;
  t698 = t374 * t152;
  t699 = t320 * t698;
  t702 = t213 * t281;
  t703 = t320 * t702;
  t714 = -t19 * t640 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t19 * t651 * t102 + t19 * t226 * t214 / 0.4e1 + t19 * t108 * t375 / 0.4e1 + 0.3e1 / 0.8e1 * t19 * t257 * t214 + 0.3e1 / 0.4e1 * t19 * t136 * t375 + 0.3e1 / 0.8e1 * t19 * t80 * t674 + t19 * t678 * t102 / 0.12e2 + t19 * t340 * t153 / 0.4e1 + 0.3e1 / 0.4e1 * t19 * t351 * t153 + 0.3e1 / 0.8e1 * t19 * t201 * t282 + 0.9e1 / 0.4e1 * t319 * t692 - 0.3e1 / 0.2e1 * t319 * t695 - 0.3e1 / 0.2e1 * t319 * t699 - 0.3e1 / 0.4e1 * t319 * t703 - 0.3e1 / 0.4e1 * t19 * t201 * t267 - t19 * t222 * t214 / 0.12e2 - t581 * t365 / 0.2e1;
  t715 = my_piecewise3(t3, 0, t714);
  tv3rho2tau0 = 0.2e1 * rho[0] * t715 + 0.4e1 * t380;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t719 = t18 / t121;
  t720 = t7 * t719;
  t724 = t7 * t384 * params->a2t;
  t725 = t28 * t141;
  t727 = t402 * t725 * t152;
  t736 = t172 * t265;
  t737 = t736 * t321;
  t749 = t394 * t152;
  t750 = t553 * t749;
  t753 = t182 * t331;
  t754 = t320 * t753;
  t758 = t7 * t719 * t79;
  t762 = t7 * t384 * t135;
  t766 = t265 * params->a2b * t46;
  t767 = t386 * t152;
  t768 = t766 * t767;
  t771 = 0.5e1 / 0.384e3 * t720 * t388 + t724 * t727 / 0.384e3 + t19 * t290 * t183 / 0.4e1 + 0.3e1 / 0.4e1 * t19 * t305 * t183 - 0.3e1 / 0.2e1 * t319 * t737 + 0.3e1 / 0.4e1 * t19 * t173 * t332 - t19 * t108 * t395 / 0.4e1 - 0.3e1 / 0.4e1 * t19 * t136 * t395 + 0.9e1 / 0.4e1 * t319 * t750 - 0.3e1 / 0.2e1 * t319 * t754 - 0.5e1 / 0.384e3 * t758 * t404 + t762 * t404 / 0.384e3 - t400 * t768 / 0.192e3;
  t772 = my_piecewise3(t3, 0, t771);
  tv3rhosigma20 = 0.2e1 * rho[0] * t772 + 0.2e1 * t408;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t778 = t7 * t411 * params->xt;
  t787 = t200 * t265;
  t788 = t787 * t321;
  t800 = t736 * t364;
  t808 = t584 * t422;
  t811 = t422 * t152;
  t812 = t553 * t811;
  t815 = t374 * t182;
  t816 = t320 * t815;
  t819 = t213 * t331;
  t820 = t320 * t819;
  t826 = t7 * t411 * t135;
  t829 = t265 * params->xb;
  t830 = t829 * t46;
  t831 = t830 * t767;
  t834 = 0.5e1 / 0.72e2 * t385 * t413 + 0.5e1 / 0.288e3 * t778 * t727 + t19 * t340 * t183 / 0.8e1 + 0.3e1 / 0.8e1 * t19 * t351 * t183 - 0.3e1 / 0.4e1 * t319 * t788 + 0.3e1 / 0.8e1 * t19 * t201 * t332 + t19 * t290 * t214 / 0.8e1 + 0.3e1 / 0.8e1 * t19 * t305 * t214 - 0.3e1 / 0.4e1 * t319 * t800 + 0.3e1 / 0.8e1 * t19 * t173 * t375 - t581 * t423 / 0.4e1 - 0.3e1 / 0.4e1 * t319 * t808 + 0.9e1 / 0.4e1 * t319 * t812 - 0.3e1 / 0.4e1 * t319 * t816 - 0.3e1 / 0.4e1 * t319 * t820 - 0.5e1 / 0.72e2 * t400 * t429 + 0.5e1 / 0.288e3 * t826 * t429 - 0.5e1 / 0.144e3 * t427 * t831;
  t835 = my_piecewise3(t3, 0, t834);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t835 + 0.2e1 * t433;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t841 = t7 * t436 * params->b2t;
  t850 = t787 * t364;
  t862 = t446 * t152;
  t863 = t553 * t862;
  t866 = t213 * t374;
  t867 = t320 * t866;
  t873 = t7 * t436 * t135;
  t876 = t265 * params->b2b;
  t877 = t876 * t28;
  t878 = t402 * t152;
  t879 = t877 * t878;
  t882 = 0.25e2 / 0.18e2 * t412 * t440 + 0.25e2 / 0.54e2 * t841 * t727 + t19 * t340 * t214 / 0.4e1 + 0.3e1 / 0.4e1 * t19 * t351 * t214 - 0.3e1 / 0.2e1 * t319 * t850 + 0.3e1 / 0.4e1 * t19 * t201 * t375 - t19 * t108 * t447 / 0.4e1 - 0.3e1 / 0.4e1 * t19 * t136 * t447 + 0.9e1 / 0.4e1 * t319 * t863 - 0.3e1 / 0.2e1 * t319 * t867 - 0.25e2 / 0.18e2 * t427 * t454 + 0.25e2 / 0.54e2 * t873 * t454 - 0.25e2 / 0.27e2 * t452 * t879;
  t883 = my_piecewise3(t3, 0, t882);
  tv3rhotau20 = 0.2e1 * rho[0] * t883 + 0.2e1 * t458;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t887 = t402 * t725 * t182;
  t894 = t7 * t384 * t172;
  t897 = t394 * t182;
  t898 = t468 * t897;
  t902 = t265 * t182;
  t904 = t902 * params->a2b * t403;
  t908 = my_piecewise3(t3, 0, t724 * t887 / 0.128e3 - 0.9e1 / 0.4e1 * t19 * t173 * t395 + t894 * t404 / 0.128e3 + 0.9e1 / 0.4e1 * t19 * t80 * t898 - t400 * t904 / 0.64e2);
  tv3sigma30 = 0.2e1 * rho[0] * t908;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t916 = t7 * t384 * t200;
  t920 = t402 * t725 * t213;
  t923 = t736 * t422;
  t927 = t7 * t411 * t172;
  t930 = t213 * t394;
  t931 = t553 * t930;
  t935 = t830 * t386 * t182;
  t938 = t265 * t213;
  t940 = t938 * params->a2b * t403;
  t944 = my_piecewise3(t3, 0, 0.5e1 / 0.144e3 * t778 * t887 - 0.3e1 / 0.4e1 * t19 * t201 * t395 + t916 * t404 / 0.384e3 + t724 * t920 / 0.384e3 - 0.3e1 / 0.2e1 * t319 * t923 + 0.5e1 / 0.144e3 * t927 * t429 + 0.9e1 / 0.4e1 * t319 * t931 - 0.5e1 / 0.72e2 * t427 * t935 - t400 * t940 / 0.192e3);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t944;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t950 = t787 * t422;
  t954 = t7 * t411 * t200;
  t960 = t446 * t182;
  t961 = t553 * t960;
  t965 = t938 * params->xb * t403;
  t969 = t7 * t436 * t172;
  t972 = t402 * t182;
  t973 = t877 * t972;
  t977 = my_piecewise3(t3, 0, 0.25e2 / 0.54e2 * t841 * t887 + 0.5e1 / 0.144e3 * t778 * t920 - 0.3e1 / 0.2e1 * t319 * t950 + 0.5e1 / 0.144e3 * t954 * t429 - 0.3e1 / 0.4e1 * t19 * t173 * t447 + 0.9e1 / 0.4e1 * t319 * t961 - 0.5e1 / 0.72e2 * t427 * t965 + 0.25e2 / 0.54e2 * t969 * t454 - 0.25e2 / 0.27e2 * t452 * t973);
  tv3sigmatau20 = 0.2e1 * rho[0] * t977;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t985 = t7 * t436 * t200;
  t988 = t446 * t213;
  t989 = t468 * t988;
  t994 = t938 * params->b2b * t403;
  t998 = my_piecewise3(t3, 0, 0.25e2 / 0.18e2 * t841 * t920 - 0.9e1 / 0.4e1 * t19 * t201 * t447 + 0.25e2 / 0.18e2 * t985 * t454 + 0.9e1 / 0.4e1 * t19 * t80 * t989 - 0.25e2 / 0.9e1 * t452 * t994);
  tv3tau30 = 0.2e1 * rho[0] * t998;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1030 = 0.1e1 / t467 / t101;
  t1031 = t266 * t266;
  t1045 = 0.3e1 / 0.2e1 * t19 * t502 * t153 - 0.3e1 * t19 * t226 * t267 - 0.9e1 / 0.2e1 * t19 * t257 * t267 + 0.3e1 / 0.2e1 * t19 * t226 * t282 + 0.9e1 / 0.4e1 * t19 * t257 * t282 - 0.9e1 * t319 * t584 * t474 - 0.3e1 * t319 * t320 * t152 * t524 - 0.3e1 * t581 * t475 + 0.27e2 / 0.2e1 * t319 * t553 * t266 * t281 - 0.9e1 * t19 * t80 * t1030 * t1031 + 0.9e1 * t19 * t136 * t470 + 0.3e1 * t19 * t108 * t470 + t19 * t108 * t525 / 0.2e1;
  t1048 = t281 * t281;
  t1064 = t30 / t32 / t121;
  t1068 = t479 * t21 * t26;
  t1073 = 0.1e1 / t20 / t487 / rho[0];
  t1074 = t52 * t1073;
  t1078 = t244 * t46 * t49;
  t1082 = t72 * t489 * tau[0];
  t1126 = t19 * t222 * t267 - 0.9e1 / 0.4e1 * t19 * t80 * t265 * t1048 - t19 * t222 * t282 / 0.2e1 + 0.5e1 / 0.9e1 * t19 * t529 * t153 + 0.3e1 / 0.2e1 * t19 * t136 * t525 + 0.3e1 / 0.8e1 * t19 * t80 * t141 * (0.2618e4 / 0.243e3 * t82 * t1064 + 0.308e5 / 0.729e3 * t86 * t1068 + 0.5225e4 / 0.729e3 * t90 * t1074 + 0.1976e7 / 0.6561e4 * t94 * t1078 + 0.10868e6 / 0.2187e4 * t98 * t1082) - t19 * t506 * t153 + 0.3e1 / 0.2e1 * t19 * t510 * t153 - t19 * t107 * t501 * t102 / 0.2e1 - 0.5e1 / 0.9e1 * t19 * t34 * t135 * t102 + 0.1e2 / 0.27e2 * t19 * t113 * t79 * t102 - 0.3e1 / 0.8e1 * t19 * t20 * (0.2618e4 / 0.243e3 * t27 * t1064 + 0.308e5 / 0.729e3 * t39 * t1068 + 0.5225e4 / 0.729e3 * t50 * t1074 + 0.1976e7 / 0.6561e4 * t62 * t1078 + 0.10868e6 / 0.2187e4 * t71 * t1082) * t102 + t19 * t41 * t256 * t102 / 0.2e1;
  t1128 = my_piecewise3(t3, 0, t1045 + t1126);
  tv4rho40 = 0.2e1 * rho[0] * t1128 + 0.8e1 * t549;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1148 = t256 * t265;
  t1170 = t135 * t468;
  t1179 = t7 * t18 * t41;
  t1190 = t79 * t1030;
  t1195 = 0.27e2 / 0.4e1 * t319 * t553 * t321 * t281 + 0.5e1 / 0.36e2 * t19 * t529 * t183 + 0.3e1 / 0.8e1 * t19 * t290 * t282 - 0.3e1 / 0.4e1 * t19 * t290 * t267 + 0.9e1 / 0.4e1 * t19 * t173 * t470 - 0.9e1 / 0.4e1 * t319 * t1148 * t321 - 0.9e1 / 0.2e1 * t319 * t584 * t588 - 0.9e1 / 0.4e1 * t319 * t584 * t592 - 0.9e1 / 0.4e1 * t319 * t320 * t620 * t152 - 0.9e1 / 0.4e1 * t319 * t320 * t331 * t281 - 0.3e1 / 0.4e1 * t319 * t320 * t182 * t524 + 0.27e2 / 0.4e1 * t319 * t1170 * t554 + 0.27e2 / 0.4e1 * t319 * t553 * t331 * t266 + t1179 * t322 / 0.2e1 - 0.3e1 / 0.2e1 * t581 * t585 - 0.3e1 / 0.2e1 * t581 * t589 - 0.3e1 / 0.4e1 * t581 * t593 + 0.9e1 / 0.4e1 * t581 * t555 - 0.9e1 * t319 * t1190 * t182 * t469;
  t1214 = t161 * t479;
  t1217 = t72 * t489;
  t1221 = t28 * t244 * tau[0];
  t1279 = -0.9e1 / 0.4e1 * t319 * t736 * t474 - 0.9e1 / 0.4e1 * t19 * t305 * t267 - t19 * t506 * t183 / 0.4e1 - t19 * t222 * t332 / 0.4e1 + 0.3e1 / 0.4e1 * t19 * t558 * t153 + 0.9e1 / 0.8e1 * t19 * t573 * t153 + 0.3e1 / 0.8e1 * t19 * t80 * t141 * (-0.154e3 / 0.81e2 * t81 * t1214 - 0.418e3 / 0.243e3 * t90 * t1217 - 0.494e4 / 0.729e3 * t98 * t1221) - t19 * t625 * t153 / 0.4e1 + 0.3e1 / 0.8e1 * t19 * t502 * t183 + 0.9e1 / 0.8e1 * t19 * t257 * t332 + 0.9e1 / 0.8e1 * t19 * t136 * t621 + 0.3e1 / 0.8e1 * t19 * t510 * t183 + 0.3e1 / 0.4e1 * t19 * t226 * t332 + 0.3e1 / 0.8e1 * t19 * t108 * t621 + 0.9e1 / 0.8e1 * t19 * t305 * t282 + 0.3e1 / 0.8e1 * t19 * t173 * t525 - 0.3e1 / 0.8e1 * t19 * t20 * (-0.154e3 / 0.81e2 * t22 * t1214 - 0.418e3 / 0.243e3 * t50 * t1217 - 0.494e4 / 0.729e3 * t71 * t1221) * t102 - 0.3e1 / 0.8e1 * t19 * t107 * t572 * t102 + t19 * t41 * t304 * t102 / 0.4e1 - 0.5e1 / 0.36e2 * t19 * t34 * t172 * t102;
  t1281 = my_piecewise3(t3, 0, t1195 + t1279);
  tv4rho3sigma0 = 0.2e1 * rho[0] * t1281 + 0.6e1 * t636;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t1351 = 0.27e2 / 0.4e1 * t319 * t553 * t364 * t281 - 0.3e1 / 0.4e1 * t19 * t340 * t267 + 0.9e1 / 0.4e1 * t19 * t201 * t470 + 0.5e1 / 0.36e2 * t19 * t529 * t214 + 0.3e1 / 0.8e1 * t19 * t201 * t525 - t19 * t678 * t153 / 0.4e1 + 0.3e1 / 0.8e1 * t19 * t340 * t282 + 0.9e1 / 0.8e1 * t19 * t351 * t282 + 0.3e1 / 0.8e1 * t19 * t80 * t141 * (-0.22e4 / 0.243e3 * t204 * t484 - 0.208e6 / 0.2187e4 * t208 * t494 - 0.494e4 / 0.729e3 * t98 * t565) + 0.9e1 / 0.8e1 * t19 * t257 * t375 + 0.9e1 / 0.8e1 * t19 * t136 * t674 + 0.3e1 / 0.4e1 * t19 * t226 * t375 + 0.3e1 / 0.8e1 * t19 * t108 * t674 + 0.3e1 / 0.8e1 * t19 * t502 * t214 + 0.9e1 / 0.8e1 * t19 * t651 * t153 + 0.3e1 / 0.8e1 * t19 * t510 * t214 + 0.3e1 / 0.4e1 * t19 * t640 * t153 - t19 * t222 * t375 / 0.4e1 - t19 * t506 * t214 / 0.4e1;
  t1423 = -0.9e1 / 0.4e1 * t19 * t351 * t267 + t19 * t41 * t350 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t19 * t107 * t650 * t102 - 0.3e1 / 0.8e1 * t19 * t20 * (-0.22e4 / 0.243e3 * t190 * t484 - 0.208e6 / 0.2187e4 * t194 * t494 - 0.494e4 / 0.729e3 * t71 * t565) * t102 - 0.9e1 / 0.4e1 * t319 * t1148 * t364 - 0.9e1 / 0.2e1 * t319 * t584 * t698 - 0.9e1 / 0.4e1 * t319 * t320 * t673 * t152 - 0.9e1 / 0.4e1 * t319 * t584 * t702 - 0.9e1 / 0.4e1 * t319 * t320 * t374 * t281 - 0.3e1 / 0.4e1 * t319 * t320 * t213 * t524 - 0.3e1 / 0.2e1 * t581 * t695 - 0.3e1 / 0.2e1 * t581 * t699 + t1179 * t365 / 0.2e1 - 0.9e1 / 0.4e1 * t319 * t787 * t474 + 0.27e2 / 0.4e1 * t319 * t1170 * t691 + 0.27e2 / 0.4e1 * t319 * t553 * t374 * t266 + 0.9e1 / 0.4e1 * t581 * t692 - 0.9e1 * t319 * t1190 * t213 * t469 - 0.3e1 / 0.4e1 * t581 * t703 - 0.5e1 / 0.36e2 * t19 * t34 * t200 * t102;
  t1425 = my_piecewise3(t3, 0, t1351 + t1423);
  tv4rho3tau0 = 0.2e1 * rho[0] * t1425 + 0.6e1 * t715;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t1429 = t28 * t265;
  t1431 = t402 * t1429 * t266;
  t1435 = t18 / t242;
  t1449 = t7 * t719 * params->a2t;
  t1453 = t402 * t725 * t281;
  t1458 = t386 * t266;
  t1462 = t386 * t281;
  t1476 = t331 * t331;
  t1493 = -t724 * t1431 / 0.192e3 + 0.5e1 / 0.64e2 * t7 * t1435 * t79 * t404 - 0.5e1 / 0.192e3 * t7 * t719 * t135 * t404 + t7 * t384 * t256 * t404 / 0.384e3 - 0.5e1 / 0.192e3 * t1449 * t727 + t724 * t1453 / 0.384e3 + t400 * t468 * params->a2b * t46 * t1458 / 0.64e2 - t400 * t766 * t1462 / 0.192e3 + 0.5e1 / 0.96e2 * t758 * t768 - t762 * t768 / 0.96e2 + t19 * t558 * t183 / 0.2e1 - t19 * t625 * t183 / 0.6e1 - 0.3e1 / 0.2e1 * t19 * t80 * t265 * t1476 + t19 * t222 * t395 / 0.6e1 - t19 * t226 * t395 / 0.2e1 - 0.3e1 / 0.4e1 * t19 * t257 * t395 + t19 * t290 * t332 / 0.2e1;
  t1503 = t172 * t468;
  t1520 = t304 * t265;
  t1546 = 0.3e1 / 0.4e1 * t19 * t573 * t183 + 0.3e1 / 0.2e1 * t19 * t305 * t332 + 0.3e1 / 0.4e1 * t19 * t173 * t621 + 0.9e1 / 0.2e1 * t319 * t1503 * t554 - 0.9e1 * t319 * t1190 * t394 * t266 + 0.9e1 / 0.4e1 * t319 * t553 * t394 * t281 - 0.3e1 / 0.2e1 * t319 * t320 * t182 * t620 - t581 * t737 - 0.3e1 * t319 * t1520 * t321 - 0.3e1 * t319 * t736 * t588 - 0.3e1 / 0.2e1 * t319 * t736 * t592 + 0.3e1 / 0.2e1 * t581 * t750 - t581 * t754 + 0.9e1 / 0.2e1 * t319 * t1170 * t749 - 0.3e1 * t319 * t584 * t753 + 0.9e1 * t319 * t553 * t321 * t331 - 0.5e1 / 0.64e2 * t7 * t1435 * t388;
  t1548 = my_piecewise3(t3, 0, t1493 + t1546);
  tv4rho2sigma20 = 0.2e1 * rho[0] * t1548 + 0.4e1 * t772;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  t1563 = t7 * t384 * params->xt;
  t1569 = t468 * params->xb * t46;
  t1586 = -0.5e1 / 0.144e3 * t778 * t1431 + 0.25e2 / 0.72e2 * t758 * t429 - 0.5e1 / 0.36e2 * t762 * t429 + 0.5e1 / 0.288e3 * t7 * t411 * t256 * t429 - 0.5e1 / 0.36e2 * t1563 * t727 + 0.5e1 / 0.288e3 * t778 * t1453 + 0.5e1 / 0.48e2 * t427 * t1569 * t1458 - 0.5e1 / 0.72e2 * t826 * t831 - 0.5e1 / 0.144e3 * t427 * t830 * t1462 + 0.5e1 / 0.18e2 * t400 * t831 + t19 * t640 * t183 / 0.4e1 + t19 * t340 * t332 / 0.4e1;
  t1607 = t200 * t468;
  t1622 = 0.3e1 / 0.8e1 * t19 * t651 * t183 + 0.3e1 / 0.4e1 * t19 * t351 * t332 - t19 * t625 * t214 / 0.12e2 + 0.3e1 / 0.8e1 * t19 * t173 * t674 - t19 * t678 * t183 / 0.12e2 + 0.9e1 / 0.4e1 * t319 * t1503 * t691 + t1179 * t423 / 0.6e1 + 0.9e1 / 0.4e1 * t319 * t1607 * t554 - 0.3e1 / 0.4e1 * t319 * t787 * t592 - t581 * t800 / 0.2e1 - 0.3e1 / 0.4e1 * t319 * t1148 * t422 - 0.3e1 / 0.2e1 * t319 * t584 * t815;
  t1637 = t350 * t265;
  t1661 = -0.3e1 / 0.2e1 * t319 * t584 * t819 - 0.3e1 / 0.4e1 * t319 * t320 * t673 * t182 - 0.3e1 / 0.2e1 * t319 * t320 * t374 * t331 - t581 * t788 / 0.2e1 - 0.3e1 / 0.2e1 * t319 * t1637 * t321 - 0.3e1 / 0.2e1 * t319 * t787 * t588 - 0.3e1 / 0.4e1 * t319 * t320 * t213 * t620 - 0.3e1 / 0.2e1 * t319 * t1520 * t364 - 0.3e1 / 0.2e1 * t319 * t736 * t698 - 0.3e1 / 0.4e1 * t319 * t736 * t702 - t581 * t808 / 0.2e1 - t581 * t816 / 0.2e1;
  t1702 = -t581 * t820 / 0.2e1 + 0.3e1 / 0.4e1 * t19 * t305 * t375 + t19 * t290 * t375 / 0.4e1 + 0.3e1 / 0.8e1 * t19 * t573 * t214 + 0.9e1 / 0.2e1 * t319 * t553 * t815 * t152 + 0.9e1 / 0.2e1 * t319 * t553 * t819 * t152 + 0.9e1 / 0.4e1 * t319 * t553 * t422 * t281 + 0.3e1 / 0.2e1 * t581 * t812 + 0.9e1 / 0.2e1 * t319 * t1170 * t811 - 0.9e1 * t319 * t1190 * t422 * t266 - 0.25e2 / 0.72e2 * t720 * t413 + 0.3e1 / 0.8e1 * t19 * t201 * t621 + t19 * t558 * t214 / 0.4e1;
  t1705 = my_piecewise3(t3, 0, t1586 + t1622 + t1661 + t1702);
  tv4rho2sigmatau0 = 0.2e1 * rho[0] * t1705 + 0.4e1 * t835;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  t1714 = t7 * t411 * params->b2t;
  t1726 = t468 * params->b2b * t28;
  t1759 = -0.25e2 / 0.27e2 * t841 * t1431 + 0.5e2 / 0.9e1 * t400 * t454 - 0.25e2 / 0.9e1 * t1714 * t727 + 0.25e2 / 0.54e2 * t841 * t1453 - 0.25e2 / 0.9e1 * t826 * t454 + 0.25e2 / 0.54e2 * t7 * t436 * t256 * t454 + 0.25e2 / 0.9e1 * t452 * t1726 * t402 * t266 - 0.5e2 / 0.27e2 * t873 * t879 - 0.25e2 / 0.27e2 * t452 * t877 * t402 * t281 + 0.5e2 / 0.9e1 * t427 * t879 + 0.9e1 / 0.2e1 * t319 * t1170 * t862 - 0.3e1 * t319 * t584 * t866 - 0.3e1 / 0.2e1 * t319 * t320 * t213 * t673 - t581 * t850 - 0.3e1 * t319 * t1637 * t364 - 0.3e1 * t319 * t787 * t698 - 0.3e1 / 0.2e1 * t319 * t787 * t702;
  t1777 = t374 * t374;
  t1812 = 0.3e1 / 0.2e1 * t581 * t863 - t581 * t867 + 0.9e1 / 0.4e1 * t319 * t553 * t446 * t281 - 0.9e1 * t319 * t1190 * t446 * t266 + 0.9e1 / 0.2e1 * t319 * t1607 * t691 + t19 * t222 * t447 / 0.6e1 - 0.3e1 / 0.2e1 * t19 * t80 * t265 * t1777 - t19 * t678 * t214 / 0.6e1 - 0.3e1 / 0.4e1 * t19 * t257 * t447 + 0.3e1 / 0.4e1 * t19 * t201 * t674 - t19 * t226 * t447 / 0.2e1 + t19 * t340 * t375 / 0.2e1 + 0.3e1 / 0.4e1 * t19 * t651 * t214 + 0.3e1 / 0.2e1 * t19 * t351 * t375 + t19 * t640 * t214 / 0.2e1 - 0.5e2 / 0.9e1 * t385 * t440 + 0.9e1 * t319 * t553 * t364 * t374;
  t1814 = my_piecewise3(t3, 0, t1759 + t1812);
  tv4rho2tau20 = 0.2e1 * rho[0] * t1814 + 0.4e1 * t883;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t1820 = t403 * t902 * t152;
  t1824 = t402 * t725 * t331;
  t1869 = t19 * t383 * t79 * t468;
  t1880 = -0.5e1 / 0.128e3 * t1449 * t887 - t724 * t1820 / 0.64e2 + t724 * t1824 / 0.128e3 - 0.3e1 / 0.4e1 * t19 * t290 * t395 - 0.9e1 / 0.4e1 * t19 * t305 * t395 + 0.27e2 / 0.4e1 * t319 * t1503 * t749 - 0.9e1 / 0.2e1 * t319 * t736 * t753 - 0.5e1 / 0.128e3 * t7 * t719 * t172 * t404 + t7 * t384 * t304 * t404 / 0.128e3 - t894 * t768 / 0.64e2 + 0.3e1 / 0.4e1 * t19 * t108 * t898 + 0.9e1 / 0.4e1 * t19 * t136 * t898 - 0.9e1 * t319 * t1190 * t897 * t152 + 0.27e2 / 0.4e1 * t319 * t553 * t394 * t331 + 0.5e1 / 0.64e2 * t758 * t904 - t762 * t904 / 0.64e2 + 0.3e1 / 0.64e2 * t1869 * t182 * params->a2b * t46 * t767 - t400 * t265 * t331 * params->a2b * t403 / 0.64e2;
  t1881 = my_piecewise3(t3, 0, t1880);
  tv4rhosigma30 = 0.2e1 * rho[0] * t1881 + 0.2e1 * t908;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  t1891 = t19 * t410 * t79 * t468;
  t1911 = t402 * t725 * t374;
  t1927 = t403 * t938 * t152;
  t1940 = t1869 * t213 * params->a2b * t46 * t767 / 0.64e2 + 0.5e1 / 0.24e2 * t1891 * t98 * t28 * t182 * t152 - 0.3e1 / 0.4e1 * t19 * t351 * t395 - 0.5e1 / 0.36e2 * t894 * t429 - 0.5e1 / 0.36e2 * t1563 * t887 - 0.5e1 / 0.384e3 * t7 * t719 * t200 * t404 - 0.5e1 / 0.384e3 * t1449 * t920 + t724 * t1911 / 0.384e3 + 0.5e1 / 0.144e3 * t7 * t411 * t304 * t429 + 0.5e1 / 0.144e3 * t778 * t1824 + t7 * t384 * t350 * t404 / 0.384e3 + 0.5e1 / 0.18e2 * t400 * t935 - t724 * t1927 / 0.192e3 - 0.5e1 / 0.72e2 * t927 * t831 - 0.5e1 / 0.72e2 * t826 * t935 - 0.5e1 / 0.72e2 * t427 * t830 * t386 * t331 - t762 * t940 / 0.192e3;
  t1941 = t265 * t374;
  t1992 = -t400 * t1941 * params->a2b * t403 / 0.192e3 - 0.5e1 / 0.72e2 * t778 * t1820 - t916 * t768 / 0.192e3 + 0.5e1 / 0.192e3 * t758 * t940 - t581 * t923 / 0.2e1 + 0.3e1 / 0.4e1 * t581 * t931 + 0.9e1 / 0.4e1 * t319 * t1607 * t749 - 0.3e1 / 0.2e1 * t319 * t787 * t753 - 0.3e1 / 0.2e1 * t319 * t1520 * t422 - 0.3e1 / 0.2e1 * t319 * t736 * t815 - 0.3e1 / 0.2e1 * t319 * t736 * t819 + 0.9e1 / 0.4e1 * t319 * t1170 * t930 + 0.9e1 / 0.4e1 * t319 * t553 * t374 * t394 - t19 * t340 * t395 / 0.4e1 + 0.9e1 / 0.2e1 * t319 * t1503 * t811 - 0.9e1 * t319 * t1190 * t930 * t152 + 0.9e1 / 0.2e1 * t319 * t553 * t422 * t331;
  t1994 = my_piecewise3(t3, 0, t1940 + t1992);
  tv4rhosigma2tau0 = 0.2e1 * rho[0] * t1994 + 0.2e1 * t944;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  t1999 = t19 * t435 * t79 * t468;
  t2054 = 0.25e2 / 0.9e1 * t1999 * params->b2b * t28 * t46 * t49 * t182 * t152 + 0.5e1 / 0.24e2 * t1891 * t213 * params->xb * t46 * t767 - 0.3e1 / 0.2e1 * t319 * t1637 * t422 - 0.3e1 / 0.2e1 * t319 * t787 * t815 - 0.3e1 / 0.2e1 * t319 * t787 * t819 + 0.9e1 / 0.4e1 * t319 * t1503 * t862 - 0.3e1 / 0.2e1 * t319 * t736 * t866 + 0.9e1 / 0.4e1 * t319 * t1170 * t960 + 0.9e1 / 0.4e1 * t319 * t553 * t446 * t331 + 0.5e1 / 0.144e3 * t778 * t1911 + 0.5e1 / 0.144e3 * t7 * t411 * t350 * t429 + 0.25e2 / 0.54e2 * t7 * t436 * t304 * t454 + 0.25e2 / 0.54e2 * t841 * t1824 - 0.25e2 / 0.18e2 * t927 * t454 - 0.25e2 / 0.18e2 * t1714 * t887 - 0.5e1 / 0.36e2 * t1563 * t920 - 0.5e1 / 0.36e2 * t916 * t429;
  t2100 = -t581 * t950 / 0.2e1 + 0.3e1 / 0.4e1 * t581 * t961 - 0.5e1 / 0.72e2 * t826 * t965 - 0.5e1 / 0.72e2 * t427 * t1941 * params->xb * t403 - 0.25e2 / 0.27e2 * t969 * t879 - 0.25e2 / 0.27e2 * t873 * t973 - 0.25e2 / 0.27e2 * t452 * t877 * t402 * t331 - 0.25e2 / 0.27e2 * t841 * t1820 - 0.5e1 / 0.72e2 * t778 * t1927 - 0.5e1 / 0.72e2 * t954 * t831 + 0.25e2 / 0.9e1 * t427 * t973 + 0.5e1 / 0.18e2 * t400 * t965 - t19 * t290 * t447 / 0.4e1 - 0.3e1 / 0.4e1 * t19 * t305 * t447 - 0.9e1 * t319 * t1190 * t960 * t152 + 0.9e1 / 0.2e1 * t319 * t553 * t422 * t374 + 0.9e1 / 0.2e1 * t319 * t1607 * t811;
  t2102 = my_piecewise3(t3, 0, t2054 + t2100);
  tv4rhosigmatau20 = 0.2e1 * rho[0] * t2102 + 0.2e1 * t977;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rholapl30 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  t2150 = t213 * params->b2b * t28;
  t2158 = -0.25e2 / 0.6e1 * t1714 * t920 - 0.25e2 / 0.9e1 * t841 * t1927 + 0.25e2 / 0.18e2 * t841 * t1911 - 0.3e1 / 0.4e1 * t19 * t340 * t447 - 0.9e1 / 0.4e1 * t19 * t351 * t447 + 0.27e2 / 0.4e1 * t319 * t1607 * t862 - 0.9e1 / 0.2e1 * t319 * t787 * t866 - 0.25e2 / 0.6e1 * t954 * t454 + 0.25e2 / 0.18e2 * t7 * t436 * t350 * t454 - 0.25e2 / 0.9e1 * t985 * t879 + 0.3e1 / 0.4e1 * t19 * t108 * t989 + 0.9e1 / 0.4e1 * t19 * t136 * t989 - 0.9e1 * t319 * t1190 * t988 * t152 + 0.27e2 / 0.4e1 * t319 * t553 * t446 * t374 + 0.25e2 / 0.3e1 * t427 * t994 - 0.25e2 / 0.9e1 * t873 * t994 + 0.25e2 / 0.3e1 * t1999 * t2150 * t878 - 0.25e2 / 0.9e1 * t452 * t1941 * params->b2b * t403;
  t2159 = my_piecewise3(t3, 0, t2158);
  tv4rhotau30 = 0.2e1 * rho[0] * t2159 + 0.2e1 * t998;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t2163 = t402 * t1429 * t394;
  t2169 = t18 / t20 / t487 / t31;
  t2172 = t23 * t23;
  t2174 = 0.1e1 / t25 / t2172;
  t2175 = t21 * t2174;
  t2176 = t29 * t141;
  t2178 = t2175 * t2176 * params->a2b;
  t2186 = t394 * t394;
  t2198 = params->a2b * params->a2b;
  t2200 = t2175 * t29;
  t2205 = my_piecewise3(t3, 0, -t724 * t2163 / 0.32e2 + t7 * t2169 * params->a2t * t2178 / 0.1536e4 + 0.9e1 * t19 * t173 * t898 - t894 * t904 / 0.16e2 - 0.9e1 * t19 * t80 * t1030 * t2186 + 0.3e1 / 0.32e2 * t400 * t468 * t394 * params->a2b * t403 - t7 * t2169 * t79 * t265 * t2198 * t2200 / 0.1536e4);
  tv4sigma40 = 0.2e1 * rho[0] * t2205;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  t2221 = t18 * t1073;
  t2229 = t2175 * t2176 * params->xb;
  t2233 = t403 * t938 * t182;
  t2246 = t829 * t21;
  t2247 = t2174 * t29;
  t2256 = 0.27e2 / 0.4e1 * t319 * t1503 * t930 - 0.9e1 * t319 * t1190 * t213 * t897 + 0.3e1 / 0.64e2 * t1869 * t422 * params->a2b * t403 + 0.9e1 / 0.4e1 * t19 * t201 * t898 + 0.5e1 / 0.2304e4 * t7 * t2221 * params->xt * t2178 + 0.5e1 / 0.2304e4 * t7 * t2221 * params->a2t * t2229 - t724 * t2233 / 0.64e2 - 0.5e1 / 0.24e2 * t927 * t935 - t894 * t940 / 0.64e2 + 0.5e1 / 0.16e2 * t427 * t1569 * t386 * t394 - 0.5e1 / 0.1152e4 * t7 * t2221 * t79 * t2246 * t2247 * params->a2b - 0.5e1 / 0.48e2 * t778 * t2163 - t916 * t904 / 0.64e2;
  t2257 = my_piecewise3(t3, 0, t2256);
  tv4sigma3tau0 = 0.2e1 * rho[0] * t2257;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  t2260 = t402 * t1429 * t446;
  t2263 = t18 * t489;
  t2265 = t7 * t2263 * t79;
  t2266 = params->xb * params->xb;
  t2274 = t2175 * t2176 * params->b2b;
  t2294 = t468 * t446;
  t2325 = -t724 * t2260 / 0.192e3 - 0.25e2 / 0.1296e4 * t2265 * t265 * t2266 * t2200 + 0.25e2 / 0.1296e4 * t7 * t2263 * params->a2t * t2274 - 0.9e1 * t319 * t1190 * t446 * t394 + 0.9e1 / 0.2e1 * t319 * t1607 * t930 + 0.9e1 / 0.2e1 * t319 * t1503 * t960 - 0.25e2 / 0.648e3 * t2265 * t876 * t29 * t2175 * params->a2b - 0.5e1 / 0.36e2 * t927 * t965 + t400 * t2294 * params->a2b * t403 / 0.64e2 - 0.5e2 / 0.27e2 * t969 * t973 - 0.25e2 / 0.27e2 * t841 * t2163 - 0.5e1 / 0.36e2 * t778 * t2233 - 0.5e1 / 0.36e2 * t954 * t935 - t916 * t940 / 0.96e2 + 0.5e1 / 0.12e2 * t1891 * t422 * params->xb * t403 + 0.25e2 / 0.9e1 * t452 * t1726 * t402 * t394 + 0.25e2 / 0.1296e4 * t7 * t2263 * params->b2t * t2178 + 0.25e2 / 0.1296e4 * t7 * t2263 * params->xt * t2229;
  t2326 = my_piecewise3(t3, 0, t2325);
  tv4sigma2tau20 = 0.2e1 * rho[0] * t2326;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  t2330 = t18 * t244;
  t2370 = -0.25e2 / 0.9e1 * t841 * t2233 + 0.125e3 / 0.324e3 * t7 * t2330 * params->b2t * t2229 - 0.5e1 / 0.48e2 * t778 * t2260 + 0.27e2 / 0.4e1 * t319 * t1607 * t960 - 0.5e1 / 0.24e2 * t954 * t965 + 0.125e3 / 0.324e3 * t7 * t2330 * params->xt * t2274 - 0.25e2 / 0.9e1 * t985 * t973 + 0.9e1 / 0.4e1 * t19 * t173 * t989 - 0.9e1 * t319 * t1190 * t988 * t182 + 0.5e1 / 0.16e2 * t427 * t2294 * params->xb * t403 - 0.25e2 / 0.9e1 * t969 * t994 + 0.25e2 / 0.3e1 * t1999 * t2150 * t972 - 0.125e3 / 0.162e3 * t7 * t2330 * t79 * t2246 * t2247 * params->b2b;
  t2371 = my_piecewise3(t3, 0, t2370);
  tv4sigmatau30 = 0.2e1 * rho[0] * t2371;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4lapl40 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  t2375 = t18 * t123;
  t2385 = t446 * t446;
  t2396 = params->b2b * params->b2b;
  t2402 = my_piecewise3(t3, 0, -0.5e2 / 0.9e1 * t841 * t2260 + 0.5e4 / 0.243e3 * t7 * t2375 * params->b2t * t2274 + 0.9e1 * t19 * t201 * t989 - 0.1e3 / 0.9e1 * t985 * t994 - 0.9e1 * t19 * t80 * t1030 * t2385 + 0.5e2 / 0.3e1 * t452 * t2294 * params->b2b * t403 - 0.5e4 / 0.243e3 * t7 * t2375 * t79 * t265 * t2396 * t2200);
  tv4tau40 = 0.2e1 * rho[0] * t2402;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t40, t41;
  double t44, t46, t48, t51, t52, t54, t55, t56;
  double t57, t58, t60, t61, t64, t65, t66, t68;
  double t69, t70, t73, t74, t76, t78, t81, t82;
  double t83, t86, t89, t92, t95, t96, t99, t100;
  double t101, t104, t105, t106, t108, t109, t110, t111;
  double t113, t114, t115, t116, t117, t118, t120, t121;
  double t124, t126, t128, t131, t132, t133, t134, t136;
  double t137, t140, t141, t142, t144, t145, t146, t150;
  double t152, t155, t156, t159, t164, t169, t170, t171;
  double t174, tzk0;

  mgga_x_ktbm_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ktbm_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = t6 * t26;
  t28 = POW_1_3(t7);
  t29 = M_CBRT6;
  t30 = params->at * t29;
  t31 = M_PI * M_PI;
  t32 = POW_1_3(t31);
  t33 = t32 * t32;
  t34 = 0.1e1 / t33;
  t35 = t34 * sigma[0];
  t36 = rho[0] * rho[0];
  t37 = POW_1_3(rho[0]);
  t38 = t37 * t37;
  t40 = 0.1e1 / t38 / t36;
  t41 = t35 * t40;
  t44 = params->bt * tau[0];
  t46 = 0.1e1 / t38 / rho[0];
  t48 = t46 * t29 * t34;
  t51 = t29 * t29;
  t52 = params->a2t * t51;
  t54 = 0.1e1 / t32 / t31;
  t55 = sigma[0] * sigma[0];
  t56 = t54 * t55;
  t57 = t36 * t36;
  t58 = t57 * rho[0];
  t60 = 0.1e1 / t37 / t58;
  t61 = t56 * t60;
  t64 = tau[0] * tau[0];
  t65 = params->b2t * t64;
  t66 = t36 * rho[0];
  t68 = 0.1e1 / t37 / t66;
  t69 = t68 * t51;
  t70 = t69 * t54;
  t73 = params->xt * t51;
  t74 = t73 * t54;
  t76 = 0.1e1 / t37 / t57;
  t78 = sigma[0] * t76 * tau[0];
  t81 = params->ct + t30 * t41 / 0.24e2 + 0.5e1 / 0.9e1 * t44 * t48 + t52 * t61 / 0.576e3 + 0.25e2 / 0.81e2 * t65 * t70 + 0.5e1 / 0.216e3 * t74 * t78;
  t82 = t28 * t81;
  t83 = params->ab * t29;
  t86 = params->bb * tau[0];
  t89 = params->a2b * t51;
  t92 = params->b2b * t64;
  t95 = params->xb * t51;
  t96 = t95 * t54;
  t99 = params->cb + t83 * t41 / 0.24e2 + 0.5e1 / 0.9e1 * t86 * t48 + t89 * t61 / 0.576e3 + 0.25e2 / 0.81e2 * t92 * t70 + 0.5e1 / 0.216e3 * t96 * t78;
  t100 = 0.1e1 / t99;
  t101 = t82 * t100;
  t104 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t101);
  t105 = rho[1] <= p->dens_threshold;
  t106 = -t17;
  t108 = my_piecewise5(t15, t12, t11, t16, t106 * t8);
  t109 = 0.1e1 + t108;
  t110 = t109 <= p->zeta_threshold;
  t111 = POW_1_3(t109);
  t113 = my_piecewise3(t110, t23, t111 * t109);
  t114 = t6 * t113;
  t115 = t34 * sigma[2];
  t116 = rho[1] * rho[1];
  t117 = POW_1_3(rho[1]);
  t118 = t117 * t117;
  t120 = 0.1e1 / t118 / t116;
  t121 = t115 * t120;
  t124 = params->bt * tau[1];
  t126 = 0.1e1 / t118 / rho[1];
  t128 = t126 * t29 * t34;
  t131 = sigma[2] * sigma[2];
  t132 = t54 * t131;
  t133 = t116 * t116;
  t134 = t133 * rho[1];
  t136 = 0.1e1 / t117 / t134;
  t137 = t132 * t136;
  t140 = tau[1] * tau[1];
  t141 = params->b2t * t140;
  t142 = t116 * rho[1];
  t144 = 0.1e1 / t117 / t142;
  t145 = t144 * t51;
  t146 = t145 * t54;
  t150 = 0.1e1 / t117 / t133;
  t152 = sigma[2] * t150 * tau[1];
  t155 = params->ct + t30 * t121 / 0.24e2 + 0.5e1 / 0.9e1 * t124 * t128 + t52 * t137 / 0.576e3 + 0.25e2 / 0.81e2 * t141 * t146 + 0.5e1 / 0.216e3 * t74 * t152;
  t156 = t28 * t155;
  t159 = params->bb * tau[1];
  t164 = params->b2b * t140;
  t169 = params->cb + t83 * t121 / 0.24e2 + 0.5e1 / 0.9e1 * t159 * t128 + t89 * t137 / 0.576e3 + 0.25e2 / 0.81e2 * t164 * t146 + 0.5e1 / 0.216e3 * t96 * t152;
  t170 = 0.1e1 / t169;
  t171 = t156 * t170;
  t174 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t171);
  tzk0 = t104 + t174;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t40, t41;
  double t44, t46, t48, t51, t52, t54, t55, t56;
  double t57, t58, t60, t61, t64, t65, t66, t68;
  double t69, t70, t73, t74, t76, t78, t81, t82;
  double t83, t86, t89, t92, t95, t96, t99, t100;
  double t101, t104, t105, t106, t108, t109, t110, t111;
  double t113, t114, t115, t116, t117, t118, t120, t121;
  double t124, t126, t128, t131, t132, t133, t134, t136;
  double t137, t140, t141, t142, t144, t145, t146, t150;
  double t152, t155, t156, t159, t164, t169, t170, t171;
  double t174, tzk0;

  double t175, t176, t177, t179, t182, t183, t186, t187;
  double t188, t189, t191, t193, t194, t198, t201, t203;
  double t204, t208, t212, t215, t216, t217, t220, t221;
  double t232, t233, t234, t238, t239, t241, t244, t245;
  double t248, t249, t251, t253, tvrho0, t257, t260, t261;
  double t265, t267, t270, t271, t275, t276, t280, t283;
  double t285, t286, t290, t294, t297, t298, t299, t302;
  double t303, t314, t315, t316, t320, tvrho1, t323, t326;
  double t327, t330, t331, t334, t335, t336, t344, t345;
  double t346, t350, tvsigma0, tvsigma1, t351, t354, t355, t358;
  double t359, t362, t363, t364, t372, t373, t374, t378;
  double tvsigma2, tvlapl0, tvlapl1, t380, t383, t386, t389, t390;
  double t391, t396, t401, t402, t403, t407, tvtau0, t411;
  double t414, t417, t418, t419, t424, t429, t430, t431;
  double t435, tvtau1;

  mgga_x_ktbm_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ktbm_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = t6 * t26;
  t28 = POW_1_3(t7);
  t29 = M_CBRT6;
  t30 = params->at * t29;
  t31 = M_PI * M_PI;
  t32 = POW_1_3(t31);
  t33 = t32 * t32;
  t34 = 0.1e1 / t33;
  t35 = t34 * sigma[0];
  t36 = rho[0] * rho[0];
  t37 = POW_1_3(rho[0]);
  t38 = t37 * t37;
  t40 = 0.1e1 / t38 / t36;
  t41 = t35 * t40;
  t44 = params->bt * tau[0];
  t46 = 0.1e1 / t38 / rho[0];
  t48 = t46 * t29 * t34;
  t51 = t29 * t29;
  t52 = params->a2t * t51;
  t54 = 0.1e1 / t32 / t31;
  t55 = sigma[0] * sigma[0];
  t56 = t54 * t55;
  t57 = t36 * t36;
  t58 = t57 * rho[0];
  t60 = 0.1e1 / t37 / t58;
  t61 = t56 * t60;
  t64 = tau[0] * tau[0];
  t65 = params->b2t * t64;
  t66 = t36 * rho[0];
  t68 = 0.1e1 / t37 / t66;
  t69 = t68 * t51;
  t70 = t69 * t54;
  t73 = params->xt * t51;
  t74 = t73 * t54;
  t76 = 0.1e1 / t37 / t57;
  t78 = sigma[0] * t76 * tau[0];
  t81 = params->ct + t30 * t41 / 0.24e2 + 0.5e1 / 0.9e1 * t44 * t48 + t52 * t61 / 0.576e3 + 0.25e2 / 0.81e2 * t65 * t70 + 0.5e1 / 0.216e3 * t74 * t78;
  t82 = t28 * t81;
  t83 = params->ab * t29;
  t86 = params->bb * tau[0];
  t89 = params->a2b * t51;
  t92 = params->b2b * t64;
  t95 = params->xb * t51;
  t96 = t95 * t54;
  t99 = params->cb + t83 * t41 / 0.24e2 + 0.5e1 / 0.9e1 * t86 * t48 + t89 * t61 / 0.576e3 + 0.25e2 / 0.81e2 * t92 * t70 + 0.5e1 / 0.216e3 * t96 * t78;
  t100 = 0.1e1 / t99;
  t101 = t82 * t100;
  t104 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t101);
  t105 = rho[1] <= p->dens_threshold;
  t106 = -t17;
  t108 = my_piecewise5(t15, t12, t11, t16, t106 * t8);
  t109 = 0.1e1 + t108;
  t110 = t109 <= p->zeta_threshold;
  t111 = POW_1_3(t109);
  t113 = my_piecewise3(t110, t23, t111 * t109);
  t114 = t6 * t113;
  t115 = t34 * sigma[2];
  t116 = rho[1] * rho[1];
  t117 = POW_1_3(rho[1]);
  t118 = t117 * t117;
  t120 = 0.1e1 / t118 / t116;
  t121 = t115 * t120;
  t124 = params->bt * tau[1];
  t126 = 0.1e1 / t118 / rho[1];
  t128 = t126 * t29 * t34;
  t131 = sigma[2] * sigma[2];
  t132 = t54 * t131;
  t133 = t116 * t116;
  t134 = t133 * rho[1];
  t136 = 0.1e1 / t117 / t134;
  t137 = t132 * t136;
  t140 = tau[1] * tau[1];
  t141 = params->b2t * t140;
  t142 = t116 * rho[1];
  t144 = 0.1e1 / t117 / t142;
  t145 = t144 * t51;
  t146 = t145 * t54;
  t150 = 0.1e1 / t117 / t133;
  t152 = sigma[2] * t150 * tau[1];
  t155 = params->ct + t30 * t121 / 0.24e2 + 0.5e1 / 0.9e1 * t124 * t128 + t52 * t137 / 0.576e3 + 0.25e2 / 0.81e2 * t141 * t146 + 0.5e1 / 0.216e3 * t74 * t152;
  t156 = t28 * t155;
  t159 = params->bb * tau[1];
  t164 = params->b2b * t140;
  t169 = params->cb + t83 * t121 / 0.24e2 + 0.5e1 / 0.9e1 * t159 * t128 + t89 * t137 / 0.576e3 + 0.25e2 / 0.81e2 * t164 * t146 + 0.5e1 / 0.216e3 * t96 * t152;
  t170 = 0.1e1 / t169;
  t171 = t156 * t170;
  t174 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t171);
  tzk0 = t104 + t174;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t175 = t7 * t7;
  t176 = 0.1e1 / t175;
  t177 = t17 * t176;
  t179 = my_piecewise5(t11, 0, t15, 0, t8 - t177);
  t182 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t179);
  t183 = t6 * t182;
  t186 = t28 * t28;
  t187 = 0.1e1 / t186;
  t188 = t187 * t81;
  t189 = t188 * t100;
  t191 = t27 * t189 / 0.8e1;
  t193 = 0.1e1 / t38 / t66;
  t194 = t35 * t193;
  t198 = t40 * t29 * t34;
  t201 = t57 * t36;
  t203 = 0.1e1 / t37 / t201;
  t204 = t56 * t203;
  t208 = t76 * t51 * t54;
  t212 = sigma[0] * t60 * tau[0];
  t215 = -t30 * t194 / 0.9e1 - 0.25e2 / 0.27e2 * t44 * t198 - t52 * t204 / 0.108e3 - 0.25e3 / 0.243e3 * t65 * t208 - 0.65e2 / 0.648e3 * t74 * t212;
  t216 = t28 * t215;
  t217 = t216 * t100;
  t220 = t99 * t99;
  t221 = 0.1e1 / t220;
  t232 = -t83 * t194 / 0.9e1 - 0.25e2 / 0.27e2 * t86 * t198 - t89 * t204 / 0.108e3 - 0.25e3 / 0.243e3 * t92 * t208 - 0.65e2 / 0.648e3 * t96 * t212;
  t233 = t221 * t232;
  t234 = t82 * t233;
  t238 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t183 * t101 - t191 - 0.3e1 / 0.8e1 * t27 * t217 + 0.3e1 / 0.8e1 * t27 * t234);
  t239 = t106 * t176;
  t241 = my_piecewise5(t15, 0, t11, 0, -t8 - t239);
  t244 = my_piecewise3(t110, 0, 0.4e1 / 0.3e1 * t111 * t241);
  t245 = t6 * t244;
  t248 = t187 * t155;
  t249 = t248 * t170;
  t251 = t114 * t249 / 0.8e1;
  t253 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t245 * t171 - t251);
  tvrho0 = t104 + t174 + t7 * (t238 + t253);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t257 = my_piecewise5(t11, 0, t15, 0, -t8 - t177);
  t260 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t257);
  t261 = t6 * t260;
  t265 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t261 * t101 - t191);
  t267 = my_piecewise5(t15, 0, t11, 0, t8 - t239);
  t270 = my_piecewise3(t110, 0, 0.4e1 / 0.3e1 * t111 * t267);
  t271 = t6 * t270;
  t275 = 0.1e1 / t118 / t142;
  t276 = t115 * t275;
  t280 = t120 * t29 * t34;
  t283 = t133 * t116;
  t285 = 0.1e1 / t117 / t283;
  t286 = t132 * t285;
  t290 = t150 * t51 * t54;
  t294 = sigma[2] * t136 * tau[1];
  t297 = -t30 * t276 / 0.9e1 - 0.25e2 / 0.27e2 * t124 * t280 - t52 * t286 / 0.108e3 - 0.25e3 / 0.243e3 * t141 * t290 - 0.65e2 / 0.648e3 * t74 * t294;
  t298 = t28 * t297;
  t299 = t298 * t170;
  t302 = t169 * t169;
  t303 = 0.1e1 / t302;
  t314 = -t83 * t276 / 0.9e1 - 0.25e2 / 0.27e2 * t159 * t280 - t89 * t286 / 0.108e3 - 0.25e3 / 0.243e3 * t164 * t290 - 0.65e2 / 0.648e3 * t96 * t294;
  t315 = t303 * t314;
  t316 = t156 * t315;
  t320 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t271 * t171 - t251 - 0.3e1 / 0.8e1 * t114 * t299 + 0.3e1 / 0.8e1 * t114 * t316);
  tvrho1 = t104 + t174 + t7 * (t265 + t320);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t323 = t34 * t40;
  t326 = t54 * sigma[0];
  t327 = t326 * t60;
  t330 = t54 * t76;
  t331 = t330 * tau[0];
  t334 = t30 * t323 / 0.24e2 + t52 * t327 / 0.288e3 + 0.5e1 / 0.216e3 * t73 * t331;
  t335 = t28 * t334;
  t336 = t335 * t100;
  t344 = t83 * t323 / 0.24e2 + t89 * t327 / 0.288e3 + 0.5e1 / 0.216e3 * t95 * t331;
  t345 = t221 * t344;
  t346 = t82 * t345;
  t350 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t336 + 0.3e1 / 0.8e1 * t27 * t346);
  tvsigma0 = t7 * t350;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t351 = t34 * t120;
  t354 = t54 * sigma[2];
  t355 = t354 * t136;
  t358 = t54 * t150;
  t359 = t358 * tau[1];
  t362 = t30 * t351 / 0.24e2 + t52 * t355 / 0.288e3 + 0.5e1 / 0.216e3 * t73 * t359;
  t363 = t28 * t362;
  t364 = t363 * t170;
  t372 = t83 * t351 / 0.24e2 + t89 * t355 / 0.288e3 + 0.5e1 / 0.216e3 * t95 * t359;
  t373 = t303 * t372;
  t374 = t156 * t373;
  t378 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t364 + 0.3e1 / 0.8e1 * t114 * t374);
  tvsigma2 = t7 * t378;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t380 = t29 * t34;
  t383 = params->b2t * tau[0];
  t386 = t326 * t76;
  t389 = 0.5e1 / 0.9e1 * params->bt * t46 * t380 + 0.5e2 / 0.81e2 * t383 * t70 + 0.5e1 / 0.216e3 * t73 * t386;
  t390 = t28 * t389;
  t391 = t390 * t100;
  t396 = params->b2b * tau[0];
  t401 = 0.5e1 / 0.9e1 * params->bb * t46 * t380 + 0.5e2 / 0.81e2 * t396 * t70 + 0.5e1 / 0.216e3 * t95 * t386;
  t402 = t221 * t401;
  t403 = t82 * t402;
  t407 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t391 + 0.3e1 / 0.8e1 * t27 * t403);
  tvtau0 = t7 * t407;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t411 = params->b2t * tau[1];
  t414 = t354 * t150;
  t417 = 0.5e1 / 0.9e1 * params->bt * t126 * t380 + 0.5e2 / 0.81e2 * t411 * t146 + 0.5e1 / 0.216e3 * t73 * t414;
  t418 = t28 * t417;
  t419 = t418 * t170;
  t424 = params->b2b * tau[1];
  t429 = 0.5e1 / 0.9e1 * params->bb * t126 * t380 + 0.5e2 / 0.81e2 * t424 * t146 + 0.5e1 / 0.216e3 * t95 * t414;
  t430 = t303 * t429;
  t431 = t156 * t430;
  t435 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t419 + 0.3e1 / 0.8e1 * t114 * t431);
  tvtau1 = t7 * t435;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t40, t41;
  double t44, t46, t48, t51, t52, t54, t55, t56;
  double t57, t58, t60, t61, t64, t65, t66, t68;
  double t69, t70, t73, t74, t76, t78, t81, t82;
  double t83, t86, t89, t92, t95, t96, t99, t100;
  double t101, t104, t105, t106, t108, t109, t110, t111;
  double t113, t114, t115, t116, t117, t118, t120, t121;
  double t124, t126, t128, t131, t132, t133, t134, t136;
  double t137, t140, t141, t142, t144, t145, t146, t150;
  double t152, t155, t156, t159, t164, t169, t170, t171;
  double t174, tzk0;

  double t175, t176, t177, t179, t182, t183, t186, t187;
  double t188, t189, t191, t193, t194, t198, t201, t203;
  double t204, t208, t212, t215, t216, t217, t220, t221;
  double t232, t233, t234, t238, t239, t241, t244, t245;
  double t248, t249, t251, t253, tvrho0, t257, t260, t261;
  double t265, t267, t270, t271, t275, t276, t280, t283;
  double t285, t286, t290, t294, t297, t298, t299, t302;
  double t303, t314, t315, t316, t320, tvrho1, t323, t326;
  double t327, t330, t331, t334, t335, t336, t344, t345;
  double t346, t350, tvsigma0, tvsigma1, t351, t354, t355, t358;
  double t359, t362, t363, t364, t372, t373, t374, t378;
  double tvsigma2, tvlapl0, tvlapl1, t380, t383, t386, t389, t390;
  double t391, t396, t401, t402, t403, t407, tvtau0, t411;
  double t414, t417, t418, t419, t424, t429, t430, t431;
  double t435, tvtau1;

  double t438, t439, t440, t443, t444, t445, t448, t452;
  double t453, t456, t463, t464, t465, t467, t468, t469;
  double t470, t472, t473, t476, t477, t481, t484, t486;
  double t487, t491, t495, t498, t499, t500, t503, t507;
  double t508, t509, t510, t523, t524, t525, t528, t529;
  double t530, t531, t532, t535, t538, t542, t543, t546;
  double t548, t549, t551, t553, tv2rho20, t556, t560, t564;
  double t565, t568, t578, t579, t583, t587, t588, t591;
  double t596, t597, t598, t602, t603, t606, tv2rho21, t611;
  double t616, t620, t621, t626, t627, t632, t636, t637;
  double t648, t649, t653, t656, t658, t659, t663, t667;
  double t670, t671, t672, t675, t679, t680, t681, t682;
  double t695, t696, t697, t700, t701, tv2rho22, t706, t707;
  double t709, t710, t713, t716, t717, t720, t721, t722;
  double t725, t730, t732, t733, t736, t737, t738, t739;
  double t740, t749, t750, t751, t755, tv2rhosigma0, tv2rhosigma1, t759;
  double t760, t762, t765, t767, t769, tv2rhosigma2, t776, tv2rhosigma3;
  double tv2rhosigma4, t780, t783, t786, t787, t790, t791, t792;
  double t795, t800, t803, t804, t805, t806, t807, t816;
  double t817, t818, t822, tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3;
  double t826, t827, t829, t837, t838, t839, t842, t847;
  double t849, t850, t853, t854, t864, t865, t866, t870;
  double tv2rhotau0, t874, t875, t877, t880, t882, t884, tv2rhotau1;
  double t891, tv2rhotau2, t902, t903, t904, t907, t912, t915;
  double t916, t926, t927, t928, t932, tv2rhotau3, t934, t935;
  double t938, t941, t942, t943, t947, t948, t949, t953;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t954, t955, t958;
  double t961, t962, t963, t967, t968, t969, t973, tv2sigma25;
  double tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t975, t978;
  double t981, t984, t985, t988, t989, t993, tv2sigmatau0, tv2sigmatau1;
  double tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t995, t998, t1001, t1004, t1005;
  double t1008, t1009, t1013, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, tv2lapltau3, t1015, t1016, t1017, t1020, t1023;
  double t1024, t1025, t1028, t1029, t1033, tv2tau20, tv2tau21, t1035;
  double t1036, t1039, t1042, t1043, t1044, t1047, t1048, t1052;
  double tv2tau22;

  mgga_x_ktbm_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ktbm_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = t6 * t26;
  t28 = POW_1_3(t7);
  t29 = M_CBRT6;
  t30 = params->at * t29;
  t31 = M_PI * M_PI;
  t32 = POW_1_3(t31);
  t33 = t32 * t32;
  t34 = 0.1e1 / t33;
  t35 = t34 * sigma[0];
  t36 = rho[0] * rho[0];
  t37 = POW_1_3(rho[0]);
  t38 = t37 * t37;
  t40 = 0.1e1 / t38 / t36;
  t41 = t35 * t40;
  t44 = params->bt * tau[0];
  t46 = 0.1e1 / t38 / rho[0];
  t48 = t46 * t29 * t34;
  t51 = t29 * t29;
  t52 = params->a2t * t51;
  t54 = 0.1e1 / t32 / t31;
  t55 = sigma[0] * sigma[0];
  t56 = t54 * t55;
  t57 = t36 * t36;
  t58 = t57 * rho[0];
  t60 = 0.1e1 / t37 / t58;
  t61 = t56 * t60;
  t64 = tau[0] * tau[0];
  t65 = params->b2t * t64;
  t66 = t36 * rho[0];
  t68 = 0.1e1 / t37 / t66;
  t69 = t68 * t51;
  t70 = t69 * t54;
  t73 = params->xt * t51;
  t74 = t73 * t54;
  t76 = 0.1e1 / t37 / t57;
  t78 = sigma[0] * t76 * tau[0];
  t81 = params->ct + t30 * t41 / 0.24e2 + 0.5e1 / 0.9e1 * t44 * t48 + t52 * t61 / 0.576e3 + 0.25e2 / 0.81e2 * t65 * t70 + 0.5e1 / 0.216e3 * t74 * t78;
  t82 = t28 * t81;
  t83 = params->ab * t29;
  t86 = params->bb * tau[0];
  t89 = params->a2b * t51;
  t92 = params->b2b * t64;
  t95 = params->xb * t51;
  t96 = t95 * t54;
  t99 = params->cb + t83 * t41 / 0.24e2 + 0.5e1 / 0.9e1 * t86 * t48 + t89 * t61 / 0.576e3 + 0.25e2 / 0.81e2 * t92 * t70 + 0.5e1 / 0.216e3 * t96 * t78;
  t100 = 0.1e1 / t99;
  t101 = t82 * t100;
  t104 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t101);
  t105 = rho[1] <= p->dens_threshold;
  t106 = -t17;
  t108 = my_piecewise5(t15, t12, t11, t16, t106 * t8);
  t109 = 0.1e1 + t108;
  t110 = t109 <= p->zeta_threshold;
  t111 = POW_1_3(t109);
  t113 = my_piecewise3(t110, t23, t111 * t109);
  t114 = t6 * t113;
  t115 = t34 * sigma[2];
  t116 = rho[1] * rho[1];
  t117 = POW_1_3(rho[1]);
  t118 = t117 * t117;
  t120 = 0.1e1 / t118 / t116;
  t121 = t115 * t120;
  t124 = params->bt * tau[1];
  t126 = 0.1e1 / t118 / rho[1];
  t128 = t126 * t29 * t34;
  t131 = sigma[2] * sigma[2];
  t132 = t54 * t131;
  t133 = t116 * t116;
  t134 = t133 * rho[1];
  t136 = 0.1e1 / t117 / t134;
  t137 = t132 * t136;
  t140 = tau[1] * tau[1];
  t141 = params->b2t * t140;
  t142 = t116 * rho[1];
  t144 = 0.1e1 / t117 / t142;
  t145 = t144 * t51;
  t146 = t145 * t54;
  t150 = 0.1e1 / t117 / t133;
  t152 = sigma[2] * t150 * tau[1];
  t155 = params->ct + t30 * t121 / 0.24e2 + 0.5e1 / 0.9e1 * t124 * t128 + t52 * t137 / 0.576e3 + 0.25e2 / 0.81e2 * t141 * t146 + 0.5e1 / 0.216e3 * t74 * t152;
  t156 = t28 * t155;
  t159 = params->bb * tau[1];
  t164 = params->b2b * t140;
  t169 = params->cb + t83 * t121 / 0.24e2 + 0.5e1 / 0.9e1 * t159 * t128 + t89 * t137 / 0.576e3 + 0.25e2 / 0.81e2 * t164 * t146 + 0.5e1 / 0.216e3 * t96 * t152;
  t170 = 0.1e1 / t169;
  t171 = t156 * t170;
  t174 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t171);
  tzk0 = t104 + t174;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t175 = t7 * t7;
  t176 = 0.1e1 / t175;
  t177 = t17 * t176;
  t179 = my_piecewise5(t11, 0, t15, 0, t8 - t177);
  t182 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t179);
  t183 = t6 * t182;
  t186 = t28 * t28;
  t187 = 0.1e1 / t186;
  t188 = t187 * t81;
  t189 = t188 * t100;
  t191 = t27 * t189 / 0.8e1;
  t193 = 0.1e1 / t38 / t66;
  t194 = t35 * t193;
  t198 = t40 * t29 * t34;
  t201 = t57 * t36;
  t203 = 0.1e1 / t37 / t201;
  t204 = t56 * t203;
  t208 = t76 * t51 * t54;
  t212 = sigma[0] * t60 * tau[0];
  t215 = -t30 * t194 / 0.9e1 - 0.25e2 / 0.27e2 * t44 * t198 - t52 * t204 / 0.108e3 - 0.25e3 / 0.243e3 * t65 * t208 - 0.65e2 / 0.648e3 * t74 * t212;
  t216 = t28 * t215;
  t217 = t216 * t100;
  t220 = t99 * t99;
  t221 = 0.1e1 / t220;
  t232 = -t83 * t194 / 0.9e1 - 0.25e2 / 0.27e2 * t86 * t198 - t89 * t204 / 0.108e3 - 0.25e3 / 0.243e3 * t92 * t208 - 0.65e2 / 0.648e3 * t96 * t212;
  t233 = t221 * t232;
  t234 = t82 * t233;
  t238 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t183 * t101 - t191 - 0.3e1 / 0.8e1 * t27 * t217 + 0.3e1 / 0.8e1 * t27 * t234);
  t239 = t106 * t176;
  t241 = my_piecewise5(t15, 0, t11, 0, -t8 - t239);
  t244 = my_piecewise3(t110, 0, 0.4e1 / 0.3e1 * t111 * t241);
  t245 = t6 * t244;
  t248 = t187 * t155;
  t249 = t248 * t170;
  t251 = t114 * t249 / 0.8e1;
  t253 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t245 * t171 - t251);
  tvrho0 = t104 + t174 + t7 * (t238 + t253);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t257 = my_piecewise5(t11, 0, t15, 0, -t8 - t177);
  t260 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t257);
  t261 = t6 * t260;
  t265 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t261 * t101 - t191);
  t267 = my_piecewise5(t15, 0, t11, 0, t8 - t239);
  t270 = my_piecewise3(t110, 0, 0.4e1 / 0.3e1 * t111 * t267);
  t271 = t6 * t270;
  t275 = 0.1e1 / t118 / t142;
  t276 = t115 * t275;
  t280 = t120 * t29 * t34;
  t283 = t133 * t116;
  t285 = 0.1e1 / t117 / t283;
  t286 = t132 * t285;
  t290 = t150 * t51 * t54;
  t294 = sigma[2] * t136 * tau[1];
  t297 = -t30 * t276 / 0.9e1 - 0.25e2 / 0.27e2 * t124 * t280 - t52 * t286 / 0.108e3 - 0.25e3 / 0.243e3 * t141 * t290 - 0.65e2 / 0.648e3 * t74 * t294;
  t298 = t28 * t297;
  t299 = t298 * t170;
  t302 = t169 * t169;
  t303 = 0.1e1 / t302;
  t314 = -t83 * t276 / 0.9e1 - 0.25e2 / 0.27e2 * t159 * t280 - t89 * t286 / 0.108e3 - 0.25e3 / 0.243e3 * t164 * t290 - 0.65e2 / 0.648e3 * t96 * t294;
  t315 = t303 * t314;
  t316 = t156 * t315;
  t320 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t271 * t171 - t251 - 0.3e1 / 0.8e1 * t114 * t299 + 0.3e1 / 0.8e1 * t114 * t316);
  tvrho1 = t104 + t174 + t7 * (t265 + t320);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t323 = t34 * t40;
  t326 = t54 * sigma[0];
  t327 = t326 * t60;
  t330 = t54 * t76;
  t331 = t330 * tau[0];
  t334 = t30 * t323 / 0.24e2 + t52 * t327 / 0.288e3 + 0.5e1 / 0.216e3 * t73 * t331;
  t335 = t28 * t334;
  t336 = t335 * t100;
  t344 = t83 * t323 / 0.24e2 + t89 * t327 / 0.288e3 + 0.5e1 / 0.216e3 * t95 * t331;
  t345 = t221 * t344;
  t346 = t82 * t345;
  t350 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t336 + 0.3e1 / 0.8e1 * t27 * t346);
  tvsigma0 = t7 * t350;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t351 = t34 * t120;
  t354 = t54 * sigma[2];
  t355 = t354 * t136;
  t358 = t54 * t150;
  t359 = t358 * tau[1];
  t362 = t30 * t351 / 0.24e2 + t52 * t355 / 0.288e3 + 0.5e1 / 0.216e3 * t73 * t359;
  t363 = t28 * t362;
  t364 = t363 * t170;
  t372 = t83 * t351 / 0.24e2 + t89 * t355 / 0.288e3 + 0.5e1 / 0.216e3 * t95 * t359;
  t373 = t303 * t372;
  t374 = t156 * t373;
  t378 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t364 + 0.3e1 / 0.8e1 * t114 * t374);
  tvsigma2 = t7 * t378;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t380 = t29 * t34;
  t383 = params->b2t * tau[0];
  t386 = t326 * t76;
  t389 = 0.5e1 / 0.9e1 * params->bt * t46 * t380 + 0.5e2 / 0.81e2 * t383 * t70 + 0.5e1 / 0.216e3 * t73 * t386;
  t390 = t28 * t389;
  t391 = t390 * t100;
  t396 = params->b2b * tau[0];
  t401 = 0.5e1 / 0.9e1 * params->bb * t46 * t380 + 0.5e2 / 0.81e2 * t396 * t70 + 0.5e1 / 0.216e3 * t95 * t386;
  t402 = t221 * t401;
  t403 = t82 * t402;
  t407 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t391 + 0.3e1 / 0.8e1 * t27 * t403);
  tvtau0 = t7 * t407;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t411 = params->b2t * tau[1];
  t414 = t354 * t150;
  t417 = 0.5e1 / 0.9e1 * params->bt * t126 * t380 + 0.5e2 / 0.81e2 * t411 * t146 + 0.5e1 / 0.216e3 * t73 * t414;
  t418 = t28 * t417;
  t419 = t418 * t170;
  t424 = params->b2b * tau[1];
  t429 = 0.5e1 / 0.9e1 * params->bb * t126 * t380 + 0.5e2 / 0.81e2 * t424 * t146 + 0.5e1 / 0.216e3 * t95 * t414;
  t430 = t303 * t429;
  t431 = t156 * t430;
  t435 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t419 + 0.3e1 / 0.8e1 * t114 * t431);
  tvtau1 = t7 * t435;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t438 = t24 * t24;
  t439 = 0.1e1 / t438;
  t440 = t179 * t179;
  t443 = t175 * t7;
  t444 = 0.1e1 / t443;
  t445 = t17 * t444;
  t448 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t176 + 0.2e1 * t445);
  t452 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t439 * t440 + 0.4e1 / 0.3e1 * t24 * t448);
  t453 = t6 * t452;
  t456 = t183 * t189;
  t463 = 0.1e1 / t186 / t7;
  t464 = t463 * t81;
  t465 = t464 * t100;
  t467 = t27 * t465 / 0.12e2;
  t468 = t187 * t215;
  t469 = t468 * t100;
  t470 = t27 * t469;
  t472 = t188 * t233;
  t473 = t27 * t472;
  t476 = 0.1e1 / t38 / t57;
  t477 = t35 * t476;
  t481 = t193 * t29 * t34;
  t484 = t57 * t66;
  t486 = 0.1e1 / t37 / t484;
  t487 = t56 * t486;
  t491 = t60 * t51 * t54;
  t495 = sigma[0] * t203 * tau[0];
  t498 = 0.11e2 / 0.27e2 * t30 * t477 + 0.2e3 / 0.81e2 * t44 * t481 + 0.19e2 / 0.324e3 * t52 * t487 + 0.325e4 / 0.729e3 * t65 * t491 + 0.13e3 / 0.243e3 * t74 * t495;
  t499 = t28 * t498;
  t500 = t499 * t100;
  t503 = t216 * t233;
  t507 = 0.1e1 / t220 / t99;
  t508 = t232 * t232;
  t509 = t507 * t508;
  t510 = t82 * t509;
  t523 = 0.11e2 / 0.27e2 * t83 * t477 + 0.2e3 / 0.81e2 * t86 * t481 + 0.19e2 / 0.324e3 * t89 * t487 + 0.325e4 / 0.729e3 * t92 * t491 + 0.13e3 / 0.243e3 * t96 * t495;
  t524 = t221 * t523;
  t525 = t82 * t524;
  t528 = -0.3e1 / 0.8e1 * t453 * t101 - t456 / 0.4e1 - 0.3e1 / 0.4e1 * t183 * t217 + 0.3e1 / 0.4e1 * t183 * t234 + t467 - t470 / 0.4e1 + t473 / 0.4e1 - 0.3e1 / 0.8e1 * t27 * t500 + 0.3e1 / 0.4e1 * t27 * t503 - 0.3e1 / 0.4e1 * t27 * t510 + 0.3e1 / 0.8e1 * t27 * t525;
  t529 = my_piecewise3(t2, 0, t528);
  t530 = t111 * t111;
  t531 = 0.1e1 / t530;
  t532 = t241 * t241;
  t535 = t106 * t444;
  t538 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t176 + 0.2e1 * t535);
  t542 = my_piecewise3(t110, 0, 0.4e1 / 0.9e1 * t531 * t532 + 0.4e1 / 0.3e1 * t111 * t538);
  t543 = t6 * t542;
  t546 = t245 * t249;
  t548 = t463 * t155;
  t549 = t548 * t170;
  t551 = t114 * t549 / 0.12e2;
  t553 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t543 * t171 - t546 / 0.4e1 + t551);
  tv2rho20 = 0.2e1 * t238 + 0.2e1 * t253 + t7 * (t529 + t553);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t556 = t439 * t257;
  t560 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t445);
  t564 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t556 * t179 + 0.4e1 / 0.3e1 * t24 * t560);
  t565 = t6 * t564;
  t568 = t261 * t189;
  t578 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t565 * t101 - t568 / 0.8e1 - 0.3e1 / 0.8e1 * t261 * t217 + 0.3e1 / 0.8e1 * t261 * t234 - t456 / 0.8e1 + t467 - t470 / 0.8e1 + t473 / 0.8e1);
  t579 = t531 * t267;
  t583 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t535);
  t587 = my_piecewise3(t110, 0, 0.4e1 / 0.9e1 * t579 * t241 + 0.4e1 / 0.3e1 * t111 * t583);
  t588 = t6 * t587;
  t591 = t271 * t249;
  t596 = t187 * t297;
  t597 = t596 * t170;
  t598 = t114 * t597;
  t602 = t248 * t315;
  t603 = t114 * t602;
  t606 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t588 * t171 - t591 / 0.8e1 - t546 / 0.8e1 + t551 - 0.3e1 / 0.8e1 * t245 * t299 - t598 / 0.8e1 + 0.3e1 / 0.8e1 * t245 * t316 + t603 / 0.8e1);
  tv2rho21 = t238 + t253 + t265 + t320 + t7 * (t578 + t606);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t611 = t257 * t257;
  t616 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t176 + 0.2e1 * t445);
  t620 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t439 * t611 + 0.4e1 / 0.3e1 * t24 * t616);
  t621 = t6 * t620;
  t626 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t621 * t101 - t568 / 0.4e1 + t467);
  t627 = t267 * t267;
  t632 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t176 + 0.2e1 * t535);
  t636 = my_piecewise3(t110, 0, 0.4e1 / 0.9e1 * t531 * t627 + 0.4e1 / 0.3e1 * t111 * t632);
  t637 = t6 * t636;
  t648 = 0.1e1 / t118 / t133;
  t649 = t115 * t648;
  t653 = t275 * t29 * t34;
  t656 = t133 * t142;
  t658 = 0.1e1 / t117 / t656;
  t659 = t132 * t658;
  t663 = t136 * t51 * t54;
  t667 = sigma[2] * t285 * tau[1];
  t670 = 0.11e2 / 0.27e2 * t30 * t649 + 0.2e3 / 0.81e2 * t124 * t653 + 0.19e2 / 0.324e3 * t52 * t659 + 0.325e4 / 0.729e3 * t141 * t663 + 0.13e3 / 0.243e3 * t74 * t667;
  t671 = t28 * t670;
  t672 = t671 * t170;
  t675 = t298 * t315;
  t679 = 0.1e1 / t302 / t169;
  t680 = t314 * t314;
  t681 = t679 * t680;
  t682 = t156 * t681;
  t695 = 0.11e2 / 0.27e2 * t83 * t649 + 0.2e3 / 0.81e2 * t159 * t653 + 0.19e2 / 0.324e3 * t89 * t659 + 0.325e4 / 0.729e3 * t164 * t663 + 0.13e3 / 0.243e3 * t96 * t667;
  t696 = t303 * t695;
  t697 = t156 * t696;
  t700 = -0.3e1 / 0.8e1 * t637 * t171 - t591 / 0.4e1 - 0.3e1 / 0.4e1 * t271 * t299 + 0.3e1 / 0.4e1 * t271 * t316 + t551 - t598 / 0.4e1 + t603 / 0.4e1 - 0.3e1 / 0.8e1 * t114 * t672 + 0.3e1 / 0.4e1 * t114 * t675 - 0.3e1 / 0.4e1 * t114 * t682 + 0.3e1 / 0.8e1 * t114 * t697;
  t701 = my_piecewise3(t105, 0, t700);
  tv2rho22 = 0.2e1 * t265 + 0.2e1 * t320 + t7 * (t626 + t701);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t706 = t187 * t334;
  t707 = t706 * t100;
  t709 = t27 * t707 / 0.8e1;
  t710 = t34 * t193;
  t713 = t326 * t203;
  t716 = t54 * t60;
  t717 = t716 * tau[0];
  t720 = -t30 * t710 / 0.9e1 - t52 * t713 / 0.54e2 - 0.65e2 / 0.648e3 * t73 * t717;
  t721 = t28 * t720;
  t722 = t721 * t100;
  t725 = t335 * t233;
  t730 = t188 * t345;
  t732 = t27 * t730 / 0.8e1;
  t733 = t216 * t345;
  t736 = t26 * t28;
  t737 = t6 * t736;
  t738 = t81 * t507;
  t739 = t344 * t232;
  t740 = t738 * t739;
  t749 = -t83 * t710 / 0.9e1 - t89 * t713 / 0.54e2 - 0.65e2 / 0.648e3 * t95 * t717;
  t750 = t221 * t749;
  t751 = t82 * t750;
  t755 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t183 * t336 - t709 - 0.3e1 / 0.8e1 * t27 * t722 + 0.3e1 / 0.8e1 * t27 * t725 + 0.3e1 / 0.8e1 * t183 * t346 + t732 + 0.3e1 / 0.8e1 * t27 * t733 - 0.3e1 / 0.4e1 * t737 * t740 + 0.3e1 / 0.8e1 * t27 * t751);
  tv2rhosigma0 = t7 * t755 + t350;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t759 = t187 * t362;
  t760 = t759 * t170;
  t762 = t114 * t760 / 0.8e1;
  t765 = t248 * t373;
  t767 = t114 * t765 / 0.8e1;
  t769 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t245 * t364 - t762 + 0.3e1 / 0.8e1 * t245 * t374 + t767);
  tv2rhosigma2 = t7 * t769 + t378;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t776 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t261 * t336 - t709 + 0.3e1 / 0.8e1 * t261 * t346 + t732);
  tv2rhosigma3 = t7 * t776 + t350;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t780 = t34 * t275;
  t783 = t354 * t285;
  t786 = t54 * t136;
  t787 = t786 * tau[1];
  t790 = -t30 * t780 / 0.9e1 - t52 * t783 / 0.54e2 - 0.65e2 / 0.648e3 * t73 * t787;
  t791 = t28 * t790;
  t792 = t791 * t170;
  t795 = t363 * t315;
  t800 = t298 * t373;
  t803 = t113 * t28;
  t804 = t6 * t803;
  t805 = t155 * t679;
  t806 = t372 * t314;
  t807 = t805 * t806;
  t816 = -t83 * t780 / 0.9e1 - t89 * t783 / 0.54e2 - 0.65e2 / 0.648e3 * t95 * t787;
  t817 = t303 * t816;
  t818 = t156 * t817;
  t822 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t271 * t364 - t762 - 0.3e1 / 0.8e1 * t114 * t792 + 0.3e1 / 0.8e1 * t114 * t795 + 0.3e1 / 0.8e1 * t271 * t374 + t767 + 0.3e1 / 0.8e1 * t114 * t800 - 0.3e1 / 0.4e1 * t804 * t807 + 0.3e1 / 0.8e1 * t114 * t818);
  tv2rhosigma5 = t7 * t822 + t378;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t826 = t187 * t389;
  t827 = t826 * t100;
  t829 = t27 * t827 / 0.8e1;
  t837 = -0.25e2 / 0.27e2 * params->bt * t40 * t380 - 0.5e3 / 0.243e3 * t383 * t208 - 0.65e2 / 0.648e3 * t73 * t327;
  t838 = t28 * t837;
  t839 = t838 * t100;
  t842 = t390 * t233;
  t847 = t188 * t402;
  t849 = t27 * t847 / 0.8e1;
  t850 = t216 * t402;
  t853 = t401 * t232;
  t854 = t738 * t853;
  t864 = -0.25e2 / 0.27e2 * params->bb * t40 * t380 - 0.5e3 / 0.243e3 * t396 * t208 - 0.65e2 / 0.648e3 * t95 * t327;
  t865 = t221 * t864;
  t866 = t82 * t865;
  t870 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t183 * t391 - t829 - 0.3e1 / 0.8e1 * t27 * t839 + 0.3e1 / 0.8e1 * t27 * t842 + 0.3e1 / 0.8e1 * t183 * t403 + t849 + 0.3e1 / 0.8e1 * t27 * t850 - 0.3e1 / 0.4e1 * t737 * t854 + 0.3e1 / 0.8e1 * t27 * t866);
  tv2rhotau0 = t7 * t870 + t407;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t874 = t187 * t417;
  t875 = t874 * t170;
  t877 = t114 * t875 / 0.8e1;
  t880 = t248 * t430;
  t882 = t114 * t880 / 0.8e1;
  t884 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t245 * t419 - t877 + 0.3e1 / 0.8e1 * t245 * t431 + t882);
  tv2rhotau1 = t7 * t884 + t435;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t891 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t261 * t391 - t829 + 0.3e1 / 0.8e1 * t261 * t403 + t849);
  tv2rhotau2 = t7 * t891 + t407;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t902 = -0.25e2 / 0.27e2 * params->bt * t120 * t380 - 0.5e3 / 0.243e3 * t411 * t290 - 0.65e2 / 0.648e3 * t73 * t355;
  t903 = t28 * t902;
  t904 = t903 * t170;
  t907 = t418 * t315;
  t912 = t298 * t430;
  t915 = t429 * t314;
  t916 = t805 * t915;
  t926 = -0.25e2 / 0.27e2 * params->bb * t120 * t380 - 0.5e3 / 0.243e3 * t424 * t290 - 0.65e2 / 0.648e3 * t95 * t355;
  t927 = t303 * t926;
  t928 = t156 * t927;
  t932 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t271 * t419 - t877 - 0.3e1 / 0.8e1 * t114 * t904 + 0.3e1 / 0.8e1 * t114 * t907 + 0.3e1 / 0.8e1 * t271 * t431 + t882 + 0.3e1 / 0.8e1 * t114 * t912 - 0.3e1 / 0.4e1 * t804 * t916 + 0.3e1 / 0.8e1 * t114 * t928);
  tv2rhotau3 = t7 * t932 + t435;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t934 = t716 * t100;
  t935 = t52 * t934;
  t938 = t335 * t345;
  t941 = t344 * t344;
  t942 = t507 * t941;
  t943 = t82 * t942;
  t947 = t6 * t736 * t81;
  t948 = t221 * params->a2b;
  t949 = t948 * t491;
  t953 = my_piecewise3(t2, 0, -t737 * t935 / 0.768e3 + 0.3e1 / 0.4e1 * t27 * t938 - 0.3e1 / 0.4e1 * t27 * t943 + t947 * t949 / 0.768e3);
  tv2sigma20 = t7 * t953;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t954 = t786 * t170;
  t955 = t52 * t954;
  t958 = t363 * t373;
  t961 = t372 * t372;
  t962 = t679 * t961;
  t963 = t156 * t962;
  t967 = t6 * t803 * t155;
  t968 = t303 * params->a2b;
  t969 = t968 * t663;
  t973 = my_piecewise3(t105, 0, -t804 * t955 / 0.768e3 + 0.3e1 / 0.4e1 * t114 * t958 - 0.3e1 / 0.4e1 * t114 * t963 + t967 * t969 / 0.768e3);
  tv2sigma25 = t7 * t973;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t975 = t73 * t330 * t100;
  t978 = t390 * t345;
  t981 = t335 * t402;
  t984 = t401 * t344;
  t985 = t738 * t984;
  t988 = t221 * params->xb;
  t989 = t988 * t208;
  t993 = my_piecewise3(t2, 0, -0.5e1 / 0.576e3 * t737 * t975 + 0.3e1 / 0.8e1 * t27 * t978 + 0.3e1 / 0.8e1 * t27 * t981 - 0.3e1 / 0.4e1 * t737 * t985 + 0.5e1 / 0.576e3 * t947 * t989);
  tv2sigmatau0 = t7 * t993;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t995 = t73 * t358 * t170;
  t998 = t418 * t373;
  t1001 = t363 * t430;
  t1004 = t429 * t372;
  t1005 = t805 * t1004;
  t1008 = t303 * params->xb;
  t1009 = t1008 * t290;
  t1013 = my_piecewise3(t105, 0, -0.5e1 / 0.576e3 * t804 * t995 + 0.3e1 / 0.8e1 * t114 * t998 + 0.3e1 / 0.8e1 * t114 * t1001 - 0.3e1 / 0.4e1 * t804 * t1005 + 0.5e1 / 0.576e3 * t967 * t1009);
  tv2sigmatau5 = t7 * t1013;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1015 = t51 * t54;
  t1016 = t1015 * t100;
  t1017 = params->b2t * t68 * t1016;
  t1020 = t390 * t402;
  t1023 = t401 * t401;
  t1024 = t507 * t1023;
  t1025 = t82 * t1024;
  t1028 = t221 * params->b2b;
  t1029 = t1028 * t70;
  t1033 = my_piecewise3(t2, 0, -0.25e2 / 0.108e3 * t737 * t1017 + 0.3e1 / 0.4e1 * t27 * t1020 - 0.3e1 / 0.4e1 * t27 * t1025 + 0.25e2 / 0.108e3 * t947 * t1029);
  tv2tau20 = t7 * t1033;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1035 = t1015 * t170;
  t1036 = params->b2t * t144 * t1035;
  t1039 = t418 * t430;
  t1042 = t429 * t429;
  t1043 = t679 * t1042;
  t1044 = t156 * t1043;
  t1047 = t303 * params->b2b;
  t1048 = t1047 * t146;
  t1052 = my_piecewise3(t105, 0, -0.25e2 / 0.108e3 * t804 * t1036 + 0.3e1 / 0.4e1 * t114 * t1039 - 0.3e1 / 0.4e1 * t114 * t1044 + 0.25e2 / 0.108e3 * t967 * t1048);
  tv2tau22 = t7 * t1052;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t40, t41;
  double t44, t46, t48, t51, t52, t54, t55, t56;
  double t57, t58, t60, t61, t64, t65, t66, t68;
  double t69, t70, t73, t74, t76, t78, t81, t82;
  double t83, t86, t89, t92, t95, t96, t99, t100;
  double t101, t104, t105, t106, t108, t109, t110, t111;
  double t113, t114, t115, t116, t117, t118, t120, t121;
  double t124, t126, t128, t131, t132, t133, t134, t136;
  double t137, t140, t141, t142, t144, t145, t146, t150;
  double t152, t155, t156, t159, t164, t169, t170, t171;
  double t174, tzk0;

  double t175, t176, t177, t179, t182, t183, t186, t187;
  double t188, t189, t191, t193, t194, t198, t201, t203;
  double t204, t208, t212, t215, t216, t217, t220, t221;
  double t232, t233, t234, t238, t239, t241, t244, t245;
  double t248, t249, t251, t253, tvrho0, t257, t260, t261;
  double t265, t267, t270, t271, t275, t276, t280, t283;
  double t285, t286, t290, t294, t297, t298, t299, t302;
  double t303, t314, t315, t316, t320, tvrho1, t323, t326;
  double t327, t330, t331, t334, t335, t336, t344, t345;
  double t346, t350, tvsigma0, tvsigma1, t351, t354, t355, t358;
  double t359, t362, t363, t364, t372, t373, t374, t378;
  double tvsigma2, tvlapl0, tvlapl1, t380, t383, t386, t389, t390;
  double t391, t396, t401, t402, t403, t407, tvtau0, t411;
  double t414, t417, t418, t419, t424, t429, t430, t431;
  double t435, tvtau1;

  double t438, t439, t440, t443, t444, t445, t448, t452;
  double t453, t456, t463, t464, t465, t467, t468, t469;
  double t470, t472, t473, t476, t477, t481, t484, t486;
  double t487, t491, t495, t498, t499, t500, t503, t507;
  double t508, t509, t510, t523, t524, t525, t528, t529;
  double t530, t531, t532, t535, t538, t542, t543, t546;
  double t548, t549, t551, t553, tv2rho20, t556, t560, t564;
  double t565, t568, t578, t579, t583, t587, t588, t591;
  double t596, t597, t598, t602, t603, t606, tv2rho21, t611;
  double t616, t620, t621, t626, t627, t632, t636, t637;
  double t648, t649, t653, t656, t658, t659, t663, t667;
  double t670, t671, t672, t675, t679, t680, t681, t682;
  double t695, t696, t697, t700, t701, tv2rho22, t706, t707;
  double t709, t710, t713, t716, t717, t720, t721, t722;
  double t725, t730, t732, t733, t736, t737, t738, t739;
  double t740, t749, t750, t751, t755, tv2rhosigma0, tv2rhosigma1, t759;
  double t760, t762, t765, t767, t769, tv2rhosigma2, t776, tv2rhosigma3;
  double tv2rhosigma4, t780, t783, t786, t787, t790, t791, t792;
  double t795, t800, t803, t804, t805, t806, t807, t816;
  double t817, t818, t822, tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3;
  double t826, t827, t829, t837, t838, t839, t842, t847;
  double t849, t850, t853, t854, t864, t865, t866, t870;
  double tv2rhotau0, t874, t875, t877, t880, t882, t884, tv2rhotau1;
  double t891, tv2rhotau2, t902, t903, t904, t907, t912, t915;
  double t916, t926, t927, t928, t932, tv2rhotau3, t934, t935;
  double t938, t941, t942, t943, t947, t948, t949, t953;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t954, t955, t958;
  double t961, t962, t963, t967, t968, t969, t973, tv2sigma25;
  double tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t975, t978;
  double t981, t984, t985, t988, t989, t993, tv2sigmatau0, tv2sigmatau1;
  double tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t995, t998, t1001, t1004, t1005;
  double t1008, t1009, t1013, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, tv2lapltau3, t1015, t1016, t1017, t1020, t1023;
  double t1024, t1025, t1028, t1029, t1033, tv2tau20, tv2tau21, t1035;
  double t1036, t1039, t1042, t1043, t1044, t1047, t1048, t1052;
  double tv2tau22;

  double t1056, t1057, t1061, t1064, t1066, t1067, t1071, t1075;
  double t1078, t1079, t1080, t1085, t1086, t1087, t1089, t1090;
  double t1091, t1094, t1095, t1098, t1101, t1102, t1103, t1106;
  double t1110, t1111, t1116, t1119, t1120, t1121, t1123, t1124;
  double t1126, t1130, t1131, t1133, t1134, t1141, t1142, t1144;
  double t1145, t1147, t1148, t1150, t1151, t1152, t1153, t1154;
  double t1157, t1160, t1173, t1174, t1175, t1180, t1182, t1183;
  double t1186, t1188, t1190, t1191, t1194, t1197, t1200, t1204;
  double t1205, t1208, t1210, t1212, t1213, t1215, t1217, tv3rho30;
  double t1220, t1221, t1223, t1226, t1229, t1238, t1245, t1248;
  double t1251, t1256, t1257, t1259, t1263, t1264, t1272, t1274;
  double t1275, t1278, t1283, t1285, t1289, t1290, t1294, t1295;
  double t1302, t1303, t1304, t1305, t1310, t1311, t1312, t1314;
  double t1315, tv3rho31, t1318, t1323, t1327, t1331, t1332, t1335;
  double t1345, t1346, t1347, t1352, t1356, t1360, t1361, t1364;
  double t1369, t1373, t1376, t1381, t1382, t1383, t1387, t1388;
  double t1392, t1393, t1397, t1398, t1400, t1402, tv3rho32, t1407;
  double t1414, t1418, t1419, t1425, t1431, t1432, t1433, t1434;
  double t1435, t1440, t1443, t1447, t1448, t1452, t1455, t1457;
  double t1458, t1462, t1466, t1469, t1470, t1471, t1476, t1481;
  double t1489, t1490, t1507, t1508, t1509, t1512, t1519, t1523;
  double t1524, t1527, t1529, tv3rho33, t1533, t1536, t1539, t1541;
  double t1543, t1544, t1545, t1547, t1550, t1559, t1560, t1562;
  double t1563, t1565, t1568, t1569, t1572, t1575, t1576, t1579;
  double t1580, t1581, t1586, t1588, t1589, t1591, t1594, t1595;
  double t1596, t1604, t1605, t1606, t1611, t1612, t1615, t1616;
  double t1617, t1619, t1620, t1623, t1624, t1627, t1628, t1631;
  double t1632, t1633, t1636, t1638, tv3rho2sigma0, tv3rho2sigma1, t1643, t1645;
  double t1646, t1648, t1651, t1653, t1655, t1657, tv3rho2sigma2, t1661;
  double t1672, t1676, t1677, t1686, t1687, tv3rho2sigma3, tv3rho2sigma4, t1691;
  double t1696, t1697, t1698, t1702, t1703, t1707, t1712, t1713;
  double t1715, t1716, t1719, t1720, t1721, t1725, t1726, t1728;
  double t1729, tv3rho2sigma5, t1739, tv3rho2sigma6, tv3rho2sigma7, t1746, t1749, t1752;
  double t1753, t1756, t1757, t1758, t1763, t1772, t1775, t1784;
  double t1785, t1786, t1789, t1792, t1795, t1802, t1803, t1804;
  double t1808, t1809, t1812, t1813, t1816, t1817, t1820, t1821;
  double t1824, t1826, tv3rho2sigma8, tv3rho2lapl0, tv3rho2lapl1, tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4;
  double tv3rho2lapl5, t1836, t1837, t1838, t1845, t1846, t1847, t1849;
  double t1850, t1852, t1853, t1857, t1858, t1860, t1861, t1863;
  double t1866, t1869, t1872, t1874, t1875, t1877, t1880, t1881;
  double t1883, t1886, t1900, t1901, t1902, t1905, t1906, t1911;
  double t1913, t1916, t1917, t1920, t1921, t1924, t1926, tv3rho2tau0;
  double t1931, t1933, t1934, t1936, t1939, t1941, t1943, t1945;
  double tv3rho2tau1, t1949, t1960, t1972, t1973, tv3rho2tau2, t1977, t1982;
  double t1983, t1984, t1988, t1989, t1993, t1998, t1999, t2003;
  double t2007, t2008, t2010, t2011, tv3rho2tau3, t2021, tv3rho2tau4, t2031;
  double t2032, t2033, t2042, t2052, t2053, t2054, t2057, t2062;
  double t2065, t2070, t2075, t2082, t2083, t2086, t2089, t2090;
  double t2093, t2094, t2100, t2102, tv3rho2tau5, t2107, t2108, t2109;
  double t2113, t2114, t2116, t2121, t2123, t2124, t2127, t2128;
  double t2131, t2136, t2138, t2139, t2142, t2143, t2146, t2147;
  double t2151, t2155, t2157, t2159, t2163, t2164, t2165, t2168;
  double t2171, t2172, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t2177;
  double t2180, t2182, t2185, t2187, t2189, t2193, t2195, t2197;
  double tv3rhosigma25, t2206, t2210, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210;
  double t2214, t2215, t2219, t2220, t2222, t2227, t2230, t2231;
  double t2234, t2239, t2242, t2243, t2246, t2247, t2251, t2255;
  double t2259, t2260, t2261, t2264, t2267, t2268, tv3rhosigma211, tv3rhosigmalapl0;
  double tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8;
  double tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t2271, t2272, t2277, t2278, t2281;
  double t2283, t2286, t2289, t2294, t2297, t2300, t2302, t2303;
  double t2305, t2306, t2308, t2316, t2317, t2320, t2321, t2324;
  double t2329, t2332, t2333, t2336, t2337, t2341, t2342, t2343;
  double t2344, t2345, t2348, t2350, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3;
  double tv3rhosigmatau4, t2355, t2358, t2360, t2363, t2365, t2369, t2373;
  double t2375, tv3rhosigmatau5, t2388, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10;
  double t2390, t2395, t2396, t2401, t2404, t2409, t2412, t2415;
  double t2417, t2418, t2420, t2427, t2430, t2433, t2434, t2437;
  double t2438, t2441, t2442, t2445, t2450, t2451, t2452, t2453;
  double t2456, t2458, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22, tv3rholapl23, tv3rholapl24;
  double tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6;
  double tv3rholapltau7, t2463, t2465, t2469, t2470, t2472, t2477, t2479;
  double t2480, t2483, t2486, t2491, t2493, t2494, t2497, t2498;
  double t2501, t2502, t2508, t2511, t2512, t2513, t2514, t2517;
  double t2520, t2521, tv3rhotau20, tv3rhotau21, t2526, t2529, t2531, t2534;
  double t2536, t2540, t2542, tv3rhotau22, t2553, tv3rhotau23, tv3rhotau24, t2558;
  double t2562, t2563, t2565, t2570, t2573, t2576, t2581, t2584;
  double t2585, t2588, t2589, t2596, t2597, t2598, t2599, t2602;
  double t2605, t2606, tv3rhotau25, t2609, t2612, t2616, t2619, t2620;
  double t2621, t2624, t2625, t2626, t2630, tv3sigma30, tv3sigma31, tv3sigma32;
  double tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t2632, t2635;
  double t2639, t2642, t2643, t2644, t2647, t2648, t2649, t2653;
  double tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6;
  double tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11, t2655, t2658, t2662;
  double t2666, t2669, t2674, t2675, t2679, t2682, t2683, t2684;
  double t2688, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6;
  double tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, t2690, t2693, t2697, t2701;
  double t2704, t2709, t2710, t2714, t2717, t2718, t2719, t2723;
  double tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26;
  double tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5;
  double tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, t2725, t2729;
  double t2732, t2737, t2740, t2741, t2744, t2745, t2750, t2751;
  double t2755, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26;
  double tv3sigmatau27, t2757, t2761, t2764, t2769, t2772, t2773, t2776;
  double t2777, t2782, t2783, t2787, tv3sigmatau28, tv3lapl30, tv3lapl31, tv3lapl32;
  double tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20;
  double tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, t2789, t2792, t2797;
  double t2798, t2799, t2802, t2803, t2807, tv3tau30, tv3tau31, tv3tau32;
  double t2809, t2812, t2817, t2818, t2819, t2822, t2823, t2827;
  double tv3tau33;

  mgga_x_ktbm_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ktbm_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = t6 * t26;
  t28 = POW_1_3(t7);
  t29 = M_CBRT6;
  t30 = params->at * t29;
  t31 = M_PI * M_PI;
  t32 = POW_1_3(t31);
  t33 = t32 * t32;
  t34 = 0.1e1 / t33;
  t35 = t34 * sigma[0];
  t36 = rho[0] * rho[0];
  t37 = POW_1_3(rho[0]);
  t38 = t37 * t37;
  t40 = 0.1e1 / t38 / t36;
  t41 = t35 * t40;
  t44 = params->bt * tau[0];
  t46 = 0.1e1 / t38 / rho[0];
  t48 = t46 * t29 * t34;
  t51 = t29 * t29;
  t52 = params->a2t * t51;
  t54 = 0.1e1 / t32 / t31;
  t55 = sigma[0] * sigma[0];
  t56 = t54 * t55;
  t57 = t36 * t36;
  t58 = t57 * rho[0];
  t60 = 0.1e1 / t37 / t58;
  t61 = t56 * t60;
  t64 = tau[0] * tau[0];
  t65 = params->b2t * t64;
  t66 = t36 * rho[0];
  t68 = 0.1e1 / t37 / t66;
  t69 = t68 * t51;
  t70 = t69 * t54;
  t73 = params->xt * t51;
  t74 = t73 * t54;
  t76 = 0.1e1 / t37 / t57;
  t78 = sigma[0] * t76 * tau[0];
  t81 = params->ct + t30 * t41 / 0.24e2 + 0.5e1 / 0.9e1 * t44 * t48 + t52 * t61 / 0.576e3 + 0.25e2 / 0.81e2 * t65 * t70 + 0.5e1 / 0.216e3 * t74 * t78;
  t82 = t28 * t81;
  t83 = params->ab * t29;
  t86 = params->bb * tau[0];
  t89 = params->a2b * t51;
  t92 = params->b2b * t64;
  t95 = params->xb * t51;
  t96 = t95 * t54;
  t99 = params->cb + t83 * t41 / 0.24e2 + 0.5e1 / 0.9e1 * t86 * t48 + t89 * t61 / 0.576e3 + 0.25e2 / 0.81e2 * t92 * t70 + 0.5e1 / 0.216e3 * t96 * t78;
  t100 = 0.1e1 / t99;
  t101 = t82 * t100;
  t104 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t101);
  t105 = rho[1] <= p->dens_threshold;
  t106 = -t17;
  t108 = my_piecewise5(t15, t12, t11, t16, t106 * t8);
  t109 = 0.1e1 + t108;
  t110 = t109 <= p->zeta_threshold;
  t111 = POW_1_3(t109);
  t113 = my_piecewise3(t110, t23, t111 * t109);
  t114 = t6 * t113;
  t115 = t34 * sigma[2];
  t116 = rho[1] * rho[1];
  t117 = POW_1_3(rho[1]);
  t118 = t117 * t117;
  t120 = 0.1e1 / t118 / t116;
  t121 = t115 * t120;
  t124 = params->bt * tau[1];
  t126 = 0.1e1 / t118 / rho[1];
  t128 = t126 * t29 * t34;
  t131 = sigma[2] * sigma[2];
  t132 = t54 * t131;
  t133 = t116 * t116;
  t134 = t133 * rho[1];
  t136 = 0.1e1 / t117 / t134;
  t137 = t132 * t136;
  t140 = tau[1] * tau[1];
  t141 = params->b2t * t140;
  t142 = t116 * rho[1];
  t144 = 0.1e1 / t117 / t142;
  t145 = t144 * t51;
  t146 = t145 * t54;
  t150 = 0.1e1 / t117 / t133;
  t152 = sigma[2] * t150 * tau[1];
  t155 = params->ct + t30 * t121 / 0.24e2 + 0.5e1 / 0.9e1 * t124 * t128 + t52 * t137 / 0.576e3 + 0.25e2 / 0.81e2 * t141 * t146 + 0.5e1 / 0.216e3 * t74 * t152;
  t156 = t28 * t155;
  t159 = params->bb * tau[1];
  t164 = params->b2b * t140;
  t169 = params->cb + t83 * t121 / 0.24e2 + 0.5e1 / 0.9e1 * t159 * t128 + t89 * t137 / 0.576e3 + 0.25e2 / 0.81e2 * t164 * t146 + 0.5e1 / 0.216e3 * t96 * t152;
  t170 = 0.1e1 / t169;
  t171 = t156 * t170;
  t174 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t171);
  tzk0 = t104 + t174;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t175 = t7 * t7;
  t176 = 0.1e1 / t175;
  t177 = t17 * t176;
  t179 = my_piecewise5(t11, 0, t15, 0, t8 - t177);
  t182 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t179);
  t183 = t6 * t182;
  t186 = t28 * t28;
  t187 = 0.1e1 / t186;
  t188 = t187 * t81;
  t189 = t188 * t100;
  t191 = t27 * t189 / 0.8e1;
  t193 = 0.1e1 / t38 / t66;
  t194 = t35 * t193;
  t198 = t40 * t29 * t34;
  t201 = t57 * t36;
  t203 = 0.1e1 / t37 / t201;
  t204 = t56 * t203;
  t208 = t76 * t51 * t54;
  t212 = sigma[0] * t60 * tau[0];
  t215 = -t30 * t194 / 0.9e1 - 0.25e2 / 0.27e2 * t44 * t198 - t52 * t204 / 0.108e3 - 0.25e3 / 0.243e3 * t65 * t208 - 0.65e2 / 0.648e3 * t74 * t212;
  t216 = t28 * t215;
  t217 = t216 * t100;
  t220 = t99 * t99;
  t221 = 0.1e1 / t220;
  t232 = -t83 * t194 / 0.9e1 - 0.25e2 / 0.27e2 * t86 * t198 - t89 * t204 / 0.108e3 - 0.25e3 / 0.243e3 * t92 * t208 - 0.65e2 / 0.648e3 * t96 * t212;
  t233 = t221 * t232;
  t234 = t82 * t233;
  t238 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t183 * t101 - t191 - 0.3e1 / 0.8e1 * t27 * t217 + 0.3e1 / 0.8e1 * t27 * t234);
  t239 = t106 * t176;
  t241 = my_piecewise5(t15, 0, t11, 0, -t8 - t239);
  t244 = my_piecewise3(t110, 0, 0.4e1 / 0.3e1 * t111 * t241);
  t245 = t6 * t244;
  t248 = t187 * t155;
  t249 = t248 * t170;
  t251 = t114 * t249 / 0.8e1;
  t253 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t245 * t171 - t251);
  tvrho0 = t104 + t174 + t7 * (t238 + t253);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t257 = my_piecewise5(t11, 0, t15, 0, -t8 - t177);
  t260 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t257);
  t261 = t6 * t260;
  t265 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t261 * t101 - t191);
  t267 = my_piecewise5(t15, 0, t11, 0, t8 - t239);
  t270 = my_piecewise3(t110, 0, 0.4e1 / 0.3e1 * t111 * t267);
  t271 = t6 * t270;
  t275 = 0.1e1 / t118 / t142;
  t276 = t115 * t275;
  t280 = t120 * t29 * t34;
  t283 = t133 * t116;
  t285 = 0.1e1 / t117 / t283;
  t286 = t132 * t285;
  t290 = t150 * t51 * t54;
  t294 = sigma[2] * t136 * tau[1];
  t297 = -t30 * t276 / 0.9e1 - 0.25e2 / 0.27e2 * t124 * t280 - t52 * t286 / 0.108e3 - 0.25e3 / 0.243e3 * t141 * t290 - 0.65e2 / 0.648e3 * t74 * t294;
  t298 = t28 * t297;
  t299 = t298 * t170;
  t302 = t169 * t169;
  t303 = 0.1e1 / t302;
  t314 = -t83 * t276 / 0.9e1 - 0.25e2 / 0.27e2 * t159 * t280 - t89 * t286 / 0.108e3 - 0.25e3 / 0.243e3 * t164 * t290 - 0.65e2 / 0.648e3 * t96 * t294;
  t315 = t303 * t314;
  t316 = t156 * t315;
  t320 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t271 * t171 - t251 - 0.3e1 / 0.8e1 * t114 * t299 + 0.3e1 / 0.8e1 * t114 * t316);
  tvrho1 = t104 + t174 + t7 * (t265 + t320);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t323 = t34 * t40;
  t326 = t54 * sigma[0];
  t327 = t326 * t60;
  t330 = t54 * t76;
  t331 = t330 * tau[0];
  t334 = t30 * t323 / 0.24e2 + t52 * t327 / 0.288e3 + 0.5e1 / 0.216e3 * t73 * t331;
  t335 = t28 * t334;
  t336 = t335 * t100;
  t344 = t83 * t323 / 0.24e2 + t89 * t327 / 0.288e3 + 0.5e1 / 0.216e3 * t95 * t331;
  t345 = t221 * t344;
  t346 = t82 * t345;
  t350 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t336 + 0.3e1 / 0.8e1 * t27 * t346);
  tvsigma0 = t7 * t350;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t351 = t34 * t120;
  t354 = t54 * sigma[2];
  t355 = t354 * t136;
  t358 = t54 * t150;
  t359 = t358 * tau[1];
  t362 = t30 * t351 / 0.24e2 + t52 * t355 / 0.288e3 + 0.5e1 / 0.216e3 * t73 * t359;
  t363 = t28 * t362;
  t364 = t363 * t170;
  t372 = t83 * t351 / 0.24e2 + t89 * t355 / 0.288e3 + 0.5e1 / 0.216e3 * t95 * t359;
  t373 = t303 * t372;
  t374 = t156 * t373;
  t378 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t364 + 0.3e1 / 0.8e1 * t114 * t374);
  tvsigma2 = t7 * t378;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t380 = t29 * t34;
  t383 = params->b2t * tau[0];
  t386 = t326 * t76;
  t389 = 0.5e1 / 0.9e1 * params->bt * t46 * t380 + 0.5e2 / 0.81e2 * t383 * t70 + 0.5e1 / 0.216e3 * t73 * t386;
  t390 = t28 * t389;
  t391 = t390 * t100;
  t396 = params->b2b * tau[0];
  t401 = 0.5e1 / 0.9e1 * params->bb * t46 * t380 + 0.5e2 / 0.81e2 * t396 * t70 + 0.5e1 / 0.216e3 * t95 * t386;
  t402 = t221 * t401;
  t403 = t82 * t402;
  t407 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t391 + 0.3e1 / 0.8e1 * t27 * t403);
  tvtau0 = t7 * t407;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t411 = params->b2t * tau[1];
  t414 = t354 * t150;
  t417 = 0.5e1 / 0.9e1 * params->bt * t126 * t380 + 0.5e2 / 0.81e2 * t411 * t146 + 0.5e1 / 0.216e3 * t73 * t414;
  t418 = t28 * t417;
  t419 = t418 * t170;
  t424 = params->b2b * tau[1];
  t429 = 0.5e1 / 0.9e1 * params->bb * t126 * t380 + 0.5e2 / 0.81e2 * t424 * t146 + 0.5e1 / 0.216e3 * t95 * t414;
  t430 = t303 * t429;
  t431 = t156 * t430;
  t435 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t419 + 0.3e1 / 0.8e1 * t114 * t431);
  tvtau1 = t7 * t435;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t438 = t24 * t24;
  t439 = 0.1e1 / t438;
  t440 = t179 * t179;
  t443 = t175 * t7;
  t444 = 0.1e1 / t443;
  t445 = t17 * t444;
  t448 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t176 + 0.2e1 * t445);
  t452 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t439 * t440 + 0.4e1 / 0.3e1 * t24 * t448);
  t453 = t6 * t452;
  t456 = t183 * t189;
  t463 = 0.1e1 / t186 / t7;
  t464 = t463 * t81;
  t465 = t464 * t100;
  t467 = t27 * t465 / 0.12e2;
  t468 = t187 * t215;
  t469 = t468 * t100;
  t470 = t27 * t469;
  t472 = t188 * t233;
  t473 = t27 * t472;
  t476 = 0.1e1 / t38 / t57;
  t477 = t35 * t476;
  t481 = t193 * t29 * t34;
  t484 = t57 * t66;
  t486 = 0.1e1 / t37 / t484;
  t487 = t56 * t486;
  t491 = t60 * t51 * t54;
  t495 = sigma[0] * t203 * tau[0];
  t498 = 0.11e2 / 0.27e2 * t30 * t477 + 0.2e3 / 0.81e2 * t44 * t481 + 0.19e2 / 0.324e3 * t52 * t487 + 0.325e4 / 0.729e3 * t65 * t491 + 0.13e3 / 0.243e3 * t74 * t495;
  t499 = t28 * t498;
  t500 = t499 * t100;
  t503 = t216 * t233;
  t507 = 0.1e1 / t220 / t99;
  t508 = t232 * t232;
  t509 = t507 * t508;
  t510 = t82 * t509;
  t523 = 0.11e2 / 0.27e2 * t83 * t477 + 0.2e3 / 0.81e2 * t86 * t481 + 0.19e2 / 0.324e3 * t89 * t487 + 0.325e4 / 0.729e3 * t92 * t491 + 0.13e3 / 0.243e3 * t96 * t495;
  t524 = t221 * t523;
  t525 = t82 * t524;
  t528 = -0.3e1 / 0.8e1 * t453 * t101 - t456 / 0.4e1 - 0.3e1 / 0.4e1 * t183 * t217 + 0.3e1 / 0.4e1 * t183 * t234 + t467 - t470 / 0.4e1 + t473 / 0.4e1 - 0.3e1 / 0.8e1 * t27 * t500 + 0.3e1 / 0.4e1 * t27 * t503 - 0.3e1 / 0.4e1 * t27 * t510 + 0.3e1 / 0.8e1 * t27 * t525;
  t529 = my_piecewise3(t2, 0, t528);
  t530 = t111 * t111;
  t531 = 0.1e1 / t530;
  t532 = t241 * t241;
  t535 = t106 * t444;
  t538 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t176 + 0.2e1 * t535);
  t542 = my_piecewise3(t110, 0, 0.4e1 / 0.9e1 * t531 * t532 + 0.4e1 / 0.3e1 * t111 * t538);
  t543 = t6 * t542;
  t546 = t245 * t249;
  t548 = t463 * t155;
  t549 = t548 * t170;
  t551 = t114 * t549 / 0.12e2;
  t553 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t543 * t171 - t546 / 0.4e1 + t551);
  tv2rho20 = 0.2e1 * t238 + 0.2e1 * t253 + t7 * (t529 + t553);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t556 = t439 * t257;
  t560 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t445);
  t564 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t556 * t179 + 0.4e1 / 0.3e1 * t24 * t560);
  t565 = t6 * t564;
  t568 = t261 * t189;
  t578 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t565 * t101 - t568 / 0.8e1 - 0.3e1 / 0.8e1 * t261 * t217 + 0.3e1 / 0.8e1 * t261 * t234 - t456 / 0.8e1 + t467 - t470 / 0.8e1 + t473 / 0.8e1);
  t579 = t531 * t267;
  t583 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t535);
  t587 = my_piecewise3(t110, 0, 0.4e1 / 0.9e1 * t579 * t241 + 0.4e1 / 0.3e1 * t111 * t583);
  t588 = t6 * t587;
  t591 = t271 * t249;
  t596 = t187 * t297;
  t597 = t596 * t170;
  t598 = t114 * t597;
  t602 = t248 * t315;
  t603 = t114 * t602;
  t606 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t588 * t171 - t591 / 0.8e1 - t546 / 0.8e1 + t551 - 0.3e1 / 0.8e1 * t245 * t299 - t598 / 0.8e1 + 0.3e1 / 0.8e1 * t245 * t316 + t603 / 0.8e1);
  tv2rho21 = t238 + t253 + t265 + t320 + t7 * (t578 + t606);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t611 = t257 * t257;
  t616 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t176 + 0.2e1 * t445);
  t620 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t439 * t611 + 0.4e1 / 0.3e1 * t24 * t616);
  t621 = t6 * t620;
  t626 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t621 * t101 - t568 / 0.4e1 + t467);
  t627 = t267 * t267;
  t632 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t176 + 0.2e1 * t535);
  t636 = my_piecewise3(t110, 0, 0.4e1 / 0.9e1 * t531 * t627 + 0.4e1 / 0.3e1 * t111 * t632);
  t637 = t6 * t636;
  t648 = 0.1e1 / t118 / t133;
  t649 = t115 * t648;
  t653 = t275 * t29 * t34;
  t656 = t133 * t142;
  t658 = 0.1e1 / t117 / t656;
  t659 = t132 * t658;
  t663 = t136 * t51 * t54;
  t667 = sigma[2] * t285 * tau[1];
  t670 = 0.11e2 / 0.27e2 * t30 * t649 + 0.2e3 / 0.81e2 * t124 * t653 + 0.19e2 / 0.324e3 * t52 * t659 + 0.325e4 / 0.729e3 * t141 * t663 + 0.13e3 / 0.243e3 * t74 * t667;
  t671 = t28 * t670;
  t672 = t671 * t170;
  t675 = t298 * t315;
  t679 = 0.1e1 / t302 / t169;
  t680 = t314 * t314;
  t681 = t679 * t680;
  t682 = t156 * t681;
  t695 = 0.11e2 / 0.27e2 * t83 * t649 + 0.2e3 / 0.81e2 * t159 * t653 + 0.19e2 / 0.324e3 * t89 * t659 + 0.325e4 / 0.729e3 * t164 * t663 + 0.13e3 / 0.243e3 * t96 * t667;
  t696 = t303 * t695;
  t697 = t156 * t696;
  t700 = -0.3e1 / 0.8e1 * t637 * t171 - t591 / 0.4e1 - 0.3e1 / 0.4e1 * t271 * t299 + 0.3e1 / 0.4e1 * t271 * t316 + t551 - t598 / 0.4e1 + t603 / 0.4e1 - 0.3e1 / 0.8e1 * t114 * t672 + 0.3e1 / 0.4e1 * t114 * t675 - 0.3e1 / 0.4e1 * t114 * t682 + 0.3e1 / 0.8e1 * t114 * t697;
  t701 = my_piecewise3(t105, 0, t700);
  tv2rho22 = 0.2e1 * t265 + 0.2e1 * t320 + t7 * (t626 + t701);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t706 = t187 * t334;
  t707 = t706 * t100;
  t709 = t27 * t707 / 0.8e1;
  t710 = t34 * t193;
  t713 = t326 * t203;
  t716 = t54 * t60;
  t717 = t716 * tau[0];
  t720 = -t30 * t710 / 0.9e1 - t52 * t713 / 0.54e2 - 0.65e2 / 0.648e3 * t73 * t717;
  t721 = t28 * t720;
  t722 = t721 * t100;
  t725 = t335 * t233;
  t730 = t188 * t345;
  t732 = t27 * t730 / 0.8e1;
  t733 = t216 * t345;
  t736 = t26 * t28;
  t737 = t6 * t736;
  t738 = t81 * t507;
  t739 = t344 * t232;
  t740 = t738 * t739;
  t749 = -t83 * t710 / 0.9e1 - t89 * t713 / 0.54e2 - 0.65e2 / 0.648e3 * t95 * t717;
  t750 = t221 * t749;
  t751 = t82 * t750;
  t755 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t183 * t336 - t709 - 0.3e1 / 0.8e1 * t27 * t722 + 0.3e1 / 0.8e1 * t27 * t725 + 0.3e1 / 0.8e1 * t183 * t346 + t732 + 0.3e1 / 0.8e1 * t27 * t733 - 0.3e1 / 0.4e1 * t737 * t740 + 0.3e1 / 0.8e1 * t27 * t751);
  tv2rhosigma0 = t7 * t755 + t350;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t759 = t187 * t362;
  t760 = t759 * t170;
  t762 = t114 * t760 / 0.8e1;
  t765 = t248 * t373;
  t767 = t114 * t765 / 0.8e1;
  t769 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t245 * t364 - t762 + 0.3e1 / 0.8e1 * t245 * t374 + t767);
  tv2rhosigma2 = t7 * t769 + t378;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t776 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t261 * t336 - t709 + 0.3e1 / 0.8e1 * t261 * t346 + t732);
  tv2rhosigma3 = t7 * t776 + t350;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t780 = t34 * t275;
  t783 = t354 * t285;
  t786 = t54 * t136;
  t787 = t786 * tau[1];
  t790 = -t30 * t780 / 0.9e1 - t52 * t783 / 0.54e2 - 0.65e2 / 0.648e3 * t73 * t787;
  t791 = t28 * t790;
  t792 = t791 * t170;
  t795 = t363 * t315;
  t800 = t298 * t373;
  t803 = t113 * t28;
  t804 = t6 * t803;
  t805 = t155 * t679;
  t806 = t372 * t314;
  t807 = t805 * t806;
  t816 = -t83 * t780 / 0.9e1 - t89 * t783 / 0.54e2 - 0.65e2 / 0.648e3 * t95 * t787;
  t817 = t303 * t816;
  t818 = t156 * t817;
  t822 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t271 * t364 - t762 - 0.3e1 / 0.8e1 * t114 * t792 + 0.3e1 / 0.8e1 * t114 * t795 + 0.3e1 / 0.8e1 * t271 * t374 + t767 + 0.3e1 / 0.8e1 * t114 * t800 - 0.3e1 / 0.4e1 * t804 * t807 + 0.3e1 / 0.8e1 * t114 * t818);
  tv2rhosigma5 = t7 * t822 + t378;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t826 = t187 * t389;
  t827 = t826 * t100;
  t829 = t27 * t827 / 0.8e1;
  t837 = -0.25e2 / 0.27e2 * params->bt * t40 * t380 - 0.5e3 / 0.243e3 * t383 * t208 - 0.65e2 / 0.648e3 * t73 * t327;
  t838 = t28 * t837;
  t839 = t838 * t100;
  t842 = t390 * t233;
  t847 = t188 * t402;
  t849 = t27 * t847 / 0.8e1;
  t850 = t216 * t402;
  t853 = t401 * t232;
  t854 = t738 * t853;
  t864 = -0.25e2 / 0.27e2 * params->bb * t40 * t380 - 0.5e3 / 0.243e3 * t396 * t208 - 0.65e2 / 0.648e3 * t95 * t327;
  t865 = t221 * t864;
  t866 = t82 * t865;
  t870 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t183 * t391 - t829 - 0.3e1 / 0.8e1 * t27 * t839 + 0.3e1 / 0.8e1 * t27 * t842 + 0.3e1 / 0.8e1 * t183 * t403 + t849 + 0.3e1 / 0.8e1 * t27 * t850 - 0.3e1 / 0.4e1 * t737 * t854 + 0.3e1 / 0.8e1 * t27 * t866);
  tv2rhotau0 = t7 * t870 + t407;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t874 = t187 * t417;
  t875 = t874 * t170;
  t877 = t114 * t875 / 0.8e1;
  t880 = t248 * t430;
  t882 = t114 * t880 / 0.8e1;
  t884 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t245 * t419 - t877 + 0.3e1 / 0.8e1 * t245 * t431 + t882);
  tv2rhotau1 = t7 * t884 + t435;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t891 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t261 * t391 - t829 + 0.3e1 / 0.8e1 * t261 * t403 + t849);
  tv2rhotau2 = t7 * t891 + t407;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t902 = -0.25e2 / 0.27e2 * params->bt * t120 * t380 - 0.5e3 / 0.243e3 * t411 * t290 - 0.65e2 / 0.648e3 * t73 * t355;
  t903 = t28 * t902;
  t904 = t903 * t170;
  t907 = t418 * t315;
  t912 = t298 * t430;
  t915 = t429 * t314;
  t916 = t805 * t915;
  t926 = -0.25e2 / 0.27e2 * params->bb * t120 * t380 - 0.5e3 / 0.243e3 * t424 * t290 - 0.65e2 / 0.648e3 * t95 * t355;
  t927 = t303 * t926;
  t928 = t156 * t927;
  t932 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t271 * t419 - t877 - 0.3e1 / 0.8e1 * t114 * t904 + 0.3e1 / 0.8e1 * t114 * t907 + 0.3e1 / 0.8e1 * t271 * t431 + t882 + 0.3e1 / 0.8e1 * t114 * t912 - 0.3e1 / 0.4e1 * t804 * t916 + 0.3e1 / 0.8e1 * t114 * t928);
  tv2rhotau3 = t7 * t932 + t435;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t934 = t716 * t100;
  t935 = t52 * t934;
  t938 = t335 * t345;
  t941 = t344 * t344;
  t942 = t507 * t941;
  t943 = t82 * t942;
  t947 = t6 * t736 * t81;
  t948 = t221 * params->a2b;
  t949 = t948 * t491;
  t953 = my_piecewise3(t2, 0, -t737 * t935 / 0.768e3 + 0.3e1 / 0.4e1 * t27 * t938 - 0.3e1 / 0.4e1 * t27 * t943 + t947 * t949 / 0.768e3);
  tv2sigma20 = t7 * t953;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t954 = t786 * t170;
  t955 = t52 * t954;
  t958 = t363 * t373;
  t961 = t372 * t372;
  t962 = t679 * t961;
  t963 = t156 * t962;
  t967 = t6 * t803 * t155;
  t968 = t303 * params->a2b;
  t969 = t968 * t663;
  t973 = my_piecewise3(t105, 0, -t804 * t955 / 0.768e3 + 0.3e1 / 0.4e1 * t114 * t958 - 0.3e1 / 0.4e1 * t114 * t963 + t967 * t969 / 0.768e3);
  tv2sigma25 = t7 * t973;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t975 = t73 * t330 * t100;
  t978 = t390 * t345;
  t981 = t335 * t402;
  t984 = t401 * t344;
  t985 = t738 * t984;
  t988 = t221 * params->xb;
  t989 = t988 * t208;
  t993 = my_piecewise3(t2, 0, -0.5e1 / 0.576e3 * t737 * t975 + 0.3e1 / 0.8e1 * t27 * t978 + 0.3e1 / 0.8e1 * t27 * t981 - 0.3e1 / 0.4e1 * t737 * t985 + 0.5e1 / 0.576e3 * t947 * t989);
  tv2sigmatau0 = t7 * t993;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t995 = t73 * t358 * t170;
  t998 = t418 * t373;
  t1001 = t363 * t430;
  t1004 = t429 * t372;
  t1005 = t805 * t1004;
  t1008 = t303 * params->xb;
  t1009 = t1008 * t290;
  t1013 = my_piecewise3(t105, 0, -0.5e1 / 0.576e3 * t804 * t995 + 0.3e1 / 0.8e1 * t114 * t998 + 0.3e1 / 0.8e1 * t114 * t1001 - 0.3e1 / 0.4e1 * t804 * t1005 + 0.5e1 / 0.576e3 * t967 * t1009);
  tv2sigmatau5 = t7 * t1013;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1015 = t51 * t54;
  t1016 = t1015 * t100;
  t1017 = params->b2t * t68 * t1016;
  t1020 = t390 * t402;
  t1023 = t401 * t401;
  t1024 = t507 * t1023;
  t1025 = t82 * t1024;
  t1028 = t221 * params->b2b;
  t1029 = t1028 * t70;
  t1033 = my_piecewise3(t2, 0, -0.25e2 / 0.108e3 * t737 * t1017 + 0.3e1 / 0.4e1 * t27 * t1020 - 0.3e1 / 0.4e1 * t27 * t1025 + 0.25e2 / 0.108e3 * t947 * t1029);
  tv2tau20 = t7 * t1033;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1035 = t1015 * t170;
  t1036 = params->b2t * t144 * t1035;
  t1039 = t418 * t430;
  t1042 = t429 * t429;
  t1043 = t679 * t1042;
  t1044 = t156 * t1043;
  t1047 = t303 * params->b2b;
  t1048 = t1047 * t146;
  t1052 = my_piecewise3(t105, 0, -0.25e2 / 0.108e3 * t804 * t1036 + 0.3e1 / 0.4e1 * t114 * t1039 - 0.3e1 / 0.4e1 * t114 * t1044 + 0.25e2 / 0.108e3 * t967 * t1048);
  tv2tau22 = t7 * t1052;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1056 = 0.1e1 / t38 / t58;
  t1057 = t35 * t1056;
  t1061 = t476 * t29 * t34;
  t1064 = t57 * t57;
  t1066 = 0.1e1 / t37 / t1064;
  t1067 = t56 * t1066;
  t1071 = t203 * t51 * t54;
  t1075 = sigma[0] * t486 * tau[0];
  t1078 = -0.154e3 / 0.81e2 * t30 * t1057 - 0.22e4 / 0.243e3 * t44 * t1061 - 0.209e3 / 0.486e3 * t52 * t1067 - 0.52e5 / 0.2187e4 * t65 * t1071 - 0.247e4 / 0.729e3 * t74 * t1075;
  t1079 = t28 * t1078;
  t1080 = t1079 * t100;
  t1085 = t463 * t215;
  t1086 = t1085 * t100;
  t1087 = t27 * t1086;
  t1089 = t187 * t498;
  t1090 = t1089 * t100;
  t1091 = t27 * t1090;
  t1094 = 0.1e1 / t438 / t20;
  t1095 = t440 * t179;
  t1098 = t439 * t179;
  t1101 = t175 * t175;
  t1102 = 0.1e1 / t1101;
  t1103 = t17 * t1102;
  t1106 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t444 - 0.6e1 * t1103);
  t1110 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1094 * t1095 + 0.4e1 / 0.3e1 * t1098 * t448 + 0.4e1 / 0.3e1 * t24 * t1106);
  t1111 = t6 * t1110;
  t1116 = t183 * t469;
  t1119 = 0.1e1 / t186 / t175;
  t1120 = t1119 * t81;
  t1121 = t1120 * t100;
  t1123 = 0.5e1 / 0.36e2 * t27 * t1121;
  t1124 = t183 * t465;
  t1126 = t453 * t189;
  t1130 = t188 * t509;
  t1131 = t27 * t1130;
  t1133 = -0.3e1 / 0.8e1 * t27 * t1080 - 0.9e1 / 0.8e1 * t183 * t500 + t1087 / 0.4e1 - 0.3e1 / 0.8e1 * t1091 - 0.3e1 / 0.8e1 * t1111 * t101 - 0.9e1 / 0.8e1 * t453 * t217 - 0.3e1 / 0.4e1 * t1116 - t1123 + t1124 / 0.4e1 - 0.3e1 / 0.8e1 * t1126 - 0.9e1 / 0.4e1 * t183 * t510 - 0.3e1 / 0.4e1 * t1131;
  t1134 = t216 * t509;
  t1141 = t464 * t233;
  t1142 = t27 * t1141;
  t1144 = t468 * t233;
  t1145 = t27 * t1144;
  t1147 = t188 * t524;
  t1148 = t27 * t1147;
  t1150 = t220 * t220;
  t1151 = 0.1e1 / t1150;
  t1152 = t508 * t232;
  t1153 = t1151 * t1152;
  t1154 = t82 * t1153;
  t1157 = t499 * t233;
  t1160 = t216 * t524;
  t1173 = -0.154e3 / 0.81e2 * t83 * t1057 - 0.22e4 / 0.243e3 * t86 * t1061 - 0.209e3 / 0.486e3 * t89 * t1067 - 0.52e5 / 0.2187e4 * t92 * t1071 - 0.247e4 / 0.729e3 * t96 * t1075;
  t1174 = t221 * t1173;
  t1175 = t82 * t1174;
  t1180 = t183 * t472;
  t1182 = t232 * t523;
  t1183 = t738 * t1182;
  t1186 = -0.9e1 / 0.4e1 * t27 * t1134 + 0.9e1 / 0.4e1 * t183 * t503 + 0.9e1 / 0.8e1 * t183 * t525 - t1142 / 0.4e1 + 0.3e1 / 0.4e1 * t1145 + 0.3e1 / 0.8e1 * t1148 + 0.9e1 / 0.4e1 * t27 * t1154 + 0.9e1 / 0.8e1 * t27 * t1157 + 0.9e1 / 0.8e1 * t27 * t1160 + 0.3e1 / 0.8e1 * t27 * t1175 + 0.9e1 / 0.8e1 * t453 * t234 + 0.3e1 / 0.4e1 * t1180 - 0.9e1 / 0.4e1 * t737 * t1183;
  t1188 = my_piecewise3(t2, 0, t1133 + t1186);
  t1190 = 0.1e1 / t530 / t109;
  t1191 = t532 * t241;
  t1194 = t531 * t241;
  t1197 = t106 * t1102;
  t1200 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t444 - 0.6e1 * t1197);
  t1204 = my_piecewise3(t110, 0, -0.8e1 / 0.27e2 * t1190 * t1191 + 0.4e1 / 0.3e1 * t1194 * t538 + 0.4e1 / 0.3e1 * t111 * t1200);
  t1205 = t6 * t1204;
  t1208 = t543 * t249;
  t1210 = t245 * t549;
  t1212 = t1119 * t155;
  t1213 = t1212 * t170;
  t1215 = 0.5e1 / 0.36e2 * t114 * t1213;
  t1217 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t1205 * t171 - 0.3e1 / 0.8e1 * t1208 + t1210 / 0.4e1 - t1215);
  tv3rho30 = 0.3e1 * t529 + 0.3e1 * t553 + t7 * (t1188 + t1217);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1220 = 0.2e1 * t578;
  t1221 = 0.2e1 * t606;
  t1223 = t565 * t189 / 0.4e1;
  t1226 = t261 * t465;
  t1229 = t261 * t472 / 0.4e1;
  t1238 = -t1223 + 0.3e1 / 0.4e1 * t565 * t234 + t1226 / 0.12e2 + t1229 + 0.3e1 / 0.4e1 * t261 * t503 + 0.3e1 / 0.8e1 * t261 * t525 - t1126 / 0.8e1 + t1124 / 0.6e1 + t1180 / 0.4e1 - t1123 - t1142 / 0.6e1;
  t1245 = t261 * t469 / 0.4e1;
  t1248 = t1094 * t257;
  t1251 = t439 * t560;
  t1256 = 0.2e1 * t444;
  t1257 = 0.6e1 * t1103;
  t1259 = my_piecewise5(t11, 0, t15, 0, t1256 - t1257);
  t1263 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1248 * t440 + 0.8e1 / 0.9e1 * t1251 * t179 + 0.4e1 / 0.9e1 * t556 * t448 + 0.4e1 / 0.3e1 * t24 * t1259);
  t1264 = t6 * t1263;
  t1272 = t1145 / 0.4e1 + t1148 / 0.8e1 - 0.3e1 / 0.4e1 * t261 * t510 - t1131 / 0.4e1 - t1245 - 0.3e1 / 0.8e1 * t261 * t500 - 0.3e1 / 0.8e1 * t1264 * t101 - 0.3e1 / 0.4e1 * t565 * t217 - t1116 / 0.4e1 + t1087 / 0.6e1 - t1091 / 0.8e1;
  t1274 = my_piecewise3(t2, 0, t1238 + t1272);
  t1275 = t1190 * t267;
  t1278 = t531 * t583;
  t1283 = 0.6e1 * t1197;
  t1285 = my_piecewise5(t15, 0, t11, 0, -t1256 - t1283);
  t1289 = my_piecewise3(t110, 0, -0.8e1 / 0.27e2 * t1275 * t532 + 0.8e1 / 0.9e1 * t1278 * t241 + 0.4e1 / 0.9e1 * t579 * t538 + 0.4e1 / 0.3e1 * t111 * t1285);
  t1290 = t6 * t1289;
  t1294 = t588 * t249 / 0.4e1;
  t1295 = t271 * t549;
  t1302 = t245 * t597 / 0.4e1;
  t1303 = t463 * t297;
  t1304 = t1303 * t170;
  t1305 = t114 * t1304;
  t1310 = t245 * t602 / 0.4e1;
  t1311 = t548 * t315;
  t1312 = t114 * t1311;
  t1314 = -0.3e1 / 0.8e1 * t1290 * t171 - t1294 + t1295 / 0.12e2 - t1208 / 0.8e1 + t1210 / 0.6e1 - t1215 - 0.3e1 / 0.8e1 * t543 * t299 - t1302 + t1305 / 0.12e2 + 0.3e1 / 0.8e1 * t543 * t316 + t1310 - t1312 / 0.12e2;
  t1315 = my_piecewise3(t105, 0, t1314);
  tv3rho31 = t529 + t553 + t1220 + t1221 + t7 * (t1274 + t1315);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1318 = t1094 * t611;
  t1323 = t439 * t616;
  t1327 = my_piecewise5(t11, 0, t15, 0, -t1256 - t1257);
  t1331 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1318 * t179 + 0.8e1 / 0.9e1 * t556 * t560 + 0.4e1 / 0.9e1 * t1323 * t179 + 0.4e1 / 0.3e1 * t24 * t1327);
  t1332 = t6 * t1331;
  t1335 = t621 * t189;
  t1345 = -0.3e1 / 0.8e1 * t1332 * t101 - t1335 / 0.8e1 - 0.3e1 / 0.8e1 * t621 * t217 + 0.3e1 / 0.8e1 * t621 * t234 - t1223 + t1226 / 0.6e1 - t1245 + t1229 + t1124 / 0.12e2 - t1123 + t1087 / 0.12e2 - t1142 / 0.12e2;
  t1346 = my_piecewise3(t2, 0, t1345);
  t1347 = t1190 * t627;
  t1352 = t531 * t632;
  t1356 = my_piecewise5(t15, 0, t11, 0, t1256 - t1283);
  t1360 = my_piecewise3(t110, 0, -0.8e1 / 0.27e2 * t1347 * t241 + 0.8e1 / 0.9e1 * t579 * t583 + 0.4e1 / 0.9e1 * t1352 * t241 + 0.4e1 / 0.3e1 * t111 * t1356);
  t1361 = t6 * t1360;
  t1364 = t637 * t249;
  t1369 = t271 * t597;
  t1373 = t271 * t602;
  t1376 = -0.3e1 / 0.8e1 * t1361 * t171 - t1364 / 0.8e1 - t1294 + t1295 / 0.6e1 - 0.3e1 / 0.4e1 * t588 * t299 - t1369 / 0.4e1 + 0.3e1 / 0.4e1 * t588 * t316 + t1373 / 0.4e1 + t1210 / 0.12e2 - t1215 - t1302;
  t1381 = t187 * t670;
  t1382 = t1381 * t170;
  t1383 = t114 * t1382;
  t1387 = t596 * t315;
  t1388 = t114 * t1387;
  t1392 = t248 * t681;
  t1393 = t114 * t1392;
  t1397 = t248 * t696;
  t1398 = t114 * t1397;
  t1400 = t1305 / 0.6e1 + t1310 - t1312 / 0.6e1 - 0.3e1 / 0.8e1 * t245 * t672 - t1383 / 0.8e1 + 0.3e1 / 0.4e1 * t245 * t675 + t1388 / 0.4e1 - 0.3e1 / 0.4e1 * t245 * t682 - t1393 / 0.4e1 + 0.3e1 / 0.8e1 * t245 * t697 + t1398 / 0.8e1;
  t1402 = my_piecewise3(t105, 0, t1376 + t1400);
  tv3rho32 = t1220 + t1221 + t626 + t701 + t7 * (t1346 + t1402);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1407 = t611 * t257;
  t1414 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t444 - 0.6e1 * t1103);
  t1418 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1094 * t1407 + 0.4e1 / 0.3e1 * t556 * t616 + 0.4e1 / 0.3e1 * t24 * t1414);
  t1419 = t6 * t1418;
  t1425 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t1419 * t101 - 0.3e1 / 0.8e1 * t1335 + t1226 / 0.4e1 - t1123);
  t1431 = t302 * t302;
  t1432 = 0.1e1 / t1431;
  t1433 = t680 * t314;
  t1434 = t1432 * t1433;
  t1435 = t156 * t1434;
  t1440 = t298 * t681;
  t1443 = t298 * t696;
  t1447 = 0.1e1 / t118 / t134;
  t1448 = t115 * t1447;
  t1452 = t648 * t29 * t34;
  t1455 = t133 * t133;
  t1457 = 0.1e1 / t117 / t1455;
  t1458 = t132 * t1457;
  t1462 = t285 * t51 * t54;
  t1466 = sigma[2] * t658 * tau[1];
  t1469 = -0.154e3 / 0.81e2 * t83 * t1448 - 0.22e4 / 0.243e3 * t159 * t1452 - 0.209e3 / 0.486e3 * t89 * t1458 - 0.52e5 / 0.2187e4 * t164 * t1462 - 0.247e4 / 0.729e3 * t96 * t1466;
  t1470 = t303 * t1469;
  t1471 = t156 * t1470;
  t1476 = -t1215 - 0.3e1 / 0.8e1 * t1383 - 0.3e1 / 0.4e1 * t1369 - 0.3e1 / 0.8e1 * t1364 + t1305 / 0.4e1 + t1295 / 0.4e1 + 0.9e1 / 0.4e1 * t114 * t1435 - 0.9e1 / 0.4e1 * t271 * t682 - 0.9e1 / 0.4e1 * t114 * t1440 + 0.9e1 / 0.8e1 * t114 * t1443 + 0.3e1 / 0.8e1 * t114 * t1471 + 0.9e1 / 0.8e1 * t637 * t316;
  t1481 = t671 * t315;
  t1489 = t314 * t695;
  t1490 = t805 * t1489;
  t1507 = -0.154e3 / 0.81e2 * t30 * t1448 - 0.22e4 / 0.243e3 * t124 * t1452 - 0.209e3 / 0.486e3 * t52 * t1458 - 0.52e5 / 0.2187e4 * t141 * t1462 - 0.247e4 / 0.729e3 * t74 * t1466;
  t1508 = t28 * t1507;
  t1509 = t1508 * t170;
  t1512 = t627 * t267;
  t1519 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t444 - 0.6e1 * t1197);
  t1523 = my_piecewise3(t110, 0, -0.8e1 / 0.27e2 * t1190 * t1512 + 0.4e1 / 0.3e1 * t579 * t632 + 0.4e1 / 0.3e1 * t111 * t1519);
  t1524 = t6 * t1523;
  t1527 = 0.9e1 / 0.4e1 * t271 * t675 + 0.9e1 / 0.8e1 * t271 * t697 + 0.9e1 / 0.8e1 * t114 * t1481 + 0.3e1 / 0.4e1 * t1388 - 0.3e1 / 0.4e1 * t1393 + 0.3e1 / 0.8e1 * t1398 + 0.3e1 / 0.4e1 * t1373 - t1312 / 0.4e1 - 0.9e1 / 0.4e1 * t804 * t1490 - 0.9e1 / 0.8e1 * t637 * t299 - 0.9e1 / 0.8e1 * t271 * t672 - 0.3e1 / 0.8e1 * t114 * t1509 - 0.3e1 / 0.8e1 * t1524 * t171;
  t1529 = my_piecewise3(t105, 0, t1476 + t1527);
  tv3rho33 = 0.3e1 * t626 + 0.3e1 * t701 + t7 * (t1425 + t1529);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1533 = t216 * t750;
  t1536 = t335 * t509;
  t1539 = t183 * t730;
  t1541 = t464 * t345;
  t1543 = t27 * t1541 / 0.12e2;
  t1544 = t706 * t233;
  t1545 = t27 * t1544;
  t1547 = t721 * t233;
  t1550 = t335 * t524;
  t1559 = t468 * t345;
  t1560 = t27 * t1559;
  t1562 = t188 * t750;
  t1563 = t27 * t1562;
  t1565 = t499 * t345;
  t1568 = 0.3e1 / 0.4e1 * t27 * t1533 - 0.3e1 / 0.4e1 * t27 * t1536 + t1539 / 0.4e1 - t1543 + t1545 / 0.4e1 + 0.3e1 / 0.4e1 * t27 * t1547 + 0.3e1 / 0.8e1 * t27 * t1550 + 0.3e1 / 0.8e1 * t453 * t346 + 0.3e1 / 0.4e1 * t183 * t733 + 0.3e1 / 0.4e1 * t183 * t751 + t1560 / 0.4e1 + t1563 / 0.4e1 + 0.3e1 / 0.8e1 * t27 * t1565;
  t1569 = t34 * t476;
  t1572 = t326 * t486;
  t1575 = t54 * t203;
  t1576 = t1575 * tau[0];
  t1579 = 0.11e2 / 0.27e2 * t83 * t1569 + 0.19e2 / 0.162e3 * t89 * t1572 + 0.13e3 / 0.243e3 * t95 * t1576;
  t1580 = t221 * t1579;
  t1581 = t82 * t1580;
  t1586 = t183 * t707;
  t1588 = t463 * t334;
  t1589 = t1588 * t100;
  t1591 = t27 * t1589 / 0.12e2;
  t1594 = t187 * t720;
  t1595 = t1594 * t100;
  t1596 = t27 * t1595;
  t1604 = 0.11e2 / 0.27e2 * t30 * t1569 + 0.19e2 / 0.162e3 * t52 * t1572 + 0.13e3 / 0.243e3 * t73 * t1576;
  t1605 = t28 * t1604;
  t1606 = t1605 * t100;
  t1611 = t182 * t28;
  t1612 = t6 * t1611;
  t1615 = t26 * t187;
  t1616 = t6 * t1615;
  t1617 = t1616 * t740;
  t1619 = t215 * t507;
  t1620 = t1619 * t739;
  t1623 = t749 * t232;
  t1624 = t738 * t1623;
  t1627 = t344 * t523;
  t1628 = t738 * t1627;
  t1631 = t81 * t1151;
  t1632 = t344 * t508;
  t1633 = t1631 * t1632;
  t1636 = 0.3e1 / 0.8e1 * t27 * t1581 + 0.3e1 / 0.4e1 * t183 * t725 - t1586 / 0.4e1 + t1591 - 0.3e1 / 0.4e1 * t183 * t722 - t1596 / 0.4e1 - 0.3e1 / 0.8e1 * t27 * t1606 - 0.3e1 / 0.8e1 * t453 * t336 - 0.3e1 / 0.2e1 * t1612 * t740 - t1617 / 0.2e1 - 0.3e1 / 0.2e1 * t737 * t1620 - 0.3e1 / 0.2e1 * t737 * t1624 - 0.3e1 / 0.4e1 * t737 * t1628 + 0.9e1 / 0.4e1 * t737 * t1633;
  t1638 = my_piecewise3(t2, 0, t1568 + t1636);
  tv3rho2sigma0 = t7 * t1638 + 0.2e1 * t755;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1643 = t245 * t760;
  t1645 = t463 * t362;
  t1646 = t1645 * t170;
  t1648 = t114 * t1646 / 0.12e2;
  t1651 = t245 * t765;
  t1653 = t548 * t373;
  t1655 = t114 * t1653 / 0.12e2;
  t1657 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t543 * t364 - t1643 / 0.4e1 + t1648 + 0.3e1 / 0.8e1 * t543 * t374 + t1651 / 0.4e1 - t1655);
  tv3rho2sigma2 = t7 * t1657 + 0.2e1 * t769;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1661 = t261 * t707;
  t1672 = t261 * t730;
  t1676 = t260 * t28;
  t1677 = t6 * t1676;
  t1686 = -0.3e1 / 0.8e1 * t565 * t336 - t1661 / 0.8e1 - 0.3e1 / 0.8e1 * t261 * t722 + 0.3e1 / 0.8e1 * t261 * t725 - t1586 / 0.8e1 + t1591 - t1596 / 0.8e1 + t1545 / 0.8e1 + 0.3e1 / 0.8e1 * t565 * t346 + t1672 / 0.8e1 + 0.3e1 / 0.8e1 * t261 * t733 - 0.3e1 / 0.4e1 * t1677 * t740 + 0.3e1 / 0.8e1 * t261 * t751 + t1539 / 0.8e1 - t1543 + t1560 / 0.8e1 - t1617 / 0.4e1 + t1563 / 0.8e1;
  t1687 = my_piecewise3(t2, 0, t1686);
  tv3rho2sigma3 = t7 * t1687 + t755 + t776;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1691 = t271 * t760;
  t1696 = t187 * t790;
  t1697 = t1696 * t170;
  t1698 = t114 * t1697;
  t1702 = t759 * t315;
  t1703 = t114 * t1702;
  t1707 = t271 * t765;
  t1712 = t596 * t373;
  t1713 = t114 * t1712;
  t1715 = t244 * t28;
  t1716 = t6 * t1715;
  t1719 = t113 * t187;
  t1720 = t6 * t1719;
  t1721 = t1720 * t807;
  t1725 = t248 * t817;
  t1726 = t114 * t1725;
  t1728 = -0.3e1 / 0.8e1 * t588 * t364 - t1691 / 0.8e1 - t1643 / 0.8e1 + t1648 - 0.3e1 / 0.8e1 * t245 * t792 - t1698 / 0.8e1 + 0.3e1 / 0.8e1 * t245 * t795 + t1703 / 0.8e1 + 0.3e1 / 0.8e1 * t588 * t374 + t1707 / 0.8e1 + t1651 / 0.8e1 - t1655 + 0.3e1 / 0.8e1 * t245 * t800 + t1713 / 0.8e1 - 0.3e1 / 0.4e1 * t1716 * t807 - t1721 / 0.4e1 + 0.3e1 / 0.8e1 * t245 * t818 + t1726 / 0.8e1;
  t1729 = my_piecewise3(t105, 0, t1728);
  tv3rho2sigma5 = t7 * t1729 + t769 + t822;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1739 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t621 * t336 - t1661 / 0.4e1 + t1591 + 0.3e1 / 0.8e1 * t621 * t346 + t1672 / 0.4e1 - t1543);
  tv3rho2sigma6 = t7 * t1739 + 0.2e1 * t776;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1746 = t34 * t648;
  t1749 = t354 * t658;
  t1752 = t54 * t285;
  t1753 = t1752 * tau[1];
  t1756 = 0.11e2 / 0.27e2 * t30 * t1746 + 0.19e2 / 0.162e3 * t52 * t1749 + 0.13e3 / 0.243e3 * t73 * t1753;
  t1757 = t28 * t1756;
  t1758 = t1757 * t170;
  t1763 = t363 * t696;
  t1772 = t671 * t373;
  t1775 = t298 * t817;
  t1784 = 0.11e2 / 0.27e2 * t83 * t1746 + 0.19e2 / 0.162e3 * t89 * t1749 + 0.13e3 / 0.243e3 * t95 * t1753;
  t1785 = t303 * t1784;
  t1786 = t156 * t1785;
  t1789 = -0.3e1 / 0.8e1 * t637 * t364 - 0.3e1 / 0.4e1 * t271 * t792 - 0.3e1 / 0.8e1 * t114 * t1758 - t1698 / 0.4e1 - t1691 / 0.4e1 + t1648 + 0.3e1 / 0.8e1 * t114 * t1763 + 0.3e1 / 0.8e1 * t637 * t374 + 0.3e1 / 0.4e1 * t271 * t800 + 0.3e1 / 0.4e1 * t271 * t818 + 0.3e1 / 0.8e1 * t114 * t1772 + 0.3e1 / 0.4e1 * t114 * t1775 + 0.3e1 / 0.8e1 * t114 * t1786;
  t1792 = t791 * t315;
  t1795 = t363 * t681;
  t1802 = t155 * t1432;
  t1803 = t372 * t680;
  t1804 = t1802 * t1803;
  t1808 = t372 * t695;
  t1809 = t805 * t1808;
  t1812 = t270 * t28;
  t1813 = t6 * t1812;
  t1816 = t297 * t679;
  t1817 = t1816 * t806;
  t1820 = t816 * t314;
  t1821 = t805 * t1820;
  t1824 = 0.3e1 / 0.4e1 * t271 * t795 + 0.3e1 / 0.4e1 * t114 * t1792 - 0.3e1 / 0.4e1 * t114 * t1795 + t1707 / 0.4e1 + t1713 / 0.4e1 + t1726 / 0.4e1 + t1703 / 0.4e1 - t1655 + 0.9e1 / 0.4e1 * t804 * t1804 - t1721 / 0.2e1 - 0.3e1 / 0.4e1 * t804 * t1809 - 0.3e1 / 0.2e1 * t1813 * t807 - 0.3e1 / 0.2e1 * t804 * t1817 - 0.3e1 / 0.2e1 * t804 * t1821;
  t1826 = my_piecewise3(t105, 0, t1789 + t1824);
  tv3rho2sigma8 = t7 * t1826 + 0.2e1 * t822;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t1836 = 0.2e3 / 0.81e2 * params->bt * t193 * t380 + 0.65e4 / 0.729e3 * t383 * t491 + 0.13e3 / 0.243e3 * t73 * t713;
  t1837 = t28 * t1836;
  t1838 = t1837 * t100;
  t1845 = t187 * t837;
  t1846 = t1845 * t100;
  t1847 = t27 * t1846;
  t1849 = t463 * t389;
  t1850 = t1849 * t100;
  t1852 = t27 * t1850 / 0.12e2;
  t1853 = t183 * t827;
  t1857 = t468 * t402;
  t1858 = t27 * t1857;
  t1860 = t188 * t865;
  t1861 = t27 * t1860;
  t1863 = t499 * t402;
  t1866 = t216 * t865;
  t1869 = t390 * t509;
  t1872 = t183 * t847;
  t1874 = -0.3e1 / 0.8e1 * t27 * t1838 - 0.3e1 / 0.8e1 * t453 * t391 - 0.3e1 / 0.4e1 * t183 * t839 - t1847 / 0.4e1 + t1852 - t1853 / 0.4e1 + 0.3e1 / 0.4e1 * t183 * t866 + t1858 / 0.4e1 + t1861 / 0.4e1 + 0.3e1 / 0.8e1 * t27 * t1863 + 0.3e1 / 0.4e1 * t27 * t1866 - 0.3e1 / 0.4e1 * t27 * t1869 + t1872 / 0.4e1;
  t1875 = t464 * t402;
  t1877 = t27 * t1875 / 0.12e2;
  t1880 = t826 * t233;
  t1881 = t27 * t1880;
  t1883 = t838 * t233;
  t1886 = t390 * t524;
  t1900 = 0.2e3 / 0.81e2 * params->bb * t193 * t380 + 0.65e4 / 0.729e3 * t396 * t491 + 0.13e3 / 0.243e3 * t95 * t713;
  t1901 = t221 * t1900;
  t1902 = t82 * t1901;
  t1905 = t401 * t508;
  t1906 = t1631 * t1905;
  t1911 = t1616 * t854;
  t1913 = t1619 * t853;
  t1916 = t864 * t232;
  t1917 = t738 * t1916;
  t1920 = t401 * t523;
  t1921 = t738 * t1920;
  t1924 = -t1877 + 0.3e1 / 0.4e1 * t183 * t842 + t1881 / 0.4e1 + 0.3e1 / 0.4e1 * t27 * t1883 + 0.3e1 / 0.8e1 * t27 * t1886 + 0.3e1 / 0.8e1 * t453 * t403 + 0.3e1 / 0.4e1 * t183 * t850 + 0.3e1 / 0.8e1 * t27 * t1902 + 0.9e1 / 0.4e1 * t737 * t1906 - 0.3e1 / 0.2e1 * t1612 * t854 - t1911 / 0.2e1 - 0.3e1 / 0.2e1 * t737 * t1913 - 0.3e1 / 0.2e1 * t737 * t1917 - 0.3e1 / 0.4e1 * t737 * t1921;
  t1926 = my_piecewise3(t2, 0, t1874 + t1924);
  tv3rho2tau0 = t7 * t1926 + 0.2e1 * t870;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1931 = t245 * t875;
  t1933 = t463 * t417;
  t1934 = t1933 * t170;
  t1936 = t114 * t1934 / 0.12e2;
  t1939 = t245 * t880;
  t1941 = t548 * t430;
  t1943 = t114 * t1941 / 0.12e2;
  t1945 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t543 * t419 - t1931 / 0.4e1 + t1936 + 0.3e1 / 0.8e1 * t543 * t431 + t1939 / 0.4e1 - t1943);
  tv3rho2tau1 = t7 * t1945 + 0.2e1 * t884;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t1949 = t261 * t827;
  t1960 = t261 * t847;
  t1972 = -0.3e1 / 0.8e1 * t565 * t391 - t1949 / 0.8e1 - 0.3e1 / 0.8e1 * t261 * t839 + 0.3e1 / 0.8e1 * t261 * t842 - t1853 / 0.8e1 + t1852 - t1847 / 0.8e1 + t1881 / 0.8e1 + 0.3e1 / 0.8e1 * t565 * t403 + t1960 / 0.8e1 + 0.3e1 / 0.8e1 * t261 * t850 - 0.3e1 / 0.4e1 * t1677 * t854 + 0.3e1 / 0.8e1 * t261 * t866 + t1872 / 0.8e1 - t1877 + t1858 / 0.8e1 - t1911 / 0.4e1 + t1861 / 0.8e1;
  t1973 = my_piecewise3(t2, 0, t1972);
  tv3rho2tau2 = t7 * t1973 + t870 + t891;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t1977 = t271 * t875;
  t1982 = t187 * t902;
  t1983 = t1982 * t170;
  t1984 = t114 * t1983;
  t1988 = t874 * t315;
  t1989 = t114 * t1988;
  t1993 = t271 * t880;
  t1998 = t596 * t430;
  t1999 = t114 * t1998;
  t2003 = t1720 * t916;
  t2007 = t248 * t927;
  t2008 = t114 * t2007;
  t2010 = -0.3e1 / 0.8e1 * t588 * t419 - t1977 / 0.8e1 - t1931 / 0.8e1 + t1936 - 0.3e1 / 0.8e1 * t245 * t904 - t1984 / 0.8e1 + 0.3e1 / 0.8e1 * t245 * t907 + t1989 / 0.8e1 + 0.3e1 / 0.8e1 * t588 * t431 + t1993 / 0.8e1 + t1939 / 0.8e1 - t1943 + 0.3e1 / 0.8e1 * t245 * t912 + t1999 / 0.8e1 - 0.3e1 / 0.4e1 * t1716 * t916 - t2003 / 0.4e1 + 0.3e1 / 0.8e1 * t245 * t928 + t2008 / 0.8e1;
  t2011 = my_piecewise3(t105, 0, t2010);
  tv3rho2tau3 = t7 * t2011 + t884 + t932;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2021 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t621 * t391 - t1949 / 0.4e1 + t1852 + 0.3e1 / 0.8e1 * t621 * t403 + t1960 / 0.4e1 - t1877);
  tv3rho2tau4 = t7 * t2021 + 0.2e1 * t891;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2031 = 0.2e3 / 0.81e2 * params->bt * t275 * t380 + 0.65e4 / 0.729e3 * t411 * t663 + 0.13e3 / 0.243e3 * t73 * t783;
  t2032 = t28 * t2031;
  t2033 = t2032 * t170;
  t2042 = t298 * t927;
  t2052 = 0.2e3 / 0.81e2 * params->bb * t275 * t380 + 0.65e4 / 0.729e3 * t424 * t663 + 0.13e3 / 0.243e3 * t95 * t783;
  t2053 = t303 * t2052;
  t2054 = t156 * t2053;
  t2057 = t418 * t681;
  t2062 = t903 * t315;
  t2065 = t418 * t696;
  t2070 = -0.3e1 / 0.8e1 * t114 * t2033 - 0.3e1 / 0.8e1 * t637 * t419 - 0.3e1 / 0.4e1 * t271 * t904 + t1936 - t1984 / 0.4e1 - t1977 / 0.4e1 + 0.3e1 / 0.4e1 * t114 * t2042 + 0.3e1 / 0.8e1 * t114 * t2054 - 0.3e1 / 0.4e1 * t114 * t2057 + 0.3e1 / 0.4e1 * t271 * t907 + 0.3e1 / 0.4e1 * t114 * t2062 + 0.3e1 / 0.8e1 * t114 * t2065 + 0.3e1 / 0.8e1 * t637 * t431;
  t2075 = t671 * t430;
  t2082 = t429 * t680;
  t2083 = t1802 * t2082;
  t2086 = t1816 * t915;
  t2089 = t926 * t314;
  t2090 = t805 * t2089;
  t2093 = t429 * t695;
  t2094 = t805 * t2093;
  t2100 = 0.3e1 / 0.4e1 * t271 * t912 + 0.3e1 / 0.4e1 * t271 * t928 + 0.3e1 / 0.8e1 * t114 * t2075 + t1999 / 0.4e1 + t2008 / 0.4e1 + t1989 / 0.4e1 + t1993 / 0.4e1 - t1943 + 0.9e1 / 0.4e1 * t804 * t2083 - 0.3e1 / 0.2e1 * t804 * t2086 - 0.3e1 / 0.2e1 * t804 * t2090 - 0.3e1 / 0.4e1 * t804 * t2094 - 0.3e1 / 0.2e1 * t1813 * t916 - t2003 / 0.2e1;
  t2102 = my_piecewise3(t105, 0, t2070 + t2100);
  tv3rho2tau5 = t7 * t2102 + 0.2e1 * t932;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2107 = t1616 * t935 / 0.2304e4;
  t2108 = t1575 * t100;
  t2109 = t52 * t2108;
  t2113 = t6 * t736 * params->a2t;
  t2114 = t60 * t221;
  t2116 = t1015 * t2114 * t232;
  t2121 = t706 * t345;
  t2123 = t27 * t2121 / 0.4e1;
  t2124 = t721 * t345;
  t2127 = t334 * t507;
  t2128 = t2127 * t739;
  t2131 = t335 * t750;
  t2136 = t188 * t942;
  t2138 = t27 * t2136 / 0.4e1;
  t2139 = t216 * t942;
  t2142 = t941 * t232;
  t2143 = t1631 * t2142;
  t2146 = t344 * t749;
  t2147 = t738 * t2146;
  t2151 = t6 * t1611 * t81;
  t2155 = t6 * t1615 * t81;
  t2157 = t2155 * t949 / 0.2304e4;
  t2159 = t6 * t736 * t215;
  t2163 = t507 * params->a2b * t51;
  t2164 = t716 * t232;
  t2165 = t2163 * t2164;
  t2168 = t948 * t1071;
  t2171 = -t1612 * t935 / 0.768e3 - t2107 + t737 * t2109 / 0.144e3 + t2113 * t2116 / 0.768e3 + 0.3e1 / 0.4e1 * t183 * t938 + t2123 + 0.3e1 / 0.4e1 * t27 * t2124 - 0.3e1 / 0.2e1 * t737 * t2128 + 0.3e1 / 0.4e1 * t27 * t2131 - 0.3e1 / 0.4e1 * t183 * t943 - t2138 - 0.3e1 / 0.4e1 * t27 * t2139 + 0.9e1 / 0.4e1 * t737 * t2143 - 0.3e1 / 0.2e1 * t737 * t2147 + t2151 * t949 / 0.768e3 + t2157 + t2159 * t949 / 0.768e3 - t947 * t2165 / 0.384e3 - t947 * t2168 / 0.144e3;
  t2172 = my_piecewise3(t2, 0, t2171);
  tv3rhosigma20 = t7 * t2172 + t953;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2177 = t1720 * t955 / 0.2304e4;
  t2180 = t759 * t373;
  t2182 = t114 * t2180 / 0.4e1;
  t2185 = t248 * t962;
  t2187 = t114 * t2185 / 0.4e1;
  t2189 = t6 * t1715 * t155;
  t2193 = t6 * t1719 * t155;
  t2195 = t2193 * t969 / 0.2304e4;
  t2197 = my_piecewise3(t105, 0, -t1716 * t955 / 0.768e3 - t2177 + 0.3e1 / 0.4e1 * t245 * t958 + t2182 - 0.3e1 / 0.4e1 * t245 * t963 - t2187 + t2189 * t969 / 0.768e3 + t2195);
  tv3rhosigma25 = t7 * t2197 + t973;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2206 = t6 * t1676 * t81;
  t2210 = my_piecewise3(t2, 0, -t1677 * t935 / 0.768e3 - t2107 + 0.3e1 / 0.4e1 * t261 * t938 + t2123 - 0.3e1 / 0.4e1 * t261 * t943 - t2138 + t2206 * t949 / 0.768e3 + t2157);
  tv3rhosigma26 = t7 * t2210 + t953;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2214 = t1752 * t170;
  t2215 = t52 * t2214;
  t2219 = t6 * t803 * params->a2t;
  t2220 = t136 * t303;
  t2222 = t1015 * t2220 * t314;
  t2227 = t791 * t373;
  t2230 = t362 * t679;
  t2231 = t2230 * t806;
  t2234 = t363 * t817;
  t2239 = t298 * t962;
  t2242 = t961 * t314;
  t2243 = t1802 * t2242;
  t2246 = t372 * t816;
  t2247 = t805 * t2246;
  t2251 = t6 * t1812 * t155;
  t2255 = t6 * t803 * t297;
  t2259 = t679 * params->a2b * t51;
  t2260 = t786 * t314;
  t2261 = t2259 * t2260;
  t2264 = t968 * t1462;
  t2267 = -t1813 * t955 / 0.768e3 - t2177 + t804 * t2215 / 0.144e3 + t2219 * t2222 / 0.768e3 + 0.3e1 / 0.4e1 * t271 * t958 + t2182 + 0.3e1 / 0.4e1 * t114 * t2227 - 0.3e1 / 0.2e1 * t804 * t2231 + 0.3e1 / 0.4e1 * t114 * t2234 - 0.3e1 / 0.4e1 * t271 * t963 - t2187 - 0.3e1 / 0.4e1 * t114 * t2239 + 0.9e1 / 0.4e1 * t804 * t2243 - 0.3e1 / 0.2e1 * t804 * t2247 + t2251 * t969 / 0.768e3 + t2195 + t2255 * t969 / 0.768e3 - t967 * t2261 / 0.384e3 - t967 * t2264 / 0.144e3;
  t2268 = my_piecewise3(t105, 0, t2267);
  tv3rhosigma211 = t7 * t2268 + t973;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t2271 = 0.5e1 / 0.1728e4 * t1616 * t975;
  t2272 = t73 * t934;
  t2277 = t984 * t232;
  t2278 = t1631 * t2277;
  t2281 = t706 * t402;
  t2283 = t27 * t2281 / 0.8e1;
  t2286 = t838 * t345;
  t2289 = t390 * t750;
  t2294 = t721 * t402;
  t2297 = t335 * t865;
  t2300 = t826 * t345;
  t2302 = t27 * t2300 / 0.8e1;
  t2303 = -t2271 + 0.65e2 / 0.1728e4 * t737 * t2272 - 0.5e1 / 0.576e3 * t1612 * t975 + 0.9e1 / 0.4e1 * t737 * t2278 + t2283 + 0.3e1 / 0.8e1 * t183 * t978 + 0.3e1 / 0.8e1 * t27 * t2286 + 0.3e1 / 0.8e1 * t27 * t2289 + 0.3e1 / 0.8e1 * t183 * t981 + 0.3e1 / 0.8e1 * t27 * t2294 + 0.3e1 / 0.8e1 * t27 * t2297 + t2302;
  t2305 = t6 * t736 * params->xt;
  t2306 = t76 * t221;
  t2308 = t1015 * t2306 * t232;
  t2316 = 0.5e1 / 0.1728e4 * t2155 * t989;
  t2317 = t988 * t491;
  t2320 = t389 * t507;
  t2321 = t2320 * t739;
  t2324 = t2127 * t853;
  t2329 = t1619 * t984;
  t2332 = t864 * t344;
  t2333 = t738 * t2332;
  t2336 = t401 * t749;
  t2337 = t738 * t2336;
  t2341 = t1616 * t985 / 0.4e1;
  t2342 = t507 * params->xb;
  t2343 = t2342 * t51;
  t2344 = t330 * t232;
  t2345 = t2343 * t2344;
  t2348 = 0.5e1 / 0.576e3 * t2305 * t2308 + 0.5e1 / 0.576e3 * t2151 * t989 + 0.5e1 / 0.576e3 * t2159 * t989 + t2316 - 0.65e2 / 0.1728e4 * t947 * t2317 - 0.3e1 / 0.4e1 * t737 * t2321 - 0.3e1 / 0.4e1 * t737 * t2324 - 0.3e1 / 0.4e1 * t1612 * t985 - 0.3e1 / 0.4e1 * t737 * t2329 - 0.3e1 / 0.4e1 * t737 * t2333 - 0.3e1 / 0.4e1 * t737 * t2337 - t2341 - 0.5e1 / 0.288e3 * t947 * t2345;
  t2350 = my_piecewise3(t2, 0, t2303 + t2348);
  tv3rhosigmatau0 = t7 * t2350 + t993;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t2355 = 0.5e1 / 0.1728e4 * t1720 * t995;
  t2358 = t874 * t373;
  t2360 = t114 * t2358 / 0.8e1;
  t2363 = t759 * t430;
  t2365 = t114 * t2363 / 0.8e1;
  t2369 = t1720 * t1005 / 0.4e1;
  t2373 = 0.5e1 / 0.1728e4 * t2193 * t1009;
  t2375 = my_piecewise3(t105, 0, -0.5e1 / 0.576e3 * t1716 * t995 - t2355 + 0.3e1 / 0.8e1 * t245 * t998 + t2360 + 0.3e1 / 0.8e1 * t245 * t1001 + t2365 - 0.3e1 / 0.4e1 * t1716 * t1005 - t2369 + 0.5e1 / 0.576e3 * t2189 * t1009 + t2373);
  tv3rhosigmatau5 = t7 * t2375 + t1013;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t2388 = my_piecewise3(t2, 0, -0.5e1 / 0.576e3 * t1677 * t975 - t2271 + 0.3e1 / 0.8e1 * t261 * t978 + t2302 + 0.3e1 / 0.8e1 * t261 * t981 + t2283 - 0.3e1 / 0.4e1 * t1677 * t985 - t2341 + 0.5e1 / 0.576e3 * t2206 * t989 + t2316);
  tv3rhosigmatau6 = t7 * t2388 + t993;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t2390 = t73 * t954;
  t2395 = t1004 * t314;
  t2396 = t1802 * t2395;
  t2401 = t903 * t373;
  t2404 = t418 * t817;
  t2409 = t791 * t430;
  t2412 = t363 * t927;
  t2415 = 0.65e2 / 0.1728e4 * t804 * t2390 - 0.5e1 / 0.576e3 * t1813 * t995 + 0.9e1 / 0.4e1 * t804 * t2396 - t2355 + 0.3e1 / 0.8e1 * t271 * t998 + 0.3e1 / 0.8e1 * t114 * t2401 + 0.3e1 / 0.8e1 * t114 * t2404 + 0.3e1 / 0.8e1 * t271 * t1001 + 0.3e1 / 0.8e1 * t114 * t2409 + 0.3e1 / 0.8e1 * t114 * t2412 + t2360 + t2365;
  t2417 = t6 * t803 * params->xt;
  t2418 = t150 * t303;
  t2420 = t1015 * t2418 * t314;
  t2427 = t1008 * t663;
  t2430 = t1816 * t1004;
  t2433 = t926 * t372;
  t2434 = t805 * t2433;
  t2437 = t429 * t816;
  t2438 = t805 * t2437;
  t2441 = t417 * t679;
  t2442 = t2441 * t806;
  t2445 = t2230 * t915;
  t2450 = t679 * params->xb;
  t2451 = t2450 * t51;
  t2452 = t358 * t314;
  t2453 = t2451 * t2452;
  t2456 = t2373 + 0.5e1 / 0.576e3 * t2417 * t2420 + 0.5e1 / 0.576e3 * t2251 * t1009 + 0.5e1 / 0.576e3 * t2255 * t1009 - 0.65e2 / 0.1728e4 * t967 * t2427 - t2369 - 0.3e1 / 0.4e1 * t804 * t2430 - 0.3e1 / 0.4e1 * t804 * t2434 - 0.3e1 / 0.4e1 * t804 * t2438 - 0.3e1 / 0.4e1 * t804 * t2442 - 0.3e1 / 0.4e1 * t804 * t2445 - 0.3e1 / 0.4e1 * t1813 * t1005 - 0.5e1 / 0.288e3 * t967 * t2453;
  t2458 = my_piecewise3(t105, 0, t2415 + t2456);
  tv3rhosigmatau11 = t7 * t2458 + t1013;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t2463 = 0.25e2 / 0.324e3 * t1616 * t1017;
  t2465 = params->b2t * t76 * t1016;
  t2469 = t6 * t736 * params->b2t;
  t2470 = t54 * t221;
  t2472 = t69 * t2470 * t232;
  t2477 = t826 * t402;
  t2479 = t27 * t2477 / 0.4e1;
  t2480 = t838 * t402;
  t2483 = t2320 * t853;
  t2486 = t390 * t865;
  t2491 = t188 * t1024;
  t2493 = t27 * t2491 / 0.4e1;
  t2494 = t216 * t1024;
  t2497 = t1023 * t232;
  t2498 = t1631 * t2497;
  t2501 = t401 * t864;
  t2502 = t738 * t2501;
  t2508 = 0.25e2 / 0.324e3 * t2155 * t1029;
  t2511 = t507 * params->b2b;
  t2512 = t2511 * t68;
  t2513 = t1015 * t232;
  t2514 = t2512 * t2513;
  t2517 = t1028 * t208;
  t2520 = -0.25e2 / 0.108e3 * t1612 * t1017 - t2463 + 0.125e3 / 0.162e3 * t737 * t2465 + 0.25e2 / 0.108e3 * t2469 * t2472 + 0.3e1 / 0.4e1 * t183 * t1020 + t2479 + 0.3e1 / 0.4e1 * t27 * t2480 - 0.3e1 / 0.2e1 * t737 * t2483 + 0.3e1 / 0.4e1 * t27 * t2486 - 0.3e1 / 0.4e1 * t183 * t1025 - t2493 - 0.3e1 / 0.4e1 * t27 * t2494 + 0.9e1 / 0.4e1 * t737 * t2498 - 0.3e1 / 0.2e1 * t737 * t2502 + 0.25e2 / 0.108e3 * t2151 * t1029 + t2508 + 0.25e2 / 0.108e3 * t2159 * t1029 - 0.25e2 / 0.54e2 * t947 * t2514 - 0.125e3 / 0.162e3 * t947 * t2517;
  t2521 = my_piecewise3(t2, 0, t2520);
  tv3rhotau20 = t7 * t2521 + t1033;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t2526 = 0.25e2 / 0.324e3 * t1720 * t1036;
  t2529 = t874 * t430;
  t2531 = t114 * t2529 / 0.4e1;
  t2534 = t248 * t1043;
  t2536 = t114 * t2534 / 0.4e1;
  t2540 = 0.25e2 / 0.324e3 * t2193 * t1048;
  t2542 = my_piecewise3(t105, 0, -0.25e2 / 0.108e3 * t1716 * t1036 - t2526 + 0.3e1 / 0.4e1 * t245 * t1039 + t2531 - 0.3e1 / 0.4e1 * t245 * t1044 - t2536 + 0.25e2 / 0.108e3 * t2189 * t1048 + t2540);
  tv3rhotau22 = t7 * t2542 + t1052;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t2553 = my_piecewise3(t2, 0, -0.25e2 / 0.108e3 * t1677 * t1017 - t2463 + 0.3e1 / 0.4e1 * t261 * t1020 + t2479 - 0.3e1 / 0.4e1 * t261 * t1025 - t2493 + 0.25e2 / 0.108e3 * t2206 * t1029 + t2508);
  tv3rhotau23 = t7 * t2553 + t1033;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t2558 = params->b2t * t150 * t1035;
  t2562 = t6 * t803 * params->b2t;
  t2563 = t54 * t303;
  t2565 = t145 * t2563 * t314;
  t2570 = t903 * t430;
  t2573 = t2441 * t915;
  t2576 = t418 * t927;
  t2581 = t298 * t1043;
  t2584 = t1042 * t314;
  t2585 = t1802 * t2584;
  t2588 = t429 * t926;
  t2589 = t805 * t2588;
  t2596 = t679 * params->b2b;
  t2597 = t2596 * t144;
  t2598 = t1015 * t314;
  t2599 = t2597 * t2598;
  t2602 = t1047 * t290;
  t2605 = -0.25e2 / 0.108e3 * t1813 * t1036 - t2526 + 0.125e3 / 0.162e3 * t804 * t2558 + 0.25e2 / 0.108e3 * t2562 * t2565 + 0.3e1 / 0.4e1 * t271 * t1039 + t2531 + 0.3e1 / 0.4e1 * t114 * t2570 - 0.3e1 / 0.2e1 * t804 * t2573 + 0.3e1 / 0.4e1 * t114 * t2576 - 0.3e1 / 0.4e1 * t271 * t1044 - t2536 - 0.3e1 / 0.4e1 * t114 * t2581 + 0.9e1 / 0.4e1 * t804 * t2585 - 0.3e1 / 0.2e1 * t804 * t2589 + 0.25e2 / 0.108e3 * t2251 * t1048 + t2540 + 0.25e2 / 0.108e3 * t2255 * t1048 - 0.25e2 / 0.54e2 * t967 * t2599 - 0.125e3 / 0.162e3 * t967 * t2602;
  t2606 = my_piecewise3(t105, 0, t2605);
  tv3rhotau25 = t7 * t2606 + t1052;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2609 = t1015 * t2114 * t344;
  t2612 = t335 * t942;
  t2616 = t6 * t736 * t334;
  t2619 = t941 * t344;
  t2620 = t1151 * t2619;
  t2621 = t82 * t2620;
  t2624 = t507 * t344;
  t2625 = t2624 * params->a2b;
  t2626 = t2625 * t491;
  t2630 = my_piecewise3(t2, 0, t2113 * t2609 / 0.256e3 - 0.9e1 / 0.4e1 * t27 * t2612 + t2616 * t949 / 0.256e3 + 0.9e1 / 0.4e1 * t27 * t2621 - t947 * t2626 / 0.128e3);
  tv3sigma30 = t7 * t2630;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2632 = t1015 * t2220 * t372;
  t2635 = t363 * t962;
  t2639 = t6 * t803 * t362;
  t2642 = t961 * t372;
  t2643 = t1432 * t2642;
  t2644 = t156 * t2643;
  t2647 = t679 * t372;
  t2648 = t2647 * params->a2b;
  t2649 = t2648 * t663;
  t2653 = my_piecewise3(t105, 0, t2219 * t2632 / 0.256e3 - 0.9e1 / 0.4e1 * t114 * t2635 + t2639 * t969 / 0.256e3 + 0.9e1 / 0.4e1 * t114 * t2644 - t967 * t2649 / 0.128e3);
  tv3sigma39 = t7 * t2653;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t2655 = t1015 * t2306 * t344;
  t2658 = t390 * t942;
  t2662 = t6 * t736 * t389;
  t2666 = t1015 * t2114 * t401;
  t2669 = t2127 * t984;
  t2674 = t401 * t941;
  t2675 = t1631 * t2674;
  t2679 = t2343 * t330 * t344;
  t2682 = t507 * t401;
  t2683 = t2682 * params->a2b;
  t2684 = t2683 * t491;
  t2688 = my_piecewise3(t2, 0, 0.5e1 / 0.288e3 * t2305 * t2655 - 0.3e1 / 0.4e1 * t27 * t2658 + t2662 * t949 / 0.768e3 + t2113 * t2666 / 0.768e3 - 0.3e1 / 0.2e1 * t737 * t2669 + 0.5e1 / 0.288e3 * t2616 * t989 + 0.9e1 / 0.4e1 * t737 * t2675 - 0.5e1 / 0.144e3 * t947 * t2679 - t947 * t2684 / 0.384e3);
  tv3sigma2tau0 = t7 * t2688;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t2690 = t1015 * t2418 * t372;
  t2693 = t418 * t962;
  t2697 = t6 * t803 * t417;
  t2701 = t1015 * t2220 * t429;
  t2704 = t2230 * t1004;
  t2709 = t429 * t961;
  t2710 = t1802 * t2709;
  t2714 = t2451 * t358 * t372;
  t2717 = t679 * t429;
  t2718 = t2717 * params->a2b;
  t2719 = t2718 * t663;
  t2723 = my_piecewise3(t105, 0, 0.5e1 / 0.288e3 * t2417 * t2690 - 0.3e1 / 0.4e1 * t114 * t2693 + t2697 * t969 / 0.768e3 + t2219 * t2701 / 0.768e3 - 0.3e1 / 0.2e1 * t804 * t2704 + 0.5e1 / 0.288e3 * t2639 * t1009 + 0.9e1 / 0.4e1 * t804 * t2710 - 0.5e1 / 0.144e3 * t967 * t2714 - t967 * t2719 / 0.384e3);
  tv3sigma2tau11 = t7 * t2723;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t2725 = t69 * t2470 * t344;
  t2729 = t1015 * t2306 * t401;
  t2732 = t2320 * t984;
  t2737 = t335 * t1024;
  t2740 = t1023 * t344;
  t2741 = t1631 * t2740;
  t2744 = t2682 * params->xb;
  t2745 = t2744 * t208;
  t2750 = t1015 * t344;
  t2751 = t2512 * t2750;
  t2755 = my_piecewise3(t2, 0, 0.25e2 / 0.108e3 * t2469 * t2725 + 0.5e1 / 0.288e3 * t2305 * t2729 - 0.3e1 / 0.2e1 * t737 * t2732 + 0.5e1 / 0.288e3 * t2662 * t989 - 0.3e1 / 0.4e1 * t27 * t2737 + 0.9e1 / 0.4e1 * t737 * t2741 - 0.5e1 / 0.144e3 * t947 * t2745 + 0.25e2 / 0.108e3 * t2616 * t1029 - 0.25e2 / 0.54e2 * t947 * t2751);
  tv3sigmatau20 = t7 * t2755;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t2757 = t145 * t2563 * t372;
  t2761 = t1015 * t2418 * t429;
  t2764 = t2441 * t1004;
  t2769 = t363 * t1043;
  t2772 = t1042 * t372;
  t2773 = t1802 * t2772;
  t2776 = t2717 * params->xb;
  t2777 = t2776 * t290;
  t2782 = t1015 * t372;
  t2783 = t2597 * t2782;
  t2787 = my_piecewise3(t105, 0, 0.25e2 / 0.108e3 * t2562 * t2757 + 0.5e1 / 0.288e3 * t2417 * t2761 - 0.3e1 / 0.2e1 * t804 * t2764 + 0.5e1 / 0.288e3 * t2697 * t1009 - 0.3e1 / 0.4e1 * t114 * t2769 + 0.9e1 / 0.4e1 * t804 * t2773 - 0.5e1 / 0.144e3 * t967 * t2777 + 0.25e2 / 0.108e3 * t2639 * t1048 - 0.25e2 / 0.54e2 * t967 * t2783);
  tv3sigmatau28 = t7 * t2787;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t2789 = t69 * t2470 * t401;
  t2792 = t390 * t1024;
  t2797 = t1023 * t401;
  t2798 = t1151 * t2797;
  t2799 = t82 * t2798;
  t2802 = t2682 * params->b2b;
  t2803 = t2802 * t70;
  t2807 = my_piecewise3(t2, 0, 0.25e2 / 0.36e2 * t2469 * t2789 - 0.9e1 / 0.4e1 * t27 * t2792 + 0.25e2 / 0.36e2 * t2662 * t1029 + 0.9e1 / 0.4e1 * t27 * t2799 - 0.25e2 / 0.18e2 * t947 * t2803);
  tv3tau30 = t7 * t2807;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t2809 = t145 * t2563 * t429;
  t2812 = t418 * t1043;
  t2817 = t1042 * t429;
  t2818 = t1432 * t2817;
  t2819 = t156 * t2818;
  t2822 = t2717 * params->b2b;
  t2823 = t2822 * t146;
  t2827 = my_piecewise3(t105, 0, 0.25e2 / 0.36e2 * t2562 * t2809 - 0.9e1 / 0.4e1 * t114 * t2812 + 0.25e2 / 0.36e2 * t2697 * t1048 + 0.9e1 / 0.4e1 * t114 * t2819 - 0.25e2 / 0.18e2 * t967 * t2823);
  tv3tau33 = t7 * t2827;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t40, t41;
  double t44, t46, t48, t51, t52, t54, t55, t56;
  double t57, t58, t60, t61, t64, t65, t66, t68;
  double t69, t70, t73, t74, t76, t78, t81, t82;
  double t83, t86, t89, t92, t95, t96, t99, t100;
  double t101, t104, t105, t106, t108, t109, t110, t111;
  double t113, t114, t115, t116, t117, t118, t120, t121;
  double t124, t126, t128, t131, t132, t133, t134, t136;
  double t137, t140, t141, t142, t144, t145, t146, t150;
  double t152, t155, t156, t159, t164, t169, t170, t171;
  double t174, tzk0;

  double t175, t176, t177, t179, t182, t183, t186, t187;
  double t188, t189, t191, t193, t194, t198, t201, t203;
  double t204, t208, t212, t215, t216, t217, t220, t221;
  double t232, t233, t234, t238, t239, t241, t244, t245;
  double t248, t249, t251, t253, tvrho0, t257, t260, t261;
  double t265, t267, t270, t271, t275, t276, t280, t283;
  double t285, t286, t290, t294, t297, t298, t299, t302;
  double t303, t314, t315, t316, t320, tvrho1, t323, t326;
  double t327, t330, t331, t334, t335, t336, t344, t345;
  double t346, t350, tvsigma0, tvsigma1, t351, t354, t355, t358;
  double t359, t362, t363, t364, t372, t373, t374, t378;
  double tvsigma2, tvlapl0, tvlapl1, t380, t383, t386, t389, t390;
  double t391, t396, t401, t402, t403, t407, tvtau0, t411;
  double t414, t417, t418, t419, t424, t429, t430, t431;
  double t435, tvtau1;

  double t438, t439, t440, t443, t444, t445, t448, t452;
  double t453, t456, t463, t464, t465, t467, t468, t469;
  double t470, t472, t473, t476, t477, t481, t484, t486;
  double t487, t491, t495, t498, t499, t500, t503, t507;
  double t508, t509, t510, t523, t524, t525, t528, t529;
  double t530, t531, t532, t535, t538, t542, t543, t546;
  double t548, t549, t551, t553, tv2rho20, t556, t560, t564;
  double t565, t568, t578, t579, t583, t587, t588, t591;
  double t596, t597, t598, t602, t603, t606, tv2rho21, t611;
  double t616, t620, t621, t626, t627, t632, t636, t637;
  double t648, t649, t653, t656, t658, t659, t663, t667;
  double t670, t671, t672, t675, t679, t680, t681, t682;
  double t695, t696, t697, t700, t701, tv2rho22, t706, t707;
  double t709, t710, t713, t716, t717, t720, t721, t722;
  double t725, t730, t732, t733, t736, t737, t738, t739;
  double t740, t749, t750, t751, t755, tv2rhosigma0, tv2rhosigma1, t759;
  double t760, t762, t765, t767, t769, tv2rhosigma2, t776, tv2rhosigma3;
  double tv2rhosigma4, t780, t783, t786, t787, t790, t791, t792;
  double t795, t800, t803, t804, t805, t806, t807, t816;
  double t817, t818, t822, tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3;
  double t826, t827, t829, t837, t838, t839, t842, t847;
  double t849, t850, t853, t854, t864, t865, t866, t870;
  double tv2rhotau0, t874, t875, t877, t880, t882, t884, tv2rhotau1;
  double t891, tv2rhotau2, t902, t903, t904, t907, t912, t915;
  double t916, t926, t927, t928, t932, tv2rhotau3, t934, t935;
  double t938, t941, t942, t943, t947, t948, t949, t953;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t954, t955, t958;
  double t961, t962, t963, t967, t968, t969, t973, tv2sigma25;
  double tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t975, t978;
  double t981, t984, t985, t988, t989, t993, tv2sigmatau0, tv2sigmatau1;
  double tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t995, t998, t1001, t1004, t1005;
  double t1008, t1009, t1013, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, tv2lapltau3, t1015, t1016, t1017, t1020, t1023;
  double t1024, t1025, t1028, t1029, t1033, tv2tau20, tv2tau21, t1035;
  double t1036, t1039, t1042, t1043, t1044, t1047, t1048, t1052;
  double tv2tau22;

  double t1056, t1057, t1061, t1064, t1066, t1067, t1071, t1075;
  double t1078, t1079, t1080, t1085, t1086, t1087, t1089, t1090;
  double t1091, t1094, t1095, t1098, t1101, t1102, t1103, t1106;
  double t1110, t1111, t1116, t1119, t1120, t1121, t1123, t1124;
  double t1126, t1130, t1131, t1133, t1134, t1141, t1142, t1144;
  double t1145, t1147, t1148, t1150, t1151, t1152, t1153, t1154;
  double t1157, t1160, t1173, t1174, t1175, t1180, t1182, t1183;
  double t1186, t1188, t1190, t1191, t1194, t1197, t1200, t1204;
  double t1205, t1208, t1210, t1212, t1213, t1215, t1217, tv3rho30;
  double t1220, t1221, t1223, t1226, t1229, t1238, t1245, t1248;
  double t1251, t1256, t1257, t1259, t1263, t1264, t1272, t1274;
  double t1275, t1278, t1283, t1285, t1289, t1290, t1294, t1295;
  double t1302, t1303, t1304, t1305, t1310, t1311, t1312, t1314;
  double t1315, tv3rho31, t1318, t1323, t1327, t1331, t1332, t1335;
  double t1345, t1346, t1347, t1352, t1356, t1360, t1361, t1364;
  double t1369, t1373, t1376, t1381, t1382, t1383, t1387, t1388;
  double t1392, t1393, t1397, t1398, t1400, t1402, tv3rho32, t1407;
  double t1414, t1418, t1419, t1425, t1431, t1432, t1433, t1434;
  double t1435, t1440, t1443, t1447, t1448, t1452, t1455, t1457;
  double t1458, t1462, t1466, t1469, t1470, t1471, t1476, t1481;
  double t1489, t1490, t1507, t1508, t1509, t1512, t1519, t1523;
  double t1524, t1527, t1529, tv3rho33, t1533, t1536, t1539, t1541;
  double t1543, t1544, t1545, t1547, t1550, t1559, t1560, t1562;
  double t1563, t1565, t1568, t1569, t1572, t1575, t1576, t1579;
  double t1580, t1581, t1586, t1588, t1589, t1591, t1594, t1595;
  double t1596, t1604, t1605, t1606, t1611, t1612, t1615, t1616;
  double t1617, t1619, t1620, t1623, t1624, t1627, t1628, t1631;
  double t1632, t1633, t1636, t1638, tv3rho2sigma0, tv3rho2sigma1, t1643, t1645;
  double t1646, t1648, t1651, t1653, t1655, t1657, tv3rho2sigma2, t1661;
  double t1672, t1676, t1677, t1686, t1687, tv3rho2sigma3, tv3rho2sigma4, t1691;
  double t1696, t1697, t1698, t1702, t1703, t1707, t1712, t1713;
  double t1715, t1716, t1719, t1720, t1721, t1725, t1726, t1728;
  double t1729, tv3rho2sigma5, t1739, tv3rho2sigma6, tv3rho2sigma7, t1746, t1749, t1752;
  double t1753, t1756, t1757, t1758, t1763, t1772, t1775, t1784;
  double t1785, t1786, t1789, t1792, t1795, t1802, t1803, t1804;
  double t1808, t1809, t1812, t1813, t1816, t1817, t1820, t1821;
  double t1824, t1826, tv3rho2sigma8, tv3rho2lapl0, tv3rho2lapl1, tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4;
  double tv3rho2lapl5, t1836, t1837, t1838, t1845, t1846, t1847, t1849;
  double t1850, t1852, t1853, t1857, t1858, t1860, t1861, t1863;
  double t1866, t1869, t1872, t1874, t1875, t1877, t1880, t1881;
  double t1883, t1886, t1900, t1901, t1902, t1905, t1906, t1911;
  double t1913, t1916, t1917, t1920, t1921, t1924, t1926, tv3rho2tau0;
  double t1931, t1933, t1934, t1936, t1939, t1941, t1943, t1945;
  double tv3rho2tau1, t1949, t1960, t1972, t1973, tv3rho2tau2, t1977, t1982;
  double t1983, t1984, t1988, t1989, t1993, t1998, t1999, t2003;
  double t2007, t2008, t2010, t2011, tv3rho2tau3, t2021, tv3rho2tau4, t2031;
  double t2032, t2033, t2042, t2052, t2053, t2054, t2057, t2062;
  double t2065, t2070, t2075, t2082, t2083, t2086, t2089, t2090;
  double t2093, t2094, t2100, t2102, tv3rho2tau5, t2107, t2108, t2109;
  double t2113, t2114, t2116, t2121, t2123, t2124, t2127, t2128;
  double t2131, t2136, t2138, t2139, t2142, t2143, t2146, t2147;
  double t2151, t2155, t2157, t2159, t2163, t2164, t2165, t2168;
  double t2171, t2172, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t2177;
  double t2180, t2182, t2185, t2187, t2189, t2193, t2195, t2197;
  double tv3rhosigma25, t2206, t2210, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210;
  double t2214, t2215, t2219, t2220, t2222, t2227, t2230, t2231;
  double t2234, t2239, t2242, t2243, t2246, t2247, t2251, t2255;
  double t2259, t2260, t2261, t2264, t2267, t2268, tv3rhosigma211, tv3rhosigmalapl0;
  double tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8;
  double tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t2271, t2272, t2277, t2278, t2281;
  double t2283, t2286, t2289, t2294, t2297, t2300, t2302, t2303;
  double t2305, t2306, t2308, t2316, t2317, t2320, t2321, t2324;
  double t2329, t2332, t2333, t2336, t2337, t2341, t2342, t2343;
  double t2344, t2345, t2348, t2350, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3;
  double tv3rhosigmatau4, t2355, t2358, t2360, t2363, t2365, t2369, t2373;
  double t2375, tv3rhosigmatau5, t2388, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10;
  double t2390, t2395, t2396, t2401, t2404, t2409, t2412, t2415;
  double t2417, t2418, t2420, t2427, t2430, t2433, t2434, t2437;
  double t2438, t2441, t2442, t2445, t2450, t2451, t2452, t2453;
  double t2456, t2458, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22, tv3rholapl23, tv3rholapl24;
  double tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6;
  double tv3rholapltau7, t2463, t2465, t2469, t2470, t2472, t2477, t2479;
  double t2480, t2483, t2486, t2491, t2493, t2494, t2497, t2498;
  double t2501, t2502, t2508, t2511, t2512, t2513, t2514, t2517;
  double t2520, t2521, tv3rhotau20, tv3rhotau21, t2526, t2529, t2531, t2534;
  double t2536, t2540, t2542, tv3rhotau22, t2553, tv3rhotau23, tv3rhotau24, t2558;
  double t2562, t2563, t2565, t2570, t2573, t2576, t2581, t2584;
  double t2585, t2588, t2589, t2596, t2597, t2598, t2599, t2602;
  double t2605, t2606, tv3rhotau25, t2609, t2612, t2616, t2619, t2620;
  double t2621, t2624, t2625, t2626, t2630, tv3sigma30, tv3sigma31, tv3sigma32;
  double tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t2632, t2635;
  double t2639, t2642, t2643, t2644, t2647, t2648, t2649, t2653;
  double tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6;
  double tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11, t2655, t2658, t2662;
  double t2666, t2669, t2674, t2675, t2679, t2682, t2683, t2684;
  double t2688, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6;
  double tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, t2690, t2693, t2697, t2701;
  double t2704, t2709, t2710, t2714, t2717, t2718, t2719, t2723;
  double tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26;
  double tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5;
  double tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, t2725, t2729;
  double t2732, t2737, t2740, t2741, t2744, t2745, t2750, t2751;
  double t2755, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26;
  double tv3sigmatau27, t2757, t2761, t2764, t2769, t2772, t2773, t2776;
  double t2777, t2782, t2783, t2787, tv3sigmatau28, tv3lapl30, tv3lapl31, tv3lapl32;
  double tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20;
  double tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, t2789, t2792, t2797;
  double t2798, t2799, t2802, t2803, t2807, tv3tau30, tv3tau31, tv3tau32;
  double t2809, t2812, t2817, t2818, t2819, t2822, t2823, t2827;
  double tv3tau33;

  double t2831, t2832, t2836, t2839, t2842, t2846, t2850, t2858;
  double t2860, t2862, t2865, t2867, t2869, t2870, t2876, t2882;
  double t2883, t2886, t2890, t2898, t2904, t2908, t2910, t2912;
  double t2916, t2917, t2919, t2923, t2928, t2930, t2939, t2942;
  double t2944, t2946, t2947, t2950, t2953, t2956, t2957, t2977;
  double t2998, t3004, t3006, t3009, t3012, t3014, t3018, t3033;
  double t3036, t3037, t3039, t3040, t3046, t3051, t3054, t3058;
  double t3062, t3064, t3066, t3071, t3073, tv4rho40, t3089, t3090;
  double t3091, t3092, t3094, t3100, t3110, t3117, t3131, t3133;
  double t3134, t3138, t3158, t3159, t3161, t3165, t3171, t3172;
  double t3173, t3177, t3179, t3181, t3184, t3201, t3203, t3207;
  double t3211, t3213, t3214, t3215, t3222, t3224, t3225, t3228;
  double t3232, t3234, t3235, t3237, t3239, t3240, tv4rho41, t3252;
  double t3254, t3264, t3270, t3276, t3286, t3299, t3303, t3318;
  double t3320, t3321, t3323, t3325, t3327, t3329, t3335, t3345;
  double t3358, t3362, t3376, t3379, t3381, t3383, t3385, t3387;
  double t3389, t3391, t3394, t3407, t3409, tv4rho42, t3430, t3434;
  double t3438, t3452, t3453, t3470, t3474, t3494, t3510, t3513;
  double t3515, t3518, t3521, t3524, t3526, t3528, t3530, t3532;
  double t3542, t3546, t3553, t3555, t3557, t3559, t3561, t3564;
  double tv4rho43, t3569, t3574, t3581, t3585, t3593, t3594, t3599;
  double t3606, t3610, t3623, t3624, t3628, t3631, t3634, t3638;
  double t3642, t3657, t3658, t3663, t3664, t3695, t3707, t3745;
  double t3748, tv4rho44, t3756, t3758, t3761, t3764, t3765, t3781;
  double t3783, t3786, t3791, t3796, t3798, t3801, t3804, t3806;
  double t3810, t3816, t3836, t3841, t3844, t3853, t3856, t3858;
  double t3869, t3881, t3883, t3900, t3902, t3903, t3905, t3919;
  double t3920, t3923, t3931, t3938, t3939, t3940, t3944, t3945;
  double t3946, t3948, t3952, t3954, t3959, t3960, t3963, tv4rho3sigma0;
  double tv4rho3sigma1, t3968, t3970, t3975, t3978, t3980, t3984, t3986;
  double tv4rho3sigma2, t3988, t3990, t3993, t3997, t4006, t4007, t4013;
  double t4017, t4019, t4029, t4038, t4054, t4055, t4056, t4059;
  double t4060, t4062, t4076, t4079, tv4rho3sigma3, tv4rho3sigma4, t4081, t4087;
  double t4090, t4095, t4096, t4106, t4108, t4111, t4113, t4116;
  double t4118, t4121, t4122, t4125, t4128, t4129, t4132, t4133;
  double t4135, t4136, t4137, t4138, t4140, t4142, tv4rho3sigma5, t4145;
  double t4157, t4162, t4167, t4168, t4174, t4176, tv4rho3sigma6, tv4rho3sigma7;
  double t4185, t4187, t4191, t4203, t4215, t4217, t4220, t4225;
  double t4227, t4229, t4231, t4233, t4236, t4239, t4242, t4248;
  double t4250, t4252, t4254, t4255, t4256, t4258, t4260, t4270;
  double t4271, t4275, t4278, tv4rho3sigma8, t4290, tv4rho3sigma9, tv4rho3sigma10, t4323;
  double t4326, t4329, t4330, t4340, t4369, t4393, t4394, t4401;
  double t4405, t4420, t4424, t4452, t4455, tv4rho3sigma11, tv4rho3lapl0, tv4rho3lapl1;
  double tv4rho3lapl2, tv4rho3lapl3, tv4rho3lapl4, tv4rho3lapl5, tv4rho3lapl6, tv4rho3lapl7, t4459, t4466;
  double t4471, t4476, t4478, t4480, t4505, t4509, t4534, t4537;
  double t4542, t4545, t4548, t4551, t4553, t4556, t4560, t4561;
  double t4565, t4569, t4574, t4575, t4579, t4608, t4609, t4617;
  double t4628, t4630, t4645, t4647, t4655, t4658, tv4rho3tau0, t4663;
  double t4665, t4670, t4673, t4675, t4679, t4681, tv4rho3tau1, t4683;
  double t4684, t4698, t4702, t4703, t4706, t4717, t4729, t4738;
  double t4744, t4756, t4758, t4764, t4767, t4770, tv4rho3tau2, t4772;
  double t4780, t4781, t4784, t4787, t4793, t4799, t4802, t4803;
  double t4806, t4808, t4811, t4813, t4816, t4818, t4819, t4825;
  double t4827, tv4rho3tau3, t4831, t4839, t4851, t4857, t4859, tv4rho3tau4;
  double t4870, t4872, t4874, t4883, t4886, t4888, t4890, t4892;
  double t4894, t4909, t4922, t4925, t4928, t4930, t4932, t4934;
  double t4936, t4938, t4941, t4944, t4947, t4954, t4957, tv4rho3tau5;
  double t4969, tv4rho3tau6, t5017, t5054, t5105, t5124, t5127, tv4rho3tau7;
  double t5130, t5136, t5137, t5142, t5144, t5146, t5147, t5150;
  double t5154, t5155, t5157, t5167, t5171, t5175, t5178, t5185;
  double t5193, t5195, t5212, t5213, t5224, t5228, t5230, t5235;
  double t5239, t5243, t5247, t5251, t5254, t5270, t5272, t5285;
  double t5303, t5309, t5314, t5315, t5318, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22;
  double tv4rho2sigma23, tv4rho2sigma24, t5323, t5326, t5329, t5333, t5336, t5340;
  double t5342, t5346, t5347, t5350, t5352, t5353, t5354, tv4rho2sigma25;
  double t5357, t5358, t5364, t5368, t5372, t5387, t5389, t5393;
  double t5416, t5418, t5420, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210;
  double t5423, t5427, t5433, t5437, t5438, t5440, t5443, t5444;
  double t5447, t5448, t5457, t5459, t5461, t5469, t5475, t5478;
  double t5480, t5483, t5485, t5491, t5493, t5495, t5502, t5504;
  double tv4rho2sigma211, t5517, t5521, t5522, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215;
  double tv4rho2sigma216, t5527, t5537, t5541, t5545, t5549, t5552, t5566;
  double t5567, t5589, t5606, t5630, t5640, t5674, t5677, tv4rho2sigma217;
  double tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4, tv4rho2sigmalapl5, tv4rho2sigmalapl6, tv4rho2sigmalapl7;
  double tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, tv4rho2sigmalapl11, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15;
  double tv4rho2sigmalapl16, tv4rho2sigmalapl17, t5681, t5682, t5687, t5706, t5707, t5709;
  double t5714, t5718, t5720, t5727, t5733, t5763, t5768, t5779;
  double t5791, t5800, t5802, t5823, t5825, t5827, t5830, t5833;
  double t5836, t5837, t5840, t5842, t5844, t5847, t5852, t5862;
  double t5868, t5885, t5896, t5897, t5905, t5909, tv4rho2sigmatau0, tv4rho2sigmatau1;
  double tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4, t5914, t5917, t5920, t5924, t5927;
  double t5931, t5934, t5937, t5940, t5943, t5944, t5945, tv4rho2sigmatau5;
  double t5954, t5958, t5963, t5967, t5991, t5995, t5997, t6005;
  double t6012, t6023, t6026, tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10;
  double t6036, t6043, t6046, t6048, t6054, t6056, t6061, t6063;
  double t6066, t6067, t6070, t6072, t6074, t6076, t6078, t6080;
  double t6082, t6098, t6101, t6103, t6106, t6110, t6112, t6114;
  double t6116, t6125, t6128, tv4rho2sigmatau11, t6146, t6147, tv4rho2sigmatau12, tv4rho2sigmatau13;
  double tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, t6190, t6197, t6205, t6235, t6247;
  double t6273, t6286, t6288, t6337, t6341, tv4rho2sigmatau17, tv4rho2lapl20, tv4rho2lapl21;
  double tv4rho2lapl22, tv4rho2lapl23, tv4rho2lapl24, tv4rho2lapl25, tv4rho2lapl26, tv4rho2lapl27, tv4rho2lapl28, tv4rho2lapltau0;
  double tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8;
  double tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, t6360, t6370, t6373, t6377, t6378;
  double t6382, t6383, t6384, t6389, t6391, t6396, t6397, t6416;
  double t6421, t6424, t6427, t6428, t6435, t6453, t6455, t6464;
  double t6465, t6474, t6477, t6482, t6497, t6498, t6510, t6512;
  double t6515, tv4rho2tau20, tv4rho2tau21, t6520, t6523, t6526, t6530, t6533;
  double t6537, t6540, t6543, t6544, t6545, tv4rho2tau22, t6557, t6559;
  double t6566, t6572, t6574, t6596, t6603, t6605, tv4rho2tau23, tv4rho2tau24;
  double t6618, t6621, t6623, t6626, t6628, t6633, t6642, t6644;
  double t6645, t6647, t6650, t6651, t6656, t6664, t6666, t6668;
  double t6670, t6672, t6679, t6681, tv4rho2tau25, t6696, t6697, tv4rho2tau26;
  double tv4rho2tau27, t6719, t6732, t6735, t6755, t6769, t6783, t6788;
  double t6807, t6838, t6841, tv4rho2tau28, t6844, t6860, t6863, t6871;
  double t6875, t6881, t6886, t6888, t6890, t6914, t6921, t6927;
  double t6929, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36;
  double tv4rhosigma37, tv4rhosigma38, t6934, t6939, t6941, t6945, t6947, t6952;
  double t6956, t6958, tv4rhosigma39, t6965, t6973, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312;
  double tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t6976, t7005;
  double t7009, t7012, t7038, t7045, t7047, tv4rhosigma319, tv4rhosigma2lapl0, tv4rhosigma2lapl1;
  double tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9;
  double tv4rhosigma2lapl10, tv4rhosigma2lapl11, tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17;
  double tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22, tv4rhosigma2lapl23, t7066, t7068;
  double t7070, t7074, t7080, t7082, t7085, t7091, t7095, t7120;
  double t7135, t7137, t7144, t7151, t7155, t7157, t7174, t7195;
  double t7198, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6;
  double tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, t7203, t7208, t7210, t7214;
  double t7216, t7220, t7224, t7228, t7232, t7236, t7240, t7241;
  double t7242, tv4rhosigma2tau11, t7249, t7264, t7265, tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14;
  double tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22;
  double t7299, t7302, t7304, t7337, t7352, t7358, t7371, t7392;
  double t7395, tv4rhosigma2tau23, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25;
  double tv4rhosigmalapl26, tv4rhosigmalapl27, tv4rhosigmalapl28, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213;
  double tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3;
  double tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11;
  double tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19;
  double tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, t7411, t7435, t7441, t7445;
  double t7449, t7453, t7462, t7483, t7485, t7498, t7508, t7513;
  double t7534, t7537, tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25;
  double tv4rhosigmatau26, tv4rhosigmatau27, t7542, t7546, t7550, t7554, t7559, t7563;
  double t7567, t7571, t7575, t7576, t7577, tv4rhosigmatau28, t7597, t7598;
  double tv4rhosigmatau29, tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216;
  double t7637, t7655, t7685, t7718, t7721, tv4rhosigmatau217, tv4rholapl30, tv4rholapl31;
  double tv4rholapl32, tv4rholapl33, tv4rholapl34, tv4rholapl35, tv4rholapl36, tv4rholapl37, tv4rholapl2tau0, tv4rholapl2tau1;
  double tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8, tv4rholapl2tau9;
  double tv4rholapl2tau10, tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24, tv4rholapltau25;
  double tv4rholapltau26, tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, t7724, t7730;
  double t7743, t7745, t7749, t7758, t7791, t7795, t7797, tv4rhotau30;
  double tv4rhotau31, tv4rhotau32, t7802, t7807, t7811, t7816, t7820, t7822;
  double tv4rhotau33, t7835, tv4rhotau34, tv4rhotau35, tv4rhotau36, t7838, t7862, t7897;
  double t7899, tv4rhotau37, t7905, t7907, t7908, t7911, t7922, t7932;
  double t7939, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46;
  double tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t7946;
  double t7957, t7973, tv4sigma414, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4;
  double tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12;
  double tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, tv4sigma3lapl19, t7975;
  double t7976, t7998, t8010, t8023, t8024, tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2;
  double tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10;
  double tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18;
  double t8036, t8037, t8056, t8068, t8074, t8075, tv4sigma3tau19, tv4sigma2lapl20;
  double tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28;
  double tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216;
  double tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6;
  double tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14;
  double tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22;
  double tv4sigma2lapltau23, t8076, t8079, t8084, t8090, t8107, t8113, t8146;
  double t8147, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26;
  double tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214;
  double tv4sigma2tau215, tv4sigma2tau216, t8153, t8158, t8164, t8177, t8216, t8217;
  double tv4sigma2tau217, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36;
  double tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, tv4sigmalapl311, tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2;
  double tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10;
  double tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15, tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20;
  double tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28;
  double tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216;
  double tv4sigmalapltau217, t8222, t8265, t8266, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33;
  double tv4sigmatau34, tv4sigmatau35, tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, t8271;
  double t8314, t8315, tv4sigmatau311, tv4lapl40, tv4lapl41, tv4lapl42, tv4lapl43, tv4lapl44;
  double tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7;
  double tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27;
  double tv4lapl2tau28, tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36;
  double tv4lapltau37, t8320, t8330, t8339, t8346, tv4tau40, tv4tau41, tv4tau42;
  double tv4tau43, t8351, t8361, t8376, tv4tau44;

  mgga_x_ktbm_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ktbm_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = t6 * t26;
  t28 = POW_1_3(t7);
  t29 = M_CBRT6;
  t30 = params->at * t29;
  t31 = M_PI * M_PI;
  t32 = POW_1_3(t31);
  t33 = t32 * t32;
  t34 = 0.1e1 / t33;
  t35 = t34 * sigma[0];
  t36 = rho[0] * rho[0];
  t37 = POW_1_3(rho[0]);
  t38 = t37 * t37;
  t40 = 0.1e1 / t38 / t36;
  t41 = t35 * t40;
  t44 = params->bt * tau[0];
  t46 = 0.1e1 / t38 / rho[0];
  t48 = t46 * t29 * t34;
  t51 = t29 * t29;
  t52 = params->a2t * t51;
  t54 = 0.1e1 / t32 / t31;
  t55 = sigma[0] * sigma[0];
  t56 = t54 * t55;
  t57 = t36 * t36;
  t58 = t57 * rho[0];
  t60 = 0.1e1 / t37 / t58;
  t61 = t56 * t60;
  t64 = tau[0] * tau[0];
  t65 = params->b2t * t64;
  t66 = t36 * rho[0];
  t68 = 0.1e1 / t37 / t66;
  t69 = t68 * t51;
  t70 = t69 * t54;
  t73 = params->xt * t51;
  t74 = t73 * t54;
  t76 = 0.1e1 / t37 / t57;
  t78 = sigma[0] * t76 * tau[0];
  t81 = params->ct + t30 * t41 / 0.24e2 + 0.5e1 / 0.9e1 * t44 * t48 + t52 * t61 / 0.576e3 + 0.25e2 / 0.81e2 * t65 * t70 + 0.5e1 / 0.216e3 * t74 * t78;
  t82 = t28 * t81;
  t83 = params->ab * t29;
  t86 = params->bb * tau[0];
  t89 = params->a2b * t51;
  t92 = params->b2b * t64;
  t95 = params->xb * t51;
  t96 = t95 * t54;
  t99 = params->cb + t83 * t41 / 0.24e2 + 0.5e1 / 0.9e1 * t86 * t48 + t89 * t61 / 0.576e3 + 0.25e2 / 0.81e2 * t92 * t70 + 0.5e1 / 0.216e3 * t96 * t78;
  t100 = 0.1e1 / t99;
  t101 = t82 * t100;
  t104 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t101);
  t105 = rho[1] <= p->dens_threshold;
  t106 = -t17;
  t108 = my_piecewise5(t15, t12, t11, t16, t106 * t8);
  t109 = 0.1e1 + t108;
  t110 = t109 <= p->zeta_threshold;
  t111 = POW_1_3(t109);
  t113 = my_piecewise3(t110, t23, t111 * t109);
  t114 = t6 * t113;
  t115 = t34 * sigma[2];
  t116 = rho[1] * rho[1];
  t117 = POW_1_3(rho[1]);
  t118 = t117 * t117;
  t120 = 0.1e1 / t118 / t116;
  t121 = t115 * t120;
  t124 = params->bt * tau[1];
  t126 = 0.1e1 / t118 / rho[1];
  t128 = t126 * t29 * t34;
  t131 = sigma[2] * sigma[2];
  t132 = t54 * t131;
  t133 = t116 * t116;
  t134 = t133 * rho[1];
  t136 = 0.1e1 / t117 / t134;
  t137 = t132 * t136;
  t140 = tau[1] * tau[1];
  t141 = params->b2t * t140;
  t142 = t116 * rho[1];
  t144 = 0.1e1 / t117 / t142;
  t145 = t144 * t51;
  t146 = t145 * t54;
  t150 = 0.1e1 / t117 / t133;
  t152 = sigma[2] * t150 * tau[1];
  t155 = params->ct + t30 * t121 / 0.24e2 + 0.5e1 / 0.9e1 * t124 * t128 + t52 * t137 / 0.576e3 + 0.25e2 / 0.81e2 * t141 * t146 + 0.5e1 / 0.216e3 * t74 * t152;
  t156 = t28 * t155;
  t159 = params->bb * tau[1];
  t164 = params->b2b * t140;
  t169 = params->cb + t83 * t121 / 0.24e2 + 0.5e1 / 0.9e1 * t159 * t128 + t89 * t137 / 0.576e3 + 0.25e2 / 0.81e2 * t164 * t146 + 0.5e1 / 0.216e3 * t96 * t152;
  t170 = 0.1e1 / t169;
  t171 = t156 * t170;
  t174 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t171);
  tzk0 = t104 + t174;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t175 = t7 * t7;
  t176 = 0.1e1 / t175;
  t177 = t17 * t176;
  t179 = my_piecewise5(t11, 0, t15, 0, t8 - t177);
  t182 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t179);
  t183 = t6 * t182;
  t186 = t28 * t28;
  t187 = 0.1e1 / t186;
  t188 = t187 * t81;
  t189 = t188 * t100;
  t191 = t27 * t189 / 0.8e1;
  t193 = 0.1e1 / t38 / t66;
  t194 = t35 * t193;
  t198 = t40 * t29 * t34;
  t201 = t57 * t36;
  t203 = 0.1e1 / t37 / t201;
  t204 = t56 * t203;
  t208 = t76 * t51 * t54;
  t212 = sigma[0] * t60 * tau[0];
  t215 = -t30 * t194 / 0.9e1 - 0.25e2 / 0.27e2 * t44 * t198 - t52 * t204 / 0.108e3 - 0.25e3 / 0.243e3 * t65 * t208 - 0.65e2 / 0.648e3 * t74 * t212;
  t216 = t28 * t215;
  t217 = t216 * t100;
  t220 = t99 * t99;
  t221 = 0.1e1 / t220;
  t232 = -t83 * t194 / 0.9e1 - 0.25e2 / 0.27e2 * t86 * t198 - t89 * t204 / 0.108e3 - 0.25e3 / 0.243e3 * t92 * t208 - 0.65e2 / 0.648e3 * t96 * t212;
  t233 = t221 * t232;
  t234 = t82 * t233;
  t238 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t183 * t101 - t191 - 0.3e1 / 0.8e1 * t27 * t217 + 0.3e1 / 0.8e1 * t27 * t234);
  t239 = t106 * t176;
  t241 = my_piecewise5(t15, 0, t11, 0, -t8 - t239);
  t244 = my_piecewise3(t110, 0, 0.4e1 / 0.3e1 * t111 * t241);
  t245 = t6 * t244;
  t248 = t187 * t155;
  t249 = t248 * t170;
  t251 = t114 * t249 / 0.8e1;
  t253 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t245 * t171 - t251);
  tvrho0 = t104 + t174 + t7 * (t238 + t253);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t257 = my_piecewise5(t11, 0, t15, 0, -t8 - t177);
  t260 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t257);
  t261 = t6 * t260;
  t265 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t261 * t101 - t191);
  t267 = my_piecewise5(t15, 0, t11, 0, t8 - t239);
  t270 = my_piecewise3(t110, 0, 0.4e1 / 0.3e1 * t111 * t267);
  t271 = t6 * t270;
  t275 = 0.1e1 / t118 / t142;
  t276 = t115 * t275;
  t280 = t120 * t29 * t34;
  t283 = t133 * t116;
  t285 = 0.1e1 / t117 / t283;
  t286 = t132 * t285;
  t290 = t150 * t51 * t54;
  t294 = sigma[2] * t136 * tau[1];
  t297 = -t30 * t276 / 0.9e1 - 0.25e2 / 0.27e2 * t124 * t280 - t52 * t286 / 0.108e3 - 0.25e3 / 0.243e3 * t141 * t290 - 0.65e2 / 0.648e3 * t74 * t294;
  t298 = t28 * t297;
  t299 = t298 * t170;
  t302 = t169 * t169;
  t303 = 0.1e1 / t302;
  t314 = -t83 * t276 / 0.9e1 - 0.25e2 / 0.27e2 * t159 * t280 - t89 * t286 / 0.108e3 - 0.25e3 / 0.243e3 * t164 * t290 - 0.65e2 / 0.648e3 * t96 * t294;
  t315 = t303 * t314;
  t316 = t156 * t315;
  t320 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t271 * t171 - t251 - 0.3e1 / 0.8e1 * t114 * t299 + 0.3e1 / 0.8e1 * t114 * t316);
  tvrho1 = t104 + t174 + t7 * (t265 + t320);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t323 = t34 * t40;
  t326 = t54 * sigma[0];
  t327 = t326 * t60;
  t330 = t54 * t76;
  t331 = t330 * tau[0];
  t334 = t30 * t323 / 0.24e2 + t52 * t327 / 0.288e3 + 0.5e1 / 0.216e3 * t73 * t331;
  t335 = t28 * t334;
  t336 = t335 * t100;
  t344 = t83 * t323 / 0.24e2 + t89 * t327 / 0.288e3 + 0.5e1 / 0.216e3 * t95 * t331;
  t345 = t221 * t344;
  t346 = t82 * t345;
  t350 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t336 + 0.3e1 / 0.8e1 * t27 * t346);
  tvsigma0 = t7 * t350;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t351 = t34 * t120;
  t354 = t54 * sigma[2];
  t355 = t354 * t136;
  t358 = t54 * t150;
  t359 = t358 * tau[1];
  t362 = t30 * t351 / 0.24e2 + t52 * t355 / 0.288e3 + 0.5e1 / 0.216e3 * t73 * t359;
  t363 = t28 * t362;
  t364 = t363 * t170;
  t372 = t83 * t351 / 0.24e2 + t89 * t355 / 0.288e3 + 0.5e1 / 0.216e3 * t95 * t359;
  t373 = t303 * t372;
  t374 = t156 * t373;
  t378 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t364 + 0.3e1 / 0.8e1 * t114 * t374);
  tvsigma2 = t7 * t378;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t380 = t29 * t34;
  t383 = params->b2t * tau[0];
  t386 = t326 * t76;
  t389 = 0.5e1 / 0.9e1 * params->bt * t46 * t380 + 0.5e2 / 0.81e2 * t383 * t70 + 0.5e1 / 0.216e3 * t73 * t386;
  t390 = t28 * t389;
  t391 = t390 * t100;
  t396 = params->b2b * tau[0];
  t401 = 0.5e1 / 0.9e1 * params->bb * t46 * t380 + 0.5e2 / 0.81e2 * t396 * t70 + 0.5e1 / 0.216e3 * t95 * t386;
  t402 = t221 * t401;
  t403 = t82 * t402;
  t407 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t27 * t391 + 0.3e1 / 0.8e1 * t27 * t403);
  tvtau0 = t7 * t407;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t411 = params->b2t * tau[1];
  t414 = t354 * t150;
  t417 = 0.5e1 / 0.9e1 * params->bt * t126 * t380 + 0.5e2 / 0.81e2 * t411 * t146 + 0.5e1 / 0.216e3 * t73 * t414;
  t418 = t28 * t417;
  t419 = t418 * t170;
  t424 = params->b2b * tau[1];
  t429 = 0.5e1 / 0.9e1 * params->bb * t126 * t380 + 0.5e2 / 0.81e2 * t424 * t146 + 0.5e1 / 0.216e3 * t95 * t414;
  t430 = t303 * t429;
  t431 = t156 * t430;
  t435 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t114 * t419 + 0.3e1 / 0.8e1 * t114 * t431);
  tvtau1 = t7 * t435;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t438 = t24 * t24;
  t439 = 0.1e1 / t438;
  t440 = t179 * t179;
  t443 = t175 * t7;
  t444 = 0.1e1 / t443;
  t445 = t17 * t444;
  t448 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t176 + 0.2e1 * t445);
  t452 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t439 * t440 + 0.4e1 / 0.3e1 * t24 * t448);
  t453 = t6 * t452;
  t456 = t183 * t189;
  t463 = 0.1e1 / t186 / t7;
  t464 = t463 * t81;
  t465 = t464 * t100;
  t467 = t27 * t465 / 0.12e2;
  t468 = t187 * t215;
  t469 = t468 * t100;
  t470 = t27 * t469;
  t472 = t188 * t233;
  t473 = t27 * t472;
  t476 = 0.1e1 / t38 / t57;
  t477 = t35 * t476;
  t481 = t193 * t29 * t34;
  t484 = t57 * t66;
  t486 = 0.1e1 / t37 / t484;
  t487 = t56 * t486;
  t491 = t60 * t51 * t54;
  t495 = sigma[0] * t203 * tau[0];
  t498 = 0.11e2 / 0.27e2 * t30 * t477 + 0.2e3 / 0.81e2 * t44 * t481 + 0.19e2 / 0.324e3 * t52 * t487 + 0.325e4 / 0.729e3 * t65 * t491 + 0.13e3 / 0.243e3 * t74 * t495;
  t499 = t28 * t498;
  t500 = t499 * t100;
  t503 = t216 * t233;
  t507 = 0.1e1 / t220 / t99;
  t508 = t232 * t232;
  t509 = t507 * t508;
  t510 = t82 * t509;
  t523 = 0.11e2 / 0.27e2 * t83 * t477 + 0.2e3 / 0.81e2 * t86 * t481 + 0.19e2 / 0.324e3 * t89 * t487 + 0.325e4 / 0.729e3 * t92 * t491 + 0.13e3 / 0.243e3 * t96 * t495;
  t524 = t221 * t523;
  t525 = t82 * t524;
  t528 = -0.3e1 / 0.8e1 * t453 * t101 - t456 / 0.4e1 - 0.3e1 / 0.4e1 * t183 * t217 + 0.3e1 / 0.4e1 * t183 * t234 + t467 - t470 / 0.4e1 + t473 / 0.4e1 - 0.3e1 / 0.8e1 * t27 * t500 + 0.3e1 / 0.4e1 * t27 * t503 - 0.3e1 / 0.4e1 * t27 * t510 + 0.3e1 / 0.8e1 * t27 * t525;
  t529 = my_piecewise3(t2, 0, t528);
  t530 = t111 * t111;
  t531 = 0.1e1 / t530;
  t532 = t241 * t241;
  t535 = t106 * t444;
  t538 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t176 + 0.2e1 * t535);
  t542 = my_piecewise3(t110, 0, 0.4e1 / 0.9e1 * t531 * t532 + 0.4e1 / 0.3e1 * t111 * t538);
  t543 = t6 * t542;
  t546 = t245 * t249;
  t548 = t463 * t155;
  t549 = t548 * t170;
  t551 = t114 * t549 / 0.12e2;
  t553 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t543 * t171 - t546 / 0.4e1 + t551);
  tv2rho20 = 0.2e1 * t238 + 0.2e1 * t253 + t7 * (t529 + t553);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t556 = t439 * t257;
  t560 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t445);
  t564 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t556 * t179 + 0.4e1 / 0.3e1 * t24 * t560);
  t565 = t6 * t564;
  t568 = t261 * t189;
  t578 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t565 * t101 - t568 / 0.8e1 - 0.3e1 / 0.8e1 * t261 * t217 + 0.3e1 / 0.8e1 * t261 * t234 - t456 / 0.8e1 + t467 - t470 / 0.8e1 + t473 / 0.8e1);
  t579 = t531 * t267;
  t583 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t535);
  t587 = my_piecewise3(t110, 0, 0.4e1 / 0.9e1 * t579 * t241 + 0.4e1 / 0.3e1 * t111 * t583);
  t588 = t6 * t587;
  t591 = t271 * t249;
  t596 = t187 * t297;
  t597 = t596 * t170;
  t598 = t114 * t597;
  t602 = t248 * t315;
  t603 = t114 * t602;
  t606 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t588 * t171 - t591 / 0.8e1 - t546 / 0.8e1 + t551 - 0.3e1 / 0.8e1 * t245 * t299 - t598 / 0.8e1 + 0.3e1 / 0.8e1 * t245 * t316 + t603 / 0.8e1);
  tv2rho21 = t238 + t253 + t265 + t320 + t7 * (t578 + t606);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t611 = t257 * t257;
  t616 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t176 + 0.2e1 * t445);
  t620 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t439 * t611 + 0.4e1 / 0.3e1 * t24 * t616);
  t621 = t6 * t620;
  t626 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t621 * t101 - t568 / 0.4e1 + t467);
  t627 = t267 * t267;
  t632 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t176 + 0.2e1 * t535);
  t636 = my_piecewise3(t110, 0, 0.4e1 / 0.9e1 * t531 * t627 + 0.4e1 / 0.3e1 * t111 * t632);
  t637 = t6 * t636;
  t648 = 0.1e1 / t118 / t133;
  t649 = t115 * t648;
  t653 = t275 * t29 * t34;
  t656 = t133 * t142;
  t658 = 0.1e1 / t117 / t656;
  t659 = t132 * t658;
  t663 = t136 * t51 * t54;
  t667 = sigma[2] * t285 * tau[1];
  t670 = 0.11e2 / 0.27e2 * t30 * t649 + 0.2e3 / 0.81e2 * t124 * t653 + 0.19e2 / 0.324e3 * t52 * t659 + 0.325e4 / 0.729e3 * t141 * t663 + 0.13e3 / 0.243e3 * t74 * t667;
  t671 = t28 * t670;
  t672 = t671 * t170;
  t675 = t298 * t315;
  t679 = 0.1e1 / t302 / t169;
  t680 = t314 * t314;
  t681 = t679 * t680;
  t682 = t156 * t681;
  t695 = 0.11e2 / 0.27e2 * t83 * t649 + 0.2e3 / 0.81e2 * t159 * t653 + 0.19e2 / 0.324e3 * t89 * t659 + 0.325e4 / 0.729e3 * t164 * t663 + 0.13e3 / 0.243e3 * t96 * t667;
  t696 = t303 * t695;
  t697 = t156 * t696;
  t700 = -0.3e1 / 0.8e1 * t637 * t171 - t591 / 0.4e1 - 0.3e1 / 0.4e1 * t271 * t299 + 0.3e1 / 0.4e1 * t271 * t316 + t551 - t598 / 0.4e1 + t603 / 0.4e1 - 0.3e1 / 0.8e1 * t114 * t672 + 0.3e1 / 0.4e1 * t114 * t675 - 0.3e1 / 0.4e1 * t114 * t682 + 0.3e1 / 0.8e1 * t114 * t697;
  t701 = my_piecewise3(t105, 0, t700);
  tv2rho22 = 0.2e1 * t265 + 0.2e1 * t320 + t7 * (t626 + t701);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t706 = t187 * t334;
  t707 = t706 * t100;
  t709 = t27 * t707 / 0.8e1;
  t710 = t34 * t193;
  t713 = t326 * t203;
  t716 = t54 * t60;
  t717 = t716 * tau[0];
  t720 = -t30 * t710 / 0.9e1 - t52 * t713 / 0.54e2 - 0.65e2 / 0.648e3 * t73 * t717;
  t721 = t28 * t720;
  t722 = t721 * t100;
  t725 = t335 * t233;
  t730 = t188 * t345;
  t732 = t27 * t730 / 0.8e1;
  t733 = t216 * t345;
  t736 = t26 * t28;
  t737 = t6 * t736;
  t738 = t81 * t507;
  t739 = t344 * t232;
  t740 = t738 * t739;
  t749 = -t83 * t710 / 0.9e1 - t89 * t713 / 0.54e2 - 0.65e2 / 0.648e3 * t95 * t717;
  t750 = t221 * t749;
  t751 = t82 * t750;
  t755 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t183 * t336 - t709 - 0.3e1 / 0.8e1 * t27 * t722 + 0.3e1 / 0.8e1 * t27 * t725 + 0.3e1 / 0.8e1 * t183 * t346 + t732 + 0.3e1 / 0.8e1 * t27 * t733 - 0.3e1 / 0.4e1 * t737 * t740 + 0.3e1 / 0.8e1 * t27 * t751);
  tv2rhosigma0 = t7 * t755 + t350;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t759 = t187 * t362;
  t760 = t759 * t170;
  t762 = t114 * t760 / 0.8e1;
  t765 = t248 * t373;
  t767 = t114 * t765 / 0.8e1;
  t769 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t245 * t364 - t762 + 0.3e1 / 0.8e1 * t245 * t374 + t767);
  tv2rhosigma2 = t7 * t769 + t378;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t776 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t261 * t336 - t709 + 0.3e1 / 0.8e1 * t261 * t346 + t732);
  tv2rhosigma3 = t7 * t776 + t350;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t780 = t34 * t275;
  t783 = t354 * t285;
  t786 = t54 * t136;
  t787 = t786 * tau[1];
  t790 = -t30 * t780 / 0.9e1 - t52 * t783 / 0.54e2 - 0.65e2 / 0.648e3 * t73 * t787;
  t791 = t28 * t790;
  t792 = t791 * t170;
  t795 = t363 * t315;
  t800 = t298 * t373;
  t803 = t113 * t28;
  t804 = t6 * t803;
  t805 = t155 * t679;
  t806 = t372 * t314;
  t807 = t805 * t806;
  t816 = -t83 * t780 / 0.9e1 - t89 * t783 / 0.54e2 - 0.65e2 / 0.648e3 * t95 * t787;
  t817 = t303 * t816;
  t818 = t156 * t817;
  t822 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t271 * t364 - t762 - 0.3e1 / 0.8e1 * t114 * t792 + 0.3e1 / 0.8e1 * t114 * t795 + 0.3e1 / 0.8e1 * t271 * t374 + t767 + 0.3e1 / 0.8e1 * t114 * t800 - 0.3e1 / 0.4e1 * t804 * t807 + 0.3e1 / 0.8e1 * t114 * t818);
  tv2rhosigma5 = t7 * t822 + t378;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t826 = t187 * t389;
  t827 = t826 * t100;
  t829 = t27 * t827 / 0.8e1;
  t837 = -0.25e2 / 0.27e2 * params->bt * t40 * t380 - 0.5e3 / 0.243e3 * t383 * t208 - 0.65e2 / 0.648e3 * t73 * t327;
  t838 = t28 * t837;
  t839 = t838 * t100;
  t842 = t390 * t233;
  t847 = t188 * t402;
  t849 = t27 * t847 / 0.8e1;
  t850 = t216 * t402;
  t853 = t401 * t232;
  t854 = t738 * t853;
  t864 = -0.25e2 / 0.27e2 * params->bb * t40 * t380 - 0.5e3 / 0.243e3 * t396 * t208 - 0.65e2 / 0.648e3 * t95 * t327;
  t865 = t221 * t864;
  t866 = t82 * t865;
  t870 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t183 * t391 - t829 - 0.3e1 / 0.8e1 * t27 * t839 + 0.3e1 / 0.8e1 * t27 * t842 + 0.3e1 / 0.8e1 * t183 * t403 + t849 + 0.3e1 / 0.8e1 * t27 * t850 - 0.3e1 / 0.4e1 * t737 * t854 + 0.3e1 / 0.8e1 * t27 * t866);
  tv2rhotau0 = t7 * t870 + t407;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t874 = t187 * t417;
  t875 = t874 * t170;
  t877 = t114 * t875 / 0.8e1;
  t880 = t248 * t430;
  t882 = t114 * t880 / 0.8e1;
  t884 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t245 * t419 - t877 + 0.3e1 / 0.8e1 * t245 * t431 + t882);
  tv2rhotau1 = t7 * t884 + t435;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t891 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t261 * t391 - t829 + 0.3e1 / 0.8e1 * t261 * t403 + t849);
  tv2rhotau2 = t7 * t891 + t407;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t902 = -0.25e2 / 0.27e2 * params->bt * t120 * t380 - 0.5e3 / 0.243e3 * t411 * t290 - 0.65e2 / 0.648e3 * t73 * t355;
  t903 = t28 * t902;
  t904 = t903 * t170;
  t907 = t418 * t315;
  t912 = t298 * t430;
  t915 = t429 * t314;
  t916 = t805 * t915;
  t926 = -0.25e2 / 0.27e2 * params->bb * t120 * t380 - 0.5e3 / 0.243e3 * t424 * t290 - 0.65e2 / 0.648e3 * t95 * t355;
  t927 = t303 * t926;
  t928 = t156 * t927;
  t932 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t271 * t419 - t877 - 0.3e1 / 0.8e1 * t114 * t904 + 0.3e1 / 0.8e1 * t114 * t907 + 0.3e1 / 0.8e1 * t271 * t431 + t882 + 0.3e1 / 0.8e1 * t114 * t912 - 0.3e1 / 0.4e1 * t804 * t916 + 0.3e1 / 0.8e1 * t114 * t928);
  tv2rhotau3 = t7 * t932 + t435;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t934 = t716 * t100;
  t935 = t52 * t934;
  t938 = t335 * t345;
  t941 = t344 * t344;
  t942 = t507 * t941;
  t943 = t82 * t942;
  t947 = t6 * t736 * t81;
  t948 = t221 * params->a2b;
  t949 = t948 * t491;
  t953 = my_piecewise3(t2, 0, -t737 * t935 / 0.768e3 + 0.3e1 / 0.4e1 * t27 * t938 - 0.3e1 / 0.4e1 * t27 * t943 + t947 * t949 / 0.768e3);
  tv2sigma20 = t7 * t953;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t954 = t786 * t170;
  t955 = t52 * t954;
  t958 = t363 * t373;
  t961 = t372 * t372;
  t962 = t679 * t961;
  t963 = t156 * t962;
  t967 = t6 * t803 * t155;
  t968 = t303 * params->a2b;
  t969 = t968 * t663;
  t973 = my_piecewise3(t105, 0, -t804 * t955 / 0.768e3 + 0.3e1 / 0.4e1 * t114 * t958 - 0.3e1 / 0.4e1 * t114 * t963 + t967 * t969 / 0.768e3);
  tv2sigma25 = t7 * t973;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t975 = t73 * t330 * t100;
  t978 = t390 * t345;
  t981 = t335 * t402;
  t984 = t401 * t344;
  t985 = t738 * t984;
  t988 = t221 * params->xb;
  t989 = t988 * t208;
  t993 = my_piecewise3(t2, 0, -0.5e1 / 0.576e3 * t737 * t975 + 0.3e1 / 0.8e1 * t27 * t978 + 0.3e1 / 0.8e1 * t27 * t981 - 0.3e1 / 0.4e1 * t737 * t985 + 0.5e1 / 0.576e3 * t947 * t989);
  tv2sigmatau0 = t7 * t993;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t995 = t73 * t358 * t170;
  t998 = t418 * t373;
  t1001 = t363 * t430;
  t1004 = t429 * t372;
  t1005 = t805 * t1004;
  t1008 = t303 * params->xb;
  t1009 = t1008 * t290;
  t1013 = my_piecewise3(t105, 0, -0.5e1 / 0.576e3 * t804 * t995 + 0.3e1 / 0.8e1 * t114 * t998 + 0.3e1 / 0.8e1 * t114 * t1001 - 0.3e1 / 0.4e1 * t804 * t1005 + 0.5e1 / 0.576e3 * t967 * t1009);
  tv2sigmatau5 = t7 * t1013;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1015 = t51 * t54;
  t1016 = t1015 * t100;
  t1017 = params->b2t * t68 * t1016;
  t1020 = t390 * t402;
  t1023 = t401 * t401;
  t1024 = t507 * t1023;
  t1025 = t82 * t1024;
  t1028 = t221 * params->b2b;
  t1029 = t1028 * t70;
  t1033 = my_piecewise3(t2, 0, -0.25e2 / 0.108e3 * t737 * t1017 + 0.3e1 / 0.4e1 * t27 * t1020 - 0.3e1 / 0.4e1 * t27 * t1025 + 0.25e2 / 0.108e3 * t947 * t1029);
  tv2tau20 = t7 * t1033;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1035 = t1015 * t170;
  t1036 = params->b2t * t144 * t1035;
  t1039 = t418 * t430;
  t1042 = t429 * t429;
  t1043 = t679 * t1042;
  t1044 = t156 * t1043;
  t1047 = t303 * params->b2b;
  t1048 = t1047 * t146;
  t1052 = my_piecewise3(t105, 0, -0.25e2 / 0.108e3 * t804 * t1036 + 0.3e1 / 0.4e1 * t114 * t1039 - 0.3e1 / 0.4e1 * t114 * t1044 + 0.25e2 / 0.108e3 * t967 * t1048);
  tv2tau22 = t7 * t1052;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1056 = 0.1e1 / t38 / t58;
  t1057 = t35 * t1056;
  t1061 = t476 * t29 * t34;
  t1064 = t57 * t57;
  t1066 = 0.1e1 / t37 / t1064;
  t1067 = t56 * t1066;
  t1071 = t203 * t51 * t54;
  t1075 = sigma[0] * t486 * tau[0];
  t1078 = -0.154e3 / 0.81e2 * t30 * t1057 - 0.22e4 / 0.243e3 * t44 * t1061 - 0.209e3 / 0.486e3 * t52 * t1067 - 0.52e5 / 0.2187e4 * t65 * t1071 - 0.247e4 / 0.729e3 * t74 * t1075;
  t1079 = t28 * t1078;
  t1080 = t1079 * t100;
  t1085 = t463 * t215;
  t1086 = t1085 * t100;
  t1087 = t27 * t1086;
  t1089 = t187 * t498;
  t1090 = t1089 * t100;
  t1091 = t27 * t1090;
  t1094 = 0.1e1 / t438 / t20;
  t1095 = t440 * t179;
  t1098 = t439 * t179;
  t1101 = t175 * t175;
  t1102 = 0.1e1 / t1101;
  t1103 = t17 * t1102;
  t1106 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t444 - 0.6e1 * t1103);
  t1110 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1094 * t1095 + 0.4e1 / 0.3e1 * t1098 * t448 + 0.4e1 / 0.3e1 * t24 * t1106);
  t1111 = t6 * t1110;
  t1116 = t183 * t469;
  t1119 = 0.1e1 / t186 / t175;
  t1120 = t1119 * t81;
  t1121 = t1120 * t100;
  t1123 = 0.5e1 / 0.36e2 * t27 * t1121;
  t1124 = t183 * t465;
  t1126 = t453 * t189;
  t1130 = t188 * t509;
  t1131 = t27 * t1130;
  t1133 = -0.3e1 / 0.8e1 * t27 * t1080 - 0.9e1 / 0.8e1 * t183 * t500 + t1087 / 0.4e1 - 0.3e1 / 0.8e1 * t1091 - 0.3e1 / 0.8e1 * t1111 * t101 - 0.9e1 / 0.8e1 * t453 * t217 - 0.3e1 / 0.4e1 * t1116 - t1123 + t1124 / 0.4e1 - 0.3e1 / 0.8e1 * t1126 - 0.9e1 / 0.4e1 * t183 * t510 - 0.3e1 / 0.4e1 * t1131;
  t1134 = t216 * t509;
  t1141 = t464 * t233;
  t1142 = t27 * t1141;
  t1144 = t468 * t233;
  t1145 = t27 * t1144;
  t1147 = t188 * t524;
  t1148 = t27 * t1147;
  t1150 = t220 * t220;
  t1151 = 0.1e1 / t1150;
  t1152 = t508 * t232;
  t1153 = t1151 * t1152;
  t1154 = t82 * t1153;
  t1157 = t499 * t233;
  t1160 = t216 * t524;
  t1173 = -0.154e3 / 0.81e2 * t83 * t1057 - 0.22e4 / 0.243e3 * t86 * t1061 - 0.209e3 / 0.486e3 * t89 * t1067 - 0.52e5 / 0.2187e4 * t92 * t1071 - 0.247e4 / 0.729e3 * t96 * t1075;
  t1174 = t221 * t1173;
  t1175 = t82 * t1174;
  t1180 = t183 * t472;
  t1182 = t232 * t523;
  t1183 = t738 * t1182;
  t1186 = -0.9e1 / 0.4e1 * t27 * t1134 + 0.9e1 / 0.4e1 * t183 * t503 + 0.9e1 / 0.8e1 * t183 * t525 - t1142 / 0.4e1 + 0.3e1 / 0.4e1 * t1145 + 0.3e1 / 0.8e1 * t1148 + 0.9e1 / 0.4e1 * t27 * t1154 + 0.9e1 / 0.8e1 * t27 * t1157 + 0.9e1 / 0.8e1 * t27 * t1160 + 0.3e1 / 0.8e1 * t27 * t1175 + 0.9e1 / 0.8e1 * t453 * t234 + 0.3e1 / 0.4e1 * t1180 - 0.9e1 / 0.4e1 * t737 * t1183;
  t1188 = my_piecewise3(t2, 0, t1133 + t1186);
  t1190 = 0.1e1 / t530 / t109;
  t1191 = t532 * t241;
  t1194 = t531 * t241;
  t1197 = t106 * t1102;
  t1200 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t444 - 0.6e1 * t1197);
  t1204 = my_piecewise3(t110, 0, -0.8e1 / 0.27e2 * t1190 * t1191 + 0.4e1 / 0.3e1 * t1194 * t538 + 0.4e1 / 0.3e1 * t111 * t1200);
  t1205 = t6 * t1204;
  t1208 = t543 * t249;
  t1210 = t245 * t549;
  t1212 = t1119 * t155;
  t1213 = t1212 * t170;
  t1215 = 0.5e1 / 0.36e2 * t114 * t1213;
  t1217 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t1205 * t171 - 0.3e1 / 0.8e1 * t1208 + t1210 / 0.4e1 - t1215);
  tv3rho30 = 0.3e1 * t529 + 0.3e1 * t553 + t7 * (t1188 + t1217);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1220 = 0.2e1 * t578;
  t1221 = 0.2e1 * t606;
  t1223 = t565 * t189 / 0.4e1;
  t1226 = t261 * t465;
  t1229 = t261 * t472 / 0.4e1;
  t1238 = -t1223 + 0.3e1 / 0.4e1 * t565 * t234 + t1226 / 0.12e2 + t1229 + 0.3e1 / 0.4e1 * t261 * t503 + 0.3e1 / 0.8e1 * t261 * t525 - t1126 / 0.8e1 + t1124 / 0.6e1 + t1180 / 0.4e1 - t1123 - t1142 / 0.6e1;
  t1245 = t261 * t469 / 0.4e1;
  t1248 = t1094 * t257;
  t1251 = t439 * t560;
  t1256 = 0.2e1 * t444;
  t1257 = 0.6e1 * t1103;
  t1259 = my_piecewise5(t11, 0, t15, 0, t1256 - t1257);
  t1263 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1248 * t440 + 0.8e1 / 0.9e1 * t1251 * t179 + 0.4e1 / 0.9e1 * t556 * t448 + 0.4e1 / 0.3e1 * t24 * t1259);
  t1264 = t6 * t1263;
  t1272 = t1145 / 0.4e1 + t1148 / 0.8e1 - 0.3e1 / 0.4e1 * t261 * t510 - t1131 / 0.4e1 - t1245 - 0.3e1 / 0.8e1 * t261 * t500 - 0.3e1 / 0.8e1 * t1264 * t101 - 0.3e1 / 0.4e1 * t565 * t217 - t1116 / 0.4e1 + t1087 / 0.6e1 - t1091 / 0.8e1;
  t1274 = my_piecewise3(t2, 0, t1238 + t1272);
  t1275 = t1190 * t267;
  t1278 = t531 * t583;
  t1283 = 0.6e1 * t1197;
  t1285 = my_piecewise5(t15, 0, t11, 0, -t1256 - t1283);
  t1289 = my_piecewise3(t110, 0, -0.8e1 / 0.27e2 * t1275 * t532 + 0.8e1 / 0.9e1 * t1278 * t241 + 0.4e1 / 0.9e1 * t579 * t538 + 0.4e1 / 0.3e1 * t111 * t1285);
  t1290 = t6 * t1289;
  t1294 = t588 * t249 / 0.4e1;
  t1295 = t271 * t549;
  t1302 = t245 * t597 / 0.4e1;
  t1303 = t463 * t297;
  t1304 = t1303 * t170;
  t1305 = t114 * t1304;
  t1310 = t245 * t602 / 0.4e1;
  t1311 = t548 * t315;
  t1312 = t114 * t1311;
  t1314 = -0.3e1 / 0.8e1 * t1290 * t171 - t1294 + t1295 / 0.12e2 - t1208 / 0.8e1 + t1210 / 0.6e1 - t1215 - 0.3e1 / 0.8e1 * t543 * t299 - t1302 + t1305 / 0.12e2 + 0.3e1 / 0.8e1 * t543 * t316 + t1310 - t1312 / 0.12e2;
  t1315 = my_piecewise3(t105, 0, t1314);
  tv3rho31 = t529 + t553 + t1220 + t1221 + t7 * (t1274 + t1315);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1318 = t1094 * t611;
  t1323 = t439 * t616;
  t1327 = my_piecewise5(t11, 0, t15, 0, -t1256 - t1257);
  t1331 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1318 * t179 + 0.8e1 / 0.9e1 * t556 * t560 + 0.4e1 / 0.9e1 * t1323 * t179 + 0.4e1 / 0.3e1 * t24 * t1327);
  t1332 = t6 * t1331;
  t1335 = t621 * t189;
  t1345 = -0.3e1 / 0.8e1 * t1332 * t101 - t1335 / 0.8e1 - 0.3e1 / 0.8e1 * t621 * t217 + 0.3e1 / 0.8e1 * t621 * t234 - t1223 + t1226 / 0.6e1 - t1245 + t1229 + t1124 / 0.12e2 - t1123 + t1087 / 0.12e2 - t1142 / 0.12e2;
  t1346 = my_piecewise3(t2, 0, t1345);
  t1347 = t1190 * t627;
  t1352 = t531 * t632;
  t1356 = my_piecewise5(t15, 0, t11, 0, t1256 - t1283);
  t1360 = my_piecewise3(t110, 0, -0.8e1 / 0.27e2 * t1347 * t241 + 0.8e1 / 0.9e1 * t579 * t583 + 0.4e1 / 0.9e1 * t1352 * t241 + 0.4e1 / 0.3e1 * t111 * t1356);
  t1361 = t6 * t1360;
  t1364 = t637 * t249;
  t1369 = t271 * t597;
  t1373 = t271 * t602;
  t1376 = -0.3e1 / 0.8e1 * t1361 * t171 - t1364 / 0.8e1 - t1294 + t1295 / 0.6e1 - 0.3e1 / 0.4e1 * t588 * t299 - t1369 / 0.4e1 + 0.3e1 / 0.4e1 * t588 * t316 + t1373 / 0.4e1 + t1210 / 0.12e2 - t1215 - t1302;
  t1381 = t187 * t670;
  t1382 = t1381 * t170;
  t1383 = t114 * t1382;
  t1387 = t596 * t315;
  t1388 = t114 * t1387;
  t1392 = t248 * t681;
  t1393 = t114 * t1392;
  t1397 = t248 * t696;
  t1398 = t114 * t1397;
  t1400 = t1305 / 0.6e1 + t1310 - t1312 / 0.6e1 - 0.3e1 / 0.8e1 * t245 * t672 - t1383 / 0.8e1 + 0.3e1 / 0.4e1 * t245 * t675 + t1388 / 0.4e1 - 0.3e1 / 0.4e1 * t245 * t682 - t1393 / 0.4e1 + 0.3e1 / 0.8e1 * t245 * t697 + t1398 / 0.8e1;
  t1402 = my_piecewise3(t105, 0, t1376 + t1400);
  tv3rho32 = t1220 + t1221 + t626 + t701 + t7 * (t1346 + t1402);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1407 = t611 * t257;
  t1414 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t444 - 0.6e1 * t1103);
  t1418 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1094 * t1407 + 0.4e1 / 0.3e1 * t556 * t616 + 0.4e1 / 0.3e1 * t24 * t1414);
  t1419 = t6 * t1418;
  t1425 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t1419 * t101 - 0.3e1 / 0.8e1 * t1335 + t1226 / 0.4e1 - t1123);
  t1431 = t302 * t302;
  t1432 = 0.1e1 / t1431;
  t1433 = t680 * t314;
  t1434 = t1432 * t1433;
  t1435 = t156 * t1434;
  t1440 = t298 * t681;
  t1443 = t298 * t696;
  t1447 = 0.1e1 / t118 / t134;
  t1448 = t115 * t1447;
  t1452 = t648 * t29 * t34;
  t1455 = t133 * t133;
  t1457 = 0.1e1 / t117 / t1455;
  t1458 = t132 * t1457;
  t1462 = t285 * t51 * t54;
  t1466 = sigma[2] * t658 * tau[1];
  t1469 = -0.154e3 / 0.81e2 * t83 * t1448 - 0.22e4 / 0.243e3 * t159 * t1452 - 0.209e3 / 0.486e3 * t89 * t1458 - 0.52e5 / 0.2187e4 * t164 * t1462 - 0.247e4 / 0.729e3 * t96 * t1466;
  t1470 = t303 * t1469;
  t1471 = t156 * t1470;
  t1476 = -t1215 - 0.3e1 / 0.8e1 * t1383 - 0.3e1 / 0.4e1 * t1369 - 0.3e1 / 0.8e1 * t1364 + t1305 / 0.4e1 + t1295 / 0.4e1 + 0.9e1 / 0.4e1 * t114 * t1435 - 0.9e1 / 0.4e1 * t271 * t682 - 0.9e1 / 0.4e1 * t114 * t1440 + 0.9e1 / 0.8e1 * t114 * t1443 + 0.3e1 / 0.8e1 * t114 * t1471 + 0.9e1 / 0.8e1 * t637 * t316;
  t1481 = t671 * t315;
  t1489 = t314 * t695;
  t1490 = t805 * t1489;
  t1507 = -0.154e3 / 0.81e2 * t30 * t1448 - 0.22e4 / 0.243e3 * t124 * t1452 - 0.209e3 / 0.486e3 * t52 * t1458 - 0.52e5 / 0.2187e4 * t141 * t1462 - 0.247e4 / 0.729e3 * t74 * t1466;
  t1508 = t28 * t1507;
  t1509 = t1508 * t170;
  t1512 = t627 * t267;
  t1519 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t444 - 0.6e1 * t1197);
  t1523 = my_piecewise3(t110, 0, -0.8e1 / 0.27e2 * t1190 * t1512 + 0.4e1 / 0.3e1 * t579 * t632 + 0.4e1 / 0.3e1 * t111 * t1519);
  t1524 = t6 * t1523;
  t1527 = 0.9e1 / 0.4e1 * t271 * t675 + 0.9e1 / 0.8e1 * t271 * t697 + 0.9e1 / 0.8e1 * t114 * t1481 + 0.3e1 / 0.4e1 * t1388 - 0.3e1 / 0.4e1 * t1393 + 0.3e1 / 0.8e1 * t1398 + 0.3e1 / 0.4e1 * t1373 - t1312 / 0.4e1 - 0.9e1 / 0.4e1 * t804 * t1490 - 0.9e1 / 0.8e1 * t637 * t299 - 0.9e1 / 0.8e1 * t271 * t672 - 0.3e1 / 0.8e1 * t114 * t1509 - 0.3e1 / 0.8e1 * t1524 * t171;
  t1529 = my_piecewise3(t105, 0, t1476 + t1527);
  tv3rho33 = 0.3e1 * t626 + 0.3e1 * t701 + t7 * (t1425 + t1529);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1533 = t216 * t750;
  t1536 = t335 * t509;
  t1539 = t183 * t730;
  t1541 = t464 * t345;
  t1543 = t27 * t1541 / 0.12e2;
  t1544 = t706 * t233;
  t1545 = t27 * t1544;
  t1547 = t721 * t233;
  t1550 = t335 * t524;
  t1559 = t468 * t345;
  t1560 = t27 * t1559;
  t1562 = t188 * t750;
  t1563 = t27 * t1562;
  t1565 = t499 * t345;
  t1568 = 0.3e1 / 0.4e1 * t27 * t1533 - 0.3e1 / 0.4e1 * t27 * t1536 + t1539 / 0.4e1 - t1543 + t1545 / 0.4e1 + 0.3e1 / 0.4e1 * t27 * t1547 + 0.3e1 / 0.8e1 * t27 * t1550 + 0.3e1 / 0.8e1 * t453 * t346 + 0.3e1 / 0.4e1 * t183 * t733 + 0.3e1 / 0.4e1 * t183 * t751 + t1560 / 0.4e1 + t1563 / 0.4e1 + 0.3e1 / 0.8e1 * t27 * t1565;
  t1569 = t34 * t476;
  t1572 = t326 * t486;
  t1575 = t54 * t203;
  t1576 = t1575 * tau[0];
  t1579 = 0.11e2 / 0.27e2 * t83 * t1569 + 0.19e2 / 0.162e3 * t89 * t1572 + 0.13e3 / 0.243e3 * t95 * t1576;
  t1580 = t221 * t1579;
  t1581 = t82 * t1580;
  t1586 = t183 * t707;
  t1588 = t463 * t334;
  t1589 = t1588 * t100;
  t1591 = t27 * t1589 / 0.12e2;
  t1594 = t187 * t720;
  t1595 = t1594 * t100;
  t1596 = t27 * t1595;
  t1604 = 0.11e2 / 0.27e2 * t30 * t1569 + 0.19e2 / 0.162e3 * t52 * t1572 + 0.13e3 / 0.243e3 * t73 * t1576;
  t1605 = t28 * t1604;
  t1606 = t1605 * t100;
  t1611 = t182 * t28;
  t1612 = t6 * t1611;
  t1615 = t26 * t187;
  t1616 = t6 * t1615;
  t1617 = t1616 * t740;
  t1619 = t215 * t507;
  t1620 = t1619 * t739;
  t1623 = t749 * t232;
  t1624 = t738 * t1623;
  t1627 = t344 * t523;
  t1628 = t738 * t1627;
  t1631 = t81 * t1151;
  t1632 = t344 * t508;
  t1633 = t1631 * t1632;
  t1636 = 0.3e1 / 0.8e1 * t27 * t1581 + 0.3e1 / 0.4e1 * t183 * t725 - t1586 / 0.4e1 + t1591 - 0.3e1 / 0.4e1 * t183 * t722 - t1596 / 0.4e1 - 0.3e1 / 0.8e1 * t27 * t1606 - 0.3e1 / 0.8e1 * t453 * t336 - 0.3e1 / 0.2e1 * t1612 * t740 - t1617 / 0.2e1 - 0.3e1 / 0.2e1 * t737 * t1620 - 0.3e1 / 0.2e1 * t737 * t1624 - 0.3e1 / 0.4e1 * t737 * t1628 + 0.9e1 / 0.4e1 * t737 * t1633;
  t1638 = my_piecewise3(t2, 0, t1568 + t1636);
  tv3rho2sigma0 = t7 * t1638 + 0.2e1 * t755;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1643 = t245 * t760;
  t1645 = t463 * t362;
  t1646 = t1645 * t170;
  t1648 = t114 * t1646 / 0.12e2;
  t1651 = t245 * t765;
  t1653 = t548 * t373;
  t1655 = t114 * t1653 / 0.12e2;
  t1657 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t543 * t364 - t1643 / 0.4e1 + t1648 + 0.3e1 / 0.8e1 * t543 * t374 + t1651 / 0.4e1 - t1655);
  tv3rho2sigma2 = t7 * t1657 + 0.2e1 * t769;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1661 = t261 * t707;
  t1672 = t261 * t730;
  t1676 = t260 * t28;
  t1677 = t6 * t1676;
  t1686 = -0.3e1 / 0.8e1 * t565 * t336 - t1661 / 0.8e1 - 0.3e1 / 0.8e1 * t261 * t722 + 0.3e1 / 0.8e1 * t261 * t725 - t1586 / 0.8e1 + t1591 - t1596 / 0.8e1 + t1545 / 0.8e1 + 0.3e1 / 0.8e1 * t565 * t346 + t1672 / 0.8e1 + 0.3e1 / 0.8e1 * t261 * t733 - 0.3e1 / 0.4e1 * t1677 * t740 + 0.3e1 / 0.8e1 * t261 * t751 + t1539 / 0.8e1 - t1543 + t1560 / 0.8e1 - t1617 / 0.4e1 + t1563 / 0.8e1;
  t1687 = my_piecewise3(t2, 0, t1686);
  tv3rho2sigma3 = t7 * t1687 + t755 + t776;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1691 = t271 * t760;
  t1696 = t187 * t790;
  t1697 = t1696 * t170;
  t1698 = t114 * t1697;
  t1702 = t759 * t315;
  t1703 = t114 * t1702;
  t1707 = t271 * t765;
  t1712 = t596 * t373;
  t1713 = t114 * t1712;
  t1715 = t244 * t28;
  t1716 = t6 * t1715;
  t1719 = t113 * t187;
  t1720 = t6 * t1719;
  t1721 = t1720 * t807;
  t1725 = t248 * t817;
  t1726 = t114 * t1725;
  t1728 = -0.3e1 / 0.8e1 * t588 * t364 - t1691 / 0.8e1 - t1643 / 0.8e1 + t1648 - 0.3e1 / 0.8e1 * t245 * t792 - t1698 / 0.8e1 + 0.3e1 / 0.8e1 * t245 * t795 + t1703 / 0.8e1 + 0.3e1 / 0.8e1 * t588 * t374 + t1707 / 0.8e1 + t1651 / 0.8e1 - t1655 + 0.3e1 / 0.8e1 * t245 * t800 + t1713 / 0.8e1 - 0.3e1 / 0.4e1 * t1716 * t807 - t1721 / 0.4e1 + 0.3e1 / 0.8e1 * t245 * t818 + t1726 / 0.8e1;
  t1729 = my_piecewise3(t105, 0, t1728);
  tv3rho2sigma5 = t7 * t1729 + t769 + t822;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1739 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t621 * t336 - t1661 / 0.4e1 + t1591 + 0.3e1 / 0.8e1 * t621 * t346 + t1672 / 0.4e1 - t1543);
  tv3rho2sigma6 = t7 * t1739 + 0.2e1 * t776;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1746 = t34 * t648;
  t1749 = t354 * t658;
  t1752 = t54 * t285;
  t1753 = t1752 * tau[1];
  t1756 = 0.11e2 / 0.27e2 * t30 * t1746 + 0.19e2 / 0.162e3 * t52 * t1749 + 0.13e3 / 0.243e3 * t73 * t1753;
  t1757 = t28 * t1756;
  t1758 = t1757 * t170;
  t1763 = t363 * t696;
  t1772 = t671 * t373;
  t1775 = t298 * t817;
  t1784 = 0.11e2 / 0.27e2 * t83 * t1746 + 0.19e2 / 0.162e3 * t89 * t1749 + 0.13e3 / 0.243e3 * t95 * t1753;
  t1785 = t303 * t1784;
  t1786 = t156 * t1785;
  t1789 = -0.3e1 / 0.8e1 * t637 * t364 - 0.3e1 / 0.4e1 * t271 * t792 - 0.3e1 / 0.8e1 * t114 * t1758 - t1698 / 0.4e1 - t1691 / 0.4e1 + t1648 + 0.3e1 / 0.8e1 * t114 * t1763 + 0.3e1 / 0.8e1 * t637 * t374 + 0.3e1 / 0.4e1 * t271 * t800 + 0.3e1 / 0.4e1 * t271 * t818 + 0.3e1 / 0.8e1 * t114 * t1772 + 0.3e1 / 0.4e1 * t114 * t1775 + 0.3e1 / 0.8e1 * t114 * t1786;
  t1792 = t791 * t315;
  t1795 = t363 * t681;
  t1802 = t155 * t1432;
  t1803 = t372 * t680;
  t1804 = t1802 * t1803;
  t1808 = t372 * t695;
  t1809 = t805 * t1808;
  t1812 = t270 * t28;
  t1813 = t6 * t1812;
  t1816 = t297 * t679;
  t1817 = t1816 * t806;
  t1820 = t816 * t314;
  t1821 = t805 * t1820;
  t1824 = 0.3e1 / 0.4e1 * t271 * t795 + 0.3e1 / 0.4e1 * t114 * t1792 - 0.3e1 / 0.4e1 * t114 * t1795 + t1707 / 0.4e1 + t1713 / 0.4e1 + t1726 / 0.4e1 + t1703 / 0.4e1 - t1655 + 0.9e1 / 0.4e1 * t804 * t1804 - t1721 / 0.2e1 - 0.3e1 / 0.4e1 * t804 * t1809 - 0.3e1 / 0.2e1 * t1813 * t807 - 0.3e1 / 0.2e1 * t804 * t1817 - 0.3e1 / 0.2e1 * t804 * t1821;
  t1826 = my_piecewise3(t105, 0, t1789 + t1824);
  tv3rho2sigma8 = t7 * t1826 + 0.2e1 * t822;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t1836 = 0.2e3 / 0.81e2 * params->bt * t193 * t380 + 0.65e4 / 0.729e3 * t383 * t491 + 0.13e3 / 0.243e3 * t73 * t713;
  t1837 = t28 * t1836;
  t1838 = t1837 * t100;
  t1845 = t187 * t837;
  t1846 = t1845 * t100;
  t1847 = t27 * t1846;
  t1849 = t463 * t389;
  t1850 = t1849 * t100;
  t1852 = t27 * t1850 / 0.12e2;
  t1853 = t183 * t827;
  t1857 = t468 * t402;
  t1858 = t27 * t1857;
  t1860 = t188 * t865;
  t1861 = t27 * t1860;
  t1863 = t499 * t402;
  t1866 = t216 * t865;
  t1869 = t390 * t509;
  t1872 = t183 * t847;
  t1874 = -0.3e1 / 0.8e1 * t27 * t1838 - 0.3e1 / 0.8e1 * t453 * t391 - 0.3e1 / 0.4e1 * t183 * t839 - t1847 / 0.4e1 + t1852 - t1853 / 0.4e1 + 0.3e1 / 0.4e1 * t183 * t866 + t1858 / 0.4e1 + t1861 / 0.4e1 + 0.3e1 / 0.8e1 * t27 * t1863 + 0.3e1 / 0.4e1 * t27 * t1866 - 0.3e1 / 0.4e1 * t27 * t1869 + t1872 / 0.4e1;
  t1875 = t464 * t402;
  t1877 = t27 * t1875 / 0.12e2;
  t1880 = t826 * t233;
  t1881 = t27 * t1880;
  t1883 = t838 * t233;
  t1886 = t390 * t524;
  t1900 = 0.2e3 / 0.81e2 * params->bb * t193 * t380 + 0.65e4 / 0.729e3 * t396 * t491 + 0.13e3 / 0.243e3 * t95 * t713;
  t1901 = t221 * t1900;
  t1902 = t82 * t1901;
  t1905 = t401 * t508;
  t1906 = t1631 * t1905;
  t1911 = t1616 * t854;
  t1913 = t1619 * t853;
  t1916 = t864 * t232;
  t1917 = t738 * t1916;
  t1920 = t401 * t523;
  t1921 = t738 * t1920;
  t1924 = -t1877 + 0.3e1 / 0.4e1 * t183 * t842 + t1881 / 0.4e1 + 0.3e1 / 0.4e1 * t27 * t1883 + 0.3e1 / 0.8e1 * t27 * t1886 + 0.3e1 / 0.8e1 * t453 * t403 + 0.3e1 / 0.4e1 * t183 * t850 + 0.3e1 / 0.8e1 * t27 * t1902 + 0.9e1 / 0.4e1 * t737 * t1906 - 0.3e1 / 0.2e1 * t1612 * t854 - t1911 / 0.2e1 - 0.3e1 / 0.2e1 * t737 * t1913 - 0.3e1 / 0.2e1 * t737 * t1917 - 0.3e1 / 0.4e1 * t737 * t1921;
  t1926 = my_piecewise3(t2, 0, t1874 + t1924);
  tv3rho2tau0 = t7 * t1926 + 0.2e1 * t870;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1931 = t245 * t875;
  t1933 = t463 * t417;
  t1934 = t1933 * t170;
  t1936 = t114 * t1934 / 0.12e2;
  t1939 = t245 * t880;
  t1941 = t548 * t430;
  t1943 = t114 * t1941 / 0.12e2;
  t1945 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t543 * t419 - t1931 / 0.4e1 + t1936 + 0.3e1 / 0.8e1 * t543 * t431 + t1939 / 0.4e1 - t1943);
  tv3rho2tau1 = t7 * t1945 + 0.2e1 * t884;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t1949 = t261 * t827;
  t1960 = t261 * t847;
  t1972 = -0.3e1 / 0.8e1 * t565 * t391 - t1949 / 0.8e1 - 0.3e1 / 0.8e1 * t261 * t839 + 0.3e1 / 0.8e1 * t261 * t842 - t1853 / 0.8e1 + t1852 - t1847 / 0.8e1 + t1881 / 0.8e1 + 0.3e1 / 0.8e1 * t565 * t403 + t1960 / 0.8e1 + 0.3e1 / 0.8e1 * t261 * t850 - 0.3e1 / 0.4e1 * t1677 * t854 + 0.3e1 / 0.8e1 * t261 * t866 + t1872 / 0.8e1 - t1877 + t1858 / 0.8e1 - t1911 / 0.4e1 + t1861 / 0.8e1;
  t1973 = my_piecewise3(t2, 0, t1972);
  tv3rho2tau2 = t7 * t1973 + t870 + t891;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t1977 = t271 * t875;
  t1982 = t187 * t902;
  t1983 = t1982 * t170;
  t1984 = t114 * t1983;
  t1988 = t874 * t315;
  t1989 = t114 * t1988;
  t1993 = t271 * t880;
  t1998 = t596 * t430;
  t1999 = t114 * t1998;
  t2003 = t1720 * t916;
  t2007 = t248 * t927;
  t2008 = t114 * t2007;
  t2010 = -0.3e1 / 0.8e1 * t588 * t419 - t1977 / 0.8e1 - t1931 / 0.8e1 + t1936 - 0.3e1 / 0.8e1 * t245 * t904 - t1984 / 0.8e1 + 0.3e1 / 0.8e1 * t245 * t907 + t1989 / 0.8e1 + 0.3e1 / 0.8e1 * t588 * t431 + t1993 / 0.8e1 + t1939 / 0.8e1 - t1943 + 0.3e1 / 0.8e1 * t245 * t912 + t1999 / 0.8e1 - 0.3e1 / 0.4e1 * t1716 * t916 - t2003 / 0.4e1 + 0.3e1 / 0.8e1 * t245 * t928 + t2008 / 0.8e1;
  t2011 = my_piecewise3(t105, 0, t2010);
  tv3rho2tau3 = t7 * t2011 + t884 + t932;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2021 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t621 * t391 - t1949 / 0.4e1 + t1852 + 0.3e1 / 0.8e1 * t621 * t403 + t1960 / 0.4e1 - t1877);
  tv3rho2tau4 = t7 * t2021 + 0.2e1 * t891;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2031 = 0.2e3 / 0.81e2 * params->bt * t275 * t380 + 0.65e4 / 0.729e3 * t411 * t663 + 0.13e3 / 0.243e3 * t73 * t783;
  t2032 = t28 * t2031;
  t2033 = t2032 * t170;
  t2042 = t298 * t927;
  t2052 = 0.2e3 / 0.81e2 * params->bb * t275 * t380 + 0.65e4 / 0.729e3 * t424 * t663 + 0.13e3 / 0.243e3 * t95 * t783;
  t2053 = t303 * t2052;
  t2054 = t156 * t2053;
  t2057 = t418 * t681;
  t2062 = t903 * t315;
  t2065 = t418 * t696;
  t2070 = -0.3e1 / 0.8e1 * t114 * t2033 - 0.3e1 / 0.8e1 * t637 * t419 - 0.3e1 / 0.4e1 * t271 * t904 + t1936 - t1984 / 0.4e1 - t1977 / 0.4e1 + 0.3e1 / 0.4e1 * t114 * t2042 + 0.3e1 / 0.8e1 * t114 * t2054 - 0.3e1 / 0.4e1 * t114 * t2057 + 0.3e1 / 0.4e1 * t271 * t907 + 0.3e1 / 0.4e1 * t114 * t2062 + 0.3e1 / 0.8e1 * t114 * t2065 + 0.3e1 / 0.8e1 * t637 * t431;
  t2075 = t671 * t430;
  t2082 = t429 * t680;
  t2083 = t1802 * t2082;
  t2086 = t1816 * t915;
  t2089 = t926 * t314;
  t2090 = t805 * t2089;
  t2093 = t429 * t695;
  t2094 = t805 * t2093;
  t2100 = 0.3e1 / 0.4e1 * t271 * t912 + 0.3e1 / 0.4e1 * t271 * t928 + 0.3e1 / 0.8e1 * t114 * t2075 + t1999 / 0.4e1 + t2008 / 0.4e1 + t1989 / 0.4e1 + t1993 / 0.4e1 - t1943 + 0.9e1 / 0.4e1 * t804 * t2083 - 0.3e1 / 0.2e1 * t804 * t2086 - 0.3e1 / 0.2e1 * t804 * t2090 - 0.3e1 / 0.4e1 * t804 * t2094 - 0.3e1 / 0.2e1 * t1813 * t916 - t2003 / 0.2e1;
  t2102 = my_piecewise3(t105, 0, t2070 + t2100);
  tv3rho2tau5 = t7 * t2102 + 0.2e1 * t932;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2107 = t1616 * t935 / 0.2304e4;
  t2108 = t1575 * t100;
  t2109 = t52 * t2108;
  t2113 = t6 * t736 * params->a2t;
  t2114 = t60 * t221;
  t2116 = t1015 * t2114 * t232;
  t2121 = t706 * t345;
  t2123 = t27 * t2121 / 0.4e1;
  t2124 = t721 * t345;
  t2127 = t334 * t507;
  t2128 = t2127 * t739;
  t2131 = t335 * t750;
  t2136 = t188 * t942;
  t2138 = t27 * t2136 / 0.4e1;
  t2139 = t216 * t942;
  t2142 = t941 * t232;
  t2143 = t1631 * t2142;
  t2146 = t344 * t749;
  t2147 = t738 * t2146;
  t2151 = t6 * t1611 * t81;
  t2155 = t6 * t1615 * t81;
  t2157 = t2155 * t949 / 0.2304e4;
  t2159 = t6 * t736 * t215;
  t2163 = t507 * params->a2b * t51;
  t2164 = t716 * t232;
  t2165 = t2163 * t2164;
  t2168 = t948 * t1071;
  t2171 = -t1612 * t935 / 0.768e3 - t2107 + t737 * t2109 / 0.144e3 + t2113 * t2116 / 0.768e3 + 0.3e1 / 0.4e1 * t183 * t938 + t2123 + 0.3e1 / 0.4e1 * t27 * t2124 - 0.3e1 / 0.2e1 * t737 * t2128 + 0.3e1 / 0.4e1 * t27 * t2131 - 0.3e1 / 0.4e1 * t183 * t943 - t2138 - 0.3e1 / 0.4e1 * t27 * t2139 + 0.9e1 / 0.4e1 * t737 * t2143 - 0.3e1 / 0.2e1 * t737 * t2147 + t2151 * t949 / 0.768e3 + t2157 + t2159 * t949 / 0.768e3 - t947 * t2165 / 0.384e3 - t947 * t2168 / 0.144e3;
  t2172 = my_piecewise3(t2, 0, t2171);
  tv3rhosigma20 = t7 * t2172 + t953;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2177 = t1720 * t955 / 0.2304e4;
  t2180 = t759 * t373;
  t2182 = t114 * t2180 / 0.4e1;
  t2185 = t248 * t962;
  t2187 = t114 * t2185 / 0.4e1;
  t2189 = t6 * t1715 * t155;
  t2193 = t6 * t1719 * t155;
  t2195 = t2193 * t969 / 0.2304e4;
  t2197 = my_piecewise3(t105, 0, -t1716 * t955 / 0.768e3 - t2177 + 0.3e1 / 0.4e1 * t245 * t958 + t2182 - 0.3e1 / 0.4e1 * t245 * t963 - t2187 + t2189 * t969 / 0.768e3 + t2195);
  tv3rhosigma25 = t7 * t2197 + t973;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2206 = t6 * t1676 * t81;
  t2210 = my_piecewise3(t2, 0, -t1677 * t935 / 0.768e3 - t2107 + 0.3e1 / 0.4e1 * t261 * t938 + t2123 - 0.3e1 / 0.4e1 * t261 * t943 - t2138 + t2206 * t949 / 0.768e3 + t2157);
  tv3rhosigma26 = t7 * t2210 + t953;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2214 = t1752 * t170;
  t2215 = t52 * t2214;
  t2219 = t6 * t803 * params->a2t;
  t2220 = t136 * t303;
  t2222 = t1015 * t2220 * t314;
  t2227 = t791 * t373;
  t2230 = t362 * t679;
  t2231 = t2230 * t806;
  t2234 = t363 * t817;
  t2239 = t298 * t962;
  t2242 = t961 * t314;
  t2243 = t1802 * t2242;
  t2246 = t372 * t816;
  t2247 = t805 * t2246;
  t2251 = t6 * t1812 * t155;
  t2255 = t6 * t803 * t297;
  t2259 = t679 * params->a2b * t51;
  t2260 = t786 * t314;
  t2261 = t2259 * t2260;
  t2264 = t968 * t1462;
  t2267 = -t1813 * t955 / 0.768e3 - t2177 + t804 * t2215 / 0.144e3 + t2219 * t2222 / 0.768e3 + 0.3e1 / 0.4e1 * t271 * t958 + t2182 + 0.3e1 / 0.4e1 * t114 * t2227 - 0.3e1 / 0.2e1 * t804 * t2231 + 0.3e1 / 0.4e1 * t114 * t2234 - 0.3e1 / 0.4e1 * t271 * t963 - t2187 - 0.3e1 / 0.4e1 * t114 * t2239 + 0.9e1 / 0.4e1 * t804 * t2243 - 0.3e1 / 0.2e1 * t804 * t2247 + t2251 * t969 / 0.768e3 + t2195 + t2255 * t969 / 0.768e3 - t967 * t2261 / 0.384e3 - t967 * t2264 / 0.144e3;
  t2268 = my_piecewise3(t105, 0, t2267);
  tv3rhosigma211 = t7 * t2268 + t973;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t2271 = 0.5e1 / 0.1728e4 * t1616 * t975;
  t2272 = t73 * t934;
  t2277 = t984 * t232;
  t2278 = t1631 * t2277;
  t2281 = t706 * t402;
  t2283 = t27 * t2281 / 0.8e1;
  t2286 = t838 * t345;
  t2289 = t390 * t750;
  t2294 = t721 * t402;
  t2297 = t335 * t865;
  t2300 = t826 * t345;
  t2302 = t27 * t2300 / 0.8e1;
  t2303 = -t2271 + 0.65e2 / 0.1728e4 * t737 * t2272 - 0.5e1 / 0.576e3 * t1612 * t975 + 0.9e1 / 0.4e1 * t737 * t2278 + t2283 + 0.3e1 / 0.8e1 * t183 * t978 + 0.3e1 / 0.8e1 * t27 * t2286 + 0.3e1 / 0.8e1 * t27 * t2289 + 0.3e1 / 0.8e1 * t183 * t981 + 0.3e1 / 0.8e1 * t27 * t2294 + 0.3e1 / 0.8e1 * t27 * t2297 + t2302;
  t2305 = t6 * t736 * params->xt;
  t2306 = t76 * t221;
  t2308 = t1015 * t2306 * t232;
  t2316 = 0.5e1 / 0.1728e4 * t2155 * t989;
  t2317 = t988 * t491;
  t2320 = t389 * t507;
  t2321 = t2320 * t739;
  t2324 = t2127 * t853;
  t2329 = t1619 * t984;
  t2332 = t864 * t344;
  t2333 = t738 * t2332;
  t2336 = t401 * t749;
  t2337 = t738 * t2336;
  t2341 = t1616 * t985 / 0.4e1;
  t2342 = t507 * params->xb;
  t2343 = t2342 * t51;
  t2344 = t330 * t232;
  t2345 = t2343 * t2344;
  t2348 = 0.5e1 / 0.576e3 * t2305 * t2308 + 0.5e1 / 0.576e3 * t2151 * t989 + 0.5e1 / 0.576e3 * t2159 * t989 + t2316 - 0.65e2 / 0.1728e4 * t947 * t2317 - 0.3e1 / 0.4e1 * t737 * t2321 - 0.3e1 / 0.4e1 * t737 * t2324 - 0.3e1 / 0.4e1 * t1612 * t985 - 0.3e1 / 0.4e1 * t737 * t2329 - 0.3e1 / 0.4e1 * t737 * t2333 - 0.3e1 / 0.4e1 * t737 * t2337 - t2341 - 0.5e1 / 0.288e3 * t947 * t2345;
  t2350 = my_piecewise3(t2, 0, t2303 + t2348);
  tv3rhosigmatau0 = t7 * t2350 + t993;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t2355 = 0.5e1 / 0.1728e4 * t1720 * t995;
  t2358 = t874 * t373;
  t2360 = t114 * t2358 / 0.8e1;
  t2363 = t759 * t430;
  t2365 = t114 * t2363 / 0.8e1;
  t2369 = t1720 * t1005 / 0.4e1;
  t2373 = 0.5e1 / 0.1728e4 * t2193 * t1009;
  t2375 = my_piecewise3(t105, 0, -0.5e1 / 0.576e3 * t1716 * t995 - t2355 + 0.3e1 / 0.8e1 * t245 * t998 + t2360 + 0.3e1 / 0.8e1 * t245 * t1001 + t2365 - 0.3e1 / 0.4e1 * t1716 * t1005 - t2369 + 0.5e1 / 0.576e3 * t2189 * t1009 + t2373);
  tv3rhosigmatau5 = t7 * t2375 + t1013;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t2388 = my_piecewise3(t2, 0, -0.5e1 / 0.576e3 * t1677 * t975 - t2271 + 0.3e1 / 0.8e1 * t261 * t978 + t2302 + 0.3e1 / 0.8e1 * t261 * t981 + t2283 - 0.3e1 / 0.4e1 * t1677 * t985 - t2341 + 0.5e1 / 0.576e3 * t2206 * t989 + t2316);
  tv3rhosigmatau6 = t7 * t2388 + t993;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t2390 = t73 * t954;
  t2395 = t1004 * t314;
  t2396 = t1802 * t2395;
  t2401 = t903 * t373;
  t2404 = t418 * t817;
  t2409 = t791 * t430;
  t2412 = t363 * t927;
  t2415 = 0.65e2 / 0.1728e4 * t804 * t2390 - 0.5e1 / 0.576e3 * t1813 * t995 + 0.9e1 / 0.4e1 * t804 * t2396 - t2355 + 0.3e1 / 0.8e1 * t271 * t998 + 0.3e1 / 0.8e1 * t114 * t2401 + 0.3e1 / 0.8e1 * t114 * t2404 + 0.3e1 / 0.8e1 * t271 * t1001 + 0.3e1 / 0.8e1 * t114 * t2409 + 0.3e1 / 0.8e1 * t114 * t2412 + t2360 + t2365;
  t2417 = t6 * t803 * params->xt;
  t2418 = t150 * t303;
  t2420 = t1015 * t2418 * t314;
  t2427 = t1008 * t663;
  t2430 = t1816 * t1004;
  t2433 = t926 * t372;
  t2434 = t805 * t2433;
  t2437 = t429 * t816;
  t2438 = t805 * t2437;
  t2441 = t417 * t679;
  t2442 = t2441 * t806;
  t2445 = t2230 * t915;
  t2450 = t679 * params->xb;
  t2451 = t2450 * t51;
  t2452 = t358 * t314;
  t2453 = t2451 * t2452;
  t2456 = t2373 + 0.5e1 / 0.576e3 * t2417 * t2420 + 0.5e1 / 0.576e3 * t2251 * t1009 + 0.5e1 / 0.576e3 * t2255 * t1009 - 0.65e2 / 0.1728e4 * t967 * t2427 - t2369 - 0.3e1 / 0.4e1 * t804 * t2430 - 0.3e1 / 0.4e1 * t804 * t2434 - 0.3e1 / 0.4e1 * t804 * t2438 - 0.3e1 / 0.4e1 * t804 * t2442 - 0.3e1 / 0.4e1 * t804 * t2445 - 0.3e1 / 0.4e1 * t1813 * t1005 - 0.5e1 / 0.288e3 * t967 * t2453;
  t2458 = my_piecewise3(t105, 0, t2415 + t2456);
  tv3rhosigmatau11 = t7 * t2458 + t1013;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t2463 = 0.25e2 / 0.324e3 * t1616 * t1017;
  t2465 = params->b2t * t76 * t1016;
  t2469 = t6 * t736 * params->b2t;
  t2470 = t54 * t221;
  t2472 = t69 * t2470 * t232;
  t2477 = t826 * t402;
  t2479 = t27 * t2477 / 0.4e1;
  t2480 = t838 * t402;
  t2483 = t2320 * t853;
  t2486 = t390 * t865;
  t2491 = t188 * t1024;
  t2493 = t27 * t2491 / 0.4e1;
  t2494 = t216 * t1024;
  t2497 = t1023 * t232;
  t2498 = t1631 * t2497;
  t2501 = t401 * t864;
  t2502 = t738 * t2501;
  t2508 = 0.25e2 / 0.324e3 * t2155 * t1029;
  t2511 = t507 * params->b2b;
  t2512 = t2511 * t68;
  t2513 = t1015 * t232;
  t2514 = t2512 * t2513;
  t2517 = t1028 * t208;
  t2520 = -0.25e2 / 0.108e3 * t1612 * t1017 - t2463 + 0.125e3 / 0.162e3 * t737 * t2465 + 0.25e2 / 0.108e3 * t2469 * t2472 + 0.3e1 / 0.4e1 * t183 * t1020 + t2479 + 0.3e1 / 0.4e1 * t27 * t2480 - 0.3e1 / 0.2e1 * t737 * t2483 + 0.3e1 / 0.4e1 * t27 * t2486 - 0.3e1 / 0.4e1 * t183 * t1025 - t2493 - 0.3e1 / 0.4e1 * t27 * t2494 + 0.9e1 / 0.4e1 * t737 * t2498 - 0.3e1 / 0.2e1 * t737 * t2502 + 0.25e2 / 0.108e3 * t2151 * t1029 + t2508 + 0.25e2 / 0.108e3 * t2159 * t1029 - 0.25e2 / 0.54e2 * t947 * t2514 - 0.125e3 / 0.162e3 * t947 * t2517;
  t2521 = my_piecewise3(t2, 0, t2520);
  tv3rhotau20 = t7 * t2521 + t1033;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t2526 = 0.25e2 / 0.324e3 * t1720 * t1036;
  t2529 = t874 * t430;
  t2531 = t114 * t2529 / 0.4e1;
  t2534 = t248 * t1043;
  t2536 = t114 * t2534 / 0.4e1;
  t2540 = 0.25e2 / 0.324e3 * t2193 * t1048;
  t2542 = my_piecewise3(t105, 0, -0.25e2 / 0.108e3 * t1716 * t1036 - t2526 + 0.3e1 / 0.4e1 * t245 * t1039 + t2531 - 0.3e1 / 0.4e1 * t245 * t1044 - t2536 + 0.25e2 / 0.108e3 * t2189 * t1048 + t2540);
  tv3rhotau22 = t7 * t2542 + t1052;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t2553 = my_piecewise3(t2, 0, -0.25e2 / 0.108e3 * t1677 * t1017 - t2463 + 0.3e1 / 0.4e1 * t261 * t1020 + t2479 - 0.3e1 / 0.4e1 * t261 * t1025 - t2493 + 0.25e2 / 0.108e3 * t2206 * t1029 + t2508);
  tv3rhotau23 = t7 * t2553 + t1033;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t2558 = params->b2t * t150 * t1035;
  t2562 = t6 * t803 * params->b2t;
  t2563 = t54 * t303;
  t2565 = t145 * t2563 * t314;
  t2570 = t903 * t430;
  t2573 = t2441 * t915;
  t2576 = t418 * t927;
  t2581 = t298 * t1043;
  t2584 = t1042 * t314;
  t2585 = t1802 * t2584;
  t2588 = t429 * t926;
  t2589 = t805 * t2588;
  t2596 = t679 * params->b2b;
  t2597 = t2596 * t144;
  t2598 = t1015 * t314;
  t2599 = t2597 * t2598;
  t2602 = t1047 * t290;
  t2605 = -0.25e2 / 0.108e3 * t1813 * t1036 - t2526 + 0.125e3 / 0.162e3 * t804 * t2558 + 0.25e2 / 0.108e3 * t2562 * t2565 + 0.3e1 / 0.4e1 * t271 * t1039 + t2531 + 0.3e1 / 0.4e1 * t114 * t2570 - 0.3e1 / 0.2e1 * t804 * t2573 + 0.3e1 / 0.4e1 * t114 * t2576 - 0.3e1 / 0.4e1 * t271 * t1044 - t2536 - 0.3e1 / 0.4e1 * t114 * t2581 + 0.9e1 / 0.4e1 * t804 * t2585 - 0.3e1 / 0.2e1 * t804 * t2589 + 0.25e2 / 0.108e3 * t2251 * t1048 + t2540 + 0.25e2 / 0.108e3 * t2255 * t1048 - 0.25e2 / 0.54e2 * t967 * t2599 - 0.125e3 / 0.162e3 * t967 * t2602;
  t2606 = my_piecewise3(t105, 0, t2605);
  tv3rhotau25 = t7 * t2606 + t1052;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2609 = t1015 * t2114 * t344;
  t2612 = t335 * t942;
  t2616 = t6 * t736 * t334;
  t2619 = t941 * t344;
  t2620 = t1151 * t2619;
  t2621 = t82 * t2620;
  t2624 = t507 * t344;
  t2625 = t2624 * params->a2b;
  t2626 = t2625 * t491;
  t2630 = my_piecewise3(t2, 0, t2113 * t2609 / 0.256e3 - 0.9e1 / 0.4e1 * t27 * t2612 + t2616 * t949 / 0.256e3 + 0.9e1 / 0.4e1 * t27 * t2621 - t947 * t2626 / 0.128e3);
  tv3sigma30 = t7 * t2630;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2632 = t1015 * t2220 * t372;
  t2635 = t363 * t962;
  t2639 = t6 * t803 * t362;
  t2642 = t961 * t372;
  t2643 = t1432 * t2642;
  t2644 = t156 * t2643;
  t2647 = t679 * t372;
  t2648 = t2647 * params->a2b;
  t2649 = t2648 * t663;
  t2653 = my_piecewise3(t105, 0, t2219 * t2632 / 0.256e3 - 0.9e1 / 0.4e1 * t114 * t2635 + t2639 * t969 / 0.256e3 + 0.9e1 / 0.4e1 * t114 * t2644 - t967 * t2649 / 0.128e3);
  tv3sigma39 = t7 * t2653;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t2655 = t1015 * t2306 * t344;
  t2658 = t390 * t942;
  t2662 = t6 * t736 * t389;
  t2666 = t1015 * t2114 * t401;
  t2669 = t2127 * t984;
  t2674 = t401 * t941;
  t2675 = t1631 * t2674;
  t2679 = t2343 * t330 * t344;
  t2682 = t507 * t401;
  t2683 = t2682 * params->a2b;
  t2684 = t2683 * t491;
  t2688 = my_piecewise3(t2, 0, 0.5e1 / 0.288e3 * t2305 * t2655 - 0.3e1 / 0.4e1 * t27 * t2658 + t2662 * t949 / 0.768e3 + t2113 * t2666 / 0.768e3 - 0.3e1 / 0.2e1 * t737 * t2669 + 0.5e1 / 0.288e3 * t2616 * t989 + 0.9e1 / 0.4e1 * t737 * t2675 - 0.5e1 / 0.144e3 * t947 * t2679 - t947 * t2684 / 0.384e3);
  tv3sigma2tau0 = t7 * t2688;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t2690 = t1015 * t2418 * t372;
  t2693 = t418 * t962;
  t2697 = t6 * t803 * t417;
  t2701 = t1015 * t2220 * t429;
  t2704 = t2230 * t1004;
  t2709 = t429 * t961;
  t2710 = t1802 * t2709;
  t2714 = t2451 * t358 * t372;
  t2717 = t679 * t429;
  t2718 = t2717 * params->a2b;
  t2719 = t2718 * t663;
  t2723 = my_piecewise3(t105, 0, 0.5e1 / 0.288e3 * t2417 * t2690 - 0.3e1 / 0.4e1 * t114 * t2693 + t2697 * t969 / 0.768e3 + t2219 * t2701 / 0.768e3 - 0.3e1 / 0.2e1 * t804 * t2704 + 0.5e1 / 0.288e3 * t2639 * t1009 + 0.9e1 / 0.4e1 * t804 * t2710 - 0.5e1 / 0.144e3 * t967 * t2714 - t967 * t2719 / 0.384e3);
  tv3sigma2tau11 = t7 * t2723;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t2725 = t69 * t2470 * t344;
  t2729 = t1015 * t2306 * t401;
  t2732 = t2320 * t984;
  t2737 = t335 * t1024;
  t2740 = t1023 * t344;
  t2741 = t1631 * t2740;
  t2744 = t2682 * params->xb;
  t2745 = t2744 * t208;
  t2750 = t1015 * t344;
  t2751 = t2512 * t2750;
  t2755 = my_piecewise3(t2, 0, 0.25e2 / 0.108e3 * t2469 * t2725 + 0.5e1 / 0.288e3 * t2305 * t2729 - 0.3e1 / 0.2e1 * t737 * t2732 + 0.5e1 / 0.288e3 * t2662 * t989 - 0.3e1 / 0.4e1 * t27 * t2737 + 0.9e1 / 0.4e1 * t737 * t2741 - 0.5e1 / 0.144e3 * t947 * t2745 + 0.25e2 / 0.108e3 * t2616 * t1029 - 0.25e2 / 0.54e2 * t947 * t2751);
  tv3sigmatau20 = t7 * t2755;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t2757 = t145 * t2563 * t372;
  t2761 = t1015 * t2418 * t429;
  t2764 = t2441 * t1004;
  t2769 = t363 * t1043;
  t2772 = t1042 * t372;
  t2773 = t1802 * t2772;
  t2776 = t2717 * params->xb;
  t2777 = t2776 * t290;
  t2782 = t1015 * t372;
  t2783 = t2597 * t2782;
  t2787 = my_piecewise3(t105, 0, 0.25e2 / 0.108e3 * t2562 * t2757 + 0.5e1 / 0.288e3 * t2417 * t2761 - 0.3e1 / 0.2e1 * t804 * t2764 + 0.5e1 / 0.288e3 * t2697 * t1009 - 0.3e1 / 0.4e1 * t114 * t2769 + 0.9e1 / 0.4e1 * t804 * t2773 - 0.5e1 / 0.144e3 * t967 * t2777 + 0.25e2 / 0.108e3 * t2639 * t1048 - 0.25e2 / 0.54e2 * t967 * t2783);
  tv3sigmatau28 = t7 * t2787;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t2789 = t69 * t2470 * t401;
  t2792 = t390 * t1024;
  t2797 = t1023 * t401;
  t2798 = t1151 * t2797;
  t2799 = t82 * t2798;
  t2802 = t2682 * params->b2b;
  t2803 = t2802 * t70;
  t2807 = my_piecewise3(t2, 0, 0.25e2 / 0.36e2 * t2469 * t2789 - 0.9e1 / 0.4e1 * t27 * t2792 + 0.25e2 / 0.36e2 * t2662 * t1029 + 0.9e1 / 0.4e1 * t27 * t2799 - 0.25e2 / 0.18e2 * t947 * t2803);
  tv3tau30 = t7 * t2807;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t2809 = t145 * t2563 * t429;
  t2812 = t418 * t1043;
  t2817 = t1042 * t429;
  t2818 = t1432 * t2817;
  t2819 = t156 * t2818;
  t2822 = t2717 * params->b2b;
  t2823 = t2822 * t146;
  t2827 = my_piecewise3(t105, 0, 0.25e2 / 0.36e2 * t2562 * t2809 - 0.9e1 / 0.4e1 * t114 * t2812 + 0.25e2 / 0.36e2 * t2697 * t1048 + 0.9e1 / 0.4e1 * t114 * t2819 - 0.25e2 / 0.18e2 * t967 * t2823);
  tv3tau33 = t7 * t2827;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t2831 = 0.1e1 / t38 / t201;
  t2832 = t35 * t2831;
  t2836 = t1056 * t29 * t34;
  t2839 = t1064 * rho[0];
  t2842 = t56 / t37 / t2839;
  t2846 = t486 * t51 * t54;
  t2850 = sigma[0] * t1066 * tau[0];
  t2858 = t1111 * t189;
  t2860 = t453 * t469;
  t2862 = t183 * t1086;
  t2865 = t27 * t1119 * t215 * t100;
  t2867 = t20 * t20;
  t2869 = 0.1e1 / t438 / t2867;
  t2870 = t440 * t440;
  t2876 = t448 * t448;
  t2882 = 0.1e1 / t1101 / t7;
  t2883 = t17 * t2882;
  t2886 = my_piecewise5(t11, 0, t15, 0, -0.24e2 * t1102 + 0.24e2 * t2883);
  t2890 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t2869 * t2870 - 0.16e2 / 0.9e1 * t1094 * t440 * t448 + 0.4e1 / 0.3e1 * t439 * t2876 + 0.16e2 / 0.9e1 * t1098 * t1106 + 0.4e1 / 0.3e1 * t24 * t2886);
  t2898 = t183 * t1090;
  t2904 = t27 * t463 * t498 * t100;
  t2908 = t27 * t187 * t1078 * t100;
  t2910 = -0.3e1 / 0.8e1 * t27 * t28 * (0.2618e4 / 0.243e3 * t30 * t2832 + 0.308e5 / 0.729e3 * t44 * t2836 + 0.5225e4 / 0.1458e4 * t52 * t2842 + 0.988e6 / 0.6561e4 * t65 * t2846 + 0.5434e5 / 0.2187e4 * t74 * t2850) * t100 - t2858 / 0.2e1 - 0.3e1 / 0.2e1 * t2860 + t2862 - 0.5e1 / 0.9e1 * t2865 - 0.3e1 / 0.8e1 * t6 * t2890 * t101 - 0.3e1 / 0.2e1 * t1111 * t217 - 0.9e1 / 0.4e1 * t453 * t500 - 0.3e1 / 0.2e1 * t2898 - 0.3e1 / 0.2e1 * t183 * t1080 + t2904 / 0.2e1 - t2908 / 0.2e1;
  t2912 = 0.1e1 / t186 / t443;
  t2916 = 0.1e2 / 0.27e2 * t27 * t2912 * t81 * t100;
  t2917 = t453 * t465;
  t2919 = t183 * t1121;
  t2923 = t183 * t1130;
  t2928 = t27 * t1089 * t233;
  t2930 = t523 * t523;
  t2939 = t27 * t468 * t524;
  t2942 = t27 * t188 * t1174;
  t2944 = t183 * t1141;
  t2946 = t27 * t464 * t509;
  t2947 = t2916 + t2917 / 0.2e1 - 0.5e1 / 0.9e1 * t2919 - 0.9e1 / 0.2e1 * t453 * t510 - 0.3e1 * t2923 - 0.9e1 * t183 * t1134 + 0.3e1 / 0.2e1 * t2928 - 0.9e1 / 0.4e1 * t27 * t82 * t507 * t2930 - 0.9e1 / 0.2e1 * t27 * t499 * t509 + 0.3e1 / 0.2e1 * t2939 + t2942 / 0.2e1 - t2944 + t2946;
  t2950 = t27 * t468 * t509;
  t2953 = t27 * t188 * t1153;
  t2956 = 0.1e1 / t1150 / t99;
  t2957 = t508 * t508;
  t2977 = t453 * t472;
  t2998 = -0.3e1 * t2950 + 0.3e1 * t2953 - 0.9e1 * t27 * t82 * t2956 * t2957 + 0.3e1 / 0.8e1 * t27 * t82 * t221 * (0.2618e4 / 0.243e3 * t83 * t2832 + 0.308e5 / 0.729e3 * t86 * t2836 + 0.5225e4 / 0.1458e4 * t89 * t2842 + 0.988e6 / 0.6561e4 * t92 * t2846 + 0.5434e5 / 0.2187e4 * t96 * t2850) + 0.3e1 / 0.2e1 * t2977 + 0.3e1 / 0.2e1 * t1111 * t234 + 0.9e1 / 0.2e1 * t453 * t503 + 0.9e1 / 0.4e1 * t453 * t525 + 0.9e1 * t27 * t216 * t1153 + 0.9e1 / 0.2e1 * t183 * t1157 + 0.3e1 / 0.2e1 * t27 * t1079 * t233 + 0.9e1 / 0.4e1 * t27 * t499 * t524 + 0.9e1 / 0.2e1 * t183 * t1160;
  t3004 = t183 * t1144;
  t3006 = t183 * t1147;
  t3009 = t27 * t1120 * t233;
  t3012 = t27 * t1085 * t233;
  t3014 = t27 * t464 * t524;
  t3018 = t1616 * t1183;
  t3033 = 0.3e1 / 0.2e1 * t27 * t216 * t1174 + 0.3e1 / 0.2e1 * t183 * t1175 + 0.3e1 * t3004 + 0.3e1 / 0.2e1 * t3006 + 0.5e1 / 0.9e1 * t3009 - t3012 - t3014 / 0.2e1 + 0.9e1 * t183 * t1154 - 0.3e1 * t3018 + 0.27e2 / 0.2e1 * t737 * t1631 * t508 * t523 - 0.9e1 * t737 * t1619 * t1182 - 0.3e1 * t737 * t738 * t1173 * t232 - 0.9e1 * t1612 * t1183;
  t3036 = my_piecewise3(t2, 0, t2910 + t2947 + t2998 + t3033);
  t3037 = t109 * t109;
  t3039 = 0.1e1 / t530 / t3037;
  t3040 = t532 * t532;
  t3046 = t538 * t538;
  t3051 = t106 * t2882;
  t3054 = my_piecewise5(t15, 0, t11, 0, 0.24e2 * t1102 + 0.24e2 * t3051);
  t3058 = my_piecewise3(t110, 0, 0.4e2 / 0.81e2 * t3039 * t3040 - 0.16e2 / 0.9e1 * t1190 * t532 * t538 + 0.4e1 / 0.3e1 * t531 * t3046 + 0.16e2 / 0.9e1 * t1194 * t1200 + 0.4e1 / 0.3e1 * t111 * t3054);
  t3062 = t1205 * t249;
  t3064 = t543 * t549;
  t3066 = t245 * t1213;
  t3071 = 0.1e2 / 0.27e2 * t114 * t2912 * t155 * t170;
  t3073 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t6 * t3058 * t171 - t3062 / 0.2e1 + t3064 / 0.2e1 - 0.5e1 / 0.9e1 * t3066 + t3071);
  tv4rho40 = 0.4e1 * t1188 + 0.4e1 * t1217 + t7 * (t3036 + t3073);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t3089 = t261 * t1141;
  t3090 = t3089 / 0.4e1;
  t3091 = -t2858 / 0.8e1 - 0.3e1 / 0.8e1 * t2860 + t2862 / 0.2e1 - 0.5e1 / 0.12e2 * t2865 - 0.3e1 / 0.8e1 * t2898 + t2904 / 0.4e1 - t2908 / 0.8e1 + t2916 + t2917 / 0.4e1 - 0.5e1 / 0.12e2 * t2919 + 0.3e1 / 0.8e1 * t261 * t1175 - t3090;
  t3092 = t261 * t1144;
  t3094 = t261 * t1147;
  t3100 = t565 * t472;
  t3110 = t261 * t1130;
  t3117 = 0.3e1 / 0.4e1 * t3092 + 0.3e1 / 0.8e1 * t3094 + 0.9e1 / 0.8e1 * t261 * t1157 + 0.9e1 / 0.8e1 * t261 * t1160 + 0.3e1 / 0.4e1 * t3100 + 0.9e1 / 0.8e1 * t1264 * t234 + 0.9e1 / 0.4e1 * t565 * t503 + 0.9e1 / 0.8e1 * t565 * t525 - 0.9e1 / 0.4e1 * t565 * t510 - 0.3e1 / 0.4e1 * t3110 - 0.9e1 / 0.4e1 * t261 * t1134 + 0.9e1 / 0.4e1 * t261 * t1154 - 0.3e1 / 0.4e1 * t2923;
  t3131 = 0.3e1 / 0.8e1 * t2928 + 0.3e1 / 0.8e1 * t2939 + t2942 / 0.8e1 - t2944 / 0.2e1 + t2946 / 0.2e1 - 0.3e1 / 0.4e1 * t2950 + 0.3e1 / 0.4e1 * t2953 + 0.3e1 / 0.8e1 * t2977 + 0.3e1 / 0.4e1 * t3004 + 0.3e1 / 0.8e1 * t3006 + 0.5e1 / 0.12e2 * t3009 - t3012 / 0.2e1;
  t3133 = t565 * t465;
  t3134 = t3133 / 0.4e1;
  t3138 = t261 * t1121;
  t3158 = 0.12e2 * t1102;
  t3159 = 0.24e2 * t2883;
  t3161 = my_piecewise5(t11, 0, t15, 0, -t3158 + t3159);
  t3165 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t2869 * t257 * t1095 - 0.8e1 / 0.9e1 * t1094 * t560 * t440 - 0.8e1 / 0.9e1 * t1248 * t179 * t448 + 0.4e1 / 0.3e1 * t439 * t1259 * t179 + 0.4e1 / 0.3e1 * t1251 * t448 + 0.4e1 / 0.9e1 * t556 * t1106 + 0.4e1 / 0.3e1 * t24 * t3161);
  t3171 = t261 * t1086;
  t3172 = t3171 / 0.4e1;
  t3173 = t261 * t1090;
  t3177 = t1264 * t189;
  t3179 = t565 * t469;
  t3181 = -t3014 / 0.4e1 + t3134 - 0.9e1 / 0.4e1 * t1677 * t1183 - 0.3e1 / 0.4e1 * t3018 - 0.5e1 / 0.36e2 * t3138 - 0.3e1 / 0.8e1 * t261 * t1080 - 0.3e1 / 0.8e1 * t6 * t3165 * t101 - 0.9e1 / 0.8e1 * t1264 * t217 + t3172 - 0.3e1 / 0.8e1 * t3173 - 0.9e1 / 0.8e1 * t565 * t500 - 0.3e1 / 0.8e1 * t3177 - 0.3e1 / 0.4e1 * t3179;
  t3184 = my_piecewise3(t2, 0, t3091 + t3117 + t3131 + t3181);
  t3201 = 0.24e2 * t3051;
  t3203 = my_piecewise5(t15, 0, t11, 0, t3158 + t3201);
  t3207 = my_piecewise3(t110, 0, 0.4e2 / 0.81e2 * t3039 * t267 * t1191 - 0.8e1 / 0.9e1 * t1190 * t583 * t532 - 0.8e1 / 0.9e1 * t1275 * t241 * t538 + 0.4e1 / 0.3e1 * t531 * t1285 * t241 + 0.4e1 / 0.3e1 * t1278 * t538 + 0.4e1 / 0.9e1 * t579 * t1200 + 0.4e1 / 0.3e1 * t111 * t3203);
  t3211 = t1290 * t249;
  t3213 = t588 * t549;
  t3214 = t3213 / 0.4e1;
  t3215 = t271 * t1213;
  t3222 = t543 * t597;
  t3224 = t245 * t1304;
  t3225 = t3224 / 0.4e1;
  t3228 = t114 * t1119 * t297 * t170;
  t3232 = t543 * t602;
  t3234 = t245 * t1311;
  t3235 = t3234 / 0.4e1;
  t3237 = t114 * t1212 * t315;
  t3239 = -0.3e1 / 0.8e1 * t6 * t3207 * t171 - 0.3e1 / 0.8e1 * t3211 + t3214 - 0.5e1 / 0.36e2 * t3215 - t3062 / 0.8e1 + t3064 / 0.4e1 - 0.5e1 / 0.12e2 * t3066 + t3071 - 0.3e1 / 0.8e1 * t1205 * t299 - 0.3e1 / 0.8e1 * t3222 + t3225 - 0.5e1 / 0.36e2 * t3228 + 0.3e1 / 0.8e1 * t1205 * t316 + 0.3e1 / 0.8e1 * t3232 - t3235 + 0.5e1 / 0.36e2 * t3237;
  t3240 = my_piecewise3(t105, 0, t3239);
  tv4rho41 = t1188 + t1217 + 0.3e1 * t1274 + 0.3e1 * t1315 + t7 * (t3184 + t3240);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t3252 = t621 * t465;
  t3254 = t1332 * t189;
  t3264 = t621 * t472;
  t3270 = t2862 / 0.6e1 - 0.5e1 / 0.18e2 * t2865 + t2904 / 0.12e2 + t2916 + t2917 / 0.12e2 - 0.5e1 / 0.18e2 * t2919 + t3252 / 0.12e2 - t3254 / 0.4e1 - 0.3e1 / 0.8e1 * t621 * t500 + 0.3e1 / 0.4e1 * t621 * t503 + 0.3e1 / 0.8e1 * t621 * t525 + 0.3e1 / 0.4e1 * t1332 * t234 + t3264 / 0.4e1 - 0.3e1 / 0.4e1 * t621 * t510 - t3089 / 0.3e1 + t3092 / 0.2e1;
  t3276 = t621 * t469;
  t3286 = t560 * t560;
  t3299 = my_piecewise5(t11, 0, t15, 0, t3159);
  t3303 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t2869 * t611 * t440 - 0.32e2 / 0.27e2 * t1248 * t179 * t560 - 0.8e1 / 0.27e2 * t1318 * t448 + 0.8e1 / 0.9e1 * t439 * t3286 + 0.8e1 / 0.9e1 * t556 * t1259 - 0.8e1 / 0.27e2 * t1094 * t616 * t440 + 0.8e1 / 0.9e1 * t439 * t1327 * t179 + 0.4e1 / 0.9e1 * t1323 * t448 + 0.4e1 / 0.3e1 * t24 * t3299);
  t3318 = t3094 / 0.4e1 + t3100 / 0.2e1 - t3110 / 0.2e1 - 0.3e1 / 0.4e1 * t1332 * t217 - t3276 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t3303 * t101 - t2944 / 0.6e1 + t2946 / 0.6e1 + 0.5e1 / 0.18e2 * t3009 - t3012 / 0.6e1 - t3014 / 0.12e2 + t3133 / 0.3e1 - 0.5e1 / 0.18e2 * t3138 + t3171 / 0.3e1 - t3173 / 0.4e1 - t3177 / 0.4e1 - t3179 / 0.2e1;
  t3320 = my_piecewise3(t2, 0, t3270 + t3318);
  t3321 = t245 * t1382;
  t3323 = t588 * t597;
  t3325 = t271 * t1304;
  t3327 = t1361 * t249;
  t3329 = t637 * t549;
  t3335 = t114 * t463 * t670 * t170;
  t3345 = t583 * t583;
  t3358 = my_piecewise5(t15, 0, t11, 0, t3201);
  t3362 = my_piecewise3(t110, 0, 0.4e2 / 0.81e2 * t3039 * t627 * t532 - 0.32e2 / 0.27e2 * t1275 * t241 * t583 - 0.8e1 / 0.27e2 * t1347 * t538 + 0.8e1 / 0.9e1 * t531 * t3345 + 0.8e1 / 0.9e1 * t579 * t1285 - 0.8e1 / 0.27e2 * t1190 * t632 * t532 + 0.8e1 / 0.9e1 * t531 * t1356 * t241 + 0.4e1 / 0.9e1 * t1352 * t538 + 0.4e1 / 0.3e1 * t111 * t3358);
  t3376 = t245 * t1392;
  t3379 = t114 * t548 * t681;
  t3381 = t245 * t1397;
  t3383 = -t3321 / 0.4e1 - t3323 / 0.2e1 + t3325 / 0.6e1 - t3327 / 0.4e1 + t3329 / 0.12e2 - 0.3e1 / 0.8e1 * t543 * t672 + t3335 / 0.12e2 - 0.3e1 / 0.8e1 * t6 * t3362 * t171 - 0.3e1 / 0.4e1 * t1290 * t299 + 0.3e1 / 0.4e1 * t1290 * t316 + 0.3e1 / 0.4e1 * t543 * t675 - 0.3e1 / 0.4e1 * t543 * t682 + 0.3e1 / 0.8e1 * t543 * t697 - t3376 / 0.2e1 + t3379 / 0.6e1 + t3381 / 0.4e1;
  t3385 = t114 * t548 * t696;
  t3387 = t588 * t602;
  t3389 = t271 * t1311;
  t3391 = t245 * t1387;
  t3394 = t114 * t1303 * t315;
  t3407 = -t3385 / 0.12e2 + t3387 / 0.2e1 - t3389 / 0.6e1 + t3391 / 0.2e1 - t3394 / 0.6e1 + t3232 / 0.4e1 - t3234 / 0.3e1 + 0.5e1 / 0.18e2 * t3237 + t3224 / 0.3e1 - 0.5e1 / 0.18e2 * t3228 - t3222 / 0.4e1 - 0.5e1 / 0.18e2 * t3215 - t3211 / 0.4e1 + t3213 / 0.3e1 - 0.5e1 / 0.18e2 * t3066 + t3071 + t3064 / 0.12e2;
  t3409 = my_piecewise3(t105, 0, t3383 + t3407);
  tv4rho42 = 0.2e1 * t1274 + 0.2e1 * t1315 + 0.2e1 * t1346 + 0.2e1 * t1402 + t7 * (t3320 + t3409);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t3430 = my_piecewise5(t11, 0, t15, 0, t3158 + t3159);
  t3434 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t2869 * t1407 * t179 - 0.8e1 / 0.9e1 * t1318 * t560 - 0.8e1 / 0.9e1 * t1248 * t616 * t179 + 0.4e1 / 0.3e1 * t1251 * t616 + 0.4e1 / 0.3e1 * t556 * t1327 + 0.4e1 / 0.9e1 * t439 * t1414 * t179 + 0.4e1 / 0.3e1 * t24 * t3430);
  t3438 = t1419 * t189;
  t3452 = -0.3e1 / 0.8e1 * t6 * t3434 * t101 - t3438 / 0.8e1 - 0.3e1 / 0.8e1 * t1419 * t217 + 0.3e1 / 0.8e1 * t1419 * t234 - 0.3e1 / 0.8e1 * t3254 + t3252 / 0.4e1 - 0.3e1 / 0.8e1 * t3276 + 0.3e1 / 0.8e1 * t3264 + t3134 - 0.5e1 / 0.12e2 * t3138 + t3172 - t3090 - 0.5e1 / 0.36e2 * t2919 + t2916 - 0.5e1 / 0.36e2 * t2865 + 0.5e1 / 0.36e2 * t3009;
  t3453 = my_piecewise3(t2, 0, t3452);
  t3470 = my_piecewise5(t15, 0, t11, 0, -t3158 + t3201);
  t3474 = my_piecewise3(t110, 0, 0.4e2 / 0.81e2 * t3039 * t1512 * t241 - 0.8e1 / 0.9e1 * t1347 * t583 - 0.8e1 / 0.9e1 * t1275 * t632 * t241 + 0.4e1 / 0.3e1 * t1278 * t632 + 0.4e1 / 0.3e1 * t579 * t1356 + 0.4e1 / 0.9e1 * t531 * t1519 * t241 + 0.4e1 / 0.3e1 * t111 * t3470);
  t3494 = -0.3e1 / 0.8e1 * t6 * t3474 * t171 - 0.9e1 / 0.8e1 * t1361 * t299 - 0.9e1 / 0.8e1 * t588 * t672 - 0.3e1 / 0.8e1 * t245 * t1509 - 0.3e1 / 0.8e1 * t3321 - 0.3e1 / 0.4e1 * t3323 + t3325 / 0.2e1 - 0.3e1 / 0.8e1 * t3327 + t3329 / 0.4e1 + t3335 / 0.4e1 - 0.9e1 / 0.4e1 * t245 * t1440 + 0.9e1 / 0.8e1 * t245 * t1481;
  t3510 = t114 * t248 * t1470;
  t3513 = t114 * t248 * t1434;
  t3515 = t271 * t1392;
  t3518 = t114 * t1381 * t315;
  t3521 = t114 * t596 * t696;
  t3524 = t114 * t596 * t681;
  t3526 = 0.9e1 / 0.8e1 * t245 * t1443 + 0.3e1 / 0.8e1 * t245 * t1471 + 0.9e1 / 0.8e1 * t1361 * t316 + 0.9e1 / 0.4e1 * t588 * t675 + 0.9e1 / 0.8e1 * t588 * t697 + 0.9e1 / 0.4e1 * t245 * t1435 - 0.9e1 / 0.4e1 * t588 * t682 + t3510 / 0.8e1 + 0.3e1 / 0.4e1 * t3513 - 0.3e1 / 0.4e1 * t3515 + 0.3e1 / 0.8e1 * t3518 + 0.3e1 / 0.8e1 * t3521 - 0.3e1 / 0.4e1 * t3524;
  t3528 = t637 * t602;
  t3530 = t271 * t1387;
  t3532 = t271 * t1397;
  t3542 = 0.3e1 / 0.8e1 * t3528 + 0.3e1 / 0.4e1 * t3530 + 0.3e1 / 0.8e1 * t3532 - 0.3e1 / 0.4e1 * t3376 + t3379 / 0.2e1 + 0.3e1 / 0.8e1 * t3381 - t3385 / 0.4e1 + 0.3e1 / 0.4e1 * t3387 - t3389 / 0.2e1 + 0.3e1 / 0.4e1 * t3391 - t3394 / 0.2e1 - t3235;
  t3546 = t1720 * t1490;
  t3553 = t114 * t187 * t1507 * t170;
  t3555 = t1524 * t249;
  t3557 = t637 * t597;
  t3559 = t271 * t1382;
  t3561 = 0.5e1 / 0.12e2 * t3237 + t3225 - 0.5e1 / 0.12e2 * t3228 - 0.5e1 / 0.12e2 * t3215 + t3214 - 0.3e1 / 0.4e1 * t3546 - 0.9e1 / 0.4e1 * t1716 * t1490 - 0.5e1 / 0.36e2 * t3066 + t3071 - t3553 / 0.8e1 - t3555 / 0.8e1 - 0.3e1 / 0.8e1 * t3557 - 0.3e1 / 0.8e1 * t3559;
  t3564 = my_piecewise3(t105, 0, t3494 + t3526 + t3542 + t3561);
  tv4rho43 = 0.3e1 * t1346 + 0.3e1 * t1402 + t1425 + t1529 + t7 * (t3453 + t3564);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t3569 = t611 * t611;
  t3574 = t616 * t616;
  t3581 = my_piecewise5(t11, 0, t15, 0, 0.24e2 * t1102 + 0.24e2 * t2883);
  t3585 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t2869 * t3569 - 0.16e2 / 0.9e1 * t1318 * t616 + 0.4e1 / 0.3e1 * t439 * t3574 + 0.16e2 / 0.9e1 * t556 * t1414 + 0.4e1 / 0.3e1 * t24 * t3581);
  t3593 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t3585 * t101 - t3438 / 0.2e1 + t3252 / 0.2e1 - 0.5e1 / 0.9e1 * t3138 + t2916);
  t3594 = t627 * t627;
  t3599 = t632 * t632;
  t3606 = my_piecewise5(t15, 0, t11, 0, -0.24e2 * t1102 + 0.24e2 * t3051);
  t3610 = my_piecewise3(t110, 0, 0.4e2 / 0.81e2 * t3039 * t3594 - 0.16e2 / 0.9e1 * t1347 * t632 + 0.4e1 / 0.3e1 * t531 * t3599 + 0.16e2 / 0.9e1 * t579 * t1519 + 0.4e1 / 0.3e1 * t111 * t3606);
  t3623 = 0.1e1 / t118 / t283;
  t3624 = t115 * t3623;
  t3628 = t1447 * t29 * t34;
  t3631 = t1455 * rho[1];
  t3634 = t132 / t117 / t3631;
  t3638 = t658 * t51 * t54;
  t3642 = sigma[2] * t1457 * tau[1];
  t3657 = 0.1e1 / t1431 / t169;
  t3658 = t680 * t680;
  t3663 = -0.3e1 / 0.8e1 * t6 * t3610 * t171 - 0.3e1 / 0.2e1 * t1524 * t299 + t3325 + t3329 / 0.2e1 + t3335 / 0.2e1 - 0.9e1 / 0.2e1 * t637 * t682 - 0.9e1 * t271 * t1440 + 0.3e1 / 0.8e1 * t114 * t156 * t303 * (0.2618e4 / 0.243e3 * t83 * t3624 + 0.308e5 / 0.729e3 * t159 * t3628 + 0.5225e4 / 0.1458e4 * t89 * t3634 + 0.988e6 / 0.6561e4 * t164 * t3638 + 0.5434e5 / 0.2187e4 * t96 * t3642) + 0.9e1 / 0.4e1 * t637 * t697 + 0.3e1 / 0.2e1 * t1524 * t316 + 0.9e1 / 0.2e1 * t637 * t675 - 0.9e1 * t114 * t156 * t3657 * t3658;
  t3664 = t695 * t695;
  t3695 = -0.9e1 / 0.4e1 * t114 * t156 * t679 * t3664 - 0.9e1 / 0.2e1 * t114 * t671 * t681 + 0.9e1 * t114 * t298 * t1434 + 0.9e1 / 0.2e1 * t271 * t1481 + 0.3e1 / 0.2e1 * t114 * t1508 * t315 + 0.9e1 / 0.4e1 * t114 * t671 * t696 + 0.9e1 / 0.2e1 * t271 * t1443 + 0.3e1 / 0.2e1 * t114 * t298 * t1470 + 0.3e1 / 0.2e1 * t271 * t1471 + 0.9e1 * t271 * t1435 + t3510 / 0.2e1 + 0.3e1 * t3513 - 0.3e1 * t3515;
  t3707 = 0.3e1 / 0.2e1 * t3518 + 0.3e1 / 0.2e1 * t3521 - 0.3e1 * t3524 + 0.3e1 / 0.2e1 * t3528 + 0.3e1 * t3530 + 0.3e1 / 0.2e1 * t3532 + t3379 - t3385 / 0.2e1 - t3389 - t3394 + 0.5e1 / 0.9e1 * t3237 - 0.5e1 / 0.9e1 * t3228 - 0.5e1 / 0.9e1 * t3215;
  t3745 = 0.27e2 / 0.2e1 * t804 * t1802 * t680 * t695 - 0.9e1 * t804 * t1816 * t1489 - 0.3e1 * t804 * t805 * t1469 * t314 - 0.9e1 * t1813 * t1490 - 0.3e1 * t3546 - 0.9e1 / 0.4e1 * t637 * t672 - 0.3e1 / 0.2e1 * t271 * t1509 - 0.3e1 / 0.8e1 * t114 * t28 * (0.2618e4 / 0.243e3 * t30 * t3624 + 0.308e5 / 0.729e3 * t124 * t3628 + 0.5225e4 / 0.1458e4 * t52 * t3634 + 0.988e6 / 0.6561e4 * t141 * t3638 + 0.5434e5 / 0.2187e4 * t74 * t3642) * t170 + t3071 - t3553 / 0.2e1 - t3555 / 0.2e1 - 0.3e1 / 0.2e1 * t3557 - 0.3e1 / 0.2e1 * t3559;
  t3748 = my_piecewise3(t105, 0, t3663 + t3695 + t3707 + t3745);
  tv4rho44 = 0.4e1 * t1425 + 0.4e1 * t1529 + t7 * (t3593 + t3748);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t3756 = t453 * t707;
  t3758 = t34 * t1056;
  t3761 = t326 * t1066;
  t3764 = t54 * t486;
  t3765 = t3764 * tau[0];
  t3781 = t27 * t187 * t1604 * t100;
  t3783 = t183 * t1559;
  t3786 = t27 * t188 * t1580;
  t3791 = t27 * t706 * t509;
  t3796 = t453 * t730;
  t3798 = t183 * t1562;
  t3801 = t27 * t1085 * t345;
  t3804 = t27 * t464 * t750;
  t3806 = 0.27e2 / 0.4e1 * t737 * t1631 * t1627 * t232 - 0.3e1 / 0.8e1 * t3756 - 0.3e1 / 0.8e1 * t27 * t28 * (-0.154e3 / 0.81e2 * t30 * t3758 - 0.209e3 / 0.243e3 * t52 * t3761 - 0.247e4 / 0.729e3 * t73 * t3765) * t100 - 0.3e1 / 0.8e1 * t1111 * t336 - 0.9e1 / 0.8e1 * t453 * t722 - 0.9e1 / 0.8e1 * t183 * t1606 - 0.3e1 / 0.8e1 * t3781 + 0.3e1 / 0.4e1 * t3783 + 0.3e1 / 0.8e1 * t3786 - 0.9e1 / 0.4e1 * t183 * t1536 - 0.3e1 / 0.4e1 * t3791 - 0.9e1 / 0.4e1 * t27 * t721 * t509 + 0.3e1 / 0.8e1 * t3796 + 0.3e1 / 0.4e1 * t3798 - t3801 / 0.4e1 - t3804 / 0.4e1;
  t3810 = t183 * t1541;
  t3816 = 0.5e1 / 0.36e2 * t27 * t1120 * t345;
  t3836 = t183 * t1544;
  t3841 = t27 * t1588 * t233;
  t3844 = t27 * t706 * t524;
  t3853 = t27 * t1089 * t345;
  t3856 = t27 * t468 * t750;
  t3858 = 0.9e1 / 0.4e1 * t27 * t335 * t1153 - t3810 / 0.4e1 + 0.9e1 / 0.8e1 * t453 * t725 + t3816 + 0.9e1 / 0.8e1 * t27 * t1605 * t233 + 0.9e1 / 0.8e1 * t183 * t1581 + 0.9e1 / 0.8e1 * t27 * t216 * t1580 + 0.3e1 / 0.8e1 * t27 * t82 * t221 * (-0.154e3 / 0.81e2 * t83 * t3758 - 0.209e3 / 0.243e3 * t89 * t3761 - 0.247e4 / 0.729e3 * t95 * t3765) + 0.3e1 / 0.4e1 * t3836 + 0.9e1 / 0.8e1 * t183 * t1550 - t3841 / 0.4e1 + 0.3e1 / 0.8e1 * t3844 + 0.9e1 / 0.8e1 * t453 * t751 + 0.9e1 / 0.8e1 * t183 * t1565 + 0.9e1 / 0.4e1 * t183 * t1533 + 0.3e1 / 0.8e1 * t3853 + 0.3e1 / 0.4e1 * t3856;
  t3869 = t27 * t1594 * t233;
  t3881 = t1616 * t1633;
  t3883 = t1616 * t1628;
  t3900 = t1616 * t1620;
  t3902 = 0.3e1 / 0.8e1 * t27 * t1079 * t345 + 0.9e1 / 0.8e1 * t27 * t499 * t750 + 0.9e1 / 0.4e1 * t183 * t1547 + 0.3e1 / 0.4e1 * t3869 + 0.9e1 / 0.8e1 * t27 * t721 * t524 + 0.3e1 / 0.8e1 * t27 * t335 * t1174 + 0.3e1 / 0.8e1 * t1111 * t346 + 0.9e1 / 0.8e1 * t453 * t733 + 0.9e1 / 0.4e1 * t3881 - 0.3e1 / 0.4e1 * t3883 - 0.9e1 / 0.4e1 * t737 * t1619 * t1627 - 0.9e1 / 0.4e1 * t737 * t738 * t749 * t523 - 0.3e1 / 0.4e1 * t737 * t738 * t344 * t1173 - 0.9e1 / 0.2e1 * t1612 * t1620 - 0.9e1 / 0.2e1 * t1612 * t1624 - 0.3e1 / 0.2e1 * t3900;
  t3903 = t1616 * t1624;
  t3905 = t498 * t507;
  t3919 = t452 * t28;
  t3920 = t6 * t3919;
  t3923 = t215 * t1151;
  t3931 = t81 * t2956;
  t3938 = t182 * t187;
  t3939 = t6 * t3938;
  t3940 = t3939 * t740;
  t3944 = t26 * t463;
  t3945 = t6 * t3944;
  t3946 = t3945 * t740;
  t3948 = t183 * t1595;
  t3952 = t27 * t463 * t720 * t100;
  t3954 = t183 * t1589;
  t3959 = 0.5e1 / 0.36e2 * t27 * t1119 * t334 * t100;
  t3960 = -0.3e1 / 0.2e1 * t3903 - 0.9e1 / 0.4e1 * t737 * t3905 * t739 - 0.9e1 / 0.2e1 * t737 * t1619 * t1623 - 0.9e1 / 0.4e1 * t737 * t738 * t1579 * t232 - 0.9e1 / 0.4e1 * t737 * t2127 * t1182 - 0.9e1 / 0.4e1 * t3920 * t740 + 0.27e2 / 0.4e1 * t737 * t3923 * t1632 + 0.27e2 / 0.4e1 * t737 * t1631 * t749 * t508 - 0.9e1 * t737 * t3931 * t344 * t1152 + 0.27e2 / 0.4e1 * t1612 * t1633 - 0.3e1 / 0.2e1 * t3940 - 0.9e1 / 0.4e1 * t1612 * t1628 + t3946 / 0.2e1 - 0.3e1 / 0.4e1 * t3948 + t3952 / 0.4e1 + t3954 / 0.4e1 - t3959;
  t3963 = my_piecewise3(t2, 0, t3806 + t3858 + t3902 + t3960);
  tv4rho3sigma0 = t7 * t3963 + 0.3e1 * t1638;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t3968 = t543 * t760;
  t3970 = t245 * t1646;
  t3975 = 0.5e1 / 0.36e2 * t114 * t1119 * t362 * t170;
  t3978 = t543 * t765;
  t3980 = t245 * t1653;
  t3984 = 0.5e1 / 0.36e2 * t114 * t1212 * t373;
  t3986 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t1205 * t364 - 0.3e1 / 0.8e1 * t3968 + t3970 / 0.4e1 - t3975 + 0.3e1 / 0.8e1 * t1205 * t374 + 0.3e1 / 0.8e1 * t3978 - t3980 / 0.4e1 + t3984);
  tv4rho3sigma2 = t7 * t3986 + 0.3e1 * t1657;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t3988 = 0.2e1 * t1687;
  t3990 = t261 * t1589;
  t3993 = t565 * t707 / 0.4e1;
  t3997 = t261 * t1595 / 0.4e1;
  t4006 = t565 * t730 / 0.4e1;
  t4007 = t261 * t1541;
  t4013 = -t3756 / 0.8e1 + t3990 / 0.12e2 - t3993 - 0.3e1 / 0.4e1 * t565 * t722 - t3997 - 0.3e1 / 0.8e1 * t261 * t1606 - 0.3e1 / 0.8e1 * t1264 * t336 - t3781 / 0.8e1 - 0.3e1 / 0.4e1 * t261 * t1536 + t4006 - t4007 / 0.12e2 + 0.3e1 / 0.8e1 * t1264 * t346 + 0.3e1 / 0.4e1 * t565 * t733;
  t4017 = t261 * t1559 / 0.4e1;
  t4019 = t261 * t1562 / 0.4e1;
  t4029 = t261 * t1544 / 0.4e1;
  t4038 = 0.3e1 / 0.4e1 * t565 * t751 + t4017 + t4019 + 0.3e1 / 0.8e1 * t261 * t1565 + 0.3e1 / 0.4e1 * t261 * t1533 + 0.3e1 / 0.8e1 * t261 * t1581 + 0.3e1 / 0.4e1 * t565 * t725 + t4029 + 0.3e1 / 0.4e1 * t261 * t1547 + 0.3e1 / 0.8e1 * t261 * t1550 + t3783 / 0.4e1 + t3786 / 0.8e1 - t3791 / 0.4e1 + t3796 / 0.8e1;
  t4054 = t3798 / 0.4e1 - t3801 / 0.6e1 - t3804 / 0.6e1 - t3810 / 0.6e1 + t3816 + t3836 / 0.4e1 - t3841 / 0.6e1 + t3844 / 0.8e1 + t3853 / 0.8e1 + t3856 / 0.4e1 + t3869 / 0.4e1 + 0.9e1 / 0.4e1 * t1677 * t1633 - 0.3e1 / 0.4e1 * t1677 * t1628;
  t4055 = t564 * t28;
  t4056 = t6 * t4055;
  t4059 = t260 * t187;
  t4060 = t6 * t4059;
  t4062 = t4060 * t740 / 0.2e1;
  t4076 = -0.3e1 / 0.2e1 * t4056 * t740 - t4062 - 0.3e1 / 0.2e1 * t1677 * t1620 - 0.3e1 / 0.2e1 * t1677 * t1624 + 0.3e1 / 0.4e1 * t3881 - t3883 / 0.4e1 - t3900 / 0.2e1 - t3903 / 0.2e1 - t3940 / 0.2e1 + t3946 / 0.3e1 - t3948 / 0.4e1 + t3952 / 0.6e1 + t3954 / 0.6e1 - t3959;
  t4079 = my_piecewise3(t2, 0, t4013 + t4038 + t4054 + t4076);
  tv4rho3sigma3 = t7 * t4079 + t1638 + t3988;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t4081 = 0.2e1 * t1729;
  t4087 = t245 * t1697 / 0.4e1;
  t4090 = t114 * t463 * t790 * t170;
  t4095 = t588 * t760 / 0.4e1;
  t4096 = t271 * t1646;
  t4106 = -t3975 - t3968 / 0.8e1 + t3970 / 0.6e1 - 0.3e1 / 0.8e1 * t1290 * t364 - t4087 + t4090 / 0.12e2 - 0.3e1 / 0.8e1 * t543 * t792 - t4095 + t4096 / 0.12e2 + 0.3e1 / 0.8e1 * t543 * t818 + 0.3e1 / 0.8e1 * t543 * t795 + 0.3e1 / 0.8e1 * t1290 * t374 + 0.3e1 / 0.8e1 * t543 * t800;
  t4108 = t114 * t1303 * t373;
  t4111 = t245 * t1725 / 0.4e1;
  t4113 = t114 * t548 * t817;
  t4116 = t245 * t1702 / 0.4e1;
  t4118 = t114 * t1645 * t315;
  t4121 = t588 * t765 / 0.4e1;
  t4122 = t271 * t1653;
  t4125 = t245 * t1712 / 0.4e1;
  t4128 = t542 * t28;
  t4129 = t6 * t4128;
  t4132 = t244 * t187;
  t4133 = t6 * t4132;
  t4135 = t4133 * t807 / 0.2e1;
  t4136 = t113 * t463;
  t4137 = t6 * t4136;
  t4138 = t4137 * t807;
  t4140 = -t4108 / 0.12e2 + t4111 - t4113 / 0.12e2 + t4116 - t4118 / 0.12e2 + t4121 - t4122 / 0.12e2 + t4125 + t3978 / 0.8e1 - t3980 / 0.6e1 + t3984 - 0.3e1 / 0.4e1 * t4129 * t807 - t4135 + t4138 / 0.6e1;
  t4142 = my_piecewise3(t105, 0, t4106 + t4140);
  tv4rho3sigma5 = t7 * t4142 + t1657 + t4081;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t4145 = t621 * t707;
  t4157 = t621 * t730;
  t4162 = t3990 / 0.6e1 - t3993 - t3997 - t4145 / 0.8e1 - 0.3e1 / 0.8e1 * t1332 * t336 - 0.3e1 / 0.8e1 * t621 * t722 + 0.3e1 / 0.8e1 * t621 * t751 + 0.3e1 / 0.8e1 * t621 * t725 + 0.3e1 / 0.8e1 * t1332 * t346 + t4157 / 0.8e1 + 0.3e1 / 0.8e1 * t621 * t733 + t4006 - t4007 / 0.6e1;
  t4167 = t620 * t28;
  t4168 = t6 * t4167;
  t4174 = t4017 + t4019 + t4029 - t3801 / 0.12e2 - t3804 / 0.12e2 - t3810 / 0.12e2 + t3816 - t3841 / 0.12e2 - 0.3e1 / 0.4e1 * t4168 * t740 - t4062 + t3946 / 0.6e1 + t3952 / 0.12e2 + t3954 / 0.12e2 - t3959;
  t4176 = my_piecewise3(t2, 0, t4162 + t4174);
  tv4rho3sigma6 = t7 * t4176 + t1739 + t3988;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t4185 = t637 * t760;
  t4187 = t271 * t1697;
  t4191 = t114 * t187 * t1756 * t170;
  t4203 = -t3975 + t3970 / 0.12e2 - 0.3e1 / 0.8e1 * t1361 * t364 - 0.3e1 / 0.4e1 * t588 * t792 - 0.3e1 / 0.8e1 * t245 * t1758 - t4185 / 0.8e1 - t4187 / 0.4e1 - t4191 / 0.8e1 + 0.3e1 / 0.8e1 * t245 * t1772 + 0.3e1 / 0.4e1 * t245 * t1775 + 0.3e1 / 0.8e1 * t245 * t1786 + 0.3e1 / 0.4e1 * t588 * t795 + 0.3e1 / 0.4e1 * t245 * t1792;
  t4215 = t114 * t248 * t1785;
  t4217 = t271 * t1702;
  t4220 = t114 * t759 * t681;
  t4225 = t114 * t759 * t696;
  t4227 = t637 * t765;
  t4229 = 0.3e1 / 0.8e1 * t245 * t1763 - 0.3e1 / 0.4e1 * t245 * t1795 + 0.3e1 / 0.8e1 * t1361 * t374 + 0.3e1 / 0.4e1 * t588 * t800 + 0.3e1 / 0.4e1 * t588 * t818 + t4215 / 0.8e1 + t4217 / 0.4e1 - t4220 / 0.4e1 - t4087 + t4090 / 0.6e1 - t4095 + t4096 / 0.6e1 + t4225 / 0.8e1 + t4227 / 0.8e1;
  t4231 = t271 * t1712;
  t4233 = t271 * t1725;
  t4236 = t114 * t1381 * t373;
  t4239 = t114 * t596 * t817;
  t4242 = t114 * t1696 * t315;
  t4248 = t4231 / 0.4e1 + t4233 / 0.4e1 + t4236 / 0.8e1 + t4239 / 0.4e1 + t4242 / 0.4e1 - t4108 / 0.6e1 + t4111 - t4113 / 0.6e1 + t4116 - t4118 / 0.6e1 + t4121 - t4122 / 0.6e1 + t4125;
  t4250 = t1720 * t1804;
  t4252 = t1720 * t1809;
  t4254 = t270 * t187;
  t4255 = t6 * t4254;
  t4256 = t4255 * t807;
  t4258 = t1720 * t1817;
  t4260 = t1720 * t1821;
  t4270 = t587 * t28;
  t4271 = t6 * t4270;
  t4275 = -t3980 / 0.12e2 + t3984 + 0.3e1 / 0.4e1 * t4250 - t4252 / 0.4e1 - t4256 / 0.2e1 - t4258 / 0.2e1 - t4260 / 0.2e1 + 0.9e1 / 0.4e1 * t1716 * t1804 - 0.3e1 / 0.2e1 * t1716 * t1817 - 0.3e1 / 0.2e1 * t1716 * t1821 - 0.3e1 / 0.4e1 * t1716 * t1809 - 0.3e1 / 0.2e1 * t4271 * t807 - t4135 + t4138 / 0.3e1;
  t4278 = my_piecewise3(t105, 0, t4203 + t4229 + t4248 + t4275);
  tv4rho3sigma8 = t7 * t4278 + t1826 + t4081;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t4290 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t1419 * t336 - 0.3e1 / 0.8e1 * t4145 + t3990 / 0.4e1 - t3959 + 0.3e1 / 0.8e1 * t1419 * t346 + 0.3e1 / 0.8e1 * t4157 - t4007 / 0.4e1 + t3816);
  tv4rho3sigma9 = t7 * t4290 + 0.3e1 * t1739;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t4323 = t34 * t1447;
  t4326 = t354 * t1457;
  t4329 = t54 * t658;
  t4330 = t4329 * tau[1];
  t4340 = 0.27e2 / 0.4e1 * t804 * t1802 * t1808 * t314 - t3975 - 0.3e1 / 0.8e1 * t4185 - 0.3e1 / 0.4e1 * t4187 - 0.3e1 / 0.8e1 * t4191 - 0.9e1 / 0.4e1 * t271 * t1795 - 0.9e1 / 0.4e1 * t114 * t791 * t681 + 0.9e1 / 0.8e1 * t637 * t795 + 0.9e1 / 0.4e1 * t114 * t363 * t1434 + 0.3e1 / 0.8e1 * t114 * t1508 * t373 + 0.9e1 / 0.8e1 * t114 * t671 * t817 + 0.9e1 / 0.4e1 * t271 * t1775 + 0.9e1 / 0.8e1 * t114 * t298 * t1785 + 0.9e1 / 0.8e1 * t271 * t1786 + 0.3e1 / 0.8e1 * t114 * t156 * t303 * (-0.154e3 / 0.81e2 * t83 * t4323 - 0.209e3 / 0.243e3 * t89 * t4326 - 0.247e4 / 0.729e3 * t95 * t4330) + 0.9e1 / 0.8e1 * t271 * t1763;
  t4369 = 0.9e1 / 0.8e1 * t114 * t791 * t696 + 0.3e1 / 0.8e1 * t114 * t363 * t1470 + 0.3e1 / 0.8e1 * t1524 * t374 + 0.9e1 / 0.8e1 * t637 * t800 + 0.9e1 / 0.8e1 * t637 * t818 + 0.9e1 / 0.4e1 * t271 * t1792 + 0.9e1 / 0.8e1 * t114 * t1757 * t315 + 0.9e1 / 0.8e1 * t271 * t1772 + 0.3e1 / 0.8e1 * t4215 + 0.3e1 / 0.4e1 * t4217 - 0.3e1 / 0.4e1 * t4220 + t4090 / 0.4e1 + t4096 / 0.4e1 + 0.3e1 / 0.8e1 * t4225 + 0.3e1 / 0.8e1 * t4227 + 0.3e1 / 0.4e1 * t4231 + 0.3e1 / 0.4e1 * t4233;
  t4393 = t636 * t28;
  t4394 = t6 * t4393;
  t4401 = t670 * t679;
  t4405 = 0.3e1 / 0.8e1 * t4236 + 0.3e1 / 0.4e1 * t4239 + 0.3e1 / 0.4e1 * t4242 - t4108 / 0.4e1 - t4113 / 0.4e1 - t4118 / 0.4e1 - t4122 / 0.4e1 + t3984 + 0.27e2 / 0.4e1 * t804 * t1802 * t816 * t680 - 0.9e1 / 0.4e1 * t804 * t805 * t816 * t695 - 0.3e1 / 0.4e1 * t804 * t805 * t372 * t1469 - 0.9e1 / 0.4e1 * t804 * t2230 * t1489 - 0.9e1 / 0.4e1 * t4394 * t807 - 0.9e1 / 0.2e1 * t1813 * t1817 - 0.9e1 / 0.2e1 * t1813 * t1821 - 0.9e1 / 0.4e1 * t804 * t4401 * t806;
  t4420 = t297 * t1432;
  t4424 = t155 * t3657;
  t4452 = -0.9e1 / 0.2e1 * t804 * t1816 * t1820 - 0.9e1 / 0.4e1 * t804 * t805 * t1784 * t314 - 0.9e1 / 0.4e1 * t1813 * t1809 - 0.9e1 / 0.4e1 * t804 * t1816 * t1808 + 0.27e2 / 0.4e1 * t1813 * t1804 + 0.27e2 / 0.4e1 * t804 * t4420 * t1803 - 0.9e1 * t804 * t4424 * t372 * t1433 + 0.9e1 / 0.4e1 * t4250 - 0.3e1 / 0.4e1 * t4252 - 0.3e1 / 0.2e1 * t4256 - 0.3e1 / 0.2e1 * t4258 - 0.3e1 / 0.2e1 * t4260 - 0.9e1 / 0.8e1 * t271 * t1758 - 0.3e1 / 0.8e1 * t114 * t28 * (-0.154e3 / 0.81e2 * t30 * t4323 - 0.209e3 / 0.243e3 * t52 * t4326 - 0.247e4 / 0.729e3 * t73 * t4330) * t170 - 0.3e1 / 0.8e1 * t1524 * t364 - 0.9e1 / 0.8e1 * t637 * t792 + t4138 / 0.2e1;
  t4455 = my_piecewise3(t105, 0, t4340 + t4369 + t4405 + t4452);
  tv4rho3sigma11 = t7 * t4455 + 0.3e1 * t1826;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3lapl1 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  tv4rho3lapl2 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  tv4rho3lapl3 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  tv4rho3lapl4 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  tv4rho3lapl5 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  tv4rho3lapl6 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  tv4rho3lapl7 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  t4459 = t27 * t188 * t1901;
  t4466 = t27 * t1849 * t233;
  t4471 = t27 * t826 * t509;
  t4476 = t453 * t847;
  t4478 = t183 * t1857;
  t4480 = t183 * t1860;
  t4505 = t183 * t1880;
  t4509 = 0.3e1 / 0.8e1 * t4459 + 0.27e2 / 0.4e1 * t737 * t1631 * t1920 * t232 - t4466 / 0.4e1 - 0.9e1 / 0.4e1 * t183 * t1869 - 0.3e1 / 0.4e1 * t4471 - 0.9e1 / 0.4e1 * t27 * t838 * t509 + 0.3e1 / 0.8e1 * t4476 + 0.3e1 / 0.4e1 * t4478 + 0.3e1 / 0.4e1 * t4480 + 0.3e1 / 0.8e1 * t27 * t1079 * t402 + 0.9e1 / 0.8e1 * t27 * t499 * t865 + 0.9e1 / 0.8e1 * t183 * t1902 + 0.9e1 / 0.8e1 * t27 * t216 * t1901 + 0.3e1 / 0.8e1 * t27 * t82 * t221 * (-0.22e4 / 0.243e3 * params->bb * t476 * t380 - 0.104e6 / 0.2187e4 * t396 * t1071 - 0.247e4 / 0.729e3 * t95 * t1572) + 0.3e1 / 0.4e1 * t4505 + 0.9e1 / 0.8e1 * t453 * t842;
  t4534 = t27 * t1089 * t402;
  t4537 = t27 * t468 * t865;
  t4542 = t183 * t1875;
  t4545 = t27 * t1845 * t233;
  t4548 = t27 * t826 * t524;
  t4551 = t27 * t1085 * t402;
  t4553 = 0.9e1 / 0.4e1 * t183 * t1883 + 0.9e1 / 0.8e1 * t183 * t1886 + 0.9e1 / 0.8e1 * t27 * t1837 * t233 + 0.9e1 / 0.8e1 * t27 * t838 * t524 + 0.3e1 / 0.8e1 * t27 * t390 * t1174 + 0.3e1 / 0.8e1 * t1111 * t403 + 0.9e1 / 0.8e1 * t453 * t850 + 0.9e1 / 0.8e1 * t453 * t866 + 0.9e1 / 0.8e1 * t183 * t1863 + 0.9e1 / 0.4e1 * t183 * t1866 + 0.3e1 / 0.8e1 * t4534 + 0.3e1 / 0.4e1 * t4537 + 0.9e1 / 0.4e1 * t27 * t390 * t1153 - t4542 / 0.4e1 + 0.3e1 / 0.4e1 * t4545 + 0.3e1 / 0.8e1 * t4548 - t4551 / 0.4e1;
  t4556 = t27 * t464 * t865;
  t4560 = 0.5e1 / 0.36e2 * t27 * t1120 * t402;
  t4561 = t183 * t1846;
  t4565 = t27 * t463 * t837 * t100;
  t4569 = t453 * t827;
  t4574 = 0.5e1 / 0.36e2 * t27 * t1119 * t389 * t100;
  t4575 = t183 * t1850;
  t4579 = t27 * t187 * t1836 * t100;
  t4608 = -t4556 / 0.4e1 + t4560 - 0.3e1 / 0.4e1 * t4561 + t4565 / 0.4e1 - 0.3e1 / 0.8e1 * t1111 * t391 - 0.3e1 / 0.8e1 * t4569 - t4574 + t4575 / 0.4e1 - 0.3e1 / 0.8e1 * t4579 - 0.3e1 / 0.8e1 * t27 * t28 * (-0.22e4 / 0.243e3 * params->bt * t476 * t380 - 0.104e6 / 0.2187e4 * t383 * t1071 - 0.247e4 / 0.729e3 * t73 * t1572) * t100 - 0.9e1 / 0.8e1 * t453 * t839 - 0.9e1 / 0.8e1 * t183 * t1838 - 0.9e1 / 0.4e1 * t737 * t738 * t1900 * t232 - 0.9e1 / 0.4e1 * t737 * t2320 * t1182 - 0.9e1 / 0.4e1 * t3920 * t854 - 0.9e1 / 0.2e1 * t1612 * t1913;
  t4609 = t3939 * t854;
  t4617 = t1616 * t1906;
  t4628 = t3945 * t854;
  t4630 = t1616 * t1921;
  t4645 = t1616 * t1913;
  t4647 = t1616 * t1917;
  t4655 = -0.3e1 / 0.2e1 * t4609 - 0.9e1 * t737 * t3931 * t401 * t1152 + 0.27e2 / 0.4e1 * t1612 * t1906 + 0.9e1 / 0.4e1 * t4617 + 0.27e2 / 0.4e1 * t737 * t3923 * t1905 + 0.27e2 / 0.4e1 * t737 * t1631 * t864 * t508 - 0.9e1 / 0.4e1 * t1612 * t1921 + t4628 / 0.2e1 - 0.3e1 / 0.4e1 * t4630 - 0.9e1 / 0.4e1 * t737 * t1619 * t1920 - 0.9e1 / 0.4e1 * t737 * t738 * t864 * t523 - 0.3e1 / 0.4e1 * t737 * t738 * t401 * t1173 - 0.9e1 / 0.2e1 * t1612 * t1917 - 0.3e1 / 0.2e1 * t4645 - 0.3e1 / 0.2e1 * t4647 - 0.9e1 / 0.4e1 * t737 * t3905 * t853 - 0.9e1 / 0.2e1 * t737 * t1619 * t1916;
  t4658 = my_piecewise3(t2, 0, t4509 + t4553 + t4608 + t4655);
  tv4rho3tau0 = t7 * t4658 + 0.3e1 * t1926;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t4663 = t543 * t875;
  t4665 = t245 * t1934;
  t4670 = 0.5e1 / 0.36e2 * t114 * t1119 * t417 * t170;
  t4673 = t543 * t880;
  t4675 = t245 * t1941;
  t4679 = 0.5e1 / 0.36e2 * t114 * t1212 * t430;
  t4681 = my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t1205 * t419 - 0.3e1 / 0.8e1 * t4663 + t4665 / 0.4e1 - t4670 + 0.3e1 / 0.8e1 * t1205 * t431 + 0.3e1 / 0.8e1 * t4673 - t4675 / 0.4e1 + t4679);
  tv4rho3tau1 = t7 * t4681 + 0.3e1 * t1945;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  t4683 = 0.2e1 * t1973;
  t4684 = t261 * t1875;
  t4698 = -t4684 / 0.12e2 + t4459 / 0.8e1 - t4466 / 0.6e1 - t4471 / 0.4e1 + t4476 / 0.8e1 + t4478 / 0.4e1 + t4480 / 0.4e1 + t4505 / 0.4e1 + t4534 / 0.8e1 + t4537 / 0.4e1 - t4542 / 0.6e1 + t4545 / 0.4e1 + t4548 / 0.8e1;
  t4702 = t565 * t827 / 0.4e1;
  t4703 = t261 * t1850;
  t4706 = t261 * t1846 / 0.4e1;
  t4717 = -t4551 / 0.6e1 - t4556 / 0.6e1 + t4560 - t4702 + t4703 / 0.12e2 - t4706 - 0.3e1 / 0.8e1 * t261 * t1838 - 0.3e1 / 0.8e1 * t1264 * t391 - 0.3e1 / 0.4e1 * t565 * t839 - t4561 / 0.4e1 + t4565 / 0.6e1 - t4569 / 0.8e1 - t4574 + t4575 / 0.6e1;
  t4729 = t4060 * t854 / 0.2e1;
  t4738 = -t4579 / 0.8e1 - 0.3e1 / 0.2e1 * t1677 * t1917 - 0.3e1 / 0.4e1 * t1677 * t1921 + 0.9e1 / 0.4e1 * t1677 * t1906 - 0.3e1 / 0.2e1 * t4056 * t854 - t4729 - 0.3e1 / 0.2e1 * t1677 * t1913 - t4609 / 0.2e1 + 0.3e1 / 0.4e1 * t4617 + t4628 / 0.3e1 - t4630 / 0.4e1 - t4645 / 0.2e1 - t4647 / 0.2e1;
  t4744 = t261 * t1880 / 0.4e1;
  t4756 = t261 * t1857 / 0.4e1;
  t4758 = t261 * t1860 / 0.4e1;
  t4764 = t565 * t847 / 0.4e1;
  t4767 = 0.3e1 / 0.8e1 * t261 * t1902 + 0.3e1 / 0.4e1 * t565 * t842 + t4744 + 0.3e1 / 0.4e1 * t261 * t1883 + 0.3e1 / 0.8e1 * t261 * t1886 + 0.3e1 / 0.8e1 * t1264 * t403 + 0.3e1 / 0.4e1 * t565 * t850 + 0.3e1 / 0.4e1 * t565 * t866 + t4756 + t4758 + 0.3e1 / 0.8e1 * t261 * t1863 + 0.3e1 / 0.4e1 * t261 * t1866 + t4764 - 0.3e1 / 0.4e1 * t261 * t1869;
  t4770 = my_piecewise3(t2, 0, t4698 + t4717 + t4738 + t4767);
  tv4rho3tau2 = t7 * t4770 + t1926 + t4683;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  t4772 = 0.2e1 * t2011;
  t4780 = t4133 * t916 / 0.2e1;
  t4781 = t4137 * t916;
  t4784 = t245 * t1983 / 0.4e1;
  t4787 = t114 * t463 * t902 * t170;
  t4793 = t4679 + t4673 / 0.8e1 - t4675 / 0.6e1 - t4663 / 0.8e1 + t4665 / 0.6e1 - t4670 - 0.3e1 / 0.4e1 * t4129 * t916 - t4780 + t4781 / 0.6e1 - t4784 + t4787 / 0.12e2 + 0.3e1 / 0.8e1 * t543 * t928 + 0.3e1 / 0.8e1 * t543 * t907;
  t4799 = t114 * t1933 * t315;
  t4802 = t588 * t880 / 0.4e1;
  t4803 = t271 * t1941;
  t4806 = t245 * t1998 / 0.4e1;
  t4808 = t114 * t1303 * t430;
  t4811 = t245 * t2007 / 0.4e1;
  t4813 = t114 * t548 * t927;
  t4816 = t245 * t1988 / 0.4e1;
  t4818 = t588 * t875 / 0.4e1;
  t4819 = t271 * t1934;
  t4825 = 0.3e1 / 0.8e1 * t1290 * t431 + 0.3e1 / 0.8e1 * t543 * t912 - t4799 / 0.12e2 + t4802 - t4803 / 0.12e2 + t4806 - t4808 / 0.12e2 + t4811 - t4813 / 0.12e2 + t4816 - t4818 + t4819 / 0.12e2 - 0.3e1 / 0.8e1 * t543 * t904 - 0.3e1 / 0.8e1 * t1290 * t419;
  t4827 = my_piecewise3(t105, 0, t4793 + t4825);
  tv4rho3tau3 = t7 * t4827 + t1945 + t4772;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  t4831 = t621 * t827;
  t4839 = -t4684 / 0.6e1 - t4466 / 0.12e2 - t4831 / 0.8e1 - t4542 / 0.12e2 - t4551 / 0.12e2 - t4556 / 0.12e2 + t4560 - t4702 + t4703 / 0.6e1 - t4706 + t4565 / 0.12e2 - t4574 + t4575 / 0.12e2;
  t4851 = t621 * t847;
  t4857 = -0.3e1 / 0.4e1 * t4168 * t854 - t4729 + t4628 / 0.6e1 + 0.3e1 / 0.8e1 * t621 * t866 + 0.3e1 / 0.8e1 * t621 * t842 + 0.3e1 / 0.8e1 * t1332 * t403 + 0.3e1 / 0.8e1 * t621 * t850 + t4851 / 0.8e1 + t4744 + t4756 + t4758 + t4764 - 0.3e1 / 0.8e1 * t621 * t839 - 0.3e1 / 0.8e1 * t1332 * t391;
  t4859 = my_piecewise3(t2, 0, t4839 + t4857);
  tv4rho3tau4 = t7 * t4859 + t2021 + t4683;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  t4870 = t114 * t187 * t2031 * t170;
  t4872 = t637 * t875;
  t4874 = t271 * t1983;
  t4883 = t4679 - t4675 / 0.12e2 - 0.3e1 / 0.8e1 * t245 * t2033 - 0.3e1 / 0.8e1 * t1361 * t419 - 0.3e1 / 0.4e1 * t588 * t904 - t4870 / 0.8e1 - t4872 / 0.8e1 - t4874 / 0.4e1 + t4665 / 0.12e2 - t4670 - 0.3e1 / 0.2e1 * t1716 * t2086 - 0.3e1 / 0.2e1 * t1716 * t2090 - 0.3e1 / 0.4e1 * t1716 * t2094;
  t4886 = t4255 * t916;
  t4888 = t1720 * t2083;
  t4890 = t1720 * t2086;
  t4892 = t1720 * t2090;
  t4894 = t1720 * t2094;
  t4909 = 0.9e1 / 0.4e1 * t1716 * t2083 - t4886 / 0.2e1 + 0.3e1 / 0.4e1 * t4888 - t4890 / 0.2e1 - t4892 / 0.2e1 - t4894 / 0.4e1 - 0.3e1 / 0.2e1 * t4271 * t916 - t4780 + t4781 / 0.3e1 + 0.3e1 / 0.4e1 * t588 * t907 + 0.3e1 / 0.4e1 * t245 * t2062 + 0.3e1 / 0.8e1 * t245 * t2065 + 0.3e1 / 0.8e1 * t1361 * t431 + 0.3e1 / 0.4e1 * t588 * t912;
  t4922 = t271 * t1988;
  t4925 = t114 * t1982 * t315;
  t4928 = t114 * t874 * t696;
  t4930 = t637 * t880;
  t4932 = t271 * t1998;
  t4934 = t271 * t2007;
  t4936 = 0.3e1 / 0.4e1 * t588 * t928 + 0.3e1 / 0.8e1 * t245 * t2075 + 0.3e1 / 0.4e1 * t245 * t2042 + 0.3e1 / 0.8e1 * t245 * t2054 - 0.3e1 / 0.4e1 * t245 * t2057 - t4784 + t4787 / 0.6e1 + t4922 / 0.4e1 + t4925 / 0.4e1 + t4928 / 0.8e1 + t4930 / 0.8e1 + t4932 / 0.4e1 + t4934 / 0.4e1;
  t4938 = t114 * t1381 * t430;
  t4941 = t114 * t596 * t927;
  t4944 = t114 * t248 * t2053;
  t4947 = t114 * t874 * t681;
  t4954 = t4938 / 0.8e1 + t4941 / 0.4e1 + t4944 / 0.8e1 - t4947 / 0.4e1 - t4799 / 0.6e1 + t4802 - t4803 / 0.6e1 + t4806 - t4808 / 0.6e1 + t4811 - t4813 / 0.6e1 + t4816 - t4818 + t4819 / 0.6e1;
  t4957 = my_piecewise3(t105, 0, t4883 + t4909 + t4936 + t4954);
  tv4rho3tau5 = t7 * t4957 + t2102 + t4772;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  t4969 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t1419 * t391 - 0.3e1 / 0.8e1 * t4831 + t4703 / 0.4e1 - t4574 + 0.3e1 / 0.8e1 * t1419 * t403 + 0.3e1 / 0.8e1 * t4851 - t4684 / 0.4e1 + t4560);
  tv4rho3tau6 = t7 * t4969 + 0.3e1 * t2021;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  t5017 = t4679 + 0.27e2 / 0.4e1 * t804 * t1802 * t915 * t695 - 0.3e1 / 0.8e1 * t1524 * t419 - 0.9e1 / 0.8e1 * t637 * t904 - 0.9e1 / 0.8e1 * t271 * t2033 - 0.3e1 / 0.8e1 * t114 * t28 * (-0.22e4 / 0.243e3 * params->bt * t648 * t380 - 0.104e6 / 0.2187e4 * t411 * t1462 - 0.247e4 / 0.729e3 * t73 * t1749) * t170 - 0.3e1 / 0.8e1 * t4870 - 0.3e1 / 0.8e1 * t4872 - 0.3e1 / 0.4e1 * t4874 - t4670 - 0.9e1 * t804 * t4424 * t429 * t1433 - 0.9e1 / 0.2e1 * t804 * t1816 * t2089 - 0.9e1 / 0.4e1 * t804 * t805 * t2052 * t314 - 0.9e1 / 0.4e1 * t804 * t1816 * t2093 - 0.9e1 / 0.4e1 * t804 * t805 * t926 * t695 - 0.9e1 / 0.4e1 * t1813 * t2094;
  t5054 = -0.3e1 / 0.4e1 * t804 * t805 * t429 * t1469 - 0.9e1 / 0.4e1 * t804 * t2441 * t1489 - 0.9e1 / 0.4e1 * t4394 * t916 - 0.9e1 / 0.2e1 * t1813 * t2086 - 0.9e1 / 0.2e1 * t1813 * t2090 - 0.9e1 / 0.4e1 * t804 * t4401 * t915 + 0.27e2 / 0.4e1 * t1813 * t2083 + 0.27e2 / 0.4e1 * t804 * t4420 * t2082 + 0.27e2 / 0.4e1 * t804 * t1802 * t926 * t680 - 0.3e1 / 0.2e1 * t4886 + 0.9e1 / 0.4e1 * t4888 - 0.3e1 / 0.2e1 * t4890 - 0.3e1 / 0.2e1 * t4892 - 0.3e1 / 0.4e1 * t4894 + t4781 / 0.2e1 - 0.9e1 / 0.4e1 * t271 * t2057 - 0.9e1 / 0.4e1 * t114 * t903 * t681;
  t5105 = 0.9e1 / 0.8e1 * t114 * t903 * t696 + 0.3e1 / 0.8e1 * t114 * t418 * t1470 + 0.9e1 / 0.4e1 * t114 * t418 * t1434 + 0.9e1 / 0.4e1 * t271 * t2042 + 0.9e1 / 0.8e1 * t271 * t2054 + 0.3e1 / 0.8e1 * t114 * t1508 * t430 + 0.9e1 / 0.8e1 * t114 * t671 * t927 + 0.9e1 / 0.8e1 * t114 * t298 * t2053 + 0.3e1 / 0.8e1 * t114 * t156 * t303 * (-0.22e4 / 0.243e3 * params->bb * t648 * t380 - 0.104e6 / 0.2187e4 * t424 * t1462 - 0.247e4 / 0.729e3 * t95 * t1749) + 0.9e1 / 0.8e1 * t114 * t2032 * t315 + 0.9e1 / 0.8e1 * t637 * t907 + 0.9e1 / 0.4e1 * t271 * t2062 + 0.9e1 / 0.8e1 * t271 * t2065 + 0.3e1 / 0.8e1 * t1524 * t431 + 0.9e1 / 0.8e1 * t637 * t912 + 0.9e1 / 0.8e1 * t637 * t928;
  t5124 = 0.9e1 / 0.8e1 * t271 * t2075 + t4787 / 0.4e1 + 0.3e1 / 0.4e1 * t4922 + 0.3e1 / 0.4e1 * t4925 + 0.3e1 / 0.8e1 * t4928 + 0.3e1 / 0.8e1 * t4930 + 0.3e1 / 0.4e1 * t4932 + 0.3e1 / 0.4e1 * t4934 + 0.3e1 / 0.8e1 * t4938 + 0.3e1 / 0.4e1 * t4941 + 0.3e1 / 0.8e1 * t4944 - 0.3e1 / 0.4e1 * t4947 - t4799 / 0.4e1 - t4803 / 0.4e1 - t4808 / 0.4e1 - t4813 / 0.4e1 + t4819 / 0.4e1;
  t5127 = my_piecewise3(t105, 0, t5017 + t5054 + t5105 + t5124);
  tv4rho3tau7 = t7 * t5127 + 0.3e1 * t2102;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t5130 = t60 * t507;
  t5136 = t6 * t3938 * t81;
  t5137 = t5136 * t949;
  t5142 = t6 * t3944 * t81;
  t5144 = t5142 * t949 / 0.3456e4;
  t5146 = t6 * t1615 * t215;
  t5147 = t5146 * t949;
  t5150 = t6 * t736 * t498;
  t5154 = t6 * t1615 * params->a2t;
  t5155 = t5154 * t2116;
  t5157 = t203 * t221;
  t5167 = t6 * t3919 * t81;
  t5171 = t6 * t1611 * t215;
  t5175 = t6 * t1611 * params->a2t;
  t5178 = t2155 * t2168;
  t5185 = -t2113 * t1015 * t5130 * t508 / 0.384e3 + t5137 / 0.1152e4 - t2151 * t2168 / 0.72e2 - t5144 + t5147 / 0.1152e4 + t5150 * t949 / 0.768e3 + t5155 / 0.1152e4 - t2113 * t1015 * t5157 * t232 / 0.72e2 + t2113 * t1015 * t2114 * t523 / 0.768e3 + t5167 * t949 / 0.768e3 + t5171 * t949 / 0.384e3 + t5175 * t2116 / 0.384e3 - t5178 / 0.216e3 - t2159 * t2168 / 0.72e2 + 0.19e2 / 0.432e3 * t947 * t948 * t2846;
  t5193 = t1616 * t2143;
  t5195 = t1616 * t2147;
  t5212 = t1616 * t2128;
  t5213 = t720 * t507;
  t5224 = t334 * t1151;
  t5228 = -0.3e1 / 0.2e1 * t737 * t2127 * t1627 + 0.9e1 / 0.2e1 * t1612 * t2143 - 0.3e1 * t1612 * t2147 + 0.3e1 / 0.2e1 * t5193 - t5195 + 0.9e1 / 0.2e1 * t737 * t3923 * t2142 - 0.3e1 * t737 * t1619 * t2146 + 0.9e1 / 0.4e1 * t737 * t1631 * t941 * t523 - 0.3e1 / 0.2e1 * t737 * t738 * t344 * t1579 - 0.3e1 * t1612 * t2128 - t5212 - 0.3e1 * t737 * t5213 * t739 - 0.3e1 * t737 * t2127 * t1623 - 0.9e1 * t737 * t3931 * t941 * t508 + 0.9e1 / 0.2e1 * t737 * t5224 * t1632;
  t5230 = t749 * t749;
  t5235 = t183 * t2121;
  t5239 = t27 * t1588 * t345 / 0.6e1;
  t5243 = t183 * t2136;
  t5247 = t27 * t464 * t942 / 0.6e1;
  t5251 = t27 * t1594 * t345;
  t5254 = t27 * t706 * t750;
  t5270 = t27 * t468 * t942;
  t5272 = -0.3e1 / 0.2e1 * t27 * t82 * t507 * t5230 + t5235 / 0.2e1 - t5239 - 0.3e1 / 0.4e1 * t27 * t499 * t942 - t5243 / 0.2e1 + t5247 + 0.3e1 / 0.2e1 * t183 * t2131 + t5251 / 0.2e1 + t5254 / 0.2e1 + 0.3e1 / 0.4e1 * t27 * t1605 * t345 + 0.3e1 / 0.2e1 * t27 * t721 * t750 + 0.3e1 / 0.4e1 * t27 * t335 * t1580 - 0.3e1 / 0.4e1 * t453 * t943 - 0.3e1 / 0.2e1 * t183 * t2139 - t5270 / 0.2e1;
  t5285 = t2155 * t2165;
  t5303 = t1616 * t2109;
  t5309 = t3939 * t935;
  t5314 = t3945 * t935 / 0.3456e4;
  t5315 = 0.3e1 / 0.4e1 * t453 * t938 + 0.3e1 / 0.2e1 * t183 * t2124 - t2159 * t2165 / 0.192e3 - t947 * t2163 * t716 * t523 / 0.384e3 - t2151 * t2165 / 0.192e3 - t5285 / 0.576e3 + t947 * t1151 * params->a2b * t51 * t716 * t508 / 0.128e3 + t947 * t2163 * t1575 * t232 / 0.36e2 + 0.9e1 * t737 * t1631 * t739 * t749 - t3920 * t935 / 0.768e3 + t5303 / 0.216e3 - 0.19e2 / 0.432e3 * t737 * t52 * t3764 * t100 - t5309 / 0.1152e4 + t1612 * t2109 / 0.72e2 + t5314;
  t5318 = my_piecewise3(t2, 0, t5185 + t5228 + t5272 + t5315);
  tv4rho2sigma20 = t7 * t5318 + 0.2e1 * t2172;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t5323 = t4133 * t955;
  t5326 = t4137 * t955 / 0.3456e4;
  t5329 = t245 * t2180;
  t5333 = t114 * t1645 * t373 / 0.6e1;
  t5336 = t245 * t2185;
  t5340 = t114 * t548 * t962 / 0.6e1;
  t5342 = t6 * t4128 * t155;
  t5346 = t6 * t4132 * t155;
  t5347 = t5346 * t969;
  t5350 = t6 * t4136 * t155;
  t5352 = t5350 * t969 / 0.3456e4;
  t5353 = -t4129 * t955 / 0.768e3 - t5323 / 0.1152e4 + t5326 + 0.3e1 / 0.4e1 * t543 * t958 + t5329 / 0.2e1 - t5333 - 0.3e1 / 0.4e1 * t543 * t963 - t5336 / 0.2e1 + t5340 + t5342 * t969 / 0.768e3 + t5347 / 0.1152e4 - t5352;
  t5354 = my_piecewise3(t105, 0, t5353);
  tv4rho2sigma25 = t7 * t5354 + 0.2e1 * t2197;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t5357 = t6 * t4059 * t81;
  t5358 = t5357 * t949;
  t5364 = t6 * t1676 * params->a2t;
  t5368 = t6 * t4055 * t81;
  t5372 = t6 * t1676 * t215;
  t5387 = t261 * t2136;
  t5389 = t261 * t2121;
  t5393 = t5358 / 0.2304e4 - t2206 * t2168 / 0.144e3 + t5137 / 0.2304e4 - t5144 + t5364 * t2116 / 0.768e3 + t5368 * t949 / 0.768e3 + t5372 * t949 / 0.768e3 + t5147 / 0.2304e4 + t5155 / 0.2304e4 - t5178 / 0.432e3 + 0.9e1 / 0.4e1 * t1677 * t2143 - 0.3e1 / 0.2e1 * t1677 * t2147 - 0.3e1 / 0.2e1 * t1677 * t2128 + 0.3e1 / 0.4e1 * t5193 - t5195 / 0.2e1 - t5212 / 0.2e1 - t5387 / 0.4e1 + t5389 / 0.4e1 + 0.3e1 / 0.4e1 * t565 * t938;
  t5416 = t4060 * t935;
  t5418 = 0.3e1 / 0.4e1 * t261 * t2124 + 0.3e1 / 0.4e1 * t261 * t2131 - 0.3e1 / 0.4e1 * t565 * t943 - 0.3e1 / 0.4e1 * t261 * t2139 + t5235 / 0.4e1 - t5239 - t5243 / 0.4e1 + t5247 + t5251 / 0.4e1 + t5254 / 0.4e1 - t5270 / 0.4e1 - t2206 * t2165 / 0.384e3 - t5285 / 0.1152e4 - t4056 * t935 / 0.768e3 + t5303 / 0.432e3 - t5309 / 0.2304e4 + t5314 + t1677 * t2109 / 0.144e3 - t5416 / 0.2304e4;
  t5420 = my_piecewise3(t2, 0, t5393 + t5418);
  tv4rho2sigma26 = t7 * t5420 + t2172 + t2210;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t5423 = t6 * t4270 * t155;
  t5427 = t6 * t1715 * t297;
  t5433 = t6 * t1715 * params->a2t;
  t5437 = t6 * t1719 * t297;
  t5438 = t5437 * t969;
  t5440 = t2193 * t2264;
  t5443 = t6 * t1719 * params->a2t;
  t5444 = t5443 * t2222;
  t5447 = t6 * t4254 * t155;
  t5448 = t5447 * t969;
  t5457 = t1720 * t2231;
  t5459 = t1720 * t2243;
  t5461 = t1720 * t2247;
  t5469 = t5423 * t969 / 0.768e3 + t5427 * t969 / 0.768e3 - t2189 * t2264 / 0.144e3 + t5433 * t2222 / 0.768e3 + t5438 / 0.2304e4 - t5440 / 0.432e3 + t5444 / 0.2304e4 + t5448 / 0.2304e4 + t5347 / 0.2304e4 - t5352 - 0.3e1 / 0.2e1 * t1716 * t2231 + 0.9e1 / 0.4e1 * t1716 * t2243 - 0.3e1 / 0.2e1 * t1716 * t2247 - t5457 / 0.2e1 + 0.3e1 / 0.4e1 * t5459 - t5461 / 0.2e1 + 0.3e1 / 0.4e1 * t588 * t958 + 0.3e1 / 0.4e1 * t245 * t2227 + 0.3e1 / 0.4e1 * t245 * t2234;
  t5475 = t114 * t1696 * t373;
  t5478 = t114 * t759 * t817;
  t5480 = t271 * t2185;
  t5483 = t114 * t596 * t962;
  t5485 = t271 * t2180;
  t5491 = t2193 * t2261;
  t5493 = t4255 * t955;
  t5495 = t1720 * t2215;
  t5502 = -0.3e1 / 0.4e1 * t588 * t963 - 0.3e1 / 0.4e1 * t245 * t2239 + t5475 / 0.4e1 + t5478 / 0.4e1 - t5480 / 0.4e1 - t5483 / 0.4e1 + t5485 / 0.4e1 + t5340 + t5329 / 0.4e1 - t5333 - t5336 / 0.4e1 - t2189 * t2261 / 0.384e3 - t5491 / 0.1152e4 - t5493 / 0.2304e4 + t5495 / 0.432e3 - t4271 * t955 / 0.768e3 + t1716 * t2215 / 0.144e3 - t5323 / 0.2304e4 + t5326;
  t5504 = my_piecewise3(t105, 0, t5469 + t5502);
  tv4rho2sigma211 = t7 * t5504 + t2197 + t2268;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t5517 = t6 * t4167 * t81;
  t5521 = -t4168 * t935 / 0.768e3 - t5416 / 0.1152e4 + t5314 + 0.3e1 / 0.4e1 * t621 * t938 + t5389 / 0.2e1 - t5239 - 0.3e1 / 0.4e1 * t621 * t943 - t5387 / 0.2e1 + t5247 + t5517 * t949 / 0.768e3 + t5358 / 0.1152e4 - t5144;
  t5522 = my_piecewise3(t2, 0, t5521);
  tv4rho2sigma212 = t7 * t5522 + 0.2e1 * t2210;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t5527 = t136 * t679;
  t5537 = t6 * t4393 * t155;
  t5541 = t6 * t1812 * t297;
  t5545 = t6 * t803 * t670;
  t5549 = t6 * t1812 * params->a2t;
  t5552 = t285 * t303;
  t5566 = -t2255 * t2264 / 0.72e2 - t2219 * t1015 * t5527 * t680 / 0.384e3 + t2219 * t1015 * t2220 * t695 / 0.768e3 + t5537 * t969 / 0.768e3 + t5541 * t969 / 0.384e3 + t5545 * t969 / 0.768e3 + t5549 * t2222 / 0.384e3 - t2219 * t1015 * t5552 * t314 / 0.72e2 + 0.19e2 / 0.432e3 * t967 * t968 * t3638 - t2251 * t2264 / 0.72e2 + t5438 / 0.1152e4 - t5440 / 0.216e3 + t5444 / 0.1152e4 + t5448 / 0.1152e4 - t5352;
  t5567 = t362 * t1432;
  t5589 = t790 * t679;
  t5606 = 0.9e1 / 0.2e1 * t804 * t5567 * t1803 - 0.9e1 * t804 * t4424 * t961 * t680 + 0.9e1 / 0.2e1 * t804 * t4420 * t2242 - 0.3e1 * t804 * t1816 * t2246 + 0.9e1 / 0.4e1 * t804 * t1802 * t961 * t695 - 0.3e1 / 0.2e1 * t804 * t805 * t372 * t1784 - 0.3e1 * t804 * t5589 * t806 - 0.3e1 * t804 * t2230 * t1820 - 0.3e1 / 0.2e1 * t804 * t2230 * t1808 + 0.9e1 / 0.2e1 * t1813 * t2243 - 0.3e1 * t1813 * t2247 - 0.3e1 * t1813 * t2231 - t5457 + 0.3e1 / 0.2e1 * t5459 - t5461;
  t5630 = t816 * t816;
  t5640 = -0.3e1 / 0.4e1 * t637 * t963 - 0.3e1 / 0.2e1 * t271 * t2239 - 0.3e1 / 0.4e1 * t114 * t671 * t962 + 0.3e1 / 0.4e1 * t637 * t958 + 0.3e1 / 0.2e1 * t271 * t2227 + 0.3e1 / 0.2e1 * t271 * t2234 + 0.3e1 / 0.4e1 * t114 * t1757 * t373 + 0.3e1 / 0.2e1 * t114 * t791 * t817 + 0.3e1 / 0.4e1 * t114 * t363 * t1785 - 0.3e1 / 0.2e1 * t114 * t156 * t679 * t5630 + t5475 / 0.2e1 + t5478 / 0.2e1 - t5480 / 0.2e1 - t5483 / 0.2e1 + t5485 / 0.2e1;
  t5674 = t5340 - t5333 - t967 * t2259 * t786 * t695 / 0.384e3 - t2251 * t2261 / 0.192e3 + t967 * t1432 * params->a2b * t51 * t786 * t680 / 0.128e3 + t967 * t2259 * t1752 * t314 / 0.36e2 - t5491 / 0.576e3 - t2255 * t2261 / 0.192e3 - t4394 * t955 / 0.768e3 + 0.9e1 * t804 * t1802 * t806 * t816 - t5493 / 0.1152e4 + t5495 / 0.216e3 + t1813 * t2215 / 0.72e2 - 0.19e2 / 0.432e3 * t804 * t52 * t4329 * t170 + t5326;
  t5677 = my_piecewise3(t105, 0, t5566 + t5606 + t5640 + t5674);
  tv4rho2sigma217 = t7 * t5677 + 0.2e1 * t2268;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  tv4rho2sigmalapl5 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  tv4rho2sigmalapl6 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  tv4rho2sigmalapl11 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  tv4rho2sigmalapl12 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  tv4rho2sigmalapl17 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  t5681 = t6 * t1615 * params->xt;
  t5682 = t5681 * t2308;
  t5687 = t6 * t1611 * params->xt;
  t5706 = 0.5e1 / 0.2592e4 * t5142 * t989;
  t5707 = t2155 * t2317;
  t5709 = t76 * t507;
  t5714 = t5136 * t989;
  t5718 = t5146 * t989;
  t5720 = t389 * t1151;
  t5727 = t3939 * t985;
  t5733 = 0.5e1 / 0.864e3 * t5682 - 0.65e2 / 0.864e3 * t2305 * t2116 + 0.5e1 / 0.288e3 * t5687 * t2308 + 0.5e1 / 0.576e3 * t2305 * t1015 * t2306 * t523 + 0.5e1 / 0.576e3 * t5167 * t989 + 0.5e1 / 0.288e3 * t5171 * t989 + 0.5e1 / 0.576e3 * t5150 * t989 + 0.65e2 / 0.324e3 * t947 * t988 * t1071 - 0.65e2 / 0.864e3 * t2159 * t2317 - t5706 - 0.65e2 / 0.2592e4 * t5707 - 0.5e1 / 0.288e3 * t2305 * t1015 * t5709 * t508 + 0.5e1 / 0.864e3 * t5714 - 0.65e2 / 0.864e3 * t2151 * t2317 + 0.5e1 / 0.864e3 * t5718 + 0.9e1 / 0.4e1 * t737 * t5720 * t1632 + 0.9e1 / 0.4e1 * t737 * t5224 * t1905 - t5727 / 0.2e1 - 0.3e1 / 0.2e1 * t1612 * t2333 - 0.3e1 / 0.2e1 * t1612 * t2337;
  t5763 = t1616 * t2321;
  t5768 = t1616 * t2324;
  t5779 = t837 * t507;
  t5791 = -0.3e1 / 0.4e1 * t737 * t3905 * t984 - 0.3e1 / 0.2e1 * t737 * t1619 * t2332 - 0.3e1 / 0.2e1 * t737 * t1619 * t2336 - 0.3e1 / 0.4e1 * t737 * t738 * t1900 * t344 - 0.3e1 / 0.2e1 * t737 * t738 * t864 * t749 - 0.3e1 / 0.4e1 * t737 * t738 * t401 * t1579 - 0.3e1 / 0.2e1 * t1612 * t2324 - 0.3e1 / 0.2e1 * t737 * t5213 * t853 - 0.3e1 / 0.2e1 * t737 * t2127 * t1916 - t5763 / 0.2e1 - 0.3e1 / 0.4e1 * t737 * t2320 * t1627 - t5768 / 0.2e1 - 0.3e1 / 0.4e1 * t737 * t2127 * t1920 - 0.3e1 / 0.4e1 * t3920 * t985 - 0.3e1 / 0.2e1 * t1612 * t2329 - 0.3e1 / 0.2e1 * t1612 * t2321 - 0.3e1 / 0.2e1 * t737 * t5779 * t739 - 0.3e1 / 0.2e1 * t737 * t2320 * t1623 + 0.3e1 / 0.4e1 * t183 * t2297 + 0.3e1 / 0.8e1 * t27 * t1605 * t402;
  t5800 = t27 * t826 * t750;
  t5802 = t183 * t2281;
  t5823 = t1616 * t2329;
  t5825 = t1616 * t2333;
  t5827 = t1616 * t2337;
  t5830 = t3945 * t985 / 0.6e1;
  t5833 = t27 * t1849 * t345 / 0.12e2;
  t5836 = t27 * t1588 * t402 / 0.12e2;
  t5837 = t183 * t2300;
  t5840 = t27 * t1845 * t345;
  t5842 = 0.3e1 / 0.4e1 * t27 * t721 * t865 + 0.3e1 / 0.8e1 * t27 * t335 * t1901 + t5800 / 0.4e1 + t5802 / 0.4e1 + 0.3e1 / 0.8e1 * t453 * t978 + 0.3e1 / 0.4e1 * t183 * t2286 + 0.3e1 / 0.4e1 * t183 * t2289 + 0.3e1 / 0.8e1 * t27 * t1837 * t345 + 0.3e1 / 0.4e1 * t27 * t838 * t750 + 0.3e1 / 0.8e1 * t27 * t390 * t1580 + 0.3e1 / 0.8e1 * t453 * t981 + 0.3e1 / 0.4e1 * t183 * t2294 - t5823 / 0.2e1 - t5825 / 0.2e1 - t5827 / 0.2e1 + t5830 - t5833 - t5836 + t5837 / 0.4e1 + t5840 / 0.4e1;
  t5844 = t27 * t1594 * t402;
  t5847 = t27 * t706 * t865;
  t5852 = t1151 * params->xb * t51;
  t5862 = t2155 * t2345;
  t5868 = t3939 * t975;
  t5885 = t1616 * t2278;
  t5896 = 0.5e1 / 0.2592e4 * t3945 * t975;
  t5897 = t1616 * t2272;
  t5905 = 0.9e1 / 0.2e1 * t1612 * t2278 + 0.9e1 / 0.2e1 * t737 * t1631 * t2332 * t232 + 0.9e1 / 0.2e1 * t737 * t1631 * t2336 * t232 - 0.5e1 / 0.576e3 * t3920 * t975 + 0.3e1 / 0.2e1 * t5885 + 0.9e1 / 0.4e1 * t737 * t1631 * t984 * t523 - 0.9e1 * t737 * t3931 * t984 * t508 + t5896 + 0.65e2 / 0.2592e4 * t5897 - 0.65e2 / 0.324e3 * t737 * t73 * t2108 + 0.9e1 / 0.2e1 * t737 * t3923 * t2277;
  t5909 = my_piecewise3(t2, 0, t5733 + t5791 + t5842 + t5844 / 0.4e1 + t5847 / 0.4e1 - 0.5e1 / 0.144e3 * t2151 * t2345 + 0.5e1 / 0.96e2 * t947 * t5852 * t330 * t508 + 0.65e2 / 0.432e3 * t947 * t2343 * t2164 - 0.5e1 / 0.144e3 * t2159 * t2345 - 0.5e1 / 0.432e3 * t5862 - 0.5e1 / 0.288e3 * t947 * t2343 * t330 * t523 - 0.5e1 / 0.864e3 * t5868 + 0.65e2 / 0.864e3 * t1612 * t2272 + t5905);
  tv4rho2sigmatau0 = t7 * t5909 + 0.2e1 * t2350;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  t5914 = t4133 * t995;
  t5917 = 0.5e1 / 0.2592e4 * t4137 * t995;
  t5920 = t245 * t2358;
  t5924 = t114 * t1933 * t373 / 0.12e2;
  t5927 = t245 * t2363;
  t5931 = t114 * t1645 * t430 / 0.12e2;
  t5934 = t4133 * t1005;
  t5937 = t4137 * t1005 / 0.6e1;
  t5940 = t5346 * t1009;
  t5943 = 0.5e1 / 0.2592e4 * t5350 * t1009;
  t5944 = -0.5e1 / 0.576e3 * t4129 * t995 - 0.5e1 / 0.864e3 * t5914 + t5917 + 0.3e1 / 0.8e1 * t543 * t998 + t5920 / 0.4e1 - t5924 + 0.3e1 / 0.8e1 * t543 * t1001 + t5927 / 0.4e1 - t5931 - 0.3e1 / 0.4e1 * t4129 * t1005 - t5934 / 0.2e1 + t5937 + 0.5e1 / 0.576e3 * t5342 * t1009 + 0.5e1 / 0.864e3 * t5940 - t5943;
  t5945 = my_piecewise3(t105, 0, t5944);
  tv4rho2sigmatau5 = t7 * t5945 + 0.2e1 * t2375;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  t5954 = t6 * t1676 * params->xt;
  t5958 = t5357 * t989;
  t5963 = t4060 * t985;
  t5967 = -0.65e2 / 0.1728e4 * t2206 * t2317 + 0.5e1 / 0.576e3 * t5368 * t989 + 0.5e1 / 0.576e3 * t5372 * t989 + 0.5e1 / 0.576e3 * t5954 * t2308 + 0.5e1 / 0.1728e4 * t5682 + 0.5e1 / 0.1728e4 * t5958 - t5706 - 0.65e2 / 0.5184e4 * t5707 + 0.5e1 / 0.1728e4 * t5714 + 0.5e1 / 0.1728e4 * t5718 - t5963 / 0.4e1 - 0.3e1 / 0.4e1 * t1677 * t2324;
  t5991 = -0.3e1 / 0.4e1 * t4056 * t985 - 0.3e1 / 0.4e1 * t1677 * t2329 - 0.3e1 / 0.4e1 * t1677 * t2333 - 0.3e1 / 0.4e1 * t1677 * t2337 - 0.3e1 / 0.4e1 * t1677 * t2321 - t5727 / 0.4e1 - t5763 / 0.4e1 - t5768 / 0.4e1 + 0.3e1 / 0.8e1 * t565 * t981 + 0.3e1 / 0.8e1 * t261 * t2294 + 0.3e1 / 0.8e1 * t261 * t2297 + 0.3e1 / 0.8e1 * t565 * t978 + 0.3e1 / 0.8e1 * t261 * t2286;
  t5995 = t261 * t2300;
  t5997 = t261 * t2281;
  t6005 = 0.3e1 / 0.8e1 * t261 * t2289 + t5995 / 0.8e1 + t5997 / 0.8e1 + t5800 / 0.8e1 + t5802 / 0.8e1 - t5823 / 0.4e1 - t5825 / 0.4e1 - t5827 / 0.4e1 + t5830 - t5833 - t5836 + t5837 / 0.8e1;
  t6012 = t4060 * t975;
  t6023 = t5840 / 0.8e1 + t5844 / 0.8e1 + t5847 / 0.8e1 - 0.5e1 / 0.288e3 * t2206 * t2345 - 0.5e1 / 0.864e3 * t5862 - 0.5e1 / 0.1728e4 * t6012 + 0.65e2 / 0.1728e4 * t1677 * t2272 - 0.5e1 / 0.1728e4 * t5868 - 0.5e1 / 0.576e3 * t4056 * t975 + 0.9e1 / 0.4e1 * t1677 * t2278 + 0.3e1 / 0.4e1 * t5885 + t5896 + 0.65e2 / 0.5184e4 * t5897;
  t6026 = my_piecewise3(t2, 0, t5967 + t5991 + t6005 + t6023);
  tv4rho2sigmatau6 = t7 * t6026 + t2350 + t2388;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  t6036 = t271 * t2358;
  t6043 = t114 * t1696 * t430;
  t6046 = t114 * t759 * t927;
  t6048 = t5447 * t1009;
  t6054 = 0.3e1 / 0.8e1 * t245 * t2404 + 0.3e1 / 0.8e1 * t588 * t1001 + 0.3e1 / 0.8e1 * t245 * t2409 + 0.3e1 / 0.8e1 * t245 * t2412 + t6036 / 0.8e1 + 0.3e1 / 0.8e1 * t588 * t998 + 0.3e1 / 0.8e1 * t245 * t2401 + t6043 / 0.8e1 + t6046 / 0.8e1 + 0.5e1 / 0.1728e4 * t6048 + 0.5e1 / 0.576e3 * t5427 * t1009 - 0.65e2 / 0.1728e4 * t2189 * t2427;
  t6056 = t6 * t1715 * params->xt;
  t6061 = t5437 * t1009;
  t6063 = t2193 * t2427;
  t6066 = t6 * t1719 * params->xt;
  t6067 = t6066 * t2420;
  t6070 = t1720 * t2438;
  t6072 = t1720 * t2442;
  t6074 = t1720 * t2445;
  t6076 = t4255 * t1005;
  t6078 = t1720 * t2430;
  t6080 = t1720 * t2434;
  t6082 = 0.5e1 / 0.576e3 * t6056 * t2420 + 0.5e1 / 0.576e3 * t5423 * t1009 + 0.5e1 / 0.1728e4 * t6061 - 0.65e2 / 0.5184e4 * t6063 + 0.5e1 / 0.1728e4 * t6067 + 0.5e1 / 0.1728e4 * t5940 - t5943 - t6070 / 0.4e1 - t6072 / 0.4e1 - t6074 / 0.4e1 - t6076 / 0.4e1 - t6078 / 0.4e1 - t6080 / 0.4e1;
  t6098 = t114 * t1982 * t373;
  t6101 = t114 * t874 * t817;
  t6103 = t271 * t2363;
  t6106 = -0.3e1 / 0.4e1 * t1716 * t2434 - 0.3e1 / 0.4e1 * t1716 * t2438 - 0.3e1 / 0.4e1 * t1716 * t2442 - 0.3e1 / 0.4e1 * t1716 * t2445 - 0.3e1 / 0.4e1 * t4271 * t1005 - 0.3e1 / 0.4e1 * t1716 * t2430 - t5934 / 0.4e1 + t5937 + t6098 / 0.8e1 + t6101 / 0.8e1 + t6103 / 0.8e1 + t5920 / 0.8e1;
  t6110 = t2193 * t2453;
  t6112 = t4255 * t995;
  t6114 = t1720 * t2396;
  t6116 = t1720 * t2390;
  t6125 = -t5924 + t5927 / 0.8e1 - t5931 - 0.5e1 / 0.288e3 * t2189 * t2453 - 0.5e1 / 0.864e3 * t6110 - 0.5e1 / 0.1728e4 * t6112 + 0.3e1 / 0.4e1 * t6114 + 0.65e2 / 0.5184e4 * t6116 - 0.5e1 / 0.576e3 * t4271 * t995 + 0.9e1 / 0.4e1 * t1716 * t2396 + 0.65e2 / 0.1728e4 * t1716 * t2390 - 0.5e1 / 0.1728e4 * t5914 + t5917;
  t6128 = my_piecewise3(t105, 0, t6054 + t6082 + t6106 + t6125);
  tv4rho2sigmatau11 = t7 * t6128 + t2375 + t2458;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  t6146 = -0.5e1 / 0.576e3 * t4168 * t975 - 0.5e1 / 0.864e3 * t6012 + t5896 + 0.3e1 / 0.8e1 * t621 * t978 + t5995 / 0.4e1 - t5833 + 0.3e1 / 0.8e1 * t621 * t981 + t5997 / 0.4e1 - t5836 - 0.3e1 / 0.4e1 * t4168 * t985 - t5963 / 0.2e1 + t5830 + 0.5e1 / 0.576e3 * t5517 * t989 + 0.5e1 / 0.864e3 * t5958 - t5706;
  t6147 = my_piecewise3(t2, 0, t6146);
  tv4rho2sigmatau12 = t7 * t6147 + 0.2e1 * t2388;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  t6190 = t150 * t679;
  t6197 = 0.3e1 / 0.8e1 * t637 * t998 + 0.3e1 / 0.4e1 * t271 * t2401 + 0.3e1 / 0.4e1 * t271 * t2404 + 0.3e1 / 0.8e1 * t114 * t2032 * t373 + 0.3e1 / 0.4e1 * t114 * t903 * t817 + 0.3e1 / 0.8e1 * t114 * t418 * t1785 + 0.3e1 / 0.8e1 * t637 * t1001 + 0.3e1 / 0.4e1 * t271 * t2409 + 0.3e1 / 0.4e1 * t271 * t2412 + 0.3e1 / 0.8e1 * t114 * t1757 * t430 + 0.3e1 / 0.4e1 * t114 * t791 * t927 + 0.3e1 / 0.8e1 * t114 * t363 * t2053 + t6036 / 0.4e1 + t6043 / 0.4e1 + t6046 / 0.4e1 + 0.65e2 / 0.324e3 * t967 * t1008 * t1462 - 0.65e2 / 0.864e3 * t2251 * t2427 - 0.65e2 / 0.864e3 * t2255 * t2427 - 0.5e1 / 0.288e3 * t2417 * t1015 * t6190 * t680 + 0.5e1 / 0.576e3 * t5537 * t1009;
  t6205 = t6 * t1812 * params->xt;
  t6235 = t902 * t679;
  t6247 = 0.5e1 / 0.288e3 * t5541 * t1009 + 0.5e1 / 0.576e3 * t5545 * t1009 - 0.65e2 / 0.864e3 * t2417 * t2222 + 0.5e1 / 0.288e3 * t6205 * t2420 + 0.5e1 / 0.576e3 * t2417 * t1015 * t2418 * t695 + 0.5e1 / 0.864e3 * t6048 + 0.5e1 / 0.864e3 * t6061 - 0.65e2 / 0.2592e4 * t6063 + 0.5e1 / 0.864e3 * t6067 - t5943 + 0.9e1 / 0.4e1 * t804 * t5567 * t2082 - 0.3e1 / 0.4e1 * t804 * t805 * t2052 * t372 - 0.3e1 / 0.2e1 * t804 * t805 * t926 * t816 - 0.3e1 / 0.2e1 * t1813 * t2438 - 0.3e1 / 0.4e1 * t804 * t805 * t429 * t1784 - 0.3e1 / 0.2e1 * t1813 * t2442 - 0.3e1 / 0.2e1 * t804 * t6235 * t806 - 0.3e1 / 0.2e1 * t804 * t2441 * t1820 - 0.3e1 / 0.4e1 * t804 * t2441 * t1808 - 0.3e1 / 0.2e1 * t1813 * t2445;
  t6273 = t417 * t1432;
  t6286 = -0.3e1 / 0.2e1 * t804 * t5589 * t915 - 0.3e1 / 0.2e1 * t804 * t2230 * t2089 - 0.3e1 / 0.4e1 * t804 * t2230 * t2093 - 0.3e1 / 0.4e1 * t4394 * t1005 - 0.3e1 / 0.2e1 * t1813 * t2430 - 0.3e1 / 0.4e1 * t804 * t4401 * t1004 - 0.3e1 / 0.2e1 * t804 * t1816 * t2433 - 0.3e1 / 0.2e1 * t804 * t1816 * t2437 - 0.3e1 / 0.2e1 * t1813 * t2434 + 0.9e1 / 0.4e1 * t804 * t6273 * t1803 - t6070 / 0.2e1 - t6072 / 0.2e1 - t6074 / 0.2e1 - t6076 / 0.2e1 - t6078 / 0.2e1 - t6080 / 0.2e1 + t5937 + t6098 / 0.4e1 + t6101 / 0.4e1 + t6103 / 0.4e1;
  t6288 = t1432 * params->xb * t51;
  t6337 = -0.5e1 / 0.576e3 * t4394 * t995 + 0.9e1 / 0.4e1 * t804 * t1802 * t1004 * t695 + 0.9e1 / 0.2e1 * t804 * t4420 * t2395 + 0.9e1 / 0.2e1 * t804 * t1802 * t2433 * t314 + 0.9e1 / 0.2e1 * t804 * t1802 * t2437 * t314 + 0.9e1 / 0.2e1 * t1813 * t2396 - 0.5e1 / 0.864e3 * t6112 + 0.3e1 / 0.2e1 * t6114 + 0.65e2 / 0.2592e4 * t6116 - 0.9e1 * t804 * t4424 * t1004 * t680 + t5917;
  t6341 = my_piecewise3(t105, 0, t6197 + t6247 + t6286 - t5924 - t5931 + 0.5e1 / 0.96e2 * t967 * t6288 * t358 * t680 + 0.65e2 / 0.432e3 * t967 * t2451 * t2260 - 0.5e1 / 0.144e3 * t2251 * t2453 - 0.5e1 / 0.144e3 * t2255 * t2453 - 0.5e1 / 0.288e3 * t967 * t2451 * t358 * t695 - 0.5e1 / 0.432e3 * t6110 - 0.65e2 / 0.324e3 * t804 * t73 * t2214 + 0.65e2 / 0.864e3 * t1813 * t2390 + t6337);
  tv4rho2sigmatau17 = t7 * t6341 + 0.2e1 * t2458;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  tv4rho2lapl22 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  tv4rho2lapl23 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  tv4rho2lapl25 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  tv4rho2lapl26 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  tv4rho2lapl28 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  t6360 = t27 * t468 * t1024;
  t6370 = t27 * t1845 * t402;
  t6373 = t27 * t826 * t865;
  t6377 = t27 * t464 * t1024 / 0.6e1;
  t6378 = t183 * t2477;
  t6382 = t27 * t1849 * t402 / 0.6e1;
  t6383 = 0.3e1 / 0.2e1 * t183 * t2486 + 0.3e1 / 0.4e1 * t27 * t1837 * t402 + 0.3e1 / 0.2e1 * t27 * t838 * t865 + 0.3e1 / 0.4e1 * t27 * t390 * t1901 - 0.3e1 / 0.4e1 * t453 * t1025 - 0.3e1 / 0.2e1 * t183 * t2494 - t6360 / 0.2e1 - 0.3e1 / 0.4e1 * t27 * t499 * t1024 + 0.3e1 / 0.4e1 * t453 * t1020 + 0.3e1 / 0.2e1 * t183 * t2480 + t6370 / 0.2e1 + t6373 / 0.2e1 + t6377 + t6378 / 0.2e1 - t6382;
  t6384 = t864 * t864;
  t6389 = t183 * t2491;
  t6391 = t5136 * t1029;
  t6396 = 0.25e2 / 0.486e3 * t5142 * t1029;
  t6397 = t2155 * t2517;
  t6416 = t5146 * t1029;
  t6421 = t6 * t1611 * params->b2t;
  t6424 = -0.3e1 / 0.2e1 * t27 * t82 * t507 * t6384 - t6389 / 0.2e1 + 0.25e2 / 0.162e3 * t6391 - 0.125e3 / 0.81e2 * t2151 * t2517 - t6396 - 0.125e3 / 0.243e3 * t6397 - 0.9e1 * t737 * t3931 * t1023 * t508 + 0.9e1 / 0.2e1 * t737 * t5720 * t1905 - 0.125e3 / 0.81e2 * t2469 * t2308 + 0.25e2 / 0.108e3 * t2469 * t69 * t2470 * t523 + 0.25e2 / 0.108e3 * t5167 * t1029 + 0.25e2 / 0.54e2 * t5171 * t1029 + 0.25e2 / 0.162e3 * t6416 + 0.25e2 / 0.108e3 * t5150 * t1029 + 0.25e2 / 0.54e2 * t6421 * t2472;
  t6427 = t6 * t1615 * params->b2t;
  t6428 = t6427 * t2472;
  t6435 = t54 * t507;
  t6453 = t1616 * t2498;
  t6455 = t1616 * t2502;
  t6464 = t1616 * t2483;
  t6465 = 0.25e2 / 0.162e3 * t6428 - 0.125e3 / 0.81e2 * t2159 * t2517 + 0.1625e4 / 0.486e3 * t947 * t1028 * t491 - 0.25e2 / 0.54e2 * t2469 * t69 * t6435 * t508 - 0.3e1 * t737 * t5779 * t853 - 0.3e1 * t737 * t2320 * t1916 - 0.3e1 / 0.2e1 * t737 * t2320 * t1920 + 0.9e1 / 0.2e1 * t1612 * t2498 - 0.3e1 * t1612 * t2502 + 0.3e1 / 0.2e1 * t6453 - t6455 + 0.9e1 / 0.2e1 * t737 * t3923 * t2497 - 0.3e1 * t737 * t1619 * t2501 - 0.3e1 * t1612 * t2483 - t6464;
  t6474 = t2155 * t2514;
  t6477 = t1151 * params->b2b * t68;
  t6482 = t2511 * t76;
  t6497 = 0.25e2 / 0.486e3 * t3945 * t1017;
  t6498 = t1616 * t2465;
  t6510 = t3939 * t1017;
  t6512 = 0.9e1 / 0.4e1 * t737 * t1631 * t1023 * t523 - 0.3e1 / 0.2e1 * t737 * t738 * t401 * t1900 - 0.25e2 / 0.81e2 * t6474 + 0.25e2 / 0.18e2 * t947 * t6477 * t1015 * t508 + 0.25e3 / 0.81e2 * t947 * t6482 * t2513 - 0.25e2 / 0.27e2 * t2159 * t2514 - 0.25e2 / 0.54e2 * t947 * t2512 * t1015 * t523 - 0.25e2 / 0.27e2 * t2151 * t2514 + 0.125e3 / 0.81e2 * t1612 * t2465 + t6497 + 0.125e3 / 0.243e3 * t6498 + 0.9e1 * t737 * t1631 * t853 * t864 - 0.25e2 / 0.108e3 * t3920 * t1017 - 0.1625e4 / 0.486e3 * t737 * params->b2t * t60 * t1016 - 0.25e2 / 0.162e3 * t6510;
  t6515 = my_piecewise3(t2, 0, t6383 + t6424 + t6465 + t6512);
  tv4rho2tau20 = t7 * t6515 + 0.2e1 * t2521;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  t6520 = t4133 * t1036;
  t6523 = 0.25e2 / 0.486e3 * t4137 * t1036;
  t6526 = t245 * t2529;
  t6530 = t114 * t1933 * t430 / 0.6e1;
  t6533 = t245 * t2534;
  t6537 = t114 * t548 * t1043 / 0.6e1;
  t6540 = t5346 * t1048;
  t6543 = 0.25e2 / 0.486e3 * t5350 * t1048;
  t6544 = -0.25e2 / 0.108e3 * t4129 * t1036 - 0.25e2 / 0.162e3 * t6520 + t6523 + 0.3e1 / 0.4e1 * t543 * t1039 + t6526 / 0.2e1 - t6530 - 0.3e1 / 0.4e1 * t543 * t1044 - t6533 / 0.2e1 + t6537 + 0.25e2 / 0.108e3 * t5342 * t1048 + 0.25e2 / 0.162e3 * t6540 - t6543;
  t6545 = my_piecewise3(t105, 0, t6544);
  tv4rho2tau22 = t7 * t6545 + 0.2e1 * t2542;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  t6557 = t261 * t2477;
  t6559 = t261 * t2491;
  t6566 = t5357 * t1029;
  t6572 = 0.3e1 / 0.4e1 * t565 * t1020 + 0.3e1 / 0.4e1 * t261 * t2480 + 0.3e1 / 0.4e1 * t261 * t2486 - 0.3e1 / 0.4e1 * t565 * t1025 - 0.3e1 / 0.4e1 * t261 * t2494 + t6557 / 0.4e1 - t6559 / 0.4e1 - t6360 / 0.4e1 + t6370 / 0.4e1 + t6373 / 0.4e1 + t6377 + t6378 / 0.4e1 - t6382 - t6389 / 0.4e1 + 0.25e2 / 0.324e3 * t6566 - 0.125e3 / 0.162e3 * t2206 * t2517 + 0.25e2 / 0.324e3 * t6391 - t6396 - 0.125e3 / 0.486e3 * t6397;
  t6574 = t6 * t1676 * params->b2t;
  t6596 = t4060 * t1017;
  t6603 = 0.25e2 / 0.108e3 * t6574 * t2472 + 0.25e2 / 0.108e3 * t5368 * t1029 + 0.25e2 / 0.108e3 * t5372 * t1029 - 0.3e1 / 0.2e1 * t1677 * t2483 + 0.9e1 / 0.4e1 * t1677 * t2498 - 0.3e1 / 0.2e1 * t1677 * t2502 + 0.25e2 / 0.324e3 * t6416 + 0.25e2 / 0.324e3 * t6428 + 0.3e1 / 0.4e1 * t6453 - t6455 / 0.2e1 - t6464 / 0.2e1 - 0.25e2 / 0.162e3 * t6474 - 0.25e2 / 0.54e2 * t2206 * t2514 + t6497 + 0.125e3 / 0.486e3 * t6498 - 0.25e2 / 0.324e3 * t6596 + 0.125e3 / 0.162e3 * t1677 * t2465 - 0.25e2 / 0.108e3 * t4056 * t1017 - 0.25e2 / 0.324e3 * t6510;
  t6605 = my_piecewise3(t2, 0, t6572 + t6603);
  tv4rho2tau23 = t7 * t6605 + t2521 + t2553;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  t6618 = t114 * t1982 * t430;
  t6621 = t114 * t874 * t927;
  t6623 = t271 * t2534;
  t6626 = t114 * t596 * t1043;
  t6628 = t271 * t2529;
  t6633 = t6 * t1715 * params->b2t;
  t6642 = t5447 * t1048;
  t6644 = 0.3e1 / 0.4e1 * t588 * t1039 + 0.3e1 / 0.4e1 * t245 * t2570 + 0.3e1 / 0.4e1 * t245 * t2576 - 0.3e1 / 0.4e1 * t588 * t1044 - 0.3e1 / 0.4e1 * t245 * t2581 + t6618 / 0.4e1 + t6621 / 0.4e1 - t6623 / 0.4e1 - t6626 / 0.4e1 + t6628 / 0.4e1 + t6537 + t6526 / 0.4e1 - t6530 - t6533 / 0.4e1 + 0.25e2 / 0.108e3 * t6633 * t2565 + 0.25e2 / 0.108e3 * t5423 * t1048 + 0.25e2 / 0.108e3 * t5427 * t1048 - 0.125e3 / 0.162e3 * t2189 * t2602 + 0.25e2 / 0.324e3 * t6642;
  t6645 = t5437 * t1048;
  t6647 = t2193 * t2602;
  t6650 = t6 * t1719 * params->b2t;
  t6651 = t6650 * t2565;
  t6656 = t2193 * t2599;
  t6664 = t1720 * t2573;
  t6666 = t1720 * t2585;
  t6668 = t1720 * t2589;
  t6670 = t4255 * t1036;
  t6672 = t1720 * t2558;
  t6679 = 0.25e2 / 0.324e3 * t6645 - 0.125e3 / 0.486e3 * t6647 + 0.25e2 / 0.324e3 * t6651 + 0.25e2 / 0.324e3 * t6540 - t6543 - 0.25e2 / 0.54e2 * t2189 * t2599 - 0.25e2 / 0.162e3 * t6656 - 0.3e1 / 0.2e1 * t1716 * t2573 + 0.9e1 / 0.4e1 * t1716 * t2585 - 0.3e1 / 0.2e1 * t1716 * t2589 - t6664 / 0.2e1 + 0.3e1 / 0.4e1 * t6666 - t6668 / 0.2e1 - 0.25e2 / 0.324e3 * t6670 + 0.125e3 / 0.486e3 * t6672 - 0.25e2 / 0.108e3 * t4271 * t1036 + 0.125e3 / 0.162e3 * t1716 * t2558 - 0.25e2 / 0.324e3 * t6520 + t6523;
  t6681 = my_piecewise3(t105, 0, t6644 + t6679);
  tv4rho2tau25 = t7 * t6681 + t2542 + t2606;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  t6696 = -0.25e2 / 0.108e3 * t4168 * t1017 - 0.25e2 / 0.162e3 * t6596 + t6497 + 0.3e1 / 0.4e1 * t621 * t1020 + t6557 / 0.2e1 - t6382 - 0.3e1 / 0.4e1 * t621 * t1025 - t6559 / 0.2e1 + t6377 + 0.25e2 / 0.108e3 * t5517 * t1029 + 0.25e2 / 0.162e3 * t6566 - t6396;
  t6697 = my_piecewise3(t2, 0, t6696);
  tv4rho2tau26 = t7 * t6697 + 0.2e1 * t2553;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  t6719 = t926 * t926;
  t6732 = 0.3e1 / 0.4e1 * t637 * t1039 + 0.3e1 / 0.2e1 * t271 * t2570 + 0.3e1 / 0.2e1 * t271 * t2576 + 0.3e1 / 0.4e1 * t114 * t2032 * t430 + 0.3e1 / 0.2e1 * t114 * t903 * t927 + 0.3e1 / 0.4e1 * t114 * t418 * t2053 - 0.3e1 / 0.4e1 * t637 * t1044 - 0.3e1 / 0.2e1 * t271 * t2581 - 0.3e1 / 0.2e1 * t114 * t156 * t679 * t6719 - 0.3e1 / 0.4e1 * t114 * t671 * t1043 + t6618 / 0.2e1 + t6621 / 0.2e1 - t6623 / 0.2e1 - t6626 / 0.2e1 + t6628 / 0.2e1;
  t6735 = t54 * t679;
  t6755 = t6 * t1812 * params->b2t;
  t6769 = t6537 - t6530 - 0.125e3 / 0.81e2 * t2255 * t2602 - 0.25e2 / 0.54e2 * t2562 * t145 * t6735 * t680 - 0.125e3 / 0.81e2 * t2251 * t2602 + 0.25e2 / 0.108e3 * t5545 * t1048 - 0.125e3 / 0.81e2 * t2562 * t2420 + 0.25e2 / 0.108e3 * t2562 * t145 * t2563 * t695 + 0.25e2 / 0.108e3 * t5537 * t1048 + 0.25e2 / 0.54e2 * t5541 * t1048 + 0.25e2 / 0.54e2 * t6755 * t2565 + 0.1625e4 / 0.486e3 * t967 * t1047 * t663 + 0.9e1 / 0.2e1 * t804 * t6273 * t2082 - 0.9e1 * t804 * t4424 * t1042 * t680 + 0.25e2 / 0.162e3 * t6642;
  t6783 = t1432 * params->b2b * t144;
  t6788 = t2596 * t150;
  t6807 = 0.25e2 / 0.162e3 * t6645 - 0.125e3 / 0.243e3 * t6647 + 0.25e2 / 0.162e3 * t6651 - t6543 - 0.25e2 / 0.27e2 * t2255 * t2599 - 0.25e2 / 0.54e2 * t967 * t2597 * t1015 * t695 - 0.25e2 / 0.27e2 * t2251 * t2599 + 0.25e2 / 0.18e2 * t967 * t6783 * t1015 * t680 + 0.25e3 / 0.81e2 * t967 * t6788 * t2598 - 0.25e2 / 0.81e2 * t6656 + 0.9e1 / 0.2e1 * t1813 * t2585 - 0.3e1 * t1813 * t2589 + 0.9e1 / 0.2e1 * t804 * t4420 * t2584 - 0.3e1 * t804 * t1816 * t2588 + 0.9e1 / 0.4e1 * t804 * t1802 * t1042 * t695;
  t6838 = -0.3e1 / 0.2e1 * t804 * t805 * t429 * t2052 - 0.3e1 * t1813 * t2573 - 0.3e1 * t804 * t6235 * t915 - 0.3e1 * t804 * t2441 * t2089 - 0.3e1 / 0.2e1 * t804 * t2441 * t2093 - t6664 + 0.3e1 / 0.2e1 * t6666 - t6668 + 0.9e1 * t804 * t1802 * t915 * t926 - 0.25e2 / 0.108e3 * t4394 * t1036 - 0.25e2 / 0.162e3 * t6670 + 0.125e3 / 0.243e3 * t6672 - 0.1625e4 / 0.486e3 * t804 * params->b2t * t136 * t1035 + 0.125e3 / 0.81e2 * t1813 * t2558 + t6523;
  t6841 = my_piecewise3(t105, 0, t6732 + t6769 + t6807 + t6838);
  tv4rho2tau28 = t7 * t6841 + 0.2e1 * t2606;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t6844 = t27 * t82 * t1151;
  t6860 = 0.3e1 / 0.4e1 * t27 * t706 * t942;
  t6863 = 0.3e1 / 0.4e1 * t27 * t188 * t2620;
  t6871 = t6 * t1611 * t334;
  t6875 = t6 * t736 * t720;
  t6881 = t5154 * t2609 / 0.768e3;
  t6886 = 0.3e1 / 0.128e3 * t6844 * t344 * params->a2b * t51 * t2164 - 0.9e1 / 0.4e1 * t27 * t721 * t942 + 0.9e1 / 0.4e1 * t183 * t2621 + 0.9e1 / 0.4e1 * t27 * t216 * t2620 - t6860 + t6863 - 0.9e1 / 0.4e1 * t183 * t2612 + t2113 * t1015 * t2114 * t749 / 0.256e3 + t6871 * t949 / 0.256e3 + t6875 * t949 / 0.256e3 + t5175 * t2609 / 0.256e3 + t6881 - t2113 * t1015 * t5157 * t344 / 0.48e2;
  t6888 = t6 * t1615 * t334;
  t6890 = t6888 * t949 / 0.768e3;
  t6914 = t2624 * t232;
  t6921 = t2155 * t2626 / 0.384e3;
  t6927 = t6890 - t2616 * t2168 / 0.48e2 + 0.27e2 / 0.4e1 * t737 * t5224 * t2142 - 0.9e1 / 0.2e1 * t737 * t2127 * t2146 - 0.9e1 * t737 * t3931 * t2619 * t232 + 0.27e2 / 0.4e1 * t737 * t1631 * t941 * t749 - t2159 * t2626 / 0.128e3 - t947 * t507 * t749 * params->a2b * t491 / 0.128e3 - t2113 * t491 * t6914 / 0.128e3 - t2616 * t2165 / 0.128e3 - t6921 + t947 * t2625 * t1071 / 0.24e2 - t2151 * t2626 / 0.128e3;
  t6929 = my_piecewise3(t2, 0, t6886 + t6927);
  tv4rhosigma30 = t7 * t6929 + t2630;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t6934 = t5443 * t2632 / 0.768e3;
  t6939 = 0.3e1 / 0.4e1 * t114 * t759 * t962;
  t6941 = t6 * t1715 * t362;
  t6945 = t6 * t1719 * t362;
  t6947 = t6945 * t969 / 0.768e3;
  t6952 = 0.3e1 / 0.4e1 * t114 * t248 * t2643;
  t6956 = t2193 * t2649 / 0.384e3;
  t6958 = my_piecewise3(t105, 0, t5433 * t2632 / 0.256e3 + t6934 - 0.9e1 / 0.4e1 * t245 * t2635 - t6939 + t6941 * t969 / 0.256e3 + t6947 + 0.9e1 / 0.4e1 * t245 * t2644 + t6952 - t2189 * t2649 / 0.128e3 - t6956);
  tv4rhosigma39 = t7 * t6958 + t2653;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t6965 = t6 * t1676 * t334;
  t6973 = my_piecewise3(t2, 0, t5364 * t2609 / 0.256e3 + t6881 - 0.9e1 / 0.4e1 * t261 * t2612 - t6860 + t6965 * t949 / 0.256e3 + t6890 + 0.9e1 / 0.4e1 * t261 * t2621 + t6863 - t2206 * t2626 / 0.128e3 - t6921);
  tv4rhosigma310 = t7 * t6973 + t2630;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t6976 = t114 * t156 * t1432;
  t7005 = t6 * t1812 * t362;
  t7009 = t6 * t803 * t790;
  t7012 = 0.3e1 / 0.128e3 * t6976 * t372 * params->a2b * t51 * t2260 + 0.9e1 / 0.4e1 * t271 * t2644 + 0.9e1 / 0.4e1 * t114 * t298 * t2643 - 0.9e1 / 0.4e1 * t271 * t2635 - 0.9e1 / 0.4e1 * t114 * t791 * t962 - t6939 + t6952 - t2639 * t2264 / 0.48e2 - t2219 * t1015 * t5552 * t372 / 0.48e2 + t5549 * t2632 / 0.256e3 + t2219 * t1015 * t2220 * t816 / 0.256e3 + t7005 * t969 / 0.256e3 + t7009 * t969 / 0.256e3;
  t7038 = t2647 * t314;
  t7045 = t6934 + t6947 + 0.27e2 / 0.4e1 * t804 * t5567 * t2242 - 0.9e1 / 0.2e1 * t804 * t2230 * t2246 - 0.9e1 * t804 * t4424 * t2642 * t314 + 0.27e2 / 0.4e1 * t804 * t1802 * t961 * t816 - t2639 * t2261 / 0.128e3 - t2251 * t2649 / 0.128e3 - t2255 * t2649 / 0.128e3 - t967 * t679 * t816 * params->a2b * t663 / 0.128e3 - t2219 * t663 * t7038 / 0.128e3 + t967 * t2648 * t1462 / 0.24e2 - t6956;
  t7047 = my_piecewise3(t105, 0, t7012 + t7045);
  tv4rhosigma319 = t7 * t7047 + t2653;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  tv4rhosigma2lapl11 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  tv4rhosigma2lapl12 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  tv4rhosigma2lapl23 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  t7066 = t27 * t826 * t942 / 0.4e1;
  t7068 = t6 * t1615 * t389;
  t7070 = t7068 * t949 / 0.2304e4;
  t7074 = t5154 * t2666 / 0.2304e4;
  t7080 = 0.5e1 / 0.864e3 * t6888 * t989;
  t7082 = 0.5e1 / 0.864e3 * t5681 * t2655;
  t7085 = 0.5e1 / 0.48e2 * t6844 * t96 * t76 * t344 * t232 + t6844 * t401 * params->a2b * t51 * t2164 / 0.128e3 - 0.3e1 / 0.4e1 * t183 * t2658 - 0.3e1 / 0.4e1 * t27 * t838 * t942 - t7066 + t7070 - t2662 * t2168 / 0.144e3 + t7074 - t2113 * t1015 * t5157 * t401 / 0.144e3 + t7080 + t7082 + 0.5e1 / 0.288e3 * t5687 * t2655;
  t7091 = t6 * t1611 * t389;
  t7095 = t6 * t736 * t837;
  t7120 = 0.5e1 / 0.288e3 * t2305 * t1015 * t2306 * t749 + t7091 * t949 / 0.768e3 + t7095 * t949 / 0.768e3 + t5175 * t2666 / 0.768e3 + t2113 * t1015 * t2114 * t864 / 0.768e3 + 0.5e1 / 0.288e3 * t6871 * t989 + 0.5e1 / 0.288e3 * t6875 * t989 - 0.65e2 / 0.864e3 * t2616 * t2317 - 0.65e2 / 0.864e3 * t2305 * t2609 - 0.3e1 / 0.2e1 * t1612 * t2669 - 0.3e1 / 0.2e1 * t737 * t5213 * t984 - 0.3e1 / 0.2e1 * t737 * t2127 * t2332;
  t7135 = t1616 * t2669 / 0.2e1;
  t7137 = 0.3e1 / 0.4e1 * t1616 * t2675;
  t7144 = t2682 * t232;
  t7151 = t2155 * t2684 / 0.1152e4;
  t7155 = -0.3e1 / 0.2e1 * t737 * t2127 * t2336 + 0.9e1 / 0.4e1 * t1612 * t2675 + 0.9e1 / 0.4e1 * t737 * t3923 * t2674 + 0.9e1 / 0.4e1 * t737 * t1631 * t864 * t941 - t7135 + t7137 + 0.9e1 / 0.4e1 * t737 * t5720 * t2142 - 0.3e1 / 0.2e1 * t737 * t2320 * t2146 - t2113 * t491 * t7144 / 0.384e3 - 0.5e1 / 0.144e3 * t2616 * t2345 - t7151 + t947 * t2683 * t1071 / 0.72e2;
  t7157 = 0.5e1 / 0.432e3 * t2155 * t2679;
  t7174 = t507 * t864;
  t7195 = -t7157 + 0.65e2 / 0.432e3 * t947 * t2343 * t716 * t344 - 0.5e1 / 0.144e3 * t2151 * t2679 - 0.5e1 / 0.144e3 * t2159 * t2679 - 0.5e1 / 0.144e3 * t947 * t2343 * t330 * t749 - t2151 * t2684 / 0.384e3 - t2159 * t2684 / 0.384e3 - t947 * t7174 * params->a2b * t491 / 0.384e3 - 0.5e1 / 0.144e3 * t2305 * t208 * t6914 - t2662 * t2165 / 0.384e3 + 0.9e1 / 0.2e1 * t737 * t5224 * t2277 - 0.9e1 * t737 * t3931 * t2674 * t232 + 0.9e1 / 0.2e1 * t737 * t1631 * t984 * t749;
  t7198 = my_piecewise3(t2, 0, t7085 + t7120 + t7155 + t7195);
  tv4rhosigma2tau0 = t7 * t7198 + t2688;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  t7203 = 0.5e1 / 0.864e3 * t6066 * t2690;
  t7208 = t114 * t874 * t962 / 0.4e1;
  t7210 = t6 * t1715 * t417;
  t7214 = t6 * t1719 * t417;
  t7216 = t7214 * t969 / 0.2304e4;
  t7220 = t5443 * t2701 / 0.2304e4;
  t7224 = t1720 * t2704 / 0.2e1;
  t7228 = 0.5e1 / 0.864e3 * t6945 * t1009;
  t7232 = 0.3e1 / 0.4e1 * t1720 * t2710;
  t7236 = 0.5e1 / 0.432e3 * t2193 * t2714;
  t7240 = t2193 * t2719 / 0.1152e4;
  t7241 = 0.5e1 / 0.288e3 * t6056 * t2690 + t7203 - 0.3e1 / 0.4e1 * t245 * t2693 - t7208 + t7210 * t969 / 0.768e3 + t7216 + t5433 * t2701 / 0.768e3 + t7220 - 0.3e1 / 0.2e1 * t1716 * t2704 - t7224 + 0.5e1 / 0.288e3 * t6941 * t1009 + t7228 + 0.9e1 / 0.4e1 * t1716 * t2710 + t7232 - 0.5e1 / 0.144e3 * t2189 * t2714 - t7236 - t2189 * t2719 / 0.384e3 - t7240;
  t7242 = my_piecewise3(t105, 0, t7241);
  tv4rhosigma2tau11 = t7 * t7242 + t2723;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  t7249 = t6 * t1676 * t389;
  t7264 = 0.5e1 / 0.288e3 * t5954 * t2655 + t7082 - 0.3e1 / 0.4e1 * t261 * t2658 - t7066 + t7249 * t949 / 0.768e3 + t7070 + t5364 * t2666 / 0.768e3 + t7074 - 0.3e1 / 0.2e1 * t1677 * t2669 - t7135 + 0.5e1 / 0.288e3 * t6965 * t989 + t7080 + 0.9e1 / 0.4e1 * t1677 * t2675 + t7137 - 0.5e1 / 0.144e3 * t2206 * t2679 - t7157 - t2206 * t2684 / 0.384e3 - t7151;
  t7265 = my_piecewise3(t2, 0, t7264);
  tv4rhosigma2tau12 = t7 * t7265 + t2688;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  t7299 = t6 * t1812 * t417;
  t7302 = 0.5e1 / 0.48e2 * t6976 * t96 * t150 * t372 * t314 + t6976 * t429 * params->a2b * t51 * t2260 / 0.128e3 - 0.3e1 / 0.4e1 * t271 * t2693 - 0.3e1 / 0.4e1 * t114 * t903 * t962 - t7208 + t5549 * t2701 / 0.768e3 + t2219 * t1015 * t2220 * t926 / 0.768e3 + 0.5e1 / 0.288e3 * t7005 * t1009 + 0.5e1 / 0.288e3 * t7009 * t1009 + 0.5e1 / 0.288e3 * t6205 * t2690 + 0.5e1 / 0.288e3 * t2417 * t1015 * t2418 * t816 + t7299 * t969 / 0.768e3;
  t7304 = t6 * t803 * t902;
  t7337 = t7304 * t969 / 0.768e3 - 0.65e2 / 0.864e3 * t2639 * t2427 - 0.65e2 / 0.864e3 * t2417 * t2632 - t2697 * t2264 / 0.144e3 - t2219 * t1015 * t5552 * t429 / 0.144e3 - 0.3e1 / 0.2e1 * t1813 * t2704 - 0.3e1 / 0.2e1 * t804 * t5589 * t1004 - 0.3e1 / 0.2e1 * t804 * t2230 * t2433 - 0.3e1 / 0.2e1 * t804 * t2230 * t2437 + 0.9e1 / 0.4e1 * t1813 * t2710 + 0.9e1 / 0.4e1 * t804 * t4420 * t2709 + 0.9e1 / 0.4e1 * t804 * t1802 * t926 * t961;
  t7352 = t2717 * t314;
  t7358 = 0.9e1 / 0.4e1 * t804 * t6273 * t2242 - 0.3e1 / 0.2e1 * t804 * t2441 * t2246 + t7203 + t7216 + t7220 + t7228 - t7224 + t7232 + 0.65e2 / 0.432e3 * t967 * t2451 * t786 * t372 + t967 * t2718 * t1462 / 0.72e2 - t2219 * t663 * t7352 / 0.384e3 - 0.5e1 / 0.144e3 * t2639 * t2453;
  t7371 = t679 * t926;
  t7392 = -0.5e1 / 0.144e3 * t2251 * t2714 - 0.5e1 / 0.144e3 * t2255 * t2714 - 0.5e1 / 0.144e3 * t967 * t2451 * t358 * t816 - t2251 * t2719 / 0.384e3 - t2255 * t2719 / 0.384e3 - t967 * t7371 * params->a2b * t663 / 0.384e3 - 0.5e1 / 0.144e3 * t2417 * t290 * t7038 - t2697 * t2261 / 0.384e3 - t7236 - t7240 + 0.9e1 / 0.2e1 * t804 * t1802 * t1004 * t816 + 0.9e1 / 0.2e1 * t804 * t5567 * t2395 - 0.9e1 * t804 * t4424 * t2709 * t314;
  t7395 = my_piecewise3(t105, 0, t7302 + t7337 + t7358 + t7392);
  tv4rhosigma2tau23 = t7 * t7395 + t2723;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  tv4rhosigmalapl28 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  tv4rhosigmalapl29 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  tv4rhosigmalapl217 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  t7411 = t27 * t706 * t1024 / 0.4e1;
  t7435 = 0.25e2 / 0.18e2 * t6844 * params->b2b * t68 * t51 * t54 * t344 * t232 + 0.5e1 / 0.48e2 * t6844 * t401 * params->xb * t51 * t2344 - t7411 - 0.3e1 / 0.4e1 * t183 * t2737 - 0.3e1 / 0.4e1 * t27 * t721 * t1024 - 0.125e3 / 0.162e3 * t2469 * t2655 + 0.25e2 / 0.108e3 * t6871 * t1029 + 0.25e2 / 0.108e3 * t6875 * t1029 + 0.25e2 / 0.108e3 * t6421 * t2725 + 0.25e2 / 0.108e3 * t2469 * t69 * t2470 * t749 + 0.5e1 / 0.288e3 * t5687 * t2729 + 0.5e1 / 0.288e3 * t2305 * t1015 * t2306 * t864;
  t7441 = 0.25e2 / 0.324e3 * t6888 * t1029;
  t7445 = 0.5e1 / 0.864e3 * t5681 * t2729;
  t7449 = 0.5e1 / 0.864e3 * t7068 * t989;
  t7453 = 0.25e2 / 0.324e3 * t6427 * t2725;
  t7462 = 0.5e1 / 0.288e3 * t7091 * t989 + 0.5e1 / 0.288e3 * t7095 * t989 + t7441 - 0.125e3 / 0.162e3 * t2616 * t2517 + t7445 - 0.65e2 / 0.864e3 * t2305 * t2666 + t7449 - 0.65e2 / 0.864e3 * t2662 * t2317 + t7453 - 0.3e1 / 0.2e1 * t1612 * t2732 - 0.3e1 / 0.2e1 * t737 * t5779 * t984 - 0.3e1 / 0.2e1 * t737 * t2320 * t2332;
  t7483 = 0.3e1 / 0.4e1 * t1616 * t2741;
  t7485 = t1616 * t2732 / 0.2e1;
  t7498 = -0.3e1 / 0.2e1 * t737 * t2320 * t2336 + 0.9e1 / 0.4e1 * t737 * t5224 * t2497 - 0.3e1 / 0.2e1 * t737 * t2127 * t2501 + 0.9e1 / 0.4e1 * t1612 * t2741 + 0.9e1 / 0.4e1 * t737 * t3923 * t2740 + 0.9e1 / 0.4e1 * t737 * t1631 * t1023 * t749 + t7483 - t7485 - 0.25e2 / 0.54e2 * t947 * t2512 * t1015 * t749 - 0.25e2 / 0.54e2 * t2469 * t70 * t6914 - 0.5e1 / 0.144e3 * t2305 * t208 * t7144 - 0.5e1 / 0.144e3 * t2662 * t2345;
  t7508 = 0.5e1 / 0.432e3 * t2155 * t2745;
  t7513 = 0.25e2 / 0.162e3 * t2155 * t2751;
  t7534 = -0.5e1 / 0.144e3 * t2151 * t2745 - 0.5e1 / 0.144e3 * t2159 * t2745 - 0.5e1 / 0.144e3 * t947 * t7174 * params->xb * t208 - t7508 + 0.65e2 / 0.432e3 * t947 * t2744 * t491 - t7513 + 0.125e3 / 0.81e2 * t947 * t6482 * t2750 - 0.25e2 / 0.54e2 * t2616 * t2514 - 0.25e2 / 0.54e2 * t2151 * t2751 - 0.25e2 / 0.54e2 * t2159 * t2751 - 0.9e1 * t737 * t3931 * t2740 * t232 + 0.9e1 / 0.2e1 * t737 * t1631 * t984 * t864 + 0.9e1 / 0.2e1 * t737 * t5720 * t2277;
  t7537 = my_piecewise3(t2, 0, t7435 + t7462 + t7498 + t7534);
  tv4rhosigmatau20 = t7 * t7537 + t2755;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  t7542 = 0.25e2 / 0.324e3 * t6650 * t2757;
  t7546 = 0.5e1 / 0.864e3 * t6066 * t2761;
  t7550 = t1720 * t2764 / 0.2e1;
  t7554 = 0.5e1 / 0.864e3 * t7214 * t1009;
  t7559 = t114 * t759 * t1043 / 0.4e1;
  t7563 = 0.3e1 / 0.4e1 * t1720 * t2773;
  t7567 = 0.5e1 / 0.432e3 * t2193 * t2777;
  t7571 = 0.25e2 / 0.324e3 * t6945 * t1048;
  t7575 = 0.25e2 / 0.162e3 * t2193 * t2783;
  t7576 = 0.25e2 / 0.108e3 * t6633 * t2757 + t7542 + 0.5e1 / 0.288e3 * t6056 * t2761 + t7546 - 0.3e1 / 0.2e1 * t1716 * t2764 - t7550 + 0.5e1 / 0.288e3 * t7210 * t1009 + t7554 - 0.3e1 / 0.4e1 * t245 * t2769 - t7559 + 0.9e1 / 0.4e1 * t1716 * t2773 + t7563 - 0.5e1 / 0.144e3 * t2189 * t2777 - t7567 + 0.25e2 / 0.108e3 * t6941 * t1048 + t7571 - 0.25e2 / 0.54e2 * t2189 * t2783 - t7575;
  t7577 = my_piecewise3(t105, 0, t7576);
  tv4rhosigmatau28 = t7 * t7577 + t2787;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  t7597 = 0.25e2 / 0.108e3 * t6574 * t2725 + t7453 + 0.5e1 / 0.288e3 * t5954 * t2729 + t7445 - 0.3e1 / 0.2e1 * t1677 * t2732 - t7485 + 0.5e1 / 0.288e3 * t7249 * t989 + t7449 - 0.3e1 / 0.4e1 * t261 * t2737 - t7411 + 0.9e1 / 0.4e1 * t1677 * t2741 + t7483 - 0.5e1 / 0.144e3 * t2206 * t2745 - t7508 + 0.25e2 / 0.108e3 * t6965 * t1029 + t7441 - 0.25e2 / 0.54e2 * t2206 * t2751 - t7513;
  t7598 = my_piecewise3(t2, 0, t7597);
  tv4rhosigmatau29 = t7 * t7598 + t2755;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  t7637 = 0.5e1 / 0.48e2 * t6976 * t429 * params->xb * t51 * t2452 + 0.25e2 / 0.18e2 * t6976 * params->b2b * t144 * t51 * t54 * t372 * t314 - 0.3e1 / 0.4e1 * t271 * t2769 - 0.3e1 / 0.4e1 * t114 * t791 * t1043 + 0.25e2 / 0.108e3 * t7005 * t1048 + 0.25e2 / 0.108e3 * t7009 * t1048 + 0.25e2 / 0.108e3 * t6755 * t2757 + 0.25e2 / 0.108e3 * t2562 * t145 * t2563 * t816 + 0.5e1 / 0.288e3 * t6205 * t2761 + 0.5e1 / 0.288e3 * t2417 * t1015 * t2418 * t926 - 0.65e2 / 0.864e3 * t2417 * t2701 - 0.65e2 / 0.864e3 * t2697 * t2427;
  t7655 = -0.125e3 / 0.162e3 * t2639 * t2602 - 0.125e3 / 0.162e3 * t2562 * t2690 - t7559 + t7542 + t7546 + t7554 + t7571 + 0.5e1 / 0.288e3 * t7299 * t1009 + 0.5e1 / 0.288e3 * t7304 * t1009 + 0.9e1 / 0.4e1 * t1813 * t2773 + 0.9e1 / 0.4e1 * t804 * t4420 * t2772 + 0.9e1 / 0.4e1 * t804 * t1802 * t1042 * t816;
  t7685 = -0.3e1 / 0.2e1 * t1813 * t2764 - 0.3e1 / 0.2e1 * t804 * t6235 * t1004 - 0.3e1 / 0.2e1 * t804 * t2441 * t2433 - 0.3e1 / 0.2e1 * t804 * t2441 * t2437 + 0.9e1 / 0.4e1 * t804 * t5567 * t2584 - 0.3e1 / 0.2e1 * t804 * t2230 * t2588 - t7550 + t7563 - 0.5e1 / 0.144e3 * t2255 * t2777 - 0.5e1 / 0.144e3 * t967 * t7371 * params->xb * t290 - 0.25e2 / 0.54e2 * t2639 * t2599 - 0.25e2 / 0.54e2 * t2562 * t146 * t7038;
  t7718 = 0.65e2 / 0.432e3 * t967 * t2776 * t663 + 0.125e3 / 0.81e2 * t967 * t6788 * t2782 - 0.25e2 / 0.54e2 * t2251 * t2783 - 0.25e2 / 0.54e2 * t2255 * t2783 - 0.25e2 / 0.54e2 * t967 * t2597 * t1015 * t816 - 0.5e1 / 0.144e3 * t2417 * t290 * t7352 - 0.5e1 / 0.144e3 * t2697 * t2453 - 0.5e1 / 0.144e3 * t2251 * t2777 - t7567 - t7575 + 0.9e1 / 0.2e1 * t804 * t6273 * t2395 - 0.9e1 * t804 * t4424 * t2772 * t314 + 0.9e1 / 0.2e1 * t804 * t1802 * t1004 * t926;
  t7721 = my_piecewise3(t105, 0, t7637 + t7655 + t7685 + t7718);
  tv4rhosigmatau217 = t7 * t7721 + t2787;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  tv4rholapl30 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  tv4rholapl33 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  tv4rholapl34 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  tv4rholapl37 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  t7724 = t401 * params->b2b * t68;
  t7730 = 0.3e1 / 0.4e1 * t27 * t188 * t2798;
  t7743 = 0.3e1 / 0.4e1 * t27 * t826 * t1024;
  t7745 = 0.25e2 / 0.108e3 * t6427 * t2789;
  t7749 = 0.25e2 / 0.108e3 * t7068 * t1029;
  t7758 = 0.25e2 / 0.6e1 * t6844 * t7724 * t2513 + t7730 + 0.9e1 / 0.4e1 * t27 * t216 * t2798 - 0.9e1 / 0.4e1 * t183 * t2792 - 0.9e1 / 0.4e1 * t27 * t838 * t1024 + 0.9e1 / 0.4e1 * t183 * t2799 - t7743 + t7745 - 0.125e3 / 0.54e2 * t2469 * t2729 + t7749 - 0.125e3 / 0.54e2 * t2662 * t2517 + 0.25e2 / 0.36e2 * t6421 * t2789 + 0.25e2 / 0.36e2 * t2469 * t69 * t2470 * t864;
  t7791 = 0.25e2 / 0.54e2 * t2155 * t2803;
  t7795 = 0.25e2 / 0.36e2 * t7091 * t1029 + 0.25e2 / 0.36e2 * t7095 * t1029 - 0.9e1 * t737 * t3931 * t2797 * t232 + 0.27e2 / 0.4e1 * t737 * t1631 * t1023 * t864 + 0.27e2 / 0.4e1 * t737 * t5720 * t2497 - 0.9e1 / 0.2e1 * t737 * t2320 * t2501 - 0.25e2 / 0.18e2 * t2469 * t70 * t7144 - 0.25e2 / 0.18e2 * t2662 * t2514 - 0.25e2 / 0.18e2 * t2151 * t2803 - 0.25e2 / 0.18e2 * t2159 * t2803 - 0.25e2 / 0.18e2 * t947 * t7174 * params->b2b * t70 - t7791 + 0.125e3 / 0.27e2 * t947 * t2802 * t208;
  t7797 = my_piecewise3(t2, 0, t7758 + t7795);
  tv4rhotau30 = t7 * t7797 + t2807;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  t7802 = 0.25e2 / 0.108e3 * t6650 * t2809;
  t7807 = 0.3e1 / 0.4e1 * t114 * t874 * t1043;
  t7811 = 0.25e2 / 0.108e3 * t7214 * t1048;
  t7816 = 0.3e1 / 0.4e1 * t114 * t248 * t2818;
  t7820 = 0.25e2 / 0.54e2 * t2193 * t2823;
  t7822 = my_piecewise3(t105, 0, 0.25e2 / 0.36e2 * t6633 * t2809 + t7802 - 0.9e1 / 0.4e1 * t245 * t2812 - t7807 + 0.25e2 / 0.36e2 * t7210 * t1048 + t7811 + 0.9e1 / 0.4e1 * t245 * t2819 + t7816 - 0.25e2 / 0.18e2 * t2189 * t2823 - t7820);
  tv4rhotau33 = t7 * t7822 + t2827;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  t7835 = my_piecewise3(t2, 0, 0.25e2 / 0.36e2 * t6574 * t2789 + t7745 - 0.9e1 / 0.4e1 * t261 * t2792 - t7743 + 0.25e2 / 0.36e2 * t7249 * t1029 + t7749 + 0.9e1 / 0.4e1 * t261 * t2799 + t7730 - 0.25e2 / 0.18e2 * t2206 * t2803 - t7791);
  tv4rhotau34 = t7 * t7835 + t2807;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  t7838 = t429 * params->b2b * t144;
  t7862 = 0.25e2 / 0.6e1 * t6976 * t7838 * t2598 - 0.9e1 / 0.4e1 * t271 * t2812 - 0.9e1 / 0.4e1 * t114 * t903 * t1043 + 0.9e1 / 0.4e1 * t271 * t2819 + 0.9e1 / 0.4e1 * t114 * t298 * t2818 - t7807 + t7816 + t7802 + t7811 + 0.25e2 / 0.36e2 * t7299 * t1048 + 0.25e2 / 0.36e2 * t7304 * t1048 + 0.25e2 / 0.36e2 * t6755 * t2809 + 0.25e2 / 0.36e2 * t2562 * t145 * t2563 * t926;
  t7897 = -0.125e3 / 0.54e2 * t2562 * t2761 - 0.125e3 / 0.54e2 * t2697 * t2602 - 0.9e1 / 0.2e1 * t804 * t2441 * t2588 - 0.9e1 * t804 * t4424 * t2817 * t314 + 0.27e2 / 0.4e1 * t804 * t1802 * t1042 * t926 + 0.27e2 / 0.4e1 * t804 * t6273 * t2584 - 0.25e2 / 0.18e2 * t2251 * t2823 - 0.25e2 / 0.18e2 * t2255 * t2823 - 0.25e2 / 0.18e2 * t967 * t7371 * params->b2b * t146 - 0.25e2 / 0.18e2 * t2562 * t146 * t7352 - 0.25e2 / 0.18e2 * t2697 * t2599 + 0.125e3 / 0.27e2 * t967 * t2822 * t290 - t7820;
  t7899 = my_piecewise3(t105, 0, t7862 + t7897);
  tv4rhotau37 = t7 * t7899 + t2827;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t7905 = t31 * t31;
  t7907 = 0.1e1 / t33 / t7905;
  t7908 = t29 * t7907;
  t7911 = 0.1e1 / t38 / t1064 / t36;
  t7922 = t941 * t941;
  t7932 = params->a2b * params->a2b;
  t7939 = my_piecewise3(t2, 0, -t2113 * t1015 * t5130 * t941 / 0.64e2 + t2113 * t7908 * t7911 * t221 * params->a2b / 0.6144e4 + 0.9e1 * t27 * t335 * t2620 - t2616 * t2626 / 0.32e2 - 0.9e1 * t27 * t82 * t2956 * t7922 + 0.3e1 / 0.64e2 * t947 * t1151 * t941 * params->a2b * t491 - t947 * t507 * t7932 * t7908 * t7911 / 0.6144e4);
  tv4sigma40 = t7 * t7939;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t7946 = 0.1e1 / t118 / t1455 / t116;
  t7957 = t961 * t961;
  t7973 = my_piecewise3(t105, 0, -t2219 * t1015 * t5527 * t961 / 0.64e2 + t2219 * t7908 * t7946 * t303 * params->a2b / 0.6144e4 + 0.9e1 * t114 * t363 * t2643 - t2639 * t2649 / 0.32e2 - 0.9e1 * t114 * t156 * t3657 * t7957 + 0.3e1 / 0.64e2 * t967 * t1432 * t961 * params->a2b * t663 - t967 * t679 * t7932 * t7908 * t7946 / 0.6144e4);
  tv4sigma414 = t7 * t7973;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  tv4sigma3lapl19 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  t7975 = 0.1e1 / t38 / t2839;
  t7976 = t7975 * t221;
  t7998 = t2342 * t29;
  t8010 = t2682 * t344;
  t8023 = 0.5e1 / 0.9216e4 * t2305 * t7908 * t7976 * params->a2b + 0.5e1 / 0.9216e4 * t2113 * t7908 * t7976 * params->xb + 0.9e1 / 0.4e1 * t27 * t390 * t2620 + 0.3e1 / 0.128e3 * t6844 * t984 * params->a2b * t491 - t2616 * t2684 / 0.128e3 + 0.5e1 / 0.32e2 * t947 * t5852 * t330 * t941 - 0.5e1 / 0.4608e4 * t947 * t7998 * t7907 * t7975 * params->a2b - 0.5e1 / 0.96e2 * t2305 * t1015 * t5709 * t941 - t2662 * t2626 / 0.128e3 - t2113 * t491 * t8010 / 0.128e3 - 0.5e1 / 0.48e2 * t2616 * t2679 + 0.27e2 / 0.4e1 * t737 * t5224 * t2674 - 0.9e1 * t737 * t3931 * t401 * t2619;
  t8024 = my_piecewise3(t2, 0, t8023);
  tv4sigma3tau0 = t7 * t8024;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  t8036 = 0.1e1 / t118 / t3631;
  t8037 = t8036 * t303;
  t8056 = t2450 * t29;
  t8068 = t2717 * t372;
  t8074 = 0.27e2 / 0.4e1 * t804 * t5567 * t2709 - 0.9e1 * t804 * t4424 * t429 * t2642 + 0.9e1 / 0.4e1 * t114 * t418 * t2643 + 0.5e1 / 0.9216e4 * t2417 * t7908 * t8037 * params->a2b + 0.5e1 / 0.9216e4 * t2219 * t7908 * t8037 * params->xb + 0.3e1 / 0.128e3 * t6976 * t1004 * params->a2b * t663 - t2639 * t2719 / 0.128e3 + 0.5e1 / 0.32e2 * t967 * t6288 * t358 * t961 - 0.5e1 / 0.4608e4 * t967 * t8056 * t7907 * t8036 * params->a2b - 0.5e1 / 0.96e2 * t2417 * t1015 * t6190 * t961 - t2697 * t2649 / 0.128e3 - t2219 * t663 * t8068 / 0.128e3 - 0.5e1 / 0.48e2 * t2639 * t2714;
  t8075 = my_piecewise3(t105, 0, t8074);
  tv4sigma3tau19 = t7 * t8075;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  tv4sigma2lapl217 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  t8076 = params->xb * params->xb;
  t8079 = 0.1e1 / t38 / t1064;
  t8084 = t8079 * t221;
  t8090 = t7907 * t221;
  t8107 = t7908 * params->a2b;
  t8113 = t1151 * t1023;
  t8146 = -0.25e2 / 0.5184e4 * t947 * t507 * t8076 * t7908 * t8079 + 0.25e2 / 0.5184e4 * t2113 * t7908 * t8084 * params->b2b + 0.25e2 / 0.5184e4 * t2469 * t8079 * t29 * t8090 * params->a2b + 0.25e2 / 0.5184e4 * t2305 * t7908 * t8084 * params->xb - t2113 * t1015 * t5130 * t1023 / 0.384e3 + 0.9e1 / 0.2e1 * t737 * t5224 * t2740 - 0.25e2 / 0.2592e4 * t947 * t2511 * t8079 * t8107 - 0.5e1 / 0.72e2 * t2616 * t2745 + t947 * t8113 * params->a2b * t491 / 0.128e3 - 0.25e2 / 0.27e2 * t2616 * t2751 - 0.25e2 / 0.54e2 * t2469 * t69 * t6435 * t941 - 0.5e1 / 0.72e2 * t2305 * t208 * t8010 - 0.5e1 / 0.72e2 * t2662 * t2679 - t2662 * t2684 / 0.192e3 + 0.9e1 / 0.2e1 * t737 * t5720 * t2674 - 0.9e1 * t737 * t3931 * t1023 * t941 + 0.25e2 / 0.18e2 * t947 * t6477 * t1015 * t941 + 0.5e1 / 0.24e2 * t6844 * t984 * params->xb * t208;
  t8147 = my_piecewise3(t2, 0, t8146);
  tv4sigma2tau20 = t7 * t8147;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  t8153 = 0.1e1 / t118 / t1455;
  t8158 = t8153 * t303;
  t8164 = t7907 * t303;
  t8177 = t1432 * t1042;
  t8216 = 0.9e1 / 0.2e1 * t804 * t5567 * t2772 - 0.25e2 / 0.5184e4 * t967 * t679 * t8076 * t7908 * t8153 + 0.25e2 / 0.5184e4 * t2219 * t7908 * t8158 * params->b2b + 0.25e2 / 0.5184e4 * t2562 * t8153 * t29 * t8164 * params->a2b + 0.25e2 / 0.5184e4 * t2417 * t7908 * t8158 * params->xb - t2219 * t1015 * t5527 * t1042 / 0.384e3 + t967 * t8177 * params->a2b * t663 / 0.128e3 - 0.25e2 / 0.27e2 * t2639 * t2783 - 0.25e2 / 0.2592e4 * t967 * t2596 * t8153 * t8107 - 0.5e1 / 0.72e2 * t2417 * t290 * t8068 - 0.5e1 / 0.72e2 * t2697 * t2714 - t2697 * t2719 / 0.192e3 - 0.5e1 / 0.72e2 * t2639 * t2777 - 0.25e2 / 0.54e2 * t2562 * t145 * t6735 * t961 + 0.9e1 / 0.2e1 * t804 * t6273 * t2709 - 0.9e1 * t804 * t4424 * t1042 * t961 + 0.5e1 / 0.24e2 * t6976 * t1004 * params->xb * t290 + 0.25e2 / 0.18e2 * t967 * t6783 * t1015 * t961;
  t8217 = my_piecewise3(t105, 0, t8216);
  tv4sigma2tau217 = t7 * t8217;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  tv4sigmalapl311 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  t8222 = 0.1e1 / t38 / t484;
  t8265 = -0.25e2 / 0.18e2 * t2469 * t70 * t8010 + 0.125e3 / 0.1296e4 * t2469 * t8222 * t29 * t8090 * params->xb - 0.5e1 / 0.96e2 * t2305 * t1015 * t5709 * t1023 + 0.27e2 / 0.4e1 * t737 * t5720 * t2740 - 0.5e1 / 0.48e2 * t2662 * t2745 + 0.125e3 / 0.1296e4 * t2305 * t7908 * t8222 * t221 * params->b2b - 0.25e2 / 0.18e2 * t2662 * t2751 + 0.9e1 / 0.4e1 * t27 * t335 * t2798 - 0.9e1 * t737 * t3931 * t2797 * t344 + 0.5e1 / 0.32e2 * t947 * t8113 * params->xb * t208 - 0.25e2 / 0.18e2 * t2616 * t2803 + 0.25e2 / 0.6e1 * t6844 * t7724 * t2750 - 0.125e3 / 0.648e3 * t947 * t7998 * t7907 * t8222 * params->b2b;
  t8266 = my_piecewise3(t2, 0, t8265);
  tv4sigmatau30 = t7 * t8266;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  t8271 = 0.1e1 / t118 / t656;
  t8314 = -0.25e2 / 0.18e2 * t2562 * t146 * t8068 + 0.125e3 / 0.1296e4 * t2562 * t8271 * t29 * t8164 * params->xb - 0.5e1 / 0.96e2 * t2417 * t1015 * t6190 * t1042 + 0.27e2 / 0.4e1 * t804 * t6273 * t2772 - 0.5e1 / 0.48e2 * t2697 * t2777 + 0.125e3 / 0.1296e4 * t2417 * t7908 * t8271 * t303 * params->b2b - 0.25e2 / 0.18e2 * t2697 * t2783 + 0.9e1 / 0.4e1 * t114 * t363 * t2818 - 0.9e1 * t804 * t4424 * t2817 * t372 + 0.5e1 / 0.32e2 * t967 * t8177 * params->xb * t290 - 0.25e2 / 0.18e2 * t2639 * t2823 + 0.25e2 / 0.6e1 * t6976 * t7838 * t2782 - 0.125e3 / 0.648e3 * t967 * t8056 * t7907 * t8271 * params->b2b;
  t8315 = my_piecewise3(t105, 0, t8314);
  tv4sigmatau311 = t7 * t8315;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  tv4lapl40 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  tv4lapl44 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  t8320 = t2831 * t29;
  t8330 = t1023 * t1023;
  t8339 = params->b2b * params->b2b;
  t8346 = my_piecewise3(t2, 0, -0.25e2 / 0.9e1 * t2469 * t69 * t6435 * t1023 + 0.125e4 / 0.243e3 * t2469 * t8320 * t8090 * params->b2b + 0.9e1 * t27 * t390 * t2798 - 0.5e2 / 0.9e1 * t2662 * t2803 - 0.9e1 * t27 * t82 * t2956 * t8330 + 0.25e2 / 0.3e1 * t947 * t8113 * params->b2b * t70 - 0.125e4 / 0.243e3 * t947 * t507 * t8339 * t8320 * t7907);
  tv4tau40 = t7 * t8346;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  t8351 = t3623 * t29;
  t8361 = t1042 * t1042;
  t8376 = my_piecewise3(t105, 0, -0.25e2 / 0.9e1 * t2562 * t145 * t6735 * t1042 + 0.125e4 / 0.243e3 * t2562 * t8351 * t8164 * params->b2b + 0.9e1 * t114 * t418 * t2818 - 0.5e2 / 0.9e1 * t2697 * t2823 - 0.9e1 * t114 * t156 * t3657 * t8361 + 0.25e2 / 0.3e1 * t967 * t8177 * params->b2b * t146 - 0.125e4 / 0.243e3 * t967 * t679 * t8339 * t8351 * t7907);
  tv4tau44 = t7 * t8376;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

