
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file PolarStereographicProjectionAttributes.h
    \\brief Definition of PolarStereographicProjection Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "PolarStereographicProjectionWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


PolarStereographicProjectionWrapper::PolarStereographicProjectionWrapper(): polarstereographicprojection_(new PolarStereographicProjection())

{

	
	
	TransformationWrapper::object(polarstereographicprojection_);
	
	
} 
PolarStereographicProjectionWrapper::PolarStereographicProjectionWrapper(PolarStereographicProjection* polarstereographicprojection): polarstereographicprojection_(polarstereographicprojection)
{
	
	
	TransformationWrapper::object(polarstereographicprojection_);
	
} 

PolarStereographicProjectionWrapper::~PolarStereographicProjectionWrapper()
{
	
}

void PolarStereographicProjectionWrapper::set(const MagRequest& request)
{
	
	
	
	TransformationWrapper::set(request);
	

	if  (request.countValues("SUBPAGE_MAP_AREA_COORDINATE_SYSTEM") ) {
		string system_value = request("SUBPAGE_MAP_AREA_COORDINATE_SYSTEM");
		polarstereographicprojection_->system_ = system_value;
		}
	if  (request.countValues("SUBPAGE_MAP_AREA_DEFINITION_POLAR") ) {
		string area_value = request("SUBPAGE_MAP_AREA_DEFINITION_POLAR");
		polarstereographicprojection_->area_ = area_value;
		}
	if  (request.countValues("SUBPAGE_LOWER_LEFT_LATITUDE") ) {
		double min_latitude_value = request("SUBPAGE_LOWER_LEFT_LATITUDE");
		polarstereographicprojection_->min_latitude_ = min_latitude_value;
		}
	if  (request.countValues("SUBPAGE_LOWER_LEFT_LONGITUDE") ) {
		double min_longitude_value = request("SUBPAGE_LOWER_LEFT_LONGITUDE");
		polarstereographicprojection_->min_longitude_ = min_longitude_value;
		}
	if  (request.countValues("SUBPAGE_UPPER_RIGHT_LATITUDE") ) {
		double max_latitude_value = request("SUBPAGE_UPPER_RIGHT_LATITUDE");
		polarstereographicprojection_->max_latitude_ = max_latitude_value;
		}
	if  (request.countValues("SUBPAGE_UPPER_RIGHT_LONGITUDE") ) {
		double max_longitude_value = request("SUBPAGE_UPPER_RIGHT_LONGITUDE");
		polarstereographicprojection_->max_longitude_ = max_longitude_value;
		}
	if  (request.countValues("SUBPAGE_MAP_VERTICAL_LONGITUDE") ) {
		double vertical_longitude_value = request("SUBPAGE_MAP_VERTICAL_LONGITUDE");
		polarstereographicprojection_->vertical_longitude_ = vertical_longitude_value;
		}
	if  (request.countValues("SUBPAGE_MAP_CENTRE_LATITUDE") ) {
		double centre_latitude_value = request("SUBPAGE_MAP_CENTRE_LATITUDE");
		polarstereographicprojection_->centre_latitude_ = centre_latitude_value;
		}
	if  (request.countValues("SUBPAGE_MAP_CENTRE_LONGITUDE") ) {
		double centre_longitude_value = request("SUBPAGE_MAP_CENTRE_LONGITUDE");
		polarstereographicprojection_->centre_longitude_ = centre_longitude_value;
		}
	if  (request.countValues("SUBPAGE_MAP_SCALE") ) {
		double map_scale_value = request("SUBPAGE_MAP_SCALE");
		polarstereographicprojection_->map_scale_ = map_scale_value;
		}
	
	
	if  (request.countValues("SUBPAGE_MAP_HEMISPHERE") ) {
		string hemisphere_value = request("SUBPAGE_MAP_HEMISPHERE");
		polarstereographicprojection_->hemisphere_ = MagTranslator<string, Hemisphere>()(hemisphere_value);
	}
		
	
}

void PolarStereographicProjectionWrapper::print(ostream& out)  const
{
	out << "PolarStereographicProjectionWrapper[]";
}


    




