// This file is part of libigl, a simple c++ geometry processing library.
//
// Copyright (C) 2020 Oded Stein <oded.stein@columbia.edu>
//
// This Source Code Form is subject to the terms of the Mozilla Public License
// v. 2.0. If a copy of the MPL was not distributed with this file, You can
// obtain one at http://mozilla.org/MPL/2.0/.
#ifndef IGL_EDGE_MIDPOINTS_H
#define IGL_EDGE_MIDPOINTS_H
#include "igl_inline.h"

#include <Eigen/Dense>
namespace igl
{
  // Computes the midpoints of edges in a triangle mesh.
  //
  // Input:
  // V, F: triangle mesh
  // E, oE: mapping from halfedges to edges and orientation as generated by
  //    orient_halfedges
  //
  // Output:
  // mps: edge midpoints, one per edge in E
  template<typename DerivedV,typename DerivedF,typename DerivedE,
  typename DerivedoE, typename Derivedmps>
  IGL_INLINE void edge_midpoints(
    const Eigen::MatrixBase<DerivedV> &V,
    const Eigen::MatrixBase<DerivedF> &F,
    const Eigen::MatrixBase<DerivedE> &E,
    const Eigen::MatrixBase<DerivedoE> &oE,
    Eigen::PlainObjectBase<Derivedmps> &mps);
}

#ifndef IGL_STATIC_LIBRARY
#  include "edge_midpoints.cpp"
#endif

#endif
