/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:
//  CommonXSectView
//
// .AUTHOR:
//  Geir Austad. Modified by Fernando Ii 03-2012
//
// .SUMMARY:
//  Convenience class, for implementing methods common
//  to XSectView and AverageView.
//
// .CLIENTS:
//  DropAction
//
// .RESPONSIBILITY:
//
// .ASCENDENT:
//  PlotModView, PlotModService
//
// .DESCENDENT:
//  XSectView, AverageView
//
//
#pragma once

#include <string>

#include "Page.h"
#include "PlotModService.h"
#include "PlotModView.h"


class CommonXSectView : public PlotModView, public PlotModService
{
public:
    // -- Constructor
    CommonXSectView(Page&, const MvRequest&, const MvRequest&);
    CommonXSectView(const CommonXSectView&);

    // -- Destructor
    ~CommonXSectView();

    // --  Methods overriden from PlotModView class
    std::string Name() override;

    // --  Methods that the subclasses must provide

    // Decode the data Unit
    void DecodeDataUnit(MvIcon& dataUnit) override;

    // Process a drop
    void Drop(PmContext& context) override;

    // Draw the foreground.
    void DrawForeground() override {}

    // Set data unit id
    void ParentDataUnitId(int parentDataUnitId)
    {
        viewRequest_("_PARENT_DATAUNIT_ID") = parentDataUnitId;
        appViewReq_("_PARENT_DATAUNIT_ID")  = parentDataUnitId;
        parentDataUnitId_                   = parentDataUnitId;
    }

    int ParentDataUnitId() { return parentDataUnitId_; }

    bool ConsistencyCheck(MvRequest&, MvRequest&) override { return true; }

protected:
    // Call a service and wait its return
    bool callServiceInternal(const MvRequest&, PmContext&, MvRequest&);

    void ApplicationName(const std::string& appname)
    {
        applicationName_ = appname;
    }

    std::string& ApplicationName() { return applicationName_; }

    void Draw(SubPage*) override;

    // Save some data specific to some DataApplication
    // It must be pure virtual because ThermoView and
    // HovmoellerView have their own implementation.
    virtual void ApplicationInfo(const MvRequest&) = 0;

    // Insert a new data request into the page hierarchy
    MvIconList InsertDataRequest(MvRequest& dropRequest) override;

    // Get output requests from executing a Module (they all have the
    // same tag _MODULEID
    bool DropFromModule(MvRequest&, MvRequest&, bool&);

#if 0
    // Provide Axis information
    void DescribeAxis ( ObjectInfo& description,
                        MvRequest& axisRequest,
                        const Cached& axisName );

    // Check and set axis values.
    void CheckAxis(double minValue,double maxValue,
                   int axisType,MvRequest&,
                   std::string title = "");

    bool CheckLatLon(const std::string&,double,double,MvRequest&, const char *);  

    virtual void SetVariables(const MvRequest&, bool) {}

    // Check horizontal value
    virtual bool CheckHorizontal(MvRequest &) = 0;

    // Add values to a request
    void AddValues ( MvRequest& dataRequest, std::vector<double>& dataVector, const char* variableName ); 

    // Functions for generating matrix data.

    // convert a netcdf file into a matrix file for use by magics.
    bool NetCDFtoMatrix(MvIcon&,MvRequest&);

    void GenerateData(FILE *fp,int startIndex,double yMin,
                      double yMax,vector<double> &xvector,
                      std::vector<double> &yvector, int nrPoints, 
                      bool logax = false, bool modlev = false);

    bool FindPressure(vector<double> &yvector,double pk,
                      int &firstindex,int &nextindex, int);
#endif

    double latMin_, latMax_, lonMin_, lonMax_;
    double yMin_, yMax_;
    std::string applicationName_;
    MvRequest appViewReq_;  //original application view request

private:
    // No assignment
    CommonXSectView& operator=(const CommonXSectView&);
};
