/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

#include "common/common_pch.h"

#include "common/mime.h"

namespace mtx::mime {

std::vector<type_t> const g_types = {
  { "application/activemessage",                              {}                                                       },
  { "application/andrew-inset",                               { "ez" }                                                 },
  { "application/applefile",                                  {}                                                       },
  { "application/atomicmail",                                 {}                                                       },
  { "application/batch-SMTP",                                 {}                                                       },
  { "application/beep+xml",                                   {}                                                       },
  { "application/cals-1840",                                  {}                                                       },
  { "application/commonground",                               {}                                                       },
  { "application/cu-seeme",                                   { "csm", "cu" }                                          },
  { "application/cybercash",                                  {}                                                       },
  { "application/dca-rft",                                    {}                                                       },
  { "application/dec-dx",                                     {}                                                       },
  { "application/dsptype",                                    { "tsp" }                                                },
  { "application/dvcs",                                       {}                                                       },
  { "application/edi-consent",                                {}                                                       },
  { "application/EDI-Consent",                                {}                                                       },
  { "application/edifact",                                    {}                                                       },
  { "application/EDIFACT",                                    {}                                                       },
  { "application/edi-x12",                                    {}                                                       },
  { "application/EDI-X12",                                    {}                                                       },
  { "application/eshop",                                      {}                                                       },
  { "application/font-tdpfr",                                 {}                                                       },
  { "application/futuresplash",                               { "spl" }                                                },
  { "application/ghostview",                                  {}                                                       },
  { "application/hta",                                        { "hta" }                                                },
  { "application/http",                                       {}                                                       },
  { "application/hyperstudio",                                {}                                                       },
  { "application/iges",                                       {}                                                       },
  { "application/index",                                      {}                                                       },
  { "application/index.cmd",                                  {}                                                       },
  { "application/index.obj",                                  {}                                                       },
  { "application/index.response",                             {}                                                       },
  { "application/index.vnd",                                  {}                                                       },
  { "application/iotp",                                       {}                                                       },
  { "application/ipp",                                        {}                                                       },
  { "application/isup",                                       {}                                                       },
  { "application/mac-binhex40",                               { "hqx" }                                                },
  { "application/mac-compactpro",                             { "cpt" }                                                },
  { "application/macwriteii",                                 {}                                                       },
  { "application/marc",                                       {}                                                       },
  { "application/mathematica",                                { "nb" }                                                 },
  { "application/mathematica-old",                            {}                                                       },
  { "application/msaccess",                                   { "mdb" }                                                },
  { "application/msword",                                     { "doc", "dot" }                                         },
  { "application/news-message-id",                            {}                                                       },
  { "application/news-transmission",                          {}                                                       },
  { "application/ocsp-request",                               {}                                                       },
  { "application/ocsp-response",                              {}                                                       },
  { "application/octet-stream",                               { "bin" }                                                },
  { "application/oda",                                        { "oda" }                                                },
  { "application/parityfec",                                  {}                                                       },
  { "application/pdf",                                        { "pdf" }                                                },
  { "application/pgp-encrypted",                              {}                                                       },
  { "application/pgp-keys",                                   { "key" }                                                },
  { "application/pgp-signature",                              { "pgp" }                                                },
  { "application/pics-rules",                                 { "prf" }                                                },
  { "application/pkcs10",                                     {}                                                       },
  { "application/pkcs7-mime",                                 {}                                                       },
  { "application/pkcs7-signature",                            {}                                                       },
  { "application/pkix-cert",                                  {}                                                       },
  { "application/pkixcmp",                                    {}                                                       },
  { "application/pkix-crl",                                   {}                                                       },
  { "application/postscript",                                 { "ps", "ai", "eps" }                                    },
  { "application/prs.alvestrand.titrax-sheet",                {}                                                       },
  { "application/prs.cww",                                    {}                                                       },
  { "application/prs.nprend",                                 {}                                                       },
  { "application/qsig",                                       {}                                                       },
  { "application/remote-printing",                            {}                                                       },
  { "application/riscos",                                     {}                                                       },
  { "application/rtf",                                        { "rtf" }                                                },
  { "application/sdp",                                        {}                                                       },
  { "application/set-payment",                                {}                                                       },
  { "application/set-payment-initiation",                     {}                                                       },
  { "application/set-registration",                           {}                                                       },
  { "application/set-registration-initiation",                {}                                                       },
  { "application/sgml",                                       {}                                                       },
  { "application/sgml-open-catalog",                          {}                                                       },
  { "application/sieve",                                      {}                                                       },
  { "application/slate",                                      {}                                                       },
  { "application/smil",                                       { "smi", "smil" }                                        },
  { "application/timestamp-query",                            {}                                                       },
  { "application/timestamp-reply",                            {}                                                       },
  { "application/vemmi",                                      {}                                                       },
  { "application/vnd.3M.Post-it-Notes",                       {}                                                       },
  { "application/vnd.accpac.simply.aso",                      {}                                                       },
  { "application/vnd.accpac.simply.imp",                      {}                                                       },
  { "application/vnd.acucobol",                               {}                                                       },
  { "application/vnd.aether.imp",                             {}                                                       },
  { "application/vnd.anser-web-certificate-issue-initiation", {}                                                       },
  { "application/vnd.anser-web-funds-transfer-initiation",    {}                                                       },
  { "application/vnd.audiograph",                             {}                                                       },
  { "application/vnd.bmi",                                    {}                                                       },
  { "application/vnd.businessobjects",                        {}                                                       },
  { "application/vnd.canon-cpdl",                             {}                                                       },
  { "application/vnd.canon-lips",                             {}                                                       },
  { "application/vnd.cinderella",                             { "cdy" }                                                },
  { "application/vnd.claymore",                               {}                                                       },
  { "application/vnd.$commerce_battelle",                     {}                                                       },
  { "application/vnd.commerce-battelle",                      {}                                                       },
  { "application/vnd.commonspace",                            {}                                                       },
  { "application/vnd.comsocaller",                            {}                                                       },
  { "application/vnd.contact.cmsg",                           {}                                                       },
  { "application/vnd.cosmocaller",                            {}                                                       },
  { "application/vnd.ctc-posml",                              {}                                                       },
  { "application/vnd.cups-postscript",                        {}                                                       },
  { "application/vnd.cups-raster",                            {}                                                       },
  { "application/vnd.cups-raw",                               {}                                                       },
  { "application/vnd.cybank",                                 {}                                                       },
  { "application/vnd.dna",                                    {}                                                       },
  { "application/vnd.dpgraph",                                {}                                                       },
  { "application/vnd.dxr",                                    {}                                                       },
  { "application/vnd.ecdis-update",                           {}                                                       },
  { "application/vnd.ecowin.chart",                           {}                                                       },
  { "application/vnd.ecowin.filerequest",                     {}                                                       },
  { "application/vnd.ecowin.fileupdate",                      {}                                                       },
  { "application/vnd.ecowin.series",                          {}                                                       },
  { "application/vnd.ecowin.seriesrequest",                   {}                                                       },
  { "application/vnd.ecowin.seriesupdate",                    {}                                                       },
  { "application/vnd.enliven",                                {}                                                       },
  { "application/vnd.epson.esf",                              {}                                                       },
  { "application/vnd.epson.msf",                              {}                                                       },
  { "application/vnd.epson.quickanime",                       {}                                                       },
  { "application/vnd.epson.salt",                             {}                                                       },
  { "application/vnd.epson.ssf",                              {}                                                       },
  { "application/vnd.ericsson.quickcall",                     {}                                                       },
  { "application/vnd.eudora.data",                            {}                                                       },
  { "application/vnd.fdf",                                    {}                                                       },
  { "application/vnd.ffsns",                                  {}                                                       },
  { "application/vnd.flographit",                             {}                                                       },
  { "application/vnd.FloGraphIt",                             {}                                                       },
  { "application/vnd.framemaker",                             {}                                                       },
  { "application/vnd.fsc.weblaunch",                          {}                                                       },
  { "application/vnd.fujitsu.oasys",                          {}                                                       },
  { "application/vnd.fujitsu.oasys2",                         {}                                                       },
  { "application/vnd.fujitsu.oasys3",                         {}                                                       },
  { "application/vnd.fujitsu.oasysgp",                        {}                                                       },
  { "application/vnd.fujitsu.oasysprs",                       {}                                                       },
  { "application/vnd.fujixerox.ddd",                          {}                                                       },
  { "application/vnd.fujixerox.docuworks",                    {}                                                       },
  { "application/vnd.fujixerox.docuworks.binder",             {}                                                       },
  { "application/vnd.fut-misnet",                             {}                                                       },
  { "application/vnd.grafeq",                                 {}                                                       },
  { "application/vnd.groove-account",                         {}                                                       },
  { "application/vnd.groove-identity-message",                {}                                                       },
  { "application/vnd.groove-injector",                        {}                                                       },
  { "application/vnd.groove-tool-message",                    {}                                                       },
  { "application/vnd.groove-tool-template",                   {}                                                       },
  { "application/vnd.groove-vcard",                           {}                                                       },
  { "application/vnd.hhe.lesson-player",                      {}                                                       },
  { "application/vnd.hp-HPGL",                                {}                                                       },
  { "application/vnd.hp-hpid",                                {}                                                       },
  { "application/vnd.hp-hps",                                 {}                                                       },
  { "application/vnd.hp-PCL",                                 {}                                                       },
  { "application/vnd.hp-PCLXL",                               {}                                                       },
  { "application/vnd.httphone",                               {}                                                       },
  { "application/vnd.hzn-3d-crossword",                       {}                                                       },
  { "application/vnd.ibm.afplinedata",                        {}                                                       },
  { "application/vnd.ibm.MiniPay",                            {}                                                       },
  { "application/vnd.ibm.modcap",                             {}                                                       },
  { "application/vnd.informix-visionary",                     {}                                                       },
  { "application/vnd.intercon.formnet",                       {}                                                       },
  { "application/vnd.intertrust.digibox",                     {}                                                       },
  { "application/vnd.intertrust.nncp",                        {}                                                       },
  { "application/vnd.intu.qbo",                               {}                                                       },
  { "application/vnd.intu.qfx",                               {}                                                       },
  { "application/vnd.irepository.package+xml",                {}                                                       },
  { "application/vnd.is-xpr",                                 {}                                                       },
  { "application/vnd.japannet-directory-service",             {}                                                       },
  { "application/vnd.japannet-jpnstore-wakeup",               {}                                                       },
  { "application/vnd.japannet-payment-wakeup",                {}                                                       },
  { "application/vnd.japannet-registration",                  {}                                                       },
  { "application/vnd.japannet-registration-wakeup",           {}                                                       },
  { "application/vnd.japannet-setstore-wakeup",               {}                                                       },
  { "application/vnd.japannet-verification",                  {}                                                       },
  { "application/vnd.japannet-verification-wakeup",           {}                                                       },
  { "application/vnd.koan",                                   {}                                                       },
  { "application/vnd.lotus-1-2-3",                            {}                                                       },
  { "application/vnd.lotus-approach",                         {}                                                       },
  { "application/vnd.lotus-freelance",                        {}                                                       },
  { "application/vnd.lotus-notes",                            {}                                                       },
  { "application/vnd.lotus-organizer",                        {}                                                       },
  { "application/vnd.lotus-screencam",                        {}                                                       },
  { "application/vnd.lotus-wordpro",                          {}                                                       },
  { "application/vnd.mcd",                                    {}                                                       },
  { "application/vnd.mediastation.cdkey",                     {}                                                       },
  { "application/vnd.meridian-slingshot",                     {}                                                       },
  { "application/vnd.mif",                                    { "mif" }                                                },
  { "application/vnd.minisoft-hp3000-save",                   {}                                                       },
  { "application/vnd.mitsubishi.misty-guard.trustweb",        {}                                                       },
  { "application/vnd.mobius.daf",                             {}                                                       },
  { "application/vnd.Mobius.DAF",                             {}                                                       },
  { "application/vnd.mobius.dis",                             {}                                                       },
  { "application/vnd.Mobius.DIS",                             {}                                                       },
  { "application/vnd.Mobius.MBK",                             {}                                                       },
  { "application/vnd.Mobius.MQY",                             {}                                                       },
  { "application/vnd.mobius.msl",                             {}                                                       },
  { "application/vnd.Mobius.MSL",                             {}                                                       },
  { "application/vnd.mobius.plc",                             {}                                                       },
  { "application/vnd.Mobius.PLC",                             {}                                                       },
  { "application/vnd.mobius.txf",                             {}                                                       },
  { "application/vnd.Mobius.TXF",                             {}                                                       },
  { "application/vnd.motorola.flexsuite",                     {}                                                       },
  { "application/vnd.motorola.flexsuite.adsi",                {}                                                       },
  { "application/vnd.motorola.flexsuite.fis",                 {}                                                       },
  { "application/vnd.motorola.flexsuite.gotap",               {}                                                       },
  { "application/vnd.motorola.flexsuite.kmr",                 {}                                                       },
  { "application/vnd.motorola.flexsuite.ttc",                 {}                                                       },
  { "application/vnd.motorola.flexsuite.wem",                 {}                                                       },
  { "application/vnd.mozilla.xul+xml",                        {}                                                       },
  { "application/vnd.ms-artgalry",                            {}                                                       },
  { "application/vnd.ms-asf",                                 {}                                                       },
  { "application/vnd.mseq",                                   {}                                                       },
  { "application/vnd.ms-excel",                               { "xls", "xlb" }                                         },
  { "application/vnd.msign",                                  {}                                                       },
  { "application/vnd.ms-lrm",                                 {}                                                       },
  { "application/vnd.ms-pki.seccat",                          { "cat" }                                                },
  { "application/vnd.ms-pki.stl",                             { "stl" }                                                },
  { "application/vnd.ms-powerpoint",                          { "ppt", "pps", "pot" }                                  },
  { "application/vnd.ms-project",                             {}                                                       },
  { "application/vnd.ms-tnef",                                {}                                                       },
  { "application/vnd.ms-works",                               {}                                                       },
  { "application/vnd.musician",                               {}                                                       },
  { "application/vnd.music-niff",                             {}                                                       },
  { "application/vnd.netfpx",                                 {}                                                       },
  { "application/vnd.noblenet-directory",                     {}                                                       },
  { "application/vnd.noblenet-sealer",                        {}                                                       },
  { "application/vnd.noblenet-web",                           {}                                                       },
  { "application/vnd.novadigm.EDM",                           {}                                                       },
  { "application/vnd.novadigm.EDX",                           {}                                                       },
  { "application/vnd.novadigm.EXT",                           {}                                                       },
  { "application/vnd.osa.netdeploy",                          {}                                                       },
  { "application/vnd.palm",                                   {}                                                       },
  { "application/vnd.pg.format",                              {}                                                       },
  { "application/vnd.pg.osasli",                              {}                                                       },
  { "application/vnd.powerbuilder6",                          {}                                                       },
  { "application/vnd.powerbuilder6-s",                        {}                                                       },
  { "application/vnd.powerbuilder7",                          {}                                                       },
  { "application/vnd.powerbuilder75",                         {}                                                       },
  { "application/vnd.powerbuilder75-s",                       {}                                                       },
  { "application/vnd.powerbuilder7-s",                        {}                                                       },
  { "application/vnd.previewsystems.box",                     {}                                                       },
  { "application/vnd.publishare-delta-tree",                  {}                                                       },
  { "application/vnd.pvi.ptid1",                              {}                                                       },
  { "application/vnd.pwg-xhtml-print+xml",                    {}                                                       },
  { "application/vnd.rapid",                                  {}                                                       },
  { "application/vnd.s3sms",                                  {}                                                       },
  { "application/vnd.seemail",                                {}                                                       },
  { "application/vnd.shana.informed.formdata",                {}                                                       },
  { "application/vnd.shana.informed.formtemplate",            {}                                                       },
  { "application/vnd.shana.informed.interchange",             {}                                                       },
  { "application/vnd.shana.informed.package",                 {}                                                       },
  { "application/vnd.sss-cod",                                {}                                                       },
  { "application/vnd.sss-dtf",                                {}                                                       },
  { "application/vnd.sss-ntf",                                {}                                                       },
  { "application/vnd.stardivision.calc",                      { "sdc" }                                                },
  { "application/vnd.stardivision.draw",                      { "sda" }                                                },
  { "application/vnd.stardivision.impress",                   { "sdd", "sdp" }                                         },
  { "application/vnd.stardivision.math",                      { "smf" }                                                },
  { "application/vnd.stardivision.writer",                    { "sdw", "vor" }                                         },
  { "application/vnd.stardivision.writer-global",             { "sgl" }                                                },
  { "application/vnd.street-stream",                          {}                                                       },
  { "application/vnd.sun.xml.calc",                           { "sxc" }                                                },
  { "application/vnd.sun.xml.calc.template",                  { "stc" }                                                },
  { "application/vnd.sun.xml.draw",                           { "sxd" }                                                },
  { "application/vnd.sun.xml.draw.template",                  { "std" }                                                },
  { "application/vnd.sun.xml.impress",                        { "sxi" }                                                },
  { "application/vnd.sun.xml.impress.template",               { "sti" }                                                },
  { "application/vnd.sun.xml.math",                           { "sxm" }                                                },
  { "application/vnd.sun.xml.writer",                         { "sxw" }                                                },
  { "application/vnd.sun.xml.writer.global",                  { "sxg" }                                                },
  { "application/vnd.sun.xml.writer.template",                { "stw" }                                                },
  { "application/vnd.svd",                                    {}                                                       },
  { "application/vnd.swiftview-ics",                          {}                                                       },
  { "application/vnd.triscape.mxs",                           {}                                                       },
  { "application/vnd.trueapp",                                {}                                                       },
  { "application/vnd.truedoc",                                {}                                                       },
  { "application/vnd.tve-trigger",                            {}                                                       },
  { "application/vnd.ufdl",                                   {}                                                       },
  { "application/vnd.uplanet.alert",                          {}                                                       },
  { "application/vnd.uplanet.alert-wbxml",                    {}                                                       },
  { "application/vnd.uplanet.bearer-choice",                  {}                                                       },
  { "application/vnd.uplanet.bearer-choice-wbxml",            {}                                                       },
  { "application/vnd.uplanet.cacheop",                        {}                                                       },
  { "application/vnd.uplanet.cacheop-wbxml",                  {}                                                       },
  { "application/vnd.uplanet.channel",                        {}                                                       },
  { "application/vnd.uplanet.channel-wbxml",                  {}                                                       },
  { "application/vnd.uplanet.list",                           {}                                                       },
  { "application/vnd.uplanet.listcmd",                        {}                                                       },
  { "application/vnd.uplanet.listcmd-wbxml",                  {}                                                       },
  { "application/vnd.uplanet.list-wbxml",                     {}                                                       },
  { "application/vnd.uplanet.signal",                         {}                                                       },
  { "application/vnd.vcx",                                    {}                                                       },
  { "application/vnd.vectorworks",                            {}                                                       },
  { "application/vnd.vidsoft.vidconference",                  {}                                                       },
  { "application/vnd.visio",                                  {}                                                       },
  { "application/vnd.vividence.scriptfile",                   {}                                                       },
  { "application/vnd.wap.sic",                                {}                                                       },
  { "application/vnd.wap.slc",                                {}                                                       },
  { "application/vnd.wap.wbxml",                              { "wbxml" }                                              },
  { "application/vnd.wap.wmlc",                               { "wmlc" }                                               },
  { "application/vnd.wap.wmlscriptc",                         { "wmlsc" }                                              },
  { "application/vnd.webturbo",                               {}                                                       },
  { "application/vnd.wrq-hp3000-labelled",                    {}                                                       },
  { "application/vnd.wt.stf",                                 {}                                                       },
  { "application/vnd.xara",                                   {}                                                       },
  { "application/vnd.xfdl",                                   {}                                                       },
  { "application/vnd.yellowriver-custom-menu",                {}                                                       },
  { "application/whoispp-query",                              {}                                                       },
  { "application/whoispp-response",                           {}                                                       },
  { "application/wita",                                       {}                                                       },
  { "application/wordperfect5.1",                             { "wp5" }                                                },
  { "application/x-123",                                      { "wk" }                                                 },
  { "application/x400-bp",                                    {}                                                       },
  { "application/x-bcpio",                                    { "bcpio" }                                              },
  { "application/x-cdf",                                      { "cdf" }                                                },
  { "application/x-cdlink",                                   { "vcd" }                                                },
  { "application/x-chess-pgn",                                { "pgn" }                                                },
  { "application/x-core",                                     {}                                                       },
  { "application/x-cpio",                                     { "cpio" }                                               },
  { "application/x-csh",                                      { "csh" }                                                },
  { "application/x-debian-package",                           { "deb" }                                                },
  { "application/x-director",                                 { "dcr", "dir", "dxr" }                                  },
  { "application/x-dms",                                      { "dms" }                                                },
  { "application/x-doom",                                     { "wad" }                                                },
  { "application/x-dvi",                                      { "dvi" }                                                },
  { "application/x-executable",                               {}                                                       },
  { "application/x-font",                                     { "pfa", "pfb", "gsf", "pcf", "pcf.Z" }                  },
  { "application/x-futuresplash",                             { "spl" }                                                },
  { "application/x-gnumeric",                                 { "gnumeric" }                                           },
  { "application/x-graphing-calculator",                      { "gcf" }                                                },
  { "application/x-gtar",                                     { "gtar", "tgz", "taz" }                                 },
  { "application/x-hdf",                                      { "hdf" }                                                },
  { "application/xhtml+xml",                                  { "xht", "xhtml" }                                       },
  { "application/x-httpd-php",                                { "phtml", "pht", "php" }                                },
  { "application/x-httpd-php3",                               { "php3" }                                               },
  { "application/x-httpd-php3-preprocessed",                  { "php3p" }                                              },
  { "application/x-httpd-php4",                               { "php4" }                                               },
  { "application/x-httpd-php-source",                         { "phps" }                                               },
  { "application/x-ica",                                      { "ica" }                                                },
  { "application/x-internet-signup",                          { "ins", "isp" }                                         },
  { "application/x-iphone",                                   { "iii" }                                                },
  { "application/x-java-applet",                              {}                                                       },
  { "application/x-java-archive",                             { "jar" }                                                },
  { "application/x-java-bean",                                {}                                                       },
  { "application/x-java-jnlp-file",                           { "jnlp" }                                               },
  { "application/x-javascript",                               { "js" }                                                 },
  { "application/x-java-serialized-object",                   { "ser" }                                                },
  { "application/x-java-vm",                                  { "class" }                                              },
  { "application/x-kchart",                                   { "chrt" }                                               },
  { "application/x-kdelnk",                                   {}                                                       },
  { "application/x-killustrator",                             { "kil" }                                                },
  { "application/x-koan",                                     { "skp", "skd", "skt", "skm" }                           },
  { "application/x-kpresenter",                               { "kpr", "kpt" }                                         },
  { "application/x-kspread",                                  { "ksp" }                                                },
  { "application/x-kword",                                    { "kwd", "kwt" }                                         },
  { "application/x-latex",                                    { "latex" }                                              },
  { "application/x-lha",                                      { "lha" }                                                },
  { "application/x-lzh",                                      { "lzh" }                                                },
  { "application/x-lzx",                                      { "lzx" }                                                },
  { "application/x-maker",                                    { "frm", "maker", "frame", "fm", "fb", "book", "fbdoc" } },
  { "application/x-mif",                                      { "mif" }                                                },
  { "application/xml",                                        {}                                                       },
  { "application/xml-dtd",                                    {}                                                       },
  { "application/xml-external-parsed-entity",                 {}                                                       },
  { "application/x-msdos-program",                            { "com", "exe", "bat", "dll" }                           },
  { "application/x-msi",                                      { "msi" }                                                },
  { "application/x-ms-wmd",                                   { "wmd" }                                                },
  { "application/x-ms-wmz",                                   { "wmz" }                                                },
  { "application/x-netcdf",                                   { "nc" }                                                 },
  { "application/x-ns-proxy-autoconfig",                      { "pac" }                                                },
  { "application/x-object",                                   { "o" }                                                  },
  { "application/x-ogg",                                      {}                                                       },
  { "application/x-oz-application",                           { "oza" }                                                },
  { "application/x-perl",                                     { "pl", "pm" }                                           },
  { "application/x-pkcs7-certreqresp",                        { "p7r" }                                                },
  { "application/x-pkcs7-crl",                                { "crl" }                                                },
  { "application/x-quicktimeplayer",                          { "qtl" }                                                },
  { "application/x-redhat-package-manager",                   { "rpm" }                                                },
  { "application/x-rx",                                       {}                                                       },
  { "application/x-sh",                                       { "sh" }                                                 },
  { "application/x-shar",                                     { "shar" }                                               },
  { "application/x-shellscript",                              {}                                                       },
  { "application/x-shockwave-flash",                          { "swf", "swfl" }                                        },
  { "application/x-stuffit",                                  { "sit" }                                                },
  { "application/x-sv4cpio",                                  { "sv4cpio" }                                            },
  { "application/x-sv4crc",                                   { "sv4crc" }                                             },
  { "application/x-tar",                                      { "tar" }                                                },
  { "application/x-tcl",                                      { "tcl" }                                                },
  { "application/x-tex",                                      { "tex" }                                                },
  { "application/x-tex-gf",                                   { "gf" }                                                 },
  { "application/x-texinfo",                                  { "texinfo", "texi" }                                    },
  { "application/x-tex-pk",                                   { "pk" }                                                 },
  { "application/x-trash",                                    { "~", "%", "bak", "old", "sik" }                        },
  { "application/x-troff",                                    { "t", "tr", "roff" }                                    },
  { "application/x-troff-man",                                { "man" }                                                },
  { "application/x-troff-me",                                 { "me" }                                                 },
  { "application/x-troff-ms",                                 { "ms" }                                                 },
  { "application/x-truetype-font",                            { "ttf", "otf", "ttc" }                                  },
  { "application/x-ustar",                                    { "ustar" }                                              },
  { "application/x-wais-source",                              { "src" }                                                },
  { "application/x-wingz",                                    { "wz" }                                                 },
  { "application/x-x509-ca-cert",                             { "crt" }                                                },
  { "application/x-xfig",                                     { "fig" }                                                },
  { "application/zip",                                        { "zip" }                                                },
  { "audio/32kadpcm",                                         {}                                                       },
  { "audio/basic",                                            { "au", "snd" }                                          },
  { "audio/DAT12",                                            {}                                                       },
  { "audio/g.722.1",                                          {}                                                       },
  { "audio/G.722.1",                                          {}                                                       },
  { "audio/l16",                                              {}                                                       },
  { "audio/L16",                                              {}                                                       },
  { "audio/L20",                                              {}                                                       },
  { "audio/L24",                                              {}                                                       },
  { "audio/midi",                                             { "mid", "midi", "kar" }                                 },
  { "audio/mp4a-latm",                                        {}                                                       },
  { "audio/MP4A-LATM",                                        {}                                                       },
  { "audio/mpa-robust",                                       {}                                                       },
  { "audio/mpeg",                                             { "mpga", "mpega", "mp2", "mp3" }                        },
  { "audio/mpegurl",                                          { "m3u" }                                                },
  { "audio/parityfec",                                        {}                                                       },
  { "audio/prs.sid",                                          { "sid" }                                                },
  { "audio/telephone-event",                                  {}                                                       },
  { "audio/tone",                                             {}                                                       },
  { "audio/vnd.cisco.nse",                                    {}                                                       },
  { "audio/vnd.cns.anp1",                                     {}                                                       },
  { "audio/vnd.cns.inf1",                                     {}                                                       },
  { "audio/vnd.digital-winds",                                {}                                                       },
  { "audio/vnd.everad.plj",                                   {}                                                       },
  { "audio/vnd.lucent.voice",                                 {}                                                       },
  { "audio/vnd.nortel.vbk",                                   {}                                                       },
  { "audio/vnd.nuera.ecelp4800",                              {}                                                       },
  { "audio/vnd.nuera.ecelp7470",                              {}                                                       },
  { "audio/vnd.nuera.ecelp9600",                              {}                                                       },
  { "audio/vnd.octel.sbc",                                    {}                                                       },
  { "audio/vnd.qcelp",                                        {}                                                       },
  { "audio/vnd.rhetorex.32kadpcm",                            {}                                                       },
  { "audio/vnd.vmx.cvsd",                                     {}                                                       },
  { "audio/x-aiff",                                           { "aif", "aiff", "aifc" }                                },
  { "audio/x-gsm",                                            { "gsm" }                                                },
  { "audio/x-mpegurl",                                        { "m3u" }                                                },
  { "audio/x-ms-wax",                                         { "wax" }                                                },
  { "audio/x-ms-wma",                                         { "wma" }                                                },
  { "audio/x-pn-realaudio",                                   { "rm", "ram" }                                          },
  { "audio/x-pn-realaudio-plugin",                            { "rpm" }                                                },
  { "audio/x-realaudio",                                      { "ra" }                                                 },
  { "audio/x-scpls",                                          { "pls" }                                                },
  { "audio/x-sd2",                                            { "sd2" }                                                },
  { "audio/x-wav",                                            { "wav" }                                                },
  { "chemical/x-pdb",                                         { "pdb" }                                                },
  { "chemical/x-xyz",                                         { "xyz" }                                                },
  { "font/sfnt",                                              {}                                                       },
  { "font/ttf",                                               {}                                                       },
  { "font/otf" ,                                              {}                                                       },
  { "font/collection",                                        {}                                                       },
  { "font/woff",                                              { "woff" }                                               },
  { "font/woff2",                                             { "woff2" }                                              },
  { "image/bmp",                                              { "bmp" }                                                },
  { "image/cgm",                                              {}                                                       },
  { "image/cgmComputerGraphicsMetafile",                      {}                                                       },
  { "image/g3fax",                                            {}                                                       },
  { "image/gif",                                              { "gif" }                                                },
  { "image/ief",                                              { "ief" }                                                },
  { "image/iefImageExchangeFormat",                           {}                                                       },
  { "image/jpeg",                                             { "jpg", "jpeg", "jpe" }                                 },
  { "image/naplps",                                           {}                                                       },
  { "image/pcx",                                              { "pcx" }                                                },
  { "image/png",                                              { "png" }                                                },
  { "image/prs.btif",                                         {}                                                       },
  { "image/prs.pti",                                          {}                                                       },
  { "image/svg+xml",                                          { "svg" }                                                },
  { "image/svg+xml-compressed",                               { "svgz" }                                               },
  { "image/tiff",                                             { "tiff", "tif" }                                        },
  { "image/tiffTagImageFileFormat",                           {}                                                       },
  { "image/vnd.cns.inf2",                                     {}                                                       },
  { "image/vnd.dwg",                                          {}                                                       },
  { "image/vnd.dxf",                                          {}                                                       },
  { "image/vnd.fastbidsheet",                                 {}                                                       },
  { "image/vnd.fpx",                                          {}                                                       },
  { "image/vnd.fst",                                          {}                                                       },
  { "image/vnd.fujixerox.edmics-mmr",                         {}                                                       },
  { "image/vnd.fujixerox.edmics-rlc",                         {}                                                       },
  { "image/vnd.mix",                                          {}                                                       },
  { "image/vnd.net-fpx",                                      {}                                                       },
  { "image/vnd.svf",                                          {}                                                       },
  { "image/vnd.wap.wbmp",                                     { "wbmp" }                                               },
  { "image/vnd.xiff",                                         {}                                                       },
  { "image/x-cmu-raster",                                     { "ras" }                                                },
  { "image/x-coreldraw",                                      { "cdr" }                                                },
  { "image/x-coreldrawpattern",                               { "pat" }                                                },
  { "image/x-coreldrawtemplate",                              { "cdt" }                                                },
  { "image/x-corelphotopaint",                                { "cpt" }                                                },
  { "image/x-djvu",                                           { "djvu", "djv" }                                        },
  { "image/x-jg",                                             { "art" }                                                },
  { "image/x-jng",                                            { "jng" }                                                },
  { "image/x-ms-bmp",                                         { "bmp" }                                                },
  { "image/x-photoshop",                                      { "psd" }                                                },
  { "image/x-portable-anymap",                                { "pnm" }                                                },
  { "image/x-portable-bitmap",                                { "pbm" }                                                },
  { "image/x-portable-graymap",                               { "pgm" }                                                },
  { "image/x-portable-pixmap",                                { "ppm" }                                                },
  { "image/x-rgb",                                            { "rgb" }                                                },
  { "image/x-xbitmap",                                        { "xbm" }                                                },
  { "image/x-xpixmap",                                        { "xpm" }                                                },
  { "image/x-xwindowdump",                                    { "xwd" }                                                },
  { "image/webp",                                             { "webp" }                                               },
  { "inode/blockdevice",                                      {}                                                       },
  { "inode/chardevice",                                       {}                                                       },
  { "inode/directory",                                        {}                                                       },
  { "inode/directory-locked",                                 {}                                                       },
  { "inode/fifo",                                             {}                                                       },
  { "inode/socket",                                           {}                                                       },
  { "message/delivery-status",                                {}                                                       },
  { "message/disposition-notification",                       {}                                                       },
  { "message/external-body",                                  {}                                                       },
  { "message/http",                                           {}                                                       },
  { "message/news",                                           {}                                                       },
  { "message/partial",                                        {}                                                       },
  { "message/rfc822",                                         {}                                                       },
  { "message/s-http",                                         {}                                                       },
  { "model/iges",                                             { "igs", "iges" }                                        },
  { "model/mesh",                                             { "msh", "mesh", "silo" }                                },
  { "model/vnd.dwf",                                          {}                                                       },
  { "model/vnd.flatland.3dml",                                {}                                                       },
  { "model/vnd.gdl",                                          {}                                                       },
  { "model/vnd.gs-gdl",                                       {}                                                       },
  { "model/vnd.gtw",                                          {}                                                       },
  { "model/vnd.mts",                                          {}                                                       },
  { "model/vnd.parasolid.transmit.binary",                    {}                                                       },
  { "model/vnd.parasolid.transmit.text",                      {}                                                       },
  { "model/vnd.vtu",                                          {}                                                       },
  { "model/vrml",                                             { "wrl", "vrml" }                                        },
  { "multipart/alternative",                                  {}                                                       },
  { "multipart/appledouble",                                  {}                                                       },
  { "multipart/byteranges",                                   {}                                                       },
  { "multipart/digest",                                       {}                                                       },
  { "multipart/encrypted",                                    {}                                                       },
  { "multipart/form-data",                                    {}                                                       },
  { "multipart/header-set",                                   {}                                                       },
  { "multipart/mixed",                                        {}                                                       },
  { "multipart/parallel",                                     {}                                                       },
  { "multipart/related",                                      {}                                                       },
  { "multipart/report",                                       {}                                                       },
  { "multipart/signed",                                       {}                                                       },
  { "multipart/voice-message",                                {}                                                       },
  { "text/calendar",                                          {}                                                       },
  { "text/comma-separated-values",                            { "csv" }                                                },
  { "text/css",                                               { "css" }                                                },
  { "text/directory",                                         {}                                                       },
  { "text/english",                                           {}                                                       },
  { "text/enriched",                                          {}                                                       },
  { "text/h323",                                              { "323" }                                                },
  { "text/html",                                              { "htm", "html", "mht" }                                 },
  { "text/iuls",                                              { "uls" }                                                },
  { "text/mathml",                                            { "mml" }                                                },
  { "text/parityfec",                                         {}                                                       },
  { "text/plain",                                             { "asc", "avs", "txt", "text", "diff", "cue" }           },
  { "text/prs.lines.tag",                                     {}                                                       },
  { "text/rfc822-headers",                                    {}                                                       },
  { "text/richtext",                                          { "rtx" }                                                },
  { "text/rtf",                                               { "rtf" }                                                },
  { "text/scriptlet",                                         { "sct", "wsc" }                                         },
  { "text/sgml",                                              {}                                                       },
  { "text/t140",                                              {}                                                       },
  { "text/tab-separated-values",                              { "tsv" }                                                },
  { "text/texmacs",                                           { "tm", "ts" }                                           },
  { "text/uri-list",                                          {}                                                       },
  { "text/vnd.abc",                                           {}                                                       },
  { "text/vnd.curl",                                          {}                                                       },
  { "text/vnd.DMClientScript",                                {}                                                       },
  { "text/vnd.flatland.3dml",                                 {}                                                       },
  { "text/vnd.fly",                                           {}                                                       },
  { "text/vnd.fmi.flexstor",                                  {}                                                       },
  { "text/vnd.in3d.3dml",                                     {}                                                       },
  { "text/vnd.in3d.spot",                                     {}                                                       },
  { "text/vnd.IPTC.NewsML",                                   {}                                                       },
  { "text/vnd.IPTC.NITF",                                     {}                                                       },
  { "text/vnd.latex-z",                                       {}                                                       },
  { "text/vnd.motorola.reflex",                               {}                                                       },
  { "text/vnd.ms-mediapackage",                               {}                                                       },
  { "text/vnd.wap.si",                                        {}                                                       },
  { "text/vnd.wap.sl",                                        {}                                                       },
  { "text/vnd.wap.wml",                                       { "wml" }                                                },
  { "text/vnd.wap.wmlscript",                                 { "wmls" }                                               },
  { "text/x-chdr",                                            { "h" }                                                  },
  { "text/x-c++hdr",                                          { "h++", "hpp", "hxx", "hh" }                            },
  { "text/x-crontab",                                         {}                                                       },
  { "text/x-csh",                                             { "csh" }                                                },
  { "text/x-csrc",                                            { "c" }                                                  },
  { "text/x-c++src",                                          { "c++", "cpp", "cxx", "cc" }                            },
  { "text/x-java",                                            { "java" }                                               },
  { "text/x-makefile",                                        {}                                                       },
  { "text/xml",                                               { "xml", "xsl" }                                         },
  { "text/xml-external-parsed-entity",                        {}                                                       },
  { "text/x-moc",                                             { "moc" }                                                },
  { "text/x-pascal",                                          { "p", "pas" }                                           },
  { "text/x-server-parsed-html",                              { "shtml" }                                              },
  { "text/x-setext",                                          { "etx" }                                                },
  { "text/x-sh",                                              { "sh" }                                                 },
  { "text/x-tcl",                                             { "tcl", "tk" }                                          },
  { "text/x-tex",                                             { "tex", "ltx", "sty", "cls" }                           },
  { "text/x-vcalendar",                                       { "vcs" }                                                },
  { "text/x-vcard",                                           { "vcf" }                                                },
  { "video/dl",                                               { "dl" }                                                 },
  { "video/fli",                                              { "fli" }                                                },
  { "video/gl",                                               { "gl" }                                                 },
  { "video/mp4v-es",                                          {}                                                       },
  { "video/MP4V-ES",                                          {}                                                       },
  { "video/mpeg",                                             { "mpeg", "mpg", "mpe" }                                 },
  { "video/parityfec",                                        {}                                                       },
  { "video/pointer",                                          {}                                                       },
  { "video/quicktime",                                        { "qt", "mov" }                                          },
  { "video/vnd.fvt",                                          {}                                                       },
  { "video/vnd.motorola.video",                               {}                                                       },
  { "video/vnd.motorola.videop",                              {}                                                       },
  { "video/vnd.mpegurl",                                      { "mxu" }                                                },
  { "video/vnd.mts",                                          {}                                                       },
  { "video/vnd.nokia.interleaved-multimedia",                 {}                                                       },
  { "video/vnd.vivo",                                         {}                                                       },
  { "video/x-dv",                                             { "dif", "dv" }                                          },
  { "video/x-la-asf",                                         { "lsf", "lsx" }                                         },
  { "video/x-mng",                                            { "mng" }                                                },
  { "video/x-ms-asf",                                         { "asf", "asx" }                                         },
  { "video/x-msvideo",                                        { "avi" }                                                },
  { "video/x-ms-wm",                                          { "wm" }                                                 },
  { "video/x-ms-wmv",                                         { "wmv" }                                                },
  { "video/x-ms-wmx",                                         { "wmx" }                                                },
  { "video/x-ms-wvx",                                         { "wvx" }                                                },
  { "video/x-sgi-movie",                                      { "movie" }                                              },
  { "x-conference/x-cooltalk",                                { "ice" }                                                },
  { "x-world/x-vrml",                                         { "vrm", "vrml", "wrl" }                                 },
};

}                              // namespace mtx::mime
