This is an attempt at implementing a mailing list manager with the same
functionality as the brilliant ezmlm, but with a decent license and mail server
independence.

The functionality:

 * Archive
 * Custom headers / footer
 * Fully automated bounce handling (similar to ezmlm)
 * Complete requeueing functionality
 * Moderation functionality
 * Subject prefix
 * Subscribers only posting
 * Regular expression access control
 * Functionality to retrieve old posts
 * Web interface
 * Digests
 * No-mail subscription
 * VERP support
 * Delivery Status Notification (RFC1891) support
 * Rich, customisable texts for automated operations

To use mlmmj, do the following:

 0) Compile it if you're not using a binary package such as dpkg, rpm or
    a ports collection from a BSD or Gentoo. To compile, untar the tar-ball
    and do:

        $ autoreconf -i && ./configure && make && make install

    If you want to filter multipart/mime messages, pass the option
    --enable-receive-strip to configure, and take a look at
    contrib/receivestrip/README.

 1) Configure a recipient delimiter. The default is to use '+', and in
    Postfix it's done by adding

        recipient_delimiter = +

    to /etc/postfix/main.cf. In Exim it can be done by adding

        local_part_suffix = +*
        local_part_suffix_optional

    to the "userforward:" and the "localuser:" router in /etc/exim/exim.conf,
    and also add "local_part_suffix = +*" to the system_aliases function. Also
    make sure that exim will add the envelope from in the Return-Path: header.

    There is a nice FAQ explaining recipient delimiter configuration here:

    http://faqs.org/faqs/mail/addressing/

    The mlmmj TUNABLE "delimiter" configures this on a per list basis

    NOTE: Using '-' as a delimiter is unlikely to work. Mlmmj uses '-' as its
    own kind of minor delimiter. Of course, you also cannot use the delimiter
    in your list names or you will encounter problems.

 2) Create the mailinglist.  There's a script, mlmmj-make-ml, that will make
    a mailinglist for mlmmj. It is highly recommended to use this script to make
    the lists! What is does is described here:

    In the case of a list called mlmmj-test below /var/spool/mlmmj it makes the
    following directories:

    ```
    /var/spool/mlmmj/mlmmj-test/incoming
    /var/spool/mlmmj/mlmmj-test/queue
    /var/spool/mlmmj/mlmmj-test/queue/discarded
    /var/spool/mlmmj/mlmmj-test/archive
    /var/spool/mlmmj/mlmmj-test/text
    /var/spool/mlmmj/mlmmj-test/subconf
    /var/spool/mlmmj/mlmmj-test/unsubconf
    /var/spool/mlmmj/mlmmj-test/bounce
    /var/spool/mlmmj/mlmmj-test/control
    /var/spool/mlmmj/mlmmj-test/moderation
    /var/spool/mlmmj/mlmmj-test/subscribers.d
    /var/spool/mlmmj/mlmmj-test/digesters.d
    /var/spool/mlmmj/mlmmj-test/nomailsubs.d
    /var/spool/mlmmj/mlmmj-test/requeue
    ```

    NOTE: The mailinglist directory (/var/spool/mlmmj/mlmmj-test in our
    example) have to be owned by the user the mailserver writes as. On some
    Postfix installations Postfix is run by the user postfix, but still writes
    files as nobody:nogroup or nobody:nobody

 3) Make the changes to your mailserver aliases that came as output from
    mlmmj-make-ml. Following the example above they will look like this:

        mlmmj-test:     "|/usr/bin/mlmmj-receive -L /var/spool/mlmmj/mlmmj-test"

    NOTE: Don't forget newaliases.

 4) Start mlmmj-maintd (remember full path when starting it!) or add it to
    crontab with -F switch. The recommended way for now is to run it via cron:

        "0 */2 * * *  /usr/bin/mlmmj-maintd -F -L /var/spool/mlmmj/mlmmj-test"

    It should be started as root, as mlmmj-maintd will become the user owning
    the listdir (/var/spool/mlmmj/mlmmj-test), and log it's last maintenance
    run to listdir/mlmmj-maintd.lastrun.log.

    If you have several lists below /var/spool/mlmmj you can use -d:
    /usr/bin/mlmmj-maintd -F -d /var/spool/mlmmj

    If you have lists more deeply nested below /var/spool/mlmmj, use
    something like:

```
    find /var/spool/mlmmj -mindepth 1 -maxdepth 1 -type d \
        -exec /usr/bin/mlmmj-maintd -F -d {} \;
```

That's it! You probably want to go through the next steps too.

 5) Subscribe some people

        /usr/bin/mlmmj-sub -L /var/spool/mlmmj/mlmmj-test/ -a joe@domain.tld

    etc.

 6) If you want custom headers like X-Mailinglist, Reply-To: etc. just add a
    file called 'customheaders' in the list control/ directory like this:
    $ cat /var/spool/mlmmj/mlmmj-test/control/customheaders
    X-Mailinglist: mlmmj-test
    Reply-To: mlmmj-test@domain.tld

 7) If you want every mail to have something like:

        To unsubscribe send a mail to coollist+unsubscribe@lists.domain.net

    Just add what you want to a file named "footer" in the same dir as
    "customheaders" (listdir/control/).

 8) If you want a prefix on the subject, to make it look like this:

        Subject: [mlmmj-test] how are we doing?
        Simply do 'echo "[mlmmj-test]" > control/prefix

 9) For having a moderated list, simply create a file called 'moderated' in the
    control/ directory. Moderators are added to a file called 'moderators' in
    the control/ dir as well.

10) Have a look at the file TUNABLES for runtime configurable things.

Tunables in include/mlmmj.h:
 · There's some time intervals for how mlmmj-maintd operates. I've chosen
   non-strict defaults, so depending on your BOFH rate you might want to tweak.
   The defaults should be good for most people though.

Have fun!
