// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Kawi`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x011F00, 0x011F10],
    [0x011F12, 0x011F3A],
    [0x011F3E, 0x011F5A]
  ]
});
testPropertyEscapes(
  /^\p{Script=Kawi}+$/u,
  matchSymbols,
  "\\p{Script=Kawi}"
);
testPropertyEscapes(
  /^\p{Script=Kawi}+$/u,
  matchSymbols,
  "\\p{Script=Kawi}"
);
testPropertyEscapes(
  /^\p{sc=Kawi}+$/u,
  matchSymbols,
  "\\p{sc=Kawi}"
);
testPropertyEscapes(
  /^\p{sc=Kawi}+$/u,
  matchSymbols,
  "\\p{sc=Kawi}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x011F11
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x011EFF],
    [0x011F3B, 0x011F3D],
    [0x011F5B, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Kawi}+$/u,
  nonMatchSymbols,
  "\\P{Script=Kawi}"
);
testPropertyEscapes(
  /^\P{Script=Kawi}+$/u,
  nonMatchSymbols,
  "\\P{Script=Kawi}"
);
testPropertyEscapes(
  /^\P{sc=Kawi}+$/u,
  nonMatchSymbols,
  "\\P{sc=Kawi}"
);
testPropertyEscapes(
  /^\P{sc=Kawi}+$/u,
  nonMatchSymbols,
  "\\P{sc=Kawi}"
);

reportCompare(0, 0);
