/** eslint-disable @typescript-eslint/no-unused-vars */

import babelPlugin, {
  babel,
  getBabelInputPlugin,
  getBabelOutputPlugin,
  createBabelInputPluginFactory,
  createBabelOutputPluginFactory
} from '../types';

const rollupConfig: import('rollup').RollupOptions = {
  input: 'main.js',
  output: {
    file: 'bundle.js',
    format: 'iife'
  },
  plugins: [
    babelPlugin({
      include: 'node_modules/**',
      exclude: ['node_modules/foo/**', 'node_modules/bar/**', /node_modules/],
      extensions: ['.js', '.coffee'],
      babelHelpers: 'runtime',
      skipPreflightCheck: true,
      babelrc: false,
      plugins: []
    }),
    babel({
      include: 'node_modules/**',
      exclude: ['node_modules/foo/**', 'node_modules/bar/**', /node_modules/],
      extensions: ['.js', '.coffee'],
      babelHelpers: 'runtime',
      skipPreflightCheck: true,
      babelrc: false,
      plugins: []
    }),
    getBabelInputPlugin({
      include: 'node_modules/**',
      exclude: ['node_modules/foo/**', 'node_modules/bar/**', /node_modules/],
      extensions: ['.js', '.coffee'],
      babelHelpers: 'runtime',
      skipPreflightCheck: true,
      babelrc: false,
      plugins: []
    }),
    getBabelOutputPlugin({
      allowAllFormats: true,
      babelrc: false,
      plugins: []
    })
  ]
};

export default rollupConfig;

createBabelInputPluginFactory((babelCore) => {
  function myPlugin() {
    return {
      name: `input-${babelCore.version}`,
      visitor: {}
    };
  }

  return {
    // Passed the plugin options.
    options({ opt1, opt2, ...pluginOptions }) {
      return {
        // Pull out any custom options that the plugin might have.
        customOptions: { opt1, opt2 },

        // Pass the options back with the two custom options removed.
        pluginOptions
      };
    },

    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    config(cfg, { code, customOptions }) {
      if (cfg.hasFilesystemConfig()) {
        // Use the normal config
        return cfg.options;
      }

      return {
        ...cfg.options,
        plugins: [
          ...(cfg.options.plugins || []),

          // Include a custom plugin in the options.
          myPlugin
        ]
      };
    },

    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    result(result, { code, customOptions, config, transformOptions }) {
      return {
        ...result,
        code: `${result.code}\n// Generated by some custom plugin`
      };
    }
  };
});

createBabelOutputPluginFactory((babelCore) => {
  function myPlugin() {
    return {
      name: `output-${babelCore.version}`,
      visitor: {}
    };
  }

  return {
    // Passed the plugin options.
    options({ opt1, opt2, ...pluginOptions }) {
      return {
        // Pull out any custom options that the plugin might have.
        customOptions: { opt1, opt2 },

        // Pass the options back with the two custom options removed.
        pluginOptions
      };
    },

    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    config(cfg, { code, customOptions }) {
      if (cfg.hasFilesystemConfig()) {
        // Use the normal config
        return cfg.options;
      }

      return {
        ...cfg.options,
        plugins: [
          ...(cfg.options.plugins || []),

          // Include a custom plugin in the options.
          myPlugin
        ]
      };
    },

    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    result(result, { code, customOptions, config, transformOptions }) {
      return {
        ...result,
        code: `${result.code}\n// Generated by some custom plugin`
      };
    }
  };
});
