/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/*
* When adding modules to the namespace, ensure that they are added in alphabetical order according to module name.
*/

// MODULES //

var setReadOnly = require( '@stdlib/utils/define-read-only-property' );


// MAIN //

/**
* Top-level namespace.
*
* @namespace special
*/
var special = {};

/**
* @name abs
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/abs}
*/
setReadOnly( special, 'abs', require( './../../../base/special/abs' ) );

/**
* @name abs2
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/abs2}
*/
setReadOnly( special, 'abs2', require( './../../../base/special/abs2' ) );

/**
* @name abs2f
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/abs2f}
*/
setReadOnly( special, 'abs2f', require( './../../../base/special/abs2f' ) );

/**
* @name absf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/absf}
*/
setReadOnly( special, 'absf', require( './../../../base/special/absf' ) );

/**
* @name acos
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/acos}
*/
setReadOnly( special, 'acos', require( './../../../base/special/acos' ) );

/**
* @name acosh
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/acosh}
*/
setReadOnly( special, 'acosh', require( './../../../base/special/acosh' ) );

/**
* @name acot
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/acot}
*/
setReadOnly( special, 'acot', require( './../../../base/special/acot' ) );

/**
* @name acoth
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/acoth}
*/
setReadOnly( special, 'acoth', require( './../../../base/special/acoth' ) );

/**
* @name acovercos
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/acovercos}
*/
setReadOnly( special, 'acovercos', require( './../../../base/special/acovercos' ) );

/**
* @name acoversin
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/acoversin}
*/
setReadOnly( special, 'acoversin', require( './../../../base/special/acoversin' ) );

/**
* @name ahavercos
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ahavercos}
*/
setReadOnly( special, 'ahavercos', require( './../../../base/special/ahavercos' ) );

/**
* @name ahaversin
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ahaversin}
*/
setReadOnly( special, 'ahaversin', require( './../../../base/special/ahaversin' ) );

/**
* @name asin
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/asin}
*/
setReadOnly( special, 'asin', require( './../../../base/special/asin' ) );

/**
* @name asinh
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/asinh}
*/
setReadOnly( special, 'asinh', require( './../../../base/special/asinh' ) );

/**
* @name atan
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/atan}
*/
setReadOnly( special, 'atan', require( './../../../base/special/atan' ) );

/**
* @name atan2
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/atan2}
*/
setReadOnly( special, 'atan2', require( './../../../base/special/atan2' ) );

/**
* @name atanh
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/atanh}
*/
setReadOnly( special, 'atanh', require( './../../../base/special/atanh' ) );

/**
* @name avercos
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/avercos}
*/
setReadOnly( special, 'avercos', require( './../../../base/special/avercos' ) );

/**
* @name aversin
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/aversin}
*/
setReadOnly( special, 'aversin', require( './../../../base/special/aversin' ) );

/**
* @name bernoulli
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/bernoulli}
*/
setReadOnly( special, 'bernoulli', require( './../../../base/special/bernoulli' ) );

/**
* @name besselj0
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/besselj0}
*/
setReadOnly( special, 'besselj0', require( './../../../base/special/besselj0' ) );

/**
* @name besselj1
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/besselj1}
*/
setReadOnly( special, 'besselj1', require( './../../../base/special/besselj1' ) );

/**
* @name bessely0
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/bessely0}
*/
setReadOnly( special, 'bessely0', require( './../../../base/special/bessely0' ) );

/**
* @name bessely1
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/bessely1}
*/
setReadOnly( special, 'bessely1', require( './../../../base/special/bessely1' ) );

/**
* @name beta
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/beta}
*/
setReadOnly( special, 'beta', require( './../../../base/special/beta' ) );

/**
* @name betainc
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/betainc}
*/
setReadOnly( special, 'betainc', require( './../../../base/special/betainc' ) );

/**
* @name betaincinv
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/betaincinv}
*/
setReadOnly( special, 'betaincinv', require( './../../../base/special/betaincinv' ) );

/**
* @name betaln
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/betaln}
*/
setReadOnly( special, 'betaln', require( './../../../base/special/betaln' ) );

/**
* @name binet
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/binet}
*/
setReadOnly( special, 'binet', require( './../../../base/special/binet' ) );

/**
* @name binomcoef
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/binomcoef}
*/
setReadOnly( special, 'binomcoef', require( './../../../base/special/binomcoef' ) );

/**
* @name binomcoefln
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/binomcoefln}
*/
setReadOnly( special, 'binomcoefln', require( './../../../base/special/binomcoefln' ) );

/**
* @name boxcox
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/boxcox}
*/
setReadOnly( special, 'boxcox', require( './../../../base/special/boxcox' ) );

/**
* @name boxcox1p
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/boxcox1p}
*/
setReadOnly( special, 'boxcox1p', require( './../../../base/special/boxcox1p' ) );

/**
* @name boxcox1pinv
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/boxcox1pinv}
*/
setReadOnly( special, 'boxcox1pinv', require( './../../../base/special/boxcox1pinv' ) );

/**
* @name boxcoxinv
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/boxcoxinv}
*/
setReadOnly( special, 'boxcoxinv', require( './../../../base/special/boxcoxinv' ) );

/**
* @name cabs
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cabs}
*/
setReadOnly( special, 'cabs', require( './../../../base/special/cabs' ) );

/**
* @name cabs2
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cabs2}
*/
setReadOnly( special, 'cabs2', require( './../../../base/special/cabs2' ) );

/**
* @name cbrt
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cbrt}
*/
setReadOnly( special, 'cbrt', require( './../../../base/special/cbrt' ) );

/**
* @name cbrtf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cbrtf}
*/
setReadOnly( special, 'cbrtf', require( './../../../base/special/cbrtf' ) );

/**
* @name cceil
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cceil}
*/
setReadOnly( special, 'cceil', require( './../../../base/special/cceil' ) );

/**
* @name cceiln
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cceiln}
*/
setReadOnly( special, 'cceiln', require( './../../../base/special/cceiln' ) );

/**
* @name ccis
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ccis}
*/
setReadOnly( special, 'ccis', require( './../../../base/special/ccis' ) );

/**
* @name ceil
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ceil}
*/
setReadOnly( special, 'ceil', require( './../../../base/special/ceil' ) );

/**
* @name ceil2
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ceil2}
*/
setReadOnly( special, 'ceil2', require( './../../../base/special/ceil2' ) );

/**
* @name ceil10
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ceil10}
*/
setReadOnly( special, 'ceil10', require( './../../../base/special/ceil10' ) );

/**
* @name ceilb
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ceilb}
*/
setReadOnly( special, 'ceilb', require( './../../../base/special/ceilb' ) );

/**
* @name ceilf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ceilf}
*/
setReadOnly( special, 'ceilf', require( './../../../base/special/ceilf' ) );

/**
* @name ceiln
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ceiln}
*/
setReadOnly( special, 'ceiln', require( './../../../base/special/ceiln' ) );

/**
* @name ceilsd
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ceilsd}
*/
setReadOnly( special, 'ceilsd', require( './../../../base/special/ceilsd' ) );

/**
* @name cexp
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cexp}
*/
setReadOnly( special, 'cexp', require( './../../../base/special/cexp' ) );

/**
* @name cflipsign
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cflipsign}
*/
setReadOnly( special, 'cflipsign', require( './../../../base/special/cflipsign' ) );

/**
* @name cfloor
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cfloor}
*/
setReadOnly( special, 'cfloor', require( './../../../base/special/cfloor' ) );

/**
* @name cfloorn
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cfloorn}
*/
setReadOnly( special, 'cfloorn', require( './../../../base/special/cfloorn' ) );

/**
* @name cinv
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cinv}
*/
setReadOnly( special, 'cinv', require( './../../../base/special/cinv' ) );

/**
* @name clamp
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/clamp}
*/
setReadOnly( special, 'clamp', require( './../../../base/special/clamp' ) );

/**
* @name clampf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/clampf}
*/
setReadOnly( special, 'clampf', require( './../../../base/special/clampf' ) );

/**
* @name copysign
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/copysign}
*/
setReadOnly( special, 'copysign', require( './../../../base/special/copysign' ) );

/**
* @name cos
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cos}
*/
setReadOnly( special, 'cos', require( './../../../base/special/cos' ) );

/**
* @name cosh
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cosh}
*/
setReadOnly( special, 'cosh', require( './../../../base/special/cosh' ) );

/**
* @name cosm1
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cosm1}
*/
setReadOnly( special, 'cosm1', require( './../../../base/special/cosm1' ) );

/**
* @name cospi
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cospi}
*/
setReadOnly( special, 'cospi', require( './../../../base/special/cospi' ) );

/**
* @name covercos
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/covercos}
*/
setReadOnly( special, 'covercos', require( './../../../base/special/covercos' ) );

/**
* @name coversin
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/coversin}
*/
setReadOnly( special, 'coversin', require( './../../../base/special/coversin' ) );

/**
* @name cphase
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cphase}
*/
setReadOnly( special, 'cphase', require( './../../../base/special/cphase' ) );

/**
* @name cpolar
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cpolar}
*/
setReadOnly( special, 'cpolar', require( './../../../base/special/cpolar' ) );

/**
* @name cround
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/cround}
*/
setReadOnly( special, 'cround', require( './../../../base/special/cround' ) );

/**
* @name croundn
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/croundn}
*/
setReadOnly( special, 'croundn', require( './../../../base/special/croundn' ) );

/**
* @name csignum
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/csignum}
*/
setReadOnly( special, 'csignum', require( './../../../base/special/csignum' ) );

/**
* @name deg2rad
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/deg2rad}
*/
setReadOnly( special, 'deg2rad', require( './../../../base/special/deg2rad' ) );

/**
* @name deg2radf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/deg2radf}
*/
setReadOnly( special, 'deg2radf', require( './../../../base/special/deg2radf' ) );

/**
* @name digamma
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/digamma}
*/
setReadOnly( special, 'digamma', require( './../../../base/special/digamma' ) );

/**
* @name diracDelta
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/dirac-delta}
*/
setReadOnly( special, 'diracDelta', require( './../../../base/special/dirac-delta' ) );

/**
* @name eta
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/dirichlet-eta}
*/
setReadOnly( special, 'eta', require( './../../../base/special/dirichlet-eta' ) );

/**
* @name ellipe
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ellipe}
*/
setReadOnly( special, 'ellipe', require( './../../../base/special/ellipe' ) );

/**
* @name ellipk
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ellipk}
*/
setReadOnly( special, 'ellipk', require( './../../../base/special/ellipk' ) );

/**
* @name erf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/erf}
*/
setReadOnly( special, 'erf', require( './../../../base/special/erf' ) );

/**
* @name erfc
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/erfc}
*/
setReadOnly( special, 'erfc', require( './../../../base/special/erfc' ) );

/**
* @name erfcinv
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/erfcinv}
*/
setReadOnly( special, 'erfcinv', require( './../../../base/special/erfcinv' ) );

/**
* @name erfinv
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/erfinv}
*/
setReadOnly( special, 'erfinv', require( './../../../base/special/erfinv' ) );

/**
* @name exp
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/exp}
*/
setReadOnly( special, 'exp', require( './../../../base/special/exp' ) );

/**
* @name exp2
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/exp2}
*/
setReadOnly( special, 'exp2', require( './../../../base/special/exp2' ) );

/**
* @name exp10
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/exp10}
*/
setReadOnly( special, 'exp10', require( './../../../base/special/exp10' ) );

/**
* @name expit
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/expit}
*/
setReadOnly( special, 'expit', require( './../../../base/special/expit' ) );

/**
* @name expm1
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/expm1}
*/
setReadOnly( special, 'expm1', require( './../../../base/special/expm1' ) );

/**
* @name expm1rel
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/expm1rel}
*/
setReadOnly( special, 'expm1rel', require( './../../../base/special/expm1rel' ) );

/**
* @name factorial
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/factorial}
*/
setReadOnly( special, 'factorial', require( './../../../base/special/factorial' ) );

/**
* @name factorialln
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/factorialln}
*/
setReadOnly( special, 'factorialln', require( './../../../base/special/factorialln' ) );

/**
* @name fallingFactorial
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/falling-factorial}
*/
setReadOnly( special, 'fallingFactorial', require( './../../../base/special/falling-factorial' ) );

/**
* @name fast
* @memberof special
* @readonly
* @type {Namespace}
* @see {@link module:@stdlib/math/base/special/fast}
*/
setReadOnly( special, 'fast', require( './../../../base/special/fast' ) );

/**
* @name fibonacci
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/fibonacci}
*/
setReadOnly( special, 'fibonacci', require( './../../../base/special/fibonacci' ) );

/**
* @name fibonacciIndex
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/fibonacci-index}
*/
setReadOnly( special, 'fibonacciIndex', require( './../../../base/special/fibonacci-index' ) );

/**
* @name flipsign
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/flipsign}
*/
setReadOnly( special, 'flipsign', require( './../../../base/special/flipsign' ) );

/**
* @name floor
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/floor}
*/
setReadOnly( special, 'floor', require( './../../../base/special/floor' ) );

/**
* @name floor2
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/floor2}
*/
setReadOnly( special, 'floor2', require( './../../../base/special/floor2' ) );

/**
* @name floor10
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/floor10}
*/
setReadOnly( special, 'floor10', require( './../../../base/special/floor10' ) );

/**
* @name floorb
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/floorb}
*/
setReadOnly( special, 'floorb', require( './../../../base/special/floorb' ) );

/**
* @name floorf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/floorf}
*/
setReadOnly( special, 'floorf', require( './../../../base/special/floorf' ) );

/**
* @name floorn
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/floorn}
*/
setReadOnly( special, 'floorn', require( './../../../base/special/floorn' ) );

/**
* @name floorsd
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/floorsd}
*/
setReadOnly( special, 'floorsd', require( './../../../base/special/floorsd' ) );

/**
* @name fresnel
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/fresnel}
*/
setReadOnly( special, 'fresnel', require( './../../../base/special/fresnel' ) );

/**
* @name fresnelc
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/fresnelc}
*/
setReadOnly( special, 'fresnelc', require( './../../../base/special/fresnelc' ) );

/**
* @name fresnels
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/fresnels}
*/
setReadOnly( special, 'fresnels', require( './../../../base/special/fresnels' ) );

/**
* @name frexp
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/frexp}
*/
setReadOnly( special, 'frexp', require( './../../../base/special/frexp' ) );

/**
* @name gamma
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/gamma}
*/
setReadOnly( special, 'gamma', require( './../../../base/special/gamma' ) );

/**
* @name gammaDeltaRatio
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/gamma-delta-ratio}
*/
setReadOnly( special, 'gammaDeltaRatio', require( './../../../base/special/gamma-delta-ratio' ) );

/**
* @name gammaLanczosSum
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/gamma-lanczos-sum}
*/
setReadOnly( special, 'gammaLanczosSum', require( './../../../base/special/gamma-lanczos-sum' ) );

/**
* @name gammaLanczosSumExpGScaled
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/gamma-lanczos-sum-expg-scaled}
*/
setReadOnly( special, 'gammaLanczosSumExpGScaled', require( './../../../base/special/gamma-lanczos-sum-expg-scaled' ) );

/**
* @name gamma1pm1
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/gamma1pm1}
*/
setReadOnly( special, 'gamma1pm1', require( './../../../base/special/gamma1pm1' ) );

/**
* @name gammainc
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/gammainc}
*/
setReadOnly( special, 'gammainc', require( './../../../base/special/gammainc' ) );

/**
* @name gammaincinv
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/gammaincinv}
*/
setReadOnly( special, 'gammaincinv', require( './../../../base/special/gammaincinv' ) );

/**
* @name gammaln
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/gammaln}
*/
setReadOnly( special, 'gammaln', require( './../../../base/special/gammaln' ) );

/**
* @name gcd
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/gcd}
*/
setReadOnly( special, 'gcd', require( './../../../base/special/gcd' ) );

/**
* @name hacovercos
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/hacovercos}
*/
setReadOnly( special, 'hacovercos', require( './../../../base/special/hacovercos' ) );

/**
* @name hacoversin
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/hacoversin}
*/
setReadOnly( special, 'hacoversin', require( './../../../base/special/hacoversin' ) );

/**
* @name havercos
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/havercos}
*/
setReadOnly( special, 'havercos', require( './../../../base/special/havercos' ) );

/**
* @name haversin
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/haversin}
*/
setReadOnly( special, 'haversin', require( './../../../base/special/haversin' ) );

/**
* @name heaviside
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/heaviside}
*/
setReadOnly( special, 'heaviside', require( './../../../base/special/heaviside' ) );

/**
* @name hypot
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/hypot}
*/
setReadOnly( special, 'hypot', require( './../../../base/special/hypot' ) );

/**
* @name hypotf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/hypotf}
*/
setReadOnly( special, 'hypotf', require( './../../../base/special/hypotf' ) );

/**
* @name identity
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/identity}
*/
setReadOnly( special, 'identity', require( './../../../base/special/identity' ) );

/**
* @name identityf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/identityf}
*/
setReadOnly( special, 'identityf', require( './../../../base/special/identityf' ) );

/**
* @name imul
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/imul}
*/
setReadOnly( special, 'imul', require( './../../../base/special/imul' ) );

/**
* @name imuldw
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/imuldw}
*/
setReadOnly( special, 'imuldw', require( './../../../base/special/imuldw' ) );

/**
* @name inv
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/inv}
*/
setReadOnly( special, 'inv', require( './../../../base/special/inv' ) );

/**
* @name invf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/invf}
*/
setReadOnly( special, 'invf', require( './../../../base/special/invf' ) );

/**
* @name kernelBetainc
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/kernel-betainc}
*/
setReadOnly( special, 'kernelBetainc', require( './../../../base/special/kernel-betainc' ) );

/**
* @name kernelBetaincinv
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/kernel-betaincinv}
*/
setReadOnly( special, 'kernelBetaincinv', require( './../../../base/special/kernel-betaincinv' ) );

/**
* @name kernelCos
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/kernel-cos}
*/
setReadOnly( special, 'kernelCos', require( './../../../base/special/kernel-cos' ) );

/**
* @name kernelSin
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/kernel-sin}
*/
setReadOnly( special, 'kernelSin', require( './../../../base/special/kernel-sin' ) );

/**
* @name kernelTan
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/kernel-tan}
*/
setReadOnly( special, 'kernelTan', require( './../../../base/special/kernel-tan' ) );

/**
* @name kroneckerDelta
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/kronecker-delta}
*/
setReadOnly( special, 'kroneckerDelta', require( './../../../base/special/kronecker-delta' ) );

/**
* @name kroneckerDeltaf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/kronecker-deltaf}
*/
setReadOnly( special, 'kroneckerDeltaf', require( './../../../base/special/kronecker-deltaf' ) );

/**
* @name labs
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/labs}
*/
setReadOnly( special, 'labs', require( './../../../base/special/labs' ) );

/**
* @name lcm
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/lcm}
*/
setReadOnly( special, 'lcm', require( './../../../base/special/lcm' ) );

/**
* @name ldexp
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ldexp}
*/
setReadOnly( special, 'ldexp', require( './../../../base/special/ldexp' ) );

/**
* @name ln
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ln}
*/
setReadOnly( special, 'ln', require( './../../../base/special/ln' ) );

/**
* @name log
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/log}
*/
setReadOnly( special, 'log', require( './../../../base/special/log' ) );

/**
* @name log1mexp
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/log1mexp}
*/
setReadOnly( special, 'log1mexp', require( './../../../base/special/log1mexp' ) );

/**
* @name log1p
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/log1p}
*/
setReadOnly( special, 'log1p', require( './../../../base/special/log1p' ) );

/**
* @name log1pexp
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/log1pexp}
*/
setReadOnly( special, 'log1pexp', require( './../../../base/special/log1pexp' ) );

/**
* @name log2
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/log2}
*/
setReadOnly( special, 'log2', require( './../../../base/special/log2' ) );

/**
* @name log10
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/log10}
*/
setReadOnly( special, 'log10', require( './../../../base/special/log10' ) );

/**
* @name logaddexp
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/logaddexp}
*/
setReadOnly( special, 'logaddexp', require( './../../../base/special/logaddexp' ) );

/**
* @name logit
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/logit}
*/
setReadOnly( special, 'logit', require( './../../../base/special/logit' ) );

/**
* @name lucas
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/lucas}
*/
setReadOnly( special, 'lucas', require( './../../../base/special/lucas' ) );

/**
* @name max
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/max}
*/
setReadOnly( special, 'max', require( './../../../base/special/max' ) );

/**
* @name maxabs
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/maxabs}
*/
setReadOnly( special, 'maxabs', require( './../../../base/special/maxabs' ) );

/**
* @name min
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/min}
*/
setReadOnly( special, 'min', require( './../../../base/special/min' ) );

/**
* @name minabs
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/minabs}
*/
setReadOnly( special, 'minabs', require( './../../../base/special/minabs' ) );

/**
* @name minmax
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/minmax}
*/
setReadOnly( special, 'minmax', require( './../../../base/special/minmax' ) );

/**
* @name minmaxabs
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/minmaxabs}
*/
setReadOnly( special, 'minmaxabs', require( './../../../base/special/minmaxabs' ) );

/**
* @name modf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/modf}
*/
setReadOnly( special, 'modf', require( './../../../base/special/modf' ) );

/**
* @name negafibonacci
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/negafibonacci}
*/
setReadOnly( special, 'negafibonacci', require( './../../../base/special/negafibonacci' ) );

/**
* @name negalucas
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/negalucas}
*/
setReadOnly( special, 'negalucas', require( './../../../base/special/negalucas' ) );

/**
* @name nonfibonacci
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/nonfibonacci}
*/
setReadOnly( special, 'nonfibonacci', require( './../../../base/special/nonfibonacci' ) );

/**
* @name pdiff
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/pdiff}
*/
setReadOnly( special, 'pdiff', require( './../../../base/special/pdiff' ) );

/**
* @name pdifff
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/pdifff}
*/
setReadOnly( special, 'pdifff', require( './../../../base/special/pdifff' ) );

/**
* @name polygamma
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/polygamma}
*/
setReadOnly( special, 'polygamma', require( './../../../base/special/polygamma' ) );

/**
* @name pow
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/pow}
*/
setReadOnly( special, 'pow', require( './../../../base/special/pow' ) );

/**
* @name powm1
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/powm1}
*/
setReadOnly( special, 'powm1', require( './../../../base/special/powm1' ) );

/**
* @name rad2deg
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/rad2deg}
*/
setReadOnly( special, 'rad2deg', require( './../../../base/special/rad2deg' ) );

/**
* @name ramp
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/ramp}
*/
setReadOnly( special, 'ramp', require( './../../../base/special/ramp' ) );

/**
* @name rampf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/rampf}
*/
setReadOnly( special, 'rampf', require( './../../../base/special/rampf' ) );

/**
* @name rempio2
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/rempio2}
*/
setReadOnly( special, 'rempio2', require( './../../../base/special/rempio2' ) );

/**
* @name zeta
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/riemann-zeta}
*/
setReadOnly( special, 'zeta', require( './../../../base/special/riemann-zeta' ) );

/**
* @name risingFactorial
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/rising-factorial}
*/
setReadOnly( special, 'risingFactorial', require( './../../../base/special/rising-factorial' ) );

/**
* @name round
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/round}
*/
setReadOnly( special, 'round', require( './../../../base/special/round' ) );

/**
* @name round2
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/round2}
*/
setReadOnly( special, 'round2', require( './../../../base/special/round2' ) );

/**
* @name round10
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/round10}
*/
setReadOnly( special, 'round10', require( './../../../base/special/round10' ) );

/**
* @name roundb
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/roundb}
*/
setReadOnly( special, 'roundb', require( './../../../base/special/roundb' ) );

/**
* @name roundn
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/roundn}
*/
setReadOnly( special, 'roundn', require( './../../../base/special/roundn' ) );

/**
* @name roundsd
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/roundsd}
*/
setReadOnly( special, 'roundsd', require( './../../../base/special/roundsd' ) );

/**
* @name rsqrt
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/rsqrt}
*/
setReadOnly( special, 'rsqrt', require( './../../../base/special/rsqrt' ) );

/**
* @name rsqrtf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/rsqrtf}
*/
setReadOnly( special, 'rsqrtf', require( './../../../base/special/rsqrtf' ) );

/**
* @name sici
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/sici}
*/
setReadOnly( special, 'sici', require( './../../../base/special/sici' ) );

/**
* @name signum
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/signum}
*/
setReadOnly( special, 'signum', require( './../../../base/special/signum' ) );

/**
* @name signumf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/signumf}
*/
setReadOnly( special, 'signumf', require( './../../../base/special/signumf' ) );

/**
* @name sin
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/sin}
*/
setReadOnly( special, 'sin', require( './../../../base/special/sin' ) );

/**
* @name sinc
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/sinc}
*/
setReadOnly( special, 'sinc', require( './../../../base/special/sinc' ) );

/**
* @name sincos
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/sincos}
*/
setReadOnly( special, 'sincos', require( './../../../base/special/sincos' ) );

/**
* @name sincospi
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/sincospi}
*/
setReadOnly( special, 'sincospi', require( './../../../base/special/sincospi' ) );

/**
* @name sinh
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/sinh}
*/
setReadOnly( special, 'sinh', require( './../../../base/special/sinh' ) );

/**
* @name sinpi
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/sinpi}
*/
setReadOnly( special, 'sinpi', require( './../../../base/special/sinpi' ) );

/**
* @name spence
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/spence}
*/
setReadOnly( special, 'spence', require( './../../../base/special/spence' ) );

/**
* @name sqrt
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/sqrt}
*/
setReadOnly( special, 'sqrt', require( './../../../base/special/sqrt' ) );

/**
* @name sqrt1pm1
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/sqrt1pm1}
*/
setReadOnly( special, 'sqrt1pm1', require( './../../../base/special/sqrt1pm1' ) );

/**
* @name sqrtf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/sqrtf}
*/
setReadOnly( special, 'sqrtf', require( './../../../base/special/sqrtf' ) );

/**
* @name tan
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/tan}
*/
setReadOnly( special, 'tan', require( './../../../base/special/tan' ) );

/**
* @name tanh
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/tanh}
*/
setReadOnly( special, 'tanh', require( './../../../base/special/tanh' ) );

/**
* @name tribonacci
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/tribonacci}
*/
setReadOnly( special, 'tribonacci', require( './../../../base/special/tribonacci' ) );

/**
* @name trigamma
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/trigamma}
*/
setReadOnly( special, 'trigamma', require( './../../../base/special/trigamma' ) );

/**
* @name trunc
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/trunc}
*/
setReadOnly( special, 'trunc', require( './../../../base/special/trunc' ) );

/**
* @name trunc2
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/trunc2}
*/
setReadOnly( special, 'trunc2', require( './../../../base/special/trunc2' ) );

/**
* @name trunc10
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/trunc10}
*/
setReadOnly( special, 'trunc10', require( './../../../base/special/trunc10' ) );

/**
* @name truncb
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/truncb}
*/
setReadOnly( special, 'truncb', require( './../../../base/special/truncb' ) );

/**
* @name truncf
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/truncf}
*/
setReadOnly( special, 'truncf', require( './../../../base/special/truncf' ) );

/**
* @name truncn
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/truncn}
*/
setReadOnly( special, 'truncn', require( './../../../base/special/truncn' ) );

/**
* @name truncsd
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/truncsd}
*/
setReadOnly( special, 'truncsd', require( './../../../base/special/truncsd' ) );

/**
* @name uimul
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/uimul}
*/
setReadOnly( special, 'uimul', require( './../../../base/special/uimul' ) );

/**
* @name uimuldw
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/uimuldw}
*/
setReadOnly( special, 'uimuldw', require( './../../../base/special/uimuldw' ) );

/**
* @name vercos
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/vercos}
*/
setReadOnly( special, 'vercos', require( './../../../base/special/vercos' ) );

/**
* @name versin
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/versin}
*/
setReadOnly( special, 'versin', require( './../../../base/special/versin' ) );

/**
* @name wrap
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/wrap}
*/
setReadOnly( special, 'wrap', require( './../../../base/special/wrap' ) );

/**
* @name xlog1py
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/xlog1py}
*/
setReadOnly( special, 'xlog1py', require( './../../../base/special/xlog1py' ) );

/**
* @name xlogy
* @memberof special
* @readonly
* @type {Function}
* @see {@link module:@stdlib/math/base/special/xlogy}
*/
setReadOnly( special, 'xlogy', require( './../../../base/special/xlogy' ) );


// EXPORTS //

module.exports = special;
