/*
 * Copyright 2015 Higher Frequency Trading
 *
 * http://www.higherfrequencytrading.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package vanilla.java.proxy;

import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ExcerptAppender;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ToChronicle implements InvocationHandler {
    final ExcerptAppender appender;

    public ToChronicle(ExcerptAppender appender) {
        this.appender = appender;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke(this, args);
        }
        appender.startExcerpt();
        MetaData.get().writeMarshallable(appender);
        appender.writeUTFΔ(method.getName());
        if (args == null) {
            appender.writeStopBit(0);

        } else {
            appender.writeStopBit(args.length);
            for (Object arg : args) {
                appender.writeObject(arg);
            }
        }
        appender.finish();
        return null;
    }

    public static <T> T of(Class<T> interfaceType, Chronicle chroncile) throws IOException {
        return (T) Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, new ToChronicle(chroncile.createAppender()));
    }
}

