# OpenRefine

[![DOI](https://zenodo.org/badge/6220644.svg)](https://zenodo.org/badge/latestdoi/6220644)
[![Join the chat at https://gitter.im/OpenRefine/OpenRefine](https://badges.gitter.im/OpenRefine/OpenRefine.svg)](https://gitter.im/OpenRefine/OpenRefine) 
[![Snapshot release](https://github.com/OpenRefine/OpenRefine/actions/workflows/snapshot_release.yml/badge.svg)](https://github.com/OpenRefine/OpenRefine/actions/workflows/snapshot_release.yml) [![Coverage Status](https://coveralls.io/repos/github/OpenRefine/OpenRefine/badge.svg?branch=master)](https://coveralls.io/github/OpenRefine/OpenRefine?branch=master) [![Translation progress](https://hosted.weblate.org/widgets/openrefine/-/svg-badge.svg)](https://hosted.weblate.org/engage/openrefine/?utm_source=widget)

OpenRefine is a Java-based power tool that allows you to load data, understand it,
clean it up, reconcile it, and augment it with data coming from
the web. All from a web browser and the comfort and privacy of your own computer.

Official website: **https://openrefine.org**

Community forum: **https://forum.openrefine.org**

[<img src="https://github.com/OpenRefine/OpenRefine/blob/master/graphics/icon/open-refine-320px.png" align="right">](https://openrefine.org)

## Download

* [OpenRefine Releases](https://github.com/OpenRefine/OpenRefine/releases)

## Snapshot releases

You can download snapshots of the development version of OpenRefine.
To do so, you need to be logged in to GitHub. Then, click on the first item with a green tick / check mark on [this page](https://github.com/OpenRefine/OpenRefine/actions/workflows/snapshot_release.yml) and scroll down to the Artifacts section to find the version that matches your operating system.

## Run from source

If you have cloned this repository to your computer, you can run OpenRefine with:

* `./refine` on Mac OS and Linux
* `refine.bat` on Windows

This requires [JDK 11](https://adoptium.net/) or newer, [Apache Maven](https://maven.apache.org/) and [NPM](https://www.npmjs.com/) 16 or newer.

## Documentation

* [User Manual](https://openrefine.org/docs)
* [FAQ](https://github.com/OpenRefine/OpenRefine/wiki/FAQ)

## Contributing to the project

* [Developers Guide & Architecture](https://github.com/OpenRefine/OpenRefine/wiki/Documentation-For-Developers)
* [Contributing Guide](https://github.com/OpenRefine/OpenRefine/blob/master/CONTRIBUTING.md)
* [Project Governance](https://github.com/OpenRefine/OpenRefine/blob/master/GOVERNANCE.md)

## Contact us

* [Community forum](https://forum.openrefine.org)
* [Twitter](https://www.twitter.com/openrefine)
* [Gitter](https://gitter.im/OpenRefine/OpenRefine)
* [Matrix (bridged from Gitter)](https://matrix.to/#/#OpenRefine_OpenRefine:gitter.im)

## Licensing and legal issues

OpenRefine is open source software and is licensed under the BSD license located in the [LICENSE.txt](LICENSE.txt). See the folder `licenses` for information on open source libraries that OpenRefine depends on.

## Credits

This software was created by Metaweb Technologies, Inc. and originally written and conceived by [David Huynh](https://github.com/dfhuynh). Metaweb Technologies, Inc. was acquired by Google, Inc. in July 2010 and the product was renamed Google Refine. In October 2012, it was renamed OpenRefine as it transitioned to a community-driven project.

Since 2020, OpenRefine is fiscally sponsored by [Code for Science and Society](https://www.codeforsociety.org/) (CS&S).

See [CONTRIBUTING.md](./CONTRIBUTING.md) for instructions on how to contribute yourself.
